/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import aQute.lib.qtokens.QuotedTokenizer;
import aQute.lib.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.types.Path;

public class BndTask
extends BaseTask
implements Reporter {
    List files = new ArrayList();
    List classpath = new ArrayList();
    List sourcepath = new ArrayList();
    File output = null;
    File testDir = null;
    boolean failok;
    boolean exceptions;
    boolean print;
    boolean eclipse;
    static File[] EMPTY_FILES = new File[0];

    public void execute() throws BuildException {
        block16: {
            try {
                if (this.files == null) {
                    throw new BuildException("No files set");
                }
                if (this.eclipse) {
                    File project = this.getProject().getBaseDir();
                    EclipseClasspath cp = new EclipseClasspath(this, project.getParentFile(), project);
                    this.classpath.addAll(cp.getClasspath());
                    this.classpath.addAll(cp.getBootclasspath());
                    this.sourcepath.addAll(cp.getSourcepath());
                    this.classpath.add(cp.getOutput());
                    if (this.report()) {
                        throw new BuildException("Errors during Eclipse Path inspection");
                    }
                }
                if (this.output == null) {
                    this.output = this.getProject().getBaseDir();
                }
                Iterator f = this.files.iterator();
                while (f.hasNext()) {
                    File file = (File)f.next();
                    String bsn = file.getName().replaceAll("\\.bnd$", "");
                    Builder builder = new Builder();
                    builder.setPedantic(this.isPedantic());
                    if (file.exists()) {
                        builder.setProperties(file);
                    }
                    Properties projectProperties = new Properties();
                    projectProperties.putAll((Map<?, ?>)this.getProject().getProperties());
                    projectProperties.putAll((Map<?, ?>)builder.getProperties());
                    builder.setProperties(projectProperties);
                    builder.setClasspath(this.toFiles(this.classpath, "classpath"));
                    builder.setSourcepath(this.toFiles(this.sourcepath, "sourcepath"));
                    builder.build();
                    Jar jar = builder.getJar();
                    jar.setName(bsn);
                    if (!this.failok && this.report()) {
                        throw new BuildException("Errors during build: " + builder.getErrors(), new Location(file.getName()));
                    }
                    File base = file.getParentFile();
                    File output = this.output;
                    String path = builder.getProperty("-output");
                    if (output == null) {
                        output = path == null ? BndTask.getFile(base, String.valueOf(bsn) + ".jar") : BndTask.getFile(base, path);
                    } else if (output.isDirectory()) {
                        output = path == null ? BndTask.getFile(this.output, String.valueOf(bsn) + ".jar") : BndTask.getFile(this.output, path);
                    } else if (output.isFile() && this.files.size() > 1) {
                        this.error("Output is a file but there are multiple input files, these files will overwrite the output file: " + output.getAbsolutePath());
                    }
                    String msg = "";
                    if (!output.exists() || output.lastModified() <= jar.lastModified()) {
                        jar.write(output);
                    } else {
                        msg = "(not modified)";
                    }
                    System.out.println(String.valueOf(jar.getName()) + " (" + output.getName() + ") " + jar.getResources().size() + " " + msg);
                    this.report();
                    jar.close();
                    builder.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.failok) break block16;
                throw new BuildException("Failed to build jar file: ", (Throwable)e);
            }
        }
    }

    public void setFiles(String files) {
        files = files.replaceAll("\\.jar(,|$)", ".bnd");
        this.addAll(this.files, files, ",");
    }

    void addAll(List list, String files, String separator) {
        QuotedTokenizer qt = new QuotedTokenizer(files, separator);
        String[] entries = qt.getTokens();
        File project = this.getProject().getBaseDir();
        int i = 0;
        while (i < entries.length) {
            File f = BndTask.getFile(project, entries[i]);
            if (f.exists()) {
                list.add(f);
            } else {
                this.error("Can not find bnd file to process: " + f.getAbsolutePath());
            }
            ++i;
        }
    }

    public void setClasspath(String value) {
        Path p = (Path)this.getProject().getReference(value);
        if (p == null) {
            this.addAll(this.classpath, value, String.valueOf(File.pathSeparator) + ",");
        } else {
            String[] path = p.list();
            int i = 0;
            while (i < path.length) {
                this.classpath.add(path[i]);
                ++i;
            }
        }
    }

    public void setEclipse(boolean eclipse) {
        this.eclipse = eclipse;
    }

    boolean isFailok() {
        return this.failok;
    }

    public void setFailok(boolean failok) {
        this.failok = failok;
    }

    boolean isExceptions() {
        return this.exceptions;
    }

    public void setExceptions(boolean exceptions) {
        this.exceptions = exceptions;
    }

    boolean isPrint() {
        return this.print;
    }

    void setPrint(boolean print) {
        this.print = print;
    }

    public void setSourcepath(String sourcepath) {
        this.addAll(this.sourcepath, sourcepath, String.valueOf(File.pathSeparator) + ",");
    }

    File[] toFiles(List files, String what) throws IOException {
        return files.toArray(EMPTY_FILES);
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setDestFile(File output) {
        this.output = output;
    }

    public void setTestDir(File testDir) {
        this.testDir = testDir;
    }
}

