/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.repackage.cglib.proxy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.repackage.cglib.asm.Label;
import org.hibernate.repackage.cglib.asm.Type;
import org.hibernate.repackage.cglib.core.ClassEmitter;
import org.hibernate.repackage.cglib.core.CodeEmitter;
import org.hibernate.repackage.cglib.core.Constants;
import org.hibernate.repackage.cglib.core.EmitUtils;
import org.hibernate.repackage.cglib.core.Local;
import org.hibernate.repackage.cglib.core.MethodInfo;
import org.hibernate.repackage.cglib.core.ObjectSwitchCallback;
import org.hibernate.repackage.cglib.core.Signature;
import org.hibernate.repackage.cglib.core.TypeUtils;
import org.hibernate.repackage.cglib.proxy.CallbackGenerator;

class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String EMPTY_ARGS_NAME = "CGLIB$emptyArgs";
    static final String FIND_PROXY_NAME = "CGLIB$findMethodProxy";
    static final Class[] FIND_PROXY_TYPES = new Class[]{class$org$hibernate$repackage$cglib$core$Signature == null ? (class$org$hibernate$repackage$cglib$core$Signature = MethodInterceptorGenerator.class$("org.hibernate.repackage.cglib.core.Signature")) : class$org$hibernate$repackage$cglib$core$Signature};
    private static final Type ABSTRACT_METHOD_ERROR = TypeUtils.parseType("AbstractMethodError");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Type METHOD_PROXY = TypeUtils.parseType("org.hibernate.repackage.cglib.proxy.MethodProxy");
    private static final Type METHOD_INTERCEPTOR = TypeUtils.parseType("org.hibernate.repackage.cglib.proxy.MethodInterceptor");
    private static final Signature GET_DECLARING_CLASS = TypeUtils.parseSignature("Class getDeclaringClass()");
    private static final Signature GET_CLASS_LOADER = TypeUtils.parseSignature("ClassLoader getClassLoader()");
    private static final Signature MAKE_PROXY = new Signature("create", METHOD_PROXY, new Type[]{Constants.TYPE_CLASS_LOADER, Constants.TYPE_CLASS, Constants.TYPE_CLASS, Constants.TYPE_STRING, Constants.TYPE_STRING, Constants.TYPE_STRING});
    private static final Signature INTERCEPT = new Signature("intercept", Constants.TYPE_OBJECT, new Type[]{Constants.TYPE_OBJECT, METHOD, Constants.TYPE_OBJECT_ARRAY, METHOD_PROXY});
    private static final Signature FIND_PROXY = new Signature("CGLIB$findMethodProxy", METHOD_PROXY, new Type[]{Constants.TYPE_SIGNATURE});
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    static /* synthetic */ Class class$org$hibernate$repackage$cglib$core$Signature;

    MethodInterceptorGenerator() {
    }

    private String getMethodField(Signature impl) {
        return impl.getName() + "$Method";
    }

    private String getMethodProxyField(Signature impl) {
        return impl.getName() + "$Proxy";
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods) {
        HashMap<String, String> sigMap = new HashMap<String, String>();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            Signature impl = context.getImplSignature(method);
            String methodField = this.getMethodField(impl);
            String methodProxyField = this.getMethodProxyField(impl);
            sigMap.put(method.getSignature().toString(), methodProxyField);
            ce.declare_field(26, methodField, METHOD, null, null);
            ce.declare_field(26, methodProxyField, METHOD_PROXY, null, null);
            ce.declare_field(26, EMPTY_ARGS_NAME, Constants.TYPE_OBJECT_ARRAY, null, null);
            CodeEmitter e = ce.begin_method(16, impl, method.getExceptionTypes(), null);
            if (TypeUtils.isAbstract(method.getModifiers())) {
                e.throw_exception(ABSTRACT_METHOD_ERROR, method.toString() + " is abstract");
            } else {
                e.load_this();
                e.load_args();
                e.super_invoke(method.getSignature());
            }
            e.return_value();
            e.end_method();
            e = context.beginMethod(ce, method);
            Label nullInterceptor = e.make_label();
            context.emitCallback(e, context.getIndex(method));
            e.dup();
            e.ifnull(nullInterceptor);
            e.load_this();
            e.getfield(methodField);
            if (method.getSignature().getArgumentTypes().length == 0) {
                e.getfield(EMPTY_ARGS_NAME);
            } else {
                e.create_arg_array();
            }
            e.getfield(methodProxyField);
            e.invoke_interface(METHOD_INTERCEPTOR, INTERCEPT);
            e.unbox_or_zero(method.getSignature().getReturnType());
            e.return_value();
            e.mark(nullInterceptor);
            e.load_this();
            e.load_args();
            e.super_invoke(method.getSignature());
            e.return_value();
            e.end_method();
        }
        this.generateFindProxy(ce, sigMap);
    }

    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List methods) {
        Local thisclass = e.make_local();
        EmitUtils.load_class_this(e);
        e.dup();
        e.store_local(thisclass);
        e.invoke_virtual(Constants.TYPE_CLASS, GET_CLASS_LOADER);
        e.push(0);
        e.newarray();
        e.putfield(EMPTY_ARGS_NAME);
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            e.dup();
            MethodInfo method = (MethodInfo)it.next();
            Signature impl = context.getImplSignature(method);
            EmitUtils.load_method(e, method);
            e.dup();
            e.putfield(this.getMethodField(impl));
            Signature sig = method.getSignature();
            e.invoke_virtual(METHOD, GET_DECLARING_CLASS);
            e.load_local(thisclass);
            e.push(sig.getDescriptor());
            e.push(sig.getName());
            e.push(impl.getName());
            e.invoke_static(METHOD_PROXY, MAKE_PROXY);
            e.putfield(this.getMethodProxyField(impl));
        }
    }

    public void generateFindProxy(ClassEmitter ce, final Map sigMap) {
        final CodeEmitter e = ce.begin_method(9, FIND_PROXY, null, null);
        e.load_arg(0);
        e.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                e.getfield((String)sigMap.get(key));
                e.return_value();
            }

            public void processDefault() {
                e.aconst_null();
                e.return_value();
            }
        };
        EmitUtils.string_switch(e, sigMap.keySet().toArray(new String[0]), 1, callback);
        e.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

