/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi.eclipse;

import aQute.lib.reporter.Reporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EclipseClasspath {
    static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder db;
    File project;
    File workspace;
    List sources = new ArrayList();
    List classpath = new ArrayList();
    List dependents = new ArrayList();
    File output;
    boolean recurse = true;
    List exports = new ArrayList();
    Map properties = new HashMap();
    Reporter reporter;
    int options;
    List bootclasspath = new ArrayList();
    public static final int DO_VARIABLES = 1;
    static Pattern PATH = Pattern.compile("([A-Z_]+)/(.*)");

    public EclipseClasspath(Reporter reporter, File workspace, File project, int options) throws Exception {
        this.project = project;
        this.workspace = workspace;
        this.reporter = reporter;
        this.db = documentBuilderFactory.newDocumentBuilder();
        this.parse(project, true);
        this.db = null;
    }

    public EclipseClasspath(Reporter reporter, File workspace, File project) throws Exception {
        this(reporter, workspace, project, 0);
    }

    void parse(File project, boolean top) throws ParserConfigurationException, SAXException, IOException {
        File file = new File(project, ".classpath");
        if (!file.exists()) {
            throw new FileNotFoundException(".classpath file not found: " + file.getAbsolutePath());
        }
        File cp = new File(project, ".classpath");
        if (!cp.exists()) {
            return;
        }
        Document doc = this.db.parse(cp);
        NodeList nodelist = doc.getDocumentElement().getElementsByTagName("classpathentry");
        if (nodelist == null) {
            throw new IllegalArgumentException("Can not find classpathentry in classpath file");
        }
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            NamedNodeMap attrs = node.getAttributes();
            String kind = this.get(attrs, "kind");
            if ("src".equals(kind)) {
                String path = this.get(attrs, "path");
                boolean exported = "true".equalsIgnoreCase(this.get(attrs, "exported"));
                if (path.startsWith("/")) {
                    path = path.replace('/', File.separatorChar);
                    File subProject = new File(this.workspace, path.substring(1));
                    this.dependents.add(subProject);
                    if (this.recurse && (top || exported)) {
                        this.parse(subProject, false);
                    }
                } else {
                    File src = new File(project, path);
                    this.sources.add(src);
                }
            } else if ("lib".equals(kind)) {
                String path = this.get(attrs, "path");
                boolean exported = "true".equalsIgnoreCase(this.get(attrs, "exported"));
                if (top || exported) {
                    File f;
                    File jar = null;
                    jar = (path = path.replace('/', File.separatorChar)).startsWith(File.separator) ? new File(this.workspace, path.substring(1)) : ((f = new File(path)).isAbsolute() ? f : new File(project, path));
                    if (jar.getName().startsWith("ee.")) {
                        this.bootclasspath.add(jar);
                    } else {
                        this.classpath.add(jar);
                    }
                    if (exported) {
                        this.exports.add(jar);
                    }
                }
            } else if ("output".equals(kind)) {
                String path = this.get(attrs, "path");
                path = path.replace('/', File.separatorChar);
                this.output = new File(project, path);
                this.classpath.add(this.output);
                this.exports.add(this.output);
            } else if ("var".equals(kind)) {
                boolean exported = "true".equalsIgnoreCase(this.get(attrs, "exported"));
                File lib = this.replaceVar(this.get(attrs, "path"));
                File slib = this.replaceVar(this.get(attrs, "sourcepath"));
                if (lib != null) {
                    this.classpath.add(lib);
                    if (exported) {
                        this.exports.add(lib);
                    }
                }
                if (slib != null) {
                    this.sources.add(slib);
                }
            }
            ++i;
        }
    }

    private File replaceVar(String path) {
        if ((this.options & 1) == 0) {
            return null;
        }
        Matcher m = PATH.matcher(path);
        if (m.matches()) {
            String var = m.group(1);
            String remainder = m.group(2);
            String base = (String)this.properties.get(var);
            if (base != null) {
                File b = new File(base);
                File f = new File(b, remainder.replace('/', File.separatorChar));
                return f;
            }
            this.reporter.error("Can't find replacement variable for: " + path);
        } else {
            this.reporter.error("Cant split variable path: " + path);
        }
        return null;
    }

    private String get(NamedNodeMap map, String name) {
        Node node = map.getNamedItem(name);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public List getClasspath() {
        return this.classpath;
    }

    public List getSourcepath() {
        return this.sources;
    }

    public File getOutput() {
        return this.output;
    }

    public List getDependents() {
        return this.dependents;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public List getExports() {
        return this.exports;
    }

    public void setExports(List exports) {
        this.exports = exports;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public List getBootclasspath() {
        return this.bootclasspath;
    }
}

