/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;

public class EclipseTask
extends BaseTask {
    String prefix = "project.";
    List prebuild = new ArrayList();
    File workspace;

    public void execute() throws BuildException {
        try {
            File project = this.getProject().getBaseDir();
            EclipseClasspath eclipse = new EclipseClasspath(this, project.getParentFile(), project);
            if (this.report()) {
                throw new BuildException("Errors during Eclipse Path inspection");
            }
            this.addProperty(String.valueOf(this.prefix) + "classpath", this.join(eclipse.getClasspath(), File.pathSeparator));
            this.addProperty(String.valueOf(this.prefix) + "bootclasspath", this.join(eclipse.getBootclasspath(), ","));
            this.addProperty(String.valueOf(this.prefix) + "sourcepath", this.join(eclipse.getSourcepath(), File.pathSeparator));
            this.addProperty(String.valueOf(this.prefix) + "output", eclipse.getOutput().getAbsolutePath());
            List dependents = eclipse.getDependents();
            if (dependents.size() > 0) {
                this.addProperty(String.valueOf(this.prefix) + "buildpath", this.join(dependents, ","));
            }
        }
        catch (Exception e) {
            throw new BuildException("Error during parsing Eclipse .classpath files", (Throwable)e);
        }
    }

    protected void addProperty(String n, String v) {
        if (v != null) {
            this.getProject().setProperty(n, v);
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPrebuild(String prebuild) {
        StringTokenizer st = new StringTokenizer(prebuild, " ,");
        while (st.hasMoreTokens()) {
            this.prebuild.add(EclipseTask.getFile(this.getProject().getBaseDir(), prebuild));
        }
    }
}

