/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionDeserializer
implements ObjectDeserializer {
    public static final CollectionDeserializer instance = new CollectionDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        if (parser.getLexer().token() == 8) {
            parser.getLexer().nextToken(16);
            return null;
        }
        Collection list = null;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isAssignableFrom(HashSet.class)) {
                list = new HashSet();
            } else if (clazz.isAssignableFrom(ArrayList.class)) {
                list = new ArrayList();
            } else {
                try {
                    list = (Collection)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new JSONException("create instane error, class " + clazz.getName());
                }
            }
        }
        if (list == null) {
            list = new ArrayList();
        }
        Object itemType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
        parser.parseArray((Type)itemType, list);
        return (T)list;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

