/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.cobertura.coveragedata.BranchCoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;

public class SwitchData
implements BranchCoverageData,
Comparable,
Serializable,
HasBeenInstrumented {
    private static final long serialVersionUID = 9L;
    private transient Lock lock;
    private int switchNumber;
    private long defaultHits;
    private long[] hits;
    private int[] keys;

    public SwitchData(int switchNumber, int[] keys) {
        this.switchNumber = switchNumber;
        this.defaultHits = 0L;
        this.hits = new long[keys.length];
        Arrays.fill(this.hits, 0L);
        this.keys = new int[keys.length];
        System.arraycopy(keys, 0, this.keys, 0, keys.length);
        this.initLock();
    }

    public SwitchData(int switchNumber, int min, int max) {
        this.switchNumber = switchNumber;
        this.defaultHits = 0L;
        this.hits = new long[max - min + 1];
        Arrays.fill(this.hits, 0L);
        this.keys = new int[max - min + 1];
        int i = 0;
        while (min <= max) {
            this.keys[i++] = min++;
        }
        this.initLock();
    }

    public SwitchData(int switchNumber) {
        this(switchNumber, new int[0]);
    }

    private void initLock() {
        this.lock = new ReentrantLock();
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(SwitchData.class)) {
            return Integer.MAX_VALUE;
        }
        return this.switchNumber - ((SwitchData)o).switchNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void touchBranch(int branch, int new_hits) {
        this.lock.lock();
        try {
            if (branch == -1) {
                ++this.defaultHits;
            } else {
                if (this.hits.length <= branch) {
                    long[] old = this.hits;
                    this.hits = new long[branch + 1];
                    System.arraycopy(old, 0, this.hits, 0, old.length);
                    Arrays.fill(this.hits, old.length, this.hits.length - 1, 0L);
                }
                int n = branch;
                this.hits[n] = this.hits[n] + (long)new_hits;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getSwitchNumber() {
        return this.switchNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHits(int branch) {
        this.lock.lock();
        try {
            if (this.hits.length > branch) {
                long l = this.hits[branch];
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDefaultHits() {
        this.lock.lock();
        try {
            long l = this.defaultHits;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBranchCoverageRate() {
        this.lock.lock();
        try {
            int branches = this.hits.length + 1;
            int hit = this.defaultHits > 0L ? 1 : 0;
            int i = this.hits.length - 1;
            while (i >= 0) {
                hit += this.hits[i--] > 0L ? 1 : 0;
            }
            double d = (double)hit / (double)branches;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SwitchData switchData = (SwitchData)obj;
        this.getBothLocks(switchData);
        try {
            boolean bl = this.defaultHits == switchData.defaultHits && Arrays.equals(this.hits, switchData.hits) && this.switchNumber == switchData.switchNumber;
            return bl;
        }
        finally {
            this.lock.unlock();
            switchData.lock.unlock();
        }
    }

    public int hashCode() {
        return this.switchNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCoveredBranches() {
        this.lock.lock();
        try {
            int ret = this.defaultHits > 0L ? 1 : 0;
            for (int i = this.hits.length - 1; i >= 0; --i) {
                if (this.hits[i] <= 0L) continue;
                ++ret;
            }
            int n = ret;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfValidBranches() {
        this.lock.lock();
        try {
            int n = this.hits.length + 1;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(BranchCoverageData coverageData) {
        SwitchData switchData = (SwitchData)coverageData;
        this.getBothLocks(switchData);
        try {
            this.defaultHits += switchData.defaultHits;
            for (int i = Math.min(this.hits.length, switchData.hits.length) - 1; i >= 0; --i) {
                int n = i;
                this.hits[n] = this.hits[n] + switchData.hits[i];
            }
            if (switchData.hits.length > this.hits.length) {
                long[] old = this.hits;
                this.hits = new long[switchData.hits.length];
                System.arraycopy(old, 0, this.hits, 0, old.length);
                System.arraycopy(switchData.hits, old.length, this.hits, old.length, this.hits.length - old.length);
            }
            if (this.keys.length == 0 && switchData.keys.length > 0) {
                this.keys = switchData.keys;
            }
        }
        finally {
            this.lock.unlock();
            switchData.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBothLocks(SwitchData other) {
        boolean myLock = false;
        boolean otherLock = false;
        while (!myLock || !otherLock) {
            try {
                myLock = this.lock.tryLock();
                otherLock = other.lock.tryLock();
            }
            finally {
                if (myLock && otherLock) continue;
                if (myLock) {
                    this.lock.unlock();
                }
                if (otherLock) {
                    other.lock.unlock();
                }
                Thread.yield();
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initLock();
    }
}

