/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanDeserializer
implements ObjectDeserializer {
    public static final BooleanDeserializer instance = new BooleanDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        return BooleanDeserializer.deserialze(parser);
    }

    public static <T> T deserialze(DefaultExtJSONParser parser) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 6) {
            lexer.nextToken(16);
            return (T)Boolean.TRUE;
        }
        if (lexer.token() == 7) {
            lexer.nextToken(16);
            return (T)Boolean.FALSE;
        }
        if (lexer.token() == 2) {
            int intValue = lexer.intValue();
            lexer.nextToken(16);
            if (intValue == 1) {
                return (T)Boolean.TRUE;
            }
            return (T)Boolean.FALSE;
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)TypeUtils.castToBoolean(value);
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

