/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.SourceFileData;

public class PackageData
extends CoverageDataContainer
implements Comparable,
HasBeenInstrumented {
    private static final long serialVersionUID = 7L;
    private String name;

    public PackageData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Package name must be specified.");
        }
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassData(ClassData classData) {
        this.lock.lock();
        try {
            if (this.children.containsKey(classData.getBaseName())) {
                throw new IllegalArgumentException("Package " + this.name + " already contains a class with the name " + classData.getBaseName());
            }
            this.children.put(classData.getBaseName(), classData);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(PackageData.class)) {
            return Integer.MAX_VALUE;
        }
        return this.name.compareTo(((PackageData)o).name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        this.lock.lock();
        try {
            boolean bl = this.children.containsKey(name);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        PackageData packageData = (PackageData)obj;
        this.getBothLocks(packageData);
        try {
            boolean bl = super.equals(obj) && this.name.equals(packageData.name);
            return bl;
        }
        finally {
            this.lock.unlock();
            packageData.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet getClasses() {
        this.lock.lock();
        try {
            TreeSet treeSet = new TreeSet(this.children.values());
            return treeSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSourceFileName() {
        return this.name.replace('.', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSourceFiles() {
        TreeMap<String, SourceFileData> sourceFileDatas = new TreeMap<String, SourceFileData>();
        this.lock.lock();
        try {
            for (ClassData classData : this.children.values()) {
                String sourceFileName = classData.getSourceFileName();
                SourceFileData sourceFileData = (SourceFileData)sourceFileDatas.get(sourceFileName);
                if (sourceFileData == null) {
                    sourceFileData = new SourceFileData(sourceFileName);
                    sourceFileDatas.put(sourceFileName, sourceFileData);
                }
                sourceFileData.addClassData(classData);
            }
        }
        finally {
            this.lock.unlock();
        }
        return sourceFileDatas.values();
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

