/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.ZipResource;
import aQute.lib.reporter.Reporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Jar {
    public static final Object[] EMPTY_ARRAY = new Jar[0];
    Map resources = new TreeMap();
    Map directories = new TreeMap();
    Manifest manifest;
    boolean manifestFirst;
    String name;
    File source;
    ZipFile zipFile;
    long lastModified;
    Reporter reporter;

    public Jar(String name) {
        this.name = name;
    }

    public Jar(String name, File dirOrFile) throws ZipException, IOException {
        this(name);
        this.source = dirOrFile;
        if (dirOrFile.isDirectory()) {
            FileResource.build(this, dirOrFile, Analyzer.doNotCopy);
        } else {
            this.zipFile = ZipResource.build(this, dirOrFile);
        }
    }

    public Jar(String name, InputStream in, long lastModified) throws IOException {
        this(name);
        EmbeddedResource.build(this, in, lastModified);
    }

    public Jar(String name, String path) throws IOException {
        this(name);
        File f = new File(path);
        FileInputStream in = new FileInputStream(f);
        EmbeddedResource.build(this, in, f.lastModified());
        ((InputStream)in).close();
    }

    public Jar(File jar) throws IOException {
        this(jar.getName(), jar);
    }

    public Jar(String string, InputStream resourceAsStream) throws IOException {
        this(string, resourceAsStream, 0L);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Jar:" + this.name;
    }

    public boolean putResource(String path, Resource resource) {
        return this.putResource(path, resource, true);
    }

    public boolean putResource(String path, Resource resource, boolean overwrite) {
        boolean duplicate;
        String dir;
        TreeMap<String, Resource> s;
        if (resource.lastModified() > this.lastModified) {
            this.lastModified = resource.lastModified();
        }
        if (path.equals("META-INF/MANIFEST.MF")) {
            this.manifest = null;
            if (this.resources.isEmpty()) {
                this.manifestFirst = true;
            }
        }
        if ((s = (TreeMap<String, Resource>)this.directories.get(dir = this.getDirectory(path))) == null) {
            s = new TreeMap<String, Resource>();
            this.directories.put(dir, s);
            int n = dir.lastIndexOf(47);
            while (n > 0) {
                String dd = dir.substring(0, n);
                if (this.directories.containsKey(dd)) break;
                this.directories.put(dd, null);
                n = dd.lastIndexOf(47);
            }
        }
        if (!(duplicate = s.containsKey(path)) || overwrite) {
            this.resources.put(path, resource);
            s.put(path, resource);
        }
        return duplicate;
    }

    public Resource getResource(String path) {
        return (Resource)this.resources.get(path);
    }

    private String getDirectory(String path) {
        int n = path.lastIndexOf(47);
        if (n < 0) {
            return "";
        }
        return path.substring(0, n);
    }

    public Map getDirectories() {
        return this.directories;
    }

    public Map getResources() {
        return this.resources;
    }

    public boolean addDirectory(Map directory, boolean overwrite) {
        boolean duplicates = false;
        if (directory == null) {
            return false;
        }
        Iterator c = directory.entrySet().iterator();
        while (c.hasNext()) {
            Map.Entry entry = c.next();
            String key = (String)entry.getKey();
            if (key.endsWith(".java")) continue;
            duplicates |= this.putResource(key, (Resource)entry.getValue(), overwrite);
        }
        return duplicates;
    }

    public Manifest getManifest() throws IOException {
        Resource manifestResource;
        if (this.manifest == null && (manifestResource = this.getResource("META-INF/MANIFEST.MF")) != null) {
            InputStream in = manifestResource.openInputStream();
            this.manifest = new Manifest(in);
            in.close();
        }
        return this.manifest;
    }

    public boolean exists(String path) {
        return this.resources.containsKey(path);
    }

    public void setManifest(Manifest manifest) {
        this.manifestFirst = true;
        this.manifest = manifest;
    }

    public void write(File file) throws Exception {
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.write(out);
            ((OutputStream)out).close();
        }
        catch (Throwable t) {
            try {
                file.delete();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            t.printStackTrace();
        }
    }

    public void write(String file) throws Exception {
        this.write(new File(file));
    }

    public void write(OutputStream out) throws IOException {
        JarOutputStream jout = new JarOutputStream(out);
        HashSet done = new HashSet();
        HashSet directories = new HashSet();
        this.doManifest(done, jout);
        Iterator i = this.getResources().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (done.contains(entry.getKey())) continue;
            this.writeResource(jout, directories, (String)entry.getKey(), (Resource)entry.getValue());
        }
        jout.finish();
    }

    private void doManifest(Set done, JarOutputStream jout) throws IOException {
        JarEntry ze = new JarEntry("META-INF/MANIFEST.MF");
        jout.putNextEntry(ze);
        this.writeManifest(jout);
        jout.closeEntry();
        done.add(ze.getName());
    }

    public void writeManifest(OutputStream out) throws IOException {
        Manifest manifest = Jar.clean(this.getManifest());
        manifest.write(out);
    }

    private static Manifest clean(Manifest org) {
        Manifest result = new Manifest();
        Iterator<Map.Entry<Object, Object>> i = org.getMainAttributes().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String nice = Jar.clean((String)entry.getValue());
            result.getMainAttributes().put((Attributes.Name)entry.getKey(), nice);
        }
        Iterator<String> n = org.getEntries().keySet().iterator();
        while (n.hasNext()) {
            String name = n.next();
            Attributes attrs = result.getAttributes(name);
            if (attrs == null) {
                attrs = new Attributes();
                result.getEntries().put(name, attrs);
            }
            Iterator<Map.Entry<Object, Object>> i2 = org.getAttributes(name).entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry<Object, Object> entry = i2.next();
                String nice = Jar.clean((String)entry.getValue());
                attrs.put((Attributes.Name)entry.getKey(), nice);
            }
        }
        return result;
    }

    private static String clean(String s) {
        if (s.indexOf(10) < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '\n') {
                sb.insert(++i, ' ');
            }
            ++i;
        }
        return sb.toString();
    }

    private void writeResource(JarOutputStream jout, Set directories, String path, Resource resource) throws IOException {
        if (resource == null) {
            return;
        }
        this.createDirectories(directories, jout, path);
        ZipEntry ze = new ZipEntry(path);
        ze.setMethod(8);
        long lastModified = resource.lastModified();
        if (lastModified == 0L) {
            lastModified = System.currentTimeMillis();
        }
        ze.setTime(lastModified);
        if (resource.getExtra() != null) {
            ze.setExtra(resource.getExtra().getBytes());
        }
        jout.putNextEntry(ze);
        try {
            resource.write(jout);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot write resource: " + path + " " + e);
        }
        jout.closeEntry();
    }

    void createDirectories(Set directories, JarOutputStream zip, String name) throws IOException {
        int index = name.lastIndexOf(47);
        if (index > 0) {
            String path = name.substring(0, index);
            if (directories.contains(path)) {
                return;
            }
            this.createDirectories(directories, zip, path);
            ZipEntry ze = new ZipEntry(String.valueOf(path) + '/');
            zip.putNextEntry(ze);
            zip.closeEntry();
            directories.add(path);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean addAll(Jar sub, Pattern filter) {
        boolean dupl = false;
        Iterator r = sub.getResources().keySet().iterator();
        while (r.hasNext()) {
            String name = (String)r.next();
            if ("META-INF/MANIFEST.MF".equals(name) || filter != null && !filter.matcher(name).matches()) continue;
            dupl |= this.putResource(name, sub.getResource(name), true);
        }
        return dupl;
    }

    public void close() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.resources = null;
        this.directories = null;
        this.manifest = null;
        this.source = null;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void updateModified(long time) {
        if (time > this.lastModified) {
            this.lastModified = time;
        }
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public boolean hasDirectory(String path) {
        return this.directories.containsKey(path);
    }

    public List getPackages() {
        ArrayList<String> list = new ArrayList<String>(this.directories.size());
        Iterator i = this.directories.keySet().iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            String pack = path.replace('/', '.');
            list.add(pack);
        }
        return list;
    }

    public File getSource() {
        return this.source;
    }

    public boolean addAll(Jar src) {
        return this.addAll(src, null);
    }

    public boolean rename(String oldPath, String newPath) {
        Resource resource = this.remove(oldPath);
        if (resource == null) {
            return false;
        }
        return this.putResource(newPath, resource);
    }

    public Resource remove(String path) {
        Resource resource = (Resource)this.resources.remove(path);
        String dir = this.getDirectory(path);
        Map mdir = (Map)this.directories.get(dir);
        mdir.remove(path);
        return resource;
    }
}

