/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto;

import org.codehaus.stax2.XMLStreamLocation2;

public class LocationImpl
implements XMLStreamLocation2 {
    private static final LocationImpl sEmptyLocation = new LocationImpl("", "", -1, -1, -1);
    final String mPublicId;
    final String mSystemId;
    final int mCharOffset;
    final int mCol;
    final int mRow;
    transient String mDesc = null;

    public LocationImpl(String pubId, String sysId, int charOffset, int row, int col) {
        this.mPublicId = pubId;
        this.mSystemId = sysId;
        this.mCharOffset = charOffset < 0 ? Integer.MAX_VALUE : charOffset;
        this.mCol = col;
        this.mRow = row;
    }

    public static LocationImpl fromZeroBased(String pubId, String sysId, int rawOffset, int rawRow, int rawCol) {
        return new LocationImpl(pubId, sysId, rawOffset, rawRow + 1, rawCol + 1);
    }

    public static LocationImpl getEmptyLocation() {
        return sEmptyLocation;
    }

    public int getCharacterOffset() {
        return this.mCharOffset;
    }

    public int getColumnNumber() {
        return this.mCol;
    }

    public int getLineNumber() {
        return this.mRow;
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public XMLStreamLocation2 getContext() {
        return null;
    }

    public String toString() {
        if (this.mDesc == null) {
            StringBuffer sb = new StringBuffer(100);
            this.appendDesc(sb);
            this.mDesc = sb.toString();
        }
        return this.mDesc;
    }

    private void appendDesc(StringBuffer sb) {
        String srcId;
        if (this.mSystemId != null) {
            sb.append("[row,col,system-id]: ");
            srcId = this.mSystemId;
        } else if (this.mPublicId != null) {
            sb.append("[row,col,public-id]: ");
            srcId = this.mPublicId;
        } else {
            sb.append("[row,col {unknown-source}]: ");
            srcId = null;
        }
        sb.append('[');
        sb.append(this.mRow);
        sb.append(',');
        sb.append(this.mCol);
        if (srcId != null) {
            sb.append(',');
            sb.append('\"');
            sb.append(srcId);
            sb.append('\"');
        }
        sb.append(']');
    }
}

