/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson;

import de.undercouch.bson4jackson.BsonGenerator;
import de.undercouch.bson4jackson.BsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.io.IOContext;

public class BsonFactory
extends JsonFactory {
    private static final int DEFAULT_BSON_GENERATOR_FEATURE_FLAGS = 0;
    protected int _bsonGeneratorFeatures = 0;

    public BsonFactory() {
        this(null);
    }

    public BsonFactory(ObjectCodec objectCodec) {
        super(objectCodec);
    }

    public final BsonFactory configure(BsonGenerator.Feature feature, boolean bl) {
        if (bl) {
            return this.enable(feature);
        }
        return this.disable(feature);
    }

    public BsonFactory enable(BsonGenerator.Feature feature) {
        this._bsonGeneratorFeatures |= feature.getMask();
        return this;
    }

    public BsonFactory disable(BsonGenerator.Feature feature) {
        this._bsonGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(BsonGenerator.Feature feature) {
        return (this._bsonGeneratorFeatures & feature.getMask()) != 0;
    }

    public BsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return this.createJsonGenerator(outputStream);
    }

    public BsonGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        return new BsonGenerator(this._generatorFeatures, this._bsonGeneratorFeatures, outputStream);
    }

    public BsonParser createJsonParser(InputStream inputStream) throws IOException {
        BsonParser bsonParser = new BsonParser(this._parserFeatures, inputStream);
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec != null) {
            bsonParser.setCodec(objectCodec);
        }
        return bsonParser;
    }

    protected JsonParser _createJsonParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        return this.createJsonParser(inputStream);
    }

    protected JsonParser _createJsonParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        throw new UnsupportedOperationException("Can not create reader for non-byte-based source");
    }

    protected JsonParser _createJsonParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        return this._createJsonParser(new ByteArrayInputStream(byArray, n, n2), iOContext);
    }

    protected JsonGenerator _createJsonGenerator(Writer writer, IOContext iOContext) throws IOException {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        throw new UnsupportedOperationException("Can not create generator for non-byte-based target");
    }
}

