/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.util.Collection;

public class CollectionSerializer
implements ObjectSerializer {
    public static final CollectionSerializer instance = new CollectionSerializer();

    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        Collection collection = (Collection)object;
        out.append('[');
        boolean first = true;
        for (Object item : collection) {
            if (!first) {
                out.append(',');
            }
            first = false;
            if (item == null) {
                out.writeNull();
                continue;
            }
            Class<?> clazz = item.getClass();
            if (clazz == Integer.class) {
                out.writeInt((Integer)item);
                continue;
            }
            if (clazz == Long.class) {
                out.writeLong((Long)item);
                continue;
            }
            serializer.write(item);
        }
        out.append(']');
    }
}

