/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.url;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BndConnection
extends URLConnection {
    static final String REPOSITORIES_KEY = "biz.aQute.bnd.maven.repositories";
    static final String DEFAULT_REPOSITORIES = "http://repo.mergere.com/maven2/, http://download.java.net/maven/2/,http://repo1.maven.org/maven2/";
    static final String GROUP_ID = "(.+?)";
    static final String ARTIFACT_ID = "(\\.(\\w+))";
    static final String VERSION = "(([0-9]+(\\.[0-9]+)*)(.*))";
    Pattern FILE_NAME = Pattern.compile("(.*/)*(.+?)(-(.+))?");
    static final Pattern maven = Pattern.compile("(.+?)(\\.(\\w+))(-(([0-9]+(\\.[0-9]+)*)(.*)))?");

    BndConnection(URL url) {
        super(url);
    }

    public InputStream getInputStream() throws IOException {
        Jar jar;
        Manifest manifest;
        InputStream target;
        String query;
        Properties properties;
        block12: {
            properties = new Properties();
            String path = this.getURL().getPath();
            query = this.getURL().getQuery();
            target = null;
            try {
                URL url = new URL(path);
                String file = this.getURL().getFile();
                if (file.endsWith(".jar")) {
                    file = file.substring(0, file.length() - 4);
                }
                target = url.openStream();
                Matcher m = this.FILE_NAME.matcher(file);
                if (m.matches()) {
                    properties.put("Bundle-SymbolicName", m.group(2));
                    String version = m.group(4);
                    if (version != null) {
                        properties.put("Bundle-Version", version);
                    }
                }
            }
            catch (MalformedURLException e) {
                String[] parts = this.parseMaven(path);
                target = this.openMaven(parts[0], parts[1], parts[2]);
                properties.put("Bundle-SymbolicName", String.valueOf(parts[0]) + "." + parts[1]);
                if (parts[2] == null) break block12;
                properties.put("Bundle-Version", parts[2]);
            }
        }
        if ((manifest = (jar = new Jar("dot", target)).getManifest()) == null || manifest.getMainAttributes().getValue("Export-Package") == null && manifest.getMainAttributes().getValue("Import-Package") == null) {
            properties.put("Bnd-URL", this.getURL().toExternalForm());
            if (query != null && query.length() > 0) {
                Pattern q = Pattern.compile("(\\w+)\\s*=\\s([-!\"'()*+,.0-9A-Z_a-z%]+)");
                String[] split = query.split("\\s*&\\s*");
                int i = 0;
                while (i < split.length) {
                    String expr = split[i];
                    Matcher z = q.matcher(expr);
                    if (z.matches()) {
                        String value = URLDecoder.decode(z.group(2), "UTF-8");
                        properties.put(z.group(1), value);
                    }
                    ++i;
                }
            }
            Analyzer analyzer = new Analyzer();
            analyzer.setJar(jar);
            analyzer.setProperties(properties);
            if (analyzer.getProperty("Import-Package") == null) {
                analyzer.setProperty("Import-Package", "*;resolution:=optional");
            }
            if (analyzer.getProperty("Export-Package") == null) {
                String export = analyzer.calculateExportsFromContents(jar);
                analyzer.setProperty("Export-Package", export);
            }
            if (analyzer.getProperty("Bundle-SymbolicName") == null) {
                analyzer.setProperty("Bundle-SymbolicName", "U" + System.currentTimeMillis());
            }
            analyzer.mergeManifest(manifest);
            analyzer.calcManifest();
        }
        PipedInputStream pin = new PipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        Thread t = new Thread(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        jar.write(pout);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    try {
                        jar.close();
                        pout.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                try {}
                catch (IOException iOException) {
                    return;
                }
                jar.close();
                pout.close();
            }
        };
        t.start();
        return pin;
    }

    private String[] parseMaven(String path) throws FileNotFoundException {
        Matcher m = maven.matcher(path);
        if (!m.matches()) {
            throw new FileNotFoundException("Invalid format for <groupid>.<artifactid>-<version>: " + path);
        }
        String[] parts = new String[]{m.group(1), m.group(3), m.group(6)};
        return parts;
    }

    private InputStream openMaven(String groupId, String artifactId, String version) throws FileNotFoundException {
        String repos = System.getProperty(REPOSITORIES_KEY);
        if (repos == null) {
            repos = DEFAULT_REPOSITORIES;
        }
        String[] split = repos.split("\\s*,\\s*");
        int i = 0;
        while (i < split.length) {
            try {
                URL url = new URL(split[i]);
                String tpath = String.valueOf(groupId.replace('.', '/')) + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + ".jar";
                URL target = new URL(url, tpath);
                return target.openStream();
            }
            catch (Exception exception) {
                ++i;
            }
        }
        throw new FileNotFoundException("Could not find " + groupId + "." + artifactId + "-" + " in " + repos);
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public void connect() throws IOException {
    }
}

