/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.async;

import com.fasterxml.aalto.async.AsyncByteScanner;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import javax.xml.stream.XMLStreamException;

public class AsyncUtfScanner
extends AsyncByteScanner {
    static final int PENDING_STATE_CR = -1;
    static final int PENDING_STATE_PI_QMARK = -2;
    static final int PENDING_STATE_COMMENT_HYPHEN1 = -3;
    static final int PENDING_STATE_COMMENT_HYPHEN2 = -4;

    public AsyncUtfScanner(ReaderConfig cfg) {
        super(cfg);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected final int startCharacters(byte b) throws XMLStreamException {
        block20: {
            int c = b & 0xFF;
            switch (this.mCharTypes.TEXT_CHARS[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = -1;
                        return 257;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = c;
                        return 257;
                    }
                    c = this.decodeUtf8_2(c);
                    break;
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            int d = this._inputBuffer[this._inputPtr++] & 0xFF;
                            c |= d << 8;
                        }
                        this.mPendingInput = c;
                        return 257;
                    }
                    c = this.decodeUtf8_3(c);
                    break;
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            int d = this._inputBuffer[this._inputPtr++] & 0xFF;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 0xFF;
                                c |= d << 16;
                            }
                        }
                        this.mPendingInput = c;
                        return 257;
                    }
                    c = this.decodeUtf8_4(c);
                    this._textBuilder.resetWithSurrogate(c);
                    break block20;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                    break;
                }
                case 9: 
                case 10: {
                    this.throwInternal();
                }
            }
            this._textBuilder.resetWithChar((char)c);
        }
        if (this._cfgCoalescing && !this._cfgLazyParsing) {
            return this.finishCharactersCoalescing();
        }
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
            return this._currToken;
        }
        this.finishCharacters();
        return this._currToken;
    }

    @Override
    protected int startCharactersPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return 257;
        }
        int c = this.mPendingInput;
        this.mPendingInput = 0;
        if (c == -1) {
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
            this.markLF();
            this._textBuilder.resetWithChar('\n');
        } else {
            switch (this.mCharTypes.TEXT_CHARS[c & 0xFF]) {
                case 5: {
                    this._textBuilder.resetWithChar((char)this.decodeUtf8_2(c));
                    break;
                }
                case 6: {
                    int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                    int c2 = c >> 8;
                    if (c2 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.mPendingInput = c | next << 8;
                            return 257;
                        }
                        int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        c = this.decodeUtf8_3(c, next, c3);
                    } else {
                        c = this.decodeUtf8_3(c & 0xFF, c2, next);
                    }
                    this._textBuilder.resetWithChar((char)c);
                    break;
                }
                case 7: {
                    int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (c >> 8 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.mPendingInput = c | next << 8;
                            return 257;
                        }
                        int c2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        if (this._inputPtr >= this._inputEnd) {
                            this.mPendingInput = c | next << 8 | c2 << 16;
                            return 257;
                        }
                        int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        c = this.decodeUtf8_4(c, next, c2, c3);
                    } else {
                        int c2 = c >> 8 & 0xFF;
                        int c3 = c >> 16;
                        if (c3 == 0) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.mPendingInput = c | next << 16;
                                return 257;
                            }
                            c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                            c = this.decodeUtf8_4(c & 0xFF, c2, next, c3);
                        } else {
                            c = this.decodeUtf8_4(c & 0xFF, c2, c3, next);
                        }
                    }
                    this._textBuilder.resetWithSurrogate(c);
                    this._currToken = 4;
                    return 4;
                }
                default: {
                    this.throwInternal();
                }
            }
        }
        if (this._cfgCoalescing && !this._cfgLazyParsing) {
            return this.finishCharactersCoalescing();
        }
        this._currToken = 4;
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        return this._currToken;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCharacters() throws XMLStreamException {
        if (this.mPendingInput != 0) {
            this.throwInternal();
        }
        TYPES = this.mCharTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        block12: while ((ptr = this._inputPtr) < this._inputEnd) {
            block31: {
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block31;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = -1;
                        break block12;
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl100
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl100
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = c;
                        break block12;
                    }
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl100
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                        }
                        this.mPendingInput = c;
                        break block12;
                    }
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl100
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 16;
                            }
                        }
                        this.mPendingInput = c;
                        break block12;
                    }
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl100
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    c = this.handleCharacterEntity();
                    if (c == 0) break block12;
                    if (c >> 16 == 0) ** GOTO lbl100
                    outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl100
                }
                case 11: {
                    count = 1;
                    b = 0;
                    while (this._inputPtr < this._inputEnd && (b = inputBuffer[this._inputPtr]) == 93) {
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (--count > 0) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr < outputBuffer.length) continue;
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                }
lbl100:
                // 9 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block12;
                }
            }
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final int finishCharactersCoalescing() throws XMLStreamException {
        if (this.mPendingInput != 0 && !this.handleAndAppendPending()) {
            return 257;
        }
        return 0;
    }

    private boolean handleAndAppendPending() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            return false;
        }
        int c = this.mPendingInput;
        this.mPendingInput = 0;
        if (c < 0) {
            if (c == -1) {
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                this._textBuilder.append('\n');
                return true;
            }
            this.throwInternal();
        }
        switch (this.mCharTypes.TEXT_CHARS[c & 0xFF]) {
            case 5: {
                this._textBuilder.append((char)this.decodeUtf8_2(c));
                break;
            }
            case 6: {
                int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                int c2 = c >> 8;
                if (c2 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = c | next << 8;
                        return false;
                    }
                    int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    c = this.decodeUtf8_3(c, next, c3);
                } else {
                    c = this.decodeUtf8_3(c & 0xFF, c2, next);
                }
                this._textBuilder.append((char)c);
                break;
            }
            case 7: {
                int next = this._inputBuffer[this._inputPtr++] & 0xFF;
                if (c >> 8 == 0) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = c | next << 8;
                        return false;
                    }
                    int c2 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = c | next << 8 | c2 << 16;
                        return false;
                    }
                    int c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                    c = this.decodeUtf8_4(c, next, c2, c3);
                } else {
                    int c2 = c >> 8 & 0xFF;
                    int c3 = c >> 16;
                    if (c3 == 0) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.mPendingInput = c | next << 16;
                            return false;
                        }
                        c3 = this._inputBuffer[this._inputPtr++] & 0xFF;
                        c = this.decodeUtf8_4(c & 0xFF, c2, next, c3);
                    } else {
                        c = this.decodeUtf8_4(c & 0xFF, c2, c3, next);
                    }
                }
                this._textBuilder.appendSurrogate(c);
                break;
            }
            default: {
                this.throwInternal();
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean skipCharacters() throws XMLStreamException {
        if (this.mPendingInput != 0) {
            this.throwInternal();
        }
        TYPES = this.mCharTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        block12: while ((ptr = this._inputPtr) < (max = this._inputEnd)) {
            block26: {
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) continue;
                    break block26;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = -1;
                        break block12;
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    ** GOTO lbl76
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl76
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = c;
                        break block12;
                    }
                    this.skipUtf8_2(c);
                    ** GOTO lbl76
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                        }
                        this.mPendingInput = c;
                        break block12;
                    }
                    this.decodeUtf8_3(c);
                    ** GOTO lbl76
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 16;
                            }
                        }
                        this.mPendingInput = c;
                        break block12;
                    }
                    this.decodeUtf8_4(c);
                    ** GOTO lbl76
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    return false;
                }
                case 10: {
                    c = this.handleCharacterEntity();
                    if (c == 0) {
                        return true;
                    }
                    ** GOTO lbl76
                }
                case 11: {
                    count = 1;
                    b = 0;
                    while (this._inputPtr < this._inputEnd && (b = inputBuffer[this._inputPtr]) == 93) {
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                }
lbl76:
                // 10 sources

                default: {
                    continue block12;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean skipCoalescedText() throws XMLStreamException {
        this.throwInternal();
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean handleAttrValue() throws XMLStreamException {
        attrBuffer = this._attrCollector.continueValue();
        TYPES = this.mCharTypes.ATTR_CHARS;
        quoteChar = this.mElemAttrQuote;
        if (this.mPendingInput != 0) {
            if (!this.handlePartialCR()) {
                return false;
            }
            if (this.mElemAttrPtr >= attrBuffer.length) {
                attrBuffer = this._attrCollector.valueBufferFull();
            }
            attrBuffer[this.mElemAttrPtr++] = 32;
        }
        block13: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return false;
            }
            if (this.mElemAttrPtr >= attrBuffer.length) {
                attrBuffer = this._attrCollector.valueBufferFull();
            }
            if ((max2 = this._inputPtr + (attrBuffer.length - this.mElemAttrPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (true) {
                if (this._inputPtr >= max) continue block13;
                if (TYPES[c = this._inputBuffer[this._inputPtr++] & 255] != 0) break;
                attrBuffer[this.mElemAttrPtr++] = (char)c;
            }
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = -1;
                        return false;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    c = 32;
                    ** GOTO lbl83
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl83
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                        }
                        this.mPendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl83
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 16;
                            }
                        }
                        this.mPendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_4(c);
                    attrBuffer[this.mElemAttrPtr++] = (char)(55296 | c >> 10);
                    c = 56320 | c & 1023;
                    if (this.mElemAttrPtr >= attrBuffer.length) {
                        attrBuffer = this._attrCollector.valueBufferFull();
                    }
                    ** GOTO lbl83
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                }
                case 10: {
                    c = this.handleCharacterEntity();
                    if (c == 0) {
                        this.reportUnexpandedEntityInAttr(this.mElemAttrName, false);
                    }
                    if (c >> 16 != 0) {
                        attrBuffer[this.mElemAttrPtr++] = (char)(55296 | (c -= 65536) >> 10);
                        c = 56320 | c & 1023;
                        if (this.mElemAttrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                    }
                    ** GOTO lbl83
                }
                case 14: {
                    if (c == quoteChar) break block13;
                }
lbl83:
                // 7 sources

                default: {
                    attrBuffer[this.mElemAttrPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean handleNsDecl() throws XMLStreamException {
        TYPES = this.mCharTypes.ATTR_CHARS;
        attrBuffer = this._nameBuffer;
        quoteChar = this.mElemAttrQuote;
        if (this.mPendingInput != 0) {
            if (!this.handlePartialCR()) {
                return false;
            }
            if (this.mElemAttrPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            attrBuffer[this.mElemAttrPtr++] = 32;
        }
        block13: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return false;
            }
            if (this.mElemAttrPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            if ((max2 = this._inputPtr + (attrBuffer.length - this.mElemAttrPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (true) {
                if (this._inputPtr >= max) continue block13;
                if (TYPES[c = this._inputBuffer[this._inputPtr++] & 255] != 0) break;
                attrBuffer[this.mElemAttrPtr++] = (char)c;
            }
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = -1;
                        return false;
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    c = 32;
                    ** GOTO lbl83
                }
                case 5: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl83
                }
                case 6: {
                    if (this._inputEnd - this._inputPtr < 2) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                        }
                        this.mPendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl83
                }
                case 7: {
                    if (this._inputEnd - this._inputPtr < 3) {
                        if (this._inputEnd > this._inputPtr) {
                            d = this._inputBuffer[this._inputPtr++] & 255;
                            c |= d << 8;
                            if (this._inputEnd > this._inputPtr) {
                                d = this._inputBuffer[this._inputPtr++] & 255;
                                c |= d << 16;
                            }
                        }
                        this.mPendingInput = c;
                        return false;
                    }
                    c = this.decodeUtf8_4(c);
                    attrBuffer[this.mElemAttrPtr++] = (char)(55296 | c >> 10);
                    c = 56320 | c & 1023;
                    if (this.mElemAttrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    ** GOTO lbl83
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                }
                case 10: {
                    c = this.handleCharacterEntity();
                    if (c == 0) {
                        this.reportUnexpandedEntityInAttr(this.mElemAttrName, true);
                    }
                    if (c >> 16 != 0) {
                        attrBuffer[this.mElemAttrPtr++] = (char)(55296 | (c -= 65536) >> 10);
                        c = 56320 | c & 1023;
                        if (this.mElemAttrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                    }
                    ** GOTO lbl83
                }
                case 14: {
                    if (c == quoteChar) break block13;
                }
lbl83:
                // 7 sources

                default: {
                    attrBuffer[this.mElemAttrPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        attrPtr = this.mElemAttrPtr;
        if (attrPtr == 0) {
            this.bindNs(this.mElemAttrName, "");
        } else {
            uri = this._config.canonicalizeURI(attrBuffer, attrPtr);
            this.bindNs(this.mElemAttrName, uri);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int parseCommentContents() throws XMLStreamException {
        if (this.mPendingInput != 0 && (result = this.handleCommentPending()) != 0) {
            return result;
        }
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        TYPES = this.mCharTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        block10: while (this._inputPtr < this._inputEnd) {
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            if ((max2 = this._inputPtr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (this._inputPtr < max) {
                if (TYPES[c = inputBuffer[this._inputPtr++] & 255] == 0) {
                    outputBuffer[outPtr++] = (char)c;
                    continue;
                }
                switch (TYPES[c]) {
                    case 1: {
                        this.throwInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr < this._inputEnd) {
                            this.mPendingInput = -1;
                            break block10;
                        }
                        if (inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        ** GOTO lbl63
                    }
                    case 3: {
                        this.markLF();
                        ** GOTO lbl63
                    }
                    case 5: {
                        c = this.decodeUtf8_2(c);
                        ** GOTO lbl63
                    }
                    case 6: {
                        c = this.decodeUtf8_3(c);
                        ** GOTO lbl63
                    }
                    case 7: {
                        c = this.decodeUtf8_4(c);
                        outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        c = 56320 | c & 1023;
                        ** GOTO lbl63
                    }
                    case 4: {
                        this.reportInvalidInitial(c);
                    }
                    case 13: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.mPendingInput = -3;
                            break block10;
                        }
                        if (this._inputBuffer[this._inputPtr] == 45) {
                            ++this._inputPtr;
                            if (this._inputPtr >= this._inputEnd) {
                                this.mPendingInput = -4;
                                break block10;
                            }
                            if (this._inputBuffer[this._inputPtr++] != 62) {
                                this.reportDoubleHyphenInComments();
                            }
                            this._textBuilder.setCurrentLength(outPtr);
                            this.mState = 0;
                            this.mNextEvent = 257;
                            return 5;
                        }
                    }
lbl63:
                    // 8 sources

                    default: {
                        outputBuffer[outPtr++] = (char)c;
                        continue block10;
                    }
                }
            }
        }
        this._textBuilder.setCurrentLength(outPtr);
        return 257;
    }

    protected final int handleCommentPending() throws XMLStreamException {
        if (this.mPendingInput == -3) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if (this._inputBuffer[this._inputPtr] != 45) {
                this._textBuilder.append("-");
                return 0;
            }
            ++this._inputPtr;
            this.mPendingInput = -4;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
        }
        if (this.mPendingInput == -4) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if ((b = this._inputBuffer[this._inputPtr++]) != 45) {
                this.reportDoubleHyphenInComments();
            }
            this.mState = 0;
            this.mNextEvent = 257;
            return 3;
        }
        return this.handleAndAppendPending() ? 0 : 257;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int parsePIData() throws XMLStreamException {
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        if (this.mPendingInput != 0 && (result = this.handlePIPending()) != 0) {
            return result;
        }
        TYPES = this.mCharTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        block10: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            if ((max2 = this._inputPtr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                max = max2;
            }
            while (true) {
                if (this._inputPtr >= max) continue block10;
                if (TYPES[c = inputBuffer[this._inputPtr++] & 255] != 0) break;
                outputBuffer[outPtr++] = (char)c;
            }
            switch (TYPES[c]) {
                case 1: {
                    this.throwInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr < this._inputEnd) {
                        this.mPendingInput = -1;
                        break block10;
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl61
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl61
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl61
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl61
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl61
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.mPendingInput = -2;
                        break block10;
                    }
                    if (this._inputBuffer[this._inputPtr] == 62) {
                        ++this._inputPtr;
                        this._textBuilder.setCurrentLength(outPtr);
                        this.mState = 0;
                        this.mNextEvent = 257;
                        return 3;
                    }
                }
lbl61:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
        return 257;
    }

    protected final int handlePIPending() throws XMLStreamException {
        if (this.mPendingInput == -2) {
            if (this._inputPtr >= this._inputEnd) {
                return 257;
            }
            byte b = this._inputBuffer[this._inputPtr];
            this.mPendingInput = 0;
            if (b != 62) {
                this._textBuilder.append("?");
                return 0;
            }
            ++this._inputPtr;
            this.mState = 0;
            this.mNextEvent = 257;
            return 3;
        }
        return this.handleAndAppendPending() ? 0 : 257;
    }

    protected final int decodeUtf8_2(int c) throws XMLStreamException {
        byte d;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    protected final void skipUtf8_2(int c) throws XMLStreamException {
        byte d;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
    }

    protected final int decodeUtf8_3(int c1) throws XMLStreamException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (c1 >= 13 && c >= 55296 && (c < 57344 || c >= 65534 && c <= 65535)) {
            this.throwInvalidXmlChar(c);
        }
        return c;
    }

    protected final int decodeUtf8_3(int c1, int c2, int c3) throws XMLStreamException {
        if ((c2 & 0xC0) != 128) {
            this.reportInvalidOther(c2 & 0xFF, this._inputPtr - 1);
        }
        if ((c3 & 0xC0) != 128) {
            this.reportInvalidOther(c3 & 0xFF, this._inputPtr);
        }
        int c = (c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
        if (c1 >= 13 && c >= 55296 && (c < 57344 || c >= 65534 && c <= 65535)) {
            this.throwInvalidXmlChar(c);
        }
        return c;
    }

    protected final int decodeUtf8_4(int c) throws XMLStreamException {
        byte d;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    protected final int decodeUtf8_4(int c1, int c2, int c3, int c4) throws XMLStreamException {
        if ((c2 & 0xC0) != 128) {
            this.reportInvalidOther(c2 & 0xFF, this._inputPtr - 2);
        }
        int c = (c1 & 7) << 6 | c2 & 0x3F;
        if ((c3 & 0xC0) != 128) {
            this.reportInvalidOther(c3 & 0xFF, this._inputPtr - 1);
        }
        c = c << 6 | c3 & 0x3F;
        if ((c4 & 0xC0) != 128) {
            this.reportInvalidOther(c4 & 0xFF, this._inputPtr);
        }
        return (c << 6 | c4 & 0x3F) - 65536;
    }

    @Override
    protected final PName addPName(int hash, int[] quads, int qlen, int lastQuadBytes) throws XMLStreamException {
        return this.addUtfPName(this.mCharTypes, hash, quads, qlen, lastQuadBytes);
    }

    @Override
    protected void reportInvalidInitial(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    @Override
    protected void reportInvalidOther(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    protected void reportInvalidOther(int mask, int ptr) throws XMLStreamException {
        this._inputPtr = ptr;
        this.reportInvalidOther(mask);
    }
}

