/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.parser;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ParseException;

public class JSONParser {
    private boolean acceptSimpleQuote = true;
    private boolean acceptNonQuote = true;
    private boolean acceptNaN = true;
    public static final int MODE_PERMISSIF = -1;
    public static final int MODE_RFC4627 = 0;
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final byte EOI = 26;
    protected static boolean[] stopArray = new boolean[126];
    protected static boolean[] stopKey = new boolean[126];
    protected static boolean[] stopValue = new boolean[126];
    protected static boolean[] stopX = new boolean[126];
    private char c;
    private ContainerFactory containerFactory;
    private String in;
    private int len;
    private int pos;
    private StringBuilder sb = new StringBuilder();

    public JSONParser() {
        this(-1);
    }

    public JSONParser(int permissifMode) {
        this.acceptNaN = (permissifMode & 4) > 0;
        this.acceptNonQuote = (permissifMode & 2) > 0;
        this.acceptSimpleQuote = (permissifMode & 1) > 0;
    }

    public Object parse(String in) throws ParseException {
        return this.parse(in, ContainerFactory.FACTORY);
    }

    public Object parse(String in, ContainerFactory containerFactory) throws ParseException {
        this.len = in.length();
        this.in = in;
        this.containerFactory = containerFactory;
        this.pos = -1;
        this.read();
        return this.readMain(stopX);
    }

    private final void read() throws ParseException {
        if (++this.pos >= this.len) {
            throw new ParseException(this.pos - 1, 3, "EOF");
        }
        this.c = this.in.charAt(this.pos);
    }

    private List<Object> readArray() throws ParseException {
        List<Object> obj = this.containerFactory.creatArrayContainer();
        if (this.c != '[') {
            throw new RuntimeException("Internal Error");
        }
        this.read();
        block6: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block6;
                }
                case ']': {
                    this.readEOI();
                    return obj;
                }
                case ':': 
                case '}': {
                    throw new ParseException(this.pos, 1, Character.valueOf(this.c));
                }
                case ',': {
                    this.read();
                    continue block6;
                }
            }
            obj.add(this.readMain(stopArray));
        }
    }

    private final void readEOI() throws ParseException {
        this.c = ++this.pos >= this.len ? (char)26 : this.in.charAt(this.pos);
    }

    private Object readMain(boolean[] stop) throws ParseException {
        block12: while (true) {
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.read();
                    continue block12;
                }
                case ':': 
                case ']': 
                case '}': {
                    throw new ParseException(this.pos, 1, null);
                }
                case '{': {
                    return this.readObject();
                }
                case '[': {
                    return this.readArray();
                }
                case '\"': 
                case '\'': {
                    return this.readString();
                }
                case 'n': {
                    String x = this.readNQString(stop);
                    if ("null".equals(x)) {
                        return null;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(1, x);
                    }
                    return x;
                }
                case 'f': {
                    String x = this.readNQString(stop);
                    if ("false".equals(x)) {
                        return Boolean.FALSE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(1, x);
                    }
                    return x;
                }
                case 't': {
                    String x = this.readNQString(stop);
                    if ("true".equals(x)) {
                        return Boolean.TRUE;
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(1, x);
                    }
                    return x;
                }
                case 'N': {
                    String x = this.readNQString(stop);
                    if (!this.acceptNaN) {
                        throw new ParseException(1, x);
                    }
                    if ("NaN".equals(x)) {
                        return Float.valueOf(Float.NaN);
                    }
                    if (!this.acceptNonQuote) {
                        throw new ParseException(1, x);
                    }
                    return x;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.readNumber(stop);
                }
            }
            break;
        }
        String text = this.readNQString(stop);
        if (!this.acceptNonQuote) {
            throw new ParseException(1, text);
        }
        return text;
    }

    private String readNQString(boolean[] stop) throws ParseException {
        int start = this.pos;
        this.skipNQString(stop);
        return this.in.substring(start, this.pos).trim();
    }

    private Object readNumber(boolean[] stop) throws ParseException {
        int start = this.pos;
        this.read();
        this.skipDigits();
        if (this.c != '.' && this.c != 'E' && this.c != 'e') {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                String text = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(1, text);
                }
                return text;
            }
            String num = this.in.substring(start, this.pos).trim();
            if (num.length() > 20) {
                return new BigInteger(num);
            }
            try {
                long v = Long.parseLong(num);
                if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                    return (int)v;
                }
                return v;
            }
            catch (NumberFormatException e) {
                return new BigInteger(num);
            }
        }
        if (this.c == '.') {
            this.read();
            this.skipDigits();
        }
        if (this.c != 'E' && this.c != 'e') {
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                String text = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(1, text);
                }
                return text;
            }
            String num = this.in.substring(start, this.pos).trim();
            return Double.parseDouble(num);
        }
        this.sb.append('E');
        this.read();
        if (this.c == '+' || this.c == '-' || this.c >= '0' && this.c <= '9') {
            this.sb.append(this.c);
            this.read();
            this.skipDigits();
            this.skipSpace();
            if (!stop[this.c]) {
                this.skipNQString(stop);
                String text = this.in.substring(start, this.pos).trim();
                if (!this.acceptNonQuote) {
                    throw new ParseException(1, text);
                }
                return text;
            }
            return Double.parseDouble(this.in.substring(start, this.pos).trim());
        }
        this.skipNQString(stop);
        String text = this.in.substring(start, this.pos).trim();
        if (!this.acceptNonQuote) {
            throw new ParseException(1, text);
        }
        return text;
    }

    private Map<String, Object> readObject() throws ParseException {
        Map<String, Object> obj = this.containerFactory.createObjectContainer();
        if (this.c != '{') {
            throw new RuntimeException("Internal Error");
        }
        block6: while (true) {
            String key;
            this.read();
            switch (this.c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                case ':': 
                case ']': {
                    throw new NullPointerException();
                }
                case '}': {
                    this.readEOI();
                    return obj;
                }
                case ',': {
                    continue block6;
                }
            }
            if (this.c == '\"' || this.c == '\'') {
                key = this.readString();
            } else {
                key = this.readNQString(stopKey);
                if (!this.acceptNonQuote) {
                    throw new ParseException(1, key);
                }
            }
            while (this.c != ':') {
                this.read();
            }
            this.read();
            obj.put(key, this.readMain(stopValue));
            if (this.c == '}') break;
        }
        this.readEOI();
        return obj;
    }

    private String readString() throws ParseException {
        if (!this.acceptSimpleQuote && this.c == '\'') {
            throw new ParseException(1, "'");
        }
        int tmpP = this.in.indexOf(this.c, this.pos + 1);
        if (tmpP == -1) {
            throw new ParseException(this.in.length(), 3);
        }
        String tmp = this.in.substring(this.pos + 1, tmpP);
        if (tmp.indexOf(92) == -1) {
            this.pos = tmpP;
            this.read();
            return tmp;
        }
        this.sb.delete(0, this.sb.length());
        char sep = this.c;
        block17: while (true) {
            this.read();
            switch (this.c) {
                case '\"': 
                case '\'': {
                    if (sep == this.c) {
                        this.read();
                        return this.sb.toString();
                    }
                    this.sb.append(this.c);
                    continue block17;
                }
                case '\\': {
                    this.read();
                    switch (this.c) {
                        case 't': {
                            this.sb.append('\t');
                            continue block17;
                        }
                        case 'n': {
                            this.sb.append('\n');
                            continue block17;
                        }
                        case 'r': {
                            this.sb.append('\r');
                            continue block17;
                        }
                        case 'f': {
                            this.sb.append('\f');
                            continue block17;
                        }
                        case 'b': {
                            this.sb.append('\b');
                            continue block17;
                        }
                        case '\\': {
                            this.sb.append('\\');
                            continue block17;
                        }
                        case '/': {
                            this.sb.append('/');
                            continue block17;
                        }
                        case '\'': {
                            this.sb.append('\'');
                            continue block17;
                        }
                        case '\"': {
                            this.sb.append('\"');
                            continue block17;
                        }
                        case 'u': {
                            this.sb.append(this.readUnicode());
                            continue block17;
                        }
                    }
                    continue block17;
                }
                case '\n': 
                case '\r': {
                    continue block17;
                }
            }
            this.sb.append(this.c);
        }
    }

    private char readUnicode() throws ParseException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value *= 16;
            this.read();
            if (this.c >= '0' && this.c <= '9') {
                value += this.c - 48;
                continue;
            }
            if (this.c >= 'A' && this.c <= 'F') {
                value += this.c - 65 + 10;
                continue;
            }
            if (this.c >= 'a' && this.c <= 'f') {
                value += this.c - 97 + 10;
                continue;
            }
            throw new ParseException(this.pos, 1, "Invalid Unicode value " + this.c);
        }
        return (char)value;
    }

    private void skipDigits() throws ParseException {
        while (this.pos < this.len) {
            if (this.c < '0' || this.c > '9') {
                return;
            }
            this.read();
        }
        return;
    }

    private void skipNQString(boolean[] stop) throws ParseException {
        while (this.pos < this.len) {
            if (this.c >= '\u0000' && this.c <= '}' && stop[this.c]) {
                return;
            }
            this.read();
        }
        return;
    }

    private void skipSpace() throws ParseException {
        while (this.pos < this.len) {
            if (this.c != ' ' && this.c != '\r' && this.c != '\t' && this.c != '\n') {
                return;
            }
            this.read();
        }
        return;
    }

    static {
        JSONParser.stopKey[58] = true;
        JSONParser.stopValue[125] = true;
        JSONParser.stopValue[44] = true;
        JSONParser.stopArray[93] = true;
        JSONParser.stopArray[44] = true;
    }
}

