h50202
s 00138/00017/00199
d D 1.14 02/03/10 20:01:50 shannon 15 14
c add more complete support for JDK 1.2 class loaders and security model
e
s 00006/00016/00210
d D 1.13 99/12/06 16:33:43 shannon 14 13
c Update copyright for SCSL release
e
s 00010/00000/00216
d D 1.12 99/05/11 09:20:06 shannon 13 12
c add missing javadoc @param and @return clauses
e
s 00001/00003/00215
d D 1.11 99/04/21 13:48:44 shannon 12 11
c allow MimeTypeFile to open the file
e
s 00013/00010/00205
d D 1.10 99/03/25 17:35:03 shannon 11 10
c clean up code and javadocs
e
s 00039/00030/00176
d D 1.9 99/03/12 16:52:20 shannon 10 9
c clean up code and comments
e
s 00004/00004/00202
d D 1.8 98/02/20 17:45:47 miltonb 9 8
c 0.6 edit updates
e
s 00006/00006/00200
d D 1.7 98/02/06 15:26:53 bhc 8 7
c javadoc overhaul
e
s 00010/00010/00196
d D 1.6 98/01/30 10:43:49 bhc 7 6
c Fix to the JavaDocs, minor API change as per review
e
s 00002/00002/00204
d D 1.5 98/01/22 15:37:13 shannon 6 5
c resource names have to start with /
e
s 00003/00011/00203
d D 1.4 98/01/22 11:11:25 shannon 5 4
c use Class.getResource instead of ClassLoader.getResource, to make it
c work under Internet Explorer 4
e
s 00131/00070/00083
d D 1.3 98/01/18 00:36:53 shannon 4 3
c significantly cleaned up and rewritten to properly handle the
c collection of databases
e
s 00002/00002/00151
d D 1.2 98/01/09 17:16:18 bhc 3 1
c last minute code review changes for javamail beta
e
s 00000/00000/00000
d R 1.2 97/12/08 07:30:43 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/MimetypesFileTypeMap.java
c Name history : 1 0 src/classes/javax/activation/MimetypesFileTypeMap.java
e
s 00153/00000/00000
d D 1.1 97/12/08 07:30:42 bhc 1 0
c date and time created 97/12/08 07:30:42 by bhc
e
u
U
f e 0
t
T
I 1
/*
D 9
 * %W% %E%
E 9
I 9
D 10
 * @(#)MimetypesFileTypeMap.java	1.7 98/02/06
E 9
D 4
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
E 4
I 4
 * Copyright (c) 1997-1998 Sun Microsystems, Inc. All Rights Reserved.
E 10
I 10
D 14
 * %W%	%E%
E 14
I 14
 * %W% %E%
E 14
E 10
E 4
 *
I 10
D 14
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 10
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
E 14
I 14
D 15
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 15
I 15
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
E 15
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 14
D 4
 * @author Bart Calder
E 4
 */

package javax.activation;

D 4
import java.io.File;
import java.io.InputStream;
import java.io.IOException;
import java.io.ByteArrayOutputStream;
E 4
I 4
import java.io.*;
I 15
import java.net.*;
import java.util.*;
E 15
E 4
import com.sun.activation.registries.MimeTypeFile;

/**
 * This class extends FileTypeMap and provides data typing of files
D 10
 * via their file extension. It uses the .mime.types format:
E 10
I 10
 * via their file extension. It uses the <code>.mime.types</code> format. <p>
 *
 * <b>MIME types file search order:</b><p>
 * The MimetypesFileTypeMap looks in various places in the user's
 * system for MIME types file entries. When requests are made
 * to search for MIME types in the MimetypesFileTypeMap, it searches  
 * MIME types files in the following order:
E 10
 * <p>
I 10
 * <ol>
 * <li> Programmatically added entries to the MimetypesFileTypeMap instance.
 * <li> The file <code>.mime.types</code> in the user's home directory.
 * <li> The file &lt;<i>java.home</i>&gt;<code>/lib/mime.types</code>.
D 15
 * <li> The file or resource named <code>META-INF/mime.types</code>.
E 15
I 15
 * <li> The file or resources named <code>META-INF/mime.types</code>.
E 15
 * <li> The file or resource named <code>META-INF/mimetypes.default</code>
 * (usually found only in the <code>activation.jar</code> file).
 * </ol>
 * <p>
 * <b>MIME types file format:</b><p>
 *
E 10
 * <code>
D 7
 * # comments begin with a '#'
 * # the format is <mime type> <space separated file extensions>
 * # for example:
 * text/plain    txt text TXT
D 4
 * # this would map file.txt, file.text, and file.TXT to 
E 4
I 4
 * # this would map file.txt, file.text, and file.TXT to
E 4
 * # the mime type "text/plain"
E 7
I 7
 * # comments begin with a '#'<br>
 * # the format is &lt;mime type> &lt;space separated file extensions><br>
 * # for example:<br>
 * text/plain    txt text TXT<br>
 * # this would map file.txt, file.text, and file.TXT to<br>
 * # the mime type "text/plain"<br>
E 7
 * </code>
D 4
 * <p> 
E 4
I 4
D 10
 * <p>
E 4
 * When either of the <code>getContentType</code> methods are
D 4
 * called, first the mime type entries added to this instance of 
E 4
I 4
 * called, first the mime type entries added to this instance of
E 4
 * file map are checked, if no mapping it found, the default
 * entries which are included as part of the JavaBeans Activation
 * Framework are checked. If no mapping is found, the type
 * "application/octet-stream" is returned.
E 10
I 4
 *
 * @author Bart Calder
 * @author Bill Shannon
E 4
 */
public class MimetypesFileTypeMap extends FileTypeMap {
I 4
    /*
D 15
     * We manage up to 5 databases, searched in order.
E 15
I 15
     * We manage a collection of databases, searched in order.
E 15
     * The default database is shared between all instances
     * of this class.
     * XXX - Can we safely share more databases between instances?
     */
    private static MimeTypeFile defDB = null;
D 15
    private MimeTypeFile[] DB = new MimeTypeFile[5];
E 15
I 15
    private MimeTypeFile[] DB;
E 15
    private static final int PROG = 0;	// programmatically added entries
D 15
    private static final int HOME = 1;	// the user's home directory
    private static final int SYS = 2;	// the system file
    private static final int JAR = 3;	// the app's entry in the jar file
    private static final int DEF = 4;	// the default entry in our jar file
E 15
E 4

D 4
    private static MimeTypeFile systemTypesDB = null;
    private MimeTypeFile instanceDB = null;
    private static String defaultType = null;
E 4
I 4
    private static String defaultType = "application/octet-stream";
E 4

I 15
    private static boolean debug = false;

    static {
	try {
	    debug = Boolean.getBoolean("javax.activation.debug");
	} catch (Throwable t) {
	    // ignore any errors
	}
    }

E 15
    /**
D 4
     * The default constructor, reads in the defalt mimetype mappings
     * included with the JAF.
E 4
I 4
     * The default constructor.
E 4
     */
D 4
   public MimetypesFileTypeMap(){
       InputStream is = java.lang.ClassLoader.getSystemResourceAsStream(
D 3
						      "META-INF/mimetypes");
E 3
I 3
						"META-INF/mimetypes.default");
E 3
       // see if another instance has created this yet.
       if(systemTypesDB == null){
	   systemTypesDB = new MimeTypeFile();
	   if(is != null) {
	       try {
		   systemTypesDB.appendToRegistry(streamToString(is));
	       } catch (IOException e) {}
	   }
       }
       
       if(defaultType == null)
	   defaultType = new String("application/octet-stream");
E 4
I 4
    public MimetypesFileTypeMap() {
I 15
	Vector dbv = new Vector(5);	// usually 5 or less databases
	MimeTypeFile mf = null;
	dbv.addElement(null);		// place holder for PROG entry

	if (debug)
	    System.out.println("MimetypesFileTypeMap: load HOME");
E 15
	try {
	    String user_home = System.getProperty("user.home");
E 4

D 4
   }
E 4
I 4
	    if (user_home != null) {
		String path = user_home + File.separator + ".mime.types";
D 15
		DB[HOME] = loadFile(path);
E 15
I 15
		mf = loadFile(path);
		if (mf != null)
		    dbv.addElement(mf);
E 15
	    }
	} catch (SecurityException ex) {}
E 4

I 15
	if (debug)
	    System.out.println("MimetypesFileTypeMap: load SYS");
E 15
I 4
	try {
	    // check system's home
	    String system_mimetypes = System.getProperty("java.home") +
		File.separator + "lib" + File.separator + "mime.types";
D 15
	    DB[SYS] = loadFile(system_mimetypes);
E 15
I 15
	    mf = loadFile(system_mimetypes);
	    if (mf != null)
		dbv.addElement(mf);
E 15
	} catch (SecurityException ex) {}

I 15
	if (debug)
	    System.out.println("MimetypesFileTypeMap: load JAR");
E 15
	// load from the app's jar file
D 6
	DB[JAR] = loadResource("META-INF/mime.types");
E 6
I 6
D 15
	DB[JAR] = loadResource("/META-INF/mime.types");
E 15
I 15
	loadAllResources(dbv, "META-INF/mime.types");
E 15
E 6

I 15
	if (debug)
	    System.out.println("MimetypesFileTypeMap: load DEF");
E 15
	synchronized (MimetypesFileTypeMap.class) {
	    // see if another instance has created this yet.
	    if (defDB == null)
D 6
		defDB = loadResource("META-INF/mimetypes.default");
E 6
I 6
		defDB = loadResource("/META-INF/mimetypes.default");
E 6
	}

D 15
	DB[DEF] = defDB;
E 15
I 15
	if (defDB != null)
	    dbv.addElement(defDB);

	DB = new MimeTypeFile[dbv.size()];
	dbv.copyInto(DB);
E 15
    }

I 15
    private static final void pr(String s) {
	System.out.println(s);
    }

E 15
E 4
    /**
D 4
     * Constructor that allows one to specify a mimetypes file to 
E 4
I 4
D 15
     * Load the named resource.
E 15
I 15
     * Load from the named resource.
E 15
     */
    private MimeTypeFile loadResource(String name) {
I 15
	InputStream clis = null;
E 15
D 5
	ClassLoader cl = this.getClass().getClassLoader();
	InputStream clis = null;
	MimeTypeFile mtf = null;

	if (cl != null) // null would mean system CL
	    clis = cl.getResourceAsStream(name);
	else
	    clis = ClassLoader.getSystemResourceAsStream(name);

E 5
	try {
I 5
D 15
	    InputStream clis = this.getClass().getResourceAsStream(name);
E 5
	    if (clis != null)
D 5
		mtf = new MimeTypeFile(clis);
E 5
I 5
		return new MimeTypeFile(clis);
E 15
I 15
	    clis = SecuritySupport.getInstance().
		    getResourceAsStream(this.getClass(), name);
	    if (clis != null) {
		MimeTypeFile mf = new MimeTypeFile(clis);
		if (debug)
		    pr("MimetypesFileTypeMap: successfully loaded " +
			"mime types file: " + name);
		return mf;
	    } else {
		if (debug)
		    pr("MimetypesFileTypeMap: not loading mime types file: " +
			name);
	    }
E 15
E 5
	} catch (IOException e) {
D 11
	    //e.printStackTrace();
E 11
I 11
D 15
	    // e.printStackTrace();
E 15
I 15
	    if (debug) {
		pr("MimetypesFileTypeMap: " + e);
		e.printStackTrace();
	    }
	} catch (SecurityException sex) {
	    if (debug)
		pr("MimetypesFileTypeMap: " + sex);
	} finally {
	    try {
		if (clis != null)
		    clis.close();
	    } catch (IOException ex) { }	// ignore it
E 15
E 11
	}
D 5
	return mtf;
E 5
I 5
	return null;
E 5
    }

I 15
    /**
     * Load all of the named resource.
     */
    private void loadAllResources(Vector v, String name) {
	boolean anyLoaded = false;
	try {
	    URL[] urls;
	    ClassLoader cld = null;
	    // First try the "application's" class loader.
	    cld = SecuritySupport.getInstance().getContextClassLoader();
	    if (cld == null)
		cld = this.getClass().getClassLoader();
	    if (cld != null)
		urls = SecuritySupport.getInstance().getResources(cld, name);
	    else
		urls = SecuritySupport.getInstance().getSystemResources(name);
	    if (urls != null) {
		if (debug)
		    pr("MimetypesFileTypeMap: getResources");
		for (int i = 0; i < urls.length; i++) {
		    URL url = urls[i];
		    InputStream clis = null;
		    if (debug)
			pr("MimetypesFileTypeMap: URL " + url);
		    try {
			clis = SecuritySupport.getInstance().openStream(url);
			if (clis != null) {
			    v.addElement(new MimeTypeFile(clis));
			    anyLoaded = true;
			    if (debug)
				pr("MimetypesFileTypeMap: successfully " +
				    "loaded mime types from URL: " +
				    url);
			} else {
			    if (debug)
				pr("MimetypesFileTypeMap: not loading " +
				    "mime types from URL: " + url);
			}
		    } catch (IOException ioex) {
			if (debug)
			    pr("MimetypesFileTypeMap: " + ioex);
		    } catch (SecurityException sex) {
			if (debug)
			    pr("MimetypesFileTypeMap: " + sex);
		    } finally {
			try {
			    if (clis != null)
				clis.close();
			} catch (IOException cex) { }
		    }
		}
	    }
	} catch (Exception ex) {
	    if (debug)
		pr("MimetypesFileTypeMap: " + ex);
	}

	// if failed to load anything, fall back to old technique, just in case
	if (!anyLoaded) {
	    if (debug)
		pr("MimetypesFileTypeMap: !anyLoaded");
	    MimeTypeFile mf = loadResource("/" + name);
	    if (mf != null)
		v.addElement(mf);
	}
    }

E 15
    /**
     * Load the named file.
     */
    private MimeTypeFile loadFile(String name) {
	MimeTypeFile mtf = null;

	try {
D 12
	    FileInputStream fis = new FileInputStream(name);
	    if (fis != null)
		mtf = new MimeTypeFile(fis);
E 12
I 12
	    mtf = new MimeTypeFile(name);
E 12
D 11
	} catch(IOException e) {
E 11
I 11
	} catch (IOException e) {
E 11
	    //	e.printStackTrace();
	}
	return mtf;
    }

    /**
D 9
     * Constructor that allows one to specify a mimetypes file to
E 9
I 9
D 10
     * Constructor specifies a mimetypes file to
E 9
E 4
     * append to the registry.
E 10
I 10
     * Construct a MimetypesFileTypeMap with programmatic entries
     * added from the named file.
I 13
     *
     * @param mimeTypeFileName	the file name
E 13
E 10
     */
D 4
    public MimetypesFileTypeMap(String mimeTypeFileName){
	this(); // set up the system mimetype file.
	instanceDB = new MimeTypeFile(mimeTypeFileName);
E 4
I 4
D 7
    public MimetypesFileTypeMap(String mimeTypeFileName) {
E 7
I 7
    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
E 7
	this();
D 7
	try {
E 7
I 7
D 10
	//	try {
E 7
	    DB[PROG] = new MimeTypeFile(mimeTypeFileName);
D 7
	} catch (IOException ex) {
E 7
I 7
	    //} catch (IOException ex) {
E 7
	    // XXX - really should throw it
D 7
	}
E 7
I 7
	    //}
E 10
I 10
	DB[PROG] = new MimeTypeFile(mimeTypeFileName);
E 10
E 7
E 4
    }
D 4
    
E 4
I 4

E 4
    /**
D 9
     * Constructor that allows one to specify a mimetypes file
E 9
I 9
D 10
     * Constructor specifies a mimetypes file
E 9
     * as an InputStream to append to the registry.
E 10
I 10
     * Construct a MimetypesFileTypeMap with programmatic entries
     * added from the InputStream.
I 13
     *
     * @param is	the input stream to read from
E 13
E 10
     */
    public MimetypesFileTypeMap(InputStream is) {
D 4
	this(); //set up the system mimetype file
	instanceDB = new MimeTypeFile();
E 4
I 4
	this();
E 4
	try {
D 4
	    instanceDB.appendToRegistry( streamToString(is));
D 3
	} catch(Exception e) {}
E 3
I 3
	} catch(IOException e) {}
E 4
I 4
	    DB[PROG] = new MimeTypeFile(is);
	} catch (IOException ex) {
	    // XXX - really should throw it
	}
E 4
E 3
    }
D 4
    /**
     * Convert an inputstream into a string
     */
    private String streamToString(InputStream is) throws IOException {
	int bytes_read = 0;
	byte buf[] = new byte[4096];
	ByteArrayOutputStream baos = new ByteArrayOutputStream();
	
	while((bytes_read = is.read(buf)) > 0) 
	    baos.write(buf, 0, bytes_read);
E 4

D 4
	return baos.toString();
    }

E 4
    /**
D 4
     * This method will prepend the .mimetype values to the 
E 4
I 4
D 9
     * This method will prepend the .mimetype values to the
E 9
I 9
D 10
     * This method prepends the .mimetype values to the
E 9
E 4
     * registry.
E 10
I 10
     * Prepend the MIME type values to the registry.
E 10
     *
     * @param mime_types A .mime.types formatted string of entries.
     */
D 4
    public void addMimeTypes(String mime_types)	{
E 4
I 4
    public synchronized void addMimeTypes(String mime_types) {
E 4
	// check to see if we have created the registry
D 4
	if( instanceDB == null)
	    instanceDB = new MimeTypeFile(); // make one
	
	instanceDB.appendToRegistry( mime_types );
E 4
I 4
	if (DB[PROG] == null)
	    DB[PROG] = new MimeTypeFile(); // make one

	DB[PROG].appendToRegistry(mime_types);
E 4
    }
I 4

E 4
    /**
D 10
     * Return the type of the file object.
E 10
I 10
     * Return the MIME type of the file object.
     * The implementation in this class calls
     * <code>getContentType(f.getName())</code>.
I 13
     *
     * @param f	the file
     * @return	the file's MIME type
E 13
E 10
     */
    public String getContentType(File f) {
	return this.getContentType(f.getName());
    }

    /**
D 10
     * Return the type of the file passed in
E 10
I 10
     * Return the MIME type based on the specified file name.
     * The MIME type entries are searched as described above under
     * <i>MIME types file search order</i>.
     * If no entry is found, the type "application/octet-stream" is returned.
I 13
     *
     * @param filename	the file name
     * @return		the file's MIME type
E 13
E 10
     */
D 4
   public String getContentType(String filename) {
E 4
I 4
D 11
   public synchronized String getContentType(String filename) {
E 11
I 11
    public synchronized String getContentType(String filename) {
E 11
E 4
	int dot_pos = filename.lastIndexOf("."); // period index

D 4
	String file_ext = new String(filename.substring(dot_pos + 1,
						     filename.length()));
E 4
I 4
	if (dot_pos < 0)
	    return defaultType;

	String file_ext = filename.substring(dot_pos + 1);
E 4
D 10
	String result = null;
E 10
I 10
	if (file_ext.length() == 0)
	    return defaultType;
E 10
D 4
	
	if(instanceDB != null) // has one been specified?
	    result = instanceDB.getMIMETypeString( file_ext );
	
	if(result == null)
	    result = systemTypesDB.getMIMETypeString( file_ext );
	
	if(result == null)
E 4
I 4

	for (int i = 0; i < DB.length; i++) {
	    if (DB[i] == null)
		continue;
D 10
	    result = DB[i].getMIMETypeString(file_ext);
E 10
I 10
	    String result = DB[i].getMIMETypeString(file_ext);
E 10
	    if (result != null)
D 10
		break;
E 10
I 10
		return result;
E 10
	}
D 10

	if (result == null)
E 4
	    result = defaultType;
D 4
	
E 4
	return result;
E 10
I 10
	return defaultType;
E 10
    }

I 4
D 11
    // for debugging
D 8
    public static void main(String[] argv) throws Exception {
	MimetypesFileTypeMap map = new MimetypesFileTypeMap();
	System.out.println("File " + argv[0] + " has MIME type " +
						map.getContentType(argv[0]));
	System.exit(0);
    }
E 8
I 8
//     public static void main(String[] argv) throws Exception {
// 	MimetypesFileTypeMap map = new MimetypesFileTypeMap();
// 	System.out.println("File " + argv[0] + " has MIME type " +
// 						map.getContentType(argv[0]));
// 	System.exit(0);
//     }
E 11
I 11
    /**
     * for debugging...
     *
    public static void main(String[] argv) throws Exception {
	MimetypesFileTypeMap map = new MimetypesFileTypeMap();
	System.out.println("File " + argv[0] + " has MIME type " +
						map.getContentType(argv[0]));
	System.exit(0);
    }
    */
E 11
E 8
E 4
}
E 1
