h16980
s 00115/00016/00418
d D 1.27 02/03/10 20:01:50 shannon 30 29
c add more complete support for JDK 1.2 class loaders and security model
e
s 00006/00017/00428
d D 1.26 99/12/06 16:33:41 shannon 29 28
c Update copyright for SCSL release
e
s 00000/00001/00445
d D 1.25 99/11/18 15:31:30 shannon 28 27
c remove unneeded import
e
s 00007/00000/00439
d D 1.24 99/05/11 09:20:02 shannon 27 26
c add missing javadoc @param and @return clauses
e
s 00036/00003/00403
d D 1.23 99/04/21 13:57:11 shannon 26 25
c add debugging; let MailcapFile open the file
e
s 00029/00027/00377
d D 1.22 99/03/25 17:34:59 shannon 25 24
c clean up code and javadocs
e
s 00027/00026/00377
d D 1.21 99/03/12 17:03:09 shannon 24 23
c clean up documentation
e
s 00022/00022/00381
d D 1.20 98/02/20 17:45:47 miltonb 23 22
c 0.6 edit updates
e
s 00067/00020/00336
d D 1.19 98/02/06 15:26:47 bhc 22 21
c javadoc overhaul
e
s 00001/00001/00355
d D 1.18 98/01/23 13:07:47 bhc 21 20
c minor typo
c 
e
s 00000/00000/00356
d D 1.17 98/01/23 10:48:45 bhc 20 18
i 19
c Merged changes between child workspace "/home/bhc/jaf/jaf_ext" and
c  parent workspace "/net/icdev/export1/ic/tsunami/bhc_ws/jaf_ext".
c 
e
s 00022/00011/00334
d D 1.15.1.1 98/01/23 10:48:02 bhc 19 17
c interum
e
s 00004/00004/00341
d D 1.16 98/01/22 15:37:12 shannon 18 17
c resource names have to start with /
e
s 00003/00011/00342
d D 1.15 98/01/22 11:11:25 shannon 17 15
c use Class.getResource instead of ClassLoader.getResource, to make it
c work under Internet Explorer 4
e
s 00030/00024/00576
d D 1.13.1.1 98/01/20 14:36:39 bhc 16 14
c interum checkin
e
s 00209/00456/00144
d D 1.14 98/01/18 00:36:52 shannon 15 14
c significantly cleaned up and rewritten to properly handle the
c collection of databases
e
s 00054/00030/00546
d D 1.13 98/01/09 17:16:17 bhc 14 13
c last minute code review changes for javamail beta
e
s 00212/00035/00364
d D 1.12 97/12/18 13:21:10 bhc 13 12
c fixed file separator bug, now correctly open java/lib/mailcap, not .mailcap, getPreferredCommands now works, getCommand, and getAllCommands now correctly fall back correctly in cases they don't find the commands in mailcap file, 
e
s 00017/00031/00382
d D 1.11 97/12/16 14:48:32 bhc 12 11
c fixed ID 4099195, use File.separator, mailcap_contents bug
e
s 00014/00010/00399
d D 1.10 97/12/09 13:59:43 bhc 11 10
c fixed a null check when reading the mc file
c 
e
s 00012/00012/00397
d D 1.9 97/12/09 10:34:33 bhc 10 9
c removed excess debug output, made createDCH method public
e
s 00194/00130/00215
d D 1.8 97/12/05 16:08:08 bhc 9 8
c update semantics to spec.
c add constructor that takes an InputStream
c clean up
c 
e
s 00068/00055/00277
d D 1.7 97/12/02 09:49:55 bhc 8 7
c updated for new API's
e
s 00020/00012/00312
d D 1.6 97/10/13 16:18:09 bhc 7 6
c minor bug fix to getAllCmds, javadoc fix
c 
e
s 00004/00000/00320
d D 1.5 97/10/13 14:16:58 bhc 6 5
c implemented wildcards
c 
e
s 00120/00069/00200
d D 1.4 97/10/13 11:27:18 bhc 5 4
c updated to implement partially complete updated semantics and use new MailcapFile class
e
s 00011/00003/00258
d D 1.3 97/10/06 10:55:48 bhc 4 3
c change to reflect name change from 'DefaultCommandMap'
e
s 00064/00012/00197
d D 1.2 97/09/29 14:18:11 bhc 3 1
c reflect config file changes
e
s 00000/00000/00000
d R 1.2 97/09/05 16:22:25 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 3 2 src/share/classes/javax/activation/MailcapCommandMap.java
c Name history : 2 1 src/classes/javax/activation/MailcapCommandMap.java
c Name history : 1 0 src/classes/javax/activation/DefaultCommandMap.java
e
s 00209/00000/00000
d D 1.1 97/09/05 16:22:24 bhc 1 0
c date and time created 97/09/05 16:22:24 by bhc
e
u
U
f e 0
t
T
I 1
/*
D 23
 * %W% %E%
E 23
I 23
D 24
 * @(#)MailcapCommandMap.java	1.19 98/02/06
E 24
I 24
D 29
 * %W%	%E%
E 29
I 29
 * %W% %E%
E 29
E 24
E 23
D 15
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 15
I 15
 *
D 24
 * Copyright (c) 1997-1998 Sun Microsystems, Inc. All Rights Reserved.
E 24
I 24
D 29
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 24
 *
E 15
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 15
 * 
E 15
I 15
 *
E 15
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 15
 * 
 * 
E 15
I 15
 *
 *
E 29
I 29
D 30
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 30
I 30
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
E 30
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 29
E 15
 */


package javax.activation;

D 8
import java.beans.BeanInfo;
E 8
I 8
D 9
// import java.beans.BeanInfo;
E 8
import java.beans.SimpleBeanInfo;
import java.beans.BeanDescriptor;
E 9
D 15
import java.util.Vector;
I 5
import java.util.Hashtable;
import java.util.Enumeration;
E 5
I 3
import java.io.InputStream;
I 9
import java.io.ByteArrayOutputStream;
E 9
import java.io.IOException;
I 9
import java.io.FileInputStream;
I 12
import java.io.File;
I 16
import java.io.FileNotFoundException;
E 16
E 15
I 15
import java.util.*;
import java.io.*;
I 30
import java.net.*;
E 30
E 15
E 12
E 9
E 3
import com.sun.activation.registries.MailcapFile;
D 28
import com.sun.activation.registries.MailcapEntry;
E 28

/**
D 9
 * This class implements the default command map for the JDK. It uses a 
 * <b>TBD</b> mechanism to map <code>MIME</code> types to java beans
E 9
I 9
D 23
 * The MailcapCommandMap is an implementation of the CommandMap
D 15
 * abstract class. It implements a CommandMap whose configuration 
E 15
I 15
 * abstract class. It implements a CommandMap whose configuration
E 23
I 23
D 24
 * The MailcapCommandMap implements the CommandMap
 * abstract class. It implements a CommandMap where its configuration
E 24
I 24
 * MailcapCommandMap extends the CommandMap
 * abstract class. It implements a CommandMap whose configuration
E 24
E 23
E 15
 * is based on mailcap files (RFC 1524). The MailcapCommandMap can
D 15
 * be configured both programmatically as well as via configuration 
 * files. 
E 15
I 15
D 23
 * be configured both programmatically as well as via configuration
E 23
I 23
 * be configured both programmatically and via configuration
E 23
 * files.
E 15
 * <p>
I 22
 * <b>Mailcap file search order:</b><p>
E 22
D 15
 * The MailcapCommandMap looks in various places in the user's 
 * system for mailcap file entries. When requests are made 
E 15
I 15
 * The MailcapCommandMap looks in various places in the user's
 * system for mailcap file entries. When requests are made
E 15
D 23
 * to search for commands in the MailcapCommandMap, the
D 15
 * following search order is used. 
E 15
I 15
 * following search order is used.
E 23
I 23
 * to search for commands in the MailcapCommandMap, it searches  
 * mailcap files in the following order:
E 23
E 15
 * <p>
 * <ol>
D 15
 * <li> programatically added entries to the MailcapCommandMap instance.
 * <li> The mailcap file in the user's home directory
 * <li> The mailcap file in the java.home's <i>lib</i> directory
D 14
 * <li> The mailcap file in the ClassLoader.getResource("mailcap")
E 14
I 14
 * <li> The mailcap file in the ClassLoader.getResource("META-INF/mailcap")
E 14
 * <li> The mailcap file getSystemResource("META-INF/mailcap.default");
E 15
I 15
 * <li> Programatically added entries to the MailcapCommandMap instance.
D 24
 * <li> The mailcap file in the user's home directory.
 * <li> The mailcap file in the java.home's <i>lib</i> directory.
D 18
 * <li> The mailcap file in the resource "META-INF/mailcap".
 * <li> The mailcap file in the resource "META-INF/mailcap.default".
E 18
I 18
 * <li> The mailcap file in the resource "/META-INF/mailcap".
 * <li> The mailcap file in the resource "/META-INF/mailcap.default".
E 24
I 24
 * <li> The file <code>.mailcap</code> in the user's home directory.
 * <li> The file &lt;<i>java.home</i>&gt;<code>/lib/mailcap</code>.
D 30
 * <li> The file or resource named <code>META-INF/mailcap</code>.
E 30
I 30
 * <li> The file or resources named <code>META-INF/mailcap</code>.
E 30
 * <li> The file or resource named <code>META-INF/mailcap.default</code>
 * (usually found only in the <code>activation.jar</code> file).
E 24
E 18
E 15
 * </ol>
I 22
 * <p>
 * <b>Mailcap file format:</b><p>
E 22
 *
I 22
D 23
 * As mentioned above, mailcap files must conform to the mailcap
E 23
I 23
 * Mailcap files must conform to the mailcap
E 23
D 24
 * file (RFC 1524, <i>A User Agent Configuration Mechanism
 * For Multimedia Mail Format Information</i>) specification. 
D 23
 * The basic format of the file consists of entries corresponding to
 * particular MIME types. The general spirit of the specification 
 * is to specify <i>applications</i> for clients to use when they
E 23
I 23
 * File format consists of entries corresponding to
E 24
I 24
 * file specification (RFC 1524, <i>A User Agent Configuration Mechanism
 * For Multimedia Mail Format Information</i>). 
 * The file format consists of entries corresponding to
E 24
 * particular MIME types. In general, the specification 
 * specifies <i>applications</i> for clients to use when they
E 23
 * themselves cannot operate on the specified MIME type. The 
D 23
 * MailcapCommandMap extends this by using the parameter mechanism
 * in mailcap files to allow JavaBeans(tm) to be specified as corresponding
E 23
I 23
 * MailcapCommandMap extends this specification by using a parameter mechanism
D 24
 * in mailcap files that allows JavaBeans(tm) to be specified as corresponding
E 23
 * to particular commands for a MIME type.<p>
E 24
I 24
 * in mailcap files that allows JavaBeans(tm) components to be specified as
 * corresponding to particular commands for a MIME type.<p>
E 24
 *
 * When a mailcap file is
 * parsed, the MailcapCommandMap recognizes certain parameter signatures,
 * specifically those parameter names that begin with <code>x-java-</code>.
 * The MailcapCommandMap uses this signature to find
D 23
 * command entries for inclusion into it's registries.
E 23
I 23
 * command entries for inclusion into its registries.
E 23
 * Parameter names with the form <code>x-java-&lt;name></code>
 * are read by the MailcapCommandMap as identifying a command
 * with the name <i>name</i>. When the <i>name</i> is <code>
 * content-handler</code> the MailcapCommandMap recognizes the class
 * signified by this parameter as a <i>DataContentHandler</i>.
 * All other commands are handled generically regardless of command 
 * name. The command implementation is specified by a fully qualified
D 23
 * class name of a JavaBean(tm). So a command for viewing some data
 * might be specified as: <code>x-java-view=com.foo.ViewBean</code>.<p>
E 23
I 23
D 24
 * class name of a JavaBean(tm). For example; a command for viewing some data
 * can be specified as: <code>x-java-view=com.foo.ViewBean</code>.<p>
E 24
I 24
 * class name of a JavaBean(tm) component. For example; a command for viewing
 * some data can be specified as: <code>x-java-view=com.foo.ViewBean</code>.<p>
E 24
E 23
 * 
D 23
 * MailcapCommandMap aware mailcap files have the general 
E 23
I 23
 * MailcapCommandMap aware mailcap files have the 
E 23
 * following general form:<p>
 * <code>
 * # Comments begin with a '#' and continue to the end of the line.<br>
 * &lt;mime type>; ; &lt;parameter list><br>
 * # Where a parameter list consists of one or more parameters,<br>
 * # where parameters look like: x-java-view=com.sun.TextViewer<br>
 * # and a parameter list looks like: <br>
 * text/plain; ; x-java-view=com.sun.TextViewer; x-java-edit=com.sun.TextEdit
 * <br>
 * # Note that mailcap entries that do not contain 'x-java' parameters<br>
 * # and comply to RFC 1524 are simply ignored:<br>
 * image/gif; /usr/dt/bin/sdtimage %s<br>
 *
 * </code>
 * <p>
 *
E 22
I 15
 * @author Bart Calder
 * @author Bill Shannon
E 15
E 9
 */

D 4
public class DefaultCommandMap extends CommandMap {
E 4
I 4
public class MailcapCommandMap extends CommandMap {
E 4
D 15
    // Variables -- 
    private boolean DEBUG = false;
E 15
I 15
    /*
D 30
     * We manage up to 5 databases, searched in order.
E 30
I 30
     * We manage a collection of databases, searched in order.
E 30
     * The default database is shared between all instances
     * of this class.
     * XXX - Can we safely share more databases between instances?
     */
    private static MailcapFile defDB = null;
D 30
    private MailcapFile[] DB = new MailcapFile[5];
E 30
I 30
    private MailcapFile[] DB;
E 30
    private static final int PROG = 0;	// programmatically added entries
D 30
    private static final int HOME = 1;	// the user's home directory
    private static final int SYS = 2;	// the system file
    private static final int JAR = 3;	// the app's entry in the jar file
    private static final int DEF = 4;	// the default entry in our jar file
E 30
E 15

I 26
    private static boolean debug = false;

    static {
	try {
	    debug = Boolean.getBoolean("javax.activation.debug");
	} catch (Throwable t) {
	    // ignore any errors
	}
    }


E 26
D 9
    // registry
E 9
I 9
D 15
    // registries
    private MailcapFile programmaticDB = null; // y
    private MailcapFile usersMailcapDB = null; // y
    //    private MailcapFile systemMailcapDB = null; // 
    private MailcapFile javaHomeMailcapDB = null; // y
    private MailcapFile clMailcapDB = null; 
E 9
    private static MailcapFile systemCmdsDB = null;
D 9
    private MailcapFile instanceCmdsDB = null;
E 9
I 9


    // registry

    //    private MailcapFile programmaticDB = null;
E 15
E 9
    /**
D 15
     * The default Constructor, use the <i>system</i> (as provided by the
     * JDK) mailcap equivelant.
     *
E 15
I 15
     * The default Constructor.
E 15
     */
D 3
    public DefaultCommandMap()
	{
E 3
I 3
D 4
    public DefaultCommandMap(){
E 4
I 4
D 15
    public MailcapCommandMap(){
E 4
	
E 15
I 15
    public MailcapCommandMap() {
E 15
	super();
I 30
	Vector dbv = new Vector(5);	// usually 5 or less databases
	MailcapFile mf = null;
	dbv.addElement(null);		// place holder for PROG entry

E 30
I 26
	if (debug)
	    System.out.println("MailcapCommandMap: load HOME");
E 26
D 15
	
D 9
	if(systemCmdsDB == null){
	    InputStream is = java.lang.ClassLoader.getSystemResourceAsStream(
						          "META-INF/mailcap");
	    byte[] data = null;
	    int bytes_read = 0;
	    String mailcap_contents = null;
E 9
I 9
D 12
	String platform_sep = null;
E 12
	String mailcap_contents = null;
	
D 12
	try {
	    platform_sep = System.getProperty("file.separator");
	} catch(SecurityException e) {
	    e.printStackTrace();
	}
E 12
	// read mailcap file in the user's home directory
	
	// first construct the path to the user's home dir:
	
	String user_home = null;
E 15
I 15
	try {
	    String user_home = System.getProperty("user.home");
E 15
E 9
E 3
D 16

D 3
	    super();
E 3
I 3
D 9
	    try {
		while(bytes_read != -1) {
		    int len = 1024;
		    byte[] chunk = new byte[len];
E 9
I 9
D 15
	user_home = System.getProperty("user.home");
E 16
	
I 16
	try {
	    user_home = System.getProperty("user.home");
	} catch(SecurityException e){ 
	    user_home = null; // will cause the code to skip reading in mc
	}
E 16
D 10
	System.out.println("------------------user home----------------");
E 10
I 10
D 14
	// System.out.println("------------------user home----------------");
E 14
I 14
	//	 System.out.println("------------------user home----------------");
E 14
E 10
	
	if(user_home != null) {
D 12
	    String path = user_home + platform_sep + ".mailcap";
E 12
I 12
	    String path = user_home + File.separator + ".mailcap";
E 12
	    try{
		FileInputStream fis = new FileInputStream(path);
D 11
		
		mailcap_contents = streamToString(fis);
		usersMailcapDB = new MailcapFile();
		usersMailcapDB.appendToMailcap(mailcap_contents);
E 11
I 11
		if(fis != null) {
		    mailcap_contents = streamToString(fis);
		    usersMailcapDB = new MailcapFile();
		    usersMailcapDB.appendToMailcap(mailcap_contents);
		}
E 11
D 10
		System.out.println("home dir mailcap =" + mailcap_contents);
E 10
I 10
		// System.out.println("home dir mailcap =" + mailcap_contents);
E 10
D 14
	    } catch(Exception e) {
E 14
I 14
D 16
	    } catch(IOException e) {
E 14
D 10
		e.printStackTrace();
E 10
I 10
		//	e.printStackTrace();
E 15
I 15
	    if (user_home != null) {
		String path = user_home + File.separator + ".mailcap";
D 30
		DB[HOME] = loadFile(path);
E 30
I 30
		mf = loadFile(path);
		if (mf != null)
		    dbv.addElement(mf);
E 30
E 15
E 10
	    }
D 15
	    
E 16
I 16
	} catch(FileNotFoundException e1){}
	catch(IOException e){}
	catch(SecurityException e2){}
	
E 16
	}
D 10
	System.out.println("------------------system home----------------");
E 10
I 10
D 14
	// System.out.println("------------------system home----------------");
E 14
I 14
	//System.out.println("------------------system home----------------");
E 15
I 15
	} catch (SecurityException ex) {}
E 15
E 14
E 10
E 9
E 3

I 26
	if (debug)
	    System.out.println("MailcapCommandMap: load SYS");
E 26
D 3
	    if(systemCmdsDB == null)
		systemCmdsDB = new MailcapFile( 
				      System.getProperty("java.home") +
				      System.getProperty("file.separator") +
				      "lib" +
				      System.getProperty("file.separator") +
				      "jdk_mailcap.properties" 
				      );
E 3
I 3
D 9
		    bytes_read = is.read(chunk, 0, chunk.length);
		    
		    if(bytes_read == -1)
			break;
E 9
I 9
D 15
	// check system's home
D 16
	String system_mailcap = System.getProperty("java.home") +
D 12
	    platform_sep + "lib" + platform_sep + ".mailcap";
E 12
I 12
D 13
	    File.separator + "lib" + File.separator + ".mailcap";
E 13
I 13
	    File.separator + "lib" + File.separator + "mailcap";
E 13
E 12
	try{
	    FileInputStream fis = new FileInputStream(system_mailcap);
D 11
	    
	    mailcap_contents = streamToString(fis);
	    javaHomeMailcapDB = new MailcapFile();
	    javaHomeMailcapDB.appendToMailcap(mailcap_contents);
E 11
I 11
	    if(fis != null){
		mailcap_contents = streamToString(fis);
		javaHomeMailcapDB = new MailcapFile();
		javaHomeMailcapDB.appendToMailcap(mailcap_contents);
	    }
E 11
D 10
	    System.out.println("java home dir mailcap =" + mailcap_contents);
E 10
I 10
D 12
	    // System.out.println("java home dir mailcap =" + mailcap_contents);
E 10
	} catch(Exception e) {
	    //  e.printStackTrace();
D 10
	    System.out.println("debug: no java_home .mailcap");
E 10
I 10
	    // System.out.println("debug: no java_home .mailcap");
E 10
	}
E 12
I 12
D 14
	} catch(Exception e) { }
E 14
I 14
	} catch(IOException e) { }
E 15
I 15
	try {
	    // check system's home
	    String system_mailcap = System.getProperty("java.home") +
		File.separator + "lib" + File.separator + "mailcap";
D 30
	    DB[SYS] = loadFile(system_mailcap);
E 30
I 30
	    mf = loadFile(system_mailcap);
	    if (mf != null)
		dbv.addElement(mf);
E 30
	} catch (SecurityException ex) {}
E 15
E 14
E 12
E 9

I 26
	if (debug)
	    System.out.println("MailcapCommandMap: load JAR");
E 26
E 16
I 16
	try {
	    String system_mailcap = System.getProperty("java.home") +
		File.separator + "lib" + File.separator + "mailcap";
	    try{
		FileInputStream fis = new FileInputStream(system_mailcap);
		if(fis != null){
		    mailcap_contents = streamToString(fis);
		    javaHomeMailcapDB = new MailcapFile();
		    javaHomeMailcapDB.appendToMailcap(mailcap_contents);
		}
	    } catch(IOException e) { }
	} catch(SecurityException e){}
	
E 16
D 9
		    if(data == null){
E 9
I 9
D 10
	System.out.println("------------------class loader----------------");
E 10
I 10
D 14
	// System.out.println("------------------class loader----------------");
E 14
I 14
D 15
	//System.out.println("------------------class loader----------------");
E 15
I 15
	// load from the app's jar file
D 18
	DB[JAR] = loadResource("META-INF/mailcap");
E 18
I 18
D 30
	DB[JAR] = loadResource("/META-INF/mailcap");
E 30
I 30
	loadAllResources(dbv, "META-INF/mailcap");
E 30
E 18
E 15
E 14
E 10
E 9

I 26
	if (debug)
	    System.out.println("MailcapCommandMap: load DEF");
E 26
I 9
D 15
	// try the class loader's getResource
E 15
I 15
	synchronized (MailcapCommandMap.class) {
	    // see if another instance has created this yet.
	    if (defDB == null)
D 18
		defDB = loadResource("META-INF/mailcap.default");
E 18
I 18
		defDB = loadResource("/META-INF/mailcap.default");
E 18
	}

D 30
	DB[DEF] = defDB;
E 30
I 30
	if (defDB != null)
	    dbv.addElement(defDB);

	DB = new MailcapFile[dbv.size()];
	dbv.copyInto(DB);
E 30
    }

I 30
    private static final void pr(String s) {
	System.out.println(s);
    }

E 30
    /**
     * Load from the named resource.
     */
    private MailcapFile loadResource(String name) {
I 30
	InputStream clis = null;
E 30
E 15
D 17
	ClassLoader cl = this.getClass().getClassLoader();
D 14
	if(cl != null) { // null would mean system CL
D 13
	    InputStream is = cl.getResourceAsStream(".mailcap");
E 13
I 13
	    InputStream is = cl.getResourceAsStream("mailcap");
E 13
	    try {
D 11
		mailcap_contents = streamToString(is);
E 11
I 11
D 12
		if(is != null)
E 12
I 12
		if(is != null) {
E 12
		    mailcap_contents = streamToString(is);
I 12
		    clMailcapDB = new MailcapFile();
		    clMailcapDB.appendToMailcap(mailcap_contents);
		}
E 12
E 11
	    } catch (IOException e) {
		e.printStackTrace();
	    }
E 14
I 14
	InputStream clis = null;
D 15
	if(cl != null) // null would mean system CL
	    clis = cl.getResourceAsStream("META-INF/mailcap");
E 15
I 15
	MailcapFile mtf = null;

	if (cl != null) // null would mean system CL
	    clis = cl.getResourceAsStream(name);
E 15
	else
D 15
	    clis = ClassLoader.getSystemResourceAsStream("META-INF/mailcap");
E 15
I 15
	    clis = ClassLoader.getSystemResourceAsStream(name);
E 15
E 14
D 12
	    clMailcapDB = new MailcapFile();
	    clMailcapDB.appendToMailcap(mailcap_contents);
D 10
	    System.out.println("cl mailcap = " + mailcap_contents);
E 10
I 10
	    // System.out.println("cl mailcap = " + mailcap_contents);
E 12
E 10
E 9

E 17
I 14
	try {
I 17
D 30
	    InputStream clis = this.getClass().getResourceAsStream(name);
E 17
D 15
	    if(clis != null) {
		mailcap_contents = streamToString(clis);
		clMailcapDB = new MailcapFile();
		clMailcapDB.appendToMailcap(mailcap_contents);
	    }
E 15
I 15
	    if (clis != null)
D 17
		mtf = new MailcapFile(clis);
E 17
I 17
		return new MailcapFile(clis);
E 30
I 30
	    clis = SecuritySupport.getInstance().
		    getResourceAsStream(this.getClass(), name);
	    if (clis != null) {
		MailcapFile mf = new MailcapFile(clis);
		if (debug)
		    pr("MailcapCommandMap: successfully loaded mailcap file: " +
			name);
		return mf;
	    } else {
		if (debug)
		    pr("MailcapCommandMap: not loading mailcap file: " + name);
	    }
E 30
E 17
E 15
	} catch (IOException e) {
D 15
	    e.printStackTrace();
E 15
I 15
D 25
	    //e.printStackTrace();
E 25
I 25
D 30
	    // e.printStackTrace();
E 30
I 30
	    if (debug)
		pr("MailcapCommandMap: " + e);
	} catch (SecurityException sex) {
	    if (debug)
		pr("MailcapCommandMap: " + sex);
	} finally {
	    try {
		if (clis != null)
		    clis.close();
	    } catch (IOException ex) { }	// ignore it
E 30
E 25
E 15
E 14
D 9
			data = new byte[bytes_read];
			System.arraycopy(chunk,
					 0,
					 data,
					 0,
					 bytes_read);
E 9
I 9
	}
I 14
D 15
	
	
E 15
I 15
D 17
	return mtf;
E 17
I 17
	return null;
E 17
    }
E 15
E 14
E 9

I 30
    /**
     * Load all of the named resource.
     */
    private void loadAllResources(Vector v, String name) {
	boolean anyLoaded = false;
	try {
	    URL[] urls;
	    ClassLoader cld = null;
	    // First try the "application's" class loader.
	    cld = SecuritySupport.getInstance().getContextClassLoader();
	    if (cld == null)
		cld = this.getClass().getClassLoader();
	    if (cld != null)
		urls = SecuritySupport.getInstance().getResources(cld, name);
	    else
		urls = SecuritySupport.getInstance().getSystemResources(name);
	    if (urls != null) {
		if (debug)
		    pr("MailcapCommandMap: getResources");
		for (int i = 0; i < urls.length; i++) {
		    URL url = urls[i];
		    InputStream clis = null;
		    if (debug)
			pr("MailcapCommandMap: URL " + url);
		    try {
			clis = SecuritySupport.getInstance().openStream(url);
			if (clis != null) {
			    v.addElement(new MailcapFile(clis));
			    anyLoaded = true;
			    if (debug)
				pr("MailcapCommandMap: successfully loaded " +
				    "mailcap file from URL: " +
				    url);
			} else {
			    if (debug)
				pr("MailcapCommandMap: not loading mailcap " +
				    "file from URL: " + url);
			}
		    } catch (IOException ioex) {
			if (debug)
			    pr("MailcapCommandMap: " + ioex);
		    } catch (SecurityException sex) {
			if (debug)
			    pr("MailcapCommandMap: " + sex);
		    } finally {
			try {
			    if (clis != null)
				clis.close();
			} catch (IOException cex) { }
		    }
		}
	    }
	} catch (Exception ex) {
	    if (debug)
		pr("MailcapCommandMap: " + ex);
	}

	// if failed to load anything, fall back to old technique, just in case
	if (!anyLoaded) {
	    if (debug)
		pr("MailcapCommandMap: !anyLoaded");
	    MailcapFile mf = loadResource("/" + name);
	    if (mf != null)
		v.addElement(mf);
	}
    }

E 30
D 9
		    } else {
			byte[] tmp = new byte[data.length + bytes_read];
E 9
I 9
D 10
	System.out.println("------------------JAR file----------------");
E 10
I 10
D 14
	// System.out.println("------------------JAR file----------------");
E 14
I 14
D 15
	//System.out.println("------------------JAR file----------------");
E 15
I 15
    /**
     * Load from the named file.
     */
    private MailcapFile loadFile(String name) {
	MailcapFile mtf = null;
E 15
E 14
E 10
E 9

D 9
			System.arraycopy(data,
					 0,
					 tmp,
					 0,
					 data.length);
E 9
I 9
D 15
	// read mailcap getSystemResource("META-INF/mailcap.default");
	if(systemCmdsDB == null){
	    InputStream is = java.lang.ClassLoader.getSystemResourceAsStream(
D 14
						          "META-INF/mailcap");
E 14
I 14
						          "META-INF/mailcap.default");
E 14
	    try {
D 11
		mailcap_contents = streamToString(is);
E 11
I 11
D 12
		if(is != null)
E 12
I 12
		if(is != null) {
E 12
		    mailcap_contents = streamToString(is);
E 11
D 12
	    } catch (IOException e) {
D 10
		e.printStackTrace();
E 10
I 10
		// e.printStackTrace();
E 10
	    }
E 9

D 9
			System.arraycopy(chunk,
					0,
					tmp,
					data.length - 1,
					bytes_read);
			data = tmp;
		    }
			
		}
		
	    } catch(IOException e) {}

	    mailcap_contents = new String(data);
D 5
	    
E 5
I 5
	    // System.out.println("mailcap contents = " + mailcap_contents);
E 9
E 5
	    systemCmdsDB = new MailcapFile(); 
	    systemCmdsDB.appendToMailcap(mailcap_contents);
I 9
D 10
	    System.out.println("system mailcap =" + mailcap_contents);
E 10
I 10
	    // System.out.println("system mailcap =" + mailcap_contents);
E 10

E 12
I 12
		    systemCmdsDB = new MailcapFile(); 
		    systemCmdsDB.appendToMailcap(mailcap_contents);
		}
	    } catch (IOException e) { }
	    
E 15
I 15
	try {
D 26
	    FileInputStream fis = new FileInputStream(name);
	    if (fis != null)
		mtf = new MailcapFile(fis);
E 26
I 26
	    mtf = new MailcapFile(name);
E 26
D 25
	} catch(IOException e) {
E 25
I 25
	} catch (IOException e) {
E 25
	    //	e.printStackTrace();
E 15
E 12
E 9
D 5
					   // 					   System.getProperty("java.home") +
// 					   System.getProperty("file.separator") +
// 					   "lib" +
// 					   System.getProperty("file.separator") +
// 					   "jdk_mailcap.properties" 
// 					   );
E 5
E 3
	}
I 15
	return mtf;
E 15
I 3
    }
E 3
D 15
    
E 15
I 15

E 15
    /**
D 19
     * Constructor to specify a specific <i>mailcap</i>.
E 19
I 19
     * Constructor that allows the caller to specify the path
     * of a <i>mailcap</i> file.
E 19
     *
     * @param fileName The name of the <i>mailcap</i> file to open
     */
D 4
    public DefaultCommandMap(String mailcapFileName)
E 4
I 4
D 15
    public MailcapCommandMap(String mailcapFileName)
E 4
	{
E 15
I 15
D 19
    public MailcapCommandMap(String fileName) {
E 19
I 19
D 21
    public MailcapCommandMap(String fileName) throw IOException {
E 21
I 21
    public MailcapCommandMap(String fileName) throws IOException {
E 21
E 19
	this();
E 15
D 16

I 26
	if (debug)
	    System.out.println("MailcapCommandMap: load PROG from " + fileName);
E 26
E 16
D 5
	    super(); // do the super ctor
E 5
I 5
D 15
	    this(); // do the super ctor
E 5
	    
D 5
	    if(systemCmdsDB == null)
		systemCmdsDB = new MailcapFile( mailcapFileName );
E 5
I 5
D 9
	    if(instanceCmdsDB == null)
		instanceCmdsDB = new MailcapFile( mailcapFileName );
E 9
I 9
D 16
	    if(programmaticDB == null)
		programmaticDB = new MailcapFile( mailcapFileName );
E 9
E 5
	    
E 16
I 16
	    try {
		if(programmaticDB == null)
		    programmaticDB = new MailcapFile( mailcapFileName );
	    } catch(FileNotFoundException e) {
		programmaticDB = null;
	    }
E 16
E 15
I 15
	if (DB[PROG] == null) {
D 19
	    try {
		DB[PROG] = new MailcapFile(fileName);
	    } catch (IOException ex) {
		// XXX - should throw it
	    }
E 19
I 19
	    DB[PROG] = new MailcapFile(fileName);
E 19
E 15
	}
I 15
    }
E 15
I 9

I 19

E 19
    /**
D 19
     * Constructor to specify a specific <i>mailcap</i>.
E 19
I 19
     * Constructor that allows the caller to specify an <i>InputStream</i>
     * containing a mailcap file.
E 19
     *
D 15
     * @param InputStream of the <i>mailcap</i> file to open
E 15
I 15
     * @param is	InputStream of the <i>mailcap</i> file to open
E 15
     */
D 15
    public MailcapCommandMap(InputStream is)
	{
E 15
I 15
    public MailcapCommandMap(InputStream is) {
	this();
E 15

I 26
	if (debug)
	    System.out.println("MailcapCommandMap: load PROG");
E 26
D 15
	    this(); // do the super ctor
	    
	    if(programmaticDB == null)
		programmaticDB = new MailcapFile();
	    
E 15
I 15
	if (DB[PROG] == null) {
E 15
	    try {
D 15
		programmaticDB.appendToMailcap( streamToString(is));
D 14
	    } catch(Exception e) { }
E 14
I 14
	    } catch(IOException e) { }
E 14
	    
E 15
I 15
		DB[PROG] = new MailcapFile(is);
	    } catch (IOException ex) {
		// XXX - should throw it
	    }
E 15
	}
I 15
    }
E 15

    /**
D 15
     * Convert an inputstream into a string
     */
    private String streamToString(InputStream is) throws IOException {
	int bytes_read = 0;
	byte buf[] = new byte[4096];
	ByteArrayOutputStream baos = new ByteArrayOutputStream();
	
	while((bytes_read = is.read(buf)) > 0) 
	    baos.write(buf, 0, bytes_read);

	String new_str = baos.toString();

	return new_str;
	    
    }
E 9
     
    /**
E 15
D 19
     * Get preferred command list from a MIME Type.
E 19
I 19
D 23
     * Get preferred command list from a MIME Type. The MailcapCommandMap
E 23
I 23
D 24
     * Get the preferred command list from a MIME Type. The MailcapCommandMap
E 23
     * iterates through the mailcap files described by the search order
D 23
     * described at the top of the page.<p>
E 23
I 23
     * described in the MailcapCommandMap class description, under <i>Mailcap File
     * Search Order</i>.<p>
E 24
I 24
     * Get the preferred command list for a MIME Type. The MailcapCommandMap
     * searches the mailcap files as described above under
     * <i>Mailcap file search order</i>.<p>
E 24
E 23
E 19
D 5
     *
E 5
I 5
D 15
     * NOTE: This method is not fully implemented for the Preview
     * Release, it will return the same value as getAllCommands.
     * 
E 5
D 16
     * @return the BeanInfo classes the represent the command Beans.
E 15
I 13
     *
I 19
D 24
     * The net result of the search is a proper subset of available
E 24
I 24
     * The result of the search is a proper subset of available
E 24
     * commands in all mailcap files known to this instance of 
D 24
     * MailcapCommandMap.
E 24
I 24
     * MailcapCommandMap.  The first entry for a particular command
     * is considered the preferred command.
E 24
     *
I 27
     * @param mimeType	the MIME type
E 27
E 19
E 16
D 15
     * @return returns the CommandInfo objects representing all the commands.
     */        
    public CommandInfo[] getPreferredCommands(String mimeType) {
      Hashtable instCmdList = null;
      Hashtable sysCmdList = null;
      CommandInfo cmdInfos[] = null;
      Vector cmdVector = new Vector();
 
      // first try the programmatic
      if(programmaticDB != null) {
	  // System.out.println("instanceMCF not null");
	  instCmdList = programmaticDB.getMailcapList(mimeType);
	  if(instCmdList != null) {
	      appendPrefCmdsToVector(instCmdList, cmdVector);
	  }
      }
E 15
I 15
     * @return the CommandInfo objects representing the preferred commands.
     */
    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
	Vector cmdVector = new Vector();
E 15

D 15
      // then try the user's home dir
      if(usersMailcapDB != null) {
	  // System.out.println("instanceMCF not null");
	  instCmdList = usersMailcapDB.getMailcapList(mimeType);
	  if(instCmdList != null) {
	      appendPrefCmdsToVector(instCmdList, cmdVector);
	  }
      }
      
      // then try the java.home/lib/mailcap
      if(javaHomeMailcapDB != null) {
	  // System.out.println("instanceMCF not null");
	  instCmdList = javaHomeMailcapDB.getMailcapList(mimeType);
	  if(instCmdList != null) {
	      appendPrefCmdsToVector(instCmdList, cmdVector);
	  }
      }
E 15
I 15
	for (int i = 0; i < DB.length; i++) {
	    if (DB[i] == null)
		continue;
	    Hashtable cmdList = DB[i].getMailcapList(mimeType);
	    if (cmdList != null)
		appendPrefCmdsToVector(cmdList, cmdVector);
	}
E 15

D 15
      // then try the cl mailcap
      if(clMailcapDB != null) {
	  // System.out.println("instanceMCF not null");
	  instCmdList = clMailcapDB.getMailcapList(mimeType);
	  if(instCmdList != null) {
	      appendPrefCmdsToVector(instCmdList, cmdVector);
	  }
      }
      
E 15
I 15
	CommandInfo[] cmdInfos = new CommandInfo[cmdVector.size()];
	cmdVector.copyInto(cmdInfos);
E 15

D 15
      // the user will go here!!!
      // then the system
      if(systemCmdsDB != null) {
	  // System.out.println("systemMCF not null");
	  sysCmdList = systemCmdsDB.getMailcapList(mimeType);
	  if(sysCmdList != null) {
	      appendPrefCmdsToVector(sysCmdList, cmdVector);
	  }
      } 
      
      cmdInfos = new CommandInfo[cmdVector.size()];
      cmdVector.copyInto(cmdInfos);

      return cmdInfos; // for now...
E 15
I 15
	return cmdInfos;
E 15
    }

    /**
D 15
     * Put the commands that are in the hash table, into the 
     * vector.
E 15
I 15
     * Put the commands that are in the hash table, into the vector.
E 15
E 13
     */
D 8
    public BeanInfo[] getPreferredCommands(String mimeType)// REMIND throws Exception;
	{
D 5
	    BeanInfo binfos[] = null;
E 5
	    
D 5
	    //	jcm, 6/26/97: only check the instance list if it exists
	    Vector instance_cmd_list = null;
	    if(instanceCmdsDB != null)
	    {
		    instance_cmd_list = instanceCmdsDB.getMailcapList(mimeType);
		}
	    Vector cmd_list = systemCmdsDB.getMailcapList(mimeType);
	    int size = 0;
E 5
I 5
	    return this.getAllCommands(mimeType);
	}
E 8
I 8
D 13
    public CommandInfo[] getPreferredCommands(String mimeType){
	return this.getAllCommands(mimeType);
E 13
I 13
D 15
    private void appendPrefCmdsToVector(Hashtable typeHash, Vector cmdList){
E 15
I 15
    private void appendPrefCmdsToVector(Hashtable typeHash, Vector cmdList) {
E 15
	Enumeration verb_enum = typeHash.keys();

D 15
	while(verb_enum.hasMoreElements()){
E 15
I 15
	while (verb_enum.hasMoreElements()) {
E 15
	    String verb = (String)verb_enum.nextElement();
D 15
	    if(!checkForVerb(cmdList,verb)){
E 15
I 15
D 25
	    if (!checkForVerb(cmdList,verb)) {
E 25
I 25
	    if (!checkForVerb(cmdList, verb)) {
E 25
E 15
		Vector cmdVector = (Vector)typeHash.get(verb); // get the list
		String className = (String)cmdVector.firstElement();
		cmdList.addElement(new CommandInfo(verb, className));
	    }
	}
E 13
    }
I 13

E 13
E 8
    /**
I 13
D 15
     * check the cmdVector to see if this command exists, return
     * true if the verb is there
E 15
I 15
     * Check the cmdVector to see if this command exists, return
     * true if the verb is there.
E 15
     */
    private boolean checkForVerb(Vector cmdVector, String verb) {
	Enumeration enum = cmdVector.elements();
D 15
	while(enum.hasMoreElements()){
	    String enum_verb = (String)((CommandInfo)enum.nextElement()).getCommandName();
	    if(enum_verb.equals(verb))
E 15
I 15
D 25
	while (enum.hasMoreElements()){
E 25
I 25
	while (enum.hasMoreElements()) {
E 25
	    String enum_verb =
		(String)((CommandInfo)enum.nextElement()).getCommandName();
	    if (enum_verb.equals(verb))
E 15
		return true;
	}
	return false;
    }
I 15

E 15
    /**
E 13
D 19
     * Get all the available commands for this type.
E 19
I 19
     * Get all the available commands in all mailcap files known to
D 24
     * this instance of MailcapCommandMap for this type.
E 24
I 24
     * this instance of MailcapCommandMap for this MIME type.
E 24
E 19
     *
I 27
     * @param mimeType	the MIME type
E 27
D 15
D 16
     * @return returns the BeanInfo objects representing all the commands.
E 16
I 16
     * @return returns the CommandInfo objects representing all the commands.
E 16
     */        
D 8
    public BeanInfo[] getAllCommands(String mimeType) {
E 8
I 8
    public CommandInfo[] getAllCommands(String mimeType) {
E 8
      Hashtable instCmdList = null;
      Hashtable sysCmdList = null;
D 8
      BeanInfo binfos[] = null;
      Enumeration instEnum = null;
      Enumeration sysEnum = null;
      int foundCmds = 0;
E 8
I 8
      CommandInfo cmdInfos[] = null;
      Vector cmdVector = new Vector();
D 12
      //       Enumeration instEnum = null;
      //       Enumeration sysEnum = null;
      //      int foundCmds = 0;
E 8
E 5

E 12
I 12
 
E 12
D 5
	    if(instance_cmd_list != null)
			size += instance_cmd_list.size();
	    
	    if(cmd_list != null)
		size += cmd_list.size();
	    
	    if(size > 0)
		binfos = new BeanInfo[size];
E 5
I 5
D 9
      // first try the instance
      if(instanceCmdsDB != null) {
E 9
I 9
      // first try the programmatic
      if(programmaticDB != null) {
E 9
	  // System.out.println("instanceMCF not null");
D 9
	  instCmdList = instanceCmdsDB.getMailcapList(mimeType);
E 9
I 9
	  instCmdList = programmaticDB.getMailcapList(mimeType);
E 9
	  if(instCmdList != null) {
D 8
	      // System.out.println("instance CMD's = " + instCmdList.size());
	      foundCmds += instCmdList.size();
	      instEnum = instCmdList.elements();
I 6
	  } 
	  else { // try wildcard
	      instCmdList = instanceCmdsDB.getMailcapList(mimeType);
	      
E 8
I 8
	      appendCmdsToVector(instCmdList, cmdVector);
E 8
E 6
	  }
      }
E 15
I 15
     * @return the CommandInfo objects representing all the commands.
     */
    public synchronized CommandInfo[] getAllCommands(String mimeType) {
	Vector cmdVector = new Vector();
E 15
D 7
	      
E 7
I 7

I 9
D 15
      // then try the user's home dir
      if(usersMailcapDB != null) {
	  // System.out.println("instanceMCF not null");
	  instCmdList = usersMailcapDB.getMailcapList(mimeType);
	  if(instCmdList != null) {
	      appendCmdsToVector(instCmdList, cmdVector);
	  }
      }
      
      // then try the java.home/lib/mailcap
      if(javaHomeMailcapDB != null) {
	  // System.out.println("instanceMCF not null");
	  instCmdList = javaHomeMailcapDB.getMailcapList(mimeType);
	  if(instCmdList != null) {
	      appendCmdsToVector(instCmdList, cmdVector);
	  }
      }
E 15
I 15
	for (int i = 0; i < DB.length; i++) {
	    if (DB[i] == null)
		continue;
	    Hashtable cmdList = DB[i].getMailcapList(mimeType);
	    if (cmdList != null)
		appendCmdsToVector(cmdList, cmdVector);
	}
E 15

D 15
      // then try the cl mailcap
      if(clMailcapDB != null) {
	  // System.out.println("instanceMCF not null");
	  instCmdList = clMailcapDB.getMailcapList(mimeType);
	  if(instCmdList != null) {
	      appendCmdsToVector(instCmdList, cmdVector);
	  }
      }
      
E 15
I 15
	CommandInfo[] cmdInfos = new CommandInfo[cmdVector.size()];
	cmdVector.copyInto(cmdInfos);
E 15

E 9
E 7
D 15
      // the user will go here!!!
      // then the system
      if(systemCmdsDB != null) {
	  // System.out.println("systemMCF not null");
	  sysCmdList = systemCmdsDB.getMailcapList(mimeType);
	  if(sysCmdList != null) {
D 8
	      // System.out.println("system CMD's = " + sysCmdList.size());
	      foundCmds += sysCmdList.size();
	      sysEnum = sysCmdList.elements();
E 8
I 8
	      appendCmdsToVector(sysCmdList, cmdVector);
E 8
	  }
      } 
D 7
      else 
	  // System.out.println("NO SYSTEM MCF");
E 5

E 7
D 5
	    // if 
	    if(DEBUG && (cmd_list != null ))
		System.out.println("Found: " + cmd_list.toString());
E 5
I 5
      
E 5
D 7

E 7
D 5
	    if(instance_cmd_list != null)
		{
		    for(int i = 0; i < instance_cmd_list.size(); i++)
			{
			    binfos[i] = 
				new DefaultBeanInfo(
               ((MailcapEntry)instance_cmd_list.elementAt(i)).getExecutable());
			}
E 5
I 5
D 8
      if(foundCmds == 0) // if none were found
	  return null; // return null
E 8
I 8
D 9
//       if(foundCmds == 0) // if none were found
// 	  return null; // return null
E 8
E 5

D 5
		}
E 5
I 5
D 8
      // now unroll them into the array
      binfos = new BeanInfo[foundCmds];
E 8
I 8
//       // now unroll them into the array
//       cmdinfos = new CommandInfo[foundCmds];
E 8
      
D 7
      if(instEnum != null)
E 7
I 7
D 8
      if(instEnum != null) {
	  int tally = 0;
E 7
	  while(instEnum.hasMoreElements()) {
	      Vector v = (Vector)instEnum.nextElement();
D 7
	      for(int i = 0; i < v.size(); i++) 
		  binfos[i] = new DefaultBeanInfo((String)v.elementAt(i));
E 7
I 7
	      for(int i = 0; i < v.size(); i++) {
		  binfos[i + tally] = new DefaultBeanInfo((String)v.elementAt(i));
	      }
	      ++tally;
E 7
	  }
E 5
D 7

I 5
      if(sysCmdList != null)
E 7
I 7
      }
      if(sysCmdList != null) {
	  int tally = 0;
E 7
	  while(sysEnum.hasMoreElements()) {
	      Vector v = (Vector)sysEnum.nextElement();
D 7
	      for(int i = 0; i < v.size(); i++)
		  binfos[i +  instCmdList.size()] = new DefaultBeanInfo((String)v.elementAt(i));
E 7
I 7
	      for(int i = 0; i < v.size(); i++) {
		  if(instCmdList != null)
		      binfos[i +  instCmdList.size() + tally] = 
			  new DefaultBeanInfo((String)v.elementAt(i));
		  else {
		      binfos[i + tally] = new DefaultBeanInfo((String)v.elementAt(i));
		  }
	      }
	      tally++;
E 7
	  }
I 7
      }
E 8
I 8
//       if(instEnum != null) {
// 	  int tally = 0;
// 	  while(instEnum.hasMoreElements()) {
// 	      Vector v = (Vector)instEnum.nextElement();
// 	      for(int i = 0; i < v.size(); i++) {
// 		  binfos[i + tally] = new DefaultBeanInfo((String)v.elementAt(i));
// 	      }
// 	      ++tally;
// 	  }
//       }
//       if(sysCmdList != null) {
// 	  int tally = 0;
// 	  while(sysEnum.hasMoreElements()) {
// 	      Vector v = (Vector)sysEnum.nextElement();
// 	      for(int i = 0; i < v.size(); i++) {
// 		  if(instCmdList != null)
// 		      binfos[i +  instCmdList.size() + tally] = 
// 			  new DefaultBeanInfo((String)v.elementAt(i));
// 		  else {
// 		      binfos[i + tally] = new DefaultBeanInfo((String)v.elementAt(i));
// 		  }
// 	      }
// 	      tally++;
// 	  }
//       }
E 9
      cmdInfos = new CommandInfo[cmdVector.size()];
      cmdVector.copyInto(cmdInfos);
E 8
E 7
E 5

D 5
	    if(cmd_list != null)
		{
		    for(int i = 0; i < cmd_list.size(); i++)
			{
			    binfos[i] = 
				new DefaultBeanInfo(
                ((MailcapEntry)cmd_list.elementAt(i)).getExecutable());
			}

		}
	    
	    return binfos;
	}
E 5
I 5
D 8
      return binfos; // for now...
E 8
I 8
      return cmdInfos; // for now...
E 15
I 15
	return cmdInfos;
E 15
E 8
    }
I 8

E 8
E 5
    /**
I 8
D 15
     * Put the commands that are in the hash table, into the 
     * vector.
E 15
I 15
     * Put the commands that are in the hash table, into the vector.
E 15
     */
D 25
    private void appendCmdsToVector(Hashtable typeHash, Vector cmdList){
E 25
I 25
    private void appendCmdsToVector(Hashtable typeHash, Vector cmdList) {
E 25
	Enumeration verb_enum = typeHash.keys();

D 15
	while(verb_enum.hasMoreElements()){
E 15
I 15
	while (verb_enum.hasMoreElements()) {
E 15
	    String verb = (String)verb_enum.nextElement();
	    Vector cmdVector = (Vector)typeHash.get(verb);
	    Enumeration cmd_enum = ((Vector)cmdVector).elements();
D 15
	    
	    while(cmd_enum.hasMoreElements()){
E 15
I 15

	    while (cmd_enum.hasMoreElements()) {
E 15
		String cmd = (String)cmd_enum.nextElement();
D 12
		cmdList.addElement(new CommandInfo(verb, cmd));
E 12
I 12
		// cmdList.addElement(new CommandInfo(verb, cmd));
		cmdList.insertElementAt(new CommandInfo(verb, cmd), 0);
E 12
	    }
	}
    }

    /**
E 8
D 5
     * Get all the available commands for this type.
     *
     * @return returns the BeanInfo objects representing all the commands.
     */        
    public BeanInfo[] getAllCommands(String mimeType) // REMIND throws Exception
	{
	    return this.getPreferredCommands(mimeType); // for now...
	}
    /**
E 5
D 15
     * Get the default <code>command</code> corresonding to the MIME type. 
E 15
I 15
D 24
     * Get the <code>command</code> corresponding to cmdName for the MIME type.
E 24
I 24
     * Get the command corresponding to <code>cmdName</code> for the MIME type.
E 24
E 15
     *
I 27
     * @param mimeType	the MIME type
     * @param cmdName	the command name
E 27
D 15
     * @return the Bean Info corresponding to the command.
E 15
I 15
     * @return the CommandInfo object corresponding to the command.
E 15
     */
D 5
    public BeanInfo getCommand(String mimeType,String cmdName) // REMIND thows Exception; 
	{
	    return null;
E 5
I 5
D 8
    public BeanInfo getCommand(String mimeType,String cmdName) {
E 8
I 8
D 15
    public CommandInfo getCommand(String mimeType,String cmdName) {
E 8
	Hashtable cmdList = null;
D 8
	BeanInfo binfo = null;
E 8
I 8
	CommandInfo cmdinfo = null;
E 8

	// first get the cmd hash for mimeType
	
	// first try the instance
D 9
	if(instanceCmdsDB != null)
	    cmdList = instanceCmdsDB.getMailcapList(mimeType);
E 9
I 9
D 13
	if(programmaticDB != null)
E 13
I 13
	if(programmaticDB != null){
E 13
	    cmdList = programmaticDB.getMailcapList(mimeType);
I 13
	    if(cmdList != null) {
		Vector v = (Vector)cmdList.get(cmdName); // get the cmd list for the cmd
		if(v != null) {
		    String cmdClassName = (String)v.firstElement();
		
		    if(cmdClassName != null)
			cmdinfo = new CommandInfo(cmdName, cmdClassName);
		}
	    }
	}
E 13
E 9
	
I 9
	// try user's home dir
D 13
	if(cmdList == null && usersMailcapDB != null)
E 13
I 13
	if(cmdinfo == null && usersMailcapDB != null){
E 13
	    cmdList = usersMailcapDB.getMailcapList(mimeType);
D 13

E 13
I 13
	    if(cmdList != null) {
E 15
I 15
    public synchronized CommandInfo getCommand(String mimeType,
							String cmdName) {
	for (int i = 0; i < DB.length; i++) {
	    if (DB[i] == null)
		continue;
	    Hashtable cmdList = DB[i].getMailcapList(mimeType);
	    if (cmdList != null) {
		// get the cmd list for the cmd
E 15
		Vector v = (Vector)cmdList.get(cmdName);
D 15
		if(v != null) {
E 15
I 15
		if (v != null) {
E 15
		    String cmdClassName = (String)v.firstElement();
D 15
		    
		    if(cmdClassName != null)
			cmdinfo = new CommandInfo(cmdName, cmdClassName);
E 15
I 15

		    if (cmdClassName != null)
			return new CommandInfo(cmdName, cmdClassName);
E 15
		}
	    }
	}
E 13
D 15
	// try java home lib dir
D 13
	if(cmdList == null && javaHomeMailcapDB != null)
E 13
I 13
	if(cmdinfo == null && javaHomeMailcapDB != null){
E 13
	    cmdList = javaHomeMailcapDB.getMailcapList(mimeType);
D 13

E 13
I 13
	    if(cmdList != null) {
		Vector v = (Vector)cmdList.get(cmdName);
		if(v != null) {
		    String cmdClassName = (String)v.firstElement();
		    
		    if(cmdClassName != null)
			cmdinfo = new CommandInfo(cmdName, cmdClassName);
		}
	    }
	}
	
E 13
	// try cl
D 13
	if(cmdList == null && clMailcapDB != null)
E 13
I 13
	if(cmdinfo == null && clMailcapDB != null){
E 13
	    cmdList = clMailcapDB.getMailcapList(mimeType);
D 13

E 9
	// the user will go here!!!
E 13
I 13
	    if(cmdList != null) {
		Vector v = (Vector)cmdList.get(cmdName);
		if(v != null) {
		    String cmdClassName = (String)v.firstElement();
		    if(cmdClassName != null)
			cmdinfo = new CommandInfo(cmdName, cmdClassName);
		}
	    }
	}
E 13
	// then the system
D 13
	if(cmdList == null) 
E 13
I 13
	if(cmdinfo == null) {
E 13
	    cmdList = systemCmdsDB.getMailcapList(mimeType);
D 13
	
	
	// do the work...
	if(cmdList != null) {
	    Vector v = (Vector)cmdList.get(cmdName); // get the cmd list for the cmd
	    
	    if(v != null) {
		String cmdClassName = (String)v.firstElement();
		
E 13
I 13
	    if(cmdList != null) {
		Vector v = (Vector)cmdList.get(cmdName);
		if(v != null) {
		    String cmdClassName = (String)v.firstElement();
E 13
		if(cmdClassName != null)
D 8
		    binfo = new DefaultBeanInfo(cmdClassName);
E 8
I 8
D 13
		  cmdinfo = new CommandInfo(cmdName, cmdClassName);
E 13
I 13
		    cmdinfo = new CommandInfo(cmdName, cmdClassName);
		}
E 13
E 8
	    }
E 5
	}
I 5
D 8
	return binfo; 
E 8
I 8
	return cmdinfo; 
E 15
I 15
	return null;
E 15
E 8
    }
I 15

E 15
E 5
    /**
D 15
     * addMailCap added entries to the registry which will be searched
     * before the default.
E 15
I 15
D 19
     * Add entries to the registry to be searched first.
E 19
I 19
D 23
     * Add entries to the registry. As mentioned above, 
     * programatically added entries will be searched before
     * any other entries.<p>
E 23
I 23
D 24
     * Add entries to the registry. Searches programatically 
     * added entries before any other entries.<p>
E 24
I 24
     * Add entries to the registry.  Programmatically 
     * added entries are searched before other entries.<p>
E 24
E 23
E 19
E 15
     *
I 19
     * The string that is passed in should be in mailcap
     * format.
     *
E 19
     * @param mail_cap a correctly formatted mailcap string
     */
D 5
    public void addMailCap(String mail_cap)
E 5
I 5
D 15
    public void addMailcap(String mail_cap)
E 5
	{
	    // check to see if one exists
D 9
	    if( instanceCmdsDB == null)
		instanceCmdsDB = new MailcapFile();
E 9
I 9
	    if( programmaticDB == null)
		programmaticDB = new MailcapFile();
E 15
I 15
    public synchronized void addMailcap(String mail_cap) {
	// check to see if one exists
I 26
	if (debug)
	    System.out.println("MailcapCommandMap: add to PROG");
E 26
	if (DB[PROG] == null)
	    DB[PROG] = new MailcapFile();
E 15
E 9

D 9
	    instanceCmdsDB.appendToMailcap( mail_cap );
E 9
I 9
D 15
	    programmaticDB.appendToMailcap( mail_cap );
E 9
	    
	}
E 15
I 15
	DB[PROG].appendToMailcap(mail_cap);
    }
E 15
I 4

E 4
    /**
I 4
D 15
     * Return the DCH referring to the MIME type
E 15
I 15
D 23
     * Return the DataContentHandler referring to the MIME type.
E 23
I 23
D 24
     * Return the DataContentHandler that refers to the MIME type.
E 24
I 24
     * Return the DataContentHandler for the specified MIME type.
I 27
     *
     * @param mimeType	the MIME type
     * @return		the DataContentHandler
E 27
E 24
E 23
E 15
     */
D 10
    DataContentHandler createDataContentHandler(String mimeType) {
E 10
I 10
D 15
    public DataContentHandler createDataContentHandler(String mimeType) {
E 10
D 5
	return null;
E 5
I 5
	Hashtable cmdList = null;
	Vector v = null;
	DataContentHandler dch = null;

	// first try the instance
D 9
	if(instanceCmdsDB != null)
	    cmdList = instanceCmdsDB.getMailcapList(mimeType);
E 9
I 9
D 13
	if(programmaticDB != null)
E 13
I 13
	if(programmaticDB != null){
E 13
	    cmdList = programmaticDB.getMailcapList(mimeType);
I 13
	    if(cmdList != null)
		v = (Vector)cmdList.get("content-handler");
	    
	    if(v != null) {
		try {
		    dch =  (DataContentHandler)Class.forName(
E 15
I 15
    public synchronized DataContentHandler createDataContentHandler(
							String mimeType) {
I 26
	if (debug)
	    System.out.println(
		"MailcapCommandMap: createDataContentHandler for " + mimeType);
E 26
	for (int i = 0; i < DB.length; i++) {
	    if (DB[i] == null)
		continue;
I 26
	    if (debug)
		System.out.println("  search DB #" + i);
E 26
	    Hashtable cmdList = DB[i].getMailcapList(mimeType);
	    if (cmdList != null) {
		Vector v = (Vector)cmdList.get("content-handler");
		if (v != null) {
I 26
		    if (debug)
			System.out.println("    got content-handler");
E 26
		    try {
I 26
			if (debug)
			    System.out.println("      class " +
						(String)v.firstElement());
E 26
			return (DataContentHandler)Class.forName(
E 15
				      (String)v.firstElement()).newInstance();
D 14
		} catch (Exception e) { e.printStackTrace(); }
	    
E 14
I 14
D 15
		} catch (IllegalAccessException e) {  }
		catch(ClassNotFoundException e){}
		catch(InstantiationException e){}
E 15
I 15
		    } catch (IllegalAccessException e) {
		    } catch (ClassNotFoundException e) {
		    } catch (InstantiationException e) {
		    }
		}
E 15
E 14
	    }
	}
E 13
E 9
D 15
	
	// the user will go here!!!
D 13
	// then the system
	if(cmdList == null) 
E 13
I 13
	if(dch == null && usersMailcapDB != null){
	    cmdList = usersMailcapDB.getMailcapList(mimeType);
	    if(cmdList != null)
		v = (Vector)cmdList.get("content-handler");
	    
	    if(v != null) {
		try {
		    dch =  (DataContentHandler)Class.forName(
				      (String)v.firstElement()).newInstance();
D 14
		} catch (Exception e) { e.printStackTrace(); }
E 14
I 14
	    } catch (IllegalAccessException e) { } 
	    catch(ClassNotFoundException e){}
	    catch(InstantiationException e){}
E 14
	    
	    }
	}
E 15
I 15
	return null;
    }
E 15

D 15
	// the java home will go here!!!
	if(dch == null && javaHomeMailcapDB != null){
	    cmdList = javaHomeMailcapDB.getMailcapList(mimeType);
	    if(cmdList != null)
		v = (Vector)cmdList.get("content-handler");
	    
	    if(v != null) {
		try {
		    dch =  (DataContentHandler)Class.forName(
D 14
				      (String)v.firstElement()).newInstance();
		} catch (Exception e) { e.printStackTrace(); }
	    
E 14
I 14
				     (String)v.firstElement()).newInstance();
		} catch (IllegalAccessException e) { } 
		catch(ClassNotFoundException e){}
		catch(InstantiationException e){}
E 14
	    }
	}
E 15
I 15
D 25
    // for debugging
D 22
    public static void main(String[] argv) throws Exception {
	MailcapCommandMap map = new MailcapCommandMap();
	CommandInfo[] cmdInfo;
E 22
I 22
    // I commented this out because JavaDocs were getting built for it!!! ;-) /bhc
//     public static void main(String[] argv) throws Exception {
// 	MailcapCommandMap map = new MailcapCommandMap();
// 	CommandInfo[] cmdInfo;
E 25
I 25
    /**
     * for debugging...
     *
    public static void main(String[] argv) throws Exception {
	MailcapCommandMap map = new MailcapCommandMap();
	CommandInfo[] cmdInfo;
E 25
E 22
E 15

D 15
	// the class loader will go here!!!
	if(dch == null && clMailcapDB != null){
	    cmdList = clMailcapDB.getMailcapList(mimeType);
	    if(cmdList != null)
		v = (Vector)cmdList.get("content-handler");
	    
	    if(v != null) {
		try {
		    dch =  (DataContentHandler)Class.forName(
				      (String)v.firstElement()).newInstance();
D 14
		} catch (Exception e) { e.printStackTrace(); }
	    
E 14
I 14
		} catch (IllegalAccessException e) { }
		catch(ClassNotFoundException e) {}
		catch (InstantiationException e) {  } 
E 14
	    }
	}

	// the system will go here!!!
	if(dch == null && systemCmdsDB != null){
E 13
	    cmdList = systemCmdsDB.getMailcapList(mimeType);
D 13
	
	if(cmdList != null)
	    v = (Vector)cmdList.get("content-handler");
E 13
I 13
	    if(cmdList != null)
		v = (Vector)cmdList.get("content-handler");
	    
	    if(v != null) {
		try {
		    dch =  (DataContentHandler)Class.forName(
D 14
				      (String)v.firstElement()).newInstance();
		} catch (Exception e) { e.printStackTrace(); }
E 14
I 14
				(String)v.firstElement()).newInstance();
	    } catch (InstantiationException e) {  } 
	    catch(IllegalAccessException e) {} 
	    catch(ClassNotFoundException e) {}
E 14
	    
	    }
	}
E 13

D 13
	if(v != null) {
	    try {
		dch =  (DataContentHandler)Class.forName(
				       (String)v.firstElement()).newInstance();
	    } catch (Exception e) { e.printStackTrace(); }
	}    
E 13
	return dch;
E 15
I 15
D 22
	cmdInfo = map.getPreferredCommands(argv[0]);
	System.out.println("Preferred Commands:");
	for (int i = 0; i < cmdInfo.length; i++)
	    System.out.println("Command " + cmdInfo[i].getCommandName() + " [" +
					cmdInfo[i].getCommandClass() + "]");
	cmdInfo = map.getAllCommands(argv[0]);
	System.out.println();
	System.out.println("All Commands:");
	for (int i = 0; i < cmdInfo.length; i++)
	    System.out.println("Command " + cmdInfo[i].getCommandName() + " [" +
					cmdInfo[i].getCommandClass() + "]");
	DataContentHandler dch = map.createDataContentHandler(argv[0]);
	if (dch != null)
	    System.out.println("DataContentHandler " +
						dch.getClass().toString());
	System.exit(0);
E 15
E 5
    }
E 22
I 22
D 25
// 	cmdInfo = map.getPreferredCommands(argv[0]);
// 	System.out.println("Preferred Commands:");
// 	for (int i = 0; i < cmdInfo.length; i++)
// 	    System.out.println("Command " + cmdInfo[i].getCommandName() + " [" +
// 					cmdInfo[i].getCommandClass() + "]");
// 	cmdInfo = map.getAllCommands(argv[0]);
// 	System.out.println();
// 	System.out.println("All Commands:");
// 	for (int i = 0; i < cmdInfo.length; i++)
// 	    System.out.println("Command " + cmdInfo[i].getCommandName() + " [" +
// 					cmdInfo[i].getCommandClass() + "]");
// 	DataContentHandler dch = map.createDataContentHandler(argv[0]);
// 	if (dch != null)
// 	    System.out.println("DataContentHandler " +
// 						dch.getClass().toString());
// 	System.exit(0);
//     }
E 25
I 25
	cmdInfo = map.getPreferredCommands(argv[0]);
	System.out.println("Preferred Commands:");
	for (int i = 0; i < cmdInfo.length; i++)
	    System.out.println("Command " + cmdInfo[i].getCommandName() + " [" +
					cmdInfo[i].getCommandClass() + "]");
	cmdInfo = map.getAllCommands(argv[0]);
	System.out.println();
	System.out.println("All Commands:");
	for (int i = 0; i < cmdInfo.length; i++)
	    System.out.println("Command " + cmdInfo[i].getCommandName() + " [" +
					cmdInfo[i].getCommandClass() + "]");
	DataContentHandler dch = map.createDataContentHandler(argv[0]);
	if (dch != null)
	    System.out.println("DataContentHandler " +
						dch.getClass().toString());
	System.exit(0);
    }
    */
E 25
E 22
D 9
        
    /**
E 4
     * DefaultBeanInfo class for beans that don't have a BeanInfo
     */
    class DefaultBeanInfo extends SimpleBeanInfo {
	String _className = null;
	/**
	 * The Constructor for SBI, pass the bean name.
	 *
	 * @param className The name of the bean's class.
	 */
	public DefaultBeanInfo(String className)
	    {
		super(); // call the default ctor first
		_className = className;
	    }
	/**
	 * Get the default Bean Descriptor
	 *
	 * @return The BeanDescriptor.
	 */
	public BeanDescriptor getBeanDescriptor ()
	    {
		Class beanClass = null;

		// this will have to be 'improved'

		try {
		    beanClass = java.lang.Class.forName(_className);
		} catch (ClassNotFoundException e)
		    {
D 3
			System.out.println("Sorry, can't find the class!");
E 3
I 3
D 5
			System.out.println("Sorry, can't find class: " + _className);
E 3
			System.exit(1);
E 5
I 5
			e.printStackTrace();
E 5
		    }
		
		// do some error checking? REMIND!
		return new BeanDescriptor(beanClass);
	    }
    }
E 9
I 9
D 15
       
E 15
E 9
}
D 15


I 14













E 14
I 9

E 9

E 15
E 1
