h60916
s 00006/00002/00220
d D 1.12 01/08/13 14:52:12 shannon 13 12
c workaround JDK 1.1.x compiler bug to fix 4488357
e
s 00005/00016/00217
d D 1.11 99/12/06 16:33:38 shannon 12 11
c Update copyright for SCSL release
e
s 00002/00002/00231
d D 1.10 99/05/21 13:49:18 shannon 11 10
c minor javadoc polish
e
s 00028/00000/00205
d D 1.9 99/05/11 09:20:04 shannon 10 9
c add missing javadoc @param and @return clauses
e
s 00060/00070/00145
d D 1.8 99/03/06 18:05:25 shannon 9 8
c clean up code and comments
e
s 00002/00002/00213
d D 1.7 98/02/06 15:26:45 bhc 8 7
c javadoc overhaul
e
s 00002/00002/00213
d D 1.6 98/01/23 11:04:26 bhc 7 6
c javadoc updates
e
s 00039/00008/00176
d D 1.5 98/01/22 13:39:43 bhc 6 5
c clean up javadocs
c 
e
s 00008/00001/00176
d D 1.4 97/10/28 13:51:33 bhc 5 4
c fixed getUPName bug, and mime type equals buf
e
s 00000/00011/00177
d D 1.3 97/10/13 16:18:21 bhc 4 3
c javadoc fix
c 
e
s 00001/00001/00187
d D 1.2 97/10/07 15:30:19 jmoore 3 1
c Fix to handle updated MimeType object.
e
s 00000/00000/00000
d R 1.2 97/10/06 11:08:15 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/ActivationDataFlavor.java
c Name history : 1 0 src/classes/javax/activation/ActivationDataFlavor.java
e
s 00188/00000/00000
d D 1.1 97/10/06 11:08:14 bhc 1 0
c date and time created 97/10/06 11:08:14 by bhc
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
D 9
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 9
I 9
 *
D 12
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 9
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 9
 * 
E 9
I 9
 *
E 9
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 9
 * 
 * 
E 9
I 9
 *
 *
E 12
I 12
D 13
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 13
I 13
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
E 13
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 12
E 9
 */

package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import javax.activation.MimeType;

/**
D 9
 * The ActivationDataFlavor is a special instance of the
 * java.awt.datatransfer.DataFlavor. It allows the JAF to 
E 9
I 9
D 11
 * The ActivationDataFlavor is a special subclass of
E 11
I 11
 * The ActivationDataFlavor class is a special subclass of
E 11
 * <code>java.awt.datatransfer.DataFlavor</code>. It allows the JAF to
E 9
 * set all three values stored by the DataFlavor class via a new
D 11
 * constructor as well as improved MIME parsing in the <code>equals
E 11
I 11
 * constructor. It also contains improved MIME parsing in the <code>equals
E 11
D 6
 * </code> method.
E 6
I 6
D 9
 * </code> method. Besides the improved parsing, it's semantics are
E 9
I 9
 * </code> method. Except for the improved parsing, its semantics are
E 9
 * identical to that of the JDK's DataFlavor class.
E 6
 */

public class ActivationDataFlavor extends DataFlavor {
D 9
    
E 9
I 9

E 9
    /*
     * Raison d'etre:
     *
     * The DataFlavor class included in JDK 1.1 has several limitations
     * including piss poor MIME type parsing, and the limitation of
D 9
     * only supporting serialized objects and InputStreams as 
E 9
I 9
     * only supporting serialized objects and InputStreams as
E 9
     * representation objects. This class 'fixes' that.
     */
D 9
  
    // I think for now I'll keep copies of all the variables and 
E 9
I 9

    // I think for now I'll keep copies of all the variables and
E 9
    // then later I may choose try to better coexist with the base
    // class *sigh*
    private String mimeType = null;
    private MimeType mimeObject = null;
    private String humanPresentableName = null;
    private Class representationClass = null;

    /**
     * Construct a DataFlavor that represents an arbitrary
D 6
     * Java object.
E 6
I 6
D 9
     * Java object. This constructor is an extension of the 
E 9
I 9
     * Java object. This constructor is an extension of the
E 9
     * JDK's DataFlavor in that it allows the explicit setting
     * of all three DataFlavor attributes.
E 6
     * <p>
     * The returned DataFlavor will have the following characteristics:
     * <p>
     * representationClass = representationClass<br>
     * mimeType            = mimeType<br>
     * humanName           = humanName
     * <p>
D 9
     * 
E 9
I 9
     *
E 9
     * @param representationClass the class used in this DataFlavor
     * @param mimeType the MIME type of the data represented by this class
     * @param humanPresentableName the human presentable name of the flavor
     */
    public ActivationDataFlavor(Class representationClass,
D 9
		      String mimeType,
		      String humanPresentableName) {

E 9
I 9
		      String mimeType, String humanPresentableName) {
E 9
	super(mimeType, humanPresentableName); // need to call super

	// init private variables:
	this.mimeType = mimeType;
	this.humanPresentableName = humanPresentableName;
	this.representationClass = representationClass;
    }

D 6
    /*
     * Mirror subclasses constructors:
E 6
I 6
D 7
    /* 
E 7
I 7
    /**
E 7
D 8
     * Construct a DataFlavor that represents a MimeType
E 8
I 8
     * Construct a DataFlavor that represents a MimeType.
E 8
D 9
     * <p> 
E 9
I 9
     * <p>
E 9
     * The returned DataFlavor will have the following characteristics:
D 9
     * <p> 
E 9
I 9
     * <p>
E 9
     * If the mimeType is "application/x-java-serialized-object;
D 9
     * class=", the result is the same as *calling new
     * DataFlavor(Class:forName() as above
E 9
I 9
     * class=", the result is the same as calling new
     * DataFlavor(Class.forName()) as above.
E 9
     * <p>
D 9
     * otherwise: 
E 9
I 9
     * otherwise:
E 9
     * <p>
     * representationClass = InputStream<p>
     * mimeType = mimeType<p>
I 10
     *
     * @param representationClass the class used in this DataFlavor
     * @param humanPresentableName the human presentable name of the flavor
E 10
E 6
     */
D 9
    public ActivationDataFlavor(Class representationClass, String humanPresentableName) {
	super(representationClass,humanPresentableName);
	this.mimeType = "application/x-java-serialized-object";
E 9
I 9
    public ActivationDataFlavor(Class representationClass,
				String humanPresentableName) {
	super(representationClass, humanPresentableName);
	this.mimeType = super.getMimeType();
E 9
	this.representationClass = representationClass;
      	this.humanPresentableName = humanPresentableName;
    }
D 9
    
E 9
I 9

E 9
I 6
D 7
    /*
E 7
I 7
    /**
E 7
D 8
     * Construct a DataFlavor that represents a MimeType 
E 8
I 8
     * Construct a DataFlavor that represents a MimeType.
E 8
     * <p>
D 9
     * The returned DataFlavor will have the following characteristics: 
E 9
I 9
     * The returned DataFlavor will have the following characteristics:
E 9
     * <p>
D 9
     * If the mimeType is "application/x-java-serialized-object; class=", 
     * the result is the same as calling new DataFlavor(Class:forName() as 
     * above otherwise: 
E 9
I 9
     * If the mimeType is "application/x-java-serialized-object; class=",
     * the result is the same as calling new DataFlavor(Class.forName()) as
     * above, otherwise:
E 9
     * <p>
     * representationClass = InputStream<p>
D 9
     * mimeType = mimeType 
E 9
I 9
     * mimeType = mimeType
I 10
     *
     * @param mimeType the MIME type of the data represented by this class
     * @param humanPresentableName the human presentable name of the flavor
E 10
E 9
     */
E 6
    public ActivationDataFlavor(String mimeType, String humanPresentableName) {
	super(mimeType, humanPresentableName);
	this.mimeType = mimeType;
D 9
	try {
	    this.representationClass = Class.forName("java.io.InputStream");
	} catch (Exception e) {}
E 9
I 9
D 13
	this.representationClass = java.io.InputStream.class;
E 13
I 13
	try {
	    this.representationClass = Class.forName("java.io.InputStream");
	} catch (ClassNotFoundException ex) {
	    // XXX - should never happen, ignore it
	}
E 13
E 9
      	this.humanPresentableName = humanPresentableName;
D 9
    }       
  
E 9
I 9
    }

E 9
    /**
D 6
     * Returns the MIME type string for this DataFlavor
     */
E 6
I 6
D 9
     * Returns the MIME type string for this DataFlavor */
E 6
    public String getMimeType(){
E 9
I 9
     * Return the MIME type for this DataFlavor.
I 10
     *
     * @return	the MIME type
E 10
     */
    public String getMimeType() {
E 9
	return mimeType;
    }

D 9
    /** 
     * Return the representation class
E 9
I 9
    /**
     * Return the representation class.
I 10
     *
     * @return	the representation class
E 10
E 9
     */
D 9
    public Class getRepresentationClass(){
E 9
I 9
    public Class getRepresentationClass() {
E 9
	return representationClass;
    }
I 5
D 9
    
E 9
I 9

E 9
    /**
D 9
     * Return the Human Presentable name
E 9
I 9
     * Return the Human Presentable name.
I 10
     *
     * @return	the human presentable name
E 10
E 9
     */
    public String getHumanPresentableName() {
	return humanPresentableName;
    }
E 5

    /**
D 9
     * set the human presentable name
E 9
I 9
     * Set the human presentable name.
I 10
     *
     * @param humanPresentableName	the name to set
E 10
E 9
     */
D 9
    public void setHumanPresentableName(String humanPresentableName){
E 9
I 9
    public void setHumanPresentableName(String humanPresentableName) {
E 9
	this.humanPresentableName = humanPresentableName;
    }

    /**
D 6
     * is the passed in DF equal to this DF?
E 6
I 6
D 9
     * Compares the DataFlavor passed in with this DataFlavor, calls
     * this.isMimeTypeEqual.
E 9
I 9
     * Compares the DataFlavor passed in with this DataFlavor; calls
     * the <code>isMimeTypeEqual</code> method.
I 10
     *
     * @param dataFlavor	the DataFlavor to compare with
     * @return			true if the MIME type and representation class
     *				are the same
E 10
E 9
E 6
     */
D 9
    public boolean equals(DataFlavor dataFlavor){
E 9
I 9
    public boolean equals(DataFlavor dataFlavor) {
E 9
	return (isMimeTypeEqual(dataFlavor) &&
	 	dataFlavor.getRepresentationClass() == representationClass);
    }
D 9
    
E 9
I 9

E 9
    /**
     * Is the string representation of the MIME type passed in equivalent
D 9
     * to the MIME type of this DataFlavor.  This may involve adding default
     * attributes for some MIME types (like adding charset=US-ASCII to
D 6
     * text/plain MIME types that have no charset parameter specified)
E 6
I 6
     * text/plain MIME types that have no charset parameter specified).<p>
E 9
I 9
     * to the MIME type of this DataFlavor. <p>
E 9
     *
     * ActivationDataFlavor delegates the comparison of MIME types to
     * the MimeType class included as part of the JavaBeans Activation
     * Framework. This provides a more robust comparison than is normally
     * available in the DataFlavor class.
I 10
     *
     * @param mimeType	the MIME type
     * @return		true if the same MIME type
E 10
E 6
D 4
     *
     * -=-=-=-=-=-=-=-=-=-=-=-=-=-==-=-=-
     * I'll fix this as soon as I have the MIME type class integrated!
     * --bhc
E 4
     */
    public boolean isMimeTypeEqual(String mimeType) {
	MimeType mt = null;
	try {
D 9
	    if(mimeObject == null)
E 9
I 9
	    if (mimeObject == null)
E 9
		mimeObject = new MimeType(this.mimeType);
D 9
	    
E 9
	    mt = new MimeType(mimeType);
D 3
	} catch (IOException e) {}
E 3
I 3
	} catch (MimeTypeParseException e) {}
E 3

D 5
	return mimeObject.equals(mt);
E 5
I 5
	return mimeObject.match(mt);
E 5
    }
D 9
    
    
E 9
I 9

E 9
    /**
     * Called on DataFlavor for every MIME Type parameter to allow DataFlavor
     * subclasses to handle special parameters like the text/plain charset
     * parameters, whose values are case insensitive.  (MIME type parameter
D 9
     * values are supposed to be case sensitive.
E 9
I 9
     * values are supposed to be case sensitive).
E 9
     * <p>
     * This method is called for each parameter name/value pair and should
D 9
     * return the normalized representation of the parameterValue
     *
E 9
I 9
     * return the normalized representation of the parameterValue.
I 10
     *
     * @param parameterName	the parameter name
     * @param parameterValue	the parameter value
     * @return			the normalized parameter value
E 10
E 9
D 4
     * -=-=-=-=-=-=-=-=-=-=-=-=-
     * This one will need to be fixed too
     *
E 4
     */
D 9
    protected String normalizeMimeTypeParameter(String parameterName, 
E 9
I 9
    protected String normalizeMimeTypeParameter(String parameterName,
E 9
						String parameterValue) {
D 9
	return parameterName+"="+parameterValue;	
E 9
I 9
	return parameterName+"="+parameterValue;
E 9
    }
D 9
    
E 9
I 9

E 9
    /**
     * Called for each MIME type string to give DataFlavor subtypes the
D 9
     * opportunity to change how the normalization of MIME types is accomplished.
E 9
I 9
     * opportunity to change how the normalization of MIME types is
     * accomplished.
E 9
     * One possible use would be to add default parameter/value pairs in cases
D 9
     * where none are present in the MIME type string passed in
E 9
I 9
     * where none are present in the MIME type string passed in.
I 10
     *
     * @param mimeType	the MIME type
     * @return		the normalized MIME type
E 10
E 9
D 4
     *
     * -=-=-=-=-=-=-=-=-=-=-=-=-
     * This one will need to be fixed too
     *
E 4
     */
    protected String normalizeMimeType(String mimeType) {
D 9
	return mimeType;	
E 9
I 9
	return mimeType;
E 9
    }
}
D 9




E 9
E 1
