h35705
s 00005/00016/00296
d D 1.6 99/12/06 16:33:33 shannon 7 6
c Update copyright for SCSL release
e
s 00012/00009/00300
d D 1.5 99/04/21 13:58:09 shannon 6 5
c add debugging; when reading an input stream, use iso-8859-1 - bug 4231750
e
s 00002/00010/00307
d D 1.4 98/02/12 13:24:43 bhc 5 4
c minor api change to correctly pass the exception up the stack
c 
e
s 00001/00001/00316
d D 1.3 98/01/21 07:53:35 bhc 4 3
c fixed bug that caused exception when blank line appeared in mailcap
e
s 00244/00197/00073
d D 1.2 98/01/18 00:42:58 shannon 3 1
c significant cleanup; parse both old and new format files
e
s 00000/00000/00000
d R 1.2 97/09/05 16:25:24 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/com/sun/activation/registries/MimeTypeFile.java
c Name history : 1 0 src/classes/com/sun/activation/registries/MimeTypeFile.java
e
s 00270/00000/00000
d D 1.1 97/09/05 16:25:23 bhc 1 0
c date and time created 97/09/05 16:25:23 by bhc
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
D 3
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 3
I 3
 *
D 6
 * Copyright (c) 1997-1998 Sun Microsystems, Inc. All Rights Reserved.
E 6
I 6
D 7
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 6
 *
E 3
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 3
 * 
E 3
I 3
 *
E 3
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 3
 * 
 * 
E 3
I 3
 *
 *
E 7
I 7
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 7
E 3
 */

package com.sun.activation.registries;

import java.io.*;
import java.util.*;

public class MimeTypeFile {
    private String fname = null;
D 3
    private Hashtable type_hash = null;
    private boolean DEBUG = false;
    
    ///////////////////////////////////////////////////////////////////////
E 3
I 3
    private Hashtable type_hash = new Hashtable();
    private static boolean DEBUG = false;

E 3
    /**
     * The construtor that takes a filename as an argument.
D 3
     * 
E 3
I 3
     *
E 3
     * @param new_fname The file name of the mime types file.
     */
D 3
    public MimeTypeFile(String new_fname)
	{
	    File mime_file = null;
	    FileInputStream fis = null;
	    
	    fname = new_fname; // remember the file name
	    
	    mime_file = new File(fname); // get a file object
	    
	    try {
		fis = new FileInputStream(mime_file);
	    }
	    catch(FileNotFoundException e)
		{
		    System.out.println("File: " + fname + " not found.");
		    // remind: create default table here
		    System.out.println("Use Defaults?");
		    e.printStackTrace();
		    System.exit(1);
		}
E 3
I 3
    public MimeTypeFile(String new_fname) throws IOException {
	File mime_file = null;
D 6
	FileInputStream fis = null;
E 6
I 6
	FileReader fr = null;
E 6
E 3

D 3
	    this.parseMIMEFile(fis);
	    try {
		fis.close(); // close it
	    } catch (IOException e)
		{
		    // oh well! REMIND:!
		}
	    
E 3
I 3
	fname = new_fname; // remember the file name
E 3

I 3
	mime_file = new File(fname); // get a file object

D 5
	try {
	    fis = new FileInputStream(mime_file);
	} catch (FileNotFoundException e) {
	    System.out.println("File: " + fname + " not found.");
	    // remind: create default table here
	    System.out.println("Use Defaults?");
	    e.printStackTrace();
	    System.exit(1);
E 3
	}
D 3
    ///////////////////////////////////////////////////////////////////////
E 3
I 3

E 5
I 5
D 6
	fis = new FileInputStream(mime_file);
	
E 5
	parse(new BufferedReader(new InputStreamReader(fis)));
E 6
I 6
	fr = new FileReader(mime_file);

E 6
	try {
D 6
	    fis.close(); // close it
	} catch (IOException e) {
	    // oh well! REMIND:!
E 6
I 6
	    parse(new BufferedReader(fr));
	} finally {
	    try {
		fr.close(); // close it
	    } catch (IOException e) {
		// ignore it
	    }
E 6
	}
    }

    public MimeTypeFile(InputStream is) throws IOException {
D 6
	parse(new BufferedReader(new InputStreamReader(is)));
E 6
I 6
	parse(new BufferedReader(new InputStreamReader(is, "iso-8859-1")));
E 6
    }

E 3
    /**
D 3
     * Creates an empty DB
E 3
I 3
     * Creates an empty DB.
E 3
     */
D 3
    public MimeTypeFile()
	{
	    // need one of these
	    type_hash = new Hashtable();
	}
    ///////////////////////////////////////////////////////////////////////
E 3
I 3
    public MimeTypeFile() {
    }

E 3
    /**
     * get the MimeTypeEntry based on the file extension
     */
D 3
    public MimeTypeEntry getMimeTypeEntry(String file_ext)
	{
	    return (MimeTypeEntry)type_hash.get((Object)file_ext);
	}
    ///////////////////////////////////////////////////////////////////////
E 3
I 3
    public MimeTypeEntry getMimeTypeEntry(String file_ext) {
	return (MimeTypeEntry)type_hash.get((Object)file_ext);
    }

E 3
    /**
D 3
     * 
E 3
I 3
     * Get the MIME type string corresponding to the file extension.
E 3
     */
D 3
    public String getMIMETypeString( String file_ext )
	{
	    MimeTypeEntry entry = this.getMimeTypeEntry( file_ext );
E 3
I 3
    public String getMIMETypeString(String file_ext) {
	MimeTypeEntry entry = this.getMimeTypeEntry(file_ext);
E 3

D 3
	    if( entry != null )
		return entry.getMIMEType();
	    else
		return null;
	}
    ///////////////////////////////////////////////////////////////////////
E 3
I 3
	if (entry != null)
	    return entry.getMIMEType();
	else
	    return null;
    }

E 3
    /**
     * Appends string of entries to the types registry, must be valid
D 3
     * .mime.types format:
     * Comment == "# <i>this part ignored</i>
     * Entry   == "mime type     file exts separated by spaces ' new line'
E 3
I 3
     * .mime.types format.
     * A mime.types entry is one of two forms:
E 3
     *
I 3
     *	type/subtype	ext1 ext2 ...
     * or
     *	type=type/subtype desc="description of type" exts=ext1,ext2,...
     *
E 3
     * Example:
     * # this is a test
     * audio/basic            au
     * text/plain             txt text
I 3
     * type=application/postscript exts=ps,eps
E 3
     */
D 3
    public void appendToRegistry(String mime_types)
	{
	    StringBuffer buffer = new StringBuffer( mime_types );
	    
	    parseBufferizedMIMEFile( buffer,
				     type_hash);
E 3
I 3
    public void appendToRegistry(String mime_types) {
	try {
	    parse(new BufferedReader(new StringReader(mime_types)));
	} catch (IOException ex) {
	    // can't happen
E 3
	}
D 3
     
    ///////////////////////////////////////////////////////////////////////
    /**
     * The method that parses the bits in the mailcap file.
     *
     * @param ins The InputStream the represents the file
     */
    private void parseMIMEFile(InputStream ins)
	{
	    StringBuffer file_contents = null;
E 3
I 3
    }
E 3

D 3
	    // bufferize the file contents
	    file_contents = this.bufferizeMIMEFile(ins);

	    // parse the bufferized file
	    type_hash = this.createMIMEFileHash(file_contents);

	    
	}
    ///////////////////////////////////////////////////////////////////////
E 3
    /**
D 3
     * create a hash table of MIME Type Entry Obj from a string buffer
E 3
I 3
     * Parse a stream of mime.types entries.
E 3
     */
D 3
    private Hashtable createMIMEFileHash(StringBuffer file_contents)
	{
	    Hashtable new_hash = new Hashtable();
	    
	    parseBufferizedMIMEFile(file_contents, new_hash);
	    
	    return new_hash;
E 3
I 3
    private void parse(BufferedReader buf_reader) throws IOException {
	String line = null, prev = null;
E 3

I 3
	while ((line = buf_reader.readLine()) != null) {
	    if (prev == null)
		prev = line;
	    else
		prev += line;
	    int end = prev.length();
D 4
	    if (prev.charAt(end - 1) == '\\') {
E 4
I 4
	    if (prev.length() > 0 && prev.charAt(end - 1) == '\\') {
E 4
		prev = prev.substring(0, end - 1);
		continue;
	    }
	    this.parseEntry(prev);
	    prev = null;
E 3
	}
D 3
    ///////////////////////////////////////////////////////////////////////
    /**
     * parse bufferized file into a hash table of MIME Type Entry Obj
     */
    private void parseBufferizedMIMEFile(StringBuffer file_contents,
					 Hashtable hash)
	{
	    // make a string reader
	    StringReader sins = new StringReader(file_contents.toString());
	    // make a buffered string reader to parse for us
	    BufferedReader buf_reader = new BufferedReader(sins);
	    String line_o_text = null;
	    boolean done = false;
E 3
I 3
	if (prev != null)
	    this.parseEntry(prev);
    }
E 3

D 3
	    try {
		while(buf_reader.ready() && !done)
		    {
			try {
			    line_o_text = buf_reader.readLine();
			} catch(IOException e)
			    {
				System.out.println(e);
			    }
			if(line_o_text != null) // empty line
			    this.parseMIMEFileLine(line_o_text, hash);
			else
			    done = true;
			
		    }
		} catch(IOException e)
		    {
			// REMIND: handle me better!
			System.out.println(e);
		    }

	}
    ///////////////////////////////////////////////////////////////////////
E 3
    /**
D 3
     * Parse of line of the file
E 3
I 3
     * Parse single mime.types entry.
E 3
     */
D 3
    private void parseMIMEFileLine(String line, Hashtable hash)
	{
	    String mime_type = null;
	    String file_ext = null;
	    String sub_string = new String(line.trim()); // create & trim
	    StringTokenizer strtok = new StringTokenizer(sub_string);
	    int num_tok;
	    //	    int next_space = 0;
	    //      int next_tab = 0;
E 3
I 3
    private void parseEntry(String line) {
	String mime_type = null;
	String file_ext = null;
	line = line.trim();
E 3

D 3
	    if(sub_string.length() == 0) // empty line...
		return; // BAIL!
E 3
I 3
	if (line.length() == 0) // empty line...
	    return; // BAIL!
E 3

D 3
	    // check to see if this is a comment line?
	    if(sub_string.charAt(0) == '#') 
		return; // then we are done!
E 3
I 3
	// check to see if this is a comment line?
	if (line.charAt(0) == '#')
	    return; // then we are done!
E 3

I 3
	// is it a new format line or old format?
	if (line.indexOf('=') > 0) {
	    // new format
	    LineTokenizer lt = new LineTokenizer(line);
	    while (lt.hasMoreTokens()) {
		String name = lt.nextToken();
		String value = null;
		if (lt.hasMoreTokens() && lt.nextToken().equals("=") &&
							lt.hasMoreTokens())
		    value = lt.nextToken();
		if (value == null) {
		    System.err.println("Bad .mime.types entry: " + line);
		    return;
		}
		if (name.equals("type"))
		    mime_type = value;
		else if (name.equals("exts")) {
		    StringTokenizer st = new StringTokenizer(value, ",");
		    while (st.hasMoreTokens()) {
			file_ext = st.nextToken();
			MimeTypeEntry entry =
				new MimeTypeEntry(mime_type, file_ext);
			type_hash.put(file_ext, entry);
			if (DEBUG)
			    System.out.println("Added: " + entry.toString());
		    }
		}
	    }
	} else {
	    // old format
E 3
	    // count the tokens
D 3
	    num_tok = strtok.countTokens();
E 3
I 3
	    StringTokenizer strtok = new StringTokenizer(line);
	    int num_tok = strtok.countTokens();
E 3

D 3
	    if(num_tok == 0) // empty line
E 3
I 3
	    if (num_tok == 0) // empty line
E 3
		return;
D 3
	    
E 3
I 3

E 3
	    mime_type = strtok.nextToken(); // get the MIME type

D 3
	    while(strtok.hasMoreTokens())
		{
		    MimeTypeEntry entry = null;
E 3
I 3
	    while (strtok.hasMoreTokens()) {
		MimeTypeEntry entry = null;
E 3

D 3
		    file_ext = strtok.nextToken();
		    entry = new MimeTypeEntry(mime_type, file_ext);
		    hash.put(file_ext, entry);
		    if(DEBUG)
			System.out.println("Added: " + entry.toString()); 
		}
	    
E 3
I 3
		file_ext = strtok.nextToken();
		entry = new MimeTypeEntry(mime_type, file_ext);
		type_hash.put(file_ext, entry);
		if (DEBUG)
		    System.out.println("Added: " + entry.toString());
	    }
E 3
	}
D 3
    ///////////////////////////////////////////////////////////////////////
E 3
I 3
    }

    // for debugging
    public static void main(String[] argv) throws Exception {
	DEBUG = true;
	MimeTypeFile mf = new MimeTypeFile(argv[0]);
	System.out.println("ext " + argv[1] + " type " +
						mf.getMIMETypeString(argv[1]));
	System.exit(0);
    }
}

class LineTokenizer {
    private int currentPosition;
    private int maxPosition;
    private String str;
    private Vector stack = new Vector();
    private static final String singles = "=";	// single character tokens

E 3
    /**
D 3
     * Bring file into memory
E 3
I 3
     * Constructs a tokenizer for the specified string.
     * <p>
E 3
     *
I 3
     * @param   str            a string to be parsed.
E 3
     */
D 3
    private StringBuffer bufferizeMIMEFile(InputStream ins)
	{
	    byte b_array[] = new byte[1024];
	    int available = 0;
	    int bytes_read = 0;
	    boolean done = false;
	    StringBuffer file_contents = new StringBuffer();
E 3
I 3
    public LineTokenizer(String str) {
	currentPosition = 0;
	this.str = str;
	maxPosition = str.length();
    }
E 3

D 3
	    while(!done)
		{
		    try {
			bytes_read = ins.read(b_array);
		    } catch(IOException e)
			{
			    // remind handle better
			    System.out.println(e);
			}
		    // append to the file contents
		    file_contents.append(new String(b_array, 0, 
						    bytes_read));
		
		    // check if there is still stuff to read
		    try {
			available = ins.available();
		    }
		    catch (IOException e)
			{
			    System.out.println(e);
			}
E 3
I 3
    /**
     * Skips white space.
     */
    private void skipWhiteSpace() {
	while ((currentPosition < maxPosition) &&
	       Character.isWhitespace(str.charAt(currentPosition))) {
	    currentPosition++;
	}
    }
E 3

D 3
		    // if not, we're done
		    if(available <= 0)
			done = true;
		}
E 3
I 3
    /**
     * Tests if there are more tokens available from this tokenizer's string.
     *
     * @return  <code>true</code> if there are more tokens available from this
     *          tokenizer's string; <code>false</code> otherwise.
     */
    public boolean hasMoreTokens() {
	if (stack.size() > 0)
	    return true;
	skipWhiteSpace();
	return (currentPosition < maxPosition);
    }
E 3

D 3
	    return file_contents;
E 3
I 3
    /**
     * Returns the next token from this tokenizer.
     *
     * @return     the next token from this tokenizer.
     * @exception  NoSuchElementException  if there are no more tokens in this
     *               tokenizer's string.
     */
    public String nextToken() {
	int size = stack.size();
	if (size > 0) {
	    String t = (String)stack.elementAt(size - 1);
	    stack.removeElementAt(size - 1);
	    return t;
E 3
	}
I 3
	skipWhiteSpace();
E 3

I 3
	if (currentPosition >= maxPosition) {
	    throw new NoSuchElementException();
	}

	int start = currentPosition;
	char c = str.charAt(start);
	if (c == '"') {
	    currentPosition++;
	    boolean filter = false;
	    while (currentPosition < maxPosition) {
		c = str.charAt(currentPosition++);
		if (c == '\\') {
		    currentPosition++;
		    filter = true;
		} else if (c == '"') {
		    String s;

		    if (filter) {
			StringBuffer sb = new StringBuffer();
			for (int i = start + 1; i < currentPosition - 1; i++) {
			    c = str.charAt(i);
			    if (c != '\\')
				sb.append(c);
			}
			s = sb.toString();
		    } else
			s = str.substring(start + 1, currentPosition - 1);
		    return s;
		}
	    }
	} else if (singles.indexOf(c) >= 0) {
	    currentPosition++;
	} else {
	    while ((currentPosition < maxPosition) && 
		   singles.indexOf(str.charAt(currentPosition)) < 0 &&
		   !Character.isWhitespace(str.charAt(currentPosition))) {
		currentPosition++;
	    }
	}
	return str.substring(start, currentPosition);
    }

    public void pushToken(String token) {
	stack.addElement(token);
    }
E 3
}
E 1
