h29913
s 00003/00003/00317
d D 1.10 02/02/12 10:16:55 shannon 11 10
c tolerate trailing semicolon
e
s 00005/00015/00315
d D 1.9 99/12/06 16:33:42 shannon 10 9
c Update copyright for SCSL release
e
s 00015/00000/00315
d D 1.8 99/05/11 09:20:05 shannon 9 8
c add missing javadoc @param and @return clauses
e
s 00147/00172/00168
d D 1.7 99/03/25 17:38:35 shannon 8 7
c significantly cleanup code
e
s 00002/00008/00338
d D 1.6 99/03/02 00:01:47 shannon 7 6
c properly skip white space at the end of a ContentType - bug 4141496
e
s 00058/00025/00288
d D 1.5 98/02/10 17:18:17 bhc 6 5
c minor javadoc tweaks
e
s 00006/00000/00307
d D 1.4 98/02/06 15:26:52 bhc 5 4
c javadoc overhaul
e
s 00008/00058/00299
d D 1.3 97/10/20 14:29:02 jmoore 4 3
c Clean up code in response to Bill's comments
e
s 00352/00250/00005
d D 1.2 97/10/20 10:42:49 jmoore 3 1
c Update MimeType to the latest code.
e
s 00000/00000/00000
d R 1.2 97/10/07 16:30:00 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/MimeTypeParameterList.java
c Name history : 1 0 src/classes/javax/activation/MimeTypeParameterList.java
e
s 00255/00000/00000
d D 1.1 97/10/07 15:29:59 jmoore 1 0
c First checked in.
e
u
U
f e 0
t
T
I 6
/*
 * %W% %E%
D 8
 * 
 * Copyright (c) 1997, 1998 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 8
I 8
 *
D 10
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 8
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 8
 * 
E 8
I 8
 *
E 8
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 8
 * 
 * 
E 8
I 8
 *
E 10
I 10
D 11
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 11
I 11
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
E 11
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 10
E 8
 */

D 8

E 8
E 6
I 1
D 3
package	javax.activation;
E 3
I 3
package javax.activation;
E 3

D 3
import	java.util.*;
E 3
I 3
import java.util.Hashtable;
D 4
import java.io.ObjectOutput;
import java.io.ObjectInput;
import java.io.IOException;
E 4
import java.util.Enumeration;
E 3

/**
D 3
 *	A class that represents an immutable list of parameters for a MimeType.
E 3
I 3
D 6
 * An object that encapsualtes the parameter list of a MimeType
 * as defined in RFC 2045 and 2046.
E 6
I 6
D 8
 * This object is used by javax.activation.MimeType. 
 * It parses the parameter list of a MimeType
E 8
I 8
 * A parameter list of a MimeType
E 8
 * as defined in RFC 2045 and 2046. The Primary type of the
D 8
 * object must already be stripped off. 
E 8
I 8
 * object must already be stripped off.
E 8
 *
 * @see javax.activation.MimeType
E 6
E 3
 */
D 3
public class	MimeTypeParameterList // implements java.util.Collection
{
	public	MimeTypeParameterList(Hashtable theParameters)
	{
		parameters = theParameters;
	}
	
	/**
	 * Returns the number of elements in this Collection.
	 */
	public int size()
	{
		return parameters.size();
	}
	
	/**
	 * Returns true if this Collection contains no elements.
	 */
	public boolean isEmpty()
	{
		return parameters.isEmpty();
	}
	
	/**
	 * Returns true if this Collection contains the specified element.  More
	 * formally, returns true if and only if this Collection contains at least
	 * one element <code>e</code> such that <code>e.equals(o)</code>.
	 *
	 * @param o element whose presence in this Collection is to be tested.
	 */
	public boolean contains(Object o)
	{
		boolean answer = false;
		
		if(o instanceof MimeTypeParameter)
		{
			MimeTypeParameter p = (MimeTypeParameter)o;
			
			String value = (String)parameters.get(p.getKey());
			
			answer = (value != null) && (p.getValue().equals(value));
		}
		
		return answer;
	}
	
	/**
	 * Returns an Iterator over the elements in this Collection.  There are
	 * no guarantees concerning the order in which the elements are returned
	 * (unless this Collection is an instance of some class that provides a
	 * guarantee).
	 */
	public MimeTypeParameterListIterator iterator()
	{
		return new MimeTypeParameterListIterator(parameters);
	}
	
	/**
	 * Returns an array containing all of the elements in this Collection.  If
	 * the Collection makes any guarantees as to what order its elements are
	 * returned by its Iterator, this method must return the elements in the
	 * same order.  The returned array will be "safe" in that no references to
	 * it are maintained by the Collection.  (In other words, this method must
	 * allocate a new array even if the Collection is backed by an Array).
	 * The caller is thus free to modify the returned array.
	 * <p>
	 * This method acts as bridge between array-based and Collection-based
	 * APIs.
	 */
	public Object[] toArray()
	{
		MimeTypeParameter[] parameterArray = new MimeTypeParameter[parameters.size()];
		
		MimeTypeParameterListIterator iter = new MimeTypeParameterListIterator(parameters);
		int index = 0;
		while(iter.hasNext())
		{
			parameterArray[index++] = (MimeTypeParameter)iter.next();
		}
		
		return parameterArray;
	}
	
	// Modification Operations
	
	/**
	* Ensures that this Collection contains the specified element. Returns
	* true if the Collection changed as a result of the call.  (Returns false
	* if this Collection does not permit duplicates and already contains the
	* specified element.)  Collections that support this operation may place
	* limitations on what elements may be added to the Collection.  In
	* particular, some Collections will refuse to add null elements, and
	* others will impose restrictions on the type of elements that may be
	* added.  Collection classes should clearly specify in their documentation
	* any restrictions on what elements may be added.  Optional operation.
	*
	* @param o element whose presence in this Collection is to be ensured.
	* @return true if the Collection changed as a result of the call.
	* @exception UnsupportedOperationException add is not supported by this
	*		  Collection.
	* @exception NullPointerException this Collection does not permit null
	* 		  elements, and the specified element is null.
	* @exception ClassCastException class of the specified element
	* 		  prevents it from being added to this Collection.
	* @exception IllegalArgumentException some aspect of this element prevents
	*		  it from being added to this Collection.
	* @since JDK1.2
	*/
	public boolean add(Object o)
	{
		throw new UnsupportedOperationException("MimeTypeParameterLists are immutable.");
	}
	
	/**
	 * Removes a single instance of the specified element from this
	 * Collection, if it is present.  More formally, removes an element
	 * <code>e</code> such that <code>e.equals(o)</code>, if the Collection
	 * contains one or more such elements.  Returns true if the Collection
	 * contained the specified element (or equivalently, if the Collection
	 * changed as a result of the call).  Optional operation.
	 *
	 * @param o element to be removed from this Collection, if present.
	 * @return true if the Collection contained the specified element.
	 * @exception UnsupportedOperationException remove is not supported
	 *		  by this Collection.
	 */
	public boolean remove(Object o)
	{
		throw new UnsupportedOperationException("MimeTypeParameterLists are immutable.");
	}
	
	
	// Bulk Modification Operations
	
	/**
	 * Adds all of the elements in the specified Collection to this
	 * Collection, in the order they are returned by the specified
	 * Collection's Iterator.  Implementers note: take
	 * care to ensure correct behavior in the case where the specified
	 * Collection is an alias of this Collection.  Optional operation.
	 *
	 * @exception UnsupportedOperationException addAll is not supported
	 * 		  by this Collection.
	 * @exception NullPointerException this Collection does not permit null
	 * 		  elements and one of the elements of <code>c</code> is null.
	 * @exception ClassCastException class of the specified element
	 * 		  prevents it from being added to this Collection.
	 * @exception IllegalArgumentException some aspect of the specified
	 *		  element prevents it from being added to this Collection.
	 * @see Alias
	 */
	public void addAll(MimeTypeParameterList c)
	{
		throw new UnsupportedOperationException("MimeTypeParameterLists are immutable.");
	}
	
	/**
	 * Removes all of the elements from this Collection.  The Collection will
	 * be empty after this call returns (unless it throws an exception).
	 * Optional operation.
	 *
	 * @exception UnsupportedOperationException clear is not supported
	 *		  by this Collection.
	 * @see add
	 * @see Alias
	 */
	public void clear()
	{
		throw new UnsupportedOperationException("MimeTypeParameterLists are immutable.");
	}
	
	// Comparison and hashing
	
	/**
	 * Compares the specified Object with this Collection for equality.
	 * While Collection adds no stipulations to the general contract for
	 * Object.equals, programmers who impelement Collection "directly" (in
	 * other words, create a class that is a Collection but is not a Set or a
	 * List) must exercise care if they choose to override Object.equals.  It
	 * is not necessary do so, and the simplest course of action is to rely
	 * on Object's implementation, but the implementer may wish to implement
	 * a "value comparison" in place of the default "reference comparison."
	 * (Lists and Sets mandate such value comparisons.)
	 *
	 * The general contract for Object.equals states that equals
	 * must be reflexive (in other words, <code>a.equals(b)</code> if and only
	 * if <code>b.equals(a)</code>).  The contracts for List.equals and
	 * Set.equals state that Lists are only equal to other Lists, and
	 * Sets to other Sets.  Thus, a custom equals method for a Collection
	 * that is neither a List nor a Set must return false when this
	 * Collection is compared to any List or Set.
	 *
	 * @param o Object to be compared for equality with this Collection.
	 * @return true if the specified Object is equal to this Collection.
	 * @see Object.equals
	 * @see Set.equals
	 * @see List.equals
	 */
	public boolean equals(Object o)
	{
		boolean answer = super.equals(o);
		
		if(!answer && (o instanceof MimeTypeParameterList))
		{
			MimeTypeParameterList theList = (MimeTypeParameterList)o;
			
			int count = parameters.size();
			
			if (count != theList.size())
			{
				answer = false;
			}
			else
			{
				Enumeration keys = parameters.keys();
				while(keys.hasMoreElements())
				{
					String myKey = (String)keys.nextElement();
					String myValue = (String)parameters.get(myKey);
					String theirValue = (String)theList.parameters.get(myKey);
					
					answer = myValue.equals(theirValue);
				}
			}
		}
		
		return answer;
	}
	
	/**
	 * Returns the hash code value for this Collection.  While Collection
	 * adds no stipulations to the general contract for Object.hashCode,
	 * programmers should take note that any class that overrides
	 * Object.equals must also override Object.hashCode, in order to satisfy
	 * the general contract for Object.hashCode.  In particular,
	 * <code>c1.equals(c2)</code> implies that
	 * <code>c1.hashCode()==c2.hashCode()</code>.
	 *
	 * @see Object.hashCode
	 * @see Object.equals
	 */
	public int hashCode()
	{
		return parameters.hashCode();
	}
	
	private Hashtable parameters;
E 3
I 3
D 4
public class MimeTypeParameterList implements java.io.Externalizable {
E 4
I 4
public class MimeTypeParameterList {
E 4
D 6

E 6
I 6
    private Hashtable parameters;
D 8
    
E 8
I 8

E 8
E 6
    /**
I 8
     * A string that holds all the special chars.
     */
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";


    /**
E 8
     * Default constructor.
     */
    public MimeTypeParameterList() {
        parameters = new Hashtable();
    }

I 5
    /**
     * Constructs a new MimeTypeParameterList with the passed in data.
I 9
     *
E 9
I 6
     * @param parameterList an RFC 2045, 2046 compliant parameter list.
E 6
     */
E 5
D 6
    public MimeTypeParameterList(String rawdata) throws MimeTypeParseException {
E 6
I 6
D 8
    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
E 8
I 8
    public MimeTypeParameterList(String parameterList)
					throws MimeTypeParseException {
E 8
E 6
        parameters = new Hashtable();
D 8
        
E 8
I 8

E 8
        //    now parse rawdata
D 6
        parse(rawdata);
E 6
I 6
        parse(parameterList);
E 6
    }
D 8
    
E 8
I 8

E 8
    /**
     * A routine for parsing the parameter list out of a String.
I 6
     *
     * @param parameterList an RFC 2045, 2046 compliant parameter list.
E 6
     */
D 6
    protected void parse(String rawdata) throws MimeTypeParseException {
        int length = rawdata.length();
E 6
I 6
    protected void parse(String parameterList) throws MimeTypeParseException {
D 8
        int length = 0;
	if(parameterList != null)
	    length = parameterList.length();
E 8
I 8
	if (parameterList == null)
	    return;
E 8

E 6
D 8
        if(length > 0) {
D 6
            int currentIndex = skipWhiteSpace(rawdata, 0);
E 6
I 6
            int currentIndex = skipWhiteSpace(parameterList, 0);
E 6
            int lastIndex = 0;
            
            if(currentIndex < length) {
D 6
                char currentChar = rawdata.charAt(currentIndex);
E 6
I 6
                char currentChar = parameterList.charAt(currentIndex);
E 6
                while ((currentIndex < length) && (currentChar == ';')) {
                    String name;
                    String value;
                    boolean foundit;
                    
                    //    eat the ';'
                    ++currentIndex;
                    
                    //    now parse the parameter name
                    
                    //    skip whitespace
D 6
                    currentIndex = skipWhiteSpace(rawdata, currentIndex);
E 6
I 6
                    currentIndex = skipWhiteSpace(parameterList, currentIndex);
E 6
                    
                    if(currentIndex < length) {
                        //    find the end of the token char run
                        lastIndex = currentIndex;
D 6
                        currentChar = rawdata.charAt(currentIndex);
E 6
I 6
                        currentChar = parameterList.charAt(currentIndex);
E 6
                        while((currentIndex < length) && isTokenChar(currentChar)) {
                            ++currentIndex;
D 6
                            currentChar = rawdata.charAt(currentIndex);
E 6
I 6
                            currentChar = parameterList.charAt(currentIndex);
E 6
                        }
D 6
                        name = rawdata.substring(lastIndex, currentIndex).toLowerCase();
E 6
I 6
                        name = parameterList.substring(lastIndex, currentIndex).toLowerCase();
E 6
                        
                        //    now parse the '=' that separates the name from the value
                        
                        //    skip whitespace
D 6
                        currentIndex = skipWhiteSpace(rawdata, currentIndex);
E 6
I 6
                        currentIndex = skipWhiteSpace(parameterList, 
						      currentIndex);
E 6
                        
D 6
                        if((currentIndex < length) && (rawdata.charAt(currentIndex) == '='))  {
E 6
I 6
                        if((currentIndex < length) && 
			   (parameterList.charAt(currentIndex) == '='))  {
E 6
                            //    eat it and parse the parameter value
                            ++currentIndex;
                            
                            //    skip whitespace
D 6
                            currentIndex = skipWhiteSpace(rawdata, currentIndex);
E 6
I 6
                            currentIndex = skipWhiteSpace(parameterList, currentIndex);
E 6
                            
                            if(currentIndex < length) {
                                //    now find out whether or not we have a quoted value
D 6
                                currentChar = rawdata.charAt(currentIndex);
E 6
I 6
                                currentChar = parameterList.charAt(currentIndex);
E 6
                                if(currentChar == '"') {
                                    //    yup it's quoted so eat it and capture the quoted string
                                    ++currentIndex;
                                    lastIndex = currentIndex;
                                    
                                    if(currentIndex < length) {
                                        //    find the next unescqped quote
                                        foundit = false;
                                        while((currentIndex < length) && !foundit) {
D 6
                                            currentChar = rawdata.charAt(currentIndex);
E 6
I 6
                                            currentChar = parameterList.charAt(currentIndex);
E 6
                                            if(currentChar == '\\') {
                                                //    found an escape sequence so pass this and the next character
                                                currentIndex += 2;
                                            } else if(currentChar == '"') {
                                                //    foundit!
                                                foundit = true;
                                            } else {
                                                ++currentIndex;
                                            }
                                        }
                                        if(currentChar == '"') {
D 6
                                            value = unquote(rawdata.substring(lastIndex, currentIndex));
E 6
I 6
                                            value = unquote(parameterList.substring(lastIndex, currentIndex));
E 6
                                            //    eat the quote
                                            ++currentIndex;
                                        } else {
                                            throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                                        }
                                    } else {
                                        throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                                    }
                                } else if(isTokenChar(currentChar)) {
                                    //    nope it's an ordinary token so it ends with a non-token char
                                    lastIndex = currentIndex;
                                    foundit = false;
                                    while((currentIndex < length) && !foundit) {
D 6
                                        currentChar = rawdata.charAt(currentIndex);
E 6
I 6
                                        currentChar = parameterList.charAt(currentIndex);
E 6
                                        
                                        if(isTokenChar(currentChar)) {
                                            ++currentIndex;
                                        } else {
                                            foundit = true;
                                        }
                                    }
D 6
                                    value = rawdata.substring(lastIndex, currentIndex);
E 6
I 6
                                    value = parameterList.substring(lastIndex, currentIndex);
E 6
                                } else {
                                    //    it ain't a value
                                    throw new MimeTypeParseException("Unexpected character encountered at index " + currentIndex);
                                }
                                
                                //    now put the data into the hashtable
                                parameters.put(name, value);
                            } else {
                                throw new MimeTypeParseException("Couldn't find a value for parameter named " + name);
                            }
                        } else {
                            throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
                        }
                    } else {
                        throw new MimeTypeParseException("Couldn't find parameter name");
                    }
                    
                    //    setup the next iteration
D 6
                    currentIndex = skipWhiteSpace(rawdata, currentIndex);
E 6
I 6
                    currentIndex = skipWhiteSpace(parameterList, currentIndex);
E 6
                    if(currentIndex < length) {
D 6
                        currentChar = rawdata.charAt(currentIndex);
E 6
I 6
                        currentChar = parameterList.charAt(currentIndex);
E 6
                    }
                }
                if(currentIndex < length) {
                    throw new MimeTypeParseException("More characters encountered in input than expected.");
                }
            }
        }
E 8
I 8
        int length = parameterList.length();
        if (length <= 0)
	    return;

	int i;
	char c;
	for (i = skipWhiteSpace(parameterList, 0);
		i < length && (c = parameterList.charAt(i)) == ';';
		i = skipWhiteSpace(parameterList, i)) {
	    int lastIndex;
	    String name;
	    String value;

	    //    eat the ';'
	    i++;

	    //    now parse the parameter name

	    //    skip whitespace
	    i = skipWhiteSpace(parameterList, i);

I 11
	    // tolerate trailing semicolon, even though it violates the spec
E 11
	    if (i >= length)
D 11
		throw new MimeTypeParseException(
				    "Couldn't find parameter name");
E 11
I 11
		return;
E 11

	    //    find the end of the token char run
	    lastIndex = i;
	    while ((i < length) && isTokenChar(parameterList.charAt(i)))
		i++;

	    name = parameterList.substring(lastIndex, i).toLowerCase();

	    //    now parse the '=' that separates the name from the value
	    i = skipWhiteSpace(parameterList, i);

	    if (i >= length || parameterList.charAt(i) != '=')
		throw new MimeTypeParseException(
		    "Couldn't find the '=' that separates a " +
		    "parameter name from its value.");

	    //    eat it and parse the parameter value
	    i++;
	    i = skipWhiteSpace(parameterList, i);

	    if (i >= length)
		throw new MimeTypeParseException(
			"Couldn't find a value for parameter named " + name);

	    //    now find out whether or not we have a quoted value
	    c = parameterList.charAt(i);
	    if (c == '"') {
		//    yup it's quoted so eat it and capture the quoted string
		i++;
		if (i >= length)
		    throw new MimeTypeParseException(
			    "Encountered unterminated quoted parameter value.");

		lastIndex = i;

		//    find the next unescaped quote
		while (i < length) {
		    c = parameterList.charAt(i);
		    if (c == '"')
			break;
		    if (c == '\\') {
			//    found an escape sequence
			//    so skip this and the
			//    next character
			i++;
		    }
		    i++;
		}
		if (c != '"')
		    throw new MimeTypeParseException(
			"Encountered unterminated quoted parameter value.");

		value = unquote(parameterList.substring(lastIndex, i));
		//    eat the quote
		i++;
	    } else if (isTokenChar(c)) {
		//    nope it's an ordinary token so it
		//    ends with a non-token char
		lastIndex = i;
		while (i < length && isTokenChar(parameterList.charAt(i)))
		    i++;
		value = parameterList.substring(lastIndex, i);
	    } else {
		//    it ain't a value
		throw new MimeTypeParseException(
			"Unexpected character encountered at index " + i);
	    }

	    //    now put the data into the hashtable
	    parameters.put(name, value);
	}
	if (i < length) {
	    throw new MimeTypeParseException(
		"More characters encountered in input than expected.");
	}
E 8
    }

    /**
D 8
     * return the number of name-value pairs in this list.
E 8
I 8
     * Return the number of name-value pairs in this list.
I 9
     *
     * @return	the number of parameters
E 9
E 8
     */
    public int size() {
        return parameters.size();
    }

    /**
     * Determine whether or not this list is empty.
I 9
     *
     * @return	true if there are no parameters
E 9
     */
    public boolean isEmpty() {
        return parameters.isEmpty();
    }

    /**
     * Retrieve the value associated with the given name, or null if there
     * is no current association.
I 9
     *
     * @param name	the parameter name
     * @return		the parameter's value
E 9
     */
    public String get(String name) {
        return (String)parameters.get(name.trim().toLowerCase());
    }

    /**
     * Set the value to be associated with the given name, replacing
     * any previous association.
I 9
     *
     * @param name	the parameter name
     * @param value	the parameter's value
E 9
     */
    public void set(String name, String value) {
        parameters.put(name.trim().toLowerCase(), value);
    }

    /**
     * Remove any value associated with the given name.
I 9
     *
     * @param name	the parameter name
E 9
     */
    public void remove(String name) {
        parameters.remove(name.trim().toLowerCase());
    }

    /**
     * Retrieve an enumeration of all the names in this list.
I 9
     *
     * @return	an enumeration of all parameter names
E 9
     */
    public Enumeration getNames() {
        return parameters.keys();
    }

I 5
    /**
     * Return a string representation of this object.
     */
E 5
    public String toString() {
        StringBuffer buffer = new StringBuffer();
D 8
        buffer.ensureCapacity(parameters.size() * 16);    //    heuristic: 8 characters per field
        
E 8
I 8
        buffer.ensureCapacity(parameters.size() * 16);
			//    heuristic: 8 characters per field

E 8
        Enumeration keys = parameters.keys();
D 8
        while(keys.hasMoreElements())
        {
            buffer.append("; ");
            
E 8
I 8
        while (keys.hasMoreElements()) {
E 8
            String key = (String)keys.nextElement();
I 8
            buffer.append("; ");
E 8
            buffer.append(key);
            buffer.append('=');
D 8
               buffer.append(quote((String)parameters.get(key)));
E 8
I 8
	    buffer.append(quote((String)parameters.get(key)));
E 8
        }
D 8
        
E 8
I 8

E 8
        return buffer.toString();
    }
D 4
    
    /**
     * The object implements the writeExternal method to save its contents
     * by calling the methods of DataOutput for its primitive values or
     * calling the writeObject method of ObjectOutput for objects, strings
     * and arrays.
     * @exception IOException Includes any I/O exceptions that may occur
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(toString());
    }
E 4

D 4
    /**
     * The object implements the readExternal method to restore its
     * contents by calling the methods of DataInput for primitive
     * types and readObject for objects, strings and arrays.  The
     * readExternal method must read the values in the same sequence
     * and with the same types as were written by writeExternal.
     * @exception ClassNotFoundException If the class for an object being
     *              restored cannot be found.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    	try {
	        parse((String)in.readObject());
	    } catch(MimeTypeParseException e) {
	        throw new IOException(e.toString());
	    }
    }

E 4
D 6
    private Hashtable parameters;
    
E 6
    //    below here be scary parsing related things

    /**
     * Determine whether or not a given character belongs to a legal token.
     */
    private static boolean isTokenChar(char c) {
D 4
        boolean answer = !Character.isISOControl(c) && !Character.isWhitespace(c);
        
        if(answer) {
            switch(c) {
                case '(':
                case ')':
                case '<':
                case '>':
                case '@':
                case ',':
                case ';':
                case ':':
                case '\\':
                case '"':
                case '/':
                case '[':
                case ']':
                case '?':
                case '=':
                    answer = false;
                    break;
            }
        }
        
        return answer;
E 4
I 4
        return ((c > 040) && (c < 0177)) && (TSPECIALS.indexOf(c) < 0);
E 4
    }

    /**
     * return the index of the first non white space character in
     * rawdata at or after index i.
     */
    private static int skipWhiteSpace(String rawdata, int i) {
        int length = rawdata.length();
D 7
        if (i < length) {
            char c =  rawdata.charAt(i);
            while ((i < length) && Character.isWhitespace(c)) {
                ++i;
                c = rawdata.charAt(i);
            }
        }
        
E 7
I 7
	while ((i < length) && Character.isWhitespace(rawdata.charAt(i)))
	    i++;
E 7
        return i;
    }
D 8
    
E 8
I 8

E 8
    /**
     * A routine that knows how and when to quote and escape the given value.
     */
    private static String quote(String value) {
        boolean needsQuotes = false;
D 8
        
E 8
I 8

E 8
        //    check to see if we actually have to quote this thing
        int length = value.length();
D 8
        for(int i = 0; (i < length) && !needsQuotes; ++i) {
E 8
I 8
        for (int i = 0; (i < length) && !needsQuotes; i++) {
E 8
            needsQuotes = !isTokenChar(value.charAt(i));
        }
D 8
        
        if(needsQuotes) {
E 8
I 8

        if (needsQuotes) {
E 8
            StringBuffer buffer = new StringBuffer();
            buffer.ensureCapacity((int)(length * 1.5));
D 8
            
E 8
I 8

E 8
            //    add the initial quote
            buffer.append('"');
D 8
            
E 8
I 8

E 8
            //    add the properly escaped text
D 8
            for(int i = 0; i < length; ++i) {
E 8
I 8
            for (int i = 0; i < length; ++i) {
E 8
                char c = value.charAt(i);
D 8
                if((c == '\\') || (c == '"')) {
E 8
I 8
                if ((c == '\\') || (c == '"'))
E 8
                    buffer.append('\\');
D 8
                }
E 8
                buffer.append(c);
            }
D 8
            
E 8
I 8

E 8
            //    add the closing quote
            buffer.append('"');
D 8
            
E 8
I 8

E 8
            return buffer.toString();
D 8
        }
        else
        {
E 8
I 8
        } else {
E 8
            return value;
        }
    }
D 8
    
E 8
I 8

E 8
    /**
D 8
     * A routine that knows how to strip the quotes and escape sequences from the given value.
E 8
I 8
     * A routine that knows how to strip the quotes and
     * escape sequences from the given value.
E 8
     */
    private static String unquote(String value) {
        int valueLength = value.length();
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(valueLength);
D 8
        
E 8
I 8

E 8
        boolean escaped = false;
D 8
        for(int i = 0; i < valueLength; ++i) {
E 8
I 8
        for (int i = 0; i < valueLength; ++i) {
E 8
            char currentChar = value.charAt(i);
D 4
            if(currentChar != '\\') {
E 4
I 4
D 8
            if(!escaped && (currentChar != '\\')) {
E 8
I 8
            if (!escaped && (currentChar != '\\')) {
E 8
E 4
                buffer.append(currentChar);
D 8
            } else if(escaped) {
E 8
I 8
            } else if (escaped) {
E 8
                buffer.append(currentChar);
                escaped = false;
            } else {
                escaped = true;
            }
        }
D 8
        
E 8
I 8

E 8
        return buffer.toString();
    }
I 4
D 8
    
    /**
     * A string that holds all the special chars.
     */
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";
E 4

E 8
E 3
}
E 1
