h30407
s 00005/00016/00136
d D 1.8 99/12/06 16:33:41 shannon 9 8
c Update copyright for SCSL release
e
s 00035/00038/00117
d D 1.7 99/03/25 17:34:59 shannon 8 7
c clean up code and javadocs
e
s 00036/00024/00119
d D 1.6 98/02/05 14:42:53 bhc 7 6
c update javadocs as per bug 4105084
c 
e
s 00024/00011/00119
d D 1.5 98/01/22 13:44:24 bhc 6 5
c clean up javadocs
c 
e
s 00008/00001/00122
d D 1.4 97/12/09 10:33:45 bhc 5 4
c fixed API change in FileTypeMap, added getFile method
e
s 00012/00094/00111
d D 1.3 97/12/08 08:13:03 bhc 4 3
c now it delegates all typing to a FileTypeMap class
e
s 00059/00007/00146
d D 1.2 97/09/29 14:17:39 bhc 3 1
c change code to reflect new config file location
e
s 00000/00000/00000
d R 1.2 97/09/05 16:22:25 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/FileDataSource.java
c Name history : 1 0 src/classes/javax/activation/FileDataSource.java
e
s 00153/00000/00000
d D 1.1 97/09/05 16:22:24 bhc 1 0
c date and time created 97/09/05 16:22:24 by bhc
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
D 8
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
E 8
 *
I 8
D 9
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 8
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * @author Bart Calder
E 9
I 9
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 9
 */

package javax.activation;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.sun.activation.registries.MimeTypeFile;

/**
D 6
 * The FileDataSource class implements a simple DataSource class
E 6
I 6
 * The FileDataSource class implements a simple DataSource object
E 6
 * that encapsulates a file. It provides data typing services via
D 6
 * the users .mime.types file if one is available, otherwise it
 * uses the system one.
E 6
I 6
D 7
 * a <code>FileTypeMap</code> object. <p>
E 7
I 7
 * a FileTypeMap object. <p>
E 7
D 8
 * 
E 8
I 8
 *
E 8
 * <b>FileDataSource Typing Semantics</b><p>
E 6
 *
I 6
D 7
 * The <code>FileDataSource</code> class delegates data typing of files
 * to an object subclassed from the <code>FileTypeMap</code> class. 
 * The <code>setFileTypeMap</code> method can be used to explicitly
E 7
I 7
 * The FileDataSource class delegates data typing of files
D 8
 * to an object subclassed from the FileTypeMap class. 
 * The setFileTypeMap method can be used to explicitly
E 8
I 8
 * to an object subclassed from the FileTypeMap class.
 * The <code>setFileTypeMap</code> method can be used to explicitly
E 8
E 7
 * set the FileTypeMap for an instance of FileDataSource. If no
 * FileTypeMap is set, the FileDataSource will call the FileTypeMap's
 * getDefaultFileTypeMap method to get the System's default FileTypeMap.
 *
E 6
D 7
 * @see java.beans.DataSource
E 7
I 7
 * @see javax.activation.DataSource
 * @see javax.activation.FileTypeMap
 * @see javax.activation.MimetypesFileTypeMap
E 7
 */
public class FileDataSource implements DataSource {

    // keep track of original 'ref' passed in, non-null
    // one indicated which was passed in:
    private File _file = null;
D 4

    // types registry
    private static MimeTypeFile systemTypesDB = null;
    private MimeTypeFile instanceTypesDB = null;

E 4
I 4
    private FileTypeMap typeMap = null;
I 8

E 8
E 4
    /**
D 7
     * Creates a FileDataSource from a <code>File</code> object.
E 7
I 7
     * Creates a FileDataSource from a File object. <i>Note:
     * The file will not actually be opened until a method is
     * called that requires the file to be opened.</i>
E 7
     *
D 8
     * @param file the file to be opened for reading.
E 8
I 8
     * @param file the file
E 8
     */
D 8
    public FileDataSource( File file ){
	_file = file; // get the file Object...
E 8
I 8
    public FileDataSource(File file) {
	_file = file;	// save the file Object...
E 8
D 4
	    
	// initial the data typing registry
	if(systemTypesDB == null) {
D 3
	    systemTypesDB = new MimeTypeFile( 
					     System.getProperty("java.home") +
					     System.getProperty("file.separator") +
					     "lib" +
					     System.getProperty("file.separator") +
					     "jdk_mime_types.properties"
					     );
E 3
I 3
	    InputStream is = java.lang.ClassLoader.getSystemResourceAsStream(
						          "META-INF/mimetypes");
	    	    byte[] data = null;
	    int bytes_read = 0;
	    String mimetype_contents = null;

	    try {
		while(bytes_read != -1) {
		    int len = 1024;
		    byte[] chunk = new byte[len];

		    bytes_read = is.read(chunk, 0, chunk.length);
		    
		    if(bytes_read == -1)
			break;

		    if(data == null){


			data = new byte[bytes_read];
			System.arraycopy(chunk,
					 0,
					 data,
					 0,
					 bytes_read);

		    } else {
			byte[] tmp = new byte[data.length + bytes_read];

			System.arraycopy(data,
					 0,
					 tmp,
					 0,
					 data.length);

			System.arraycopy(chunk,
					0,
					tmp,
					data.length - 1,
					bytes_read);
			data = tmp;
		    }
			
		}
		
	    } catch(IOException e) {}

	    mimetype_contents = new String(data);



	    systemTypesDB = new MimeTypeFile();
	    systemTypesDB.appendToRegistry(mimetype_contents);
// 					     System.getProperty("java.home") +
// 					     System.getProperty("file.separator") +
// 					     "lib" +
// 					     System.getProperty("file.separator") +
// 					     "jdk_mime_types.properties"
// 					     );
E 3
	}
E 4
    }

    /**
D 6
     * Creates an input file stream to read from a file with 
E 6
I 6
D 7
     * Creates FileDataSource from from  
E 6
     * the specified name.
E 7
I 7
D 8
     * Creates FileDataSource from   
E 8
I 8
     * Creates a FileDataSource from
E 8
     * the specified path name. <i>Note:
     * The file will not actually be opened until a method is
     * called that requires the file to be opened.</i>
E 7
     *
     * @param name the system-dependent file name.
     */
D 8
    public FileDataSource( String name ) {
	this( new File( name ) ); // use the file ctor
E 8
I 8
    public FileDataSource(String name) {
	this(new File(name));	// use the file constructor
E 8
    }

D 4
    /**
     * This method will prepend the .mime.type values to the 
     * registry.
     *
     * @param mime_types A .mime.types formatted string of entries.
     */
    public void addMimeTypes(String mime_types)	{
	// check to see if we have created the registry
	if( instanceTypesDB == null)
	    instanceTypesDB = new MimeTypeFile(); // make one
	
	instanceTypesDB.appendToRegistry( mime_types );
	
    }
E 4
D 8
    /** 
D 7
     * This method will return an <code>InputStream</code> representing the 
     * the data and will throw the appropriate exception if it can
D 6
     * not do so. Currently implemented to throw a new <code>InputStream</code>
E 6
I 6
     * not do so. Currently implemented to return a new 
     * <code>InputStream</code>
E 6
     * with each invocation.
E 7
I 7
     * This method will return an InputStream representing the 
E 8
I 8
    /**
     * This method will return an InputStream representing the
E 8
     * the data and will throw an IOException if it can
D 8
     * not do so. This method will return a new 
E 8
I 8
     * not do so. This method will return a new
E 8
     * instance of InputStream with each invocation.
E 7
     *
     * @return an InputStream
     */
D 7
    public InputStream getInputStream() throws FileNotFoundException {
E 7
I 7
    public InputStream getInputStream() throws IOException {
E 7
D 8
	return new FileInputStream( _file );
E 8
I 8
	return new FileInputStream(_file);
E 8
    }

D 8
    /** 
D 7
     * This method will return an <code>OutputStream</code> representing the 
D 6
     * the data and will throw the appropriate exception if it can
E 6
I 6
     * the data and will return the appropriate exception if it can
E 6
     * not do so.
E 7
I 7
     * This method will return an OutputStream representing the 
E 8
I 8
    /**
     * This method will return an OutputStream representing the
E 8
     * the data and will throw an IOException if it can
D 8
     * not do so. This method will return a new instance of 
E 8
I 8
     * not do so. This method will return a new instance of
E 8
     * OutputStream with each invocation.
I 8
     *
E 8
E 7
     * @return an OutputStream
     */
    public OutputStream getOutputStream() throws IOException {
D 8
	return new FileOutputStream( _file );
E 8
I 8
	return new FileOutputStream(_file);
E 8
    }

    /**
D 6
     * This method returns the MIME type of the data in the for of a 
     * string. The semantics of this call are to first search the 
     * per instance MIME Types registry and then check the system default
     * registry returning the result of the first successful query.
E 6
I 6
D 8
     * This method returns the MIME type of the data in the form of a 
     * string. The semantics of this call are to use the currently
D 7
     * installed <code>FileTypeMap</code>. If there is no 
     * <code>FileTypeMap</code> explictly set, the 
     * <code>FileDataSource</code> will call the <code>
     * getDefaultFileTypeMap</code> method on FileTypeMap
     * to acquire a default FileTypeMap.
E 7
I 7
     * installed FileTypeMap. If there is no FileTypeMap explictly set, the 
     * FileDataSource will call the 
     * getDefaultFileTypeMap method on FileTypeMap
     * to acquire a default FileTypeMap. <i>Note: By default
     * the FileTypeMap used will be a MimetypesFileTypeMap.</i>
E 8
I 8
     * This method returns the MIME type of the data in the form of a
     * string. This method uses the currently installed FileTypeMap. If
     * there is no FileTypeMap explictly set, the FileDataSource will
     * call the <code>getDefaultFileTypeMap</code> method on
     * FileTypeMap to acquire a default FileTypeMap. <i>Note: By
     * default, the FileTypeMap used will be a MimetypesFileTypeMap.</i>
E 8
E 7
E 6
     *
     * @return the MIME Type
I 7
     * @see javax.activation.FileTypeMap#getDefaultFileTypeMap
E 7
     */
    public String getContentType() {
D 4
	String fname = _file.getName(); // ref to the file name
	int dot_pos = fname.lastIndexOf("."); // period index
	String file_ext = new String(fname.substring(dot_pos + 1,
						     fname.length()));
	String result = null;
E 4
I 4
	// check to see if the type map is null?
D 8
	if(typeMap == null)
D 5
	    typeMap = FileTypeMap.getDefaultMap();
E 5
I 5
	    typeMap = FileTypeMap.getDefaultFileTypeMap();
E 5
E 4
	
D 4
	if(instanceTypesDB != null) // has one been specified?
	    result = instanceTypesDB.getMIMETypeString( file_ext );
	
	if(result == null)
	    result = systemTypesDB.getMIMETypeString( file_ext );
	
	return result;
E 4
I 4
	return typeMap.getContentType(_file);
E 8
I 8
	if (typeMap == null)
	    return FileTypeMap.getDefaultFileTypeMap().getContentType(_file);
	else
	    return typeMap.getContentType(_file);
E 8
E 4
    }

    /**
D 6
     * Return the 'name' of this object
E 6
I 6
D 7
     * Return the 'name' of this object. The <code>FileDataSource<code>
E 7
I 7
D 8
     * Return the 'name' of this object. The FileDataSource
E 8
I 8
     * Return the <i>name</i> of this object. The FileDataSource
E 8
E 7
     * will return the file name of the object.
I 8
     *
E 8
E 6
     * @return the name of the object.
D 7
     * @see java.beans.DataSource
E 7
I 7
     * @see javax.activation.DataSource
E 7
     */
    public String getName() {
	return _file.getName();
    }

I 5
    /**
     * Return the File object that corresponds to this FileDataSource.
I 7
     * @return the File object for the file represented by this object.
E 7
     */
D 8
    public File getFile(){
E 8
I 8
    public File getFile() {
E 8
	return _file;
    }

E 5
I 4
    /**
     * Set the FileTypeMap to use with this FileDataSource
I 7
     *
     * @param map The FileTypeMap for this object.
E 7
     */
D 8
    public void setFileTypeMap(FileTypeMap map){
E 8
I 8
    public void setFileTypeMap(FileTypeMap map) {
E 8
	typeMap = map;
    }
D 8

E 8
E 4
}
D 8


I 7


E 7

E 8
E 1
