h02305
s 00005/00015/00116
d D 1.10 99/12/06 16:33:39 shannon 11 10
c Update copyright for SCSL release
e
s 00057/00058/00074
d D 1.9 99/03/06 17:40:22 shannon 10 9
c clean up code and comments, fix typos
e
s 00001/00001/00131
d D 1.8 98/02/10 17:16:33 bhc 9 8
c minor tweak to javadoc
c 
e
s 00019/00028/00113
d D 1.7 98/01/22 13:38:50 bhc 8 7
c Cleaned up externalization code, clean up javadocs
c 
e
s 00039/00005/00102
d D 1.6 98/01/21 07:49:12 bhc 7 6
c update javadocs
e
s 00020/00009/00087
d D 1.5 97/12/19 14:32:16 bhc 6 5
c fixed javadoc comments
c 
e
s 00009/00000/00087
d D 1.4 97/12/09 14:32:36 bhc 5 4
c added getCommandClass method
c 
e
s 00004/00010/00083
d D 1.3 97/12/09 10:35:31 bhc 4 3
c removed getCommandClass method, changed initCommandContext to setCommandContext
e
s 00009/00002/00084
d D 1.2 97/12/05 16:06:37 bhc 3 1
c add getCommandClass method
e
s 00000/00000/00000
d R 1.2 97/12/02 09:48:53 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/CommandInfo.java
c Name history : 1 0 src/classes/javax/activation/CommandInfo.java
e
s 00086/00000/00000
d D 1.1 97/12/02 09:48:52 bhc 1 0
c date and time created 97/12/02 09:48:52 by bhc
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
D 10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 10
I 10
 *
D 11
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 10
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 10
 * 
E 10
I 10
 *
E 10
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 10
 * 
E 10
I 10
 *
E 11
I 11
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 11
E 10
 */

D 3


E 3
package javax.activation;

D 7
import java.io.IOException;
E 7
I 7
import java.io.*;
E 7
import java.beans.Beans;
D 6
/**
 * The <b>CommandInfo</b> is used by CommandMap implementations represent
 * the results of command requests. It provides the requestor with both
 * the verb requested, as well as an instance of the bean.
E 6
I 6
D 10
/** 
E 10
I 10

/**
E 10
D 8
 * The <b>CommandInfo</b> is used by CommandMap implementations to
E 8
I 8
D 9
 * The <b>CommandInfo</b> class is used by CommandMap implementations to
E 9
I 9
 * The CommandInfo class is used by CommandMap implementations to
E 9
E 8
 * describe the results of command requests. It provides the requestor
 * with both the verb requested, as well as an instance of the
D 10
 * bean. There is also method that will return the class name of the
E 10
I 10
 * bean. There is also a method that will return the name of the
E 10
D 8
 * class that implements the command but it is not guaranteed to
 * return a valid value. The reason for this is to allow CommandMap
E 8
I 8
 * class that implements the command but <i>it is not guaranteed to
D 10
 * return a valid value.</i> The reason for this is to allow CommandMap
E 8
 * implmentations to subclass CommandInfo to provide special
E 10
I 10
 * return a valid value</i>. The reason for this is to allow CommandMap
 * implmentations that subclass CommandInfo to provide special
E 10
 * behavior. For example a CommandMap could dynamically generate
 * JavaBeans. In this case, it might not be possible to create an
 * object with all the correct state information solely from the class
D 10
 * name.  
E 10
I 10
 * name.
E 10
E 6
 */

public class CommandInfo {
    private String verb;
    private String className;
I 10

E 10
    /**
D 10
     * The Constructor for CommandInfo
     * @param verb The command verb this CommandInfo Decribes.
     * @param className The Bean's fully qualified class name.
     */     
    public CommandInfo(String verb, String className){
E 10
I 10
     * The Constructor for CommandInfo.
     * @param verb The command verb this CommandInfo decribes.
     * @param className The command's fully qualified class name.
     */
    public CommandInfo(String verb, String className) {
E 10
	this.verb = verb;
	this.className = className;
    }

    /**
     * Return the command verb.
     *
     * @return the command verb.
     */
D 10
    public String getCommandName(){
E 10
I 10
    public String getCommandName() {
E 10
	return verb;
    }

I 3
    /**
I 5
D 8
     * Return the command's class name. This method MAY return null in 
E 8
I 8
D 10
     * Return the command's class name. <i>This method MAY return null in 
E 8
     * cases where a CommandMap sub classed CommandInfo for it's
E 10
I 10
     * Return the command's class name. <i>This method MAY return null in
     * cases where a CommandMap subclassed CommandInfo for its
E 10
D 6
     * own purposes.
E 6
I 6
D 8
     * own purposes. In other words, it might not be possible to
E 8
I 8
     * own purposes.</i> In other words, it might not be possible to
E 8
D 10
     * create the correct state in the command by merely knowing 
D 8
     * it's class name.
E 8
I 8
     * it's class name. <b>DO NOT DEPEND ON THIS METHOD RETURNING
E 10
I 10
     * create the correct state in the command by merely knowing
     * its class name. <b>DO NOT DEPEND ON THIS METHOD RETURNING
E 10
     * A VALID VALUE!</b>
I 10
     *
E 10
E 8
     * @return The class name of the command, or <i>null</i>
E 6
     */
D 10
    public String getCommandClass(){
E 10
I 10
    public String getCommandClass() {
E 10
	return className;
    }

    /**
E 5
D 4
     * Return the class name of the bean.
     *
     * @return the class name.
     */
    public String getCommandClass(){
	return className;
    }

E 3
    /**
E 4
D 10
     * Return the instansiated JavaBean.
E 10
I 10
     * Return the instantiated JavaBean component.
E 10
     * <p>
D 6
     * Begin by instansiating the Bean with Beans.instansiate().
E 6
I 6
D 10
     * Begin by instantiating the Bean with Beans.instantiate().
E 10
I 10
     * Begin by instantiating the component with
     * <code>Beans.instantiate()</code>.
E 10
E 6
     * <p>
D 10
     * If this bean implements the javax.activation.CommandObject 
D 6
     * interface, call it's initCommandContext method.
E 6
I 6
     * interface, call it's setCommandContext method.
E 10
I 10
     * If the bean implements the <code>javax.activation.CommandObject</code>
     * interface, call its <code>setCommandContext</code> method.
E 10
E 6
I 4
     * <p>
D 10
     * If the DataHandler parameter is null, then the class is
E 10
I 10
     * If the DataHandler parameter is null, then the bean is
E 10
D 6
     * instansiated with no data.
E 6
I 6
D 7
     * instantiated with no data.
E 7
I 7
     * instantiated with no data. NOTE: this may be useful
     * if for some reason the DataHandler that is passed in
D 10
     * throws IOExceptions when this method attempts to 
     * access it's InputStream. It will allow the caller to
E 10
I 10
     * throws IOExceptions when this method attempts to
     * access its InputStream. It will allow the caller to
E 10
     * retrieve a reference to the bean if it can be
     * instantiated.
E 7
E 6
E 4
D 8
     *
E 8
I 8
     * <p>
     * If the bean does NOT implement the CommandObject interface,
D 10
     * this method will check if it implements the 
E 10
I 10
     * this method will check if it implements the
E 10
     * java.io.Externalizable interface. If it does, the bean's
     * readExternal method will be called if an InputStream
     * can be acquired from the DataHandler.<p>
D 10
     * 
E 8
     * @param dh The DataHandler that describes the data to be
     * passed to the command.
     * @param loader The ClassLoader to be used to instansiate the
     * Bean.
     * @return The Bean
E 10
I 10
     *
     * @param dh	The DataHandler that describes the data to be
     *			passed to the command.
     * @param loader	The ClassLoader to be used to instantiate the bean.
     * @return The bean
E 10
D 6
     * @see java.beans.Beans#instansiate
E 6
I 6
     * @see java.beans.Beans#instantiate
E 6
     * @see javax.activation.CommandObject
     */
D 10
    public Object getCommandObject(DataHandler dh, ClassLoader loader) 
	throws IOException, ClassNotFoundException {
	    Object new_bean = null;
	    
	    // try to instansiate the bean
	    new_bean = java.beans.Beans.instantiate(loader, className);
E 10
I 10
    public Object getCommandObject(DataHandler dh, ClassLoader loader)
			throws IOException, ClassNotFoundException {
	Object new_bean = null;
E 10

I 7
D 8
	    if(new_bean == null)
		System.out.println("couldn't find the bean!!!");
	    else
		System.out.println("got a bean");

	    System.out.println("test:" + new_bean.getClass().getName());
E 8
E 7
D 10
	    // if we got one and it is a CommandObject
D 7
	    if(new_bean != null &&
	       new_bean instanceof CommandObject) 
D 4
		((CommandObject)new_bean).initCommandContext(verb, dh);
E 4
I 4
		((CommandObject)new_bean).setCommandContext(verb, dh);
E 7
I 7
	    if(new_bean != null)
		if(new_bean instanceof CommandObject) {
D 8
		    System.out.println("here in CO");
E 8
		    ((CommandObject)new_bean).setCommandContext(verb, dh);
		}
		else if(new_bean instanceof Externalizable) {
D 8
		    System.out.println("got externalizable bean...");
E 8
		    ObjectInputStream ois = null;
		    InputStream is = null;
		    
		    if(dh != null) {
D 8
			try{
			    is = dh.getInputStream();
			
			
			    if(is != null){
				((Externalizable)new_bean).readExternal(
                 		    new ObjectInputStream(is));
E 8
I 8
			is = dh.getInputStream();
			if(is != null){
			    ((Externalizable)new_bean).readExternal(
						   new ObjectInputStream(is));
E 8
			    }
E 10
I 10
	// try to instantiate the bean
	new_bean = java.beans.Beans.instantiate(loader, className);

	// if we got one and it is a CommandObject
	if (new_bean != null) {
	    if (new_bean instanceof CommandObject) {
		((CommandObject)new_bean).setCommandContext(verb, dh);
	    } else if (new_bean instanceof Externalizable) {
		if (dh != null) {
		    InputStream is = dh.getInputStream();
		    if (is != null) {
			((Externalizable)new_bean).readExternal(
					       new ObjectInputStream(is));
E 10
D 8
			} catch(Exception e){ e.printStackTrace(); }
E 8
		    }
D 8
		    if(new_bean == null)
			System.out.println("couldn't find the bean222!!!");
		    else
			System.out.println("got a bean222");
		} else System.out.println("here????");
E 8
I 8
D 10
		} 
E 10
I 10
		}
	    }
	}
E 10
E 8
E 7
E 4

	return new_bean;
    }
D 10

E 10
}
E 1
