h44740
s 00002/00002/00842
d D 1.34 02/02/23 19:41:51 shannon 38 37
c fix NPE - bug 4410032
e
s 00005/00015/00839
d D 1.33 99/12/06 16:33:40 shannon 37 36
c Update copyright for SCSL release
e
s 00002/00000/00852
d D 1.32 99/05/11 09:20:00 shannon 36 35
c add missing javadoc @param and @return clauses
e
s 00009/00005/00843
d D 1.31 99/05/05 15:25:19 shannon 35 34
c add more information to exceptions
e
s 00004/00010/00844
d D 1.30 99/03/25 17:36:31 shannon 34 33
c replace Class.forName(...) with DataHandler.class
e
s 00221/00255/00633
d D 1.29 99/03/06 17:42:36 shannon 33 32
c clean up code and comments; improve documentation;
c fix a few bugs; hopefully not introduce any new bugs  :-)
e
s 00004/00002/00884
d D 1.28 99/03/01 22:46:53 shannon 32 31
c if we can't parse the Content-Type string, use the entire string
c as the "base type" - bug 4137147
e
s 00023/00008/00863
d D 1.27 98/02/24 15:27:47 bhc 31 29
i 30
c Merged changes between child workspace "/home/bhc/jaf/jaf_ext" and
c  parent workspace "/net/icdev/export1/ic/tsunami/bhc_ws/jaf_ext".
c 
e
s 00009/00006/00876
d D 1.25.1.2 98/02/24 15:27:23 bhc 30 28
c fix regression
e
s 00000/00000/00864
d D 1.26 98/02/24 14:35:10 bhc 29 27
i 26
c Merged changes between child workspace "/net/icdev/export1/ic/tsunami/bhc_ws/jaf_docs" and
c  parent workspace "/net/icdev/export1/ic/tsunami/bhc_ws/jaf_ext".
c 
e
s 00027/00008/00855
d D 1.25.1.1 98/02/24 11:47:20 bhc 28 27
c fix for bug ID:  4108514
c 
e
s 00003/00003/00860
d D 1.25 98/02/23 19:11:22 bhc 27 25
c minor fix to getTransferData
c 
e
s 00066/00065/00798
d D 1.24.1.1 98/02/20 17:45:07 miltonb 26 25
c 0.6 edit update
e
s 00011/00001/00852
d D 1.24 98/02/17 18:39:27 bhc 25 24
c fixed to getInputStream now correctly throws exception
e
s 00006/00014/00847
d D 1.23 98/02/12 12:42:10 bhc 24 23
c 
e
s 00086/00023/00775
d D 1.22 98/02/06 15:25:43 bhc 23 22
c minor bug fixing, and JavaDoc tweaks
c 
e
s 00004/00000/00794
d D 1.21 98/01/23 11:04:25 bhc 22 21
c javadoc updates
e
s 00004/00001/00790
d D 1.20 98/01/21 07:50:36 bhc 21 20
c update javadocs
e
s 00008/00016/00783
d D 1.19 98/01/09 17:16:15 bhc 20 19
c last minute code review changes for javamail beta
e
s 00313/00325/00486
d D 1.18 97/12/19 15:54:18 shannon 19 18
c clean up comments and code
e
s 00059/00047/00752
d D 1.17 97/12/19 14:32:33 bhc 18 17
c javadoc fixes
c 
e
s 00003/00005/00796
d D 1.16 97/12/18 13:18:12 bhc 17 16
c throw unsupportedDT exceptions in the right places
c 
e
s 00003/00017/00798
d D 1.15 97/12/16 14:47:20 bhc 16 15
c fixed semantics of getDataContentHandler
e
s 00002/00002/00813
d D 1.14 97/12/09 14:33:00 bhc 15 14
c fixed getTransferDataFlavors bug in odch and dsdch
c 
e
s 00002/00076/00813
d D 1.13 97/12/08 07:47:58 bhc 14 13
c removed URLDataSource class from DH
e
s 00023/00057/00866
d D 1.12 97/12/05 16:04:14 bhc 13 12
c clean up semantics in DCH stuff, fix writeTo bug
e
s 00002/00002/00921
d D 1.11 97/12/02 18:52:13 bhc 12 11
c minor fix to the DCH code
e
s 00096/00052/00827
d D 1.10 97/12/02 10:07:34 bhc 11 10
c interim checkin for test, various changes and fixes
c 
e
s 00289/00195/00590
d D 1.9 97/10/28 13:50:03 bhc 10 9
c updated API's, based on lastest reviews
e
s 00206/00091/00579
d D 1.8 97/10/20 18:02:23 bhc 9 8
c - Implements getDataSource for obj,mimeType add better javadoc comments
c 
c fixed cmd and dch search methods to use the just the type and subtype of the mime string
c 
c Added documentation for CommandMap semantics to java docs.
e
s 00002/00002/00668
d D 1.7 97/10/13 16:18:35 bhc 8 7
c javadoc fix
c 
e
s 00138/00165/00532
d D 1.6 97/10/13 11:26:08 bhc 7 6
c Many changes, includes most of the semantic and feature changes suggested from last code review
e
s 00002/00002/00695
d D 1.5 97/10/06 18:27:52 bhc 6 5
c change for putbytestream api 
e
s 00014/00011/00683
d D 1.4 97/10/06 18:05:53 bhc 5 4
c allow DCHF to e set only once, change internal dch to use new interf
e
s 00280/00057/00414
d D 1.3 97/10/06 10:53:44 bhc 4 3
c major changes to reflected updated semantics and DCH stuff
e
s 00006/00001/00465
d D 1.2 97/09/29 14:17:03 bhc 3 1
c add empty getContent method
e
s 00000/00000/00000
d R 1.2 97/09/05 16:22:25 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/DataHandler.java
c Name history : 1 0 src/classes/javax/activation/DataHandler.java
e
s 00466/00000/00000
d D 1.1 97/09/05 16:22:24 bhc 1 0
c date and time created 97/09/05 16:22:24 by bhc
e
u
U
f e 0
t
T
I 1
/*
D 26
 * %W% %E%
E 26
I 26
D 33
 * @(#)DataHandler.java	1.24 98/02/17
E 33
I 33
 * %W% %E%
E 33
E 26
D 19
 * 
E 19
I 19
 *
E 19
D 33
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
E 33
I 33
D 37
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 33
D 19
 * 
E 19
I 19
 *
E 19
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 19
 * 
E 19
I 19
 *
E 19
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 19
 * 
E 19
I 19
 *
E 37
I 37
D 38
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
E 38
I 38
 * Copyright 1997-2002 Sun Microsystems, Inc. All Rights Reserved.
E 38
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 37
E 19
 */

package javax.activation;

import java.io.InputStream;
I 5
import java.io.IOException;
E 5
import java.io.OutputStream;
I 7
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
I 14
import java.net.URL;
E 14
E 7
D 19
import java.beans.BeanInfo;
import java.beans.BeanDescriptor;
E 19
I 10
D 14
import java.net.URL;
import java.net.URLConnection;
E 14
E 10
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.DataFlavor;
I 9
import java.awt.datatransfer.UnsupportedFlavorException;
E 9
I 4
D 10
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
E 10
E 4

I 9
/**
D 10
 * The DataHandler class provides a consistant interface to the 
 * sub systems to users of the framework.
E 10
I 10
D 19
 * The DataHandler class provides a consistent interface to the 
D 18
 * subsystems to users of the framework.
E 18
I 18
 * subsystems to users of the framework. It also manages simple
 * stream to string conversions and related operations by managing
 * DataContentHandlers for users of the framework.
E 18
E 10
 * <p>
 * <b>CommandMap Semantics:</b>
 * <p>
D 10
 * The DataHandler keeps track of the current Command Map which it uses to
E 10
I 10
 * The DataHandler keeps track of the current CommandMap which it uses to
E 10
 * service requests for commands (<code>getCommand</code>, 
 * <code>getAllCommands</code>, <code>getPreferredCommands</code>). When a 
E 19
I 19
 * The DataHandler class provides a consistent interface to data
 * available in many different sources and formats.
 * It manages simple stream to string conversions and related operations
 * using DataContentHandlers.
 * It provides access to commands that can operate on the data.
 * The commands are found using a CommandMap. <p>
 *
I 23
 * <b>DataHandler and the Transferable Interface</b><p>
E 23
 * DataHandler implements the Transferable interface so that data can
 * be used in AWT data transfer operations, such as cut and paste and
D 23
 * drag and drop. <p>
E 23
I 23
 * drag and drop. The implementation of the Transferable interface
 * relies on the availability of an installed DataContentHandler
D 33
 * object corresponding to the MIME type of the data respresented in
E 33
I 33
 * object corresponding to the MIME type of the data represented in
E 33
 * the specific instance of the DataHandler.<p>
E 23
 *
I 23
 * <b>DataHandler and CommandMaps</b><p>
E 23
 * The DataHandler keeps track of the current CommandMap that it uses to
 * service requests for commands (<code>getCommand</code>,
D 26
 * <code>getAllCommands</code>, <code>getPreferredCommands</code>). When a
E 19
 * call to one of the Command methods is made, the DataHandler will
 * check to see if a CommandMap has been explictly set via the <code>
 * setCommandMap</code> method in DataHandler. If it has, it will
 * use that CommandMap, if not, it will call the <code>getDefaultCommandMap
D 10
 * </code> method in CommandMap and use it. See the CommandMap docuemtation
E 10
I 10
D 23
 * </code> method in CommandMap and use it. See the CommandMap documentation
E 10
D 19
 * for more information.
D 18
 *
E 18
I 18
 * <p>
 * <b>Data Conversion Semantics</b>
E 19
I 19
 * for more information. <p>
E 23
I 23
 * </code> method in CommandMap and use the value it returns. See 
 * the CommandMap documentation for more information. <p>
E 26
I 26
D 33
 * <code>getAllCommands</code>, <code>getPreferredCommands</code>). When 
 * it makes a call to one of the Command methods, the DataHandler 
 * checks to determine that a CommandMap has been explictly set via its 
 * <code>setCommandMap</code> method. If it has, it 
 * uses that CommandMap. If a CommandMap was not set, DataHandler
 * calls the <code>getDefaultCommandMap
 * </code> method in CommandMap and uses the value it returns. See 
E 33
I 33
 * <code>getAllCommands</code>, <code>getPreferredCommands</code>).
 * Each instance of a DataHandler may have a CommandMap associated with
 * it using the <code>setCommandMap</code> method.  If a CommandMap was
 * not set, DataHandler calls the <code>getDefaultCommandMap</code>
 * method in CommandMap and uses the value it returns. See
E 33
 * <i>CommandMap</i> for more information. <p>
E 26
E 23
 *
I 23
D 26
 * <b>DataHandler and URL's</b><p>
 * The current implementation of the DataHandler creates a private
E 26
I 26
 * <b>DataHandler and URLs</b><p>
 * The current DataHandler implementation creates a private
E 26
 * instance of URLDataSource when it is constructed with a URL.
 *
E 23
E 19
E 18
 * @see javax.activation.CommandMap
I 23
 * @see javax.activation.DataContentHandler
E 23
I 19
 * @see javax.activation.DataSource
I 23
 * @see javax.activation.URLDataSource
E 23
E 19
 */

E 9
public class DataHandler implements Transferable {
D 19
    
    // Use the datasource to notify where we were started via the
    // DataSource constructor or the 'alternative' constrcutor
E 19
I 19

    // Use the datasource to indicate whether we were started via the
D 33
    // DataSource constructor or the 'alternative' constructor.
E 33
I 33
    // DataSource constructor or the object constructor.
E 33
E 19
D 10
    private DataSource _dataSource = null;
E 10
I 10
    private DataSource dataSource = null;
E 10
I 9
    private DataSource objDataSource = null;
E 9
D 19
    
E 19
I 19

E 19
D 26
    // The Object and mimetype from the ctor (if passed in)
D 19
    // object will remain null if we were instantisated with a
    // DataSource
E 19
I 19
    // object will remain null if we were instantiated with a
E 26
I 26
D 33
    // The Object and mimetype from the constructor (if passed in)
E 33
I 33
    // The Object and mimetype from the constructor (if passed in).
E 33
    // object remains null if it was instantiated with a
E 26
    // DataSource.
E 19
D 10
    private Object _object = null;
    private String _objectMimeType = null;
E 10
I 10
    private Object object = null;
    private String objectMimeType = null;
E 10

    // Keep track of the CommandMap
D 4
    private CommandMap _commandMap = null;
E 4
I 4
    private CommandMap currentCommandMap = null;
D 16
    private static MailcapCommandMap sharedCommandMap = null;
E 16
I 16
D 19
    //    private static MailcapCommandMap sharedCommandMap = null;
E 16
E 4
    
E 19
I 19

E 19
    // our transfer flavors
D 10
    private DataFlavor _transferFlavors[] = null;
E 10
I 10
    private static final DataFlavor emptyFlavors[] = new DataFlavor[0];
    private DataFlavor transferFlavors[] = emptyFlavors;
E 10
I 4

I 10
    // our DataContentHandler
    private DataContentHandler dataContentHandler = null;
I 31
    private DataContentHandler factoryDCH = null;
E 31
I 28
    private DataContentHandler factoryDCH = null;
E 28

E 10
    // our DataContentHandlerFactory
D 10
    private static DataContentHandlerFactory _factory = null;
E 10
I 10
    private static DataContentHandlerFactory factory = null;
E 10
I 9
D 28
D 31

E 31
I 31
    private DataContentHandlerFactory oldFactory = null;
E 31
E 28
I 28
    private DataContentHandlerFactory oldFactory = null;
E 28
    // the short representation of the ContentType (sans params)
    private String shortType = null;
E 9
E 4
D 7
    
E 7
I 7
D 19
        
E 19
I 19

E 19
E 7
    /**
D 7
     * Creates a <code>DataHandler</code> instance with no DataSource.
     *
     * Note that this method really has protected access. It should not
     * be called except by subclasses. It is currently public to work
     * around a serialization bug.
     * 
     * The Sun bugtraq ID is:
     * 4029089 Should use protected superclass constructors
     * 
     * @since JDK1.2
     */
D 4
    public DataHandler()
    {
    	_dataSource = null;
    }
E 4
I 4
 //    public DataHandler() {
//     	_dataSource = null;
//     }
E 4
    
    /**
E 7
D 33
     * Creates a <code>DataHandler</code> instance with the
     * specified DataSource.
E 33
I 33
     * Create a <code>DataHandler</code> instance referencing the
     * specified DataSource.  The data exists in a byte stream form.
     * The DataSource will provide an InputStream to access the data.
E 33
     *
D 19
     * @param ds the DataSource
     * @see java.beans.DataSource
E 19
I 19
     * @param ds	the DataSource
E 19
D 7
     * @since JDK1.2
E 7
     */
    public DataHandler(DataSource ds) {
	// save a reference to the incoming DS
D 10
	_dataSource = ds;
E 10
I 10
	dataSource = ds;
I 31
	oldFactory = factory; // keep track of the factory
E 31
I 28
	oldFactory = factory; // keep track of the factory
E 28
E 10
    }
D 19
    
E 19
I 19

E 19
    /**
D 18
     * Initializes the DataHandler class. This constructor is
     * used when the application already has in memory representations
     * of the data in the form of Java Objects.
E 18
I 18
D 19
     * Initializes the DataHandler class with an object of this MIME type. 
E 19
I 19
D 33
     * Initializes the DataHandler class with an object of this MIME type.
E 19
     * This constructor is
E 33
I 33
     * Create a <code>DataHandler</code> instance representing an object
     * of this MIME type.  This constructor is
E 33
D 19
     * used when the application already has an in memory representation
E 19
I 19
     * used when the application already has an in-memory representation
E 19
     * of the data in the form of a Java Object.
E 18
     *
D 18
     * @param obj The java Object
E 18
I 18
D 19
     * @param obj The Java Object
E 18
     * @param mimeType The MIME type of the object
E 19
I 19
     * @param obj	the Java Object
     * @param mimeType	the MIME type of the object
E 19
     */
D 19
    public DataHandler( Object obj, String mimeType) {
E 19
I 19
    public DataHandler(Object obj, String mimeType) {
E 19
D 10
	_object = obj;
	_objectMimeType = mimeType;
E 10
I 10
	object = obj;
	objectMimeType = mimeType;
I 31
	oldFactory = factory; // keep track of the factory
E 31
I 28
	oldFactory = factory; // keep track of the factory
E 28
E 10
    }
D 19
    
E 19
I 19

E 19
    /**
I 10
D 18
     * Initializes the DataHandler class. This constructor takes
     * a URL.
E 18
I 18
D 33
     * Initializes the DataHandler class with a URL. The DataHandler
D 26
     * will internally create an instance of <code>URLDataSource</code> to
E 26
I 26
     * internally creates a <code>URLDataSource</code> instance to
E 26
     * represent the URL.
E 33
I 33
     * Create a <code>DataHandler</code> instance referencing a URL.
     * The DataHandler internally creates a <code>URLDataSource</code>
     * instance to represent the URL.
E 33
     *
D 19
     * @param url A URL object.
E 19
I 19
     * @param url	a URL object
E 19
E 18
     */
    public DataHandler(URL url) {
D 14
	dataSource = new URLConnectionDataSource(url);
E 14
I 14
	dataSource = new URLDataSource(url);
I 31
	oldFactory = factory; // keep track of the factory
E 31
I 28
	oldFactory = factory; // keep track of the factory
E 28
E 14
    }
I 33

E 33
    /**
E 10
D 7
     * Does the misc setup for this class.
E 7
I 7
D 33
     * Does commandmap setup for this class.
I 9
D 19
     * 
     * The semantics are, if there is not already a command map
     * set for this DataHandler, to get the default command map as
E 19
I 19
     *
     * If there is not already a command map
     * set for this DataHandler, get the default command map as
E 19
     * returned by the CommandMap.getDefaultCommandMap object.
     * (as described at the top of this file)
E 33
I 33
     * Return the CommandMap for this instance of DataHandler.
E 33
E 9
E 7
     */
D 10
    private void initDefaultCommandMap() {
E 10
I 10
D 33
    private synchronized void initDefaultCommandMap() {
E 10
D 4
	if(_commandMap == null) {
	    _commandMap = CommandMap.getDefaultCommandMap();
E 4
I 4
D 19
	if(currentCommandMap == null) {
E 19
I 19
	if (currentCommandMap == null) {
E 19
D 7
	    if(sharedCommandMap == null)
		sharedCommandMap = new MailcapCommandMap();
	    currentCommandMap = sharedCommandMap;
E 7
I 7
	    currentCommandMap = CommandMap.getDefaultCommandMap();
E 7
E 4
	}
E 33
I 33
    private synchronized CommandMap getCommandMap() {
	if (currentCommandMap != null)
	    return currentCommandMap;
	else
	    return CommandMap.getDefaultCommandMap();
E 33
    }
I 19

E 19
    /**
D 33
     * Returns the DataSource associated with this instance
E 33
I 33
     * Return the DataSource associated with this instance
E 33
D 9
     * of DataHandler. In the case of this DataHandler being
     * created using DataHandler(Object, String), the DataHandler
     * will return an instance of DataSource that it has 
     * created.
E 9
I 9
D 19
     * of DataHandler. 
E 19
I 19
     * of DataHandler.
E 19
     * <p>
D 10
     * For DataHandlers that have been instansiated with a
E 10
I 10
D 33
     * For DataHandlers that have been instantiated with a
E 10
D 26
     * DataSource, the DataSource that was used to create the
D 19
     * object will be returned, in other cases the DataHandler 
E 19
I 19
     * object will be returned, in other cases the DataHandler
E 19
     * will construct a DataSource from the data used to contruct
E 26
I 26
     * DataSource, this method returns the DataSource that was used to create the
E 33
I 33
     * For DataHandlers that have been instantiated with a DataSource,
     * this method returns the DataSource that was used to create the
E 33
     * DataHandler object. In other cases the DataHandler
     * constructs a DataSource from the data used to construct
E 26
D 18
     * the DataHandler. DataSources created for DatAaandlers NOT
     * instansiated with a DataSource will be cached for performance
E 18
I 18
D 19
     * the DataHandler. DataSources created for DataHandlers NOT
E 19
I 19
     * the DataHandler. DataSources created for DataHandlers <b>not</b>
E 19
D 26
     * instantiated with a DataSource will be cached for performance
E 26
I 26
     * instantiated with a DataSource are cached for performance
E 26
E 18
     * reasons.
E 9
     *
D 9
     * @return The Data Handler's DataSource object
E 9
I 9
D 18
     * @return The a valid DataSource object for this DataHandler
E 18
I 18
D 33
     * @return A valid DataSource object for this DataHandler.
I 19
     * @exception IOException	if an I/O error occurs
E 33
I 33
     * @return	a valid DataSource object for this DataHandler
E 33
E 19
E 18
E 9
     */
D 19
    public DataSource getDataSource()throws java.io.IOException {
D 10
	if(_dataSource == null) {
E 10
I 10
	if(dataSource == null) {
E 19
I 19
D 23
    public DataSource getDataSource() throws IOException {
E 23
I 23
D 33
    //    public DataSource getDataSource() throws IOException {
E 33
    public DataSource getDataSource() {
E 23
	if (dataSource == null) {
E 19
E 10
	    // create one on the fly
D 9
	    // 		    DataSource inner_source = 
	    // 			new DHDataSource( _object,
	    // 					  objectMimeType );
E 9
D 11
	    
D 7
	    System.out.println("Can't get data source yet!");
	    System.exit(1);
E 7
I 7
D 9
	    System.out.println("getDataSource on obj,mimeType not yet implemented");
	    //	    System.exit(1);
E 7
	    
	    //		    return inner_source;
E 9
I 9
	    if(objDataSource != null)
E 11
I 11
D 19
	    if(objDataSource == null)
E 19
I 19
	    if (objDataSource == null)
E 19
E 11
		objDataSource = new DataHandlerDataSource(this);
D 11

E 11
I 11
D 19
	    
E 19
E 11
	    return objDataSource;
E 9
	}
D 9
	
E 9
D 10
	return _dataSource;
E 10
I 10
	return dataSource;
E 10
    }
D 19
    
E 19
I 19

E 19
    /**
D 9
     * Return the name of the data object.
E 9
I 9
     * Return the name of the data object. If this DataHandler
     * was created with a DataSource, this method calls through
D 18
     * to <code>DataSource.getName,</code>, otherwise it will
     * return null.
E 18
I 18
D 19
     * to <code>DataSource.getName</code>, otherwise it will
E 19
I 19
D 26
     * to the <code>DataSource.getName</code> method, otherwise it will
E 19
     * return <i>null</i>.
E 26
I 26
D 33
     * to the <code>DataSource.getName</code> method, otherwise it 
E 33
I 33
     * to the <code>DataSource.getName</code> method, otherwise it
E 33
     * returns <i>null</i>.
E 26
E 18
E 9
     *
D 9
     * <p><i>Currently implemented to return null if the object was
     * created with the ojb/mimeType ctor</i></p>
E 9
D 19
     * @return The name of the object.  
E 19
I 19
     * @return	the name of the object
E 19
     */
    public String getName() {
D 10
	if(_dataSource != null)
	    return _dataSource.getName();
E 10
I 10
D 19
	if(dataSource != null)
E 19
I 19
	if (dataSource != null)
E 19
	    return dataSource.getName();
E 10
	else
	    return null;
    }

    /**
D 7
     * Return the <b>MIME</b> type of this object.
E 7
I 7
D 9
     * Return the MIME type of this object.
E 9
I 9
D 19
     * Return the MIME type of this object as retrieved from 
E 19
I 19
     * Return the MIME type of this object as retrieved from
E 19
     * the source object. Note that this is the <i>full</i>
D 19
     * type with parameters etc.
E 19
I 19
D 26
     * type with parameters, etc.
E 26
I 26
     * type with parameters.
E 26
E 19
E 9
E 7
     *
D 19
     * @return the MIME type.
E 19
I 19
     * @return	the MIME type
E 19
     */
    public String getContentType() {
D 7
	if(_objectMimeType == null) {
	    if(_dataSource == null) {
		try {
		    return this.getDataSource().getContentType();
		} catch (Exception e) {}
		return null;
	    }
	    else
		return _dataSource.getContentType();
	}
	else {
E 7
I 7
D 9
	if(_dataSource != null) 
E 9
I 9
D 10
	if(_dataSource != null) // data source case
E 9
	    return _dataSource.getContentType();
E 10
I 10
D 19
	if(dataSource != null) // data source case
E 19
I 19
	if (dataSource != null) // data source case
E 19
	    return dataSource.getContentType();
E 10
D 19
	else 	    
E 19
I 19
	else
E 19
E 7
D 9
	    return _objectMimeType;
E 9
I 9
D 10
	    return _objectMimeType; // obj/type case
E 10
I 10
	    return objectMimeType; // obj/type case
E 10
E 9
D 7
	}
E 7
    }
D 7
    
E 7
I 7

E 7
    /**
I 7
D 9
     * Get the InputStream
E 9
I 9
     * Get the InputStream for this object. <p>
E 9
     *
I 9
D 10
     * <b>DataHandlers instansiated with a DataSource:</b><p>
E 10
I 10
D 19
     * <b>DataHandlers instantiated with a DataSource:</b><p>
E 10
     *
     * The DataSources <code>getInputStream</code> method will be 
E 19
I 19
D 26
     * For DataHandlers instantiated with a DataSource
     * the <code>DataSource.getInputStream</code> method will be
E 19
     * called and the result returned to the caller.
E 26
I 26
D 33
     * For DataHandlers instantiated with a DataSource. the DataHandler
     * calls the <code>DataSource.getInputStream</code> method 
     * The result returned to the caller.
E 33
I 33
     * For DataHandlers instantiated with a DataSource, the DataHandler
     * calls the <code>DataSource.getInputStream</code> method and
     * returns the result to the caller.
E 33
E 26
     * <p>
D 19
     * <b>DataHandlers instansiated with an Object:</b><p>
     *
     * The DataHandler first attempts to find a DataContentHandler
E 19
I 19
D 26
     * For DataHandlers instantiated with an Object
E 26
I 26
D 33
     * For DataHandlers instantiated with an Object, 
E 26
     * the DataHandler first attempts to find a DataContentHandler
E 19
D 23
     * for the Object. If it is successful, a pipe is created
E 23
I 23
D 26
     * for the Object. If a DataContentHandler can not be found for
     * this MIME type, an UnsupportedDataTypeException is thrown.
     * If it is successful, a pipe is created
E 26
I 26
     * for the Object. If the DataHandler can not find a DataContentHandler 
     * for this MIME type, it throws an UnsupportedDataTypeException.
     * If it is successful, it creates a pipe 
E 26
E 23
     * between the returned InputStream and DataContentHandler's
D 10
     * <code>putByteStream</code> method which is called with
E 10
I 10
D 19
     * <code>writeTo</code> method which is called with
E 10
     * object's data. A thread is created which allows this operation
     * to complete asynchonously.
E 19
I 19
     * <code>writeTo</code> method, which is called with the
D 26
     * object's data. A thread is created that allows this operation
D 21
     * to complete asynchonously. <p>
E 21
I 21
     * to complete asynchonously. However because a thread is created
E 26
I 26
     * object's data. It creates a thread that allows this operation
     * to complete asynchonously. However, because a thread is created
E 26
     * to copy the data, IOExceptions that may occur during the
D 23
     * copy can not be propagated back to the called. The result
E 23
I 23
     * copy can not be propagated back to the caller. The result
E 23
D 26
     * will be an empty stream.<p>
E 26
I 26
     * is an empty stream.<p>
E 33
I 33
     * For DataHandlers instantiated with an Object, the DataHandler
     * first attempts to find a DataContentHandler for the Object. If
     * the DataHandler can not find a DataContentHandler for this MIME
     * type, it throws an UnsupportedDataTypeException.  If it is
     * successful, it creates a pipe and a thread.  The thread uses the
     * DataContentHandler's <code>writeTo</code> method to write the
     * stream data into one end of the pipe.  The other end of the pipe
     * is returned to the caller.  Because a thread is created to copy
     * the data, IOExceptions that may occur during the copy can not be
     * propagated back to the caller. The result is an empty stream.<p>
E 33
E 26
E 21
E 19
     *
I 23
D 33
     *
E 33
E 23
E 9
D 19
     * @return the InputStream representing this data
E 19
I 19
     * @return	the InputStream representing this data
     * @exception IOException	if an I/O error occurs
     *
E 19
I 9
D 10
     * @see javax.activation.DataContentHandler#putByteStream
E 10
I 10
     * @see javax.activation.DataContentHandler#writeTo
I 23
     * @see javax.activation.UnsupportedDataTypeException
E 23
E 10
E 9
     */
    public InputStream getInputStream() throws IOException {
D 33
	    InputStream ins = null;
E 33
I 33
	InputStream ins = null;
E 33

D 10
	    if(_dataSource != null) {
		ins = _dataSource.getInputStream();
	    }
	    else {
		DataContentHandler dch = getDataContentHandler(_objectMimeType);
		if(dch == null) 
		    dch = new ObjectDataContentHandler(_object, _objectMimeType);
E 10
I 10
D 19
	    if(dataSource != null) {
E 19
I 19
D 33
	    if (dataSource != null) {
E 19
		ins = dataSource.getInputStream();
	    } else {
		DataContentHandler dch = getDataContentHandler();
I 23
		// we won't even try if we can't get a dch
		if(dch == null)
E 33
I 33
	if (dataSource != null) {
	    ins = dataSource.getInputStream();
	} else {
	    DataContentHandler dch = getDataContentHandler();
	    // we won't even try if we can't get a dch
	    if (dch == null)
D 35
		throw new UnsupportedDataTypeException();
E 35
I 35
		throw new UnsupportedDataTypeException(
				"no DCH for MIME type " + getBaseType());
E 35

	    if (dch instanceof ObjectDataContentHandler) {
		if (((ObjectDataContentHandler)dch).getDCH() == null)
E 33
D 35
		    throw new UnsupportedDataTypeException();
E 35
I 35
		    throw new UnsupportedDataTypeException(
				"no object DCH for MIME type " + getBaseType());
E 35
D 25
		
E 25
I 25
D 33
	
D 30
		if(dch instanceof ObjectDataContentHandler)
E 30
I 30
		if(dch instanceof ObjectDataContentHandler) {
E 30
		    if(((ObjectDataContentHandler)dch).getDCH() == null) 
			throw new UnsupportedDataTypeException();
I 30
		}
E 30
		// there is none but the default^^^^^^^^^^^^^^^^
E 25
E 23
E 10
		final DataContentHandler fdch = dch;
E 33
I 33
	    }
	    // there is none but the default^^^^^^^^^^^^^^^^
	    final DataContentHandler fdch = dch;
E 33

D 33
		// from bill s.
D 23
		// ce n'est pas use pipe!
E 23
I 23
		// ce n'est pas une pipe!
E 23
		//
		// NOTE: This block of code needs to throw exceptions, but
		// can't because it is in another thread!!! ARG!
		//
		final PipedOutputStream pos = new PipedOutputStream();
		PipedInputStream pin = new PipedInputStream(pos);
D 19
		new Thread(	    
E 19
I 19
		new Thread(
E 19
			   new Runnable() {
		    public void run() {
			try {
D 10
			    fdch.putByteStream(_object, _objectMimeType, pos);
E 10
I 10
			    fdch.writeTo(object, objectMimeType, pos);
E 10
D 20
			} catch (Exception e) {
			    e.printStackTrace();
E 20
I 20
			} catch (IOException e) {
E 33
I 33
	    // from bill s.
	    // ce n'est pas une pipe!
	    //
	    // NOTE: This block of code needs to throw exceptions, but
	    // can't because it is in another thread!!! ARG!
	    //
	    final PipedOutputStream pos = new PipedOutputStream();
	    PipedInputStream pin = new PipedInputStream(pos);
	    new Thread(
		       new Runnable() {
		public void run() {
		    try {
			fdch.writeTo(object, objectMimeType, pos);
		    } catch (IOException e) {
E 33

E 20
D 33
			} finally {
			    try {
				pos.close();
D 20
			    } catch (IOException ie) {
D 9
				ie.printStackTrace();
E 9
I 9
				ie.printStackTrace(); // remove before FCS
E 9
			    }
E 20
I 20
			    } catch (IOException ie) { }
E 20
			}
E 33
I 33
		    } finally {
			try {
			    pos.close();
			} catch (IOException ie) { }
E 33
		    }
D 33
		},
			  "DataHandler.getInputStream" ).start();
		ins = pin;
	    }
E 33
I 33
		}
	    },
		      "DataHandler.getInputStream").start();
	    ins = pin;
	}
E 33
D 19
	    
E 19
I 19

E 19
D 33
	    return ins;
E 33
I 33
	return ins;
E 33
    }
D 19
        
E 19
I 19

E 19
    /**
E 7
I 4
D 9
     * Write the data to an <code>OutputStream</code>
E 9
I 9
D 18
     * Write the data to an <code>OutputStream</code><p>
E 18
I 18
     * Write the data to an <code>OutputStream</code>.<p>
E 18
E 9
     *
I 9
D 26
     * If the DataHandler was created with a DataSource,
     * the InputStream is retrieved, and the bytes from the
D 18
     * InputStream are read to the OutputStream passed in.
E 18
I 18
     * InputStream are written to the OutputStream passed in.
E 26
I 26
D 33
     * If the DataHandler was created with a DataSource, writeTo 
     * retrieves the InputStream and writes the bytes from the
E 33
I 33
     * If the DataHandler was created with a DataSource, writeTo
     * retrieves the InputStream and copies the bytes from the
E 33
     * InputStream to the OutputStream passed in.
E 26
E 18
     * <p>
D 19
     * If the DataHandler was created with an object, the 
E 19
I 19
D 26
     * If the DataHandler was created with an object, the
E 19
     * DataContentHandler for the object's type is retrieved
D 10
     * and if found, the <code>putByteStream</code> method
E 10
I 10
     * and if found, the <code>writeTo</code> method
E 10
D 18
     * on it is called.
E 18
I 18
     * on the <code>DataContentHandler</code> is called.
E 26
I 26
D 33
     * If the DataHandler was created with an object, writeTo 
     * retrieves the DataContentHandler for the object's type. 
     * If the DataContentHandler was found, it calls the 
E 33
I 33
     * If the DataHandler was created with an object, writeTo
     * retrieves the DataContentHandler for the object's type.
     * If the DataContentHandler was found, it calls the
E 33
     * <code>writeTo</code> method on the <code>DataContentHandler</code>.
E 26
E 18
D 19
     * 
E 9
     * @param os The OutputStream to write to
I 9
     * @exception java.io.IOException
E 19
I 19
     *
     * @param os	the OutputStream to write to
     * @exception IOException	if an I/O error occurs
E 19
E 9
     */
D 7
    public void putByteStream(OutputStream os) {
E 7
I 7
D 10
    public void putByteStream(OutputStream os) throws IOException {
E 10
I 10
    public void writeTo(OutputStream os) throws IOException {
E 10
E 7
	// for the DataSource case
D 10
	if(_dataSource != null) {
E 10
I 10
D 19
	if(dataSource != null) {
E 19
I 19
	if (dataSource != null) {
E 19
E 10
	    InputStream is = null;
D 33
	    byte data[] = new byte[1024];
E 33
I 33
	    byte data[] = new byte[8*1024];
E 33
D 7

	    try {
		is = _dataSource.getInputStream();
		while(is.read(data) > 0)
		    os.write(data);
	    } catch (Exception e) {}
E 7
I 7
	    int bytes_read;
D 19
	    
E 19
I 19

E 19
D 10
	    is = _dataSource.getInputStream();
E 10
I 10
	    is = dataSource.getInputStream();
E 10
D 19
	    
D 10
	    while(true){
		bytes_read = is.read(data);
		if(bytes_read > 0)
		    os.write(data, 0, bytes_read);
		else
		    break;
E 10
I 10
	    while((bytes_read = is.read(data)) > 0){
E 19
I 19

	    while ((bytes_read = is.read(data)) > 0) {
E 19
		os.write(data, 0, bytes_read);
E 10
D 19
	    } 
E 19
I 19
	    }
E 19
I 13
	    is.close();
E 13
E 7
D 33
	}
	else { // for the Object case
E 33
I 33
	} else { // for the Object case
E 33
D 10
	    DataContentHandler dch = getDataContentHandler(_objectMimeType);
	    if(dch == null) 
		dch = new ObjectDataContentHandler(_object, _objectMimeType);
D 7
	    
	    System.out.println("DataHandler.putByteStream not yet implemented for objects/mimeType");
	    
E 7
I 7

	    dch.putByteStream(_object, _objectMimeType, os);
E 10
I 10
	    DataContentHandler dch = getDataContentHandler();
	    dch.writeTo(object, objectMimeType, os);
E 10
E 7
	}
D 19
	
D 7
    }

E 7
I 7
    }   
E 19
I 19
D 33

E 33
    }

E 19
E 7
    /**
E 4
D 7
     * Get the InputStream
     *
     * @return the InputStream representing this data
     */
    public InputStream getInputStream() throws Exception {
	    InputStream ins = null;

	    if(_dataSource != null) {
		    try {
			ins = _dataSource.getInputStream();
		    } catch(Exception e) {}
	    }
	    else {
		// try to get out dataSource
		DataSource tmp_ds = this.getDataSource();
		
		if(tmp_ds != null)
		    ins = tmp_ds.getInputStream();
		
		// REMIND: need to add code that converts
		// obj => stream!
		
		// we need to try to use the DCH mechanisms to get 
		// a stream type
		
	    }
	    
	    return ins;
    }
    
    /**
E 7
D 9
     * Get the OutputStream
E 9
I 9
D 23
     * Get the OutputStream for this DataHandler. This method is
D 19
     * only valid with DataHandlers that were created with a 
E 19
I 19
     * only valid with DataHandlers that were created with a
E 19
     * DataSource. All others will return null.
E 23
I 23
D 26
     * Get the OutputStream for this DataHandler. This method will
     * attempt to return a valid OutputStream in DataHandlers <i>not</i>
E 26
I 26
D 33
     * Get the OutputStream for this DataHandler. This method 
     * attempts to return a valid OutputStream in DataHandlers <i>not</i>
E 26
     * created with the DataHandler(Object, String) constructor (in
D 26
     * which case it will return <i>null</i>). In other cases it will
     * return a valid OutputStream unless either
E 26
I 26
     * which case it returns <i>null</i>). In other cases, it 
     * returns a valid OutputStream unless either
E 26
     * the DataSource used to construct this DataHandler can not
     * provide an valid OutputStream, or the URL used to construct
     * this object can not return a valid OutputStream.
E 33
I 33
     * Get an OutputStream for this DataHandler to allow overwriting
     * the underlying data.
     * If the DataHandler was created with a DataSource, the
     * DataSource's <code>getOutputStream</code> method is called.
     * Otherwise, <code>null</code> is returned.
E 33
E 23
E 9
D 19
     * 
E 19
I 19
     *
E 19
     * @return the OutputStream
I 19
     *
E 19
I 9
     * @see javax.activation.DataSource#getOutputStream
I 23
     * @see javax.activation.URLDataSource
E 23
E 9
     */
D 7
    public OutputStream getOutputStream() throws Exception {
E 7
I 7
    public OutputStream getOutputStream() throws IOException {
E 7
D 33
	OutputStream ops = null;
D 19
	
D 10
	if(_dataSource != null)	{
D 7
	    try	{
		ops = _dataSource.getOutputStream();
	    } catch(Exception e) {  }
E 7
I 7
	    ops = _dataSource.getOutputStream();
E 10
I 10
	if(dataSource != null)	{
E 19
I 19

	if (dataSource != null) {
E 19
	    ops = dataSource.getOutputStream();
E 10
E 7
	}
D 7
	else {
	    // try to get out dataSource
	    DataSource tmp_ds = this.getDataSource();
	    
	    if(tmp_ds != null)
		ops = tmp_ds.getOutputStream();
	    // remind see get output stream
	    // same as above
	}

E 7
	return ops;
E 33
I 33
	if (dataSource != null)
	    return dataSource.getOutputStream();
	else
	    return null;
E 33
    }
D 19
    
E 19
I 19

E 19
    /**
D 18
     * (from Transferable)
E 18
D 19
     * Return the MIMETypes (DataFlavors) of this data
     * 
E 19
I 19
     * Return the DataFlavors in which this data is available. <p>
     *
E 19
D 18
     * The return value of this method is derived from the
     * the original type of this data as well as from the
     * possible Object types returned from a search of 
     * the available DataContentHanders.
     * @return the DataFlavors
E 18
I 18
     * Returns an array of DataFlavor objects indicating the flavors
D 19
     *  the data can be provided in. The array should be ordered
     *  according to preference for providing the data (from most
     *  richly descriptive to least descriptive). 
     *  
     * @return an array of data flavors in which this data can be transferred 
E 19
I 19
D 26
     * the data can be provided in. The array should be ordered
     * according to preference for providing the data (from most
D 23
     * richly descriptive to least descriptive).
E 23
I 23
     * richly descriptive to least descriptive).<p>
E 26
I 26
     * the data can be provided in. The array is usually ordered
D 33
     * according to preference for providing the data,from most
     * richly descriptive to least descriptive.<p>
E 33
I 33
     * according to preference for providing the data, from most
     * richly descriptive to least richly descriptive.<p>
E 33
E 26
E 23
     *
I 23
     * The DataHandler attempts to find a DataContentHandler that
     * corresponds to the MIME type of the data. If one is located,
D 26
     * the DataHandler returns the result of calling it's 
     * getTransferDataFlavors method. If a DataContentHandler can 
     * <i>not</i> be located, if the DataHandler was created with
     * a DataSource (or URL), one DataFlavor is returned that represents
E 26
I 26
D 33
     * the DataHandler calls the DataContentHandler's getTransferDataFlavors
     * method.  If a DataContentHandler can 
     * <i>not</i> be located, and if the DataHandler was created with
     * a DataSource (or URL); one DataFlavor is returned that represents
E 26
     * the <i>natural</i> type and format of the data (generally
D 26
     * this.getContentType/InputStream) and if the DataHandler was
     * created with an object and MIME type, one DataFlavor is 
     * returned that represents the this.getContentType/InputStream.
E 26
I 26
     * this.getContentType/InputStream). If the DataHandler was
     * created with an object and a MIME type; getTransferDataFlavors   
     * returns one DataFlavor that represents the this.getContentType/InputStream.
E 33
I 33
     * the DataHandler calls the DataContentHandler's
     * <code>getTransferDataFlavors</code> method. <p>
E 33
E 26
     *
I 33
     * If a DataContentHandler can <i>not</i> be located, and if the
     * DataHandler was created with a DataSource (or URL), one
     * DataFlavor is returned that represents this object's MIME type
     * and the <code>java.io.InputStream</code> class.  If the
     * DataHandler was created with an object and a MIME type,
     * getTransferDataFlavors returns one DataFlavor that represents
     * this object's MIME type and the object's class.
     *
E 33
E 23
     * @return	an array of data flavors in which this data can be transferred
I 23
     * @see javax.activation.DataContentHandler#getTransferDataFlavors
E 23
E 19
E 18
     */
D 10
    public DataFlavor[] getTransferDataFlavors() {
E 10
I 10
    public synchronized DataFlavor[] getTransferDataFlavors() {
D 19
	// (I might move this comment to the top level comment
	// but for now I'll leave the semantics here:
	//
	// NOTE: Will likely have to modify to make sure the 
	// sync if correct...
	//
	// We will cache the transferFlavors.
	//
E 19
E 10
I 4
D 33
	DataContentHandler dch = null;

I 31
	if(factory != oldFactory) // if the factory has been set, prime the pump
E 33
I 33
	if (factory != oldFactory) // if the factory has changed, clear cache
E 33
	    transferFlavors = emptyFlavors;

E 31
I 28
	if(factory != oldFactory) // if the factory has been set, prime the pump
	    transferFlavors = emptyFlavors;

E 28
E 4
D 10
	// forcibly update the list
	// check to see if we are build from a DataSource
	if( _dataSource != null ) {
E 10
I 10
D 33
	// if it's already set, use it...
D 19
	if(transferFlavors != emptyFlavors)
E 19
I 19
	if (transferFlavors != emptyFlavors)
E 19
	    return transferFlavors;
E 10
D 4
	    _transferFlavors = new DataFlavor[1];
	    _transferFlavors[0] = new DataFlavor(this.getContentType(),
						 this.getContentType());
E 4
I 4

D 10
	    // get a DCH first
D 9
	    dch = this.getDataContentHandler(this.getContentType());
E 9
I 9
	    dch = this.getDataContentHandler(this.getShortType());
E 9
	    if(dch == null) { // use the DCH of last resort
		dch = new DataSourceDataContentHandler(_dataSource);
	    }
	    _transferFlavors =  dch.getTransferDataFlavors();
E 4
	}
D 4
	else if(_object != null) { // we can atleast do the serialized object
	    _transferFlavors = new DataFlavor[1];
	    _transferFlavors[0] = new DataFlavor(_object.getClass(),
						 _object.getClass().getName());
E 4
I 4
D 7
	else if(_object != null) { 
E 7
I 7
	else  { 
E 7
	    _transferFlavors = new ActivationDataFlavor[2];
	    
	    // REMINDER: what do we use for a HPN? NOT CAFEBABE!
	    _transferFlavors[0] = new ActivationDataFlavor(_object.getClass(),
							   _objectMimeType,
							   "CAFEBABE");
	    _transferFlavors[1] = new ActivationDataFlavor(_objectMimeType,
						    "CAFEBABE");
E 4
	}
E 10
I 10
D 19
	// check to see if we are built from a DataSource
	//	if( dataSource != null ) {
E 10
D 4
	else {
	    _transferFlavors = null;
	}
	
E 4
I 4

E 4
D 10
	return _transferFlavors;
E 10
I 10

E 19
	dch = this.getDataContentHandler();
D 19
	transferFlavors =  dch.getTransferDataFlavors();
	// 	}
	// 	else  { 
	// 	    dch = this.getDataContentHandler();
	// 	    transferFlavors = dch.getTransferDataFlavors();
	// 	}

E 19
I 19
	transferFlavors = dch.getTransferDataFlavors();
E 33
I 33
	// if it's not set, set it...
	if (transferFlavors == emptyFlavors)
	    transferFlavors = getDataContentHandler().getTransferDataFlavors();
E 33
E 19
	return transferFlavors;
E 10
I 4
D 19
	
E 19
I 19
D 33

E 33
E 19
E 4
    }
D 19
    
    /** 
E 19
I 19

    /**
E 19
D 26
     * Returns whether or not the specified data flavor is supported
E 26
I 26
     * Returns whether the specified data flavor is supported
E 26
D 23
     * for this object.
E 23
I 23
     * for this object.<p>
E 23
D 19
     * @param flavor - the requested flovor for the data.
     * @return boolean indicating whether or not the data flavor is
     * supported.
     * 
E 19
I 19
     *
I 23
D 33
     * This method iterates through the DataFlavors available from
D 26
     * this object (the result of
     * a call to this.getTransferDataFlavors).
E 26
I 26
     * this object, which was the result of
     * a call to this.getTransferDataFlavors.
E 33
I 33
     * This method iterates through the DataFlavors returned from
     * <code>getTransferDataFlavors</code>, comparing each with
     * the specified flavor.
E 33
E 26
     *
E 23
     * @param flavor	the requested flavor for the data
     * @return		true if the data flavor is supported
I 23
     * @see javax.activation.DataHandler#getTransferDataFlavors
E 23
E 19
     */
    public boolean isDataFlavorSupported(DataFlavor flavor) {
D 19
	//
	// NOTE: This function also has the side effect of 
	// setting the _transferData variable if it isn't
	// set already
	//
E 19
D 10
	int numFlavors = 0;
	
E 10
D 7
	// jcm, 7/2/97
	//		if getTransferDataFlavors does the right thing
	//		when _transferFlavors is null, why is it being
	//		assigned to here?
	
	// jcm, 7/2/97
	//		better to call getTransferDataFlavors() and shadow
	//		the return value
E 7
	DataFlavor[] lFlavors = getTransferDataFlavors();
D 19
	
D 10
	// now make sure we got have some xfer flavors:
	if( lFlavors == null) 
	    return false; // we have none, return null
	
	// now try to make a match
	numFlavors = lFlavors.length;
	
D 7
	// jcm, 7/2/97:
	//		whoops, this should be incrementing i!
E 7
	for(int i = 0; i < numFlavors; ++i)
	    {
		if(lFlavors[i].equals(flavor))
		    return true;
	    }
E 10
I 10
	for(int i = 0; i < lFlavors.length; ++i) {
	    if(lFlavors[i].equals(flavor))
E 19
I 19

D 33
	for (int i = 0; i < lFlavors.length; ++i) {
E 33
I 33
	for (int i = 0; i < lFlavors.length; i++) {
E 33
	    if (lFlavors[i].equals(flavor))
E 19
		return true;
	}
E 10
	return false;
    }

D 19
    /** 
     * Returns an object which represents the data to be
E 19
I 19
    /**
     * Returns an object that represents the data to be
E 19
     * transferred. The class of the object returned is defined by the
D 19
     * representation class of the flavor.  
     * @param flavor - the requested flavor for the data
D 8
     * @returns the object
E 8
I 8
     * @return the object
E 19
I 19
D 23
     * representation class of the data flavor.
E 23
I 23
     * representation class of the data flavor.<p>
E 23
E 19
E 8
     *
I 23
     * <b>For DataHandler's created with DataSources or URLs:</b><p>
     *
     * The DataHandler attempts to locate a DataContentHandler
     * for this MIME type. If one is found, the passed in DataFlavor
D 33
     * and the type of the date are passed to it's getTransferData
E 33
I 33
     * and the type of the data are passed to its <code>getTransferData</code>
E 33
     * method. If the DataHandler fails to locate a DataContentHandler
D 33
     * the default behavior is to see if the DataFlavor requested
     * matches the <i>natural</i> type and representation class of
     * of the data and return it. Otherwise <i>null</i> is 
     * returned.<p>
E 33
I 33
     * and the flavor specifies this object's MIME type and the
     * <code>java.io.InputStream</code> class, this object's InputStream
     * is returned.
     * Otherwise it throws an UnsupportedFlavorException. <p>
E 33
     *
     * <b>For DataHandler's created with Objects:</b><p>
     *
     * The DataHandler attempts to locate a DataContentHandler
     * for this MIME type. If one is found, the passed in DataFlavor
D 33
     * and the type of the date are passed to it's getTransferData
E 33
I 33
     * and the type of the data are passed to its getTransferData
E 33
     * method. If the DataHandler fails to locate a DataContentHandler
D 33
     * the default behavior is to see if the DataFlavor requested
     * matches the <i>natural</i> type and representation class of
D 27
     * of the data and return it. Otherwise <i>null</i> is 
     * returned.<p>
E 27
I 27
     * of the data and return it. Otherwise it throws an UnsupportedFlavorException.
E 27
     * 
E 33
I 33
     * and the flavor specifies this object's MIME type and its class,
     * this DataHandler's referenced object is returned.  
     * Otherwise it throws an UnsupportedFlavorException.
     *
E 33
E 23
I 19
     * @param flavor	the requested flavor for the data
     * @return		the object
     * @exception UnsupportedFlavorException	if the data could not be
     *			converted to the requested flavor
     * @exception IOException	if an I/O error occurs
I 23
     * @see javax.activation.ActivationDataFlavor
E 23
E 19
     */
D 9
    public Object getTransferData(DataFlavor flavor) { 
D 4
	int numFlavors = 0;
E 4
I 4
	System.out.print("DataHandler: getTransferData called ");
E 9
I 9
D 19
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException { 
E 9
E 4
	
D 4
	// see if we have any transfer data
	_transferFlavors = this.getTransferDataFlavors();
	
	if( _transferFlavors == null )
	    return null;
	
	numFlavors = _transferFlavors.length;
	
	for(int i = 0; i < numFlavors; numFlavors++) {
	    if(_transferFlavors[i].equals(flavor)) {
		
		try {
		    if(flavor.getRepresentationClass() == 
		       Class.forName("java.io.InputStream")) {
			//
			// I think this fails if an input stream
			// is passed in.
			//
			if(_dataSource != null)
			    return this.getInputStream();
			else
			    return null; // hook for checking DCH
		    }
		} catch (Exception e) {}
E 4
I 4
D 10
	if(_dataSource != null) {
D 5
	    System.out.println("...got a DataSource");
E 5
	    DataContentHandler dch = this.getDataContentHandler(
D 9
						this.getContentType());
E 9
I 9
						this.getShortType());
E 9
	    if(dch == null) { // use the DCH of last resort
		dch = new DataSourceDataContentHandler(_dataSource);
E 4
	    }
D 4
	    else {
		//REMIND   
	    }
E 4
I 4
	    return dch.getTransferData(flavor, _dataSource);
E 10
I 10
	if(dataSource != null) {
E 19
I 19
    public Object getTransferData(DataFlavor flavor)
				throws UnsupportedFlavorException, IOException {
D 33
	if (dataSource != null) {
E 19
	    DataContentHandler dch = this.getDataContentHandler();
	    return dch.getTransferData(flavor, dataSource);
E 10
D 19
	    
E 19
I 19

E 19
E 4
	}
I 4
	else { // the object case
	    // for the live object case
D 24
	    try {
D 10
		if(flavor.getRepresentationClass() == _object.getClass() &&
		   flavor.getMimeType() == _objectMimeType) {
		    return _object;
E 10
I 10
D 19
		if(flavor.getRepresentationClass() == object.getClass() &&
E 19
I 19
		if (flavor.getRepresentationClass() == object.getClass() &&
E 19
		   flavor.getMimeType() == objectMimeType) {
		    return object;
E 10
		}
D 10
		else if(flavor.getMimeType() == _objectMimeType &&
E 10
I 10
D 19
		else if(flavor.getMimeType() == objectMimeType &&
E 10
			flavor.getRepresentationClass() == 
			Class.forName("java.io.InputStream")){
E 19
I 19
		else if (flavor.getMimeType() == objectMimeType &&
			flavor.getRepresentationClass() ==
			Class.forName("java.io.InputStream")) {
E 19
D 10
		    DataContentHandler dch = this.getDataContentHandler(
D 9
						     this.getContentType());
E 9
I 9
						     this.getShortType());
E 10
I 10
		    DataContentHandler dch = this.getDataContentHandler();
E 10
E 9
		    // REMIND ask Bill!!!!
		    return null;
		}
	    } catch(ClassNotFoundException e) {}
E 24
I 24
	    if (flavor.getRepresentationClass() == object.getClass() &&
		flavor.getMimeType() == objectMimeType) {
		return object;
	    }
	    else
D 27
		return null;
E 27
I 27
		throw new UnsupportedFlavorException(flavor);
	    //return null;
E 27
E 24
D 19
	    
		
E 19
	}
E 33
I 33
	return getDataContentHandler().getTransferData(flavor, dataSource);
E 33
E 4
D 24
	return null;
E 24
D 4
    }
    
E 4
I 4
D 19
    }    
E 19
I 19
    }

E 19
E 4
    /**
D 9
     * Set the CommandMap to use, DataHandler uses the 
     * CommandMap from the getDefaultCommandMap static method
     * in CommandMap by default.  
E 9
I 9
D 18
     * This method over rides the current CommandMap in
E 18
I 18
D 33
     * This method overrides the current CommandMap in
E 18
     * this DataHandler. Setting it to <code>null</code>
D 26
     * will cause the CommandMap to revert to the
E 26
I 26
     * causes the CommandMap to revert to the
E 26
D 19
     * CommandMap specified in CommandMap.getDefaultCommandMap.
E 19
I 19
     * CommandMap returned by the <code>CommandMap.getDefaultCommandMap</code>
     * method.
E 33
I 33
     * Set the CommandMap for use by this DataHandler.
     * Setting it to <code>null</code> causes the CommandMap to revert
     * to the CommandMap returned by the
     * <code>CommandMap.getDefaultCommandMap</code> method.
     * Changing the CommandMap, or setting it to <code>null</code>,
     * clears out any data cached from the previous CommandMap.
E 33
E 19
     *
D 19
     * @param commandMap The CommandMap to use in this DataHandler.
E 19
I 19
     * @param commandMap	the CommandMap to use in this DataHandler
     *
E 19
     * @see javax.activation.CommandMap#setDefaultCommandMap
E 9
     */
D 19
    public void setCommandMap(CommandMap commandMap) {
E 19
I 19
    public synchronized void setCommandMap(CommandMap commandMap) {
E 19
I 10
D 33
	// clear cached values...
	transferFlavors = emptyFlavors;
        dataContentHandler = null;
E 33
I 33
	if (commandMap != currentCommandMap || commandMap == null) {
	    // clear cached values...
	    transferFlavors = emptyFlavors;
	    dataContentHandler = null;
E 33

E 10
D 7
	// REMIND: do some error checking here!
	if(commandMap == null)
	    throw new NullPointerException();
E 7
D 4
	_commandMap = commandMap;
E 4
I 4
D 33
	currentCommandMap = commandMap;
E 33
I 33
	    currentCommandMap = commandMap;
	}
E 33
E 4
    }

    /**
I 33
     * Return the <i>preferred</i> commands for this type of data.
E 33
D 9
     * Get preferred command list from a MIME Type.
E 9
I 9
D 18
     * This method calls the CommandMap installed in this
     * instance of DataHandler's getPreferredCommands method.
E 18
I 18
D 19
     * This method calls the <code>getPreferredCommands</code> 
     * method in the commandMap installed in this instance of DataHandler.
E 18
     * The semantics of the method are intended to return
D 10
     * an array which represents the proper sub set of available
     * commands. In cases where multiple commands for the Mime
E 10
I 10
     * an array that represents the proper subset of available
     * commands. In cases where multiple commands for the MIME
E 10
     * type represented by this DataHandler are present, the
     * semantics of the installed CommandMap will choose the 
     * appropriate command to add to the array.
E 19
I 19
     * This method calls the <code>getPreferredCommands</code> method
D 33
     * in the commandMap installed in this instance of DataHandler.
E 33
I 33
     * in the CommandMap associated with this instance of DataHandler.
E 33
     * This method returns an array that represents a subset of
     * available commands. In cases where multiple commands for the
     * MIME type represented by this DataHandler are present, the
D 26
     * installed CommandMap will choose the appropriate commands.
E 26
I 26
     * installed CommandMap chooses the appropriate commands.
E 26
E 19
E 9
     *
D 18
     * @return the BeanInfo classes the represent the command Beans.
E 18
I 18
D 19
     * @return the CommandInfo classes the represent the command Beans.
E 19
I 19
     * @return	the CommandInfo objects representing the preferred commands
     *
E 19
E 18
I 9
     * @see javax.activation.CommandMap#getPreferredCommands
E 9
     */
D 4
    public BeanInfo[] getPreferredCommands(String mimeType) {// REMIND throws Exception;
E 4
I 4
D 7
    public BeanInfo[] getPreferredCommands() {// REMIND throws Exception;
E 7
I 7
D 11
    public BeanInfo[] getPreferredCommands() {
E 11
I 11
    public CommandInfo[] getPreferredCommands() {
E 11
E 7
E 4
D 19
	// see if it has been set 
E 19
D 33
	this.initDefaultCommandMap();
D 9
	
D 4
	return  _commandMap.getPreferredCommands(mimeType);
E 4
I 4
	return  currentCommandMap.getPreferredCommands(this.getContentType());
E 9
I 9
D 10
	return  currentCommandMap.getPreferredCommands(this.getShortType());
E 10
I 10
D 19
	return  currentCommandMap.getPreferredCommands(this.getBaseType());
E 19
I 19
	return currentCommandMap.getPreferredCommands(this.getBaseType());
E 33
I 33
	return getCommandMap().getPreferredCommands(getBaseType());
E 33
E 19
E 10
E 9
E 4
    }

    /**
I 33
     * Return all the commands for this type of data.
E 33
D 9
     * Get all the available commands for this type.
E 9
I 9
D 26
     * This method will return an array containing all commands
E 26
I 26
     * This method returns an array containing all commands
E 26
D 18
     * for the type of data. The 
     * Mime Type for the underlying data represented by this DataHandler
E 18
I 18
D 19
     * for the type of data represented in the <code>DataHandler</code>. The 
E 19
I 19
D 33
     * for the type of data represented in the <code>DataHandler</code>. The
E 19
     * MIME Type for the underlying data represented by this DataHandler
E 18
D 19
     * is used to call through to the getAllCommands method of this 
E 19
I 19
     * is used to call through to the <code>getAllCommands</code> method of the
E 19
     * currently installed CommandMap.
E 33
I 33
     * for the type of data represented by this DataHandler. The
     * MIME type for the underlying data represented by this DataHandler
     * is used to call through to the <code>getAllCommands</code> method
     * of the CommandMap associated with this DataHandler.
E 33
E 9
     *
D 18
     * @return returns the BeanInfo objects representing all the commands.
E 18
I 18
D 19
     * @return returns the CommandInfo objects representing all the commands.
E 18
I 9
     * @see javax.activation.CommandMap
E 9
     */        
D 4
    public BeanInfo[] getAllCommands(String mimeType) { // REMIND throws Exception
E 4
I 4
D 7
    public BeanInfo[] getAllCommands() { // REMIND throws Exception
E 7
I 7
D 11
    public BeanInfo[] getAllCommands() { 
E 11
I 11
    public CommandInfo[] getAllCommands() { 
E 19
I 19
     * @return	the CommandInfo objects representing all the commands
     *
     * @see javax.activation.CommandMap#getAllCommands
     */
    public CommandInfo[] getAllCommands() {
E 19
E 11
E 7
E 4
D 33
	this.initDefaultCommandMap();
D 4
	return _commandMap.getAllCommands(mimeType);
E 4
I 4
D 9
	return currentCommandMap.getAllCommands(this.getContentType());
E 9
I 9
D 10
	return currentCommandMap.getAllCommands(this.getShortType());
E 10
I 10
	return currentCommandMap.getAllCommands(this.getBaseType());
E 33
I 33
	return getCommandMap().getAllCommands(getBaseType());
E 33
E 10
E 9
E 4
    }
D 19
    
E 19
I 19

E 19
    /**
D 9
     * Get the default <code>command</code> corresonding to the MIME type. 
E 9
I 9
D 19
     * Get the command <i>cmdName</i>. Use the search semantics as 
E 19
I 19
     * Get the command <i>cmdName</i>. Use the search semantics as
E 19
     * defined by the CommandMap installed in this DataHandler. The
D 18
     * Mime Type for the underlying data represented by this DataHandler
E 18
I 18
     * MIME type for the underlying data represented by this DataHandler
E 18
D 19
     * is used to call through to the getCommand method of this currently 
     * installed CommandMap.
E 19
I 19
D 33
     * is used to call through to the <code>getCommand</code> method of the
     * currently installed CommandMap.
E 33
I 33
     * is used to call through to the <code>getCommand</code> method
     * of the CommandMap associated with this DataHandler.
E 33
E 19
E 9
     *
I 36
     * @param cmdName	the command name
E 36
D 18
     * @return the Bean Info corresponding to the command.
E 18
I 18
D 19
     * @return the CommandInfo corresponding to the command.
E 18
I 9
     * @see javax.activation.CommandMap
E 19
I 19
     * @return	the CommandInfo corresponding to the command
     *
     * @see javax.activation.CommandMap#getCommand
E 19
E 9
     */
D 4
    public BeanInfo getCommand(String mimeType, 
			       String cmdName) { // REMIND thows Exception;
E 4
I 4
D 7
    public BeanInfo getCommand(String cmdName) { // REMIND thows Exception;
E 7
I 7
D 11
    public BeanInfo getCommand(String cmdName) { 
E 11
I 11
D 19
    public CommandInfo getCommand(String cmdName) { 
E 19
I 19
    public CommandInfo getCommand(String cmdName) {
E 19
E 11
E 7
E 4
D 33
	this.initDefaultCommandMap();
D 4
	return _commandMap.getCommand(mimeType, cmdName);
E 4
I 4
D 9
	return currentCommandMap.getCommand(this.getContentType(), cmdName);
E 9
I 9
D 10
	return currentCommandMap.getCommand(this.getShortType(), cmdName);
E 10
I 10
	return currentCommandMap.getCommand(this.getBaseType(), cmdName);
E 33
I 33
	return getCommandMap().getCommand(getBaseType(), cmdName);
E 33
E 10
E 9
E 4
    }
D 19
    
E 19
I 19

E 19
D 3
    
E 3
    /**
I 7
D 18
     * This method returns the content of this DataHandler
E 18
I 18
D 19
     * This method uses a DataContentHandler to return the content
     * object for the data represented by this object. If no
E 19
I 19
     * Return the data in its preferred Object form. <p>
     *
     * If the DataHandler was instantiated with an object, return
     * the object. <p>
     *
     * If the DataHandler was instantiated with a DataSource,
     * this method uses a DataContentHandler to return the content
     * object for the data represented by this DataHandler. If no
E 19
     * <code>DataContentHandler</code> can be found for the
D 19
     * the type of this object, an <code>UnsupportedDataTypeException</code>
E 19
I 19
D 26
     * the type of this data, an <code>UnsupportedDataTypeException</code>
E 19
     * exception will be thrown.
E 26
I 26
D 33
     * the type of this data, the DataHandler throws an 
     * <code>UnsupportedDataTypeException</code> exception.
E 33
I 33
     * the type of this data, the DataHandler returns an
     * InputStream for the data.
E 33
E 26
E 18
E 7
I 3
     *
I 9
D 18
     * REMIND: FIX JDOCS
E 18
E 9
I 7
D 8
     * @returns the content.
E 8
I 8
     * @return the content.
I 19
D 23
     * @exception UnsupportedDataTypeException	if a needed DataContentHandler
     *						can not be found
E 23
I 23
     * @exception IOException if an IOException occurs during
     *                              this operation.
E 23
E 19
E 8
E 7
     */
D 10
    public Object getContent() {
D 4
	return null;
E 4
I 4
D 9
	
	if(_transferFlavors == null) {
D 5
	    System.out.println("debug: creating xfer flavors in getContent");
E 5
	    _transferFlavors = this.getTransferDataFlavors();
	}
	

	if(_transferFlavors == null) {
D 5
	    System.out.println("no flavors!!!");
E 5
	    return null;
	}
E 9
I 9
	DataContentHandler dch = this.getDataContentHandler(
						   this.getShortType());
E 10
I 10
    public Object getContent() throws IOException {
D 33
	DataContentHandler dch = this.getDataContentHandler();
E 10
D 18
	//
	// This method still needs some work...--bhc 10/20
	//
E 18
I 18

D 19

E 18
D 10
	try { // REMINDER FIX THIS!!!
E 10
D 11
	if(dch != null)
	    return dch.getContent(this.getDataSource());
E 11
I 11
	if(dch != null) {
E 19
I 19
D 23
	if (dch != null) {
E 19
	    DataSource my_ds = this.getDataSource();
E 23
I 23
	DataSource my_ds = this.getDataSource();
	return dch.getContent(my_ds);
E 23

E 33
I 33
	return getDataContentHandler().getContent(getDataSource());
E 33
D 23
	    return dch.getContent(my_ds);
D 17
	    //	    return dch.getContent(this.getDataSource());
	    }
E 11
E 9
	else
E 17
I 17
D 18
	} else
E 17
D 9
	    return this.getTransferData(_transferFlavors[0]);
E 9
I 9
	    return null;
E 18
I 18
	} else {
	    throw new UnsupportedDataTypeException();
	}
E 23
E 18
D 10
	} catch (Exception e) { e.printStackTrace(); }

	return null;

E 9
	
I 9
	// if it's not set, try to get the flavor
// 	if(_transferFlavors == null) {
// 	    _transferFlavors = this.getTransferDataFlavors();
// 	}
	
	// if it is still not set, return null
// 	if(_transferFlavors == null) {
// 	    return null;
// 	}
// 	else
// 	    return this.getTransferData(_transferFlavors[0]);
E 10
E 9
E 4
    }
I 19

E 19
    /**
E 3
D 18
     * A convenience method that takes a BeanInfo class 
     * and instansiates an instance of the associated JavaBean.
     * This method will check to see if the Bean implements 
     * <code>CommandObject</code> and if it does, will set the
     * DataHandler on it saving the user the extra step.
E 18
I 18
D 19
     * A convenience method that takes a CommandInfo class 
     * and instantiates an instance of the associated JavaBean.
E 19
I 19
     * A convenience method that takes a CommandInfo object
     * and instantiates the corresponding command, usually
     * a JavaBean component.
E 19
     * <p>
D 19
     * It will effectively call the cmdInfo's getCommandObject
E 19
I 19
D 33
     * This method calls the cmdInfo's <code>getCommandObject</code>
E 33
I 33
     * This method calls the CommandInfo's <code>getCommandObject</code>
E 33
E 19
     * method with the <code>ClassLoader</code> used to load
D 33
     * this object.
E 33
I 33
     * the <code>javax.activation.DataHandler</code> class itself.
E 33
E 18
D 19
     * @return The instantiated JavaBean
E 19
I 19
     *
I 36
     * @param cmdinfo	the CommandInfo corresponding to a command
E 36
     * @return	the instantiated command object
E 19
     */
D 11
    public Object getBean(BeanInfo binfo){
	BeanDescriptor bd = null;
E 11
I 11
D 19
    public Object getBean(CommandInfo cmdinfo){
E 19
I 19
    public Object getBean(CommandInfo cmdinfo) {
E 19
E 11
	Object bean = null;
D 19
	
D 11
	if( binfo != null )
E 11
I 11
	if( cmdinfo != null )
E 11
	    {
		Class _class = null; // class
		ClassLoader loader = this.getClass().getClassLoader();
		
		// get the descriptor ==> then the class
D 11
		bd = binfo.getBeanDescriptor();
		_class = bd.getBeanClass();
		
E 11
		try {
		    // make the bean
D 11
		    bean = java.beans.Beans.instantiate(loader,
							_class.getName());
E 11
I 11
		    bean = cmdinfo.getCommandObject(this, loader);
E 11
		} catch (Exception e) {
D 7
		    System.out.println("Ooops! Caught and exception in DataHandler.getBean:");
		    System.out.println( e );
		    System.exit(1);
E 7
I 7
		    e.printStackTrace();
E 7
		}
		
		// init the bean?
D 11
		if(bean instanceof CommandObject){
D 5
		    System.out.println("got a cmdobj");
E 5
		    ((CommandObject)bean).setDataHandler(this);
		}
E 11
I 11
		// if(bean instanceof CommandObject){
// 		    ((CommandObject)bean).initCommandContext(
// 					     cmdinfo.getCommandName(),this);
// 		}
E 19
I 19

D 20
	if (cmdinfo != null) {
E 20
I 20
D 33
// 	if (cmdinfo != null) {
E 20
	    ClassLoader loader = this.getClass().getClassLoader();
D 20

E 20
I 20
	    
E 20
	    // get the descriptor ==> then the class
	    try {
		// make the bean
		bean = cmdinfo.getCommandObject(this, loader);
D 20
	    } catch (Exception e) {
		e.printStackTrace();
E 19
E 11
	    }
I 19
	}
E 19
	else {
	    // REMIND: fix this!
	}
E 20
I 20
	    } catch (IOException e) { } catch(ClassNotFoundException e){}
E 33
I 33
	try {
	    // make the bean
	    bean = cmdinfo.getCommandObject(this, getClass().getClassLoader());
	} catch (IOException e) {
	} catch (ClassNotFoundException e) { }
E 33
E 20
D 19
	
	return bean; // for now
E 19
I 19

	return bean;
E 19
    }

I 4
D 19

E 19
E 4
    /**
I 4
D 19
     * get the DataContentHandler for this DataHandler:
E 19
I 19
D 33
     * Get the DataContentHandler for this DataHandler:
E 33
I 33
     * Get the DataContentHandler for this DataHandler: <p>
E 33
E 19
     *
D 19
     * The semantics are approximately as follows:
     *
     * if a DataContentHandlerFactory is set use it,
E 19
I 19
D 33
     * If a DataContentHandlerFactory is set use it.
E 33
I 33
     * If a DataContentHandlerFactory is set, use it.
E 33
E 19
     * Otherwise look for an object to serve DCH in the
D 33
     * following order:
E 33
I 33
     * following order: <p>
E 33
     *
D 19
     * 1) If a commandmap is set and it's a MCM use it
     * 2) If CM.getDefaultCM is an instance of MCM usr it
     * 3) If defaultMCM != null use it
     * 4) If defaultMCM is null, create a new one and use it
I 10
     * 5) Use the DCH of last resort of the data in the DH
E 19
I 19
D 33
     * 1) if a factory is set, use it
     * 2) if a CommandMap is set, use it
     * 3) use the default CommandMap
E 33
I 33
     * 1) if a factory is set, use it <p>
     * 2) if a CommandMap is set, use it <p>
     * 3) use the default CommandMap <p>
E 33
E 19
E 10
     *
D 19
     * @return The requested DataContentHandler or null if not found.
E 19
I 19
     * In any case, wrap the real DataContentHandler with one of our own
     * to handle any missing cases, fill in defaults, and to ensure that
     * we always have a non-null DataContentHandler.
     *
     * @return	the requested DataContentHandler
E 19
     */
D 10
    private DataContentHandler getDataContentHandler(String mimeType) {
	DataContentHandler dch = null;
D 9
	MimeType mt = null;
	try {
	    mt = new MimeType(mimeType);
	} catch(Exception e){}
	String simpleMT = mt.getPrimaryType() + "/" + mt.getSubType();
E 9
I 9
	String simpleMT = this.getShortType();
E 10
I 10
D 20
    private DataContentHandler getDataContentHandler() {
E 20
I 20
    private synchronized DataContentHandler getDataContentHandler() {
E 20
E 10
E 9

D 10
	if(_factory != null) {
	    dch = _factory.createDataContentHandler(simpleMT);
E 10
I 10
D 19
	if(dataContentHandler != null)
E 19
I 19
D 28
D 31
	if (dataContentHandler != null)
E 19
	    return dataContentHandler;
E 31
E 28
I 28
D 30
// 	if (dataContentHandler != null)
// 	    return dataContentHandler;
E 30
E 28
D 33

I 31
	// make sure the factory didn't change 

	if(factory != oldFactory){
E 33
I 33
	// make sure the factory didn't change
D 34
	if (factory != oldFactory){
E 34
I 34
	if (factory != oldFactory) {
E 34
E 33
	    oldFactory = factory;
	    factoryDCH = null;
	    dataContentHandler = null;
	    transferFlavors = emptyFlavors;
	}

E 31
I 28
	// make sure the factory didn't change 

	if(factory != oldFactory){
	    oldFactory = factory;
	    factoryDCH = null;
	    dataContentHandler = null;
	    transferFlavors = emptyFlavors;
	}

I 30
 	if (dataContentHandler != null)
 	    return dataContentHandler;

E 30
E 28
D 33
	String simpleMT = this.getBaseType();
E 33
I 33
	String simpleMT = getBaseType();
E 33

D 19
	if(factory != null) {
E 19
I 19
D 28
D 31
	if (factory != null) {
E 19
	    dataContentHandler = factory.createDataContentHandler(simpleMT);
E 31
I 31
D 33
	if (factoryDCH == null && factory != null) {
E 33
I 33
	if (factoryDCH == null && factory != null)
E 33
	    factoryDCH = factory.createDataContentHandler(simpleMT);
E 31
E 28
I 28
	if (factoryDCH == null && factory != null) {
	    factoryDCH = factory.createDataContentHandler(simpleMT);
E 28
E 10
D 7
	    
	    if(dch == null) {
		if(currentCommandMap != null &&
		   currentCommandMap instanceof MailcapCommandMap) {
		   dch = ((MailcapCommandMap)currentCommandMap).createDataContentHandler(simpleMT);
		} 
		else  { // check the value of getDefaultCommandMap
		    CommandMap sysDefaultCM = CommandMap.getDefaultCommandMap();
		    if(sysDefaultCM instanceof MailcapCommandMap) {
			dch = ((MailcapCommandMap)sysDefaultCM).createDataContentHandler(simpleMT); 
E 7
I 7
D 33
	}
E 33
D 19
	
D 10
	if(dch == null) {
E 10
I 10
	if(dataContentHandler == null) {
E 19
I 19

I 28
D 30
	if (factoryDCH != null)
	    dataContentHandler = factoryDCH;
E 30
I 30
 	if (factoryDCH != null)
 	    dataContentHandler = factoryDCH;
I 31

E 31
E 30

E 28
	if (dataContentHandler == null) {
E 19
E 10
D 16
	    if(currentCommandMap != null &&
	       currentCommandMap instanceof MailcapCommandMap) {
D 10
		dch = ((MailcapCommandMap)currentCommandMap).createDataContentHandler(simpleMT);
E 10
I 10
		dataContentHandler = ((MailcapCommandMap)currentCommandMap).createDataContentHandler(simpleMT);
E 10
	    } 
	    else  { // check the value of getDefaultCommandMap
		CommandMap sysDefaultCM = CommandMap.getDefaultCommandMap();
		if(sysDefaultCM instanceof MailcapCommandMap) {
D 10
		    dch = ((MailcapCommandMap)sysDefaultCM).createDataContentHandler(simpleMT); 
E 10
I 10
		    dataContentHandler = ((MailcapCommandMap)sysDefaultCM).createDataContentHandler(simpleMT); 
E 10
		}
		else {
		    if(sharedCommandMap == null) {
			sharedCommandMap = new MailcapCommandMap();
E 7
		    }
D 7
		    else {
			if(sharedCommandMap == null) {
			    sharedCommandMap = new MailcapCommandMap();
			}
			dch = sharedCommandMap.createDataContentHandler(simpleMT);
		    }
E 7
I 7
D 10
		    dch = sharedCommandMap.createDataContentHandler(simpleMT);
E 10
I 10
		    dataContentHandler = sharedCommandMap.createDataContentHandler(simpleMT);
E 10
E 7
		}
	    }
E 16
I 16
D 33
	    initDefaultCommandMap(); // make sure there is a command map
E 33
D 19
	    dataContentHandler = currentCommandMap.createDataContentHandler(simpleMT);
E 19
I 19
	    dataContentHandler =
D 33
			currentCommandMap.createDataContentHandler(simpleMT);
E 19
E 16
D 30
	}
E 30
I 30
	} 
	
E 33
I 33
			getCommandMap().createDataContentHandler(simpleMT);
	}
E 33
E 30
I 7
D 19
	
E 7
D 10
	return dch;
E 10
I 10
D 11
	// if we are STILL out of luck here, use the DCH of last 
	// resort:
	if(dataContentHandler == null) {
	    if(dataSource != null)
		dataContentHandler = new DataSourceDataContentHandler(
							        dataSource);
	    else
		dataContentHandler = new ObjectDataContentHandler(
								object, 
								objectMimeType);
	}
E 11
I 11
	// we will always use these 'wrapper' handlers 
E 19
I 19

D 26
	// we will always use these 'wrapper' handlers
E 19
	// to make sure we return SOMETHING meaningful...
E 26
I 26
	// getDataContentHandler always uses these 'wrapper' handlers
	// to make sure it returns SOMETHING meaningful...
E 26
D 19
	if(dataSource != null)
E 19
I 19
	if (dataSource != null)
E 19
	    dataContentHandler = new DataSourceDataContentHandler(
						      dataContentHandler,
						      dataSource);
	else
	    dataContentHandler = new ObjectDataContentHandler(
						      dataContentHandler,
D 19
						      object, 
E 19
I 19
						      object,
E 19
						      objectMimeType);
E 11
D 19
	
I 11
	
E 19
I 19
D 33


E 33
E 19
E 11
	return dataContentHandler;
E 10
    }
I 19

E 19
I 9
    /**
D 19
     * uses the MIME Type class to ensure to create a 'short' MimeType
     * the type is cached, 
E 19
I 19
D 33
     * Uses the MIME Type class to create a 'short' MimeType.
     * The type is cached,
E 33
I 33
     * Use the MimeType class to extract the MIME type/subtype,
     * ignoring the parameters.  The type is cached.
E 33
E 19
     */
D 10
    private String getShortType() {
E 10
I 10
D 19
    private String getBaseType() {
E 19
I 19
    private synchronized String getBaseType() {
E 19
E 10
D 33
	MimeType mt = null;
D 19
	
	if(shortType == null) {
E 19
I 19

E 33
I 33
D 35
	String ct = getContentType();
E 35
E 33
	if (shortType == null) {
I 35
	    String ct = getContentType();
E 35
E 19
	    try {
D 33
		mt = new MimeType(this.getContentType());
E 33
I 33
		MimeType mt = new MimeType(ct);
E 33
D 19
	    } catch(Exception e){}
E 19
I 19
D 20
	    } catch(Exception e) {}
E 20
I 20
D 32
	    } catch(MimeTypeParseException e) {}
E 20
E 19
D 10
	    shortType = mt.getPrimaryType() + "/" + mt.getSubType();
E 10
I 10
	    shortType = mt.getBaseType();
E 32
I 32
		shortType = mt.getBaseType();
D 33
	    } catch(MimeTypeParseException e) {
		shortType = this.getContentType();
E 33
I 33
	    } catch (MimeTypeParseException e) {
		shortType = ct;
E 33
	    }
E 32
E 10
	}
E 9
D 33

E 33
I 9
D 19
	return shortType;	
E 19
I 19
	return shortType;
E 19
    }
D 10
	    
	    
	
E 10
I 10
D 19
    
E 19
I 19

E 19
E 10
E 9
    /**
D 18
     * Sets the DataContentHandlerFactory. This will over
E 18
I 18
D 26
     * Sets the DataContentHandlerFactory. This will override
E 26
I 26
D 33
     * Sets the DataContentHandlerFactory. This overrides
E 26
E 18
D 19
     * ride all other places in the system where the 
E 19
I 19
     * all other places in the system where the
E 19
D 18
     * DataHandler might potentially look for DataContentHandlers.
E 18
I 18
     * <code>DataHandler</code> might potentially look for DataContentHandlers.
E 18
I 9
     * The DataContentHandler factory can only be set once.
E 33
I 33
     * Sets the DataContentHandlerFactory.  The DataContentHandlerFactory
     * is called first to find DataContentHandlers.
     * The DataContentHandlerFactory can only be set once.
E 33
I 22
     * <p>
     * If the DataContentHandlerFactory has already been set,
D 26
     * this method will throw an Error. The design pattern is
E 26
I 26
D 33
     * this method throws an Error. The design pattern is
E 26
     * same a java.net.URLConnection.setContentHandler.
E 33
I 33
     * this method throws an Error.
E 33
E 22
E 9
     *
D 19
     * @param factory the DataContentHandlerFactory
E 19
I 19
     * @param factory	the DataContentHandlerFactory
I 33
     * @exception Error	if the factory has already been defined.
E 33
     *
E 19
I 18
     * @see javax.activation.DataContentHandlerFactory
E 18
     */
D 5
    public static void setDataContentHandlerFactory(
				DataContentHandlerFactory factory) {
E 5
I 5
    public static synchronized void setDataContentHandlerFactory(
D 28
D 31
					 DataContentHandlerFactory factory) {
E 31
I 31
					 DataContentHandlerFactory newFactory) {
E 31
E 28
I 28
					 DataContentHandlerFactory newFactory) {
E 28
D 10
	if(_factory != null) {
E 10
I 10
D 33
	// transferFlavors = emptyFlavors;
	// dataContentHandler = null;
D 28
D 31

E 31
E 28
D 19
	if(DataHandler.factory != null) {
E 19
I 19
	if (DataHandler.factory != null) {
E 19
E 10
	    throw new Error("factory already defined");
	}
	// probably need some security stuff in here...
E 5
D 10
	_factory = factory;
E 10
I 10
D 28
D 31
	DataHandler.factory = factory;
E 31
I 31
	DataHandler.factory = newFactory;
E 33
I 33
	if (factory != null)
	    throw new Error("DataContentHandlerFactory already defined");
E 33

I 33
	SecurityManager security = System.getSecurityManager();
	if (security != null) {
	    try {
		// if it's ok with the SecurityManager, it's ok with me...
		security.checkSetFactory();
	    } catch (SecurityException ex) {
		// otherwise, we also allow it if this code and the
		// factory come from the same class loader (e.g.,
		// the JAF classes were loaded with the applet classes).
D 34
		try {
		    if (Class.forName("javax.activation.DataHandler").
			    getClassLoader() !=
			    newFactory.getClass().getClassLoader())
			throw ex;
		} catch (ClassNotFoundException ex2) {
		    // XXX - can never happen
E 34
I 34
		if (DataHandler.class.getClassLoader() !=
			newFactory.getClass().getClassLoader())
E 34
		    throw ex;
D 34
		}
E 34
	    }
	}
	factory = newFactory;
E 33
E 31
E 28
I 28
	DataHandler.factory = newFactory;

E 28
E 10
    }
D 10
	
E 10
I 10
D 19
    
E 19
I 19
D 33

E 33
E 19
}

E 10
D 19
    /**
E 4
     * _DataHanderDataSource is the inner class that implements the
     * DataSource interface in the case where the DataHandler is constructed 
     * and Object and a mimeType string.
     */
E 19
I 19
/**
D 26
 * DataHanderDataSource is the class that implements the
 * DataSource interface in the case where the DataHandler is constructed
E 26
I 26
 * The DataHanderDataSource class implements the
 * DataSource interface when the DataHandler is constructed
E 26
 * with an Object and a mimeType string.
 */
E 19
D 7
    private class DataHandlerDataSource implements DataSource {
E 7
I 7
D 9
//     private class DataHandlerDataSource implements DataSource {
E 7

D 7
	private String _mimeType = null;
	private String _name = null;
E 7
I 7
// 	private String _mimeType = null;
// 	private String _name = null;
E 7

D 7
	/**
	 * Returns an <code>InputStream</code> representing this object.
	 * @return the <code>InputStream</code>
	 */
	public InputStream getInputStream() throws Exception {
	    return null;
	}
E 7
I 7
// 	/**
// 	 * Returns an <code>InputStream</code> representing this object.
// 	 * @return the <code>InputStream</code>
// 	 */
// 	public InputStream getInputStream() throws Exception {
// 	    return null;
// 	}
E 9
I 9
D 10
    private class DataHandlerDataSource implements DataSource {
	DataHandler dataHandler = null;
E 9
E 7
	
D 7
	/**
	 * Returns the <code>OutputStream</code> for this object.
	 * @return the <code>OutputStream</code>.
	 */
	public OutputStream getOutputStream() throws Exception {
	    return null;
	}
E 7
I 7
D 9
// 	/**
// 	 * Returns the <code>OutputStream</code> for this object.
// 	 * @return the <code>OutputStream</code>.
// 	 */
// 	public OutputStream getOutputStream() throws Exception {
// 	    return null;
// 	}
E 7

D 7
	/**
	 * Returns the MIME type of the data represented by this object.
	 * @return the MIME type.
	 */
	public String getContentType() {
	    return _objectMimeType;
	}
E 7
I 7
// 	/**
// 	 * Returns the MIME type of the data represented by this object.
// 	 * @return the MIME type.
// 	 */
// 	public String getContentType() {
// 	    return _objectMimeType;
// 	}
E 7

D 7
	/**
	 * Returns the name of this object.
	 * @return the name of this object.
	 */
	public String getName(){
	    return null; // what else would it be?
	}
    }
E 7
I 7
// 	/**
// 	 * Returns the name of this object.
// 	 * @return the name of this object.
// 	 */
// 	public String getName(){
// 	    return null; // what else would it be?
// 	}
//     }
E 9
I 9
	/**
	 * The constructor
	 */
	public DataHandlerDataSource(DataHandler dh) {
	    this.dataHandler = dh;
	}
 	/**
 	 * Returns an <code>InputStream</code> representing this object.
 	 * @return the <code>InputStream</code>
 	 */
 	public InputStream getInputStream() throws IOException {
 	    return dataHandler.getInputStream();
 	}
	
 	/**
 	 * Returns the <code>OutputStream</code> for this object.
 	 * @return the <code>OutputStream</code>.
 	 */
 	public OutputStream getOutputStream() throws IOException {
 	    return dataHandler.getOutputStream();
 	}
	
 	/**
 	 * Returns the MIME type of the data represented by this object.
 	 * @return the MIME type.
 	 */
 	public String getContentType() {
 	    return dataHandler.getContentType();
 	}
	
 	/**
 	 * Returns the name of this object.
 	 * @return the name of this object.
 	 */
 	public String getName(){
 	    return dataHandler.getName(); // what else would it be?
 	}
E 10
I 10
class DataHandlerDataSource implements DataSource {
    DataHandler dataHandler = null;
D 19
    
E 19
I 19

E 19
    /**
D 19
     * The constructor
E 19
I 19
     * The constructor.
E 19
     */
    public DataHandlerDataSource(DataHandler dh) {
	this.dataHandler = dh;
E 10
    }
I 33

E 33
I 10
    /**
     * Returns an <code>InputStream</code> representing this object.
D 19
     * @return the <code>InputStream</code>
E 19
I 19
     * @return	the <code>InputStream</code>
E 19
     */
    public InputStream getInputStream() throws IOException {
	return dataHandler.getInputStream();
    }
E 10
E 9
E 7
D 19
    
E 19
I 19

E 19
I 10
    /**
     * Returns the <code>OutputStream</code> for this object.
D 19
     * @return the <code>OutputStream</code>.
E 19
I 19
     * @return	the <code>OutputStream</code>
E 19
     */
    public OutputStream getOutputStream() throws IOException {
	return dataHandler.getOutputStream();
    }
D 19
    
E 19
I 19

E 19
    /**
     * Returns the MIME type of the data represented by this object.
D 19
     * @return the MIME type.
E 19
I 19
     * @return	the MIME type
E 19
     */
    public String getContentType() {
	return dataHandler.getContentType();
    }
D 19
    
E 19
I 19

E 19
    /**
     * Returns the name of this object.
D 19
     * @return the name of this object.
E 19
I 19
     * @return	the name of this object
E 19
     */
D 19
    public String getName(){
E 19
I 19
    public String getName() {
E 19
	return dataHandler.getName(); // what else would it be?
    }
E 10
}
I 4

/*
 * DataSourceDataContentHandler
 *
D 19
 * This is a <i>private</i> DataContentHandler that support the default 
 * case in DataHandlers when there is no DCH to be found (the default
 * DCH)
E 19
I 19
 * This is a <i>private</i> DataContentHandler that wraps the real
 * DataContentHandler in the case where the DataHandler was instantiated
 * with a DataSource.
E 19
 */
class DataSourceDataContentHandler implements DataContentHandler {
I 10
    private DataSource ds = null;
    private DataFlavor transferFlavors[] = null;
I 11
    private DataContentHandler dch = null;
I 19

E 19
E 11
E 10
    /**
D 19
     * the constructor
E 19
I 19
     * The constructor.
E 19
     */
D 11
    public DataSourceDataContentHandler(DataSource ds) {
E 11
I 11
D 19
    public DataSourceDataContentHandler(DataContentHandler dch,
					DataSource ds) {
E 19
I 19
    public DataSourceDataContentHandler(DataContentHandler dch, DataSource ds) {
E 19
E 11
I 10
	this.ds = ds;
I 11
	this.dch = dch;
E 11
E 10
    }
I 19

E 19
    /**
D 19
     * return the DataFlavors for this <code>DataContentHandler</code>
     * @return The DataFlavors.
E 19
I 19
     * Return the DataFlavors for this <code>DataContentHandler</code>.
     * @return	the DataFlavors
E 19
     */
D 11
    public DataFlavor[] getTransferDataFlavors(){ // throws Exception;
E 11
I 11
D 19
    public DataFlavor[] getTransferDataFlavors(){ 
D 13
	DataFlavor tempFlavors[] = new DataFlavor[0];

	if(dch != null) { // is there a dch?
	    tempFlavors = dch.getTransferDataFlavors();
	}
E 13
E 11
D 9
	return null;
E 9
I 9
D 10
	return new DataFlavor[0];
E 10
I 10
	
I 11
D 13

E 11
	if(transferFlavors == null) {
D 11
	    transferFlavors = new DataFlavor[1];
E 11
I 11
	    transferFlavors = new DataFlavor[tempFlavors.length + 1];
E 11
	    
D 11
	    transferFlavors[0] = new ActivationDataFlavor(ds.getContentType(),
	       				       ds.getContentType());
E 11
I 11
	    for(int i = 0; i < tempFlavors.length; i++)
		transferFlavors[i] = tempFlavors[i];

D 12
	    transferFlavors[tempFlavors.length + 1] = 
E 12
I 12
	    transferFlavors[tempFlavors.length] = 
E 12
		new ActivationDataFlavor(ds.getContentType(),
					 ds.getContentType());
E 11
	}
E 13
I 13
D 15
	if(transferFlavors != null)
E 15
I 15
	if(transferFlavors == null)
E 15
	    if(dch != null) { // is there a dch?
E 19
I 19
    public DataFlavor[] getTransferDataFlavors() {

D 33
	if (transferFlavors == null)
E 33
I 33
	if (transferFlavors == null) {
E 33
	    if (dch != null) { // is there a dch?
E 19
		transferFlavors = dch.getTransferDataFlavors();
	    } else {
		transferFlavors = new DataFlavor[1];
D 19
		transferFlavors[0] = 
E 19
I 19
		transferFlavors[0] =
E 19
		    new ActivationDataFlavor(ds.getContentType(),
					     ds.getContentType());
	    }
E 13
D 19
	
E 19
I 19
D 33

E 33
I 33
	}
E 33
E 19
	return transferFlavors;
E 10
E 9
    }
I 19

E 19
    /**
D 19
     * return the Transfer Data of type DataFlavor from InputStream
     * @param df The DataFlavor.
     * @param ins The InputStream corresponding to the data.
     * @return The constructed Object.
E 19
I 19
     * Return the Transfer Data of type DataFlavor from InputStream.
     * @param df	the DataFlavor
     * @param ds	the DataSource
     * @return		the constructed Object
E 19
     */
D 10
    public Object getTransferData(DataFlavor df, DataSource ds){
	return null;
E 10
I 10
D 19
    public Object getTransferData(DataFlavor df, DataSource ds) throws 
    UnsupportedFlavorException, IOException{
D 11
	if(df.equals(transferFlavors[0])) // only have one now
E 11
I 11
	
	if(dch != null)
E 19
I 19
    public Object getTransferData(DataFlavor df, DataSource ds) throws
				UnsupportedFlavorException, IOException {

	if (dch != null)
E 19
	    return dch.getTransferData(df, ds);
D 19
	else if(df.equals(transferFlavors[0])) // only have one now
E 19
I 19
D 38
	else if (df.equals(transferFlavors[0])) // only have one now
E 38
I 38
	else if (df.equals(getTransferDataFlavors()[0])) // only have one now
E 38
E 19
E 11
	    return ds.getInputStream();
	else
D 33
	    return null;
E 33
I 33
	    throw new UnsupportedFlavorException(df);
E 33
E 10
    }
D 19
    
I 7
D 10
    public Object getContent(DataSource ds){ return null;}
E 10
I 10
    public Object getContent(DataSource ds) throws IOException { 
D 11
	return ds.getInputStream();
E 11
I 11
	
	if(dch != null)
E 19
I 19

    public Object getContent(DataSource ds) throws IOException {

	if (dch != null)
E 19
	    return dch.getContent(ds);
	else
	    return ds.getInputStream();
E 11
    }
E 10

E 7
    /**
D 13
     * return the InputStream, throws an exception if it cannot
     * construct an InputStream from the object type.
     */
D 11
    public InputStream getInputStream(Object obj){ // throws Exception;
	return null;
    }
E 11
I 11
//     public InputStream getInputStream(Object obj){ // throws Exception;
	
// 	if(dch != null)
// 	    return dch.getInputStream(obj);
// 	else
// 	    return null;
//     }
E 11
    /**
E 13
D 19
     * construct an object from a byte stream
     * (similar semantically to previous method, we are deciding
     *  which one to support)
E 19
I 19
     * Write the object to the output stream.
E 19
     */
D 5
    public void putByteStream(Object obj, OutputStream os) {}
	// throws Exception;
E 5
I 5
D 6
    public void putByteStream(Object obj, OutputStream os, String mimeType) 
E 6
I 6
D 7
    public void putByteStream(OutputStream os, Object obj, String mimeType) 
E 7
I 7
D 10
    public void putByteStream(Object obj, String mimeType, OutputStream os) 
E 10
I 10
D 19
    public void writeTo(Object obj, String mimeType, OutputStream os) 
E 10
E 7
E 6
	throws IOException {
D 11
	    System.out.println("DSDataContentHandler.writeto not implemented");
E 11
I 11
	    if(dch != null)
		dch.writeTo(obj, mimeType, os);
	    else
D 13
		System.out.println("DSDataContentHandler.writeto not implemented");
E 13
I 13
D 17
		throw new IOException("DSDCH.writeTo should never be called");
E 17
I 17
D 18
		throw new UnSupportedDataTypeException();
E 18
I 18
		throw new UnsupportedDataTypeException();
E 19
I 19
    public void writeTo(Object obj, String mimeType, OutputStream os)
						throws IOException {
	if (dch != null)
	    dch.writeTo(obj, mimeType, os);
	else
D 35
	    throw new UnsupportedDataTypeException();
E 35
I 35
	    throw new UnsupportedDataTypeException(
			"no DCH for content type " + ds.getContentType());
E 35
E 19
E 18
E 17
E 13
E 11
    }
E 5
}

/*
 * ObjectDataContentHandler
 *
D 19
 * This is a <i>private</i> DataContentHandler that support the default 
 * case in DataHandlers when there is no DCH to be found (the default
 * DCH)
E 19
I 19
 * This is a <i>private</i> DataContentHandler that wraps the real
 * DataContentHandler in the case where the DataHandler was instantiated
 * with an object.
E 19
 */
class ObjectDataContentHandler implements DataContentHandler {
D 10
    
E 10
I 10
    private DataFlavor transferFlavors[] = null;
E 10
    private Object obj;
    private String mimeType;
I 11
    private DataContentHandler dch = null;
E 11
D 19
    /** 
     * the constructor
E 19
I 19

    /**
     * The constructor.
E 19
     */
D 11
    public ObjectDataContentHandler(Object obj, String mimeType){
E 11
I 11
    public ObjectDataContentHandler(DataContentHandler dch,
D 19
				    Object obj, String mimeType){
E 19
I 19
				    Object obj, String mimeType) {
E 19
E 11
	this.obj = obj;
	this.mimeType = mimeType;
I 11
	this.dch = dch;
E 11
    }
I 19

E 19
    /**
I 25
D 33
     * return the datacontenthandler for this object
E 33
I 33
     * Return the DataContentHandler for this object.
     * Used only by the DataHandler class.
E 33
     */
D 34
    public DataContentHandler getDCH(){
E 34
I 34
    public DataContentHandler getDCH() {
E 34
	return dch;
    }
I 33

E 33
    /**
E 25
D 19
     * return the DataFlavors for this <code>DataContentHandler</code>
     * @return The DataFlavors.
E 19
I 19
     * Return the DataFlavors for this <code>DataContentHandler</code>.
     * @return	the DataFlavors
E 19
     */
D 11
    public DataFlavor[] getTransferDataFlavors(){ // throws Exception;
E 11
I 11
D 19
    public DataFlavor[] getTransferDataFlavors(){ 
D 13
	DataFlavor tempFlavors[] = new DataFlavor[0];
E 13
I 13
D 15
	if(transferFlavors != null)
E 15
I 15
	if(transferFlavors == null)
E 15
	    if(dch != null){
E 19
I 19
    public DataFlavor[] getTransferDataFlavors() {
D 33
	if (transferFlavors == null)
E 33
I 33
	if (transferFlavors == null) {
E 33
	    if (dch != null) {
E 19
		transferFlavors = dch.getTransferDataFlavors();
	    } else {
D 33
		transferFlavors = new DataFlavor[0];
D 19
		    
		transferFlavors[0] = 
E 19
I 19

		transferFlavors[0] =
E 19
D 23
		    new ActivationDataFlavor(mimeType,
E 23
I 23
		    new ActivationDataFlavor(obj.getClass(),
					     mimeType,
E 23
					     mimeType);
E 33
I 33
		transferFlavors = new DataFlavor[1];
		transferFlavors[0] = new ActivationDataFlavor(obj.getClass(),
					     mimeType, mimeType);
E 33
	    }
E 13
D 19
	
E 19
I 19
D 33

E 33
I 33
	}
E 33
E 19
D 13
	if(dch != null){
	    tempFlavors = dch.getTransferDataFlavors();
	}

E 11
D 9
	return null;
E 9
I 9
D 10
	return new DataFlavor[0];
E 10
I 10
	if(transferFlavors == null) {
D 11
	    transferFlavors = new DataFlavor[1];
E 11
I 11
	    transferFlavors = new DataFlavor[tempFlavors.length + 1];
E 11
	    
D 11
	    transferFlavors[0] = new ActivationDataFlavor(
					       obj.getClass(),
                                               mimeType,
					       mimeType);
E 11
I 11
	    for(int i = 0; i < tempFlavors.length; i++)
		transferFlavors[i] = tempFlavors[i];

D 12
	    transferFlavors[tempFlavors.length + 1] = 
E 12
I 12
	    transferFlavors[tempFlavors.length] = 
E 12
		new ActivationDataFlavor(mimeType,
					 mimeType);
E 11
	}
	
E 13
	return transferFlavors;
E 10
E 9
    }
I 19

E 19
    /**
D 19
     * return the Transfer Data of type DataFlavor from InputStream
     * @param df The DataFlavor.
     * @param ins The InputStream corresponding to the data.
     * @return The constructed Object.
E 19
I 19
     * Return the Transfer Data of type DataFlavor from InputStream.
     * @param df	the DataFlavor
     * @param ds	the DataSource
     * @return		the constructed Object
E 19
     */
D 10
    public Object getTransferData(DataFlavor df, DataSource ds){
E 10
I 10
D 19
    public Object getTransferData(DataFlavor df, DataSource ds) throws 
    UnsupportedFlavorException, IOException {
D 11
	
	if(df.equals(transferFlavors[0])) // only have one now
E 11
I 11
		
	if(dch != null)
E 19
I 19
    public Object getTransferData(DataFlavor df, DataSource ds)
				throws UnsupportedFlavorException, IOException {

	if (dch != null)
E 19
	    return dch.getTransferData(df, ds);
D 19
	else if(df.equals(transferFlavors[0])) // only have one now
E 19
I 19
	else if (df.equals(transferFlavors[0])) // only have one now
E 19
E 11
D 23
	    return ds.getInputStream();
E 23
I 23
	    return obj;
E 23
	else
D 33
	    return null;
E 33
I 33
	    throw new UnsupportedFlavorException(df);
E 33
I 11

E 11
    }
D 19
    public Object getContent(DataSource ds){
E 19
I 19

    public Object getContent(DataSource ds) {
E 19
E 10
D 11
	return null;
E 11
I 11
	return obj;
E 11
    }
I 7
D 10
    public Object getContent(DataSource ds){return null;}
E 10
E 7
D 19
    
E 19
I 19

E 19
    /**
D 13
     * return the InputStream, throws an exception if it cannot
     * construct an InputStream from the object type.
     */
D 10
    public InputStream getInputStream(Object obj){ // throws Exception;
E 10
I 10
    public InputStream getInputStream(Object obj) throws IOException { // throws Exception;
E 10
	return null;
    }
    /**
E 13
D 19
     * construct an object from a byte stream
     * (similar semantically to previous method, we are deciding
     *  which one to support)
E 19
I 19
     * Write the object to the output stream.
E 19
     */
D 5
    public void putByteStream(Object obj, OutputStream os) {
	System.out.println("ObjectDataContentHandler.putByteStream not implemented");
E 5
I 5
D 6
    public void putByteStream(Object obj, OutputStream os, String mimeType) 
E 6
I 6
D 7
    public void putByteStream(OutputStream os, Object obj, String mimeType) 
E 7
I 7
D 10
    public void putByteStream(Object obj, String mimeType, OutputStream os) 
E 10
I 10
D 19
    public void writeTo(Object obj, String mimeType, OutputStream os) 
E 10
E 7
E 6
	throws IOException {
D 11
	    System.out.println("ObjectDataContentHandler.writeto not implemented");
E 11
I 11
	    if(dch != null)
		dch.writeTo(obj, mimeType, os);
	    else
D 13
		System.out.println("ObjectDataContentHandler.writeto not implemented");
E 13
I 13
D 17
		throw new IOException();
E 17
I 17
D 18
		throw new UnSupportedDataTypeException();
E 18
I 18
		throw new UnsupportedDataTypeException();
E 19
I 19
    public void writeTo(Object obj, String mimeType, OutputStream os)
						throws IOException {
	if (dch != null)
	    dch.writeTo(obj, mimeType, os);
	else
D 35
	    throw new UnsupportedDataTypeException();
E 35
I 35
	    throw new UnsupportedDataTypeException(
				"no object DCH for MIME type " + this.mimeType);
E 35
E 19
E 18
E 17
E 13
E 11
E 5
    }
D 5
	// throws Exception;
E 5
}
D 19

E 19
I 10
D 14
//////////////////////////////////////////////////////////////////////////
/**
 * The URLConnectionDataSource class provides a DataSource wrapper around
 * the URLConnection class which allows for some URL support in the DataHandler
 * class.
 */
class URLConnectionDataSource implements DataSource {
    private URL url = null;
    private URLConnection url_conn = null;
E 10

I 10
    /**
     * The constructor for URLConnectionDataSource. It takes a 
I 13
     * URLConnectionDataSource. It takes a 
E 13
     * URL which it will lazily retrieve the URLConnection from.
     */
    public URLConnectionDataSource(URL url) {
	this.url = url;
    }
E 10

I 10
    public String getContentType(){
	try {
	    if(url_conn == null)
		url_conn = url.openConnection();
	} catch(IOException e){ 
	    e.printStackTrace();
	}
	
	if(url_conn != null)
	    return url_conn.getContentType();
	else
	    return null;
    }

    /**
     * The getName method from DataSource, always returns null
     * for now.
     */
    public String getName(){ 
	return null;
    }
    
    /**
     * The getOutputStream method from DataSource
     */
    public InputStream getInputStream() throws IOException {
	// get the url connection if it is available
	if(url_conn == null)
	    url_conn = url.openConnection();
	
	if(url_conn != null)
	    return url_conn.getInputStream();
	else
	    return null;
    }

    /**
     * The getOutputStream method from DataSource
     */
    public OutputStream getOutputStream() throws IOException {
	// get the url connection if it is available
	if(url_conn == null)
	    url_conn = url.openConnection();
	
	if(url_conn != null)
	    return url_conn.getOutputStream();
	else
	    return null;


    }

}
D 13


E 10



E 13
E 4

E 14
E 1
