/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.oshandler;

import jarinstaller.oshandler.IOsHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;

public abstract class defaultOsHandler
implements IOsHandler {
    public static final boolean onDebug = true;

    public String getOsShell() {
        return "";
    }

    public String getOsShellParam() {
        return "";
    }

    public String getOsName() {
        return OS_NAME;
    }

    public String getOsPrefix() {
        return OS_PREFIX;
    }

    public boolean isOs(String os) {
        return os.equalsIgnoreCase(OS_NAME);
    }

    public void setExecuteFlag(String filename) throws Exception {
    }

    public String getScriptPostfix() {
        return "";
    }

    public void showMessage(String message) {
    }

    public String getUserHomeDir() {
        this.showDebugMessage("user.home=" + System.getProperty("user.home"));
        return System.getProperty("user.home");
    }

    public void showDebugMessage(String message) {
    }

    public String getDebugInfo(String[] shellCommand) {
        StringBuffer debuginfo = new StringBuffer();
        for (int i = 0; i < shellCommand.length; ++i) {
            String s = shellCommand[i];
            debuginfo.append(s);
            debuginfo.append(" ");
        }
        return debuginfo.toString();
    }

    public String getStdError(Process p) {
        return this.getStdStream(p.getErrorStream());
    }

    public String getStdInput(Process p) {
        return this.getStdStream(p.getInputStream());
    }

    protected String getStdStream(InputStream is) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
        }
        catch (IOException e) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            e.printStackTrace();
            return e.getMessage();
        }
        return sb.toString();
    }

    public void closeProcess(Process p) {
        try {
            p.getOutputStream().close();
            p.getInputStream().close();
            p.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String executeShowResult(String command) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{this.getOsShell(), this.getOsShellParam(), command});
            String env = this.getStdInput(p);
            this.closeProcess(p);
            p = null;
            return env;
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                if (p != null) {
                    this.closeProcess(p);
                    p = null;
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            return "";
        }
    }

    public boolean writeFile(File destfile, Vector lines, String char_set_name, boolean append) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destfile, append), char_set_name)));
            for (int i = 0; i < lines.size(); ++i) {
                pw.println(lines.elementAt(i));
            }
            pw.flush();
            pw.close();
            Thread.sleep(500L);
            return true;
        }
        catch (Exception e) {
            try {
                if (pw != null) {
                    pw.close();
                }
                if (!append && destfile.exists()) {
                    destfile.delete();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            this.showMessage("File ki\u00edr\u00e1sa sikertelen: " + destfile);
            return false;
        }
    }

    public boolean searchStrInFile(File file, String str) {
        if (!file.exists()) {
            return false;
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                if (line.indexOf(str) == -1) continue;
                return true;
            }
            br.close();
            return false;
        }
        catch (Exception e) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean canCreateDesktopIcon() {
        return true;
    }

    public boolean canCreateMenuItem() {
        return true;
    }

    public String getDirtyEnvironmentVariable(String var, String userFile) {
        return this.getEnvironmentVariable(var);
    }

    public String getEnvFromFile(String var, String path) {
        String result = "";
        File file = new File(path);
        if (!file.exists()) {
            return result;
        }
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null && result.length() == 0) {
                String[] arr;
                if (line.toLowerCase().indexOf(var.toLowerCase()) == -1 || (arr = line.split("=")).length <= 1) continue;
                result = arr[1].trim();
            }
            br.close();
            return result;
        }
        catch (Exception e) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            return result;
        }
    }
}

