/* 
 Copyright (C) 2009 Red Hat, Inc.

 This file is part of IcedTea.

 IcedTea is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.

 IcedTea is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with IcedTea; see the file COPYING.  If not, write to
 the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 02110-1301 USA.

 Linking this library statically or dynamically with other modules is
 making a combined work based on this library.  Thus, the terms and
 conditions of the GNU General Public License cover the whole
 combination.

 As a special exception, the copyright holders of this library give you
 permission to link this library with independent modules to produce an
 executable, regardless of the license terms of these independent
 modules, and to copy and distribute the resulting executable under
 terms of your choice, provided that you also meet, for each linked
 independent module, the terms and conditions of the license of that
 module.  An independent module is a module which is not derived from
 or based on this library.  If you modify this library, you may extend
 this exception to your version of the library, but you are not
 obligated to do so.  If you do not wish to do so, delete this
 exception statement from your version.
 */
package net.sourceforge.jnlp.security.dialogresults;

import java.util.EnumSet;

public class Yes extends BasicDialogValue.PrimitivesSubset {

    public static Yes readValue(String s) {
        BasicDialogValue.Primitive x = BasicDialogValue.Primitive.valueOf(s);
        if (x == BasicDialogValue.Primitive.YES) {
            return new Yes();
        }
        throw new RuntimeException("Expected YES and only YES. Got" + x);

    }


    public Yes() {
        super(BasicDialogValue.Primitive.YES);
    }
    
    /**
     * To allow inheritance.
     * Overriders have to override getAllowedValues to work.
     * This one fails with anything else then Yes
     */
    protected Yes(BasicDialogValue.Primitive p) {
        super(p);
    }

    @Override
    public int getButtonIndex() {
        return BasicDialogValue.Primitive.YES.getLegacyButton();
    }

    @Override
    public EnumSet<BasicDialogValue.Primitive> getAllowedValues() {
        return BasicDialogValue.Yes;
    }

    @Override
    public String toString() {
        return writeValue();
    }
    
    

}
