/* xkblayout.c generated by valac 0.40.8, the Vala compiler
 * generated from xkblayout.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2014 Red Hat, Inc.
 * Copyright(c) 2014 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2014 Takao Fujiwara <tfujiwar@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ibus.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_XKB_LAYOUT (xkb_layout_get_type ())
#define XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XKB_LAYOUT, XKBLayout))
#define XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XKB_LAYOUT, XKBLayoutClass))
#define IS_XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XKB_LAYOUT))
#define IS_XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XKB_LAYOUT))
#define XKB_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XKB_LAYOUT, XKBLayoutClass))

typedef struct _XKBLayout XKBLayout;
typedef struct _XKBLayoutClass XKBLayoutClass;
typedef struct _XKBLayoutPrivate XKBLayoutPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecXKBLayout ParamSpecXKBLayout;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _XKBLayout {
	GTypeInstance parent_instance;
	volatile int ref_count;
	XKBLayoutPrivate * priv;
};

struct _XKBLayoutClass {
	GTypeClass parent_class;
	void (*finalize) (XKBLayout *self);
};

struct _XKBLayoutPrivate {
	gchar** m_xkb_latin_layouts;
	gint m_xkb_latin_layouts_length1;
	gint _m_xkb_latin_layouts_size_;
	gchar* m_default_layout;
	gchar* m_default_variant;
	gchar* m_default_option;
	gboolean m_use_xmodmap;
};

struct _ParamSpecXKBLayout {
	GParamSpec parent_instance;
};


static gpointer xkb_layout_parent_class = NULL;

gpointer xkb_layout_ref (gpointer instance);
void xkb_layout_unref (gpointer instance);
GParamSpec* param_spec_xkb_layout (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_xkb_layout (GValue* value,
                           gpointer v_object);
void value_take_xkb_layout (GValue* value,
                            gpointer v_object);
gpointer value_get_xkb_layout (const GValue* value);
GType xkb_layout_get_type (void) G_GNUC_CONST;
#define XKB_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_XKB_LAYOUT, XKBLayoutPrivate))
#define XKB_LAYOUT_XKB_COMMAND "setxkbmap"
#define XKB_LAYOUT_XKB_QUERY_ARG "-query"
#define XKB_LAYOUT_XKB_LAYOUT_ARG "-layout"
#define XKB_LAYOUT_XMODMAP_COMMAND "xmodmap"
XKBLayout* xkb_layout_new (void);
XKBLayout* xkb_layout_construct (GType object_type);
void xkb_layout_set_latin_layouts (XKBLayout* self,
                                   gchar** xkb_latin_layouts,
                                   int xkb_latin_layouts_length1);
static gchar** _vala_array_dup6 (gchar** self,
                          int length);
void xkb_layout_get_layout (gchar* * layout,
                            gchar* * variant,
                            gchar* * option);
static void _vala_array_add26 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add27 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void xkb_layout_set_layout (XKBLayout* self,
                            IBusEngineDesc* engine);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      gchar* needle);
static void _vala_array_add28 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add29 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add30 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add31 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add32 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add33 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add34 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add35 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void xkb_layout_run_xmodmap (XKBLayout* self);
void xkb_layout_set_use_xmodmap (XKBLayout* self,
                                 gboolean use_xmodmap);
static void xkb_layout_finalize (XKBLayout * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* XKB_LAYOUT_XMODMAP_KNOWN_FILES[4] = {".xmodmap", ".xmodmaprc", ".Xmodmap", ".Xmodmaprc"};

XKBLayout*
xkb_layout_construct (GType object_type)
{
	XKBLayout* self = NULL;
	self = (XKBLayout*) g_type_create_instance (object_type);
	return self;
}


XKBLayout*
xkb_layout_new (void)
{
	return xkb_layout_construct (TYPE_XKB_LAYOUT);
}


static gchar**
_vala_array_dup6 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void
xkb_layout_set_latin_layouts (XKBLayout* self,
                              gchar** xkb_latin_layouts,
                              int xkb_latin_layouts_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (xkb_latin_layouts != NULL) ? _vala_array_dup6 (xkb_latin_layouts, xkb_latin_layouts_length1) : ((gpointer) xkb_latin_layouts);
	_tmp0__length1 = xkb_latin_layouts_length1;
	self->priv->m_xkb_latin_layouts = (_vala_array_free (self->priv->m_xkb_latin_layouts, self->priv->m_xkb_latin_layouts_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_xkb_latin_layouts = _tmp0_;
	self->priv->m_xkb_latin_layouts_length1 = _tmp0__length1;
	self->priv->_m_xkb_latin_layouts_size_ = self->priv->m_xkb_latin_layouts_length1;
}


static void
_vala_array_add26 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add27 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void
xkb_layout_get_layout (gchar* * layout,
                       gchar* * variant,
                       gchar* * option)
{
	gchar* _vala_layout = NULL;
	gchar* _vala_variant = NULL;
	gchar* _vala_option = NULL;
	gchar** exec_command = NULL;
	gchar** _tmp0_;
	gint exec_command_length1;
	gint _exec_command_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* standard_output = NULL;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp15_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	exec_command = _tmp0_;
	exec_command_length1 = 0;
	_exec_command_size_ = exec_command_length1;
	_tmp1_ = exec_command;
	_tmp1__length1 = exec_command_length1;
	_tmp2_ = g_strdup (XKB_LAYOUT_XKB_COMMAND);
	_vala_array_add26 (&exec_command, &exec_command_length1, &_exec_command_size_, _tmp2_);
	_tmp3_ = exec_command;
	_tmp3__length1 = exec_command_length1;
	_tmp4_ = g_strdup (XKB_LAYOUT_XKB_QUERY_ARG);
	_vala_array_add27 (&exec_command, &exec_command_length1, &_exec_command_size_, _tmp4_);
	standard_output = NULL;
	standard_error = NULL;
	exit_status = 0;
	_tmp5_ = g_strdup ("");
	_g_free0 (_vala_layout);
	_vala_layout = _tmp5_;
	_tmp6_ = g_strdup ("");
	_g_free0 (_vala_variant);
	_vala_variant = _tmp6_;
	_tmp7_ = g_strdup ("");
	_g_free0 (_vala_option);
	_vala_option = _tmp7_;
	{
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp8_ = exec_command;
		_tmp8__length1 = exec_command_length1;
		g_spawn_sync (NULL, _tmp8_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error_);
		_g_free0 (standard_output);
		standard_output = _tmp9_;
		_g_free0 (standard_error);
		standard_error = _tmp10_;
		exit_status = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch15_g_spawn_error;
			}
			_g_free0 (standard_error);
			_g_free0 (standard_output);
			exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally15;
	__catch15_g_spawn_error:
	{
		GError* err = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "IBUS_ERROR: %s\n", _tmp14_);
		_g_error_free0 (err);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = exit_status;
	if (_tmp15_ != 0) {
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_;
		FILE* _tmp18_;
		_tmp17_ = standard_error;
		_tmp16_ = _tmp17_;
		if (_tmp16_ == NULL) {
			_tmp16_ = "";
		}
		_tmp18_ = stderr;
		fprintf (_tmp18_, "IBUS_ERROR: %s\n", _tmp16_);
	}
	_tmp19_ = standard_output;
	if (_tmp19_ == NULL) {
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
		if (layout) {
			*layout = _vala_layout;
		} else {
			_g_free0 (_vala_layout);
		}
		if (variant) {
			*variant = _vala_variant;
		} else {
			_g_free0 (_vala_variant);
		}
		if (option) {
			*option = _vala_option;
		} else {
			_g_free0 (_vala_option);
		}
		return;
	}
	_tmp20_ = standard_output;
	_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp22_;
		line_collection_length1 = _vala_array_length (_tmp21_);
		for (line_it = 0; line_it < _vala_array_length (_tmp21_); line_it = line_it + 1) {
			gchar* _tmp23_;
			gchar* line = NULL;
			_tmp23_ = g_strdup (line_collection[line_it]);
			line = _tmp23_;
			{
				gchar* element = NULL;
				gchar* _tmp24_;
				gchar* retval = NULL;
				gchar* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				_tmp24_ = g_strdup ("layout:");
				element = _tmp24_;
				_tmp25_ = g_strdup ("");
				retval = _tmp25_;
				_tmp26_ = line;
				_tmp27_ = element;
				if (g_str_has_prefix (_tmp26_, _tmp27_)) {
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					const gchar* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					gchar* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp39_;
					gchar* _tmp40_;
					_tmp28_ = line;
					_tmp29_ = element;
					_tmp30_ = strlen (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = line;
					_tmp33_ = strlen (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = string_slice (_tmp28_, (glong) _tmp31_, (glong) _tmp34_);
					_g_free0 (retval);
					retval = _tmp35_;
					_tmp36_ = retval;
					if (_tmp36_ != NULL) {
						const gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp37_ = retval;
						_tmp38_ = string_strip (_tmp37_);
						_g_free0 (retval);
						retval = _tmp38_;
					}
					_tmp39_ = retval;
					_tmp40_ = g_strdup (_tmp39_);
					_g_free0 (_vala_layout);
					_vala_layout = _tmp40_;
				}
				_tmp41_ = g_strdup ("variant:");
				_g_free0 (element);
				element = _tmp41_;
				_tmp42_ = g_strdup ("");
				_g_free0 (retval);
				retval = _tmp42_;
				_tmp43_ = line;
				_tmp44_ = element;
				if (g_str_has_prefix (_tmp43_, _tmp44_)) {
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					const gchar* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					gchar* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					_tmp45_ = line;
					_tmp46_ = element;
					_tmp47_ = strlen (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = line;
					_tmp50_ = strlen (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = string_slice (_tmp45_, (glong) _tmp48_, (glong) _tmp51_);
					_g_free0 (retval);
					retval = _tmp52_;
					_tmp53_ = retval;
					if (_tmp53_ != NULL) {
						const gchar* _tmp54_;
						gchar* _tmp55_;
						_tmp54_ = retval;
						_tmp55_ = string_strip (_tmp54_);
						_g_free0 (retval);
						retval = _tmp55_;
					}
					_tmp56_ = retval;
					_tmp57_ = g_strdup (_tmp56_);
					_g_free0 (_vala_variant);
					_vala_variant = _tmp57_;
				}
				_tmp58_ = g_strdup ("options:");
				_g_free0 (element);
				element = _tmp58_;
				_tmp59_ = g_strdup ("");
				_g_free0 (retval);
				retval = _tmp59_;
				_tmp60_ = line;
				_tmp61_ = element;
				if (g_str_has_prefix (_tmp60_, _tmp61_)) {
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					gint _tmp64_;
					gint _tmp65_;
					const gchar* _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gchar* _tmp69_;
					const gchar* _tmp70_;
					const gchar* _tmp73_;
					gchar* _tmp74_;
					_tmp62_ = line;
					_tmp63_ = element;
					_tmp64_ = strlen (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = line;
					_tmp67_ = strlen (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = string_slice (_tmp62_, (glong) _tmp65_, (glong) _tmp68_);
					_g_free0 (retval);
					retval = _tmp69_;
					_tmp70_ = retval;
					if (_tmp70_ != NULL) {
						const gchar* _tmp71_;
						gchar* _tmp72_;
						_tmp71_ = retval;
						_tmp72_ = string_strip (_tmp71_);
						_g_free0 (retval);
						retval = _tmp72_;
					}
					_tmp73_ = retval;
					_tmp74_ = g_strdup (_tmp73_);
					_g_free0 (_vala_option);
					_vala_option = _tmp74_;
				}
				_g_free0 (retval);
				_g_free0 (element);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (standard_error);
	_g_free0 (standard_output);
	exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
	if (layout) {
		*layout = _vala_layout;
	} else {
		_g_free0 (_vala_layout);
	}
	if (variant) {
		*variant = _vala_variant;
	} else {
		_g_free0 (_vala_variant);
	}
	if (option) {
		*option = _vala_option;
	} else {
		_g_free0 (_vala_option);
	}
}


static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void
_vala_array_add28 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add29 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add30 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add31 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add32 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add33 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add34 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add35 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void
xkb_layout_set_layout (XKBLayout* self,
                       IBusEngineDesc* engine)
{
	gchar* layout = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* variant = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* option = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean need_us_layout = FALSE;
	const gchar* _tmp16_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_;
	const gchar* _tmp27_;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_;
	const gchar* _tmp38_;
	gboolean _tmp39_ = FALSE;
	const gchar* _tmp40_;
	gboolean _tmp55_;
	gchar** args = NULL;
	gchar** _tmp61_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	gchar* _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	gchar* _tmp65_;
	gchar** _tmp66_;
	gint _tmp66__length1;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	const gchar* _tmp71_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	const gchar* _tmp81_;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gint _tmp99_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = ibus_engine_desc_get_layout (engine);
	_tmp1_ = g_strdup (_tmp0_);
	layout = _tmp1_;
	_tmp2_ = ibus_engine_desc_get_layout_variant (engine);
	_tmp3_ = g_strdup (_tmp2_);
	variant = _tmp3_;
	_tmp4_ = ibus_engine_desc_get_layout_option (engine);
	_tmp5_ = g_strdup (_tmp4_);
	option = _tmp5_;
	_tmp6_ = layout;
	_vala_assert (_tmp6_ != NULL, "layout != null");
	_tmp9_ = layout;
	if (g_strcmp0 (_tmp9_, "default") == 0) {
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		_tmp11_ = variant;
		if (g_strcmp0 (_tmp11_, "default") == 0) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp12_;
			_tmp12_ = variant;
			_tmp10_ = g_strcmp0 (_tmp12_, "") == 0;
		}
		_tmp8_ = _tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp14_ = option;
		if (g_strcmp0 (_tmp14_, "default") == 0) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = option;
			_tmp13_ = g_strcmp0 (_tmp15_, "") == 0;
		}
		_tmp7_ = _tmp13_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	need_us_layout = FALSE;
	_tmp16_ = variant;
	if (g_strcmp0 (_tmp16_, "eng") != 0) {
		const gchar* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp17_ = layout;
		_tmp18_ = self->priv->m_xkb_latin_layouts;
		_tmp18__length1 = self->priv->m_xkb_latin_layouts_length1;
		need_us_layout = _vala_string_array_contains (_tmp18_, _tmp18__length1, _tmp17_);
	}
	_tmp20_ = need_us_layout;
	if (!_tmp20_) {
		const gchar* _tmp21_;
		_tmp21_ = variant;
		_tmp19_ = _tmp21_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		_tmp22_ = layout;
		_tmp23_ = variant;
		_tmp24_ = g_strdup_printf ("%s(%s)", _tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->m_xkb_latin_layouts;
		_tmp26__length1 = self->priv->m_xkb_latin_layouts_length1;
		need_us_layout = _vala_string_array_contains (_tmp26_, _tmp26__length1, _tmp25_);
		_g_free0 (_tmp25_);
	}
	_tmp27_ = self->priv->m_default_layout;
	if (g_strcmp0 (_tmp27_, "") == 0) {
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		xkb_layout_get_layout (&_tmp28_, &_tmp29_, &_tmp30_);
		_g_free0 (self->priv->m_default_layout);
		self->priv->m_default_layout = _tmp28_;
		_g_free0 (self->priv->m_default_variant);
		self->priv->m_default_variant = _tmp29_;
		_g_free0 (self->priv->m_default_option);
		self->priv->m_default_option = _tmp30_;
	}
	_tmp32_ = layout;
	if (g_strcmp0 (_tmp32_, "default") == 0) {
		_tmp31_ = TRUE;
	} else {
		const gchar* _tmp33_;
		_tmp33_ = layout;
		_tmp31_ = g_strcmp0 (_tmp33_, "") == 0;
	}
	if (_tmp31_) {
		const gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp34_ = self->priv->m_default_layout;
		_tmp35_ = g_strdup (_tmp34_);
		_g_free0 (layout);
		layout = _tmp35_;
		_tmp36_ = self->priv->m_default_variant;
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (variant);
		variant = _tmp37_;
	}
	_tmp38_ = layout;
	if (g_strcmp0 (_tmp38_, "") == 0) {
		g_warning ("xkblayout.vala:148: Could not get the correct layout");
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	_tmp40_ = option;
	if (g_strcmp0 (_tmp40_, "default") == 0) {
		_tmp39_ = TRUE;
	} else {
		const gchar* _tmp41_;
		_tmp41_ = option;
		_tmp39_ = g_strcmp0 (_tmp41_, "") == 0;
	}
	if (_tmp39_) {
		const gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp42_ = self->priv->m_default_option;
		_tmp43_ = g_strdup (_tmp42_);
		_g_free0 (option);
		option = _tmp43_;
	} else {
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar** _tmp46_;
		gchar** _tmp47_;
		gchar** _tmp48_;
		gint _tmp48__length1;
		gboolean _tmp49_;
		_tmp44_ = option;
		_tmp45_ = self->priv->m_default_option;
		_tmp47_ = _tmp46_ = g_strsplit (_tmp45_, ",", 0);
		_tmp48_ = _tmp47_;
		_tmp48__length1 = _vala_array_length (_tmp46_);
		_tmp49_ = !_vala_string_array_contains (_tmp48_, _vala_array_length (_tmp46_), _tmp44_);
		_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
		if (_tmp49_) {
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp50_ = self->priv->m_default_option;
			_tmp51_ = option;
			_tmp52_ = g_strdup_printf ("%s,%s", _tmp50_, _tmp51_);
			_g_free0 (option);
			option = _tmp52_;
		} else {
			const gchar* _tmp53_;
			gchar* _tmp54_;
			_tmp53_ = self->priv->m_default_option;
			_tmp54_ = g_strdup (_tmp53_);
			_g_free0 (option);
			option = _tmp54_;
		}
	}
	_tmp55_ = need_us_layout;
	if (_tmp55_) {
		const gchar* _tmp56_;
		gchar* _tmp57_;
		const gchar* _tmp58_;
		_tmp56_ = layout;
		_tmp57_ = g_strconcat (_tmp56_, ",us", NULL);
		_g_free0 (layout);
		layout = _tmp57_;
		_tmp58_ = variant;
		if (_tmp58_ != NULL) {
			const gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp59_ = variant;
			_tmp60_ = g_strconcat (_tmp59_, ",", NULL);
			_g_free0 (variant);
			variant = _tmp60_;
		}
	}
	_tmp61_ = g_new0 (gchar*, 0 + 1);
	args = _tmp61_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp62_ = args;
	_tmp62__length1 = args_length1;
	_tmp63_ = g_strdup (XKB_LAYOUT_XKB_COMMAND);
	_vala_array_add28 (&args, &args_length1, &_args_size_, _tmp63_);
	_tmp64_ = args;
	_tmp64__length1 = args_length1;
	_tmp65_ = g_strdup (XKB_LAYOUT_XKB_LAYOUT_ARG);
	_vala_array_add29 (&args, &args_length1, &_args_size_, _tmp65_);
	_tmp66_ = args;
	_tmp66__length1 = args_length1;
	_tmp67_ = layout;
	_tmp68_ = g_strdup (_tmp67_);
	_vala_array_add30 (&args, &args_length1, &_args_size_, _tmp68_);
	_tmp71_ = variant;
	if (_tmp71_ != NULL) {
		const gchar* _tmp72_;
		_tmp72_ = variant;
		_tmp70_ = g_strcmp0 (_tmp72_, "") != 0;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		const gchar* _tmp73_;
		_tmp73_ = variant;
		_tmp69_ = g_strcmp0 (_tmp73_, "default") != 0;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		gchar** _tmp74_;
		gint _tmp74__length1;
		gchar* _tmp75_;
		gchar** _tmp76_;
		gint _tmp76__length1;
		const gchar* _tmp77_;
		gchar* _tmp78_;
		_tmp74_ = args;
		_tmp74__length1 = args_length1;
		_tmp75_ = g_strdup ("-variant");
		_vala_array_add31 (&args, &args_length1, &_args_size_, _tmp75_);
		_tmp76_ = args;
		_tmp76__length1 = args_length1;
		_tmp77_ = variant;
		_tmp78_ = g_strdup (_tmp77_);
		_vala_array_add32 (&args, &args_length1, &_args_size_, _tmp78_);
	}
	_tmp81_ = option;
	if (_tmp81_ != NULL) {
		const gchar* _tmp82_;
		_tmp82_ = option;
		_tmp80_ = g_strcmp0 (_tmp82_, "") != 0;
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		const gchar* _tmp83_;
		_tmp83_ = option;
		_tmp79_ = g_strcmp0 (_tmp83_, "default") != 0;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		gchar** _tmp84_;
		gint _tmp84__length1;
		gchar* _tmp85_;
		gchar** _tmp86_;
		gint _tmp86__length1;
		gchar* _tmp87_;
		gchar** _tmp88_;
		gint _tmp88__length1;
		const gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp84_ = args;
		_tmp84__length1 = args_length1;
		_tmp85_ = g_strdup ("-option");
		_vala_array_add33 (&args, &args_length1, &_args_size_, _tmp85_);
		_tmp86_ = args;
		_tmp86__length1 = args_length1;
		_tmp87_ = g_strdup ("-option");
		_vala_array_add34 (&args, &args_length1, &_args_size_, _tmp87_);
		_tmp88_ = args;
		_tmp88__length1 = args_length1;
		_tmp89_ = option;
		_tmp90_ = g_strdup (_tmp89_);
		_vala_array_add35 (&args, &args_length1, &_args_size_, _tmp90_);
	}
	standard_error = NULL;
	exit_status = 0;
	{
		gboolean _tmp91_ = FALSE;
		gchar** _tmp92_;
		gint _tmp92__length1;
		gchar* _tmp93_ = NULL;
		gint _tmp94_ = 0;
		gboolean _tmp95_;
		_tmp92_ = args;
		_tmp92__length1 = args_length1;
		_tmp95_ = g_spawn_sync (NULL, _tmp92_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp93_, &_tmp94_, &_inner_error_);
		_g_free0 (standard_error);
		standard_error = _tmp93_;
		exit_status = _tmp94_;
		_tmp91_ = _tmp95_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch16_g_spawn_error;
			}
			_g_free0 (standard_error);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!_tmp91_) {
			const gchar* _tmp96_;
			_tmp96_ = ibus_engine_desc_get_layout (engine);
			g_warning ("xkblayout.vala:195: Switch xkb layout to %s failed.", _tmp96_);
		}
	}
	goto __finally16;
	__catch16_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp97_;
		const gchar* _tmp98_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp97_ = e;
		_tmp98_ = _tmp97_->message;
		g_warning ("xkblayout.vala:198: Execute setxkbmap failed: %s", _tmp98_);
		_g_error_free0 (e);
		_g_free0 (standard_error);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (standard_error);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp99_ = exit_status;
	if (_tmp99_ != 0) {
		const gchar* _tmp100_ = NULL;
		const gchar* _tmp101_;
		_tmp101_ = standard_error;
		_tmp100_ = _tmp101_;
		if (_tmp100_ == NULL) {
			_tmp100_ = "(null)";
		}
		g_warning ("xkblayout.vala:203: Execute setxkbmap failed: %s", _tmp100_);
	}
	xkb_layout_run_xmodmap (self);
	_g_free0 (standard_error);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
}


void
xkb_layout_run_xmodmap (XKBLayout* self)
{
	gboolean _tmp0_;
	gchar* homedir = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_use_xmodmap;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = g_strdup (_tmp1_);
	homedir = _tmp2_;
	{
		const gchar** xmodmap_file_collection = NULL;
		gint xmodmap_file_collection_length1 = 0;
		gint _xmodmap_file_collection_size_ = 0;
		gint xmodmap_file_it = 0;
		xmodmap_file_collection = XKB_LAYOUT_XMODMAP_KNOWN_FILES;
		xmodmap_file_collection_length1 = G_N_ELEMENTS (XKB_LAYOUT_XMODMAP_KNOWN_FILES);
		for (xmodmap_file_it = 0; xmodmap_file_it < G_N_ELEMENTS (XKB_LAYOUT_XMODMAP_KNOWN_FILES); xmodmap_file_it = xmodmap_file_it + 1) {
			gchar* _tmp3_;
			gchar* xmodmap_file = NULL;
			_tmp3_ = g_strdup (xmodmap_file_collection[xmodmap_file_it]);
			xmodmap_file = _tmp3_;
			{
				gchar* xmodmap_filepath = NULL;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar** args = NULL;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar** _tmp11_;
				gint args_length1;
				gint _args_size_;
				_tmp4_ = homedir;
				_tmp5_ = xmodmap_file;
				_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
				xmodmap_filepath = _tmp6_;
				_tmp7_ = xmodmap_filepath;
				if (!g_file_test (_tmp7_, G_FILE_TEST_EXISTS)) {
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					continue;
				}
				_tmp8_ = g_strdup (XKB_LAYOUT_XMODMAP_COMMAND);
				_tmp9_ = xmodmap_filepath;
				_tmp10_ = g_strdup (_tmp9_);
				_tmp11_ = g_new0 (gchar*, 2 + 1);
				_tmp11_[0] = _tmp8_;
				_tmp11_[1] = _tmp10_;
				args = _tmp11_;
				args_length1 = 2;
				_args_size_ = args_length1;
				{
					gchar** _tmp12_;
					gint _tmp12__length1;
					_tmp12_ = args;
					_tmp12__length1 = args_length1;
					g_spawn_async (NULL, _tmp12_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_SPAWN_ERROR) {
							goto __catch17_g_spawn_error;
						}
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (xmodmap_filepath);
						_g_free0 (xmodmap_file);
						_g_free0 (homedir);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				goto __finally17;
				__catch17_g_spawn_error:
				{
					GError* e = NULL;
					GError* _tmp13_;
					const gchar* _tmp14_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp13_ = e;
					_tmp14_ = _tmp13_->message;
					g_warning ("xkblayout.vala:241: Execute xmodmap is failed: %s\n", _tmp14_);
					_g_error_free0 (e);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					_g_free0 (homedir);
					return;
				}
				__finally17:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					_g_free0 (homedir);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (xmodmap_filepath);
				_g_free0 (xmodmap_file);
				break;
			}
		}
	}
	_g_free0 (homedir);
}


void
xkb_layout_set_use_xmodmap (XKBLayout* self,
                            gboolean use_xmodmap)
{
	g_return_if_fail (self != NULL);
	self->priv->m_use_xmodmap = use_xmodmap;
}


static void
value_xkb_layout_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
value_xkb_layout_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		xkb_layout_unref (value->data[0].v_pointer);
	}
}


static void
value_xkb_layout_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = xkb_layout_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
value_xkb_layout_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
value_xkb_layout_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		XKBLayout * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = xkb_layout_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
value_xkb_layout_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	XKBLayout ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = xkb_layout_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
param_spec_xkb_layout (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecXKBLayout* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_XKB_LAYOUT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
value_get_xkb_layout (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT), NULL);
	return value->data[0].v_pointer;
}


void
value_set_xkb_layout (GValue* value,
                      gpointer v_object)
{
	XKBLayout * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_XKB_LAYOUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		xkb_layout_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xkb_layout_unref (old);
	}
}


void
value_take_xkb_layout (GValue* value,
                       gpointer v_object)
{
	XKBLayout * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_XKB_LAYOUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xkb_layout_unref (old);
	}
}


static void
xkb_layout_class_init (XKBLayoutClass * klass)
{
	xkb_layout_parent_class = g_type_class_peek_parent (klass);
	((XKBLayoutClass *) klass)->finalize = xkb_layout_finalize;
	g_type_class_add_private (klass, sizeof (XKBLayoutPrivate));
}


static void
xkb_layout_instance_init (XKBLayout * self)
{
	gchar** _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = XKB_LAYOUT_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_xkb_latin_layouts = _tmp0_;
	self->priv->m_xkb_latin_layouts_length1 = 0;
	self->priv->_m_xkb_latin_layouts_size_ = self->priv->m_xkb_latin_layouts_length1;
	_tmp1_ = g_strdup ("");
	self->priv->m_default_layout = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->m_default_variant = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->m_default_option = _tmp3_;
	self->priv->m_use_xmodmap = TRUE;
	self->ref_count = 1;
}


static void
xkb_layout_finalize (XKBLayout * obj)
{
	XKBLayout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_XKB_LAYOUT, XKBLayout);
	g_signal_handlers_destroy (self);
	self->priv->m_xkb_latin_layouts = (_vala_array_free (self->priv->m_xkb_latin_layouts, self->priv->m_xkb_latin_layouts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->m_default_layout);
	_g_free0 (self->priv->m_default_variant);
	_g_free0 (self->priv->m_default_option);
}


GType
xkb_layout_get_type (void)
{
	static volatile gsize xkb_layout_type_id__volatile = 0;
	if (g_once_init_enter (&xkb_layout_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_xkb_layout_init, value_xkb_layout_free_value, value_xkb_layout_copy_value, value_xkb_layout_peek_pointer, "p", value_xkb_layout_collect_value, "p", value_xkb_layout_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (XKBLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xkb_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XKBLayout), 0, (GInstanceInitFunc) xkb_layout_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType xkb_layout_type_id;
		xkb_layout_type_id = g_type_register_fundamental (g_type_fundamental_next (), "XKBLayout", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&xkb_layout_type_id__volatile, xkb_layout_type_id);
	}
	return xkb_layout_type_id__volatile;
}


gpointer
xkb_layout_ref (gpointer instance)
{
	XKBLayout * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
xkb_layout_unref (gpointer instance)
{
	XKBLayout * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		XKB_LAYOUT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



