/* panelbinding.c generated by valac 0.40.8, the Vala compiler
 * generated from panelbinding.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2018 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2018 Takao Fujwiara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ibus.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gdk/gdkwayland.h>


#define TYPE_PREEDIT (preedit_get_type ())
#define PREEDIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREEDIT, Preedit))
#define PREEDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREEDIT, PreeditClass))
#define IS_PREEDIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREEDIT))
#define IS_PREEDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREEDIT))
#define PREEDIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREEDIT, PreeditClass))

typedef struct _Preedit Preedit;
typedef struct _PreeditClass PreeditClass;
typedef struct _PreeditPrivate PreeditPrivate;
enum  {
	PREEDIT_0_PROPERTY,
	PREEDIT_NUM_PROPERTIES
};
static GParamSpec* preedit_properties[PREEDIT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PANEL_BINDING (panel_binding_get_type ())
#define PANEL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL_BINDING, PanelBinding))
#define PANEL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL_BINDING, PanelBindingClass))
#define IS_PANEL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL_BINDING))
#define IS_PANEL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL_BINDING))
#define PANEL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL_BINDING, PanelBindingClass))

typedef struct _PanelBinding PanelBinding;
typedef struct _PanelBindingClass PanelBindingClass;
typedef struct _PanelBindingPrivate PanelBindingPrivate;

#define TYPE_IBUS_EMOJIER (ibus_emojier_get_type ())
#define IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IBUS_EMOJIER, IBusEmojier))
#define IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IBUS_EMOJIER, IBusEmojierClass))
#define IS_IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IBUS_EMOJIER))
#define IS_IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IBUS_EMOJIER))
#define IBUS_EMOJIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IBUS_EMOJIER, IBusEmojierClass))

typedef struct _IBusEmojier IBusEmojier;
typedef struct _IBusEmojierClass IBusEmojierClass;
enum  {
	PANEL_BINDING_0_PROPERTY,
	PANEL_BINDING_NUM_PROPERTIES
};
static GParamSpec* panel_binding_properties[PANEL_BINDING_NUM_PROPERTIES];
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Preedit {
	GtkWindow parent_instance;
	PreeditPrivate * priv;
};

struct _PreeditClass {
	GtkWindowClass parent_class;
};

struct _PreeditPrivate {
	GtkLabel* m_extension_preedit_text;
	GtkLabel* m_extension_preedit_emoji;
	IBusText* m_engine_preedit_text;
	gboolean m_engine_preedit_text_show;
	guint m_engine_preedit_cursor_pos;
	gchar* m_prefix;
	gboolean m_is_shown;
};

struct _PanelBinding {
	IBusPanelService parent_instance;
	PanelBindingPrivate * priv;
};

struct _PanelBindingClass {
	IBusPanelServiceClass parent_class;
};

struct _PanelBindingPrivate {
	gboolean m_is_wayland;
	gboolean m_wayland_lookup_table_is_visible;
	IBusBus* m_bus;
	GtkApplication* m_application;
	GSettings* m_settings_panel;
	GSettings* m_settings_emoji;
	gchar* m_current_context_path;
	gchar* m_real_current_context_path;
	IBusEmojier* m_emojier;
	guint m_emojier_set_emoji_lang_id;
	guint m_emojier_focus_commit_text_id;
	gchar** m_emojier_favorites;
	gint m_emojier_favorites_length1;
	gint _m_emojier_favorites_size_;
	GtkCssProvider* m_css_provider;
	gboolean m_load_emoji_at_startup;
	gboolean m_loaded_emoji;
	gboolean m_load_unicode_at_startup;
	gboolean m_loaded_unicode;
	gboolean m_enable_extension;
	gchar* m_extension_name;
	Preedit* m_preedit;
	IBusProcessKeyEventData m_key_event_data;
};


static gpointer preedit_parent_class = NULL;
static gpointer panel_binding_parent_class = NULL;

GType preedit_get_type (void) G_GNUC_CONST;
#define PREEDIT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREEDIT, PreeditPrivate))
Preedit* preedit_new (void);
Preedit* preedit_construct (GType object_type);
void preedit_hide (Preedit* self);
void preedit_reset (Preedit* self);
gboolean preedit_is_shown (Preedit* self);
void preedit_set_emoji (Preedit* self,
                        const gchar* text);
void preedit_set_text (Preedit* self,
                       const gchar* text);
void preedit_append_text (Preedit* self,
                          const gchar* text);
gchar* preedit_get_text (Preedit* self);
gchar* preedit_get_emoji (Preedit* self);
gboolean preedit_backspace (Preedit* self);
static gchar* preedit_get_extension_text (Preedit* self);
static void preedit_set_preedit_color (Preedit* self,
                                IBusText* text,
                                guint start_index,
                                guint end_index);
IBusText* preedit_get_engine_preedit_text (Preedit* self);
void preedit_set_engine_preedit_text (Preedit* self,
                                      IBusText* text);
void preedit_show_engine_preedit_text (Preedit* self);
void preedit_hide_engine_preedit_text (Preedit* self);
guint preedit_get_engine_preedit_cursor_pos (Preedit* self);
void preedit_set_engine_preedit_cursor_pos (Preedit* self,
                                            guint cursor_pos);
IBusText* preedit_get_commit_text (Preedit* self);
void preedit_set_extension_name (Preedit* self,
                                 const gchar* extension_name);
static void preedit_finalize (GObject * obj);
GType panel_binding_get_type (void) G_GNUC_CONST;
GType ibus_emojier_get_type (void) G_GNUC_CONST;
#define PANEL_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PANEL_BINDING, PanelBindingPrivate))
#define PANEL_BINDING_PRELOAD_ENGINES_DELAY_TIME ((guint) 30000)
PanelBinding* panel_binding_new (IBusBus* bus,
                                 GtkApplication* application);
PanelBinding* panel_binding_construct (GType object_type,
                                       IBusBus* bus,
                                       GtkApplication* application);
static void panel_binding_init_settings (PanelBinding* self);
static void __lambda28_ (PanelBinding* self,
                  const gchar* key);
void binding_common_set_custom_font (GSettings* settings_panel,
                                     GSettings* settings_emoji,
                                     GtkCssProvider* * css_provider);
static void ___lambda28__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda29_ (PanelBinding* self,
                  const gchar* key);
static void ___lambda29__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda30_ (PanelBinding* self,
                  const gchar* key);
static void panel_binding_set_emoji_hotkey (PanelBinding* self);
static void ___lambda30__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda31_ (PanelBinding* self,
                  const gchar* key);
static void ___lambda31__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda32_ (PanelBinding* self,
                  const gchar* key);
static void ___lambda32__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda33_ (PanelBinding* self,
                  const gchar* key);
static void panel_binding_set_emoji_favorites (PanelBinding* self);
static void ___lambda33__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda34_ (PanelBinding* self,
                  const gchar* key);
static void ___lambda34__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda35_ (PanelBinding* self,
                  const gchar* key);
static void panel_binding_set_emoji_lang (PanelBinding* self);
static void ___lambda35__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda37_ (PanelBinding* self,
                  const gchar* key);
static void panel_binding_set_emoji_partial_match (PanelBinding* self);
static void ___lambda37__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda38_ (PanelBinding* self,
                  const gchar* key);
static void ___lambda38__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda39_ (PanelBinding* self,
                  const gchar* key);
static void ___lambda39__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda40_ (PanelBinding* self,
                  const gchar* key);
static void panel_binding_set_load_emoji_at_startup (PanelBinding* self);
static void ___lambda40__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda41_ (PanelBinding* self,
                  const gchar* key);
static void panel_binding_set_load_unicode_at_startup (PanelBinding* self);
static void ___lambda41__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void panel_binding_parse_accelerator (PanelBinding* self,
                                      const gchar* accelerator);
static void _vala_array_add8 (IBusProcessKeyEventData* * array,
                       int* length,
                       int* size,
                       const IBusProcessKeyEventData* value);
static void _vala_array_add9 (IBusProcessKeyEventData* * array,
                       int* length,
                       int* size,
                       const IBusProcessKeyEventData* value);
static void _vala_array_add10 (IBusProcessKeyEventData* * array,
                        int* length,
                        int* size,
                        const IBusProcessKeyEventData* value);
static void _vala_array_add11 (IBusProcessKeyEventData* * array,
                        int* length,
                        int* size,
                        const IBusProcessKeyEventData* value);
void ibus_emojier_set_favorites (gchar** unowned_favorites,
                                 int unowned_favorites_length1,
                                 gchar** unowned_favorite_annotations,
                                 int unowned_favorite_annotations_length1);
static gboolean __lambda36_ (PanelBinding* self);
void ibus_emojier_set_annotation_lang (const gchar* lang);
void ibus_emojier_load_unicode_dict (void);
static gboolean ___lambda36__gsource_func (gpointer self);
void ibus_emojier_set_partial_match (gboolean has_partial_match);
void ibus_emojier_set_partial_match_length (gint length);
void ibus_emojier_set_partial_match_condition (gint condition);
void panel_binding_load_settings (PanelBinding* self);
void panel_binding_disconnect_signals (PanelBinding* self);
static void panel_binding_commit_text_update_favorites (PanelBinding* self,
                                                 IBusText* text);
static void _vala_array_add12 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static gboolean panel_binding_emojier_focus_commit_real (PanelBinding* self);
gchar* ibus_emojier_get_selected_string (IBusEmojier* self);
gchar* ibus_emojier_get_input_context_path (IBusEmojier* self);
void ibus_emojier_reset (IBusEmojier* self);
static void panel_binding_emojier_focus_commit (PanelBinding* self);
static gboolean ___lambda42_ (PanelBinding* self);
static gboolean ____lambda42__gsource_func (gpointer self);
static gboolean panel_binding_key_press_escape (PanelBinding* self);
static gboolean panel_binding_is_emoji_lookup_table (PanelBinding* self);
gboolean ibus_emojier_key_press_escape (IBusEmojier* self);
static void panel_binding_convert_preedit_text (PanelBinding* self);
void ibus_emojier_set_annotation (IBusEmojier* self,
                                  const gchar* annotation);
static void panel_binding_hide_emoji_lookup_table (PanelBinding* self);
static gboolean panel_binding_key_press_enter (PanelBinding* self);
gboolean ibus_emojier_key_press_enter (IBusEmojier* self);
guint ibus_emojier_get_number_of_candidates (IBusEmojier* self);
gchar* ibus_emojier_get_current_candidate (IBusEmojier* self);
static gboolean panel_binding_key_press_space (PanelBinding* self);
gboolean ibus_emojier_key_press_cursor_horizontal (IBusEmojier* self,
                                                   guint keyval,
                                                   guint modifiers);
static gboolean panel_binding_key_press_cursor_horizontal (PanelBinding* self,
                                                    guint keyval,
                                                    guint modifiers);
static gboolean panel_binding_key_press_cursor_vertical (PanelBinding* self,
                                                  guint keyval,
                                                  guint modifiers);
gboolean ibus_emojier_key_press_cursor_vertical (IBusEmojier* self,
                                                 guint keyval,
                                                 guint modifiers);
static gboolean panel_binding_key_press_cursor_home_end (PanelBinding* self,
                                                  guint keyval,
                                                  guint modifiers);
gboolean ibus_emojier_key_press_cursor_home_end (IBusEmojier* self,
                                                 guint keyval,
                                                 guint modifiers);
static gboolean panel_binding_key_press_control_keyval (PanelBinding* self,
                                                 guint keyval,
                                                 guint modifiers);
static void panel_binding_hide_wayland_lookup_table (PanelBinding* self);
static void panel_binding_show_wayland_lookup_table (PanelBinding* self,
                                              IBusText* text);
IBusLookupTable* ibus_emojier_get_one_dimension_lookup_table (IBusEmojier* self);
static gboolean panel_binding_is_visible_wayland_lookup_table (PanelBinding* self);
static void panel_binding_show_emoji_lookup_table (PanelBinding* self);
IBusText* ibus_emojier_get_title_text (IBusEmojier* self);
void ibus_emojier_set_input_context_path (IBusEmojier* self,
                                          const gchar* input_context_path);
static void panel_binding_show_preedit_and_candidate (PanelBinding* self,
                                               gboolean show_candidate);
static void panel_binding_real_focus_in (IBusPanelService* base,
                                  const gchar* input_context_path);
static void panel_binding_real_focus_out (IBusPanelService* base,
                                   const gchar* input_context_path);
static void panel_binding_real_panel_extension_received (IBusPanelService* base,
                                                  IBusExtensionEvent* event);
IBusEmojier* ibus_emojier_new (void);
IBusEmojier* ibus_emojier_construct (GType object_type);
static void ___lambda43_ (PanelBinding* self,
                   guint i,
                   guint b,
                   guint s);
static void ____lambda43__ibus_emojier_candidate_clicked (IBusEmojier* _sender,
                                                   guint index,
                                                   guint button,
                                                   guint state,
                                                   gpointer self);
static void panel_binding_real_set_cursor_location (IBusPanelService* base,
                                             gint x,
                                             gint y,
                                             gint width,
                                             gint height);
void ibus_emojier_set_cursor_location (IBusEmojier* self,
                                       gint x,
                                       gint y,
                                       gint width,
                                       gint height);
static void panel_binding_real_update_preedit_text (IBusPanelService* base,
                                             IBusText* text,
                                             guint cursor_pos,
                                             gboolean visible);
static void panel_binding_real_show_preedit_text (IBusPanelService* base);
static void panel_binding_real_hide_preedit_text (IBusPanelService* base);
static gboolean panel_binding_real_process_key_event (IBusPanelService* base,
                                               guint keyval,
                                               guint keycode,
                                               guint state);
static void panel_binding_real_commit_text_received (IBusPanelService* base,
                                              IBusText* text);
static void panel_binding_real_page_up_lookup_table (IBusPanelService* base);
static void panel_binding_real_page_down_lookup_table (IBusPanelService* base);
static void panel_binding_real_cursor_up_lookup_table (IBusPanelService* base);
static void panel_binding_real_cursor_down_lookup_table (IBusPanelService* base);
static void panel_binding_real_candidate_clicked_lookup_table (IBusPanelService* base,
                                                        guint index,
                                                        guint button,
                                                        guint state);
#define IBUS_EMOJIER_BUTTON_CLOSE_BUTTON ((guint) 1000)
void ibus_emojier_set_cursor_pos (IBusEmojier* self,
                                  guint cursor_pos);
gboolean ibus_emojier_has_variants (IBusEmojier* self,
                                    guint index);
static void panel_binding_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


Preedit*
preedit_construct (GType object_type)
{
	Preedit * self = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	self = (Preedit*) g_object_new (object_type, "name", "IBusPreedit", "type", GTK_WINDOW_POPUP, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_extension_preedit_text);
	self->priv->m_extension_preedit_text = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->m_extension_preedit_emoji);
	self->priv->m_extension_preedit_emoji = _tmp1_;
	return self;
}


Preedit*
preedit_new (void)
{
	return preedit_construct (TYPE_PREEDIT);
}


void
preedit_hide (Preedit* self)
{
	g_return_if_fail (self != NULL);
	preedit_reset (self);
	GTK_WIDGET_CLASS (preedit_parent_class)->hide ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	self->priv->m_is_shown = FALSE;
}


gboolean
preedit_is_shown (Preedit* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_is_shown;
	result = _tmp0_;
	return result;
}


void
preedit_reset (Preedit* self)
{
	g_return_if_fail (self != NULL);
	preedit_set_emoji (self, "");
	preedit_set_text (self, "");
	gtk_window_resize ((GtkWindow*) self, 1, 1);
	self->priv->m_is_shown = TRUE;
}


void
preedit_append_text (Preedit* self,
                     const gchar* text)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* total = NULL;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = strlen (text);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = self->priv->m_extension_preedit_text;
	_tmp3_ = gtk_label_get_text (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	total = _tmp4_;
	_tmp5_ = total;
	_tmp6_ = g_strconcat (_tmp5_, text, NULL);
	_g_free0 (total);
	total = _tmp6_;
	_tmp7_ = self->priv->m_extension_preedit_text;
	_tmp8_ = total;
	gtk_label_set_text (_tmp7_, _tmp8_);
	_g_free0 (total);
}


gchar*
preedit_get_text (Preedit* self)
{
	gchar* result = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_extension_preedit_text;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


void
preedit_set_text (Preedit* self,
                  const gchar* text)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->m_extension_preedit_text;
	gtk_label_set_text (_tmp0_, text);
}


gchar*
preedit_get_emoji (Preedit* self)
{
	gchar* result = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_extension_preedit_emoji;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


void
preedit_set_emoji (Preedit* self,
                   const gchar* text)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->m_extension_preedit_emoji;
	gtk_label_set_text (_tmp0_, text);
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gint result = 0;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}


gboolean
preedit_backspace (Preedit* self)
{
	gboolean result = FALSE;
	gchar* total = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint char_count = 0;
	const gchar* _tmp10_;
	gint _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	GtkLabel* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_extension_preedit_emoji;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	total = _tmp2_;
	_tmp3_ = total;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		GtkLabel* _tmp6_;
		_tmp6_ = self->priv->m_extension_preedit_emoji;
		gtk_label_set_text (_tmp6_, "");
		gtk_window_resize ((GtkWindow*) self, 1, 1);
		result = FALSE;
		_g_free0 (total);
		return result;
	}
	_tmp7_ = self->priv->m_extension_preedit_text;
	_tmp8_ = gtk_label_get_text (_tmp7_);
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (total);
	total = _tmp9_;
	_tmp10_ = total;
	char_count = g_utf8_strlen (_tmp10_, (gssize) -1);
	_tmp11_ = char_count;
	if (_tmp11_ == 0) {
		result = TRUE;
		_g_free0 (total);
		return result;
	}
	_tmp12_ = total;
	_tmp13_ = total;
	_tmp14_ = char_count;
	_tmp15_ = string_slice (_tmp12_, (glong) 0, (glong) string_index_of_nth_char (_tmp13_, (glong) (_tmp14_ - 1)));
	_g_free0 (total);
	total = _tmp15_;
	gtk_window_resize ((GtkWindow*) self, 1, 1);
	_tmp16_ = self->priv->m_extension_preedit_text;
	_tmp17_ = total;
	gtk_label_set_text (_tmp16_, _tmp17_);
	_tmp18_ = total;
	_tmp19_ = strlen (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == 0) {
		gtk_window_resize ((GtkWindow*) self, 1, 1);
	}
	result = TRUE;
	_g_free0 (total);
	return result;
}


static gchar*
preedit_get_extension_text (Preedit* self)
{
	gchar* result = NULL;
	gchar* extension_text = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_extension_preedit_emoji;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	extension_text = _tmp2_;
	_tmp3_ = extension_text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		GtkLabel* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->m_extension_preedit_text;
		_tmp7_ = gtk_label_get_text (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (extension_text);
		extension_text = _tmp8_;
	}
	_tmp9_ = self->priv->m_prefix;
	_tmp10_ = extension_text;
	_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
	result = _tmp11_;
	_g_free0 (extension_text);
	return result;
}


static void
preedit_set_preedit_color (Preedit* self,
                           IBusText* text,
                           guint start_index,
                           guint end_index)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	ibus_text_append_attribute (text, (guint) IBUS_ATTR_TYPE_UNDERLINE, (guint) IBUS_ATTR_UNDERLINE_SINGLE, start_index, (gint) end_index);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


IBusText*
preedit_get_engine_preedit_text (Preedit* self)
{
	IBusText* result = NULL;
	gchar* extension_text = NULL;
	gchar* _tmp0_;
	guint char_count = 0U;
	const gchar* _tmp1_;
	IBusText* retval = NULL;
	gboolean _tmp2_ = FALSE;
	IBusText* _tmp3_;
	const gchar* _tmp9_;
	IBusText* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	IBusText* _tmp14_;
	IBusText* _tmp15_;
	guint _tmp16_;
	IBusAttrList* attrs = NULL;
	IBusText* _tmp17_;
	IBusAttrList* _tmp18_;
	IBusAttrList* _tmp19_;
	gint i = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = preedit_get_extension_text (self);
	extension_text = _tmp0_;
	_tmp1_ = extension_text;
	char_count = (guint) g_utf8_strlen (_tmp1_, (gssize) -1);
	_tmp3_ = self->priv->m_engine_preedit_text;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = self->priv->m_engine_preedit_text_show;
		_tmp2_ = !_tmp4_;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		IBusText* _tmp6_;
		IBusText* _tmp7_;
		guint _tmp8_;
		_tmp5_ = extension_text;
		_tmp6_ = ibus_text_new_from_string (_tmp5_);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (retval);
		retval = _tmp6_;
		_tmp7_ = retval;
		_tmp8_ = char_count;
		preedit_set_preedit_color (self, _tmp7_, (guint) 0, _tmp8_);
		result = retval;
		_g_free0 (extension_text);
		return result;
	}
	_tmp9_ = extension_text;
	_tmp10_ = self->priv->m_engine_preedit_text;
	_tmp11_ = ibus_text_get_text (_tmp10_);
	_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = ibus_text_new_from_string (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (retval);
	retval = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = retval;
	_tmp16_ = char_count;
	preedit_set_preedit_color (self, _tmp15_, (guint) 0, _tmp16_);
	_tmp17_ = self->priv->m_engine_preedit_text;
	_tmp18_ = ibus_text_get_attributes (_tmp17_);
	attrs = _tmp18_;
	_tmp19_ = attrs;
	if (_tmp19_ == NULL) {
		result = retval;
		_g_free0 (extension_text);
		return result;
	}
	i = 0;
	while (TRUE) {
		IBusAttribute* attr = NULL;
		IBusAttrList* _tmp20_;
		gint _tmp21_;
		IBusAttribute* _tmp22_;
		IBusAttribute* _tmp23_;
		IBusAttribute* _tmp24_;
		glong start_index = 0L;
		IBusAttribute* _tmp25_;
		guint _tmp26_;
		glong end_index = 0L;
		IBusAttribute* _tmp27_;
		guint _tmp28_;
		glong _tmp29_;
		glong _tmp30_;
		IBusText* _tmp32_;
		IBusAttribute* _tmp33_;
		guint _tmp34_;
		IBusAttribute* _tmp35_;
		guint _tmp36_;
		guint _tmp37_;
		glong _tmp38_;
		guint _tmp39_;
		glong _tmp40_;
		_tmp20_ = attrs;
		_tmp21_ = i;
		i = _tmp21_ + 1;
		_tmp22_ = ibus_attr_list_get (_tmp20_, (guint) _tmp21_);
		_tmp23_ = _g_object_ref0 (_tmp22_);
		attr = _tmp23_;
		_tmp24_ = attr;
		if (_tmp24_ == NULL) {
			_g_object_unref0 (attr);
			break;
		}
		_tmp25_ = attr;
		_tmp26_ = _tmp25_->start_index;
		start_index = (glong) _tmp26_;
		_tmp27_ = attr;
		_tmp28_ = _tmp27_->end_index;
		end_index = (glong) _tmp28_;
		_tmp29_ = start_index;
		if (_tmp29_ < ((glong) 0)) {
			start_index = (glong) 0;
		}
		_tmp30_ = end_index;
		if (_tmp30_ < ((glong) 0)) {
			IBusText* _tmp31_;
			_tmp31_ = self->priv->m_engine_preedit_text;
			end_index = (glong) ibus_text_get_length (_tmp31_);
		}
		_tmp32_ = retval;
		_tmp33_ = attr;
		_tmp34_ = _tmp33_->type;
		_tmp35_ = attr;
		_tmp36_ = _tmp35_->value;
		_tmp37_ = char_count;
		_tmp38_ = start_index;
		_tmp39_ = char_count;
		_tmp40_ = end_index;
		ibus_text_append_attribute (_tmp32_, _tmp34_, _tmp36_, _tmp37_ + ((guint) _tmp38_), ((gint) _tmp39_) + ((gint) _tmp40_));
		_g_object_unref0 (attr);
	}
	result = retval;
	_g_free0 (extension_text);
	return result;
}


void
preedit_set_engine_preedit_text (Preedit* self,
                                 IBusText* text)
{
	IBusText* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (text);
	_g_object_unref0 (self->priv->m_engine_preedit_text);
	self->priv->m_engine_preedit_text = _tmp0_;
}


void
preedit_show_engine_preedit_text (Preedit* self)
{
	g_return_if_fail (self != NULL);
	self->priv->m_engine_preedit_text_show = TRUE;
}


void
preedit_hide_engine_preedit_text (Preedit* self)
{
	g_return_if_fail (self != NULL);
	self->priv->m_engine_preedit_text_show = FALSE;
}


guint
preedit_get_engine_preedit_cursor_pos (Preedit* self)
{
	guint result = 0U;
	gchar* _tmp0_;
	gchar* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = preedit_get_extension_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->m_engine_preedit_cursor_pos;
	_tmp3_ = g_utf8_strlen (_tmp1_, (gssize) -1) + _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


void
preedit_set_engine_preedit_cursor_pos (Preedit* self,
                                       guint cursor_pos)
{
	g_return_if_fail (self != NULL);
	self->priv->m_engine_preedit_cursor_pos = cursor_pos;
}


IBusText*
preedit_get_commit_text (Preedit* self)
{
	IBusText* result = NULL;
	gchar* extension_text = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp9_;
	IBusText* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_extension_preedit_emoji;
	_tmp1_ = gtk_label_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	extension_text = _tmp2_;
	_tmp3_ = extension_text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		GtkLabel* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->m_extension_preedit_text;
		_tmp7_ = gtk_label_get_text (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (extension_text);
		extension_text = _tmp8_;
	}
	_tmp9_ = extension_text;
	_tmp10_ = ibus_text_new_from_string (_tmp9_);
	g_object_ref_sink (_tmp10_);
	result = _tmp10_;
	_g_free0 (extension_text);
	return result;
}


void
preedit_set_extension_name (Preedit* self,
                            const gchar* extension_name)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (extension_name != NULL);
	_tmp0_ = strlen (extension_name);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("@");
		_g_free0 (self->priv->m_prefix);
		self->priv->m_prefix = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = string_slice (extension_name, (glong) 0, (glong) 1);
		_g_free0 (self->priv->m_prefix);
		self->priv->m_prefix = _tmp3_;
	}
}


static void
preedit_class_init (PreeditClass * klass)
{
	preedit_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreeditPrivate));
	G_OBJECT_CLASS (klass)->finalize = preedit_finalize;
}


static void
preedit_instance_init (Preedit * self)
{
	gchar* _tmp0_;
	self->priv = PREEDIT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("@");
	self->priv->m_prefix = _tmp0_;
	self->priv->m_is_shown = TRUE;
}


static void
preedit_finalize (GObject * obj)
{
	Preedit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREEDIT, Preedit);
	_g_object_unref0 (self->priv->m_extension_preedit_text);
	_g_object_unref0 (self->priv->m_extension_preedit_emoji);
	_g_object_unref0 (self->priv->m_engine_preedit_text);
	_g_free0 (self->priv->m_prefix);
	G_OBJECT_CLASS (preedit_parent_class)->finalize (obj);
}


GType
preedit_get_type (void)
{
	static volatile gsize preedit_type_id__volatile = 0;
	if (g_once_init_enter (&preedit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreeditClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preedit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preedit), 0, (GInstanceInitFunc) preedit_instance_init, NULL };
		GType preedit_type_id;
		preedit_type_id = g_type_register_static (gtk_window_get_type (), "Preedit", &g_define_type_info, 0);
		g_once_init_leave (&preedit_type_id__volatile, preedit_type_id);
	}
	return preedit_type_id__volatile;
}


PanelBinding*
panel_binding_construct (GType object_type,
                         IBusBus* bus,
                         GtkApplication* application)
{
	PanelBinding * self = NULL;
	GDBusConnection* _tmp0_;
	GType instance_type = 0UL;
	GdkDisplay* _tmp1_;
	GType wayland_type = 0UL;
	IBusBus* _tmp2_;
	GtkApplication* _tmp3_;
	Preedit* _tmp4_;
	g_return_val_if_fail (bus != NULL, NULL);
	g_return_val_if_fail (application != NULL, NULL);
	_vala_assert (ibus_bus_is_connected (bus), "bus.is_connected()");
	_tmp0_ = ibus_bus_get_connection (bus);
	self = (PanelBinding*) g_object_new (object_type, "connection", _tmp0_, "object-path", IBUS_PATH_PANEL_EXTENSION_EMOJI, NULL);
	_tmp1_ = gdk_display_get_default ();
	instance_type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
	wayland_type = gdk_wayland_display_get_type ();
	self->priv->m_is_wayland = g_type_is_a (instance_type, wayland_type);
	_tmp2_ = _g_object_ref0 (bus);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp2_;
	_tmp3_ = _g_object_ref0 (application);
	_g_object_unref0 (self->priv->m_application);
	self->priv->m_application = _tmp3_;
	panel_binding_init_settings (self);
	_tmp4_ = preedit_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_preedit);
	self->priv->m_preedit = _tmp4_;
	return self;
}


PanelBinding*
panel_binding_new (IBusBus* bus,
                   GtkApplication* application)
{
	return panel_binding_construct (TYPE_PANEL_BINDING, bus, application);
}


static void
__lambda28_ (PanelBinding* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = self->priv->m_settings_emoji;
	binding_common_set_custom_font (_tmp0_, _tmp1_, &self->priv->m_css_provider);
}


static void
___lambda28__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda28_ ((PanelBinding*) self, key);
}


static void
__lambda29_ (PanelBinding* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = self->priv->m_settings_emoji;
	binding_common_set_custom_font (_tmp0_, _tmp1_, &self->priv->m_css_provider);
}


static void
___lambda29__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda29_ ((PanelBinding*) self, key);
}


static void
__lambda30_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_hotkey (self);
}


static void
___lambda30__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda30_ ((PanelBinding*) self, key);
}


static void
__lambda31_ (PanelBinding* self,
             const gchar* key)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = self->priv->m_settings_emoji;
	binding_common_set_custom_font (_tmp0_, _tmp1_, &self->priv->m_css_provider);
}


static void
___lambda31__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda31_ ((PanelBinding*) self, key);
}


static void
__lambda32_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_hotkey (self);
}


static void
___lambda32__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda32_ ((PanelBinding*) self, key);
}


static void
__lambda33_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_favorites (self);
}


static void
___lambda33__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda33_ ((PanelBinding*) self, key);
}


static void
__lambda34_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_favorites (self);
}


static void
___lambda34__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda34_ ((PanelBinding*) self, key);
}


static void
__lambda35_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_lang (self);
}


static void
___lambda35__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda35_ ((PanelBinding*) self, key);
}


static void
__lambda37_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_partial_match (self);
}


static void
___lambda37__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda37_ ((PanelBinding*) self, key);
}


static void
__lambda38_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_partial_match (self);
}


static void
___lambda38__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda38_ ((PanelBinding*) self, key);
}


static void
__lambda39_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_partial_match (self);
}


static void
___lambda39__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda39_ ((PanelBinding*) self, key);
}


static void
__lambda40_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_load_emoji_at_startup (self);
}


static void
___lambda40__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda40_ ((PanelBinding*) self, key);
}


static void
__lambda41_ (PanelBinding* self,
             const gchar* key)
{
	g_return_if_fail (key != NULL);
	panel_binding_set_load_unicode_at_startup (self);
}


static void
___lambda41__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda41_ ((PanelBinding*) self, key);
}


static void
panel_binding_init_settings (PanelBinding* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.panel");
	_g_object_unref0 (self->priv->m_settings_panel);
	self->priv->m_settings_panel = _tmp0_;
	_tmp1_ = g_settings_new ("org.freedesktop.ibus.panel.emoji");
	_g_object_unref0 (self->priv->m_settings_emoji);
	self->priv->m_settings_emoji = _tmp1_;
	_tmp2_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp2_, "changed::custom-font", (GCallback) ___lambda28__g_settings_changed, self, 0);
	_tmp3_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp3_, "changed::use-custom-font", (GCallback) ___lambda29__g_settings_changed, self, 0);
	_tmp4_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp4_, "changed::unicode-hotkey", (GCallback) ___lambda30__g_settings_changed, self, 0);
	_tmp5_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp5_, "changed::font", (GCallback) ___lambda31__g_settings_changed, self, 0);
	_tmp6_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp6_, "changed::hotkey", (GCallback) ___lambda32__g_settings_changed, self, 0);
	_tmp7_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp7_, "changed::favorites", (GCallback) ___lambda33__g_settings_changed, self, 0);
	_tmp8_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp8_, "changed::favorite-annotations", (GCallback) ___lambda34__g_settings_changed, self, 0);
	_tmp9_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp9_, "changed::lang", (GCallback) ___lambda35__g_settings_changed, self, 0);
	_tmp10_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp10_, "changed::has-partial-match", (GCallback) ___lambda37__g_settings_changed, self, 0);
	_tmp11_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp11_, "changed::partial-match-length", (GCallback) ___lambda38__g_settings_changed, self, 0);
	_tmp12_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp12_, "changed::partial-match-condition", (GCallback) ___lambda39__g_settings_changed, self, 0);
	_tmp13_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp13_, "changed::load-emoji-at-startup", (GCallback) ___lambda40__g_settings_changed, self, 0);
	_tmp14_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp14_, "changed::load-unicode-at-startup", (GCallback) ___lambda41__g_settings_changed, self, 0);
}


static void
panel_binding_parse_accelerator (PanelBinding* self,
                                 const gchar* accelerator)
{
	IBusProcessKeyEventData _tmp0_ = {0};
	guint keysym = 0U;
	IBusModifierType modifiers = 0;
	guint _tmp1_ = 0U;
	IBusModifierType _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_;
	IBusModifierType _tmp8_;
	guint _tmp11_;
	IBusModifierType _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (accelerator != NULL);
	self->priv->m_key_event_data = _tmp0_;
	keysym = (guint) 0;
	modifiers = 0;
	ibus_accelerator_parse (accelerator, &_tmp1_, &_tmp2_);
	keysym = _tmp1_;
	modifiers = _tmp2_;
	_tmp4_ = keysym;
	if (_tmp4_ == 0U) {
		IBusModifierType _tmp5_;
		_tmp5_ = modifiers;
		_tmp3_ = _tmp5_ == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup_printf ("Failed to parse shortcut key '%s'", accelerator);
		_tmp7_ = _tmp6_;
		g_warning ("panelbinding.vala:325: %s", _tmp7_);
		_g_free0 (_tmp7_);
		return;
	}
	_tmp8_ = modifiers;
	if ((_tmp8_ & IBUS_SUPER_MASK) != 0) {
		IBusModifierType _tmp9_;
		IBusModifierType _tmp10_;
		_tmp9_ = modifiers;
		modifiers = _tmp9_ ^ IBUS_SUPER_MASK;
		_tmp10_ = modifiers;
		modifiers = _tmp10_ | IBUS_MOD4_MASK;
	}
	_tmp11_ = keysym;
	self->priv->m_key_event_data.keyval = _tmp11_;
	_tmp12_ = modifiers;
	self->priv->m_key_event_data.state = (guint) _tmp12_;
}


static void
_vala_array_add8 (IBusProcessKeyEventData* * array,
                  int* length,
                  int* size,
                  const IBusProcessKeyEventData* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusProcessKeyEventData, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
_vala_array_add9 (IBusProcessKeyEventData* * array,
                  int* length,
                  int* size,
                  const IBusProcessKeyEventData* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusProcessKeyEventData, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
_vala_array_add10 (IBusProcessKeyEventData* * array,
                   int* length,
                   int* size,
                   const IBusProcessKeyEventData* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusProcessKeyEventData, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
_vala_array_add11 (IBusProcessKeyEventData* * array,
                   int* length,
                   int* size,
                   const IBusProcessKeyEventData* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusProcessKeyEventData, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
panel_binding_set_emoji_hotkey (PanelBinding* self)
{
	IBusProcessKeyEventData* emoji_keys = NULL;
	IBusProcessKeyEventData* _tmp0_;
	gint emoji_keys_length1;
	gint _emoji_keys_size_;
	IBusProcessKeyEventData key = {0};
	gchar** accelerators = NULL;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint accelerators_length1;
	gint _accelerators_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	IBusProcessKeyEventData _tmp9_ = {0};
	IBusProcessKeyEventData* _tmp10_;
	gint _tmp10__length1;
	IBusProcessKeyEventData _tmp11_;
	IBusProcessKeyEventData* unicode_keys = NULL;
	IBusProcessKeyEventData* _tmp12_;
	gint unicode_keys_length1;
	gint _unicode_keys_size_;
	GSettings* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	IBusProcessKeyEventData _tmp21_ = {0};
	IBusProcessKeyEventData* _tmp22_;
	gint _tmp22__length1;
	IBusProcessKeyEventData _tmp23_;
	IBusProcessKeyEventData* _tmp24_;
	gint _tmp24__length1;
	IBusProcessKeyEventData* _tmp25_;
	gint _tmp25__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (IBusProcessKeyEventData, 0);
	emoji_keys = _tmp0_;
	emoji_keys_length1 = 0;
	_emoji_keys_size_ = emoji_keys_length1;
	_tmp1_ = self->priv->m_settings_emoji;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "hotkey");
	accelerators = _tmp3_;
	accelerators_length1 = _vala_array_length (_tmp2_);
	_accelerators_size_ = accelerators_length1;
	_tmp4_ = accelerators;
	_tmp4__length1 = accelerators_length1;
	{
		gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp4_;
		accelerator_collection_length1 = _tmp4__length1;
		for (accelerator_it = 0; accelerator_it < _tmp4__length1; accelerator_it = accelerator_it + 1) {
			gchar* _tmp5_;
			gchar* accelerator = NULL;
			_tmp5_ = g_strdup (accelerator_collection[accelerator_it]);
			accelerator = _tmp5_;
			{
				const gchar* _tmp6_;
				IBusProcessKeyEventData* _tmp7_;
				gint _tmp7__length1;
				IBusProcessKeyEventData _tmp8_;
				_tmp6_ = accelerator;
				panel_binding_parse_accelerator (self, _tmp6_);
				_tmp7_ = emoji_keys;
				_tmp7__length1 = emoji_keys_length1;
				_tmp8_ = self->priv->m_key_event_data;
				_vala_array_add8 (&emoji_keys, &emoji_keys_length1, &_emoji_keys_size_, &_tmp8_);
				_g_free0 (accelerator);
			}
		}
	}
	key = _tmp9_;
	_tmp10_ = emoji_keys;
	_tmp10__length1 = emoji_keys_length1;
	_tmp11_ = key;
	_vala_array_add9 (&emoji_keys, &emoji_keys_length1, &_emoji_keys_size_, &_tmp11_);
	_tmp12_ = g_new0 (IBusProcessKeyEventData, 0);
	unicode_keys = _tmp12_;
	unicode_keys_length1 = 0;
	_unicode_keys_size_ = unicode_keys_length1;
	_tmp13_ = self->priv->m_settings_emoji;
	_tmp15_ = _tmp14_ = g_settings_get_strv (_tmp13_, "unicode-hotkey");
	accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
	accelerators = _tmp15_;
	accelerators_length1 = _vala_array_length (_tmp14_);
	_accelerators_size_ = accelerators_length1;
	_tmp16_ = accelerators;
	_tmp16__length1 = accelerators_length1;
	{
		gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp16_;
		accelerator_collection_length1 = _tmp16__length1;
		for (accelerator_it = 0; accelerator_it < _tmp16__length1; accelerator_it = accelerator_it + 1) {
			gchar* _tmp17_;
			gchar* accelerator = NULL;
			_tmp17_ = g_strdup (accelerator_collection[accelerator_it]);
			accelerator = _tmp17_;
			{
				const gchar* _tmp18_;
				IBusProcessKeyEventData* _tmp19_;
				gint _tmp19__length1;
				IBusProcessKeyEventData _tmp20_;
				_tmp18_ = accelerator;
				panel_binding_parse_accelerator (self, _tmp18_);
				_tmp19_ = unicode_keys;
				_tmp19__length1 = unicode_keys_length1;
				_tmp20_ = self->priv->m_key_event_data;
				_vala_array_add10 (&unicode_keys, &unicode_keys_length1, &_unicode_keys_size_, &_tmp20_);
				_g_free0 (accelerator);
			}
		}
	}
	key = _tmp21_;
	_tmp22_ = unicode_keys;
	_tmp22__length1 = unicode_keys_length1;
	_tmp23_ = key;
	_vala_array_add11 (&unicode_keys, &unicode_keys_length1, &_unicode_keys_size_, &_tmp23_);
	_tmp24_ = emoji_keys;
	_tmp24__length1 = emoji_keys_length1;
	_tmp25_ = unicode_keys;
	_tmp25__length1 = unicode_keys_length1;
	ibus_panel_service_panel_extension_register_keys ((IBusPanelService*) self, "emoji", _tmp24_, "unicode", _tmp25_, NULL);
	unicode_keys = (g_free (unicode_keys), NULL);
	accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
	emoji_keys = (g_free (emoji_keys), NULL);
}


static void
panel_binding_set_emoji_favorites (PanelBinding* self)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "favorites");
	self->priv->m_emojier_favorites = (_vala_array_free (self->priv->m_emojier_favorites, self->priv->m_emojier_favorites_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_emojier_favorites = _tmp2_;
	self->priv->m_emojier_favorites_length1 = _vala_array_length (_tmp1_);
	self->priv->_m_emojier_favorites_size_ = self->priv->m_emojier_favorites_length1;
	_tmp3_ = self->priv->m_emojier_favorites;
	_tmp3__length1 = self->priv->m_emojier_favorites_length1;
	_tmp4_ = self->priv->m_settings_emoji;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "favorite-annotations");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	ibus_emojier_set_favorites (_tmp3_, _tmp3__length1, _tmp7_, _vala_array_length (_tmp5_));
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
}


static gboolean
__lambda36_ (PanelBinding* self)
{
	gboolean result = FALSE;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_string (_tmp0_, "lang");
	_tmp2_ = _tmp1_;
	ibus_emojier_set_annotation_lang (_tmp2_);
	_g_free0 (_tmp2_);
	self->priv->m_emojier_set_emoji_lang_id = (guint) 0;
	self->priv->m_loaded_emoji = TRUE;
	_tmp4_ = self->priv->m_load_unicode_at_startup;
	if (_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->m_loaded_unicode;
		_tmp3_ = !_tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ibus_emojier_load_unicode_dict ();
		self->priv->m_loaded_unicode = TRUE;
	}
	result = FALSE;
	return result;
}


static gboolean
___lambda36__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda36_ ((PanelBinding*) self);
	return result;
}


static void
panel_binding_set_emoji_lang (PanelBinding* self)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier_set_emoji_lang_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->m_emojier_set_emoji_lang_id;
		g_source_remove (_tmp1_);
		self->priv->m_emojier_set_emoji_lang_id = (guint) 0;
	}
	self->priv->m_emojier_set_emoji_lang_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda36__gsource_func, g_object_ref (self), g_object_unref);
}


static void
panel_binding_set_emoji_partial_match (PanelBinding* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	ibus_emojier_set_partial_match (g_settings_get_boolean (_tmp0_, "has-partial-match"));
	_tmp1_ = self->priv->m_settings_emoji;
	ibus_emojier_set_partial_match_length (g_settings_get_int (_tmp1_, "partial-match-length"));
	_tmp2_ = self->priv->m_settings_emoji;
	ibus_emojier_set_partial_match_condition (g_settings_get_int (_tmp2_, "partial-match-condition"));
}


static void
panel_binding_set_load_emoji_at_startup (PanelBinding* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	self->priv->m_load_emoji_at_startup = g_settings_get_boolean (_tmp0_, "load-emoji-at-startup");
}


static void
panel_binding_set_load_unicode_at_startup (PanelBinding* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	self->priv->m_load_unicode_at_startup = g_settings_get_boolean (_tmp0_, "load-unicode-at-startup");
}


void
panel_binding_load_settings (PanelBinding* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	panel_binding_set_emoji_hotkey (self);
	panel_binding_set_load_emoji_at_startup (self);
	panel_binding_set_load_unicode_at_startup (self);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = self->priv->m_settings_emoji;
	binding_common_set_custom_font (_tmp0_, _tmp1_, &self->priv->m_css_provider);
	panel_binding_set_emoji_favorites (self);
	_tmp3_ = self->priv->m_load_emoji_at_startup;
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->m_loaded_emoji;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		panel_binding_set_emoji_lang (self);
	}
	panel_binding_set_emoji_partial_match (self);
}


/**
     * disconnect_signals:
     *
     * Call this API before m_panel = null so that the ref_count becomes 0
     */
void
panel_binding_disconnect_signals (PanelBinding* self)
{
	guint _tmp0_;
	IBusEmojier* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier_set_emoji_lang_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->m_emojier_set_emoji_lang_id;
		g_source_remove (_tmp1_);
		self->priv->m_emojier_set_emoji_lang_id = (guint) 0;
	}
	_tmp2_ = self->priv->m_emojier;
	if (_tmp2_ != NULL) {
		GtkApplication* _tmp3_;
		IBusEmojier* _tmp4_;
		_tmp3_ = self->priv->m_application;
		_tmp4_ = self->priv->m_emojier;
		gtk_application_remove_window (_tmp3_, (GtkWindow*) _tmp4_);
		_g_object_unref0 (self->priv->m_emojier);
		self->priv->m_emojier = NULL;
	}
	_g_object_unref0 (self->priv->m_application);
	self->priv->m_application = NULL;
}


static void
_vala_array_add12 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
panel_binding_commit_text_update_favorites (PanelBinding* self,
                                            IBusText* text)
{
	IBusExtensionEvent* event = NULL;
	const gchar* _tmp0_;
	IBusExtensionEvent* _tmp1_;
	IBusExtensionEvent* _tmp2_;
	IBusExtensionEvent* _tmp3_;
	gchar* committed_string = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* preedit_string = NULL;
	Preedit* _tmp6_;
	gchar* _tmp7_;
	Preedit* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean has_favorite = FALSE;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	ibus_panel_service_commit_text ((IBusPanelService*) self, text);
	_tmp0_ = self->priv->m_extension_name;
	_tmp1_ = ibus_extension_event_new ("name", _tmp0_, "is-enabled", FALSE, "is-extension", TRUE, NULL);
	g_object_ref_sink (_tmp1_);
	event = _tmp1_;
	_tmp2_ = event;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ibus_panel_service_panel_extension ((IBusPanelService*) self, _tmp3_);
	_tmp4_ = text->text;
	_tmp5_ = g_strdup (_tmp4_);
	committed_string = _tmp5_;
	_tmp6_ = self->priv->m_preedit;
	_tmp7_ = preedit_get_text (_tmp6_);
	preedit_string = _tmp7_;
	_tmp8_ = self->priv->m_preedit;
	preedit_hide (_tmp8_);
	_tmp9_ = preedit_string;
	_tmp10_ = committed_string;
	if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
		_g_free0 (preedit_string);
		_g_free0 (committed_string);
		_g_object_unref0 (event);
		return;
	}
	has_favorite = FALSE;
	_tmp11_ = self->priv->m_emojier_favorites;
	_tmp11__length1 = self->priv->m_emojier_favorites_length1;
	{
		gchar** favorite_collection = NULL;
		gint favorite_collection_length1 = 0;
		gint _favorite_collection_size_ = 0;
		gint favorite_it = 0;
		favorite_collection = _tmp11_;
		favorite_collection_length1 = _tmp11__length1;
		for (favorite_it = 0; favorite_it < _tmp11__length1; favorite_it = favorite_it + 1) {
			const gchar* favorite = NULL;
			favorite = favorite_collection[favorite_it];
			{
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = favorite;
				_tmp13_ = committed_string;
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
					has_favorite = TRUE;
					break;
				}
			}
		}
	}
	_tmp14_ = has_favorite;
	if (!_tmp14_) {
		gchar** _tmp15_;
		gint _tmp15__length1;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		GSettings* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp15_ = self->priv->m_emojier_favorites;
		_tmp15__length1 = self->priv->m_emojier_favorites_length1;
		_tmp16_ = committed_string;
		_tmp17_ = g_strdup (_tmp16_);
		_vala_array_add12 (&self->priv->m_emojier_favorites, &self->priv->m_emojier_favorites_length1, &self->priv->_m_emojier_favorites_size_, _tmp17_);
		_tmp18_ = self->priv->m_settings_emoji;
		_tmp19_ = self->priv->m_emojier_favorites;
		_tmp19__length1 = self->priv->m_emojier_favorites_length1;
		g_settings_set_strv (_tmp18_, "favorites", _tmp19_);
	}
	_g_free0 (preedit_string);
	_g_free0 (committed_string);
	_g_object_unref0 (event);
}


static gboolean
panel_binding_emojier_focus_commit_real (PanelBinding* self)
{
	gboolean result = FALSE;
	IBusEmojier* _tmp0_;
	gchar* selected_string = NULL;
	IBusEmojier* _tmp1_;
	gchar* _tmp2_;
	gchar* prev_context_path = NULL;
	IBusEmojier* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_emojier;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->m_emojier;
	_tmp2_ = ibus_emojier_get_selected_string (_tmp1_);
	selected_string = _tmp2_;
	_tmp3_ = self->priv->m_emojier;
	_tmp4_ = ibus_emojier_get_input_context_path (_tmp3_);
	prev_context_path = _tmp4_;
	_tmp7_ = selected_string;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = prev_context_path;
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = prev_context_path;
		_tmp10_ = self->priv->m_current_context_path;
		_tmp5_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		IBusText* text = NULL;
		const gchar* _tmp11_;
		IBusText* _tmp12_;
		IBusText* _tmp13_;
		IBusEmojier* _tmp14_;
		_tmp11_ = selected_string;
		_tmp12_ = ibus_text_new_from_string (_tmp11_);
		g_object_ref_sink (_tmp12_);
		text = _tmp12_;
		_tmp13_ = text;
		panel_binding_commit_text_update_favorites (self, _tmp13_);
		_tmp14_ = self->priv->m_emojier;
		ibus_emojier_reset (_tmp14_);
		result = TRUE;
		_g_object_unref0 (text);
		_g_free0 (prev_context_path);
		_g_free0 (selected_string);
		return result;
	}
	result = FALSE;
	_g_free0 (prev_context_path);
	_g_free0 (selected_string);
	return result;
}


static gpointer
_g_main_context_ref0 (gpointer self)
{
	return self ? g_main_context_ref (self) : NULL;
}


static gboolean
___lambda42_ (PanelBinding* self)
{
	gboolean result = FALSE;
	panel_binding_emojier_focus_commit_real (self);
	self->priv->m_emojier_focus_commit_text_id = (guint) -1;
	result = FALSE;
	return result;
}


static gboolean
____lambda42__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda42_ ((PanelBinding*) self);
	return result;
}


static void
panel_binding_emojier_focus_commit (PanelBinding* self)
{
	IBusEmojier* _tmp0_;
	gchar* selected_string = NULL;
	IBusEmojier* _tmp1_;
	gchar* _tmp2_;
	gchar* prev_context_path = NULL;
	IBusEmojier* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_emojier;
	_tmp2_ = ibus_emojier_get_selected_string (_tmp1_);
	selected_string = _tmp2_;
	_tmp3_ = self->priv->m_emojier;
	_tmp4_ = ibus_emojier_get_input_context_path (_tmp3_);
	prev_context_path = _tmp4_;
	_tmp6_ = selected_string;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		_tmp7_ = prev_context_path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GMainContext* context = NULL;
		GMainContext* _tmp8_;
		GMainContext* _tmp9_;
		gboolean _tmp10_ = FALSE;
		guint _tmp11_;
		_tmp8_ = g_main_context_default ();
		_tmp9_ = _g_main_context_ref0 (_tmp8_);
		context = _tmp9_;
		_tmp11_ = self->priv->m_emojier_focus_commit_text_id;
		if (_tmp11_ > ((guint) 0)) {
			GMainContext* _tmp12_;
			guint _tmp13_;
			GSource* _tmp14_;
			_tmp12_ = context;
			_tmp13_ = self->priv->m_emojier_focus_commit_text_id;
			_tmp14_ = g_main_context_find_source_by_id (_tmp12_, _tmp13_);
			_tmp10_ = _tmp14_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			guint _tmp15_;
			_tmp15_ = self->priv->m_emojier_focus_commit_text_id;
			g_source_remove (_tmp15_);
		}
		self->priv->m_emojier_focus_commit_text_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda42__gsource_func, g_object_ref (self), g_object_unref);
		_g_main_context_unref0 (context);
	} else {
		if (panel_binding_emojier_focus_commit_real (self)) {
			GMainContext* context = NULL;
			GMainContext* _tmp16_;
			GMainContext* _tmp17_;
			gboolean _tmp18_ = FALSE;
			guint _tmp19_;
			_tmp16_ = g_main_context_default ();
			_tmp17_ = _g_main_context_ref0 (_tmp16_);
			context = _tmp17_;
			_tmp19_ = self->priv->m_emojier_focus_commit_text_id;
			if (_tmp19_ > ((guint) 0)) {
				GMainContext* _tmp20_;
				guint _tmp21_;
				GSource* _tmp22_;
				_tmp20_ = context;
				_tmp21_ = self->priv->m_emojier_focus_commit_text_id;
				_tmp22_ = g_main_context_find_source_by_id (_tmp20_, _tmp21_);
				_tmp18_ = _tmp22_ != NULL;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				guint _tmp23_;
				_tmp23_ = self->priv->m_emojier_focus_commit_text_id;
				g_source_remove (_tmp23_);
			}
			self->priv->m_emojier_focus_commit_text_id = (guint) -1;
			_g_main_context_unref0 (context);
		}
	}
	_g_free0 (prev_context_path);
	_g_free0 (selected_string);
}


static gboolean
panel_binding_key_press_escape (PanelBinding* self)
{
	gboolean result = FALSE;
	Preedit* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	Preedit* _tmp10_;
	IBusExtensionEvent* event = NULL;
	const gchar* _tmp11_;
	IBusExtensionEvent* _tmp12_;
	IBusExtensionEvent* _tmp13_;
	IBusExtensionEvent* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (panel_binding_is_emoji_lookup_table (self)) {
		gboolean show_candidate = FALSE;
		IBusEmojier* _tmp0_;
		_tmp0_ = self->priv->m_emojier;
		show_candidate = ibus_emojier_key_press_escape (_tmp0_);
		panel_binding_convert_preedit_text (self);
		result = show_candidate;
		return result;
	}
	_tmp1_ = self->priv->m_preedit;
	_tmp2_ = preedit_get_emoji (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") != 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		Preedit* _tmp5_;
		gchar* annotation = NULL;
		Preedit* _tmp6_;
		gchar* _tmp7_;
		IBusEmojier* _tmp8_;
		const gchar* _tmp9_;
		_tmp5_ = self->priv->m_preedit;
		preedit_set_emoji (_tmp5_, "");
		_tmp6_ = self->priv->m_preedit;
		_tmp7_ = preedit_get_text (_tmp6_);
		annotation = _tmp7_;
		_tmp8_ = self->priv->m_emojier;
		_tmp9_ = annotation;
		ibus_emojier_set_annotation (_tmp8_, _tmp9_);
		result = FALSE;
		_g_free0 (annotation);
		return result;
	}
	self->priv->m_enable_extension = FALSE;
	panel_binding_hide_emoji_lookup_table (self);
	_tmp10_ = self->priv->m_preedit;
	preedit_hide (_tmp10_);
	_tmp11_ = self->priv->m_extension_name;
	_tmp12_ = ibus_extension_event_new ("name", _tmp11_, "is-enabled", FALSE, "is-extension", TRUE, NULL);
	g_object_ref_sink (_tmp12_);
	event = _tmp12_;
	_tmp13_ = event;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	ibus_panel_service_panel_extension ((IBusPanelService*) self, _tmp14_);
	result = FALSE;
	_g_object_unref0 (event);
	return result;
}


static gboolean
panel_binding_key_press_enter (PanelBinding* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	IBusText* text = NULL;
	Preedit* _tmp3_;
	IBusText* _tmp4_;
	IBusText* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->m_extension_name;
	if (g_strcmp0 (_tmp1_, "unicode") != 0) {
		_tmp0_ = panel_binding_is_emoji_lookup_table (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		IBusEmojier* _tmp2_;
		_tmp2_ = self->priv->m_emojier;
		if (ibus_emojier_key_press_enter (_tmp2_)) {
			panel_binding_convert_preedit_text (self);
			result = TRUE;
			return result;
		}
	}
	_tmp3_ = self->priv->m_preedit;
	_tmp4_ = preedit_get_commit_text (_tmp3_);
	text = _tmp4_;
	_tmp5_ = text;
	panel_binding_commit_text_update_favorites (self, _tmp5_);
	result = FALSE;
	_g_object_unref0 (text);
	return result;
}


static void
panel_binding_convert_preedit_text (PanelBinding* self)
{
	IBusEmojier* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier;
	if (ibus_emojier_get_number_of_candidates (_tmp0_) > ((guint) 0)) {
		Preedit* _tmp1_;
		IBusEmojier* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->m_preedit;
		_tmp2_ = self->priv->m_emojier;
		_tmp3_ = ibus_emojier_get_current_candidate (_tmp2_);
		_tmp4_ = _tmp3_;
		preedit_set_emoji (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		Preedit* _tmp5_;
		_tmp5_ = self->priv->m_preedit;
		preedit_set_emoji (_tmp5_, "");
	}
}


static gboolean
panel_binding_key_press_space (PanelBinding* self)
{
	gboolean result = FALSE;
	gboolean show_candidate = FALSE;
	Preedit* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	show_candidate = FALSE;
	_tmp0_ = self->priv->m_preedit;
	_tmp1_ = preedit_get_emoji (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		IBusEmojier* _tmp4_;
		_tmp4_ = self->priv->m_emojier;
		ibus_emojier_key_press_cursor_horizontal (_tmp4_, (guint) GDK_KEY_Right, (guint) 0);
		show_candidate = TRUE;
	} else {
		gchar* annotation = NULL;
		Preedit* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp5_ = self->priv->m_preedit;
		_tmp6_ = preedit_get_text (_tmp5_);
		annotation = _tmp6_;
		_tmp7_ = annotation;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == 0) {
			show_candidate = TRUE;
			if (panel_binding_is_emoji_lookup_table (self)) {
				IBusEmojier* _tmp10_;
				_tmp10_ = self->priv->m_emojier;
				ibus_emojier_key_press_cursor_horizontal (_tmp10_, (guint) GDK_KEY_Right, (guint) 0);
			}
		} else {
			IBusEmojier* _tmp11_;
			const gchar* _tmp12_;
			_tmp11_ = self->priv->m_emojier;
			_tmp12_ = annotation;
			ibus_emojier_set_annotation (_tmp11_, _tmp12_);
		}
		_g_free0 (annotation);
	}
	panel_binding_convert_preedit_text (self);
	result = show_candidate;
	return result;
}


static gboolean
panel_binding_key_press_cursor_horizontal (PanelBinding* self,
                                           guint keyval,
                                           guint modifiers)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (panel_binding_is_emoji_lookup_table (self)) {
		IBusEmojier* _tmp0_;
		_tmp0_ = self->priv->m_emojier;
		ibus_emojier_key_press_cursor_horizontal (_tmp0_, keyval, modifiers);
		panel_binding_convert_preedit_text (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
panel_binding_key_press_cursor_vertical (PanelBinding* self,
                                         guint keyval,
                                         guint modifiers)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (panel_binding_is_emoji_lookup_table (self)) {
		IBusEmojier* _tmp0_;
		_tmp0_ = self->priv->m_emojier;
		ibus_emojier_key_press_cursor_vertical (_tmp0_, keyval, modifiers);
		panel_binding_convert_preedit_text (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
panel_binding_key_press_cursor_home_end (PanelBinding* self,
                                         guint keyval,
                                         guint modifiers)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (panel_binding_is_emoji_lookup_table (self)) {
		IBusEmojier* _tmp0_;
		_tmp0_ = self->priv->m_emojier;
		ibus_emojier_key_press_cursor_home_end (_tmp0_, keyval, modifiers);
		panel_binding_convert_preedit_text (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
panel_binding_key_press_control_keyval (PanelBinding* self,
                                        guint keyval,
                                        guint modifiers)
{
	gboolean result = FALSE;
	gboolean show_candidate = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	show_candidate = FALSE;
	switch (keyval) {
		case GDK_KEY_f:
		{
			show_candidate = panel_binding_key_press_cursor_horizontal (self, (guint) GDK_KEY_Right, modifiers);
			break;
		}
		case GDK_KEY_b:
		{
			show_candidate = panel_binding_key_press_cursor_horizontal (self, (guint) GDK_KEY_Left, modifiers);
			break;
		}
		case GDK_KEY_n:
		case GDK_KEY_N:
		{
			show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Down, modifiers);
			break;
		}
		case GDK_KEY_p:
		case GDK_KEY_P:
		{
			show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Up, modifiers);
			break;
		}
		case GDK_KEY_h:
		{
			show_candidate = panel_binding_key_press_cursor_home_end (self, (guint) GDK_KEY_Home, modifiers);
			break;
		}
		case GDK_KEY_e:
		{
			show_candidate = panel_binding_key_press_cursor_home_end (self, (guint) GDK_KEY_End, modifiers);
			break;
		}
		case GDK_KEY_u:
		{
			Preedit* _tmp0_;
			IBusEmojier* _tmp1_;
			_tmp0_ = self->priv->m_preedit;
			preedit_reset (_tmp0_);
			_tmp1_ = self->priv->m_emojier;
			ibus_emojier_set_annotation (_tmp1_, "");
			panel_binding_hide_emoji_lookup_table (self);
			break;
		}
		case GDK_KEY_C:
		case GDK_KEY_c:
		{
			if ((modifiers & GDK_SHIFT_MASK) != ((guint) 0)) {
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_;
				_tmp4_ = self->priv->m_is_wayland;
				if (!_tmp4_) {
					IBusEmojier* _tmp5_;
					_tmp5_ = self->priv->m_emojier;
					_tmp3_ = _tmp5_ != NULL;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					IBusEmojier* _tmp6_;
					_tmp6_ = self->priv->m_emojier;
					_tmp2_ = ibus_emojier_get_number_of_candidates (_tmp6_) > ((guint) 0);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gchar* text = NULL;
					IBusEmojier* _tmp7_;
					gchar* _tmp8_;
					GtkClipboard* clipboard = NULL;
					GtkClipboard* _tmp9_;
					GtkClipboard* _tmp10_;
					GtkClipboard* _tmp11_;
					const gchar* _tmp12_;
					GtkClipboard* _tmp13_;
					_tmp7_ = self->priv->m_emojier;
					_tmp8_ = ibus_emojier_get_current_candidate (_tmp7_);
					text = _tmp8_;
					_tmp9_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
					_tmp10_ = _g_object_ref0 (_tmp9_);
					clipboard = _tmp10_;
					_tmp11_ = clipboard;
					_tmp12_ = text;
					gtk_clipboard_set_text (_tmp11_, _tmp12_, -1);
					_tmp13_ = clipboard;
					gtk_clipboard_store (_tmp13_);
					_g_object_unref0 (clipboard);
					_g_free0 (text);
				}
				show_candidate = panel_binding_is_emoji_lookup_table (self);
			}
			break;
		}
		default:
		{
			show_candidate = panel_binding_is_emoji_lookup_table (self);
			break;
		}
	}
	result = show_candidate;
	return result;
}


static void
panel_binding_hide_wayland_lookup_table (PanelBinding* self)
{
	IBusText* text = NULL;
	IBusText* _tmp0_;
	IBusLookupTable* _tmp1_;
	IBusLookupTable* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->m_wayland_lookup_table_is_visible = FALSE;
	_tmp0_ = ibus_text_new_from_string ("");
	g_object_ref_sink (_tmp0_);
	text = _tmp0_;
	ibus_panel_service_update_auxiliary_text_received ((IBusPanelService*) self, text, FALSE);
	_tmp1_ = ibus_lookup_table_new ((guint) 1, (guint) 0, FALSE, TRUE);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	ibus_panel_service_update_lookup_table_received ((IBusPanelService*) self, _tmp2_, FALSE);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (text);
}


static void
panel_binding_show_wayland_lookup_table (PanelBinding* self,
                                         IBusText* text)
{
	IBusLookupTable* table = NULL;
	IBusEmojier* _tmp0_;
	IBusLookupTable* _tmp1_;
	guint ncandidates = 0U;
	IBusLookupTable* _tmp2_;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_;
	gboolean _tmp5_ = FALSE;
	guint _tmp6_;
	IBusLookupTable* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	self->priv->m_wayland_lookup_table_is_visible = TRUE;
	_tmp0_ = self->priv->m_emojier;
	_tmp1_ = ibus_emojier_get_one_dimension_lookup_table (_tmp0_);
	table = _tmp1_;
	_tmp2_ = table;
	ncandidates = ibus_lookup_table_get_number_of_candidates (_tmp2_);
	_tmp4_ = ncandidates;
	if (_tmp4_ > ((guint) 0)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = FALSE;
	}
	ibus_panel_service_update_auxiliary_text_received ((IBusPanelService*) self, text, _tmp3_);
	_tmp6_ = ncandidates;
	if (_tmp6_ > ((guint) 0)) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp7_ = table;
	ibus_panel_service_update_lookup_table_received ((IBusPanelService*) self, _tmp7_, _tmp5_);
	_g_object_unref0 (table);
}


static gboolean
panel_binding_is_visible_wayland_lookup_table (PanelBinding* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_wayland_lookup_table_is_visible;
	result = _tmp0_;
	return result;
}


static void
panel_binding_hide_emoji_lookup_table (PanelBinding* self)
{
	IBusEmojier* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_is_wayland;
	if (_tmp1_) {
		panel_binding_hide_wayland_lookup_table (self);
	} else {
		IBusEmojier* _tmp2_;
		_tmp2_ = self->priv->m_emojier;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
}


static void
panel_binding_show_emoji_lookup_table (PanelBinding* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->m_is_wayland;
	if (_tmp1_) {
		Preedit* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->m_preedit;
		_tmp3_ = preedit_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "") != 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		IBusText* text = NULL;
		IBusEmojier* _tmp5_;
		IBusText* _tmp6_;
		IBusText* _tmp7_;
		_tmp5_ = self->priv->m_emojier;
		_tmp6_ = ibus_emojier_get_title_text (_tmp5_);
		text = _tmp6_;
		_tmp7_ = text;
		panel_binding_show_wayland_lookup_table (self, _tmp7_);
		_g_object_unref0 (text);
	} else {
		gboolean _tmp8_;
		IBusEmojier* _tmp11_;
		_tmp8_ = self->priv->m_is_wayland;
		if (_tmp8_) {
			IBusEmojier* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = self->priv->m_emojier;
			_tmp10_ = self->priv->m_real_current_context_path;
			ibus_emojier_set_input_context_path (_tmp9_, _tmp10_);
		}
		_tmp11_ = self->priv->m_emojier;
		gtk_widget_show_all ((GtkWidget*) _tmp11_);
	}
}


static gboolean
panel_binding_is_emoji_lookup_table (PanelBinding* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_is_wayland;
	if (_tmp0_) {
		result = panel_binding_is_visible_wayland_lookup_table (self);
		return result;
	} else {
		IBusEmojier* _tmp1_;
		_tmp1_ = self->priv->m_emojier;
		result = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
		return result;
	}
}


static void
panel_binding_show_preedit_and_candidate (PanelBinding* self,
                                          gboolean show_candidate)
{
	guint cursor_pos = 0U;
	Preedit* _tmp1_;
	IBusText* _tmp2_;
	IBusText* _tmp3_;
	guint _tmp4_;
	IBusEmojier* _tmp5_;
	g_return_if_fail (self != NULL);
	cursor_pos = (guint) 0;
	if (!show_candidate) {
		Preedit* _tmp0_;
		_tmp0_ = self->priv->m_preedit;
		cursor_pos = preedit_get_engine_preedit_cursor_pos (_tmp0_);
	}
	_tmp1_ = self->priv->m_preedit;
	_tmp2_ = preedit_get_engine_preedit_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = cursor_pos;
	ibus_panel_service_update_preedit_text_received ((IBusPanelService*) self, _tmp3_, _tmp4_, TRUE);
	_g_object_unref0 (_tmp3_);
	if (!show_candidate) {
		panel_binding_hide_emoji_lookup_table (self);
		return;
	}
	_tmp5_ = self->priv->m_emojier;
	if (_tmp5_ == NULL) {
		return;
	}
	panel_binding_show_emoji_lookup_table (self);
}


static void
panel_binding_real_focus_in (IBusPanelService* base,
                             const gchar* input_context_path)
{
	PanelBinding * self;
	gchar* _tmp0_;
	self = (PanelBinding*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = g_strdup (input_context_path);
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp0_;
	if (!g_str_has_suffix (input_context_path, "InputContext_1")) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->m_current_context_path;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (self->priv->m_real_current_context_path);
		self->priv->m_real_current_context_path = _tmp2_;
		panel_binding_emojier_focus_commit (self);
	}
}


static void
panel_binding_real_focus_out (IBusPanelService* base,
                              const gchar* input_context_path)
{
	PanelBinding * self;
	gchar* _tmp0_;
	self = (PanelBinding*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp0_;
}


static void
___lambda43_ (PanelBinding* self,
              guint i,
              guint b,
              guint s)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->m_is_wayland;
	if (!_tmp0_) {
		g_signal_emit_by_name ((IBusPanelService*) self, "candidate-clicked-lookup-table", i, b, s);
	}
}


static void
____lambda43__ibus_emojier_candidate_clicked (IBusEmojier* _sender,
                                              guint index,
                                              guint button,
                                              guint state,
                                              gpointer self)
{
	___lambda43_ ((PanelBinding*) self, index, button, state);
}


static void
panel_binding_real_panel_extension_received (IBusPanelService* base,
                                             IBusExtensionEvent* event)
{
	PanelBinding * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	IBusEmojier* _tmp18_;
	IBusEmojier* _tmp23_;
	IBusEmojier* _tmp24_;
	Preedit* _tmp25_;
	const gchar* _tmp26_;
	Preedit* _tmp27_;
	Preedit* _tmp28_;
	IBusText* _tmp29_;
	IBusText* _tmp30_;
	Preedit* _tmp31_;
	gchar* params = NULL;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	self = (PanelBinding*) base;
	g_return_if_fail (event != NULL);
	_tmp0_ = ibus_extension_event_get_name (event);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->m_extension_name);
	self->priv->m_extension_name = _tmp1_;
	_tmp3_ = self->priv->m_extension_name;
	if (g_strcmp0 (_tmp3_, "emoji") != 0) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->m_extension_name;
		_tmp2_ = g_strcmp0 (_tmp4_, "unicode") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* format = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = g_strdup ("The name %s is not implemented in PanelExtension");
		format = _tmp5_;
		_tmp6_ = format;
		_tmp7_ = self->priv->m_extension_name;
		_tmp8_ = g_strdup_printf (_tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		g_warning ("panelbinding.vala:787: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = g_strdup ("");
		_g_free0 (self->priv->m_extension_name);
		self->priv->m_extension_name = _tmp10_;
		_g_free0 (format);
		return;
	}
	g_object_get (event, "is-enabled", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	self->priv->m_enable_extension = _tmp12_;
	_tmp13_ = self->priv->m_enable_extension;
	if (!_tmp13_) {
		panel_binding_hide_emoji_lookup_table (self);
		return;
	}
	_tmp14_ = self->priv->m_loaded_emoji;
	if (!_tmp14_) {
		panel_binding_set_emoji_lang (self);
	}
	_tmp16_ = self->priv->m_loaded_unicode;
	if (!_tmp16_) {
		gboolean _tmp17_;
		_tmp17_ = self->priv->m_loaded_emoji;
		_tmp15_ = _tmp17_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ibus_emojier_load_unicode_dict ();
		self->priv->m_loaded_unicode = TRUE;
	}
	_tmp18_ = self->priv->m_emojier;
	if (_tmp18_ == NULL) {
		IBusEmojier* _tmp19_;
		GtkApplication* _tmp20_;
		IBusEmojier* _tmp21_;
		IBusEmojier* _tmp22_;
		_tmp19_ = ibus_emojier_new ();
		g_object_ref_sink (_tmp19_);
		_g_object_unref0 (self->priv->m_emojier);
		self->priv->m_emojier = _tmp19_;
		_tmp20_ = self->priv->m_application;
		_tmp21_ = self->priv->m_emojier;
		gtk_application_add_window (_tmp20_, (GtkWindow*) _tmp21_);
		_tmp22_ = self->priv->m_emojier;
		g_signal_connect_object (_tmp22_, "candidate-clicked", (GCallback) ____lambda43__ibus_emojier_candidate_clicked, self, 0);
	}
	_tmp23_ = self->priv->m_emojier;
	ibus_emojier_reset (_tmp23_);
	_tmp24_ = self->priv->m_emojier;
	ibus_emojier_set_annotation (_tmp24_, "");
	_tmp25_ = self->priv->m_preedit;
	_tmp26_ = self->priv->m_extension_name;
	preedit_set_extension_name (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->m_preedit;
	preedit_reset (_tmp27_);
	_tmp28_ = self->priv->m_preedit;
	_tmp29_ = preedit_get_engine_preedit_text (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->m_preedit;
	ibus_panel_service_update_preedit_text_received ((IBusPanelService*) self, _tmp30_, preedit_get_engine_preedit_cursor_pos (_tmp31_), TRUE);
	_g_object_unref0 (_tmp30_);
	_tmp32_ = ibus_extension_event_get_params (event);
	_tmp33_ = g_strdup (_tmp32_);
	params = _tmp33_;
	_tmp34_ = params;
	if (g_strcmp0 (_tmp34_, "category-list") == 0) {
		panel_binding_key_press_space (self);
		panel_binding_show_preedit_and_candidate (self, TRUE);
	}
	_g_free0 (params);
}


static void
panel_binding_real_set_cursor_location (IBusPanelService* base,
                                        gint x,
                                        gint y,
                                        gint width,
                                        gint height)
{
	PanelBinding * self;
	IBusEmojier* _tmp0_;
	self = (PanelBinding*) base;
	_tmp0_ = self->priv->m_emojier;
	if (_tmp0_ != NULL) {
		IBusEmojier* _tmp1_;
		_tmp1_ = self->priv->m_emojier;
		ibus_emojier_set_cursor_location (_tmp1_, x, y, width, height);
	}
}


static void
panel_binding_real_update_preedit_text (IBusPanelService* base,
                                        IBusText* text,
                                        guint cursor_pos,
                                        gboolean visible)
{
	PanelBinding * self;
	Preedit* _tmp0_;
	Preedit* _tmp3_;
	Preedit* _tmp4_;
	IBusText* _tmp5_;
	IBusText* _tmp6_;
	Preedit* _tmp7_;
	self = (PanelBinding*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->m_preedit;
	preedit_set_engine_preedit_text (_tmp0_, text);
	if (visible) {
		Preedit* _tmp1_;
		_tmp1_ = self->priv->m_preedit;
		preedit_show_engine_preedit_text (_tmp1_);
	} else {
		Preedit* _tmp2_;
		_tmp2_ = self->priv->m_preedit;
		preedit_hide_engine_preedit_text (_tmp2_);
	}
	_tmp3_ = self->priv->m_preedit;
	preedit_set_engine_preedit_cursor_pos (_tmp3_, cursor_pos);
	_tmp4_ = self->priv->m_preedit;
	_tmp5_ = preedit_get_engine_preedit_text (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->m_preedit;
	ibus_panel_service_update_preedit_text_received ((IBusPanelService*) self, _tmp6_, preedit_get_engine_preedit_cursor_pos (_tmp7_), visible);
	_g_object_unref0 (_tmp6_);
}


static void
panel_binding_real_show_preedit_text (IBusPanelService* base)
{
	PanelBinding * self;
	Preedit* _tmp0_;
	self = (PanelBinding*) base;
	_tmp0_ = self->priv->m_preedit;
	preedit_show_engine_preedit_text (_tmp0_);
	panel_binding_show_preedit_and_candidate (self, FALSE);
}


static void
panel_binding_real_hide_preedit_text (IBusPanelService* base)
{
	PanelBinding * self;
	Preedit* _tmp0_;
	self = (PanelBinding*) base;
	_tmp0_ = self->priv->m_preedit;
	preedit_hide_engine_preedit_text (_tmp0_);
	panel_binding_show_preedit_and_candidate (self, FALSE);
}


static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean
panel_binding_real_process_key_event (IBusPanelService* base,
                                      guint keyval,
                                      guint keycode,
                                      guint state)
{
	PanelBinding * self;
	gboolean result = FALSE;
	guint modifiers = 0U;
	gboolean show_candidate = FALSE;
	gboolean _tmp44_;
	self = (PanelBinding*) base;
	if ((state & IBUS_RELEASE_MASK) != ((guint) 0)) {
		result = FALSE;
		return result;
	}
	modifiers = state;
	show_candidate = FALSE;
	switch (keyval) {
		case GDK_KEY_Escape:
		{
			Preedit* _tmp0_;
			show_candidate = panel_binding_key_press_escape (self);
			_tmp0_ = self->priv->m_preedit;
			if (!preedit_is_shown (_tmp0_)) {
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Return:
		case GDK_KEY_KP_Enter:
		{
			const gchar* _tmp1_;
			Preedit* _tmp2_;
			_tmp1_ = self->priv->m_extension_name;
			if (g_strcmp0 (_tmp1_, "unicode") == 0) {
				panel_binding_key_press_space (self);
			}
			show_candidate = panel_binding_key_press_enter (self);
			_tmp2_ = self->priv->m_preedit;
			if (!preedit_is_shown (_tmp2_)) {
				panel_binding_hide_emoji_lookup_table (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_BackSpace:
		{
			Preedit* _tmp3_;
			gchar* annotation = NULL;
			Preedit* _tmp4_;
			gchar* _tmp5_;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_;
			IBusEmojier* _tmp9_;
			const gchar* _tmp10_;
			_tmp3_ = self->priv->m_preedit;
			preedit_backspace (_tmp3_);
			_tmp4_ = self->priv->m_preedit;
			_tmp5_ = preedit_get_text (_tmp4_);
			annotation = _tmp5_;
			_tmp7_ = annotation;
			if (g_strcmp0 (_tmp7_, "") == 0) {
				const gchar* _tmp8_;
				_tmp8_ = self->priv->m_extension_name;
				_tmp6_ = g_strcmp0 (_tmp8_, "unicode") == 0;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				panel_binding_key_press_escape (self);
				result = TRUE;
				_g_free0 (annotation);
				return result;
			}
			_tmp9_ = self->priv->m_emojier;
			_tmp10_ = annotation;
			ibus_emojier_set_annotation (_tmp9_, _tmp10_);
			_g_free0 (annotation);
			break;
		}
		case GDK_KEY_space:
		case GDK_KEY_KP_Space:
		{
			const gchar* _tmp11_;
			show_candidate = panel_binding_key_press_space (self);
			_tmp11_ = self->priv->m_extension_name;
			if (g_strcmp0 (_tmp11_, "unicode") == 0) {
				panel_binding_key_press_enter (self);
				result = TRUE;
				return result;
			}
			break;
		}
		case GDK_KEY_Right:
		case GDK_KEY_KP_Right:
		{
			gboolean _tmp12_;
			_tmp12_ = self->priv->m_is_wayland;
			if (_tmp12_) {
				guint _tmp13_;
				_tmp13_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Down, _tmp13_);
			} else {
				guint _tmp14_;
				_tmp14_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_horizontal (self, (guint) GDK_KEY_Right, _tmp14_);
			}
			break;
		}
		case GDK_KEY_Left:
		case GDK_KEY_KP_Left:
		{
			gboolean _tmp15_;
			_tmp15_ = self->priv->m_is_wayland;
			if (_tmp15_) {
				guint _tmp16_;
				_tmp16_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Up, _tmp16_);
			} else {
				guint _tmp17_;
				_tmp17_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_horizontal (self, (guint) GDK_KEY_Left, _tmp17_);
			}
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_KP_Down:
		{
			gboolean _tmp18_;
			_tmp18_ = self->priv->m_is_wayland;
			if (_tmp18_) {
				guint _tmp19_;
				_tmp19_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_horizontal (self, (guint) GDK_KEY_Right, _tmp19_);
			} else {
				guint _tmp20_;
				_tmp20_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Down, _tmp20_);
			}
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_KP_Up:
		{
			gboolean _tmp21_;
			_tmp21_ = self->priv->m_is_wayland;
			if (_tmp21_) {
				guint _tmp22_;
				_tmp22_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_horizontal (self, (guint) GDK_KEY_Left, _tmp22_);
			} else {
				guint _tmp23_;
				_tmp23_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Up, _tmp23_);
			}
			break;
		}
		case GDK_KEY_Page_Down:
		case GDK_KEY_KP_Page_Down:
		{
			gboolean _tmp24_;
			_tmp24_ = self->priv->m_is_wayland;
			if (_tmp24_) {
				guint _tmp25_;
				_tmp25_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Down, _tmp25_);
			} else {
				guint _tmp26_;
				_tmp26_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Page_Down, _tmp26_);
			}
			break;
		}
		case GDK_KEY_Page_Up:
		case GDK_KEY_KP_Page_Up:
		{
			gboolean _tmp27_;
			_tmp27_ = self->priv->m_is_wayland;
			if (_tmp27_) {
				guint _tmp28_;
				_tmp28_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Up, _tmp28_);
			} else {
				guint _tmp29_;
				_tmp29_ = modifiers;
				show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Page_Up, _tmp29_);
			}
			break;
		}
		case GDK_KEY_Home:
		case GDK_KEY_KP_Home:
		{
			guint _tmp30_;
			_tmp30_ = modifiers;
			show_candidate = panel_binding_key_press_cursor_home_end (self, (guint) GDK_KEY_Home, _tmp30_);
			break;
		}
		case GDK_KEY_End:
		case GDK_KEY_KP_End:
		{
			guint _tmp31_;
			_tmp31_ = modifiers;
			show_candidate = panel_binding_key_press_cursor_home_end (self, (guint) GDK_KEY_End, _tmp31_);
			break;
		}
		default:
		{
			guint _tmp32_;
			gunichar ch = 0U;
			gunichar _tmp34_;
			gchar* str = NULL;
			gunichar _tmp35_;
			gchar* _tmp36_;
			Preedit* _tmp37_;
			const gchar* _tmp38_;
			gchar* annotation = NULL;
			Preedit* _tmp39_;
			gchar* _tmp40_;
			IBusEmojier* _tmp41_;
			const gchar* _tmp42_;
			Preedit* _tmp43_;
			_tmp32_ = modifiers;
			if ((_tmp32_ & GDK_CONTROL_MASK) != ((guint) 0)) {
				guint _tmp33_;
				_tmp33_ = modifiers;
				show_candidate = panel_binding_key_press_control_keyval (self, keyval, _tmp33_);
				break;
			}
			ch = ibus_keyval_to_unicode (keyval);
			_tmp34_ = ch;
			if (g_unichar_iscntrl (_tmp34_)) {
				result = TRUE;
				return result;
			}
			_tmp35_ = ch;
			_tmp36_ = g_unichar_to_string (_tmp35_);
			str = _tmp36_;
			_tmp37_ = self->priv->m_preedit;
			_tmp38_ = str;
			preedit_append_text (_tmp37_, _tmp38_);
			_tmp39_ = self->priv->m_preedit;
			_tmp40_ = preedit_get_text (_tmp39_);
			annotation = _tmp40_;
			_tmp41_ = self->priv->m_emojier;
			_tmp42_ = annotation;
			ibus_emojier_set_annotation (_tmp41_, _tmp42_);
			_tmp43_ = self->priv->m_preedit;
			preedit_set_emoji (_tmp43_, "");
			show_candidate = panel_binding_is_emoji_lookup_table (self);
			_g_free0 (annotation);
			_g_free0 (str);
			break;
		}
	}
	_tmp44_ = show_candidate;
	panel_binding_show_preedit_and_candidate (self, _tmp44_);
	result = TRUE;
	return result;
}


static void
panel_binding_real_commit_text_received (IBusPanelService* base,
                                         IBusText* text)
{
	PanelBinding * self;
	const gchar* str = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	Preedit* _tmp2_;
	const gchar* _tmp3_;
	Preedit* _tmp4_;
	gchar* annotation = NULL;
	Preedit* _tmp5_;
	gchar* _tmp6_;
	IBusEmojier* _tmp7_;
	const gchar* _tmp8_;
	self = (PanelBinding*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = text->text;
	str = _tmp0_;
	_tmp1_ = str;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->m_preedit;
	_tmp3_ = str;
	preedit_append_text (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->m_preedit;
	preedit_set_emoji (_tmp4_, "");
	_tmp5_ = self->priv->m_preedit;
	_tmp6_ = preedit_get_text (_tmp5_);
	annotation = _tmp6_;
	_tmp7_ = self->priv->m_emojier;
	_tmp8_ = annotation;
	ibus_emojier_set_annotation (_tmp7_, _tmp8_);
	panel_binding_show_preedit_and_candidate (self, FALSE);
	_g_free0 (annotation);
}


static void
panel_binding_real_page_up_lookup_table (IBusPanelService* base)
{
	PanelBinding * self;
	gboolean show_candidate = FALSE;
	self = (PanelBinding*) base;
	show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Up, (guint) 0);
	panel_binding_show_preedit_and_candidate (self, show_candidate);
}


static void
panel_binding_real_page_down_lookup_table (IBusPanelService* base)
{
	PanelBinding * self;
	gboolean show_candidate = FALSE;
	self = (PanelBinding*) base;
	show_candidate = panel_binding_key_press_cursor_vertical (self, (guint) GDK_KEY_Down, (guint) 0);
	panel_binding_show_preedit_and_candidate (self, show_candidate);
}


static void
panel_binding_real_cursor_up_lookup_table (IBusPanelService* base)
{
	PanelBinding * self;
	gboolean show_candidate = FALSE;
	self = (PanelBinding*) base;
	show_candidate = panel_binding_key_press_cursor_horizontal (self, (guint) GDK_KEY_Left, (guint) 0);
	panel_binding_show_preedit_and_candidate (self, show_candidate);
}


static void
panel_binding_real_cursor_down_lookup_table (IBusPanelService* base)
{
	PanelBinding * self;
	gboolean show_candidate = FALSE;
	self = (PanelBinding*) base;
	show_candidate = panel_binding_key_press_cursor_horizontal (self, (guint) GDK_KEY_Right, (guint) 0);
	panel_binding_show_preedit_and_candidate (self, show_candidate);
}


static void
panel_binding_real_candidate_clicked_lookup_table (IBusPanelService* base,
                                                   guint index,
                                                   guint button,
                                                   guint state)
{
	PanelBinding * self;
	IBusEmojier* _tmp5_;
	gboolean show_candidate = FALSE;
	guint ncandidates = 0U;
	IBusEmojier* _tmp6_;
	gboolean _tmp7_ = FALSE;
	guint _tmp8_;
	gboolean _tmp16_;
	gboolean _tmp20_;
	self = (PanelBinding*) base;
	if (button == IBUS_EMOJIER_BUTTON_CLOSE_BUTTON) {
		Preedit* _tmp0_;
		IBusExtensionEvent* event = NULL;
		const gchar* _tmp1_;
		IBusExtensionEvent* _tmp2_;
		IBusExtensionEvent* _tmp3_;
		IBusExtensionEvent* _tmp4_;
		self->priv->m_enable_extension = FALSE;
		panel_binding_hide_emoji_lookup_table (self);
		_tmp0_ = self->priv->m_preedit;
		preedit_hide (_tmp0_);
		_tmp1_ = self->priv->m_extension_name;
		_tmp2_ = ibus_extension_event_new ("name", _tmp1_, "is-enabled", FALSE, "is-extension", TRUE, NULL);
		g_object_ref_sink (_tmp2_);
		event = _tmp2_;
		_tmp3_ = event;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		ibus_panel_service_panel_extension ((IBusPanelService*) self, _tmp4_);
		_g_object_unref0 (event);
		return;
	}
	_tmp5_ = self->priv->m_emojier;
	if (_tmp5_ == NULL) {
		return;
	}
	show_candidate = FALSE;
	_tmp6_ = self->priv->m_emojier;
	ncandidates = ibus_emojier_get_number_of_candidates (_tmp6_);
	_tmp8_ = ncandidates;
	if (_tmp8_ > ((guint) 0)) {
		guint _tmp9_;
		_tmp9_ = ncandidates;
		_tmp7_ = _tmp9_ >= index;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		IBusEmojier* _tmp10_;
		IBusEmojier* _tmp11_;
		Preedit* _tmp12_;
		IBusEmojier* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp10_ = self->priv->m_emojier;
		ibus_emojier_set_cursor_pos (_tmp10_, index);
		_tmp11_ = self->priv->m_emojier;
		show_candidate = ibus_emojier_has_variants (_tmp11_, index);
		_tmp12_ = self->priv->m_preedit;
		_tmp13_ = self->priv->m_emojier;
		_tmp14_ = ibus_emojier_get_current_candidate (_tmp13_);
		_tmp15_ = _tmp14_;
		preedit_set_emoji (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
	} else {
		return;
	}
	_tmp16_ = show_candidate;
	if (!_tmp16_) {
		IBusText* text = NULL;
		Preedit* _tmp17_;
		IBusText* _tmp18_;
		IBusText* _tmp19_;
		_tmp17_ = self->priv->m_preedit;
		_tmp18_ = preedit_get_commit_text (_tmp17_);
		text = _tmp18_;
		_tmp19_ = text;
		panel_binding_commit_text_update_favorites (self, _tmp19_);
		panel_binding_hide_emoji_lookup_table (self);
		_g_object_unref0 (text);
		return;
	}
	_tmp20_ = show_candidate;
	panel_binding_show_preedit_and_candidate (self, _tmp20_);
}


static void
panel_binding_class_init (PanelBindingClass * klass)
{
	panel_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PanelBindingPrivate));
	((IBusPanelServiceClass *) klass)->focus_in = (void (*) (IBusPanelService *, const gchar*)) panel_binding_real_focus_in;
	((IBusPanelServiceClass *) klass)->focus_out = (void (*) (IBusPanelService *, const gchar*)) panel_binding_real_focus_out;
	((IBusPanelServiceClass *) klass)->panel_extension_received = (void (*) (IBusPanelService *, IBusExtensionEvent*)) panel_binding_real_panel_extension_received;
	((IBusPanelServiceClass *) klass)->set_cursor_location = (void (*) (IBusPanelService *, gint, gint, gint, gint)) panel_binding_real_set_cursor_location;
	((IBusPanelServiceClass *) klass)->update_preedit_text = (void (*) (IBusPanelService *, IBusText*, guint, gboolean)) panel_binding_real_update_preedit_text;
	((IBusPanelServiceClass *) klass)->show_preedit_text = (void (*) (IBusPanelService *)) panel_binding_real_show_preedit_text;
	((IBusPanelServiceClass *) klass)->hide_preedit_text = (void (*) (IBusPanelService *)) panel_binding_real_hide_preedit_text;
	((IBusPanelServiceClass *) klass)->process_key_event = (gboolean (*) (IBusPanelService *, guint, guint, guint)) panel_binding_real_process_key_event;
	((IBusPanelServiceClass *) klass)->commit_text_received = (void (*) (IBusPanelService *, IBusText*)) panel_binding_real_commit_text_received;
	((IBusPanelServiceClass *) klass)->page_up_lookup_table = (void (*) (IBusPanelService *)) panel_binding_real_page_up_lookup_table;
	((IBusPanelServiceClass *) klass)->page_down_lookup_table = (void (*) (IBusPanelService *)) panel_binding_real_page_down_lookup_table;
	((IBusPanelServiceClass *) klass)->cursor_up_lookup_table = (void (*) (IBusPanelService *)) panel_binding_real_cursor_up_lookup_table;
	((IBusPanelServiceClass *) klass)->cursor_down_lookup_table = (void (*) (IBusPanelService *)) panel_binding_real_cursor_down_lookup_table;
	((IBusPanelServiceClass *) klass)->candidate_clicked_lookup_table = (void (*) (IBusPanelService *, guint, guint, guint)) panel_binding_real_candidate_clicked_lookup_table;
	G_OBJECT_CLASS (klass)->finalize = panel_binding_finalize;
}


static void
panel_binding_instance_init (PanelBinding * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_;
	self->priv = PANEL_BINDING_GET_PRIVATE (self);
	self->priv->m_settings_panel = NULL;
	self->priv->m_settings_emoji = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->m_current_context_path = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->m_real_current_context_path = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_emojier_favorites = _tmp2_;
	self->priv->m_emojier_favorites_length1 = 0;
	self->priv->_m_emojier_favorites_size_ = self->priv->m_emojier_favorites_length1;
	self->priv->m_loaded_emoji = FALSE;
	self->priv->m_loaded_unicode = FALSE;
	_tmp3_ = g_strdup ("");
	self->priv->m_extension_name = _tmp3_;
	memset (&self->priv->m_key_event_data, 0, sizeof (IBusProcessKeyEventData));
}


static void
panel_binding_finalize (GObject * obj)
{
	PanelBinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL_BINDING, PanelBinding);
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_application);
	_g_object_unref0 (self->priv->m_settings_panel);
	_g_object_unref0 (self->priv->m_settings_emoji);
	_g_free0 (self->priv->m_current_context_path);
	_g_free0 (self->priv->m_real_current_context_path);
	_g_object_unref0 (self->priv->m_emojier);
	self->priv->m_emojier_favorites = (_vala_array_free (self->priv->m_emojier_favorites, self->priv->m_emojier_favorites_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->m_css_provider);
	_g_free0 (self->priv->m_extension_name);
	_g_object_unref0 (self->priv->m_preedit);
	G_OBJECT_CLASS (panel_binding_parent_class)->finalize (obj);
}


GType
panel_binding_get_type (void)
{
	static volatile gsize panel_binding_type_id__volatile = 0;
	if (g_once_init_enter (&panel_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PanelBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PanelBinding), 0, (GInstanceInitFunc) panel_binding_instance_init, NULL };
		GType panel_binding_type_id;
		panel_binding_type_id = g_type_register_static (ibus_panel_service_get_type (), "PanelBinding", &g_define_type_info, 0);
		g_once_init_leave (&panel_binding_type_id__volatile, panel_binding_type_id);
	}
	return panel_binding_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



