/* candidatepanel.c generated by valac 0.38.2, the Vala compiler
 * generated from candidatepanel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2015 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <ibus.h>
#include <string.h>
#include <cairo.h>
#include <pango/pango.h>
#include <stdlib.h>


#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;
typedef struct _CandidatePanelPrivate CandidatePanelPrivate;

#define TYPE_CANDIDATE_AREA (candidate_area_get_type ())
#define CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_AREA, CandidateArea))
#define CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_AREA, CandidateAreaClass))
#define IS_CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_AREA))
#define IS_CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_AREA))
#define CANDIDATE_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_AREA, CandidateAreaClass))

typedef struct _CandidateArea CandidateArea;
typedef struct _CandidateAreaClass CandidateAreaClass;

#define TYPE_HSEPARATOR (hseparator_get_type ())
#define HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSEPARATOR, HSeparator))
#define HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSEPARATOR, HSeparatorClass))
#define IS_HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSEPARATOR))
#define IS_HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSEPARATOR))
#define HSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSEPARATOR, HSeparatorClass))

typedef struct _HSeparator HSeparator;
typedef struct _HSeparatorClass HSeparatorClass;
enum  {
	CANDIDATE_PANEL_DUMMY_PROPERTY,
	CANDIDATE_PANEL_LAST_PROPERTY
};
static GParamSpec* candidate_panel_properties[CANDIDATE_PANEL_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HANDLE (handle_get_type ())
#define HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE, Handle))
#define HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE, HandleClass))
#define IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE))
#define IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE))
#define HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE, HandleClass))

typedef struct _Handle Handle;
typedef struct _HandleClass HandleClass;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CANDIDATE_PANEL_CURSOR_UP_SIGNAL,
	CANDIDATE_PANEL_CURSOR_DOWN_SIGNAL,
	CANDIDATE_PANEL_PAGE_UP_SIGNAL,
	CANDIDATE_PANEL_PAGE_DOWN_SIGNAL,
	CANDIDATE_PANEL_CANDIDATE_CLICKED_SIGNAL,
	CANDIDATE_PANEL_LAST_SIGNAL
};
static guint candidate_panel_signals[CANDIDATE_PANEL_LAST_SIGNAL] = {0};

struct _CandidatePanel {
	GtkBox parent_instance;
	CandidatePanelPrivate * priv;
};

struct _CandidatePanelClass {
	GtkBoxClass parent_class;
};

struct _CandidatePanelPrivate {
	gboolean m_vertical_panel_system;
	gboolean m_vertical_writing;
	GtkWindow* m_toplevel;
	GtkBox* m_vbox;
	GtkLabel* m_preedit_label;
	GtkLabel* m_aux_label;
	CandidateArea* m_candidate_area;
	HSeparator* m_hseparator;
	GdkRectangle m_cursor_location;
};


static gpointer candidate_panel_parent_class = NULL;

GType candidate_panel_get_type (void) G_GNUC_CONST;
GType candidate_area_get_type (void) G_GNUC_CONST;
GType hseparator_get_type (void) G_GNUC_CONST;
#define CANDIDATE_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CANDIDATE_PANEL, CandidatePanelPrivate))
CandidatePanel* candidate_panel_new (void);
CandidatePanel* candidate_panel_construct (GType object_type);
static gboolean __lambda13_ (CandidatePanel* self, GtkWidget* w, GdkEventButton* e);
void candidate_panel_set_vertical (CandidatePanel* self, gboolean vertical);
static gboolean ___lambda13__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void __lambda14_ (CandidatePanel* self, GtkWidget* w, GtkAllocation* a);
static void candidate_panel_adjust_window_position (CandidatePanel* self);
static void ___lambda14__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
GType handle_get_type (void) G_GNUC_CONST;
Handle* handle_new (void);
Handle* handle_construct (GType object_type);
static void candidate_panel_create_ui (CandidatePanel* self);
void candidate_area_set_vertical (CandidateArea* self, gboolean vertical, gboolean force);
static void candidate_panel_set_orientation (CandidatePanel* self, IBusOrientation orientation);
void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1, const cairo_rectangle_int_t * s2);
static void candidate_panel_set_labels (CandidatePanel* self, IBusText** labels, int labels_length1);
void candidate_area_set_labels (CandidateArea* self, IBusText** labels, int labels_length1);
static void candidate_panel_set_attributes (CandidatePanel* self, GtkLabel* label, IBusText* text);
PangoAttrList* get_pango_attr_list_from_ibus_text (IBusText* text);
void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor);
static void candidate_panel_update (CandidatePanel* self);
void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text);
void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table);
static void _vala_array_add8 (IBusText** * array, int* length, int* size, IBusText* value);
static void _vala_array_add9 (IBusText** * array, int* length, int* size, IBusText* value);
void candidate_area_set_candidates (CandidateArea* self, IBusText** candidates, int candidates_length1, guint focus_candidate, gboolean show_cursor);
void candidate_panel_set_content_type (CandidatePanel* self, guint purpose, guint hints);
CandidateArea* candidate_area_new (gboolean vertical);
CandidateArea* candidate_area_construct (GType object_type, gboolean vertical);
static void __lambda15_ (CandidatePanel* self, CandidateArea* w, guint i, guint b, guint s);
static void ___lambda15__candidate_area_candidate_clicked (CandidateArea* _sender, guint index, guint button, guint state, gpointer self);
static void __lambda16_ (CandidatePanel* self, CandidateArea* c);
static void ___lambda16__candidate_area_page_up (CandidateArea* _sender, gpointer self);
static void __lambda17_ (CandidatePanel* self, CandidateArea* c);
static void ___lambda17__candidate_area_page_down (CandidateArea* _sender, gpointer self);
static void __lambda18_ (CandidatePanel* self, CandidateArea* c);
static void ___lambda18__candidate_area_cursor_up (CandidateArea* _sender, gpointer self);
static void __lambda19_ (CandidatePanel* self, CandidateArea* c);
static void ___lambda19__candidate_area_cursor_down (CandidateArea* _sender, gpointer self);
HSeparator* hseparator_new (void);
HSeparator* hseparator_construct (GType object_type);
static void candidate_panel_pack_all_widgets (CandidatePanel* self);
void candidate_panel_show (CandidatePanel* self);
void candidate_panel_hide (CandidatePanel* self);
static void candidate_panel_move (CandidatePanel* self, gint x, gint y);
static void candidate_panel_adjust_window_position_horizontal (CandidatePanel* self);
static void candidate_panel_adjust_window_position_vertical (CandidatePanel* self);
static void candidate_panel_get_monitor_geometry (CandidatePanel* self, GdkRectangle* result);
gboolean candidate_area_get_vertical (CandidateArea* self);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void candidate_panel_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean __lambda13_ (CandidatePanel* self, GtkWidget* w, GdkEventButton* e) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_;
	guint _tmp2_;
	gboolean _tmp5_;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ != ((guint) 1)) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton* _tmp3_;
		GdkModifierType _tmp4_;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->state;
		_tmp0_ = (_tmp4_ & GDK_CONTROL_MASK) == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->m_vertical_panel_system;
	candidate_panel_set_vertical (self, !_tmp5_);
	result = TRUE;
	return result;
}


static gboolean ___lambda13__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda13_ ((CandidatePanel*) self, _sender, event);
	return result;
}


static void __lambda14_ (CandidatePanel* self, GtkWidget* w, GtkAllocation* a) {
	g_return_if_fail (w != NULL);
	g_return_if_fail (a != NULL);
	candidate_panel_adjust_window_position (self);
}


static void ___lambda14__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda14_ ((CandidatePanel*) self, _sender, allocation);
}


CandidatePanel* candidate_panel_construct (GType object_type) {
	CandidatePanel * self = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	Handle* handle = NULL;
	Handle* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkWindow* _tmp8_;
	self = (CandidatePanel*) g_object_new (object_type, "name", "IBusCandidate", "orientation", GTK_ORIENTATION_HORIZONTAL, "visible", TRUE, NULL);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_toplevel);
	self->priv->m_toplevel = _tmp0_;
	_tmp1_ = self->priv->m_toplevel;
	gtk_widget_add_events ((GtkWidget*) _tmp1_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp2_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp2_, "button-press-event", (GCallback) ___lambda13__gtk_widget_button_press_event, self, 0);
	_tmp3_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp3_, "size-allocate", (GCallback) ___lambda14__gtk_widget_size_allocate, self, 0);
	_tmp4_ = handle_new ();
	g_object_ref_sink (_tmp4_);
	handle = _tmp4_;
	gtk_widget_set_visible ((GtkWidget*) handle, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) handle, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_vbox);
	self->priv->m_vbox = _tmp5_;
	_tmp6_ = self->priv->m_vbox;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = self->priv->m_vbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
	_tmp8_ = self->priv->m_toplevel;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) self);
	candidate_panel_create_ui (self);
	_g_object_unref0 (handle);
	return self;
}


CandidatePanel* candidate_panel_new (void) {
	return candidate_panel_construct (TYPE_CANDIDATE_PANEL);
}


void candidate_panel_set_vertical (CandidatePanel* self, gboolean vertical) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	CandidateArea* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_vertical_panel_system;
	_tmp1_ = vertical;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = vertical;
	self->priv->m_vertical_panel_system = _tmp2_;
	_tmp3_ = self->priv->m_candidate_area;
	_tmp4_ = vertical;
	candidate_area_set_vertical (_tmp3_, _tmp4_, FALSE);
}


static void candidate_panel_set_orientation (CandidatePanel* self, IBusOrientation orientation) {
	IBusOrientation _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = orientation;
	switch (_tmp0_) {
		case IBUS_ORIENTATION_VERTICAL:
		{
			CandidateArea* _tmp1_;
			_tmp1_ = self->priv->m_candidate_area;
			candidate_area_set_vertical (_tmp1_, TRUE, FALSE);
			break;
		}
		case IBUS_ORIENTATION_HORIZONTAL:
		{
			CandidateArea* _tmp2_;
			_tmp2_ = self->priv->m_candidate_area;
			candidate_area_set_vertical (_tmp2_, FALSE, FALSE);
			break;
		}
		case IBUS_ORIENTATION_SYSTEM:
		{
			CandidateArea* _tmp3_;
			gboolean _tmp4_;
			_tmp3_ = self->priv->m_candidate_area;
			_tmp4_ = self->priv->m_vertical_panel_system;
			candidate_area_set_vertical (_tmp3_, _tmp4_, FALSE);
			break;
		}
		default:
		break;
	}
}


static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1, const cairo_rectangle_int_t * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}


void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height) {
	GdkRectangle location = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = width;
	_tmp3_ = height;
	memset (&_tmp4_, 0, sizeof (GdkRectangle));
	_tmp4_.x = _tmp0_;
	_tmp4_.y = _tmp1_;
	_tmp4_.width = _tmp2_;
	_tmp4_.height = _tmp3_;
	location = _tmp4_;
	_tmp5_ = self->priv->m_cursor_location;
	_tmp6_ = location;
	if (_cairo_rectangle_int_equal (&_tmp5_, &_tmp6_) == TRUE) {
		return;
	}
	_tmp7_ = location;
	self->priv->m_cursor_location = _tmp7_;
}


static void candidate_panel_set_labels (CandidatePanel* self, IBusText** labels, int labels_length1) {
	CandidateArea* _tmp0_;
	IBusText** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_candidate_area;
	_tmp1_ = labels;
	_tmp1__length1 = labels_length1;
	candidate_area_set_labels (_tmp0_, _tmp1_, _tmp1__length1);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void candidate_panel_set_attributes (CandidatePanel* self, GtkLabel* label, IBusText* text) {
	PangoAttrList* attrs = NULL;
	IBusText* _tmp0_;
	PangoAttrList* _tmp1_;
	GtkStyleContext* context = NULL;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GdkRGBA color = {0};
	GtkStyleContext* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	gboolean _tmp7_;
	GtkLabel* _tmp23_;
	PangoAttrList* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = get_pango_attr_list_from_ibus_text (_tmp0_);
	attrs = _tmp1_;
	_tmp2_ = label;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	context = _tmp4_;
	_tmp5_ = context;
	_tmp7_ = gtk_style_context_lookup_color (_tmp5_, "placeholder_text_color", &_tmp6_);
	color = _tmp6_;
	if (_tmp7_) {
		PangoAttribute* pango_attr = NULL;
		GdkRGBA _tmp8_;
		gdouble _tmp9_;
		GdkRGBA _tmp10_;
		gdouble _tmp11_;
		GdkRGBA _tmp12_;
		gdouble _tmp13_;
		PangoAttribute* _tmp14_;
		PangoAttribute* _tmp15_;
		PangoAttribute* _tmp16_;
		GtkLabel* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		PangoAttrList* _tmp21_;
		PangoAttribute* _tmp22_;
		_tmp8_ = color;
		_tmp9_ = _tmp8_.red;
		_tmp10_ = color;
		_tmp11_ = _tmp10_.green;
		_tmp12_ = color;
		_tmp13_ = _tmp12_.blue;
		_tmp14_ = pango_attr_foreground_new ((guint16) (_tmp9_ * G_MAXUINT16), (guint16) (_tmp11_ * G_MAXUINT16), (guint16) (_tmp13_ * G_MAXUINT16));
		pango_attr = _tmp14_;
		_tmp15_ = pango_attr;
		_tmp15_->start_index = (guint) 0;
		_tmp16_ = pango_attr;
		_tmp17_ = label;
		_tmp18_ = gtk_label_get_text (_tmp17_);
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_->end_index = (guint) _tmp20_;
		_tmp21_ = attrs;
		_tmp22_ = pango_attr;
		pango_attr = NULL;
		pango_attr_list_insert (_tmp21_, _tmp22_);
		_pango_attribute_destroy0 (pango_attr);
	}
	_tmp23_ = label;
	_tmp24_ = attrs;
	gtk_label_set_attributes (_tmp23_, _tmp24_);
	_g_object_unref0 (context);
	_pango_attr_list_unref0 (attrs);
}


void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor) {
	IBusText* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = text;
	if (_tmp0_ != NULL) {
		gchar* str = NULL;
		IBusText* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp1_ = text;
		_tmp2_ = ibus_text_get_text (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		str = _tmp3_;
		_tmp4_ = str;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ > 0) {
			GtkLabel* _tmp7_;
			const gchar* _tmp8_;
			GtkLabel* _tmp9_;
			GtkLabel* _tmp10_;
			IBusText* _tmp11_;
			_tmp7_ = self->priv->m_preedit_label;
			_tmp8_ = str;
			gtk_label_set_text (_tmp7_, _tmp8_);
			_tmp9_ = self->priv->m_preedit_label;
			gtk_widget_show ((GtkWidget*) _tmp9_);
			_tmp10_ = self->priv->m_preedit_label;
			_tmp11_ = text;
			candidate_panel_set_attributes (self, _tmp10_, _tmp11_);
		} else {
			GtkLabel* _tmp12_;
			GtkLabel* _tmp13_;
			_tmp12_ = self->priv->m_preedit_label;
			gtk_label_set_text (_tmp12_, "");
			_tmp13_ = self->priv->m_preedit_label;
			gtk_widget_hide ((GtkWidget*) _tmp13_);
		}
		_g_free0 (str);
	} else {
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		_tmp14_ = self->priv->m_preedit_label;
		gtk_label_set_text (_tmp14_, "");
		_tmp15_ = self->priv->m_preedit_label;
		gtk_widget_hide ((GtkWidget*) _tmp15_);
	}
	candidate_panel_update (self);
}


void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text) {
	IBusText* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = text;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_;
		IBusText* _tmp2_;
		const gchar* _tmp3_;
		GtkLabel* _tmp4_;
		_tmp1_ = self->priv->m_aux_label;
		_tmp2_ = text;
		_tmp3_ = ibus_text_get_text (_tmp2_);
		gtk_label_set_text (_tmp1_, _tmp3_);
		_tmp4_ = self->priv->m_aux_label;
		gtk_widget_show ((GtkWidget*) _tmp4_);
	} else {
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		_tmp5_ = self->priv->m_aux_label;
		gtk_label_set_text (_tmp5_, "");
		_tmp6_ = self->priv->m_aux_label;
		gtk_widget_hide ((GtkWidget*) _tmp6_);
	}
	candidate_panel_update (self);
}


static void _vala_array_add8 (IBusText** * array, int* length, int* size, IBusText* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusText*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (IBusText** * array, int* length, int* size, IBusText* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusText*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table) {
	IBusText** candidates = NULL;
	IBusText** _tmp0_;
	gint candidates_length1;
	gint _candidates_size_;
	guint cursor_in_page = 0U;
	gboolean show_cursor = FALSE;
	IBusText** labels = NULL;
	IBusText** _tmp1_;
	gint labels_length1;
	gint _labels_size_;
	IBusOrientation orientation = 0;
	IBusLookupTable* _tmp2_;
	CandidateArea* _tmp44_;
	IBusText** _tmp45_;
	gint _tmp45__length1;
	guint _tmp46_;
	gboolean _tmp47_;
	IBusText** _tmp48_;
	gint _tmp48__length1;
	IBusLookupTable* _tmp49_;
	IBusText** _tmp51_;
	gint _tmp51__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (IBusText*, 0 + 1);
	candidates = _tmp0_;
	candidates_length1 = 0;
	_candidates_size_ = candidates_length1;
	cursor_in_page = (guint) 0;
	show_cursor = TRUE;
	_tmp1_ = g_new0 (IBusText*, 0 + 1);
	labels = _tmp1_;
	labels_length1 = 0;
	_labels_size_ = labels_length1;
	orientation = IBUS_ORIENTATION_SYSTEM;
	_tmp2_ = table;
	if (_tmp2_ != NULL) {
		guint page_size = 0U;
		IBusLookupTable* _tmp3_;
		guint _tmp4_;
		guint ncandidates = 0U;
		IBusLookupTable* _tmp5_;
		guint _tmp6_;
		guint cursor = 0U;
		IBusLookupTable* _tmp7_;
		guint _tmp8_;
		IBusLookupTable* _tmp9_;
		guint _tmp10_;
		IBusLookupTable* _tmp11_;
		gboolean _tmp12_;
		guint page_start_pos = 0U;
		guint _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		guint page_end_pos = 0U;
		guint _tmp16_;
		guint _tmp17_;
		guint _tmp18_;
		guint _tmp19_;
		IBusLookupTable* _tmp42_;
		gint _tmp43_;
		_tmp3_ = table;
		_tmp4_ = ibus_lookup_table_get_page_size (_tmp3_);
		page_size = _tmp4_;
		_tmp5_ = table;
		_tmp6_ = ibus_lookup_table_get_number_of_candidates (_tmp5_);
		ncandidates = _tmp6_;
		_tmp7_ = table;
		_tmp8_ = ibus_lookup_table_get_cursor_pos (_tmp7_);
		cursor = _tmp8_;
		_tmp9_ = table;
		_tmp10_ = ibus_lookup_table_get_cursor_in_page (_tmp9_);
		cursor_in_page = _tmp10_;
		_tmp11_ = table;
		_tmp12_ = ibus_lookup_table_is_cursor_visible (_tmp11_);
		show_cursor = _tmp12_;
		_tmp13_ = cursor;
		_tmp14_ = page_size;
		_tmp15_ = page_size;
		page_start_pos = (_tmp13_ / _tmp14_) * _tmp15_;
		_tmp16_ = page_start_pos;
		_tmp17_ = page_size;
		_tmp18_ = ncandidates;
		_tmp19_ = MIN (_tmp16_ + _tmp17_, _tmp18_);
		page_end_pos = _tmp19_;
		{
			guint i = 0U;
			guint _tmp20_;
			_tmp20_ = page_start_pos;
			i = _tmp20_;
			{
				gboolean _tmp21_ = FALSE;
				_tmp21_ = TRUE;
				while (TRUE) {
					guint _tmp23_;
					guint _tmp24_;
					IBusText** _tmp25_;
					gint _tmp25__length1;
					IBusLookupTable* _tmp26_;
					guint _tmp27_;
					IBusText* _tmp28_;
					IBusText* _tmp29_;
					if (!_tmp21_) {
						guint _tmp22_;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp21_ = FALSE;
					_tmp23_ = i;
					_tmp24_ = page_end_pos;
					if (!(_tmp23_ < _tmp24_)) {
						break;
					}
					_tmp25_ = candidates;
					_tmp25__length1 = candidates_length1;
					_tmp26_ = table;
					_tmp27_ = i;
					_tmp28_ = ibus_lookup_table_get_candidate (_tmp26_, _tmp27_);
					_tmp29_ = _g_object_ref0 (_tmp28_);
					_vala_array_add8 (&candidates, &candidates_length1, &_candidates_size_, _tmp29_);
				}
			}
		}
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp30_ = FALSE;
				_tmp30_ = TRUE;
				while (TRUE) {
					guint _tmp32_;
					guint _tmp33_;
					IBusText* label = NULL;
					IBusLookupTable* _tmp34_;
					guint _tmp35_;
					IBusText* _tmp36_;
					IBusText* _tmp37_;
					IBusText* _tmp38_;
					if (!_tmp30_) {
						guint _tmp31_;
						_tmp31_ = i;
						i = _tmp31_ + 1;
					}
					_tmp30_ = FALSE;
					_tmp32_ = i;
					_tmp33_ = page_size;
					if (!(_tmp32_ < _tmp33_)) {
						break;
					}
					_tmp34_ = table;
					_tmp35_ = i;
					_tmp36_ = ibus_lookup_table_get_label (_tmp34_, _tmp35_);
					_tmp37_ = _g_object_ref0 (_tmp36_);
					label = _tmp37_;
					_tmp38_ = label;
					if (_tmp38_ != NULL) {
						IBusText** _tmp39_;
						gint _tmp39__length1;
						IBusText* _tmp40_;
						IBusText* _tmp41_;
						_tmp39_ = labels;
						_tmp39__length1 = labels_length1;
						_tmp40_ = label;
						_tmp41_ = _g_object_ref0 (_tmp40_);
						_vala_array_add9 (&labels, &labels_length1, &_labels_size_, _tmp41_);
					}
					_g_object_unref0 (label);
				}
			}
		}
		_tmp42_ = table;
		_tmp43_ = ibus_lookup_table_get_orientation (_tmp42_);
		orientation = (IBusOrientation) _tmp43_;
	}
	_tmp44_ = self->priv->m_candidate_area;
	_tmp45_ = candidates;
	_tmp45__length1 = candidates_length1;
	_tmp46_ = cursor_in_page;
	_tmp47_ = show_cursor;
	candidate_area_set_candidates (_tmp44_, _tmp45_, _tmp45__length1, _tmp46_, _tmp47_);
	_tmp48_ = labels;
	_tmp48__length1 = labels_length1;
	candidate_panel_set_labels (self, _tmp48_, _tmp48__length1);
	_tmp49_ = table;
	if (_tmp49_ != NULL) {
		IBusOrientation _tmp50_;
		_tmp50_ = orientation;
		candidate_panel_set_orientation (self, _tmp50_);
	}
	_tmp51_ = candidates;
	_tmp51__length1 = candidates_length1;
	if (_tmp51__length1 != 0) {
		CandidateArea* _tmp52_;
		_tmp52_ = self->priv->m_candidate_area;
		gtk_widget_show_all ((GtkWidget*) _tmp52_);
	} else {
		CandidateArea* _tmp53_;
		_tmp53_ = self->priv->m_candidate_area;
		gtk_widget_hide ((GtkWidget*) _tmp53_);
	}
	candidate_panel_update (self);
	labels = (_vala_array_free (labels, labels_length1, (GDestroyNotify) g_object_unref), NULL);
	candidates = (_vala_array_free (candidates, candidates_length1, (GDestroyNotify) g_object_unref), NULL);
}


void candidate_panel_set_content_type (CandidatePanel* self, guint purpose, guint hints) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = hints;
	self->priv->m_vertical_writing = (_tmp0_ & IBUS_INPUT_HINT_VERTICAL_WRITING) != ((guint) 0);
}


static void candidate_panel_update (CandidatePanel* self) {
	GtkWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	CandidateArea* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp11_ = FALSE;
	GtkLabel* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp0_, 1, 1);
	_tmp3_ = self->priv->m_candidate_area;
	_tmp4_ = gtk_widget_get_visible ((GtkWidget*) _tmp3_);
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		GtkLabel* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = self->priv->m_preedit_label;
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GtkLabel* _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = self->priv->m_aux_label;
		_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		GtkWindow* _tmp9_;
		_tmp9_ = self->priv->m_toplevel;
		gtk_widget_show ((GtkWidget*) _tmp9_);
	} else {
		GtkWindow* _tmp10_;
		_tmp10_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp10_);
	}
	_tmp12_ = self->priv->m_aux_label;
	_tmp13_ = gtk_widget_get_visible ((GtkWidget*) _tmp12_);
	if (_tmp13_) {
		gboolean _tmp14_ = FALSE;
		CandidateArea* _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = self->priv->m_candidate_area;
		_tmp16_ = gtk_widget_get_visible ((GtkWidget*) _tmp15_);
		if (_tmp16_) {
			_tmp14_ = TRUE;
		} else {
			GtkLabel* _tmp17_;
			gboolean _tmp18_;
			_tmp17_ = self->priv->m_preedit_label;
			_tmp18_ = gtk_widget_get_visible ((GtkWidget*) _tmp17_);
			_tmp14_ = _tmp18_;
		}
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		HSeparator* _tmp19_;
		_tmp19_ = self->priv->m_hseparator;
		gtk_widget_show ((GtkWidget*) _tmp19_);
	} else {
		HSeparator* _tmp20_;
		_tmp20_ = self->priv->m_hseparator;
		gtk_widget_hide ((GtkWidget*) _tmp20_);
	}
}


static void __lambda15_ (CandidatePanel* self, CandidateArea* w, guint i, guint b, guint s) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (w != NULL);
	_tmp0_ = i;
	_tmp1_ = b;
	_tmp2_ = s;
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_CANDIDATE_CLICKED_SIGNAL], 0, _tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda15__candidate_area_candidate_clicked (CandidateArea* _sender, guint index, guint button, guint state, gpointer self) {
	__lambda15_ ((CandidatePanel*) self, _sender, index, button, state);
}


static void __lambda16_ (CandidatePanel* self, CandidateArea* c) {
	g_return_if_fail (c != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_PAGE_UP_SIGNAL], 0);
}


static void ___lambda16__candidate_area_page_up (CandidateArea* _sender, gpointer self) {
	__lambda16_ ((CandidatePanel*) self, _sender);
}


static void __lambda17_ (CandidatePanel* self, CandidateArea* c) {
	g_return_if_fail (c != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_PAGE_DOWN_SIGNAL], 0);
}


static void ___lambda17__candidate_area_page_down (CandidateArea* _sender, gpointer self) {
	__lambda17_ ((CandidatePanel*) self, _sender);
}


static void __lambda18_ (CandidatePanel* self, CandidateArea* c) {
	g_return_if_fail (c != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_CURSOR_UP_SIGNAL], 0);
}


static void ___lambda18__candidate_area_cursor_up (CandidateArea* _sender, gpointer self) {
	__lambda18_ ((CandidatePanel*) self, _sender);
}


static void __lambda19_ (CandidatePanel* self, CandidateArea* c) {
	g_return_if_fail (c != NULL);
	g_signal_emit (self, candidate_panel_signals[CANDIDATE_PANEL_CURSOR_DOWN_SIGNAL], 0);
}


static void ___lambda19__candidate_area_cursor_down (CandidateArea* _sender, gpointer self) {
	__lambda19_ ((CandidatePanel*) self, _sender);
}


static void candidate_panel_create_ui (CandidatePanel* self) {
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	gboolean _tmp12_;
	CandidateArea* _tmp13_;
	CandidateArea* _tmp14_;
	CandidateArea* _tmp15_;
	CandidateArea* _tmp16_;
	CandidateArea* _tmp17_;
	CandidateArea* _tmp18_;
	HSeparator* _tmp19_;
	HSeparator* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_preedit_label);
	self->priv->m_preedit_label = _tmp0_;
	_tmp1_ = self->priv->m_preedit_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp1_, 20, -1);
	_tmp2_ = self->priv->m_preedit_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
	_tmp3_ = self->priv->m_preedit_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = self->priv->m_preedit_label;
	gtk_misc_set_padding ((GtkMisc*) _tmp4_, 8, 0);
	_tmp5_ = self->priv->m_preedit_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->m_aux_label);
	self->priv->m_aux_label = _tmp6_;
	_tmp7_ = self->priv->m_aux_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp7_, 20, -1);
	_tmp8_ = self->priv->m_aux_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	_tmp9_ = self->priv->m_aux_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
	_tmp10_ = self->priv->m_aux_label;
	gtk_misc_set_padding ((GtkMisc*) _tmp10_, 8, 0);
	_tmp11_ = self->priv->m_aux_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = self->priv->m_vertical_panel_system;
	_tmp13_ = candidate_area_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->m_candidate_area);
	self->priv->m_candidate_area = _tmp13_;
	_tmp14_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp14_, "candidate-clicked", (GCallback) ___lambda15__candidate_area_candidate_clicked, self, 0);
	_tmp15_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp15_, "page-up", (GCallback) ___lambda16__candidate_area_page_up, self, 0);
	_tmp16_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp16_, "page-down", (GCallback) ___lambda17__candidate_area_page_down, self, 0);
	_tmp17_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp17_, "cursor-up", (GCallback) ___lambda18__candidate_area_cursor_up, self, 0);
	_tmp18_ = self->priv->m_candidate_area;
	g_signal_connect_object (_tmp18_, "cursor-down", (GCallback) ___lambda19__candidate_area_cursor_down, self, 0);
	_tmp19_ = hseparator_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->m_hseparator);
	self->priv->m_hseparator = _tmp19_;
	_tmp20_ = self->priv->m_hseparator;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, TRUE);
	candidate_panel_pack_all_widgets (self);
}


static void candidate_panel_pack_all_widgets (CandidatePanel* self) {
	GtkBox* _tmp0_;
	GtkLabel* _tmp1_;
	GtkBox* _tmp2_;
	GtkLabel* _tmp3_;
	GtkBox* _tmp4_;
	HSeparator* _tmp5_;
	GtkBox* _tmp6_;
	CandidateArea* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_vbox;
	_tmp1_ = self->priv->m_preedit_label;
	gtk_box_pack_start (_tmp0_, (GtkWidget*) _tmp1_, FALSE, FALSE, (guint) 4);
	_tmp2_ = self->priv->m_vbox;
	_tmp3_ = self->priv->m_aux_label;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 4);
	_tmp4_ = self->priv->m_vbox;
	_tmp5_ = self->priv->m_hseparator;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = self->priv->m_vbox;
	_tmp7_ = self->priv->m_candidate_area;
	gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
}


void candidate_panel_show (CandidatePanel* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
}


void candidate_panel_hide (CandidatePanel* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void candidate_panel_move (CandidatePanel* self, gint x, gint y) {
	GtkWindow* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	_tmp1_ = x;
	_tmp2_ = y;
	gtk_window_move (_tmp0_, _tmp1_, _tmp2_);
}


static void candidate_panel_adjust_window_position (CandidatePanel* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_vertical_writing;
	if (!_tmp0_) {
		candidate_panel_adjust_window_position_horizontal (self);
	} else {
		candidate_panel_adjust_window_position_vertical (self);
	}
}


static void candidate_panel_get_monitor_geometry (CandidatePanel* self, GdkRectangle* result) {
	GdkRectangle monitor_area = {0};
	GdkRectangle _tmp0_ = {0};
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkMonitor* _tmp6_;
	GdkMonitor* _tmp7_;
	GdkRectangle _tmp8_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_.x = 0;
	monitor_area = _tmp0_;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = _tmp2_.x;
	_tmp4_ = self->priv->m_cursor_location;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = gdk_display_get_monitor_at_point (_tmp1_, _tmp3_, _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	monitor = _tmp7_;
	gdk_monitor_get_geometry (monitor, &_tmp8_);
	monitor_area = _tmp8_;
	*result = monitor_area;
	_g_object_unref0 (monitor);
	return;
}


static void candidate_panel_adjust_window_position_horizontal (CandidatePanel* self) {
	GdkPoint cursor_right_bottom = {0};
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	GdkPoint _tmp8_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp9_;
	GtkAllocation _tmp10_ = {0};
	GdkPoint window_right_bottom = {0};
	GdkPoint _tmp11_;
	gint _tmp12_;
	GtkAllocation _tmp13_;
	gint _tmp14_;
	GdkPoint _tmp15_;
	gint _tmp16_;
	GtkAllocation _tmp17_;
	gint _tmp18_;
	GdkPoint _tmp19_ = {0};
	GdkRectangle monitor_area = {0};
	GdkRectangle _tmp20_ = {0};
	gint monitor_right = 0;
	GdkRectangle _tmp21_;
	gint _tmp22_;
	GdkRectangle _tmp23_;
	gint _tmp24_;
	gint monitor_bottom = 0;
	GdkRectangle _tmp25_;
	gint _tmp26_;
	GdkRectangle _tmp27_;
	gint _tmp28_;
	gint x = 0;
	gint y = 0;
	GdkPoint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp37_;
	GdkPoint _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = _tmp0_.x;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = _tmp2_.width;
	_tmp4_ = self->priv->m_cursor_location;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = self->priv->m_cursor_location;
	_tmp7_ = _tmp6_.height;
	_tmp8_.x = _tmp1_ + _tmp3_;
	_tmp8_.y = _tmp5_ + _tmp7_;
	cursor_right_bottom = _tmp8_;
	_tmp9_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp9_, &_tmp10_);
	allocation = _tmp10_;
	_tmp11_ = cursor_right_bottom;
	_tmp12_ = _tmp11_.x;
	_tmp13_ = allocation;
	_tmp14_ = _tmp13_.width;
	_tmp15_ = cursor_right_bottom;
	_tmp16_ = _tmp15_.y;
	_tmp17_ = allocation;
	_tmp18_ = _tmp17_.height;
	_tmp19_.x = _tmp12_ + _tmp14_;
	_tmp19_.y = _tmp16_ + _tmp18_;
	window_right_bottom = _tmp19_;
	candidate_panel_get_monitor_geometry (self, &_tmp20_);
	monitor_area = _tmp20_;
	_tmp21_ = monitor_area;
	_tmp22_ = _tmp21_.x;
	_tmp23_ = monitor_area;
	_tmp24_ = _tmp23_.width;
	monitor_right = _tmp22_ + _tmp24_;
	_tmp25_ = monitor_area;
	_tmp26_ = _tmp25_.y;
	_tmp27_ = monitor_area;
	_tmp28_ = _tmp27_.height;
	monitor_bottom = _tmp26_ + _tmp28_;
	_tmp29_ = window_right_bottom;
	_tmp30_ = _tmp29_.x;
	_tmp31_ = monitor_right;
	if (_tmp30_ > _tmp31_) {
		gint _tmp32_;
		GtkAllocation _tmp33_;
		gint _tmp34_;
		_tmp32_ = monitor_right;
		_tmp33_ = allocation;
		_tmp34_ = _tmp33_.width;
		x = _tmp32_ - _tmp34_;
	} else {
		GdkPoint _tmp35_;
		gint _tmp36_;
		_tmp35_ = cursor_right_bottom;
		_tmp36_ = _tmp35_.x;
		x = _tmp36_;
	}
	_tmp37_ = x;
	if (_tmp37_ < 0) {
		x = 0;
	}
	_tmp38_ = window_right_bottom;
	_tmp39_ = _tmp38_.y;
	_tmp40_ = monitor_bottom;
	if (_tmp39_ > _tmp40_) {
		GdkRectangle _tmp41_;
		gint _tmp42_;
		GtkAllocation _tmp43_;
		gint _tmp44_;
		_tmp41_ = self->priv->m_cursor_location;
		_tmp42_ = _tmp41_.y;
		_tmp43_ = allocation;
		_tmp44_ = _tmp43_.height;
		y = _tmp42_ - _tmp44_;
	} else {
		GdkPoint _tmp45_;
		gint _tmp46_;
		_tmp45_ = cursor_right_bottom;
		_tmp46_ = _tmp45_.y;
		y = _tmp46_;
	}
	_tmp47_ = y;
	if (_tmp47_ < 0) {
		y = 0;
	}
	_tmp48_ = x;
	_tmp49_ = y;
	candidate_panel_move (self, _tmp48_, _tmp49_);
}


static void candidate_panel_adjust_window_position_vertical (CandidatePanel* self) {
	gint char_size = 0;
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GdkPoint cursor_right_bottom = {0};
	GdkRectangle _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GdkRectangle _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GdkPoint _tmp11_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp12_;
	GtkAllocation _tmp13_ = {0};
	GdkPoint hwindow_right_bottom = {0};
	GdkRectangle _tmp14_;
	gint _tmp15_;
	GtkAllocation _tmp16_;
	gint _tmp17_;
	GdkPoint _tmp18_;
	gint _tmp19_;
	GtkAllocation _tmp20_;
	gint _tmp21_;
	GdkPoint _tmp22_ = {0};
	GdkPoint vwindow_left_bottom = {0};
	GdkRectangle _tmp23_;
	gint _tmp24_;
	GtkAllocation _tmp25_;
	gint _tmp26_;
	GdkRectangle _tmp27_;
	gint _tmp28_;
	GtkAllocation _tmp29_;
	gint _tmp30_;
	GdkPoint _tmp31_ = {0};
	GdkRectangle monitor_area = {0};
	GdkRectangle _tmp32_ = {0};
	gint monitor_right = 0;
	GdkRectangle _tmp33_;
	gint _tmp34_;
	GdkRectangle _tmp35_;
	gint _tmp36_;
	gint monitor_bottom = 0;
	GdkRectangle _tmp37_;
	gint _tmp38_;
	GdkRectangle _tmp39_;
	gint _tmp40_;
	gint x = 0;
	gint y = 0;
	CandidateArea* _tmp41_;
	gboolean _tmp42_;
	gint _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	gint _tmp83_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = _tmp0_.width;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = _tmp2_.height;
	_tmp4_ = MAX (_tmp1_, _tmp3_);
	char_size = _tmp4_;
	_tmp5_ = self->priv->m_cursor_location;
	_tmp6_ = _tmp5_.x;
	_tmp7_ = char_size;
	_tmp8_ = self->priv->m_cursor_location;
	_tmp9_ = _tmp8_.y;
	_tmp10_ = char_size;
	_tmp11_.x = _tmp6_ + _tmp7_;
	_tmp11_.y = _tmp9_ + _tmp10_;
	cursor_right_bottom = _tmp11_;
	_tmp12_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp12_, &_tmp13_);
	allocation = _tmp13_;
	_tmp14_ = self->priv->m_cursor_location;
	_tmp15_ = _tmp14_.x;
	_tmp16_ = allocation;
	_tmp17_ = _tmp16_.width;
	_tmp18_ = cursor_right_bottom;
	_tmp19_ = _tmp18_.y;
	_tmp20_ = allocation;
	_tmp21_ = _tmp20_.height;
	_tmp22_.x = _tmp15_ + _tmp17_;
	_tmp22_.y = _tmp19_ + _tmp21_;
	hwindow_right_bottom = _tmp22_;
	_tmp23_ = self->priv->m_cursor_location;
	_tmp24_ = _tmp23_.x;
	_tmp25_ = allocation;
	_tmp26_ = _tmp25_.width;
	_tmp27_ = self->priv->m_cursor_location;
	_tmp28_ = _tmp27_.y;
	_tmp29_ = allocation;
	_tmp30_ = _tmp29_.height;
	_tmp31_.x = _tmp24_ - _tmp26_;
	_tmp31_.y = _tmp28_ + _tmp30_;
	vwindow_left_bottom = _tmp31_;
	candidate_panel_get_monitor_geometry (self, &_tmp32_);
	monitor_area = _tmp32_;
	_tmp33_ = monitor_area;
	_tmp34_ = _tmp33_.x;
	_tmp35_ = monitor_area;
	_tmp36_ = _tmp35_.width;
	monitor_right = _tmp34_ + _tmp36_;
	_tmp37_ = monitor_area;
	_tmp38_ = _tmp37_.y;
	_tmp39_ = monitor_area;
	_tmp40_ = _tmp39_.height;
	monitor_bottom = _tmp38_ + _tmp40_;
	_tmp41_ = self->priv->m_candidate_area;
	_tmp42_ = candidate_area_get_vertical (_tmp41_);
	if (!_tmp42_) {
		GdkPoint _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		GdkPoint _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		_tmp43_ = hwindow_right_bottom;
		_tmp44_ = _tmp43_.x;
		_tmp45_ = monitor_right;
		if (_tmp44_ > _tmp45_) {
			gint _tmp46_;
			GtkAllocation _tmp47_;
			gint _tmp48_;
			_tmp46_ = monitor_right;
			_tmp47_ = allocation;
			_tmp48_ = _tmp47_.width;
			x = _tmp46_ - _tmp48_;
		} else {
			GdkRectangle _tmp49_;
			gint _tmp50_;
			_tmp49_ = self->priv->m_cursor_location;
			_tmp50_ = _tmp49_.x;
			x = _tmp50_;
		}
		_tmp51_ = hwindow_right_bottom;
		_tmp52_ = _tmp51_.y;
		_tmp53_ = monitor_bottom;
		if (_tmp52_ > _tmp53_) {
			GdkRectangle _tmp54_;
			gint _tmp55_;
			GtkAllocation _tmp56_;
			gint _tmp57_;
			_tmp54_ = self->priv->m_cursor_location;
			_tmp55_ = _tmp54_.y;
			_tmp56_ = allocation;
			_tmp57_ = _tmp56_.height;
			y = _tmp55_ - _tmp57_;
		} else {
			GdkPoint _tmp58_;
			gint _tmp59_;
			_tmp58_ = cursor_right_bottom;
			_tmp59_ = _tmp58_.y;
			y = _tmp59_;
		}
	} else {
		GdkPoint _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		GdkPoint _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		_tmp60_ = vwindow_left_bottom;
		_tmp61_ = _tmp60_.x;
		_tmp62_ = monitor_right;
		if (_tmp61_ > _tmp62_) {
			gint _tmp63_;
			GtkAllocation _tmp64_;
			gint _tmp65_;
			_tmp63_ = monitor_right;
			_tmp64_ = allocation;
			_tmp65_ = _tmp64_.width;
			x = _tmp63_ - _tmp65_;
		} else {
			GdkPoint _tmp66_;
			gint _tmp67_;
			_tmp66_ = vwindow_left_bottom;
			_tmp67_ = _tmp66_.x;
			if (_tmp67_ < 0) {
				GdkPoint _tmp68_;
				gint _tmp69_;
				_tmp68_ = cursor_right_bottom;
				_tmp69_ = _tmp68_.x;
				x = _tmp69_;
			} else {
				GdkPoint _tmp70_;
				gint _tmp71_;
				_tmp70_ = vwindow_left_bottom;
				_tmp71_ = _tmp70_.x;
				x = _tmp71_;
			}
		}
		_tmp72_ = vwindow_left_bottom;
		_tmp73_ = _tmp72_.y;
		_tmp74_ = monitor_bottom;
		if (_tmp73_ > _tmp74_) {
			gint _tmp75_;
			GtkAllocation _tmp76_;
			gint _tmp77_;
			_tmp75_ = monitor_bottom;
			_tmp76_ = allocation;
			_tmp77_ = _tmp76_.height;
			y = _tmp75_ - _tmp77_;
		} else {
			GdkRectangle _tmp78_;
			gint _tmp79_;
			_tmp78_ = self->priv->m_cursor_location;
			_tmp79_ = _tmp78_.y;
			y = _tmp79_;
		}
	}
	_tmp80_ = x;
	if (_tmp80_ < 0) {
		x = 0;
	}
	_tmp81_ = y;
	if (_tmp81_ < 0) {
		y = 0;
	}
	_tmp82_ = x;
	_tmp83_ = y;
	candidate_panel_move (self, _tmp82_, _tmp83_);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void candidate_panel_class_init (CandidatePanelClass * klass) {
	candidate_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CandidatePanelPrivate));
	G_OBJECT_CLASS (klass)->finalize = candidate_panel_finalize;
	candidate_panel_signals[CANDIDATE_PANEL_CURSOR_UP_SIGNAL] = g_signal_new ("cursor-up", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_panel_signals[CANDIDATE_PANEL_CURSOR_DOWN_SIGNAL] = g_signal_new ("cursor-down", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_panel_signals[CANDIDATE_PANEL_PAGE_UP_SIGNAL] = g_signal_new ("page-up", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_panel_signals[CANDIDATE_PANEL_PAGE_DOWN_SIGNAL] = g_signal_new ("page-down", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	candidate_panel_signals[CANDIDATE_PANEL_CANDIDATE_CLICKED_SIGNAL] = g_signal_new ("candidate-clicked", TYPE_CANDIDATE_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
}


static void candidate_panel_instance_init (CandidatePanel * self) {
	self->priv = CANDIDATE_PANEL_GET_PRIVATE (self);
	self->priv->m_vertical_panel_system = TRUE;
}


static void candidate_panel_finalize (GObject * obj) {
	CandidatePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANDIDATE_PANEL, CandidatePanel);
	_g_object_unref0 (self->priv->m_toplevel);
	_g_object_unref0 (self->priv->m_vbox);
	_g_object_unref0 (self->priv->m_preedit_label);
	_g_object_unref0 (self->priv->m_aux_label);
	_g_object_unref0 (self->priv->m_candidate_area);
	_g_object_unref0 (self->priv->m_hseparator);
	G_OBJECT_CLASS (candidate_panel_parent_class)->finalize (obj);
}


GType candidate_panel_get_type (void) {
	static volatile gsize candidate_panel_type_id__volatile = 0;
	if (g_once_init_enter (&candidate_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CandidatePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) candidate_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CandidatePanel), 0, (GInstanceInitFunc) candidate_panel_instance_init, NULL };
		GType candidate_panel_type_id;
		candidate_panel_type_id = g_type_register_static (gtk_box_get_type (), "CandidatePanel", &g_define_type_info, 0);
		g_once_init_leave (&candidate_panel_type_id__volatile, candidate_panel_type_id);
	}
	return candidate_panel_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



