SET(CMAKE_ALLOW_LOOSE_LOOP_CONSTRUCTS ON)
SET(CTEST_SOURCE_DIRECTORY "${CTEST_SCRIPT_DIRECTORY}/..")
SET(CTEST_BINARY_DIRECTORY "${CTEST_SOURCE_DIRECTORY}")
#SET(CTEST_COMMAND "${CTEST_EXECUTABLE_NAME}")
IF(NOT DEFINED CTEST_COMMAND)
    SET(CTEST_COMMAND "echo 'Tests passed'")
ENDIF(NOT DEFINED CTEST_COMMAND)

SET(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} Modules test
    ${CTEST_SOURCE_DIRECTORY}/Modules ${CTEST_SOURCE_DIRECTORY}/test)
MESSAGE("CMAKE_MODULE_PATH=${CMAKE_MODULE_PATH}")

FUNCTION(TEST_STR_MATCH var expected)
    SET(_val "${${var}}") 
    IF(NOT "${_val}" STREQUAL "${expected}" )
	MESSAGE(SEND_ERROR "  Error: ${var} = |${_val}| <> |${expected}|")
    ENDIF()
ENDFUNCTION()

STRING(REPLACE "/test/.." "" CTEST_HOME_DIR "${CTEST_SOURCE_DIRECTORY}")
SET(CMAKE_FEDORA_TMP_DIR "${CTEST_HOME_DIR}/NO_PACK")
IF(NOT EXISTS ${CMAKE_FEDORA_TMP_DIR})
    FILE(MAKE_DIRECTORY ${CMAKE_FEDORA_TMP_DIR})
ENDIF(NOT EXISTS ${CMAKE_FEDORA_TMP_DIR})

