/* engine.c generated by valac 0.20.1, the Vala compiler
 * generated from engine.vala, do not modify */

/* 
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <libkkc/libkkc.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libutil.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <gdk/gdk.h>


#define TYPE_KKC_ENGINE (kkc_engine_get_type ())
#define KKC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KKC_ENGINE, KkcEngine))
#define KKC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KKC_ENGINE, KkcEngineClass))
#define IS_KKC_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KKC_ENGINE))
#define IS_KKC_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KKC_ENGINE))
#define KKC_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KKC_ENGINE, KkcEngineClass))

typedef struct _KkcEngine KkcEngine;
typedef struct _KkcEngineClass KkcEngineClass;
typedef struct _KkcEnginePrivate KkcEnginePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_ENGINE_TYPE_KEY_ENTRY (kkc_engine_key_entry_get_type ())
typedef struct _KkcEngineKeyEntry KkcEngineKeyEntry;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KkcEngine {
	IBusEngine parent_instance;
	KkcEnginePrivate * priv;
};

struct _KkcEngineClass {
	IBusEngineClass parent_class;
};

struct _KkcEnginePrivate {
	KkcContext* context;
	IBusLookupTable* lookup_table;
	guint page_start;
	gboolean lookup_table_visible;
	gboolean use_custom_keymap;
	gboolean show_annotation;
	IBusKeymap* keymap;
	IBusProperty* input_mode_prop;
	IBusPropList* prop_list;
	GeeMap* input_mode_props;
	GeeMap* input_mode_symbols;
	GeeMap* name_input_modes;
	GtkClipboard* clipboard;
	gchar** LOOKUP_TABLE_LABELS;
	gint LOOKUP_TABLE_LABELS_length1;
	gint _LOOKUP_TABLE_LABELS_size_;
	guint save_dictionaries_timeout_id;
};

struct _KkcEngineKeyEntry {
	guint keyval;
	guint modifiers;
};


static gpointer kkc_engine_parent_class = NULL;
static Preferences* kkc_engine_preferences;
static Preferences* kkc_engine_preferences = NULL;
static GeeArrayList* kkc_engine_dictionaries;
static GeeArrayList* kkc_engine_dictionaries = NULL;
static KkcLanguageModel* kkc_engine_language_model;
static KkcLanguageModel* kkc_engine_language_model = NULL;
static gboolean kkc_engine_ibus;
static gboolean kkc_engine_ibus = FALSE;

GType kkc_engine_get_type (void) G_GNUC_CONST;
#define KKC_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KKC_ENGINE, KkcEnginePrivate))
enum  {
	KKC_ENGINE_DUMMY_PROPERTY
};
static GType kkc_engine_key_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static KkcEngineKeyEntry* kkc_engine_key_entry_dup (const KkcEngineKeyEntry* self);
static void kkc_engine_key_entry_free (KkcEngineKeyEntry* self);
static void kkc_engine_set_selection_text (GtkClipboard* clipboard, const gchar* text, KkcEngine* self);
static void kkc_engine_populate_lookup_table (KkcEngine* self);
static void kkc_engine_set_lookup_table_cursor_pos (KkcEngine* self);
static void kkc_engine_update_preedit (KkcEngine* self);
static void kkc_engine_update_candidates (KkcEngine* self);
static void kkc_engine_update_input_mode (KkcEngine* self);
static void kkc_engine_reload_dictionaries (void);
static void kkc_engine_apply_preferences (KkcEngine* self);
static IBusProperty* kkc_engine_register_input_mode_property (KkcEngine* self, KkcInputMode mode, const gchar* name, const gchar* label, const gchar* symbol);
static gboolean kkc_engine_process_lookup_table_key_event (KkcEngine* self, guint keyval, guint keycode, guint state);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static gboolean kkc_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state);
static void kkc_engine_real_enable (IBusEngine* base);
static gboolean __lambda2_ (KkcEngine* self);
static gboolean ___lambda2__gsource_func (gpointer self);
static void kkc_engine_real_disable (IBusEngine* base);
static void kkc_engine_real_reset (IBusEngine* base);
static void kkc_engine_real_focus_in (IBusEngine* base);
static void kkc_engine_real_focus_out (IBusEngine* base);
static void kkc_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state);
static void kkc_engine_real_candidate_clicked (IBusEngine* base, guint index, guint button, guint state);
static void kkc_engine_real_cursor_up (IBusEngine* base);
static void kkc_engine_real_cursor_down (IBusEngine* base);
static void kkc_engine_real_page_up (IBusEngine* base);
static void kkc_engine_real_page_down (IBusEngine* base);
gint kkc_engine_main (gchar** args, int args_length1);
static void __lambda3_ (void);
static void ___lambda3__ibus_bus_disconnected (IBusBus* _sender, gpointer self);
static void __lambda4_ (const gchar* name, GVariant* value);
static void ___lambda4__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self);
KkcEngine* kkc_engine_new (void);
KkcEngine* kkc_engine_construct (GType object_type);
static GObject * kkc_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _kkc_engine___lambda5_ (KkcEngine* self, const gchar* name, GVariant* value);
static void __kkc_engine___lambda5__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self);
static void _kkc_engine___lambda6_ (KkcEngine* self);
static void __kkc_engine___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _kkc_engine___lambda7_ (KkcEngine* self, GObject* s, GParamSpec* p);
static void __kkc_engine___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _kkc_engine___lambda8_ (KkcEngine* self);
static void __kkc_engine___lambda8__kkc_candidate_list_populated (KkcCandidateList* _sender, gpointer self);
static void _kkc_engine___lambda9_ (KkcEngine* self);
static void __kkc_engine___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _kkc_engine___lambda10_ (KkcEngine* self);
static void __kkc_engine___lambda10__kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self);
static void _kkc_engine___lambda11_ (KkcEngine* self, KkcContext* e);
static void __kkc_engine___lambda11__kkc_context_request_selection_text (KkcContext* _sender, gpointer self);
static void kkc_engine_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const KkcEngineKeyEntry KKC_ENGINE_IGNORE_KEYS[1] = {{(guint) IBUS_j, (guint) IBUS_CONTROL_MASK}};
static const GOptionEntry KKC_ENGINE_options[2] = {{"ibus", 'i', 0, G_OPTION_ARG_NONE, &kkc_engine_ibus, "Component is executed by IBus", NULL}, {NULL}};

static void kkc_engine_set_selection_text (GtkClipboard* clipboard, const gchar* text, KkcEngine* self) {
	KkcContext* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = text;
	kkc_context_set_selection_text (_tmp0_, _tmp1_);
}


static void kkc_engine_populate_lookup_table (KkcEngine* self) {
	IBusLookupTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lookup_table;
	ibus_lookup_table_clear (_tmp0_);
	{
		guint _tmp1_;
		gint i;
		_tmp1_ = self->priv->page_start;
		i = (gint) _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				KkcContext* _tmp6_;
				KkcCandidateList* _tmp7_;
				KkcCandidateList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				KkcContext* _tmp11_;
				KkcCandidateList* _tmp12_;
				KkcCandidateList* _tmp13_;
				gint _tmp14_;
				KkcCandidate* _tmp15_ = NULL;
				KkcCandidate* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				IBusText* _tmp19_;
				IBusText* _tmp20_;
				IBusText* text;
				IBusLookupTable* _tmp21_;
				IBusText* _tmp22_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->context;
				_tmp7_ = kkc_context_get_candidates (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = kkc_candidate_list_get_size (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp5_ < _tmp10_)) {
					break;
				}
				_tmp11_ = self->priv->context;
				_tmp12_ = kkc_context_get_candidates (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = i;
				_tmp15_ = kkc_candidate_list_get (_tmp13_, _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = kkc_candidate_get_output (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = ibus_text_new_from_string (_tmp18_);
				g_object_ref_sink (_tmp19_);
				_tmp20_ = _tmp19_;
				_g_object_unref0 (_tmp16_);
				text = _tmp20_;
				_tmp21_ = self->priv->lookup_table;
				_tmp22_ = text;
				ibus_lookup_table_append_candidate (_tmp21_, _tmp22_);
				_g_object_unref0 (text);
			}
		}
	}
}


static void kkc_engine_set_lookup_table_cursor_pos (KkcEngine* self) {
	IBusText* _tmp0_;
	IBusText* empty_text;
	KkcContext* _tmp1_;
	KkcCandidateList* _tmp2_;
	KkcCandidateList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cursor_pos;
	KkcContext* _tmp6_;
	KkcCandidateList* _tmp7_;
	KkcCandidateList* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ibus_text_new_from_static_string ("");
	g_object_ref_sink (_tmp0_);
	empty_text = _tmp0_;
	_tmp1_ = self->priv->context;
	_tmp2_ = kkc_context_get_candidates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = kkc_candidate_list_get_cursor_pos (_tmp3_);
	_tmp5_ = _tmp4_;
	cursor_pos = _tmp5_;
	_tmp6_ = self->priv->context;
	_tmp7_ = kkc_context_get_candidates (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = kkc_candidate_list_get_page_visible (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		IBusLookupTable* _tmp11_;
		gint _tmp12_;
		KkcContext* _tmp13_;
		KkcCandidateList* _tmp14_;
		KkcCandidateList* _tmp15_;
		guint _tmp16_;
		guint _tmp17_;
		IBusLookupTable* _tmp18_;
		KkcContext* _tmp19_;
		KkcCandidateList* _tmp20_;
		KkcCandidateList* _tmp21_;
		KkcCandidate* _tmp22_ = NULL;
		KkcCandidate* candidate;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
		gboolean _tmp28_;
		_tmp11_ = self->priv->lookup_table;
		_tmp12_ = cursor_pos;
		_tmp13_ = self->priv->context;
		_tmp14_ = kkc_context_get_candidates (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = kkc_candidate_list_get_page_start (_tmp15_);
		_tmp17_ = _tmp16_;
		ibus_lookup_table_set_cursor_pos (_tmp11_, _tmp12_ - _tmp17_);
		_tmp18_ = self->priv->lookup_table;
		ibus_engine_update_lookup_table_fast ((IBusEngine*) self, _tmp18_, TRUE);
		_tmp19_ = self->priv->context;
		_tmp20_ = kkc_context_get_candidates (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = kkc_candidate_list_get (_tmp21_, -1);
		candidate = _tmp22_;
		_tmp24_ = self->priv->show_annotation;
		if (_tmp24_) {
			KkcCandidate* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp25_ = candidate;
			_tmp26_ = kkc_candidate_get_annotation (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp28_ = _tmp23_;
		if (_tmp28_) {
			KkcCandidate* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			IBusText* _tmp32_;
			IBusText* text;
			IBusText* _tmp33_;
			_tmp29_ = candidate;
			_tmp30_ = kkc_candidate_get_annotation (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = ibus_text_new_from_string (_tmp31_);
			g_object_ref_sink (_tmp32_);
			text = _tmp32_;
			_tmp33_ = text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp33_, TRUE);
			_g_object_unref0 (text);
		} else {
			IBusText* _tmp34_;
			_tmp34_ = empty_text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp34_, FALSE);
		}
		self->priv->lookup_table_visible = TRUE;
		_g_object_unref0 (candidate);
	} else {
		gboolean _tmp35_;
		_tmp35_ = self->priv->lookup_table_visible;
		if (_tmp35_) {
			ibus_engine_hide_lookup_table ((IBusEngine*) self);
			ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
			self->priv->lookup_table_visible = FALSE;
		}
	}
	_g_object_unref0 (empty_text);
}


static void kkc_engine_update_preedit (KkcEngine* self) {
	IBusText* text = NULL;
	guint cursor_pos = 0U;
	KkcContext* _tmp0_;
	KkcSegmentList* _tmp1_;
	KkcSegmentList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	IBusText* _tmp86_;
	guint _tmp87_ = 0U;
	KkcContext* _tmp91_;
	gboolean _tmp92_ = FALSE;
	IBusText* _tmp98_;
	guint _tmp99_;
	IBusText* _tmp100_;
	guint _tmp101_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_segments (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_segment_list_get_cursor_pos (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ >= 0) {
		KkcContext* _tmp5_;
		KkcSegmentList* _tmp6_;
		KkcSegmentList* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		IBusText* _tmp10_;
		gint index;
		gint offset;
		IBusText* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		KkcContext* _tmp33_;
		KkcSegmentList* _tmp34_;
		KkcSegmentList* _tmp35_;
		gint _tmp36_;
		KkcSegment* _tmp37_ = NULL;
		KkcSegment* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gint _tmp41_ = 0;
		IBusText* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		KkcContext* _tmp45_;
		KkcSegmentList* _tmp46_;
		KkcSegmentList* _tmp47_;
		gint _tmp48_;
		KkcSegment* _tmp49_ = NULL;
		KkcSegment* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gint _tmp53_ = 0;
		gint _tmp54_;
		_tmp5_ = self->priv->context;
		_tmp6_ = kkc_context_get_segments (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = kkc_segment_list_get_output (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = ibus_text_new_from_string (_tmp9_);
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (text);
		text = _tmp10_;
		_g_free0 (_tmp9_);
		index = 0;
		offset = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				gint _tmp14_;
				KkcContext* _tmp15_;
				KkcSegmentList* _tmp16_;
				KkcSegmentList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				KkcContext* _tmp21_;
				KkcSegmentList* _tmp22_;
				KkcSegmentList* _tmp23_;
				gint _tmp24_;
				KkcSegment* _tmp25_ = NULL;
				KkcSegment* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gint _tmp29_ = 0;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = index;
					index = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = index;
				_tmp15_ = self->priv->context;
				_tmp16_ = kkc_context_get_segments (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = kkc_segment_list_get_cursor_pos (_tmp17_);
				_tmp19_ = _tmp18_;
				if (!(_tmp14_ < _tmp19_)) {
					break;
				}
				_tmp20_ = offset;
				_tmp21_ = self->priv->context;
				_tmp22_ = kkc_context_get_segments (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = index;
				_tmp25_ = kkc_segment_list_get (_tmp23_, _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = kkc_segment_get_output (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_utf8_strlen (_tmp28_, (gssize) (-1));
				offset = _tmp20_ + _tmp29_;
				_g_object_unref0 (_tmp26_);
			}
		}
		_tmp30_ = text;
		_tmp31_ = offset;
		_tmp32_ = offset;
		_tmp33_ = self->priv->context;
		_tmp34_ = kkc_context_get_segments (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = index;
		_tmp37_ = kkc_segment_list_get (_tmp35_, _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = kkc_segment_get_output (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_utf8_strlen (_tmp40_, (gssize) (-1));
		ibus_text_append_attribute (_tmp30_, (guint) IBUS_ATTR_TYPE_BACKGROUND, (guint) 0x00c8c8f0, (guint) _tmp31_, _tmp32_ + _tmp41_);
		_g_object_unref0 (_tmp38_);
		_tmp42_ = text;
		_tmp43_ = offset;
		_tmp44_ = offset;
		_tmp45_ = self->priv->context;
		_tmp46_ = kkc_context_get_segments (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = index;
		_tmp49_ = kkc_segment_list_get (_tmp47_, _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = kkc_segment_get_output (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_utf8_strlen (_tmp52_, (gssize) (-1));
		ibus_text_append_attribute (_tmp42_, (guint) IBUS_ATTR_TYPE_FOREGROUND, (guint) 0x00000000, (guint) _tmp43_, _tmp44_ + _tmp53_);
		_g_object_unref0 (_tmp50_);
		_tmp54_ = offset;
		cursor_pos = (guint) _tmp54_;
	} else {
		KkcContext* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		IBusText* _tmp59_;
		gboolean _tmp60_ = FALSE;
		IBusText* _tmp61_;
		guint _tmp62_ = 0U;
		gboolean _tmp66_;
		_tmp55_ = self->priv->context;
		_tmp56_ = kkc_context_get_input (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = _tmp57_;
		_tmp59_ = ibus_text_new_from_string (_tmp58_);
		g_object_ref_sink (_tmp59_);
		_g_object_unref0 (text);
		text = _tmp59_;
		_g_free0 (_tmp58_);
		_tmp61_ = text;
		_tmp62_ = ibus_text_get_length (_tmp61_);
		if (_tmp62_ > ((guint) 0)) {
			KkcContext* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			_tmp63_ = self->priv->context;
			_tmp64_ = kkc_context_get_input_cursor_pos (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp60_ = _tmp65_ >= 0;
		} else {
			_tmp60_ = FALSE;
		}
		_tmp66_ = _tmp60_;
		if (_tmp66_) {
			IBusText* _tmp67_;
			KkcContext* _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			KkcContext* _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			IBusText* _tmp74_;
			KkcContext* _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			KkcContext* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			KkcContext* _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			_tmp67_ = text;
			_tmp68_ = self->priv->context;
			_tmp69_ = kkc_context_get_input_cursor_pos (_tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = self->priv->context;
			_tmp72_ = kkc_context_get_input_cursor_pos (_tmp71_);
			_tmp73_ = _tmp72_;
			ibus_text_append_attribute (_tmp67_, (guint) IBUS_ATTR_TYPE_BACKGROUND, (guint) 0x00000000, (guint) _tmp70_, _tmp73_ + 1);
			_tmp74_ = text;
			_tmp75_ = self->priv->context;
			_tmp76_ = kkc_context_get_input_cursor_pos (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = self->priv->context;
			_tmp79_ = kkc_context_get_input_cursor_pos (_tmp78_);
			_tmp80_ = _tmp79_;
			ibus_text_append_attribute (_tmp74_, (guint) IBUS_ATTR_TYPE_FOREGROUND, (guint) 0xffffffffLL, (guint) _tmp77_, _tmp80_ + 1);
			_tmp81_ = self->priv->context;
			_tmp82_ = kkc_context_get_input_cursor_pos (_tmp81_);
			_tmp83_ = _tmp82_;
			cursor_pos = (guint) _tmp83_;
		} else {
			IBusText* _tmp84_;
			guint _tmp85_ = 0U;
			_tmp84_ = text;
			_tmp85_ = ibus_text_get_length (_tmp84_);
			cursor_pos = _tmp85_;
		}
	}
	_tmp86_ = text;
	_tmp87_ = ibus_text_get_length (_tmp86_);
	if (_tmp87_ > ((guint) 0)) {
		IBusText* _tmp88_;
		IBusText* _tmp89_;
		guint _tmp90_ = 0U;
		_tmp88_ = text;
		_tmp89_ = text;
		_tmp90_ = ibus_text_get_length (_tmp89_);
		ibus_text_append_attribute (_tmp88_, (guint) IBUS_ATTR_TYPE_UNDERLINE, (guint) IBUS_ATTR_UNDERLINE_SINGLE, (guint) 0, (gint) _tmp90_);
	}
	_tmp91_ = self->priv->context;
	_tmp92_ = kkc_context_has_output (_tmp91_);
	if (_tmp92_) {
		KkcContext* _tmp93_;
		gchar* _tmp94_ = NULL;
		gchar* output;
		const gchar* _tmp95_;
		IBusText* _tmp96_;
		IBusText* ctext;
		IBusText* _tmp97_;
		_tmp93_ = self->priv->context;
		_tmp94_ = kkc_context_poll_output (_tmp93_);
		output = _tmp94_;
		_tmp95_ = output;
		_tmp96_ = ibus_text_new_from_string (_tmp95_);
		g_object_ref_sink (_tmp96_);
		ctext = _tmp96_;
		_tmp97_ = ctext;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp97_);
		_g_object_unref0 (ctext);
		_g_free0 (output);
	}
	_tmp98_ = text;
	_tmp99_ = cursor_pos;
	_tmp100_ = text;
	_tmp101_ = ibus_text_get_length (_tmp100_);
	ibus_engine_update_preedit_text ((IBusEngine*) self, _tmp98_, _tmp99_, _tmp101_ > ((guint) 0));
	_g_object_unref0 (text);
}


static void kkc_engine_update_candidates (KkcEngine* self) {
	KkcContext* _tmp0_;
	KkcCandidateList* _tmp1_;
	KkcCandidateList* _tmp2_;
	guint _tmp3_;
	KkcContext* _tmp4_;
	KkcCandidateList* _tmp5_;
	KkcCandidateList* _tmp6_;
	IBusLookupTable* _tmp7_;
	guint _tmp8_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->page_start;
	kkc_candidate_list_set_page_start (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->context;
	_tmp5_ = kkc_context_get_candidates (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->lookup_table;
	_tmp8_ = ibus_lookup_table_get_page_size (_tmp7_);
	kkc_candidate_list_set_page_size (_tmp6_, _tmp8_);
	kkc_engine_populate_lookup_table (self);
	kkc_engine_set_lookup_table_cursor_pos (self);
}


static void kkc_engine_update_input_mode (KkcEngine* self) {
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_ = NULL;
	GeeMapIterator* iter;
	GeeMapIterator* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeMap* _tmp19_;
	KkcContext* _tmp20_;
	KkcInputMode _tmp21_;
	KkcInputMode _tmp22_;
	gpointer _tmp23_ = NULL;
	gchar* _tmp24_;
	IBusText* _tmp25_;
	IBusText* _tmp26_;
	IBusText* symbol;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	IBusText* _tmp31_;
	IBusText* _tmp32_;
	IBusText* label;
	IBusProperty* _tmp33_;
	IBusProperty* _tmp34_;
	IBusProperty* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_mode_props;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	iter = _tmp1_;
	_tmp2_ = iter;
	_tmp3_ = gee_map_iterator_first (_tmp2_);
	if (_tmp3_) {
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				GeeMapIterator* _tmp8_;
				gpointer _tmp9_ = NULL;
				KkcInputMode input_mode;
				GeeMapIterator* _tmp10_;
				gpointer _tmp11_ = NULL;
				IBusProperty* prop;
				KkcInputMode _tmp12_;
				KkcContext* _tmp13_;
				KkcInputMode _tmp14_;
				KkcInputMode _tmp15_;
				IBusProperty* _tmp18_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					GeeMapIterator* _tmp6_;
					gboolean _tmp7_ = FALSE;
					_tmp6_ = iter;
					_tmp7_ = gee_map_iterator_next (_tmp6_);
					if (!_tmp7_) {
						break;
					}
				}
				_tmp4_ = FALSE;
				_tmp8_ = iter;
				_tmp9_ = gee_map_iterator_get_key (_tmp8_);
				input_mode = (KkcInputMode) ((gintptr) _tmp9_);
				_tmp10_ = iter;
				_tmp11_ = gee_map_iterator_get_value (_tmp10_);
				prop = (IBusProperty*) _tmp11_;
				_tmp12_ = input_mode;
				_tmp13_ = self->priv->context;
				_tmp14_ = kkc_context_get_input_mode (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp12_ == _tmp15_) {
					IBusProperty* _tmp16_;
					_tmp16_ = prop;
					ibus_property_set_state (_tmp16_, PROP_STATE_CHECKED);
				} else {
					IBusProperty* _tmp17_;
					_tmp17_ = prop;
					ibus_property_set_state (_tmp17_, PROP_STATE_UNCHECKED);
				}
				_tmp18_ = prop;
				ibus_engine_update_property ((IBusEngine*) self, _tmp18_);
				_g_object_unref0 (prop);
			}
		}
	}
	_tmp19_ = self->priv->input_mode_symbols;
	_tmp20_ = self->priv->context;
	_tmp21_ = kkc_context_get_input_mode (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gee_map_get (_tmp19_, (gpointer) ((gintptr) _tmp22_));
	_tmp24_ = (gchar*) _tmp23_;
	_tmp25_ = ibus_text_new_from_string (_tmp24_);
	g_object_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	symbol = _tmp26_;
	_tmp27_ = _ ("Input Mode (%s)");
	_tmp28_ = symbol->text;
	_tmp29_ = g_strdup_printf (_tmp27_, _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = ibus_text_new_from_string (_tmp30_);
	g_object_ref_sink (_tmp31_);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp30_);
	label = _tmp32_;
	_tmp33_ = self->priv->input_mode_prop;
	ibus_property_set_label (_tmp33_, label);
	_tmp34_ = self->priv->input_mode_prop;
	ibus_property_set_symbol (_tmp34_, symbol);
	_tmp35_ = self->priv->input_mode_prop;
	ibus_engine_update_property ((IBusEngine*) self, _tmp35_);
	_g_object_unref0 (label);
	_g_object_unref0 (symbol);
	_g_object_unref0 (iter);
}


static void kkc_engine_reload_dictionaries (void) {
	GeeArrayList* _tmp0_;
	GVariant* variant = NULL;
	Preferences* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_;
	Preferences* _tmp10_;
	GVariant* _tmp11_ = NULL;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	size_t _tmp14_;
	gchar** _tmp15_ = NULL;
	gchar** strv;
	gint strv_length1;
	gint _strv_size_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = kkc_engine_dictionaries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = kkc_engine_preferences;
	_tmp2_ = preferences_get (_tmp1_, "user_dictionary");
	_g_variant_unref0 (variant);
	variant = _tmp2_;
	_tmp3_ = variant;
	if (_tmp3_ != NULL) {
		GVariant* _tmp4_;
		const gchar* _tmp5_ = NULL;
		KkcUserDictionary* _tmp6_;
		KkcUserDictionary* _tmp7_;
		GeeArrayList* _tmp8_;
		KkcUserDictionary* _tmp9_;
		_tmp4_ = variant;
		_tmp5_ = g_variant_get_string (_tmp4_, NULL);
		_tmp6_ = kkc_user_dictionary_new (_tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_variant_unref0 (variant);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = kkc_engine_dictionaries;
		_tmp9_ = _tmp7_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, (KkcDictionary*) _tmp9_);
		_g_object_unref0 (_tmp9_);
	}
	_tmp10_ = kkc_engine_preferences;
	_tmp11_ = preferences_get (_tmp10_, "system_dictionaries");
	_g_variant_unref0 (variant);
	variant = _tmp11_;
	_tmp12_ = variant;
	_vala_assert (_tmp12_ != NULL, "variant != null");
	_tmp13_ = variant;
	_tmp15_ = g_variant_dup_strv (_tmp13_, &_tmp14_);
	strv = _tmp15_;
	strv_length1 = _tmp14_;
	_strv_size_ = strv_length1;
	_tmp16_ = strv;
	_tmp16__length1 = strv_length1;
	{
		gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp16_;
		id_collection_length1 = _tmp16__length1;
		for (id_it = 0; id_it < _tmp16__length1; id_it = id_it + 1) {
			gchar* _tmp17_;
			gchar* id = NULL;
			_tmp17_ = g_strdup (id_collection[id_it]);
			id = _tmp17_;
			{
				Preferences* _tmp18_;
				const gchar* _tmp19_;
				DictionaryMetadata* _tmp20_ = NULL;
				DictionaryMetadata* metadata;
				DictionaryMetadata* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				DictionaryMetadata* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				KkcSystemSegmentDictionary* _tmp27_;
				KkcSystemSegmentDictionary* _tmp28_;
				GeeArrayList* _tmp29_;
				KkcSystemSegmentDictionary* _tmp30_;
				_tmp18_ = kkc_engine_preferences;
				_tmp19_ = id;
				_tmp20_ = preferences_get_dictionary_metadata (_tmp18_, _tmp19_);
				metadata = _tmp20_;
				_tmp21_ = metadata;
				_tmp22_ = dictionary_metadata_get_filename (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = metadata;
				_tmp25_ = dictionary_metadata_get_encoding (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = kkc_system_segment_dictionary_new (_tmp23_, _tmp26_, &_inner_error_);
				_tmp28_ = _tmp27_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (metadata);
					_g_free0 (id);
					strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
					_g_variant_unref0 (variant);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp29_ = kkc_engine_dictionaries;
				_tmp30_ = _tmp28_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, (KkcDictionary*) _tmp30_);
				_g_object_unref0 (_tmp30_);
				_g_object_unref0 (metadata);
				_g_free0 (id);
			}
		}
	}
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (variant);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void kkc_engine_apply_preferences (KkcEngine* self) {
	GVariant* variant = NULL;
	Preferences* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_;
	KkcContext* _tmp3_;
	GVariant* _tmp4_;
	gint32 _tmp5_ = 0;
	Preferences* _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_;
	KkcContext* _tmp9_;
	GVariant* _tmp10_;
	gboolean _tmp11_ = FALSE;
	Preferences* _tmp12_;
	GVariant* _tmp13_ = NULL;
	GVariant* _tmp14_;
	IBusLookupTable* _tmp15_;
	GVariant* _tmp16_;
	gint32 _tmp17_ = 0;
	Preferences* _tmp18_;
	GVariant* _tmp19_ = NULL;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	gint32 _tmp22_ = 0;
	Preferences* _tmp23_;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_;
	KkcContext* _tmp26_;
	GVariant* _tmp27_;
	gint32 _tmp28_ = 0;
	Preferences* _tmp29_;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	gboolean _tmp33_ = FALSE;
	Preferences* _tmp34_;
	GVariant* _tmp35_ = NULL;
	GVariant* _tmp36_;
	GVariant* _tmp37_;
	const gchar* _tmp38_ = NULL;
	KkcRuleMetadata* _tmp39_ = NULL;
	KkcRuleMetadata* parent_metadata;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* base_dir;
	Preferences* _tmp50_;
	GVariant* _tmp51_ = NULL;
	GVariant* _tmp52_;
	GVariant* _tmp53_;
	gboolean _tmp54_ = FALSE;
	Preferences* _tmp55_;
	GVariant* _tmp56_ = NULL;
	GVariant* _tmp57_;
	GVariant* _tmp58_;
	const gchar* _tmp59_ = NULL;
	IBusKeymap* _tmp60_ = NULL;
	IBusKeymap* _tmp61_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = kkc_engine_preferences;
	_tmp1_ = preferences_get (_tmp0_, "punctuation_style");
	_g_variant_unref0 (variant);
	variant = _tmp1_;
	_tmp2_ = variant;
	_vala_assert (_tmp2_ != NULL, "variant != null");
	_tmp3_ = self->priv->context;
	_tmp4_ = variant;
	_tmp5_ = g_variant_get_int32 (_tmp4_);
	kkc_context_set_punctuation_style (_tmp3_, (KkcPunctuationStyle) _tmp5_);
	_tmp6_ = kkc_engine_preferences;
	_tmp7_ = preferences_get (_tmp6_, "auto_correct");
	_g_variant_unref0 (variant);
	variant = _tmp7_;
	_tmp8_ = variant;
	_vala_assert (_tmp8_ != NULL, "variant != null");
	_tmp9_ = self->priv->context;
	_tmp10_ = variant;
	_tmp11_ = g_variant_get_boolean (_tmp10_);
	kkc_context_set_auto_correct (_tmp9_, _tmp11_);
	_tmp12_ = kkc_engine_preferences;
	_tmp13_ = preferences_get (_tmp12_, "page_size");
	_g_variant_unref0 (variant);
	variant = _tmp13_;
	_tmp14_ = variant;
	_vala_assert (_tmp14_ != NULL, "variant != null");
	_tmp15_ = self->priv->lookup_table;
	_tmp16_ = variant;
	_tmp17_ = g_variant_get_int32 (_tmp16_);
	ibus_lookup_table_set_page_size (_tmp15_, (guint) _tmp17_);
	_tmp18_ = kkc_engine_preferences;
	_tmp19_ = preferences_get (_tmp18_, "pagination_start");
	_g_variant_unref0 (variant);
	variant = _tmp19_;
	_tmp20_ = variant;
	_vala_assert (_tmp20_ != NULL, "variant != null");
	_tmp21_ = variant;
	_tmp22_ = g_variant_get_int32 (_tmp21_);
	self->priv->page_start = (guint) _tmp22_;
	_tmp23_ = kkc_engine_preferences;
	_tmp24_ = preferences_get (_tmp23_, "initial_input_mode");
	_g_variant_unref0 (variant);
	variant = _tmp24_;
	_tmp25_ = variant;
	_vala_assert (_tmp25_ != NULL, "variant != null");
	_tmp26_ = self->priv->context;
	_tmp27_ = variant;
	_tmp28_ = g_variant_get_int32 (_tmp27_);
	kkc_context_set_input_mode (_tmp26_, (KkcInputMode) _tmp28_);
	_tmp29_ = kkc_engine_preferences;
	_tmp30_ = preferences_get (_tmp29_, "show_annotation");
	_g_variant_unref0 (variant);
	variant = _tmp30_;
	_tmp31_ = variant;
	_vala_assert (_tmp31_ != NULL, "variant != null");
	_tmp32_ = variant;
	_tmp33_ = g_variant_get_boolean (_tmp32_);
	self->priv->show_annotation = _tmp33_;
	_tmp34_ = kkc_engine_preferences;
	_tmp35_ = preferences_get (_tmp34_, "typing_rule");
	_g_variant_unref0 (variant);
	variant = _tmp35_;
	_tmp36_ = variant;
	_vala_assert (_tmp36_ != NULL, "variant != null");
	_tmp37_ = variant;
	_tmp38_ = g_variant_get_string (_tmp37_, NULL);
	_tmp39_ = kkc_rule_metadata_find (_tmp38_);
	parent_metadata = _tmp39_;
	_vala_assert (parent_metadata != NULL, "parent_metadata != null");
	_tmp40_ = g_get_user_config_dir ();
	_tmp41_ = g_build_filename (_tmp40_, "ibus-kkc", "rules", NULL);
	base_dir = _tmp41_;
	{
		KkcUserRule* _tmp42_;
		KkcUserRule* _tmp43_;
		KkcContext* _tmp44_;
		KkcUserRule* _tmp45_;
		_tmp42_ = kkc_user_rule_new (parent_metadata, base_dir, "ibus-kkc", &_inner_error_);
		_tmp43_ = _tmp42_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp44_ = self->priv->context;
		_tmp45_ = _tmp43_;
		kkc_context_set_typing_rule (_tmp44_, (KkcRule*) _tmp45_);
		_g_object_unref0 (_tmp45_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GVariant* _tmp46_;
		const gchar* _tmp47_ = NULL;
		GError* _tmp48_;
		const gchar* _tmp49_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp46_ = variant;
		_tmp47_ = g_variant_get_string (_tmp46_, NULL);
		_tmp48_ = e;
		_tmp49_ = _tmp48_->message;
		g_warning ("engine.vala:376: can't load typing rule %s: %s", _tmp47_, _tmp49_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (base_dir);
		_g_object_unref0 (parent_metadata);
		_g_variant_unref0 (variant);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp50_ = kkc_engine_preferences;
	_tmp51_ = preferences_get (_tmp50_, "use_custom_keymap");
	_g_variant_unref0 (variant);
	variant = _tmp51_;
	_tmp52_ = variant;
	_vala_assert (_tmp52_ != NULL, "variant != null");
	_tmp53_ = variant;
	_tmp54_ = g_variant_get_boolean (_tmp53_);
	self->priv->use_custom_keymap = _tmp54_;
	_tmp55_ = kkc_engine_preferences;
	_tmp56_ = preferences_get (_tmp55_, "keymap");
	_g_variant_unref0 (variant);
	variant = _tmp56_;
	_tmp57_ = variant;
	_vala_assert (_tmp57_ != NULL, "variant != null");
	_tmp58_ = variant;
	_tmp59_ = g_variant_get_string (_tmp58_, NULL);
	_tmp60_ = ibus_keymap_get (_tmp59_);
	_tmp61_ = _g_object_ref0 (_tmp60_);
	_g_object_unref0 (self->priv->keymap);
	self->priv->keymap = _tmp61_;
	_g_free0 (base_dir);
	_g_object_unref0 (parent_metadata);
	_g_variant_unref0 (variant);
}


static IBusProperty* kkc_engine_register_input_mode_property (KkcEngine* self, KkcInputMode mode, const gchar* name, const gchar* label, const gchar* symbol) {
	IBusProperty* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	IBusText* _tmp2_;
	IBusText* _tmp3_;
	IBusProperty* _tmp4_;
	IBusProperty* _tmp5_;
	IBusProperty* prop;
	GeeMap* _tmp6_;
	KkcInputMode _tmp7_;
	GeeMap* _tmp8_;
	KkcInputMode _tmp9_;
	const gchar* _tmp10_;
	GeeMap* _tmp11_;
	const gchar* _tmp12_;
	KkcInputMode _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = label;
	_tmp2_ = ibus_text_new_from_string (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = ibus_property_new (_tmp0_, PROP_TYPE_RADIO, _tmp3_, NULL, NULL, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	prop = _tmp5_;
	_tmp6_ = self->priv->input_mode_props;
	_tmp7_ = mode;
	gee_map_set (_tmp6_, (gpointer) ((gintptr) _tmp7_), prop);
	_tmp8_ = self->priv->input_mode_symbols;
	_tmp9_ = mode;
	_tmp10_ = symbol;
	gee_map_set (_tmp8_, (gpointer) ((gintptr) _tmp9_), _tmp10_);
	_tmp11_ = self->priv->name_input_modes;
	_tmp12_ = name;
	_tmp13_ = mode;
	gee_map_set (_tmp11_, _tmp12_, (gpointer) ((gintptr) _tmp13_));
	result = prop;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean kkc_engine_process_lookup_table_key_event (KkcEngine* self, guint keyval, guint keycode, guint state) {
	gboolean result = FALSE;
	IBusLookupTable* _tmp0_;
	guint _tmp1_ = 0U;
	guint page_size;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_;
	gboolean _tmp8_;
	guint _tmp28_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lookup_table;
	_tmp1_ = ibus_lookup_table_get_page_size (_tmp0_);
	page_size = _tmp1_;
	_tmp3_ = state;
	if (_tmp3_ == ((guint) 0)) {
		guint _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp4_ = keyval;
		_tmp5_ = g_unichar_to_string ((gunichar) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp7__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp2_ = _vala_string_array_contains (_tmp7_, _tmp7__length1, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		guint _tmp9_;
		gunichar _tmp10_ = 0U;
		gchar* _tmp11_ = NULL;
		gchar* label;
		_tmp9_ = keyval;
		_tmp10_ = g_unichar_tolower ((gunichar) _tmp9_);
		_tmp11_ = g_unichar_to_string (_tmp10_);
		label = _tmp11_;
		{
			gint index;
			index = 0;
			{
				gboolean _tmp12_;
				_tmp12_ = TRUE;
				while (TRUE) {
					gboolean _tmp13_;
					gint _tmp15_;
					guint _tmp16_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_ = 0;
					gchar** _tmp19_;
					gint _tmp19__length1;
					gint _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp13_ = _tmp12_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = index;
						index = _tmp14_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp15_ = index;
					_tmp16_ = page_size;
					_tmp17_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp17__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp18_ = MIN ((gint) _tmp16_, _tmp17__length1);
					if (!(_tmp15_ < _tmp18_)) {
						break;
					}
					_tmp19_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp19__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp20_ = index;
					_tmp21_ = _tmp19_[_tmp20_];
					_tmp22_ = label;
					if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
						KkcContext* _tmp23_;
						KkcCandidateList* _tmp24_;
						KkcCandidateList* _tmp25_;
						gint _tmp26_;
						gboolean _tmp27_ = FALSE;
						_tmp23_ = self->priv->context;
						_tmp24_ = kkc_context_get_candidates (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = index;
						_tmp27_ = kkc_candidate_list_select_at (_tmp25_, (guint) _tmp26_);
						result = _tmp27_;
						_g_free0 (label);
						return result;
					}
				}
			}
		}
		result = FALSE;
		_g_free0 (label);
		return result;
	}
	_tmp28_ = state;
	if (_tmp28_ == ((guint) 0)) {
		gboolean retval;
		guint _tmp29_;
		gboolean _tmp46_;
		retval = FALSE;
		_tmp29_ = keyval;
		switch (_tmp29_) {
			case IBUS_Page_Up:
			case IBUS_KP_Page_Up:
			{
				KkcContext* _tmp30_;
				KkcCandidateList* _tmp31_;
				KkcCandidateList* _tmp32_;
				gboolean _tmp33_ = FALSE;
				_tmp30_ = self->priv->context;
				_tmp31_ = kkc_context_get_candidates (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = kkc_candidate_list_page_up (_tmp32_);
				retval = _tmp33_;
				break;
			}
			case IBUS_Page_Down:
			case IBUS_KP_Page_Down:
			{
				KkcContext* _tmp34_;
				KkcCandidateList* _tmp35_;
				KkcCandidateList* _tmp36_;
				gboolean _tmp37_ = FALSE;
				_tmp34_ = self->priv->context;
				_tmp35_ = kkc_context_get_candidates (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = kkc_candidate_list_page_down (_tmp36_);
				retval = _tmp37_;
				break;
			}
			case IBUS_Up:
			{
				KkcContext* _tmp38_;
				KkcCandidateList* _tmp39_;
				KkcCandidateList* _tmp40_;
				gboolean _tmp41_ = FALSE;
				_tmp38_ = self->priv->context;
				_tmp39_ = kkc_context_get_candidates (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = kkc_candidate_list_cursor_up (_tmp40_);
				retval = _tmp41_;
				break;
			}
			case IBUS_Down:
			{
				KkcContext* _tmp42_;
				KkcCandidateList* _tmp43_;
				KkcCandidateList* _tmp44_;
				gboolean _tmp45_ = FALSE;
				_tmp42_ = self->priv->context;
				_tmp43_ = kkc_context_get_candidates (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = kkc_candidate_list_cursor_down (_tmp44_);
				retval = _tmp45_;
				break;
			}
			default:
			{
				result = FALSE;
				return result;
			}
		}
		_tmp46_ = retval;
		if (_tmp46_) {
			kkc_engine_set_lookup_table_cursor_pos (self);
			kkc_engine_update_preedit (self);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean kkc_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state) {
	KkcEngine * self;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _keyval;
	gboolean _tmp1_;
	guint _tmp6_;
	guint _state;
	gboolean _tmp7_ = FALSE;
	KkcContext* _tmp8_;
	KkcCandidateList* _tmp9_;
	KkcCandidateList* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	KkcKeyEvent* _tmp21_;
	KkcKeyEvent* key;
	KkcContext* _tmp22_;
	KkcKeyEvent* _tmp23_;
	gboolean _tmp24_ = FALSE;
	gboolean retval;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_;
	gboolean _tmp42_;
	gboolean _tmp45_;
	gboolean _tmp47_;
	gboolean _tmp49_;
	gboolean _tmp51_;
	self = (KkcEngine*) base;
	_tmp0_ = keyval;
	_keyval = _tmp0_;
	_tmp1_ = self->priv->use_custom_keymap;
	if (_tmp1_) {
		IBusKeymap* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		guint _tmp5_ = 0U;
		_tmp2_ = self->priv->keymap;
		_tmp3_ = keycode;
		_tmp4_ = state;
		_tmp5_ = ibus_keymap_lookup_keysym (_tmp2_, (guint16) _tmp3_, (guint32) _tmp4_);
		_keyval = _tmp5_;
	}
	_tmp6_ = state;
	_state = _tmp6_ & ((((IBUS_SHIFT_MASK | IBUS_CONTROL_MASK) | IBUS_MOD1_MASK) | IBUS_MOD5_MASK) | IBUS_RELEASE_MASK);
	_tmp8_ = self->priv->context;
	_tmp9_ = kkc_context_get_candidates (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_candidate_list_get_page_visible (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		guint _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp13_ = _keyval;
		_tmp14_ = keycode;
		_tmp15_ = _state;
		_tmp16_ = kkc_engine_process_lookup_table_key_event (self, _tmp13_, _tmp14_, _tmp15_);
		_tmp7_ = _tmp16_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp17_ = _tmp7_;
	if (_tmp17_) {
		result = TRUE;
		return result;
	}
	_tmp18_ = _keyval;
	_tmp19_ = keycode;
	_tmp20_ = _state;
	_tmp21_ = kkc_key_event_new_from_x_event (_tmp18_, _tmp19_, (KkcModifierType) _tmp20_);
	key = _tmp21_;
	_tmp22_ = self->priv->context;
	_tmp23_ = key;
	_tmp24_ = kkc_context_process_key_event (_tmp22_, _tmp23_);
	retval = _tmp24_;
	{
		KkcEngineKeyEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = KKC_ENGINE_IGNORE_KEYS;
		entry_collection_length1 = G_N_ELEMENTS (KKC_ENGINE_IGNORE_KEYS);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (KKC_ENGINE_IGNORE_KEYS); entry_it = entry_it + 1) {
			KkcEngineKeyEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				gboolean _tmp25_ = FALSE;
				KkcEngineKeyEntry _tmp26_;
				guint _tmp27_;
				guint _tmp28_;
				gboolean _tmp34_;
				_tmp26_ = entry;
				_tmp27_ = _tmp26_.keyval;
				_tmp28_ = _keyval;
				if (_tmp27_ == _tmp28_) {
					KkcEngineKeyEntry _tmp29_;
					guint _tmp30_;
					KkcKeyEvent* _tmp31_;
					KkcModifierType _tmp32_;
					KkcModifierType _tmp33_;
					_tmp29_ = entry;
					_tmp30_ = _tmp29_.modifiers;
					_tmp31_ = key;
					_tmp32_ = kkc_key_event_get_modifiers (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp25_ = _tmp30_ == ((guint) _tmp33_);
				} else {
					_tmp25_ = FALSE;
				}
				_tmp34_ = _tmp25_;
				if (_tmp34_) {
					result = TRUE;
					_g_object_unref0 (key);
					return result;
				}
			}
		}
	}
	_tmp40_ = retval;
	if (!_tmp40_) {
		gboolean _tmp41_;
		_tmp41_ = self->priv->use_custom_keymap;
		_tmp39_ = _tmp41_;
	} else {
		_tmp39_ = FALSE;
	}
	_tmp42_ = _tmp39_;
	if (_tmp42_) {
		guint _tmp43_;
		guint _tmp44_;
		_tmp43_ = _keyval;
		_tmp44_ = keyval;
		_tmp38_ = _tmp43_ != _tmp44_;
	} else {
		_tmp38_ = FALSE;
	}
	_tmp45_ = _tmp38_;
	if (_tmp45_) {
		guint _tmp46_;
		_tmp46_ = _keyval;
		_tmp37_ = ((guint) 0x20) <= _tmp46_;
	} else {
		_tmp37_ = FALSE;
	}
	_tmp47_ = _tmp37_;
	if (_tmp47_) {
		guint _tmp48_;
		_tmp48_ = _keyval;
		_tmp36_ = _tmp48_ <= ((guint) 0x7F);
	} else {
		_tmp36_ = FALSE;
	}
	_tmp49_ = _tmp36_;
	if (_tmp49_) {
		guint _tmp50_;
		_tmp50_ = state;
		_tmp35_ = (_tmp50_ & IBUS_RELEASE_MASK) == ((guint) 0);
	} else {
		_tmp35_ = FALSE;
	}
	_tmp51_ = _tmp35_;
	if (_tmp51_) {
		GString* _tmp52_;
		GString* builder;
		GString* _tmp53_;
		guint _tmp54_;
		GString* _tmp55_;
		const gchar* _tmp56_;
		IBusText* _tmp57_;
		IBusText* text;
		IBusText* _tmp58_;
		_tmp52_ = g_string_new ("");
		builder = _tmp52_;
		_tmp53_ = builder;
		_tmp54_ = _keyval;
		g_string_append_c (_tmp53_, (gchar) _tmp54_);
		_tmp55_ = builder;
		_tmp56_ = _tmp55_->str;
		_tmp57_ = ibus_text_new_from_string (_tmp56_);
		g_object_ref_sink (_tmp57_);
		text = _tmp57_;
		_tmp58_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp58_);
		result = TRUE;
		_g_object_unref0 (text);
		_g_string_free0 (builder);
		_g_object_unref0 (key);
		return result;
	}
	result = retval;
	_g_object_unref0 (key);
	return result;
}


static gboolean __lambda2_ (KkcEngine* self) {
	gboolean result = FALSE;
	KkcContext* _tmp0_;
	KkcDictionaryList* _tmp1_;
	KkcDictionaryList* _tmp2_;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_dictionaries (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_dictionary_list_save (_tmp2_);
	result = TRUE;
	return result;
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
	return result;
}


static void kkc_engine_real_enable (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_;
	guint _tmp1_ = 0U;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	kkc_context_reset (_tmp0_);
	_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_LOW, (guint) 300, ___lambda2__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->save_dictionaries_timeout_id = _tmp1_;
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->enable (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void kkc_engine_real_disable (IBusEngine* base) {
	KkcEngine * self;
	guint _tmp0_;
	KkcContext* _tmp2_;
	KkcDictionaryList* _tmp3_;
	KkcDictionaryList* _tmp4_;
	self = (KkcEngine*) base;
	g_signal_emit_by_name ((IBusEngine*) self, "focus-out");
	_tmp0_ = self->priv->save_dictionaries_timeout_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->save_dictionaries_timeout_id;
		g_source_remove (_tmp1_);
		self->priv->save_dictionaries_timeout_id = (guint) 0;
	}
	_tmp2_ = self->priv->context;
	_tmp3_ = kkc_context_get_dictionaries (_tmp2_);
	_tmp4_ = _tmp3_;
	kkc_dictionary_list_save (_tmp4_);
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->disable (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void kkc_engine_real_reset (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_;
	IBusText* _tmp1_;
	IBusText* empty_text;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	kkc_context_reset (_tmp0_);
	_tmp1_ = ibus_text_new_from_static_string ("");
	g_object_ref_sink (_tmp1_);
	empty_text = _tmp1_;
	ibus_engine_update_preedit_text ((IBusEngine*) self, empty_text, (guint) 0, FALSE);
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->reset (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
	_g_object_unref0 (empty_text);
}


static void kkc_engine_real_focus_in (IBusEngine* base) {
	KkcEngine * self;
	IBusPropList* _tmp0_;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->prop_list;
	ibus_engine_register_properties ((IBusEngine*) self, _tmp0_);
	kkc_engine_update_input_mode (self);
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->focus_in (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void kkc_engine_real_focus_out (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	kkc_context_reset (_tmp0_);
	ibus_engine_hide_preedit_text ((IBusEngine*) self);
	ibus_engine_hide_lookup_table ((IBusEngine*) self);
	IBUS_ENGINE_CLASS (kkc_engine_parent_class)->focus_out (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}


static void kkc_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state) {
	KkcEngine * self;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (KkcEngine*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "setup") == 0) {
		gchar* _tmp1_ = NULL;
		gchar* filename;
		_tmp1_ = g_build_filename (LIBEXECDIR, "ibus-setup-kkc", NULL);
		filename = _tmp1_;
		{
			const gchar* _tmp2_;
			_tmp2_ = filename;
			g_spawn_command_line_async (_tmp2_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch1_g_spawn_error;
				}
				_g_free0 (filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally1;
		__catch1_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp3_;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = filename;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("engine.vala:579: can't spawn %s: %s", _tmp3_, _tmp5_);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (filename);
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp10_;
		_tmp7_ = prop_name;
		_tmp8_ = g_str_has_prefix (_tmp7_, "InputMode.");
		if (_tmp8_) {
			guint _tmp9_;
			_tmp9_ = prop_state;
			_tmp6_ = _tmp9_ == ((guint) PROP_STATE_CHECKED);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp10_ = _tmp6_;
		if (_tmp10_) {
			KkcContext* _tmp11_;
			GeeMap* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_ = NULL;
			_tmp11_ = self->priv->context;
			_tmp12_ = self->priv->name_input_modes;
			_tmp13_ = prop_name;
			_tmp14_ = gee_map_get (_tmp12_, _tmp13_);
			kkc_context_set_input_mode (_tmp11_, (KkcInputMode) ((gintptr) _tmp14_));
		}
	}
}


static void kkc_engine_real_candidate_clicked (IBusEngine* base, guint index, guint button, guint state) {
	KkcEngine * self;
	KkcContext* _tmp0_;
	KkcCandidateList* _tmp1_;
	KkcCandidateList* _tmp2_;
	guint _tmp3_;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	kkc_candidate_list_select_at (_tmp2_, _tmp3_);
}


static void kkc_engine_real_cursor_up (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_;
	KkcCandidateList* _tmp1_;
	KkcCandidateList* _tmp2_;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_candidate_list_cursor_up (_tmp2_);
}


static void kkc_engine_real_cursor_down (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_;
	KkcCandidateList* _tmp1_;
	KkcCandidateList* _tmp2_;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_candidate_list_cursor_down (_tmp2_);
}


static void kkc_engine_real_page_up (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_;
	KkcCandidateList* _tmp1_;
	KkcCandidateList* _tmp2_;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_candidate_list_page_up (_tmp2_);
}


static void kkc_engine_real_page_down (IBusEngine* base) {
	KkcEngine * self;
	KkcContext* _tmp0_;
	KkcCandidateList* _tmp1_;
	KkcCandidateList* _tmp2_;
	self = (KkcEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_candidate_list_page_down (_tmp2_);
}


static void __lambda3_ (void) {
	ibus_quit ();
}


static void ___lambda3__ibus_bus_disconnected (IBusBus* _sender, gpointer self) {
	__lambda3_ ();
}


static void __lambda4_ (const gchar* name, GVariant* value) {
	const gchar* _tmp0_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "dictionaries") == 0) {
		kkc_engine_reload_dictionaries ();
	}
}


static void ___lambda4__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self) {
	__lambda4_ (name, value);
}


gint kkc_engine_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* context;
	GOptionContext* _tmp1_;
	IBusBus* _tmp6_;
	IBusBus* bus;
	IBusBus* _tmp7_;
	gboolean _tmp8_ = FALSE;
	IBusBus* _tmp10_;
	IBusBus* _tmp11_;
	IBusConfig* _tmp12_ = NULL;
	IBusConfig* _tmp13_;
	IBusConfig* config;
	IBusConfig* _tmp14_;
	IBusConfig* _tmp21_;
	Preferences* _tmp22_;
	GeeArrayList* _tmp23_;
	Preferences* _tmp24_;
	IBusBus* _tmp25_;
	GDBusConnection* _tmp26_ = NULL;
	IBusFactory* _tmp27_;
	IBusFactory* factory;
	IBusFactory* _tmp28_;
	gboolean _tmp29_;
	GError * _inner_error_ = NULL;
	ibus_init ();
	kkc_init ();
	gtk_init (&args_length1, &args);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("- ibus kkc");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, KKC_ENGINE_options, "ibus-kkc");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = ibus_bus_new ();
	g_object_ref_sink (_tmp6_);
	bus = _tmp6_;
	_tmp7_ = bus;
	_tmp8_ = ibus_bus_is_connected (_tmp7_);
	if (!_tmp8_) {
		FILE* _tmp9_;
		_tmp9_ = stderr;
		fprintf (_tmp9_, "cannot connect to ibus-daemon!\n");
		result = 1;
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	_tmp10_ = bus;
	g_signal_connect (_tmp10_, "disconnected", (GCallback) ___lambda3__ibus_bus_disconnected, NULL);
	_tmp11_ = bus;
	_tmp12_ = ibus_bus_get_config (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	config = _tmp13_;
	_tmp14_ = config;
	if (_tmp14_ == NULL) {
		FILE* _tmp15_;
		_tmp15_ = stderr;
		fprintf (_tmp15_, "ibus-config component is not running!\n");
		result = 1;
		_g_object_unref0 (config);
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	{
		KkcLanguageModel* _tmp16_ = NULL;
		KkcLanguageModel* _tmp17_;
		_tmp16_ = kkc_language_model_load ("sorted3", &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_object_unref0 (kkc_engine_language_model);
		kkc_engine_language_model = _tmp17_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = stderr;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		fprintf (_tmp18_, "can't load language model: %s\n", _tmp20_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (config);
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp21_ = config;
	_tmp22_ = preferences_new (_tmp21_);
	_g_object_unref0 (kkc_engine_preferences);
	kkc_engine_preferences = _tmp22_;
	_tmp23_ = gee_array_list_new (KKC_TYPE_DICTIONARY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (kkc_engine_dictionaries);
	kkc_engine_dictionaries = _tmp23_;
	kkc_engine_reload_dictionaries ();
	_tmp24_ = kkc_engine_preferences;
	g_signal_connect (_tmp24_, "value-changed", (GCallback) ___lambda4__preferences_value_changed, NULL);
	_tmp25_ = bus;
	_tmp26_ = ibus_bus_get_connection (_tmp25_);
	_tmp27_ = ibus_factory_new (_tmp26_);
	g_object_ref_sink (_tmp27_);
	factory = _tmp27_;
	_tmp28_ = factory;
	ibus_factory_add_engine (_tmp28_, "kkc", TYPE_KKC_ENGINE);
	_tmp29_ = kkc_engine_ibus;
	if (_tmp29_) {
		IBusBus* _tmp30_;
		_tmp30_ = bus;
		ibus_bus_request_name (_tmp30_, "org.freedesktop.IBus.KKC", (guint32) 0);
	} else {
		IBusComponent* _tmp31_;
		IBusComponent* component;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		IBusEngineDesc* _tmp34_;
		IBusEngineDesc* _tmp35_;
		IBusEngineDesc* engine;
		IBusComponent* _tmp36_;
		IBusEngineDesc* _tmp37_;
		IBusBus* _tmp38_;
		IBusComponent* _tmp39_;
		_tmp31_ = ibus_component_new ("org.freedesktop.IBus.KKC", "Kana Kanji", PACKAGE_VERSION, "GPL", "Daiki Ueno <ueno@gnu.org>", "http://code.google.com/p/ibus/", "", "ibus-kkc");
		g_object_ref_sink (_tmp31_);
		component = _tmp31_;
		_tmp32_ = g_strdup_printf ("%s/icons/ibus-kkc.svg", PACKAGE_DATADIR);
		_tmp33_ = _tmp32_;
		_tmp34_ = ibus_engine_desc_new ("kkc", "Kana Kanji", "Kana Kanji Input Method", "ja", "GPL", "Daiki Ueno <ueno@gnu.org>", _tmp33_, "us");
		g_object_ref_sink (_tmp34_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		engine = _tmp35_;
		_tmp36_ = component;
		_tmp37_ = engine;
		ibus_component_add_engine (_tmp36_, _tmp37_);
		_tmp38_ = bus;
		_tmp39_ = component;
		ibus_bus_register_component (_tmp38_, _tmp39_);
		_g_object_unref0 (engine);
		_g_object_unref0 (component);
	}
	ibus_main ();
	result = 0;
	_g_object_unref0 (factory);
	_g_object_unref0 (config);
	_g_object_unref0 (bus);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return kkc_engine_main (argv, argc);
}


KkcEngine* kkc_engine_construct (GType object_type) {
	KkcEngine * self = NULL;
	self = (KkcEngine*) g_object_new (object_type, NULL);
	return self;
}


KkcEngine* kkc_engine_new (void) {
	return kkc_engine_construct (TYPE_KKC_ENGINE);
}


static void _kkc_engine___lambda5_ (KkcEngine* self, const gchar* name, GVariant* value) {
	const gchar* _tmp0_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	kkc_engine_apply_preferences (self);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "dictionaries") == 0) {
		KkcContext* _tmp1_;
		KkcDictionaryList* _tmp2_;
		KkcDictionaryList* _tmp3_;
		_tmp1_ = self->priv->context;
		_tmp2_ = kkc_context_get_dictionaries (_tmp1_);
		_tmp3_ = _tmp2_;
		kkc_dictionary_list_clear (_tmp3_);
		{
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			GeeArrayList* _dictionary_list;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _dictionary_size;
			gint _dictionary_index;
			_tmp4_ = kkc_engine_dictionaries;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_dictionary_list = _tmp5_;
			_tmp6_ = _dictionary_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_dictionary_size = _tmp8_;
			_dictionary_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_ = NULL;
				KkcDictionary* dictionary;
				KkcContext* _tmp15_;
				KkcDictionaryList* _tmp16_;
				KkcDictionaryList* _tmp17_;
				KkcDictionary* _tmp18_;
				_tmp9_ = _dictionary_index;
				_dictionary_index = _tmp9_ + 1;
				_tmp10_ = _dictionary_index;
				_tmp11_ = _dictionary_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _dictionary_list;
				_tmp13_ = _dictionary_index;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
				dictionary = (KkcDictionary*) _tmp14_;
				_tmp15_ = self->priv->context;
				_tmp16_ = kkc_context_get_dictionaries (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = dictionary;
				kkc_dictionary_list_add (_tmp17_, _tmp18_);
				_g_object_unref0 (dictionary);
			}
			_g_object_unref0 (_dictionary_list);
		}
	}
}


static void __kkc_engine___lambda5__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self) {
	_kkc_engine___lambda5_ (self, name, value);
}


static void _kkc_engine___lambda6_ (KkcEngine* self) {
	kkc_engine_update_preedit (self);
}


static void __kkc_engine___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_kkc_engine___lambda6_ (self);
}


static void _kkc_engine___lambda7_ (KkcEngine* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	kkc_engine_update_input_mode (self);
}


static void __kkc_engine___lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_kkc_engine___lambda7_ (self, _sender, pspec);
}


static void _kkc_engine___lambda8_ (KkcEngine* self) {
	kkc_engine_populate_lookup_table (self);
}


static void __kkc_engine___lambda8__kkc_candidate_list_populated (KkcCandidateList* _sender, gpointer self) {
	_kkc_engine___lambda8_ (self);
}


static void _kkc_engine___lambda9_ (KkcEngine* self) {
	kkc_engine_set_lookup_table_cursor_pos (self);
}


static void __kkc_engine___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_kkc_engine___lambda9_ (self);
}


static void _kkc_engine___lambda10_ (KkcEngine* self) {
	gboolean _tmp0_;
	_tmp0_ = self->priv->lookup_table_visible;
	if (_tmp0_) {
		ibus_engine_hide_lookup_table ((IBusEngine*) self);
		ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
		self->priv->lookup_table_visible = FALSE;
	}
}


static void __kkc_engine___lambda10__kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self) {
	_kkc_engine___lambda10_ (self);
}


static void _kkc_engine___lambda11_ (KkcEngine* self, KkcContext* e) {
	GtkClipboard* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = self->priv->clipboard;
	gtk_clipboard_request_text (_tmp0_, (GtkClipboardTextReceivedFunc) kkc_engine_set_selection_text, self);
}


static void __kkc_engine___lambda11__kkc_context_request_selection_text (KkcContext* _sender, gpointer self) {
	_kkc_engine___lambda11_ (self, _sender);
}


static GObject * kkc_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	KkcEngine * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	IBusLookupTable* _tmp1_;
	IBusPropList* _tmp14_;
	IBusPropList* _tmp15_;
	IBusPropList* props;
	IBusProperty* prop = NULL;
	const gchar* _tmp16_ = NULL;
	IBusProperty* _tmp17_ = NULL;
	IBusPropList* _tmp18_;
	IBusProperty* _tmp19_;
	const gchar* _tmp20_ = NULL;
	IBusProperty* _tmp21_ = NULL;
	IBusPropList* _tmp22_;
	IBusProperty* _tmp23_;
	const gchar* _tmp24_ = NULL;
	IBusProperty* _tmp25_ = NULL;
	IBusPropList* _tmp26_;
	IBusProperty* _tmp27_;
	const gchar* _tmp28_ = NULL;
	IBusProperty* _tmp29_ = NULL;
	IBusPropList* _tmp30_;
	IBusProperty* _tmp31_;
	const gchar* _tmp32_ = NULL;
	IBusProperty* _tmp33_ = NULL;
	IBusPropList* _tmp34_;
	IBusProperty* _tmp35_;
	const gchar* _tmp36_ = NULL;
	IBusProperty* _tmp37_ = NULL;
	IBusPropList* _tmp38_;
	IBusProperty* _tmp39_;
	IBusText* _tmp40_;
	IBusText* _tmp41_;
	const gchar* _tmp42_ = NULL;
	IBusText* _tmp43_;
	IBusText* _tmp44_;
	IBusPropList* _tmp45_;
	IBusProperty* _tmp46_;
	IBusPropList* _tmp47_;
	IBusProperty* _tmp48_;
	IBusProperty* _tmp49_;
	IBusProperty* _tmp50_;
	const gchar* _tmp51_ = NULL;
	IBusText* _tmp52_;
	IBusText* _tmp53_;
	const gchar* _tmp54_ = NULL;
	IBusText* _tmp55_;
	IBusText* _tmp56_;
	IBusProperty* _tmp57_;
	IBusPropList* _tmp58_;
	IBusProperty* _tmp59_;
	KkcLanguageModel* _tmp60_;
	KkcContext* _tmp61_;
	Preferences* _tmp77_;
	KkcContext* _tmp78_;
	KkcContext* _tmp79_;
	KkcContext* _tmp80_;
	KkcCandidateList* _tmp81_;
	KkcCandidateList* _tmp82_;
	KkcContext* _tmp83_;
	KkcCandidateList* _tmp84_;
	KkcCandidateList* _tmp85_;
	KkcContext* _tmp86_;
	KkcCandidateList* _tmp87_;
	KkcCandidateList* _tmp88_;
	GtkClipboard* _tmp89_ = NULL;
	GtkClipboard* _tmp90_;
	KkcContext* _tmp91_;
	parent_class = G_OBJECT_CLASS (kkc_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KKC_ENGINE, KkcEngine);
	_tmp0_ = self->priv->LOOKUP_TABLE_LABELS;
	_tmp0__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
	_tmp1_ = ibus_lookup_table_new ((guint) _tmp0__length1, (guint) 0, TRUE, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->lookup_table);
	self->priv->lookup_table = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gchar** _tmp6_;
				gint _tmp6__length1;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				const gchar* _tmp9_;
				IBusText* _tmp10_;
				IBusText* text;
				IBusLookupTable* _tmp11_;
				gint _tmp12_;
				IBusText* _tmp13_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp6__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp7__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				_tmp10_ = ibus_text_new_from_string (_tmp9_);
				g_object_ref_sink (_tmp10_);
				text = _tmp10_;
				_tmp11_ = self->priv->lookup_table;
				_tmp12_ = i;
				_tmp13_ = text;
				ibus_lookup_table_set_label (_tmp11_, (guint) _tmp12_, _tmp13_);
				_g_object_unref0 (text);
			}
		}
	}
	_tmp14_ = ibus_prop_list_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->prop_list);
	self->priv->prop_list = _tmp14_;
	_tmp15_ = ibus_prop_list_new ();
	g_object_ref_sink (_tmp15_);
	props = _tmp15_;
	_tmp16_ = _ ("Hiragana");
	_tmp17_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_HIRAGANA, "InputMode.Hiragana", _tmp16_, "あ");
	_g_object_unref0 (prop);
	prop = _tmp17_;
	_tmp18_ = props;
	_tmp19_ = prop;
	ibus_prop_list_append (_tmp18_, _tmp19_);
	_tmp20_ = _ ("Katakana");
	_tmp21_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_KATAKANA, "InputMode.Katakana", _tmp20_, "ア");
	_g_object_unref0 (prop);
	prop = _tmp21_;
	_tmp22_ = props;
	_tmp23_ = prop;
	ibus_prop_list_append (_tmp22_, _tmp23_);
	_tmp24_ = _ ("Halfwidth Katakana");
	_tmp25_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_HANKAKU_KATAKANA, "InputMode.HankakuKatakana", _tmp24_, "_ｱ");
	_g_object_unref0 (prop);
	prop = _tmp25_;
	_tmp26_ = props;
	_tmp27_ = prop;
	ibus_prop_list_append (_tmp26_, _tmp27_);
	_tmp28_ = _ ("Latin");
	_tmp29_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_LATIN, "InputMode.Latin", _tmp28_, "_A");
	_g_object_unref0 (prop);
	prop = _tmp29_;
	_tmp30_ = props;
	_tmp31_ = prop;
	ibus_prop_list_append (_tmp30_, _tmp31_);
	_tmp32_ = _ ("Wide Latin");
	_tmp33_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_WIDE_LATIN, "InputMode.WideLatin", _tmp32_, "Ａ");
	_g_object_unref0 (prop);
	prop = _tmp33_;
	_tmp34_ = props;
	_tmp35_ = prop;
	ibus_prop_list_append (_tmp34_, _tmp35_);
	_tmp36_ = _ ("Direct Input");
	_tmp37_ = kkc_engine_register_input_mode_property (self, KKC_INPUT_MODE_DIRECT, "InputMode.Direct", _tmp36_, "_A");
	_g_object_unref0 (prop);
	prop = _tmp37_;
	_tmp38_ = props;
	_tmp39_ = prop;
	ibus_prop_list_append (_tmp38_, _tmp39_);
	_tmp40_ = ibus_text_new_from_string ("あ");
	g_object_ref_sink (_tmp40_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _ ("Switch input mode");
	_tmp43_ = ibus_text_new_from_string (_tmp42_);
	g_object_ref_sink (_tmp43_);
	_tmp44_ = _tmp43_;
	_tmp45_ = props;
	_tmp46_ = ibus_property_new ("InputMode", PROP_TYPE_MENU, _tmp41_, NULL, _tmp44_, TRUE, TRUE, PROP_STATE_UNCHECKED, _tmp45_);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (prop);
	prop = _tmp46_;
	_g_object_unref0 (_tmp44_);
	_g_object_unref0 (_tmp41_);
	_tmp47_ = self->priv->prop_list;
	_tmp48_ = prop;
	ibus_prop_list_append (_tmp47_, _tmp48_);
	_tmp49_ = prop;
	_tmp50_ = _g_object_ref0 (_tmp49_);
	_g_object_unref0 (self->priv->input_mode_prop);
	self->priv->input_mode_prop = _tmp50_;
	_tmp51_ = _ ("Setup");
	_tmp52_ = ibus_text_new_from_string (_tmp51_);
	g_object_ref_sink (_tmp52_);
	_tmp53_ = _tmp52_;
	_tmp54_ = _ ("Configure KKC");
	_tmp55_ = ibus_text_new_from_string (_tmp54_);
	g_object_ref_sink (_tmp55_);
	_tmp56_ = _tmp55_;
	_tmp57_ = ibus_property_new ("setup", PROP_TYPE_NORMAL, _tmp53_, "gtk-preferences", _tmp56_, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (prop);
	prop = _tmp57_;
	_g_object_unref0 (_tmp56_);
	_g_object_unref0 (_tmp53_);
	_tmp58_ = self->priv->prop_list;
	_tmp59_ = prop;
	ibus_prop_list_append (_tmp58_, _tmp59_);
	_tmp60_ = kkc_engine_language_model;
	_tmp61_ = kkc_context_new (_tmp60_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp61_;
	{
		GeeArrayList* _tmp62_;
		GeeArrayList* _tmp63_;
		GeeArrayList* _dictionary_list;
		GeeArrayList* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gint _dictionary_size;
		gint _dictionary_index;
		_tmp62_ = kkc_engine_dictionaries;
		_tmp63_ = _g_object_ref0 (_tmp62_);
		_dictionary_list = _tmp63_;
		_tmp64_ = _dictionary_list;
		_tmp65_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp64_);
		_tmp66_ = _tmp65_;
		_dictionary_size = _tmp66_;
		_dictionary_index = -1;
		while (TRUE) {
			gint _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			GeeArrayList* _tmp70_;
			gint _tmp71_;
			gpointer _tmp72_ = NULL;
			KkcDictionary* dictionary;
			KkcContext* _tmp73_;
			KkcDictionaryList* _tmp74_;
			KkcDictionaryList* _tmp75_;
			KkcDictionary* _tmp76_;
			_tmp67_ = _dictionary_index;
			_dictionary_index = _tmp67_ + 1;
			_tmp68_ = _dictionary_index;
			_tmp69_ = _dictionary_size;
			if (!(_tmp68_ < _tmp69_)) {
				break;
			}
			_tmp70_ = _dictionary_list;
			_tmp71_ = _dictionary_index;
			_tmp72_ = gee_abstract_list_get ((GeeAbstractList*) _tmp70_, _tmp71_);
			dictionary = (KkcDictionary*) _tmp72_;
			_tmp73_ = self->priv->context;
			_tmp74_ = kkc_context_get_dictionaries (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = dictionary;
			kkc_dictionary_list_add (_tmp75_, _tmp76_);
			_g_object_unref0 (dictionary);
		}
		_g_object_unref0 (_dictionary_list);
	}
	kkc_engine_apply_preferences (self);
	_tmp77_ = kkc_engine_preferences;
	g_signal_connect_object (_tmp77_, "value-changed", (GCallback) __kkc_engine___lambda5__preferences_value_changed, self, 0);
	_tmp78_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp78_, "notify::input", (GCallback) __kkc_engine___lambda6__g_object_notify, self, 0);
	_tmp79_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp79_, "notify::input-mode", (GCallback) __kkc_engine___lambda7__g_object_notify, self, 0);
	_tmp80_ = self->priv->context;
	_tmp81_ = kkc_context_get_candidates (_tmp80_);
	_tmp82_ = _tmp81_;
	g_signal_connect_object (_tmp82_, "populated", (GCallback) __kkc_engine___lambda8__kkc_candidate_list_populated, self, 0);
	_tmp83_ = self->priv->context;
	_tmp84_ = kkc_context_get_candidates (_tmp83_);
	_tmp85_ = _tmp84_;
	g_signal_connect_object ((GObject*) _tmp85_, "notify::cursor-pos", (GCallback) __kkc_engine___lambda9__g_object_notify, self, 0);
	_tmp86_ = self->priv->context;
	_tmp87_ = kkc_context_get_candidates (_tmp86_);
	_tmp88_ = _tmp87_;
	g_signal_connect_object (_tmp88_, "selected", (GCallback) __kkc_engine___lambda10__kkc_candidate_list_selected, self, 0);
	_tmp89_ = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
	_tmp90_ = _g_object_ref0 (_tmp89_);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->clipboard = _tmp90_;
	_tmp91_ = self->priv->context;
	g_signal_connect_object (_tmp91_, "request-selection-text", (GCallback) __kkc_engine___lambda11__kkc_context_request_selection_text, self, 0);
	kkc_engine_update_candidates (self);
	kkc_engine_update_input_mode (self);
	_g_object_unref0 (prop);
	_g_object_unref0 (props);
	return obj;
}


static KkcEngineKeyEntry* kkc_engine_key_entry_dup (const KkcEngineKeyEntry* self) {
	KkcEngineKeyEntry* dup;
	dup = g_new0 (KkcEngineKeyEntry, 1);
	memcpy (dup, self, sizeof (KkcEngineKeyEntry));
	return dup;
}


static void kkc_engine_key_entry_free (KkcEngineKeyEntry* self) {
	g_free (self);
}


static GType kkc_engine_key_entry_get_type (void) {
	static volatile gsize kkc_engine_key_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_engine_key_entry_type_id__volatile)) {
		GType kkc_engine_key_entry_type_id;
		kkc_engine_key_entry_type_id = g_boxed_type_register_static ("KkcEngineKeyEntry", (GBoxedCopyFunc) kkc_engine_key_entry_dup, (GBoxedFreeFunc) kkc_engine_key_entry_free);
		g_once_init_leave (&kkc_engine_key_entry_type_id__volatile, kkc_engine_key_entry_type_id);
	}
	return kkc_engine_key_entry_type_id__volatile;
}


static void kkc_engine_class_init (KkcEngineClass * klass) {
	kkc_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcEnginePrivate));
	IBUS_ENGINE_CLASS (klass)->process_key_event = kkc_engine_real_process_key_event;
	IBUS_ENGINE_CLASS (klass)->enable = kkc_engine_real_enable;
	IBUS_ENGINE_CLASS (klass)->disable = kkc_engine_real_disable;
	IBUS_ENGINE_CLASS (klass)->reset = kkc_engine_real_reset;
	IBUS_ENGINE_CLASS (klass)->focus_in = kkc_engine_real_focus_in;
	IBUS_ENGINE_CLASS (klass)->focus_out = kkc_engine_real_focus_out;
	IBUS_ENGINE_CLASS (klass)->property_activate = kkc_engine_real_property_activate;
	IBUS_ENGINE_CLASS (klass)->candidate_clicked = kkc_engine_real_candidate_clicked;
	IBUS_ENGINE_CLASS (klass)->cursor_up = kkc_engine_real_cursor_up;
	IBUS_ENGINE_CLASS (klass)->cursor_down = kkc_engine_real_cursor_down;
	IBUS_ENGINE_CLASS (klass)->page_up = kkc_engine_real_page_up;
	IBUS_ENGINE_CLASS (klass)->page_down = kkc_engine_real_page_down;
	G_OBJECT_CLASS (klass)->constructor = kkc_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = kkc_engine_finalize;
}


static void kkc_engine_instance_init (KkcEngine * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_ = NULL;
	self->priv = KKC_ENGINE_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (KKC_TYPE_INPUT_MODE, NULL, NULL, IBUS_TYPE_PROPERTY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->input_mode_props = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (KKC_TYPE_INPUT_MODE, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	self->priv->input_mode_symbols = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, KKC_TYPE_INPUT_MODE, NULL, NULL, NULL, NULL, NULL);
	self->priv->name_input_modes = (GeeMap*) _tmp2_;
	_tmp3_ = g_strdup ("1");
	_tmp4_ = g_strdup ("2");
	_tmp5_ = g_strdup ("3");
	_tmp6_ = g_strdup ("4");
	_tmp7_ = g_strdup ("5");
	_tmp8_ = g_strdup ("6");
	_tmp9_ = g_strdup ("7");
	_tmp10_ = g_strdup ("8");
	_tmp11_ = g_strdup ("9");
	_tmp12_ = g_strdup ("0");
	_tmp13_ = g_strdup ("a");
	_tmp14_ = g_strdup ("b");
	_tmp15_ = g_strdup ("c");
	_tmp16_ = g_strdup ("d");
	_tmp17_ = g_strdup ("e");
	_tmp18_ = g_new0 (gchar*, 15 + 1);
	_tmp18_[0] = _tmp3_;
	_tmp18_[1] = _tmp4_;
	_tmp18_[2] = _tmp5_;
	_tmp18_[3] = _tmp6_;
	_tmp18_[4] = _tmp7_;
	_tmp18_[5] = _tmp8_;
	_tmp18_[6] = _tmp9_;
	_tmp18_[7] = _tmp10_;
	_tmp18_[8] = _tmp11_;
	_tmp18_[9] = _tmp12_;
	_tmp18_[10] = _tmp13_;
	_tmp18_[11] = _tmp14_;
	_tmp18_[12] = _tmp15_;
	_tmp18_[13] = _tmp16_;
	_tmp18_[14] = _tmp17_;
	self->priv->LOOKUP_TABLE_LABELS = _tmp18_;
	self->priv->LOOKUP_TABLE_LABELS_length1 = 15;
	self->priv->_LOOKUP_TABLE_LABELS_size_ = self->priv->LOOKUP_TABLE_LABELS_length1;
	self->priv->save_dictionaries_timeout_id = (guint) 0;
}


static void kkc_engine_finalize (GObject* obj) {
	KkcEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KKC_ENGINE, KkcEngine);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->lookup_table);
	_g_object_unref0 (self->priv->keymap);
	_g_object_unref0 (self->priv->input_mode_prop);
	_g_object_unref0 (self->priv->prop_list);
	_g_object_unref0 (self->priv->input_mode_props);
	_g_object_unref0 (self->priv->input_mode_symbols);
	_g_object_unref0 (self->priv->name_input_modes);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->LOOKUP_TABLE_LABELS = (_vala_array_free (self->priv->LOOKUP_TABLE_LABELS, self->priv->LOOKUP_TABLE_LABELS_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (kkc_engine_parent_class)->finalize (obj);
}


GType kkc_engine_get_type (void) {
	static volatile gsize kkc_engine_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcEngine), 0, (GInstanceInitFunc) kkc_engine_instance_init, NULL };
		GType kkc_engine_type_id;
		kkc_engine_type_id = g_type_register_static (IBUS_TYPE_ENGINE, "KkcEngine", &g_define_type_info, 0);
		g_once_init_leave (&kkc_engine_type_id__volatile, kkc_engine_type_id);
	}
	return kkc_engine_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



