---
layout: page
title: Other English Dictionaries
---
There are many different speller dictionaries available for English.
This page is an attempt to keep track of them all.

Please help keep this page up to date.  This site is included in the
Git repository for SCOWL, so the easiest way to contribute is to fork,
[edit this file](https://github.com/kevina/wordlist/edit/master/site/other-dicts.md), 
and then submit a pull request.  You can also just
email me any corrections or additions.

# American (en_US) #

## Official ##

* <http://wordlist.aspell.net/dicts>
* Kevin Atkinson
* Based on SCOWL
* License: BSD/MIT-Like
* Last Updated: 2012

## Alternative ##

* <http://qa.openoffice.org/issues/show_bug.cgi?id=92383>
* David Dibble
* License: GPLv3
* Last Updated: 2011

An alternative dictionary by David Dibble was submitted as a bug report to Open Office. It is "an alternative for writers or business
professionals who don't want to look like idiots".  It leaves out words like 
"alright", which makes it well suited for professional writing, but ill-suited as a general purpose dictionary.

## Others ##

Mozilla included American dictionary is based on the official one but contains several additional changes, including a list of suggested new words from Google that has been edited to remove junk.

A version with some minor changes by László Németh (Hunspell author) is included in Open Office.

Google chrome includes a very old version, but is enhanced with several new terms.  This list contains a fair amount of junk also (such as http instead of HTTP, etc.).

# British (en_GB and en_GB-oed) #

## Official ##

* <http://en-gb.pyxidium.co.uk/index.php>
* David Bartlett
* License: LGPL
* Last Updated: 2006

The dictionary was initially based on an old SCOWL version.  Since then it has been extensively updated by David Bartlett, Brian Kelk and Andrew Brown:

* numerous Americanism have been removed
* numerous American spellings have been corrected
* missing words have been added
* many errors have been corrected
* compound hyphenated words have been added where appropriate

The latest release on the web page is R 1.18 even though R 1.20 is suppose to be available.

An Oxford spelling (en_GB-oed) version is also provided which follows the spelling preferred by the (Concise) Oxford English Dictionary.

## Fork of Official ##

* <http://marcoagpinto.cidadevirtual.pt/proofingtoolgui.html>
* Marco A.G.Pinto
* License: LGPL
* Last Update: 2014

## Alternative ##

* <http://wordlist.aspell.net/dicts>
* Kevin Atkinson
* Based on SCOWL
* License: BSD/MIT-Like
* Last Updated: 2012

Since SCOWL was forked in David Bartlett version, it has undergone numerous corrections and should now be fairly accurate.  David Bartlett's en_GB dictionary includes both -ize and -ise forms, while with SCOWL it is possible to get one with just the -ise forms, it is also possible to have the option of including common variants or leaving them out to promote consistent spelling.  Furthermore, SCOWL 
is also a bit more up-to-date and includes words such as "blog" and "Google" (which where not in R 1.18).  However, the SCOWL version still likely includes some American only words and misses some British only words, and it includes some words such as "alright" which David Bartlett made a point to leave out.  Also David Bartlett version includes hyphenated words while SCOWL does not yet.

Since the official Aspell English dictionaries are generated from SCOWL, this is the version found in the official English dictionary for Aspell (which also includes American and Canadian options).

## Others ##

A version of David Bartlett list (based on R 1.20) with some minor changes by László Németh (Hunspell author) is included in Open Office.

# Canadian (en_CA) #

## Offical ##

* <http://wordlist.aspell.net/dicts>
* Kevin Atkinson
* Based on SCOWL
* License: BSD/MIT-Like
* Last Updated: 2012

## Others ##

A [Firefox extension](http://addons.mozilla.org/en-US/firefox/addon/3653/) is available by Paul Schmiedge 
based on the official SCOWL version but with some additional corrections.

A version with some minor changes by László Németh (Hunspell author) is included in Open Office.

# Australian (en_AU) #

## Official? ##

* <http://wiki.services.openoffice.org/wiki/Australian-English_Spelling_Dictionary>
* David Wilson
* Last Updated: 2008
* License: LGPL?

## Others ##

There was a version at www.JustLocal.com.au under a Free license.  However, the author pulled that version.  I belive there is a non-free one still available.

# New Zealand (en_NZ) #

## Official? ##

* <http://extensions.services.openoffice.org/en/project/dict-en-nz-2008-12-03>
* Tristan Burtenshaw
* Last Updated: 2003?
* License: LGPL

Extension above looks like it just repackaged 2003 OpenOffice en_NZ dictionary.

# South African (en_ZA) #

## Official ##

* <http://translate.org.za/content/view/23/54/lang,en-za/>
* Dwayne Bailey
* Based on David Bartlett British English Dictionary
* Last Updated: 2009

# Other #

## Chemistry ##

* <http://extensions.services.openoffice.org/en/project/ChemDictOOo>
* Adam M. Azman
* License: CC BY 3.0
* Last Updated: 2011
