/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.matcher;

import org.jmock.core.Invocation;
import org.jmock.core.matcher.InvokedRecorder;

public class InvokeCountMatcher
extends InvokedRecorder {
    private int expectedCount;

    public InvokeCountMatcher(int expectedCount) {
        this.expectedCount = expectedCount;
    }

    public boolean matches(Invocation invocation) {
        return this.getInvocationCount() < this.expectedCount;
    }

    public void verify() {
        this.verifyHasBeenInvokedExactly(this.expectedCount);
    }

    public boolean hasDescription() {
        return true;
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        return buffer.append("expected ").append(this.expectedCount).append(" times, invoked ").append(this.getInvocationCount()).append(" times");
    }
}

