/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jmock.core.Constraint;
import org.jmock.util.PropertyUtil;

public class HasPropertyWithValue
implements Constraint {
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private String propertyName;
    private Constraint expectation;

    public HasPropertyWithValue(String propertyName, Constraint expectation) {
        this.propertyName = propertyName;
        this.expectation = expectation;
    }

    public boolean eval(Object argument) {
        try {
            Method readMethod = this.getReadMethod(argument);
            return readMethod != null && this.expectation.eval(readMethod.invoke(argument, NO_ARGUMENTS));
        }
        catch (IntrospectionException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    private Method getReadMethod(Object argument) throws IntrospectionException {
        PropertyDescriptor property = PropertyUtil.getPropertyDescriptor(this.propertyName, argument);
        return property == null ? null : property.getReadMethod();
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        buffer.append("hasProperty(\"");
        buffer.append(this.propertyName);
        buffer.append("\", ");
        this.expectation.describeTo(buffer);
        buffer.append(")");
        return buffer;
    }
}

