/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.Wildcard;
import com.tonicsystems.jarjar.Zap;
import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZapProcessor
implements JarProcessor {
    private List<Wildcard> wildcards;

    public ZapProcessor(List<Zap> zapList) {
        this.wildcards = PatternElement.createWildcards(zapList);
    }

    @Override
    public boolean process(EntryStruct struct) throws IOException {
        String name = struct.name;
        if (name.endsWith(".class")) {
            return !this.zap(name.substring(0, name.length() - 6));
        }
        return true;
    }

    private boolean zap(String desc) {
        for (Wildcard wildcard : this.wildcards) {
            if (!wildcard.matches(desc)) continue;
            return true;
        }
        return false;
    }
}

