/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.ext_util;

import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.IoUtil;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.zip.JarMarker;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipOutputStream;

public abstract class AntJarProcessor
extends Jar {
    private EntryStruct struct = new EntryStruct();
    private JarProcessor proc;
    private byte[] buf = new byte[8192];
    private Set<String> dirs = new HashSet<String>();
    private boolean filesOnly;
    protected boolean verbose;
    private static final ZipExtraField[] JAR_MARKER = new ZipExtraField[]{JarMarker.getInstance()};

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public abstract void execute() throws BuildException;

    public void execute(JarProcessor proc) throws BuildException {
        this.proc = proc;
        super.execute();
    }

    public void setFilesonly(boolean f) {
        super.setFilesonly(f);
        this.filesOnly = f;
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode) throws IOException {
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtil.pipe(is, baos, this.buf);
        this.struct.data = baos.toByteArray();
        this.struct.name = vPath;
        this.struct.time = lastModified;
        if (this.proc.process(this.struct)) {
            if (mode == 0) {
                mode = 33188;
            }
            if (!this.filesOnly) {
                this.addParentDirs(this.struct.name, zOut);
            }
            super.zipFile((InputStream)new ByteArrayInputStream(this.struct.data), zOut, this.struct.name, this.struct.time, fromArchive, mode);
        }
    }

    private void addParentDirs(String file, ZipOutputStream zOut) throws IOException {
        String dir;
        int slash = file.lastIndexOf(47);
        if (slash >= 0 && this.dirs.add(dir = file.substring(0, slash))) {
            this.addParentDirs(dir, zOut);
            super.zipDir((File)null, zOut, dir + "/", 16877, JAR_MARKER);
        }
    }

    public void reset() {
        super.reset();
        this.cleanHelper();
    }

    protected void cleanUp() {
        super.cleanUp();
        this.cleanHelper();
    }

    protected void cleanHelper() {
        this.verbose = false;
        this.filesOnly = false;
        this.dirs.clear();
    }
}

