export default class FakeSchemaData {
  static getLogAnalyticsFakeSchema() {
    return {
      Tables: [
        {
          TableName: 'Table_0',
          Columns: [
            {
              ColumnName: 'TableName',
              DataType: 'String',
            },
            {
              ColumnName: 'ColumnName',
              DataType: 'String',
            },
            {
              ColumnName: 'ColumnType',
              DataType: 'String',
            },
          ],
          Rows: [
            ['AzureNetworkAnalytics_CL', 'SourceSystem', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'ManagementGroupName', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'TimeGenerated', 'System.DateTime'],
            ['AzureNetworkAnalytics_CL', 'Computer', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'FASchemaVersion_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'FlowType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SrcIP_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'DestIP_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VMIP_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'L4Protocol_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'L7Protocol_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'FlowDirection_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'NSGList_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'NSGRules_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'HopNSGList_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'HopNSGRules_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Region1_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Region2_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'NIC_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'NIC1_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'NIC2_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VM_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VM1_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VM2_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Subnet_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'ConnectionName_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'S2SConnection_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'S2SConnectionType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Country_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'AzureRegion_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Subscription1_g', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Subscription2_g', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'FlowStartTime_t', 'System.DateTime'],
            ['AzureNetworkAnalytics_CL', 'FlowEndTime_t', 'System.DateTime'],
            ['AzureNetworkAnalytics_CL', 'DestPort_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'AllowedInFlows_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'DeniedInFlows_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'AllowedOutFlows_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'DeniedOutFlows_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'DeniedInFlowsAtHops_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'DeniedOutFlowsAtHops_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'FlowCount_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'NextHopIP_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'IsVirtualAppliance_b', 'System.Boolean'],
            ['AzureNetworkAnalytics_CL', 'AddressPrefix_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'NextHopType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'RouteTable_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Subnet1_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Subnet2_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SubnetRegion1_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SubnetRegion2_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualAppliances_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'AllowForwardedTraffic_b', 'System.Boolean'],
            ['AzureNetworkAnalytics_CL', 'AllowGatewayTransit_b', 'System.Boolean'],
            ['AzureNetworkAnalytics_CL', 'AllowVirtualNetworkAccess_b', 'System.Boolean'],
            ['AzureNetworkAnalytics_CL', 'UseRemoteGateways_b', 'System.Boolean'],
            ['AzureNetworkAnalytics_CL', 'NSG_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'PrivateIPAddresses_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'PublicIPAddresses_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Subnetwork_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualMachine_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'MACAddress_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'AddressPrefixes_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'ConnectingVirtualNetwork_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'RemoteVirtualNetworkGateway_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'IsFlowEnabled_b', 'System.Boolean'],
            ['AzureNetworkAnalytics_CL', 'GatewayType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SKU_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VIPAddress_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualSubnetwork_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'BGPEnabled_b', 'System.Boolean'],
            ['AzureNetworkAnalytics_CL', 'ConnectionStatus_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'ConnectionType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'GatewayConnectionType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'LocalNetworkGateway_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualNetwork1_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualNetwork2_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualNetworkGateway1_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualNetworkGateway2_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualNetworkRegion1_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'VirtualNetworkRegion2_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'EgressBytesTransferred_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'IngressBytesTransferred_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'RoutingWeight_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'FrontendSubnet_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'LoadBalancerType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Access_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Description_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'DestinationAddressPrefix_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'DestinationPortRange_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Direction_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Protocol_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'RuleType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SourceAddressPrefix_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SourcePortRange_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Priority_d', 'System.Double'],
            ['AzureNetworkAnalytics_CL', 'IPAddress', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SubnetPrefixes_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SchemaVersion_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Name_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Region_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'AppGatewayType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'BackendSubnets_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'FrontendIPs_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'GatewaySubnet_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'ComponentType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'DiscoveryRegion_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'ResourceType', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Status_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'SubType_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'TopologyVersion_s', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'Subscription_g', 'System.String'],
            ['AzureNetworkAnalytics_CL', 'TimeProcessed_t', 'System.DateTime'],
            ['AzureNetworkAnalytics_CL', 'Type', 'System.String'],
          ],
          KqlPrimaryTimestampColumnName: 'TimeGenerated',
        },
        {
          TableName: 'Table_1',
          Columns: [
            {
              ColumnName: 'TableType',
              DataType: 'String',
            },
            {
              ColumnName: 'TableName',
              DataType: 'String',
            },
            {
              ColumnName: 'PrimaryTimestampColumnName',
              DataType: 'String',
            },
            {
              ColumnName: 'Solutions',
              DataType: 'String',
            },
          ],
          Rows: [['oms', 'AzureNetworkAnalytics_CL', 'TimeGenerated', 'LogManagement']],
        },
      ],
    };
  }

  static getlogAnalyticsFakeMetadata(): any {
    return {
      tables: [
        {
          id: 't/Alert',
          name: 'Alert',
          timespanColumn: 'TimeGenerated',
          columns: [
            { name: 'TimeGenerated', type: 'datetime' },
            { name: 'AlertSeverity', type: 'string' },
            { name: 'SourceDisplayName', type: 'string' },
            { name: 'AlertName', type: 'string' },
            { name: 'AlertDescription', type: 'string' },
            { name: 'SourceSystem', type: 'string' },
            { name: 'QueryExecutionStartTime', type: 'datetime' },
            { name: 'QueryExecutionEndTime', type: 'datetime' },
            { name: 'Query', type: 'string' },
            { name: 'RemediationJobId', type: 'string' },
            { name: 'RemediationRunbookName', type: 'string' },
            { name: 'AlertRuleId', type: 'string' },
            { name: 'AlertRuleInstanceId', type: 'string' },
            { name: 'ThresholdOperator', type: 'string' },
            { name: 'ThresholdValue', type: 'int' },
            { name: 'LinkToSearchResults', type: 'string' },
            { name: 'ServiceDeskConnectionName', type: 'string' },
            { name: 'ServiceDeskId', type: 'string' },
            { name: 'ServiceDeskWorkItemLink', type: 'string' },
            { name: 'ServiceDeskWorkItemType', type: 'string' },
            { name: 'ResourceId', type: 'string' },
            { name: 'ResourceType', type: 'string' },
            { name: 'ResourceValue', type: 'string' },
            { name: 'RootObjectName', type: 'string' },
            { name: 'ObjectDisplayName', type: 'string' },
            { name: 'Computer', type: 'string' },
            { name: 'AlertPriority', type: 'string' },
            { name: 'SourceFullName', type: 'string' },
            { name: 'AlertId', type: 'string' },
            { name: 'RepeatCount', type: 'int' },
            { name: 'AlertState', type: 'string' },
            { name: 'ResolvedBy', type: 'string' },
            { name: 'LastModifiedBy', type: 'string' },
            { name: 'TimeRaised', type: 'datetime' },
            { name: 'TimeResolved', type: 'datetime' },
            { name: 'TimeLastModified', type: 'datetime' },
            { name: 'AlertContext', type: 'string' },
            { name: 'TicketId', type: 'string' },
            { name: 'Custom1', type: 'string' },
            { name: 'Custom2', type: 'string' },
            { name: 'Custom3', type: 'string' },
            { name: 'Custom4', type: 'string' },
            { name: 'Custom5', type: 'string' },
            { name: 'Custom6', type: 'string' },
            { name: 'Custom7', type: 'string' },
            { name: 'Custom8', type: 'string' },
            { name: 'Custom9', type: 'string' },
            { name: 'Custom10', type: 'string' },
            { name: 'ManagementGroupName', type: 'string' },
            { name: 'PriorityNumber', type: 'int' },
            { name: 'HostName', type: 'string' },
            { name: 'StateType', type: 'string' },
            { name: 'AlertTypeDescription', type: 'string' },
            { name: 'AlertTypeNumber', type: 'int' },
            { name: 'AlertError', type: 'string' },
            { name: 'StatusDescription', type: 'string' },
            { name: 'AlertStatus', type: 'int' },
            { name: 'TriggerId', type: 'string' },
            { name: 'Url', type: 'string' },
            { name: 'ValueDescription', type: 'string' },
            { name: 'AlertValue', type: 'int' },
            { name: 'Comments', type: 'string' },
            { name: 'TemplateId', type: 'string' },
            { name: 'FlagsDescription', type: 'string' },
            { name: 'Flags', type: 'int' },
            { name: 'ValueFlagsDescription', type: 'string' },
            { name: 'ValueFlags', type: 'int' },
            { name: 'Expression', type: 'string' },
            { name: 'Type', type: 'string' },
          ],
        },
        {
          id: 't/AzureActivity',
          name: 'AzureActivity',
          timespanColumn: 'TimeGenerated',
          columns: [
            { name: 'OperationName', type: 'string' },
            { name: 'Level', type: 'string' },
            { name: 'ActivityStatus', type: 'string' },
            { name: 'ActivitySubstatus', type: 'string' },
            { name: 'ResourceGroup', type: 'string' },
            { name: 'SubscriptionId', type: 'string' },
            { name: 'CorrelationId', type: 'string' },
            { name: 'Caller', type: 'string' },
            { name: 'CallerIpAddress', type: 'string' },
            { name: 'Category', type: 'string' },
            { name: 'HTTPRequest', type: 'string' },
            { name: 'Properties', type: 'string' },
            { name: 'EventSubmissionTimestamp', type: 'datetime' },
            { name: 'Authorization', type: 'string' },
            { name: 'ResourceId', type: 'string' },
            { name: 'OperationId', type: 'string' },
            { name: 'ResourceProvider', type: 'string' },
            { name: 'Resource', type: 'string' },
            { name: 'TimeGenerated', type: 'datetime' },
            { name: 'SourceSystem', type: 'string' },
            { name: 'Type', type: 'string' },
          ],
        },
      ],
      tableGroups: [
        {
          id: 'oms/LogManagement',
          name: 'LogManagement',
          source: 'oms',
          tables: ['t/Alert', 't/AzureActivity'],
        },
      ],
      functions: [
        {
          id: 'f/Func1',
          name: 'Func1',
          displayName: 'Func1',
          body: 'AzureActivity\n| where ActivityStatus == "" \n',
          category: 'test',
        },
      ],
      applications: [],
      workspaces: [
        {
          id: 'a2c1b44e-3e57-4410-b027-999999999999',
          name: 'danieltest',
          resourceId:
            '/subscriptions/44693801-6ee6-49de-9b2d-999999999999/resourceGroups/danieltest/providers/' +
            'microsoft.operationalinsights/workspaces/danieltest',
          tables: [],
          tableGroups: ['oms/LogManagement'],
          functions: ['f/Func1'],
        },
      ],
    };
  }
}
