/*! For license information please see newtonsoft.json.min.js.LICENSE.txt */
Bridge.assembly("Newtonsoft.Json",(function($asm,globals){"use strict";Bridge.define("Newtonsoft.Json.DefaultValueHandling",{$kind:"enum",statics:{fields:{Include:0,Ignore:1,Populate:2,IgnoreAndPopulate:3}},$flags:!0}),Bridge.define("Newtonsoft.Json.Formatting",{$kind:"enum",statics:{fields:{None:0,Indented:1}}}),Bridge.define("Newtonsoft.Json.JsonConstructorAttribute",{inherits:[System.Attribute]}),Bridge.define("Newtonsoft.Json.JsonException",{inherits:[System.Exception],ctors:{ctor:function(){this.$initialize(),System.Exception.ctor.call(this)},$ctor1:function(e){this.$initialize(),System.Exception.ctor.call(this,e)},$ctor2:function(e,t){this.$initialize(),System.Exception.ctor.call(this,e,t)}}}),Bridge.define("Newtonsoft.Json.JsonIgnoreAttribute",{inherits:[System.Attribute]}),Bridge.define("Newtonsoft.Json.JsonPropertyAttribute",{inherits:[System.Attribute],fields:{_nullValueHandling:null,_defaultValueHandling:null,_objectCreationHandling:null,_typeNameHandling:null,_required:null,_order:null},props:{NullValueHandling:{get:function(){var e;return null!=(e=this._nullValueHandling)?e:0},set:function(e){this._nullValueHandling=e}},DefaultValueHandling:{get:function(){var e;return null!=(e=this._defaultValueHandling)?e:0},set:function(e){this._defaultValueHandling=e}},ObjectCreationHandling:{get:function(){var e;return null!=(e=this._objectCreationHandling)?e:0},set:function(e){this._objectCreationHandling=e}},TypeNameHandling:{get:function(){var e;return null!=(e=this._typeNameHandling)?e:0},set:function(e){this._typeNameHandling=e}},Required:{get:function(){var e;return null!=(e=this._required)?e:Newtonsoft.Json.Required.Default},set:function(e){this._required=e}},Order:{get:function(){var e;return null!=(e=this._order)?e:Bridge.getDefaultValue(System.Int32)},set:function(e){this._order=e}},PropertyName:null},ctors:{ctor:function(){this.$initialize(),System.Attribute.ctor.call(this)},$ctor1:function(e){this.$initialize(),System.Attribute.ctor.call(this),this.PropertyName=e}}}),Bridge.define("Newtonsoft.Json.JsonSerializerSettings",{statics:{fields:{DefaultNullValueHandling:0,DefaultTypeNameHandling:0},ctors:{init:function(){this.DefaultNullValueHandling=Newtonsoft.Json.NullValueHandling.Include,this.DefaultTypeNameHandling=Newtonsoft.Json.TypeNameHandling.None}}},fields:{_defaultValueHandling:null,_typeNameHandling:null,_nullValueHandling:null,_objectCreationHandling:null},props:{NullValueHandling:{get:function(){var e;return null!=(e=this._nullValueHandling)?e:Newtonsoft.Json.JsonSerializerSettings.DefaultNullValueHandling},set:function(e){this._nullValueHandling=e}},ObjectCreationHandling:{get:function(){var e;return null!=(e=this._objectCreationHandling)?e:0},set:function(e){this._objectCreationHandling=e}},DefaultValueHandling:{get:function(){var e;return null!=(e=this._defaultValueHandling)?e:0},set:function(e){this._defaultValueHandling=e}},TypeNameHandling:{get:function(){var e;return null!=(e=this._typeNameHandling)?e:Newtonsoft.Json.JsonSerializerSettings.DefaultTypeNameHandling},set:function(e){this._typeNameHandling=e}},ContractResolver:null,SerializationBinder:null}}),Bridge.define("Newtonsoft.Json.NullValueHandling",{$kind:"enum",statics:{fields:{Include:0,Ignore:1}}}),Bridge.define("Newtonsoft.Json.ObjectCreationHandling",{$kind:"enum",statics:{fields:{Auto:0,Reuse:1,Replace:2}}}),Bridge.define("Newtonsoft.Json.Required",{$kind:"enum",statics:{fields:{Default:0,AllowNull:1,Always:2,DisallowNull:3}}}),Bridge.define("Newtonsoft.Json.Serialization.IContractResolver",{$kind:"interface"}),Bridge.define("Newtonsoft.Json.Serialization.ISerializationBinder",{$kind:"interface"}),Bridge.define("Newtonsoft.Json.TypeNameHandling",{$kind:"enum",statics:{fields:{None:0,Objects:1,Arrays:2,All:3,Auto:4}},$flags:!0}),Bridge.define("Newtonsoft.Json.Utils.AssemblyVersion",{statics:{fields:{version:null,compiler:null},ctors:{init:function(){this.version="1.17.0",this.compiler="17.10.0"}}}}),Bridge.define("Newtonsoft.Json.JsonSerializationException",{inherits:[Newtonsoft.Json.JsonException],ctors:{ctor:function(){this.$initialize(),Newtonsoft.Json.JsonException.ctor.call(this)},$ctor1:function(e){this.$initialize(),Newtonsoft.Json.JsonException.$ctor1.call(this,e)},$ctor2:function(e,t){this.$initialize(),Newtonsoft.Json.JsonException.$ctor2.call(this,e,t)}}}),Bridge.define("Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver",{inherits:[Newtonsoft.Json.Serialization.IContractResolver]}),Bridge.define("Newtonsoft.Json.JsonConvert",{statics:{methods:{stringify:function(e,t,n){return t===Newtonsoft.Json.Formatting.Indented?JSON.stringify(e,null,"  "):JSON.stringify(e)},parse:function(value){try{return JSON.parse(value)}catch(e){if(e instanceof SyntaxError)try{return eval("("+value+")")}catch(e){throw new Newtonsoft.Json.JsonException(e.message)}throw new Newtonsoft.Json.JsonException(e.message)}},getEnumerableElementType:function(e){var t,n,o;if(System.String.startsWith(e.$$name,"System.Collections.Generic.IEnumerable"))t=e;else for(n=Bridge.Reflection.getInterfaces(e),o=0;o<n.length;o++)if(System.String.startsWith(n[o].$$name,"System.Collections.Generic.IEnumerable")){t=n[o];break}return t?Bridge.Reflection.getGenericArguments(t)[0]:null},validateReflectable:function(e){do{var t=e===System.Object||e===Object||e.$literal||"anonymous"===e.$kind,n=!Bridge.getMetadata(e);if(!t&&n)throw Bridge.$jsonGuard&&delete Bridge.$jsonGuard,new System.InvalidOperationException(Bridge.getTypeName(e)+" is not reflectable and cannot be serialized.");e=t?null:Bridge.Reflection.getBaseType(e)}while(!t&&null!=e)},defaultGuard:function(){Bridge.$jsonGuard&&Bridge.$jsonGuard.pop()},getValue:function(e,t){for(var n in t=t.toLowerCase(),e)if(n.toLowerCase()==t)return e[n]},getCacheByType:function(e){for(var t,n,o=0;o<Newtonsoft.Json.$cache.length;o++)if((t=Newtonsoft.Json.$cache[o]).type===e)return t;return n={type:e},Newtonsoft.Json.$cache.push(n),n},getMembers:function(e,t){var n,o,i=Newtonsoft.Json.JsonConvert.getCacheByType(e);return i[t]?i[t]:(n=Bridge.Reflection.getMembers(e,t,52),o=!1,n=n.map((function(e){var t=System.Attribute.getCustomAttributes(e,Newtonsoft.Json.JsonPropertyAttribute),n=System.Attribute.getCustomAttributes(e,System.ComponentModel.DefaultValueAttribute);return{member:e,attr:t&&t.length>0?t[0]:null,defaultValue:n&&n.length>0?n[0].Value:Bridge.getDefaultValue(e.rt)}})).filter((function(e){return!o&&e.attr&&e.attr.Order&&(o=!0),(e.attr||2===e.member.a)&&0===System.Attribute.getCustomAttributes(e.member,Newtonsoft.Json.JsonIgnoreAttribute).length})),o&&n.sort((function(e,t){return(e.attr&&e.attr.Order||0)-(t.attr&&t.attr.Order||0)})),i[t]=n,n)},preRawProcess:function(e,t,n,o){var i=e.attr,r=i&&null!=i._defaultValueHandling?i._defaultValueHandling:o.DefaultValueHandling,s=i&&i.Required;if(void 0===n&&(r===Newtonsoft.Json.DefaultValueHandling.Populate||r===Newtonsoft.Json.DefaultValueHandling.IgnoreAndPopulate)&&(n=e.defaultValue),(s===Newtonsoft.Json.Required.AllowNull||s===Newtonsoft.Json.Required.Always)&&void 0===n)throw new Newtonsoft.Json.JsonSerializationException("Required property '"+e.member.n+"' not found in JSON.");if(s===Newtonsoft.Json.Required.Always&&null===n)throw new Newtonsoft.Json.JsonSerializationException("Required property '"+e.member.n+"' expects a value but got null.");if(s===Newtonsoft.Json.Required.DisallowNull&&null===n)throw new Newtonsoft.Json.JsonSerializationException("Property '"+e.member.n+"' expects a value but got null.");return{value:n}},preProcess:function(e,t,n,o){var i=e.attr,r=i&&null!=i._defaultValueHandling?i._defaultValueHandling:o.DefaultValueHandling,s=i&&null!=i._nullValueHandling?i._nullValueHandling:o.NullValueHandling;if(null==n&&s===Newtonsoft.Json.NullValueHandling.Ignore)return!1;var l=Bridge.unbox(n,!0),a=e.defaultValue;return!(!(null==l||null==a&&!(null==l&&null==a))&&Bridge.equals(l,a)&&(r===Newtonsoft.Json.DefaultValueHandling.Ignore||r===Newtonsoft.Json.DefaultValueHandling.IgnoreAndPopulate))&&{value:n}},PopulateObject:function(e,t,n,o){var i,r,s,l,a,u;if(n=n||{},i=Bridge.getType(t),r="string"==typeof e?Newtonsoft.Json.JsonConvert.parse(e):e,i.$nullable&&(i=i.$nullableType),null!=r&&"object"==typeof r)if(Bridge.isArray(null,i)){if(void 0===r.length)return;for(v=0;v<r.length;v++)t.push(Newtonsoft.Json.JsonConvert.DeserializeObject(r[v],i.$elementType,n,!0))}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,i)){var f,m=System.Collections.Generic.Dictionary$2.getTypeParameters(i),g=m[0]||System.Object,y=m[1]||System.Object;if(Bridge.is(r,System.Collections.IDictionary))for(f=System.Linq.Enumerable.from(r.getKeys()).ToArray(),v=0;v<f.length;v++)s=f[v],t.setItem(Newtonsoft.Json.JsonConvert.DeserializeObject(s,g,n,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(r.get(s),y,n,!0),!1);else for(l in r)r.hasOwnProperty(l)&&t.setItem(Newtonsoft.Json.JsonConvert.DeserializeObject(l,g,n,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(r[l],y,n,!0),!1)}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IList,i)||Bridge.Reflection.isAssignableFrom(System.Collections.ICollection,i))for(a=System.Collections.Generic.List$1.getElementType(i)||System.Object,Bridge.isArray(r)||(r=r.ToArray?r.ToArray():Bridge.Collections.EnumerableHelpers.ToArray(a,r)),v=0;v<r.length;v++)t.add(Newtonsoft.Json.JsonConvert.DeserializeObject(r[v],a,n,!0));else{for(var d,c,S,J,p=n&&Bridge.is(n.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),N=Newtonsoft.Json.JsonConvert.getMembers(i,4),w=Newtonsoft.Json.JsonConvert.getMembers(i,16),v=0;v<N.length;v++)if(c=(d=N[v]).member,void 0===(e=r[J=d.attr&&d.attr.PropertyName||(p?c.n.charAt(0).toLowerCase()+c.n.substr(1):c.n)])&&(e=Newtonsoft.Json.JsonConvert.getValue(r,J)),void 0===(u=(o||r)[J])&&(u=Newtonsoft.Json.JsonConvert.getValue(o||r,J)),void 0!==(u=(b=Newtonsoft.Json.JsonConvert.preRawProcess(d,o||r,u,n)).value)){var b,C=null===e||!1===e||!0===e||"number"==typeof e||"string"==typeof e,B=Bridge.unbox(Bridge.Reflection.fieldAccess(c,t)),h=Newtonsoft.Json.JsonConvert.DeserializeObject(e,c.rt,n,!0);!1!==(b=Newtonsoft.Json.JsonConvert.preProcess(d,t,B,n))&&(B=b.value,C||null==B?Bridge.Reflection.fieldAccess(c,t,h):Newtonsoft.Json.JsonConvert.PopulateObject(h,B,n,e))}for(v=0;v<w.length;v++)S=(d=w[v]).member,void 0===(e=r[J=d.attr&&d.attr.PropertyName||(p?S.n.charAt(0).toLowerCase()+S.n.substr(1):S.n)])&&(e=Newtonsoft.Json.JsonConvert.getValue(r,J)),void 0===(u=(o||r)[J])&&(u=Newtonsoft.Json.JsonConvert.getValue(o||r,J)),void 0!==(u=(b=Newtonsoft.Json.JsonConvert.preRawProcess(d,o||r,u,n)).value)&&(C=null===e||!1===e||!0===e||"number"==typeof e||"string"==typeof e,B=Bridge.unbox(Bridge.Reflection.midel(S.g,t)()),h=Newtonsoft.Json.JsonConvert.DeserializeObject(e,S.rt,n,!0),!1!==(b=Newtonsoft.Json.JsonConvert.preProcess(d,t,B,n))&&(B=b.value,C||null==B?S.s?Bridge.Reflection.midel(S.s,t)(h):"anonymous"===type.$kind&&(t[S.n]=h):Newtonsoft.Json.JsonConvert.PopulateObject(h,B,n,e)))}},BindToName:function(e,t){if(e&&e.SerializationBinder&&e.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToName){var n={},o={};return e.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToName(t,n,o),o.v+(n.v?", "+n.v:"")}return Bridge.Reflection.getTypeQName(t)},BindToType:function(e,t,n){var o;if(e&&e.SerializationBinder&&e.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToType?(o=Newtonsoft.Json.JsonConvert.SplitFullyQualifiedTypeName(t),o=e.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToType(o.assemblyName,o.typeName)):o=Bridge.Reflection.getType(t),!o)throw new Newtonsoft.Json.JsonSerializationException("Type specified in JSON '"+t+"' was not resolved.");if(n&&!Bridge.Reflection.isAssignableFrom(n,o))throw new Newtonsoft.Json.JsonSerializationException("Type specified in JSON '"+Bridge.Reflection.getTypeQName(o)+"' is not compatible with '"+Bridge.Reflection.getTypeQName(n)+"'.");return o},SplitFullyQualifiedTypeName:function(e){var t,n,o=Newtonsoft.Json.JsonConvert.GetAssemblyDelimiterIndex(e);return null!=o?(t=Newtonsoft.Json.JsonConvert.Trim(e,0,System.Nullable.getValueOrDefault(o,0)),n=Newtonsoft.Json.JsonConvert.Trim(e,System.Nullable.getValueOrDefault(o,0)+1|0,(e.length-System.Nullable.getValueOrDefault(o,0)|0)-1|0)):(t=e,n=null),{typeName:t,assemblyName:n}},GetAssemblyDelimiterIndex:function(e){for(var t=0,n=0;n<e.length;n=n+1|0)switch(e.charCodeAt(n)){case 91:t=t+1|0;break;case 93:t=t-1|0;break;case 44:if(0===t)return n}return null},Trim:function(e,t,n){var o=(t+n|0)-1|0;if(o>=e.length)throw new System.ArgumentOutOfRangeException.$ctor1("length");for(;t<o&&System.Char.isWhiteSpace(String.fromCharCode(e.charCodeAt(t)));t=t+1|0);for(;o>=t&&System.Char.isWhiteSpace(String.fromCharCode(e.charCodeAt(o)));o=o-1|0);return e.substr(t,1+(o-t|0)|0)},SerializeObject:function(e,t,n,o,i,r){var s,l,a,u,f,m,g,y,d,c,S,J,p,N,w,v,b,C,B,h,T,$,D;if(Bridge.is(t,Newtonsoft.Json.JsonSerializerSettings)&&(n=t,t=0),null==e)return n&&n.NullValueHandling===Newtonsoft.Json.NullValueHandling.Ignore?void 0:o?null:Newtonsoft.Json.JsonConvert.stringify(null,t,n);if(s=Bridge.getType(e),i&&s&&("interface"===i.$kind||Bridge.Reflection.isAssignableFrom(i,s))&&(i=null),i&&i.$nullable&&(i=i.$nullableType),i&&i===System.Char)return String.fromCharCode(e);if(l=i||s,"function"==typeof e)return a=Bridge.getTypeName(e),o?a:Newtonsoft.Json.JsonConvert.stringify(a,t,n);if("object"==typeof e){if(m=Newtonsoft.Json.JsonConvert.defaultGuard,Bridge.$jsonGuard||(Bridge.$jsonGuard=[],m=function(){delete Bridge.$jsonGuard}),Bridge.$jsonGuard.indexOf(e)>-1)return;if(l===System.Globalization.CultureInfo||l===System.Guid||l===System.Uri||l===System.Int64||l===System.UInt64||l===System.Decimal||l===System.DateTime||l===System.DateTimeOffset||l===System.Char||Bridge.Reflection.isEnum(l)?m():Bridge.$jsonGuard.push(e),g=!1,e&&e.$boxed&&(e=Bridge.unbox(e,!0),g=!0),l===System.Globalization.CultureInfo)return o?e.name:Newtonsoft.Json.JsonConvert.stringify(e.name,t,n);if(l===System.Guid)return o?Bridge.toString(e):Newtonsoft.Json.JsonConvert.stringify(Bridge.toString(e),t,n);if(l===System.Uri)return o?e.getAbsoluteUri():Newtonsoft.Json.JsonConvert.stringify(e.getAbsoluteUri(),t,n);if(l===System.Int64||l===System.UInt64||l===System.Decimal)return o?e.toJSON():e.toString();if(l===System.DateTime)return y=System.DateTime.format(e,"yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFFK"),o?y:Newtonsoft.Json.JsonConvert.stringify(y,t,n);if(l===System.TimeSpan)return y=Bridge.toString(e),o?y:Newtonsoft.Json.JsonConvert.stringify(y,t,n);if(l===System.DateTimeOffset)return y=e.ToString$1("yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFFK"),o?y:Newtonsoft.Json.JsonConvert.stringify(y,t,n);if(Bridge.isArray(null,l)){if(l.$elementType===System.Byte)return m(),d=System.Convert.toBase64String(e),o?d:Newtonsoft.Json.JsonConvert.stringify(d,t,n);for(u=[],f=0;f<e.length;f++)u.push(Newtonsoft.Json.JsonConvert.SerializeObject(e[f],t,n,!0,l.$elementType));e=u,n&&n._typeNameHandling&&((2==(b=n._typeNameHandling)||3==b||4==b&&i&&i!==s)&&(e={$type:Newtonsoft.Json.JsonConvert.BindToName(n,l),$values:u}))}else{if(Bridge.Reflection.isEnum(l))return r?System.Enum.getName(l,e):o?e:Newtonsoft.Json.JsonConvert.stringify(e,t,n);if(l===System.Char)return o?String.fromCharCode(e):Newtonsoft.Json.JsonConvert.stringify(String.fromCharCode(e),t,n);if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,l)){var H=System.Collections.Generic.Dictionary$2.getTypeParameters(l),I=H[0],O=H[1],A={},R=Bridge.getEnumerator(e);for(n&&n._typeNameHandling&&((1==(b=n._typeNameHandling)||3==b||4==b&&i&&i!==s)&&(A.$type=Newtonsoft.Json.JsonConvert.BindToName(n,l)));R.moveNext();)c=R.Current,"object"==typeof(S=Newtonsoft.Json.JsonConvert.SerializeObject(c.key,t,n,!0,I,!0))&&(S=Bridge.toString(c.key)),A[S]=Newtonsoft.Json.JsonConvert.SerializeObject(c.value,t,n,!0,O);e=A}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,l)){for(J=Newtonsoft.Json.JsonConvert.getEnumerableElementType(l),p=Bridge.getEnumerator(e,J),u=[];p.moveNext();)N=p.Current,u.push(Newtonsoft.Json.JsonConvert.SerializeObject(N,t,n,!0,J));e=u,n&&n._typeNameHandling&&((2==(b=n._typeNameHandling)||3==b||4==b&&i&&i!==s)&&(e={$type:Newtonsoft.Json.JsonConvert.BindToName(n,l),$values:u}))}else if(!g){if(w={},v=!Bridge.getMetadata(l),Newtonsoft.Json.JsonConvert.validateReflectable(l),n&&n._typeNameHandling&&((1==(b=n._typeNameHandling)||3==b||4==b&&i&&i!==s)&&(w.$type=Newtonsoft.Json.JsonConvert.BindToName(n,l))),v)if(e.toJSON)w=e.toJSON();else for(C in e)e.hasOwnProperty(C)&&(w[C]=Newtonsoft.Json.JsonConvert.SerializeObject(e[C],t,n,!0));else{var j=Newtonsoft.Json.JsonConvert.getMembers(l,4),z=n&&Bridge.is(n.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),_=Bridge.Reflection.getMembers(l,8,54);if(_.length>0)for(D=0;D<_.length;D++)System.Attribute.isDefined(_[D],System.Runtime.Serialization.OnSerializingAttribute,!1)&&Bridge.Reflection.midel(_[D],e)(null);for(f=0;f<j.length;f++){var V,E=(V=j[f]).member,x=V.attr&&V.attr.PropertyName||(z?E.n.charAt(0).toLowerCase()+E.n.substr(1):E.n),P=Bridge.Reflection.fieldAccess(E,e);!1!==(G=Newtonsoft.Json.JsonConvert.preProcess(V,e,P,n||{}))&&(V.attr&&(T=V.attr._typeNameHandling),null!=T&&($=(n=n||{})._typeNameHandling,n._typeNameHandling=T),w[x]=Newtonsoft.Json.JsonConvert.SerializeObject(G.value,t,n,!0,E.rt),null!=T&&(n._typeNameHandling=$))}for(B=Newtonsoft.Json.JsonConvert.getMembers(l,16),f=0;f<B.length;f++)if((h=(V=B[f]).member).g){var G,F=V.attr&&V.attr.PropertyName||(z?h.n.charAt(0).toLowerCase()+h.n.substr(1):h.n);P=Bridge.Reflection.midel(h.g,e)();!1!==(G=Newtonsoft.Json.JsonConvert.preProcess(V,e,P,n||{}))&&(V.attr&&(T=V.attr._typeNameHandling),null!=T&&($=(n=n||{})._typeNameHandling,n._typeNameHandling=T),w[F]=Newtonsoft.Json.JsonConvert.SerializeObject(G.value,t,n,!0,h.rt),null!=T&&(n._typeNameHandling=$))}if(_.length>0)for(D=0;D<_.length;D++)if(System.Attribute.isDefined(_[D],System.Runtime.Serialization.OnSerializedAttribute,!1)){Bridge.Reflection.midel(_[D],e)(null);break}}e=w}}m()}else if(Bridge.Reflection.isEnum(l))return r?System.Enum.getName(l,e):o?e:Newtonsoft.Json.JsonConvert.stringify(e,t,n);return o?e:Newtonsoft.Json.JsonConvert.stringify(e,t,n)},getInstanceBuilder:function(e,t,n){var o,i,r,s,l,a,u,f=Bridge.isArray(t),m=f&&Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,e),g=!1;if(m||"object"==typeof t&&!f){var y=Bridge.Reflection.getMembers(e,1,54),d=[],c=!1,S=null;if(e===System.Version)y=[Bridge.Reflection.getMembers(e,1,284,null,[System.Int32,System.Int32,System.Int32,System.Int32])],S=y[0];else if(y.length>0)for(y=y.filter((function(e){return!e.isSynthetic})),o=0;o<y.length;o++){var J=y[o],p=System.Attribute.getCustomAttributes(J,Newtonsoft.Json.JsonConstructorAttribute).length>0;if(0===(J.pi||[]).length&&(c=!0),p){if(null!=S)throw new Newtonsoft.Json.JsonException("Multiple constructors with the JsonConstructorAttribute.");S=J}2===J.a&&d.push(J)}if(!c&&!S&&"struct"===e.$kind){if(i=!0,d.length>0){i=!1;var N=(S=d[0]).pi||[],w=Newtonsoft.Json.JsonConvert.getMembers(e,4),v=Newtonsoft.Json.JsonConvert.getMembers(e,16);for(r=0;r<N.length;r++){for(l=(s=N[r]).sn||s.n,a=0;a<v.length;a++){var b=(C=v[r]).member;if(l===(B=C.attr&&C.attr.PropertyName||b.n)||l.toLowerCase()===B.toLowerCase()&&C.s){i=!0;break}}if(!i)for(a=0;a<w.length;a++){var C,B,h=(C=w[r]).member;if(l===(B=C.attr&&C.attr.PropertyName||h.n)||l.toLowerCase()===B.toLowerCase()&&!C.ro){i=!0;break}}if(i)break}}i&&(S={td:e})}if(!c&&y.length>0){if(1!==d.length&&null==S)throw new Newtonsoft.Json.JsonSerializationException("Unable to find a constructor to use for type "+Bridge.getTypeName(e)+". A class should either have a default constructor or one constructor with arguments.");return null==S&&(S=d[0]),N=S.pi||[],m?function(t){var o,i,r,s,l,a,u,f,m,y,d,c,J=[];if(Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,N[0].pt)){if(o=[],i=Bridge.Reflection.getGenericArguments(N[0].pt)[0]||Bridge.Reflection.getGenericArguments(e)[0]||System.Object,n&&n._typeNameHandling&&t.length>0&&t[0]){if(s=!0,l=t[0].$type){for(u=1;u<t.length;u++)if(!(a=t[u]?t[u].$type:null)||a!==l){s=!1;break}}else s=!1;r=s?Newtonsoft.Json.JsonConvert.getInstanceBuilder(i,t[0],n):null}else r=null;for(u=0;u<t.length;u++)f=t[u],(d=r&&!r.default)&&(m=r(f),o[u]=m.value,y=m.names),o[u]=Newtonsoft.Json.JsonConvert.DeserializeObject(f,i,n,!0,d?o[u]:void 0,y);J.push(o),g=!0}return c=Bridge.Reflection.invokeCI(S,J),g?{$list:!0,names:[],value:c}:{names:[],value:c}}:function(e){for(var t,o=[],i=[],r=Object.getOwnPropertyNames(e),s=0;s<N.length;s++){var l=N[s],a=l.sn||l.n,u=null;for(t=0;t<r.length;t++)if(a===r[t]){u=r[t];break}if(!u)for(a=a.toLowerCase(),t=0;t<r.length;t++)if(a===r[t].toLowerCase()){u=r[t];break}(a=u)?(o[s]=Newtonsoft.Json.JsonConvert.DeserializeObject(e[a],l.pt,n,!0),i.push(a)):o[s]=Bridge.getDefaultValue(l.pt)}return{names:i,value:Bridge.Reflection.invokeCI(S,o)}}}}return(u=function(){return{names:[],value:Bridge.createInstance(e),default:!0}}).default=!0,u},createInstance:function(e,t,n){return this.getInstanceBuilder(e,t,n)(t)},needReuse:function(e,t,n,o){return!(e!==Newtonsoft.Json.ObjectCreationHandling.Reuse&&(e!==Newtonsoft.Json.ObjectCreationHandling.Auto||null==t)||!o||"struct"===n.$kind||"enum"===n.$kind||n===System.String||n===System.Boolean||n===System.Int64||n===System.UInt64||n===System.Int32||n===System.UInt32||n===System.Int16||n===System.UInt16||n===System.Byte||n===System.SByte||n===System.Single||n===System.Double||n===System.Decimal)},tryToGetCastOperator:function(e,t){var n,o,i,r,s;if(null===e)return null;if("boolean"==typeof e||"string"==typeof e)n=[Bridge.getType(e)];else{if("number"!=typeof e)return null;n=[System.Double,System.Int64]}for(o=0;o<n.length;o++){if(i=n[o],r=Bridge.Reflection.getMembers(t,8,284,"op_Explicit",[i]))return function(e){return Bridge.Reflection.midel(r,null)(e)};if(s=Bridge.Reflection.getMembers(t,8,284,"op_Implicit",[i]))return function(e){return Bridge.Reflection.midel(s,null)(e)}}return null},DeserializeObject:function(e,t,n,o,i,r){var s,l,a,u,f,m,g,y,d,c,S,J,p,N,w,v,b,C,B,h,T,$,D,H,I,O,A,R,j,z,_,V,E,x,P;if(n=n||{},"interface"===t.$kind&&(System.Collections.IDictionary===t?t=System.Collections.Generic.Dictionary$2(System.Object,System.Object):Bridge.Reflection.isGenericType(t)&&Bridge.Reflection.isAssignableFrom(System.Collections.Generic.IDictionary$2,Bridge.Reflection.getGenericTypeDefinition(t))?(s=System.Collections.Generic.Dictionary$2.getTypeParameters(t),t=System.Collections.Generic.Dictionary$2(s[0]||System.Object,s[1]||System.Object)):t===System.Collections.IList||t===System.Collections.ICollection?t=System.Collections.Generic.List$1(System.Object):Bridge.Reflection.isGenericType(t)&&(Bridge.Reflection.isAssignableFrom(System.Collections.Generic.IList$1,Bridge.Reflection.getGenericTypeDefinition(t))||Bridge.Reflection.isAssignableFrom(System.Collections.Generic.ICollection$1,Bridge.Reflection.getGenericTypeDefinition(t)))&&(t=System.Collections.Generic.List$1(System.Collections.Generic.List$1.getElementType(t)||System.Object))),o||"string"!=typeof e||("object"==typeof(l=Newtonsoft.Json.JsonConvert.parse(e))||Bridge.isArray(l)||t===System.Array.type(System.Byte,1)||t===Function||t==System.Type||t===System.Guid||t===System.Globalization.CultureInfo||t===System.Uri||t===System.DateTime||t===System.DateTimeOffset||t===System.Char||Bridge.Reflection.isEnum(t))&&(e=l),a=t===Object||t===System.Object,u=Bridge.isObject(e),a&&u&&e&&e.$type&&(t=Newtonsoft.Json.JsonConvert.BindToType(n,e.$type,t),a=!1),a&&u||t.$literal&&!Bridge.getMetadata(t))return Bridge.merge(a?{}:i||Bridge.createInstance(t),e);if(f=Bridge.getDefaultValue(t),t.$nullable&&(t=t.$nullableType),null===e)return f;if(!1===e)return t!==System.Boolean&&(t===System.String?"false":(c=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(e,t))?c(e):a?Bridge.box(e,System.Boolean,System.Boolean.toString):f);if(!0===e){if(t===System.Boolean)return!0;if(t===System.Int64)return System.Int64(1);if(t===System.UInt64)return System.UInt64(1);if(t===System.Decimal)return System.Decimal(1);if(t===String.String)return"true";if(t===System.DateTime)return System.DateTime.create$2(1,0);if(t===System.DateTimeOffset)return System.DateTimeOffset.MinValue.$clone();if(Bridge.Reflection.isEnum(t))return Bridge.unbox(System.Enum.parse(t,1));if("number"==typeof f)return f+1;if(c=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(e,t))return c(e);if(a)return Bridge.box(e,System.Boolean,System.Boolean.toString);throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(e),Bridge.getTypeName(t)))}if("number"==typeof e){if(t.$number&&!t.$is(e)&&(t!==System.Decimal||!t.tryParse(e,null,{}))&&(!System.Int64.is64BitType(t)||!t.tryParse(e.toString(),{})))throw new Newtonsoft.Json.JsonException(System.String.format("Input string '{0}' is not a valid {1}",e,Bridge.getTypeName(t)));if(t===System.Boolean)return 0!==e;if(Bridge.Reflection.isEnum(t))return Bridge.unbox(System.Enum.parse(t,e));if(t===System.SByte)return 0|e;if(t===System.Byte)return e>>>0;if(t===System.Int16)return 0|e;if(t===System.UInt16)return e>>>0;if(t===System.Int32)return 0|e;if(t===System.UInt32)return e>>>0;if(t===System.Int64)return System.Int64(e);if(t===System.UInt64)return System.UInt64(e);if(t===System.Single)return e;if(t===System.Double)return e;if(t===System.Decimal)return System.Decimal(e);if(t===System.Char)return 0|e;if(t===System.String)return e.toString();if(t===System.DateTime)return System.DateTime.create$2(0|e,0);if(t===System.TimeSpan)return System.TimeSpan.fromTicks(e);if(t===System.DateTimeOffset)return new System.DateTimeOffset.$ctor5(System.Int64(0|e),(new System.DateTimeOffset.ctor).Offset);if(c=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(e,t))return c(e);if(a)return Bridge.box(e,Bridge.getType(e));throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(e),Bridge.getTypeName(t)))}if("string"==typeof e){if((g=(m=t===System.Decimal)||System.Int64.is64BitType(t))&&(m?!t.tryParse(e,null,{}):!t.tryParse(e,{})))throw new Newtonsoft.Json.JsonException(System.String.format("Input string '{0}' is not a valid {1}",e,Bridge.getTypeName(t)));if(y=t==System.Double||t==System.Single,!g&&t.$number&&(y?!t.tryParse(e,null,{}):!t.tryParse(e,{})))throw new Newtonsoft.Json.JsonException(System.String.format("Could not convert {0} to {1}: {2}",Bridge.getTypeName(e),Bridge.getTypeName(t),e));if(t===Function||t==System.Type)return Bridge.Reflection.getType(e);if(t===System.Globalization.CultureInfo)return new System.Globalization.CultureInfo(e);if(t===System.Uri)return new System.Uri(e);if(t===System.Guid)return System.Guid.Parse(e);if(t===System.Boolean)return d={v:!1},!(System.String.isNullOrWhiteSpace(e)||!System.Boolean.tryParse(e,d))&&d.v;if(t===System.SByte)return 0|e;if(t===System.Byte)return e>>>0;if(t===System.Int16)return 0|e;if(t===System.UInt16)return e>>>0;if(t===System.Int32)return 0|e;if(t===System.UInt32)return e>>>0;if(t===System.Int64)return System.Int64(e);if(t===System.UInt64)return System.UInt64(e);if(t===System.Single)return parseFloat(e);if(t===System.Double)return parseFloat(e);if(t!==System.Decimal){if(t===System.Char)return 0===e.length?0:e.charCodeAt(0);if(t===System.String)return o?e:JSON.parse(e);if(t===System.TimeSpan)return System.TimeSpan.parse('"'==e[0]?JSON.parse(e):e);if(t===System.DateTime){var G="yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFF"+((F=System.String.endsWith(e,"Z"))?"'Z'":"K");return k=null!=(k=System.DateTime.parseExact(e,G,null,!0,!0))?k:System.DateTime.parse(e,void 0,!0),F&&1!==k.kind&&(k=System.DateTime.specifyKind(k,1)),k}if(t===System.DateTimeOffset){var F,k;G="yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFF"+((F=System.String.endsWith(e,"Z"))?"'Z'":"K");return k=null!=(k=System.DateTime.parseExact(e,G,null,!0,!0))?k:System.DateTime.parse(e,void 0,!0),F&&1!==k.kind&&(k=System.DateTime.specifyKind(k,1)),new System.DateTimeOffset.$ctor1(k)}if(Bridge.Reflection.isEnum(t))return Bridge.unbox(System.Enum.parse(t,e));if(t===System.Array.type(System.Byte,1))return System.Convert.fromBase64String(e);if(c=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(e,t))return c(e);if(a)return e;throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(e),Bridge.getTypeName(t)))}try{return System.Decimal(e)}catch(e){return System.Decimal(0)}}else if("object"==typeof e){if(null!==f&&"struct"!==t.$kind)return f;if(Bridge.isArray(null,t)){if(null!=(L=e.$type)&&(t=Newtonsoft.Json.JsonConvert.BindToType(n,L,t),e=e.$values),void 0===e.length)return[];for(S=[],System.Array.type(t.$elementType,t.$rank||1,S),A=0;A<e.length;A++)S[A]=Newtonsoft.Json.JsonConvert.DeserializeObject(e[A],t.$elementType,n,!0);return S}if(Bridge.Reflection.isAssignableFrom(System.Collections.IList,t)){if(null!=(L=e.$type)&&(t=Newtonsoft.Json.JsonConvert.BindToType(n,L,t),e=e.$values),J=System.Collections.Generic.List$1.getElementType(t)||System.Object,(p=i?{value:i}:Newtonsoft.Json.JsonConvert.createInstance(t,e,n))&&p.$list)return p.value;if(p=p.value,void 0===e.length)return p;for(A=0;A<e.length;A++)p.add(Newtonsoft.Json.JsonConvert.DeserializeObject(e[A],J,n,!0));return p}if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,t)){var M,L,U=System.Collections.Generic.Dictionary$2.getTypeParameters(t),q=U[0]||System.Object,K=U[1]||System.Object,W=!1;if(null!=(L=e.$type)&&(t=Newtonsoft.Json.JsonConvert.BindToType(n,L,t),W=!0),(N=i?{value:i}:Newtonsoft.Json.JsonConvert.createInstance(t,e,n))&&N.$list)return N.value;for(w in M=N.names||[],N=N.value,e)e.hasOwnProperty(w)&&(!W||"$type"!==w)&&M.indexOf(w)<0&&N.add(Newtonsoft.Json.JsonConvert.DeserializeObject(w,q,n,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(e[w],K,n,!0));return N}if(null!=(L=e.$type)&&(t=Newtonsoft.Json.JsonConvert.BindToType(n,L,t)),!Bridge.getMetadata(t))return Bridge.merge(a?{}:i||Bridge.createInstance(t),e);if(M=(v=i?{value:i,names:r,default:!0}:Newtonsoft.Json.JsonConvert.createInstance(t,e,n)).names||[],b=v.default,v=v.value,(C=Bridge.Reflection.getMembers(t,8,54)).length>0)for(P=0;P<C.length;P++)System.Attribute.isDefined(C[P],System.Runtime.Serialization.OnDeserializingAttribute,!1)&&Bridge.Reflection.midel(C[P],v)(null);for(B=n&&Bridge.is(n.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),h=Newtonsoft.Json.JsonConvert.getMembers(t,4),A=0;A<h.length;A++)D=($=h[A]).member,I=$.attr&&$.attr.PropertyName||(B?D.n.charAt(0).toLowerCase()+D.n.substr(1):D.n),M.indexOf(I)>-1||(void 0===(T=e[I])&&(T=Newtonsoft.Json.JsonConvert.getValue(e,I)),void 0!==(T=(j=Newtonsoft.Json.JsonConvert.preRawProcess($,e,T,n)).value)&&(z=Bridge.Reflection.fieldAccess(D,v),_=Newtonsoft.Json.ObjectCreationHandling.Auto,O=void 0,$.attr&&null!=$.attr._objectCreationHandling?_=$.attr._objectCreationHandling:null!=n._objectCreationHandling&&(_=n._objectCreationHandling),Newtonsoft.Json.JsonConvert.needReuse(_,z,D.rt,b)&&(O=Bridge.unbox(z,!0)),$.attr&&(V=$.attr._typeNameHandling),null!=V&&(E=n._typeNameHandling,n._typeNameHandling=V),x=Newtonsoft.Json.JsonConvert.DeserializeObject(T,D.rt,n,!0,O),null!=V&&(n._typeNameHandling=E),!1!==(j=Newtonsoft.Json.JsonConvert.preProcess($,v,x,n))&&void 0===O&&Bridge.Reflection.fieldAccess(D,v,j.value)));for(R=Newtonsoft.Json.JsonConvert.getMembers(t,16),A=0;A<R.length;A++)H=($=R[A]).member,I=$.attr&&$.attr.PropertyName||(B?H.n.charAt(0).toLowerCase()+H.n.substr(1):H.n),M.indexOf(I)>-1||(void 0===(T=e[I])&&(T=Newtonsoft.Json.JsonConvert.getValue(e,I)),void 0!==(T=(j=Newtonsoft.Json.JsonConvert.preRawProcess($,e,T,n)).value)&&(O=void 0,H.g&&(z=Bridge.Reflection.midel(H.g,v)(),_=Newtonsoft.Json.ObjectCreationHandling.Auto,$.attr&&null!=$.attr._objectCreationHandling?_=$.attr._objectCreationHandling:null!=n._objectCreationHandling&&(_=n._objectCreationHandling),Newtonsoft.Json.JsonConvert.needReuse(_,z,H.rt,b)&&(O=Bridge.unbox(z,!0))),$.attr&&(V=$.attr._typeNameHandling),null!=V&&(E=n._typeNameHandling,n._typeNameHandling=V),x=Newtonsoft.Json.JsonConvert.DeserializeObject(T,H.rt,n,!0,O),null!=V&&(n._typeNameHandling=E),!1!==(j=Newtonsoft.Json.JsonConvert.preProcess($,v,x,n))&&void 0===O&&(H.s?Bridge.Reflection.midel(H.s,v)(j.value):"anonymous"===t.$kind&&(v[H.n]=j.value))));if(C.length>0)for(P=0;P<C.length;P++)System.Attribute.isDefined(C[P],System.Runtime.Serialization.OnDeserializedAttribute,!1)&&Bridge.Reflection.midel(C[P],v)(null);return v}}}}}),Newtonsoft.Json.$cache=[]}));