+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "JsonExplorer"
keywords = ["grafana","documentation","sdk","@grafana/ui"]
type = "docs"
draft = true
+++

## JsonExplorer class

 JsonExplorer

JsonExplorer allows you to render JSON objects in HTML with a \*\*collapsible\*\* navigation.

<b>Signature</b>

```typescript
export declare class JsonExplorer 
```
<b>Import</b>

```typescript
import { JsonExplorer } from '@grafana/ui';
```
<b>Constructors</b>

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [constructor(json, open, config, key)](#constructor-jsonopenconfigkey) |  | Constructs a new instance of the <code>JsonExplorer</code> class |

<b>Properties</b>

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [json](#json-property) |  | <code>any</code> |  |

<b>Methods</b>

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [appendChildren(animated)](#appendchildren-method) |  | Appends all the children to children element Animated option is used when user triggers this via a click |
|  [isNumberArray()](#isnumberarray-method) |  |  |
|  [openAtDepth(depth)](#openatdepth-method) |  | Open all children up to a certain depth. Allows actions such as expand all/collapse all |
|  [removeChildren(animated)](#removechildren-method) |  | Removes all the children from children element Animated option is used when user triggers this via a click |
|  [render(skipRoot)](#render-method) |  | Renders an HTML element and installs event listeners |
|  [renderArray()](#renderarray-method) |  |  |
|  [toggleOpen()](#toggleopen-method) |  | Toggles <code>isOpen</code> state |

### constructor(json, open, config, key)

Constructs a new instance of the `JsonExplorer` class

<b>Signature</b>

```typescript
constructor(json: any, open?: number, config?: JsonExplorerConfig, key?: string | undefined);
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  json | <code>any</code> |  |
|  open | <code>number</code> |  |
|  config | <code>JsonExplorerConfig</code> |  |
|  key | <code>string &#124; undefined</code> |  |

### json property

<b>Signature</b>

```typescript
json: any;
```

### appendChildren method

Appends all the children to children element Animated option is used when user triggers this via a click

<b>Signature</b>

```typescript
appendChildren(animated?: boolean): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  animated | <code>boolean</code> |  |

<b>Returns:</b>

`void`

### isNumberArray method

<b>Signature</b>

```typescript
isNumberArray(): boolean;
```
<b>Returns:</b>

`boolean`

### openAtDepth method

Open all children up to a certain depth. Allows actions such as expand all/collapse all

<b>Signature</b>

```typescript
openAtDepth(depth?: number): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  depth | <code>number</code> |  |

<b>Returns:</b>

`void`

### removeChildren method

Removes all the children from children element Animated option is used when user triggers this via a click

<b>Signature</b>

```typescript
removeChildren(animated?: boolean): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  animated | <code>boolean</code> |  |

<b>Returns:</b>

`void`

### render method

Renders an HTML element and installs event listeners

<b>Signature</b>

```typescript
render(skipRoot?: boolean): HTMLDivElement;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  skipRoot | <code>boolean</code> |  |

<b>Returns:</b>

`HTMLDivElement`

{<!-- -->HTMLDivElement<!-- -->}

### renderArray method

<b>Signature</b>

```typescript
renderArray(): Element;
```
<b>Returns:</b>

`Element`

### toggleOpen method

Toggles `isOpen` state

<b>Signature</b>

```typescript
toggleOpen(): void;
```
<b>Returns:</b>

`void`

