---
name: Language Change Proposals
about: Changes to the language
title: "proposal: Go 2: "
labels: Proposal Go2 LanguageChange
---

<!--
Our process for evaluating language changes can be found here:
https://go.googlesource.com/proposal/+/refs/heads/master#language-changes
-->

### Author background

- **Would you consider yourself a novice, intermediate, or experienced Go programmer?**
- **What other languages do you have experience with?**

### Related proposals

- **Has this idea, or one like it, been proposed before?**
  - **If so, how does this proposal differ?**
- **Does this affect error handling?**
  - **If so, how does this differ from previous error handling proposals?**
- **Is this about generics?**
  - **If so, how does this relate to the accepted design and other generics proposals?**

### Proposal

- **What is the proposed change?**
- **Who does this proposal help, and why?**
- **Please describe as precisely as possible the change to the language.**
- **What would change in the language spec?**
- **Please also describe the change informally, as in a class teaching Go.**
- **Is this change backward compatible?**
  - Breaking the Go 1 compatibility guarantee is a large cost and requires a large benefit.
    Show example code before and after the change.
  - **Before**
  - **After**
- **Orthogonality: how does this change interact or overlap with existing features?**
- **Is the goal of this change a performance improvement?**
  - **If so, what quantifiable improvement should we expect?**
  - **How would we measure it?**

### Costs

- **Would this change make Go easier or harder to learn, and why?**
- **What is the cost of this proposal? (Every language change has a cost).**
- **How many tools (such as vet, gopls, gofmt, goimports, etc.) would be affected?**
- **What is the compile time cost?**
- **What is the run time cost?**
- **Can you describe a possible implementation?**
- **Do you have a prototype? (This is not required.)**
