message (STATUS "Checking for C++11 flags for ${CMAKE_CXX_COMPILER_ID}")
if (${CMAKE_CXX_COMPILER_ID} MATCHES "GNU")
    execute_process(COMMAND ${CMAKE_CXX_COMPILER} -dumpversion OUTPUT_VARIABLE GCC_VERSION)
    if(GCC_VERSION VERSION_LESS 4.2)
       message(FATAL_ERROR "${PROJECT_NAME} requires C++11 support (g++ 4.3 or later)")
    elseif (GCC_VERSION VERSION_LESS 4.7)
       set (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++0x")
    else ()
       set (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11")
    endif()
elseif (${CMAKE_CXX_COMPILER_ID} MATCHES "Clang")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11")
elseif (${CMAKE_CXX_COMPILER_ID} MATCHES "Intel")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++0x")
else ()
    if (${CMAKE_CXX_COMPILER_ID} STREQUAL MSVC)
        message(STATUS "MSVC requires no C++11 flags")
    else ()
        message(FATAL_ERROR "Your C++ compiler (${CMAKE_CXX_COMPILER_ID}) does not support C++11.")
    endif()
endif ()
