// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package ssm_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ssm"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleSSM_AddTagsToResource() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.AddTagsToResourceInput{
		ResourceId:   aws.String("ResourceId"),             // Required
		ResourceType: aws.String("ResourceTypeForTagging"), // Required
		Tags: []*ssm.Tag{ // Required
			{ // Required
				Key:   aws.String("TagKey"),   // Required
				Value: aws.String("TagValue"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.AddTagsToResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_CancelCommand() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.CancelCommandInput{
		CommandId: aws.String("CommandId"), // Required
		InstanceIds: []*string{
			aws.String("InstanceId"), // Required
			// More values...
		},
	}
	resp, err := svc.CancelCommand(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_CreateActivation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.CreateActivationInput{
		IamRole:             aws.String("IamRole"), // Required
		DefaultInstanceName: aws.String("DefaultInstanceName"),
		Description:         aws.String("ActivationDescription"),
		ExpirationDate:      aws.Time(time.Now()),
		RegistrationLimit:   aws.Int64(1),
	}
	resp, err := svc.CreateActivation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_CreateAssociation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.CreateAssociationInput{
		Name:            aws.String("DocumentName"), // Required
		DocumentVersion: aws.String("DocumentVersion"),
		InstanceId:      aws.String("InstanceId"),
		OutputLocation: &ssm.InstanceAssociationOutputLocation{
			S3Location: &ssm.S3OutputLocation{
				OutputS3BucketName: aws.String("S3BucketName"),
				OutputS3KeyPrefix:  aws.String("S3KeyPrefix"),
				OutputS3Region:     aws.String("S3Region"),
			},
		},
		Parameters: map[string][]*string{
			"Key": { // Required
				aws.String("ParameterValue"), // Required
				// More values...
			},
			// More values...
		},
		ScheduleExpression: aws.String("ScheduleExpression"),
		Targets: []*ssm.Target{
			{ // Required
				Key: aws.String("TargetKey"),
				Values: []*string{
					aws.String("TargetValue"), // Required
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.CreateAssociation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_CreateAssociationBatch() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.CreateAssociationBatchInput{
		Entries: []*ssm.CreateAssociationBatchRequestEntry{ // Required
			{ // Required
				Name:            aws.String("DocumentName"), // Required
				DocumentVersion: aws.String("DocumentVersion"),
				InstanceId:      aws.String("InstanceId"),
				OutputLocation: &ssm.InstanceAssociationOutputLocation{
					S3Location: &ssm.S3OutputLocation{
						OutputS3BucketName: aws.String("S3BucketName"),
						OutputS3KeyPrefix:  aws.String("S3KeyPrefix"),
						OutputS3Region:     aws.String("S3Region"),
					},
				},
				Parameters: map[string][]*string{
					"Key": { // Required
						aws.String("ParameterValue"), // Required
						// More values...
					},
					// More values...
				},
				ScheduleExpression: aws.String("ScheduleExpression"),
				Targets: []*ssm.Target{
					{ // Required
						Key: aws.String("TargetKey"),
						Values: []*string{
							aws.String("TargetValue"), // Required
							// More values...
						},
					},
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.CreateAssociationBatch(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_CreateDocument() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.CreateDocumentInput{
		Content:      aws.String("DocumentContent"), // Required
		Name:         aws.String("DocumentName"),    // Required
		DocumentType: aws.String("DocumentType"),
	}
	resp, err := svc.CreateDocument(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_CreateMaintenanceWindow() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.CreateMaintenanceWindowInput{
		AllowUnassociatedTargets: aws.Bool(true), // Required
		Cutoff:      aws.Int64(1),                            // Required
		Duration:    aws.Int64(1),                            // Required
		Name:        aws.String("MaintenanceWindowName"),     // Required
		Schedule:    aws.String("MaintenanceWindowSchedule"), // Required
		ClientToken: aws.String("ClientToken"),
	}
	resp, err := svc.CreateMaintenanceWindow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_CreatePatchBaseline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.CreatePatchBaselineInput{
		Name: aws.String("BaselineName"), // Required
		ApprovalRules: &ssm.PatchRuleGroup{
			PatchRules: []*ssm.PatchRule{ // Required
				{ // Required
					ApproveAfterDays: aws.Int64(1), // Required
					PatchFilterGroup: &ssm.PatchFilterGroup{ // Required
						PatchFilters: []*ssm.PatchFilter{ // Required
							{ // Required
								Key: aws.String("PatchFilterKey"), // Required
								Values: []*string{ // Required
									aws.String("PatchFilterValue"), // Required
									// More values...
								},
							},
							// More values...
						},
					},
				},
				// More values...
			},
		},
		ApprovedPatches: []*string{
			aws.String("PatchId"), // Required
			// More values...
		},
		ClientToken: aws.String("ClientToken"),
		Description: aws.String("BaselineDescription"),
		GlobalFilters: &ssm.PatchFilterGroup{
			PatchFilters: []*ssm.PatchFilter{ // Required
				{ // Required
					Key: aws.String("PatchFilterKey"), // Required
					Values: []*string{ // Required
						aws.String("PatchFilterValue"), // Required
						// More values...
					},
				},
				// More values...
			},
		},
		RejectedPatches: []*string{
			aws.String("PatchId"), // Required
			// More values...
		},
	}
	resp, err := svc.CreatePatchBaseline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeleteActivation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeleteActivationInput{
		ActivationId: aws.String("ActivationId"), // Required
	}
	resp, err := svc.DeleteActivation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeleteAssociation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeleteAssociationInput{
		AssociationId: aws.String("AssociationId"),
		InstanceId:    aws.String("InstanceId"),
		Name:          aws.String("DocumentName"),
	}
	resp, err := svc.DeleteAssociation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeleteDocument() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeleteDocumentInput{
		Name: aws.String("DocumentName"), // Required
	}
	resp, err := svc.DeleteDocument(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeleteMaintenanceWindow() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeleteMaintenanceWindowInput{
		WindowId: aws.String("MaintenanceWindowId"), // Required
	}
	resp, err := svc.DeleteMaintenanceWindow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeleteParameter() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeleteParameterInput{
		Name: aws.String("PSParameterName"), // Required
	}
	resp, err := svc.DeleteParameter(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeletePatchBaseline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeletePatchBaselineInput{
		BaselineId: aws.String("BaselineId"), // Required
	}
	resp, err := svc.DeletePatchBaseline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeregisterManagedInstance() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeregisterManagedInstanceInput{
		InstanceId: aws.String("ManagedInstanceId"), // Required
	}
	resp, err := svc.DeregisterManagedInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeregisterPatchBaselineForPatchGroup() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeregisterPatchBaselineForPatchGroupInput{
		BaselineId: aws.String("BaselineId"), // Required
		PatchGroup: aws.String("PatchGroup"), // Required
	}
	resp, err := svc.DeregisterPatchBaselineForPatchGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeregisterTargetFromMaintenanceWindow() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeregisterTargetFromMaintenanceWindowInput{
		WindowId:       aws.String("MaintenanceWindowId"),       // Required
		WindowTargetId: aws.String("MaintenanceWindowTargetId"), // Required
	}
	resp, err := svc.DeregisterTargetFromMaintenanceWindow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DeregisterTaskFromMaintenanceWindow() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DeregisterTaskFromMaintenanceWindowInput{
		WindowId:     aws.String("MaintenanceWindowId"),     // Required
		WindowTaskId: aws.String("MaintenanceWindowTaskId"), // Required
	}
	resp, err := svc.DeregisterTaskFromMaintenanceWindow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeActivations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeActivationsInput{
		Filters: []*ssm.DescribeActivationsFilter{
			{ // Required
				FilterKey: aws.String("DescribeActivationsFilterKeys"),
				FilterValues: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeActivations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeAssociation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeAssociationInput{
		AssociationId: aws.String("AssociationId"),
		InstanceId:    aws.String("InstanceId"),
		Name:          aws.String("DocumentName"),
	}
	resp, err := svc.DescribeAssociation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeAutomationExecutions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeAutomationExecutionsInput{
		Filters: []*ssm.AutomationExecutionFilter{
			{ // Required
				Key: aws.String("AutomationExecutionFilterKey"), // Required
				Values: []*string{ // Required
					aws.String("AutomationExecutionFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeAutomationExecutions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeAvailablePatches() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeAvailablePatchesInput{
		Filters: []*ssm.PatchOrchestratorFilter{
			{ // Required
				Key: aws.String("PatchOrchestratorFilterKey"),
				Values: []*string{
					aws.String("PatchOrchestratorFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeAvailablePatches(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeDocument() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeDocumentInput{
		Name:            aws.String("DocumentARN"), // Required
		DocumentVersion: aws.String("DocumentVersion"),
	}
	resp, err := svc.DescribeDocument(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeDocumentPermission() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeDocumentPermissionInput{
		Name:           aws.String("DocumentName"),           // Required
		PermissionType: aws.String("DocumentPermissionType"), // Required
	}
	resp, err := svc.DescribeDocumentPermission(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeEffectiveInstanceAssociations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeEffectiveInstanceAssociationsInput{
		InstanceId: aws.String("InstanceId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeEffectiveInstanceAssociations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeEffectivePatchesForPatchBaseline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeEffectivePatchesForPatchBaselineInput{
		BaselineId: aws.String("BaselineId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeEffectivePatchesForPatchBaseline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeInstanceAssociationsStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeInstanceAssociationsStatusInput{
		InstanceId: aws.String("InstanceId"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeInstanceAssociationsStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeInstanceInformation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeInstanceInformationInput{
		Filters: []*ssm.InstanceInformationStringFilter{
			{ // Required
				Key: aws.String("InstanceInformationStringFilterKey"), // Required
				Values: []*string{ // Required
					aws.String("InstanceInformationFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		InstanceInformationFilterList: []*ssm.InstanceInformationFilter{
			{ // Required
				Key: aws.String("InstanceInformationFilterKey"), // Required
				ValueSet: []*string{ // Required
					aws.String("InstanceInformationFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeInstanceInformation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeInstancePatchStates() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeInstancePatchStatesInput{
		InstanceIds: []*string{ // Required
			aws.String("InstanceId"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeInstancePatchStates(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeInstancePatchStatesForPatchGroup() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeInstancePatchStatesForPatchGroupInput{
		PatchGroup: aws.String("PatchGroup"), // Required
		Filters: []*ssm.InstancePatchStateFilter{
			{ // Required
				Key:  aws.String("InstancePatchStateFilterKey"),    // Required
				Type: aws.String("InstancePatchStateOperatorType"), // Required
				Values: []*string{ // Required
					aws.String("InstancePatchStateFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeInstancePatchStatesForPatchGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeInstancePatches() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeInstancePatchesInput{
		InstanceId: aws.String("InstanceId"), // Required
		Filters: []*ssm.PatchOrchestratorFilter{
			{ // Required
				Key: aws.String("PatchOrchestratorFilterKey"),
				Values: []*string{
					aws.String("PatchOrchestratorFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeInstancePatches(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeMaintenanceWindowExecutionTaskInvocations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput{
		TaskId:            aws.String("MaintenanceWindowExecutionTaskId"), // Required
		WindowExecutionId: aws.String("MaintenanceWindowExecutionId"),     // Required
		Filters: []*ssm.MaintenanceWindowFilter{
			{ // Required
				Key: aws.String("MaintenanceWindowFilterKey"),
				Values: []*string{
					aws.String("MaintenanceWindowFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeMaintenanceWindowExecutionTaskInvocations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeMaintenanceWindowExecutionTasks() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeMaintenanceWindowExecutionTasksInput{
		WindowExecutionId: aws.String("MaintenanceWindowExecutionId"), // Required
		Filters: []*ssm.MaintenanceWindowFilter{
			{ // Required
				Key: aws.String("MaintenanceWindowFilterKey"),
				Values: []*string{
					aws.String("MaintenanceWindowFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeMaintenanceWindowExecutionTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeMaintenanceWindowExecutions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeMaintenanceWindowExecutionsInput{
		WindowId: aws.String("MaintenanceWindowId"), // Required
		Filters: []*ssm.MaintenanceWindowFilter{
			{ // Required
				Key: aws.String("MaintenanceWindowFilterKey"),
				Values: []*string{
					aws.String("MaintenanceWindowFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeMaintenanceWindowExecutions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeMaintenanceWindowTargets() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeMaintenanceWindowTargetsInput{
		WindowId: aws.String("MaintenanceWindowId"), // Required
		Filters: []*ssm.MaintenanceWindowFilter{
			{ // Required
				Key: aws.String("MaintenanceWindowFilterKey"),
				Values: []*string{
					aws.String("MaintenanceWindowFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeMaintenanceWindowTargets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeMaintenanceWindowTasks() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeMaintenanceWindowTasksInput{
		WindowId: aws.String("MaintenanceWindowId"), // Required
		Filters: []*ssm.MaintenanceWindowFilter{
			{ // Required
				Key: aws.String("MaintenanceWindowFilterKey"),
				Values: []*string{
					aws.String("MaintenanceWindowFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeMaintenanceWindowTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeMaintenanceWindows() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeMaintenanceWindowsInput{
		Filters: []*ssm.MaintenanceWindowFilter{
			{ // Required
				Key: aws.String("MaintenanceWindowFilterKey"),
				Values: []*string{
					aws.String("MaintenanceWindowFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeMaintenanceWindows(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribeParameters() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribeParametersInput{
		Filters: []*ssm.ParametersFilter{
			{ // Required
				Values: []*string{ // Required
					aws.String("ParametersFilterValue"), // Required
					// More values...
				},
				Key: aws.String("ParametersFilterKey"),
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribePatchBaselines() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribePatchBaselinesInput{
		Filters: []*ssm.PatchOrchestratorFilter{
			{ // Required
				Key: aws.String("PatchOrchestratorFilterKey"),
				Values: []*string{
					aws.String("PatchOrchestratorFilterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribePatchBaselines(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribePatchGroupState() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribePatchGroupStateInput{
		PatchGroup: aws.String("PatchGroup"), // Required
	}
	resp, err := svc.DescribePatchGroupState(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_DescribePatchGroups() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.DescribePatchGroupsInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribePatchGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetAutomationExecution() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetAutomationExecutionInput{
		AutomationExecutionId: aws.String("AutomationExecutionId"), // Required
	}
	resp, err := svc.GetAutomationExecution(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetCommandInvocation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetCommandInvocationInput{
		CommandId:  aws.String("CommandId"),  // Required
		InstanceId: aws.String("InstanceId"), // Required
		PluginName: aws.String("CommandPluginName"),
	}
	resp, err := svc.GetCommandInvocation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetDefaultPatchBaseline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	var params *ssm.GetDefaultPatchBaselineInput
	resp, err := svc.GetDefaultPatchBaseline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetDeployablePatchSnapshotForInstance() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetDeployablePatchSnapshotForInstanceInput{
		InstanceId: aws.String("InstanceId"), // Required
		SnapshotId: aws.String("SnapshotId"), // Required
	}
	resp, err := svc.GetDeployablePatchSnapshotForInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetDocument() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetDocumentInput{
		Name:            aws.String("DocumentARN"), // Required
		DocumentVersion: aws.String("DocumentVersion"),
	}
	resp, err := svc.GetDocument(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetInventory() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetInventoryInput{
		Filters: []*ssm.InventoryFilter{
			{ // Required
				Key: aws.String("InventoryFilterKey"), // Required
				Values: []*string{ // Required
					aws.String("InventoryFilterValue"), // Required
					// More values...
				},
				Type: aws.String("InventoryQueryOperatorType"),
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
		ResultAttributes: []*ssm.ResultAttribute{
			{ // Required
				TypeName: aws.String("InventoryItemTypeName"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.GetInventory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetInventorySchema() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetInventorySchemaInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
		TypeName:   aws.String("InventoryItemTypeNameFilter"),
	}
	resp, err := svc.GetInventorySchema(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetMaintenanceWindow() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetMaintenanceWindowInput{
		WindowId: aws.String("MaintenanceWindowId"), // Required
	}
	resp, err := svc.GetMaintenanceWindow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetMaintenanceWindowExecution() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetMaintenanceWindowExecutionInput{
		WindowExecutionId: aws.String("MaintenanceWindowExecutionId"), // Required
	}
	resp, err := svc.GetMaintenanceWindowExecution(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetMaintenanceWindowExecutionTask() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetMaintenanceWindowExecutionTaskInput{
		TaskId:            aws.String("MaintenanceWindowExecutionTaskId"), // Required
		WindowExecutionId: aws.String("MaintenanceWindowExecutionId"),     // Required
	}
	resp, err := svc.GetMaintenanceWindowExecutionTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetParameterHistory() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetParameterHistoryInput{
		Name:           aws.String("PSParameterName"), // Required
		MaxResults:     aws.Int64(1),
		NextToken:      aws.String("NextToken"),
		WithDecryption: aws.Bool(true),
	}
	resp, err := svc.GetParameterHistory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetParameters() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetParametersInput{
		Names: []*string{ // Required
			aws.String("PSParameterName"), // Required
			// More values...
		},
		WithDecryption: aws.Bool(true),
	}
	resp, err := svc.GetParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetPatchBaseline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetPatchBaselineInput{
		BaselineId: aws.String("BaselineId"), // Required
	}
	resp, err := svc.GetPatchBaseline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_GetPatchBaselineForPatchGroup() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.GetPatchBaselineForPatchGroupInput{
		PatchGroup: aws.String("PatchGroup"), // Required
	}
	resp, err := svc.GetPatchBaselineForPatchGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_ListAssociations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.ListAssociationsInput{
		AssociationFilterList: []*ssm.AssociationFilter{
			{ // Required
				Key:   aws.String("AssociationFilterKey"),   // Required
				Value: aws.String("AssociationFilterValue"), // Required
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListAssociations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_ListCommandInvocations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.ListCommandInvocationsInput{
		CommandId: aws.String("CommandId"),
		Details:   aws.Bool(true),
		Filters: []*ssm.CommandFilter{
			{ // Required
				Key:   aws.String("CommandFilterKey"),   // Required
				Value: aws.String("CommandFilterValue"), // Required
			},
			// More values...
		},
		InstanceId: aws.String("InstanceId"),
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListCommandInvocations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_ListCommands() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.ListCommandsInput{
		CommandId: aws.String("CommandId"),
		Filters: []*ssm.CommandFilter{
			{ // Required
				Key:   aws.String("CommandFilterKey"),   // Required
				Value: aws.String("CommandFilterValue"), // Required
			},
			// More values...
		},
		InstanceId: aws.String("InstanceId"),
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListCommands(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_ListDocumentVersions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.ListDocumentVersionsInput{
		Name:       aws.String("DocumentName"), // Required
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListDocumentVersions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_ListDocuments() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.ListDocumentsInput{
		DocumentFilterList: []*ssm.DocumentFilter{
			{ // Required
				Key:   aws.String("DocumentFilterKey"),   // Required
				Value: aws.String("DocumentFilterValue"), // Required
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListDocuments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_ListInventoryEntries() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.ListInventoryEntriesInput{
		InstanceId: aws.String("InstanceId"),            // Required
		TypeName:   aws.String("InventoryItemTypeName"), // Required
		Filters: []*ssm.InventoryFilter{
			{ // Required
				Key: aws.String("InventoryFilterKey"), // Required
				Values: []*string{ // Required
					aws.String("InventoryFilterValue"), // Required
					// More values...
				},
				Type: aws.String("InventoryQueryOperatorType"),
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.ListInventoryEntries(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_ListTagsForResource() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.ListTagsForResourceInput{
		ResourceId:   aws.String("ResourceId"),             // Required
		ResourceType: aws.String("ResourceTypeForTagging"), // Required
	}
	resp, err := svc.ListTagsForResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_ModifyDocumentPermission() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.ModifyDocumentPermissionInput{
		Name:           aws.String("DocumentName"),           // Required
		PermissionType: aws.String("DocumentPermissionType"), // Required
		AccountIdsToAdd: []*string{
			aws.String("AccountId"), // Required
			// More values...
		},
		AccountIdsToRemove: []*string{
			aws.String("AccountId"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyDocumentPermission(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_PutInventory() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.PutInventoryInput{
		InstanceId: aws.String("InstanceId"), // Required
		Items: []*ssm.InventoryItem{ // Required
			{ // Required
				CaptureTime:   aws.String("InventoryItemCaptureTime"),   // Required
				SchemaVersion: aws.String("InventoryItemSchemaVersion"), // Required
				TypeName:      aws.String("InventoryItemTypeName"),      // Required
				Content: []map[string]*string{
					{ // Required
						"Key": aws.String("AttributeValue"), // Required
						// More values...
					},
					// More values...
				},
				ContentHash: aws.String("InventoryItemContentHash"),
			},
			// More values...
		},
	}
	resp, err := svc.PutInventory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_PutParameter() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.PutParameterInput{
		Name:        aws.String("PSParameterName"),  // Required
		Type:        aws.String("ParameterType"),    // Required
		Value:       aws.String("PSParameterValue"), // Required
		Description: aws.String("ParameterDescription"),
		KeyId:       aws.String("ParameterKeyId"),
		Overwrite:   aws.Bool(true),
	}
	resp, err := svc.PutParameter(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_RegisterDefaultPatchBaseline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.RegisterDefaultPatchBaselineInput{
		BaselineId: aws.String("BaselineId"), // Required
	}
	resp, err := svc.RegisterDefaultPatchBaseline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_RegisterPatchBaselineForPatchGroup() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.RegisterPatchBaselineForPatchGroupInput{
		BaselineId: aws.String("BaselineId"), // Required
		PatchGroup: aws.String("PatchGroup"), // Required
	}
	resp, err := svc.RegisterPatchBaselineForPatchGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_RegisterTargetWithMaintenanceWindow() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.RegisterTargetWithMaintenanceWindowInput{
		ResourceType: aws.String("MaintenanceWindowResourceType"), // Required
		Targets: []*ssm.Target{ // Required
			{ // Required
				Key: aws.String("TargetKey"),
				Values: []*string{
					aws.String("TargetValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		WindowId:         aws.String("MaintenanceWindowId"), // Required
		ClientToken:      aws.String("ClientToken"),
		OwnerInformation: aws.String("OwnerInformation"),
	}
	resp, err := svc.RegisterTargetWithMaintenanceWindow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_RegisterTaskWithMaintenanceWindow() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.RegisterTaskWithMaintenanceWindowInput{
		MaxConcurrency: aws.String("VelocityConstraint"), // Required
		MaxErrors:      aws.String("VelocityConstraint"), // Required
		ServiceRoleArn: aws.String("ServiceRole"),        // Required
		Targets: []*ssm.Target{ // Required
			{ // Required
				Key: aws.String("TargetKey"),
				Values: []*string{
					aws.String("TargetValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		TaskArn:     aws.String("MaintenanceWindowTaskArn"),  // Required
		TaskType:    aws.String("MaintenanceWindowTaskType"), // Required
		WindowId:    aws.String("MaintenanceWindowId"),       // Required
		ClientToken: aws.String("ClientToken"),
		LoggingInfo: &ssm.LoggingInfo{
			S3BucketName: aws.String("S3BucketName"), // Required
			S3Region:     aws.String("S3Region"),     // Required
			S3KeyPrefix:  aws.String("S3KeyPrefix"),
		},
		Priority: aws.Int64(1),
		TaskParameters: map[string]*ssm.MaintenanceWindowTaskParameterValueExpression{
			"Key": { // Required
				Values: []*string{
					aws.String("MaintenanceWindowTaskParameterValue"), // Required
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.RegisterTaskWithMaintenanceWindow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_RemoveTagsFromResource() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.RemoveTagsFromResourceInput{
		ResourceId:   aws.String("ResourceId"),             // Required
		ResourceType: aws.String("ResourceTypeForTagging"), // Required
		TagKeys: []*string{ // Required
			aws.String("TagKey"), // Required
			// More values...
		},
	}
	resp, err := svc.RemoveTagsFromResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_SendCommand() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.SendCommandInput{
		DocumentName:     aws.String("DocumentARN"), // Required
		Comment:          aws.String("Comment"),
		DocumentHash:     aws.String("DocumentHash"),
		DocumentHashType: aws.String("DocumentHashType"),
		InstanceIds: []*string{
			aws.String("InstanceId"), // Required
			// More values...
		},
		MaxConcurrency: aws.String("VelocityConstraint"),
		MaxErrors:      aws.String("VelocityConstraint"),
		NotificationConfig: &ssm.NotificationConfig{
			NotificationArn: aws.String("NotificationArn"),
			NotificationEvents: []*string{
				aws.String("NotificationEvent"), // Required
				// More values...
			},
			NotificationType: aws.String("NotificationType"),
		},
		OutputS3BucketName: aws.String("S3BucketName"),
		OutputS3KeyPrefix:  aws.String("S3KeyPrefix"),
		OutputS3Region:     aws.String("S3Region"),
		Parameters: map[string][]*string{
			"Key": { // Required
				aws.String("ParameterValue"), // Required
				// More values...
			},
			// More values...
		},
		ServiceRoleArn: aws.String("ServiceRole"),
		Targets: []*ssm.Target{
			{ // Required
				Key: aws.String("TargetKey"),
				Values: []*string{
					aws.String("TargetValue"), // Required
					// More values...
				},
			},
			// More values...
		},
		TimeoutSeconds: aws.Int64(1),
	}
	resp, err := svc.SendCommand(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_StartAutomationExecution() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.StartAutomationExecutionInput{
		DocumentName:    aws.String("DocumentARN"), // Required
		DocumentVersion: aws.String("DocumentVersion"),
		Parameters: map[string][]*string{
			"Key": { // Required
				aws.String("AutomationParameterValue"), // Required
				// More values...
			},
			// More values...
		},
	}
	resp, err := svc.StartAutomationExecution(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_StopAutomationExecution() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.StopAutomationExecutionInput{
		AutomationExecutionId: aws.String("AutomationExecutionId"), // Required
	}
	resp, err := svc.StopAutomationExecution(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_UpdateAssociation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.UpdateAssociationInput{
		AssociationId:   aws.String("AssociationId"), // Required
		DocumentVersion: aws.String("DocumentVersion"),
		OutputLocation: &ssm.InstanceAssociationOutputLocation{
			S3Location: &ssm.S3OutputLocation{
				OutputS3BucketName: aws.String("S3BucketName"),
				OutputS3KeyPrefix:  aws.String("S3KeyPrefix"),
				OutputS3Region:     aws.String("S3Region"),
			},
		},
		Parameters: map[string][]*string{
			"Key": { // Required
				aws.String("ParameterValue"), // Required
				// More values...
			},
			// More values...
		},
		ScheduleExpression: aws.String("ScheduleExpression"),
	}
	resp, err := svc.UpdateAssociation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_UpdateAssociationStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.UpdateAssociationStatusInput{
		AssociationStatus: &ssm.AssociationStatus{ // Required
			Date:           aws.Time(time.Now()),                // Required
			Message:        aws.String("StatusMessage"),         // Required
			Name:           aws.String("AssociationStatusName"), // Required
			AdditionalInfo: aws.String("StatusAdditionalInfo"),
		},
		InstanceId: aws.String("InstanceId"),   // Required
		Name:       aws.String("DocumentName"), // Required
	}
	resp, err := svc.UpdateAssociationStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_UpdateDocument() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.UpdateDocumentInput{
		Content:         aws.String("DocumentContent"), // Required
		Name:            aws.String("DocumentName"),    // Required
		DocumentVersion: aws.String("DocumentVersion"),
	}
	resp, err := svc.UpdateDocument(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_UpdateDocumentDefaultVersion() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.UpdateDocumentDefaultVersionInput{
		DocumentVersion: aws.String("DocumentVersionNumber"), // Required
		Name:            aws.String("DocumentName"),          // Required
	}
	resp, err := svc.UpdateDocumentDefaultVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_UpdateMaintenanceWindow() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.UpdateMaintenanceWindowInput{
		WindowId:                 aws.String("MaintenanceWindowId"), // Required
		AllowUnassociatedTargets: aws.Bool(true),
		Cutoff:   aws.Int64(1),
		Duration: aws.Int64(1),
		Enabled:  aws.Bool(true),
		Name:     aws.String("MaintenanceWindowName"),
		Schedule: aws.String("MaintenanceWindowSchedule"),
	}
	resp, err := svc.UpdateMaintenanceWindow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_UpdateManagedInstanceRole() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.UpdateManagedInstanceRoleInput{
		IamRole:    aws.String("IamRole"),           // Required
		InstanceId: aws.String("ManagedInstanceId"), // Required
	}
	resp, err := svc.UpdateManagedInstanceRole(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleSSM_UpdatePatchBaseline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ssm.New(sess)

	params := &ssm.UpdatePatchBaselineInput{
		BaselineId: aws.String("BaselineId"), // Required
		ApprovalRules: &ssm.PatchRuleGroup{
			PatchRules: []*ssm.PatchRule{ // Required
				{ // Required
					ApproveAfterDays: aws.Int64(1), // Required
					PatchFilterGroup: &ssm.PatchFilterGroup{ // Required
						PatchFilters: []*ssm.PatchFilter{ // Required
							{ // Required
								Key: aws.String("PatchFilterKey"), // Required
								Values: []*string{ // Required
									aws.String("PatchFilterValue"), // Required
									// More values...
								},
							},
							// More values...
						},
					},
				},
				// More values...
			},
		},
		ApprovedPatches: []*string{
			aws.String("PatchId"), // Required
			// More values...
		},
		Description: aws.String("BaselineDescription"),
		GlobalFilters: &ssm.PatchFilterGroup{
			PatchFilters: []*ssm.PatchFilter{ // Required
				{ // Required
					Key: aws.String("PatchFilterKey"), // Required
					Values: []*string{ // Required
						aws.String("PatchFilterValue"), // Required
						// More values...
					},
				},
				// More values...
			},
		},
		Name: aws.String("BaselineName"),
		RejectedPatches: []*string{
			aws.String("PatchId"), // Required
			// More values...
		},
	}
	resp, err := svc.UpdatePatchBaseline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
