/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1beta1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg4_resource "k8s.io/client-go/1.4/pkg/api/resource"
	pkg1_unversioned "k8s.io/client-go/1.4/pkg/api/unversioned"
	pkg2_v1 "k8s.io/client-go/1.4/pkg/api/v1"
	pkg3_types "k8s.io/client-go/1.4/pkg/types"
	pkg5_intstr "k8s.io/client-go/1.4/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg4_resource.Quantity
		var v1 pkg1_unversioned.TypeMeta
		var v2 pkg2_v1.ObjectMeta
		var v3 pkg3_types.UID
		var v4 pkg5_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *ScaleSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Replicas != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym6 := z.DecBinary()
	_ = yym6
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct7 := r.ContainerType()
		if yyct7 == codecSelferValueTypeMap1234 {
			yyl7 := r.ReadMapStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl7, d)
			}
		} else if yyct7 == codecSelferValueTypeArray1234 {
			yyl7 := r.ReadArrayStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl7, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys8Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys8Slc
	var yyhl8 bool = l >= 0
	for yyj8 := 0; ; yyj8++ {
		if yyhl8 {
			if yyj8 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys8Slc = r.DecodeBytes(yys8Slc, true, true)
		yys8 := string(yys8Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys8 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys8)
		} // end switch yys8
	} // end for yyj8
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym12 := z.EncBinary()
		_ = yym12
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep13 := !z.EncBinary()
			yy2arr13 := z.EncBasicHandle().StructToArray
			var yyq13 [3]bool
			_, _, _ = yysep13, yyq13, yy2arr13
			const yyr13 bool = false
			yyq13[1] = len(x.Selector) != 0
			yyq13[2] = x.TargetSelector != ""
			var yynn13 int
			if yyr13 || yy2arr13 {
				r.EncodeArrayStart(3)
			} else {
				yynn13 = 1
				for _, b := range yyq13 {
					if b {
						yynn13++
					}
				}
				r.EncodeMapStart(yynn13)
				yynn13 = 0
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym15 := z.EncBinary()
				_ = yym15
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq13[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq13[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq13[2] {
					yym21 := z.EncBinary()
					_ = yym21
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetSelector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq13[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetSelector))
					}
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym23 := z.DecBinary()
	_ = yym23
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct24 := r.ContainerType()
		if yyct24 == codecSelferValueTypeMap1234 {
			yyl24 := r.ReadMapStart()
			if yyl24 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl24, d)
			}
		} else if yyct24 == codecSelferValueTypeArray1234 {
			yyl24 := r.ReadArrayStart()
			if yyl24 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl24, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys25Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys25Slc
	var yyhl25 bool = l >= 0
	for yyj25 := 0; ; yyj25++ {
		if yyhl25 {
			if yyj25 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys25Slc = r.DecodeBytes(yys25Slc, true, true)
		yys25 := string(yys25Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys25 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv27 := &x.Selector
				yym28 := z.DecBinary()
				_ = yym28
				if false {
				} else {
					z.F.DecMapStringStringX(yyv27, false, d)
				}
			}
		case "targetSelector":
			if r.TryDecodeAsNil() {
				x.TargetSelector = ""
			} else {
				x.TargetSelector = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys25)
		} // end switch yys25
	} // end for yyj25
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj30 int
	var yyb30 bool
	var yyhl30 bool = l >= 0
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv32 := &x.Selector
		yym33 := z.DecBinary()
		_ = yym33
		if false {
		} else {
			z.F.DecMapStringStringX(yyv32, false, d)
		}
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetSelector = ""
	} else {
		x.TargetSelector = string(r.DecodeString())
	}
	for {
		yyj30++
		if yyhl30 {
			yyb30 = yyj30 > l
		} else {
			yyb30 = r.CheckBreak()
		}
		if yyb30 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj30-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Scale) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym35 := z.EncBinary()
		_ = yym35
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep36 := !z.EncBinary()
			yy2arr36 := z.EncBasicHandle().StructToArray
			var yyq36 [5]bool
			_, _, _ = yysep36, yyq36, yy2arr36
			const yyr36 bool = false
			yyq36[0] = x.Kind != ""
			yyq36[1] = x.APIVersion != ""
			yyq36[2] = true
			yyq36[3] = true
			yyq36[4] = true
			var yynn36 int
			if yyr36 || yy2arr36 {
				r.EncodeArrayStart(5)
			} else {
				yynn36 = 0
				for _, b := range yyq36 {
					if b {
						yynn36++
					}
				}
				r.EncodeMapStart(yynn36)
				yynn36 = 0
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[0] {
					yym38 := z.EncBinary()
					_ = yym38
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq36[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym39 := z.EncBinary()
					_ = yym39
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[1] {
					yym41 := z.EncBinary()
					_ = yym41
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq36[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym42 := z.EncBinary()
					_ = yym42
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[2] {
					yy44 := &x.ObjectMeta
					yy44.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq36[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy45 := &x.ObjectMeta
					yy45.CodecEncodeSelf(e)
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[3] {
					yy47 := &x.Spec
					yy47.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq36[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy48 := &x.Spec
					yy48.CodecEncodeSelf(e)
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[4] {
					yy50 := &x.Status
					yy50.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq36[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy51 := &x.Status
					yy51.CodecEncodeSelf(e)
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Scale) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym52 := z.DecBinary()
	_ = yym52
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct53 := r.ContainerType()
		if yyct53 == codecSelferValueTypeMap1234 {
			yyl53 := r.ReadMapStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl53, d)
			}
		} else if yyct53 == codecSelferValueTypeArray1234 {
			yyl53 := r.ReadArrayStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl53, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Scale) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys54Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys54Slc
	var yyhl54 bool = l >= 0
	for yyj54 := 0; ; yyj54++ {
		if yyhl54 {
			if yyj54 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys54Slc = r.DecodeBytes(yys54Slc, true, true)
		yys54 := string(yys54Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys54 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv57 := &x.ObjectMeta
				yyv57.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScaleSpec{}
			} else {
				yyv58 := &x.Spec
				yyv58.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScaleStatus{}
			} else {
				yyv59 := &x.Status
				yyv59.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys54)
		} // end switch yys54
	} // end for yyj54
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Scale) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj60 int
	var yyb60 bool
	var yyhl60 bool = l >= 0
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv63 := &x.ObjectMeta
		yyv63.CodecDecodeSelf(d)
	}
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScaleSpec{}
	} else {
		yyv64 := &x.Spec
		yyv64.CodecDecodeSelf(d)
	}
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScaleStatus{}
	} else {
		yyv65 := &x.Status
		yyv65.CodecDecodeSelf(d)
	}
	for {
		yyj60++
		if yyhl60 {
			yyb60 = yyj60 > l
		} else {
			yyb60 = r.CheckBreak()
		}
		if yyb60 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj60-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerDummy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym66 := z.EncBinary()
		_ = yym66
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep67 := !z.EncBinary()
			yy2arr67 := z.EncBasicHandle().StructToArray
			var yyq67 [2]bool
			_, _, _ = yysep67, yyq67, yy2arr67
			const yyr67 bool = false
			yyq67[0] = x.Kind != ""
			yyq67[1] = x.APIVersion != ""
			var yynn67 int
			if yyr67 || yy2arr67 {
				r.EncodeArrayStart(2)
			} else {
				yynn67 = 0
				for _, b := range yyq67 {
					if b {
						yynn67++
					}
				}
				r.EncodeMapStart(yynn67)
				yynn67 = 0
			}
			if yyr67 || yy2arr67 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq67[0] {
					yym69 := z.EncBinary()
					_ = yym69
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq67[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym70 := z.EncBinary()
					_ = yym70
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr67 || yy2arr67 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq67[1] {
					yym72 := z.EncBinary()
					_ = yym72
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq67[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym73 := z.EncBinary()
					_ = yym73
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr67 || yy2arr67 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerDummy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym74 := z.DecBinary()
	_ = yym74
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct75 := r.ContainerType()
		if yyct75 == codecSelferValueTypeMap1234 {
			yyl75 := r.ReadMapStart()
			if yyl75 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl75, d)
			}
		} else if yyct75 == codecSelferValueTypeArray1234 {
			yyl75 := r.ReadArrayStart()
			if yyl75 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl75, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys76Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys76Slc
	var yyhl76 bool = l >= 0
	for yyj76 := 0; ; yyj76++ {
		if yyhl76 {
			if yyj76 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys76Slc = r.DecodeBytes(yys76Slc, true, true)
		yys76 := string(yys76Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys76 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys76)
		} // end switch yys76
	} // end for yyj76
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj79 int
	var yyb79 bool
	var yyhl79 bool = l >= 0
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj79++
		if yyhl79 {
			yyb79 = yyj79 > l
		} else {
			yyb79 = r.CheckBreak()
		}
		if yyb79 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj79-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SubresourceReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym82 := z.EncBinary()
		_ = yym82
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep83 := !z.EncBinary()
			yy2arr83 := z.EncBasicHandle().StructToArray
			var yyq83 [4]bool
			_, _, _ = yysep83, yyq83, yy2arr83
			const yyr83 bool = false
			yyq83[0] = x.Kind != ""
			yyq83[1] = x.Name != ""
			yyq83[2] = x.APIVersion != ""
			yyq83[3] = x.Subresource != ""
			var yynn83 int
			if yyr83 || yy2arr83 {
				r.EncodeArrayStart(4)
			} else {
				yynn83 = 0
				for _, b := range yyq83 {
					if b {
						yynn83++
					}
				}
				r.EncodeMapStart(yynn83)
				yynn83 = 0
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq83[0] {
					yym85 := z.EncBinary()
					_ = yym85
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq83[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym86 := z.EncBinary()
					_ = yym86
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq83[1] {
					yym88 := z.EncBinary()
					_ = yym88
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq83[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym89 := z.EncBinary()
					_ = yym89
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq83[2] {
					yym91 := z.EncBinary()
					_ = yym91
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq83[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym92 := z.EncBinary()
					_ = yym92
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq83[3] {
					yym94 := z.EncBinary()
					_ = yym94
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq83[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subresource"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym95 := z.EncBinary()
					_ = yym95
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				}
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubresourceReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym96 := z.DecBinary()
	_ = yym96
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct97 := r.ContainerType()
		if yyct97 == codecSelferValueTypeMap1234 {
			yyl97 := r.ReadMapStart()
			if yyl97 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl97, d)
			}
		} else if yyct97 == codecSelferValueTypeArray1234 {
			yyl97 := r.ReadArrayStart()
			if yyl97 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl97, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubresourceReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys98Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys98Slc
	var yyhl98 bool = l >= 0
	for yyj98 := 0; ; yyj98++ {
		if yyhl98 {
			if yyj98 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys98Slc = r.DecodeBytes(yys98Slc, true, true)
		yys98 := string(yys98Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys98 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "subresource":
			if r.TryDecodeAsNil() {
				x.Subresource = ""
			} else {
				x.Subresource = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys98)
		} // end switch yys98
	} // end for yyj98
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubresourceReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj103 int
	var yyb103 bool
	var yyhl103 bool = l >= 0
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subresource = ""
	} else {
		x.Subresource = string(r.DecodeString())
	}
	for {
		yyj103++
		if yyhl103 {
			yyb103 = yyj103 > l
		} else {
			yyb103 = r.CheckBreak()
		}
		if yyb103 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj103-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CPUTargetUtilization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym108 := z.EncBinary()
		_ = yym108
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep109 := !z.EncBinary()
			yy2arr109 := z.EncBasicHandle().StructToArray
			var yyq109 [1]bool
			_, _, _ = yysep109, yyq109, yy2arr109
			const yyr109 bool = false
			var yynn109 int
			if yyr109 || yy2arr109 {
				r.EncodeArrayStart(1)
			} else {
				yynn109 = 1
				for _, b := range yyq109 {
					if b {
						yynn109++
					}
				}
				r.EncodeMapStart(yynn109)
				yynn109 = 0
			}
			if yyr109 || yy2arr109 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym111 := z.EncBinary()
				_ = yym111
				if false {
				} else {
					r.EncodeInt(int64(x.TargetPercentage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPercentage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym112 := z.EncBinary()
				_ = yym112
				if false {
				} else {
					r.EncodeInt(int64(x.TargetPercentage))
				}
			}
			if yyr109 || yy2arr109 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CPUTargetUtilization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym113 := z.DecBinary()
	_ = yym113
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct114 := r.ContainerType()
		if yyct114 == codecSelferValueTypeMap1234 {
			yyl114 := r.ReadMapStart()
			if yyl114 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl114, d)
			}
		} else if yyct114 == codecSelferValueTypeArray1234 {
			yyl114 := r.ReadArrayStart()
			if yyl114 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl114, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CPUTargetUtilization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys115Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys115Slc
	var yyhl115 bool = l >= 0
	for yyj115 := 0; ; yyj115++ {
		if yyhl115 {
			if yyj115 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys115Slc = r.DecodeBytes(yys115Slc, true, true)
		yys115 := string(yys115Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys115 {
		case "targetPercentage":
			if r.TryDecodeAsNil() {
				x.TargetPercentage = 0
			} else {
				x.TargetPercentage = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys115)
		} // end switch yys115
	} // end for yyj115
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CPUTargetUtilization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj117 int
	var yyb117 bool
	var yyhl117 bool = l >= 0
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPercentage = 0
	} else {
		x.TargetPercentage = int32(r.DecodeInt(32))
	}
	for {
		yyj117++
		if yyhl117 {
			yyb117 = yyj117 > l
		} else {
			yyb117 = r.CheckBreak()
		}
		if yyb117 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj117-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricTarget) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym119 := z.EncBinary()
		_ = yym119
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep120 := !z.EncBinary()
			yy2arr120 := z.EncBasicHandle().StructToArray
			var yyq120 [2]bool
			_, _, _ = yysep120, yyq120, yy2arr120
			const yyr120 bool = false
			var yynn120 int
			if yyr120 || yy2arr120 {
				r.EncodeArrayStart(2)
			} else {
				yynn120 = 2
				for _, b := range yyq120 {
					if b {
						yynn120++
					}
				}
				r.EncodeMapStart(yynn120)
				yynn120 = 0
			}
			if yyr120 || yy2arr120 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym122 := z.EncBinary()
				_ = yym122
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym123 := z.EncBinary()
				_ = yym123
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr120 || yy2arr120 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy125 := &x.TargetValue
				yym126 := z.EncBinary()
				_ = yym126
				if false {
				} else if z.HasExtensions() && z.EncExt(yy125) {
				} else if !yym126 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy125)
				} else {
					z.EncFallback(yy125)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy127 := &x.TargetValue
				yym128 := z.EncBinary()
				_ = yym128
				if false {
				} else if z.HasExtensions() && z.EncExt(yy127) {
				} else if !yym128 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy127)
				} else {
					z.EncFallback(yy127)
				}
			}
			if yyr120 || yy2arr120 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricTarget) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym129 := z.DecBinary()
	_ = yym129
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct130 := r.ContainerType()
		if yyct130 == codecSelferValueTypeMap1234 {
			yyl130 := r.ReadMapStart()
			if yyl130 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl130, d)
			}
		} else if yyct130 == codecSelferValueTypeArray1234 {
			yyl130 := r.ReadArrayStart()
			if yyl130 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl130, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricTarget) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys131Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys131Slc
	var yyhl131 bool = l >= 0
	for yyj131 := 0; ; yyj131++ {
		if yyhl131 {
			if yyj131 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys131Slc = r.DecodeBytes(yys131Slc, true, true)
		yys131 := string(yys131Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys131 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.TargetValue = pkg4_resource.Quantity{}
			} else {
				yyv133 := &x.TargetValue
				yym134 := z.DecBinary()
				_ = yym134
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv133) {
				} else if !yym134 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv133)
				} else {
					z.DecFallback(yyv133, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys131)
		} // end switch yys131
	} // end for yyj131
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricTarget) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj135 int
	var yyb135 bool
	var yyhl135 bool = l >= 0
	yyj135++
	if yyhl135 {
		yyb135 = yyj135 > l
	} else {
		yyb135 = r.CheckBreak()
	}
	if yyb135 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj135++
	if yyhl135 {
		yyb135 = yyj135 > l
	} else {
		yyb135 = r.CheckBreak()
	}
	if yyb135 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetValue = pkg4_resource.Quantity{}
	} else {
		yyv137 := &x.TargetValue
		yym138 := z.DecBinary()
		_ = yym138
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv137) {
		} else if !yym138 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv137)
		} else {
			z.DecFallback(yyv137, false)
		}
	}
	for {
		yyj135++
		if yyhl135 {
			yyb135 = yyj135 > l
		} else {
			yyb135 = r.CheckBreak()
		}
		if yyb135 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj135-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricTargetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym139 := z.EncBinary()
		_ = yym139
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep140 := !z.EncBinary()
			yy2arr140 := z.EncBasicHandle().StructToArray
			var yyq140 [1]bool
			_, _, _ = yysep140, yyq140, yy2arr140
			const yyr140 bool = false
			var yynn140 int
			if yyr140 || yy2arr140 {
				r.EncodeArrayStart(1)
			} else {
				yynn140 = 1
				for _, b := range yyq140 {
					if b {
						yynn140++
					}
				}
				r.EncodeMapStart(yynn140)
				yynn140 = 0
			}
			if yyr140 || yy2arr140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym142 := z.EncBinary()
					_ = yym142
					if false {
					} else {
						h.encSliceCustomMetricTarget(([]CustomMetricTarget)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym143 := z.EncBinary()
					_ = yym143
					if false {
					} else {
						h.encSliceCustomMetricTarget(([]CustomMetricTarget)(x.Items), e)
					}
				}
			}
			if yyr140 || yy2arr140 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricTargetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym144 := z.DecBinary()
	_ = yym144
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct145 := r.ContainerType()
		if yyct145 == codecSelferValueTypeMap1234 {
			yyl145 := r.ReadMapStart()
			if yyl145 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl145, d)
			}
		} else if yyct145 == codecSelferValueTypeArray1234 {
			yyl145 := r.ReadArrayStart()
			if yyl145 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl145, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricTargetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys146Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys146Slc
	var yyhl146 bool = l >= 0
	for yyj146 := 0; ; yyj146++ {
		if yyhl146 {
			if yyj146 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys146Slc = r.DecodeBytes(yys146Slc, true, true)
		yys146 := string(yys146Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys146 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv147 := &x.Items
				yym148 := z.DecBinary()
				_ = yym148
				if false {
				} else {
					h.decSliceCustomMetricTarget((*[]CustomMetricTarget)(yyv147), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys146)
		} // end switch yys146
	} // end for yyj146
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricTargetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj149 int
	var yyb149 bool
	var yyhl149 bool = l >= 0
	yyj149++
	if yyhl149 {
		yyb149 = yyj149 > l
	} else {
		yyb149 = r.CheckBreak()
	}
	if yyb149 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv150 := &x.Items
		yym151 := z.DecBinary()
		_ = yym151
		if false {
		} else {
			h.decSliceCustomMetricTarget((*[]CustomMetricTarget)(yyv150), d)
		}
	}
	for {
		yyj149++
		if yyhl149 {
			yyb149 = yyj149 > l
		} else {
			yyb149 = r.CheckBreak()
		}
		if yyb149 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj149-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricCurrentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym152 := z.EncBinary()
		_ = yym152
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep153 := !z.EncBinary()
			yy2arr153 := z.EncBasicHandle().StructToArray
			var yyq153 [2]bool
			_, _, _ = yysep153, yyq153, yy2arr153
			const yyr153 bool = false
			var yynn153 int
			if yyr153 || yy2arr153 {
				r.EncodeArrayStart(2)
			} else {
				yynn153 = 2
				for _, b := range yyq153 {
					if b {
						yynn153++
					}
				}
				r.EncodeMapStart(yynn153)
				yynn153 = 0
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym155 := z.EncBinary()
				_ = yym155
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym156 := z.EncBinary()
				_ = yym156
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy158 := &x.CurrentValue
				yym159 := z.EncBinary()
				_ = yym159
				if false {
				} else if z.HasExtensions() && z.EncExt(yy158) {
				} else if !yym159 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy158)
				} else {
					z.EncFallback(yy158)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy160 := &x.CurrentValue
				yym161 := z.EncBinary()
				_ = yym161
				if false {
				} else if z.HasExtensions() && z.EncExt(yy160) {
				} else if !yym161 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy160)
				} else {
					z.EncFallback(yy160)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricCurrentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym162 := z.DecBinary()
	_ = yym162
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct163 := r.ContainerType()
		if yyct163 == codecSelferValueTypeMap1234 {
			yyl163 := r.ReadMapStart()
			if yyl163 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl163, d)
			}
		} else if yyct163 == codecSelferValueTypeArray1234 {
			yyl163 := r.ReadArrayStart()
			if yyl163 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl163, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricCurrentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys164Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys164Slc
	var yyhl164 bool = l >= 0
	for yyj164 := 0; ; yyj164++ {
		if yyhl164 {
			if yyj164 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys164Slc = r.DecodeBytes(yys164Slc, true, true)
		yys164 := string(yys164Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys164 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.CurrentValue = pkg4_resource.Quantity{}
			} else {
				yyv166 := &x.CurrentValue
				yym167 := z.DecBinary()
				_ = yym167
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv166) {
				} else if !yym167 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv166)
				} else {
					z.DecFallback(yyv166, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys164)
		} // end switch yys164
	} // end for yyj164
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricCurrentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj168 int
	var yyb168 bool
	var yyhl168 bool = l >= 0
	yyj168++
	if yyhl168 {
		yyb168 = yyj168 > l
	} else {
		yyb168 = r.CheckBreak()
	}
	if yyb168 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj168++
	if yyhl168 {
		yyb168 = yyj168 > l
	} else {
		yyb168 = r.CheckBreak()
	}
	if yyb168 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentValue = pkg4_resource.Quantity{}
	} else {
		yyv170 := &x.CurrentValue
		yym171 := z.DecBinary()
		_ = yym171
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv170) {
		} else if !yym171 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv170)
		} else {
			z.DecFallback(yyv170, false)
		}
	}
	for {
		yyj168++
		if yyhl168 {
			yyb168 = yyj168 > l
		} else {
			yyb168 = r.CheckBreak()
		}
		if yyb168 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj168-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricCurrentStatusList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym172 := z.EncBinary()
		_ = yym172
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep173 := !z.EncBinary()
			yy2arr173 := z.EncBasicHandle().StructToArray
			var yyq173 [1]bool
			_, _, _ = yysep173, yyq173, yy2arr173
			const yyr173 bool = false
			var yynn173 int
			if yyr173 || yy2arr173 {
				r.EncodeArrayStart(1)
			} else {
				yynn173 = 1
				for _, b := range yyq173 {
					if b {
						yynn173++
					}
				}
				r.EncodeMapStart(yynn173)
				yynn173 = 0
			}
			if yyr173 || yy2arr173 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym175 := z.EncBinary()
					_ = yym175
					if false {
					} else {
						h.encSliceCustomMetricCurrentStatus(([]CustomMetricCurrentStatus)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym176 := z.EncBinary()
					_ = yym176
					if false {
					} else {
						h.encSliceCustomMetricCurrentStatus(([]CustomMetricCurrentStatus)(x.Items), e)
					}
				}
			}
			if yyr173 || yy2arr173 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricCurrentStatusList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym177 := z.DecBinary()
	_ = yym177
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct178 := r.ContainerType()
		if yyct178 == codecSelferValueTypeMap1234 {
			yyl178 := r.ReadMapStart()
			if yyl178 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl178, d)
			}
		} else if yyct178 == codecSelferValueTypeArray1234 {
			yyl178 := r.ReadArrayStart()
			if yyl178 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl178, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricCurrentStatusList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys179Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys179Slc
	var yyhl179 bool = l >= 0
	for yyj179 := 0; ; yyj179++ {
		if yyhl179 {
			if yyj179 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys179Slc = r.DecodeBytes(yys179Slc, true, true)
		yys179 := string(yys179Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys179 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv180 := &x.Items
				yym181 := z.DecBinary()
				_ = yym181
				if false {
				} else {
					h.decSliceCustomMetricCurrentStatus((*[]CustomMetricCurrentStatus)(yyv180), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys179)
		} // end switch yys179
	} // end for yyj179
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricCurrentStatusList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj182 int
	var yyb182 bool
	var yyhl182 bool = l >= 0
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv183 := &x.Items
		yym184 := z.DecBinary()
		_ = yym184
		if false {
		} else {
			h.decSliceCustomMetricCurrentStatus((*[]CustomMetricCurrentStatus)(yyv183), d)
		}
	}
	for {
		yyj182++
		if yyhl182 {
			yyb182 = yyj182 > l
		} else {
			yyb182 = r.CheckBreak()
		}
		if yyb182 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj182-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym185 := z.EncBinary()
		_ = yym185
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep186 := !z.EncBinary()
			yy2arr186 := z.EncBasicHandle().StructToArray
			var yyq186 [4]bool
			_, _, _ = yysep186, yyq186, yy2arr186
			const yyr186 bool = false
			yyq186[1] = x.MinReplicas != nil
			yyq186[3] = x.CPUUtilization != nil
			var yynn186 int
			if yyr186 || yy2arr186 {
				r.EncodeArrayStart(4)
			} else {
				yynn186 = 2
				for _, b := range yyq186 {
					if b {
						yynn186++
					}
				}
				r.EncodeMapStart(yynn186)
				yynn186 = 0
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy188 := &x.ScaleRef
				yy188.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("scaleRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy189 := &x.ScaleRef
				yy189.CodecEncodeSelf(e)
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq186[1] {
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy191 := *x.MinReplicas
						yym192 := z.EncBinary()
						_ = yym192
						if false {
						} else {
							r.EncodeInt(int64(yy191))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq186[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy193 := *x.MinReplicas
						yym194 := z.EncBinary()
						_ = yym194
						if false {
						} else {
							r.EncodeInt(int64(yy193))
						}
					}
				}
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym196 := z.EncBinary()
				_ = yym196
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym197 := z.EncBinary()
				_ = yym197
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq186[3] {
					if x.CPUUtilization == nil {
						r.EncodeNil()
					} else {
						x.CPUUtilization.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq186[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cpuUtilization"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CPUUtilization == nil {
						r.EncodeNil()
					} else {
						x.CPUUtilization.CodecEncodeSelf(e)
					}
				}
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym199 := z.DecBinary()
	_ = yym199
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct200 := r.ContainerType()
		if yyct200 == codecSelferValueTypeMap1234 {
			yyl200 := r.ReadMapStart()
			if yyl200 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl200, d)
			}
		} else if yyct200 == codecSelferValueTypeArray1234 {
			yyl200 := r.ReadArrayStart()
			if yyl200 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl200, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys201Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys201Slc
	var yyhl201 bool = l >= 0
	for yyj201 := 0; ; yyj201++ {
		if yyhl201 {
			if yyj201 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys201Slc = r.DecodeBytes(yys201Slc, true, true)
		yys201 := string(yys201Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys201 {
		case "scaleRef":
			if r.TryDecodeAsNil() {
				x.ScaleRef = SubresourceReference{}
			} else {
				yyv202 := &x.ScaleRef
				yyv202.CodecDecodeSelf(d)
			}
		case "minReplicas":
			if r.TryDecodeAsNil() {
				if x.MinReplicas != nil {
					x.MinReplicas = nil
				}
			} else {
				if x.MinReplicas == nil {
					x.MinReplicas = new(int32)
				}
				yym204 := z.DecBinary()
				_ = yym204
				if false {
				} else {
					*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
				}
			}
		case "maxReplicas":
			if r.TryDecodeAsNil() {
				x.MaxReplicas = 0
			} else {
				x.MaxReplicas = int32(r.DecodeInt(32))
			}
		case "cpuUtilization":
			if r.TryDecodeAsNil() {
				if x.CPUUtilization != nil {
					x.CPUUtilization = nil
				}
			} else {
				if x.CPUUtilization == nil {
					x.CPUUtilization = new(CPUTargetUtilization)
				}
				x.CPUUtilization.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys201)
		} // end switch yys201
	} // end for yyj201
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj207 int
	var yyb207 bool
	var yyhl207 bool = l >= 0
	yyj207++
	if yyhl207 {
		yyb207 = yyj207 > l
	} else {
		yyb207 = r.CheckBreak()
	}
	if yyb207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ScaleRef = SubresourceReference{}
	} else {
		yyv208 := &x.ScaleRef
		yyv208.CodecDecodeSelf(d)
	}
	yyj207++
	if yyhl207 {
		yyb207 = yyj207 > l
	} else {
		yyb207 = r.CheckBreak()
	}
	if yyb207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MinReplicas != nil {
			x.MinReplicas = nil
		}
	} else {
		if x.MinReplicas == nil {
			x.MinReplicas = new(int32)
		}
		yym210 := z.DecBinary()
		_ = yym210
		if false {
		} else {
			*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj207++
	if yyhl207 {
		yyb207 = yyj207 > l
	} else {
		yyb207 = r.CheckBreak()
	}
	if yyb207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxReplicas = 0
	} else {
		x.MaxReplicas = int32(r.DecodeInt(32))
	}
	yyj207++
	if yyhl207 {
		yyb207 = yyj207 > l
	} else {
		yyb207 = r.CheckBreak()
	}
	if yyb207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CPUUtilization != nil {
			x.CPUUtilization = nil
		}
	} else {
		if x.CPUUtilization == nil {
			x.CPUUtilization = new(CPUTargetUtilization)
		}
		x.CPUUtilization.CodecDecodeSelf(d)
	}
	for {
		yyj207++
		if yyhl207 {
			yyb207 = yyj207 > l
		} else {
			yyb207 = r.CheckBreak()
		}
		if yyb207 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj207-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym213 := z.EncBinary()
		_ = yym213
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep214 := !z.EncBinary()
			yy2arr214 := z.EncBasicHandle().StructToArray
			var yyq214 [5]bool
			_, _, _ = yysep214, yyq214, yy2arr214
			const yyr214 bool = false
			yyq214[0] = x.ObservedGeneration != nil
			yyq214[1] = x.LastScaleTime != nil
			yyq214[4] = x.CurrentCPUUtilizationPercentage != nil
			var yynn214 int
			if yyr214 || yy2arr214 {
				r.EncodeArrayStart(5)
			} else {
				yynn214 = 2
				for _, b := range yyq214 {
					if b {
						yynn214++
					}
				}
				r.EncodeMapStart(yynn214)
				yynn214 = 0
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq214[0] {
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy216 := *x.ObservedGeneration
						yym217 := z.EncBinary()
						_ = yym217
						if false {
						} else {
							r.EncodeInt(int64(yy216))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq214[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy218 := *x.ObservedGeneration
						yym219 := z.EncBinary()
						_ = yym219
						if false {
						} else {
							r.EncodeInt(int64(yy218))
						}
					}
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq214[1] {
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym221 := z.EncBinary()
						_ = yym221
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym221 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym221 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq214[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastScaleTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym222 := z.EncBinary()
						_ = yym222
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym222 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym222 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym224 := z.EncBinary()
				_ = yym224
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym225 := z.EncBinary()
				_ = yym225
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym227 := z.EncBinary()
				_ = yym227
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq214[4] {
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy230 := *x.CurrentCPUUtilizationPercentage
						yym231 := z.EncBinary()
						_ = yym231
						if false {
						} else {
							r.EncodeInt(int64(yy230))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq214[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("currentCPUUtilizationPercentage"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy232 := *x.CurrentCPUUtilizationPercentage
						yym233 := z.EncBinary()
						_ = yym233
						if false {
						} else {
							r.EncodeInt(int64(yy232))
						}
					}
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym234 := z.DecBinary()
	_ = yym234
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct235 := r.ContainerType()
		if yyct235 == codecSelferValueTypeMap1234 {
			yyl235 := r.ReadMapStart()
			if yyl235 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl235, d)
			}
		} else if yyct235 == codecSelferValueTypeArray1234 {
			yyl235 := r.ReadArrayStart()
			if yyl235 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl235, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys236Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys236Slc
	var yyhl236 bool = l >= 0
	for yyj236 := 0; ; yyj236++ {
		if yyhl236 {
			if yyj236 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys236Slc = r.DecodeBytes(yys236Slc, true, true)
		yys236 := string(yys236Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys236 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				if x.ObservedGeneration != nil {
					x.ObservedGeneration = nil
				}
			} else {
				if x.ObservedGeneration == nil {
					x.ObservedGeneration = new(int64)
				}
				yym238 := z.DecBinary()
				_ = yym238
				if false {
				} else {
					*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
				}
			}
		case "lastScaleTime":
			if r.TryDecodeAsNil() {
				if x.LastScaleTime != nil {
					x.LastScaleTime = nil
				}
			} else {
				if x.LastScaleTime == nil {
					x.LastScaleTime = new(pkg1_unversioned.Time)
				}
				yym240 := z.DecBinary()
				_ = yym240
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
				} else if yym240 {
					z.DecBinaryUnmarshal(x.LastScaleTime)
				} else if !yym240 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.LastScaleTime)
				} else {
					z.DecFallback(x.LastScaleTime, false)
				}
			}
		case "currentReplicas":
			if r.TryDecodeAsNil() {
				x.CurrentReplicas = 0
			} else {
				x.CurrentReplicas = int32(r.DecodeInt(32))
			}
		case "desiredReplicas":
			if r.TryDecodeAsNil() {
				x.DesiredReplicas = 0
			} else {
				x.DesiredReplicas = int32(r.DecodeInt(32))
			}
		case "currentCPUUtilizationPercentage":
			if r.TryDecodeAsNil() {
				if x.CurrentCPUUtilizationPercentage != nil {
					x.CurrentCPUUtilizationPercentage = nil
				}
			} else {
				if x.CurrentCPUUtilizationPercentage == nil {
					x.CurrentCPUUtilizationPercentage = new(int32)
				}
				yym244 := z.DecBinary()
				_ = yym244
				if false {
				} else {
					*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys236)
		} // end switch yys236
	} // end for yyj236
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj245 int
	var yyb245 bool
	var yyhl245 bool = l >= 0
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ObservedGeneration != nil {
			x.ObservedGeneration = nil
		}
	} else {
		if x.ObservedGeneration == nil {
			x.ObservedGeneration = new(int64)
		}
		yym247 := z.DecBinary()
		_ = yym247
		if false {
		} else {
			*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
		}
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LastScaleTime != nil {
			x.LastScaleTime = nil
		}
	} else {
		if x.LastScaleTime == nil {
			x.LastScaleTime = new(pkg1_unversioned.Time)
		}
		yym249 := z.DecBinary()
		_ = yym249
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
		} else if yym249 {
			z.DecBinaryUnmarshal(x.LastScaleTime)
		} else if !yym249 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.LastScaleTime)
		} else {
			z.DecFallback(x.LastScaleTime, false)
		}
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentReplicas = 0
	} else {
		x.CurrentReplicas = int32(r.DecodeInt(32))
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredReplicas = 0
	} else {
		x.DesiredReplicas = int32(r.DecodeInt(32))
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CurrentCPUUtilizationPercentage != nil {
			x.CurrentCPUUtilizationPercentage = nil
		}
	} else {
		if x.CurrentCPUUtilizationPercentage == nil {
			x.CurrentCPUUtilizationPercentage = new(int32)
		}
		yym253 := z.DecBinary()
		_ = yym253
		if false {
		} else {
			*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj245++
		if yyhl245 {
			yyb245 = yyj245 > l
		} else {
			yyb245 = r.CheckBreak()
		}
		if yyb245 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj245-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscaler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym254 := z.EncBinary()
		_ = yym254
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep255 := !z.EncBinary()
			yy2arr255 := z.EncBasicHandle().StructToArray
			var yyq255 [5]bool
			_, _, _ = yysep255, yyq255, yy2arr255
			const yyr255 bool = false
			yyq255[0] = x.Kind != ""
			yyq255[1] = x.APIVersion != ""
			yyq255[2] = true
			yyq255[3] = true
			yyq255[4] = true
			var yynn255 int
			if yyr255 || yy2arr255 {
				r.EncodeArrayStart(5)
			} else {
				yynn255 = 0
				for _, b := range yyq255 {
					if b {
						yynn255++
					}
				}
				r.EncodeMapStart(yynn255)
				yynn255 = 0
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[0] {
					yym257 := z.EncBinary()
					_ = yym257
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq255[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym258 := z.EncBinary()
					_ = yym258
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[1] {
					yym260 := z.EncBinary()
					_ = yym260
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq255[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym261 := z.EncBinary()
					_ = yym261
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[2] {
					yy263 := &x.ObjectMeta
					yy263.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq255[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy264 := &x.ObjectMeta
					yy264.CodecEncodeSelf(e)
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[3] {
					yy266 := &x.Spec
					yy266.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq255[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy267 := &x.Spec
					yy267.CodecEncodeSelf(e)
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[4] {
					yy269 := &x.Status
					yy269.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq255[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy270 := &x.Status
					yy270.CodecEncodeSelf(e)
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscaler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym271 := z.DecBinary()
	_ = yym271
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct272 := r.ContainerType()
		if yyct272 == codecSelferValueTypeMap1234 {
			yyl272 := r.ReadMapStart()
			if yyl272 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl272, d)
			}
		} else if yyct272 == codecSelferValueTypeArray1234 {
			yyl272 := r.ReadArrayStart()
			if yyl272 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl272, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys273Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys273Slc
	var yyhl273 bool = l >= 0
	for yyj273 := 0; ; yyj273++ {
		if yyhl273 {
			if yyj273 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys273Slc = r.DecodeBytes(yys273Slc, true, true)
		yys273 := string(yys273Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys273 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv276 := &x.ObjectMeta
				yyv276.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = HorizontalPodAutoscalerSpec{}
			} else {
				yyv277 := &x.Spec
				yyv277.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = HorizontalPodAutoscalerStatus{}
			} else {
				yyv278 := &x.Status
				yyv278.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys273)
		} // end switch yys273
	} // end for yyj273
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj279 int
	var yyb279 bool
	var yyhl279 bool = l >= 0
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv282 := &x.ObjectMeta
		yyv282.CodecDecodeSelf(d)
	}
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = HorizontalPodAutoscalerSpec{}
	} else {
		yyv283 := &x.Spec
		yyv283.CodecDecodeSelf(d)
	}
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = HorizontalPodAutoscalerStatus{}
	} else {
		yyv284 := &x.Status
		yyv284.CodecDecodeSelf(d)
	}
	for {
		yyj279++
		if yyhl279 {
			yyb279 = yyj279 > l
		} else {
			yyb279 = r.CheckBreak()
		}
		if yyb279 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj279-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym285 := z.EncBinary()
		_ = yym285
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep286 := !z.EncBinary()
			yy2arr286 := z.EncBasicHandle().StructToArray
			var yyq286 [4]bool
			_, _, _ = yysep286, yyq286, yy2arr286
			const yyr286 bool = false
			yyq286[0] = x.Kind != ""
			yyq286[1] = x.APIVersion != ""
			yyq286[2] = true
			var yynn286 int
			if yyr286 || yy2arr286 {
				r.EncodeArrayStart(4)
			} else {
				yynn286 = 1
				for _, b := range yyq286 {
					if b {
						yynn286++
					}
				}
				r.EncodeMapStart(yynn286)
				yynn286 = 0
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq286[0] {
					yym288 := z.EncBinary()
					_ = yym288
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq286[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym289 := z.EncBinary()
					_ = yym289
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq286[1] {
					yym291 := z.EncBinary()
					_ = yym291
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq286[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym292 := z.EncBinary()
					_ = yym292
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq286[2] {
					yy294 := &x.ListMeta
					yym295 := z.EncBinary()
					_ = yym295
					if false {
					} else if z.HasExtensions() && z.EncExt(yy294) {
					} else {
						z.EncFallback(yy294)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq286[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy296 := &x.ListMeta
					yym297 := z.EncBinary()
					_ = yym297
					if false {
					} else if z.HasExtensions() && z.EncExt(yy296) {
					} else {
						z.EncFallback(yy296)
					}
				}
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym299 := z.EncBinary()
					_ = yym299
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym300 := z.EncBinary()
					_ = yym300
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym301 := z.DecBinary()
	_ = yym301
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct302 := r.ContainerType()
		if yyct302 == codecSelferValueTypeMap1234 {
			yyl302 := r.ReadMapStart()
			if yyl302 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl302, d)
			}
		} else if yyct302 == codecSelferValueTypeArray1234 {
			yyl302 := r.ReadArrayStart()
			if yyl302 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl302, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys303Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys303Slc
	var yyhl303 bool = l >= 0
	for yyj303 := 0; ; yyj303++ {
		if yyhl303 {
			if yyj303 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys303Slc = r.DecodeBytes(yys303Slc, true, true)
		yys303 := string(yys303Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys303 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv306 := &x.ListMeta
				yym307 := z.DecBinary()
				_ = yym307
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv306) {
				} else {
					z.DecFallback(yyv306, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv308 := &x.Items
				yym309 := z.DecBinary()
				_ = yym309
				if false {
				} else {
					h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv308), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys303)
		} // end switch yys303
	} // end for yyj303
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj310 int
	var yyb310 bool
	var yyhl310 bool = l >= 0
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv313 := &x.ListMeta
		yym314 := z.DecBinary()
		_ = yym314
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv313) {
		} else {
			z.DecFallback(yyv313, false)
		}
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv315 := &x.Items
		yym316 := z.DecBinary()
		_ = yym316
		if false {
		} else {
			h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv315), d)
		}
	}
	for {
		yyj310++
		if yyhl310 {
			yyb310 = yyj310 > l
		} else {
			yyb310 = r.CheckBreak()
		}
		if yyb310 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj310-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym317 := z.EncBinary()
		_ = yym317
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep318 := !z.EncBinary()
			yy2arr318 := z.EncBasicHandle().StructToArray
			var yyq318 [5]bool
			_, _, _ = yysep318, yyq318, yy2arr318
			const yyr318 bool = false
			yyq318[0] = x.Kind != ""
			yyq318[1] = x.APIVersion != ""
			yyq318[2] = true
			yyq318[3] = x.Description != ""
			yyq318[4] = len(x.Versions) != 0
			var yynn318 int
			if yyr318 || yy2arr318 {
				r.EncodeArrayStart(5)
			} else {
				yynn318 = 0
				for _, b := range yyq318 {
					if b {
						yynn318++
					}
				}
				r.EncodeMapStart(yynn318)
				yynn318 = 0
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[0] {
					yym320 := z.EncBinary()
					_ = yym320
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq318[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym321 := z.EncBinary()
					_ = yym321
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[1] {
					yym323 := z.EncBinary()
					_ = yym323
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq318[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym324 := z.EncBinary()
					_ = yym324
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[2] {
					yy326 := &x.ObjectMeta
					yy326.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq318[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy327 := &x.ObjectMeta
					yy327.CodecEncodeSelf(e)
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[3] {
					yym329 := z.EncBinary()
					_ = yym329
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq318[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("description"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym330 := z.EncBinary()
					_ = yym330
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[4] {
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym332 := z.EncBinary()
						_ = yym332
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq318[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("versions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym333 := z.EncBinary()
						_ = yym333
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym334 := z.DecBinary()
	_ = yym334
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct335 := r.ContainerType()
		if yyct335 == codecSelferValueTypeMap1234 {
			yyl335 := r.ReadMapStart()
			if yyl335 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl335, d)
			}
		} else if yyct335 == codecSelferValueTypeArray1234 {
			yyl335 := r.ReadArrayStart()
			if yyl335 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl335, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys336Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys336Slc
	var yyhl336 bool = l >= 0
	for yyj336 := 0; ; yyj336++ {
		if yyhl336 {
			if yyj336 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys336Slc = r.DecodeBytes(yys336Slc, true, true)
		yys336 := string(yys336Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys336 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv339 := &x.ObjectMeta
				yyv339.CodecDecodeSelf(d)
			}
		case "description":
			if r.TryDecodeAsNil() {
				x.Description = ""
			} else {
				x.Description = string(r.DecodeString())
			}
		case "versions":
			if r.TryDecodeAsNil() {
				x.Versions = nil
			} else {
				yyv341 := &x.Versions
				yym342 := z.DecBinary()
				_ = yym342
				if false {
				} else {
					h.decSliceAPIVersion((*[]APIVersion)(yyv341), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys336)
		} // end switch yys336
	} // end for yyj336
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj343 int
	var yyb343 bool
	var yyhl343 bool = l >= 0
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv346 := &x.ObjectMeta
		yyv346.CodecDecodeSelf(d)
	}
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Description = ""
	} else {
		x.Description = string(r.DecodeString())
	}
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Versions = nil
	} else {
		yyv348 := &x.Versions
		yym349 := z.DecBinary()
		_ = yym349
		if false {
		} else {
			h.decSliceAPIVersion((*[]APIVersion)(yyv348), d)
		}
	}
	for {
		yyj343++
		if yyhl343 {
			yyb343 = yyj343 > l
		} else {
			yyb343 = r.CheckBreak()
		}
		if yyb343 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj343-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym350 := z.EncBinary()
		_ = yym350
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep351 := !z.EncBinary()
			yy2arr351 := z.EncBasicHandle().StructToArray
			var yyq351 [4]bool
			_, _, _ = yysep351, yyq351, yy2arr351
			const yyr351 bool = false
			yyq351[0] = x.Kind != ""
			yyq351[1] = x.APIVersion != ""
			yyq351[2] = true
			var yynn351 int
			if yyr351 || yy2arr351 {
				r.EncodeArrayStart(4)
			} else {
				yynn351 = 1
				for _, b := range yyq351 {
					if b {
						yynn351++
					}
				}
				r.EncodeMapStart(yynn351)
				yynn351 = 0
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[0] {
					yym353 := z.EncBinary()
					_ = yym353
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq351[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym354 := z.EncBinary()
					_ = yym354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[1] {
					yym356 := z.EncBinary()
					_ = yym356
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq351[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym357 := z.EncBinary()
					_ = yym357
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[2] {
					yy359 := &x.ListMeta
					yym360 := z.EncBinary()
					_ = yym360
					if false {
					} else if z.HasExtensions() && z.EncExt(yy359) {
					} else {
						z.EncFallback(yy359)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq351[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy361 := &x.ListMeta
					yym362 := z.EncBinary()
					_ = yym362
					if false {
					} else if z.HasExtensions() && z.EncExt(yy361) {
					} else {
						z.EncFallback(yy361)
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym364 := z.EncBinary()
					_ = yym364
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym365 := z.EncBinary()
					_ = yym365
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym366 := z.DecBinary()
	_ = yym366
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct367 := r.ContainerType()
		if yyct367 == codecSelferValueTypeMap1234 {
			yyl367 := r.ReadMapStart()
			if yyl367 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl367, d)
			}
		} else if yyct367 == codecSelferValueTypeArray1234 {
			yyl367 := r.ReadArrayStart()
			if yyl367 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl367, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys368Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys368Slc
	var yyhl368 bool = l >= 0
	for yyj368 := 0; ; yyj368++ {
		if yyhl368 {
			if yyj368 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys368Slc = r.DecodeBytes(yys368Slc, true, true)
		yys368 := string(yys368Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys368 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv371 := &x.ListMeta
				yym372 := z.DecBinary()
				_ = yym372
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv371) {
				} else {
					z.DecFallback(yyv371, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv373 := &x.Items
				yym374 := z.DecBinary()
				_ = yym374
				if false {
				} else {
					h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv373), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys368)
		} // end switch yys368
	} // end for yyj368
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj375 int
	var yyb375 bool
	var yyhl375 bool = l >= 0
	yyj375++
	if yyhl375 {
		yyb375 = yyj375 > l
	} else {
		yyb375 = r.CheckBreak()
	}
	if yyb375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj375++
	if yyhl375 {
		yyb375 = yyj375 > l
	} else {
		yyb375 = r.CheckBreak()
	}
	if yyb375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj375++
	if yyhl375 {
		yyb375 = yyj375 > l
	} else {
		yyb375 = r.CheckBreak()
	}
	if yyb375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv378 := &x.ListMeta
		yym379 := z.DecBinary()
		_ = yym379
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv378) {
		} else {
			z.DecFallback(yyv378, false)
		}
	}
	yyj375++
	if yyhl375 {
		yyb375 = yyj375 > l
	} else {
		yyb375 = r.CheckBreak()
	}
	if yyb375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv380 := &x.Items
		yym381 := z.DecBinary()
		_ = yym381
		if false {
		} else {
			h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv380), d)
		}
	}
	for {
		yyj375++
		if yyhl375 {
			yyb375 = yyj375 > l
		} else {
			yyb375 = r.CheckBreak()
		}
		if yyb375 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj375-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *APIVersion) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym382 := z.EncBinary()
		_ = yym382
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep383 := !z.EncBinary()
			yy2arr383 := z.EncBasicHandle().StructToArray
			var yyq383 [1]bool
			_, _, _ = yysep383, yyq383, yy2arr383
			const yyr383 bool = false
			yyq383[0] = x.Name != ""
			var yynn383 int
			if yyr383 || yy2arr383 {
				r.EncodeArrayStart(1)
			} else {
				yynn383 = 0
				for _, b := range yyq383 {
					if b {
						yynn383++
					}
				}
				r.EncodeMapStart(yynn383)
				yynn383 = 0
			}
			if yyr383 || yy2arr383 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq383[0] {
					yym385 := z.EncBinary()
					_ = yym385
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq383[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym386 := z.EncBinary()
					_ = yym386
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr383 || yy2arr383 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *APIVersion) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym387 := z.DecBinary()
	_ = yym387
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct388 := r.ContainerType()
		if yyct388 == codecSelferValueTypeMap1234 {
			yyl388 := r.ReadMapStart()
			if yyl388 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl388, d)
			}
		} else if yyct388 == codecSelferValueTypeArray1234 {
			yyl388 := r.ReadArrayStart()
			if yyl388 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl388, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *APIVersion) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys389Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys389Slc
	var yyhl389 bool = l >= 0
	for yyj389 := 0; ; yyj389++ {
		if yyhl389 {
			if yyj389 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys389Slc = r.DecodeBytes(yys389Slc, true, true)
		yys389 := string(yys389Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys389 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys389)
		} // end switch yys389
	} // end for yyj389
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *APIVersion) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj391 int
	var yyb391 bool
	var yyhl391 bool = l >= 0
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj391++
		if yyhl391 {
			yyb391 = yyj391 > l
		} else {
			yyb391 = r.CheckBreak()
		}
		if yyb391 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj391-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceData) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym393 := z.EncBinary()
		_ = yym393
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep394 := !z.EncBinary()
			yy2arr394 := z.EncBasicHandle().StructToArray
			var yyq394 [4]bool
			_, _, _ = yysep394, yyq394, yy2arr394
			const yyr394 bool = false
			yyq394[0] = x.Kind != ""
			yyq394[1] = x.APIVersion != ""
			yyq394[2] = true
			yyq394[3] = len(x.Data) != 0
			var yynn394 int
			if yyr394 || yy2arr394 {
				r.EncodeArrayStart(4)
			} else {
				yynn394 = 0
				for _, b := range yyq394 {
					if b {
						yynn394++
					}
				}
				r.EncodeMapStart(yynn394)
				yynn394 = 0
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq394[0] {
					yym396 := z.EncBinary()
					_ = yym396
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq394[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym397 := z.EncBinary()
					_ = yym397
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq394[1] {
					yym399 := z.EncBinary()
					_ = yym399
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq394[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym400 := z.EncBinary()
					_ = yym400
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq394[2] {
					yy402 := &x.ObjectMeta
					yy402.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq394[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy403 := &x.ObjectMeta
					yy403.CodecEncodeSelf(e)
				}
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq394[3] {
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym405 := z.EncBinary()
						_ = yym405
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq394[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("data"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym406 := z.EncBinary()
						_ = yym406
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				}
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceData) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym407 := z.DecBinary()
	_ = yym407
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct408 := r.ContainerType()
		if yyct408 == codecSelferValueTypeMap1234 {
			yyl408 := r.ReadMapStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl408, d)
			}
		} else if yyct408 == codecSelferValueTypeArray1234 {
			yyl408 := r.ReadArrayStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl408, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys409Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys409Slc
	var yyhl409 bool = l >= 0
	for yyj409 := 0; ; yyj409++ {
		if yyhl409 {
			if yyj409 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys409Slc = r.DecodeBytes(yys409Slc, true, true)
		yys409 := string(yys409Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys409 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv412 := &x.ObjectMeta
				yyv412.CodecDecodeSelf(d)
			}
		case "data":
			if r.TryDecodeAsNil() {
				x.Data = nil
			} else {
				yyv413 := &x.Data
				yym414 := z.DecBinary()
				_ = yym414
				if false {
				} else {
					*yyv413 = r.DecodeBytes(*(*[]byte)(yyv413), false, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys409)
		} // end switch yys409
	} // end for yyj409
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj415 int
	var yyb415 bool
	var yyhl415 bool = l >= 0
	yyj415++
	if yyhl415 {
		yyb415 = yyj415 > l
	} else {
		yyb415 = r.CheckBreak()
	}
	if yyb415 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj415++
	if yyhl415 {
		yyb415 = yyj415 > l
	} else {
		yyb415 = r.CheckBreak()
	}
	if yyb415 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj415++
	if yyhl415 {
		yyb415 = yyj415 > l
	} else {
		yyb415 = r.CheckBreak()
	}
	if yyb415 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv418 := &x.ObjectMeta
		yyv418.CodecDecodeSelf(d)
	}
	yyj415++
	if yyhl415 {
		yyb415 = yyj415 > l
	} else {
		yyb415 = r.CheckBreak()
	}
	if yyb415 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Data = nil
	} else {
		yyv419 := &x.Data
		yym420 := z.DecBinary()
		_ = yym420
		if false {
		} else {
			*yyv419 = r.DecodeBytes(*(*[]byte)(yyv419), false, false)
		}
	}
	for {
		yyj415++
		if yyhl415 {
			yyb415 = yyj415 > l
		} else {
			yyb415 = r.CheckBreak()
		}
		if yyb415 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj415-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Deployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym421 := z.EncBinary()
		_ = yym421
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep422 := !z.EncBinary()
			yy2arr422 := z.EncBasicHandle().StructToArray
			var yyq422 [5]bool
			_, _, _ = yysep422, yyq422, yy2arr422
			const yyr422 bool = false
			yyq422[0] = x.Kind != ""
			yyq422[1] = x.APIVersion != ""
			yyq422[2] = true
			yyq422[3] = true
			yyq422[4] = true
			var yynn422 int
			if yyr422 || yy2arr422 {
				r.EncodeArrayStart(5)
			} else {
				yynn422 = 0
				for _, b := range yyq422 {
					if b {
						yynn422++
					}
				}
				r.EncodeMapStart(yynn422)
				yynn422 = 0
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[0] {
					yym424 := z.EncBinary()
					_ = yym424
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq422[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym425 := z.EncBinary()
					_ = yym425
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[1] {
					yym427 := z.EncBinary()
					_ = yym427
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq422[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym428 := z.EncBinary()
					_ = yym428
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[2] {
					yy430 := &x.ObjectMeta
					yy430.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq422[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy431 := &x.ObjectMeta
					yy431.CodecEncodeSelf(e)
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[3] {
					yy433 := &x.Spec
					yy433.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq422[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy434 := &x.Spec
					yy434.CodecEncodeSelf(e)
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[4] {
					yy436 := &x.Status
					yy436.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq422[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy437 := &x.Status
					yy437.CodecEncodeSelf(e)
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Deployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym438 := z.DecBinary()
	_ = yym438
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct439 := r.ContainerType()
		if yyct439 == codecSelferValueTypeMap1234 {
			yyl439 := r.ReadMapStart()
			if yyl439 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl439, d)
			}
		} else if yyct439 == codecSelferValueTypeArray1234 {
			yyl439 := r.ReadArrayStart()
			if yyl439 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl439, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Deployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys440Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys440Slc
	var yyhl440 bool = l >= 0
	for yyj440 := 0; ; yyj440++ {
		if yyhl440 {
			if yyj440 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys440Slc = r.DecodeBytes(yys440Slc, true, true)
		yys440 := string(yys440Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys440 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv443 := &x.ObjectMeta
				yyv443.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DeploymentSpec{}
			} else {
				yyv444 := &x.Spec
				yyv444.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DeploymentStatus{}
			} else {
				yyv445 := &x.Status
				yyv445.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys440)
		} // end switch yys440
	} // end for yyj440
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Deployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj446 int
	var yyb446 bool
	var yyhl446 bool = l >= 0
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv449 := &x.ObjectMeta
		yyv449.CodecDecodeSelf(d)
	}
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DeploymentSpec{}
	} else {
		yyv450 := &x.Spec
		yyv450.CodecDecodeSelf(d)
	}
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DeploymentStatus{}
	} else {
		yyv451 := &x.Status
		yyv451.CodecDecodeSelf(d)
	}
	for {
		yyj446++
		if yyhl446 {
			yyb446 = yyj446 > l
		} else {
			yyb446 = r.CheckBreak()
		}
		if yyb446 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj446-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym452 := z.EncBinary()
		_ = yym452
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep453 := !z.EncBinary()
			yy2arr453 := z.EncBasicHandle().StructToArray
			var yyq453 [8]bool
			_, _, _ = yysep453, yyq453, yy2arr453
			const yyr453 bool = false
			yyq453[0] = x.Replicas != nil
			yyq453[1] = x.Selector != nil
			yyq453[3] = true
			yyq453[4] = x.MinReadySeconds != 0
			yyq453[5] = x.RevisionHistoryLimit != nil
			yyq453[6] = x.Paused != false
			yyq453[7] = x.RollbackTo != nil
			var yynn453 int
			if yyr453 || yy2arr453 {
				r.EncodeArrayStart(8)
			} else {
				yynn453 = 1
				for _, b := range yyq453 {
					if b {
						yynn453++
					}
				}
				r.EncodeMapStart(yynn453)
				yynn453 = 0
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy455 := *x.Replicas
						yym456 := z.EncBinary()
						_ = yym456
						if false {
						} else {
							r.EncodeInt(int64(yy455))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy457 := *x.Replicas
						yym458 := z.EncBinary()
						_ = yym458
						if false {
						} else {
							r.EncodeInt(int64(yy457))
						}
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy461 := &x.Template
				yy461.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy462 := &x.Template
				yy462.CodecEncodeSelf(e)
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[3] {
					yy464 := &x.Strategy
					yy464.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("strategy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy465 := &x.Strategy
					yy465.CodecEncodeSelf(e)
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[4] {
					yym467 := z.EncBinary()
					_ = yym467
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq453[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym468 := z.EncBinary()
					_ = yym468
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[5] {
					if x.RevisionHistoryLimit == nil {
						r.EncodeNil()
					} else {
						yy470 := *x.RevisionHistoryLimit
						yym471 := z.EncBinary()
						_ = yym471
						if false {
						} else {
							r.EncodeInt(int64(yy470))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revisionHistoryLimit"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RevisionHistoryLimit == nil {
						r.EncodeNil()
					} else {
						yy472 := *x.RevisionHistoryLimit
						yym473 := z.EncBinary()
						_ = yym473
						if false {
						} else {
							r.EncodeInt(int64(yy472))
						}
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[6] {
					yym475 := z.EncBinary()
					_ = yym475
					if false {
					} else {
						r.EncodeBool(bool(x.Paused))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq453[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("paused"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym476 := z.EncBinary()
					_ = yym476
					if false {
					} else {
						r.EncodeBool(bool(x.Paused))
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[7] {
					if x.RollbackTo == nil {
						r.EncodeNil()
					} else {
						x.RollbackTo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollbackTo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollbackTo == nil {
						r.EncodeNil()
					} else {
						x.RollbackTo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym478 := z.DecBinary()
	_ = yym478
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct479 := r.ContainerType()
		if yyct479 == codecSelferValueTypeMap1234 {
			yyl479 := r.ReadMapStart()
			if yyl479 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl479, d)
			}
		} else if yyct479 == codecSelferValueTypeArray1234 {
			yyl479 := r.ReadArrayStart()
			if yyl479 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl479, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys480Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys480Slc
	var yyhl480 bool = l >= 0
	for yyj480 := 0; ; yyj480++ {
		if yyhl480 {
			if yyj480 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys480Slc = r.DecodeBytes(yys480Slc, true, true)
		yys480 := string(yys480Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys480 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym482 := z.DecBinary()
				_ = yym482
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv484 := &x.Template
				yyv484.CodecDecodeSelf(d)
			}
		case "strategy":
			if r.TryDecodeAsNil() {
				x.Strategy = DeploymentStrategy{}
			} else {
				yyv485 := &x.Strategy
				yyv485.CodecDecodeSelf(d)
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		case "revisionHistoryLimit":
			if r.TryDecodeAsNil() {
				if x.RevisionHistoryLimit != nil {
					x.RevisionHistoryLimit = nil
				}
			} else {
				if x.RevisionHistoryLimit == nil {
					x.RevisionHistoryLimit = new(int32)
				}
				yym488 := z.DecBinary()
				_ = yym488
				if false {
				} else {
					*((*int32)(x.RevisionHistoryLimit)) = int32(r.DecodeInt(32))
				}
			}
		case "paused":
			if r.TryDecodeAsNil() {
				x.Paused = false
			} else {
				x.Paused = bool(r.DecodeBool())
			}
		case "rollbackTo":
			if r.TryDecodeAsNil() {
				if x.RollbackTo != nil {
					x.RollbackTo = nil
				}
			} else {
				if x.RollbackTo == nil {
					x.RollbackTo = new(RollbackConfig)
				}
				x.RollbackTo.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys480)
		} // end switch yys480
	} // end for yyj480
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj491 int
	var yyb491 bool
	var yyhl491 bool = l >= 0
	yyj491++
	if yyhl491 {
		yyb491 = yyj491 > l
	} else {
		yyb491 = r.CheckBreak()
	}
	if yyb491 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym493 := z.DecBinary()
		_ = yym493
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj491++
	if yyhl491 {
		yyb491 = yyj491 > l
	} else {
		yyb491 = r.CheckBreak()
	}
	if yyb491 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj491++
	if yyhl491 {
		yyb491 = yyj491 > l
	} else {
		yyb491 = r.CheckBreak()
	}
	if yyb491 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv495 := &x.Template
		yyv495.CodecDecodeSelf(d)
	}
	yyj491++
	if yyhl491 {
		yyb491 = yyj491 > l
	} else {
		yyb491 = r.CheckBreak()
	}
	if yyb491 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Strategy = DeploymentStrategy{}
	} else {
		yyv496 := &x.Strategy
		yyv496.CodecDecodeSelf(d)
	}
	yyj491++
	if yyhl491 {
		yyb491 = yyj491 > l
	} else {
		yyb491 = r.CheckBreak()
	}
	if yyb491 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	yyj491++
	if yyhl491 {
		yyb491 = yyj491 > l
	} else {
		yyb491 = r.CheckBreak()
	}
	if yyb491 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RevisionHistoryLimit != nil {
			x.RevisionHistoryLimit = nil
		}
	} else {
		if x.RevisionHistoryLimit == nil {
			x.RevisionHistoryLimit = new(int32)
		}
		yym499 := z.DecBinary()
		_ = yym499
		if false {
		} else {
			*((*int32)(x.RevisionHistoryLimit)) = int32(r.DecodeInt(32))
		}
	}
	yyj491++
	if yyhl491 {
		yyb491 = yyj491 > l
	} else {
		yyb491 = r.CheckBreak()
	}
	if yyb491 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paused = false
	} else {
		x.Paused = bool(r.DecodeBool())
	}
	yyj491++
	if yyhl491 {
		yyb491 = yyj491 > l
	} else {
		yyb491 = r.CheckBreak()
	}
	if yyb491 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollbackTo != nil {
			x.RollbackTo = nil
		}
	} else {
		if x.RollbackTo == nil {
			x.RollbackTo = new(RollbackConfig)
		}
		x.RollbackTo.CodecDecodeSelf(d)
	}
	for {
		yyj491++
		if yyhl491 {
			yyb491 = yyj491 > l
		} else {
			yyb491 = r.CheckBreak()
		}
		if yyb491 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj491-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentRollback) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym502 := z.EncBinary()
		_ = yym502
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep503 := !z.EncBinary()
			yy2arr503 := z.EncBasicHandle().StructToArray
			var yyq503 [5]bool
			_, _, _ = yysep503, yyq503, yy2arr503
			const yyr503 bool = false
			yyq503[0] = x.Kind != ""
			yyq503[1] = x.APIVersion != ""
			yyq503[3] = len(x.UpdatedAnnotations) != 0
			var yynn503 int
			if yyr503 || yy2arr503 {
				r.EncodeArrayStart(5)
			} else {
				yynn503 = 2
				for _, b := range yyq503 {
					if b {
						yynn503++
					}
				}
				r.EncodeMapStart(yynn503)
				yynn503 = 0
			}
			if yyr503 || yy2arr503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq503[0] {
					yym505 := z.EncBinary()
					_ = yym505
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq503[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym506 := z.EncBinary()
					_ = yym506
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr503 || yy2arr503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq503[1] {
					yym508 := z.EncBinary()
					_ = yym508
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq503[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym509 := z.EncBinary()
					_ = yym509
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr503 || yy2arr503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym511 := z.EncBinary()
				_ = yym511
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym512 := z.EncBinary()
				_ = yym512
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr503 || yy2arr503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq503[3] {
					if x.UpdatedAnnotations == nil {
						r.EncodeNil()
					} else {
						yym514 := z.EncBinary()
						_ = yym514
						if false {
						} else {
							z.F.EncMapStringStringV(x.UpdatedAnnotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq503[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedAnnotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.UpdatedAnnotations == nil {
						r.EncodeNil()
					} else {
						yym515 := z.EncBinary()
						_ = yym515
						if false {
						} else {
							z.F.EncMapStringStringV(x.UpdatedAnnotations, false, e)
						}
					}
				}
			}
			if yyr503 || yy2arr503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy517 := &x.RollbackTo
				yy517.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rollbackTo"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy518 := &x.RollbackTo
				yy518.CodecEncodeSelf(e)
			}
			if yyr503 || yy2arr503 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentRollback) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym519 := z.DecBinary()
	_ = yym519
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct520 := r.ContainerType()
		if yyct520 == codecSelferValueTypeMap1234 {
			yyl520 := r.ReadMapStart()
			if yyl520 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl520, d)
			}
		} else if yyct520 == codecSelferValueTypeArray1234 {
			yyl520 := r.ReadArrayStart()
			if yyl520 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl520, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentRollback) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys521Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys521Slc
	var yyhl521 bool = l >= 0
	for yyj521 := 0; ; yyj521++ {
		if yyhl521 {
			if yyj521 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys521Slc = r.DecodeBytes(yys521Slc, true, true)
		yys521 := string(yys521Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys521 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "updatedAnnotations":
			if r.TryDecodeAsNil() {
				x.UpdatedAnnotations = nil
			} else {
				yyv525 := &x.UpdatedAnnotations
				yym526 := z.DecBinary()
				_ = yym526
				if false {
				} else {
					z.F.DecMapStringStringX(yyv525, false, d)
				}
			}
		case "rollbackTo":
			if r.TryDecodeAsNil() {
				x.RollbackTo = RollbackConfig{}
			} else {
				yyv527 := &x.RollbackTo
				yyv527.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys521)
		} // end switch yys521
	} // end for yyj521
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentRollback) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj528 int
	var yyb528 bool
	var yyhl528 bool = l >= 0
	yyj528++
	if yyhl528 {
		yyb528 = yyj528 > l
	} else {
		yyb528 = r.CheckBreak()
	}
	if yyb528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj528++
	if yyhl528 {
		yyb528 = yyj528 > l
	} else {
		yyb528 = r.CheckBreak()
	}
	if yyb528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj528++
	if yyhl528 {
		yyb528 = yyj528 > l
	} else {
		yyb528 = r.CheckBreak()
	}
	if yyb528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj528++
	if yyhl528 {
		yyb528 = yyj528 > l
	} else {
		yyb528 = r.CheckBreak()
	}
	if yyb528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedAnnotations = nil
	} else {
		yyv532 := &x.UpdatedAnnotations
		yym533 := z.DecBinary()
		_ = yym533
		if false {
		} else {
			z.F.DecMapStringStringX(yyv532, false, d)
		}
	}
	yyj528++
	if yyhl528 {
		yyb528 = yyj528 > l
	} else {
		yyb528 = r.CheckBreak()
	}
	if yyb528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RollbackTo = RollbackConfig{}
	} else {
		yyv534 := &x.RollbackTo
		yyv534.CodecDecodeSelf(d)
	}
	for {
		yyj528++
		if yyhl528 {
			yyb528 = yyj528 > l
		} else {
			yyb528 = r.CheckBreak()
		}
		if yyb528 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj528-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RollbackConfig) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym535 := z.EncBinary()
		_ = yym535
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep536 := !z.EncBinary()
			yy2arr536 := z.EncBasicHandle().StructToArray
			var yyq536 [1]bool
			_, _, _ = yysep536, yyq536, yy2arr536
			const yyr536 bool = false
			yyq536[0] = x.Revision != 0
			var yynn536 int
			if yyr536 || yy2arr536 {
				r.EncodeArrayStart(1)
			} else {
				yynn536 = 0
				for _, b := range yyq536 {
					if b {
						yynn536++
					}
				}
				r.EncodeMapStart(yynn536)
				yynn536 = 0
			}
			if yyr536 || yy2arr536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq536[0] {
					yym538 := z.EncBinary()
					_ = yym538
					if false {
					} else {
						r.EncodeInt(int64(x.Revision))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq536[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym539 := z.EncBinary()
					_ = yym539
					if false {
					} else {
						r.EncodeInt(int64(x.Revision))
					}
				}
			}
			if yyr536 || yy2arr536 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollbackConfig) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym540 := z.DecBinary()
	_ = yym540
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct541 := r.ContainerType()
		if yyct541 == codecSelferValueTypeMap1234 {
			yyl541 := r.ReadMapStart()
			if yyl541 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl541, d)
			}
		} else if yyct541 == codecSelferValueTypeArray1234 {
			yyl541 := r.ReadArrayStart()
			if yyl541 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl541, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollbackConfig) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys542Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys542Slc
	var yyhl542 bool = l >= 0
	for yyj542 := 0; ; yyj542++ {
		if yyhl542 {
			if yyj542 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys542Slc = r.DecodeBytes(yys542Slc, true, true)
		yys542 := string(yys542Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys542 {
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = 0
			} else {
				x.Revision = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys542)
		} // end switch yys542
	} // end for yyj542
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollbackConfig) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj544 int
	var yyb544 bool
	var yyhl544 bool = l >= 0
	yyj544++
	if yyhl544 {
		yyb544 = yyj544 > l
	} else {
		yyb544 = r.CheckBreak()
	}
	if yyb544 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = 0
	} else {
		x.Revision = int64(r.DecodeInt(64))
	}
	for {
		yyj544++
		if yyhl544 {
			yyb544 = yyj544 > l
		} else {
			yyb544 = r.CheckBreak()
		}
		if yyb544 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj544-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym546 := z.EncBinary()
		_ = yym546
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep547 := !z.EncBinary()
			yy2arr547 := z.EncBasicHandle().StructToArray
			var yyq547 [2]bool
			_, _, _ = yysep547, yyq547, yy2arr547
			const yyr547 bool = false
			yyq547[0] = x.Type != ""
			yyq547[1] = x.RollingUpdate != nil
			var yynn547 int
			if yyr547 || yy2arr547 {
				r.EncodeArrayStart(2)
			} else {
				yynn547 = 0
				for _, b := range yyq547 {
					if b {
						yynn547++
					}
				}
				r.EncodeMapStart(yynn547)
				yynn547 = 0
			}
			if yyr547 || yy2arr547 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq547[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq547[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr547 || yy2arr547 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq547[1] {
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq547[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollingUpdate"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				}
			}
			if yyr547 || yy2arr547 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym550 := z.DecBinary()
	_ = yym550
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct551 := r.ContainerType()
		if yyct551 == codecSelferValueTypeMap1234 {
			yyl551 := r.ReadMapStart()
			if yyl551 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl551, d)
			}
		} else if yyct551 == codecSelferValueTypeArray1234 {
			yyl551 := r.ReadArrayStart()
			if yyl551 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl551, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStrategy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys552Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys552Slc
	var yyhl552 bool = l >= 0
	for yyj552 := 0; ; yyj552++ {
		if yyhl552 {
			if yyj552 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys552Slc = r.DecodeBytes(yys552Slc, true, true)
		yys552 := string(yys552Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys552 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = DeploymentStrategyType(r.DecodeString())
			}
		case "rollingUpdate":
			if r.TryDecodeAsNil() {
				if x.RollingUpdate != nil {
					x.RollingUpdate = nil
				}
			} else {
				if x.RollingUpdate == nil {
					x.RollingUpdate = new(RollingUpdateDeployment)
				}
				x.RollingUpdate.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys552)
		} // end switch yys552
	} // end for yyj552
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStrategy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj555 int
	var yyb555 bool
	var yyhl555 bool = l >= 0
	yyj555++
	if yyhl555 {
		yyb555 = yyj555 > l
	} else {
		yyb555 = r.CheckBreak()
	}
	if yyb555 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = DeploymentStrategyType(r.DecodeString())
	}
	yyj555++
	if yyhl555 {
		yyb555 = yyj555 > l
	} else {
		yyb555 = r.CheckBreak()
	}
	if yyb555 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollingUpdate != nil {
			x.RollingUpdate = nil
		}
	} else {
		if x.RollingUpdate == nil {
			x.RollingUpdate = new(RollingUpdateDeployment)
		}
		x.RollingUpdate.CodecDecodeSelf(d)
	}
	for {
		yyj555++
		if yyhl555 {
			yyb555 = yyj555 > l
		} else {
			yyb555 = r.CheckBreak()
		}
		if yyb555 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj555-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DeploymentStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym558 := z.EncBinary()
	_ = yym558
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DeploymentStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym559 := z.DecBinary()
	_ = yym559
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RollingUpdateDeployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym560 := z.EncBinary()
		_ = yym560
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep561 := !z.EncBinary()
			yy2arr561 := z.EncBasicHandle().StructToArray
			var yyq561 [2]bool
			_, _, _ = yysep561, yyq561, yy2arr561
			const yyr561 bool = false
			yyq561[0] = x.MaxUnavailable != nil
			yyq561[1] = x.MaxSurge != nil
			var yynn561 int
			if yyr561 || yy2arr561 {
				r.EncodeArrayStart(2)
			} else {
				yynn561 = 0
				for _, b := range yyq561 {
					if b {
						yynn561++
					}
				}
				r.EncodeMapStart(yynn561)
				yynn561 = 0
			}
			if yyr561 || yy2arr561 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq561[0] {
					if x.MaxUnavailable == nil {
						r.EncodeNil()
					} else {
						yym563 := z.EncBinary()
						_ = yym563
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxUnavailable) {
						} else if !yym563 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxUnavailable)
						} else {
							z.EncFallback(x.MaxUnavailable)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq561[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxUnavailable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MaxUnavailable == nil {
						r.EncodeNil()
					} else {
						yym564 := z.EncBinary()
						_ = yym564
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxUnavailable) {
						} else if !yym564 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxUnavailable)
						} else {
							z.EncFallback(x.MaxUnavailable)
						}
					}
				}
			}
			if yyr561 || yy2arr561 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq561[1] {
					if x.MaxSurge == nil {
						r.EncodeNil()
					} else {
						yym566 := z.EncBinary()
						_ = yym566
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxSurge) {
						} else if !yym566 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxSurge)
						} else {
							z.EncFallback(x.MaxSurge)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq561[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxSurge"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MaxSurge == nil {
						r.EncodeNil()
					} else {
						yym567 := z.EncBinary()
						_ = yym567
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxSurge) {
						} else if !yym567 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxSurge)
						} else {
							z.EncFallback(x.MaxSurge)
						}
					}
				}
			}
			if yyr561 || yy2arr561 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollingUpdateDeployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym568 := z.DecBinary()
	_ = yym568
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct569 := r.ContainerType()
		if yyct569 == codecSelferValueTypeMap1234 {
			yyl569 := r.ReadMapStart()
			if yyl569 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl569, d)
			}
		} else if yyct569 == codecSelferValueTypeArray1234 {
			yyl569 := r.ReadArrayStart()
			if yyl569 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl569, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys570Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys570Slc
	var yyhl570 bool = l >= 0
	for yyj570 := 0; ; yyj570++ {
		if yyhl570 {
			if yyj570 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys570Slc = r.DecodeBytes(yys570Slc, true, true)
		yys570 := string(yys570Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys570 {
		case "maxUnavailable":
			if r.TryDecodeAsNil() {
				if x.MaxUnavailable != nil {
					x.MaxUnavailable = nil
				}
			} else {
				if x.MaxUnavailable == nil {
					x.MaxUnavailable = new(pkg5_intstr.IntOrString)
				}
				yym572 := z.DecBinary()
				_ = yym572
				if false {
				} else if z.HasExtensions() && z.DecExt(x.MaxUnavailable) {
				} else if !yym572 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.MaxUnavailable)
				} else {
					z.DecFallback(x.MaxUnavailable, false)
				}
			}
		case "maxSurge":
			if r.TryDecodeAsNil() {
				if x.MaxSurge != nil {
					x.MaxSurge = nil
				}
			} else {
				if x.MaxSurge == nil {
					x.MaxSurge = new(pkg5_intstr.IntOrString)
				}
				yym574 := z.DecBinary()
				_ = yym574
				if false {
				} else if z.HasExtensions() && z.DecExt(x.MaxSurge) {
				} else if !yym574 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.MaxSurge)
				} else {
					z.DecFallback(x.MaxSurge, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys570)
		} // end switch yys570
	} // end for yyj570
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj575 int
	var yyb575 bool
	var yyhl575 bool = l >= 0
	yyj575++
	if yyhl575 {
		yyb575 = yyj575 > l
	} else {
		yyb575 = r.CheckBreak()
	}
	if yyb575 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MaxUnavailable != nil {
			x.MaxUnavailable = nil
		}
	} else {
		if x.MaxUnavailable == nil {
			x.MaxUnavailable = new(pkg5_intstr.IntOrString)
		}
		yym577 := z.DecBinary()
		_ = yym577
		if false {
		} else if z.HasExtensions() && z.DecExt(x.MaxUnavailable) {
		} else if !yym577 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.MaxUnavailable)
		} else {
			z.DecFallback(x.MaxUnavailable, false)
		}
	}
	yyj575++
	if yyhl575 {
		yyb575 = yyj575 > l
	} else {
		yyb575 = r.CheckBreak()
	}
	if yyb575 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MaxSurge != nil {
			x.MaxSurge = nil
		}
	} else {
		if x.MaxSurge == nil {
			x.MaxSurge = new(pkg5_intstr.IntOrString)
		}
		yym579 := z.DecBinary()
		_ = yym579
		if false {
		} else if z.HasExtensions() && z.DecExt(x.MaxSurge) {
		} else if !yym579 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.MaxSurge)
		} else {
			z.DecFallback(x.MaxSurge, false)
		}
	}
	for {
		yyj575++
		if yyhl575 {
			yyb575 = yyj575 > l
		} else {
			yyb575 = r.CheckBreak()
		}
		if yyb575 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj575-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym580 := z.EncBinary()
		_ = yym580
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep581 := !z.EncBinary()
			yy2arr581 := z.EncBasicHandle().StructToArray
			var yyq581 [5]bool
			_, _, _ = yysep581, yyq581, yy2arr581
			const yyr581 bool = false
			yyq581[0] = x.ObservedGeneration != 0
			yyq581[1] = x.Replicas != 0
			yyq581[2] = x.UpdatedReplicas != 0
			yyq581[3] = x.AvailableReplicas != 0
			yyq581[4] = x.UnavailableReplicas != 0
			var yynn581 int
			if yyr581 || yy2arr581 {
				r.EncodeArrayStart(5)
			} else {
				yynn581 = 0
				for _, b := range yyq581 {
					if b {
						yynn581++
					}
				}
				r.EncodeMapStart(yynn581)
				yynn581 = 0
			}
			if yyr581 || yy2arr581 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq581[0] {
					yym583 := z.EncBinary()
					_ = yym583
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq581[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym584 := z.EncBinary()
					_ = yym584
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr581 || yy2arr581 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq581[1] {
					yym586 := z.EncBinary()
					_ = yym586
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq581[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym587 := z.EncBinary()
					_ = yym587
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr581 || yy2arr581 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq581[2] {
					yym589 := z.EncBinary()
					_ = yym589
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq581[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym590 := z.EncBinary()
					_ = yym590
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				}
			}
			if yyr581 || yy2arr581 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq581[3] {
					yym592 := z.EncBinary()
					_ = yym592
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq581[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym593 := z.EncBinary()
					_ = yym593
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr581 || yy2arr581 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq581[4] {
					yym595 := z.EncBinary()
					_ = yym595
					if false {
					} else {
						r.EncodeInt(int64(x.UnavailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq581[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unavailableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym596 := z.EncBinary()
					_ = yym596
					if false {
					} else {
						r.EncodeInt(int64(x.UnavailableReplicas))
					}
				}
			}
			if yyr581 || yy2arr581 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym597 := z.DecBinary()
	_ = yym597
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct598 := r.ContainerType()
		if yyct598 == codecSelferValueTypeMap1234 {
			yyl598 := r.ReadMapStart()
			if yyl598 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl598, d)
			}
		} else if yyct598 == codecSelferValueTypeArray1234 {
			yyl598 := r.ReadArrayStart()
			if yyl598 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl598, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys599Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys599Slc
	var yyhl599 bool = l >= 0
	for yyj599 := 0; ; yyj599++ {
		if yyhl599 {
			if yyj599 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys599Slc = r.DecodeBytes(yys599Slc, true, true)
		yys599 := string(yys599Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys599 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "updatedReplicas":
			if r.TryDecodeAsNil() {
				x.UpdatedReplicas = 0
			} else {
				x.UpdatedReplicas = int32(r.DecodeInt(32))
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				x.AvailableReplicas = int32(r.DecodeInt(32))
			}
		case "unavailableReplicas":
			if r.TryDecodeAsNil() {
				x.UnavailableReplicas = 0
			} else {
				x.UnavailableReplicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys599)
		} // end switch yys599
	} // end for yyj599
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj605 int
	var yyb605 bool
	var yyhl605 bool = l >= 0
	yyj605++
	if yyhl605 {
		yyb605 = yyj605 > l
	} else {
		yyb605 = r.CheckBreak()
	}
	if yyb605 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj605++
	if yyhl605 {
		yyb605 = yyj605 > l
	} else {
		yyb605 = r.CheckBreak()
	}
	if yyb605 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj605++
	if yyhl605 {
		yyb605 = yyj605 > l
	} else {
		yyb605 = r.CheckBreak()
	}
	if yyb605 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedReplicas = 0
	} else {
		x.UpdatedReplicas = int32(r.DecodeInt(32))
	}
	yyj605++
	if yyhl605 {
		yyb605 = yyj605 > l
	} else {
		yyb605 = r.CheckBreak()
	}
	if yyb605 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		x.AvailableReplicas = int32(r.DecodeInt(32))
	}
	yyj605++
	if yyhl605 {
		yyb605 = yyj605 > l
	} else {
		yyb605 = r.CheckBreak()
	}
	if yyb605 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnavailableReplicas = 0
	} else {
		x.UnavailableReplicas = int32(r.DecodeInt(32))
	}
	for {
		yyj605++
		if yyhl605 {
			yyb605 = yyj605 > l
		} else {
			yyb605 = r.CheckBreak()
		}
		if yyb605 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj605-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym611 := z.EncBinary()
		_ = yym611
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep612 := !z.EncBinary()
			yy2arr612 := z.EncBasicHandle().StructToArray
			var yyq612 [4]bool
			_, _, _ = yysep612, yyq612, yy2arr612
			const yyr612 bool = false
			yyq612[0] = x.Kind != ""
			yyq612[1] = x.APIVersion != ""
			yyq612[2] = true
			var yynn612 int
			if yyr612 || yy2arr612 {
				r.EncodeArrayStart(4)
			} else {
				yynn612 = 1
				for _, b := range yyq612 {
					if b {
						yynn612++
					}
				}
				r.EncodeMapStart(yynn612)
				yynn612 = 0
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq612[0] {
					yym614 := z.EncBinary()
					_ = yym614
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq612[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym615 := z.EncBinary()
					_ = yym615
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq612[1] {
					yym617 := z.EncBinary()
					_ = yym617
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq612[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym618 := z.EncBinary()
					_ = yym618
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq612[2] {
					yy620 := &x.ListMeta
					yym621 := z.EncBinary()
					_ = yym621
					if false {
					} else if z.HasExtensions() && z.EncExt(yy620) {
					} else {
						z.EncFallback(yy620)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq612[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy622 := &x.ListMeta
					yym623 := z.EncBinary()
					_ = yym623
					if false {
					} else if z.HasExtensions() && z.EncExt(yy622) {
					} else {
						z.EncFallback(yy622)
					}
				}
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym625 := z.EncBinary()
					_ = yym625
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym626 := z.EncBinary()
					_ = yym626
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			}
			if yyr612 || yy2arr612 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym627 := z.DecBinary()
	_ = yym627
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct628 := r.ContainerType()
		if yyct628 == codecSelferValueTypeMap1234 {
			yyl628 := r.ReadMapStart()
			if yyl628 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl628, d)
			}
		} else if yyct628 == codecSelferValueTypeArray1234 {
			yyl628 := r.ReadArrayStart()
			if yyl628 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl628, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys629Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys629Slc
	var yyhl629 bool = l >= 0
	for yyj629 := 0; ; yyj629++ {
		if yyhl629 {
			if yyj629 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys629Slc = r.DecodeBytes(yys629Slc, true, true)
		yys629 := string(yys629Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys629 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv632 := &x.ListMeta
				yym633 := z.DecBinary()
				_ = yym633
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv632) {
				} else {
					z.DecFallback(yyv632, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv634 := &x.Items
				yym635 := z.DecBinary()
				_ = yym635
				if false {
				} else {
					h.decSliceDeployment((*[]Deployment)(yyv634), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys629)
		} // end switch yys629
	} // end for yyj629
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj636 int
	var yyb636 bool
	var yyhl636 bool = l >= 0
	yyj636++
	if yyhl636 {
		yyb636 = yyj636 > l
	} else {
		yyb636 = r.CheckBreak()
	}
	if yyb636 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj636++
	if yyhl636 {
		yyb636 = yyj636 > l
	} else {
		yyb636 = r.CheckBreak()
	}
	if yyb636 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj636++
	if yyhl636 {
		yyb636 = yyj636 > l
	} else {
		yyb636 = r.CheckBreak()
	}
	if yyb636 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv639 := &x.ListMeta
		yym640 := z.DecBinary()
		_ = yym640
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv639) {
		} else {
			z.DecFallback(yyv639, false)
		}
	}
	yyj636++
	if yyhl636 {
		yyb636 = yyj636 > l
	} else {
		yyb636 = r.CheckBreak()
	}
	if yyb636 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv641 := &x.Items
		yym642 := z.DecBinary()
		_ = yym642
		if false {
		} else {
			h.decSliceDeployment((*[]Deployment)(yyv641), d)
		}
	}
	for {
		yyj636++
		if yyhl636 {
			yyb636 = yyj636 > l
		} else {
			yyb636 = r.CheckBreak()
		}
		if yyb636 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj636-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym643 := z.EncBinary()
		_ = yym643
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep644 := !z.EncBinary()
			yy2arr644 := z.EncBasicHandle().StructToArray
			var yyq644 [2]bool
			_, _, _ = yysep644, yyq644, yy2arr644
			const yyr644 bool = false
			yyq644[0] = x.Selector != nil
			var yynn644 int
			if yyr644 || yy2arr644 {
				r.EncodeArrayStart(2)
			} else {
				yynn644 = 1
				for _, b := range yyq644 {
					if b {
						yynn644++
					}
				}
				r.EncodeMapStart(yynn644)
				yynn644 = 0
			}
			if yyr644 || yy2arr644 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq644[0] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq644[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr644 || yy2arr644 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy647 := &x.Template
				yy647.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy648 := &x.Template
				yy648.CodecEncodeSelf(e)
			}
			if yyr644 || yy2arr644 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym649 := z.DecBinary()
	_ = yym649
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct650 := r.ContainerType()
		if yyct650 == codecSelferValueTypeMap1234 {
			yyl650 := r.ReadMapStart()
			if yyl650 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl650, d)
			}
		} else if yyct650 == codecSelferValueTypeArray1234 {
			yyl650 := r.ReadArrayStart()
			if yyl650 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl650, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys651Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys651Slc
	var yyhl651 bool = l >= 0
	for yyj651 := 0; ; yyj651++ {
		if yyhl651 {
			if yyj651 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys651Slc = r.DecodeBytes(yys651Slc, true, true)
		yys651 := string(yys651Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys651 {
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv653 := &x.Template
				yyv653.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys651)
		} // end switch yys651
	} // end for yyj651
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj654 int
	var yyb654 bool
	var yyhl654 bool = l >= 0
	yyj654++
	if yyhl654 {
		yyb654 = yyj654 > l
	} else {
		yyb654 = r.CheckBreak()
	}
	if yyb654 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj654++
	if yyhl654 {
		yyb654 = yyj654 > l
	} else {
		yyb654 = r.CheckBreak()
	}
	if yyb654 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv656 := &x.Template
		yyv656.CodecDecodeSelf(d)
	}
	for {
		yyj654++
		if yyhl654 {
			yyb654 = yyj654 > l
		} else {
			yyb654 = r.CheckBreak()
		}
		if yyb654 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj654-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym657 := z.EncBinary()
		_ = yym657
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep658 := !z.EncBinary()
			yy2arr658 := z.EncBasicHandle().StructToArray
			var yyq658 [3]bool
			_, _, _ = yysep658, yyq658, yy2arr658
			const yyr658 bool = false
			var yynn658 int
			if yyr658 || yy2arr658 {
				r.EncodeArrayStart(3)
			} else {
				yynn658 = 3
				for _, b := range yyq658 {
					if b {
						yynn658++
					}
				}
				r.EncodeMapStart(yynn658)
				yynn658 = 0
			}
			if yyr658 || yy2arr658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym660 := z.EncBinary()
				_ = yym660
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym661 := z.EncBinary()
				_ = yym661
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			}
			if yyr658 || yy2arr658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym663 := z.EncBinary()
				_ = yym663
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("numberMisscheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym664 := z.EncBinary()
				_ = yym664
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			}
			if yyr658 || yy2arr658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym666 := z.EncBinary()
				_ = yym666
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym667 := z.EncBinary()
				_ = yym667
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			}
			if yyr658 || yy2arr658 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym668 := z.DecBinary()
	_ = yym668
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct669 := r.ContainerType()
		if yyct669 == codecSelferValueTypeMap1234 {
			yyl669 := r.ReadMapStart()
			if yyl669 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl669, d)
			}
		} else if yyct669 == codecSelferValueTypeArray1234 {
			yyl669 := r.ReadArrayStart()
			if yyl669 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl669, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys670Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys670Slc
	var yyhl670 bool = l >= 0
	for yyj670 := 0; ; yyj670++ {
		if yyhl670 {
			if yyj670 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys670Slc = r.DecodeBytes(yys670Slc, true, true)
		yys670 := string(yys670Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys670 {
		case "currentNumberScheduled":
			if r.TryDecodeAsNil() {
				x.CurrentNumberScheduled = 0
			} else {
				x.CurrentNumberScheduled = int32(r.DecodeInt(32))
			}
		case "numberMisscheduled":
			if r.TryDecodeAsNil() {
				x.NumberMisscheduled = 0
			} else {
				x.NumberMisscheduled = int32(r.DecodeInt(32))
			}
		case "desiredNumberScheduled":
			if r.TryDecodeAsNil() {
				x.DesiredNumberScheduled = 0
			} else {
				x.DesiredNumberScheduled = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys670)
		} // end switch yys670
	} // end for yyj670
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj674 int
	var yyb674 bool
	var yyhl674 bool = l >= 0
	yyj674++
	if yyhl674 {
		yyb674 = yyj674 > l
	} else {
		yyb674 = r.CheckBreak()
	}
	if yyb674 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentNumberScheduled = 0
	} else {
		x.CurrentNumberScheduled = int32(r.DecodeInt(32))
	}
	yyj674++
	if yyhl674 {
		yyb674 = yyj674 > l
	} else {
		yyb674 = r.CheckBreak()
	}
	if yyb674 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NumberMisscheduled = 0
	} else {
		x.NumberMisscheduled = int32(r.DecodeInt(32))
	}
	yyj674++
	if yyhl674 {
		yyb674 = yyj674 > l
	} else {
		yyb674 = r.CheckBreak()
	}
	if yyb674 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredNumberScheduled = 0
	} else {
		x.DesiredNumberScheduled = int32(r.DecodeInt(32))
	}
	for {
		yyj674++
		if yyhl674 {
			yyb674 = yyj674 > l
		} else {
			yyb674 = r.CheckBreak()
		}
		if yyb674 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj674-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym678 := z.EncBinary()
		_ = yym678
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep679 := !z.EncBinary()
			yy2arr679 := z.EncBasicHandle().StructToArray
			var yyq679 [5]bool
			_, _, _ = yysep679, yyq679, yy2arr679
			const yyr679 bool = false
			yyq679[0] = x.Kind != ""
			yyq679[1] = x.APIVersion != ""
			yyq679[2] = true
			yyq679[3] = true
			yyq679[4] = true
			var yynn679 int
			if yyr679 || yy2arr679 {
				r.EncodeArrayStart(5)
			} else {
				yynn679 = 0
				for _, b := range yyq679 {
					if b {
						yynn679++
					}
				}
				r.EncodeMapStart(yynn679)
				yynn679 = 0
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq679[0] {
					yym681 := z.EncBinary()
					_ = yym681
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq679[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym682 := z.EncBinary()
					_ = yym682
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq679[1] {
					yym684 := z.EncBinary()
					_ = yym684
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq679[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym685 := z.EncBinary()
					_ = yym685
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq679[2] {
					yy687 := &x.ObjectMeta
					yy687.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq679[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy688 := &x.ObjectMeta
					yy688.CodecEncodeSelf(e)
				}
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq679[3] {
					yy690 := &x.Spec
					yy690.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq679[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy691 := &x.Spec
					yy691.CodecEncodeSelf(e)
				}
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq679[4] {
					yy693 := &x.Status
					yy693.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq679[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy694 := &x.Status
					yy694.CodecEncodeSelf(e)
				}
			}
			if yyr679 || yy2arr679 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym695 := z.DecBinary()
	_ = yym695
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct696 := r.ContainerType()
		if yyct696 == codecSelferValueTypeMap1234 {
			yyl696 := r.ReadMapStart()
			if yyl696 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl696, d)
			}
		} else if yyct696 == codecSelferValueTypeArray1234 {
			yyl696 := r.ReadArrayStart()
			if yyl696 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl696, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys697Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys697Slc
	var yyhl697 bool = l >= 0
	for yyj697 := 0; ; yyj697++ {
		if yyhl697 {
			if yyj697 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys697Slc = r.DecodeBytes(yys697Slc, true, true)
		yys697 := string(yys697Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys697 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv700 := &x.ObjectMeta
				yyv700.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DaemonSetSpec{}
			} else {
				yyv701 := &x.Spec
				yyv701.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DaemonSetStatus{}
			} else {
				yyv702 := &x.Status
				yyv702.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys697)
		} // end switch yys697
	} // end for yyj697
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj703 int
	var yyb703 bool
	var yyhl703 bool = l >= 0
	yyj703++
	if yyhl703 {
		yyb703 = yyj703 > l
	} else {
		yyb703 = r.CheckBreak()
	}
	if yyb703 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj703++
	if yyhl703 {
		yyb703 = yyj703 > l
	} else {
		yyb703 = r.CheckBreak()
	}
	if yyb703 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj703++
	if yyhl703 {
		yyb703 = yyj703 > l
	} else {
		yyb703 = r.CheckBreak()
	}
	if yyb703 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv706 := &x.ObjectMeta
		yyv706.CodecDecodeSelf(d)
	}
	yyj703++
	if yyhl703 {
		yyb703 = yyj703 > l
	} else {
		yyb703 = r.CheckBreak()
	}
	if yyb703 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DaemonSetSpec{}
	} else {
		yyv707 := &x.Spec
		yyv707.CodecDecodeSelf(d)
	}
	yyj703++
	if yyhl703 {
		yyb703 = yyj703 > l
	} else {
		yyb703 = r.CheckBreak()
	}
	if yyb703 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DaemonSetStatus{}
	} else {
		yyv708 := &x.Status
		yyv708.CodecDecodeSelf(d)
	}
	for {
		yyj703++
		if yyhl703 {
			yyb703 = yyj703 > l
		} else {
			yyb703 = r.CheckBreak()
		}
		if yyb703 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj703-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym709 := z.EncBinary()
		_ = yym709
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep710 := !z.EncBinary()
			yy2arr710 := z.EncBasicHandle().StructToArray
			var yyq710 [4]bool
			_, _, _ = yysep710, yyq710, yy2arr710
			const yyr710 bool = false
			yyq710[0] = x.Kind != ""
			yyq710[1] = x.APIVersion != ""
			yyq710[2] = true
			var yynn710 int
			if yyr710 || yy2arr710 {
				r.EncodeArrayStart(4)
			} else {
				yynn710 = 1
				for _, b := range yyq710 {
					if b {
						yynn710++
					}
				}
				r.EncodeMapStart(yynn710)
				yynn710 = 0
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq710[0] {
					yym712 := z.EncBinary()
					_ = yym712
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq710[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym713 := z.EncBinary()
					_ = yym713
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq710[1] {
					yym715 := z.EncBinary()
					_ = yym715
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq710[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym716 := z.EncBinary()
					_ = yym716
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq710[2] {
					yy718 := &x.ListMeta
					yym719 := z.EncBinary()
					_ = yym719
					if false {
					} else if z.HasExtensions() && z.EncExt(yy718) {
					} else {
						z.EncFallback(yy718)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq710[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy720 := &x.ListMeta
					yym721 := z.EncBinary()
					_ = yym721
					if false {
					} else if z.HasExtensions() && z.EncExt(yy720) {
					} else {
						z.EncFallback(yy720)
					}
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym723 := z.EncBinary()
					_ = yym723
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym724 := z.EncBinary()
					_ = yym724
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			}
			if yyr710 || yy2arr710 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym725 := z.DecBinary()
	_ = yym725
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct726 := r.ContainerType()
		if yyct726 == codecSelferValueTypeMap1234 {
			yyl726 := r.ReadMapStart()
			if yyl726 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl726, d)
			}
		} else if yyct726 == codecSelferValueTypeArray1234 {
			yyl726 := r.ReadArrayStart()
			if yyl726 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl726, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys727Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys727Slc
	var yyhl727 bool = l >= 0
	for yyj727 := 0; ; yyj727++ {
		if yyhl727 {
			if yyj727 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys727Slc = r.DecodeBytes(yys727Slc, true, true)
		yys727 := string(yys727Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys727 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv730 := &x.ListMeta
				yym731 := z.DecBinary()
				_ = yym731
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv730) {
				} else {
					z.DecFallback(yyv730, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv732 := &x.Items
				yym733 := z.DecBinary()
				_ = yym733
				if false {
				} else {
					h.decSliceDaemonSet((*[]DaemonSet)(yyv732), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys727)
		} // end switch yys727
	} // end for yyj727
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj734 int
	var yyb734 bool
	var yyhl734 bool = l >= 0
	yyj734++
	if yyhl734 {
		yyb734 = yyj734 > l
	} else {
		yyb734 = r.CheckBreak()
	}
	if yyb734 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj734++
	if yyhl734 {
		yyb734 = yyj734 > l
	} else {
		yyb734 = r.CheckBreak()
	}
	if yyb734 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj734++
	if yyhl734 {
		yyb734 = yyj734 > l
	} else {
		yyb734 = r.CheckBreak()
	}
	if yyb734 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv737 := &x.ListMeta
		yym738 := z.DecBinary()
		_ = yym738
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv737) {
		} else {
			z.DecFallback(yyv737, false)
		}
	}
	yyj734++
	if yyhl734 {
		yyb734 = yyj734 > l
	} else {
		yyb734 = r.CheckBreak()
	}
	if yyb734 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv739 := &x.Items
		yym740 := z.DecBinary()
		_ = yym740
		if false {
		} else {
			h.decSliceDaemonSet((*[]DaemonSet)(yyv739), d)
		}
	}
	for {
		yyj734++
		if yyhl734 {
			yyb734 = yyj734 > l
		} else {
			yyb734 = r.CheckBreak()
		}
		if yyb734 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj734-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceDataList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym741 := z.EncBinary()
		_ = yym741
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep742 := !z.EncBinary()
			yy2arr742 := z.EncBasicHandle().StructToArray
			var yyq742 [4]bool
			_, _, _ = yysep742, yyq742, yy2arr742
			const yyr742 bool = false
			yyq742[0] = x.Kind != ""
			yyq742[1] = x.APIVersion != ""
			yyq742[2] = true
			var yynn742 int
			if yyr742 || yy2arr742 {
				r.EncodeArrayStart(4)
			} else {
				yynn742 = 1
				for _, b := range yyq742 {
					if b {
						yynn742++
					}
				}
				r.EncodeMapStart(yynn742)
				yynn742 = 0
			}
			if yyr742 || yy2arr742 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq742[0] {
					yym744 := z.EncBinary()
					_ = yym744
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq742[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym745 := z.EncBinary()
					_ = yym745
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr742 || yy2arr742 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq742[1] {
					yym747 := z.EncBinary()
					_ = yym747
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq742[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym748 := z.EncBinary()
					_ = yym748
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr742 || yy2arr742 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq742[2] {
					yy750 := &x.ListMeta
					yym751 := z.EncBinary()
					_ = yym751
					if false {
					} else if z.HasExtensions() && z.EncExt(yy750) {
					} else {
						z.EncFallback(yy750)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq742[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy752 := &x.ListMeta
					yym753 := z.EncBinary()
					_ = yym753
					if false {
					} else if z.HasExtensions() && z.EncExt(yy752) {
					} else {
						z.EncFallback(yy752)
					}
				}
			}
			if yyr742 || yy2arr742 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym755 := z.EncBinary()
					_ = yym755
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym756 := z.EncBinary()
					_ = yym756
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			}
			if yyr742 || yy2arr742 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceDataList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym757 := z.DecBinary()
	_ = yym757
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct758 := r.ContainerType()
		if yyct758 == codecSelferValueTypeMap1234 {
			yyl758 := r.ReadMapStart()
			if yyl758 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl758, d)
			}
		} else if yyct758 == codecSelferValueTypeArray1234 {
			yyl758 := r.ReadArrayStart()
			if yyl758 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl758, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys759Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys759Slc
	var yyhl759 bool = l >= 0
	for yyj759 := 0; ; yyj759++ {
		if yyhl759 {
			if yyj759 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys759Slc = r.DecodeBytes(yys759Slc, true, true)
		yys759 := string(yys759Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys759 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv762 := &x.ListMeta
				yym763 := z.DecBinary()
				_ = yym763
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv762) {
				} else {
					z.DecFallback(yyv762, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv764 := &x.Items
				yym765 := z.DecBinary()
				_ = yym765
				if false {
				} else {
					h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv764), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys759)
		} // end switch yys759
	} // end for yyj759
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj766 int
	var yyb766 bool
	var yyhl766 bool = l >= 0
	yyj766++
	if yyhl766 {
		yyb766 = yyj766 > l
	} else {
		yyb766 = r.CheckBreak()
	}
	if yyb766 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj766++
	if yyhl766 {
		yyb766 = yyj766 > l
	} else {
		yyb766 = r.CheckBreak()
	}
	if yyb766 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj766++
	if yyhl766 {
		yyb766 = yyj766 > l
	} else {
		yyb766 = r.CheckBreak()
	}
	if yyb766 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv769 := &x.ListMeta
		yym770 := z.DecBinary()
		_ = yym770
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv769) {
		} else {
			z.DecFallback(yyv769, false)
		}
	}
	yyj766++
	if yyhl766 {
		yyb766 = yyj766 > l
	} else {
		yyb766 = r.CheckBreak()
	}
	if yyb766 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv771 := &x.Items
		yym772 := z.DecBinary()
		_ = yym772
		if false {
		} else {
			h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv771), d)
		}
	}
	for {
		yyj766++
		if yyhl766 {
			yyb766 = yyj766 > l
		} else {
			yyb766 = r.CheckBreak()
		}
		if yyb766 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj766-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Job) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym773 := z.EncBinary()
		_ = yym773
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep774 := !z.EncBinary()
			yy2arr774 := z.EncBasicHandle().StructToArray
			var yyq774 [5]bool
			_, _, _ = yysep774, yyq774, yy2arr774
			const yyr774 bool = false
			yyq774[0] = x.Kind != ""
			yyq774[1] = x.APIVersion != ""
			yyq774[2] = true
			yyq774[3] = true
			yyq774[4] = true
			var yynn774 int
			if yyr774 || yy2arr774 {
				r.EncodeArrayStart(5)
			} else {
				yynn774 = 0
				for _, b := range yyq774 {
					if b {
						yynn774++
					}
				}
				r.EncodeMapStart(yynn774)
				yynn774 = 0
			}
			if yyr774 || yy2arr774 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq774[0] {
					yym776 := z.EncBinary()
					_ = yym776
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq774[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym777 := z.EncBinary()
					_ = yym777
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr774 || yy2arr774 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq774[1] {
					yym779 := z.EncBinary()
					_ = yym779
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq774[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym780 := z.EncBinary()
					_ = yym780
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr774 || yy2arr774 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq774[2] {
					yy782 := &x.ObjectMeta
					yy782.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq774[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy783 := &x.ObjectMeta
					yy783.CodecEncodeSelf(e)
				}
			}
			if yyr774 || yy2arr774 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq774[3] {
					yy785 := &x.Spec
					yy785.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq774[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy786 := &x.Spec
					yy786.CodecEncodeSelf(e)
				}
			}
			if yyr774 || yy2arr774 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq774[4] {
					yy788 := &x.Status
					yy788.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq774[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy789 := &x.Status
					yy789.CodecEncodeSelf(e)
				}
			}
			if yyr774 || yy2arr774 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Job) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym790 := z.DecBinary()
	_ = yym790
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct791 := r.ContainerType()
		if yyct791 == codecSelferValueTypeMap1234 {
			yyl791 := r.ReadMapStart()
			if yyl791 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl791, d)
			}
		} else if yyct791 == codecSelferValueTypeArray1234 {
			yyl791 := r.ReadArrayStart()
			if yyl791 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl791, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Job) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys792Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys792Slc
	var yyhl792 bool = l >= 0
	for yyj792 := 0; ; yyj792++ {
		if yyhl792 {
			if yyj792 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys792Slc = r.DecodeBytes(yys792Slc, true, true)
		yys792 := string(yys792Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys792 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv795 := &x.ObjectMeta
				yyv795.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = JobSpec{}
			} else {
				yyv796 := &x.Spec
				yyv796.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = JobStatus{}
			} else {
				yyv797 := &x.Status
				yyv797.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys792)
		} // end switch yys792
	} // end for yyj792
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Job) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj798 int
	var yyb798 bool
	var yyhl798 bool = l >= 0
	yyj798++
	if yyhl798 {
		yyb798 = yyj798 > l
	} else {
		yyb798 = r.CheckBreak()
	}
	if yyb798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj798++
	if yyhl798 {
		yyb798 = yyj798 > l
	} else {
		yyb798 = r.CheckBreak()
	}
	if yyb798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj798++
	if yyhl798 {
		yyb798 = yyj798 > l
	} else {
		yyb798 = r.CheckBreak()
	}
	if yyb798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv801 := &x.ObjectMeta
		yyv801.CodecDecodeSelf(d)
	}
	yyj798++
	if yyhl798 {
		yyb798 = yyj798 > l
	} else {
		yyb798 = r.CheckBreak()
	}
	if yyb798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = JobSpec{}
	} else {
		yyv802 := &x.Spec
		yyv802.CodecDecodeSelf(d)
	}
	yyj798++
	if yyhl798 {
		yyb798 = yyj798 > l
	} else {
		yyb798 = r.CheckBreak()
	}
	if yyb798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = JobStatus{}
	} else {
		yyv803 := &x.Status
		yyv803.CodecDecodeSelf(d)
	}
	for {
		yyj798++
		if yyhl798 {
			yyb798 = yyj798 > l
		} else {
			yyb798 = r.CheckBreak()
		}
		if yyb798 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj798-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym804 := z.EncBinary()
		_ = yym804
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep805 := !z.EncBinary()
			yy2arr805 := z.EncBasicHandle().StructToArray
			var yyq805 [4]bool
			_, _, _ = yysep805, yyq805, yy2arr805
			const yyr805 bool = false
			yyq805[0] = x.Kind != ""
			yyq805[1] = x.APIVersion != ""
			yyq805[2] = true
			var yynn805 int
			if yyr805 || yy2arr805 {
				r.EncodeArrayStart(4)
			} else {
				yynn805 = 1
				for _, b := range yyq805 {
					if b {
						yynn805++
					}
				}
				r.EncodeMapStart(yynn805)
				yynn805 = 0
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq805[0] {
					yym807 := z.EncBinary()
					_ = yym807
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq805[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym808 := z.EncBinary()
					_ = yym808
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq805[1] {
					yym810 := z.EncBinary()
					_ = yym810
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq805[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym811 := z.EncBinary()
					_ = yym811
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq805[2] {
					yy813 := &x.ListMeta
					yym814 := z.EncBinary()
					_ = yym814
					if false {
					} else if z.HasExtensions() && z.EncExt(yy813) {
					} else {
						z.EncFallback(yy813)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq805[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy815 := &x.ListMeta
					yym816 := z.EncBinary()
					_ = yym816
					if false {
					} else if z.HasExtensions() && z.EncExt(yy815) {
					} else {
						z.EncFallback(yy815)
					}
				}
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym818 := z.EncBinary()
					_ = yym818
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym819 := z.EncBinary()
					_ = yym819
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			}
			if yyr805 || yy2arr805 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym820 := z.DecBinary()
	_ = yym820
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct821 := r.ContainerType()
		if yyct821 == codecSelferValueTypeMap1234 {
			yyl821 := r.ReadMapStart()
			if yyl821 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl821, d)
			}
		} else if yyct821 == codecSelferValueTypeArray1234 {
			yyl821 := r.ReadArrayStart()
			if yyl821 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl821, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys822Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys822Slc
	var yyhl822 bool = l >= 0
	for yyj822 := 0; ; yyj822++ {
		if yyhl822 {
			if yyj822 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys822Slc = r.DecodeBytes(yys822Slc, true, true)
		yys822 := string(yys822Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys822 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv825 := &x.ListMeta
				yym826 := z.DecBinary()
				_ = yym826
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv825) {
				} else {
					z.DecFallback(yyv825, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv827 := &x.Items
				yym828 := z.DecBinary()
				_ = yym828
				if false {
				} else {
					h.decSliceJob((*[]Job)(yyv827), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys822)
		} // end switch yys822
	} // end for yyj822
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj829 int
	var yyb829 bool
	var yyhl829 bool = l >= 0
	yyj829++
	if yyhl829 {
		yyb829 = yyj829 > l
	} else {
		yyb829 = r.CheckBreak()
	}
	if yyb829 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj829++
	if yyhl829 {
		yyb829 = yyj829 > l
	} else {
		yyb829 = r.CheckBreak()
	}
	if yyb829 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj829++
	if yyhl829 {
		yyb829 = yyj829 > l
	} else {
		yyb829 = r.CheckBreak()
	}
	if yyb829 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv832 := &x.ListMeta
		yym833 := z.DecBinary()
		_ = yym833
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv832) {
		} else {
			z.DecFallback(yyv832, false)
		}
	}
	yyj829++
	if yyhl829 {
		yyb829 = yyj829 > l
	} else {
		yyb829 = r.CheckBreak()
	}
	if yyb829 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv834 := &x.Items
		yym835 := z.DecBinary()
		_ = yym835
		if false {
		} else {
			h.decSliceJob((*[]Job)(yyv834), d)
		}
	}
	for {
		yyj829++
		if yyhl829 {
			yyb829 = yyj829 > l
		} else {
			yyb829 = r.CheckBreak()
		}
		if yyb829 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj829-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym836 := z.EncBinary()
		_ = yym836
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep837 := !z.EncBinary()
			yy2arr837 := z.EncBasicHandle().StructToArray
			var yyq837 [6]bool
			_, _, _ = yysep837, yyq837, yy2arr837
			const yyr837 bool = false
			yyq837[0] = x.Parallelism != nil
			yyq837[1] = x.Completions != nil
			yyq837[2] = x.ActiveDeadlineSeconds != nil
			yyq837[3] = x.Selector != nil
			yyq837[4] = x.AutoSelector != nil
			var yynn837 int
			if yyr837 || yy2arr837 {
				r.EncodeArrayStart(6)
			} else {
				yynn837 = 1
				for _, b := range yyq837 {
					if b {
						yynn837++
					}
				}
				r.EncodeMapStart(yynn837)
				yynn837 = 0
			}
			if yyr837 || yy2arr837 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq837[0] {
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy839 := *x.Parallelism
						yym840 := z.EncBinary()
						_ = yym840
						if false {
						} else {
							r.EncodeInt(int64(yy839))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq837[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("parallelism"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy841 := *x.Parallelism
						yym842 := z.EncBinary()
						_ = yym842
						if false {
						} else {
							r.EncodeInt(int64(yy841))
						}
					}
				}
			}
			if yyr837 || yy2arr837 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq837[1] {
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy844 := *x.Completions
						yym845 := z.EncBinary()
						_ = yym845
						if false {
						} else {
							r.EncodeInt(int64(yy844))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq837[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy846 := *x.Completions
						yym847 := z.EncBinary()
						_ = yym847
						if false {
						} else {
							r.EncodeInt(int64(yy846))
						}
					}
				}
			}
			if yyr837 || yy2arr837 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq837[2] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy849 := *x.ActiveDeadlineSeconds
						yym850 := z.EncBinary()
						_ = yym850
						if false {
						} else {
							r.EncodeInt(int64(yy849))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq837[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy851 := *x.ActiveDeadlineSeconds
						yym852 := z.EncBinary()
						_ = yym852
						if false {
						} else {
							r.EncodeInt(int64(yy851))
						}
					}
				}
			}
			if yyr837 || yy2arr837 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq837[3] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq837[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr837 || yy2arr837 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq837[4] {
					if x.AutoSelector == nil {
						r.EncodeNil()
					} else {
						yy855 := *x.AutoSelector
						yym856 := z.EncBinary()
						_ = yym856
						if false {
						} else {
							r.EncodeBool(bool(yy855))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq837[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("autoSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AutoSelector == nil {
						r.EncodeNil()
					} else {
						yy857 := *x.AutoSelector
						yym858 := z.EncBinary()
						_ = yym858
						if false {
						} else {
							r.EncodeBool(bool(yy857))
						}
					}
				}
			}
			if yyr837 || yy2arr837 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy860 := &x.Template
				yy860.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy861 := &x.Template
				yy861.CodecEncodeSelf(e)
			}
			if yyr837 || yy2arr837 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym862 := z.DecBinary()
	_ = yym862
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct863 := r.ContainerType()
		if yyct863 == codecSelferValueTypeMap1234 {
			yyl863 := r.ReadMapStart()
			if yyl863 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl863, d)
			}
		} else if yyct863 == codecSelferValueTypeArray1234 {
			yyl863 := r.ReadArrayStart()
			if yyl863 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl863, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys864Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys864Slc
	var yyhl864 bool = l >= 0
	for yyj864 := 0; ; yyj864++ {
		if yyhl864 {
			if yyj864 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys864Slc = r.DecodeBytes(yys864Slc, true, true)
		yys864 := string(yys864Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys864 {
		case "parallelism":
			if r.TryDecodeAsNil() {
				if x.Parallelism != nil {
					x.Parallelism = nil
				}
			} else {
				if x.Parallelism == nil {
					x.Parallelism = new(int32)
				}
				yym866 := z.DecBinary()
				_ = yym866
				if false {
				} else {
					*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
				}
			}
		case "completions":
			if r.TryDecodeAsNil() {
				if x.Completions != nil {
					x.Completions = nil
				}
			} else {
				if x.Completions == nil {
					x.Completions = new(int32)
				}
				yym868 := z.DecBinary()
				_ = yym868
				if false {
				} else {
					*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym870 := z.DecBinary()
				_ = yym870
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "autoSelector":
			if r.TryDecodeAsNil() {
				if x.AutoSelector != nil {
					x.AutoSelector = nil
				}
			} else {
				if x.AutoSelector == nil {
					x.AutoSelector = new(bool)
				}
				yym873 := z.DecBinary()
				_ = yym873
				if false {
				} else {
					*((*bool)(x.AutoSelector)) = r.DecodeBool()
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv874 := &x.Template
				yyv874.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys864)
		} // end switch yys864
	} // end for yyj864
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj875 int
	var yyb875 bool
	var yyhl875 bool = l >= 0
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Parallelism != nil {
			x.Parallelism = nil
		}
	} else {
		if x.Parallelism == nil {
			x.Parallelism = new(int32)
		}
		yym877 := z.DecBinary()
		_ = yym877
		if false {
		} else {
			*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
		}
	}
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Completions != nil {
			x.Completions = nil
		}
	} else {
		if x.Completions == nil {
			x.Completions = new(int32)
		}
		yym879 := z.DecBinary()
		_ = yym879
		if false {
		} else {
			*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
		}
	}
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym881 := z.DecBinary()
		_ = yym881
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AutoSelector != nil {
			x.AutoSelector = nil
		}
	} else {
		if x.AutoSelector == nil {
			x.AutoSelector = new(bool)
		}
		yym884 := z.DecBinary()
		_ = yym884
		if false {
		} else {
			*((*bool)(x.AutoSelector)) = r.DecodeBool()
		}
	}
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv885 := &x.Template
		yyv885.CodecDecodeSelf(d)
	}
	for {
		yyj875++
		if yyhl875 {
			yyb875 = yyj875 > l
		} else {
			yyb875 = r.CheckBreak()
		}
		if yyb875 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj875-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym886 := z.EncBinary()
		_ = yym886
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep887 := !z.EncBinary()
			yy2arr887 := z.EncBasicHandle().StructToArray
			var yyq887 [6]bool
			_, _, _ = yysep887, yyq887, yy2arr887
			const yyr887 bool = false
			yyq887[0] = len(x.Conditions) != 0
			yyq887[1] = x.StartTime != nil
			yyq887[2] = x.CompletionTime != nil
			yyq887[3] = x.Active != 0
			yyq887[4] = x.Succeeded != 0
			yyq887[5] = x.Failed != 0
			var yynn887 int
			if yyr887 || yy2arr887 {
				r.EncodeArrayStart(6)
			} else {
				yynn887 = 0
				for _, b := range yyq887 {
					if b {
						yynn887++
					}
				}
				r.EncodeMapStart(yynn887)
				yynn887 = 0
			}
			if yyr887 || yy2arr887 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq887[0] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym889 := z.EncBinary()
						_ = yym889
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq887[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym890 := z.EncBinary()
						_ = yym890
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr887 || yy2arr887 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq887[1] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym892 := z.EncBinary()
						_ = yym892
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym892 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym892 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq887[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym893 := z.EncBinary()
						_ = yym893
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym893 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym893 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr887 || yy2arr887 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq887[2] {
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym895 := z.EncBinary()
						_ = yym895
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym895 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym895 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq887[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym896 := z.EncBinary()
						_ = yym896
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym896 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym896 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				}
			}
			if yyr887 || yy2arr887 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq887[3] {
					yym898 := z.EncBinary()
					_ = yym898
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq887[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("active"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym899 := z.EncBinary()
					_ = yym899
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				}
			}
			if yyr887 || yy2arr887 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq887[4] {
					yym901 := z.EncBinary()
					_ = yym901
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq887[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("succeeded"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym902 := z.EncBinary()
					_ = yym902
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				}
			}
			if yyr887 || yy2arr887 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq887[5] {
					yym904 := z.EncBinary()
					_ = yym904
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq887[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failed"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym905 := z.EncBinary()
					_ = yym905
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				}
			}
			if yyr887 || yy2arr887 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym906 := z.DecBinary()
	_ = yym906
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct907 := r.ContainerType()
		if yyct907 == codecSelferValueTypeMap1234 {
			yyl907 := r.ReadMapStart()
			if yyl907 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl907, d)
			}
		} else if yyct907 == codecSelferValueTypeArray1234 {
			yyl907 := r.ReadArrayStart()
			if yyl907 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl907, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys908Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys908Slc
	var yyhl908 bool = l >= 0
	for yyj908 := 0; ; yyj908++ {
		if yyhl908 {
			if yyj908 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys908Slc = r.DecodeBytes(yys908Slc, true, true)
		yys908 := string(yys908Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys908 {
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv909 := &x.Conditions
				yym910 := z.DecBinary()
				_ = yym910
				if false {
				} else {
					h.decSliceJobCondition((*[]JobCondition)(yyv909), d)
				}
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg1_unversioned.Time)
				}
				yym912 := z.DecBinary()
				_ = yym912
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym912 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym912 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "completionTime":
			if r.TryDecodeAsNil() {
				if x.CompletionTime != nil {
					x.CompletionTime = nil
				}
			} else {
				if x.CompletionTime == nil {
					x.CompletionTime = new(pkg1_unversioned.Time)
				}
				yym914 := z.DecBinary()
				_ = yym914
				if false {
				} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
				} else if yym914 {
					z.DecBinaryUnmarshal(x.CompletionTime)
				} else if !yym914 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.CompletionTime)
				} else {
					z.DecFallback(x.CompletionTime, false)
				}
			}
		case "active":
			if r.TryDecodeAsNil() {
				x.Active = 0
			} else {
				x.Active = int32(r.DecodeInt(32))
			}
		case "succeeded":
			if r.TryDecodeAsNil() {
				x.Succeeded = 0
			} else {
				x.Succeeded = int32(r.DecodeInt(32))
			}
		case "failed":
			if r.TryDecodeAsNil() {
				x.Failed = 0
			} else {
				x.Failed = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys908)
		} // end switch yys908
	} // end for yyj908
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj918 int
	var yyb918 bool
	var yyhl918 bool = l >= 0
	yyj918++
	if yyhl918 {
		yyb918 = yyj918 > l
	} else {
		yyb918 = r.CheckBreak()
	}
	if yyb918 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv919 := &x.Conditions
		yym920 := z.DecBinary()
		_ = yym920
		if false {
		} else {
			h.decSliceJobCondition((*[]JobCondition)(yyv919), d)
		}
	}
	yyj918++
	if yyhl918 {
		yyb918 = yyj918 > l
	} else {
		yyb918 = r.CheckBreak()
	}
	if yyb918 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg1_unversioned.Time)
		}
		yym922 := z.DecBinary()
		_ = yym922
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym922 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym922 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj918++
	if yyhl918 {
		yyb918 = yyj918 > l
	} else {
		yyb918 = r.CheckBreak()
	}
	if yyb918 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CompletionTime != nil {
			x.CompletionTime = nil
		}
	} else {
		if x.CompletionTime == nil {
			x.CompletionTime = new(pkg1_unversioned.Time)
		}
		yym924 := z.DecBinary()
		_ = yym924
		if false {
		} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
		} else if yym924 {
			z.DecBinaryUnmarshal(x.CompletionTime)
		} else if !yym924 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.CompletionTime)
		} else {
			z.DecFallback(x.CompletionTime, false)
		}
	}
	yyj918++
	if yyhl918 {
		yyb918 = yyj918 > l
	} else {
		yyb918 = r.CheckBreak()
	}
	if yyb918 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Active = 0
	} else {
		x.Active = int32(r.DecodeInt(32))
	}
	yyj918++
	if yyhl918 {
		yyb918 = yyj918 > l
	} else {
		yyb918 = r.CheckBreak()
	}
	if yyb918 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Succeeded = 0
	} else {
		x.Succeeded = int32(r.DecodeInt(32))
	}
	yyj918++
	if yyhl918 {
		yyb918 = yyj918 > l
	} else {
		yyb918 = r.CheckBreak()
	}
	if yyb918 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Failed = 0
	} else {
		x.Failed = int32(r.DecodeInt(32))
	}
	for {
		yyj918++
		if yyhl918 {
			yyb918 = yyj918 > l
		} else {
			yyb918 = r.CheckBreak()
		}
		if yyb918 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj918-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x JobConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym928 := z.EncBinary()
	_ = yym928
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *JobConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym929 := z.DecBinary()
	_ = yym929
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *JobCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym930 := z.EncBinary()
		_ = yym930
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep931 := !z.EncBinary()
			yy2arr931 := z.EncBasicHandle().StructToArray
			var yyq931 [6]bool
			_, _, _ = yysep931, yyq931, yy2arr931
			const yyr931 bool = false
			yyq931[2] = true
			yyq931[3] = true
			yyq931[4] = x.Reason != ""
			yyq931[5] = x.Message != ""
			var yynn931 int
			if yyr931 || yy2arr931 {
				r.EncodeArrayStart(6)
			} else {
				yynn931 = 2
				for _, b := range yyq931 {
					if b {
						yynn931++
					}
				}
				r.EncodeMapStart(yynn931)
				yynn931 = 0
			}
			if yyr931 || yy2arr931 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr931 || yy2arr931 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym934 := z.EncBinary()
				_ = yym934
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym935 := z.EncBinary()
				_ = yym935
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr931 || yy2arr931 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq931[2] {
					yy937 := &x.LastProbeTime
					yym938 := z.EncBinary()
					_ = yym938
					if false {
					} else if z.HasExtensions() && z.EncExt(yy937) {
					} else if yym938 {
						z.EncBinaryMarshal(yy937)
					} else if !yym938 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy937)
					} else {
						z.EncFallback(yy937)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq931[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy939 := &x.LastProbeTime
					yym940 := z.EncBinary()
					_ = yym940
					if false {
					} else if z.HasExtensions() && z.EncExt(yy939) {
					} else if yym940 {
						z.EncBinaryMarshal(yy939)
					} else if !yym940 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy939)
					} else {
						z.EncFallback(yy939)
					}
				}
			}
			if yyr931 || yy2arr931 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq931[3] {
					yy942 := &x.LastTransitionTime
					yym943 := z.EncBinary()
					_ = yym943
					if false {
					} else if z.HasExtensions() && z.EncExt(yy942) {
					} else if yym943 {
						z.EncBinaryMarshal(yy942)
					} else if !yym943 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy942)
					} else {
						z.EncFallback(yy942)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq931[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy944 := &x.LastTransitionTime
					yym945 := z.EncBinary()
					_ = yym945
					if false {
					} else if z.HasExtensions() && z.EncExt(yy944) {
					} else if yym945 {
						z.EncBinaryMarshal(yy944)
					} else if !yym945 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy944)
					} else {
						z.EncFallback(yy944)
					}
				}
			}
			if yyr931 || yy2arr931 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq931[4] {
					yym947 := z.EncBinary()
					_ = yym947
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq931[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym948 := z.EncBinary()
					_ = yym948
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr931 || yy2arr931 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq931[5] {
					yym950 := z.EncBinary()
					_ = yym950
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq931[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym951 := z.EncBinary()
					_ = yym951
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr931 || yy2arr931 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym952 := z.DecBinary()
	_ = yym952
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct953 := r.ContainerType()
		if yyct953 == codecSelferValueTypeMap1234 {
			yyl953 := r.ReadMapStart()
			if yyl953 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl953, d)
			}
		} else if yyct953 == codecSelferValueTypeArray1234 {
			yyl953 := r.ReadArrayStart()
			if yyl953 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl953, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys954Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys954Slc
	var yyhl954 bool = l >= 0
	for yyj954 := 0; ; yyj954++ {
		if yyhl954 {
			if yyj954 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys954Slc = r.DecodeBytes(yys954Slc, true, true)
		yys954 := string(yys954Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys954 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = JobConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg1_unversioned.Time{}
			} else {
				yyv957 := &x.LastProbeTime
				yym958 := z.DecBinary()
				_ = yym958
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv957) {
				} else if yym958 {
					z.DecBinaryUnmarshal(yyv957)
				} else if !yym958 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv957)
				} else {
					z.DecFallback(yyv957, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv959 := &x.LastTransitionTime
				yym960 := z.DecBinary()
				_ = yym960
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv959) {
				} else if yym960 {
					z.DecBinaryUnmarshal(yyv959)
				} else if !yym960 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv959)
				} else {
					z.DecFallback(yyv959, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys954)
		} // end switch yys954
	} // end for yyj954
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj963 int
	var yyb963 bool
	var yyhl963 bool = l >= 0
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = JobConditionType(r.DecodeString())
	}
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
	}
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg1_unversioned.Time{}
	} else {
		yyv966 := &x.LastProbeTime
		yym967 := z.DecBinary()
		_ = yym967
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv966) {
		} else if yym967 {
			z.DecBinaryUnmarshal(yyv966)
		} else if !yym967 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv966)
		} else {
			z.DecFallback(yyv966, false)
		}
	}
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv968 := &x.LastTransitionTime
		yym969 := z.DecBinary()
		_ = yym969
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv968) {
		} else if yym969 {
			z.DecBinaryUnmarshal(yyv968)
		} else if !yym969 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv968)
		} else {
			z.DecFallback(yyv968, false)
		}
	}
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj963++
	if yyhl963 {
		yyb963 = yyj963 > l
	} else {
		yyb963 = r.CheckBreak()
	}
	if yyb963 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj963++
		if yyhl963 {
			yyb963 = yyj963 > l
		} else {
			yyb963 = r.CheckBreak()
		}
		if yyb963 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj963-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Ingress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym972 := z.EncBinary()
		_ = yym972
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep973 := !z.EncBinary()
			yy2arr973 := z.EncBasicHandle().StructToArray
			var yyq973 [5]bool
			_, _, _ = yysep973, yyq973, yy2arr973
			const yyr973 bool = false
			yyq973[0] = x.Kind != ""
			yyq973[1] = x.APIVersion != ""
			yyq973[2] = true
			yyq973[3] = true
			yyq973[4] = true
			var yynn973 int
			if yyr973 || yy2arr973 {
				r.EncodeArrayStart(5)
			} else {
				yynn973 = 0
				for _, b := range yyq973 {
					if b {
						yynn973++
					}
				}
				r.EncodeMapStart(yynn973)
				yynn973 = 0
			}
			if yyr973 || yy2arr973 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq973[0] {
					yym975 := z.EncBinary()
					_ = yym975
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq973[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym976 := z.EncBinary()
					_ = yym976
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr973 || yy2arr973 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq973[1] {
					yym978 := z.EncBinary()
					_ = yym978
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq973[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym979 := z.EncBinary()
					_ = yym979
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr973 || yy2arr973 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq973[2] {
					yy981 := &x.ObjectMeta
					yy981.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq973[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy982 := &x.ObjectMeta
					yy982.CodecEncodeSelf(e)
				}
			}
			if yyr973 || yy2arr973 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq973[3] {
					yy984 := &x.Spec
					yy984.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq973[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy985 := &x.Spec
					yy985.CodecEncodeSelf(e)
				}
			}
			if yyr973 || yy2arr973 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq973[4] {
					yy987 := &x.Status
					yy987.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq973[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy988 := &x.Status
					yy988.CodecEncodeSelf(e)
				}
			}
			if yyr973 || yy2arr973 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Ingress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym989 := z.DecBinary()
	_ = yym989
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct990 := r.ContainerType()
		if yyct990 == codecSelferValueTypeMap1234 {
			yyl990 := r.ReadMapStart()
			if yyl990 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl990, d)
			}
		} else if yyct990 == codecSelferValueTypeArray1234 {
			yyl990 := r.ReadArrayStart()
			if yyl990 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl990, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Ingress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys991Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys991Slc
	var yyhl991 bool = l >= 0
	for yyj991 := 0; ; yyj991++ {
		if yyhl991 {
			if yyj991 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys991Slc = r.DecodeBytes(yys991Slc, true, true)
		yys991 := string(yys991Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys991 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv994 := &x.ObjectMeta
				yyv994.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = IngressSpec{}
			} else {
				yyv995 := &x.Spec
				yyv995.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = IngressStatus{}
			} else {
				yyv996 := &x.Status
				yyv996.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys991)
		} // end switch yys991
	} // end for yyj991
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Ingress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj997 int
	var yyb997 bool
	var yyhl997 bool = l >= 0
	yyj997++
	if yyhl997 {
		yyb997 = yyj997 > l
	} else {
		yyb997 = r.CheckBreak()
	}
	if yyb997 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj997++
	if yyhl997 {
		yyb997 = yyj997 > l
	} else {
		yyb997 = r.CheckBreak()
	}
	if yyb997 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj997++
	if yyhl997 {
		yyb997 = yyj997 > l
	} else {
		yyb997 = r.CheckBreak()
	}
	if yyb997 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1000 := &x.ObjectMeta
		yyv1000.CodecDecodeSelf(d)
	}
	yyj997++
	if yyhl997 {
		yyb997 = yyj997 > l
	} else {
		yyb997 = r.CheckBreak()
	}
	if yyb997 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = IngressSpec{}
	} else {
		yyv1001 := &x.Spec
		yyv1001.CodecDecodeSelf(d)
	}
	yyj997++
	if yyhl997 {
		yyb997 = yyj997 > l
	} else {
		yyb997 = r.CheckBreak()
	}
	if yyb997 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = IngressStatus{}
	} else {
		yyv1002 := &x.Status
		yyv1002.CodecDecodeSelf(d)
	}
	for {
		yyj997++
		if yyhl997 {
			yyb997 = yyj997 > l
		} else {
			yyb997 = r.CheckBreak()
		}
		if yyb997 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj997-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1003 := z.EncBinary()
		_ = yym1003
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1004 := !z.EncBinary()
			yy2arr1004 := z.EncBasicHandle().StructToArray
			var yyq1004 [4]bool
			_, _, _ = yysep1004, yyq1004, yy2arr1004
			const yyr1004 bool = false
			yyq1004[0] = x.Kind != ""
			yyq1004[1] = x.APIVersion != ""
			yyq1004[2] = true
			var yynn1004 int
			if yyr1004 || yy2arr1004 {
				r.EncodeArrayStart(4)
			} else {
				yynn1004 = 1
				for _, b := range yyq1004 {
					if b {
						yynn1004++
					}
				}
				r.EncodeMapStart(yynn1004)
				yynn1004 = 0
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1004[0] {
					yym1006 := z.EncBinary()
					_ = yym1006
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1004[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1007 := z.EncBinary()
					_ = yym1007
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1004[1] {
					yym1009 := z.EncBinary()
					_ = yym1009
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1004[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1010 := z.EncBinary()
					_ = yym1010
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1004[2] {
					yy1012 := &x.ListMeta
					yym1013 := z.EncBinary()
					_ = yym1013
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1012) {
					} else {
						z.EncFallback(yy1012)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1004[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1014 := &x.ListMeta
					yym1015 := z.EncBinary()
					_ = yym1015
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1014) {
					} else {
						z.EncFallback(yy1014)
					}
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1017 := z.EncBinary()
					_ = yym1017
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1018 := z.EncBinary()
					_ = yym1018
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			}
			if yyr1004 || yy2arr1004 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1019 := z.DecBinary()
	_ = yym1019
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1020 := r.ContainerType()
		if yyct1020 == codecSelferValueTypeMap1234 {
			yyl1020 := r.ReadMapStart()
			if yyl1020 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1020, d)
			}
		} else if yyct1020 == codecSelferValueTypeArray1234 {
			yyl1020 := r.ReadArrayStart()
			if yyl1020 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1020, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1021Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1021Slc
	var yyhl1021 bool = l >= 0
	for yyj1021 := 0; ; yyj1021++ {
		if yyhl1021 {
			if yyj1021 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1021Slc = r.DecodeBytes(yys1021Slc, true, true)
		yys1021 := string(yys1021Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1021 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1024 := &x.ListMeta
				yym1025 := z.DecBinary()
				_ = yym1025
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1024) {
				} else {
					z.DecFallback(yyv1024, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1026 := &x.Items
				yym1027 := z.DecBinary()
				_ = yym1027
				if false {
				} else {
					h.decSliceIngress((*[]Ingress)(yyv1026), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1021)
		} // end switch yys1021
	} // end for yyj1021
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1028 int
	var yyb1028 bool
	var yyhl1028 bool = l >= 0
	yyj1028++
	if yyhl1028 {
		yyb1028 = yyj1028 > l
	} else {
		yyb1028 = r.CheckBreak()
	}
	if yyb1028 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1028++
	if yyhl1028 {
		yyb1028 = yyj1028 > l
	} else {
		yyb1028 = r.CheckBreak()
	}
	if yyb1028 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1028++
	if yyhl1028 {
		yyb1028 = yyj1028 > l
	} else {
		yyb1028 = r.CheckBreak()
	}
	if yyb1028 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1031 := &x.ListMeta
		yym1032 := z.DecBinary()
		_ = yym1032
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1031) {
		} else {
			z.DecFallback(yyv1031, false)
		}
	}
	yyj1028++
	if yyhl1028 {
		yyb1028 = yyj1028 > l
	} else {
		yyb1028 = r.CheckBreak()
	}
	if yyb1028 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1033 := &x.Items
		yym1034 := z.DecBinary()
		_ = yym1034
		if false {
		} else {
			h.decSliceIngress((*[]Ingress)(yyv1033), d)
		}
	}
	for {
		yyj1028++
		if yyhl1028 {
			yyb1028 = yyj1028 > l
		} else {
			yyb1028 = r.CheckBreak()
		}
		if yyb1028 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1028-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1035 := z.EncBinary()
		_ = yym1035
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1036 := !z.EncBinary()
			yy2arr1036 := z.EncBasicHandle().StructToArray
			var yyq1036 [3]bool
			_, _, _ = yysep1036, yyq1036, yy2arr1036
			const yyr1036 bool = false
			yyq1036[0] = x.Backend != nil
			yyq1036[1] = len(x.TLS) != 0
			yyq1036[2] = len(x.Rules) != 0
			var yynn1036 int
			if yyr1036 || yy2arr1036 {
				r.EncodeArrayStart(3)
			} else {
				yynn1036 = 0
				for _, b := range yyq1036 {
					if b {
						yynn1036++
					}
				}
				r.EncodeMapStart(yynn1036)
				yynn1036 = 0
			}
			if yyr1036 || yy2arr1036 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1036[0] {
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1036[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("backend"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1036 || yy2arr1036 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1036[1] {
					if x.TLS == nil {
						r.EncodeNil()
					} else {
						yym1039 := z.EncBinary()
						_ = yym1039
						if false {
						} else {
							h.encSliceIngressTLS(([]IngressTLS)(x.TLS), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1036[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TLS == nil {
						r.EncodeNil()
					} else {
						yym1040 := z.EncBinary()
						_ = yym1040
						if false {
						} else {
							h.encSliceIngressTLS(([]IngressTLS)(x.TLS), e)
						}
					}
				}
			}
			if yyr1036 || yy2arr1036 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1036[2] {
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym1042 := z.EncBinary()
						_ = yym1042
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1036[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rules"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym1043 := z.EncBinary()
						_ = yym1043
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				}
			}
			if yyr1036 || yy2arr1036 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1044 := z.DecBinary()
	_ = yym1044
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1045 := r.ContainerType()
		if yyct1045 == codecSelferValueTypeMap1234 {
			yyl1045 := r.ReadMapStart()
			if yyl1045 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1045, d)
			}
		} else if yyct1045 == codecSelferValueTypeArray1234 {
			yyl1045 := r.ReadArrayStart()
			if yyl1045 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1045, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1046Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1046Slc
	var yyhl1046 bool = l >= 0
	for yyj1046 := 0; ; yyj1046++ {
		if yyhl1046 {
			if yyj1046 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1046Slc = r.DecodeBytes(yys1046Slc, true, true)
		yys1046 := string(yys1046Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1046 {
		case "backend":
			if r.TryDecodeAsNil() {
				if x.Backend != nil {
					x.Backend = nil
				}
			} else {
				if x.Backend == nil {
					x.Backend = new(IngressBackend)
				}
				x.Backend.CodecDecodeSelf(d)
			}
		case "tls":
			if r.TryDecodeAsNil() {
				x.TLS = nil
			} else {
				yyv1048 := &x.TLS
				yym1049 := z.DecBinary()
				_ = yym1049
				if false {
				} else {
					h.decSliceIngressTLS((*[]IngressTLS)(yyv1048), d)
				}
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv1050 := &x.Rules
				yym1051 := z.DecBinary()
				_ = yym1051
				if false {
				} else {
					h.decSliceIngressRule((*[]IngressRule)(yyv1050), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1046)
		} // end switch yys1046
	} // end for yyj1046
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1052 int
	var yyb1052 bool
	var yyhl1052 bool = l >= 0
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Backend != nil {
			x.Backend = nil
		}
	} else {
		if x.Backend == nil {
			x.Backend = new(IngressBackend)
		}
		x.Backend.CodecDecodeSelf(d)
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLS = nil
	} else {
		yyv1054 := &x.TLS
		yym1055 := z.DecBinary()
		_ = yym1055
		if false {
		} else {
			h.decSliceIngressTLS((*[]IngressTLS)(yyv1054), d)
		}
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv1056 := &x.Rules
		yym1057 := z.DecBinary()
		_ = yym1057
		if false {
		} else {
			h.decSliceIngressRule((*[]IngressRule)(yyv1056), d)
		}
	}
	for {
		yyj1052++
		if yyhl1052 {
			yyb1052 = yyj1052 > l
		} else {
			yyb1052 = r.CheckBreak()
		}
		if yyb1052 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1052-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressTLS) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1058 := z.EncBinary()
		_ = yym1058
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1059 := !z.EncBinary()
			yy2arr1059 := z.EncBasicHandle().StructToArray
			var yyq1059 [2]bool
			_, _, _ = yysep1059, yyq1059, yy2arr1059
			const yyr1059 bool = false
			yyq1059[0] = len(x.Hosts) != 0
			yyq1059[1] = x.SecretName != ""
			var yynn1059 int
			if yyr1059 || yy2arr1059 {
				r.EncodeArrayStart(2)
			} else {
				yynn1059 = 0
				for _, b := range yyq1059 {
					if b {
						yynn1059++
					}
				}
				r.EncodeMapStart(yynn1059)
				yynn1059 = 0
			}
			if yyr1059 || yy2arr1059 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1059[0] {
					if x.Hosts == nil {
						r.EncodeNil()
					} else {
						yym1061 := z.EncBinary()
						_ = yym1061
						if false {
						} else {
							z.F.EncSliceStringV(x.Hosts, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1059[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hosts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Hosts == nil {
						r.EncodeNil()
					} else {
						yym1062 := z.EncBinary()
						_ = yym1062
						if false {
						} else {
							z.F.EncSliceStringV(x.Hosts, false, e)
						}
					}
				}
			}
			if yyr1059 || yy2arr1059 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1059[1] {
					yym1064 := z.EncBinary()
					_ = yym1064
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1059[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1065 := z.EncBinary()
					_ = yym1065
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr1059 || yy2arr1059 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressTLS) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1066 := z.DecBinary()
	_ = yym1066
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1067 := r.ContainerType()
		if yyct1067 == codecSelferValueTypeMap1234 {
			yyl1067 := r.ReadMapStart()
			if yyl1067 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1067, d)
			}
		} else if yyct1067 == codecSelferValueTypeArray1234 {
			yyl1067 := r.ReadArrayStart()
			if yyl1067 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1067, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressTLS) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1068Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1068Slc
	var yyhl1068 bool = l >= 0
	for yyj1068 := 0; ; yyj1068++ {
		if yyhl1068 {
			if yyj1068 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1068Slc = r.DecodeBytes(yys1068Slc, true, true)
		yys1068 := string(yys1068Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1068 {
		case "hosts":
			if r.TryDecodeAsNil() {
				x.Hosts = nil
			} else {
				yyv1069 := &x.Hosts
				yym1070 := z.DecBinary()
				_ = yym1070
				if false {
				} else {
					z.F.DecSliceStringX(yyv1069, false, d)
				}
			}
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1068)
		} // end switch yys1068
	} // end for yyj1068
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressTLS) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1072 int
	var yyb1072 bool
	var yyhl1072 bool = l >= 0
	yyj1072++
	if yyhl1072 {
		yyb1072 = yyj1072 > l
	} else {
		yyb1072 = r.CheckBreak()
	}
	if yyb1072 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hosts = nil
	} else {
		yyv1073 := &x.Hosts
		yym1074 := z.DecBinary()
		_ = yym1074
		if false {
		} else {
			z.F.DecSliceStringX(yyv1073, false, d)
		}
	}
	yyj1072++
	if yyhl1072 {
		yyb1072 = yyj1072 > l
	} else {
		yyb1072 = r.CheckBreak()
	}
	if yyb1072 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	for {
		yyj1072++
		if yyhl1072 {
			yyb1072 = yyj1072 > l
		} else {
			yyb1072 = r.CheckBreak()
		}
		if yyb1072 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1072-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1076 := z.EncBinary()
		_ = yym1076
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1077 := !z.EncBinary()
			yy2arr1077 := z.EncBasicHandle().StructToArray
			var yyq1077 [1]bool
			_, _, _ = yysep1077, yyq1077, yy2arr1077
			const yyr1077 bool = false
			yyq1077[0] = true
			var yynn1077 int
			if yyr1077 || yy2arr1077 {
				r.EncodeArrayStart(1)
			} else {
				yynn1077 = 0
				for _, b := range yyq1077 {
					if b {
						yynn1077++
					}
				}
				r.EncodeMapStart(yynn1077)
				yynn1077 = 0
			}
			if yyr1077 || yy2arr1077 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1077[0] {
					yy1079 := &x.LoadBalancer
					yy1079.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1077[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1080 := &x.LoadBalancer
					yy1080.CodecEncodeSelf(e)
				}
			}
			if yyr1077 || yy2arr1077 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1081 := z.DecBinary()
	_ = yym1081
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1082 := r.ContainerType()
		if yyct1082 == codecSelferValueTypeMap1234 {
			yyl1082 := r.ReadMapStart()
			if yyl1082 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1082, d)
			}
		} else if yyct1082 == codecSelferValueTypeArray1234 {
			yyl1082 := r.ReadArrayStart()
			if yyl1082 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1082, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1083Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1083Slc
	var yyhl1083 bool = l >= 0
	for yyj1083 := 0; ; yyj1083++ {
		if yyhl1083 {
			if yyj1083 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1083Slc = r.DecodeBytes(yys1083Slc, true, true)
		yys1083 := string(yys1083Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1083 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = pkg2_v1.LoadBalancerStatus{}
			} else {
				yyv1084 := &x.LoadBalancer
				yyv1084.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1083)
		} // end switch yys1083
	} // end for yyj1083
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1085 int
	var yyb1085 bool
	var yyhl1085 bool = l >= 0
	yyj1085++
	if yyhl1085 {
		yyb1085 = yyj1085 > l
	} else {
		yyb1085 = r.CheckBreak()
	}
	if yyb1085 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = pkg2_v1.LoadBalancerStatus{}
	} else {
		yyv1086 := &x.LoadBalancer
		yyv1086.CodecDecodeSelf(d)
	}
	for {
		yyj1085++
		if yyhl1085 {
			yyb1085 = yyj1085 > l
		} else {
			yyb1085 = r.CheckBreak()
		}
		if yyb1085 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1085-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1087 := z.EncBinary()
		_ = yym1087
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1088 := !z.EncBinary()
			yy2arr1088 := z.EncBasicHandle().StructToArray
			var yyq1088 [2]bool
			_, _, _ = yysep1088, yyq1088, yy2arr1088
			const yyr1088 bool = false
			yyq1088[0] = x.Host != ""
			yyq1088[1] = x.IngressRuleValue.HTTP != nil && x.HTTP != nil
			var yynn1088 int
			if yyr1088 || yy2arr1088 {
				r.EncodeArrayStart(2)
			} else {
				yynn1088 = 0
				for _, b := range yyq1088 {
					if b {
						yynn1088++
					}
				}
				r.EncodeMapStart(yynn1088)
				yynn1088 = 0
			}
			if yyr1088 || yy2arr1088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1088[0] {
					yym1090 := z.EncBinary()
					_ = yym1090
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1088[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1091 := z.EncBinary()
					_ = yym1091
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			var yyn1092 bool
			if x.IngressRuleValue.HTTP == nil {
				yyn1092 = true
				goto LABEL1092
			}
		LABEL1092:
			if yyr1088 || yy2arr1088 {
				if yyn1092 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1088[1] {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1088[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1092 {
						r.EncodeNil()
					} else {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr1088 || yy2arr1088 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1093 := z.DecBinary()
	_ = yym1093
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1094 := r.ContainerType()
		if yyct1094 == codecSelferValueTypeMap1234 {
			yyl1094 := r.ReadMapStart()
			if yyl1094 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1094, d)
			}
		} else if yyct1094 == codecSelferValueTypeArray1234 {
			yyl1094 := r.ReadArrayStart()
			if yyl1094 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1094, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1095Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1095Slc
	var yyhl1095 bool = l >= 0
	for yyj1095 := 0; ; yyj1095++ {
		if yyhl1095 {
			if yyj1095 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1095Slc = r.DecodeBytes(yys1095Slc, true, true)
		yys1095 := string(yys1095Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1095 {
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "http":
			if x.IngressRuleValue.HTTP == nil {
				x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
			}
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1095)
		} // end switch yys1095
	} // end for yyj1095
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1098 int
	var yyb1098 bool
	var yyhl1098 bool = l >= 0
	yyj1098++
	if yyhl1098 {
		yyb1098 = yyj1098 > l
	} else {
		yyb1098 = r.CheckBreak()
	}
	if yyb1098 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	if x.IngressRuleValue.HTTP == nil {
		x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
	}
	yyj1098++
	if yyhl1098 {
		yyb1098 = yyj1098 > l
	} else {
		yyb1098 = r.CheckBreak()
	}
	if yyb1098 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj1098++
		if yyhl1098 {
			yyb1098 = yyj1098 > l
		} else {
			yyb1098 = r.CheckBreak()
		}
		if yyb1098 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1098-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1101 := z.EncBinary()
		_ = yym1101
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1102 := !z.EncBinary()
			yy2arr1102 := z.EncBasicHandle().StructToArray
			var yyq1102 [1]bool
			_, _, _ = yysep1102, yyq1102, yy2arr1102
			const yyr1102 bool = false
			yyq1102[0] = x.HTTP != nil
			var yynn1102 int
			if yyr1102 || yy2arr1102 {
				r.EncodeArrayStart(1)
			} else {
				yynn1102 = 0
				for _, b := range yyq1102 {
					if b {
						yynn1102++
					}
				}
				r.EncodeMapStart(yynn1102)
				yynn1102 = 0
			}
			if yyr1102 || yy2arr1102 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1102[0] {
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1102[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1102 || yy2arr1102 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1104 := z.DecBinary()
	_ = yym1104
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1105 := r.ContainerType()
		if yyct1105 == codecSelferValueTypeMap1234 {
			yyl1105 := r.ReadMapStart()
			if yyl1105 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1105, d)
			}
		} else if yyct1105 == codecSelferValueTypeArray1234 {
			yyl1105 := r.ReadArrayStart()
			if yyl1105 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1105, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1106Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1106Slc
	var yyhl1106 bool = l >= 0
	for yyj1106 := 0; ; yyj1106++ {
		if yyhl1106 {
			if yyj1106 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1106Slc = r.DecodeBytes(yys1106Slc, true, true)
		yys1106 := string(yys1106Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1106 {
		case "http":
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1106)
		} // end switch yys1106
	} // end for yyj1106
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1108 int
	var yyb1108 bool
	var yyhl1108 bool = l >= 0
	yyj1108++
	if yyhl1108 {
		yyb1108 = yyj1108 > l
	} else {
		yyb1108 = r.CheckBreak()
	}
	if yyb1108 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj1108++
		if yyhl1108 {
			yyb1108 = yyj1108 > l
		} else {
			yyb1108 = r.CheckBreak()
		}
		if yyb1108 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1108-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1110 := z.EncBinary()
		_ = yym1110
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1111 := !z.EncBinary()
			yy2arr1111 := z.EncBasicHandle().StructToArray
			var yyq1111 [1]bool
			_, _, _ = yysep1111, yyq1111, yy2arr1111
			const yyr1111 bool = false
			var yynn1111 int
			if yyr1111 || yy2arr1111 {
				r.EncodeArrayStart(1)
			} else {
				yynn1111 = 1
				for _, b := range yyq1111 {
					if b {
						yynn1111++
					}
				}
				r.EncodeMapStart(yynn1111)
				yynn1111 = 0
			}
			if yyr1111 || yy2arr1111 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym1113 := z.EncBinary()
					_ = yym1113
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("paths"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym1114 := z.EncBinary()
					_ = yym1114
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			}
			if yyr1111 || yy2arr1111 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1115 := z.DecBinary()
	_ = yym1115
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1116 := r.ContainerType()
		if yyct1116 == codecSelferValueTypeMap1234 {
			yyl1116 := r.ReadMapStart()
			if yyl1116 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1116, d)
			}
		} else if yyct1116 == codecSelferValueTypeArray1234 {
			yyl1116 := r.ReadArrayStart()
			if yyl1116 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1116, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1117Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1117Slc
	var yyhl1117 bool = l >= 0
	for yyj1117 := 0; ; yyj1117++ {
		if yyhl1117 {
			if yyj1117 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1117Slc = r.DecodeBytes(yys1117Slc, true, true)
		yys1117 := string(yys1117Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1117 {
		case "paths":
			if r.TryDecodeAsNil() {
				x.Paths = nil
			} else {
				yyv1118 := &x.Paths
				yym1119 := z.DecBinary()
				_ = yym1119
				if false {
				} else {
					h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv1118), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1117)
		} // end switch yys1117
	} // end for yyj1117
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1120 int
	var yyb1120 bool
	var yyhl1120 bool = l >= 0
	yyj1120++
	if yyhl1120 {
		yyb1120 = yyj1120 > l
	} else {
		yyb1120 = r.CheckBreak()
	}
	if yyb1120 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paths = nil
	} else {
		yyv1121 := &x.Paths
		yym1122 := z.DecBinary()
		_ = yym1122
		if false {
		} else {
			h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv1121), d)
		}
	}
	for {
		yyj1120++
		if yyhl1120 {
			yyb1120 = yyj1120 > l
		} else {
			yyb1120 = r.CheckBreak()
		}
		if yyb1120 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1120-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1123 := z.EncBinary()
		_ = yym1123
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1124 := !z.EncBinary()
			yy2arr1124 := z.EncBasicHandle().StructToArray
			var yyq1124 [2]bool
			_, _, _ = yysep1124, yyq1124, yy2arr1124
			const yyr1124 bool = false
			yyq1124[0] = x.Path != ""
			var yynn1124 int
			if yyr1124 || yy2arr1124 {
				r.EncodeArrayStart(2)
			} else {
				yynn1124 = 1
				for _, b := range yyq1124 {
					if b {
						yynn1124++
					}
				}
				r.EncodeMapStart(yynn1124)
				yynn1124 = 0
			}
			if yyr1124 || yy2arr1124 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1124[0] {
					yym1126 := z.EncBinary()
					_ = yym1126
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1124[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1127 := z.EncBinary()
					_ = yym1127
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr1124 || yy2arr1124 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1129 := &x.Backend
				yy1129.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("backend"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1130 := &x.Backend
				yy1130.CodecEncodeSelf(e)
			}
			if yyr1124 || yy2arr1124 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1131 := z.DecBinary()
	_ = yym1131
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1132 := r.ContainerType()
		if yyct1132 == codecSelferValueTypeMap1234 {
			yyl1132 := r.ReadMapStart()
			if yyl1132 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1132, d)
			}
		} else if yyct1132 == codecSelferValueTypeArray1234 {
			yyl1132 := r.ReadArrayStart()
			if yyl1132 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1132, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1133Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1133Slc
	var yyhl1133 bool = l >= 0
	for yyj1133 := 0; ; yyj1133++ {
		if yyhl1133 {
			if yyj1133 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1133Slc = r.DecodeBytes(yys1133Slc, true, true)
		yys1133 := string(yys1133Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1133 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "backend":
			if r.TryDecodeAsNil() {
				x.Backend = IngressBackend{}
			} else {
				yyv1135 := &x.Backend
				yyv1135.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1133)
		} // end switch yys1133
	} // end for yyj1133
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1136 int
	var yyb1136 bool
	var yyhl1136 bool = l >= 0
	yyj1136++
	if yyhl1136 {
		yyb1136 = yyj1136 > l
	} else {
		yyb1136 = r.CheckBreak()
	}
	if yyb1136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1136++
	if yyhl1136 {
		yyb1136 = yyj1136 > l
	} else {
		yyb1136 = r.CheckBreak()
	}
	if yyb1136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Backend = IngressBackend{}
	} else {
		yyv1138 := &x.Backend
		yyv1138.CodecDecodeSelf(d)
	}
	for {
		yyj1136++
		if yyhl1136 {
			yyb1136 = yyj1136 > l
		} else {
			yyb1136 = r.CheckBreak()
		}
		if yyb1136 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1136-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressBackend) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1139 := z.EncBinary()
		_ = yym1139
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1140 := !z.EncBinary()
			yy2arr1140 := z.EncBasicHandle().StructToArray
			var yyq1140 [2]bool
			_, _, _ = yysep1140, yyq1140, yy2arr1140
			const yyr1140 bool = false
			var yynn1140 int
			if yyr1140 || yy2arr1140 {
				r.EncodeArrayStart(2)
			} else {
				yynn1140 = 2
				for _, b := range yyq1140 {
					if b {
						yynn1140++
					}
				}
				r.EncodeMapStart(yynn1140)
				yynn1140 = 0
			}
			if yyr1140 || yy2arr1140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1142 := z.EncBinary()
				_ = yym1142
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1143 := z.EncBinary()
				_ = yym1143
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			}
			if yyr1140 || yy2arr1140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1145 := &x.ServicePort
				yym1146 := z.EncBinary()
				_ = yym1146
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1145) {
				} else if !yym1146 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1145)
				} else {
					z.EncFallback(yy1145)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("servicePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1147 := &x.ServicePort
				yym1148 := z.EncBinary()
				_ = yym1148
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1147) {
				} else if !yym1148 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1147)
				} else {
					z.EncFallback(yy1147)
				}
			}
			if yyr1140 || yy2arr1140 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressBackend) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1149 := z.DecBinary()
	_ = yym1149
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1150 := r.ContainerType()
		if yyct1150 == codecSelferValueTypeMap1234 {
			yyl1150 := r.ReadMapStart()
			if yyl1150 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1150, d)
			}
		} else if yyct1150 == codecSelferValueTypeArray1234 {
			yyl1150 := r.ReadArrayStart()
			if yyl1150 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1150, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressBackend) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1151Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1151Slc
	var yyhl1151 bool = l >= 0
	for yyj1151 := 0; ; yyj1151++ {
		if yyhl1151 {
			if yyj1151 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1151Slc = r.DecodeBytes(yys1151Slc, true, true)
		yys1151 := string(yys1151Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1151 {
		case "serviceName":
			if r.TryDecodeAsNil() {
				x.ServiceName = ""
			} else {
				x.ServiceName = string(r.DecodeString())
			}
		case "servicePort":
			if r.TryDecodeAsNil() {
				x.ServicePort = pkg5_intstr.IntOrString{}
			} else {
				yyv1153 := &x.ServicePort
				yym1154 := z.DecBinary()
				_ = yym1154
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1153) {
				} else if !yym1154 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1153)
				} else {
					z.DecFallback(yyv1153, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1151)
		} // end switch yys1151
	} // end for yyj1151
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressBackend) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1155 int
	var yyb1155 bool
	var yyhl1155 bool = l >= 0
	yyj1155++
	if yyhl1155 {
		yyb1155 = yyj1155 > l
	} else {
		yyb1155 = r.CheckBreak()
	}
	if yyb1155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceName = ""
	} else {
		x.ServiceName = string(r.DecodeString())
	}
	yyj1155++
	if yyhl1155 {
		yyb1155 = yyj1155 > l
	} else {
		yyb1155 = r.CheckBreak()
	}
	if yyb1155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServicePort = pkg5_intstr.IntOrString{}
	} else {
		yyv1157 := &x.ServicePort
		yym1158 := z.DecBinary()
		_ = yym1158
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1157) {
		} else if !yym1158 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1157)
		} else {
			z.DecFallback(yyv1157, false)
		}
	}
	for {
		yyj1155++
		if yyhl1155 {
			yyb1155 = yyj1155 > l
		} else {
			yyb1155 = r.CheckBreak()
		}
		if yyb1155 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1155-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExportOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1159 := z.EncBinary()
		_ = yym1159
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1160 := !z.EncBinary()
			yy2arr1160 := z.EncBasicHandle().StructToArray
			var yyq1160 [4]bool
			_, _, _ = yysep1160, yyq1160, yy2arr1160
			const yyr1160 bool = false
			yyq1160[0] = x.Kind != ""
			yyq1160[1] = x.APIVersion != ""
			var yynn1160 int
			if yyr1160 || yy2arr1160 {
				r.EncodeArrayStart(4)
			} else {
				yynn1160 = 2
				for _, b := range yyq1160 {
					if b {
						yynn1160++
					}
				}
				r.EncodeMapStart(yynn1160)
				yynn1160 = 0
			}
			if yyr1160 || yy2arr1160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1160[0] {
					yym1162 := z.EncBinary()
					_ = yym1162
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1160[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1163 := z.EncBinary()
					_ = yym1163
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1160 || yy2arr1160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1160[1] {
					yym1165 := z.EncBinary()
					_ = yym1165
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1160[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1166 := z.EncBinary()
					_ = yym1166
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1160 || yy2arr1160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1168 := z.EncBinary()
				_ = yym1168
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("export"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1169 := z.EncBinary()
				_ = yym1169
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			}
			if yyr1160 || yy2arr1160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1171 := z.EncBinary()
				_ = yym1171
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exact"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1172 := z.EncBinary()
				_ = yym1172
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			}
			if yyr1160 || yy2arr1160 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExportOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1173 := z.DecBinary()
	_ = yym1173
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1174 := r.ContainerType()
		if yyct1174 == codecSelferValueTypeMap1234 {
			yyl1174 := r.ReadMapStart()
			if yyl1174 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1174, d)
			}
		} else if yyct1174 == codecSelferValueTypeArray1234 {
			yyl1174 := r.ReadArrayStart()
			if yyl1174 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1174, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExportOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1175Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1175Slc
	var yyhl1175 bool = l >= 0
	for yyj1175 := 0; ; yyj1175++ {
		if yyhl1175 {
			if yyj1175 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1175Slc = r.DecodeBytes(yys1175Slc, true, true)
		yys1175 := string(yys1175Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1175 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "export":
			if r.TryDecodeAsNil() {
				x.Export = false
			} else {
				x.Export = bool(r.DecodeBool())
			}
		case "exact":
			if r.TryDecodeAsNil() {
				x.Exact = false
			} else {
				x.Exact = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1175)
		} // end switch yys1175
	} // end for yyj1175
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExportOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1180 int
	var yyb1180 bool
	var yyhl1180 bool = l >= 0
	yyj1180++
	if yyhl1180 {
		yyb1180 = yyj1180 > l
	} else {
		yyb1180 = r.CheckBreak()
	}
	if yyb1180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1180++
	if yyhl1180 {
		yyb1180 = yyj1180 > l
	} else {
		yyb1180 = r.CheckBreak()
	}
	if yyb1180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1180++
	if yyhl1180 {
		yyb1180 = yyj1180 > l
	} else {
		yyb1180 = r.CheckBreak()
	}
	if yyb1180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Export = false
	} else {
		x.Export = bool(r.DecodeBool())
	}
	yyj1180++
	if yyhl1180 {
		yyb1180 = yyj1180 > l
	} else {
		yyb1180 = r.CheckBreak()
	}
	if yyb1180 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Exact = false
	} else {
		x.Exact = bool(r.DecodeBool())
	}
	for {
		yyj1180++
		if yyhl1180 {
			yyb1180 = yyj1180 > l
		} else {
			yyb1180 = r.CheckBreak()
		}
		if yyb1180 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1180-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ListOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1185 := z.EncBinary()
		_ = yym1185
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1186 := !z.EncBinary()
			yy2arr1186 := z.EncBasicHandle().StructToArray
			var yyq1186 [7]bool
			_, _, _ = yysep1186, yyq1186, yy2arr1186
			const yyr1186 bool = false
			yyq1186[0] = x.Kind != ""
			yyq1186[1] = x.APIVersion != ""
			yyq1186[2] = x.LabelSelector != ""
			yyq1186[3] = x.FieldSelector != ""
			yyq1186[4] = x.Watch != false
			yyq1186[5] = x.ResourceVersion != ""
			yyq1186[6] = x.TimeoutSeconds != nil
			var yynn1186 int
			if yyr1186 || yy2arr1186 {
				r.EncodeArrayStart(7)
			} else {
				yynn1186 = 0
				for _, b := range yyq1186 {
					if b {
						yynn1186++
					}
				}
				r.EncodeMapStart(yynn1186)
				yynn1186 = 0
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1186[0] {
					yym1188 := z.EncBinary()
					_ = yym1188
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1186[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1189 := z.EncBinary()
					_ = yym1189
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1186[1] {
					yym1191 := z.EncBinary()
					_ = yym1191
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1186[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1192 := z.EncBinary()
					_ = yym1192
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1186[2] {
					yym1194 := z.EncBinary()
					_ = yym1194
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LabelSelector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1186[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labelSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1195 := z.EncBinary()
					_ = yym1195
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LabelSelector))
					}
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1186[3] {
					yym1197 := z.EncBinary()
					_ = yym1197
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldSelector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1186[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1198 := z.EncBinary()
					_ = yym1198
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FieldSelector))
					}
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1186[4] {
					yym1200 := z.EncBinary()
					_ = yym1200
					if false {
					} else {
						r.EncodeBool(bool(x.Watch))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1186[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("watch"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1201 := z.EncBinary()
					_ = yym1201
					if false {
					} else {
						r.EncodeBool(bool(x.Watch))
					}
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1186[5] {
					yym1203 := z.EncBinary()
					_ = yym1203
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1186[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1204 := z.EncBinary()
					_ = yym1204
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1186[6] {
					if x.TimeoutSeconds == nil {
						r.EncodeNil()
					} else {
						yy1206 := *x.TimeoutSeconds
						yym1207 := z.EncBinary()
						_ = yym1207
						if false {
						} else {
							r.EncodeInt(int64(yy1206))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1186[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TimeoutSeconds == nil {
						r.EncodeNil()
					} else {
						yy1208 := *x.TimeoutSeconds
						yym1209 := z.EncBinary()
						_ = yym1209
						if false {
						} else {
							r.EncodeInt(int64(yy1208))
						}
					}
				}
			}
			if yyr1186 || yy2arr1186 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ListOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1210 := z.DecBinary()
	_ = yym1210
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1211 := r.ContainerType()
		if yyct1211 == codecSelferValueTypeMap1234 {
			yyl1211 := r.ReadMapStart()
			if yyl1211 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1211, d)
			}
		} else if yyct1211 == codecSelferValueTypeArray1234 {
			yyl1211 := r.ReadArrayStart()
			if yyl1211 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1211, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ListOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1212Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1212Slc
	var yyhl1212 bool = l >= 0
	for yyj1212 := 0; ; yyj1212++ {
		if yyhl1212 {
			if yyj1212 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1212Slc = r.DecodeBytes(yys1212Slc, true, true)
		yys1212 := string(yys1212Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1212 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "labelSelector":
			if r.TryDecodeAsNil() {
				x.LabelSelector = ""
			} else {
				x.LabelSelector = string(r.DecodeString())
			}
		case "fieldSelector":
			if r.TryDecodeAsNil() {
				x.FieldSelector = ""
			} else {
				x.FieldSelector = string(r.DecodeString())
			}
		case "watch":
			if r.TryDecodeAsNil() {
				x.Watch = false
			} else {
				x.Watch = bool(r.DecodeBool())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				if x.TimeoutSeconds != nil {
					x.TimeoutSeconds = nil
				}
			} else {
				if x.TimeoutSeconds == nil {
					x.TimeoutSeconds = new(int64)
				}
				yym1220 := z.DecBinary()
				_ = yym1220
				if false {
				} else {
					*((*int64)(x.TimeoutSeconds)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1212)
		} // end switch yys1212
	} // end for yyj1212
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ListOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1221 int
	var yyb1221 bool
	var yyhl1221 bool = l >= 0
	yyj1221++
	if yyhl1221 {
		yyb1221 = yyj1221 > l
	} else {
		yyb1221 = r.CheckBreak()
	}
	if yyb1221 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1221++
	if yyhl1221 {
		yyb1221 = yyj1221 > l
	} else {
		yyb1221 = r.CheckBreak()
	}
	if yyb1221 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1221++
	if yyhl1221 {
		yyb1221 = yyj1221 > l
	} else {
		yyb1221 = r.CheckBreak()
	}
	if yyb1221 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LabelSelector = ""
	} else {
		x.LabelSelector = string(r.DecodeString())
	}
	yyj1221++
	if yyhl1221 {
		yyb1221 = yyj1221 > l
	} else {
		yyb1221 = r.CheckBreak()
	}
	if yyb1221 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldSelector = ""
	} else {
		x.FieldSelector = string(r.DecodeString())
	}
	yyj1221++
	if yyhl1221 {
		yyb1221 = yyj1221 > l
	} else {
		yyb1221 = r.CheckBreak()
	}
	if yyb1221 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Watch = false
	} else {
		x.Watch = bool(r.DecodeBool())
	}
	yyj1221++
	if yyhl1221 {
		yyb1221 = yyj1221 > l
	} else {
		yyb1221 = r.CheckBreak()
	}
	if yyb1221 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj1221++
	if yyhl1221 {
		yyb1221 = yyj1221 > l
	} else {
		yyb1221 = r.CheckBreak()
	}
	if yyb1221 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TimeoutSeconds != nil {
			x.TimeoutSeconds = nil
		}
	} else {
		if x.TimeoutSeconds == nil {
			x.TimeoutSeconds = new(int64)
		}
		yym1229 := z.DecBinary()
		_ = yym1229
		if false {
		} else {
			*((*int64)(x.TimeoutSeconds)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj1221++
		if yyhl1221 {
			yyb1221 = yyj1221 > l
		} else {
			yyb1221 = r.CheckBreak()
		}
		if yyb1221 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1221-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1230 := z.EncBinary()
		_ = yym1230
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1231 := !z.EncBinary()
			yy2arr1231 := z.EncBasicHandle().StructToArray
			var yyq1231 [2]bool
			_, _, _ = yysep1231, yyq1231, yy2arr1231
			const yyr1231 bool = false
			yyq1231[0] = len(x.MatchLabels) != 0
			yyq1231[1] = len(x.MatchExpressions) != 0
			var yynn1231 int
			if yyr1231 || yy2arr1231 {
				r.EncodeArrayStart(2)
			} else {
				yynn1231 = 0
				for _, b := range yyq1231 {
					if b {
						yynn1231++
					}
				}
				r.EncodeMapStart(yynn1231)
				yynn1231 = 0
			}
			if yyr1231 || yy2arr1231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1231[0] {
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym1233 := z.EncBinary()
						_ = yym1233
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1231[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchLabels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchLabels == nil {
						r.EncodeNil()
					} else {
						yym1234 := z.EncBinary()
						_ = yym1234
						if false {
						} else {
							z.F.EncMapStringStringV(x.MatchLabels, false, e)
						}
					}
				}
			}
			if yyr1231 || yy2arr1231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1231[1] {
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym1236 := z.EncBinary()
						_ = yym1236
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1231[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MatchExpressions == nil {
						r.EncodeNil()
					} else {
						yym1237 := z.EncBinary()
						_ = yym1237
						if false {
						} else {
							h.encSliceLabelSelectorRequirement(([]LabelSelectorRequirement)(x.MatchExpressions), e)
						}
					}
				}
			}
			if yyr1231 || yy2arr1231 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1238 := z.DecBinary()
	_ = yym1238
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1239 := r.ContainerType()
		if yyct1239 == codecSelferValueTypeMap1234 {
			yyl1239 := r.ReadMapStart()
			if yyl1239 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1239, d)
			}
		} else if yyct1239 == codecSelferValueTypeArray1234 {
			yyl1239 := r.ReadArrayStart()
			if yyl1239 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1239, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1240Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1240Slc
	var yyhl1240 bool = l >= 0
	for yyj1240 := 0; ; yyj1240++ {
		if yyhl1240 {
			if yyj1240 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1240Slc = r.DecodeBytes(yys1240Slc, true, true)
		yys1240 := string(yys1240Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1240 {
		case "matchLabels":
			if r.TryDecodeAsNil() {
				x.MatchLabels = nil
			} else {
				yyv1241 := &x.MatchLabels
				yym1242 := z.DecBinary()
				_ = yym1242
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1241, false, d)
				}
			}
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv1243 := &x.MatchExpressions
				yym1244 := z.DecBinary()
				_ = yym1244
				if false {
				} else {
					h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv1243), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1240)
		} // end switch yys1240
	} // end for yyj1240
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1245 int
	var yyb1245 bool
	var yyhl1245 bool = l >= 0
	yyj1245++
	if yyhl1245 {
		yyb1245 = yyj1245 > l
	} else {
		yyb1245 = r.CheckBreak()
	}
	if yyb1245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchLabels = nil
	} else {
		yyv1246 := &x.MatchLabels
		yym1247 := z.DecBinary()
		_ = yym1247
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1246, false, d)
		}
	}
	yyj1245++
	if yyhl1245 {
		yyb1245 = yyj1245 > l
	} else {
		yyb1245 = r.CheckBreak()
	}
	if yyb1245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv1248 := &x.MatchExpressions
		yym1249 := z.DecBinary()
		_ = yym1249
		if false {
		} else {
			h.decSliceLabelSelectorRequirement((*[]LabelSelectorRequirement)(yyv1248), d)
		}
	}
	for {
		yyj1245++
		if yyhl1245 {
			yyb1245 = yyj1245 > l
		} else {
			yyb1245 = r.CheckBreak()
		}
		if yyb1245 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1245-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LabelSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1250 := z.EncBinary()
		_ = yym1250
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1251 := !z.EncBinary()
			yy2arr1251 := z.EncBasicHandle().StructToArray
			var yyq1251 [3]bool
			_, _, _ = yysep1251, yyq1251, yy2arr1251
			const yyr1251 bool = false
			yyq1251[2] = len(x.Values) != 0
			var yynn1251 int
			if yyr1251 || yy2arr1251 {
				r.EncodeArrayStart(3)
			} else {
				yynn1251 = 2
				for _, b := range yyq1251 {
					if b {
						yynn1251++
					}
				}
				r.EncodeMapStart(yynn1251)
				yynn1251 = 0
			}
			if yyr1251 || yy2arr1251 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1253 := z.EncBinary()
				_ = yym1253
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1254 := z.EncBinary()
				_ = yym1254
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1251 || yy2arr1251 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr1251 || yy2arr1251 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1251[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1257 := z.EncBinary()
						_ = yym1257
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1251[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1258 := z.EncBinary()
						_ = yym1258
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr1251 || yy2arr1251 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LabelSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1259 := z.DecBinary()
	_ = yym1259
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1260 := r.ContainerType()
		if yyct1260 == codecSelferValueTypeMap1234 {
			yyl1260 := r.ReadMapStart()
			if yyl1260 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1260, d)
			}
		} else if yyct1260 == codecSelferValueTypeArray1234 {
			yyl1260 := r.ReadArrayStart()
			if yyl1260 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1260, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1261Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1261Slc
	var yyhl1261 bool = l >= 0
	for yyj1261 := 0; ; yyj1261++ {
		if yyhl1261 {
			if yyj1261 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1261Slc = r.DecodeBytes(yys1261Slc, true, true)
		yys1261 := string(yys1261Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1261 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = LabelSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv1264 := &x.Values
				yym1265 := z.DecBinary()
				_ = yym1265
				if false {
				} else {
					z.F.DecSliceStringX(yyv1264, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1261)
		} // end switch yys1261
	} // end for yyj1261
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LabelSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1266 int
	var yyb1266 bool
	var yyhl1266 bool = l >= 0
	yyj1266++
	if yyhl1266 {
		yyb1266 = yyj1266 > l
	} else {
		yyb1266 = r.CheckBreak()
	}
	if yyb1266 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1266++
	if yyhl1266 {
		yyb1266 = yyj1266 > l
	} else {
		yyb1266 = r.CheckBreak()
	}
	if yyb1266 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = LabelSelectorOperator(r.DecodeString())
	}
	yyj1266++
	if yyhl1266 {
		yyb1266 = yyj1266 > l
	} else {
		yyb1266 = r.CheckBreak()
	}
	if yyb1266 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv1269 := &x.Values
		yym1270 := z.DecBinary()
		_ = yym1270
		if false {
		} else {
			z.F.DecSliceStringX(yyv1269, false, d)
		}
	}
	for {
		yyj1266++
		if yyhl1266 {
			yyb1266 = yyj1266 > l
		} else {
			yyb1266 = r.CheckBreak()
		}
		if yyb1266 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1266-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x LabelSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1271 := z.EncBinary()
	_ = yym1271
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *LabelSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1272 := z.DecBinary()
	_ = yym1272
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ReplicaSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1273 := z.EncBinary()
		_ = yym1273
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1274 := !z.EncBinary()
			yy2arr1274 := z.EncBasicHandle().StructToArray
			var yyq1274 [5]bool
			_, _, _ = yysep1274, yyq1274, yy2arr1274
			const yyr1274 bool = false
			yyq1274[0] = x.Kind != ""
			yyq1274[1] = x.APIVersion != ""
			yyq1274[2] = true
			yyq1274[3] = true
			yyq1274[4] = true
			var yynn1274 int
			if yyr1274 || yy2arr1274 {
				r.EncodeArrayStart(5)
			} else {
				yynn1274 = 0
				for _, b := range yyq1274 {
					if b {
						yynn1274++
					}
				}
				r.EncodeMapStart(yynn1274)
				yynn1274 = 0
			}
			if yyr1274 || yy2arr1274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1274[0] {
					yym1276 := z.EncBinary()
					_ = yym1276
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1274[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1277 := z.EncBinary()
					_ = yym1277
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1274 || yy2arr1274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1274[1] {
					yym1279 := z.EncBinary()
					_ = yym1279
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1274[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1280 := z.EncBinary()
					_ = yym1280
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1274 || yy2arr1274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1274[2] {
					yy1282 := &x.ObjectMeta
					yy1282.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1274[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1283 := &x.ObjectMeta
					yy1283.CodecEncodeSelf(e)
				}
			}
			if yyr1274 || yy2arr1274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1274[3] {
					yy1285 := &x.Spec
					yy1285.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1274[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1286 := &x.Spec
					yy1286.CodecEncodeSelf(e)
				}
			}
			if yyr1274 || yy2arr1274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1274[4] {
					yy1288 := &x.Status
					yy1288.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1274[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1289 := &x.Status
					yy1289.CodecEncodeSelf(e)
				}
			}
			if yyr1274 || yy2arr1274 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1290 := z.DecBinary()
	_ = yym1290
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1291 := r.ContainerType()
		if yyct1291 == codecSelferValueTypeMap1234 {
			yyl1291 := r.ReadMapStart()
			if yyl1291 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1291, d)
			}
		} else if yyct1291 == codecSelferValueTypeArray1234 {
			yyl1291 := r.ReadArrayStart()
			if yyl1291 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1291, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1292Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1292Slc
	var yyhl1292 bool = l >= 0
	for yyj1292 := 0; ; yyj1292++ {
		if yyhl1292 {
			if yyj1292 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1292Slc = r.DecodeBytes(yys1292Slc, true, true)
		yys1292 := string(yys1292Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1292 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1295 := &x.ObjectMeta
				yyv1295.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicaSetSpec{}
			} else {
				yyv1296 := &x.Spec
				yyv1296.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicaSetStatus{}
			} else {
				yyv1297 := &x.Status
				yyv1297.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1292)
		} // end switch yys1292
	} // end for yyj1292
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1298 int
	var yyb1298 bool
	var yyhl1298 bool = l >= 0
	yyj1298++
	if yyhl1298 {
		yyb1298 = yyj1298 > l
	} else {
		yyb1298 = r.CheckBreak()
	}
	if yyb1298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1298++
	if yyhl1298 {
		yyb1298 = yyj1298 > l
	} else {
		yyb1298 = r.CheckBreak()
	}
	if yyb1298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1298++
	if yyhl1298 {
		yyb1298 = yyj1298 > l
	} else {
		yyb1298 = r.CheckBreak()
	}
	if yyb1298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1301 := &x.ObjectMeta
		yyv1301.CodecDecodeSelf(d)
	}
	yyj1298++
	if yyhl1298 {
		yyb1298 = yyj1298 > l
	} else {
		yyb1298 = r.CheckBreak()
	}
	if yyb1298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicaSetSpec{}
	} else {
		yyv1302 := &x.Spec
		yyv1302.CodecDecodeSelf(d)
	}
	yyj1298++
	if yyhl1298 {
		yyb1298 = yyj1298 > l
	} else {
		yyb1298 = r.CheckBreak()
	}
	if yyb1298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicaSetStatus{}
	} else {
		yyv1303 := &x.Status
		yyv1303.CodecDecodeSelf(d)
	}
	for {
		yyj1298++
		if yyhl1298 {
			yyb1298 = yyj1298 > l
		} else {
			yyb1298 = r.CheckBreak()
		}
		if yyb1298 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1298-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1304 := z.EncBinary()
		_ = yym1304
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1305 := !z.EncBinary()
			yy2arr1305 := z.EncBasicHandle().StructToArray
			var yyq1305 [4]bool
			_, _, _ = yysep1305, yyq1305, yy2arr1305
			const yyr1305 bool = false
			yyq1305[0] = x.Kind != ""
			yyq1305[1] = x.APIVersion != ""
			yyq1305[2] = true
			var yynn1305 int
			if yyr1305 || yy2arr1305 {
				r.EncodeArrayStart(4)
			} else {
				yynn1305 = 1
				for _, b := range yyq1305 {
					if b {
						yynn1305++
					}
				}
				r.EncodeMapStart(yynn1305)
				yynn1305 = 0
			}
			if yyr1305 || yy2arr1305 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1305[0] {
					yym1307 := z.EncBinary()
					_ = yym1307
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1305[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1308 := z.EncBinary()
					_ = yym1308
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1305 || yy2arr1305 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1305[1] {
					yym1310 := z.EncBinary()
					_ = yym1310
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1305[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1311 := z.EncBinary()
					_ = yym1311
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1305 || yy2arr1305 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1305[2] {
					yy1313 := &x.ListMeta
					yym1314 := z.EncBinary()
					_ = yym1314
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1313) {
					} else {
						z.EncFallback(yy1313)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1305[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1315 := &x.ListMeta
					yym1316 := z.EncBinary()
					_ = yym1316
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1315) {
					} else {
						z.EncFallback(yy1315)
					}
				}
			}
			if yyr1305 || yy2arr1305 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1318 := z.EncBinary()
					_ = yym1318
					if false {
					} else {
						h.encSliceReplicaSet(([]ReplicaSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1319 := z.EncBinary()
					_ = yym1319
					if false {
					} else {
						h.encSliceReplicaSet(([]ReplicaSet)(x.Items), e)
					}
				}
			}
			if yyr1305 || yy2arr1305 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1320 := z.DecBinary()
	_ = yym1320
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1321 := r.ContainerType()
		if yyct1321 == codecSelferValueTypeMap1234 {
			yyl1321 := r.ReadMapStart()
			if yyl1321 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1321, d)
			}
		} else if yyct1321 == codecSelferValueTypeArray1234 {
			yyl1321 := r.ReadArrayStart()
			if yyl1321 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1321, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1322Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1322Slc
	var yyhl1322 bool = l >= 0
	for yyj1322 := 0; ; yyj1322++ {
		if yyhl1322 {
			if yyj1322 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1322Slc = r.DecodeBytes(yys1322Slc, true, true)
		yys1322 := string(yys1322Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1322 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1325 := &x.ListMeta
				yym1326 := z.DecBinary()
				_ = yym1326
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1325) {
				} else {
					z.DecFallback(yyv1325, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1327 := &x.Items
				yym1328 := z.DecBinary()
				_ = yym1328
				if false {
				} else {
					h.decSliceReplicaSet((*[]ReplicaSet)(yyv1327), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1322)
		} // end switch yys1322
	} // end for yyj1322
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1329 int
	var yyb1329 bool
	var yyhl1329 bool = l >= 0
	yyj1329++
	if yyhl1329 {
		yyb1329 = yyj1329 > l
	} else {
		yyb1329 = r.CheckBreak()
	}
	if yyb1329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1329++
	if yyhl1329 {
		yyb1329 = yyj1329 > l
	} else {
		yyb1329 = r.CheckBreak()
	}
	if yyb1329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1329++
	if yyhl1329 {
		yyb1329 = yyj1329 > l
	} else {
		yyb1329 = r.CheckBreak()
	}
	if yyb1329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1332 := &x.ListMeta
		yym1333 := z.DecBinary()
		_ = yym1333
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1332) {
		} else {
			z.DecFallback(yyv1332, false)
		}
	}
	yyj1329++
	if yyhl1329 {
		yyb1329 = yyj1329 > l
	} else {
		yyb1329 = r.CheckBreak()
	}
	if yyb1329 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1334 := &x.Items
		yym1335 := z.DecBinary()
		_ = yym1335
		if false {
		} else {
			h.decSliceReplicaSet((*[]ReplicaSet)(yyv1334), d)
		}
	}
	for {
		yyj1329++
		if yyhl1329 {
			yyb1329 = yyj1329 > l
		} else {
			yyb1329 = r.CheckBreak()
		}
		if yyb1329 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1329-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1336 := z.EncBinary()
		_ = yym1336
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1337 := !z.EncBinary()
			yy2arr1337 := z.EncBasicHandle().StructToArray
			var yyq1337 [3]bool
			_, _, _ = yysep1337, yyq1337, yy2arr1337
			const yyr1337 bool = false
			yyq1337[0] = x.Replicas != nil
			yyq1337[1] = x.Selector != nil
			yyq1337[2] = true
			var yynn1337 int
			if yyr1337 || yy2arr1337 {
				r.EncodeArrayStart(3)
			} else {
				yynn1337 = 0
				for _, b := range yyq1337 {
					if b {
						yynn1337++
					}
				}
				r.EncodeMapStart(yynn1337)
				yynn1337 = 0
			}
			if yyr1337 || yy2arr1337 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1337[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy1339 := *x.Replicas
						yym1340 := z.EncBinary()
						_ = yym1340
						if false {
						} else {
							r.EncodeInt(int64(yy1339))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1337[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy1341 := *x.Replicas
						yym1342 := z.EncBinary()
						_ = yym1342
						if false {
						} else {
							r.EncodeInt(int64(yy1341))
						}
					}
				}
			}
			if yyr1337 || yy2arr1337 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1337[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1337[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						x.Selector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1337 || yy2arr1337 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1337[2] {
					yy1345 := &x.Template
					yy1345.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1337[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1346 := &x.Template
					yy1346.CodecEncodeSelf(e)
				}
			}
			if yyr1337 || yy2arr1337 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1347 := z.DecBinary()
	_ = yym1347
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1348 := r.ContainerType()
		if yyct1348 == codecSelferValueTypeMap1234 {
			yyl1348 := r.ReadMapStart()
			if yyl1348 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1348, d)
			}
		} else if yyct1348 == codecSelferValueTypeArray1234 {
			yyl1348 := r.ReadArrayStart()
			if yyl1348 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1348, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1349Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1349Slc
	var yyhl1349 bool = l >= 0
	for yyj1349 := 0; ; yyj1349++ {
		if yyhl1349 {
			if yyj1349 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1349Slc = r.DecodeBytes(yys1349Slc, true, true)
		yys1349 := string(yys1349Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1349 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym1351 := z.DecBinary()
				_ = yym1351
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(LabelSelector)
				}
				x.Selector.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv1353 := &x.Template
				yyv1353.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1349)
		} // end switch yys1349
	} // end for yyj1349
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1354 int
	var yyb1354 bool
	var yyhl1354 bool = l >= 0
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym1356 := z.DecBinary()
		_ = yym1356
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(LabelSelector)
		}
		x.Selector.CodecDecodeSelf(d)
	}
	yyj1354++
	if yyhl1354 {
		yyb1354 = yyj1354 > l
	} else {
		yyb1354 = r.CheckBreak()
	}
	if yyb1354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv1358 := &x.Template
		yyv1358.CodecDecodeSelf(d)
	}
	for {
		yyj1354++
		if yyhl1354 {
			yyb1354 = yyj1354 > l
		} else {
			yyb1354 = r.CheckBreak()
		}
		if yyb1354 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1354-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1359 := z.EncBinary()
		_ = yym1359
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1360 := !z.EncBinary()
			yy2arr1360 := z.EncBasicHandle().StructToArray
			var yyq1360 [4]bool
			_, _, _ = yysep1360, yyq1360, yy2arr1360
			const yyr1360 bool = false
			yyq1360[1] = x.FullyLabeledReplicas != 0
			yyq1360[2] = x.ReadyReplicas != 0
			yyq1360[3] = x.ObservedGeneration != 0
			var yynn1360 int
			if yyr1360 || yy2arr1360 {
				r.EncodeArrayStart(4)
			} else {
				yynn1360 = 1
				for _, b := range yyq1360 {
					if b {
						yynn1360++
					}
				}
				r.EncodeMapStart(yynn1360)
				yynn1360 = 0
			}
			if yyr1360 || yy2arr1360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1362 := z.EncBinary()
				_ = yym1362
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1363 := z.EncBinary()
				_ = yym1363
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr1360 || yy2arr1360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1360[1] {
					yym1365 := z.EncBinary()
					_ = yym1365
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1360[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1366 := z.EncBinary()
					_ = yym1366
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr1360 || yy2arr1360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1360[2] {
					yym1368 := z.EncBinary()
					_ = yym1368
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1360[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1369 := z.EncBinary()
					_ = yym1369
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr1360 || yy2arr1360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1360[3] {
					yym1371 := z.EncBinary()
					_ = yym1371
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1360[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1372 := z.EncBinary()
					_ = yym1372
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr1360 || yy2arr1360 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1373 := z.DecBinary()
	_ = yym1373
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1374 := r.ContainerType()
		if yyct1374 == codecSelferValueTypeMap1234 {
			yyl1374 := r.ReadMapStart()
			if yyl1374 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1374, d)
			}
		} else if yyct1374 == codecSelferValueTypeArray1234 {
			yyl1374 := r.ReadArrayStart()
			if yyl1374 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1374, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1375Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1375Slc
	var yyhl1375 bool = l >= 0
	for yyj1375 := 0; ; yyj1375++ {
		if yyhl1375 {
			if yyj1375 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1375Slc = r.DecodeBytes(yys1375Slc, true, true)
		yys1375 := string(yys1375Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1375 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				x.FullyLabeledReplicas = int32(r.DecodeInt(32))
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				x.ReadyReplicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1375)
		} // end switch yys1375
	} // end for yyj1375
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1380 int
	var yyb1380 bool
	var yyhl1380 bool = l >= 0
	yyj1380++
	if yyhl1380 {
		yyb1380 = yyj1380 > l
	} else {
		yyb1380 = r.CheckBreak()
	}
	if yyb1380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj1380++
	if yyhl1380 {
		yyb1380 = yyj1380 > l
	} else {
		yyb1380 = r.CheckBreak()
	}
	if yyb1380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		x.FullyLabeledReplicas = int32(r.DecodeInt(32))
	}
	yyj1380++
	if yyhl1380 {
		yyb1380 = yyj1380 > l
	} else {
		yyb1380 = r.CheckBreak()
	}
	if yyb1380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		x.ReadyReplicas = int32(r.DecodeInt(32))
	}
	yyj1380++
	if yyhl1380 {
		yyb1380 = yyj1380 > l
	} else {
		yyb1380 = r.CheckBreak()
	}
	if yyb1380 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	for {
		yyj1380++
		if yyhl1380 {
			yyb1380 = yyj1380 > l
		} else {
			yyb1380 = r.CheckBreak()
		}
		if yyb1380 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1380-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1385 := z.EncBinary()
		_ = yym1385
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1386 := !z.EncBinary()
			yy2arr1386 := z.EncBasicHandle().StructToArray
			var yyq1386 [4]bool
			_, _, _ = yysep1386, yyq1386, yy2arr1386
			const yyr1386 bool = false
			yyq1386[0] = x.Kind != ""
			yyq1386[1] = x.APIVersion != ""
			yyq1386[2] = true
			yyq1386[3] = true
			var yynn1386 int
			if yyr1386 || yy2arr1386 {
				r.EncodeArrayStart(4)
			} else {
				yynn1386 = 0
				for _, b := range yyq1386 {
					if b {
						yynn1386++
					}
				}
				r.EncodeMapStart(yynn1386)
				yynn1386 = 0
			}
			if yyr1386 || yy2arr1386 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1386[0] {
					yym1388 := z.EncBinary()
					_ = yym1388
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1386[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1389 := z.EncBinary()
					_ = yym1389
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1386 || yy2arr1386 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1386[1] {
					yym1391 := z.EncBinary()
					_ = yym1391
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1386[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1392 := z.EncBinary()
					_ = yym1392
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1386 || yy2arr1386 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1386[2] {
					yy1394 := &x.ObjectMeta
					yy1394.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1386[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1395 := &x.ObjectMeta
					yy1395.CodecEncodeSelf(e)
				}
			}
			if yyr1386 || yy2arr1386 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1386[3] {
					yy1397 := &x.Spec
					yy1397.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1386[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1398 := &x.Spec
					yy1398.CodecEncodeSelf(e)
				}
			}
			if yyr1386 || yy2arr1386 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1399 := z.DecBinary()
	_ = yym1399
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1400 := r.ContainerType()
		if yyct1400 == codecSelferValueTypeMap1234 {
			yyl1400 := r.ReadMapStart()
			if yyl1400 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1400, d)
			}
		} else if yyct1400 == codecSelferValueTypeArray1234 {
			yyl1400 := r.ReadArrayStart()
			if yyl1400 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1400, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1401Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1401Slc
	var yyhl1401 bool = l >= 0
	for yyj1401 := 0; ; yyj1401++ {
		if yyhl1401 {
			if yyj1401 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1401Slc = r.DecodeBytes(yys1401Slc, true, true)
		yys1401 := string(yys1401Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1401 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1404 := &x.ObjectMeta
				yyv1404.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSecurityPolicySpec{}
			} else {
				yyv1405 := &x.Spec
				yyv1405.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1401)
		} // end switch yys1401
	} // end for yyj1401
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1406 int
	var yyb1406 bool
	var yyhl1406 bool = l >= 0
	yyj1406++
	if yyhl1406 {
		yyb1406 = yyj1406 > l
	} else {
		yyb1406 = r.CheckBreak()
	}
	if yyb1406 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1406++
	if yyhl1406 {
		yyb1406 = yyj1406 > l
	} else {
		yyb1406 = r.CheckBreak()
	}
	if yyb1406 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1406++
	if yyhl1406 {
		yyb1406 = yyj1406 > l
	} else {
		yyb1406 = r.CheckBreak()
	}
	if yyb1406 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1409 := &x.ObjectMeta
		yyv1409.CodecDecodeSelf(d)
	}
	yyj1406++
	if yyhl1406 {
		yyb1406 = yyj1406 > l
	} else {
		yyb1406 = r.CheckBreak()
	}
	if yyb1406 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSecurityPolicySpec{}
	} else {
		yyv1410 := &x.Spec
		yyv1410.CodecDecodeSelf(d)
	}
	for {
		yyj1406++
		if yyhl1406 {
			yyb1406 = yyj1406 > l
		} else {
			yyb1406 = r.CheckBreak()
		}
		if yyb1406 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1406-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityPolicySpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1411 := z.EncBinary()
		_ = yym1411
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1412 := !z.EncBinary()
			yy2arr1412 := z.EncBasicHandle().StructToArray
			var yyq1412 [14]bool
			_, _, _ = yysep1412, yyq1412, yy2arr1412
			const yyr1412 bool = false
			yyq1412[0] = x.Privileged != false
			yyq1412[1] = len(x.DefaultAddCapabilities) != 0
			yyq1412[2] = len(x.RequiredDropCapabilities) != 0
			yyq1412[3] = len(x.AllowedCapabilities) != 0
			yyq1412[4] = len(x.Volumes) != 0
			yyq1412[5] = x.HostNetwork != false
			yyq1412[6] = len(x.HostPorts) != 0
			yyq1412[7] = x.HostPID != false
			yyq1412[8] = x.HostIPC != false
			yyq1412[13] = x.ReadOnlyRootFilesystem != false
			var yynn1412 int
			if yyr1412 || yy2arr1412 {
				r.EncodeArrayStart(14)
			} else {
				yynn1412 = 4
				for _, b := range yyq1412 {
					if b {
						yynn1412++
					}
				}
				r.EncodeMapStart(yynn1412)
				yynn1412 = 0
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[0] {
					yym1414 := z.EncBinary()
					_ = yym1414
					if false {
					} else {
						r.EncodeBool(bool(x.Privileged))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1412[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("privileged"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1415 := z.EncBinary()
					_ = yym1415
					if false {
					} else {
						r.EncodeBool(bool(x.Privileged))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[1] {
					if x.DefaultAddCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1417 := z.EncBinary()
						_ = yym1417
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.DefaultAddCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultAddCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultAddCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1418 := z.EncBinary()
						_ = yym1418
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.DefaultAddCapabilities), e)
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[2] {
					if x.RequiredDropCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1420 := z.EncBinary()
						_ = yym1420
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.RequiredDropCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDropCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDropCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1421 := z.EncBinary()
						_ = yym1421
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.RequiredDropCapabilities), e)
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[3] {
					if x.AllowedCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1423 := z.EncBinary()
						_ = yym1423
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.AllowedCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allowedCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1424 := z.EncBinary()
						_ = yym1424
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.AllowedCapabilities), e)
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[4] {
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1426 := z.EncBinary()
						_ = yym1426
						if false {
						} else {
							h.encSliceFSType(([]FSType)(x.Volumes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1427 := z.EncBinary()
						_ = yym1427
						if false {
						} else {
							h.encSliceFSType(([]FSType)(x.Volumes), e)
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[5] {
					yym1429 := z.EncBinary()
					_ = yym1429
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1412[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1430 := z.EncBinary()
					_ = yym1430
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[6] {
					if x.HostPorts == nil {
						r.EncodeNil()
					} else {
						yym1432 := z.EncBinary()
						_ = yym1432
						if false {
						} else {
							h.encSliceHostPortRange(([]HostPortRange)(x.HostPorts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1412[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPorts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPorts == nil {
						r.EncodeNil()
					} else {
						yym1433 := z.EncBinary()
						_ = yym1433
						if false {
						} else {
							h.encSliceHostPortRange(([]HostPortRange)(x.HostPorts), e)
						}
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[7] {
					yym1435 := z.EncBinary()
					_ = yym1435
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1412[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1436 := z.EncBinary()
					_ = yym1436
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[8] {
					yym1438 := z.EncBinary()
					_ = yym1438
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1412[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1439 := z.EncBinary()
					_ = yym1439
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1441 := &x.SELinux
				yy1441.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seLinux"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1442 := &x.SELinux
				yy1442.CodecEncodeSelf(e)
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1444 := &x.RunAsUser
				yy1444.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1445 := &x.RunAsUser
				yy1445.CodecEncodeSelf(e)
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1447 := &x.SupplementalGroups
				yy1447.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1448 := &x.SupplementalGroups
				yy1448.CodecEncodeSelf(e)
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1450 := &x.FSGroup
				yy1450.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1451 := &x.FSGroup
				yy1451.CodecEncodeSelf(e)
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1412[13] {
					yym1453 := z.EncBinary()
					_ = yym1453
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnlyRootFilesystem))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1412[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnlyRootFilesystem"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1454 := z.EncBinary()
					_ = yym1454
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnlyRootFilesystem))
					}
				}
			}
			if yyr1412 || yy2arr1412 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicySpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1455 := z.DecBinary()
	_ = yym1455
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1456 := r.ContainerType()
		if yyct1456 == codecSelferValueTypeMap1234 {
			yyl1456 := r.ReadMapStart()
			if yyl1456 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1456, d)
			}
		} else if yyct1456 == codecSelferValueTypeArray1234 {
			yyl1456 := r.ReadArrayStart()
			if yyl1456 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1456, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicySpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1457Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1457Slc
	var yyhl1457 bool = l >= 0
	for yyj1457 := 0; ; yyj1457++ {
		if yyhl1457 {
			if yyj1457 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1457Slc = r.DecodeBytes(yys1457Slc, true, true)
		yys1457 := string(yys1457Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1457 {
		case "privileged":
			if r.TryDecodeAsNil() {
				x.Privileged = false
			} else {
				x.Privileged = bool(r.DecodeBool())
			}
		case "defaultAddCapabilities":
			if r.TryDecodeAsNil() {
				x.DefaultAddCapabilities = nil
			} else {
				yyv1459 := &x.DefaultAddCapabilities
				yym1460 := z.DecBinary()
				_ = yym1460
				if false {
				} else {
					h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1459), d)
				}
			}
		case "requiredDropCapabilities":
			if r.TryDecodeAsNil() {
				x.RequiredDropCapabilities = nil
			} else {
				yyv1461 := &x.RequiredDropCapabilities
				yym1462 := z.DecBinary()
				_ = yym1462
				if false {
				} else {
					h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1461), d)
				}
			}
		case "allowedCapabilities":
			if r.TryDecodeAsNil() {
				x.AllowedCapabilities = nil
			} else {
				yyv1463 := &x.AllowedCapabilities
				yym1464 := z.DecBinary()
				_ = yym1464
				if false {
				} else {
					h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1463), d)
				}
			}
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv1465 := &x.Volumes
				yym1466 := z.DecBinary()
				_ = yym1466
				if false {
				} else {
					h.decSliceFSType((*[]FSType)(yyv1465), d)
				}
			}
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPorts":
			if r.TryDecodeAsNil() {
				x.HostPorts = nil
			} else {
				yyv1468 := &x.HostPorts
				yym1469 := z.DecBinary()
				_ = yym1469
				if false {
				} else {
					h.decSliceHostPortRange((*[]HostPortRange)(yyv1468), d)
				}
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "seLinux":
			if r.TryDecodeAsNil() {
				x.SELinux = SELinuxStrategyOptions{}
			} else {
				yyv1472 := &x.SELinux
				yyv1472.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				x.RunAsUser = RunAsUserStrategyOptions{}
			} else {
				yyv1473 := &x.RunAsUser
				yyv1473.CodecDecodeSelf(d)
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = SupplementalGroupsStrategyOptions{}
			} else {
				yyv1474 := &x.SupplementalGroups
				yyv1474.CodecDecodeSelf(d)
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				x.FSGroup = FSGroupStrategyOptions{}
			} else {
				yyv1475 := &x.FSGroup
				yyv1475.CodecDecodeSelf(d)
			}
		case "readOnlyRootFilesystem":
			if r.TryDecodeAsNil() {
				x.ReadOnlyRootFilesystem = false
			} else {
				x.ReadOnlyRootFilesystem = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1457)
		} // end switch yys1457
	} // end for yyj1457
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicySpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1477 int
	var yyb1477 bool
	var yyhl1477 bool = l >= 0
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Privileged = false
	} else {
		x.Privileged = bool(r.DecodeBool())
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DefaultAddCapabilities = nil
	} else {
		yyv1479 := &x.DefaultAddCapabilities
		yym1480 := z.DecBinary()
		_ = yym1480
		if false {
		} else {
			h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1479), d)
		}
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDropCapabilities = nil
	} else {
		yyv1481 := &x.RequiredDropCapabilities
		yym1482 := z.DecBinary()
		_ = yym1482
		if false {
		} else {
			h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1481), d)
		}
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedCapabilities = nil
	} else {
		yyv1483 := &x.AllowedCapabilities
		yym1484 := z.DecBinary()
		_ = yym1484
		if false {
		} else {
			h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1483), d)
		}
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv1485 := &x.Volumes
		yym1486 := z.DecBinary()
		_ = yym1486
		if false {
		} else {
			h.decSliceFSType((*[]FSType)(yyv1485), d)
		}
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPorts = nil
	} else {
		yyv1488 := &x.HostPorts
		yym1489 := z.DecBinary()
		_ = yym1489
		if false {
		} else {
			h.decSliceHostPortRange((*[]HostPortRange)(yyv1488), d)
		}
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SELinux = SELinuxStrategyOptions{}
	} else {
		yyv1492 := &x.SELinux
		yyv1492.CodecDecodeSelf(d)
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RunAsUser = RunAsUserStrategyOptions{}
	} else {
		yyv1493 := &x.RunAsUser
		yyv1493.CodecDecodeSelf(d)
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = SupplementalGroupsStrategyOptions{}
	} else {
		yyv1494 := &x.SupplementalGroups
		yyv1494.CodecDecodeSelf(d)
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSGroup = FSGroupStrategyOptions{}
	} else {
		yyv1495 := &x.FSGroup
		yyv1495.CodecDecodeSelf(d)
	}
	yyj1477++
	if yyhl1477 {
		yyb1477 = yyj1477 > l
	} else {
		yyb1477 = r.CheckBreak()
	}
	if yyb1477 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyRootFilesystem = false
	} else {
		x.ReadOnlyRootFilesystem = bool(r.DecodeBool())
	}
	for {
		yyj1477++
		if yyhl1477 {
			yyb1477 = yyj1477 > l
		} else {
			yyb1477 = r.CheckBreak()
		}
		if yyb1477 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1477-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FSType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1497 := z.EncBinary()
	_ = yym1497
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FSType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1498 := z.DecBinary()
	_ = yym1498
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPortRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1499 := z.EncBinary()
		_ = yym1499
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1500 := !z.EncBinary()
			yy2arr1500 := z.EncBasicHandle().StructToArray
			var yyq1500 [2]bool
			_, _, _ = yysep1500, yyq1500, yy2arr1500
			const yyr1500 bool = false
			var yynn1500 int
			if yyr1500 || yy2arr1500 {
				r.EncodeArrayStart(2)
			} else {
				yynn1500 = 2
				for _, b := range yyq1500 {
					if b {
						yynn1500++
					}
				}
				r.EncodeMapStart(yynn1500)
				yynn1500 = 0
			}
			if yyr1500 || yy2arr1500 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1502 := z.EncBinary()
				_ = yym1502
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("min"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1503 := z.EncBinary()
				_ = yym1503
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			}
			if yyr1500 || yy2arr1500 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1505 := z.EncBinary()
				_ = yym1505
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("max"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1506 := z.EncBinary()
				_ = yym1506
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			}
			if yyr1500 || yy2arr1500 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPortRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1507 := z.DecBinary()
	_ = yym1507
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1508 := r.ContainerType()
		if yyct1508 == codecSelferValueTypeMap1234 {
			yyl1508 := r.ReadMapStart()
			if yyl1508 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1508, d)
			}
		} else if yyct1508 == codecSelferValueTypeArray1234 {
			yyl1508 := r.ReadArrayStart()
			if yyl1508 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1508, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPortRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1509Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1509Slc
	var yyhl1509 bool = l >= 0
	for yyj1509 := 0; ; yyj1509++ {
		if yyhl1509 {
			if yyj1509 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1509Slc = r.DecodeBytes(yys1509Slc, true, true)
		yys1509 := string(yys1509Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1509 {
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = 0
			} else {
				x.Min = int32(r.DecodeInt(32))
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = 0
			} else {
				x.Max = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1509)
		} // end switch yys1509
	} // end for yyj1509
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPortRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1512 int
	var yyb1512 bool
	var yyhl1512 bool = l >= 0
	yyj1512++
	if yyhl1512 {
		yyb1512 = yyj1512 > l
	} else {
		yyb1512 = r.CheckBreak()
	}
	if yyb1512 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = 0
	} else {
		x.Min = int32(r.DecodeInt(32))
	}
	yyj1512++
	if yyhl1512 {
		yyb1512 = yyj1512 > l
	} else {
		yyb1512 = r.CheckBreak()
	}
	if yyb1512 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = 0
	} else {
		x.Max = int32(r.DecodeInt(32))
	}
	for {
		yyj1512++
		if yyhl1512 {
			yyb1512 = yyj1512 > l
		} else {
			yyb1512 = r.CheckBreak()
		}
		if yyb1512 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1512-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SELinuxStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1515 := z.EncBinary()
		_ = yym1515
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1516 := !z.EncBinary()
			yy2arr1516 := z.EncBasicHandle().StructToArray
			var yyq1516 [2]bool
			_, _, _ = yysep1516, yyq1516, yy2arr1516
			const yyr1516 bool = false
			yyq1516[1] = x.SELinuxOptions != nil
			var yynn1516 int
			if yyr1516 || yy2arr1516 {
				r.EncodeArrayStart(2)
			} else {
				yynn1516 = 1
				for _, b := range yyq1516 {
					if b {
						yynn1516++
					}
				}
				r.EncodeMapStart(yynn1516)
				yynn1516 = 0
			}
			if yyr1516 || yy2arr1516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Rule.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Rule.CodecEncodeSelf(e)
			}
			if yyr1516 || yy2arr1516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1516[1] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1516[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1516 || yy2arr1516 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SELinuxStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1519 := z.DecBinary()
	_ = yym1519
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1520 := r.ContainerType()
		if yyct1520 == codecSelferValueTypeMap1234 {
			yyl1520 := r.ReadMapStart()
			if yyl1520 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1520, d)
			}
		} else if yyct1520 == codecSelferValueTypeArray1234 {
			yyl1520 := r.ReadArrayStart()
			if yyl1520 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1520, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SELinuxStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1521Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1521Slc
	var yyhl1521 bool = l >= 0
	for yyj1521 := 0; ; yyj1521++ {
		if yyhl1521 {
			if yyj1521 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1521Slc = r.DecodeBytes(yys1521Slc, true, true)
		yys1521 := string(yys1521Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1521 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = SELinuxStrategy(r.DecodeString())
			}
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(pkg2_v1.SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1521)
		} // end switch yys1521
	} // end for yyj1521
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SELinuxStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1524 int
	var yyb1524 bool
	var yyhl1524 bool = l >= 0
	yyj1524++
	if yyhl1524 {
		yyb1524 = yyj1524 > l
	} else {
		yyb1524 = r.CheckBreak()
	}
	if yyb1524 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = SELinuxStrategy(r.DecodeString())
	}
	yyj1524++
	if yyhl1524 {
		yyb1524 = yyj1524 > l
	} else {
		yyb1524 = r.CheckBreak()
	}
	if yyb1524 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(pkg2_v1.SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	for {
		yyj1524++
		if yyhl1524 {
			yyb1524 = yyj1524 > l
		} else {
			yyb1524 = r.CheckBreak()
		}
		if yyb1524 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1524-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x SELinuxStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1527 := z.EncBinary()
	_ = yym1527
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *SELinuxStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1528 := z.DecBinary()
	_ = yym1528
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RunAsUserStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1529 := z.EncBinary()
		_ = yym1529
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1530 := !z.EncBinary()
			yy2arr1530 := z.EncBasicHandle().StructToArray
			var yyq1530 [2]bool
			_, _, _ = yysep1530, yyq1530, yy2arr1530
			const yyr1530 bool = false
			yyq1530[1] = len(x.Ranges) != 0
			var yynn1530 int
			if yyr1530 || yy2arr1530 {
				r.EncodeArrayStart(2)
			} else {
				yynn1530 = 1
				for _, b := range yyq1530 {
					if b {
						yynn1530++
					}
				}
				r.EncodeMapStart(yynn1530)
				yynn1530 = 0
			}
			if yyr1530 || yy2arr1530 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Rule.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Rule.CodecEncodeSelf(e)
			}
			if yyr1530 || yy2arr1530 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1530[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1533 := z.EncBinary()
						_ = yym1533
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1530[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1534 := z.EncBinary()
						_ = yym1534
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1530 || yy2arr1530 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RunAsUserStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1535 := z.DecBinary()
	_ = yym1535
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1536 := r.ContainerType()
		if yyct1536 == codecSelferValueTypeMap1234 {
			yyl1536 := r.ReadMapStart()
			if yyl1536 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1536, d)
			}
		} else if yyct1536 == codecSelferValueTypeArray1234 {
			yyl1536 := r.ReadArrayStart()
			if yyl1536 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1536, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RunAsUserStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1537Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1537Slc
	var yyhl1537 bool = l >= 0
	for yyj1537 := 0; ; yyj1537++ {
		if yyhl1537 {
			if yyj1537 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1537Slc = r.DecodeBytes(yys1537Slc, true, true)
		yys1537 := string(yys1537Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1537 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = RunAsUserStrategy(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1539 := &x.Ranges
				yym1540 := z.DecBinary()
				_ = yym1540
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1539), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1537)
		} // end switch yys1537
	} // end for yyj1537
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RunAsUserStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1541 int
	var yyb1541 bool
	var yyhl1541 bool = l >= 0
	yyj1541++
	if yyhl1541 {
		yyb1541 = yyj1541 > l
	} else {
		yyb1541 = r.CheckBreak()
	}
	if yyb1541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = RunAsUserStrategy(r.DecodeString())
	}
	yyj1541++
	if yyhl1541 {
		yyb1541 = yyj1541 > l
	} else {
		yyb1541 = r.CheckBreak()
	}
	if yyb1541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1543 := &x.Ranges
		yym1544 := z.DecBinary()
		_ = yym1544
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1543), d)
		}
	}
	for {
		yyj1541++
		if yyhl1541 {
			yyb1541 = yyj1541 > l
		} else {
			yyb1541 = r.CheckBreak()
		}
		if yyb1541 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1541-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IDRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1545 := z.EncBinary()
		_ = yym1545
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1546 := !z.EncBinary()
			yy2arr1546 := z.EncBasicHandle().StructToArray
			var yyq1546 [2]bool
			_, _, _ = yysep1546, yyq1546, yy2arr1546
			const yyr1546 bool = false
			var yynn1546 int
			if yyr1546 || yy2arr1546 {
				r.EncodeArrayStart(2)
			} else {
				yynn1546 = 2
				for _, b := range yyq1546 {
					if b {
						yynn1546++
					}
				}
				r.EncodeMapStart(yynn1546)
				yynn1546 = 0
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1548 := z.EncBinary()
				_ = yym1548
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("min"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1549 := z.EncBinary()
				_ = yym1549
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1551 := z.EncBinary()
				_ = yym1551
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("max"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1552 := z.EncBinary()
				_ = yym1552
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			}
			if yyr1546 || yy2arr1546 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IDRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1553 := z.DecBinary()
	_ = yym1553
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1554 := r.ContainerType()
		if yyct1554 == codecSelferValueTypeMap1234 {
			yyl1554 := r.ReadMapStart()
			if yyl1554 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1554, d)
			}
		} else if yyct1554 == codecSelferValueTypeArray1234 {
			yyl1554 := r.ReadArrayStart()
			if yyl1554 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1554, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IDRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1555Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1555Slc
	var yyhl1555 bool = l >= 0
	for yyj1555 := 0; ; yyj1555++ {
		if yyhl1555 {
			if yyj1555 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1555Slc = r.DecodeBytes(yys1555Slc, true, true)
		yys1555 := string(yys1555Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1555 {
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = 0
			} else {
				x.Min = int64(r.DecodeInt(64))
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = 0
			} else {
				x.Max = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1555)
		} // end switch yys1555
	} // end for yyj1555
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IDRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1558 int
	var yyb1558 bool
	var yyhl1558 bool = l >= 0
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = 0
	} else {
		x.Min = int64(r.DecodeInt(64))
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = 0
	} else {
		x.Max = int64(r.DecodeInt(64))
	}
	for {
		yyj1558++
		if yyhl1558 {
			yyb1558 = yyj1558 > l
		} else {
			yyb1558 = r.CheckBreak()
		}
		if yyb1558 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1558-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RunAsUserStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1561 := z.EncBinary()
	_ = yym1561
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RunAsUserStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1562 := z.DecBinary()
	_ = yym1562
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *FSGroupStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1563 := z.EncBinary()
		_ = yym1563
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1564 := !z.EncBinary()
			yy2arr1564 := z.EncBasicHandle().StructToArray
			var yyq1564 [2]bool
			_, _, _ = yysep1564, yyq1564, yy2arr1564
			const yyr1564 bool = false
			yyq1564[0] = x.Rule != ""
			yyq1564[1] = len(x.Ranges) != 0
			var yynn1564 int
			if yyr1564 || yy2arr1564 {
				r.EncodeArrayStart(2)
			} else {
				yynn1564 = 0
				for _, b := range yyq1564 {
					if b {
						yynn1564++
					}
				}
				r.EncodeMapStart(yynn1564)
				yynn1564 = 0
			}
			if yyr1564 || yy2arr1564 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1564[0] {
					x.Rule.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1564[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rule"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Rule.CodecEncodeSelf(e)
				}
			}
			if yyr1564 || yy2arr1564 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1564[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1567 := z.EncBinary()
						_ = yym1567
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1564[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1568 := z.EncBinary()
						_ = yym1568
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1564 || yy2arr1564 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FSGroupStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1569 := z.DecBinary()
	_ = yym1569
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1570 := r.ContainerType()
		if yyct1570 == codecSelferValueTypeMap1234 {
			yyl1570 := r.ReadMapStart()
			if yyl1570 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1570, d)
			}
		} else if yyct1570 == codecSelferValueTypeArray1234 {
			yyl1570 := r.ReadArrayStart()
			if yyl1570 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1570, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FSGroupStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1571Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1571Slc
	var yyhl1571 bool = l >= 0
	for yyj1571 := 0; ; yyj1571++ {
		if yyhl1571 {
			if yyj1571 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1571Slc = r.DecodeBytes(yys1571Slc, true, true)
		yys1571 := string(yys1571Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1571 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = FSGroupStrategyType(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1573 := &x.Ranges
				yym1574 := z.DecBinary()
				_ = yym1574
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1573), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1571)
		} // end switch yys1571
	} // end for yyj1571
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FSGroupStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1575 int
	var yyb1575 bool
	var yyhl1575 bool = l >= 0
	yyj1575++
	if yyhl1575 {
		yyb1575 = yyj1575 > l
	} else {
		yyb1575 = r.CheckBreak()
	}
	if yyb1575 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = FSGroupStrategyType(r.DecodeString())
	}
	yyj1575++
	if yyhl1575 {
		yyb1575 = yyj1575 > l
	} else {
		yyb1575 = r.CheckBreak()
	}
	if yyb1575 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1577 := &x.Ranges
		yym1578 := z.DecBinary()
		_ = yym1578
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1577), d)
		}
	}
	for {
		yyj1575++
		if yyhl1575 {
			yyb1575 = yyj1575 > l
		} else {
			yyb1575 = r.CheckBreak()
		}
		if yyb1575 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1575-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FSGroupStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1579 := z.EncBinary()
	_ = yym1579
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FSGroupStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1580 := z.DecBinary()
	_ = yym1580
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *SupplementalGroupsStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1581 := z.EncBinary()
		_ = yym1581
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1582 := !z.EncBinary()
			yy2arr1582 := z.EncBasicHandle().StructToArray
			var yyq1582 [2]bool
			_, _, _ = yysep1582, yyq1582, yy2arr1582
			const yyr1582 bool = false
			yyq1582[0] = x.Rule != ""
			yyq1582[1] = len(x.Ranges) != 0
			var yynn1582 int
			if yyr1582 || yy2arr1582 {
				r.EncodeArrayStart(2)
			} else {
				yynn1582 = 0
				for _, b := range yyq1582 {
					if b {
						yynn1582++
					}
				}
				r.EncodeMapStart(yynn1582)
				yynn1582 = 0
			}
			if yyr1582 || yy2arr1582 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1582[0] {
					x.Rule.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1582[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rule"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Rule.CodecEncodeSelf(e)
				}
			}
			if yyr1582 || yy2arr1582 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1582[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1585 := z.EncBinary()
						_ = yym1585
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1582[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1586 := z.EncBinary()
						_ = yym1586
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1582 || yy2arr1582 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SupplementalGroupsStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1587 := z.DecBinary()
	_ = yym1587
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1588 := r.ContainerType()
		if yyct1588 == codecSelferValueTypeMap1234 {
			yyl1588 := r.ReadMapStart()
			if yyl1588 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1588, d)
			}
		} else if yyct1588 == codecSelferValueTypeArray1234 {
			yyl1588 := r.ReadArrayStart()
			if yyl1588 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1588, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SupplementalGroupsStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1589Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1589Slc
	var yyhl1589 bool = l >= 0
	for yyj1589 := 0; ; yyj1589++ {
		if yyhl1589 {
			if yyj1589 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1589Slc = r.DecodeBytes(yys1589Slc, true, true)
		yys1589 := string(yys1589Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1589 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = SupplementalGroupsStrategyType(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1591 := &x.Ranges
				yym1592 := z.DecBinary()
				_ = yym1592
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1591), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1589)
		} // end switch yys1589
	} // end for yyj1589
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SupplementalGroupsStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1593 int
	var yyb1593 bool
	var yyhl1593 bool = l >= 0
	yyj1593++
	if yyhl1593 {
		yyb1593 = yyj1593 > l
	} else {
		yyb1593 = r.CheckBreak()
	}
	if yyb1593 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = SupplementalGroupsStrategyType(r.DecodeString())
	}
	yyj1593++
	if yyhl1593 {
		yyb1593 = yyj1593 > l
	} else {
		yyb1593 = r.CheckBreak()
	}
	if yyb1593 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1595 := &x.Ranges
		yym1596 := z.DecBinary()
		_ = yym1596
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1595), d)
		}
	}
	for {
		yyj1593++
		if yyhl1593 {
			yyb1593 = yyj1593 > l
		} else {
			yyb1593 = r.CheckBreak()
		}
		if yyb1593 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1593-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x SupplementalGroupsStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1597 := z.EncBinary()
	_ = yym1597
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *SupplementalGroupsStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1598 := z.DecBinary()
	_ = yym1598
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSecurityPolicyList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1599 := z.EncBinary()
		_ = yym1599
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1600 := !z.EncBinary()
			yy2arr1600 := z.EncBasicHandle().StructToArray
			var yyq1600 [4]bool
			_, _, _ = yysep1600, yyq1600, yy2arr1600
			const yyr1600 bool = false
			yyq1600[0] = x.Kind != ""
			yyq1600[1] = x.APIVersion != ""
			yyq1600[2] = true
			var yynn1600 int
			if yyr1600 || yy2arr1600 {
				r.EncodeArrayStart(4)
			} else {
				yynn1600 = 1
				for _, b := range yyq1600 {
					if b {
						yynn1600++
					}
				}
				r.EncodeMapStart(yynn1600)
				yynn1600 = 0
			}
			if yyr1600 || yy2arr1600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1600[0] {
					yym1602 := z.EncBinary()
					_ = yym1602
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1600[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1603 := z.EncBinary()
					_ = yym1603
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1600 || yy2arr1600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1600[1] {
					yym1605 := z.EncBinary()
					_ = yym1605
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1600[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1606 := z.EncBinary()
					_ = yym1606
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1600 || yy2arr1600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1600[2] {
					yy1608 := &x.ListMeta
					yym1609 := z.EncBinary()
					_ = yym1609
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1608) {
					} else {
						z.EncFallback(yy1608)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1600[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1610 := &x.ListMeta
					yym1611 := z.EncBinary()
					_ = yym1611
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1610) {
					} else {
						z.EncFallback(yy1610)
					}
				}
			}
			if yyr1600 || yy2arr1600 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1613 := z.EncBinary()
					_ = yym1613
					if false {
					} else {
						h.encSlicePodSecurityPolicy(([]PodSecurityPolicy)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1614 := z.EncBinary()
					_ = yym1614
					if false {
					} else {
						h.encSlicePodSecurityPolicy(([]PodSecurityPolicy)(x.Items), e)
					}
				}
			}
			if yyr1600 || yy2arr1600 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicyList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1615 := z.DecBinary()
	_ = yym1615
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1616 := r.ContainerType()
		if yyct1616 == codecSelferValueTypeMap1234 {
			yyl1616 := r.ReadMapStart()
			if yyl1616 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1616, d)
			}
		} else if yyct1616 == codecSelferValueTypeArray1234 {
			yyl1616 := r.ReadArrayStart()
			if yyl1616 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1616, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicyList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1617Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1617Slc
	var yyhl1617 bool = l >= 0
	for yyj1617 := 0; ; yyj1617++ {
		if yyhl1617 {
			if yyj1617 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1617Slc = r.DecodeBytes(yys1617Slc, true, true)
		yys1617 := string(yys1617Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1617 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1620 := &x.ListMeta
				yym1621 := z.DecBinary()
				_ = yym1621
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1620) {
				} else {
					z.DecFallback(yyv1620, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1622 := &x.Items
				yym1623 := z.DecBinary()
				_ = yym1623
				if false {
				} else {
					h.decSlicePodSecurityPolicy((*[]PodSecurityPolicy)(yyv1622), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1617)
		} // end switch yys1617
	} // end for yyj1617
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicyList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1624 int
	var yyb1624 bool
	var yyhl1624 bool = l >= 0
	yyj1624++
	if yyhl1624 {
		yyb1624 = yyj1624 > l
	} else {
		yyb1624 = r.CheckBreak()
	}
	if yyb1624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1624++
	if yyhl1624 {
		yyb1624 = yyj1624 > l
	} else {
		yyb1624 = r.CheckBreak()
	}
	if yyb1624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1624++
	if yyhl1624 {
		yyb1624 = yyj1624 > l
	} else {
		yyb1624 = r.CheckBreak()
	}
	if yyb1624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1627 := &x.ListMeta
		yym1628 := z.DecBinary()
		_ = yym1628
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1627) {
		} else {
			z.DecFallback(yyv1627, false)
		}
	}
	yyj1624++
	if yyhl1624 {
		yyb1624 = yyj1624 > l
	} else {
		yyb1624 = r.CheckBreak()
	}
	if yyb1624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1629 := &x.Items
		yym1630 := z.DecBinary()
		_ = yym1630
		if false {
		} else {
			h.decSlicePodSecurityPolicy((*[]PodSecurityPolicy)(yyv1629), d)
		}
	}
	for {
		yyj1624++
		if yyhl1624 {
			yyb1624 = yyj1624 > l
		} else {
			yyb1624 = r.CheckBreak()
		}
		if yyb1624 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1624-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1631 := z.EncBinary()
		_ = yym1631
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1632 := !z.EncBinary()
			yy2arr1632 := z.EncBasicHandle().StructToArray
			var yyq1632 [4]bool
			_, _, _ = yysep1632, yyq1632, yy2arr1632
			const yyr1632 bool = false
			yyq1632[0] = x.Kind != ""
			yyq1632[1] = x.APIVersion != ""
			yyq1632[2] = true
			yyq1632[3] = true
			var yynn1632 int
			if yyr1632 || yy2arr1632 {
				r.EncodeArrayStart(4)
			} else {
				yynn1632 = 0
				for _, b := range yyq1632 {
					if b {
						yynn1632++
					}
				}
				r.EncodeMapStart(yynn1632)
				yynn1632 = 0
			}
			if yyr1632 || yy2arr1632 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1632[0] {
					yym1634 := z.EncBinary()
					_ = yym1634
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1632[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1635 := z.EncBinary()
					_ = yym1635
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1632 || yy2arr1632 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1632[1] {
					yym1637 := z.EncBinary()
					_ = yym1637
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1632[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1638 := z.EncBinary()
					_ = yym1638
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1632 || yy2arr1632 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1632[2] {
					yy1640 := &x.ObjectMeta
					yy1640.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1632[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1641 := &x.ObjectMeta
					yy1641.CodecEncodeSelf(e)
				}
			}
			if yyr1632 || yy2arr1632 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1632[3] {
					yy1643 := &x.Spec
					yy1643.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1632[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1644 := &x.Spec
					yy1644.CodecEncodeSelf(e)
				}
			}
			if yyr1632 || yy2arr1632 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1645 := z.DecBinary()
	_ = yym1645
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1646 := r.ContainerType()
		if yyct1646 == codecSelferValueTypeMap1234 {
			yyl1646 := r.ReadMapStart()
			if yyl1646 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1646, d)
			}
		} else if yyct1646 == codecSelferValueTypeArray1234 {
			yyl1646 := r.ReadArrayStart()
			if yyl1646 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1646, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1647Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1647Slc
	var yyhl1647 bool = l >= 0
	for yyj1647 := 0; ; yyj1647++ {
		if yyhl1647 {
			if yyj1647 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1647Slc = r.DecodeBytes(yys1647Slc, true, true)
		yys1647 := string(yys1647Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1647 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1650 := &x.ObjectMeta
				yyv1650.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NetworkPolicySpec{}
			} else {
				yyv1651 := &x.Spec
				yyv1651.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1647)
		} // end switch yys1647
	} // end for yyj1647
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1652 int
	var yyb1652 bool
	var yyhl1652 bool = l >= 0
	yyj1652++
	if yyhl1652 {
		yyb1652 = yyj1652 > l
	} else {
		yyb1652 = r.CheckBreak()
	}
	if yyb1652 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1652++
	if yyhl1652 {
		yyb1652 = yyj1652 > l
	} else {
		yyb1652 = r.CheckBreak()
	}
	if yyb1652 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1652++
	if yyhl1652 {
		yyb1652 = yyj1652 > l
	} else {
		yyb1652 = r.CheckBreak()
	}
	if yyb1652 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1655 := &x.ObjectMeta
		yyv1655.CodecDecodeSelf(d)
	}
	yyj1652++
	if yyhl1652 {
		yyb1652 = yyj1652 > l
	} else {
		yyb1652 = r.CheckBreak()
	}
	if yyb1652 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = NetworkPolicySpec{}
	} else {
		yyv1656 := &x.Spec
		yyv1656.CodecDecodeSelf(d)
	}
	for {
		yyj1652++
		if yyhl1652 {
			yyb1652 = yyj1652 > l
		} else {
			yyb1652 = r.CheckBreak()
		}
		if yyb1652 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1652-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicySpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1657 := z.EncBinary()
		_ = yym1657
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1658 := !z.EncBinary()
			yy2arr1658 := z.EncBasicHandle().StructToArray
			var yyq1658 [2]bool
			_, _, _ = yysep1658, yyq1658, yy2arr1658
			const yyr1658 bool = false
			yyq1658[1] = len(x.Ingress) != 0
			var yynn1658 int
			if yyr1658 || yy2arr1658 {
				r.EncodeArrayStart(2)
			} else {
				yynn1658 = 1
				for _, b := range yyq1658 {
					if b {
						yynn1658++
					}
				}
				r.EncodeMapStart(yynn1658)
				yynn1658 = 0
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1660 := &x.PodSelector
				yy1660.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podSelector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1661 := &x.PodSelector
				yy1661.CodecEncodeSelf(e)
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1658[1] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1663 := z.EncBinary()
						_ = yym1663
						if false {
						} else {
							h.encSliceNetworkPolicyIngressRule(([]NetworkPolicyIngressRule)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1658[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1664 := z.EncBinary()
						_ = yym1664
						if false {
						} else {
							h.encSliceNetworkPolicyIngressRule(([]NetworkPolicyIngressRule)(x.Ingress), e)
						}
					}
				}
			}
			if yyr1658 || yy2arr1658 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicySpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1665 := z.DecBinary()
	_ = yym1665
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1666 := r.ContainerType()
		if yyct1666 == codecSelferValueTypeMap1234 {
			yyl1666 := r.ReadMapStart()
			if yyl1666 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1666, d)
			}
		} else if yyct1666 == codecSelferValueTypeArray1234 {
			yyl1666 := r.ReadArrayStart()
			if yyl1666 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1666, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicySpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1667Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1667Slc
	var yyhl1667 bool = l >= 0
	for yyj1667 := 0; ; yyj1667++ {
		if yyhl1667 {
			if yyj1667 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1667Slc = r.DecodeBytes(yys1667Slc, true, true)
		yys1667 := string(yys1667Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1667 {
		case "podSelector":
			if r.TryDecodeAsNil() {
				x.PodSelector = LabelSelector{}
			} else {
				yyv1668 := &x.PodSelector
				yyv1668.CodecDecodeSelf(d)
			}
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv1669 := &x.Ingress
				yym1670 := z.DecBinary()
				_ = yym1670
				if false {
				} else {
					h.decSliceNetworkPolicyIngressRule((*[]NetworkPolicyIngressRule)(yyv1669), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1667)
		} // end switch yys1667
	} // end for yyj1667
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicySpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1671 int
	var yyb1671 bool
	var yyhl1671 bool = l >= 0
	yyj1671++
	if yyhl1671 {
		yyb1671 = yyj1671 > l
	} else {
		yyb1671 = r.CheckBreak()
	}
	if yyb1671 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodSelector = LabelSelector{}
	} else {
		yyv1672 := &x.PodSelector
		yyv1672.CodecDecodeSelf(d)
	}
	yyj1671++
	if yyhl1671 {
		yyb1671 = yyj1671 > l
	} else {
		yyb1671 = r.CheckBreak()
	}
	if yyb1671 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv1673 := &x.Ingress
		yym1674 := z.DecBinary()
		_ = yym1674
		if false {
		} else {
			h.decSliceNetworkPolicyIngressRule((*[]NetworkPolicyIngressRule)(yyv1673), d)
		}
	}
	for {
		yyj1671++
		if yyhl1671 {
			yyb1671 = yyj1671 > l
		} else {
			yyb1671 = r.CheckBreak()
		}
		if yyb1671 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1671-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyIngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1675 := z.EncBinary()
		_ = yym1675
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1676 := !z.EncBinary()
			yy2arr1676 := z.EncBasicHandle().StructToArray
			var yyq1676 [2]bool
			_, _, _ = yysep1676, yyq1676, yy2arr1676
			const yyr1676 bool = false
			yyq1676[0] = len(x.Ports) != 0
			yyq1676[1] = len(x.From) != 0
			var yynn1676 int
			if yyr1676 || yy2arr1676 {
				r.EncodeArrayStart(2)
			} else {
				yynn1676 = 0
				for _, b := range yyq1676 {
					if b {
						yynn1676++
					}
				}
				r.EncodeMapStart(yynn1676)
				yynn1676 = 0
			}
			if yyr1676 || yy2arr1676 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1676[0] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1678 := z.EncBinary()
						_ = yym1678
						if false {
						} else {
							h.encSliceNetworkPolicyPort(([]NetworkPolicyPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1676[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1679 := z.EncBinary()
						_ = yym1679
						if false {
						} else {
							h.encSliceNetworkPolicyPort(([]NetworkPolicyPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1676 || yy2arr1676 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1676[1] {
					if x.From == nil {
						r.EncodeNil()
					} else {
						yym1681 := z.EncBinary()
						_ = yym1681
						if false {
						} else {
							h.encSliceNetworkPolicyPeer(([]NetworkPolicyPeer)(x.From), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1676[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("from"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.From == nil {
						r.EncodeNil()
					} else {
						yym1682 := z.EncBinary()
						_ = yym1682
						if false {
						} else {
							h.encSliceNetworkPolicyPeer(([]NetworkPolicyPeer)(x.From), e)
						}
					}
				}
			}
			if yyr1676 || yy2arr1676 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyIngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1683 := z.DecBinary()
	_ = yym1683
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1684 := r.ContainerType()
		if yyct1684 == codecSelferValueTypeMap1234 {
			yyl1684 := r.ReadMapStart()
			if yyl1684 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1684, d)
			}
		} else if yyct1684 == codecSelferValueTypeArray1234 {
			yyl1684 := r.ReadArrayStart()
			if yyl1684 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1684, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyIngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1685Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1685Slc
	var yyhl1685 bool = l >= 0
	for yyj1685 := 0; ; yyj1685++ {
		if yyhl1685 {
			if yyj1685 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1685Slc = r.DecodeBytes(yys1685Slc, true, true)
		yys1685 := string(yys1685Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1685 {
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1686 := &x.Ports
				yym1687 := z.DecBinary()
				_ = yym1687
				if false {
				} else {
					h.decSliceNetworkPolicyPort((*[]NetworkPolicyPort)(yyv1686), d)
				}
			}
		case "from":
			if r.TryDecodeAsNil() {
				x.From = nil
			} else {
				yyv1688 := &x.From
				yym1689 := z.DecBinary()
				_ = yym1689
				if false {
				} else {
					h.decSliceNetworkPolicyPeer((*[]NetworkPolicyPeer)(yyv1688), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1685)
		} // end switch yys1685
	} // end for yyj1685
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyIngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1690 int
	var yyb1690 bool
	var yyhl1690 bool = l >= 0
	yyj1690++
	if yyhl1690 {
		yyb1690 = yyj1690 > l
	} else {
		yyb1690 = r.CheckBreak()
	}
	if yyb1690 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1691 := &x.Ports
		yym1692 := z.DecBinary()
		_ = yym1692
		if false {
		} else {
			h.decSliceNetworkPolicyPort((*[]NetworkPolicyPort)(yyv1691), d)
		}
	}
	yyj1690++
	if yyhl1690 {
		yyb1690 = yyj1690 > l
	} else {
		yyb1690 = r.CheckBreak()
	}
	if yyb1690 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.From = nil
	} else {
		yyv1693 := &x.From
		yym1694 := z.DecBinary()
		_ = yym1694
		if false {
		} else {
			h.decSliceNetworkPolicyPeer((*[]NetworkPolicyPeer)(yyv1693), d)
		}
	}
	for {
		yyj1690++
		if yyhl1690 {
			yyb1690 = yyj1690 > l
		} else {
			yyb1690 = r.CheckBreak()
		}
		if yyb1690 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1690-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1695 := z.EncBinary()
		_ = yym1695
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1696 := !z.EncBinary()
			yy2arr1696 := z.EncBasicHandle().StructToArray
			var yyq1696 [2]bool
			_, _, _ = yysep1696, yyq1696, yy2arr1696
			const yyr1696 bool = false
			yyq1696[0] = x.Protocol != nil
			yyq1696[1] = x.Port != nil
			var yynn1696 int
			if yyr1696 || yy2arr1696 {
				r.EncodeArrayStart(2)
			} else {
				yynn1696 = 0
				for _, b := range yyq1696 {
					if b {
						yynn1696++
					}
				}
				r.EncodeMapStart(yynn1696)
				yynn1696 = 0
			}
			if yyr1696 || yy2arr1696 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1696[0] {
					if x.Protocol == nil {
						r.EncodeNil()
					} else {
						yy1698 := *x.Protocol
						yym1699 := z.EncBinary()
						_ = yym1699
						if false {
						} else if z.HasExtensions() && z.EncExt(yy1698) {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1698))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1696[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Protocol == nil {
						r.EncodeNil()
					} else {
						yy1700 := *x.Protocol
						yym1701 := z.EncBinary()
						_ = yym1701
						if false {
						} else if z.HasExtensions() && z.EncExt(yy1700) {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1700))
						}
					}
				}
			}
			if yyr1696 || yy2arr1696 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1696[1] {
					if x.Port == nil {
						r.EncodeNil()
					} else {
						yym1703 := z.EncBinary()
						_ = yym1703
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Port) {
						} else if !yym1703 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.Port)
						} else {
							z.EncFallback(x.Port)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1696[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Port == nil {
						r.EncodeNil()
					} else {
						yym1704 := z.EncBinary()
						_ = yym1704
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Port) {
						} else if !yym1704 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.Port)
						} else {
							z.EncFallback(x.Port)
						}
					}
				}
			}
			if yyr1696 || yy2arr1696 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1705 := z.DecBinary()
	_ = yym1705
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1706 := r.ContainerType()
		if yyct1706 == codecSelferValueTypeMap1234 {
			yyl1706 := r.ReadMapStart()
			if yyl1706 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1706, d)
			}
		} else if yyct1706 == codecSelferValueTypeArray1234 {
			yyl1706 := r.ReadArrayStart()
			if yyl1706 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1706, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1707Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1707Slc
	var yyhl1707 bool = l >= 0
	for yyj1707 := 0; ; yyj1707++ {
		if yyhl1707 {
			if yyj1707 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1707Slc = r.DecodeBytes(yys1707Slc, true, true)
		yys1707 := string(yys1707Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1707 {
		case "protocol":
			if r.TryDecodeAsNil() {
				if x.Protocol != nil {
					x.Protocol = nil
				}
			} else {
				if x.Protocol == nil {
					x.Protocol = new(pkg2_v1.Protocol)
				}
				x.Protocol.CodecDecodeSelf(d)
			}
		case "port":
			if r.TryDecodeAsNil() {
				if x.Port != nil {
					x.Port = nil
				}
			} else {
				if x.Port == nil {
					x.Port = new(pkg5_intstr.IntOrString)
				}
				yym1710 := z.DecBinary()
				_ = yym1710
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Port) {
				} else if !yym1710 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.Port)
				} else {
					z.DecFallback(x.Port, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1707)
		} // end switch yys1707
	} // end for yyj1707
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1711 int
	var yyb1711 bool
	var yyhl1711 bool = l >= 0
	yyj1711++
	if yyhl1711 {
		yyb1711 = yyj1711 > l
	} else {
		yyb1711 = r.CheckBreak()
	}
	if yyb1711 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Protocol != nil {
			x.Protocol = nil
		}
	} else {
		if x.Protocol == nil {
			x.Protocol = new(pkg2_v1.Protocol)
		}
		x.Protocol.CodecDecodeSelf(d)
	}
	yyj1711++
	if yyhl1711 {
		yyb1711 = yyj1711 > l
	} else {
		yyb1711 = r.CheckBreak()
	}
	if yyb1711 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Port != nil {
			x.Port = nil
		}
	} else {
		if x.Port == nil {
			x.Port = new(pkg5_intstr.IntOrString)
		}
		yym1714 := z.DecBinary()
		_ = yym1714
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Port) {
		} else if !yym1714 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.Port)
		} else {
			z.DecFallback(x.Port, false)
		}
	}
	for {
		yyj1711++
		if yyhl1711 {
			yyb1711 = yyj1711 > l
		} else {
			yyb1711 = r.CheckBreak()
		}
		if yyb1711 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1711-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyPeer) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1715 := z.EncBinary()
		_ = yym1715
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1716 := !z.EncBinary()
			yy2arr1716 := z.EncBasicHandle().StructToArray
			var yyq1716 [2]bool
			_, _, _ = yysep1716, yyq1716, yy2arr1716
			const yyr1716 bool = false
			yyq1716[0] = x.PodSelector != nil
			yyq1716[1] = x.NamespaceSelector != nil
			var yynn1716 int
			if yyr1716 || yy2arr1716 {
				r.EncodeArrayStart(2)
			} else {
				yynn1716 = 0
				for _, b := range yyq1716 {
					if b {
						yynn1716++
					}
				}
				r.EncodeMapStart(yynn1716)
				yynn1716 = 0
			}
			if yyr1716 || yy2arr1716 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1716[0] {
					if x.PodSelector == nil {
						r.EncodeNil()
					} else {
						x.PodSelector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1716[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodSelector == nil {
						r.EncodeNil()
					} else {
						x.PodSelector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1716 || yy2arr1716 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1716[1] {
					if x.NamespaceSelector == nil {
						r.EncodeNil()
					} else {
						x.NamespaceSelector.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1716[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespaceSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NamespaceSelector == nil {
						r.EncodeNil()
					} else {
						x.NamespaceSelector.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1716 || yy2arr1716 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyPeer) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1719 := z.DecBinary()
	_ = yym1719
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1720 := r.ContainerType()
		if yyct1720 == codecSelferValueTypeMap1234 {
			yyl1720 := r.ReadMapStart()
			if yyl1720 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1720, d)
			}
		} else if yyct1720 == codecSelferValueTypeArray1234 {
			yyl1720 := r.ReadArrayStart()
			if yyl1720 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1720, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyPeer) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1721Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1721Slc
	var yyhl1721 bool = l >= 0
	for yyj1721 := 0; ; yyj1721++ {
		if yyhl1721 {
			if yyj1721 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1721Slc = r.DecodeBytes(yys1721Slc, true, true)
		yys1721 := string(yys1721Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1721 {
		case "podSelector":
			if r.TryDecodeAsNil() {
				if x.PodSelector != nil {
					x.PodSelector = nil
				}
			} else {
				if x.PodSelector == nil {
					x.PodSelector = new(LabelSelector)
				}
				x.PodSelector.CodecDecodeSelf(d)
			}
		case "namespaceSelector":
			if r.TryDecodeAsNil() {
				if x.NamespaceSelector != nil {
					x.NamespaceSelector = nil
				}
			} else {
				if x.NamespaceSelector == nil {
					x.NamespaceSelector = new(LabelSelector)
				}
				x.NamespaceSelector.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1721)
		} // end switch yys1721
	} // end for yyj1721
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyPeer) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1724 int
	var yyb1724 bool
	var yyhl1724 bool = l >= 0
	yyj1724++
	if yyhl1724 {
		yyb1724 = yyj1724 > l
	} else {
		yyb1724 = r.CheckBreak()
	}
	if yyb1724 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodSelector != nil {
			x.PodSelector = nil
		}
	} else {
		if x.PodSelector == nil {
			x.PodSelector = new(LabelSelector)
		}
		x.PodSelector.CodecDecodeSelf(d)
	}
	yyj1724++
	if yyhl1724 {
		yyb1724 = yyj1724 > l
	} else {
		yyb1724 = r.CheckBreak()
	}
	if yyb1724 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NamespaceSelector != nil {
			x.NamespaceSelector = nil
		}
	} else {
		if x.NamespaceSelector == nil {
			x.NamespaceSelector = new(LabelSelector)
		}
		x.NamespaceSelector.CodecDecodeSelf(d)
	}
	for {
		yyj1724++
		if yyhl1724 {
			yyb1724 = yyj1724 > l
		} else {
			yyb1724 = r.CheckBreak()
		}
		if yyb1724 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1724-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1727 := z.EncBinary()
		_ = yym1727
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1728 := !z.EncBinary()
			yy2arr1728 := z.EncBasicHandle().StructToArray
			var yyq1728 [4]bool
			_, _, _ = yysep1728, yyq1728, yy2arr1728
			const yyr1728 bool = false
			yyq1728[0] = x.Kind != ""
			yyq1728[1] = x.APIVersion != ""
			yyq1728[2] = true
			var yynn1728 int
			if yyr1728 || yy2arr1728 {
				r.EncodeArrayStart(4)
			} else {
				yynn1728 = 1
				for _, b := range yyq1728 {
					if b {
						yynn1728++
					}
				}
				r.EncodeMapStart(yynn1728)
				yynn1728 = 0
			}
			if yyr1728 || yy2arr1728 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1728[0] {
					yym1730 := z.EncBinary()
					_ = yym1730
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1728[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1731 := z.EncBinary()
					_ = yym1731
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1728 || yy2arr1728 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1728[1] {
					yym1733 := z.EncBinary()
					_ = yym1733
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1728[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1734 := z.EncBinary()
					_ = yym1734
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1728 || yy2arr1728 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1728[2] {
					yy1736 := &x.ListMeta
					yym1737 := z.EncBinary()
					_ = yym1737
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1736) {
					} else {
						z.EncFallback(yy1736)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1728[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1738 := &x.ListMeta
					yym1739 := z.EncBinary()
					_ = yym1739
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1738) {
					} else {
						z.EncFallback(yy1738)
					}
				}
			}
			if yyr1728 || yy2arr1728 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1741 := z.EncBinary()
					_ = yym1741
					if false {
					} else {
						h.encSliceNetworkPolicy(([]NetworkPolicy)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1742 := z.EncBinary()
					_ = yym1742
					if false {
					} else {
						h.encSliceNetworkPolicy(([]NetworkPolicy)(x.Items), e)
					}
				}
			}
			if yyr1728 || yy2arr1728 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1743 := z.DecBinary()
	_ = yym1743
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1744 := r.ContainerType()
		if yyct1744 == codecSelferValueTypeMap1234 {
			yyl1744 := r.ReadMapStart()
			if yyl1744 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1744, d)
			}
		} else if yyct1744 == codecSelferValueTypeArray1234 {
			yyl1744 := r.ReadArrayStart()
			if yyl1744 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1744, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1745Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1745Slc
	var yyhl1745 bool = l >= 0
	for yyj1745 := 0; ; yyj1745++ {
		if yyhl1745 {
			if yyj1745 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1745Slc = r.DecodeBytes(yys1745Slc, true, true)
		yys1745 := string(yys1745Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1745 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1748 := &x.ListMeta
				yym1749 := z.DecBinary()
				_ = yym1749
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1748) {
				} else {
					z.DecFallback(yyv1748, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1750 := &x.Items
				yym1751 := z.DecBinary()
				_ = yym1751
				if false {
				} else {
					h.decSliceNetworkPolicy((*[]NetworkPolicy)(yyv1750), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1745)
		} // end switch yys1745
	} // end for yyj1745
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1752 int
	var yyb1752 bool
	var yyhl1752 bool = l >= 0
	yyj1752++
	if yyhl1752 {
		yyb1752 = yyj1752 > l
	} else {
		yyb1752 = r.CheckBreak()
	}
	if yyb1752 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1752++
	if yyhl1752 {
		yyb1752 = yyj1752 > l
	} else {
		yyb1752 = r.CheckBreak()
	}
	if yyb1752 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1752++
	if yyhl1752 {
		yyb1752 = yyj1752 > l
	} else {
		yyb1752 = r.CheckBreak()
	}
	if yyb1752 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1755 := &x.ListMeta
		yym1756 := z.DecBinary()
		_ = yym1756
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1755) {
		} else {
			z.DecFallback(yyv1755, false)
		}
	}
	yyj1752++
	if yyhl1752 {
		yyb1752 = yyj1752 > l
	} else {
		yyb1752 = r.CheckBreak()
	}
	if yyb1752 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1757 := &x.Items
		yym1758 := z.DecBinary()
		_ = yym1758
		if false {
		} else {
			h.decSliceNetworkPolicy((*[]NetworkPolicy)(yyv1757), d)
		}
	}
	for {
		yyj1752++
		if yyhl1752 {
			yyb1752 = yyj1752 > l
		} else {
			yyb1752 = r.CheckBreak()
		}
		if yyb1752 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1752-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *StorageClass) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1759 := z.EncBinary()
		_ = yym1759
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1760 := !z.EncBinary()
			yy2arr1760 := z.EncBasicHandle().StructToArray
			var yyq1760 [5]bool
			_, _, _ = yysep1760, yyq1760, yy2arr1760
			const yyr1760 bool = false
			yyq1760[0] = x.Kind != ""
			yyq1760[1] = x.APIVersion != ""
			yyq1760[2] = true
			yyq1760[4] = len(x.Parameters) != 0
			var yynn1760 int
			if yyr1760 || yy2arr1760 {
				r.EncodeArrayStart(5)
			} else {
				yynn1760 = 1
				for _, b := range yyq1760 {
					if b {
						yynn1760++
					}
				}
				r.EncodeMapStart(yynn1760)
				yynn1760 = 0
			}
			if yyr1760 || yy2arr1760 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1760[0] {
					yym1762 := z.EncBinary()
					_ = yym1762
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1760[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1763 := z.EncBinary()
					_ = yym1763
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1760 || yy2arr1760 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1760[1] {
					yym1765 := z.EncBinary()
					_ = yym1765
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1760[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1766 := z.EncBinary()
					_ = yym1766
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1760 || yy2arr1760 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1760[2] {
					yy1768 := &x.ObjectMeta
					yy1768.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1760[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1769 := &x.ObjectMeta
					yy1769.CodecEncodeSelf(e)
				}
			}
			if yyr1760 || yy2arr1760 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1771 := z.EncBinary()
				_ = yym1771
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Provisioner))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("provisioner"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1772 := z.EncBinary()
				_ = yym1772
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Provisioner))
				}
			}
			if yyr1760 || yy2arr1760 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1760[4] {
					if x.Parameters == nil {
						r.EncodeNil()
					} else {
						yym1774 := z.EncBinary()
						_ = yym1774
						if false {
						} else {
							z.F.EncMapStringStringV(x.Parameters, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1760[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("parameters"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Parameters == nil {
						r.EncodeNil()
					} else {
						yym1775 := z.EncBinary()
						_ = yym1775
						if false {
						} else {
							z.F.EncMapStringStringV(x.Parameters, false, e)
						}
					}
				}
			}
			if yyr1760 || yy2arr1760 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *StorageClass) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1776 := z.DecBinary()
	_ = yym1776
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1777 := r.ContainerType()
		if yyct1777 == codecSelferValueTypeMap1234 {
			yyl1777 := r.ReadMapStart()
			if yyl1777 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1777, d)
			}
		} else if yyct1777 == codecSelferValueTypeArray1234 {
			yyl1777 := r.ReadArrayStart()
			if yyl1777 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1777, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *StorageClass) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1778Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1778Slc
	var yyhl1778 bool = l >= 0
	for yyj1778 := 0; ; yyj1778++ {
		if yyhl1778 {
			if yyj1778 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1778Slc = r.DecodeBytes(yys1778Slc, true, true)
		yys1778 := string(yys1778Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1778 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1781 := &x.ObjectMeta
				yyv1781.CodecDecodeSelf(d)
			}
		case "provisioner":
			if r.TryDecodeAsNil() {
				x.Provisioner = ""
			} else {
				x.Provisioner = string(r.DecodeString())
			}
		case "parameters":
			if r.TryDecodeAsNil() {
				x.Parameters = nil
			} else {
				yyv1783 := &x.Parameters
				yym1784 := z.DecBinary()
				_ = yym1784
				if false {
				} else {
					z.F.DecMapStringStringX(yyv1783, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1778)
		} // end switch yys1778
	} // end for yyj1778
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *StorageClass) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1785 int
	var yyb1785 bool
	var yyhl1785 bool = l >= 0
	yyj1785++
	if yyhl1785 {
		yyb1785 = yyj1785 > l
	} else {
		yyb1785 = r.CheckBreak()
	}
	if yyb1785 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1785++
	if yyhl1785 {
		yyb1785 = yyj1785 > l
	} else {
		yyb1785 = r.CheckBreak()
	}
	if yyb1785 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1785++
	if yyhl1785 {
		yyb1785 = yyj1785 > l
	} else {
		yyb1785 = r.CheckBreak()
	}
	if yyb1785 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1788 := &x.ObjectMeta
		yyv1788.CodecDecodeSelf(d)
	}
	yyj1785++
	if yyhl1785 {
		yyb1785 = yyj1785 > l
	} else {
		yyb1785 = r.CheckBreak()
	}
	if yyb1785 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Provisioner = ""
	} else {
		x.Provisioner = string(r.DecodeString())
	}
	yyj1785++
	if yyhl1785 {
		yyb1785 = yyj1785 > l
	} else {
		yyb1785 = r.CheckBreak()
	}
	if yyb1785 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Parameters = nil
	} else {
		yyv1790 := &x.Parameters
		yym1791 := z.DecBinary()
		_ = yym1791
		if false {
		} else {
			z.F.DecMapStringStringX(yyv1790, false, d)
		}
	}
	for {
		yyj1785++
		if yyhl1785 {
			yyb1785 = yyj1785 > l
		} else {
			yyb1785 = r.CheckBreak()
		}
		if yyb1785 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1785-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *StorageClassList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1792 := z.EncBinary()
		_ = yym1792
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1793 := !z.EncBinary()
			yy2arr1793 := z.EncBasicHandle().StructToArray
			var yyq1793 [4]bool
			_, _, _ = yysep1793, yyq1793, yy2arr1793
			const yyr1793 bool = false
			yyq1793[0] = x.Kind != ""
			yyq1793[1] = x.APIVersion != ""
			yyq1793[2] = true
			var yynn1793 int
			if yyr1793 || yy2arr1793 {
				r.EncodeArrayStart(4)
			} else {
				yynn1793 = 1
				for _, b := range yyq1793 {
					if b {
						yynn1793++
					}
				}
				r.EncodeMapStart(yynn1793)
				yynn1793 = 0
			}
			if yyr1793 || yy2arr1793 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1793[0] {
					yym1795 := z.EncBinary()
					_ = yym1795
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1793[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1796 := z.EncBinary()
					_ = yym1796
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1793 || yy2arr1793 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1793[1] {
					yym1798 := z.EncBinary()
					_ = yym1798
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1793[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1799 := z.EncBinary()
					_ = yym1799
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1793 || yy2arr1793 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1793[2] {
					yy1801 := &x.ListMeta
					yym1802 := z.EncBinary()
					_ = yym1802
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1801) {
					} else {
						z.EncFallback(yy1801)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1793[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1803 := &x.ListMeta
					yym1804 := z.EncBinary()
					_ = yym1804
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1803) {
					} else {
						z.EncFallback(yy1803)
					}
				}
			}
			if yyr1793 || yy2arr1793 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1806 := z.EncBinary()
					_ = yym1806
					if false {
					} else {
						h.encSliceStorageClass(([]StorageClass)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1807 := z.EncBinary()
					_ = yym1807
					if false {
					} else {
						h.encSliceStorageClass(([]StorageClass)(x.Items), e)
					}
				}
			}
			if yyr1793 || yy2arr1793 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *StorageClassList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1808 := z.DecBinary()
	_ = yym1808
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1809 := r.ContainerType()
		if yyct1809 == codecSelferValueTypeMap1234 {
			yyl1809 := r.ReadMapStart()
			if yyl1809 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1809, d)
			}
		} else if yyct1809 == codecSelferValueTypeArray1234 {
			yyl1809 := r.ReadArrayStart()
			if yyl1809 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1809, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *StorageClassList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1810Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1810Slc
	var yyhl1810 bool = l >= 0
	for yyj1810 := 0; ; yyj1810++ {
		if yyhl1810 {
			if yyj1810 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1810Slc = r.DecodeBytes(yys1810Slc, true, true)
		yys1810 := string(yys1810Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1810 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1813 := &x.ListMeta
				yym1814 := z.DecBinary()
				_ = yym1814
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1813) {
				} else {
					z.DecFallback(yyv1813, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1815 := &x.Items
				yym1816 := z.DecBinary()
				_ = yym1816
				if false {
				} else {
					h.decSliceStorageClass((*[]StorageClass)(yyv1815), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1810)
		} // end switch yys1810
	} // end for yyj1810
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *StorageClassList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1817 int
	var yyb1817 bool
	var yyhl1817 bool = l >= 0
	yyj1817++
	if yyhl1817 {
		yyb1817 = yyj1817 > l
	} else {
		yyb1817 = r.CheckBreak()
	}
	if yyb1817 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1817++
	if yyhl1817 {
		yyb1817 = yyj1817 > l
	} else {
		yyb1817 = r.CheckBreak()
	}
	if yyb1817 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1817++
	if yyhl1817 {
		yyb1817 = yyj1817 > l
	} else {
		yyb1817 = r.CheckBreak()
	}
	if yyb1817 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1820 := &x.ListMeta
		yym1821 := z.DecBinary()
		_ = yym1821
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1820) {
		} else {
			z.DecFallback(yyv1820, false)
		}
	}
	yyj1817++
	if yyhl1817 {
		yyb1817 = yyj1817 > l
	} else {
		yyb1817 = r.CheckBreak()
	}
	if yyb1817 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1822 := &x.Items
		yym1823 := z.DecBinary()
		_ = yym1823
		if false {
		} else {
			h.decSliceStorageClass((*[]StorageClass)(yyv1822), d)
		}
	}
	for {
		yyj1817++
		if yyhl1817 {
			yyb1817 = yyj1817 > l
		} else {
			yyb1817 = r.CheckBreak()
		}
		if yyb1817 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1817-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceCustomMetricTarget(v []CustomMetricTarget, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1824 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1825 := &yyv1824
		yy1825.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCustomMetricTarget(v *[]CustomMetricTarget, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1826 := *v
	yyh1826, yyl1826 := z.DecSliceHelperStart()
	var yyc1826 bool
	if yyl1826 == 0 {
		if yyv1826 == nil {
			yyv1826 = []CustomMetricTarget{}
			yyc1826 = true
		} else if len(yyv1826) != 0 {
			yyv1826 = yyv1826[:0]
			yyc1826 = true
		}
	} else if yyl1826 > 0 {
		var yyrr1826, yyrl1826 int
		var yyrt1826 bool
		if yyl1826 > cap(yyv1826) {

			yyrg1826 := len(yyv1826) > 0
			yyv21826 := yyv1826
			yyrl1826, yyrt1826 = z.DecInferLen(yyl1826, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt1826 {
				if yyrl1826 <= cap(yyv1826) {
					yyv1826 = yyv1826[:yyrl1826]
				} else {
					yyv1826 = make([]CustomMetricTarget, yyrl1826)
				}
			} else {
				yyv1826 = make([]CustomMetricTarget, yyrl1826)
			}
			yyc1826 = true
			yyrr1826 = len(yyv1826)
			if yyrg1826 {
				copy(yyv1826, yyv21826)
			}
		} else if yyl1826 != len(yyv1826) {
			yyv1826 = yyv1826[:yyl1826]
			yyc1826 = true
		}
		yyj1826 := 0
		for ; yyj1826 < yyrr1826; yyj1826++ {
			yyh1826.ElemContainerState(yyj1826)
			if r.TryDecodeAsNil() {
				yyv1826[yyj1826] = CustomMetricTarget{}
			} else {
				yyv1827 := &yyv1826[yyj1826]
				yyv1827.CodecDecodeSelf(d)
			}

		}
		if yyrt1826 {
			for ; yyj1826 < yyl1826; yyj1826++ {
				yyv1826 = append(yyv1826, CustomMetricTarget{})
				yyh1826.ElemContainerState(yyj1826)
				if r.TryDecodeAsNil() {
					yyv1826[yyj1826] = CustomMetricTarget{}
				} else {
					yyv1828 := &yyv1826[yyj1826]
					yyv1828.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1826 := 0
		for ; !r.CheckBreak(); yyj1826++ {

			if yyj1826 >= len(yyv1826) {
				yyv1826 = append(yyv1826, CustomMetricTarget{}) // var yyz1826 CustomMetricTarget
				yyc1826 = true
			}
			yyh1826.ElemContainerState(yyj1826)
			if yyj1826 < len(yyv1826) {
				if r.TryDecodeAsNil() {
					yyv1826[yyj1826] = CustomMetricTarget{}
				} else {
					yyv1829 := &yyv1826[yyj1826]
					yyv1829.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1826 < len(yyv1826) {
			yyv1826 = yyv1826[:yyj1826]
			yyc1826 = true
		} else if yyj1826 == 0 && yyv1826 == nil {
			yyv1826 = []CustomMetricTarget{}
			yyc1826 = true
		}
	}
	yyh1826.End()
	if yyc1826 {
		*v = yyv1826
	}
}

func (x codecSelfer1234) encSliceCustomMetricCurrentStatus(v []CustomMetricCurrentStatus, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1830 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1831 := &yyv1830
		yy1831.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCustomMetricCurrentStatus(v *[]CustomMetricCurrentStatus, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1832 := *v
	yyh1832, yyl1832 := z.DecSliceHelperStart()
	var yyc1832 bool
	if yyl1832 == 0 {
		if yyv1832 == nil {
			yyv1832 = []CustomMetricCurrentStatus{}
			yyc1832 = true
		} else if len(yyv1832) != 0 {
			yyv1832 = yyv1832[:0]
			yyc1832 = true
		}
	} else if yyl1832 > 0 {
		var yyrr1832, yyrl1832 int
		var yyrt1832 bool
		if yyl1832 > cap(yyv1832) {

			yyrg1832 := len(yyv1832) > 0
			yyv21832 := yyv1832
			yyrl1832, yyrt1832 = z.DecInferLen(yyl1832, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt1832 {
				if yyrl1832 <= cap(yyv1832) {
					yyv1832 = yyv1832[:yyrl1832]
				} else {
					yyv1832 = make([]CustomMetricCurrentStatus, yyrl1832)
				}
			} else {
				yyv1832 = make([]CustomMetricCurrentStatus, yyrl1832)
			}
			yyc1832 = true
			yyrr1832 = len(yyv1832)
			if yyrg1832 {
				copy(yyv1832, yyv21832)
			}
		} else if yyl1832 != len(yyv1832) {
			yyv1832 = yyv1832[:yyl1832]
			yyc1832 = true
		}
		yyj1832 := 0
		for ; yyj1832 < yyrr1832; yyj1832++ {
			yyh1832.ElemContainerState(yyj1832)
			if r.TryDecodeAsNil() {
				yyv1832[yyj1832] = CustomMetricCurrentStatus{}
			} else {
				yyv1833 := &yyv1832[yyj1832]
				yyv1833.CodecDecodeSelf(d)
			}

		}
		if yyrt1832 {
			for ; yyj1832 < yyl1832; yyj1832++ {
				yyv1832 = append(yyv1832, CustomMetricCurrentStatus{})
				yyh1832.ElemContainerState(yyj1832)
				if r.TryDecodeAsNil() {
					yyv1832[yyj1832] = CustomMetricCurrentStatus{}
				} else {
					yyv1834 := &yyv1832[yyj1832]
					yyv1834.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1832 := 0
		for ; !r.CheckBreak(); yyj1832++ {

			if yyj1832 >= len(yyv1832) {
				yyv1832 = append(yyv1832, CustomMetricCurrentStatus{}) // var yyz1832 CustomMetricCurrentStatus
				yyc1832 = true
			}
			yyh1832.ElemContainerState(yyj1832)
			if yyj1832 < len(yyv1832) {
				if r.TryDecodeAsNil() {
					yyv1832[yyj1832] = CustomMetricCurrentStatus{}
				} else {
					yyv1835 := &yyv1832[yyj1832]
					yyv1835.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1832 < len(yyv1832) {
			yyv1832 = yyv1832[:yyj1832]
			yyc1832 = true
		} else if yyj1832 == 0 && yyv1832 == nil {
			yyv1832 = []CustomMetricCurrentStatus{}
			yyc1832 = true
		}
	}
	yyh1832.End()
	if yyc1832 {
		*v = yyv1832
	}
}

func (x codecSelfer1234) encSliceHorizontalPodAutoscaler(v []HorizontalPodAutoscaler, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1836 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1837 := &yyv1836
		yy1837.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHorizontalPodAutoscaler(v *[]HorizontalPodAutoscaler, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1838 := *v
	yyh1838, yyl1838 := z.DecSliceHelperStart()
	var yyc1838 bool
	if yyl1838 == 0 {
		if yyv1838 == nil {
			yyv1838 = []HorizontalPodAutoscaler{}
			yyc1838 = true
		} else if len(yyv1838) != 0 {
			yyv1838 = yyv1838[:0]
			yyc1838 = true
		}
	} else if yyl1838 > 0 {
		var yyrr1838, yyrl1838 int
		var yyrt1838 bool
		if yyl1838 > cap(yyv1838) {

			yyrg1838 := len(yyv1838) > 0
			yyv21838 := yyv1838
			yyrl1838, yyrt1838 = z.DecInferLen(yyl1838, z.DecBasicHandle().MaxInitLen, 376)
			if yyrt1838 {
				if yyrl1838 <= cap(yyv1838) {
					yyv1838 = yyv1838[:yyrl1838]
				} else {
					yyv1838 = make([]HorizontalPodAutoscaler, yyrl1838)
				}
			} else {
				yyv1838 = make([]HorizontalPodAutoscaler, yyrl1838)
			}
			yyc1838 = true
			yyrr1838 = len(yyv1838)
			if yyrg1838 {
				copy(yyv1838, yyv21838)
			}
		} else if yyl1838 != len(yyv1838) {
			yyv1838 = yyv1838[:yyl1838]
			yyc1838 = true
		}
		yyj1838 := 0
		for ; yyj1838 < yyrr1838; yyj1838++ {
			yyh1838.ElemContainerState(yyj1838)
			if r.TryDecodeAsNil() {
				yyv1838[yyj1838] = HorizontalPodAutoscaler{}
			} else {
				yyv1839 := &yyv1838[yyj1838]
				yyv1839.CodecDecodeSelf(d)
			}

		}
		if yyrt1838 {
			for ; yyj1838 < yyl1838; yyj1838++ {
				yyv1838 = append(yyv1838, HorizontalPodAutoscaler{})
				yyh1838.ElemContainerState(yyj1838)
				if r.TryDecodeAsNil() {
					yyv1838[yyj1838] = HorizontalPodAutoscaler{}
				} else {
					yyv1840 := &yyv1838[yyj1838]
					yyv1840.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1838 := 0
		for ; !r.CheckBreak(); yyj1838++ {

			if yyj1838 >= len(yyv1838) {
				yyv1838 = append(yyv1838, HorizontalPodAutoscaler{}) // var yyz1838 HorizontalPodAutoscaler
				yyc1838 = true
			}
			yyh1838.ElemContainerState(yyj1838)
			if yyj1838 < len(yyv1838) {
				if r.TryDecodeAsNil() {
					yyv1838[yyj1838] = HorizontalPodAutoscaler{}
				} else {
					yyv1841 := &yyv1838[yyj1838]
					yyv1841.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1838 < len(yyv1838) {
			yyv1838 = yyv1838[:yyj1838]
			yyc1838 = true
		} else if yyj1838 == 0 && yyv1838 == nil {
			yyv1838 = []HorizontalPodAutoscaler{}
			yyc1838 = true
		}
	}
	yyh1838.End()
	if yyc1838 {
		*v = yyv1838
	}
}

func (x codecSelfer1234) encSliceAPIVersion(v []APIVersion, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1842 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1843 := &yyv1842
		yy1843.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceAPIVersion(v *[]APIVersion, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1844 := *v
	yyh1844, yyl1844 := z.DecSliceHelperStart()
	var yyc1844 bool
	if yyl1844 == 0 {
		if yyv1844 == nil {
			yyv1844 = []APIVersion{}
			yyc1844 = true
		} else if len(yyv1844) != 0 {
			yyv1844 = yyv1844[:0]
			yyc1844 = true
		}
	} else if yyl1844 > 0 {
		var yyrr1844, yyrl1844 int
		var yyrt1844 bool
		if yyl1844 > cap(yyv1844) {

			yyrg1844 := len(yyv1844) > 0
			yyv21844 := yyv1844
			yyrl1844, yyrt1844 = z.DecInferLen(yyl1844, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1844 {
				if yyrl1844 <= cap(yyv1844) {
					yyv1844 = yyv1844[:yyrl1844]
				} else {
					yyv1844 = make([]APIVersion, yyrl1844)
				}
			} else {
				yyv1844 = make([]APIVersion, yyrl1844)
			}
			yyc1844 = true
			yyrr1844 = len(yyv1844)
			if yyrg1844 {
				copy(yyv1844, yyv21844)
			}
		} else if yyl1844 != len(yyv1844) {
			yyv1844 = yyv1844[:yyl1844]
			yyc1844 = true
		}
		yyj1844 := 0
		for ; yyj1844 < yyrr1844; yyj1844++ {
			yyh1844.ElemContainerState(yyj1844)
			if r.TryDecodeAsNil() {
				yyv1844[yyj1844] = APIVersion{}
			} else {
				yyv1845 := &yyv1844[yyj1844]
				yyv1845.CodecDecodeSelf(d)
			}

		}
		if yyrt1844 {
			for ; yyj1844 < yyl1844; yyj1844++ {
				yyv1844 = append(yyv1844, APIVersion{})
				yyh1844.ElemContainerState(yyj1844)
				if r.TryDecodeAsNil() {
					yyv1844[yyj1844] = APIVersion{}
				} else {
					yyv1846 := &yyv1844[yyj1844]
					yyv1846.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1844 := 0
		for ; !r.CheckBreak(); yyj1844++ {

			if yyj1844 >= len(yyv1844) {
				yyv1844 = append(yyv1844, APIVersion{}) // var yyz1844 APIVersion
				yyc1844 = true
			}
			yyh1844.ElemContainerState(yyj1844)
			if yyj1844 < len(yyv1844) {
				if r.TryDecodeAsNil() {
					yyv1844[yyj1844] = APIVersion{}
				} else {
					yyv1847 := &yyv1844[yyj1844]
					yyv1847.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1844 < len(yyv1844) {
			yyv1844 = yyv1844[:yyj1844]
			yyc1844 = true
		} else if yyj1844 == 0 && yyv1844 == nil {
			yyv1844 = []APIVersion{}
			yyc1844 = true
		}
	}
	yyh1844.End()
	if yyc1844 {
		*v = yyv1844
	}
}

func (x codecSelfer1234) encSliceThirdPartyResource(v []ThirdPartyResource, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1848 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1849 := &yyv1848
		yy1849.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResource(v *[]ThirdPartyResource, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1850 := *v
	yyh1850, yyl1850 := z.DecSliceHelperStart()
	var yyc1850 bool
	if yyl1850 == 0 {
		if yyv1850 == nil {
			yyv1850 = []ThirdPartyResource{}
			yyc1850 = true
		} else if len(yyv1850) != 0 {
			yyv1850 = yyv1850[:0]
			yyc1850 = true
		}
	} else if yyl1850 > 0 {
		var yyrr1850, yyrl1850 int
		var yyrt1850 bool
		if yyl1850 > cap(yyv1850) {

			yyrg1850 := len(yyv1850) > 0
			yyv21850 := yyv1850
			yyrl1850, yyrt1850 = z.DecInferLen(yyl1850, z.DecBasicHandle().MaxInitLen, 296)
			if yyrt1850 {
				if yyrl1850 <= cap(yyv1850) {
					yyv1850 = yyv1850[:yyrl1850]
				} else {
					yyv1850 = make([]ThirdPartyResource, yyrl1850)
				}
			} else {
				yyv1850 = make([]ThirdPartyResource, yyrl1850)
			}
			yyc1850 = true
			yyrr1850 = len(yyv1850)
			if yyrg1850 {
				copy(yyv1850, yyv21850)
			}
		} else if yyl1850 != len(yyv1850) {
			yyv1850 = yyv1850[:yyl1850]
			yyc1850 = true
		}
		yyj1850 := 0
		for ; yyj1850 < yyrr1850; yyj1850++ {
			yyh1850.ElemContainerState(yyj1850)
			if r.TryDecodeAsNil() {
				yyv1850[yyj1850] = ThirdPartyResource{}
			} else {
				yyv1851 := &yyv1850[yyj1850]
				yyv1851.CodecDecodeSelf(d)
			}

		}
		if yyrt1850 {
			for ; yyj1850 < yyl1850; yyj1850++ {
				yyv1850 = append(yyv1850, ThirdPartyResource{})
				yyh1850.ElemContainerState(yyj1850)
				if r.TryDecodeAsNil() {
					yyv1850[yyj1850] = ThirdPartyResource{}
				} else {
					yyv1852 := &yyv1850[yyj1850]
					yyv1852.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1850 := 0
		for ; !r.CheckBreak(); yyj1850++ {

			if yyj1850 >= len(yyv1850) {
				yyv1850 = append(yyv1850, ThirdPartyResource{}) // var yyz1850 ThirdPartyResource
				yyc1850 = true
			}
			yyh1850.ElemContainerState(yyj1850)
			if yyj1850 < len(yyv1850) {
				if r.TryDecodeAsNil() {
					yyv1850[yyj1850] = ThirdPartyResource{}
				} else {
					yyv1853 := &yyv1850[yyj1850]
					yyv1853.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1850 < len(yyv1850) {
			yyv1850 = yyv1850[:yyj1850]
			yyc1850 = true
		} else if yyj1850 == 0 && yyv1850 == nil {
			yyv1850 = []ThirdPartyResource{}
			yyc1850 = true
		}
	}
	yyh1850.End()
	if yyc1850 {
		*v = yyv1850
	}
}

func (x codecSelfer1234) encSliceDeployment(v []Deployment, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1854 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1855 := &yyv1854
		yy1855.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDeployment(v *[]Deployment, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1856 := *v
	yyh1856, yyl1856 := z.DecSliceHelperStart()
	var yyc1856 bool
	if yyl1856 == 0 {
		if yyv1856 == nil {
			yyv1856 = []Deployment{}
			yyc1856 = true
		} else if len(yyv1856) != 0 {
			yyv1856 = yyv1856[:0]
			yyc1856 = true
		}
	} else if yyl1856 > 0 {
		var yyrr1856, yyrl1856 int
		var yyrt1856 bool
		if yyl1856 > cap(yyv1856) {

			yyrg1856 := len(yyv1856) > 0
			yyv21856 := yyv1856
			yyrl1856, yyrt1856 = z.DecInferLen(yyl1856, z.DecBasicHandle().MaxInitLen, 824)
			if yyrt1856 {
				if yyrl1856 <= cap(yyv1856) {
					yyv1856 = yyv1856[:yyrl1856]
				} else {
					yyv1856 = make([]Deployment, yyrl1856)
				}
			} else {
				yyv1856 = make([]Deployment, yyrl1856)
			}
			yyc1856 = true
			yyrr1856 = len(yyv1856)
			if yyrg1856 {
				copy(yyv1856, yyv21856)
			}
		} else if yyl1856 != len(yyv1856) {
			yyv1856 = yyv1856[:yyl1856]
			yyc1856 = true
		}
		yyj1856 := 0
		for ; yyj1856 < yyrr1856; yyj1856++ {
			yyh1856.ElemContainerState(yyj1856)
			if r.TryDecodeAsNil() {
				yyv1856[yyj1856] = Deployment{}
			} else {
				yyv1857 := &yyv1856[yyj1856]
				yyv1857.CodecDecodeSelf(d)
			}

		}
		if yyrt1856 {
			for ; yyj1856 < yyl1856; yyj1856++ {
				yyv1856 = append(yyv1856, Deployment{})
				yyh1856.ElemContainerState(yyj1856)
				if r.TryDecodeAsNil() {
					yyv1856[yyj1856] = Deployment{}
				} else {
					yyv1858 := &yyv1856[yyj1856]
					yyv1858.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1856 := 0
		for ; !r.CheckBreak(); yyj1856++ {

			if yyj1856 >= len(yyv1856) {
				yyv1856 = append(yyv1856, Deployment{}) // var yyz1856 Deployment
				yyc1856 = true
			}
			yyh1856.ElemContainerState(yyj1856)
			if yyj1856 < len(yyv1856) {
				if r.TryDecodeAsNil() {
					yyv1856[yyj1856] = Deployment{}
				} else {
					yyv1859 := &yyv1856[yyj1856]
					yyv1859.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1856 < len(yyv1856) {
			yyv1856 = yyv1856[:yyj1856]
			yyc1856 = true
		} else if yyj1856 == 0 && yyv1856 == nil {
			yyv1856 = []Deployment{}
			yyc1856 = true
		}
	}
	yyh1856.End()
	if yyc1856 {
		*v = yyv1856
	}
}

func (x codecSelfer1234) encSliceDaemonSet(v []DaemonSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1860 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1861 := &yyv1860
		yy1861.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDaemonSet(v *[]DaemonSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1862 := *v
	yyh1862, yyl1862 := z.DecSliceHelperStart()
	var yyc1862 bool
	if yyl1862 == 0 {
		if yyv1862 == nil {
			yyv1862 = []DaemonSet{}
			yyc1862 = true
		} else if len(yyv1862) != 0 {
			yyv1862 = yyv1862[:0]
			yyc1862 = true
		}
	} else if yyl1862 > 0 {
		var yyrr1862, yyrl1862 int
		var yyrt1862 bool
		if yyl1862 > cap(yyv1862) {

			yyrg1862 := len(yyv1862) > 0
			yyv21862 := yyv1862
			yyrl1862, yyrt1862 = z.DecInferLen(yyl1862, z.DecBasicHandle().MaxInitLen, 752)
			if yyrt1862 {
				if yyrl1862 <= cap(yyv1862) {
					yyv1862 = yyv1862[:yyrl1862]
				} else {
					yyv1862 = make([]DaemonSet, yyrl1862)
				}
			} else {
				yyv1862 = make([]DaemonSet, yyrl1862)
			}
			yyc1862 = true
			yyrr1862 = len(yyv1862)
			if yyrg1862 {
				copy(yyv1862, yyv21862)
			}
		} else if yyl1862 != len(yyv1862) {
			yyv1862 = yyv1862[:yyl1862]
			yyc1862 = true
		}
		yyj1862 := 0
		for ; yyj1862 < yyrr1862; yyj1862++ {
			yyh1862.ElemContainerState(yyj1862)
			if r.TryDecodeAsNil() {
				yyv1862[yyj1862] = DaemonSet{}
			} else {
				yyv1863 := &yyv1862[yyj1862]
				yyv1863.CodecDecodeSelf(d)
			}

		}
		if yyrt1862 {
			for ; yyj1862 < yyl1862; yyj1862++ {
				yyv1862 = append(yyv1862, DaemonSet{})
				yyh1862.ElemContainerState(yyj1862)
				if r.TryDecodeAsNil() {
					yyv1862[yyj1862] = DaemonSet{}
				} else {
					yyv1864 := &yyv1862[yyj1862]
					yyv1864.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1862 := 0
		for ; !r.CheckBreak(); yyj1862++ {

			if yyj1862 >= len(yyv1862) {
				yyv1862 = append(yyv1862, DaemonSet{}) // var yyz1862 DaemonSet
				yyc1862 = true
			}
			yyh1862.ElemContainerState(yyj1862)
			if yyj1862 < len(yyv1862) {
				if r.TryDecodeAsNil() {
					yyv1862[yyj1862] = DaemonSet{}
				} else {
					yyv1865 := &yyv1862[yyj1862]
					yyv1865.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1862 < len(yyv1862) {
			yyv1862 = yyv1862[:yyj1862]
			yyc1862 = true
		} else if yyj1862 == 0 && yyv1862 == nil {
			yyv1862 = []DaemonSet{}
			yyc1862 = true
		}
	}
	yyh1862.End()
	if yyc1862 {
		*v = yyv1862
	}
}

func (x codecSelfer1234) encSliceThirdPartyResourceData(v []ThirdPartyResourceData, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1866 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1867 := &yyv1866
		yy1867.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResourceData(v *[]ThirdPartyResourceData, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1868 := *v
	yyh1868, yyl1868 := z.DecSliceHelperStart()
	var yyc1868 bool
	if yyl1868 == 0 {
		if yyv1868 == nil {
			yyv1868 = []ThirdPartyResourceData{}
			yyc1868 = true
		} else if len(yyv1868) != 0 {
			yyv1868 = yyv1868[:0]
			yyc1868 = true
		}
	} else if yyl1868 > 0 {
		var yyrr1868, yyrl1868 int
		var yyrt1868 bool
		if yyl1868 > cap(yyv1868) {

			yyrg1868 := len(yyv1868) > 0
			yyv21868 := yyv1868
			yyrl1868, yyrt1868 = z.DecInferLen(yyl1868, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt1868 {
				if yyrl1868 <= cap(yyv1868) {
					yyv1868 = yyv1868[:yyrl1868]
				} else {
					yyv1868 = make([]ThirdPartyResourceData, yyrl1868)
				}
			} else {
				yyv1868 = make([]ThirdPartyResourceData, yyrl1868)
			}
			yyc1868 = true
			yyrr1868 = len(yyv1868)
			if yyrg1868 {
				copy(yyv1868, yyv21868)
			}
		} else if yyl1868 != len(yyv1868) {
			yyv1868 = yyv1868[:yyl1868]
			yyc1868 = true
		}
		yyj1868 := 0
		for ; yyj1868 < yyrr1868; yyj1868++ {
			yyh1868.ElemContainerState(yyj1868)
			if r.TryDecodeAsNil() {
				yyv1868[yyj1868] = ThirdPartyResourceData{}
			} else {
				yyv1869 := &yyv1868[yyj1868]
				yyv1869.CodecDecodeSelf(d)
			}

		}
		if yyrt1868 {
			for ; yyj1868 < yyl1868; yyj1868++ {
				yyv1868 = append(yyv1868, ThirdPartyResourceData{})
				yyh1868.ElemContainerState(yyj1868)
				if r.TryDecodeAsNil() {
					yyv1868[yyj1868] = ThirdPartyResourceData{}
				} else {
					yyv1870 := &yyv1868[yyj1868]
					yyv1870.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1868 := 0
		for ; !r.CheckBreak(); yyj1868++ {

			if yyj1868 >= len(yyv1868) {
				yyv1868 = append(yyv1868, ThirdPartyResourceData{}) // var yyz1868 ThirdPartyResourceData
				yyc1868 = true
			}
			yyh1868.ElemContainerState(yyj1868)
			if yyj1868 < len(yyv1868) {
				if r.TryDecodeAsNil() {
					yyv1868[yyj1868] = ThirdPartyResourceData{}
				} else {
					yyv1871 := &yyv1868[yyj1868]
					yyv1871.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1868 < len(yyv1868) {
			yyv1868 = yyv1868[:yyj1868]
			yyc1868 = true
		} else if yyj1868 == 0 && yyv1868 == nil {
			yyv1868 = []ThirdPartyResourceData{}
			yyc1868 = true
		}
	}
	yyh1868.End()
	if yyc1868 {
		*v = yyv1868
	}
}

func (x codecSelfer1234) encSliceJob(v []Job, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1872 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1873 := &yyv1872
		yy1873.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJob(v *[]Job, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1874 := *v
	yyh1874, yyl1874 := z.DecSliceHelperStart()
	var yyc1874 bool
	if yyl1874 == 0 {
		if yyv1874 == nil {
			yyv1874 = []Job{}
			yyc1874 = true
		} else if len(yyv1874) != 0 {
			yyv1874 = yyv1874[:0]
			yyc1874 = true
		}
	} else if yyl1874 > 0 {
		var yyrr1874, yyrl1874 int
		var yyrt1874 bool
		if yyl1874 > cap(yyv1874) {

			yyrg1874 := len(yyv1874) > 0
			yyv21874 := yyv1874
			yyrl1874, yyrt1874 = z.DecInferLen(yyl1874, z.DecBasicHandle().MaxInitLen, 824)
			if yyrt1874 {
				if yyrl1874 <= cap(yyv1874) {
					yyv1874 = yyv1874[:yyrl1874]
				} else {
					yyv1874 = make([]Job, yyrl1874)
				}
			} else {
				yyv1874 = make([]Job, yyrl1874)
			}
			yyc1874 = true
			yyrr1874 = len(yyv1874)
			if yyrg1874 {
				copy(yyv1874, yyv21874)
			}
		} else if yyl1874 != len(yyv1874) {
			yyv1874 = yyv1874[:yyl1874]
			yyc1874 = true
		}
		yyj1874 := 0
		for ; yyj1874 < yyrr1874; yyj1874++ {
			yyh1874.ElemContainerState(yyj1874)
			if r.TryDecodeAsNil() {
				yyv1874[yyj1874] = Job{}
			} else {
				yyv1875 := &yyv1874[yyj1874]
				yyv1875.CodecDecodeSelf(d)
			}

		}
		if yyrt1874 {
			for ; yyj1874 < yyl1874; yyj1874++ {
				yyv1874 = append(yyv1874, Job{})
				yyh1874.ElemContainerState(yyj1874)
				if r.TryDecodeAsNil() {
					yyv1874[yyj1874] = Job{}
				} else {
					yyv1876 := &yyv1874[yyj1874]
					yyv1876.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1874 := 0
		for ; !r.CheckBreak(); yyj1874++ {

			if yyj1874 >= len(yyv1874) {
				yyv1874 = append(yyv1874, Job{}) // var yyz1874 Job
				yyc1874 = true
			}
			yyh1874.ElemContainerState(yyj1874)
			if yyj1874 < len(yyv1874) {
				if r.TryDecodeAsNil() {
					yyv1874[yyj1874] = Job{}
				} else {
					yyv1877 := &yyv1874[yyj1874]
					yyv1877.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1874 < len(yyv1874) {
			yyv1874 = yyv1874[:yyj1874]
			yyc1874 = true
		} else if yyj1874 == 0 && yyv1874 == nil {
			yyv1874 = []Job{}
			yyc1874 = true
		}
	}
	yyh1874.End()
	if yyc1874 {
		*v = yyv1874
	}
}

func (x codecSelfer1234) encSliceJobCondition(v []JobCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1878 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1879 := &yyv1878
		yy1879.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJobCondition(v *[]JobCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1880 := *v
	yyh1880, yyl1880 := z.DecSliceHelperStart()
	var yyc1880 bool
	if yyl1880 == 0 {
		if yyv1880 == nil {
			yyv1880 = []JobCondition{}
			yyc1880 = true
		} else if len(yyv1880) != 0 {
			yyv1880 = yyv1880[:0]
			yyc1880 = true
		}
	} else if yyl1880 > 0 {
		var yyrr1880, yyrl1880 int
		var yyrt1880 bool
		if yyl1880 > cap(yyv1880) {

			yyrg1880 := len(yyv1880) > 0
			yyv21880 := yyv1880
			yyrl1880, yyrt1880 = z.DecInferLen(yyl1880, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt1880 {
				if yyrl1880 <= cap(yyv1880) {
					yyv1880 = yyv1880[:yyrl1880]
				} else {
					yyv1880 = make([]JobCondition, yyrl1880)
				}
			} else {
				yyv1880 = make([]JobCondition, yyrl1880)
			}
			yyc1880 = true
			yyrr1880 = len(yyv1880)
			if yyrg1880 {
				copy(yyv1880, yyv21880)
			}
		} else if yyl1880 != len(yyv1880) {
			yyv1880 = yyv1880[:yyl1880]
			yyc1880 = true
		}
		yyj1880 := 0
		for ; yyj1880 < yyrr1880; yyj1880++ {
			yyh1880.ElemContainerState(yyj1880)
			if r.TryDecodeAsNil() {
				yyv1880[yyj1880] = JobCondition{}
			} else {
				yyv1881 := &yyv1880[yyj1880]
				yyv1881.CodecDecodeSelf(d)
			}

		}
		if yyrt1880 {
			for ; yyj1880 < yyl1880; yyj1880++ {
				yyv1880 = append(yyv1880, JobCondition{})
				yyh1880.ElemContainerState(yyj1880)
				if r.TryDecodeAsNil() {
					yyv1880[yyj1880] = JobCondition{}
				} else {
					yyv1882 := &yyv1880[yyj1880]
					yyv1882.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1880 := 0
		for ; !r.CheckBreak(); yyj1880++ {

			if yyj1880 >= len(yyv1880) {
				yyv1880 = append(yyv1880, JobCondition{}) // var yyz1880 JobCondition
				yyc1880 = true
			}
			yyh1880.ElemContainerState(yyj1880)
			if yyj1880 < len(yyv1880) {
				if r.TryDecodeAsNil() {
					yyv1880[yyj1880] = JobCondition{}
				} else {
					yyv1883 := &yyv1880[yyj1880]
					yyv1883.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1880 < len(yyv1880) {
			yyv1880 = yyv1880[:yyj1880]
			yyc1880 = true
		} else if yyj1880 == 0 && yyv1880 == nil {
			yyv1880 = []JobCondition{}
			yyc1880 = true
		}
	}
	yyh1880.End()
	if yyc1880 {
		*v = yyv1880
	}
}

func (x codecSelfer1234) encSliceIngress(v []Ingress, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1884 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1885 := &yyv1884
		yy1885.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngress(v *[]Ingress, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1886 := *v
	yyh1886, yyl1886 := z.DecSliceHelperStart()
	var yyc1886 bool
	if yyl1886 == 0 {
		if yyv1886 == nil {
			yyv1886 = []Ingress{}
			yyc1886 = true
		} else if len(yyv1886) != 0 {
			yyv1886 = yyv1886[:0]
			yyc1886 = true
		}
	} else if yyl1886 > 0 {
		var yyrr1886, yyrl1886 int
		var yyrt1886 bool
		if yyl1886 > cap(yyv1886) {

			yyrg1886 := len(yyv1886) > 0
			yyv21886 := yyv1886
			yyrl1886, yyrt1886 = z.DecInferLen(yyl1886, z.DecBasicHandle().MaxInitLen, 336)
			if yyrt1886 {
				if yyrl1886 <= cap(yyv1886) {
					yyv1886 = yyv1886[:yyrl1886]
				} else {
					yyv1886 = make([]Ingress, yyrl1886)
				}
			} else {
				yyv1886 = make([]Ingress, yyrl1886)
			}
			yyc1886 = true
			yyrr1886 = len(yyv1886)
			if yyrg1886 {
				copy(yyv1886, yyv21886)
			}
		} else if yyl1886 != len(yyv1886) {
			yyv1886 = yyv1886[:yyl1886]
			yyc1886 = true
		}
		yyj1886 := 0
		for ; yyj1886 < yyrr1886; yyj1886++ {
			yyh1886.ElemContainerState(yyj1886)
			if r.TryDecodeAsNil() {
				yyv1886[yyj1886] = Ingress{}
			} else {
				yyv1887 := &yyv1886[yyj1886]
				yyv1887.CodecDecodeSelf(d)
			}

		}
		if yyrt1886 {
			for ; yyj1886 < yyl1886; yyj1886++ {
				yyv1886 = append(yyv1886, Ingress{})
				yyh1886.ElemContainerState(yyj1886)
				if r.TryDecodeAsNil() {
					yyv1886[yyj1886] = Ingress{}
				} else {
					yyv1888 := &yyv1886[yyj1886]
					yyv1888.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1886 := 0
		for ; !r.CheckBreak(); yyj1886++ {

			if yyj1886 >= len(yyv1886) {
				yyv1886 = append(yyv1886, Ingress{}) // var yyz1886 Ingress
				yyc1886 = true
			}
			yyh1886.ElemContainerState(yyj1886)
			if yyj1886 < len(yyv1886) {
				if r.TryDecodeAsNil() {
					yyv1886[yyj1886] = Ingress{}
				} else {
					yyv1889 := &yyv1886[yyj1886]
					yyv1889.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1886 < len(yyv1886) {
			yyv1886 = yyv1886[:yyj1886]
			yyc1886 = true
		} else if yyj1886 == 0 && yyv1886 == nil {
			yyv1886 = []Ingress{}
			yyc1886 = true
		}
	}
	yyh1886.End()
	if yyc1886 {
		*v = yyv1886
	}
}

func (x codecSelfer1234) encSliceIngressTLS(v []IngressTLS, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1890 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1891 := &yyv1890
		yy1891.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressTLS(v *[]IngressTLS, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1892 := *v
	yyh1892, yyl1892 := z.DecSliceHelperStart()
	var yyc1892 bool
	if yyl1892 == 0 {
		if yyv1892 == nil {
			yyv1892 = []IngressTLS{}
			yyc1892 = true
		} else if len(yyv1892) != 0 {
			yyv1892 = yyv1892[:0]
			yyc1892 = true
		}
	} else if yyl1892 > 0 {
		var yyrr1892, yyrl1892 int
		var yyrt1892 bool
		if yyl1892 > cap(yyv1892) {

			yyrg1892 := len(yyv1892) > 0
			yyv21892 := yyv1892
			yyrl1892, yyrt1892 = z.DecInferLen(yyl1892, z.DecBasicHandle().MaxInitLen, 40)
			if yyrt1892 {
				if yyrl1892 <= cap(yyv1892) {
					yyv1892 = yyv1892[:yyrl1892]
				} else {
					yyv1892 = make([]IngressTLS, yyrl1892)
				}
			} else {
				yyv1892 = make([]IngressTLS, yyrl1892)
			}
			yyc1892 = true
			yyrr1892 = len(yyv1892)
			if yyrg1892 {
				copy(yyv1892, yyv21892)
			}
		} else if yyl1892 != len(yyv1892) {
			yyv1892 = yyv1892[:yyl1892]
			yyc1892 = true
		}
		yyj1892 := 0
		for ; yyj1892 < yyrr1892; yyj1892++ {
			yyh1892.ElemContainerState(yyj1892)
			if r.TryDecodeAsNil() {
				yyv1892[yyj1892] = IngressTLS{}
			} else {
				yyv1893 := &yyv1892[yyj1892]
				yyv1893.CodecDecodeSelf(d)
			}

		}
		if yyrt1892 {
			for ; yyj1892 < yyl1892; yyj1892++ {
				yyv1892 = append(yyv1892, IngressTLS{})
				yyh1892.ElemContainerState(yyj1892)
				if r.TryDecodeAsNil() {
					yyv1892[yyj1892] = IngressTLS{}
				} else {
					yyv1894 := &yyv1892[yyj1892]
					yyv1894.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1892 := 0
		for ; !r.CheckBreak(); yyj1892++ {

			if yyj1892 >= len(yyv1892) {
				yyv1892 = append(yyv1892, IngressTLS{}) // var yyz1892 IngressTLS
				yyc1892 = true
			}
			yyh1892.ElemContainerState(yyj1892)
			if yyj1892 < len(yyv1892) {
				if r.TryDecodeAsNil() {
					yyv1892[yyj1892] = IngressTLS{}
				} else {
					yyv1895 := &yyv1892[yyj1892]
					yyv1895.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1892 < len(yyv1892) {
			yyv1892 = yyv1892[:yyj1892]
			yyc1892 = true
		} else if yyj1892 == 0 && yyv1892 == nil {
			yyv1892 = []IngressTLS{}
			yyc1892 = true
		}
	}
	yyh1892.End()
	if yyc1892 {
		*v = yyv1892
	}
}

func (x codecSelfer1234) encSliceIngressRule(v []IngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1896 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1897 := &yyv1896
		yy1897.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressRule(v *[]IngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1898 := *v
	yyh1898, yyl1898 := z.DecSliceHelperStart()
	var yyc1898 bool
	if yyl1898 == 0 {
		if yyv1898 == nil {
			yyv1898 = []IngressRule{}
			yyc1898 = true
		} else if len(yyv1898) != 0 {
			yyv1898 = yyv1898[:0]
			yyc1898 = true
		}
	} else if yyl1898 > 0 {
		var yyrr1898, yyrl1898 int
		var yyrt1898 bool
		if yyl1898 > cap(yyv1898) {

			yyrg1898 := len(yyv1898) > 0
			yyv21898 := yyv1898
			yyrl1898, yyrt1898 = z.DecInferLen(yyl1898, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1898 {
				if yyrl1898 <= cap(yyv1898) {
					yyv1898 = yyv1898[:yyrl1898]
				} else {
					yyv1898 = make([]IngressRule, yyrl1898)
				}
			} else {
				yyv1898 = make([]IngressRule, yyrl1898)
			}
			yyc1898 = true
			yyrr1898 = len(yyv1898)
			if yyrg1898 {
				copy(yyv1898, yyv21898)
			}
		} else if yyl1898 != len(yyv1898) {
			yyv1898 = yyv1898[:yyl1898]
			yyc1898 = true
		}
		yyj1898 := 0
		for ; yyj1898 < yyrr1898; yyj1898++ {
			yyh1898.ElemContainerState(yyj1898)
			if r.TryDecodeAsNil() {
				yyv1898[yyj1898] = IngressRule{}
			} else {
				yyv1899 := &yyv1898[yyj1898]
				yyv1899.CodecDecodeSelf(d)
			}

		}
		if yyrt1898 {
			for ; yyj1898 < yyl1898; yyj1898++ {
				yyv1898 = append(yyv1898, IngressRule{})
				yyh1898.ElemContainerState(yyj1898)
				if r.TryDecodeAsNil() {
					yyv1898[yyj1898] = IngressRule{}
				} else {
					yyv1900 := &yyv1898[yyj1898]
					yyv1900.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1898 := 0
		for ; !r.CheckBreak(); yyj1898++ {

			if yyj1898 >= len(yyv1898) {
				yyv1898 = append(yyv1898, IngressRule{}) // var yyz1898 IngressRule
				yyc1898 = true
			}
			yyh1898.ElemContainerState(yyj1898)
			if yyj1898 < len(yyv1898) {
				if r.TryDecodeAsNil() {
					yyv1898[yyj1898] = IngressRule{}
				} else {
					yyv1901 := &yyv1898[yyj1898]
					yyv1901.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1898 < len(yyv1898) {
			yyv1898 = yyv1898[:yyj1898]
			yyc1898 = true
		} else if yyj1898 == 0 && yyv1898 == nil {
			yyv1898 = []IngressRule{}
			yyc1898 = true
		}
	}
	yyh1898.End()
	if yyc1898 {
		*v = yyv1898
	}
}

func (x codecSelfer1234) encSliceHTTPIngressPath(v []HTTPIngressPath, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1902 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1903 := &yyv1902
		yy1903.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHTTPIngressPath(v *[]HTTPIngressPath, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1904 := *v
	yyh1904, yyl1904 := z.DecSliceHelperStart()
	var yyc1904 bool
	if yyl1904 == 0 {
		if yyv1904 == nil {
			yyv1904 = []HTTPIngressPath{}
			yyc1904 = true
		} else if len(yyv1904) != 0 {
			yyv1904 = yyv1904[:0]
			yyc1904 = true
		}
	} else if yyl1904 > 0 {
		var yyrr1904, yyrl1904 int
		var yyrt1904 bool
		if yyl1904 > cap(yyv1904) {

			yyrg1904 := len(yyv1904) > 0
			yyv21904 := yyv1904
			yyrl1904, yyrt1904 = z.DecInferLen(yyl1904, z.DecBasicHandle().MaxInitLen, 64)
			if yyrt1904 {
				if yyrl1904 <= cap(yyv1904) {
					yyv1904 = yyv1904[:yyrl1904]
				} else {
					yyv1904 = make([]HTTPIngressPath, yyrl1904)
				}
			} else {
				yyv1904 = make([]HTTPIngressPath, yyrl1904)
			}
			yyc1904 = true
			yyrr1904 = len(yyv1904)
			if yyrg1904 {
				copy(yyv1904, yyv21904)
			}
		} else if yyl1904 != len(yyv1904) {
			yyv1904 = yyv1904[:yyl1904]
			yyc1904 = true
		}
		yyj1904 := 0
		for ; yyj1904 < yyrr1904; yyj1904++ {
			yyh1904.ElemContainerState(yyj1904)
			if r.TryDecodeAsNil() {
				yyv1904[yyj1904] = HTTPIngressPath{}
			} else {
				yyv1905 := &yyv1904[yyj1904]
				yyv1905.CodecDecodeSelf(d)
			}

		}
		if yyrt1904 {
			for ; yyj1904 < yyl1904; yyj1904++ {
				yyv1904 = append(yyv1904, HTTPIngressPath{})
				yyh1904.ElemContainerState(yyj1904)
				if r.TryDecodeAsNil() {
					yyv1904[yyj1904] = HTTPIngressPath{}
				} else {
					yyv1906 := &yyv1904[yyj1904]
					yyv1906.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1904 := 0
		for ; !r.CheckBreak(); yyj1904++ {

			if yyj1904 >= len(yyv1904) {
				yyv1904 = append(yyv1904, HTTPIngressPath{}) // var yyz1904 HTTPIngressPath
				yyc1904 = true
			}
			yyh1904.ElemContainerState(yyj1904)
			if yyj1904 < len(yyv1904) {
				if r.TryDecodeAsNil() {
					yyv1904[yyj1904] = HTTPIngressPath{}
				} else {
					yyv1907 := &yyv1904[yyj1904]
					yyv1907.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1904 < len(yyv1904) {
			yyv1904 = yyv1904[:yyj1904]
			yyc1904 = true
		} else if yyj1904 == 0 && yyv1904 == nil {
			yyv1904 = []HTTPIngressPath{}
			yyc1904 = true
		}
	}
	yyh1904.End()
	if yyc1904 {
		*v = yyv1904
	}
}

func (x codecSelfer1234) encSliceLabelSelectorRequirement(v []LabelSelectorRequirement, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1908 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1909 := &yyv1908
		yy1909.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceLabelSelectorRequirement(v *[]LabelSelectorRequirement, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1910 := *v
	yyh1910, yyl1910 := z.DecSliceHelperStart()
	var yyc1910 bool
	if yyl1910 == 0 {
		if yyv1910 == nil {
			yyv1910 = []LabelSelectorRequirement{}
			yyc1910 = true
		} else if len(yyv1910) != 0 {
			yyv1910 = yyv1910[:0]
			yyc1910 = true
		}
	} else if yyl1910 > 0 {
		var yyrr1910, yyrl1910 int
		var yyrt1910 bool
		if yyl1910 > cap(yyv1910) {

			yyrg1910 := len(yyv1910) > 0
			yyv21910 := yyv1910
			yyrl1910, yyrt1910 = z.DecInferLen(yyl1910, z.DecBasicHandle().MaxInitLen, 56)
			if yyrt1910 {
				if yyrl1910 <= cap(yyv1910) {
					yyv1910 = yyv1910[:yyrl1910]
				} else {
					yyv1910 = make([]LabelSelectorRequirement, yyrl1910)
				}
			} else {
				yyv1910 = make([]LabelSelectorRequirement, yyrl1910)
			}
			yyc1910 = true
			yyrr1910 = len(yyv1910)
			if yyrg1910 {
				copy(yyv1910, yyv21910)
			}
		} else if yyl1910 != len(yyv1910) {
			yyv1910 = yyv1910[:yyl1910]
			yyc1910 = true
		}
		yyj1910 := 0
		for ; yyj1910 < yyrr1910; yyj1910++ {
			yyh1910.ElemContainerState(yyj1910)
			if r.TryDecodeAsNil() {
				yyv1910[yyj1910] = LabelSelectorRequirement{}
			} else {
				yyv1911 := &yyv1910[yyj1910]
				yyv1911.CodecDecodeSelf(d)
			}

		}
		if yyrt1910 {
			for ; yyj1910 < yyl1910; yyj1910++ {
				yyv1910 = append(yyv1910, LabelSelectorRequirement{})
				yyh1910.ElemContainerState(yyj1910)
				if r.TryDecodeAsNil() {
					yyv1910[yyj1910] = LabelSelectorRequirement{}
				} else {
					yyv1912 := &yyv1910[yyj1910]
					yyv1912.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1910 := 0
		for ; !r.CheckBreak(); yyj1910++ {

			if yyj1910 >= len(yyv1910) {
				yyv1910 = append(yyv1910, LabelSelectorRequirement{}) // var yyz1910 LabelSelectorRequirement
				yyc1910 = true
			}
			yyh1910.ElemContainerState(yyj1910)
			if yyj1910 < len(yyv1910) {
				if r.TryDecodeAsNil() {
					yyv1910[yyj1910] = LabelSelectorRequirement{}
				} else {
					yyv1913 := &yyv1910[yyj1910]
					yyv1913.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1910 < len(yyv1910) {
			yyv1910 = yyv1910[:yyj1910]
			yyc1910 = true
		} else if yyj1910 == 0 && yyv1910 == nil {
			yyv1910 = []LabelSelectorRequirement{}
			yyc1910 = true
		}
	}
	yyh1910.End()
	if yyc1910 {
		*v = yyv1910
	}
}

func (x codecSelfer1234) encSliceReplicaSet(v []ReplicaSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1914 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1915 := &yyv1914
		yy1915.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceReplicaSet(v *[]ReplicaSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1916 := *v
	yyh1916, yyl1916 := z.DecSliceHelperStart()
	var yyc1916 bool
	if yyl1916 == 0 {
		if yyv1916 == nil {
			yyv1916 = []ReplicaSet{}
			yyc1916 = true
		} else if len(yyv1916) != 0 {
			yyv1916 = yyv1916[:0]
			yyc1916 = true
		}
	} else if yyl1916 > 0 {
		var yyrr1916, yyrl1916 int
		var yyrt1916 bool
		if yyl1916 > cap(yyv1916) {

			yyrg1916 := len(yyv1916) > 0
			yyv21916 := yyv1916
			yyrl1916, yyrt1916 = z.DecInferLen(yyl1916, z.DecBasicHandle().MaxInitLen, 768)
			if yyrt1916 {
				if yyrl1916 <= cap(yyv1916) {
					yyv1916 = yyv1916[:yyrl1916]
				} else {
					yyv1916 = make([]ReplicaSet, yyrl1916)
				}
			} else {
				yyv1916 = make([]ReplicaSet, yyrl1916)
			}
			yyc1916 = true
			yyrr1916 = len(yyv1916)
			if yyrg1916 {
				copy(yyv1916, yyv21916)
			}
		} else if yyl1916 != len(yyv1916) {
			yyv1916 = yyv1916[:yyl1916]
			yyc1916 = true
		}
		yyj1916 := 0
		for ; yyj1916 < yyrr1916; yyj1916++ {
			yyh1916.ElemContainerState(yyj1916)
			if r.TryDecodeAsNil() {
				yyv1916[yyj1916] = ReplicaSet{}
			} else {
				yyv1917 := &yyv1916[yyj1916]
				yyv1917.CodecDecodeSelf(d)
			}

		}
		if yyrt1916 {
			for ; yyj1916 < yyl1916; yyj1916++ {
				yyv1916 = append(yyv1916, ReplicaSet{})
				yyh1916.ElemContainerState(yyj1916)
				if r.TryDecodeAsNil() {
					yyv1916[yyj1916] = ReplicaSet{}
				} else {
					yyv1918 := &yyv1916[yyj1916]
					yyv1918.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1916 := 0
		for ; !r.CheckBreak(); yyj1916++ {

			if yyj1916 >= len(yyv1916) {
				yyv1916 = append(yyv1916, ReplicaSet{}) // var yyz1916 ReplicaSet
				yyc1916 = true
			}
			yyh1916.ElemContainerState(yyj1916)
			if yyj1916 < len(yyv1916) {
				if r.TryDecodeAsNil() {
					yyv1916[yyj1916] = ReplicaSet{}
				} else {
					yyv1919 := &yyv1916[yyj1916]
					yyv1919.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1916 < len(yyv1916) {
			yyv1916 = yyv1916[:yyj1916]
			yyc1916 = true
		} else if yyj1916 == 0 && yyv1916 == nil {
			yyv1916 = []ReplicaSet{}
			yyc1916 = true
		}
	}
	yyh1916.End()
	if yyc1916 {
		*v = yyv1916
	}
}

func (x codecSelfer1234) encSlicev1_Capability(v []pkg2_v1.Capability, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1920 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yym1921 := z.EncBinary()
		_ = yym1921
		if false {
		} else if z.HasExtensions() && z.EncExt(yyv1920) {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1920))
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicev1_Capability(v *[]pkg2_v1.Capability, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1922 := *v
	yyh1922, yyl1922 := z.DecSliceHelperStart()
	var yyc1922 bool
	if yyl1922 == 0 {
		if yyv1922 == nil {
			yyv1922 = []pkg2_v1.Capability{}
			yyc1922 = true
		} else if len(yyv1922) != 0 {
			yyv1922 = yyv1922[:0]
			yyc1922 = true
		}
	} else if yyl1922 > 0 {
		var yyrr1922, yyrl1922 int
		var yyrt1922 bool
		if yyl1922 > cap(yyv1922) {

			yyrl1922, yyrt1922 = z.DecInferLen(yyl1922, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1922 {
				if yyrl1922 <= cap(yyv1922) {
					yyv1922 = yyv1922[:yyrl1922]
				} else {
					yyv1922 = make([]pkg2_v1.Capability, yyrl1922)
				}
			} else {
				yyv1922 = make([]pkg2_v1.Capability, yyrl1922)
			}
			yyc1922 = true
			yyrr1922 = len(yyv1922)
		} else if yyl1922 != len(yyv1922) {
			yyv1922 = yyv1922[:yyl1922]
			yyc1922 = true
		}
		yyj1922 := 0
		for ; yyj1922 < yyrr1922; yyj1922++ {
			yyh1922.ElemContainerState(yyj1922)
			if r.TryDecodeAsNil() {
				yyv1922[yyj1922] = ""
			} else {
				yyv1922[yyj1922] = pkg2_v1.Capability(r.DecodeString())
			}

		}
		if yyrt1922 {
			for ; yyj1922 < yyl1922; yyj1922++ {
				yyv1922 = append(yyv1922, "")
				yyh1922.ElemContainerState(yyj1922)
				if r.TryDecodeAsNil() {
					yyv1922[yyj1922] = ""
				} else {
					yyv1922[yyj1922] = pkg2_v1.Capability(r.DecodeString())
				}

			}
		}

	} else {
		yyj1922 := 0
		for ; !r.CheckBreak(); yyj1922++ {

			if yyj1922 >= len(yyv1922) {
				yyv1922 = append(yyv1922, "") // var yyz1922 pkg2_v1.Capability
				yyc1922 = true
			}
			yyh1922.ElemContainerState(yyj1922)
			if yyj1922 < len(yyv1922) {
				if r.TryDecodeAsNil() {
					yyv1922[yyj1922] = ""
				} else {
					yyv1922[yyj1922] = pkg2_v1.Capability(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1922 < len(yyv1922) {
			yyv1922 = yyv1922[:yyj1922]
			yyc1922 = true
		} else if yyj1922 == 0 && yyv1922 == nil {
			yyv1922 = []pkg2_v1.Capability{}
			yyc1922 = true
		}
	}
	yyh1922.End()
	if yyc1922 {
		*v = yyv1922
	}
}

func (x codecSelfer1234) encSliceFSType(v []FSType, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1926 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yyv1926.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceFSType(v *[]FSType, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1927 := *v
	yyh1927, yyl1927 := z.DecSliceHelperStart()
	var yyc1927 bool
	if yyl1927 == 0 {
		if yyv1927 == nil {
			yyv1927 = []FSType{}
			yyc1927 = true
		} else if len(yyv1927) != 0 {
			yyv1927 = yyv1927[:0]
			yyc1927 = true
		}
	} else if yyl1927 > 0 {
		var yyrr1927, yyrl1927 int
		var yyrt1927 bool
		if yyl1927 > cap(yyv1927) {

			yyrl1927, yyrt1927 = z.DecInferLen(yyl1927, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1927 {
				if yyrl1927 <= cap(yyv1927) {
					yyv1927 = yyv1927[:yyrl1927]
				} else {
					yyv1927 = make([]FSType, yyrl1927)
				}
			} else {
				yyv1927 = make([]FSType, yyrl1927)
			}
			yyc1927 = true
			yyrr1927 = len(yyv1927)
		} else if yyl1927 != len(yyv1927) {
			yyv1927 = yyv1927[:yyl1927]
			yyc1927 = true
		}
		yyj1927 := 0
		for ; yyj1927 < yyrr1927; yyj1927++ {
			yyh1927.ElemContainerState(yyj1927)
			if r.TryDecodeAsNil() {
				yyv1927[yyj1927] = ""
			} else {
				yyv1927[yyj1927] = FSType(r.DecodeString())
			}

		}
		if yyrt1927 {
			for ; yyj1927 < yyl1927; yyj1927++ {
				yyv1927 = append(yyv1927, "")
				yyh1927.ElemContainerState(yyj1927)
				if r.TryDecodeAsNil() {
					yyv1927[yyj1927] = ""
				} else {
					yyv1927[yyj1927] = FSType(r.DecodeString())
				}

			}
		}

	} else {
		yyj1927 := 0
		for ; !r.CheckBreak(); yyj1927++ {

			if yyj1927 >= len(yyv1927) {
				yyv1927 = append(yyv1927, "") // var yyz1927 FSType
				yyc1927 = true
			}
			yyh1927.ElemContainerState(yyj1927)
			if yyj1927 < len(yyv1927) {
				if r.TryDecodeAsNil() {
					yyv1927[yyj1927] = ""
				} else {
					yyv1927[yyj1927] = FSType(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1927 < len(yyv1927) {
			yyv1927 = yyv1927[:yyj1927]
			yyc1927 = true
		} else if yyj1927 == 0 && yyv1927 == nil {
			yyv1927 = []FSType{}
			yyc1927 = true
		}
	}
	yyh1927.End()
	if yyc1927 {
		*v = yyv1927
	}
}

func (x codecSelfer1234) encSliceHostPortRange(v []HostPortRange, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1931 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1932 := &yyv1931
		yy1932.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHostPortRange(v *[]HostPortRange, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1933 := *v
	yyh1933, yyl1933 := z.DecSliceHelperStart()
	var yyc1933 bool
	if yyl1933 == 0 {
		if yyv1933 == nil {
			yyv1933 = []HostPortRange{}
			yyc1933 = true
		} else if len(yyv1933) != 0 {
			yyv1933 = yyv1933[:0]
			yyc1933 = true
		}
	} else if yyl1933 > 0 {
		var yyrr1933, yyrl1933 int
		var yyrt1933 bool
		if yyl1933 > cap(yyv1933) {

			yyrg1933 := len(yyv1933) > 0
			yyv21933 := yyv1933
			yyrl1933, yyrt1933 = z.DecInferLen(yyl1933, z.DecBasicHandle().MaxInitLen, 8)
			if yyrt1933 {
				if yyrl1933 <= cap(yyv1933) {
					yyv1933 = yyv1933[:yyrl1933]
				} else {
					yyv1933 = make([]HostPortRange, yyrl1933)
				}
			} else {
				yyv1933 = make([]HostPortRange, yyrl1933)
			}
			yyc1933 = true
			yyrr1933 = len(yyv1933)
			if yyrg1933 {
				copy(yyv1933, yyv21933)
			}
		} else if yyl1933 != len(yyv1933) {
			yyv1933 = yyv1933[:yyl1933]
			yyc1933 = true
		}
		yyj1933 := 0
		for ; yyj1933 < yyrr1933; yyj1933++ {
			yyh1933.ElemContainerState(yyj1933)
			if r.TryDecodeAsNil() {
				yyv1933[yyj1933] = HostPortRange{}
			} else {
				yyv1934 := &yyv1933[yyj1933]
				yyv1934.CodecDecodeSelf(d)
			}

		}
		if yyrt1933 {
			for ; yyj1933 < yyl1933; yyj1933++ {
				yyv1933 = append(yyv1933, HostPortRange{})
				yyh1933.ElemContainerState(yyj1933)
				if r.TryDecodeAsNil() {
					yyv1933[yyj1933] = HostPortRange{}
				} else {
					yyv1935 := &yyv1933[yyj1933]
					yyv1935.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1933 := 0
		for ; !r.CheckBreak(); yyj1933++ {

			if yyj1933 >= len(yyv1933) {
				yyv1933 = append(yyv1933, HostPortRange{}) // var yyz1933 HostPortRange
				yyc1933 = true
			}
			yyh1933.ElemContainerState(yyj1933)
			if yyj1933 < len(yyv1933) {
				if r.TryDecodeAsNil() {
					yyv1933[yyj1933] = HostPortRange{}
				} else {
					yyv1936 := &yyv1933[yyj1933]
					yyv1936.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1933 < len(yyv1933) {
			yyv1933 = yyv1933[:yyj1933]
			yyc1933 = true
		} else if yyj1933 == 0 && yyv1933 == nil {
			yyv1933 = []HostPortRange{}
			yyc1933 = true
		}
	}
	yyh1933.End()
	if yyc1933 {
		*v = yyv1933
	}
}

func (x codecSelfer1234) encSliceIDRange(v []IDRange, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1937 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1938 := &yyv1937
		yy1938.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIDRange(v *[]IDRange, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1939 := *v
	yyh1939, yyl1939 := z.DecSliceHelperStart()
	var yyc1939 bool
	if yyl1939 == 0 {
		if yyv1939 == nil {
			yyv1939 = []IDRange{}
			yyc1939 = true
		} else if len(yyv1939) != 0 {
			yyv1939 = yyv1939[:0]
			yyc1939 = true
		}
	} else if yyl1939 > 0 {
		var yyrr1939, yyrl1939 int
		var yyrt1939 bool
		if yyl1939 > cap(yyv1939) {

			yyrg1939 := len(yyv1939) > 0
			yyv21939 := yyv1939
			yyrl1939, yyrt1939 = z.DecInferLen(yyl1939, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1939 {
				if yyrl1939 <= cap(yyv1939) {
					yyv1939 = yyv1939[:yyrl1939]
				} else {
					yyv1939 = make([]IDRange, yyrl1939)
				}
			} else {
				yyv1939 = make([]IDRange, yyrl1939)
			}
			yyc1939 = true
			yyrr1939 = len(yyv1939)
			if yyrg1939 {
				copy(yyv1939, yyv21939)
			}
		} else if yyl1939 != len(yyv1939) {
			yyv1939 = yyv1939[:yyl1939]
			yyc1939 = true
		}
		yyj1939 := 0
		for ; yyj1939 < yyrr1939; yyj1939++ {
			yyh1939.ElemContainerState(yyj1939)
			if r.TryDecodeAsNil() {
				yyv1939[yyj1939] = IDRange{}
			} else {
				yyv1940 := &yyv1939[yyj1939]
				yyv1940.CodecDecodeSelf(d)
			}

		}
		if yyrt1939 {
			for ; yyj1939 < yyl1939; yyj1939++ {
				yyv1939 = append(yyv1939, IDRange{})
				yyh1939.ElemContainerState(yyj1939)
				if r.TryDecodeAsNil() {
					yyv1939[yyj1939] = IDRange{}
				} else {
					yyv1941 := &yyv1939[yyj1939]
					yyv1941.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1939 := 0
		for ; !r.CheckBreak(); yyj1939++ {

			if yyj1939 >= len(yyv1939) {
				yyv1939 = append(yyv1939, IDRange{}) // var yyz1939 IDRange
				yyc1939 = true
			}
			yyh1939.ElemContainerState(yyj1939)
			if yyj1939 < len(yyv1939) {
				if r.TryDecodeAsNil() {
					yyv1939[yyj1939] = IDRange{}
				} else {
					yyv1942 := &yyv1939[yyj1939]
					yyv1942.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1939 < len(yyv1939) {
			yyv1939 = yyv1939[:yyj1939]
			yyc1939 = true
		} else if yyj1939 == 0 && yyv1939 == nil {
			yyv1939 = []IDRange{}
			yyc1939 = true
		}
	}
	yyh1939.End()
	if yyc1939 {
		*v = yyv1939
	}
}

func (x codecSelfer1234) encSlicePodSecurityPolicy(v []PodSecurityPolicy, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1943 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1944 := &yyv1943
		yy1944.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicePodSecurityPolicy(v *[]PodSecurityPolicy, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1945 := *v
	yyh1945, yyl1945 := z.DecSliceHelperStart()
	var yyc1945 bool
	if yyl1945 == 0 {
		if yyv1945 == nil {
			yyv1945 = []PodSecurityPolicy{}
			yyc1945 = true
		} else if len(yyv1945) != 0 {
			yyv1945 = yyv1945[:0]
			yyc1945 = true
		}
	} else if yyl1945 > 0 {
		var yyrr1945, yyrl1945 int
		var yyrt1945 bool
		if yyl1945 > cap(yyv1945) {

			yyrg1945 := len(yyv1945) > 0
			yyv21945 := yyv1945
			yyrl1945, yyrt1945 = z.DecInferLen(yyl1945, z.DecBasicHandle().MaxInitLen, 552)
			if yyrt1945 {
				if yyrl1945 <= cap(yyv1945) {
					yyv1945 = yyv1945[:yyrl1945]
				} else {
					yyv1945 = make([]PodSecurityPolicy, yyrl1945)
				}
			} else {
				yyv1945 = make([]PodSecurityPolicy, yyrl1945)
			}
			yyc1945 = true
			yyrr1945 = len(yyv1945)
			if yyrg1945 {
				copy(yyv1945, yyv21945)
			}
		} else if yyl1945 != len(yyv1945) {
			yyv1945 = yyv1945[:yyl1945]
			yyc1945 = true
		}
		yyj1945 := 0
		for ; yyj1945 < yyrr1945; yyj1945++ {
			yyh1945.ElemContainerState(yyj1945)
			if r.TryDecodeAsNil() {
				yyv1945[yyj1945] = PodSecurityPolicy{}
			} else {
				yyv1946 := &yyv1945[yyj1945]
				yyv1946.CodecDecodeSelf(d)
			}

		}
		if yyrt1945 {
			for ; yyj1945 < yyl1945; yyj1945++ {
				yyv1945 = append(yyv1945, PodSecurityPolicy{})
				yyh1945.ElemContainerState(yyj1945)
				if r.TryDecodeAsNil() {
					yyv1945[yyj1945] = PodSecurityPolicy{}
				} else {
					yyv1947 := &yyv1945[yyj1945]
					yyv1947.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1945 := 0
		for ; !r.CheckBreak(); yyj1945++ {

			if yyj1945 >= len(yyv1945) {
				yyv1945 = append(yyv1945, PodSecurityPolicy{}) // var yyz1945 PodSecurityPolicy
				yyc1945 = true
			}
			yyh1945.ElemContainerState(yyj1945)
			if yyj1945 < len(yyv1945) {
				if r.TryDecodeAsNil() {
					yyv1945[yyj1945] = PodSecurityPolicy{}
				} else {
					yyv1948 := &yyv1945[yyj1945]
					yyv1948.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1945 < len(yyv1945) {
			yyv1945 = yyv1945[:yyj1945]
			yyc1945 = true
		} else if yyj1945 == 0 && yyv1945 == nil {
			yyv1945 = []PodSecurityPolicy{}
			yyc1945 = true
		}
	}
	yyh1945.End()
	if yyc1945 {
		*v = yyv1945
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyIngressRule(v []NetworkPolicyIngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1949 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1950 := &yyv1949
		yy1950.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyIngressRule(v *[]NetworkPolicyIngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1951 := *v
	yyh1951, yyl1951 := z.DecSliceHelperStart()
	var yyc1951 bool
	if yyl1951 == 0 {
		if yyv1951 == nil {
			yyv1951 = []NetworkPolicyIngressRule{}
			yyc1951 = true
		} else if len(yyv1951) != 0 {
			yyv1951 = yyv1951[:0]
			yyc1951 = true
		}
	} else if yyl1951 > 0 {
		var yyrr1951, yyrl1951 int
		var yyrt1951 bool
		if yyl1951 > cap(yyv1951) {

			yyrg1951 := len(yyv1951) > 0
			yyv21951 := yyv1951
			yyrl1951, yyrt1951 = z.DecInferLen(yyl1951, z.DecBasicHandle().MaxInitLen, 48)
			if yyrt1951 {
				if yyrl1951 <= cap(yyv1951) {
					yyv1951 = yyv1951[:yyrl1951]
				} else {
					yyv1951 = make([]NetworkPolicyIngressRule, yyrl1951)
				}
			} else {
				yyv1951 = make([]NetworkPolicyIngressRule, yyrl1951)
			}
			yyc1951 = true
			yyrr1951 = len(yyv1951)
			if yyrg1951 {
				copy(yyv1951, yyv21951)
			}
		} else if yyl1951 != len(yyv1951) {
			yyv1951 = yyv1951[:yyl1951]
			yyc1951 = true
		}
		yyj1951 := 0
		for ; yyj1951 < yyrr1951; yyj1951++ {
			yyh1951.ElemContainerState(yyj1951)
			if r.TryDecodeAsNil() {
				yyv1951[yyj1951] = NetworkPolicyIngressRule{}
			} else {
				yyv1952 := &yyv1951[yyj1951]
				yyv1952.CodecDecodeSelf(d)
			}

		}
		if yyrt1951 {
			for ; yyj1951 < yyl1951; yyj1951++ {
				yyv1951 = append(yyv1951, NetworkPolicyIngressRule{})
				yyh1951.ElemContainerState(yyj1951)
				if r.TryDecodeAsNil() {
					yyv1951[yyj1951] = NetworkPolicyIngressRule{}
				} else {
					yyv1953 := &yyv1951[yyj1951]
					yyv1953.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1951 := 0
		for ; !r.CheckBreak(); yyj1951++ {

			if yyj1951 >= len(yyv1951) {
				yyv1951 = append(yyv1951, NetworkPolicyIngressRule{}) // var yyz1951 NetworkPolicyIngressRule
				yyc1951 = true
			}
			yyh1951.ElemContainerState(yyj1951)
			if yyj1951 < len(yyv1951) {
				if r.TryDecodeAsNil() {
					yyv1951[yyj1951] = NetworkPolicyIngressRule{}
				} else {
					yyv1954 := &yyv1951[yyj1951]
					yyv1954.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1951 < len(yyv1951) {
			yyv1951 = yyv1951[:yyj1951]
			yyc1951 = true
		} else if yyj1951 == 0 && yyv1951 == nil {
			yyv1951 = []NetworkPolicyIngressRule{}
			yyc1951 = true
		}
	}
	yyh1951.End()
	if yyc1951 {
		*v = yyv1951
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyPort(v []NetworkPolicyPort, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1955 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1956 := &yyv1955
		yy1956.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyPort(v *[]NetworkPolicyPort, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1957 := *v
	yyh1957, yyl1957 := z.DecSliceHelperStart()
	var yyc1957 bool
	if yyl1957 == 0 {
		if yyv1957 == nil {
			yyv1957 = []NetworkPolicyPort{}
			yyc1957 = true
		} else if len(yyv1957) != 0 {
			yyv1957 = yyv1957[:0]
			yyc1957 = true
		}
	} else if yyl1957 > 0 {
		var yyrr1957, yyrl1957 int
		var yyrt1957 bool
		if yyl1957 > cap(yyv1957) {

			yyrg1957 := len(yyv1957) > 0
			yyv21957 := yyv1957
			yyrl1957, yyrt1957 = z.DecInferLen(yyl1957, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1957 {
				if yyrl1957 <= cap(yyv1957) {
					yyv1957 = yyv1957[:yyrl1957]
				} else {
					yyv1957 = make([]NetworkPolicyPort, yyrl1957)
				}
			} else {
				yyv1957 = make([]NetworkPolicyPort, yyrl1957)
			}
			yyc1957 = true
			yyrr1957 = len(yyv1957)
			if yyrg1957 {
				copy(yyv1957, yyv21957)
			}
		} else if yyl1957 != len(yyv1957) {
			yyv1957 = yyv1957[:yyl1957]
			yyc1957 = true
		}
		yyj1957 := 0
		for ; yyj1957 < yyrr1957; yyj1957++ {
			yyh1957.ElemContainerState(yyj1957)
			if r.TryDecodeAsNil() {
				yyv1957[yyj1957] = NetworkPolicyPort{}
			} else {
				yyv1958 := &yyv1957[yyj1957]
				yyv1958.CodecDecodeSelf(d)
			}

		}
		if yyrt1957 {
			for ; yyj1957 < yyl1957; yyj1957++ {
				yyv1957 = append(yyv1957, NetworkPolicyPort{})
				yyh1957.ElemContainerState(yyj1957)
				if r.TryDecodeAsNil() {
					yyv1957[yyj1957] = NetworkPolicyPort{}
				} else {
					yyv1959 := &yyv1957[yyj1957]
					yyv1959.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1957 := 0
		for ; !r.CheckBreak(); yyj1957++ {

			if yyj1957 >= len(yyv1957) {
				yyv1957 = append(yyv1957, NetworkPolicyPort{}) // var yyz1957 NetworkPolicyPort
				yyc1957 = true
			}
			yyh1957.ElemContainerState(yyj1957)
			if yyj1957 < len(yyv1957) {
				if r.TryDecodeAsNil() {
					yyv1957[yyj1957] = NetworkPolicyPort{}
				} else {
					yyv1960 := &yyv1957[yyj1957]
					yyv1960.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1957 < len(yyv1957) {
			yyv1957 = yyv1957[:yyj1957]
			yyc1957 = true
		} else if yyj1957 == 0 && yyv1957 == nil {
			yyv1957 = []NetworkPolicyPort{}
			yyc1957 = true
		}
	}
	yyh1957.End()
	if yyc1957 {
		*v = yyv1957
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyPeer(v []NetworkPolicyPeer, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1961 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1962 := &yyv1961
		yy1962.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyPeer(v *[]NetworkPolicyPeer, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1963 := *v
	yyh1963, yyl1963 := z.DecSliceHelperStart()
	var yyc1963 bool
	if yyl1963 == 0 {
		if yyv1963 == nil {
			yyv1963 = []NetworkPolicyPeer{}
			yyc1963 = true
		} else if len(yyv1963) != 0 {
			yyv1963 = yyv1963[:0]
			yyc1963 = true
		}
	} else if yyl1963 > 0 {
		var yyrr1963, yyrl1963 int
		var yyrt1963 bool
		if yyl1963 > cap(yyv1963) {

			yyrg1963 := len(yyv1963) > 0
			yyv21963 := yyv1963
			yyrl1963, yyrt1963 = z.DecInferLen(yyl1963, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1963 {
				if yyrl1963 <= cap(yyv1963) {
					yyv1963 = yyv1963[:yyrl1963]
				} else {
					yyv1963 = make([]NetworkPolicyPeer, yyrl1963)
				}
			} else {
				yyv1963 = make([]NetworkPolicyPeer, yyrl1963)
			}
			yyc1963 = true
			yyrr1963 = len(yyv1963)
			if yyrg1963 {
				copy(yyv1963, yyv21963)
			}
		} else if yyl1963 != len(yyv1963) {
			yyv1963 = yyv1963[:yyl1963]
			yyc1963 = true
		}
		yyj1963 := 0
		for ; yyj1963 < yyrr1963; yyj1963++ {
			yyh1963.ElemContainerState(yyj1963)
			if r.TryDecodeAsNil() {
				yyv1963[yyj1963] = NetworkPolicyPeer{}
			} else {
				yyv1964 := &yyv1963[yyj1963]
				yyv1964.CodecDecodeSelf(d)
			}

		}
		if yyrt1963 {
			for ; yyj1963 < yyl1963; yyj1963++ {
				yyv1963 = append(yyv1963, NetworkPolicyPeer{})
				yyh1963.ElemContainerState(yyj1963)
				if r.TryDecodeAsNil() {
					yyv1963[yyj1963] = NetworkPolicyPeer{}
				} else {
					yyv1965 := &yyv1963[yyj1963]
					yyv1965.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1963 := 0
		for ; !r.CheckBreak(); yyj1963++ {

			if yyj1963 >= len(yyv1963) {
				yyv1963 = append(yyv1963, NetworkPolicyPeer{}) // var yyz1963 NetworkPolicyPeer
				yyc1963 = true
			}
			yyh1963.ElemContainerState(yyj1963)
			if yyj1963 < len(yyv1963) {
				if r.TryDecodeAsNil() {
					yyv1963[yyj1963] = NetworkPolicyPeer{}
				} else {
					yyv1966 := &yyv1963[yyj1963]
					yyv1966.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1963 < len(yyv1963) {
			yyv1963 = yyv1963[:yyj1963]
			yyc1963 = true
		} else if yyj1963 == 0 && yyv1963 == nil {
			yyv1963 = []NetworkPolicyPeer{}
			yyc1963 = true
		}
	}
	yyh1963.End()
	if yyc1963 {
		*v = yyv1963
	}
}

func (x codecSelfer1234) encSliceNetworkPolicy(v []NetworkPolicy, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1967 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1968 := &yyv1967
		yy1968.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicy(v *[]NetworkPolicy, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1969 := *v
	yyh1969, yyl1969 := z.DecSliceHelperStart()
	var yyc1969 bool
	if yyl1969 == 0 {
		if yyv1969 == nil {
			yyv1969 = []NetworkPolicy{}
			yyc1969 = true
		} else if len(yyv1969) != 0 {
			yyv1969 = yyv1969[:0]
			yyc1969 = true
		}
	} else if yyl1969 > 0 {
		var yyrr1969, yyrl1969 int
		var yyrt1969 bool
		if yyl1969 > cap(yyv1969) {

			yyrg1969 := len(yyv1969) > 0
			yyv21969 := yyv1969
			yyrl1969, yyrt1969 = z.DecInferLen(yyl1969, z.DecBasicHandle().MaxInitLen, 312)
			if yyrt1969 {
				if yyrl1969 <= cap(yyv1969) {
					yyv1969 = yyv1969[:yyrl1969]
				} else {
					yyv1969 = make([]NetworkPolicy, yyrl1969)
				}
			} else {
				yyv1969 = make([]NetworkPolicy, yyrl1969)
			}
			yyc1969 = true
			yyrr1969 = len(yyv1969)
			if yyrg1969 {
				copy(yyv1969, yyv21969)
			}
		} else if yyl1969 != len(yyv1969) {
			yyv1969 = yyv1969[:yyl1969]
			yyc1969 = true
		}
		yyj1969 := 0
		for ; yyj1969 < yyrr1969; yyj1969++ {
			yyh1969.ElemContainerState(yyj1969)
			if r.TryDecodeAsNil() {
				yyv1969[yyj1969] = NetworkPolicy{}
			} else {
				yyv1970 := &yyv1969[yyj1969]
				yyv1970.CodecDecodeSelf(d)
			}

		}
		if yyrt1969 {
			for ; yyj1969 < yyl1969; yyj1969++ {
				yyv1969 = append(yyv1969, NetworkPolicy{})
				yyh1969.ElemContainerState(yyj1969)
				if r.TryDecodeAsNil() {
					yyv1969[yyj1969] = NetworkPolicy{}
				} else {
					yyv1971 := &yyv1969[yyj1969]
					yyv1971.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1969 := 0
		for ; !r.CheckBreak(); yyj1969++ {

			if yyj1969 >= len(yyv1969) {
				yyv1969 = append(yyv1969, NetworkPolicy{}) // var yyz1969 NetworkPolicy
				yyc1969 = true
			}
			yyh1969.ElemContainerState(yyj1969)
			if yyj1969 < len(yyv1969) {
				if r.TryDecodeAsNil() {
					yyv1969[yyj1969] = NetworkPolicy{}
				} else {
					yyv1972 := &yyv1969[yyj1969]
					yyv1972.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1969 < len(yyv1969) {
			yyv1969 = yyv1969[:yyj1969]
			yyc1969 = true
		} else if yyj1969 == 0 && yyv1969 == nil {
			yyv1969 = []NetworkPolicy{}
			yyc1969 = true
		}
	}
	yyh1969.End()
	if yyc1969 {
		*v = yyv1969
	}
}

func (x codecSelfer1234) encSliceStorageClass(v []StorageClass, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1973 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1974 := &yyv1973
		yy1974.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceStorageClass(v *[]StorageClass, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1975 := *v
	yyh1975, yyl1975 := z.DecSliceHelperStart()
	var yyc1975 bool
	if yyl1975 == 0 {
		if yyv1975 == nil {
			yyv1975 = []StorageClass{}
			yyc1975 = true
		} else if len(yyv1975) != 0 {
			yyv1975 = yyv1975[:0]
			yyc1975 = true
		}
	} else if yyl1975 > 0 {
		var yyrr1975, yyrl1975 int
		var yyrt1975 bool
		if yyl1975 > cap(yyv1975) {

			yyrg1975 := len(yyv1975) > 0
			yyv21975 := yyv1975
			yyrl1975, yyrt1975 = z.DecInferLen(yyl1975, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt1975 {
				if yyrl1975 <= cap(yyv1975) {
					yyv1975 = yyv1975[:yyrl1975]
				} else {
					yyv1975 = make([]StorageClass, yyrl1975)
				}
			} else {
				yyv1975 = make([]StorageClass, yyrl1975)
			}
			yyc1975 = true
			yyrr1975 = len(yyv1975)
			if yyrg1975 {
				copy(yyv1975, yyv21975)
			}
		} else if yyl1975 != len(yyv1975) {
			yyv1975 = yyv1975[:yyl1975]
			yyc1975 = true
		}
		yyj1975 := 0
		for ; yyj1975 < yyrr1975; yyj1975++ {
			yyh1975.ElemContainerState(yyj1975)
			if r.TryDecodeAsNil() {
				yyv1975[yyj1975] = StorageClass{}
			} else {
				yyv1976 := &yyv1975[yyj1975]
				yyv1976.CodecDecodeSelf(d)
			}

		}
		if yyrt1975 {
			for ; yyj1975 < yyl1975; yyj1975++ {
				yyv1975 = append(yyv1975, StorageClass{})
				yyh1975.ElemContainerState(yyj1975)
				if r.TryDecodeAsNil() {
					yyv1975[yyj1975] = StorageClass{}
				} else {
					yyv1977 := &yyv1975[yyj1975]
					yyv1977.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1975 := 0
		for ; !r.CheckBreak(); yyj1975++ {

			if yyj1975 >= len(yyv1975) {
				yyv1975 = append(yyv1975, StorageClass{}) // var yyz1975 StorageClass
				yyc1975 = true
			}
			yyh1975.ElemContainerState(yyj1975)
			if yyj1975 < len(yyv1975) {
				if r.TryDecodeAsNil() {
					yyv1975[yyj1975] = StorageClass{}
				} else {
					yyv1978 := &yyv1975[yyj1975]
					yyv1978.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1975 < len(yyv1975) {
			yyv1975 = yyv1975[:yyj1975]
			yyc1975 = true
		} else if yyj1975 == 0 && yyv1975 == nil {
			yyv1975 = []StorageClass{}
			yyc1975 = true
		}
	}
	yyh1975.End()
	if yyc1975 {
		*v = yyv1975
	}
}
