// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package xray_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/xray"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleXRay_BatchGetTraces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := xray.New(sess)

	params := &xray.BatchGetTracesInput{
		TraceIds: []*string{ // Required
			aws.String("TraceId"), // Required
			// More values...
		},
		NextToken: aws.String("String"),
	}
	resp, err := svc.BatchGetTraces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleXRay_GetServiceGraph() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := xray.New(sess)

	params := &xray.GetServiceGraphInput{
		EndTime:   aws.Time(time.Now()), // Required
		StartTime: aws.Time(time.Now()), // Required
		NextToken: aws.String("String"),
	}
	resp, err := svc.GetServiceGraph(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleXRay_GetTraceGraph() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := xray.New(sess)

	params := &xray.GetTraceGraphInput{
		TraceIds: []*string{ // Required
			aws.String("TraceId"), // Required
			// More values...
		},
		NextToken: aws.String("String"),
	}
	resp, err := svc.GetTraceGraph(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleXRay_GetTraceSummaries() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := xray.New(sess)

	params := &xray.GetTraceSummariesInput{
		EndTime:          aws.Time(time.Now()), // Required
		StartTime:        aws.Time(time.Now()), // Required
		FilterExpression: aws.String("FilterExpression"),
		NextToken:        aws.String("String"),
		Sampling:         aws.Bool(true),
	}
	resp, err := svc.GetTraceSummaries(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleXRay_PutTelemetryRecords() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := xray.New(sess)

	params := &xray.PutTelemetryRecordsInput{
		TelemetryRecords: []*xray.TelemetryRecord{ // Required
			{ // Required
				BackendConnectionErrors: &xray.BackendConnectionErrors{
					ConnectionRefusedCount: aws.Int64(1),
					HTTPCode4XXCount:       aws.Int64(1),
					HTTPCode5XXCount:       aws.Int64(1),
					OtherCount:             aws.Int64(1),
					TimeoutCount:           aws.Int64(1),
					UnknownHostCount:       aws.Int64(1),
				},
				SegmentsReceivedCount:  aws.Int64(1),
				SegmentsRejectedCount:  aws.Int64(1),
				SegmentsSentCount:      aws.Int64(1),
				SegmentsSpilloverCount: aws.Int64(1),
				Timestamp:              aws.Time(time.Now()),
			},
			// More values...
		},
		EC2InstanceId: aws.String("String"),
		Hostname:      aws.String("String"),
		ResourceARN:   aws.String("String"),
	}
	resp, err := svc.PutTelemetryRecords(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleXRay_PutTraceSegments() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := xray.New(sess)

	params := &xray.PutTraceSegmentsInput{
		TraceSegmentDocuments: []*string{ // Required
			aws.String("TraceSegmentDocument"), // Required
			// More values...
		},
	}
	resp, err := svc.PutTraceSegments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
