// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package redshift provides a client for Amazon Redshift.
package redshift

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAuthorizeClusterSecurityGroupIngress = "AuthorizeClusterSecurityGroupIngress"

// AuthorizeClusterSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeClusterSecurityGroupIngress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AuthorizeClusterSecurityGroupIngress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AuthorizeClusterSecurityGroupIngress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AuthorizeClusterSecurityGroupIngressRequest method.
//    req, resp := client.AuthorizeClusterSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress
func (c *Redshift) AuthorizeClusterSecurityGroupIngressRequest(input *AuthorizeClusterSecurityGroupIngressInput) (req *request.Request, output *AuthorizeClusterSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeClusterSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeClusterSecurityGroupIngressInput{}
	}

	output = &AuthorizeClusterSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeClusterSecurityGroupIngress API operation for Amazon Redshift.
//
// Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending
// on whether the application accessing your cluster is running on the Internet
// or an Amazon EC2 instance, you can authorize inbound access to either a Classless
// Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2
// security group. You can add as many as 20 ingress rules to an Amazon Redshift
// security group.
//
// If you authorize access to an Amazon EC2 security group, specify EC2SecurityGroupName
// and EC2SecurityGroupOwnerId. The Amazon EC2 security group and Amazon Redshift
// cluster must be in the same AWS region.
//
// If you authorize access to a CIDR/IP address range, specify CIDRIP. For an
// overview of CIDR blocks, see the Wikipedia article on Classless Inter-Domain
// Routing (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// You must also associate the security group with a cluster so that clients
// running on these IP addresses or the EC2 instance are authorized to connect
// to the cluster. For information about managing security groups, go to Working
// with Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation AuthorizeClusterSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ClusterSecurityGroupNotFound
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * InvalidClusterSecurityGroupState
//   The state of the cluster security group is not available.
//
//   * AuthorizationAlreadyExists
//   The specified CIDR block or EC2 security group is already authorized for
//   the specified cluster security group.
//
//   * AuthorizationQuotaExceeded
//   The authorization quota for the cluster security group has been reached.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress
func (c *Redshift) AuthorizeClusterSecurityGroupIngress(input *AuthorizeClusterSecurityGroupIngressInput) (*AuthorizeClusterSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeClusterSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opAuthorizeSnapshotAccess = "AuthorizeSnapshotAccess"

// AuthorizeSnapshotAccessRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeSnapshotAccess operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AuthorizeSnapshotAccess for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AuthorizeSnapshotAccess method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AuthorizeSnapshotAccessRequest method.
//    req, resp := client.AuthorizeSnapshotAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess
func (c *Redshift) AuthorizeSnapshotAccessRequest(input *AuthorizeSnapshotAccessInput) (req *request.Request, output *AuthorizeSnapshotAccessOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSnapshotAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSnapshotAccessInput{}
	}

	output = &AuthorizeSnapshotAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeSnapshotAccess API operation for Amazon Redshift.
//
// Authorizes the specified AWS customer account to restore the specified snapshot.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation AuthorizeSnapshotAccess for usage and error information.
//
// Returned Error Codes:
//   * ClusterSnapshotNotFound
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * AuthorizationAlreadyExists
//   The specified CIDR block or EC2 security group is already authorized for
//   the specified cluster security group.
//
//   * AuthorizationQuotaExceeded
//   The authorization quota for the cluster security group has been reached.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
//   * InvalidClusterSnapshotState
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * LimitExceededFault
//   The encryption key has exceeded its grant limit in AWS KMS.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess
func (c *Redshift) AuthorizeSnapshotAccess(input *AuthorizeSnapshotAccessInput) (*AuthorizeSnapshotAccessOutput, error) {
	req, out := c.AuthorizeSnapshotAccessRequest(input)
	err := req.Send()
	return out, err
}

const opCopyClusterSnapshot = "CopyClusterSnapshot"

// CopyClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopyClusterSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CopyClusterSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CopyClusterSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CopyClusterSnapshotRequest method.
//    req, resp := client.CopyClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot
func (c *Redshift) CopyClusterSnapshotRequest(input *CopyClusterSnapshotInput) (req *request.Request, output *CopyClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyClusterSnapshotInput{}
	}

	output = &CopyClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyClusterSnapshot API operation for Amazon Redshift.
//
// Copies the specified automated cluster snapshot to a new manual cluster snapshot.
// The source must be an automated snapshot and it must be in the available
// state.
//
// When you delete a cluster, Amazon Redshift deletes any automated snapshots
// of the cluster. Also, when the retention period of the snapshot expires,
// Amazon Redshift automatically deletes it. If you want to keep an automated
// snapshot for a longer period, you can make a manual copy of the snapshot.
// Manual snapshots are retained until you delete them.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CopyClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ClusterSnapshotAlreadyExists
//   The value specified as a snapshot identifier is already used by an existing
//   snapshot.
//
//   * ClusterSnapshotNotFound
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * InvalidClusterSnapshotState
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ClusterSnapshotQuotaExceeded
//   The request would result in the user exceeding the allowed number of cluster
//   snapshots.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot
func (c *Redshift) CopyClusterSnapshot(input *CopyClusterSnapshotInput) (*CopyClusterSnapshotOutput, error) {
	req, out := c.CopyClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateCluster for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateCluster method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster
func (c *Redshift) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon Redshift.
//
// Creates a new cluster.
//
// To create the cluster in Virtual Private Cloud (VPC), you must provide a
// cluster subnet group name. The cluster subnet group identifies the subnets
// of your VPC that Amazon Redshift uses when creating the cluster. For more
// information about managing clusters, go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateCluster for usage and error information.
//
// Returned Error Codes:
//   * ClusterAlreadyExists
//   The account already has a cluster with the given identifier.
//
//   * InsufficientClusterCapacity
//   The number of nodes specified exceeds the allotted capacity of the cluster.
//
//   * ClusterParameterGroupNotFound
//   The parameter group name does not refer to an existing parameter group.
//
//   * ClusterSecurityGroupNotFound
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * ClusterQuotaExceeded
//   The request would exceed the allowed number of cluster instances for this
//   account. For information about increasing your quota, go to Limits in Amazon
//   Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * NumberOfNodesQuotaExceeded
//   The operation would exceed the number of nodes allotted to the account. For
//   information about increasing your quota, go to Limits in Amazon Redshift
//   (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * NumberOfNodesPerClusterLimitExceeded
//   The operation would exceed the number of nodes allowed for a cluster.
//
//   * ClusterSubnetGroupNotFoundFault
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
//   * InvalidVPCNetworkStateFault
//   The cluster subnet group does not cover all Availability Zones.
//
//   * InvalidClusterSubnetGroupStateFault
//   The cluster subnet group cannot be deleted because it is in use.
//
//   * InvalidSubnet
//   The requested subnet is not valid, or not all of the subnets are in the same
//   VPC.
//
//   * UnauthorizedOperation
//   Your account is not authorized to perform the requested operation.
//
//   * HsmClientCertificateNotFoundFault
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
//   * HsmConfigurationNotFoundFault
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
//   * InvalidElasticIpFault
//   The Elastic IP (EIP) is invalid or cannot be found.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
//   * LimitExceededFault
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster
func (c *Redshift) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	err := req.Send()
	return out, err
}

const opCreateClusterParameterGroup = "CreateClusterParameterGroup"

// CreateClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterParameterGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateClusterParameterGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateClusterParameterGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateClusterParameterGroupRequest method.
//    req, resp := client.CreateClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup
func (c *Redshift) CreateClusterParameterGroupRequest(input *CreateClusterParameterGroupInput) (req *request.Request, output *CreateClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterParameterGroupInput{}
	}

	output = &CreateClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterParameterGroup API operation for Amazon Redshift.
//
// Creates an Amazon Redshift parameter group.
//
// Creating parameter groups is independent of creating clusters. You can associate
// a cluster with a parameter group when you create the cluster. You can also
// associate an existing cluster with a parameter group after the cluster is
// created by using ModifyCluster.
//
// Parameters in the parameter group define specific behavior that applies to
// the databases you create on the cluster. For more information about parameters
// and parameter groups, go to Amazon Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ClusterParameterGroupQuotaExceeded
//   The request would result in the user exceeding the allowed number of cluster
//   parameter groups. For information about increasing your quota, go to Limits
//   in Amazon Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ClusterParameterGroupAlreadyExists
//   A cluster parameter group with the same name already exists.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup
func (c *Redshift) CreateClusterParameterGroup(input *CreateClusterParameterGroupInput) (*CreateClusterParameterGroupOutput, error) {
	req, out := c.CreateClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateClusterSecurityGroup = "CreateClusterSecurityGroup"

// CreateClusterSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterSecurityGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateClusterSecurityGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateClusterSecurityGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateClusterSecurityGroupRequest method.
//    req, resp := client.CreateClusterSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup
func (c *Redshift) CreateClusterSecurityGroupRequest(input *CreateClusterSecurityGroupInput) (req *request.Request, output *CreateClusterSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSecurityGroupInput{}
	}

	output = &CreateClusterSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterSecurityGroup API operation for Amazon Redshift.
//
// Creates a new Amazon Redshift security group. You use security groups to
// control access to non-VPC clusters.
//
// For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateClusterSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ClusterSecurityGroupAlreadyExists
//   A cluster security group with the same name already exists.
//
//   * QuotaExceeded.ClusterSecurityGroup
//   The request would result in the user exceeding the allowed number of cluster
//   security groups. For information about increasing your quota, go to Limits
//   in Amazon Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup
func (c *Redshift) CreateClusterSecurityGroup(input *CreateClusterSecurityGroupInput) (*CreateClusterSecurityGroupOutput, error) {
	req, out := c.CreateClusterSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateClusterSnapshot = "CreateClusterSnapshot"

// CreateClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateClusterSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateClusterSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateClusterSnapshotRequest method.
//    req, resp := client.CreateClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot
func (c *Redshift) CreateClusterSnapshotRequest(input *CreateClusterSnapshotInput) (req *request.Request, output *CreateClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSnapshotInput{}
	}

	output = &CreateClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterSnapshot API operation for Amazon Redshift.
//
// Creates a manual snapshot of the specified cluster. The cluster must be in
// the available state.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ClusterSnapshotAlreadyExists
//   The value specified as a snapshot identifier is already used by an existing
//   snapshot.
//
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ClusterSnapshotQuotaExceeded
//   The request would result in the user exceeding the allowed number of cluster
//   snapshots.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot
func (c *Redshift) CreateClusterSnapshot(input *CreateClusterSnapshotInput) (*CreateClusterSnapshotOutput, error) {
	req, out := c.CreateClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateClusterSubnetGroup = "CreateClusterSubnetGroup"

// CreateClusterSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterSubnetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateClusterSubnetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateClusterSubnetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateClusterSubnetGroupRequest method.
//    req, resp := client.CreateClusterSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup
func (c *Redshift) CreateClusterSubnetGroupRequest(input *CreateClusterSubnetGroupInput) (req *request.Request, output *CreateClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterSubnetGroupInput{}
	}

	output = &CreateClusterSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterSubnetGroup API operation for Amazon Redshift.
//
// Creates a new Amazon Redshift subnet group. You must provide a list of one
// or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC)
// when creating Amazon Redshift subnet group.
//
// For information about subnet groups, go to Amazon Redshift Cluster Subnet
// Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateClusterSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ClusterSubnetGroupAlreadyExists
//   A ClusterSubnetGroupName is already used by an existing cluster subnet group.
//
//   * ClusterSubnetGroupQuotaExceeded
//   The request would result in user exceeding the allowed number of cluster
//   subnet groups. For information about increasing your quota, go to Limits
//   in Amazon Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ClusterSubnetQuotaExceededFault
//   The request would result in user exceeding the allowed number of subnets
//   in a cluster subnet groups. For information about increasing your quota,
//   go to Limits in Amazon Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * InvalidSubnet
//   The requested subnet is not valid, or not all of the subnets are in the same
//   VPC.
//
//   * UnauthorizedOperation
//   Your account is not authorized to perform the requested operation.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup
func (c *Redshift) CreateClusterSubnetGroup(input *CreateClusterSubnetGroupInput) (*CreateClusterSubnetGroupOutput, error) {
	req, out := c.CreateClusterSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateEventSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateEventSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateEventSubscriptionRequest method.
//    req, resp := client.CreateEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription
func (c *Redshift) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	output = &CreateEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSubscription API operation for Amazon Redshift.
//
// Creates an Amazon Redshift event notification subscription. This action requires
// an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the
// Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To
// obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and
// subscribe to the topic. The ARN is displayed in the SNS console.
//
// You can specify the source type, and lists of Amazon Redshift source IDs,
// event categories, and event severities. Notifications will be sent for all
// events you want that match those criteria. For example, you can specify source
// type = cluster, source ID = my-cluster-1 and mycluster2, event categories
// = Availability, Backup, and severity = ERROR. The subscription will only
// send notifications for those ERROR events in the Availability and Backup
// categories for the specified clusters.
//
// If you specify both the source type and source IDs, such as source type =
// cluster and source identifier = my-cluster-1, notifications will be sent
// for all the cluster events for my-cluster-1. If you specify a source type
// but do not specify a source identifier, you will receive notice of the events
// for the objects of that type in your AWS account. If you do not specify either
// the SourceType nor the SourceIdentifier, you will be notified of events generated
// from all Amazon Redshift sources belonging to your AWS account. You must
// specify a source type if you specify a source ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * EventSubscriptionQuotaExceeded
//   The request would exceed the allowed number of event subscriptions for this
//   account. For information about increasing your quota, go to Limits in Amazon
//   Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * SubscriptionAlreadyExist
//   There is already an existing event notification subscription with the specified
//   name.
//
//   * SNSInvalidTopic
//   Amazon SNS has responded that there is a problem with the specified Amazon
//   SNS topic.
//
//   * SNSNoAuthorization
//   You do not have permission to publish to the specified Amazon SNS topic.
//
//   * SNSTopicArnNotFound
//   An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
//   exist.
//
//   * SubscriptionEventIdNotFound
//   An Amazon Redshift event with the specified event ID does not exist.
//
//   * SubscriptionCategoryNotFound
//   The value specified for the event category was not one of the allowed values,
//   or it specified a category that does not apply to the specified source type.
//   The allowed values are Configuration, Management, Monitoring, and Security.
//
//   * SubscriptionSeverityNotFound
//   The value specified for the event severity was not one of the allowed values,
//   or it specified a severity that does not apply to the specified source type.
//   The allowed values are ERROR and INFO.
//
//   * SourceNotFound
//   The specified Amazon Redshift event source could not be found.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription
func (c *Redshift) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHsmClientCertificate = "CreateHsmClientCertificate"

// CreateHsmClientCertificateRequest generates a "aws/request.Request" representing the
// client's request for the CreateHsmClientCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateHsmClientCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateHsmClientCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateHsmClientCertificateRequest method.
//    req, resp := client.CreateHsmClientCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate
func (c *Redshift) CreateHsmClientCertificateRequest(input *CreateHsmClientCertificateInput) (req *request.Request, output *CreateHsmClientCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateHsmClientCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmClientCertificateInput{}
	}

	output = &CreateHsmClientCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHsmClientCertificate API operation for Amazon Redshift.
//
// Creates an HSM client certificate that an Amazon Redshift cluster will use
// to connect to the client's HSM in order to store and retrieve the keys used
// to encrypt the cluster databases.
//
// The command returns a public key, which you must store in the HSM. In addition
// to creating the HSM certificate, you must create an Amazon Redshift HSM configuration
// that provides a cluster the information needed to store and use encryption
// keys in the HSM. For more information, go to Hardware Security Modules (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateHsmClientCertificate for usage and error information.
//
// Returned Error Codes:
//   * HsmClientCertificateAlreadyExistsFault
//   There is already an existing Amazon Redshift HSM client certificate with
//   the specified identifier.
//
//   * HsmClientCertificateQuotaExceededFault
//   The quota for HSM client certificates has been reached. For information about
//   increasing your quota, go to Limits in Amazon Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate
func (c *Redshift) CreateHsmClientCertificate(input *CreateHsmClientCertificateInput) (*CreateHsmClientCertificateOutput, error) {
	req, out := c.CreateHsmClientCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHsmConfiguration = "CreateHsmConfiguration"

// CreateHsmConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateHsmConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateHsmConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateHsmConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateHsmConfigurationRequest method.
//    req, resp := client.CreateHsmConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration
func (c *Redshift) CreateHsmConfigurationRequest(input *CreateHsmConfigurationInput) (req *request.Request, output *CreateHsmConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateHsmConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmConfigurationInput{}
	}

	output = &CreateHsmConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHsmConfiguration API operation for Amazon Redshift.
//
// Creates an HSM configuration that contains the information required by an
// Amazon Redshift cluster to store and use database encryption keys in a Hardware
// Security Module (HSM). After creating the HSM configuration, you can specify
// it as a parameter when creating a cluster. The cluster will then store its
// encryption keys in the HSM.
//
// In addition to creating an HSM configuration, you must also create an HSM
// client certificate. For more information, go to Hardware Security Modules
// (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html) in
// the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateHsmConfiguration for usage and error information.
//
// Returned Error Codes:
//   * HsmConfigurationAlreadyExistsFault
//   There is already an existing Amazon Redshift HSM configuration with the specified
//   identifier.
//
//   * HsmConfigurationQuotaExceededFault
//   The quota for HSM configurations has been reached. For information about
//   increasing your quota, go to Limits in Amazon Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration
func (c *Redshift) CreateHsmConfiguration(input *CreateHsmConfigurationInput) (*CreateHsmConfigurationOutput, error) {
	req, out := c.CreateHsmConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshotCopyGrant = "CreateSnapshotCopyGrant"

// CreateSnapshotCopyGrantRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshotCopyGrant operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSnapshotCopyGrant for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSnapshotCopyGrant method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSnapshotCopyGrantRequest method.
//    req, resp := client.CreateSnapshotCopyGrantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant
func (c *Redshift) CreateSnapshotCopyGrantRequest(input *CreateSnapshotCopyGrantInput) (req *request.Request, output *CreateSnapshotCopyGrantOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshotCopyGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotCopyGrantInput{}
	}

	output = &CreateSnapshotCopyGrantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshotCopyGrant API operation for Amazon Redshift.
//
// Creates a snapshot copy grant that permits Amazon Redshift to use a customer
// master key (CMK) from AWS Key Management Service (AWS KMS) to encrypt copied
// snapshots in a destination region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateSnapshotCopyGrant for usage and error information.
//
// Returned Error Codes:
//   * SnapshotCopyGrantAlreadyExistsFault
//   The snapshot copy grant can't be created because a grant with the same name
//   already exists.
//
//   * SnapshotCopyGrantQuotaExceededFault
//   The AWS account has exceeded the maximum number of snapshot copy grants in
//   this region.
//
//   * LimitExceededFault
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * InvalidTagFault
//   The tag is invalid.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant
func (c *Redshift) CreateSnapshotCopyGrant(input *CreateSnapshotCopyGrantInput) (*CreateSnapshotCopyGrantOutput, error) {
	req, out := c.CreateSnapshotCopyGrantRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags
func (c *Redshift) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon Redshift.
//
// Adds one or more tags to a specified resource.
//
// A resource can have up to 10 tags. If you try to create more than 10 tags
// for a resource, you will receive an error and the attempt will fail.
//
// If you specify a key that already exists for the resource, the value for
// that key will be updated with the new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation CreateTags for usage and error information.
//
// Returned Error Codes:
//   * TagLimitExceededFault
//   The request exceeds the limit of 10 tags for the resource.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags
func (c *Redshift) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteCluster for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteCluster method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteClusterRequest method.
//    req, resp := client.DeleteClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster
func (c *Redshift) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon Redshift.
//
// Deletes a previously provisioned cluster. A successful response from the
// web service indicates that the request was received correctly. Use DescribeClusters
// to monitor the status of the deletion. The delete operation cannot be canceled
// or reverted once submitted. For more information about managing clusters,
// go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you want to shut down the cluster and retain it for future use, set SkipFinalClusterSnapshot
// to false and specify a name for FinalClusterSnapshotIdentifier. You can later
// restore this snapshot to resume using the cluster. If a final cluster snapshot
// is requested, the status of the cluster will be "final-snapshot" while the
// snapshot is being taken, then it's "deleting" once Amazon Redshift begins
// deleting the cluster.
//
// For more information about managing clusters, go to Amazon Redshift Clusters
// (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * ClusterSnapshotAlreadyExists
//   The value specified as a snapshot identifier is already used by an existing
//   snapshot.
//
//   * ClusterSnapshotQuotaExceeded
//   The request would result in the user exceeding the allowed number of cluster
//   snapshots.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster
func (c *Redshift) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClusterParameterGroup = "DeleteClusterParameterGroup"

// DeleteClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterParameterGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteClusterParameterGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteClusterParameterGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteClusterParameterGroupRequest method.
//    req, resp := client.DeleteClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup
func (c *Redshift) DeleteClusterParameterGroupRequest(input *DeleteClusterParameterGroupInput) (req *request.Request, output *DeleteClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterParameterGroupInput{}
	}

	output = &DeleteClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClusterParameterGroup API operation for Amazon Redshift.
//
// Deletes a specified Amazon Redshift parameter group.
//
// You cannot delete a parameter group if it is associated with a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * InvalidClusterParameterGroupState
//   The cluster parameter group action can not be completed because another task
//   is in progress that involves the parameter group. Wait a few moments and
//   try the operation again.
//
//   * ClusterParameterGroupNotFound
//   The parameter group name does not refer to an existing parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup
func (c *Redshift) DeleteClusterParameterGroup(input *DeleteClusterParameterGroupInput) (*DeleteClusterParameterGroupOutput, error) {
	req, out := c.DeleteClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClusterSecurityGroup = "DeleteClusterSecurityGroup"

// DeleteClusterSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterSecurityGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteClusterSecurityGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteClusterSecurityGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteClusterSecurityGroupRequest method.
//    req, resp := client.DeleteClusterSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup
func (c *Redshift) DeleteClusterSecurityGroupRequest(input *DeleteClusterSecurityGroupInput) (req *request.Request, output *DeleteClusterSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSecurityGroupInput{}
	}

	output = &DeleteClusterSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClusterSecurityGroup API operation for Amazon Redshift.
//
// Deletes an Amazon Redshift security group.
//
// You cannot delete a security group that is associated with any clusters.
// You cannot delete the default security group.
//
// For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteClusterSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * InvalidClusterSecurityGroupState
//   The state of the cluster security group is not available.
//
//   * ClusterSecurityGroupNotFound
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup
func (c *Redshift) DeleteClusterSecurityGroup(input *DeleteClusterSecurityGroupInput) (*DeleteClusterSecurityGroupOutput, error) {
	req, out := c.DeleteClusterSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClusterSnapshot = "DeleteClusterSnapshot"

// DeleteClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteClusterSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteClusterSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteClusterSnapshotRequest method.
//    req, resp := client.DeleteClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot
func (c *Redshift) DeleteClusterSnapshotRequest(input *DeleteClusterSnapshotInput) (req *request.Request, output *DeleteClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSnapshotInput{}
	}

	output = &DeleteClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteClusterSnapshot API operation for Amazon Redshift.
//
// Deletes the specified manual snapshot. The snapshot must be in the available
// state, with no other users authorized to access the snapshot.
//
// Unlike automated snapshots, manual snapshots are retained even after you
// delete your cluster. Amazon Redshift does not delete your manual snapshots.
// You must delete manual snapshot explicitly to avoid getting charged. If other
// accounts are authorized to access the snapshot, you must revoke all of the
// authorizations before you can delete the snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * InvalidClusterSnapshotState
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * ClusterSnapshotNotFound
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot
func (c *Redshift) DeleteClusterSnapshot(input *DeleteClusterSnapshotInput) (*DeleteClusterSnapshotOutput, error) {
	req, out := c.DeleteClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteClusterSubnetGroup = "DeleteClusterSubnetGroup"

// DeleteClusterSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterSubnetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteClusterSubnetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteClusterSubnetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteClusterSubnetGroupRequest method.
//    req, resp := client.DeleteClusterSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup
func (c *Redshift) DeleteClusterSubnetGroupRequest(input *DeleteClusterSubnetGroupInput) (req *request.Request, output *DeleteClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSubnetGroupInput{}
	}

	output = &DeleteClusterSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClusterSubnetGroup API operation for Amazon Redshift.
//
// Deletes the specified cluster subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteClusterSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * InvalidClusterSubnetGroupStateFault
//   The cluster subnet group cannot be deleted because it is in use.
//
//   * InvalidClusterSubnetStateFault
//   The state of the subnet is invalid.
//
//   * ClusterSubnetGroupNotFoundFault
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup
func (c *Redshift) DeleteClusterSubnetGroup(input *DeleteClusterSubnetGroupInput) (*DeleteClusterSubnetGroupOutput, error) {
	req, out := c.DeleteClusterSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteEventSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteEventSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteEventSubscriptionRequest method.
//    req, resp := client.DeleteEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription
func (c *Redshift) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	output = &DeleteEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventSubscription API operation for Amazon Redshift.
//
// Deletes an Amazon Redshift event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * SubscriptionNotFound
//   An Amazon Redshift event notification subscription with the specified name
//   does not exist.
//
//   * InvalidSubscriptionStateFault
//   The subscription request is invalid because it is a duplicate request. This
//   subscription request is already in progress.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription
func (c *Redshift) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHsmClientCertificate = "DeleteHsmClientCertificate"

// DeleteHsmClientCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHsmClientCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteHsmClientCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteHsmClientCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteHsmClientCertificateRequest method.
//    req, resp := client.DeleteHsmClientCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate
func (c *Redshift) DeleteHsmClientCertificateRequest(input *DeleteHsmClientCertificateInput) (req *request.Request, output *DeleteHsmClientCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteHsmClientCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmClientCertificateInput{}
	}

	output = &DeleteHsmClientCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHsmClientCertificate API operation for Amazon Redshift.
//
// Deletes the specified HSM client certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteHsmClientCertificate for usage and error information.
//
// Returned Error Codes:
//   * InvalidHsmClientCertificateStateFault
//   The specified HSM client certificate is not in the available state, or it
//   is still in use by one or more Amazon Redshift clusters.
//
//   * HsmClientCertificateNotFoundFault
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate
func (c *Redshift) DeleteHsmClientCertificate(input *DeleteHsmClientCertificateInput) (*DeleteHsmClientCertificateOutput, error) {
	req, out := c.DeleteHsmClientCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHsmConfiguration = "DeleteHsmConfiguration"

// DeleteHsmConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHsmConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteHsmConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteHsmConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteHsmConfigurationRequest method.
//    req, resp := client.DeleteHsmConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration
func (c *Redshift) DeleteHsmConfigurationRequest(input *DeleteHsmConfigurationInput) (req *request.Request, output *DeleteHsmConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteHsmConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmConfigurationInput{}
	}

	output = &DeleteHsmConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHsmConfiguration API operation for Amazon Redshift.
//
// Deletes the specified Amazon Redshift HSM configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteHsmConfiguration for usage and error information.
//
// Returned Error Codes:
//   * InvalidHsmConfigurationStateFault
//   The specified HSM configuration is not in the available state, or it is still
//   in use by one or more Amazon Redshift clusters.
//
//   * HsmConfigurationNotFoundFault
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration
func (c *Redshift) DeleteHsmConfiguration(input *DeleteHsmConfigurationInput) (*DeleteHsmConfigurationOutput, error) {
	req, out := c.DeleteHsmConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshotCopyGrant = "DeleteSnapshotCopyGrant"

// DeleteSnapshotCopyGrantRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshotCopyGrant operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSnapshotCopyGrant for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSnapshotCopyGrant method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSnapshotCopyGrantRequest method.
//    req, resp := client.DeleteSnapshotCopyGrantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant
func (c *Redshift) DeleteSnapshotCopyGrantRequest(input *DeleteSnapshotCopyGrantInput) (req *request.Request, output *DeleteSnapshotCopyGrantOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshotCopyGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotCopyGrantInput{}
	}

	output = &DeleteSnapshotCopyGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSnapshotCopyGrant API operation for Amazon Redshift.
//
// Deletes the specified snapshot copy grant.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteSnapshotCopyGrant for usage and error information.
//
// Returned Error Codes:
//   * InvalidSnapshotCopyGrantStateFault
//   The snapshot copy grant can't be deleted because it is used by one or more
//   clusters.
//
//   * SnapshotCopyGrantNotFoundFault
//   The specified snapshot copy grant can't be found. Make sure that the name
//   is typed correctly and that the grant exists in the destination region.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant
func (c *Redshift) DeleteSnapshotCopyGrant(input *DeleteSnapshotCopyGrantInput) (*DeleteSnapshotCopyGrantOutput, error) {
	req, out := c.DeleteSnapshotCopyGrantRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags
func (c *Redshift) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon Redshift.
//
// Deletes a tag or tags from a resource. You must provide the ARN of the resource
// from which you want to delete the tag or tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags
func (c *Redshift) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeClusterParameterGroups = "DescribeClusterParameterGroups"

// DescribeClusterParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterParameterGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeClusterParameterGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeClusterParameterGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClusterParameterGroupsRequest method.
//    req, resp := client.DescribeClusterParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups
func (c *Redshift) DescribeClusterParameterGroupsRequest(input *DescribeClusterParameterGroupsInput) (req *request.Request, output *DescribeClusterParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterParameterGroupsInput{}
	}

	output = &DescribeClusterParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterParameterGroups API operation for Amazon Redshift.
//
// Returns a list of Amazon Redshift parameter groups, including parameter groups
// you created and the default parameter group. For each parameter group, the
// response includes the parameter group name, description, and parameter group
// family name. You can optionally specify a name to retrieve the description
// of a specific parameter group.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all parameter groups that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all parameter groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, parameter groups
// are returned regardless of whether they have tag keys or values associated
// with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ClusterParameterGroupNotFound
//   The parameter group name does not refer to an existing parameter group.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups
func (c *Redshift) DescribeClusterParameterGroups(input *DescribeClusterParameterGroupsInput) (*DescribeClusterParameterGroupsOutput, error) {
	req, out := c.DescribeClusterParameterGroupsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeClusterParameterGroupsPages iterates over the pages of a DescribeClusterParameterGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterParameterGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterParameterGroups operation.
//    pageNum := 0
//    err := client.DescribeClusterParameterGroupsPages(params,
//        func(page *DescribeClusterParameterGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterParameterGroupsPages(input *DescribeClusterParameterGroupsInput, fn func(p *DescribeClusterParameterGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterParameterGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterParameterGroupsOutput), lastPage)
	})
}

const opDescribeClusterParameters = "DescribeClusterParameters"

// DescribeClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterParameters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeClusterParameters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeClusterParameters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClusterParametersRequest method.
//    req, resp := client.DescribeClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters
func (c *Redshift) DescribeClusterParametersRequest(input *DescribeClusterParametersInput) (req *request.Request, output *DescribeClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterParametersInput{}
	}

	output = &DescribeClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterParameters API operation for Amazon Redshift.
//
// Returns a detailed list of parameters contained within the specified Amazon
// Redshift parameter group. For each parameter the response includes information
// such as parameter name, description, data type, value, whether the parameter
// value is modifiable, and so on.
//
// You can specify source filter to retrieve parameters of only specific type.
// For example, to retrieve parameters that were modified by a user action such
// as from ModifyClusterParameterGroup, you can specify source equal to user.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterParameters for usage and error information.
//
// Returned Error Codes:
//   * ClusterParameterGroupNotFound
//   The parameter group name does not refer to an existing parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters
func (c *Redshift) DescribeClusterParameters(input *DescribeClusterParametersInput) (*DescribeClusterParametersOutput, error) {
	req, out := c.DescribeClusterParametersRequest(input)
	err := req.Send()
	return out, err
}

// DescribeClusterParametersPages iterates over the pages of a DescribeClusterParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterParameters operation.
//    pageNum := 0
//    err := client.DescribeClusterParametersPages(params,
//        func(page *DescribeClusterParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterParametersPages(input *DescribeClusterParametersInput, fn func(p *DescribeClusterParametersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterParametersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterParametersOutput), lastPage)
	})
}

const opDescribeClusterSecurityGroups = "DescribeClusterSecurityGroups"

// DescribeClusterSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterSecurityGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeClusterSecurityGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeClusterSecurityGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClusterSecurityGroupsRequest method.
//    req, resp := client.DescribeClusterSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups
func (c *Redshift) DescribeClusterSecurityGroupsRequest(input *DescribeClusterSecurityGroupsInput) (req *request.Request, output *DescribeClusterSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSecurityGroupsInput{}
	}

	output = &DescribeClusterSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterSecurityGroups API operation for Amazon Redshift.
//
// Returns information about Amazon Redshift security groups. If the name of
// a security group is specified, the response will contain only information
// about only that security group.
//
// For information about managing security groups, go to Amazon Redshift Cluster
// Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all security groups that match any combination of the specified keys
// and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all security groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, security groups
// are returned regardless of whether they have tag keys or values associated
// with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterSecurityGroups for usage and error information.
//
// Returned Error Codes:
//   * ClusterSecurityGroupNotFound
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups
func (c *Redshift) DescribeClusterSecurityGroups(input *DescribeClusterSecurityGroupsInput) (*DescribeClusterSecurityGroupsOutput, error) {
	req, out := c.DescribeClusterSecurityGroupsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeClusterSecurityGroupsPages iterates over the pages of a DescribeClusterSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterSecurityGroups operation.
//    pageNum := 0
//    err := client.DescribeClusterSecurityGroupsPages(params,
//        func(page *DescribeClusterSecurityGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterSecurityGroupsPages(input *DescribeClusterSecurityGroupsInput, fn func(p *DescribeClusterSecurityGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterSecurityGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterSecurityGroupsOutput), lastPage)
	})
}

const opDescribeClusterSnapshots = "DescribeClusterSnapshots"

// DescribeClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterSnapshots operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeClusterSnapshots for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeClusterSnapshots method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClusterSnapshotsRequest method.
//    req, resp := client.DescribeClusterSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots
func (c *Redshift) DescribeClusterSnapshotsRequest(input *DescribeClusterSnapshotsInput) (req *request.Request, output *DescribeClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSnapshotsInput{}
	}

	output = &DescribeClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterSnapshots API operation for Amazon Redshift.
//
// Returns one or more snapshot objects, which contain metadata about your cluster
// snapshots. By default, this operation returns information about all snapshots
// of all clusters that are owned by you AWS customer account. No information
// is returned for snapshots owned by inactive AWS customer accounts.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all snapshots that match any combination of the specified keys and
// values. For example, if you have owner and environment for tag keys, and
// admin and test for tag values, all snapshots that have any combination of
// those values are returned. Only snapshots that you own are returned in the
// response; shared snapshots are not returned with the tag key and tag value
// request parameters.
//
// If both tag keys and values are omitted from the request, snapshots are returned
// regardless of whether they have tag keys or values associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ClusterSnapshotNotFound
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots
func (c *Redshift) DescribeClusterSnapshots(input *DescribeClusterSnapshotsInput) (*DescribeClusterSnapshotsOutput, error) {
	req, out := c.DescribeClusterSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeClusterSnapshotsPages iterates over the pages of a DescribeClusterSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterSnapshots operation.
//    pageNum := 0
//    err := client.DescribeClusterSnapshotsPages(params,
//        func(page *DescribeClusterSnapshotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterSnapshotsPages(input *DescribeClusterSnapshotsInput, fn func(p *DescribeClusterSnapshotsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterSnapshotsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterSnapshotsOutput), lastPage)
	})
}

const opDescribeClusterSubnetGroups = "DescribeClusterSubnetGroups"

// DescribeClusterSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterSubnetGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeClusterSubnetGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeClusterSubnetGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClusterSubnetGroupsRequest method.
//    req, resp := client.DescribeClusterSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups
func (c *Redshift) DescribeClusterSubnetGroupsRequest(input *DescribeClusterSubnetGroupsInput) (req *request.Request, output *DescribeClusterSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterSubnetGroupsInput{}
	}

	output = &DescribeClusterSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterSubnetGroups API operation for Amazon Redshift.
//
// Returns one or more cluster subnet group objects, which contain metadata
// about your cluster subnet groups. By default, this operation returns information
// about all cluster subnet groups that are defined in you AWS account.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all subnet groups that match any combination of the specified keys
// and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all subnet groups that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, subnet groups are
// returned regardless of whether they have tag keys or values associated with
// them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ClusterSubnetGroupNotFoundFault
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups
func (c *Redshift) DescribeClusterSubnetGroups(input *DescribeClusterSubnetGroupsInput) (*DescribeClusterSubnetGroupsOutput, error) {
	req, out := c.DescribeClusterSubnetGroupsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeClusterSubnetGroupsPages iterates over the pages of a DescribeClusterSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeClusterSubnetGroupsPages(params,
//        func(page *DescribeClusterSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterSubnetGroupsPages(input *DescribeClusterSubnetGroupsInput, fn func(p *DescribeClusterSubnetGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterSubnetGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterSubnetGroupsOutput), lastPage)
	})
}

const opDescribeClusterVersions = "DescribeClusterVersions"

// DescribeClusterVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusterVersions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeClusterVersions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeClusterVersions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClusterVersionsRequest method.
//    req, resp := client.DescribeClusterVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions
func (c *Redshift) DescribeClusterVersionsRequest(input *DescribeClusterVersionsInput) (req *request.Request, output *DescribeClusterVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeClusterVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClusterVersionsInput{}
	}

	output = &DescribeClusterVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusterVersions API operation for Amazon Redshift.
//
// Returns descriptions of the available Amazon Redshift cluster versions. You
// can call this operation even before creating any clusters to learn more about
// the Amazon Redshift versions. For more information about managing clusters,
// go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusterVersions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions
func (c *Redshift) DescribeClusterVersions(input *DescribeClusterVersionsInput) (*DescribeClusterVersionsOutput, error) {
	req, out := c.DescribeClusterVersionsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeClusterVersionsPages iterates over the pages of a DescribeClusterVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusterVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusterVersions operation.
//    pageNum := 0
//    err := client.DescribeClusterVersionsPages(params,
//        func(page *DescribeClusterVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClusterVersionsPages(input *DescribeClusterVersionsInput, fn func(p *DescribeClusterVersionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClusterVersionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClusterVersionsOutput), lastPage)
	})
}

const opDescribeClusters = "DescribeClusters"

// DescribeClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeClusters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeClusters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeClustersRequest method.
//    req, resp := client.DescribeClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters
func (c *Redshift) DescribeClustersRequest(input *DescribeClustersInput) (req *request.Request, output *DescribeClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClustersInput{}
	}

	output = &DescribeClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusters API operation for Amazon Redshift.
//
// Returns properties of provisioned clusters including general cluster properties,
// cluster database properties, maintenance and backup properties, and security
// and access properties. This operation supports pagination. For more information
// about managing clusters, go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all clusters that match any combination of the specified keys and
// values. For example, if you have owner and environment for tag keys, and
// admin and test for tag values, all clusters that have any combination of
// those values are returned.
//
// If both tag keys and values are omitted from the request, clusters are returned
// regardless of whether they have tag keys or values associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeClusters for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters
func (c *Redshift) DescribeClusters(input *DescribeClustersInput) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	err := req.Send()
	return out, err
}

// DescribeClustersPages iterates over the pages of a DescribeClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeClusters operation.
//    pageNum := 0
//    err := client.DescribeClustersPages(params,
//        func(page *DescribeClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeClustersPages(input *DescribeClustersInput, fn func(p *DescribeClustersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeClustersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeClustersOutput), lastPage)
	})
}

const opDescribeDefaultClusterParameters = "DescribeDefaultClusterParameters"

// DescribeDefaultClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDefaultClusterParameters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeDefaultClusterParameters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeDefaultClusterParameters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeDefaultClusterParametersRequest method.
//    req, resp := client.DescribeDefaultClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters
func (c *Redshift) DescribeDefaultClusterParametersRequest(input *DescribeDefaultClusterParametersInput) (req *request.Request, output *DescribeDefaultClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDefaultClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"DefaultClusterParameters.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDefaultClusterParametersInput{}
	}

	output = &DescribeDefaultClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDefaultClusterParameters API operation for Amazon Redshift.
//
// Returns a list of parameter settings for the specified parameter group family.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeDefaultClusterParameters for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters
func (c *Redshift) DescribeDefaultClusterParameters(input *DescribeDefaultClusterParametersInput) (*DescribeDefaultClusterParametersOutput, error) {
	req, out := c.DescribeDefaultClusterParametersRequest(input)
	err := req.Send()
	return out, err
}

// DescribeDefaultClusterParametersPages iterates over the pages of a DescribeDefaultClusterParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDefaultClusterParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDefaultClusterParameters operation.
//    pageNum := 0
//    err := client.DescribeDefaultClusterParametersPages(params,
//        func(page *DescribeDefaultClusterParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeDefaultClusterParametersPages(input *DescribeDefaultClusterParametersInput, fn func(p *DescribeDefaultClusterParametersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDefaultClusterParametersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDefaultClusterParametersOutput), lastPage)
	})
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeEventCategories for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeEventCategories method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeEventCategoriesRequest method.
//    req, resp := client.DescribeEventCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories
func (c *Redshift) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for Amazon Redshift.
//
// Displays a list of event categories for all event source types, or for a
// specified source type. For a list of the event categories and source types,
// go to Amazon Redshift Event Notifications (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeEventCategories for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories
func (c *Redshift) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSubscriptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeEventSubscriptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeEventSubscriptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeEventSubscriptionsRequest method.
//    req, resp := client.DescribeEventSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions
func (c *Redshift) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	output = &DescribeEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSubscriptions API operation for Amazon Redshift.
//
// Lists descriptions of all the Amazon Redshift event notifications subscription
// for a customer account. If you specify a subscription name, lists the description
// for that subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeEventSubscriptions for usage and error information.
//
// Returned Error Codes:
//   * SubscriptionNotFound
//   An Amazon Redshift event notification subscription with the specified name
//   does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions
func (c *Redshift) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeEventSubscriptionsPages iterates over the pages of a DescribeEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventSubscriptions operation.
//    pageNum := 0
//    err := client.DescribeEventSubscriptionsPages(params,
//        func(page *DescribeEventSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(p *DescribeEventSubscriptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEventSubscriptionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEventSubscriptionsOutput), lastPage)
	})
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeEvents for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeEvents method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents
func (c *Redshift) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon Redshift.
//
// Returns events related to clusters, security groups, snapshots, and parameter
// groups for the past 14 days. Events specific to a particular cluster, security
// group, snapshot or parameter group can be obtained by providing the name
// as a parameter. By default, the past hour of events are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeEvents for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents
func (c *Redshift) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeEventsPages(input *DescribeEventsInput, fn func(p *DescribeEventsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEventsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEventsOutput), lastPage)
	})
}

const opDescribeHsmClientCertificates = "DescribeHsmClientCertificates"

// DescribeHsmClientCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHsmClientCertificates operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeHsmClientCertificates for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeHsmClientCertificates method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeHsmClientCertificatesRequest method.
//    req, resp := client.DescribeHsmClientCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates
func (c *Redshift) DescribeHsmClientCertificatesRequest(input *DescribeHsmClientCertificatesInput) (req *request.Request, output *DescribeHsmClientCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeHsmClientCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHsmClientCertificatesInput{}
	}

	output = &DescribeHsmClientCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHsmClientCertificates API operation for Amazon Redshift.
//
// Returns information about the specified HSM client certificate. If no certificate
// ID is specified, returns information about all the HSM certificates owned
// by your AWS customer account.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all HSM client certificates that match any combination of the specified
// keys and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all HSM client certificates that have
// any combination of those values are returned.
//
// If both tag keys and values are omitted from the request, HSM client certificates
// are returned regardless of whether they have tag keys or values associated
// with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeHsmClientCertificates for usage and error information.
//
// Returned Error Codes:
//   * HsmClientCertificateNotFoundFault
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates
func (c *Redshift) DescribeHsmClientCertificates(input *DescribeHsmClientCertificatesInput) (*DescribeHsmClientCertificatesOutput, error) {
	req, out := c.DescribeHsmClientCertificatesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeHsmClientCertificatesPages iterates over the pages of a DescribeHsmClientCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHsmClientCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeHsmClientCertificates operation.
//    pageNum := 0
//    err := client.DescribeHsmClientCertificatesPages(params,
//        func(page *DescribeHsmClientCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeHsmClientCertificatesPages(input *DescribeHsmClientCertificatesInput, fn func(p *DescribeHsmClientCertificatesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeHsmClientCertificatesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeHsmClientCertificatesOutput), lastPage)
	})
}

const opDescribeHsmConfigurations = "DescribeHsmConfigurations"

// DescribeHsmConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHsmConfigurations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeHsmConfigurations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeHsmConfigurations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeHsmConfigurationsRequest method.
//    req, resp := client.DescribeHsmConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations
func (c *Redshift) DescribeHsmConfigurationsRequest(input *DescribeHsmConfigurationsInput) (req *request.Request, output *DescribeHsmConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeHsmConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHsmConfigurationsInput{}
	}

	output = &DescribeHsmConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHsmConfigurations API operation for Amazon Redshift.
//
// Returns information about the specified Amazon Redshift HSM configuration.
// If no configuration ID is specified, returns information about all the HSM
// configurations owned by your AWS customer account.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all HSM connections that match any combination of the specified keys
// and values. For example, if you have owner and environment for tag keys,
// and admin and test for tag values, all HSM connections that have any combination
// of those values are returned.
//
// If both tag keys and values are omitted from the request, HSM connections
// are returned regardless of whether they have tag keys or values associated
// with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeHsmConfigurations for usage and error information.
//
// Returned Error Codes:
//   * HsmConfigurationNotFoundFault
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations
func (c *Redshift) DescribeHsmConfigurations(input *DescribeHsmConfigurationsInput) (*DescribeHsmConfigurationsOutput, error) {
	req, out := c.DescribeHsmConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeHsmConfigurationsPages iterates over the pages of a DescribeHsmConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHsmConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeHsmConfigurations operation.
//    pageNum := 0
//    err := client.DescribeHsmConfigurationsPages(params,
//        func(page *DescribeHsmConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeHsmConfigurationsPages(input *DescribeHsmConfigurationsInput, fn func(p *DescribeHsmConfigurationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeHsmConfigurationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeHsmConfigurationsOutput), lastPage)
	})
}

const opDescribeLoggingStatus = "DescribeLoggingStatus"

// DescribeLoggingStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoggingStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLoggingStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLoggingStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLoggingStatusRequest method.
//    req, resp := client.DescribeLoggingStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus
func (c *Redshift) DescribeLoggingStatusRequest(input *DescribeLoggingStatusInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opDescribeLoggingStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoggingStatusInput{}
	}

	output = &LoggingStatus{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoggingStatus API operation for Amazon Redshift.
//
// Describes whether information, such as queries and connection attempts, is
// being logged for the specified Amazon Redshift cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeLoggingStatus for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus
func (c *Redshift) DescribeLoggingStatus(input *DescribeLoggingStatusInput) (*LoggingStatus, error) {
	req, out := c.DescribeLoggingStatusRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeOrderableClusterOptions = "DescribeOrderableClusterOptions"

// DescribeOrderableClusterOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableClusterOptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeOrderableClusterOptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeOrderableClusterOptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeOrderableClusterOptionsRequest method.
//    req, resp := client.DescribeOrderableClusterOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions
func (c *Redshift) DescribeOrderableClusterOptionsRequest(input *DescribeOrderableClusterOptionsInput) (req *request.Request, output *DescribeOrderableClusterOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableClusterOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableClusterOptionsInput{}
	}

	output = &DescribeOrderableClusterOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableClusterOptions API operation for Amazon Redshift.
//
// Returns a list of orderable cluster options. Before you create a new cluster
// you can use this operation to find what options are available, such as the
// EC2 Availability Zones (AZ) in the specific AWS region that you can specify,
// and the node types you can request. The node types differ by available storage,
// memory, CPU and price. With the cost involved you might want to obtain a
// list of cluster options in the specific region and specify values when creating
// a cluster. For more information about managing clusters, go to Amazon Redshift
// Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeOrderableClusterOptions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions
func (c *Redshift) DescribeOrderableClusterOptions(input *DescribeOrderableClusterOptionsInput) (*DescribeOrderableClusterOptionsOutput, error) {
	req, out := c.DescribeOrderableClusterOptionsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeOrderableClusterOptionsPages iterates over the pages of a DescribeOrderableClusterOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableClusterOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrderableClusterOptions operation.
//    pageNum := 0
//    err := client.DescribeOrderableClusterOptionsPages(params,
//        func(page *DescribeOrderableClusterOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeOrderableClusterOptionsPages(input *DescribeOrderableClusterOptionsInput, fn func(p *DescribeOrderableClusterOptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeOrderableClusterOptionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeOrderableClusterOptionsOutput), lastPage)
	})
}

const opDescribeReservedNodeOfferings = "DescribeReservedNodeOfferings"

// DescribeReservedNodeOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedNodeOfferings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReservedNodeOfferings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReservedNodeOfferings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReservedNodeOfferingsRequest method.
//    req, resp := client.DescribeReservedNodeOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings
func (c *Redshift) DescribeReservedNodeOfferingsRequest(input *DescribeReservedNodeOfferingsInput) (req *request.Request, output *DescribeReservedNodeOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedNodeOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedNodeOfferingsInput{}
	}

	output = &DescribeReservedNodeOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedNodeOfferings API operation for Amazon Redshift.
//
// Returns a list of the available reserved node offerings by Amazon Redshift
// with their descriptions including the node type, the fixed and recurring
// costs of reserving the node and duration the node will be reserved for you.
// These descriptions help you determine which reserve node offering you want
// to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering
// to reserve one or more nodes for your Amazon Redshift cluster.
//
// For more information about reserved node offerings, go to Purchasing Reserved
// Nodes (http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeReservedNodeOfferings for usage and error information.
//
// Returned Error Codes:
//   * ReservedNodeOfferingNotFound
//   Specified offering does not exist.
//
//   * UnsupportedOperation
//   The requested operation isn't supported.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings
func (c *Redshift) DescribeReservedNodeOfferings(input *DescribeReservedNodeOfferingsInput) (*DescribeReservedNodeOfferingsOutput, error) {
	req, out := c.DescribeReservedNodeOfferingsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeReservedNodeOfferingsPages iterates over the pages of a DescribeReservedNodeOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedNodeOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedNodeOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedNodeOfferingsPages(params,
//        func(page *DescribeReservedNodeOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeReservedNodeOfferingsPages(input *DescribeReservedNodeOfferingsInput, fn func(p *DescribeReservedNodeOfferingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedNodeOfferingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedNodeOfferingsOutput), lastPage)
	})
}

const opDescribeReservedNodes = "DescribeReservedNodes"

// DescribeReservedNodesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedNodes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReservedNodes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReservedNodes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReservedNodesRequest method.
//    req, resp := client.DescribeReservedNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes
func (c *Redshift) DescribeReservedNodesRequest(input *DescribeReservedNodesInput) (req *request.Request, output *DescribeReservedNodesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedNodesInput{}
	}

	output = &DescribeReservedNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedNodes API operation for Amazon Redshift.
//
// Returns the descriptions of the reserved nodes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeReservedNodes for usage and error information.
//
// Returned Error Codes:
//   * ReservedNodeNotFound
//   The specified reserved compute node not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes
func (c *Redshift) DescribeReservedNodes(input *DescribeReservedNodesInput) (*DescribeReservedNodesOutput, error) {
	req, out := c.DescribeReservedNodesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeReservedNodesPages iterates over the pages of a DescribeReservedNodes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedNodes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedNodes operation.
//    pageNum := 0
//    err := client.DescribeReservedNodesPages(params,
//        func(page *DescribeReservedNodesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Redshift) DescribeReservedNodesPages(input *DescribeReservedNodesInput, fn func(p *DescribeReservedNodesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedNodesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedNodesOutput), lastPage)
	})
}

const opDescribeResize = "DescribeResize"

// DescribeResizeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResize operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeResize for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeResize method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeResizeRequest method.
//    req, resp := client.DescribeResizeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize
func (c *Redshift) DescribeResizeRequest(input *DescribeResizeInput) (req *request.Request, output *DescribeResizeOutput) {
	op := &request.Operation{
		Name:       opDescribeResize,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResizeInput{}
	}

	output = &DescribeResizeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResize API operation for Amazon Redshift.
//
// Returns information about the last resize operation for the specified cluster.
// If no resize operation has ever been initiated for the specified cluster,
// a HTTP 404 error is returned. If a resize operation was initiated and completed,
// the status of the resize remains as SUCCEEDED until the next resize.
//
// A resize operation can be requested using ModifyCluster and specifying a
// different number or type of nodes for the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeResize for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * ResizeNotFound
//   A resize operation for the specified cluster is not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize
func (c *Redshift) DescribeResize(input *DescribeResizeInput) (*DescribeResizeOutput, error) {
	req, out := c.DescribeResizeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshotCopyGrants = "DescribeSnapshotCopyGrants"

// DescribeSnapshotCopyGrantsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshotCopyGrants operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSnapshotCopyGrants for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSnapshotCopyGrants method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSnapshotCopyGrantsRequest method.
//    req, resp := client.DescribeSnapshotCopyGrantsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants
func (c *Redshift) DescribeSnapshotCopyGrantsRequest(input *DescribeSnapshotCopyGrantsInput) (req *request.Request, output *DescribeSnapshotCopyGrantsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotCopyGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotCopyGrantsInput{}
	}

	output = &DescribeSnapshotCopyGrantsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshotCopyGrants API operation for Amazon Redshift.
//
// Returns a list of snapshot copy grants owned by the AWS account in the destination
// region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeSnapshotCopyGrants for usage and error information.
//
// Returned Error Codes:
//   * SnapshotCopyGrantNotFoundFault
//   The specified snapshot copy grant can't be found. Make sure that the name
//   is typed correctly and that the grant exists in the destination region.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants
func (c *Redshift) DescribeSnapshotCopyGrants(input *DescribeSnapshotCopyGrantsInput) (*DescribeSnapshotCopyGrantsOutput, error) {
	req, out := c.DescribeSnapshotCopyGrantsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTableRestoreStatus = "DescribeTableRestoreStatus"

// DescribeTableRestoreStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTableRestoreStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTableRestoreStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTableRestoreStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTableRestoreStatusRequest method.
//    req, resp := client.DescribeTableRestoreStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus
func (c *Redshift) DescribeTableRestoreStatusRequest(input *DescribeTableRestoreStatusInput) (req *request.Request, output *DescribeTableRestoreStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeTableRestoreStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableRestoreStatusInput{}
	}

	output = &DescribeTableRestoreStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTableRestoreStatus API operation for Amazon Redshift.
//
// Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot
// API action. If you don't specify a value for the TableRestoreRequestId parameter,
// then DescribeTableRestoreStatus returns the status of all table restore requests
// ordered by the date and time of the request in ascending order. Otherwise
// DescribeTableRestoreStatus returns the status of the table specified by TableRestoreRequestId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeTableRestoreStatus for usage and error information.
//
// Returned Error Codes:
//   * TableRestoreNotFoundFault
//   The specified TableRestoreRequestId value was not found.
//
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus
func (c *Redshift) DescribeTableRestoreStatus(input *DescribeTableRestoreStatusInput) (*DescribeTableRestoreStatusOutput, error) {
	req, out := c.DescribeTableRestoreStatusRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags
func (c *Redshift) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon Redshift.
//
// Returns a list of tags. You can return tags from a specific resource by specifying
// an ARN, or you can return all tags for a given type of resource, such as
// clusters, snapshots, and so on.
//
// The following are limitations for DescribeTags:
//
//    * You cannot specify an ARN and a resource-type value together in the
//    same request.
//
//    * You cannot use the MaxRecords and Marker parameters together with the
//    ARN parameter.
//
//    * The MaxRecords parameter can be a range from 10 to 50 results to return
//    in a request.
//
// If you specify both tag keys and tag values in the same request, Amazon Redshift
// returns all resources that match any combination of the specified keys and
// values. For example, if you have owner and environment for tag keys, and
// admin and test for tag values, all resources that have any combination of
// those values are returned.
//
// If both tag keys and values are omitted from the request, resources are returned
// regardless of whether they have tag keys or values associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidTagFault
//   The tag is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags
func (c *Redshift) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDisableLogging = "DisableLogging"

// DisableLoggingRequest generates a "aws/request.Request" representing the
// client's request for the DisableLogging operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableLogging for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableLogging method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableLoggingRequest method.
//    req, resp := client.DisableLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging
func (c *Redshift) DisableLoggingRequest(input *DisableLoggingInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opDisableLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableLoggingInput{}
	}

	output = &LoggingStatus{}
	req = c.newRequest(op, input, output)
	return
}

// DisableLogging API operation for Amazon Redshift.
//
// Stops logging information, such as queries and connection attempts, for the
// specified Amazon Redshift cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DisableLogging for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging
func (c *Redshift) DisableLogging(input *DisableLoggingInput) (*LoggingStatus, error) {
	req, out := c.DisableLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opDisableSnapshotCopy = "DisableSnapshotCopy"

// DisableSnapshotCopyRequest generates a "aws/request.Request" representing the
// client's request for the DisableSnapshotCopy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableSnapshotCopy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableSnapshotCopy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableSnapshotCopyRequest method.
//    req, resp := client.DisableSnapshotCopyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy
func (c *Redshift) DisableSnapshotCopyRequest(input *DisableSnapshotCopyInput) (req *request.Request, output *DisableSnapshotCopyOutput) {
	op := &request.Operation{
		Name:       opDisableSnapshotCopy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableSnapshotCopyInput{}
	}

	output = &DisableSnapshotCopyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableSnapshotCopy API operation for Amazon Redshift.
//
// Disables the automatic copying of snapshots from one region to another region
// for a specified cluster.
//
// If your cluster and its snapshots are encrypted using a customer master key
// (CMK) from AWS KMS, use DeleteSnapshotCopyGrant to delete the grant that
// grants Amazon Redshift permission to the CMK in the destination region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation DisableSnapshotCopy for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * SnapshotCopyAlreadyDisabledFault
//   The cluster already has cross-region snapshot copy disabled.
//
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * UnauthorizedOperation
//   Your account is not authorized to perform the requested operation.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy
func (c *Redshift) DisableSnapshotCopy(input *DisableSnapshotCopyInput) (*DisableSnapshotCopyOutput, error) {
	req, out := c.DisableSnapshotCopyRequest(input)
	err := req.Send()
	return out, err
}

const opEnableLogging = "EnableLogging"

// EnableLoggingRequest generates a "aws/request.Request" representing the
// client's request for the EnableLogging operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableLogging for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableLogging method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableLoggingRequest method.
//    req, resp := client.EnableLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging
func (c *Redshift) EnableLoggingRequest(input *EnableLoggingInput) (req *request.Request, output *LoggingStatus) {
	op := &request.Operation{
		Name:       opEnableLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableLoggingInput{}
	}

	output = &LoggingStatus{}
	req = c.newRequest(op, input, output)
	return
}

// EnableLogging API operation for Amazon Redshift.
//
// Starts logging information, such as queries and connection attempts, for
// the specified Amazon Redshift cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation EnableLogging for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * BucketNotFoundFault
//   Could not find the specified S3 bucket.
//
//   * InsufficientS3BucketPolicyFault
//   The cluster does not have read bucket or put object permissions on the S3
//   bucket specified when enabling logging.
//
//   * InvalidS3KeyPrefixFault
//   The string specified for the logging S3 key prefix does not comply with the
//   documented constraints.
//
//   * InvalidS3BucketNameFault
//   The S3 bucket name is invalid. For more information about naming rules, go
//   to Bucket Restrictions and Limitations (http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html)
//   in the Amazon Simple Storage Service (S3) Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging
func (c *Redshift) EnableLogging(input *EnableLoggingInput) (*LoggingStatus, error) {
	req, out := c.EnableLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opEnableSnapshotCopy = "EnableSnapshotCopy"

// EnableSnapshotCopyRequest generates a "aws/request.Request" representing the
// client's request for the EnableSnapshotCopy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableSnapshotCopy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableSnapshotCopy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableSnapshotCopyRequest method.
//    req, resp := client.EnableSnapshotCopyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy
func (c *Redshift) EnableSnapshotCopyRequest(input *EnableSnapshotCopyInput) (req *request.Request, output *EnableSnapshotCopyOutput) {
	op := &request.Operation{
		Name:       opEnableSnapshotCopy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableSnapshotCopyInput{}
	}

	output = &EnableSnapshotCopyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EnableSnapshotCopy API operation for Amazon Redshift.
//
// Enables the automatic copy of snapshots from one region to another region
// for a specified cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation EnableSnapshotCopy for usage and error information.
//
// Returned Error Codes:
//   * IncompatibleOrderableOptions
//   The specified options are incompatible.
//
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * CopyToRegionDisabledFault
//   Cross-region snapshot copy was temporarily disabled. Try your request again.
//
//   * SnapshotCopyAlreadyEnabledFault
//   The cluster already has cross-region snapshot copy enabled.
//
//   * UnknownSnapshotCopyRegionFault
//   The specified region is incorrect or does not exist.
//
//   * UnauthorizedOperation
//   Your account is not authorized to perform the requested operation.
//
//   * SnapshotCopyGrantNotFoundFault
//   The specified snapshot copy grant can't be found. Make sure that the name
//   is typed correctly and that the grant exists in the destination region.
//
//   * LimitExceededFault
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy
func (c *Redshift) EnableSnapshotCopy(input *EnableSnapshotCopyInput) (*EnableSnapshotCopyOutput, error) {
	req, out := c.EnableSnapshotCopyRequest(input)
	err := req.Send()
	return out, err
}

const opModifyCluster = "ModifyCluster"

// ModifyClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyCluster operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyCluster for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyCluster method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyClusterRequest method.
//    req, resp := client.ModifyClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster
func (c *Redshift) ModifyClusterRequest(input *ModifyClusterInput) (req *request.Request, output *ModifyClusterOutput) {
	op := &request.Operation{
		Name:       opModifyCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterInput{}
	}

	output = &ModifyClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyCluster API operation for Amazon Redshift.
//
// Modifies the settings for a cluster. For example, you can add another security
// or parameter group, update the preferred maintenance window, or change the
// master user password. Resetting a cluster password or modifying the security
// groups associated with a cluster do not need a reboot. However, modifying
// a parameter group requires a reboot for parameters to take effect. For more
// information about managing clusters, go to Amazon Redshift Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// You can also change node type and the number of nodes to scale up or down
// the cluster. When resizing a cluster, you must specify both the number of
// nodes and the node type even if one of the parameters does not change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyCluster for usage and error information.
//
// Returned Error Codes:
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * InvalidClusterSecurityGroupState
//   The state of the cluster security group is not available.
//
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * NumberOfNodesQuotaExceeded
//   The operation would exceed the number of nodes allotted to the account. For
//   information about increasing your quota, go to Limits in Amazon Redshift
//   (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * ClusterSecurityGroupNotFound
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * ClusterParameterGroupNotFound
//   The parameter group name does not refer to an existing parameter group.
//
//   * InsufficientClusterCapacity
//   The number of nodes specified exceeds the allotted capacity of the cluster.
//
//   * UnsupportedOptionFault
//   A request option was specified that is not supported.
//
//   * UnauthorizedOperation
//   Your account is not authorized to perform the requested operation.
//
//   * HsmClientCertificateNotFoundFault
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
//   * HsmConfigurationNotFoundFault
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
//   * ClusterAlreadyExists
//   The account already has a cluster with the given identifier.
//
//   * LimitExceededFault
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
//   * InvalidElasticIpFault
//   The Elastic IP (EIP) is invalid or cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster
func (c *Redshift) ModifyCluster(input *ModifyClusterInput) (*ModifyClusterOutput, error) {
	req, out := c.ModifyClusterRequest(input)
	err := req.Send()
	return out, err
}

const opModifyClusterIamRoles = "ModifyClusterIamRoles"

// ModifyClusterIamRolesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterIamRoles operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyClusterIamRoles for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyClusterIamRoles method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyClusterIamRolesRequest method.
//    req, resp := client.ModifyClusterIamRolesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles
func (c *Redshift) ModifyClusterIamRolesRequest(input *ModifyClusterIamRolesInput) (req *request.Request, output *ModifyClusterIamRolesOutput) {
	op := &request.Operation{
		Name:       opModifyClusterIamRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterIamRolesInput{}
	}

	output = &ModifyClusterIamRolesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterIamRoles API operation for Amazon Redshift.
//
// Modifies the list of AWS Identity and Access Management (IAM) roles that
// can be used by the cluster to access other AWS services.
//
// A cluster can have up to 10 IAM roles associated at any time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterIamRoles for usage and error information.
//
// Returned Error Codes:
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles
func (c *Redshift) ModifyClusterIamRoles(input *ModifyClusterIamRolesInput) (*ModifyClusterIamRolesOutput, error) {
	req, out := c.ModifyClusterIamRolesRequest(input)
	err := req.Send()
	return out, err
}

const opModifyClusterParameterGroup = "ModifyClusterParameterGroup"

// ModifyClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterParameterGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyClusterParameterGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyClusterParameterGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyClusterParameterGroupRequest method.
//    req, resp := client.ModifyClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup
func (c *Redshift) ModifyClusterParameterGroupRequest(input *ModifyClusterParameterGroupInput) (req *request.Request, output *ClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterParameterGroupInput{}
	}

	output = &ClusterParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterParameterGroup API operation for Amazon Redshift.
//
// Modifies the parameters of a parameter group.
//
// For more information about parameters and parameter groups, go to Amazon
// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ClusterParameterGroupNotFound
//   The parameter group name does not refer to an existing parameter group.
//
//   * InvalidClusterParameterGroupState
//   The cluster parameter group action can not be completed because another task
//   is in progress that involves the parameter group. Wait a few moments and
//   try the operation again.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup
func (c *Redshift) ModifyClusterParameterGroup(input *ModifyClusterParameterGroupInput) (*ClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyClusterSubnetGroup = "ModifyClusterSubnetGroup"

// ModifyClusterSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClusterSubnetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyClusterSubnetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyClusterSubnetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyClusterSubnetGroupRequest method.
//    req, resp := client.ModifyClusterSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup
func (c *Redshift) ModifyClusterSubnetGroupRequest(input *ModifyClusterSubnetGroupInput) (req *request.Request, output *ModifyClusterSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterSubnetGroupInput{}
	}

	output = &ModifyClusterSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyClusterSubnetGroup API operation for Amazon Redshift.
//
// Modifies a cluster subnet group to include the specified list of VPC subnets.
// The operation replaces the existing list of subnets with the new list of
// subnets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyClusterSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ClusterSubnetGroupNotFoundFault
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
//   * ClusterSubnetQuotaExceededFault
//   The request would result in user exceeding the allowed number of subnets
//   in a cluster subnet groups. For information about increasing your quota,
//   go to Limits in Amazon Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * SubnetAlreadyInUse
//   A specified subnet is already in use by another cluster.
//
//   * InvalidSubnet
//   The requested subnet is not valid, or not all of the subnets are in the same
//   VPC.
//
//   * UnauthorizedOperation
//   Your account is not authorized to perform the requested operation.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup
func (c *Redshift) ModifyClusterSubnetGroup(input *ModifyClusterSubnetGroupInput) (*ModifyClusterSubnetGroupOutput, error) {
	req, out := c.ModifyClusterSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEventSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyEventSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyEventSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyEventSubscriptionRequest method.
//    req, resp := client.ModifyEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscription
func (c *Redshift) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	output = &ModifyEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEventSubscription API operation for Amazon Redshift.
//
// Modifies an existing Amazon Redshift event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifyEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * SubscriptionNotFound
//   An Amazon Redshift event notification subscription with the specified name
//   does not exist.
//
//   * SNSInvalidTopic
//   Amazon SNS has responded that there is a problem with the specified Amazon
//   SNS topic.
//
//   * SNSNoAuthorization
//   You do not have permission to publish to the specified Amazon SNS topic.
//
//   * SNSTopicArnNotFound
//   An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
//   exist.
//
//   * SubscriptionEventIdNotFound
//   An Amazon Redshift event with the specified event ID does not exist.
//
//   * SubscriptionCategoryNotFound
//   The value specified for the event category was not one of the allowed values,
//   or it specified a category that does not apply to the specified source type.
//   The allowed values are Configuration, Management, Monitoring, and Security.
//
//   * SubscriptionSeverityNotFound
//   The value specified for the event severity was not one of the allowed values,
//   or it specified a severity that does not apply to the specified source type.
//   The allowed values are ERROR and INFO.
//
//   * SourceNotFound
//   The specified Amazon Redshift event source could not be found.
//
//   * InvalidSubscriptionStateFault
//   The subscription request is invalid because it is a duplicate request. This
//   subscription request is already in progress.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscription
func (c *Redshift) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opModifySnapshotCopyRetentionPeriod = "ModifySnapshotCopyRetentionPeriod"

// ModifySnapshotCopyRetentionPeriodRequest generates a "aws/request.Request" representing the
// client's request for the ModifySnapshotCopyRetentionPeriod operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifySnapshotCopyRetentionPeriod for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifySnapshotCopyRetentionPeriod method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifySnapshotCopyRetentionPeriodRequest method.
//    req, resp := client.ModifySnapshotCopyRetentionPeriodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriod
func (c *Redshift) ModifySnapshotCopyRetentionPeriodRequest(input *ModifySnapshotCopyRetentionPeriodInput) (req *request.Request, output *ModifySnapshotCopyRetentionPeriodOutput) {
	op := &request.Operation{
		Name:       opModifySnapshotCopyRetentionPeriod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySnapshotCopyRetentionPeriodInput{}
	}

	output = &ModifySnapshotCopyRetentionPeriodOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifySnapshotCopyRetentionPeriod API operation for Amazon Redshift.
//
// Modifies the number of days to retain automated snapshots in the destination
// region after they are copied from the source region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ModifySnapshotCopyRetentionPeriod for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * SnapshotCopyDisabledFault
//   Cross-region snapshot copy was temporarily disabled. Try your request again.
//
//   * UnauthorizedOperation
//   Your account is not authorized to perform the requested operation.
//
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriod
func (c *Redshift) ModifySnapshotCopyRetentionPeriod(input *ModifySnapshotCopyRetentionPeriodInput) (*ModifySnapshotCopyRetentionPeriodOutput, error) {
	req, out := c.ModifySnapshotCopyRetentionPeriodRequest(input)
	err := req.Send()
	return out, err
}

const opPurchaseReservedNodeOffering = "PurchaseReservedNodeOffering"

// PurchaseReservedNodeOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedNodeOffering operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PurchaseReservedNodeOffering for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PurchaseReservedNodeOffering method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PurchaseReservedNodeOfferingRequest method.
//    req, resp := client.PurchaseReservedNodeOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOffering
func (c *Redshift) PurchaseReservedNodeOfferingRequest(input *PurchaseReservedNodeOfferingInput) (req *request.Request, output *PurchaseReservedNodeOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedNodeOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedNodeOfferingInput{}
	}

	output = &PurchaseReservedNodeOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedNodeOffering API operation for Amazon Redshift.
//
// Allows you to purchase reserved nodes. Amazon Redshift offers a predefined
// set of reserved node offerings. You can purchase one or more of the offerings.
// You can call the DescribeReservedNodeOfferings API to obtain the available
// reserved node offerings. You can call this API by providing a specific reserved
// node offering and the number of nodes you want to reserve.
//
// For more information about reserved node offerings, go to Purchasing Reserved
// Nodes (http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation PurchaseReservedNodeOffering for usage and error information.
//
// Returned Error Codes:
//   * ReservedNodeOfferingNotFound
//   Specified offering does not exist.
//
//   * ReservedNodeAlreadyExists
//   User already has a reservation with the given identifier.
//
//   * ReservedNodeQuotaExceeded
//   Request would exceed the user's compute node quota. For information about
//   increasing your quota, go to Limits in Amazon Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * UnsupportedOperation
//   The requested operation isn't supported.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOffering
func (c *Redshift) PurchaseReservedNodeOffering(input *PurchaseReservedNodeOfferingInput) (*PurchaseReservedNodeOfferingOutput, error) {
	req, out := c.PurchaseReservedNodeOfferingRequest(input)
	err := req.Send()
	return out, err
}

const opRebootCluster = "RebootCluster"

// RebootClusterRequest generates a "aws/request.Request" representing the
// client's request for the RebootCluster operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RebootCluster for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RebootCluster method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RebootClusterRequest method.
//    req, resp := client.RebootClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootCluster
func (c *Redshift) RebootClusterRequest(input *RebootClusterInput) (req *request.Request, output *RebootClusterOutput) {
	op := &request.Operation{
		Name:       opRebootCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootClusterInput{}
	}

	output = &RebootClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootCluster API operation for Amazon Redshift.
//
// Reboots a cluster. This action is taken as soon as possible. It results in
// a momentary outage to the cluster, during which the cluster status is set
// to rebooting. A cluster event is created when the reboot is completed. Any
// pending cluster modifications (see ModifyCluster) are applied at this reboot.
// For more information about managing clusters, go to Amazon Redshift Clusters
// (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RebootCluster for usage and error information.
//
// Returned Error Codes:
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootCluster
func (c *Redshift) RebootCluster(input *RebootClusterInput) (*RebootClusterOutput, error) {
	req, out := c.RebootClusterRequest(input)
	err := req.Send()
	return out, err
}

const opResetClusterParameterGroup = "ResetClusterParameterGroup"

// ResetClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetClusterParameterGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResetClusterParameterGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResetClusterParameterGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResetClusterParameterGroupRequest method.
//    req, resp := client.ResetClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResetClusterParameterGroup
func (c *Redshift) ResetClusterParameterGroupRequest(input *ResetClusterParameterGroupInput) (req *request.Request, output *ClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetClusterParameterGroupInput{}
	}

	output = &ClusterParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ResetClusterParameterGroup API operation for Amazon Redshift.
//
// Sets one or more parameters of the specified parameter group to their default
// values and sets the source values of the parameters to "engine-default".
// To reset the entire parameter group specify the ResetAllParameters parameter.
// For parameter changes to take effect you must reboot any associated clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation ResetClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * InvalidClusterParameterGroupState
//   The cluster parameter group action can not be completed because another task
//   is in progress that involves the parameter group. Wait a few moments and
//   try the operation again.
//
//   * ClusterParameterGroupNotFound
//   The parameter group name does not refer to an existing parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResetClusterParameterGroup
func (c *Redshift) ResetClusterParameterGroup(input *ResetClusterParameterGroupInput) (*ClusterParameterGroupNameMessage, error) {
	req, out := c.ResetClusterParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreFromClusterSnapshot = "RestoreFromClusterSnapshot"

// RestoreFromClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreFromClusterSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RestoreFromClusterSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RestoreFromClusterSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RestoreFromClusterSnapshotRequest method.
//    req, resp := client.RestoreFromClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshot
func (c *Redshift) RestoreFromClusterSnapshotRequest(input *RestoreFromClusterSnapshotInput) (req *request.Request, output *RestoreFromClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreFromClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromClusterSnapshotInput{}
	}

	output = &RestoreFromClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreFromClusterSnapshot API operation for Amazon Redshift.
//
// Creates a new cluster from a snapshot. By default, Amazon Redshift creates
// the resulting cluster with the same configuration as the original cluster
// from which the snapshot was created, except that the new cluster is created
// with the default cluster security and parameter groups. After Amazon Redshift
// creates the cluster, you can use the ModifyCluster API to associate a different
// security group and different parameter group with the restored cluster. If
// you are using a DS node type, you can also choose to change to another DS
// node type of the same size during restore.
//
// If you restore a cluster into a VPC, you must provide a cluster subnet group
// where you want the cluster restored.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RestoreFromClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * AccessToSnapshotDenied
//   The owner of the specified snapshot has not authorized your account to access
//   the snapshot.
//
//   * ClusterAlreadyExists
//   The account already has a cluster with the given identifier.
//
//   * ClusterSnapshotNotFound
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * ClusterQuotaExceeded
//   The request would exceed the allowed number of cluster instances for this
//   account. For information about increasing your quota, go to Limits in Amazon
//   Redshift (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * InsufficientClusterCapacity
//   The number of nodes specified exceeds the allotted capacity of the cluster.
//
//   * InvalidClusterSnapshotState
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * InvalidRestore
//   The restore is invalid.
//
//   * NumberOfNodesQuotaExceeded
//   The operation would exceed the number of nodes allotted to the account. For
//   information about increasing your quota, go to Limits in Amazon Redshift
//   (http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html)
//   in the Amazon Redshift Cluster Management Guide.
//
//   * NumberOfNodesPerClusterLimitExceeded
//   The operation would exceed the number of nodes allowed for a cluster.
//
//   * InvalidVPCNetworkStateFault
//   The cluster subnet group does not cover all Availability Zones.
//
//   * InvalidClusterSubnetGroupStateFault
//   The cluster subnet group cannot be deleted because it is in use.
//
//   * InvalidSubnet
//   The requested subnet is not valid, or not all of the subnets are in the same
//   VPC.
//
//   * ClusterSubnetGroupNotFoundFault
//   The cluster subnet group name does not refer to an existing cluster subnet
//   group.
//
//   * UnauthorizedOperation
//   Your account is not authorized to perform the requested operation.
//
//   * HsmClientCertificateNotFoundFault
//   There is no Amazon Redshift HSM client certificate with the specified identifier.
//
//   * HsmConfigurationNotFoundFault
//   There is no Amazon Redshift HSM configuration with the specified identifier.
//
//   * InvalidElasticIpFault
//   The Elastic IP (EIP) is invalid or cannot be found.
//
//   * ClusterParameterGroupNotFound
//   The parameter group name does not refer to an existing parameter group.
//
//   * ClusterSecurityGroupNotFound
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * LimitExceededFault
//   The encryption key has exceeded its grant limit in AWS KMS.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshot
func (c *Redshift) RestoreFromClusterSnapshot(input *RestoreFromClusterSnapshotInput) (*RestoreFromClusterSnapshotOutput, error) {
	req, out := c.RestoreFromClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreTableFromClusterSnapshot = "RestoreTableFromClusterSnapshot"

// RestoreTableFromClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreTableFromClusterSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RestoreTableFromClusterSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RestoreTableFromClusterSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RestoreTableFromClusterSnapshotRequest method.
//    req, resp := client.RestoreTableFromClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshot
func (c *Redshift) RestoreTableFromClusterSnapshotRequest(input *RestoreTableFromClusterSnapshotInput) (req *request.Request, output *RestoreTableFromClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreTableFromClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableFromClusterSnapshotInput{}
	}

	output = &RestoreTableFromClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreTableFromClusterSnapshot API operation for Amazon Redshift.
//
// Creates a new table from a table in an Amazon Redshift cluster snapshot.
// You must create the new table within the Amazon Redshift cluster that the
// snapshot was taken from.
//
// You cannot use RestoreTableFromClusterSnapshot to restore a table with the
// same name as an existing table in an Amazon Redshift cluster. That is, you
// cannot overwrite an existing table in a cluster with a restored table. If
// you want to replace your original table with a new, restored table, then
// rename or drop your original table before you call RestoreTableFromClusterSnapshot.
// When you have renamed your original table, then you can pass the original
// name of the table as the NewTableName parameter value in the call to RestoreTableFromClusterSnapshot.
// This way, you can replace the original table with the table created from
// the snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RestoreTableFromClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ClusterSnapshotNotFound
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
//   * InProgressTableRestoreQuotaExceededFault
//   You have exceeded the allowed number of table restore requests. Wait for
//   your current table restore requests to complete before making a new request.
//
//   * InvalidClusterSnapshotState
//   The specified cluster snapshot is not in the available state, or other accounts
//   are authorized to access the snapshot.
//
//   * InvalidTableRestoreArgument
//   The value specified for the sourceDatabaseName, sourceSchemaName, or sourceTableName
//   parameter, or a combination of these, doesn't exist in the snapshot.
//
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * UnsupportedOperation
//   The requested operation isn't supported.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshot
func (c *Redshift) RestoreTableFromClusterSnapshot(input *RestoreTableFromClusterSnapshotInput) (*RestoreTableFromClusterSnapshotOutput, error) {
	req, out := c.RestoreTableFromClusterSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeClusterSecurityGroupIngress = "RevokeClusterSecurityGroupIngress"

// RevokeClusterSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the RevokeClusterSecurityGroupIngress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RevokeClusterSecurityGroupIngress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RevokeClusterSecurityGroupIngress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RevokeClusterSecurityGroupIngressRequest method.
//    req, resp := client.RevokeClusterSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngress
func (c *Redshift) RevokeClusterSecurityGroupIngressRequest(input *RevokeClusterSecurityGroupIngressInput) (req *request.Request, output *RevokeClusterSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeClusterSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeClusterSecurityGroupIngressInput{}
	}

	output = &RevokeClusterSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeClusterSecurityGroupIngress API operation for Amazon Redshift.
//
// Revokes an ingress rule in an Amazon Redshift security group for a previously
// authorized IP range or Amazon EC2 security group. To add an ingress rule,
// see AuthorizeClusterSecurityGroupIngress. For information about managing
// security groups, go to Amazon Redshift Cluster Security Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RevokeClusterSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ClusterSecurityGroupNotFound
//   The cluster security group name does not refer to an existing cluster security
//   group.
//
//   * AuthorizationNotFound
//   The specified CIDR IP range or EC2 security group is not authorized for the
//   specified cluster security group.
//
//   * InvalidClusterSecurityGroupState
//   The state of the cluster security group is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngress
func (c *Redshift) RevokeClusterSecurityGroupIngress(input *RevokeClusterSecurityGroupIngressInput) (*RevokeClusterSecurityGroupIngressOutput, error) {
	req, out := c.RevokeClusterSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeSnapshotAccess = "RevokeSnapshotAccess"

// RevokeSnapshotAccessRequest generates a "aws/request.Request" representing the
// client's request for the RevokeSnapshotAccess operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RevokeSnapshotAccess for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RevokeSnapshotAccess method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RevokeSnapshotAccessRequest method.
//    req, resp := client.RevokeSnapshotAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccess
func (c *Redshift) RevokeSnapshotAccessRequest(input *RevokeSnapshotAccessInput) (req *request.Request, output *RevokeSnapshotAccessOutput) {
	op := &request.Operation{
		Name:       opRevokeSnapshotAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSnapshotAccessInput{}
	}

	output = &RevokeSnapshotAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeSnapshotAccess API operation for Amazon Redshift.
//
// Removes the ability of the specified AWS customer account to restore the
// specified snapshot. If the account is currently restoring the snapshot, the
// restore will run to completion.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RevokeSnapshotAccess for usage and error information.
//
// Returned Error Codes:
//   * AccessToSnapshotDenied
//   The owner of the specified snapshot has not authorized your account to access
//   the snapshot.
//
//   * AuthorizationNotFound
//   The specified CIDR IP range or EC2 security group is not authorized for the
//   specified cluster security group.
//
//   * ClusterSnapshotNotFound
//   The snapshot identifier does not refer to an existing cluster snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccess
func (c *Redshift) RevokeSnapshotAccess(input *RevokeSnapshotAccessInput) (*RevokeSnapshotAccessOutput, error) {
	req, out := c.RevokeSnapshotAccessRequest(input)
	err := req.Send()
	return out, err
}

const opRotateEncryptionKey = "RotateEncryptionKey"

// RotateEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the RotateEncryptionKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RotateEncryptionKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RotateEncryptionKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RotateEncryptionKeyRequest method.
//    req, resp := client.RotateEncryptionKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKey
func (c *Redshift) RotateEncryptionKeyRequest(input *RotateEncryptionKeyInput) (req *request.Request, output *RotateEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opRotateEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RotateEncryptionKeyInput{}
	}

	output = &RotateEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RotateEncryptionKey API operation for Amazon Redshift.
//
// Rotates the encryption keys for a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Redshift's
// API operation RotateEncryptionKey for usage and error information.
//
// Returned Error Codes:
//   * ClusterNotFound
//   The ClusterIdentifier parameter does not refer to an existing cluster.
//
//   * InvalidClusterState
//   The specified cluster is not in the available state.
//
//   * DependentServiceRequestThrottlingFault
//   The request cannot be completed because a dependent service is throttling
//   requests made by Amazon Redshift on your behalf. Wait and retry the request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKey
func (c *Redshift) RotateEncryptionKey(input *RotateEncryptionKeyInput) (*RotateEncryptionKeyOutput, error) {
	req, out := c.RotateEncryptionKeyRequest(input)
	err := req.Send()
	return out, err
}

// Describes an AWS customer account authorized to restore a snapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AccountWithRestoreAccess
type AccountWithRestoreAccess struct {
	_ struct{} `type:"structure"`

	// The identifier of an AWS customer account authorized to restore a snapshot.
	AccountId *string `type:"string"`
}

// String returns the string representation
func (s AccountWithRestoreAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountWithRestoreAccess) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountWithRestoreAccess) SetAccountId(v string) *AccountWithRestoreAccess {
	s.AccountId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngressMessage
type AuthorizeClusterSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range to be added the Amazon Redshift security group.
	CIDRIP *string `type:"string"`

	// The name of the security group to which the ingress rule is added.
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// The EC2 security group to be added the Amazon Redshift security group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account number of the owner of the security group specified by the
	// EC2SecurityGroupName parameter. The AWS Access Key ID is not an acceptable
	// value.
	//
	// Example: 111122223333
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s AuthorizeClusterSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeClusterSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeClusterSecurityGroupIngressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeClusterSecurityGroupIngressInput"}
	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *AuthorizeClusterSecurityGroupIngressInput) SetCIDRIP(v string) *AuthorizeClusterSecurityGroupIngressInput {
	s.CIDRIP = &v
	return s
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *AuthorizeClusterSecurityGroupIngressInput) SetClusterSecurityGroupName(v string) *AuthorizeClusterSecurityGroupIngressInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *AuthorizeClusterSecurityGroupIngressInput) SetEC2SecurityGroupName(v string) *AuthorizeClusterSecurityGroupIngressInput {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *AuthorizeClusterSecurityGroupIngressInput) SetEC2SecurityGroupOwnerId(v string) *AuthorizeClusterSecurityGroupIngressInput {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngressResult
type AuthorizeClusterSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s AuthorizeClusterSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeClusterSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroup sets the ClusterSecurityGroup field's value.
func (s *AuthorizeClusterSecurityGroupIngressOutput) SetClusterSecurityGroup(v *ClusterSecurityGroup) *AuthorizeClusterSecurityGroupIngressOutput {
	s.ClusterSecurityGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccessMessage
type AuthorizeSnapshotAccessInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS customer account authorized to restore the specified
	// snapshot.
	//
	// AccountWithRestoreAccess is a required field
	AccountWithRestoreAccess *string `type:"string" required:"true"`

	// The identifier of the cluster the snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The identifier of the snapshot the account is authorized to restore.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AuthorizeSnapshotAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSnapshotAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeSnapshotAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeSnapshotAccessInput"}
	if s.AccountWithRestoreAccess == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountWithRestoreAccess"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountWithRestoreAccess sets the AccountWithRestoreAccess field's value.
func (s *AuthorizeSnapshotAccessInput) SetAccountWithRestoreAccess(v string) *AuthorizeSnapshotAccessInput {
	s.AccountWithRestoreAccess = &v
	return s
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *AuthorizeSnapshotAccessInput) SetSnapshotClusterIdentifier(v string) *AuthorizeSnapshotAccessInput {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *AuthorizeSnapshotAccessInput) SetSnapshotIdentifier(v string) *AuthorizeSnapshotAccessInput {
	s.SnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccessResult
type AuthorizeSnapshotAccessOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s AuthorizeSnapshotAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeSnapshotAccessOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *AuthorizeSnapshotAccessOutput) SetSnapshot(v *Snapshot) *AuthorizeSnapshotAccessOutput {
	s.Snapshot = v
	return s
}

// Describes an availability zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AvailabilityZone
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// Describes a cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/Cluster
type Cluster struct {
	_ struct{} `type:"structure"`

	// A Boolean value that, if true, indicates that major version upgrades will
	// be applied automatically to the cluster during the maintenance window.
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automatic cluster snapshots are retained.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The name of the Availability Zone in which the cluster is located.
	AvailabilityZone *string `type:"string"`

	// The date and time that the cluster was created.
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the cluster.
	ClusterIdentifier *string `type:"string"`

	// The nodes in the cluster.
	ClusterNodes []*ClusterNode `type:"list"`

	// The list of cluster parameter groups that are associated with this cluster.
	// Each parameter group in the list is returned with its status.
	ClusterParameterGroups []*ClusterParameterGroupStatus `locationNameList:"ClusterParameterGroup" type:"list"`

	// The public key for the cluster.
	ClusterPublicKey *string `type:"string"`

	// The specific revision number of the database in the cluster.
	ClusterRevisionNumber *string `type:"string"`

	// A list of cluster security group that are associated with the cluster. Each
	// security group is represented by an element that contains ClusterSecurityGroup.Name
	// and ClusterSecurityGroup.Status subelements.
	//
	// Cluster security groups are used when the cluster is not created in an Amazon
	// Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security
	// groups, which are listed by the VpcSecurityGroups parameter.
	ClusterSecurityGroups []*ClusterSecurityGroupMembership `locationNameList:"ClusterSecurityGroup" type:"list"`

	// A value that returns the destination region and retention period that are
	// configured for cross-region snapshot copy.
	ClusterSnapshotCopyStatus *ClusterSnapshotCopyStatus `type:"structure"`

	// The current state of the cluster. Possible values are the following:
	//
	//    * available
	//
	//    * creating
	//
	//    * deleting
	//
	//    * final-snapshot
	//
	//    * hardware-failure
	//
	//    * incompatible-hsm
	//
	//    * incompatible-network
	//
	//    * incompatible-parameters
	//
	//    * incompatible-restore
	//
	//    * modifying
	//
	//    * rebooting
	//
	//    * renaming
	//
	//    * resizing
	//
	//    * rotating-keys
	//
	//    * storage-full
	//
	//    * updating-hsm
	ClusterStatus *string `type:"string"`

	// The name of the subnet group that is associated with the cluster. This parameter
	// is valid only when the cluster is in a VPC.
	ClusterSubnetGroupName *string `type:"string"`

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string `type:"string"`

	// The name of the initial database that was created when the cluster was created.
	// This same name is returned for the life of the cluster. If an initial database
	// was not specified, a database named devdev was created by default.
	DBName *string `type:"string"`

	// The status of the elastic IP (EIP) address.
	ElasticIpStatus *ElasticIpStatus `type:"structure"`

	// A Boolean value that, if true, indicates that data in the cluster is encrypted
	// at rest.
	Encrypted *bool `type:"boolean"`

	// The connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// A value that reports whether the Amazon Redshift cluster has finished applying
	// any hardware security module (HSM) settings changes specified in a modify
	// cluster command.
	//
	// Values: active, applying
	HsmStatus *HsmStatus `type:"structure"`

	// A list of AWS Identity and Access Management (IAM) roles that can be used
	// by the cluster to access other AWS services.
	IamRoles []*ClusterIamRole `locationNameList:"ClusterIamRole" type:"list"`

	// The AWS Key Management Service (AWS KMS) key ID of the encryption key used
	// to encrypt data in the cluster.
	KmsKeyId *string `type:"string"`

	// The master user name for the cluster. This name is used to connect to the
	// database that is specified in the DBName parameter.
	MasterUsername *string `type:"string"`

	// The status of a modify operation, if any, initiated for the cluster.
	ModifyStatus *string `type:"string"`

	// The node type for the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of compute nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// A value that, if present, indicates that changes to the cluster are pending.
	// Specific pending changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// The weekly time range, in Universal Coordinated Time (UTC), during which
	// system maintenance can occur.
	PreferredMaintenanceWindow *string `type:"string"`

	// A Boolean value that, if true, indicates that the cluster can be accessed
	// from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// A value that describes the status of a cluster restore action. This parameter
	// returns null if the cluster was not created by restoring a snapshot.
	RestoreStatus *RestoreStatus `type:"structure"`

	// The list of tags for the cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the VPC the cluster is in, if the cluster is in a VPC.
	VpcId *string `type:"string"`

	// A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that
	// are associated with the cluster. This parameter is returned only if the cluster
	// is in a VPC.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroup" type:"list"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cluster) GoString() string {
	return s.String()
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *Cluster) SetAllowVersionUpgrade(v bool) *Cluster {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *Cluster) SetAutomatedSnapshotRetentionPeriod(v int64) *Cluster {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Cluster) SetAvailabilityZone(v string) *Cluster {
	s.AvailabilityZone = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *Cluster) SetClusterCreateTime(v time.Time) *Cluster {
	s.ClusterCreateTime = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *Cluster) SetClusterIdentifier(v string) *Cluster {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterNodes sets the ClusterNodes field's value.
func (s *Cluster) SetClusterNodes(v []*ClusterNode) *Cluster {
	s.ClusterNodes = v
	return s
}

// SetClusterParameterGroups sets the ClusterParameterGroups field's value.
func (s *Cluster) SetClusterParameterGroups(v []*ClusterParameterGroupStatus) *Cluster {
	s.ClusterParameterGroups = v
	return s
}

// SetClusterPublicKey sets the ClusterPublicKey field's value.
func (s *Cluster) SetClusterPublicKey(v string) *Cluster {
	s.ClusterPublicKey = &v
	return s
}

// SetClusterRevisionNumber sets the ClusterRevisionNumber field's value.
func (s *Cluster) SetClusterRevisionNumber(v string) *Cluster {
	s.ClusterRevisionNumber = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *Cluster) SetClusterSecurityGroups(v []*ClusterSecurityGroupMembership) *Cluster {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterSnapshotCopyStatus sets the ClusterSnapshotCopyStatus field's value.
func (s *Cluster) SetClusterSnapshotCopyStatus(v *ClusterSnapshotCopyStatus) *Cluster {
	s.ClusterSnapshotCopyStatus = v
	return s
}

// SetClusterStatus sets the ClusterStatus field's value.
func (s *Cluster) SetClusterStatus(v string) *Cluster {
	s.ClusterStatus = &v
	return s
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *Cluster) SetClusterSubnetGroupName(v string) *Cluster {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *Cluster) SetClusterVersion(v string) *Cluster {
	s.ClusterVersion = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *Cluster) SetDBName(v string) *Cluster {
	s.DBName = &v
	return s
}

// SetElasticIpStatus sets the ElasticIpStatus field's value.
func (s *Cluster) SetElasticIpStatus(v *ElasticIpStatus) *Cluster {
	s.ElasticIpStatus = v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *Cluster) SetEncrypted(v bool) *Cluster {
	s.Encrypted = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Cluster) SetEndpoint(v *Endpoint) *Cluster {
	s.Endpoint = v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *Cluster) SetEnhancedVpcRouting(v bool) *Cluster {
	s.EnhancedVpcRouting = &v
	return s
}

// SetHsmStatus sets the HsmStatus field's value.
func (s *Cluster) SetHsmStatus(v *HsmStatus) *Cluster {
	s.HsmStatus = v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *Cluster) SetIamRoles(v []*ClusterIamRole) *Cluster {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Cluster) SetKmsKeyId(v string) *Cluster {
	s.KmsKeyId = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *Cluster) SetMasterUsername(v string) *Cluster {
	s.MasterUsername = &v
	return s
}

// SetModifyStatus sets the ModifyStatus field's value.
func (s *Cluster) SetModifyStatus(v string) *Cluster {
	s.ModifyStatus = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *Cluster) SetNodeType(v string) *Cluster {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *Cluster) SetNumberOfNodes(v int64) *Cluster {
	s.NumberOfNodes = &v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *Cluster) SetPendingModifiedValues(v *PendingModifiedValues) *Cluster {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *Cluster) SetPreferredMaintenanceWindow(v string) *Cluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *Cluster) SetPubliclyAccessible(v bool) *Cluster {
	s.PubliclyAccessible = &v
	return s
}

// SetRestoreStatus sets the RestoreStatus field's value.
func (s *Cluster) SetRestoreStatus(v *RestoreStatus) *Cluster {
	s.RestoreStatus = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Cluster) SetTags(v []*Tag) *Cluster {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Cluster) SetVpcId(v string) *Cluster {
	s.VpcId = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *Cluster) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *Cluster {
	s.VpcSecurityGroups = v
	return s
}

// An AWS Identity and Access Management (IAM) role that can be used by the
// associated Amazon Redshift cluster to access other AWS services.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterIamRole
type ClusterIamRole struct {
	_ struct{} `type:"structure"`

	// A value that describes the status of the IAM role's association with an Amazon
	// Redshift cluster.
	//
	// The following are possible statuses and descriptions.
	//
	//    * in-sync: The role is available for use by the cluster.
	//
	//    * adding: The role is in the process of being associated with the cluster.
	//
	//    * removing: The role is in the process of being disassociated with the
	//    cluster.
	ApplyStatus *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role, for example, arn:aws:iam::123456789012:role/RedshiftCopyUnload.
	IamRoleArn *string `type:"string"`
}

// String returns the string representation
func (s ClusterIamRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterIamRole) GoString() string {
	return s.String()
}

// SetApplyStatus sets the ApplyStatus field's value.
func (s *ClusterIamRole) SetApplyStatus(v string) *ClusterIamRole {
	s.ApplyStatus = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *ClusterIamRole) SetIamRoleArn(v string) *ClusterIamRole {
	s.IamRoleArn = &v
	return s
}

// The identifier of a node in a cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterNode
type ClusterNode struct {
	_ struct{} `type:"structure"`

	// Whether the node is a leader node or a compute node.
	NodeRole *string `type:"string"`

	// The private IP address of a node within a cluster.
	PrivateIPAddress *string `type:"string"`

	// The public IP address of a node within a cluster.
	PublicIPAddress *string `type:"string"`
}

// String returns the string representation
func (s ClusterNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterNode) GoString() string {
	return s.String()
}

// SetNodeRole sets the NodeRole field's value.
func (s *ClusterNode) SetNodeRole(v string) *ClusterNode {
	s.NodeRole = &v
	return s
}

// SetPrivateIPAddress sets the PrivateIPAddress field's value.
func (s *ClusterNode) SetPrivateIPAddress(v string) *ClusterNode {
	s.PrivateIPAddress = &v
	return s
}

// SetPublicIPAddress sets the PublicIPAddress field's value.
func (s *ClusterNode) SetPublicIPAddress(v string) *ClusterNode {
	s.PublicIPAddress = &v
	return s
}

// Describes a parameter group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterGroup
type ClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The description of the parameter group.
	Description *string `type:"string"`

	// The name of the cluster parameter group family that this cluster parameter
	// group is compatible with.
	ParameterGroupFamily *string `type:"string"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`

	// The list of tags for the cluster parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroup) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ClusterParameterGroup) SetDescription(v string) *ClusterParameterGroup {
	s.Description = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *ClusterParameterGroup) SetParameterGroupFamily(v string) *ClusterParameterGroup {
	s.ParameterGroupFamily = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ClusterParameterGroup) SetParameterGroupName(v string) *ClusterParameterGroup {
	s.ParameterGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClusterParameterGroup) SetTags(v []*Tag) *ClusterParameterGroup {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterGroupNameMessage
type ClusterParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`

	// The status of the parameter group. For example, if you made a change to a
	// parameter group name-value pair, then the change could be pending a reboot
	// of an associated cluster.
	ParameterGroupStatus *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroupNameMessage) GoString() string {
	return s.String()
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ClusterParameterGroupNameMessage) SetParameterGroupName(v string) *ClusterParameterGroupNameMessage {
	s.ParameterGroupName = &v
	return s
}

// SetParameterGroupStatus sets the ParameterGroupStatus field's value.
func (s *ClusterParameterGroupNameMessage) SetParameterGroupStatus(v string) *ClusterParameterGroupNameMessage {
	s.ParameterGroupStatus = &v
	return s
}

// Describes the status of a parameter group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterGroupStatus
type ClusterParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The list of parameter statuses.
	//
	// For more information about parameters and parameter groups, go to Amazon
	// Redshift Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ClusterParameterStatusList []*ClusterParameterStatus `type:"list"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`

	// The name of the cluster parameter group.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterGroupStatus) GoString() string {
	return s.String()
}

// SetClusterParameterStatusList sets the ClusterParameterStatusList field's value.
func (s *ClusterParameterGroupStatus) SetClusterParameterStatusList(v []*ClusterParameterStatus) *ClusterParameterGroupStatus {
	s.ClusterParameterStatusList = v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *ClusterParameterGroupStatus) SetParameterApplyStatus(v string) *ClusterParameterGroupStatus {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ClusterParameterGroupStatus) SetParameterGroupName(v string) *ClusterParameterGroupStatus {
	s.ParameterGroupName = &v
	return s
}

// Describes the status of a parameter group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterStatus
type ClusterParameterStatus struct {
	_ struct{} `type:"structure"`

	// The error that prevented the parameter from being applied to the database.
	ParameterApplyErrorDescription *string `type:"string"`

	// The status of the parameter that indicates whether the parameter is in sync
	// with the database, waiting for a cluster reboot, or encountered an error
	// when being applied.
	//
	// The following are possible statuses and descriptions.
	//
	//    * in-sync: The parameter value is in sync with the database.
	//
	//    * pending-reboot: The parameter value will be applied after the cluster
	//    reboots.
	//
	//    * applying: The parameter value is being applied to the database.
	//
	//    * invalid-parameter: Cannot apply the parameter value because it has an
	//    invalid value or syntax.
	//
	//    * apply-deferred: The parameter contains static property changes. The
	//    changes are deferred until the cluster reboots.
	//
	//    * apply-error: Cannot connect to the cluster. The parameter change will
	//    be applied after the cluster reboots.
	//
	//    * unknown-error: Cannot apply the parameter change right now. The change
	//    will be applied after the cluster reboots.
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`
}

// String returns the string representation
func (s ClusterParameterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterParameterStatus) GoString() string {
	return s.String()
}

// SetParameterApplyErrorDescription sets the ParameterApplyErrorDescription field's value.
func (s *ClusterParameterStatus) SetParameterApplyErrorDescription(v string) *ClusterParameterStatus {
	s.ParameterApplyErrorDescription = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *ClusterParameterStatus) SetParameterApplyStatus(v string) *ClusterParameterStatus {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *ClusterParameterStatus) SetParameterName(v string) *ClusterParameterStatus {
	s.ParameterName = &v
	return s
}

// Describes a security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterSecurityGroup
type ClusterSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group to which the operation was applied.
	ClusterSecurityGroupName *string `type:"string"`

	// A description of the security group.
	Description *string `type:"string"`

	// A list of EC2 security groups that are permitted to access clusters associated
	// with this cluster security group.
	EC2SecurityGroups []*EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// A list of IP ranges (CIDR blocks) that are permitted to access clusters associated
	// with this cluster security group.
	IPRanges []*IPRange `locationNameList:"IPRange" type:"list"`

	// The list of tags for the cluster security group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ClusterSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSecurityGroup) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *ClusterSecurityGroup) SetClusterSecurityGroupName(v string) *ClusterSecurityGroup {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterSecurityGroup) SetDescription(v string) *ClusterSecurityGroup {
	s.Description = &v
	return s
}

// SetEC2SecurityGroups sets the EC2SecurityGroups field's value.
func (s *ClusterSecurityGroup) SetEC2SecurityGroups(v []*EC2SecurityGroup) *ClusterSecurityGroup {
	s.EC2SecurityGroups = v
	return s
}

// SetIPRanges sets the IPRanges field's value.
func (s *ClusterSecurityGroup) SetIPRanges(v []*IPRange) *ClusterSecurityGroup {
	s.IPRanges = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClusterSecurityGroup) SetTags(v []*Tag) *ClusterSecurityGroup {
	s.Tags = v
	return s
}

// Describes a cluster security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterSecurityGroupMembership
type ClusterSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group.
	ClusterSecurityGroupName *string `type:"string"`

	// The status of the cluster security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ClusterSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *ClusterSecurityGroupMembership) SetClusterSecurityGroupName(v string) *ClusterSecurityGroupMembership {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClusterSecurityGroupMembership) SetStatus(v string) *ClusterSecurityGroupMembership {
	s.Status = &v
	return s
}

// Returns the destination region and retention period that are configured for
// cross-region snapshot copy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterSnapshotCopyStatus
type ClusterSnapshotCopyStatus struct {
	_ struct{} `type:"structure"`

	// The destination region that snapshots are automatically copied to when cross-region
	// snapshot copy is enabled.
	DestinationRegion *string `type:"string"`

	// The number of days that automated snapshots are retained in the destination
	// region after they are copied from a source region.
	RetentionPeriod *int64 `type:"long"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation
func (s ClusterSnapshotCopyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSnapshotCopyStatus) GoString() string {
	return s.String()
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *ClusterSnapshotCopyStatus) SetDestinationRegion(v string) *ClusterSnapshotCopyStatus {
	s.DestinationRegion = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *ClusterSnapshotCopyStatus) SetRetentionPeriod(v int64) *ClusterSnapshotCopyStatus {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *ClusterSnapshotCopyStatus) SetSnapshotCopyGrantName(v string) *ClusterSnapshotCopyStatus {
	s.SnapshotCopyGrantName = &v
	return s
}

// Describes a subnet group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterSubnetGroup
type ClusterSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group.
	ClusterSubnetGroupName *string `type:"string"`

	// The description of the cluster subnet group.
	Description *string `type:"string"`

	// The status of the cluster subnet group. Possible values are Complete, Incomplete
	// and Invalid.
	SubnetGroupStatus *string `type:"string"`

	// A list of the VPC Subnet elements.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// The list of tags for the cluster subnet group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The VPC ID of the cluster subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ClusterSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSubnetGroup) GoString() string {
	return s.String()
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *ClusterSubnetGroup) SetClusterSubnetGroupName(v string) *ClusterSubnetGroup {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterSubnetGroup) SetDescription(v string) *ClusterSubnetGroup {
	s.Description = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *ClusterSubnetGroup) SetSubnetGroupStatus(v string) *ClusterSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *ClusterSubnetGroup) SetSubnets(v []*Subnet) *ClusterSubnetGroup {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClusterSubnetGroup) SetTags(v []*Tag) *ClusterSubnetGroup {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ClusterSubnetGroup) SetVpcId(v string) *ClusterSubnetGroup {
	s.VpcId = &v
	return s
}

// Describes a cluster version, including the parameter group family and description
// of the version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterVersion
type ClusterVersion struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group family for the cluster.
	ClusterParameterGroupFamily *string `type:"string"`

	// The version number used by the cluster.
	ClusterVersion *string `type:"string"`

	// The description of the cluster version.
	Description *string `type:"string"`
}

// String returns the string representation
func (s ClusterVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterVersion) GoString() string {
	return s.String()
}

// SetClusterParameterGroupFamily sets the ClusterParameterGroupFamily field's value.
func (s *ClusterVersion) SetClusterParameterGroupFamily(v string) *ClusterVersion {
	s.ClusterParameterGroupFamily = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *ClusterVersion) SetClusterVersion(v string) *ClusterVersion {
	s.ClusterVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterVersion) SetDescription(v string) *ClusterVersion {
	s.Description = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshotMessage
type CopyClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster the source snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints:
	//
	//    * Must be the identifier for a valid cluster.
	SourceSnapshotClusterIdentifier *string `type:"string"`

	// The identifier for the source snapshot.
	//
	// Constraints:
	//
	//    * Must be the identifier for a valid automated snapshot whose state is
	//    available.
	//
	// SourceSnapshotIdentifier is a required field
	SourceSnapshotIdentifier *string `type:"string" required:"true"`

	// The identifier given to the new manual snapshot.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank.
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for the AWS account that is making the request.
	//
	// TargetSnapshotIdentifier is a required field
	TargetSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyClusterSnapshotInput"}
	if s.SourceSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceSnapshotIdentifier"))
	}
	if s.TargetSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceSnapshotClusterIdentifier sets the SourceSnapshotClusterIdentifier field's value.
func (s *CopyClusterSnapshotInput) SetSourceSnapshotClusterIdentifier(v string) *CopyClusterSnapshotInput {
	s.SourceSnapshotClusterIdentifier = &v
	return s
}

// SetSourceSnapshotIdentifier sets the SourceSnapshotIdentifier field's value.
func (s *CopyClusterSnapshotInput) SetSourceSnapshotIdentifier(v string) *CopyClusterSnapshotInput {
	s.SourceSnapshotIdentifier = &v
	return s
}

// SetTargetSnapshotIdentifier sets the TargetSnapshotIdentifier field's value.
func (s *CopyClusterSnapshotInput) SetTargetSnapshotIdentifier(v string) *CopyClusterSnapshotInput {
	s.TargetSnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshotResult
type CopyClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CopyClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CopyClusterSnapshotOutput) SetSnapshot(v *Snapshot) *CopyClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterMessage
type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `type:"string"`

	// If true, major version upgrades can be applied during the maintenance window
	// to the Amazon Redshift engine that is running on the cluster.
	//
	// When a new major version of the Amazon Redshift engine is released, you can
	// request that the service automatically apply upgrades during the maintenance
	// window to the Amazon Redshift engine that is running on your cluster.
	//
	// Default: true
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	// Default: 1
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision
	// the cluster. For example, if you have several EC2 instances running in a
	// specific Availability Zone, then you might want the cluster to be provisioned
	// in the same zone in order to decrease network latency.
	//
	// Default: A random, system-chosen Availability Zone in the region that is
	// specified by the endpoint.
	//
	// Example: us-east-1d
	//
	// Constraint: The specified Availability Zone must be in the same region as
	// the current endpoint.
	AvailabilityZone *string `type:"string"`

	// A unique identifier for the cluster. You use this identifier to refer to
	// the cluster for any subsequent cluster operations such as deleting or modifying.
	// The identifier also appears in the Amazon Redshift console.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// Example: myexamplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the parameter group to be associated with this cluster.
	//
	// Default: The default Amazon Redshift cluster parameter group. For information
	// about the default parameter group, go to Working with Amazon Redshift Parameter
	// Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ClusterParameterGroupName *string `type:"string"`

	// A list of security groups to be associated with this cluster.
	//
	// Default: The default cluster security group for Amazon Redshift.
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The name of a cluster subnet group to be associated with this cluster.
	//
	// If this parameter is not provided the resulting cluster will be deployed
	// outside virtual private cloud (VPC).
	ClusterSubnetGroupName *string `type:"string"`

	// The type of the cluster. When cluster type is specified as
	//
	//    * single-node, the NumberOfNodes parameter is not required.
	//
	//    * multi-node, the NumberOfNodes parameter is required.
	//
	// Valid Values: multi-node | single-node
	//
	// Default: multi-node
	ClusterType *string `type:"string"`

	// The version of the Amazon Redshift engine software that you want to deploy
	// on the cluster.
	//
	// The version selected runs on all the nodes in the cluster.
	//
	// Constraints: Only version 1.0 is currently available.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// The name of the first database to be created when the cluster is created.
	//
	// To create additional databases after the cluster is created, connect to the
	// cluster with a SQL client and use SQL commands to create a database. For
	// more information, go to Create a Database (http://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html)
	// in the Amazon Redshift Database Developer Guide.
	//
	// Default: dev
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 alphanumeric characters.
	//
	//    * Must contain only lowercase letters.
	//
	//    * Cannot be a word that is reserved by the service. A list of reserved
	//    words can be found in Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	DBName *string `type:"string"`

	// The Elastic IP (EIP) address for the cluster.
	//
	// Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
	// through an Internet gateway. For more information about provisioning clusters
	// in EC2-VPC, go to Supported Platforms to Launch Your Cluster (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms)
	// in the Amazon Redshift Cluster Management Guide.
	ElasticIp *string `type:"string"`

	// If true, the data in the cluster is encrypted at rest.
	//
	// Default: false
	Encrypted *bool `type:"boolean"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// A list of AWS Identity and Access Management (IAM) roles that can be used
	// by the cluster to access other AWS services. You must supply the IAM roles
	// in their Amazon Resource Name (ARN) format. You can supply up to 10 IAM roles
	// in a single request.
	//
	// A cluster can have up to 10 IAM roles associated with it at any time.
	IamRoles []*string `locationNameList:"IamRoleArn" type:"list"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that you
	// want to use to encrypt data in the cluster.
	KmsKeyId *string `type:"string"`

	// The password associated with the master user account for the cluster that
	// is being created.
	//
	// Constraints:
	//
	//    * Must be between 8 and 64 characters in length.
	//
	//    * Must contain at least one uppercase letter.
	//
	//    * Must contain at least one lowercase letter.
	//
	//    * Must contain one number.
	//
	//    * Can be any printable ASCII character (ASCII code 33 to 126) except '
	//    (single quote), " (double quote), \, /, @, or space.
	//
	// MasterUserPassword is a required field
	MasterUserPassword *string `type:"string" required:"true"`

	// The user name associated with the master user account for the cluster that
	// is being created.
	//
	// Constraints:
	//
	//    * Must be 1 - 128 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide.
	//
	// MasterUsername is a required field
	MasterUsername *string `type:"string" required:"true"`

	// The node type to be provisioned for the cluster. For information about node
	// types, go to  Working with Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// Valid Values: ds1.xlarge | ds1.8xlarge | ds2.xlarge | ds2.8xlarge | dc1.large
	// | dc1.8xlarge.
	//
	// NodeType is a required field
	NodeType *string `type:"string" required:"true"`

	// The number of compute nodes in the cluster. This parameter is required when
	// the ClusterType parameter is specified as multi-node.
	//
	// For information about determining how many nodes you need, go to  Working
	// with Clusters (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If you don't specify this parameter, you get a single-node cluster. When
	// requesting a multi-node cluster, you must specify the number of nodes that
	// you want in the cluster.
	//
	// Default: 1
	//
	// Constraints: Value must be at least 1 and no more than 100.
	NumberOfNodes *int64 `type:"integer"`

	// The port number on which the cluster accepts incoming connections.
	//
	// The cluster is accessible only via the JDBC and ODBC connection strings.
	// Part of the connection string requires the port on which the cluster will
	// listen for incoming connections.
	//
	// Default: 5439
	//
	// Valid Values: 1150-65535
	Port *int64 `type:"integer"`

	// The weekly time range (in UTC) during which automated cluster maintenance
	// can occur.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per region, occurring on a random day of the week. For more information about
	// the time blocks for each region, see Maintenance Windows (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows)
	// in Amazon Redshift Cluster Management Guide.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of Virtual Private Cloud (VPC) security groups to be associated with
	// the cluster.
	//
	// Default: The default VPC security group is associated with the cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.MasterUserPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUserPassword"))
	}
	if s.MasterUsername == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUsername"))
	}
	if s.NodeType == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *CreateClusterInput) SetAdditionalInfo(v string) *CreateClusterInput {
	s.AdditionalInfo = &v
	return s
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *CreateClusterInput) SetAllowVersionUpgrade(v bool) *CreateClusterInput {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *CreateClusterInput) SetAutomatedSnapshotRetentionPeriod(v int64) *CreateClusterInput {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateClusterInput) SetAvailabilityZone(v string) *CreateClusterInput {
	s.AvailabilityZone = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *CreateClusterInput) SetClusterIdentifier(v string) *CreateClusterInput {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterParameterGroupName sets the ClusterParameterGroupName field's value.
func (s *CreateClusterInput) SetClusterParameterGroupName(v string) *CreateClusterInput {
	s.ClusterParameterGroupName = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *CreateClusterInput) SetClusterSecurityGroups(v []*string) *CreateClusterInput {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *CreateClusterInput) SetClusterSubnetGroupName(v string) *CreateClusterInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *CreateClusterInput) SetClusterType(v string) *CreateClusterInput {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *CreateClusterInput) SetClusterVersion(v string) *CreateClusterInput {
	s.ClusterVersion = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *CreateClusterInput) SetDBName(v string) *CreateClusterInput {
	s.DBName = &v
	return s
}

// SetElasticIp sets the ElasticIp field's value.
func (s *CreateClusterInput) SetElasticIp(v string) *CreateClusterInput {
	s.ElasticIp = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *CreateClusterInput) SetEncrypted(v bool) *CreateClusterInput {
	s.Encrypted = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *CreateClusterInput) SetEnhancedVpcRouting(v bool) *CreateClusterInput {
	s.EnhancedVpcRouting = &v
	return s
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *CreateClusterInput) SetHsmClientCertificateIdentifier(v string) *CreateClusterInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *CreateClusterInput) SetHsmConfigurationIdentifier(v string) *CreateClusterInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *CreateClusterInput) SetIamRoles(v []*string) *CreateClusterInput {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateClusterInput) SetKmsKeyId(v string) *CreateClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateClusterInput) SetMasterUserPassword(v string) *CreateClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateClusterInput) SetMasterUsername(v string) *CreateClusterInput {
	s.MasterUsername = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *CreateClusterInput) SetNodeType(v string) *CreateClusterInput {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *CreateClusterInput) SetNumberOfNodes(v int64) *CreateClusterInput {
	s.NumberOfNodes = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateClusterInput) SetPort(v int64) *CreateClusterInput {
	s.Port = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateClusterInput) SetPreferredMaintenanceWindow(v string) *CreateClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateClusterInput) SetPubliclyAccessible(v bool) *CreateClusterInput {
	s.PubliclyAccessible = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v []*Tag) *CreateClusterInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateClusterInput) SetVpcSecurityGroupIds(v []*string) *CreateClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterResult
type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroupMessage
type CreateClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Redshift engine version to which the cluster parameter group applies.
	// The cluster engine version determines the set of parameters.
	//
	// To get a list of valid parameter group family names, you can call DescribeClusterParameterGroups.
	// By default, Amazon Redshift returns a list of all the parameter groups that
	// are owned by your AWS account, including the default parameter groups for
	// each Amazon Redshift engine version. The parameter group family names associated
	// with the default parameter groups provide you the valid values. For example,
	// a valid family name is "redshift-1.0".
	//
	// ParameterGroupFamily is a required field
	ParameterGroupFamily *string `type:"string" required:"true"`

	// The name of the cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique withing your AWS account.
	//
	// This value is stored as a lower-case string.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterParameterGroupInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.ParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupFamily"))
	}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateClusterParameterGroupInput) SetDescription(v string) *CreateClusterParameterGroupInput {
	s.Description = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *CreateClusterParameterGroupInput) SetParameterGroupFamily(v string) *CreateClusterParameterGroupInput {
	s.ParameterGroupFamily = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *CreateClusterParameterGroupInput) SetParameterGroupName(v string) *CreateClusterParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterParameterGroupInput) SetTags(v []*Tag) *CreateClusterParameterGroupInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroupResult
type CreateClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a parameter group.
	ClusterParameterGroup *ClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetClusterParameterGroup sets the ClusterParameterGroup field's value.
func (s *CreateClusterParameterGroupOutput) SetClusterParameterGroup(v *ClusterParameterGroup) *CreateClusterParameterGroupOutput {
	s.ClusterParameterGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroupMessage
type CreateClusterSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name for the security group. Amazon Redshift stores the value as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain no more than 255 alphanumeric characters or hyphens.
	//
	//    * Must not be "Default".
	//
	//    * Must be unique for all security groups that are created by your AWS
	//    account.
	//
	// Example: examplesecuritygroup
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// A description for the security group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterSecurityGroupInput"}
	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSecurityGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *CreateClusterSecurityGroupInput) SetClusterSecurityGroupName(v string) *CreateClusterSecurityGroupInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClusterSecurityGroupInput) SetDescription(v string) *CreateClusterSecurityGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterSecurityGroupInput) SetTags(v []*Tag) *CreateClusterSecurityGroupInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroupResult
type CreateClusterSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroup sets the ClusterSecurityGroup field's value.
func (s *CreateClusterSecurityGroupOutput) SetClusterSecurityGroup(v *ClusterSecurityGroup) *CreateClusterSecurityGroupOutput {
	s.ClusterSecurityGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshotMessage
type CreateClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier for which you want a snapshot.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// A unique identifier for the snapshot that you are requesting. This identifier
	// must be unique for all snapshots within the AWS account.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-snapshot-id
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterSnapshotInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *CreateClusterSnapshotInput) SetClusterIdentifier(v string) *CreateClusterSnapshotInput {
	s.ClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *CreateClusterSnapshotInput) SetSnapshotIdentifier(v string) *CreateClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterSnapshotInput) SetTags(v []*Tag) *CreateClusterSnapshotInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshotResult
type CreateClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CreateClusterSnapshotOutput) SetSnapshot(v *Snapshot) *CreateClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroupMessage
type CreateClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name for the subnet group. Amazon Redshift stores the value as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain no more than 255 alphanumeric characters or hyphens.
	//
	//    * Must not be "Default".
	//
	//    * Must be unique for all subnet groups that are created by your AWS account.
	//
	// Example: examplesubnetgroup
	//
	// ClusterSubnetGroupName is a required field
	ClusterSubnetGroupName *string `type:"string" required:"true"`

	// A description for the subnet group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
	// single request.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterSubnetGroupInput"}
	if s.ClusterSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSubnetGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *CreateClusterSubnetGroupInput) SetClusterSubnetGroupName(v string) *CreateClusterSubnetGroupInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClusterSubnetGroupInput) SetDescription(v string) *CreateClusterSubnetGroupInput {
	s.Description = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateClusterSubnetGroupInput) SetSubnetIds(v []*string) *CreateClusterSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterSubnetGroupInput) SetTags(v []*Tag) *CreateClusterSubnetGroupInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroupResult
type CreateClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a subnet group.
	ClusterSubnetGroup *ClusterSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetClusterSubnetGroup sets the ClusterSubnetGroup field's value.
func (s *CreateClusterSubnetGroupOutput) SetClusterSubnetGroup(v *ClusterSubnetGroup) *CreateClusterSubnetGroupOutput {
	s.ClusterSubnetGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscriptionMessage
type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, set to false to
	// create the subscription but not active it.
	Enabled *bool `type:"boolean"`

	// Specifies the Amazon Redshift event categories to be published by the event
	// notification subscription.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Specifies the Amazon Redshift event severity to be published by the event
	// notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the
	// event notifications. The ARN is created by Amazon SNS when you create a topic
	// and subscribe to it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// A list of one or more identifiers of Amazon Redshift source objects. All
	// of the objects must be of the same type as was specified in the source type
	// parameter. The event subscription will return only events generated by the
	// specified objects. If not specified, then events are returned for all objects
	// within the source type specified.
	//
	// Example: my-cluster-1, my-cluster-2
	//
	// Example: my-snapshot-20131010
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a cluster, you would set this
	// parameter to cluster. If this value is not specified, events are returned
	// for all Amazon Redshift objects in your AWS account. You must specify a source
	// type in order to specify source IDs.
	//
	// Valid values: cluster, cluster-parameter-group, cluster-security-group, and
	// cluster-snapshot.
	SourceType *string `type:"string"`

	// The name of the event subscription to be created.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank.
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSubscriptionInput) SetEnabled(v bool) *CreateEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *CreateEventSubscriptionInput) SetEventCategories(v []*string) *CreateEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *CreateEventSubscriptionInput) SetSeverity(v string) *CreateEventSubscriptionInput {
	s.Severity = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateEventSubscriptionInput) SetSnsTopicArn(v string) *CreateEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *CreateEventSubscriptionInput) SetSourceIds(v []*string) *CreateEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateEventSubscriptionInput) SetSourceType(v string) *CreateEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *CreateEventSubscriptionInput) SetSubscriptionName(v string) *CreateEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventSubscriptionInput) SetTags(v []*Tag) *CreateEventSubscriptionInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscriptionResult
type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Describes event subscriptions.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *CreateEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *CreateEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificateMessage
type CreateHsmClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier to be assigned to the new HSM client certificate that the
	// cluster will use to connect to the HSM to use the database encryption keys.
	//
	// HsmClientCertificateIdentifier is a required field
	HsmClientCertificateIdentifier *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateHsmClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmClientCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmClientCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHsmClientCertificateInput"}
	if s.HsmClientCertificateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmClientCertificateIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *CreateHsmClientCertificateInput) SetHsmClientCertificateIdentifier(v string) *CreateHsmClientCertificateInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHsmClientCertificateInput) SetTags(v []*Tag) *CreateHsmClientCertificateInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificateResult
type CreateHsmClientCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about an HSM client certificate. The certificate is stored
	// in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift
	// cluster to encrypt data files.
	HsmClientCertificate *HsmClientCertificate `type:"structure"`
}

// String returns the string representation
func (s CreateHsmClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmClientCertificateOutput) GoString() string {
	return s.String()
}

// SetHsmClientCertificate sets the HsmClientCertificate field's value.
func (s *CreateHsmClientCertificateOutput) SetHsmClientCertificate(v *HsmClientCertificate) *CreateHsmClientCertificateOutput {
	s.HsmClientCertificate = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfigurationMessage
type CreateHsmConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A text description of the HSM configuration to be created.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The identifier to be assigned to the new Amazon Redshift HSM configuration.
	//
	// HsmConfigurationIdentifier is a required field
	HsmConfigurationIdentifier *string `type:"string" required:"true"`

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	//
	// HsmIpAddress is a required field
	HsmIpAddress *string `type:"string" required:"true"`

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	//
	// HsmPartitionName is a required field
	HsmPartitionName *string `type:"string" required:"true"`

	// The password required to access the HSM partition.
	//
	// HsmPartitionPassword is a required field
	HsmPartitionPassword *string `type:"string" required:"true"`

	// The HSMs public certificate file. When using Cloud HSM, the file name is
	// server.pem.
	//
	// HsmServerPublicCertificate is a required field
	HsmServerPublicCertificate *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateHsmConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHsmConfigurationInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.HsmConfigurationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmConfigurationIdentifier"))
	}
	if s.HsmIpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmIpAddress"))
	}
	if s.HsmPartitionName == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmPartitionName"))
	}
	if s.HsmPartitionPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmPartitionPassword"))
	}
	if s.HsmServerPublicCertificate == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmServerPublicCertificate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateHsmConfigurationInput) SetDescription(v string) *CreateHsmConfigurationInput {
	s.Description = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *CreateHsmConfigurationInput) SetHsmConfigurationIdentifier(v string) *CreateHsmConfigurationInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetHsmIpAddress sets the HsmIpAddress field's value.
func (s *CreateHsmConfigurationInput) SetHsmIpAddress(v string) *CreateHsmConfigurationInput {
	s.HsmIpAddress = &v
	return s
}

// SetHsmPartitionName sets the HsmPartitionName field's value.
func (s *CreateHsmConfigurationInput) SetHsmPartitionName(v string) *CreateHsmConfigurationInput {
	s.HsmPartitionName = &v
	return s
}

// SetHsmPartitionPassword sets the HsmPartitionPassword field's value.
func (s *CreateHsmConfigurationInput) SetHsmPartitionPassword(v string) *CreateHsmConfigurationInput {
	s.HsmPartitionPassword = &v
	return s
}

// SetHsmServerPublicCertificate sets the HsmServerPublicCertificate field's value.
func (s *CreateHsmConfigurationInput) SetHsmServerPublicCertificate(v string) *CreateHsmConfigurationInput {
	s.HsmServerPublicCertificate = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHsmConfigurationInput) SetTags(v []*Tag) *CreateHsmConfigurationInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfigurationResult
type CreateHsmConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about an HSM configuration, which is an object that describes
	// to Amazon Redshift clusters the information they require to connect to an
	// HSM where they can store database encryption keys.
	HsmConfiguration *HsmConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateHsmConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmConfigurationOutput) GoString() string {
	return s.String()
}

// SetHsmConfiguration sets the HsmConfiguration field's value.
func (s *CreateHsmConfigurationOutput) SetHsmConfiguration(v *HsmConfiguration) *CreateHsmConfigurationOutput {
	s.HsmConfiguration = v
	return s
}

// The result of the CreateSnapshotCopyGrant action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrantMessage
type CreateSnapshotCopyGrantInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the customer master key (CMK) to which to grant
	// Amazon Redshift permission. If no key is specified, the default key is used.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot copy grant. This name must be unique in the region
	// for the AWS account.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// SnapshotCopyGrantName is a required field
	SnapshotCopyGrantName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateSnapshotCopyGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotCopyGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotCopyGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotCopyGrantInput"}
	if s.SnapshotCopyGrantName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotCopyGrantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateSnapshotCopyGrantInput) SetKmsKeyId(v string) *CreateSnapshotCopyGrantInput {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *CreateSnapshotCopyGrantInput) SetSnapshotCopyGrantName(v string) *CreateSnapshotCopyGrantInput {
	s.SnapshotCopyGrantName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotCopyGrantInput) SetTags(v []*Tag) *CreateSnapshotCopyGrantInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrantResult
type CreateSnapshotCopyGrantOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot copy grant that grants Amazon Redshift permission to encrypt
	// copied snapshots with the specified customer master key (CMK) from AWS KMS
	// in the destination region.
	//
	// For more information about managing snapshot copy grants, go to Amazon Redshift
	// Database Encryption (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
	// in the Amazon Redshift Cluster Management Guide.
	SnapshotCopyGrant *SnapshotCopyGrant `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotCopyGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotCopyGrantOutput) GoString() string {
	return s.String()
}

// SetSnapshotCopyGrant sets the SnapshotCopyGrant field's value.
func (s *CreateSnapshotCopyGrantOutput) SetSnapshotCopyGrant(v *SnapshotCopyGrant) *CreateSnapshotCopyGrantOutput {
	s.SnapshotCopyGrant = v
	return s
}

// Contains the output from the CreateTags action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTagsMessage
type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) to which you want to add the tag or tags.
	// For example, arn:aws:redshift:us-east-1:123456789:cluster:t1.
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// One or more name/value pairs to add as tags to the specified resource. Each
	// tag name is passed in with the parameter Key and the corresponding value
	// is passed in with the parameter Value. The Key and Value parameters are separated
	// by a comma (,). Separate multiple tags with a space. For example, --tags
	// "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0".
	//
	// Tags is a required field
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *CreateTagsInput) SetResourceName(v string) *CreateTagsInput {
	s.ResourceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTagsOutput
type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

// Describes the default cluster parameters for a parameter group family.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DefaultClusterParameters
type DefaultClusterParameters struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The name of the cluster parameter group family to which the engine default
	// parameters apply.
	ParameterGroupFamily *string `type:"string"`

	// The list of cluster default parameters.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DefaultClusterParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultClusterParameters) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DefaultClusterParameters) SetMarker(v string) *DefaultClusterParameters {
	s.Marker = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *DefaultClusterParameters) SetParameterGroupFamily(v string) *DefaultClusterParameters {
	s.ParameterGroupFamily = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DefaultClusterParameters) SetParameters(v []*Parameter) *DefaultClusterParameters {
	s.Parameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterMessage
type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to be deleted.
	//
	// Constraints:
	//
	//    * Must contain lowercase characters.
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the final snapshot that is to be created immediately before
	// deleting the cluster. If this parameter is provided, SkipFinalClusterSnapshot
	// must be false.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	FinalClusterSnapshotIdentifier *string `type:"string"`

	// Determines whether a final snapshot of the cluster is created before Amazon
	// Redshift deletes the cluster. If true, a final cluster snapshot is not created.
	// If false, a final cluster snapshot is created before the cluster is deleted.
	//
	// The FinalClusterSnapshotIdentifier parameter must be specified if SkipFinalClusterSnapshot
	// is false.
	//
	// Default: false
	SkipFinalClusterSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DeleteClusterInput) SetClusterIdentifier(v string) *DeleteClusterInput {
	s.ClusterIdentifier = &v
	return s
}

// SetFinalClusterSnapshotIdentifier sets the FinalClusterSnapshotIdentifier field's value.
func (s *DeleteClusterInput) SetFinalClusterSnapshotIdentifier(v string) *DeleteClusterInput {
	s.FinalClusterSnapshotIdentifier = &v
	return s
}

// SetSkipFinalClusterSnapshot sets the SkipFinalClusterSnapshot field's value.
func (s *DeleteClusterInput) SetSkipFinalClusterSnapshot(v bool) *DeleteClusterInput {
	s.SkipFinalClusterSnapshot = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterResult
type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroupMessage
type DeleteClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to be deleted.
	//
	// Constraints:
	//
	//    * Must be the name of an existing cluster parameter group.
	//
	//    * Cannot delete a default cluster parameter group.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DeleteClusterParameterGroupInput) SetParameterGroupName(v string) *DeleteClusterParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroupOutput
type DeleteClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroupMessage
type DeleteClusterSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster security group to be deleted.
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterSecurityGroupInput"}
	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *DeleteClusterSecurityGroupInput) SetClusterSecurityGroupName(v string) *DeleteClusterSecurityGroupInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroupOutput
type DeleteClusterSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSecurityGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshotMessage
type DeleteClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster the snapshot was created from. This
	// parameter is required if your IAM user has a policy containing a snapshot
	// resource element that specifies anything other than * for the cluster name.
	//
	// Constraints: Must be the name of valid cluster.
	SnapshotClusterIdentifier *string `type:"string"`

	// The unique identifier of the manual snapshot to be deleted.
	//
	// Constraints: Must be the name of an existing snapshot that is in the available
	// state.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterSnapshotInput"}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *DeleteClusterSnapshotInput) SetSnapshotClusterIdentifier(v string) *DeleteClusterSnapshotInput {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *DeleteClusterSnapshotInput) SetSnapshotIdentifier(v string) *DeleteClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshotResult
type DeleteClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *DeleteClusterSnapshotOutput) SetSnapshot(v *Snapshot) *DeleteClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroupMessage
type DeleteClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group name to be deleted.
	//
	// ClusterSubnetGroupName is a required field
	ClusterSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterSubnetGroupInput"}
	if s.ClusterSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *DeleteClusterSubnetGroupInput) SetClusterSubnetGroupName(v string) *DeleteClusterSubnetGroupInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroupOutput
type DeleteClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscriptionMessage
type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Redshift event notification subscription to be deleted.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DeleteEventSubscriptionInput) SetSubscriptionName(v string) *DeleteEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscriptionOutput
type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificateMessage
type DeleteHsmClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the HSM client certificate to be deleted.
	//
	// HsmClientCertificateIdentifier is a required field
	HsmClientCertificateIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmClientCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmClientCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHsmClientCertificateInput"}
	if s.HsmClientCertificateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmClientCertificateIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *DeleteHsmClientCertificateInput) SetHsmClientCertificateIdentifier(v string) *DeleteHsmClientCertificateInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificateOutput
type DeleteHsmClientCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHsmClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmClientCertificateOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfigurationMessage
type DeleteHsmConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift HSM configuration to be deleted.
	//
	// HsmConfigurationIdentifier is a required field
	HsmConfigurationIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHsmConfigurationInput"}
	if s.HsmConfigurationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmConfigurationIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *DeleteHsmConfigurationInput) SetHsmConfigurationIdentifier(v string) *DeleteHsmConfigurationInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfigurationOutput
type DeleteHsmConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHsmConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmConfigurationOutput) GoString() string {
	return s.String()
}

// The result of the DeleteSnapshotCopyGrant action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrantMessage
type DeleteSnapshotCopyGrantInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot copy grant to delete.
	//
	// SnapshotCopyGrantName is a required field
	SnapshotCopyGrantName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotCopyGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotCopyGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotCopyGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotCopyGrantInput"}
	if s.SnapshotCopyGrantName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotCopyGrantName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *DeleteSnapshotCopyGrantInput) SetSnapshotCopyGrantName(v string) *DeleteSnapshotCopyGrantInput {
	s.SnapshotCopyGrantName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrantOutput
type DeleteSnapshotCopyGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotCopyGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotCopyGrantOutput) GoString() string {
	return s.String()
}

// Contains the output from the DeleteTags action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTagsMessage
type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) from which you want to remove the tag or tags.
	// For example, arn:aws:redshift:us-east-1:123456789:cluster:t1.
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tag key that you want to delete.
	//
	// TagKeys is a required field
	TagKeys []*string `locationNameList:"TagKey" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *DeleteTagsInput) SetResourceName(v string) *DeleteTagsInput {
	s.ResourceName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTagsOutput
type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroupsMessage
type DescribeClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterParameterGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of a specific parameter group for which to return details. By default,
	// details about all parameter groups and the default parameter group are returned.
	ParameterGroupName *string `type:"string"`

	// A tag key or keys for which you want to return all matching cluster parameter
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have parameter groups that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the parameter groups that have either or
	// both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster parameter
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have parameter groups that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the parameter groups that have either or
	// both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParameterGroupsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterParameterGroupsInput) SetMarker(v string) *DescribeClusterParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterParameterGroupsInput) SetMaxRecords(v int64) *DescribeClusterParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DescribeClusterParameterGroupsInput) SetParameterGroupName(v string) *DescribeClusterParameterGroupsInput {
	s.ParameterGroupName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClusterParameterGroupsInput) SetTagKeys(v []*string) *DescribeClusterParameterGroupsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClusterParameterGroupsInput) SetTagValues(v []*string) *DescribeClusterParameterGroupsInput {
	s.TagValues = v
	return s
}

// Contains the output from the DescribeClusterParameterGroups action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterGroupsMessage
type DescribeClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of ClusterParameterGroup instances. Each instance describes one cluster
	// parameter group.
	ParameterGroups []*ClusterParameterGroup `locationNameList:"ClusterParameterGroup" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterParameterGroupsOutput) SetMarker(v string) *DescribeClusterParameterGroupsOutput {
	s.Marker = &v
	return s
}

// SetParameterGroups sets the ParameterGroups field's value.
func (s *DescribeClusterParameterGroupsOutput) SetParameterGroups(v []*ClusterParameterGroup) *DescribeClusterParameterGroupsOutput {
	s.ParameterGroups = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParametersMessage
type DescribeClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterParameters request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of a cluster parameter group for which to return details.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// The parameter types to return. Specify user to show parameters that are different
	// form the default. Similarly, specify engine-default to show parameters that
	// are the same as the default parameter group.
	//
	// Default: All parameter types returned.
	//
	// Valid Values: user | engine-default
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterParametersInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterParametersInput) SetMarker(v string) *DescribeClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterParametersInput) SetMaxRecords(v int64) *DescribeClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DescribeClusterParametersInput) SetParameterGroupName(v string) *DescribeClusterParametersInput {
	s.ParameterGroupName = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeClusterParametersInput) SetSource(v string) *DescribeClusterParametersInput {
	s.Source = &v
	return s
}

// Contains the output from the DescribeClusterParameters action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterGroupDetails
type DescribeClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of Parameter instances. Each instance lists the parameters of one
	// cluster parameter group.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterParametersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterParametersOutput) SetMarker(v string) *DescribeClusterParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeClusterParametersOutput) SetParameters(v []*Parameter) *DescribeClusterParametersOutput {
	s.Parameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroupsMessage
type DescribeClusterSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a cluster security group for which you are requesting details.
	// You can specify either the Marker parameter or a ClusterSecurityGroupName
	// parameter, but not both.
	//
	// Example: securitygroup1
	ClusterSecurityGroupName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSecurityGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the ClusterSecurityGroupName parameter
	// or the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching cluster security
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have security groups that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the security groups that have either or
	// both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster security
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have security groups that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the security groups that have either or
	// both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSecurityGroupsInput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *DescribeClusterSecurityGroupsInput) SetClusterSecurityGroupName(v string) *DescribeClusterSecurityGroupsInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSecurityGroupsInput) SetMarker(v string) *DescribeClusterSecurityGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterSecurityGroupsInput) SetMaxRecords(v int64) *DescribeClusterSecurityGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClusterSecurityGroupsInput) SetTagKeys(v []*string) *DescribeClusterSecurityGroupsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClusterSecurityGroupsInput) SetTagValues(v []*string) *DescribeClusterSecurityGroupsInput {
	s.TagValues = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterSecurityGroupMessage
type DescribeClusterSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ClusterSecurityGroup instances.
	ClusterSecurityGroups []*ClusterSecurityGroup `locationNameList:"ClusterSecurityGroup" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *DescribeClusterSecurityGroupsOutput) SetClusterSecurityGroups(v []*ClusterSecurityGroup) *DescribeClusterSecurityGroupsOutput {
	s.ClusterSecurityGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSecurityGroupsOutput) SetMarker(v string) *DescribeClusterSecurityGroupsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshotsMessage
type DescribeClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which information about snapshots is requested.
	ClusterIdentifier *string `type:"string"`

	// A time value that requests only snapshots created at or before the specified
	// time. The time value is specified in ISO 8601 format. For more information
	// about ISO 8601, go to the ISO8601 Wikipedia page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2012-07-16T18:00:00Z
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSnapshots request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The AWS customer account used to create or copy the snapshot. Use this field
	// to filter the results to snapshots owned by a particular account. To describe
	// snapshots you own, either specify your AWS customer account, or do not specify
	// the parameter.
	OwnerAccount *string `type:"string"`

	// The snapshot identifier of the snapshot about which to return information.
	SnapshotIdentifier *string `type:"string"`

	// The type of snapshots for which you are requesting information. By default,
	// snapshots of all types are returned.
	//
	// Valid Values: automated | manual
	SnapshotType *string `type:"string"`

	// A value that requests only snapshots created at or after the specified time.
	// The time value is specified in ISO 8601 format. For more information about
	// ISO 8601, go to the ISO8601 Wikipedia page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2012-07-16T18:00:00Z
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A tag key or keys for which you want to return all matching cluster snapshots
	// that are associated with the specified key or keys. For example, suppose
	// that you have snapshots that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the snapshots that have either or both of these tag keys
	// associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster snapshots
	// that are associated with the specified tag value or values. For example,
	// suppose that you have snapshots that are tagged with values called admin
	// and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the snapshots that have either or both of
	// these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSnapshotsInput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeClusterSnapshotsInput) SetClusterIdentifier(v string) *DescribeClusterSnapshotsInput {
	s.ClusterIdentifier = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeClusterSnapshotsInput) SetEndTime(v time.Time) *DescribeClusterSnapshotsInput {
	s.EndTime = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSnapshotsInput) SetMarker(v string) *DescribeClusterSnapshotsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterSnapshotsInput) SetMaxRecords(v int64) *DescribeClusterSnapshotsInput {
	s.MaxRecords = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *DescribeClusterSnapshotsInput) SetOwnerAccount(v string) *DescribeClusterSnapshotsInput {
	s.OwnerAccount = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *DescribeClusterSnapshotsInput) SetSnapshotIdentifier(v string) *DescribeClusterSnapshotsInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DescribeClusterSnapshotsInput) SetSnapshotType(v string) *DescribeClusterSnapshotsInput {
	s.SnapshotType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeClusterSnapshotsInput) SetStartTime(v time.Time) *DescribeClusterSnapshotsInput {
	s.StartTime = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClusterSnapshotsInput) SetTagKeys(v []*string) *DescribeClusterSnapshotsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClusterSnapshotsInput) SetTagValues(v []*string) *DescribeClusterSnapshotsInput {
	s.TagValues = v
	return s
}

// Contains the output from the DescribeClusterSnapshots action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/SnapshotMessage
type DescribeClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of Snapshot instances.
	Snapshots []*Snapshot `locationNameList:"Snapshot" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSnapshotsOutput) SetMarker(v string) *DescribeClusterSnapshotsOutput {
	s.Marker = &v
	return s
}

// SetSnapshots sets the Snapshots field's value.
func (s *DescribeClusterSnapshotsOutput) SetSnapshots(v []*Snapshot) *DescribeClusterSnapshotsOutput {
	s.Snapshots = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroupsMessage
type DescribeClusterSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group for which information is requested.
	ClusterSubnetGroupName *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterSubnetGroups request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching cluster subnet
	// groups that are associated with the specified key or keys. For example, suppose
	// that you have subnet groups that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the subnet groups that have either or both of these tag keys
	// associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching cluster subnet
	// groups that are associated with the specified tag value or values. For example,
	// suppose that you have subnet groups that are tagged with values called admin
	// and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the subnet groups that have either or both
	// of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClusterSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSubnetGroupsInput) GoString() string {
	return s.String()
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *DescribeClusterSubnetGroupsInput) SetClusterSubnetGroupName(v string) *DescribeClusterSubnetGroupsInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSubnetGroupsInput) SetMarker(v string) *DescribeClusterSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterSubnetGroupsInput) SetMaxRecords(v int64) *DescribeClusterSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClusterSubnetGroupsInput) SetTagKeys(v []*string) *DescribeClusterSubnetGroupsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClusterSubnetGroupsInput) SetTagValues(v []*string) *DescribeClusterSubnetGroupsInput {
	s.TagValues = v
	return s
}

// Contains the output from the DescribeClusterSubnetGroups action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterSubnetGroupMessage
type DescribeClusterSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ClusterSubnetGroup instances.
	ClusterSubnetGroups []*ClusterSubnetGroup `locationNameList:"ClusterSubnetGroup" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetClusterSubnetGroups sets the ClusterSubnetGroups field's value.
func (s *DescribeClusterSubnetGroupsOutput) SetClusterSubnetGroups(v []*ClusterSubnetGroup) *DescribeClusterSubnetGroupsOutput {
	s.ClusterSubnetGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterSubnetGroupsOutput) SetMarker(v string) *DescribeClusterSubnetGroupsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersionsMessage
type DescribeClusterVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific cluster parameter group family to return details for.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	ClusterParameterGroupFamily *string `type:"string"`

	// The specific cluster version to return.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusterVersions request exceed
	// the value specified in MaxRecords, AWS returns a value in the Marker field
	// of the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeClusterVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterVersionsInput) GoString() string {
	return s.String()
}

// SetClusterParameterGroupFamily sets the ClusterParameterGroupFamily field's value.
func (s *DescribeClusterVersionsInput) SetClusterParameterGroupFamily(v string) *DescribeClusterVersionsInput {
	s.ClusterParameterGroupFamily = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *DescribeClusterVersionsInput) SetClusterVersion(v string) *DescribeClusterVersionsInput {
	s.ClusterVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterVersionsInput) SetMarker(v string) *DescribeClusterVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClusterVersionsInput) SetMaxRecords(v int64) *DescribeClusterVersionsInput {
	s.MaxRecords = &v
	return s
}

// Contains the output from the DescribeClusterVersions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterVersionsMessage
type DescribeClusterVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Version elements.
	ClusterVersions []*ClusterVersion `locationNameList:"ClusterVersion" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClusterVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterVersionsOutput) GoString() string {
	return s.String()
}

// SetClusterVersions sets the ClusterVersions field's value.
func (s *DescribeClusterVersionsOutput) SetClusterVersions(v []*ClusterVersion) *DescribeClusterVersionsOutput {
	s.ClusterVersions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClusterVersionsOutput) SetMarker(v string) *DescribeClusterVersionsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClustersMessage
type DescribeClustersInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a cluster whose properties you are requesting. This
	// parameter is case sensitive.
	//
	// The default is that all clusters defined for an account are returned.
	ClusterIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeClusters request exceed the
	// value specified in MaxRecords, AWS returns a value in the Marker field of
	// the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	//
	// Constraints: You can specify either the ClusterIdentifier parameter or the
	// Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching clusters that
	// are associated with the specified key or keys. For example, suppose that
	// you have clusters that are tagged with keys called owner and environment.
	// If you specify both of these tag keys in the request, Amazon Redshift returns
	// a response with the clusters that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching clusters
	// that are associated with the specified tag value or values. For example,
	// suppose that you have clusters that are tagged with values called admin and
	// test. If you specify both of these tag values in the request, Amazon Redshift
	// returns a response with the clusters that have either or both of these tag
	// values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClustersInput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeClustersInput) SetClusterIdentifier(v string) *DescribeClustersInput {
	s.ClusterIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClustersInput) SetMarker(v string) *DescribeClustersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeClustersInput) SetMaxRecords(v int64) *DescribeClustersInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeClustersInput) SetTagKeys(v []*string) *DescribeClustersInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeClustersInput) SetTagValues(v []*string) *DescribeClustersInput {
	s.TagValues = v
	return s
}

// Contains the output from the DescribeClusters action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClustersMessage
type DescribeClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of Cluster objects, where each object describes one cluster.
	Clusters []*Cluster `locationNameList:"Cluster" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *DescribeClustersOutput) SetClusters(v []*Cluster) *DescribeClustersOutput {
	s.Clusters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeClustersOutput) SetMarker(v string) *DescribeClustersOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParametersMessage
type DescribeDefaultClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeDefaultClusterParameters
	// request exceed the value specified in MaxRecords, AWS returns a value in
	// the Marker field of the response. You can retrieve the next set of response
	// records by providing the returned marker value in the Marker parameter and
	// retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the cluster parameter group family.
	//
	// ParameterGroupFamily is a required field
	ParameterGroupFamily *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDefaultClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDefaultClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDefaultClusterParametersInput"}
	if s.ParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupFamily"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *DescribeDefaultClusterParametersInput) SetMarker(v string) *DescribeDefaultClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDefaultClusterParametersInput) SetMaxRecords(v int64) *DescribeDefaultClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *DescribeDefaultClusterParametersInput) SetParameterGroupFamily(v string) *DescribeDefaultClusterParametersInput {
	s.ParameterGroupFamily = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParametersResult
type DescribeDefaultClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// Describes the default cluster parameters for a parameter group family.
	DefaultClusterParameters *DefaultClusterParameters `type:"structure"`
}

// String returns the string representation
func (s DescribeDefaultClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultClusterParametersOutput) GoString() string {
	return s.String()
}

// SetDefaultClusterParameters sets the DefaultClusterParameters field's value.
func (s *DescribeDefaultClusterParametersOutput) SetDefaultClusterParameters(v *DefaultClusterParameters) *DescribeDefaultClusterParametersOutput {
	s.DefaultClusterParameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategoriesMessage
type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// The source type, such as cluster or parameter group, to which the described
	// event categories apply.
	//
	// Valid values: cluster, cluster-snapshot, cluster-parameter-group, and cluster-security-group.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventCategoriesInput) SetSourceType(v string) *DescribeEventCategoriesInput {
	s.SourceType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EventCategoriesMessage
type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of event categories descriptions.
	EventCategoriesMapList []*EventCategoriesMap `locationNameList:"EventCategoriesMap" type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

// SetEventCategoriesMapList sets the EventCategoriesMapList field's value.
func (s *DescribeEventCategoriesOutput) SetEventCategoriesMapList(v []*EventCategoriesMap) *DescribeEventCategoriesOutput {
	s.EventCategoriesMapList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptionsMessage
type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeEventSubscriptions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the Amazon Redshift event notification subscription to be described.
	SubscriptionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsInput) SetMarker(v string) *DescribeEventSubscriptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventSubscriptionsInput) SetMaxRecords(v int64) *DescribeEventSubscriptionsInput {
	s.MaxRecords = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DescribeEventSubscriptionsInput) SetSubscriptionName(v string) *DescribeEventSubscriptionsInput {
	s.SubscriptionName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EventSubscriptionsMessage
type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of event subscriptions.
	EventSubscriptionsList []*EventSubscription `locationNameList:"EventSubscription" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetEventSubscriptionsList sets the EventSubscriptionsList field's value.
func (s *DescribeEventSubscriptionsOutput) SetEventSubscriptionsList(v []*EventSubscription) *DescribeEventSubscriptionsOutput {
	s.EventSubscriptionsList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsOutput) SetMarker(v string) *DescribeEventSubscriptionsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventsMessage
type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes prior to the time of the request for which to retrieve
	// events. For example, if the request is sent at 18:00 and you specify a duration
	// of 60, then only events which have occurred after 17:00 will be returned.
	//
	// Default: 60
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeEvents request exceed the
	// value specified in MaxRecords, AWS returns a value in the Marker field of
	// the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events will be returned. If
	// this parameter is not specified, then all sources are included in the response.
	//
	// Constraints:
	//
	// If SourceIdentifier is supplied, SourceType must also be provided.
	//
	//    * Specify a cluster identifier when SourceType is cluster.
	//
	//    * Specify a cluster security group name when SourceType is cluster-security-group.
	//
	//    * Specify a cluster parameter group name when SourceType is cluster-parameter-group.
	//
	//    * Specify a cluster snapshot identifier when SourceType is cluster-snapshot.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	//
	// Constraints:
	//
	// If SourceType is supplied, SourceIdentifier must also be provided.
	//
	//    * Specify cluster when SourceIdentifier is a cluster identifier.
	//
	//    * Specify cluster-security-group when SourceIdentifier is a cluster security
	//    group name.
	//
	//    * Specify cluster-parameter-group when SourceIdentifier is a cluster parameter
	//    group name.
	//
	//    * Specify cluster-snapshot when SourceIdentifier is a cluster snapshot
	//    identifier.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EventsMessage
type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Event instances.
	Events []*Event `locationNameList:"Event" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificatesMessage
type DescribeHsmClientCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a specific HSM client certificate for which you want information.
	// If no identifier is specified, information is returned for all HSM client
	// certificates owned by your AWS customer account.
	HsmClientCertificateIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeHsmClientCertificates request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching HSM client certificates
	// that are associated with the specified key or keys. For example, suppose
	// that you have HSM client certificates that are tagged with keys called owner
	// and environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the HSM client certificates that have either
	// or both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching HSM client
	// certificates that are associated with the specified tag value or values.
	// For example, suppose that you have HSM client certificates that are tagged
	// with values called admin and test. If you specify both of these tag values
	// in the request, Amazon Redshift returns a response with the HSM client certificates
	// that have either or both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeHsmClientCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmClientCertificatesInput) GoString() string {
	return s.String()
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *DescribeHsmClientCertificatesInput) SetHsmClientCertificateIdentifier(v string) *DescribeHsmClientCertificatesInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeHsmClientCertificatesInput) SetMarker(v string) *DescribeHsmClientCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeHsmClientCertificatesInput) SetMaxRecords(v int64) *DescribeHsmClientCertificatesInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeHsmClientCertificatesInput) SetTagKeys(v []*string) *DescribeHsmClientCertificatesInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeHsmClientCertificatesInput) SetTagValues(v []*string) *DescribeHsmClientCertificatesInput {
	s.TagValues = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/HsmClientCertificateMessage
type DescribeHsmClientCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the identifiers for one or more HSM client certificates used by
	// Amazon Redshift clusters to store and retrieve database encryption keys in
	// an HSM.
	HsmClientCertificates []*HsmClientCertificate `locationNameList:"HsmClientCertificate" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmClientCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmClientCertificatesOutput) GoString() string {
	return s.String()
}

// SetHsmClientCertificates sets the HsmClientCertificates field's value.
func (s *DescribeHsmClientCertificatesOutput) SetHsmClientCertificates(v []*HsmClientCertificate) *DescribeHsmClientCertificatesOutput {
	s.HsmClientCertificates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeHsmClientCertificatesOutput) SetMarker(v string) *DescribeHsmClientCertificatesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurationsMessage
type DescribeHsmConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a specific Amazon Redshift HSM configuration to be described.
	// If no identifier is specified, information is returned for all HSM configurations
	// owned by your AWS customer account.
	HsmConfigurationIdentifier *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeHsmConfigurations request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A tag key or keys for which you want to return all matching HSM configurations
	// that are associated with the specified key or keys. For example, suppose
	// that you have HSM configurations that are tagged with keys called owner and
	// environment. If you specify both of these tag keys in the request, Amazon
	// Redshift returns a response with the HSM configurations that have either
	// or both of these tag keys associated with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching HSM configurations
	// that are associated with the specified tag value or values. For example,
	// suppose that you have HSM configurations that are tagged with values called
	// admin and test. If you specify both of these tag values in the request, Amazon
	// Redshift returns a response with the HSM configurations that have either
	// or both of these tag values associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeHsmConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmConfigurationsInput) GoString() string {
	return s.String()
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *DescribeHsmConfigurationsInput) SetHsmConfigurationIdentifier(v string) *DescribeHsmConfigurationsInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeHsmConfigurationsInput) SetMarker(v string) *DescribeHsmConfigurationsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeHsmConfigurationsInput) SetMaxRecords(v int64) *DescribeHsmConfigurationsInput {
	s.MaxRecords = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeHsmConfigurationsInput) SetTagKeys(v []*string) *DescribeHsmConfigurationsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeHsmConfigurationsInput) SetTagValues(v []*string) *DescribeHsmConfigurationsInput {
	s.TagValues = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/HsmConfigurationMessage
type DescribeHsmConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of HsmConfiguration objects.
	HsmConfigurations []*HsmConfiguration `locationNameList:"HsmConfiguration" type:"list"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmConfigurationsOutput) GoString() string {
	return s.String()
}

// SetHsmConfigurations sets the HsmConfigurations field's value.
func (s *DescribeHsmConfigurationsOutput) SetHsmConfigurations(v []*HsmConfiguration) *DescribeHsmConfigurationsOutput {
	s.HsmConfigurations = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeHsmConfigurationsOutput) SetMarker(v string) *DescribeHsmConfigurationsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatusMessage
type DescribeLoggingStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster from which to get the logging status.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLoggingStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoggingStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoggingStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoggingStatusInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeLoggingStatusInput) SetClusterIdentifier(v string) *DescribeLoggingStatusInput {
	s.ClusterIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptionsMessage
type DescribeOrderableClusterOptionsInput struct {
	_ struct{} `type:"structure"`

	// The version filter value. Specify this parameter to show only the available
	// offerings matching the specified version.
	//
	// Default: All versions.
	//
	// Constraints: Must be one of the version returned from DescribeClusterVersions.
	ClusterVersion *string `type:"string"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeOrderableClusterOptions request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The node type filter value. Specify this parameter to show only the available
	// offerings matching the specified node type.
	NodeType *string `type:"string"`
}

// String returns the string representation
func (s DescribeOrderableClusterOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableClusterOptionsInput) GoString() string {
	return s.String()
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *DescribeOrderableClusterOptionsInput) SetClusterVersion(v string) *DescribeOrderableClusterOptionsInput {
	s.ClusterVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableClusterOptionsInput) SetMarker(v string) *DescribeOrderableClusterOptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOrderableClusterOptionsInput) SetMaxRecords(v int64) *DescribeOrderableClusterOptionsInput {
	s.MaxRecords = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *DescribeOrderableClusterOptionsInput) SetNodeType(v string) *DescribeOrderableClusterOptionsInput {
	s.NodeType = &v
	return s
}

// Contains the output from the DescribeOrderableClusterOptions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/OrderableClusterOptionsMessage
type DescribeOrderableClusterOptionsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// An OrderableClusterOption structure containing information about orderable
	// options for the cluster.
	OrderableClusterOptions []*OrderableClusterOption `locationNameList:"OrderableClusterOption" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableClusterOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableClusterOptionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableClusterOptionsOutput) SetMarker(v string) *DescribeOrderableClusterOptionsOutput {
	s.Marker = &v
	return s
}

// SetOrderableClusterOptions sets the OrderableClusterOptions field's value.
func (s *DescribeOrderableClusterOptionsOutput) SetOrderableClusterOptions(v []*OrderableClusterOption) *DescribeOrderableClusterOptionsOutput {
	s.OrderableClusterOptions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferingsMessage
type DescribeReservedNodeOfferingsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeReservedNodeOfferings request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The unique identifier for the offering.
	ReservedNodeOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedNodeOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodeOfferingsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedNodeOfferingsInput) SetMarker(v string) *DescribeReservedNodeOfferingsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReservedNodeOfferingsInput) SetMaxRecords(v int64) *DescribeReservedNodeOfferingsInput {
	s.MaxRecords = &v
	return s
}

// SetReservedNodeOfferingId sets the ReservedNodeOfferingId field's value.
func (s *DescribeReservedNodeOfferingsInput) SetReservedNodeOfferingId(v string) *DescribeReservedNodeOfferingsInput {
	s.ReservedNodeOfferingId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ReservedNodeOfferingsMessage
type DescribeReservedNodeOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of ReservedNodeOffering objects.
	ReservedNodeOfferings []*ReservedNodeOffering `locationNameList:"ReservedNodeOffering" type:"list"`
}

// String returns the string representation
func (s DescribeReservedNodeOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodeOfferingsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedNodeOfferingsOutput) SetMarker(v string) *DescribeReservedNodeOfferingsOutput {
	s.Marker = &v
	return s
}

// SetReservedNodeOfferings sets the ReservedNodeOfferings field's value.
func (s *DescribeReservedNodeOfferingsOutput) SetReservedNodeOfferings(v []*ReservedNodeOffering) *DescribeReservedNodeOfferingsOutput {
	s.ReservedNodeOfferings = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodesMessage
type DescribeReservedNodesInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeReservedNodes request exceed
	// the value specified in MaxRecords, AWS returns a value in the Marker field
	// of the response. You can retrieve the next set of response records by providing
	// the returned marker value in the Marker parameter and retrying the request.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// Identifier for the node reservation.
	ReservedNodeId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedNodesInput) SetMarker(v string) *DescribeReservedNodesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReservedNodesInput) SetMaxRecords(v int64) *DescribeReservedNodesInput {
	s.MaxRecords = &v
	return s
}

// SetReservedNodeId sets the ReservedNodeId field's value.
func (s *DescribeReservedNodesInput) SetReservedNodeId(v string) *DescribeReservedNodesInput {
	s.ReservedNodeId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ReservedNodesMessage
type DescribeReservedNodesOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The list of ReservedNode objects.
	ReservedNodes []*ReservedNode `locationNameList:"ReservedNode" type:"list"`
}

// String returns the string representation
func (s DescribeReservedNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedNodesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedNodesOutput) SetMarker(v string) *DescribeReservedNodesOutput {
	s.Marker = &v
	return s
}

// SetReservedNodes sets the ReservedNodes field's value.
func (s *DescribeReservedNodesOutput) SetReservedNodes(v []*ReservedNode) *DescribeReservedNodesOutput {
	s.ReservedNodes = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResizeMessage
type DescribeResizeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a cluster whose resize progress you are requesting.
	// This parameter is case-sensitive.
	//
	// By default, resize operations for all clusters defined for an AWS account
	// are returned.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResizeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResizeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResizeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResizeInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeResizeInput) SetClusterIdentifier(v string) *DescribeResizeInput {
	s.ClusterIdentifier = &v
	return s
}

// Describes the result of a cluster resize operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResizeProgressMessage
type DescribeResizeOutput struct {
	_ struct{} `type:"structure"`

	// The average rate of the resize operation over the last few minutes, measured
	// in megabytes per second. After the resize operation completes, this value
	// shows the average rate of the entire resize operation.
	AvgResizeRateInMegaBytesPerSecond *float64 `type:"double"`

	// The amount of seconds that have elapsed since the resize operation began.
	// After the resize operation completes, this value shows the total actual time,
	// in seconds, for the resize operation.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimated time remaining, in seconds, until the resize operation is complete.
	// This value is calculated based on the average resize rate and the estimated
	// amount of data remaining to be processed. Once the resize operation is complete,
	// this value will be 0.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The names of tables that have been completely imported .
	//
	// Valid Values: List of table names.
	ImportTablesCompleted []*string `type:"list"`

	// The names of tables that are being currently imported.
	//
	// Valid Values: List of table names.
	ImportTablesInProgress []*string `type:"list"`

	// The names of tables that have not been yet imported.
	//
	// Valid Values: List of table names
	ImportTablesNotStarted []*string `type:"list"`

	// While the resize operation is in progress, this value shows the current amount
	// of data, in megabytes, that has been processed so far. When the resize operation
	// is complete, this value shows the total amount of data, in megabytes, on
	// the cluster, which may be more or less than TotalResizeDataInMegaBytes (the
	// estimated total amount of data before resize).
	ProgressInMegaBytes *int64 `type:"long"`

	// The status of the resize operation.
	//
	// Valid Values: NONE | IN_PROGRESS | FAILED | SUCCEEDED
	Status *string `type:"string"`

	// The cluster type after the resize operation is complete.
	//
	// Valid Values: multi-node | single-node
	TargetClusterType *string `type:"string"`

	// The node type that the cluster will have after the resize operation is complete.
	TargetNodeType *string `type:"string"`

	// The number of nodes that the cluster will have after the resize operation
	// is complete.
	TargetNumberOfNodes *int64 `type:"integer"`

	// The estimated total amount of data, in megabytes, on the cluster before the
	// resize operation began.
	TotalResizeDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeResizeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResizeOutput) GoString() string {
	return s.String()
}

// SetAvgResizeRateInMegaBytesPerSecond sets the AvgResizeRateInMegaBytesPerSecond field's value.
func (s *DescribeResizeOutput) SetAvgResizeRateInMegaBytesPerSecond(v float64) *DescribeResizeOutput {
	s.AvgResizeRateInMegaBytesPerSecond = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *DescribeResizeOutput) SetElapsedTimeInSeconds(v int64) *DescribeResizeOutput {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedTimeToCompletionInSeconds sets the EstimatedTimeToCompletionInSeconds field's value.
func (s *DescribeResizeOutput) SetEstimatedTimeToCompletionInSeconds(v int64) *DescribeResizeOutput {
	s.EstimatedTimeToCompletionInSeconds = &v
	return s
}

// SetImportTablesCompleted sets the ImportTablesCompleted field's value.
func (s *DescribeResizeOutput) SetImportTablesCompleted(v []*string) *DescribeResizeOutput {
	s.ImportTablesCompleted = v
	return s
}

// SetImportTablesInProgress sets the ImportTablesInProgress field's value.
func (s *DescribeResizeOutput) SetImportTablesInProgress(v []*string) *DescribeResizeOutput {
	s.ImportTablesInProgress = v
	return s
}

// SetImportTablesNotStarted sets the ImportTablesNotStarted field's value.
func (s *DescribeResizeOutput) SetImportTablesNotStarted(v []*string) *DescribeResizeOutput {
	s.ImportTablesNotStarted = v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *DescribeResizeOutput) SetProgressInMegaBytes(v int64) *DescribeResizeOutput {
	s.ProgressInMegaBytes = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeResizeOutput) SetStatus(v string) *DescribeResizeOutput {
	s.Status = &v
	return s
}

// SetTargetClusterType sets the TargetClusterType field's value.
func (s *DescribeResizeOutput) SetTargetClusterType(v string) *DescribeResizeOutput {
	s.TargetClusterType = &v
	return s
}

// SetTargetNodeType sets the TargetNodeType field's value.
func (s *DescribeResizeOutput) SetTargetNodeType(v string) *DescribeResizeOutput {
	s.TargetNodeType = &v
	return s
}

// SetTargetNumberOfNodes sets the TargetNumberOfNodes field's value.
func (s *DescribeResizeOutput) SetTargetNumberOfNodes(v int64) *DescribeResizeOutput {
	s.TargetNumberOfNodes = &v
	return s
}

// SetTotalResizeDataInMegaBytes sets the TotalResizeDataInMegaBytes field's value.
func (s *DescribeResizeOutput) SetTotalResizeDataInMegaBytes(v int64) *DescribeResizeOutput {
	s.TotalResizeDataInMegaBytes = &v
	return s
}

// The result of the DescribeSnapshotCopyGrants action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrantsMessage
type DescribeSnapshotCopyGrantsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeSnapshotCopyGrant request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the SnapshotCopyGrantName parameter or
	// the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The maximum number of response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	//
	// Default: 100
	//
	// Constraints: minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`

	// A tag key or keys for which you want to return all matching resources that
	// are associated with the specified key or keys. For example, suppose that
	// you have resources tagged with keys called owner and environment. If you
	// specify both of these tag keys in the request, Amazon Redshift returns a
	// response with all resources that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching resources
	// that are associated with the specified value or values. For example, suppose
	// that you have resources tagged with values called admin and test. If you
	// specify both of these tag values in the request, Amazon Redshift returns
	// a response with all resources that have either or both of these tag values
	// associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotCopyGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotCopyGrantsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetMarker(v string) *DescribeSnapshotCopyGrantsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetMaxRecords(v int64) *DescribeSnapshotCopyGrantsInput {
	s.MaxRecords = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetSnapshotCopyGrantName(v string) *DescribeSnapshotCopyGrantsInput {
	s.SnapshotCopyGrantName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetTagKeys(v []*string) *DescribeSnapshotCopyGrantsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeSnapshotCopyGrantsInput) SetTagValues(v []*string) *DescribeSnapshotCopyGrantsInput {
	s.TagValues = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/SnapshotCopyGrantMessage
type DescribeSnapshotCopyGrantsOutput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the starting point to return a set of
	// response records. When the results of a DescribeSnapshotCopyGrant request
	// exceed the value specified in MaxRecords, AWS returns a value in the Marker
	// field of the response. You can retrieve the next set of response records
	// by providing the returned marker value in the Marker parameter and retrying
	// the request.
	//
	// Constraints: You can specify either the SnapshotCopyGrantName parameter or
	// the Marker parameter, but not both.
	Marker *string `type:"string"`

	// The list of SnapshotCopyGrant objects.
	SnapshotCopyGrants []*SnapshotCopyGrant `locationNameList:"SnapshotCopyGrant" type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotCopyGrantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotCopyGrantsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSnapshotCopyGrantsOutput) SetMarker(v string) *DescribeSnapshotCopyGrantsOutput {
	s.Marker = &v
	return s
}

// SetSnapshotCopyGrants sets the SnapshotCopyGrants field's value.
func (s *DescribeSnapshotCopyGrantsOutput) SetSnapshotCopyGrants(v []*SnapshotCopyGrant) *DescribeSnapshotCopyGrantsOutput {
	s.SnapshotCopyGrants = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatusMessage
type DescribeTableRestoreStatusInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Redshift cluster that the table is being restored to.
	ClusterIdentifier *string `type:"string"`

	// An optional pagination token provided by a previous DescribeTableRestoreStatus
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by the MaxRecords parameter.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the table restore request to return status for. If you
	// don't specify a TableRestoreRequestId value, then DescribeTableRestoreStatus
	// returns the status of all in-progress table restore requests.
	TableRestoreRequestId *string `type:"string"`
}

// String returns the string representation
func (s DescribeTableRestoreStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableRestoreStatusInput) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DescribeTableRestoreStatusInput) SetClusterIdentifier(v string) *DescribeTableRestoreStatusInput {
	s.ClusterIdentifier = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableRestoreStatusInput) SetMarker(v string) *DescribeTableRestoreStatusInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeTableRestoreStatusInput) SetMaxRecords(v int64) *DescribeTableRestoreStatusInput {
	s.MaxRecords = &v
	return s
}

// SetTableRestoreRequestId sets the TableRestoreRequestId field's value.
func (s *DescribeTableRestoreStatusInput) SetTableRestoreRequestId(v string) *DescribeTableRestoreStatusInput {
	s.TableRestoreRequestId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/TableRestoreStatusMessage
type DescribeTableRestoreStatusOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token that can be used in a subsequent DescribeTableRestoreStatus
	// request.
	Marker *string `type:"string"`

	// A list of status details for one or more table restore requests.
	TableRestoreStatusDetails []*TableRestoreStatus `locationNameList:"TableRestoreStatus" type:"list"`
}

// String returns the string representation
func (s DescribeTableRestoreStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableRestoreStatusOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableRestoreStatusOutput) SetMarker(v string) *DescribeTableRestoreStatusOutput {
	s.Marker = &v
	return s
}

// SetTableRestoreStatusDetails sets the TableRestoreStatusDetails field's value.
func (s *DescribeTableRestoreStatusOutput) SetTableRestoreStatusDetails(v []*TableRestoreStatus) *DescribeTableRestoreStatusOutput {
	s.TableRestoreStatusDetails = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTagsMessage
type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the marker
	// parameter and retrying the command. If the marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// The maximum number or response records to return in each call. If the number
	// of remaining response records exceeds the specified MaxRecords value, a value
	// is returned in a marker field of the response. You can retrieve the next
	// set of records by retrying the command with the returned marker value.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for which you want to describe the tag or
	// tags. For example, arn:aws:redshift:us-east-1:123456789:cluster:t1.
	ResourceName *string `type:"string"`

	// The type of resource with which you want to view tags. Valid resource types
	// are:
	//
	//    * Cluster
	//
	//    * CIDR/IP
	//
	//    * EC2 security group
	//
	//    * Snapshot
	//
	//    * Cluster security group
	//
	//    * Subnet group
	//
	//    * HSM connection
	//
	//    * HSM certificate
	//
	//    * Parameter group
	//
	//    * Snapshot copy grant
	//
	// For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Constructing an Amazon Redshift Amazon Resource Name (ARN) (http://docs.aws.amazon.com/redshift/latest/mgmt/constructing-redshift-arn.html)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string `type:"string"`

	// A tag key or keys for which you want to return all matching resources that
	// are associated with the specified key or keys. For example, suppose that
	// you have resources tagged with keys called owner and environment. If you
	// specify both of these tag keys in the request, Amazon Redshift returns a
	// response with all resources that have either or both of these tag keys associated
	// with them.
	TagKeys []*string `locationNameList:"TagKey" type:"list"`

	// A tag value or values for which you want to return all matching resources
	// that are associated with the specified value or values. For example, suppose
	// that you have resources tagged with values called admin and test. If you
	// specify both of these tag values in the request, Amazon Redshift returns
	// a response with all resources that have either or both of these tag values
	// associated with them.
	TagValues []*string `locationNameList:"TagValue" type:"list"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTagsInput) SetMarker(v string) *DescribeTagsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeTagsInput) SetMaxRecords(v int64) *DescribeTagsInput {
	s.MaxRecords = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DescribeTagsInput) SetResourceName(v string) *DescribeTagsInput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeTagsInput) SetResourceType(v string) *DescribeTagsInput {
	s.ResourceType = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DescribeTagsInput) SetTagKeys(v []*string) *DescribeTagsInput {
	s.TagKeys = v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *DescribeTagsInput) SetTagValues(v []*string) *DescribeTagsInput {
	s.TagValues = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/TaggedResourceListMessage
type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned marker value in the Marker
	// parameter and retrying the command. If the Marker field is empty, all response
	// records have been retrieved for the request.
	Marker *string `type:"string"`

	// A list of tags with their associated resources.
	TaggedResources []*TaggedResource `locationNameList:"TaggedResource" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTagsOutput) SetMarker(v string) *DescribeTagsOutput {
	s.Marker = &v
	return s
}

// SetTaggedResources sets the TaggedResources field's value.
func (s *DescribeTagsOutput) SetTaggedResources(v []*TaggedResource) *DescribeTagsOutput {
	s.TaggedResources = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLoggingMessage
type DisableLoggingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster on which logging is to be stopped.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableLoggingInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DisableLoggingInput) SetClusterIdentifier(v string) *DisableLoggingInput {
	s.ClusterIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopyMessage
type DisableSnapshotCopyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the source cluster that you want to disable copying
	// of snapshots to a destination region.
	//
	// Constraints: Must be the valid name of an existing cluster that has cross-region
	// snapshot copy enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableSnapshotCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSnapshotCopyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableSnapshotCopyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableSnapshotCopyInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *DisableSnapshotCopyInput) SetClusterIdentifier(v string) *DisableSnapshotCopyInput {
	s.ClusterIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopyResult
type DisableSnapshotCopyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DisableSnapshotCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSnapshotCopyOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DisableSnapshotCopyOutput) SetCluster(v *Cluster) *DisableSnapshotCopyOutput {
	s.Cluster = v
	return s
}

// Describes an Amazon EC2 security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EC2SecurityGroup
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the EC2 Security Group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS ID of the owner of the EC2 security group specified in the EC2SecurityGroupName
	// field.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// The status of the EC2 security group.
	Status *string `type:"string"`

	// The list of tags for the EC2 security group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2SecurityGroup) GoString() string {
	return s.String()
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupName(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupOwnerId(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EC2SecurityGroup) SetStatus(v string) *EC2SecurityGroup {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EC2SecurityGroup) SetTags(v []*Tag) *EC2SecurityGroup {
	s.Tags = v
	return s
}

// Describes the status of the elastic IP (EIP) address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ElasticIpStatus
type ElasticIpStatus struct {
	_ struct{} `type:"structure"`

	// The elastic IP (EIP) address for the cluster.
	ElasticIp *string `type:"string"`

	// The status of the elastic IP (EIP) address.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ElasticIpStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticIpStatus) GoString() string {
	return s.String()
}

// SetElasticIp sets the ElasticIp field's value.
func (s *ElasticIpStatus) SetElasticIp(v string) *ElasticIpStatus {
	s.ElasticIp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticIpStatus) SetStatus(v string) *ElasticIpStatus {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLoggingMessage
type EnableLoggingInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing S3 bucket where the log files are to be stored.
	//
	// Constraints:
	//
	//    * Must be in the same region as the cluster
	//
	//    * The cluster must have read bucket and put object permissions
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The identifier of the cluster on which logging is to be started.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The prefix applied to the log file names.
	//
	// Constraints:
	//
	//    * Cannot exceed 512 characters
	//
	//    * Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
	//    (\), or control characters. The hexadecimal codes for invalid characters
	//    are:
	//
	// x00 to x20
	//
	// x22
	//
	// x27
	//
	// x5c
	//
	// x7f or larger
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation
func (s EnableLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableLoggingInput"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *EnableLoggingInput) SetBucketName(v string) *EnableLoggingInput {
	s.BucketName = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *EnableLoggingInput) SetClusterIdentifier(v string) *EnableLoggingInput {
	s.ClusterIdentifier = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *EnableLoggingInput) SetS3KeyPrefix(v string) *EnableLoggingInput {
	s.S3KeyPrefix = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopyMessage
type EnableSnapshotCopyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the source cluster to copy snapshots from.
	//
	// Constraints: Must be the valid name of an existing cluster that does not
	// already have cross-region snapshot copy enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The destination region that you want to copy snapshots to.
	//
	// Constraints: Must be the name of a valid region. For more information, see
	// Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region)
	// in the Amazon Web Services General Reference.
	//
	// DestinationRegion is a required field
	DestinationRegion *string `type:"string" required:"true"`

	// The number of days to retain automated snapshots in the destination region
	// after they are copied from the source region.
	//
	// Default: 7.
	//
	// Constraints: Must be at least 1 and no more than 35.
	RetentionPeriod *int64 `type:"integer"`

	// The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted
	// cluster are copied to the destination region.
	SnapshotCopyGrantName *string `type:"string"`
}

// String returns the string representation
func (s EnableSnapshotCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSnapshotCopyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableSnapshotCopyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableSnapshotCopyInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.DestinationRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationRegion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *EnableSnapshotCopyInput) SetClusterIdentifier(v string) *EnableSnapshotCopyInput {
	s.ClusterIdentifier = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *EnableSnapshotCopyInput) SetDestinationRegion(v string) *EnableSnapshotCopyInput {
	s.DestinationRegion = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *EnableSnapshotCopyInput) SetRetentionPeriod(v int64) *EnableSnapshotCopyInput {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *EnableSnapshotCopyInput) SetSnapshotCopyGrantName(v string) *EnableSnapshotCopyInput {
	s.SnapshotCopyGrantName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopyResult
type EnableSnapshotCopyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s EnableSnapshotCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSnapshotCopyOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *EnableSnapshotCopyOutput) SetCluster(v *Cluster) *EnableSnapshotCopyOutput {
	s.Cluster = v
	return s
}

// Describes a connection endpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/Endpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS address of the Cluster.
	Address *string `type:"string"`

	// The port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// Describes an event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/Event
type Event struct {
	_ struct{} `type:"structure"`

	// The date and time of the event.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of the event categories.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The identifier of the event.
	EventId *string `type:"string"`

	// The text of this event.
	Message *string `type:"string"`

	// The severity of the event.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// The source type for this event.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *Event) SetEventCategories(v []*string) *Event {
	s.EventCategories = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *Event) SetEventId(v string) *Event {
	s.EventId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *Event) SetSeverity(v string) *Event {
	s.Severity = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

// Describes event categories.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EventCategoriesMap
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The events in the event category.
	Events []*EventInfoMap `locationNameList:"EventInfoMap" type:"list"`

	// The source type, such as cluster or cluster-snapshot, that the returned categories
	// belong to.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoriesMap) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *EventCategoriesMap) SetEvents(v []*EventInfoMap) *EventCategoriesMap {
	s.Events = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventCategoriesMap) SetSourceType(v string) *EventCategoriesMap {
	s.SourceType = &v
	return s
}

// Describes event information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EventInfoMap
type EventInfoMap struct {
	_ struct{} `type:"structure"`

	// The category of an Amazon Redshift event.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The description of an Amazon Redshift event.
	EventDescription *string `type:"string"`

	// The identifier of an Amazon Redshift event.
	EventId *string `type:"string"`

	// The severity of the event.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`
}

// String returns the string representation
func (s EventInfoMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventInfoMap) GoString() string {
	return s.String()
}

// SetEventCategories sets the EventCategories field's value.
func (s *EventInfoMap) SetEventCategories(v []*string) *EventInfoMap {
	s.EventCategories = v
	return s
}

// SetEventDescription sets the EventDescription field's value.
func (s *EventInfoMap) SetEventDescription(v string) *EventInfoMap {
	s.EventDescription = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *EventInfoMap) SetEventId(v string) *EventInfoMap {
	s.EventId = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *EventInfoMap) SetSeverity(v string) *EventInfoMap {
	s.Severity = &v
	return s
}

// Describes event subscriptions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EventSubscription
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Redshift event notification subscription.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the Amazon Redshift event notification
	// subscription.
	CustomerAwsId *string `type:"string"`

	// A Boolean value indicating whether the subscription is enabled. true indicates
	// the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// The list of Amazon Redshift event categories specified in the event notification
	// subscription.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategoriesList []*string `locationNameList:"EventCategory" type:"list"`

	// The event severity specified in the Amazon Redshift event notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event
	// notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of the sources that publish events to the Amazon Redshift event notification
	// subscription.
	SourceIdsList []*string `locationNameList:"SourceId" type:"list"`

	// The source type of the events returned the Amazon Redshift event notification,
	// such as cluster, or cluster-snapshot.
	SourceType *string `type:"string"`

	// The status of the Amazon Redshift event notification subscription.
	//
	// Constraints:
	//
	//    * Can be one of the following: active | no-permission | topic-not-exist
	//
	//    * The status "no-permission" indicates that Amazon Redshift no longer
	//    has permission to post to the Amazon SNS topic. The status "topic-not-exist"
	//    indicates that the topic was deleted after the subscription was created.
	Status *string `type:"string"`

	// The date and time the Amazon Redshift event notification subscription was
	// created.
	SubscriptionCreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The list of tags for the event subscription.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

// SetCustSubscriptionId sets the CustSubscriptionId field's value.
func (s *EventSubscription) SetCustSubscriptionId(v string) *EventSubscription {
	s.CustSubscriptionId = &v
	return s
}

// SetCustomerAwsId sets the CustomerAwsId field's value.
func (s *EventSubscription) SetCustomerAwsId(v string) *EventSubscription {
	s.CustomerAwsId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventSubscription) SetEnabled(v bool) *EventSubscription {
	s.Enabled = &v
	return s
}

// SetEventCategoriesList sets the EventCategoriesList field's value.
func (s *EventSubscription) SetEventCategoriesList(v []*string) *EventSubscription {
	s.EventCategoriesList = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *EventSubscription) SetSeverity(v string) *EventSubscription {
	s.Severity = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *EventSubscription) SetSnsTopicArn(v string) *EventSubscription {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIdsList sets the SourceIdsList field's value.
func (s *EventSubscription) SetSourceIdsList(v []*string) *EventSubscription {
	s.SourceIdsList = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventSubscription) SetSourceType(v string) *EventSubscription {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventSubscription) SetStatus(v string) *EventSubscription {
	s.Status = &v
	return s
}

// SetSubscriptionCreationTime sets the SubscriptionCreationTime field's value.
func (s *EventSubscription) SetSubscriptionCreationTime(v time.Time) *EventSubscription {
	s.SubscriptionCreationTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EventSubscription) SetTags(v []*Tag) *EventSubscription {
	s.Tags = v
	return s
}

// Returns information about an HSM client certificate. The certificate is stored
// in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift
// cluster to encrypt data files.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/HsmClientCertificate
type HsmClientCertificate struct {
	_ struct{} `type:"structure"`

	// The identifier of the HSM client certificate.
	HsmClientCertificateIdentifier *string `type:"string"`

	// The public key that the Amazon Redshift cluster will use to connect to the
	// HSM. You must register the public key in the HSM.
	HsmClientCertificatePublicKey *string `type:"string"`

	// The list of tags for the HSM client certificate.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s HsmClientCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmClientCertificate) GoString() string {
	return s.String()
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *HsmClientCertificate) SetHsmClientCertificateIdentifier(v string) *HsmClientCertificate {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmClientCertificatePublicKey sets the HsmClientCertificatePublicKey field's value.
func (s *HsmClientCertificate) SetHsmClientCertificatePublicKey(v string) *HsmClientCertificate {
	s.HsmClientCertificatePublicKey = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *HsmClientCertificate) SetTags(v []*Tag) *HsmClientCertificate {
	s.Tags = v
	return s
}

// Returns information about an HSM configuration, which is an object that describes
// to Amazon Redshift clusters the information they require to connect to an
// HSM where they can store database encryption keys.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/HsmConfiguration
type HsmConfiguration struct {
	_ struct{} `type:"structure"`

	// A text description of the HSM configuration.
	Description *string `type:"string"`

	// The name of the Amazon Redshift HSM configuration.
	HsmConfigurationIdentifier *string `type:"string"`

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	HsmIpAddress *string `type:"string"`

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	HsmPartitionName *string `type:"string"`

	// The list of tags for the HSM configuration.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s HsmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmConfiguration) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *HsmConfiguration) SetDescription(v string) *HsmConfiguration {
	s.Description = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *HsmConfiguration) SetHsmConfigurationIdentifier(v string) *HsmConfiguration {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetHsmIpAddress sets the HsmIpAddress field's value.
func (s *HsmConfiguration) SetHsmIpAddress(v string) *HsmConfiguration {
	s.HsmIpAddress = &v
	return s
}

// SetHsmPartitionName sets the HsmPartitionName field's value.
func (s *HsmConfiguration) SetHsmPartitionName(v string) *HsmConfiguration {
	s.HsmPartitionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *HsmConfiguration) SetTags(v []*Tag) *HsmConfiguration {
	s.Tags = v
	return s
}

// Describes the status of changes to HSM settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/HsmStatus
type HsmStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// Reports whether the Amazon Redshift cluster has finished applying any HSM
	// settings changes specified in a modify cluster command.
	//
	// Values: active, applying
	Status *string `type:"string"`
}

// String returns the string representation
func (s HsmStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HsmStatus) GoString() string {
	return s.String()
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *HsmStatus) SetHsmClientCertificateIdentifier(v string) *HsmStatus {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *HsmStatus) SetHsmConfigurationIdentifier(v string) *HsmStatus {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *HsmStatus) SetStatus(v string) *HsmStatus {
	s.Status = &v
	return s
}

// Describes an IP range used in a security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/IPRange
type IPRange struct {
	_ struct{} `type:"structure"`

	// The IP range in Classless Inter-Domain Routing (CIDR) notation.
	CIDRIP *string `type:"string"`

	// The status of the IP range, for example, "authorized".
	Status *string `type:"string"`

	// The list of tags for the IP range.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s IPRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPRange) GoString() string {
	return s.String()
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *IPRange) SetCIDRIP(v string) *IPRange {
	s.CIDRIP = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IPRange) SetStatus(v string) *IPRange {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *IPRange) SetTags(v []*Tag) *IPRange {
	s.Tags = v
	return s
}

// Describes the status of logging for a cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/LoggingStatus
type LoggingStatus struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where the log files are stored.
	BucketName *string `type:"string"`

	// The message indicating that logs failed to be delivered.
	LastFailureMessage *string `type:"string"`

	// The last time when logs failed to be delivered.
	LastFailureTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The last time that logs were delivered.
	LastSuccessfulDeliveryTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// true if logging is on, false if logging is off.
	LoggingEnabled *bool `type:"boolean"`

	// The prefix applied to the log file names.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation
func (s LoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingStatus) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *LoggingStatus) SetBucketName(v string) *LoggingStatus {
	s.BucketName = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *LoggingStatus) SetLastFailureMessage(v string) *LoggingStatus {
	s.LastFailureMessage = &v
	return s
}

// SetLastFailureTime sets the LastFailureTime field's value.
func (s *LoggingStatus) SetLastFailureTime(v time.Time) *LoggingStatus {
	s.LastFailureTime = &v
	return s
}

// SetLastSuccessfulDeliveryTime sets the LastSuccessfulDeliveryTime field's value.
func (s *LoggingStatus) SetLastSuccessfulDeliveryTime(v time.Time) *LoggingStatus {
	s.LastSuccessfulDeliveryTime = &v
	return s
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *LoggingStatus) SetLoggingEnabled(v bool) *LoggingStatus {
	s.LoggingEnabled = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *LoggingStatus) SetS3KeyPrefix(v string) *LoggingStatus {
	s.S3KeyPrefix = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRolesMessage
type ModifyClusterIamRolesInput struct {
	_ struct{} `type:"structure"`

	// Zero or more IAM roles to associate with the cluster. The roles must be in
	// their Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles
	// with a single cluster in a single request.
	AddIamRoles []*string `locationNameList:"IamRoleArn" type:"list"`

	// The unique identifier of the cluster for which you want to associate or disassociate
	// IAM roles.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// Zero or more IAM roles in ARN format to disassociate from the cluster. You
	// can disassociate up to 10 IAM roles from a single cluster in a single request.
	RemoveIamRoles []*string `locationNameList:"IamRoleArn" type:"list"`
}

// String returns the string representation
func (s ModifyClusterIamRolesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterIamRolesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterIamRolesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterIamRolesInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddIamRoles sets the AddIamRoles field's value.
func (s *ModifyClusterIamRolesInput) SetAddIamRoles(v []*string) *ModifyClusterIamRolesInput {
	s.AddIamRoles = v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifyClusterIamRolesInput) SetClusterIdentifier(v string) *ModifyClusterIamRolesInput {
	s.ClusterIdentifier = &v
	return s
}

// SetRemoveIamRoles sets the RemoveIamRoles field's value.
func (s *ModifyClusterIamRolesInput) SetRemoveIamRoles(v []*string) *ModifyClusterIamRolesInput {
	s.RemoveIamRoles = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRolesResult
type ModifyClusterIamRolesOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterIamRolesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterIamRolesOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifyClusterIamRolesOutput) SetCluster(v *Cluster) *ModifyClusterIamRolesOutput {
	s.Cluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterMessage
type ModifyClusterInput struct {
	_ struct{} `type:"structure"`

	// If true, major version upgrades will be applied automatically to the cluster
	// during the maintenance window.
	//
	// Default: false
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	// If you decrease the automated snapshot retention period from its current
	// value, existing automated snapshots that fall outside of the new retention
	// period will be immediately deleted.
	//
	// Default: Uses existing setting.
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The unique identifier of the cluster to be modified.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the cluster parameter group to apply to this cluster. This change
	// is applied only after the cluster is rebooted. To reboot a cluster use RebootCluster.
	//
	// Default: Uses existing setting.
	//
	// Constraints: The cluster parameter group must be in the same parameter group
	// family that matches the cluster version.
	ClusterParameterGroupName *string `type:"string"`

	// A list of cluster security groups to be authorized on this cluster. This
	// change is asynchronously applied as soon as possible.
	//
	// Security groups currently associated with the cluster, and not in the list
	// of groups to apply, will be revoked from the cluster.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The new cluster type.
	//
	// When you submit your cluster resize request, your existing cluster goes into
	// a read-only mode. After Amazon Redshift provisions a new cluster based on
	// your resize requirements, there will be outage for a period while the old
	// cluster is deleted and your connection is switched to the new cluster. You
	// can use DescribeResize to track the progress of the resize request.
	//
	// Valid Values:  multi-node | single-node
	ClusterType *string `type:"string"`

	// The new version number of the Amazon Redshift engine to upgrade to.
	//
	// For major version upgrades, if a non-default cluster parameter group is currently
	// in use, a new cluster parameter group in the cluster parameter group family
	// for the new version must be specified. The new cluster parameter group can
	// be the default for that cluster parameter group family. For more information
	// about parameters and parameter groups, go to Amazon Redshift Parameter Groups
	// (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// Example: 1.0
	ClusterVersion *string `type:"string"`

	// The Elastic IP (EIP) address for the cluster.
	//
	// Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
	// through an Internet gateway. For more information about provisioning clusters
	// in EC2-VPC, go to Supported Platforms to Launch Your Cluster (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms)
	// in the Amazon Redshift Cluster Management Guide.
	ElasticIp *string `type:"string"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// The new password for the cluster master user. This change is asynchronously
	// applied as soon as possible. Between the time of the request and the completion
	// of the request, the MasterUserPassword element exists in the PendingModifiedValues
	// element of the operation response.
	//
	// Operations never return the password, so this operation provides a way to
	// regain access to the master user account for a cluster if the password is
	// lost.
	//
	// Default: Uses existing setting.
	//
	// Constraints:
	//
	//    * Must be between 8 and 64 characters in length.
	//
	//    * Must contain at least one uppercase letter.
	//
	//    * Must contain at least one lowercase letter.
	//
	//    * Must contain one number.
	//
	//    * Can be any printable ASCII character (ASCII code 33 to 126) except '
	//    (single quote), " (double quote), \, /, @, or space.
	MasterUserPassword *string `type:"string"`

	// The new identifier for the cluster.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// Example: examplecluster
	NewClusterIdentifier *string `type:"string"`

	// The new node type of the cluster. If you specify a new node type, you must
	// also specify the number of nodes parameter.
	//
	// When you submit your request to resize a cluster, Amazon Redshift sets access
	// permissions for the cluster to read-only. After Amazon Redshift provisions
	// a new cluster according to your resize requirements, there will be a temporary
	// outage while the old cluster is deleted and your connection is switched to
	// the new cluster. When the new connection is complete, the original access
	// permissions for the cluster are restored. You can use DescribeResize to track
	// the progress of the resize request.
	//
	// Valid Values:  ds1.xlarge | ds1.8xlarge |  ds2.xlarge | ds2.8xlarge | dc1.large
	// | dc1.8xlarge.
	NodeType *string `type:"string"`

	// The new number of nodes of the cluster. If you specify a new number of nodes,
	// you must also specify the node type parameter.
	//
	// When you submit your request to resize a cluster, Amazon Redshift sets access
	// permissions for the cluster to read-only. After Amazon Redshift provisions
	// a new cluster according to your resize requirements, there will be a temporary
	// outage while the old cluster is deleted and your connection is switched to
	// the new cluster. When the new connection is complete, the original access
	// permissions for the cluster are restored. You can use DescribeResize to track
	// the progress of the resize request.
	//
	// Valid Values: Integer greater than 0.
	NumberOfNodes *int64 `type:"integer"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// if necessary. If system maintenance is necessary during the window, it may
	// result in an outage.
	//
	// This maintenance window change is made immediately. If the new maintenance
	// window indicates the current time, there must be at least 120 minutes between
	// the current time and end of the window in order to ensure that pending changes
	// are applied.
	//
	// Default: Uses existing setting.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi, for example wed:07:30-wed:08:00.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network. Only clusters
	// in VPCs can be set to be publicly available.
	PubliclyAccessible *bool `type:"boolean"`

	// A list of virtual private cloud (VPC) security groups to be associated with
	// the cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *ModifyClusterInput) SetAllowVersionUpgrade(v bool) *ModifyClusterInput {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *ModifyClusterInput) SetAutomatedSnapshotRetentionPeriod(v int64) *ModifyClusterInput {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifyClusterInput) SetClusterIdentifier(v string) *ModifyClusterInput {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterParameterGroupName sets the ClusterParameterGroupName field's value.
func (s *ModifyClusterInput) SetClusterParameterGroupName(v string) *ModifyClusterInput {
	s.ClusterParameterGroupName = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *ModifyClusterInput) SetClusterSecurityGroups(v []*string) *ModifyClusterInput {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *ModifyClusterInput) SetClusterType(v string) *ModifyClusterInput {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *ModifyClusterInput) SetClusterVersion(v string) *ModifyClusterInput {
	s.ClusterVersion = &v
	return s
}

// SetElasticIp sets the ElasticIp field's value.
func (s *ModifyClusterInput) SetElasticIp(v string) *ModifyClusterInput {
	s.ElasticIp = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *ModifyClusterInput) SetEnhancedVpcRouting(v bool) *ModifyClusterInput {
	s.EnhancedVpcRouting = &v
	return s
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *ModifyClusterInput) SetHsmClientCertificateIdentifier(v string) *ModifyClusterInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *ModifyClusterInput) SetHsmConfigurationIdentifier(v string) *ModifyClusterInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *ModifyClusterInput) SetMasterUserPassword(v string) *ModifyClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetNewClusterIdentifier sets the NewClusterIdentifier field's value.
func (s *ModifyClusterInput) SetNewClusterIdentifier(v string) *ModifyClusterInput {
	s.NewClusterIdentifier = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ModifyClusterInput) SetNodeType(v string) *ModifyClusterInput {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *ModifyClusterInput) SetNumberOfNodes(v int64) *ModifyClusterInput {
	s.NumberOfNodes = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyClusterInput) SetPreferredMaintenanceWindow(v string) *ModifyClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *ModifyClusterInput) SetPubliclyAccessible(v bool) *ModifyClusterInput {
	s.PubliclyAccessible = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyClusterInput) SetVpcSecurityGroupIds(v []*string) *ModifyClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterResult
type ModifyClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifyClusterOutput) SetCluster(v *Cluster) *ModifyClusterOutput {
	s.Cluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroupMessage
type ModifyClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to be modified.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of parameters to be modified. A maximum of 20 parameters can be
	// modified in a single request.
	//
	// For each parameter to be modified, you must supply at least the parameter
	// name and parameter value; other name-value pairs of the parameter are optional.
	//
	// For the workload management (WLM) configuration, you must supply all the
	// name-value pairs in the wlm_json_configuration parameter.
	//
	// Parameters is a required field
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ModifyClusterParameterGroupInput) SetParameterGroupName(v string) *ModifyClusterParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ModifyClusterParameterGroupInput) SetParameters(v []*Parameter) *ModifyClusterParameterGroupInput {
	s.Parameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroupMessage
type ModifyClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the subnet group to be modified.
	//
	// ClusterSubnetGroupName is a required field
	ClusterSubnetGroupName *string `type:"string" required:"true"`

	// A text description of the subnet group to be modified.
	Description *string `type:"string"`

	// An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
	// single request.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClusterSubnetGroupInput"}
	if s.ClusterSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *ModifyClusterSubnetGroupInput) SetClusterSubnetGroupName(v string) *ModifyClusterSubnetGroupInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModifyClusterSubnetGroupInput) SetDescription(v string) *ModifyClusterSubnetGroupInput {
	s.Description = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ModifyClusterSubnetGroupInput) SetSubnetIds(v []*string) *ModifyClusterSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroupResult
type ModifyClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Describes a subnet group.
	ClusterSubnetGroup *ClusterSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClusterSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetClusterSubnetGroup sets the ClusterSubnetGroup field's value.
func (s *ModifyClusterSubnetGroupOutput) SetClusterSubnetGroup(v *ClusterSubnetGroup) *ModifyClusterSubnetGroupOutput {
	s.ClusterSubnetGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscriptionMessage
type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating if the subscription is enabled. true indicates
	// the subscription is enabled
	Enabled *bool `type:"boolean"`

	// Specifies the Amazon Redshift event categories to be published by the event
	// notification subscription.
	//
	// Values: Configuration, Management, Monitoring, Security
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Specifies the Amazon Redshift event severity to be published by the event
	// notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification
	// subscription.
	SnsTopicArn *string `type:"string"`

	// A list of one or more identifiers of Amazon Redshift source objects. All
	// of the objects must be of the same type as was specified in the source type
	// parameter. The event subscription will return only events generated by the
	// specified objects. If not specified, then events are returned for all objects
	// within the source type specified.
	//
	// Example: my-cluster-1, my-cluster-2
	//
	// Example: my-snapshot-20131010
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a cluster, you would set this
	// parameter to cluster. If this value is not specified, events are returned
	// for all Amazon Redshift objects in your AWS account. You must specify a source
	// type in order to specify source IDs.
	//
	// Valid values: cluster, cluster-parameter-group, cluster-security-group, and
	// cluster-snapshot.
	SourceType *string `type:"string"`

	// The name of the modified Amazon Redshift event notification subscription.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ModifyEventSubscriptionInput) SetEnabled(v bool) *ModifyEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *ModifyEventSubscriptionInput) SetEventCategories(v []*string) *ModifyEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ModifyEventSubscriptionInput) SetSeverity(v string) *ModifyEventSubscriptionInput {
	s.Severity = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *ModifyEventSubscriptionInput) SetSnsTopicArn(v string) *ModifyEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *ModifyEventSubscriptionInput) SetSourceIds(v []*string) *ModifyEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ModifyEventSubscriptionInput) SetSourceType(v string) *ModifyEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *ModifyEventSubscriptionInput) SetSubscriptionName(v string) *ModifyEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscriptionResult
type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Describes event subscriptions.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *ModifyEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *ModifyEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriodMessage
type ModifySnapshotCopyRetentionPeriodInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster for which you want to change the retention
	// period for automated snapshots that are copied to a destination region.
	//
	// Constraints: Must be the valid name of an existing cluster that has cross-region
	// snapshot copy enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The number of days to retain automated snapshots in the destination region
	// after they are copied from the source region.
	//
	// If you decrease the retention period for automated snapshots that are copied
	// to a destination region, Amazon Redshift will delete any existing automated
	// snapshots that were copied to the destination region and that fall outside
	// of the new retention period.
	//
	// Constraints: Must be at least 1 and no more than 35.
	//
	// RetentionPeriod is a required field
	RetentionPeriod *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ModifySnapshotCopyRetentionPeriodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotCopyRetentionPeriodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySnapshotCopyRetentionPeriodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifySnapshotCopyRetentionPeriodInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.RetentionPeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriod"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *ModifySnapshotCopyRetentionPeriodInput) SetClusterIdentifier(v string) *ModifySnapshotCopyRetentionPeriodInput {
	s.ClusterIdentifier = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *ModifySnapshotCopyRetentionPeriodInput) SetRetentionPeriod(v int64) *ModifySnapshotCopyRetentionPeriodInput {
	s.RetentionPeriod = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriodResult
type ModifySnapshotCopyRetentionPeriodOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s ModifySnapshotCopyRetentionPeriodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifySnapshotCopyRetentionPeriodOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *ModifySnapshotCopyRetentionPeriodOutput) SetCluster(v *Cluster) *ModifySnapshotCopyRetentionPeriodOutput {
	s.Cluster = v
	return s
}

// Describes an orderable cluster option.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/OrderableClusterOption
type OrderableClusterOption struct {
	_ struct{} `type:"structure"`

	// A list of availability zones for the orderable cluster.
	AvailabilityZones []*AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The cluster type, for example multi-node.
	ClusterType *string `type:"string"`

	// The version of the orderable cluster.
	ClusterVersion *string `type:"string"`

	// The node type for the orderable cluster.
	NodeType *string `type:"string"`
}

// String returns the string representation
func (s OrderableClusterOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableClusterOption) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *OrderableClusterOption) SetAvailabilityZones(v []*AvailabilityZone) *OrderableClusterOption {
	s.AvailabilityZones = v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *OrderableClusterOption) SetClusterType(v string) *OrderableClusterOption {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *OrderableClusterOption) SetClusterVersion(v string) *OrderableClusterOption {
	s.ClusterVersion = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *OrderableClusterOption) SetNodeType(v string) *OrderableClusterOption {
	s.NodeType = &v
	return s
}

// Describes a parameter in a cluster parameter group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/Parameter
type Parameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Specifies how to apply the WLM configuration parameter. Some properties can
	// be applied dynamically, while other properties require that any associated
	// clusters be rebooted for the configuration changes to be applied. For more
	// information about parameters and parameter groups, go to Amazon Redshift
	// Parameter Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
	// in the Amazon Redshift Cluster Management Guide.
	ApplyType *string `type:"string" enum:"ParameterApplyType"`

	// The data type of the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// If true, the parameter can be modified. Some parameters have security or
	// operational implications that prevent them from being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`

	// The source of the parameter value, such as "engine-default" or "user".
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Parameter) SetAllowedValues(v string) *Parameter {
	s.AllowedValues = &v
	return s
}

// SetApplyType sets the ApplyType field's value.
func (s *Parameter) SetApplyType(v string) *Parameter {
	s.ApplyType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Parameter) SetDataType(v string) *Parameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *Parameter) SetIsModifiable(v bool) *Parameter {
	s.IsModifiable = &v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *Parameter) SetMinimumEngineVersion(v string) *Parameter {
	s.MinimumEngineVersion = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *Parameter) SetParameterName(v string) *Parameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Parameter) SetSource(v string) *Parameter {
	s.Source = &v
	return s
}

// Describes cluster attributes that are in a pending state. A change to one
// or more the attributes was requested and is in progress or will be applied.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PendingModifiedValues
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The pending or in-progress change of the automated snapshot retention period.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The pending or in-progress change of the new identifier for the cluster.
	ClusterIdentifier *string `type:"string"`

	// The pending or in-progress change of the cluster type.
	ClusterType *string `type:"string"`

	// The pending or in-progress change of the service version.
	ClusterVersion *string `type:"string"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// The pending or in-progress change of the master user password for the cluster.
	MasterUserPassword *string `type:"string"`

	// The pending or in-progress change of the cluster's node type.
	NodeType *string `type:"string"`

	// The pending or in-progress change of the number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// The pending or in-progress change of the ability to connect to the cluster
	// from the public network.
	PubliclyAccessible *bool `type:"boolean"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *PendingModifiedValues) SetAutomatedSnapshotRetentionPeriod(v int64) *PendingModifiedValues {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *PendingModifiedValues) SetClusterIdentifier(v string) *PendingModifiedValues {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *PendingModifiedValues) SetClusterType(v string) *PendingModifiedValues {
	s.ClusterType = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *PendingModifiedValues) SetClusterVersion(v string) *PendingModifiedValues {
	s.ClusterVersion = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *PendingModifiedValues) SetEnhancedVpcRouting(v bool) *PendingModifiedValues {
	s.EnhancedVpcRouting = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *PendingModifiedValues) SetMasterUserPassword(v string) *PendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *PendingModifiedValues) SetNodeType(v string) *PendingModifiedValues {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *PendingModifiedValues) SetNumberOfNodes(v int64) *PendingModifiedValues {
	s.NumberOfNodes = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *PendingModifiedValues) SetPubliclyAccessible(v bool) *PendingModifiedValues {
	s.PubliclyAccessible = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOfferingMessage
type PurchaseReservedNodeOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of reserved nodes that you want to purchase.
	//
	// Default: 1
	NodeCount *int64 `type:"integer"`

	// The unique identifier of the reserved node offering you want to purchase.
	//
	// ReservedNodeOfferingId is a required field
	ReservedNodeOfferingId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PurchaseReservedNodeOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedNodeOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseReservedNodeOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseReservedNodeOfferingInput"}
	if s.ReservedNodeOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedNodeOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodeCount sets the NodeCount field's value.
func (s *PurchaseReservedNodeOfferingInput) SetNodeCount(v int64) *PurchaseReservedNodeOfferingInput {
	s.NodeCount = &v
	return s
}

// SetReservedNodeOfferingId sets the ReservedNodeOfferingId field's value.
func (s *PurchaseReservedNodeOfferingInput) SetReservedNodeOfferingId(v string) *PurchaseReservedNodeOfferingInput {
	s.ReservedNodeOfferingId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOfferingResult
type PurchaseReservedNodeOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Describes a reserved node. You can call the DescribeReservedNodeOfferings
	// API to obtain the available reserved node offerings.
	ReservedNode *ReservedNode `type:"structure"`
}

// String returns the string representation
func (s PurchaseReservedNodeOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedNodeOfferingOutput) GoString() string {
	return s.String()
}

// SetReservedNode sets the ReservedNode field's value.
func (s *PurchaseReservedNodeOfferingOutput) SetReservedNode(v *ReservedNode) *PurchaseReservedNodeOfferingOutput {
	s.ReservedNode = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootClusterMessage
type RebootClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootClusterInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RebootClusterInput) SetClusterIdentifier(v string) *RebootClusterInput {
	s.ClusterIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootClusterResult
type RebootClusterOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RebootClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RebootClusterOutput) SetCluster(v *Cluster) *RebootClusterOutput {
	s.Cluster = v
	return s
}

// Describes a recurring charge.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RecurringCharge
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount charged per the period of time specified by the recurring charge
	// frequency.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency at which the recurring charge amount is applied.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetRecurringChargeAmount sets the RecurringChargeAmount field's value.
func (s *RecurringCharge) SetRecurringChargeAmount(v float64) *RecurringCharge {
	s.RecurringChargeAmount = &v
	return s
}

// SetRecurringChargeFrequency sets the RecurringChargeFrequency field's value.
func (s *RecurringCharge) SetRecurringChargeFrequency(v string) *RecurringCharge {
	s.RecurringChargeFrequency = &v
	return s
}

// Describes a reserved node. You can call the DescribeReservedNodeOfferings
// API to obtain the available reserved node offerings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ReservedNode
type ReservedNode struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved cluster.
	CurrencyCode *string `type:"string"`

	// The duration of the node reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed cost Amazon Redshift charges you for this reserved node.
	FixedPrice *float64 `type:"double"`

	// The number of reserved compute nodes.
	NodeCount *int64 `type:"integer"`

	// The node type of the reserved node.
	NodeType *string `type:"string"`

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string `type:"string"`

	// The recurring charges for the reserved node.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The unique identifier for the reservation.
	ReservedNodeId *string `type:"string"`

	// The identifier for the reserved node offering.
	ReservedNodeOfferingId *string `type:"string"`

	// The time the reservation started. You purchase a reserved node offering for
	// a duration. This is the start time of that duration.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the reserved compute node.
	//
	// Possible Values:
	//
	//    * pending-payment-This reserved node has recently been purchased, and
	//    the sale has been approved, but payment has not yet been confirmed.
	//
	//    * active-This reserved node is owned by the caller and is available for
	//    use.
	//
	//    * payment-failed-Payment failed for the purchase attempt.
	State *string `type:"string"`

	// The hourly rate Amazon Redshift charges you for this reserved node.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedNode) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedNode) SetCurrencyCode(v string) *ReservedNode {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedNode) SetDuration(v int64) *ReservedNode {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedNode) SetFixedPrice(v float64) *ReservedNode {
	s.FixedPrice = &v
	return s
}

// SetNodeCount sets the NodeCount field's value.
func (s *ReservedNode) SetNodeCount(v int64) *ReservedNode {
	s.NodeCount = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ReservedNode) SetNodeType(v string) *ReservedNode {
	s.NodeType = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *ReservedNode) SetOfferingType(v string) *ReservedNode {
	s.OfferingType = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedNode) SetRecurringCharges(v []*RecurringCharge) *ReservedNode {
	s.RecurringCharges = v
	return s
}

// SetReservedNodeId sets the ReservedNodeId field's value.
func (s *ReservedNode) SetReservedNodeId(v string) *ReservedNode {
	s.ReservedNodeId = &v
	return s
}

// SetReservedNodeOfferingId sets the ReservedNodeOfferingId field's value.
func (s *ReservedNode) SetReservedNodeOfferingId(v string) *ReservedNode {
	s.ReservedNodeOfferingId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReservedNode) SetStartTime(v time.Time) *ReservedNode {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReservedNode) SetState(v string) *ReservedNode {
	s.State = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedNode) SetUsagePrice(v float64) *ReservedNode {
	s.UsagePrice = &v
	return s
}

// Describes a reserved node offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ReservedNodeOffering
type ReservedNodeOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the compute nodes offering.
	CurrencyCode *string `type:"string"`

	// The duration, in seconds, for which the offering will reserve the node.
	Duration *int64 `type:"integer"`

	// The upfront fixed charge you will pay to purchase the specific reserved node
	// offering.
	FixedPrice *float64 `type:"double"`

	// The node type offered by the reserved node offering.
	NodeType *string `type:"string"`

	// The anticipated utilization of the reserved node, as defined in the reserved
	// node offering.
	OfferingType *string `type:"string"`

	// The charge to your account regardless of whether you are creating any clusters
	// using the node offering. Recurring charges are only in effect for heavy-utilization
	// reserved nodes.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The offering identifier.
	ReservedNodeOfferingId *string `type:"string"`

	// The rate you are charged for each hour the cluster that is using the offering
	// is running.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedNodeOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedNodeOffering) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedNodeOffering) SetCurrencyCode(v string) *ReservedNodeOffering {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedNodeOffering) SetDuration(v int64) *ReservedNodeOffering {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedNodeOffering) SetFixedPrice(v float64) *ReservedNodeOffering {
	s.FixedPrice = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ReservedNodeOffering) SetNodeType(v string) *ReservedNodeOffering {
	s.NodeType = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *ReservedNodeOffering) SetOfferingType(v string) *ReservedNodeOffering {
	s.OfferingType = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedNodeOffering) SetRecurringCharges(v []*RecurringCharge) *ReservedNodeOffering {
	s.RecurringCharges = v
	return s
}

// SetReservedNodeOfferingId sets the ReservedNodeOfferingId field's value.
func (s *ReservedNodeOffering) SetReservedNodeOfferingId(v string) *ReservedNodeOffering {
	s.ReservedNodeOfferingId = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedNodeOffering) SetUsagePrice(v float64) *ReservedNodeOffering {
	s.UsagePrice = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResetClusterParameterGroupMessage
type ResetClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group to be reset.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of names of parameters to be reset. If ResetAllParameters option
	// is not used, then at least one parameter name must be supplied.
	//
	// Constraints: A maximum of 20 parameters can be reset in a single request.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// If true, all parameters in the specified parameter group will be reset to
	// their default values.
	//
	// Default: true
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetClusterParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ResetClusterParameterGroupInput) SetParameterGroupName(v string) *ResetClusterParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ResetClusterParameterGroupInput) SetParameters(v []*Parameter) *ResetClusterParameterGroupInput {
	s.Parameters = v
	return s
}

// SetResetAllParameters sets the ResetAllParameters field's value.
func (s *ResetClusterParameterGroupInput) SetResetAllParameters(v bool) *ResetClusterParameterGroupInput {
	s.ResetAllParameters = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshotMessage
type RestoreFromClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Reserved.
	AdditionalInfo *string `type:"string"`

	// If true, major version upgrades can be applied during the maintenance window
	// to the Amazon Redshift engine that is running on the cluster.
	//
	// Default: true
	AllowVersionUpgrade *bool `type:"boolean"`

	// The number of days that automated snapshots are retained. If the value is
	// 0, automated snapshots are disabled. Even if automated snapshots are disabled,
	// you can still create manual snapshots when you want with CreateClusterSnapshot.
	//
	// Default: The value selected for the cluster from which the snapshot was taken.
	//
	// Constraints: Must be a value from 0 to 35.
	AutomatedSnapshotRetentionPeriod *int64 `type:"integer"`

	// The Amazon EC2 Availability Zone in which to restore the cluster.
	//
	// Default: A random, system-chosen Availability Zone.
	//
	// Example: us-east-1a
	AvailabilityZone *string `type:"string"`

	// The identifier of the cluster that will be created from restoring the snapshot.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * Alphabetic characters must be lowercase.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must be unique for all clusters within an AWS account.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the parameter group to be associated with this cluster.
	//
	// Default: The default Amazon Redshift cluster parameter group. For information
	// about the default parameter group, go to Working with Amazon Redshift Parameter
	// Groups (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html).
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ClusterParameterGroupName *string `type:"string"`

	// A list of security groups to be associated with this cluster.
	//
	// Default: The default cluster security group for Amazon Redshift.
	//
	// Cluster security groups only apply to clusters outside of VPCs.
	ClusterSecurityGroups []*string `locationNameList:"ClusterSecurityGroupName" type:"list"`

	// The name of the subnet group where you want to cluster restored.
	//
	// A snapshot of cluster in VPC can be restored only in VPC. Therefore, you
	// must provide subnet group name where you want the cluster restored.
	ClusterSubnetGroupName *string `type:"string"`

	// The elastic IP (EIP) address for the cluster.
	ElasticIp *string `type:"string"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// Specifies the name of the HSM client certificate the Amazon Redshift cluster
	// uses to retrieve the data encryption keys stored in an HSM.
	HsmClientCertificateIdentifier *string `type:"string"`

	// Specifies the name of the HSM configuration that contains the information
	// the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
	HsmConfigurationIdentifier *string `type:"string"`

	// A list of AWS Identity and Access Management (IAM) roles that can be used
	// by the cluster to access other AWS services. You must supply the IAM roles
	// in their Amazon Resource Name (ARN) format. You can supply up to 10 IAM roles
	// in a single request.
	//
	// A cluster can have up to 10 IAM roles associated at any time.
	IamRoles []*string `locationNameList:"IamRoleArn" type:"list"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that you
	// want to use to encrypt data in the cluster that you restore from a shared
	// snapshot.
	KmsKeyId *string `type:"string"`

	// The node type that the restored cluster will be provisioned with.
	//
	// Default: The node type of the cluster from which the snapshot was taken.
	// You can modify this if you are using any DS node type. In that case, you
	// can choose to restore into another DS node type of the same size. For example,
	// you can restore ds1.8xlarge into ds2.8xlarge, or ds2.xlarge into ds1.xlarge.
	// If you have a DC instance type, you must restore into that same instance
	// type and size. In other words, you can only restore a dc1.large instance
	// type into another dc1.large instance type. For more information about node
	// types, see  About Clusters and Nodes (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes)
	// in the Amazon Redshift Cluster Management Guide
	NodeType *string `type:"string"`

	// The AWS customer account used to create or copy the snapshot. Required if
	// you are restoring a snapshot you do not own, optional if you own the snapshot.
	OwnerAccount *string `type:"string"`

	// The port number on which the cluster accepts connections.
	//
	// Default: The same port as the original cluster.
	//
	// Constraints: Must be between 1115 and 65535.
	Port *int64 `type:"integer"`

	// The weekly time range (in UTC) during which automated cluster maintenance
	// can occur.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: The value selected for the cluster from which the snapshot was taken.
	// For more information about the time blocks for each region, see Maintenance
	// Windows (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows)
	// in Amazon Redshift Cluster Management Guide.
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// If true, the cluster can be accessed from a public network.
	PubliclyAccessible *bool `type:"boolean"`

	// The name of the cluster the source snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The name of the snapshot from which to create the new cluster. This parameter
	// isn't case sensitive.
	//
	// Example: my-snapshot-id
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// A list of Virtual Private Cloud (VPC) security groups to be associated with
	// the cluster.
	//
	// Default: The default VPC security group is associated with the cluster.
	//
	// VPC security groups only apply to clusters in VPCs.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreFromClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreFromClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreFromClusterSnapshotInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *RestoreFromClusterSnapshotInput) SetAdditionalInfo(v string) *RestoreFromClusterSnapshotInput {
	s.AdditionalInfo = &v
	return s
}

// SetAllowVersionUpgrade sets the AllowVersionUpgrade field's value.
func (s *RestoreFromClusterSnapshotInput) SetAllowVersionUpgrade(v bool) *RestoreFromClusterSnapshotInput {
	s.AllowVersionUpgrade = &v
	return s
}

// SetAutomatedSnapshotRetentionPeriod sets the AutomatedSnapshotRetentionPeriod field's value.
func (s *RestoreFromClusterSnapshotInput) SetAutomatedSnapshotRetentionPeriod(v int64) *RestoreFromClusterSnapshotInput {
	s.AutomatedSnapshotRetentionPeriod = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *RestoreFromClusterSnapshotInput) SetAvailabilityZone(v string) *RestoreFromClusterSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetClusterIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterParameterGroupName sets the ClusterParameterGroupName field's value.
func (s *RestoreFromClusterSnapshotInput) SetClusterParameterGroupName(v string) *RestoreFromClusterSnapshotInput {
	s.ClusterParameterGroupName = &v
	return s
}

// SetClusterSecurityGroups sets the ClusterSecurityGroups field's value.
func (s *RestoreFromClusterSnapshotInput) SetClusterSecurityGroups(v []*string) *RestoreFromClusterSnapshotInput {
	s.ClusterSecurityGroups = v
	return s
}

// SetClusterSubnetGroupName sets the ClusterSubnetGroupName field's value.
func (s *RestoreFromClusterSnapshotInput) SetClusterSubnetGroupName(v string) *RestoreFromClusterSnapshotInput {
	s.ClusterSubnetGroupName = &v
	return s
}

// SetElasticIp sets the ElasticIp field's value.
func (s *RestoreFromClusterSnapshotInput) SetElasticIp(v string) *RestoreFromClusterSnapshotInput {
	s.ElasticIp = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *RestoreFromClusterSnapshotInput) SetEnhancedVpcRouting(v bool) *RestoreFromClusterSnapshotInput {
	s.EnhancedVpcRouting = &v
	return s
}

// SetHsmClientCertificateIdentifier sets the HsmClientCertificateIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetHsmClientCertificateIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.HsmClientCertificateIdentifier = &v
	return s
}

// SetHsmConfigurationIdentifier sets the HsmConfigurationIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetHsmConfigurationIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.HsmConfigurationIdentifier = &v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *RestoreFromClusterSnapshotInput) SetIamRoles(v []*string) *RestoreFromClusterSnapshotInput {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreFromClusterSnapshotInput) SetKmsKeyId(v string) *RestoreFromClusterSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *RestoreFromClusterSnapshotInput) SetNodeType(v string) *RestoreFromClusterSnapshotInput {
	s.NodeType = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *RestoreFromClusterSnapshotInput) SetOwnerAccount(v string) *RestoreFromClusterSnapshotInput {
	s.OwnerAccount = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreFromClusterSnapshotInput) SetPort(v int64) *RestoreFromClusterSnapshotInput {
	s.Port = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *RestoreFromClusterSnapshotInput) SetPreferredMaintenanceWindow(v string) *RestoreFromClusterSnapshotInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *RestoreFromClusterSnapshotInput) SetPubliclyAccessible(v bool) *RestoreFromClusterSnapshotInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetSnapshotClusterIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RestoreFromClusterSnapshotInput) SetSnapshotIdentifier(v string) *RestoreFromClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreFromClusterSnapshotInput) SetVpcSecurityGroupIds(v []*string) *RestoreFromClusterSnapshotInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshotResult
type RestoreFromClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RestoreFromClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RestoreFromClusterSnapshotOutput) SetCluster(v *Cluster) *RestoreFromClusterSnapshotOutput {
	s.Cluster = v
	return s
}

// Describes the status of a cluster restore action. Returns null if the cluster
// was not created by restoring a snapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreStatus
type RestoreStatus struct {
	_ struct{} `type:"structure"`

	// The number of megabytes per second being transferred from the backup storage.
	// Returns the average rate for a completed backup.
	CurrentRestoreRateInMegaBytesPerSecond *float64 `type:"double"`

	// The amount of time an in-progress restore has been running, or the amount
	// of time it took a completed restore to finish.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// The estimate of the time remaining before the restore will complete. Returns
	// 0 for a completed restore.
	EstimatedTimeToCompletionInSeconds *int64 `type:"long"`

	// The number of megabytes that have been transferred from snapshot storage.
	ProgressInMegaBytes *int64 `type:"long"`

	// The size of the set of snapshot data used to restore the cluster.
	SnapshotSizeInMegaBytes *int64 `type:"long"`

	// The status of the restore action. Returns starting, restoring, completed,
	// or failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s RestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreStatus) GoString() string {
	return s.String()
}

// SetCurrentRestoreRateInMegaBytesPerSecond sets the CurrentRestoreRateInMegaBytesPerSecond field's value.
func (s *RestoreStatus) SetCurrentRestoreRateInMegaBytesPerSecond(v float64) *RestoreStatus {
	s.CurrentRestoreRateInMegaBytesPerSecond = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *RestoreStatus) SetElapsedTimeInSeconds(v int64) *RestoreStatus {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedTimeToCompletionInSeconds sets the EstimatedTimeToCompletionInSeconds field's value.
func (s *RestoreStatus) SetEstimatedTimeToCompletionInSeconds(v int64) *RestoreStatus {
	s.EstimatedTimeToCompletionInSeconds = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *RestoreStatus) SetProgressInMegaBytes(v int64) *RestoreStatus {
	s.ProgressInMegaBytes = &v
	return s
}

// SetSnapshotSizeInMegaBytes sets the SnapshotSizeInMegaBytes field's value.
func (s *RestoreStatus) SetSnapshotSizeInMegaBytes(v int64) *RestoreStatus {
	s.SnapshotSizeInMegaBytes = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RestoreStatus) SetStatus(v string) *RestoreStatus {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshotMessage
type RestoreTableFromClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift cluster to restore the table to.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of the table to create as a result of the current request.
	//
	// NewTableName is a required field
	NewTableName *string `type:"string" required:"true"`

	// The identifier of the snapshot to restore the table from. This snapshot must
	// have been created from the Amazon Redshift cluster specified by the ClusterIdentifier
	// parameter.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// The name of the source database that contains the table to restore from.
	//
	// SourceDatabaseName is a required field
	SourceDatabaseName *string `type:"string" required:"true"`

	// The name of the source schema that contains the table to restore from. If
	// you do not specify a SourceSchemaName value, the default is public.
	SourceSchemaName *string `type:"string"`

	// The name of the source table to restore from.
	//
	// SourceTableName is a required field
	SourceTableName *string `type:"string" required:"true"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `type:"string"`
}

// String returns the string representation
func (s RestoreTableFromClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableFromClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableFromClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTableFromClusterSnapshotInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}
	if s.NewTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("NewTableName"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}
	if s.SourceDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDatabaseName"))
	}
	if s.SourceTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceTableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetClusterIdentifier(v string) *RestoreTableFromClusterSnapshotInput {
	s.ClusterIdentifier = &v
	return s
}

// SetNewTableName sets the NewTableName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetNewTableName(v string) *RestoreTableFromClusterSnapshotInput {
	s.NewTableName = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetSnapshotIdentifier(v string) *RestoreTableFromClusterSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetSourceDatabaseName sets the SourceDatabaseName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetSourceDatabaseName(v string) *RestoreTableFromClusterSnapshotInput {
	s.SourceDatabaseName = &v
	return s
}

// SetSourceSchemaName sets the SourceSchemaName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetSourceSchemaName(v string) *RestoreTableFromClusterSnapshotInput {
	s.SourceSchemaName = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetSourceTableName(v string) *RestoreTableFromClusterSnapshotInput {
	s.SourceTableName = &v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetTargetDatabaseName(v string) *RestoreTableFromClusterSnapshotInput {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetSchemaName sets the TargetSchemaName field's value.
func (s *RestoreTableFromClusterSnapshotInput) SetTargetSchemaName(v string) *RestoreTableFromClusterSnapshotInput {
	s.TargetSchemaName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshotResult
type RestoreTableFromClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Describes the status of a RestoreTableFromClusterSnapshot operation.
	TableRestoreStatus *TableRestoreStatus `type:"structure"`
}

// String returns the string representation
func (s RestoreTableFromClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreTableFromClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetTableRestoreStatus sets the TableRestoreStatus field's value.
func (s *RestoreTableFromClusterSnapshotOutput) SetTableRestoreStatus(v *TableRestoreStatus) *RestoreTableFromClusterSnapshotOutput {
	s.TableRestoreStatus = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngressMessage
type RevokeClusterSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range for which to revoke access. This range must be a valid Classless
	// Inter-Domain Routing (CIDR) block of IP addresses. If CIDRIP is specified,
	// EC2SecurityGroupName and EC2SecurityGroupOwnerId cannot be provided.
	CIDRIP *string `type:"string"`

	// The name of the security Group from which to revoke the ingress rule.
	//
	// ClusterSecurityGroupName is a required field
	ClusterSecurityGroupName *string `type:"string" required:"true"`

	// The name of the EC2 Security Group whose access is to be revoked. If EC2SecurityGroupName
	// is specified, EC2SecurityGroupOwnerId must also be provided and CIDRIP cannot
	// be provided.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account number of the owner of the security group specified in the
	// EC2SecurityGroupName parameter. The AWS access key ID is not an acceptable
	// value. If EC2SecurityGroupOwnerId is specified, EC2SecurityGroupName must
	// also be provided. and CIDRIP cannot be provided.
	//
	// Example: 111122223333
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s RevokeClusterSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeClusterSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeClusterSecurityGroupIngressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeClusterSecurityGroupIngressInput"}
	if s.ClusterSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *RevokeClusterSecurityGroupIngressInput) SetCIDRIP(v string) *RevokeClusterSecurityGroupIngressInput {
	s.CIDRIP = &v
	return s
}

// SetClusterSecurityGroupName sets the ClusterSecurityGroupName field's value.
func (s *RevokeClusterSecurityGroupIngressInput) SetClusterSecurityGroupName(v string) *RevokeClusterSecurityGroupIngressInput {
	s.ClusterSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *RevokeClusterSecurityGroupIngressInput) SetEC2SecurityGroupName(v string) *RevokeClusterSecurityGroupIngressInput {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *RevokeClusterSecurityGroupIngressInput) SetEC2SecurityGroupOwnerId(v string) *RevokeClusterSecurityGroupIngressInput {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngressResult
type RevokeClusterSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Describes a security group.
	ClusterSecurityGroup *ClusterSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s RevokeClusterSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeClusterSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// SetClusterSecurityGroup sets the ClusterSecurityGroup field's value.
func (s *RevokeClusterSecurityGroupIngressOutput) SetClusterSecurityGroup(v *ClusterSecurityGroup) *RevokeClusterSecurityGroupIngressOutput {
	s.ClusterSecurityGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccessMessage
type RevokeSnapshotAccessInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS customer account that can no longer restore the
	// specified snapshot.
	//
	// AccountWithRestoreAccess is a required field
	AccountWithRestoreAccess *string `type:"string" required:"true"`

	// The identifier of the cluster the snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The identifier of the snapshot that the account can no longer access.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeSnapshotAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSnapshotAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeSnapshotAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeSnapshotAccessInput"}
	if s.AccountWithRestoreAccess == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountWithRestoreAccess"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountWithRestoreAccess sets the AccountWithRestoreAccess field's value.
func (s *RevokeSnapshotAccessInput) SetAccountWithRestoreAccess(v string) *RevokeSnapshotAccessInput {
	s.AccountWithRestoreAccess = &v
	return s
}

// SetSnapshotClusterIdentifier sets the SnapshotClusterIdentifier field's value.
func (s *RevokeSnapshotAccessInput) SetSnapshotClusterIdentifier(v string) *RevokeSnapshotAccessInput {
	s.SnapshotClusterIdentifier = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RevokeSnapshotAccessInput) SetSnapshotIdentifier(v string) *RevokeSnapshotAccessInput {
	s.SnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccessResult
type RevokeSnapshotAccessOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s RevokeSnapshotAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeSnapshotAccessOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *RevokeSnapshotAccessOutput) SetSnapshot(v *Snapshot) *RevokeSnapshotAccessOutput {
	s.Snapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKeyMessage
type RotateEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster that you want to rotate the encryption
	// keys for.
	//
	// Constraints: Must be the name of valid cluster that has encryption enabled.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RotateEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateEncryptionKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotateEncryptionKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotateEncryptionKeyInput"}
	if s.ClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *RotateEncryptionKeyInput) SetClusterIdentifier(v string) *RotateEncryptionKeyInput {
	s.ClusterIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKeyResult
type RotateEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`

	// Describes a cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RotateEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateEncryptionKeyOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RotateEncryptionKeyOutput) SetCluster(v *Cluster) *RotateEncryptionKeyOutput {
	s.Cluster = v
	return s
}

// Describes a snapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/Snapshot
type Snapshot struct {
	_ struct{} `type:"structure"`

	// A list of the AWS customer accounts authorized to restore the snapshot. Returns
	// null if no accounts are authorized. Visible only to the snapshot owner.
	AccountsWithRestoreAccess []*AccountWithRestoreAccess `locationNameList:"AccountWithRestoreAccess" type:"list"`

	// The size of the incremental backup.
	ActualIncrementalBackupSizeInMegaBytes *float64 `type:"double"`

	// The Availability Zone in which the cluster was created.
	AvailabilityZone *string `type:"string"`

	// The number of megabytes that have been transferred to the snapshot backup.
	BackupProgressInMegaBytes *float64 `type:"double"`

	// The time (UTC) when the cluster was originally created.
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the cluster for which the snapshot was taken.
	ClusterIdentifier *string `type:"string"`

	// The version ID of the Amazon Redshift engine that is running on the cluster.
	ClusterVersion *string `type:"string"`

	// The number of megabytes per second being transferred to the snapshot backup.
	// Returns 0 for a completed backup.
	CurrentBackupRateInMegaBytesPerSecond *float64 `type:"double"`

	// The name of the database that was created when the cluster was created.
	DBName *string `type:"string"`

	// The amount of time an in-progress snapshot backup has been running, or the
	// amount of time it took a completed backup to finish.
	ElapsedTimeInSeconds *int64 `type:"long"`

	// If true, the data in the snapshot is encrypted at rest.
	Encrypted *bool `type:"boolean"`

	// A boolean that indicates whether the snapshot data is encrypted using the
	// HSM keys of the source cluster. true indicates that the data is encrypted
	// using HSM keys.
	EncryptedWithHSM *bool `type:"boolean"`

	// An option that specifies whether to create the cluster with enhanced VPC
	// routing enabled. To create a cluster that uses enhanced VPC routing, the
	// cluster must be in a VPC. For more information, see Enhanced VPC Routing
	// (http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
	// in the Amazon Redshift Cluster Management Guide.
	//
	// If this option is true, enhanced VPC routing is enabled.
	//
	// Default: false
	EnhancedVpcRouting *bool `type:"boolean"`

	// The estimate of the time remaining before the snapshot backup will complete.
	// Returns 0 for a completed backup.
	EstimatedSecondsToCompletion *int64 `type:"long"`

	// The AWS Key Management Service (KMS) key ID of the encryption key that was
	// used to encrypt data in the cluster from which the snapshot was taken.
	KmsKeyId *string `type:"string"`

	// The master user name for the cluster.
	MasterUsername *string `type:"string"`

	// The node type of the nodes in the cluster.
	NodeType *string `type:"string"`

	// The number of nodes in the cluster.
	NumberOfNodes *int64 `type:"integer"`

	// For manual snapshots, the AWS customer account used to create or copy the
	// snapshot. For automatic snapshots, the owner of the cluster. The owner can
	// perform all snapshot actions, such as sharing a manual snapshot.
	OwnerAccount *string `type:"string"`

	// The port that the cluster is listening on.
	Port *int64 `type:"integer"`

	// The list of node types that this cluster snapshot is able to restore into.
	RestorableNodeTypes []*string `locationNameList:"NodeType" type:"list"`

	// The time (UTC) when Amazon Redshift began the snapshot. A snapshot contains
	// a copy of the cluster data as of this exact time.
	SnapshotCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The snapshot identifier that is provided in the request.
	SnapshotIdentifier *string `type:"string"`

	// The snapshot type. Snapshots created using CreateClusterSnapshot and CopyClusterSnapshot
	// will be of type "manual".
	SnapshotType *string `type:"string"`

	// The source region from which the snapshot was copied.
	SourceRegion *string `type:"string"`

	// The snapshot status. The value of the status depends on the API operation
	// used.
	//
	//    * CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
	//
	//
	//    * DescribeClusterSnapshots returns status as "creating", "available",
	//    "final snapshot", or "failed".
	//
	//    * DeleteClusterSnapshot returns status as "deleted".
	Status *string `type:"string"`

	// The list of tags for the cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The size of the complete set of backup data that would be used to restore
	// the cluster.
	TotalBackupSizeInMegaBytes *float64 `type:"double"`

	// The VPC identifier of the cluster if the snapshot is from a cluster in a
	// VPC. Otherwise, this field is not in the output.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// SetAccountsWithRestoreAccess sets the AccountsWithRestoreAccess field's value.
func (s *Snapshot) SetAccountsWithRestoreAccess(v []*AccountWithRestoreAccess) *Snapshot {
	s.AccountsWithRestoreAccess = v
	return s
}

// SetActualIncrementalBackupSizeInMegaBytes sets the ActualIncrementalBackupSizeInMegaBytes field's value.
func (s *Snapshot) SetActualIncrementalBackupSizeInMegaBytes(v float64) *Snapshot {
	s.ActualIncrementalBackupSizeInMegaBytes = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Snapshot) SetAvailabilityZone(v string) *Snapshot {
	s.AvailabilityZone = &v
	return s
}

// SetBackupProgressInMegaBytes sets the BackupProgressInMegaBytes field's value.
func (s *Snapshot) SetBackupProgressInMegaBytes(v float64) *Snapshot {
	s.BackupProgressInMegaBytes = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *Snapshot) SetClusterCreateTime(v time.Time) *Snapshot {
	s.ClusterCreateTime = &v
	return s
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *Snapshot) SetClusterIdentifier(v string) *Snapshot {
	s.ClusterIdentifier = &v
	return s
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *Snapshot) SetClusterVersion(v string) *Snapshot {
	s.ClusterVersion = &v
	return s
}

// SetCurrentBackupRateInMegaBytesPerSecond sets the CurrentBackupRateInMegaBytesPerSecond field's value.
func (s *Snapshot) SetCurrentBackupRateInMegaBytesPerSecond(v float64) *Snapshot {
	s.CurrentBackupRateInMegaBytesPerSecond = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *Snapshot) SetDBName(v string) *Snapshot {
	s.DBName = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *Snapshot) SetElapsedTimeInSeconds(v int64) *Snapshot {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *Snapshot) SetEncrypted(v bool) *Snapshot {
	s.Encrypted = &v
	return s
}

// SetEncryptedWithHSM sets the EncryptedWithHSM field's value.
func (s *Snapshot) SetEncryptedWithHSM(v bool) *Snapshot {
	s.EncryptedWithHSM = &v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *Snapshot) SetEnhancedVpcRouting(v bool) *Snapshot {
	s.EnhancedVpcRouting = &v
	return s
}

// SetEstimatedSecondsToCompletion sets the EstimatedSecondsToCompletion field's value.
func (s *Snapshot) SetEstimatedSecondsToCompletion(v int64) *Snapshot {
	s.EstimatedSecondsToCompletion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Snapshot) SetKmsKeyId(v string) *Snapshot {
	s.KmsKeyId = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *Snapshot) SetMasterUsername(v string) *Snapshot {
	s.MasterUsername = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *Snapshot) SetNodeType(v string) *Snapshot {
	s.NodeType = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *Snapshot) SetNumberOfNodes(v int64) *Snapshot {
	s.NumberOfNodes = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Snapshot) SetOwnerAccount(v string) *Snapshot {
	s.OwnerAccount = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Snapshot) SetPort(v int64) *Snapshot {
	s.Port = &v
	return s
}

// SetRestorableNodeTypes sets the RestorableNodeTypes field's value.
func (s *Snapshot) SetRestorableNodeTypes(v []*string) *Snapshot {
	s.RestorableNodeTypes = v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *Snapshot) SetSnapshotCreateTime(v time.Time) *Snapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *Snapshot) SetSnapshotIdentifier(v string) *Snapshot {
	s.SnapshotIdentifier = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *Snapshot) SetSnapshotType(v string) *Snapshot {
	s.SnapshotType = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *Snapshot) SetSourceRegion(v string) *Snapshot {
	s.SourceRegion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Snapshot) SetStatus(v string) *Snapshot {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Snapshot) SetTags(v []*Tag) *Snapshot {
	s.Tags = v
	return s
}

// SetTotalBackupSizeInMegaBytes sets the TotalBackupSizeInMegaBytes field's value.
func (s *Snapshot) SetTotalBackupSizeInMegaBytes(v float64) *Snapshot {
	s.TotalBackupSizeInMegaBytes = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Snapshot) SetVpcId(v string) *Snapshot {
	s.VpcId = &v
	return s
}

// The snapshot copy grant that grants Amazon Redshift permission to encrypt
// copied snapshots with the specified customer master key (CMK) from AWS KMS
// in the destination region.
//
// For more information about managing snapshot copy grants, go to Amazon Redshift
// Database Encryption (http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
// in the Amazon Redshift Cluster Management Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/SnapshotCopyGrant
type SnapshotCopyGrant struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the customer master key (CMK) in AWS KMS to which
	// Amazon Redshift is granted permission.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot copy grant.
	SnapshotCopyGrantName *string `type:"string"`

	// A list of tag instances.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s SnapshotCopyGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotCopyGrant) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *SnapshotCopyGrant) SetKmsKeyId(v string) *SnapshotCopyGrant {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotCopyGrantName sets the SnapshotCopyGrantName field's value.
func (s *SnapshotCopyGrant) SetSnapshotCopyGrantName(v string) *SnapshotCopyGrant {
	s.SnapshotCopyGrantName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SnapshotCopyGrant) SetTags(v []*Tag) *SnapshotCopyGrant {
	s.Tags = v
	return s
}

// Describes a subnet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/Subnet
type Subnet struct {
	_ struct{} `type:"structure"`

	// Describes an availability zone.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// The status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *Subnet) SetSubnetAvailabilityZone(v *AvailabilityZone) *Subnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *Subnet) SetSubnetIdentifier(v string) *Subnet {
	s.SubnetIdentifier = &v
	return s
}

// SetSubnetStatus sets the SubnetStatus field's value.
func (s *Subnet) SetSubnetStatus(v string) *Subnet {
	s.SubnetStatus = &v
	return s
}

// Describes the status of a RestoreTableFromClusterSnapshot operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/TableRestoreStatus
type TableRestoreStatus struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Redshift cluster that the table is being restored
	// to.
	ClusterIdentifier *string `type:"string"`

	// A description of the status of the table restore request. Status values include
	// SUCCEEDED, FAILED, CANCELED, PENDING, IN_PROGRESS.
	Message *string `type:"string"`

	// The name of the table to create as a result of the table restore request.
	NewTableName *string `type:"string"`

	// The amount of data restored to the new table so far, in megabytes (MB).
	ProgressInMegaBytes *int64 `type:"long"`

	// The time that the table restore request was made, in Universal Coordinated
	// Time (UTC).
	RequestTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the snapshot that the table is being restored from.
	SnapshotIdentifier *string `type:"string"`

	// The name of the source database that contains the table being restored.
	SourceDatabaseName *string `type:"string"`

	// The name of the source schema that contains the table being restored.
	SourceSchemaName *string `type:"string"`

	// The name of the source table being restored.
	SourceTableName *string `type:"string"`

	// A value that describes the current state of the table restore request.
	//
	// Valid Values: SUCCEEDED, FAILED, CANCELED, PENDING, IN_PROGRESS
	Status *string `type:"string" enum:"TableRestoreStatusType"`

	// The unique identifier for the table restore request.
	TableRestoreRequestId *string `type:"string"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `type:"string"`

	// The total amount of data to restore to the new table, in megabytes (MB).
	TotalDataInMegaBytes *int64 `type:"long"`
}

// String returns the string representation
func (s TableRestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableRestoreStatus) GoString() string {
	return s.String()
}

// SetClusterIdentifier sets the ClusterIdentifier field's value.
func (s *TableRestoreStatus) SetClusterIdentifier(v string) *TableRestoreStatus {
	s.ClusterIdentifier = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TableRestoreStatus) SetMessage(v string) *TableRestoreStatus {
	s.Message = &v
	return s
}

// SetNewTableName sets the NewTableName field's value.
func (s *TableRestoreStatus) SetNewTableName(v string) *TableRestoreStatus {
	s.NewTableName = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *TableRestoreStatus) SetProgressInMegaBytes(v int64) *TableRestoreStatus {
	s.ProgressInMegaBytes = &v
	return s
}

// SetRequestTime sets the RequestTime field's value.
func (s *TableRestoreStatus) SetRequestTime(v time.Time) *TableRestoreStatus {
	s.RequestTime = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *TableRestoreStatus) SetSnapshotIdentifier(v string) *TableRestoreStatus {
	s.SnapshotIdentifier = &v
	return s
}

// SetSourceDatabaseName sets the SourceDatabaseName field's value.
func (s *TableRestoreStatus) SetSourceDatabaseName(v string) *TableRestoreStatus {
	s.SourceDatabaseName = &v
	return s
}

// SetSourceSchemaName sets the SourceSchemaName field's value.
func (s *TableRestoreStatus) SetSourceSchemaName(v string) *TableRestoreStatus {
	s.SourceSchemaName = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *TableRestoreStatus) SetSourceTableName(v string) *TableRestoreStatus {
	s.SourceTableName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TableRestoreStatus) SetStatus(v string) *TableRestoreStatus {
	s.Status = &v
	return s
}

// SetTableRestoreRequestId sets the TableRestoreRequestId field's value.
func (s *TableRestoreStatus) SetTableRestoreRequestId(v string) *TableRestoreStatus {
	s.TableRestoreRequestId = &v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *TableRestoreStatus) SetTargetDatabaseName(v string) *TableRestoreStatus {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetSchemaName sets the TargetSchemaName field's value.
func (s *TableRestoreStatus) SetTargetSchemaName(v string) *TableRestoreStatus {
	s.TargetSchemaName = &v
	return s
}

// SetTotalDataInMegaBytes sets the TotalDataInMegaBytes field's value.
func (s *TableRestoreStatus) SetTotalDataInMegaBytes(v int64) *TableRestoreStatus {
	s.TotalDataInMegaBytes = &v
	return s
}

// A tag consisting of a name/value pair for a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key, or name, for the resource tag.
	Key *string `type:"string"`

	// The value for the resource tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A tag and its associated resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/TaggedResource
type TaggedResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) with which the tag is associated. For example,
	// arn:aws:redshift:us-east-1:123456789:cluster:t1.
	ResourceName *string `type:"string"`

	// The type of resource with which the tag is associated. Valid resource types
	// are:
	//
	//    * Cluster
	//
	//    * CIDR/IP
	//
	//    * EC2 security group
	//
	//    * Snapshot
	//
	//    * Cluster security group
	//
	//    * Subnet group
	//
	//    * HSM connection
	//
	//    * HSM certificate
	//
	//    * Parameter group
	//
	// For more information about Amazon Redshift resource types and constructing
	// ARNs, go to Constructing an Amazon Redshift Amazon Resource Name (ARN) (http://docs.aws.amazon.com/redshift/latest/mgmt/constructing-redshift-arn.html)
	// in the Amazon Redshift Cluster Management Guide.
	ResourceType *string `type:"string"`

	// The tag for the resource.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s TaggedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaggedResource) GoString() string {
	return s.String()
}

// SetResourceName sets the ResourceName field's value.
func (s *TaggedResource) SetResourceName(v string) *TaggedResource {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TaggedResource) SetResourceType(v string) *TaggedResource {
	s.ResourceType = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *TaggedResource) SetTag(v *Tag) *TaggedResource {
	s.Tag = v
	return s
}

// Describes the members of a VPC security group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/VpcSecurityGroupMembership
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The identifier of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VpcSecurityGroupMembership) SetStatus(v string) *VpcSecurityGroupMembership {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *VpcSecurityGroupMembership) SetVpcSecurityGroupId(v string) *VpcSecurityGroupMembership {
	s.VpcSecurityGroupId = &v
	return s
}

const (
	// ParameterApplyTypeStatic is a ParameterApplyType enum value
	ParameterApplyTypeStatic = "static"

	// ParameterApplyTypeDynamic is a ParameterApplyType enum value
	ParameterApplyTypeDynamic = "dynamic"
)

const (
	// SourceTypeCluster is a SourceType enum value
	SourceTypeCluster = "cluster"

	// SourceTypeClusterParameterGroup is a SourceType enum value
	SourceTypeClusterParameterGroup = "cluster-parameter-group"

	// SourceTypeClusterSecurityGroup is a SourceType enum value
	SourceTypeClusterSecurityGroup = "cluster-security-group"

	// SourceTypeClusterSnapshot is a SourceType enum value
	SourceTypeClusterSnapshot = "cluster-snapshot"
)

const (
	// TableRestoreStatusTypePending is a TableRestoreStatusType enum value
	TableRestoreStatusTypePending = "PENDING"

	// TableRestoreStatusTypeInProgress is a TableRestoreStatusType enum value
	TableRestoreStatusTypeInProgress = "IN_PROGRESS"

	// TableRestoreStatusTypeSucceeded is a TableRestoreStatusType enum value
	TableRestoreStatusTypeSucceeded = "SUCCEEDED"

	// TableRestoreStatusTypeFailed is a TableRestoreStatusType enum value
	TableRestoreStatusTypeFailed = "FAILED"

	// TableRestoreStatusTypeCanceled is a TableRestoreStatusType enum value
	TableRestoreStatusTypeCanceled = "CANCELED"
)
