// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package elasticbeanstalk_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/elasticbeanstalk"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleElasticBeanstalk_AbortEnvironmentUpdate() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.AbortEnvironmentUpdateInput{
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
	}
	resp, err := svc.AbortEnvironmentUpdate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_ApplyEnvironmentManagedAction() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.ApplyEnvironmentManagedActionInput{
		ActionId:        aws.String("String"), // Required
		EnvironmentId:   aws.String("String"),
		EnvironmentName: aws.String("String"),
	}
	resp, err := svc.ApplyEnvironmentManagedAction(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_CheckDNSAvailability() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.CheckDNSAvailabilityInput{
		CNAMEPrefix: aws.String("DNSCnamePrefix"), // Required
	}
	resp, err := svc.CheckDNSAvailability(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_ComposeEnvironments() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.ComposeEnvironmentsInput{
		ApplicationName: aws.String("ApplicationName"),
		GroupName:       aws.String("GroupName"),
		VersionLabels: []*string{
			aws.String("VersionLabel"), // Required
			// More values...
		},
	}
	resp, err := svc.ComposeEnvironments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_CreateApplication() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.CreateApplicationInput{
		ApplicationName: aws.String("ApplicationName"), // Required
		Description:     aws.String("Description"),
		ResourceLifecycleConfig: &elasticbeanstalk.ApplicationResourceLifecycleConfig{
			ServiceRole: aws.String("String"),
			VersionLifecycleConfig: &elasticbeanstalk.ApplicationVersionLifecycleConfig{
				MaxAgeRule: &elasticbeanstalk.MaxAgeRule{
					Enabled:            aws.Bool(true), // Required
					DeleteSourceFromS3: aws.Bool(true),
					MaxAgeInDays:       aws.Int64(1),
				},
				MaxCountRule: &elasticbeanstalk.MaxCountRule{
					Enabled:            aws.Bool(true), // Required
					DeleteSourceFromS3: aws.Bool(true),
					MaxCount:           aws.Int64(1),
				},
			},
		},
	}
	resp, err := svc.CreateApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_CreateApplicationVersion() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.CreateApplicationVersionInput{
		ApplicationName:       aws.String("ApplicationName"), // Required
		VersionLabel:          aws.String("VersionLabel"),    // Required
		AutoCreateApplication: aws.Bool(true),
		BuildConfiguration: &elasticbeanstalk.BuildConfiguration{
			CodeBuildServiceRole: aws.String("NonEmptyString"), // Required
			Image:                aws.String("NonEmptyString"), // Required
			ArtifactName:         aws.String("String"),
			ComputeType:          aws.String("ComputeType"),
			TimeoutInMinutes:     aws.Int64(1),
		},
		Description: aws.String("Description"),
		Process:     aws.Bool(true),
		SourceBuildInformation: &elasticbeanstalk.SourceBuildInformation{
			SourceLocation:   aws.String("SourceLocation"),   // Required
			SourceRepository: aws.String("SourceRepository"), // Required
			SourceType:       aws.String("SourceType"),       // Required
		},
		SourceBundle: &elasticbeanstalk.S3Location{
			S3Bucket: aws.String("S3Bucket"),
			S3Key:    aws.String("S3Key"),
		},
	}
	resp, err := svc.CreateApplicationVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_CreateConfigurationTemplate() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.CreateConfigurationTemplateInput{
		ApplicationName: aws.String("ApplicationName"),           // Required
		TemplateName:    aws.String("ConfigurationTemplateName"), // Required
		Description:     aws.String("Description"),
		EnvironmentId:   aws.String("EnvironmentId"),
		OptionSettings: []*elasticbeanstalk.ConfigurationOptionSetting{
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
				Value:        aws.String("ConfigurationOptionValue"),
			},
			// More values...
		},
		SolutionStackName: aws.String("SolutionStackName"),
		SourceConfiguration: &elasticbeanstalk.SourceConfiguration{
			ApplicationName: aws.String("ApplicationName"),
			TemplateName:    aws.String("ConfigurationTemplateName"),
		},
	}
	resp, err := svc.CreateConfigurationTemplate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_CreateEnvironment() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.CreateEnvironmentInput{
		ApplicationName: aws.String("ApplicationName"), // Required
		CNAMEPrefix:     aws.String("DNSCnamePrefix"),
		Description:     aws.String("Description"),
		EnvironmentName: aws.String("EnvironmentName"),
		GroupName:       aws.String("GroupName"),
		OptionSettings: []*elasticbeanstalk.ConfigurationOptionSetting{
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
				Value:        aws.String("ConfigurationOptionValue"),
			},
			// More values...
		},
		OptionsToRemove: []*elasticbeanstalk.OptionSpecification{
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
			},
			// More values...
		},
		SolutionStackName: aws.String("SolutionStackName"),
		Tags: []*elasticbeanstalk.Tag{
			{ // Required
				Key:   aws.String("TagKey"),
				Value: aws.String("TagValue"),
			},
			// More values...
		},
		TemplateName: aws.String("ConfigurationTemplateName"),
		Tier: &elasticbeanstalk.EnvironmentTier{
			Name:    aws.String("String"),
			Type:    aws.String("String"),
			Version: aws.String("String"),
		},
		VersionLabel: aws.String("VersionLabel"),
	}
	resp, err := svc.CreateEnvironment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_CreateStorageLocation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	var params *elasticbeanstalk.CreateStorageLocationInput
	resp, err := svc.CreateStorageLocation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DeleteApplication() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DeleteApplicationInput{
		ApplicationName:     aws.String("ApplicationName"), // Required
		TerminateEnvByForce: aws.Bool(true),
	}
	resp, err := svc.DeleteApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DeleteApplicationVersion() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DeleteApplicationVersionInput{
		ApplicationName:    aws.String("ApplicationName"), // Required
		VersionLabel:       aws.String("VersionLabel"),    // Required
		DeleteSourceBundle: aws.Bool(true),
	}
	resp, err := svc.DeleteApplicationVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DeleteConfigurationTemplate() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DeleteConfigurationTemplateInput{
		ApplicationName: aws.String("ApplicationName"),           // Required
		TemplateName:    aws.String("ConfigurationTemplateName"), // Required
	}
	resp, err := svc.DeleteConfigurationTemplate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DeleteEnvironmentConfiguration() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DeleteEnvironmentConfigurationInput{
		ApplicationName: aws.String("ApplicationName"), // Required
		EnvironmentName: aws.String("EnvironmentName"), // Required
	}
	resp, err := svc.DeleteEnvironmentConfiguration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeApplicationVersions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeApplicationVersionsInput{
		ApplicationName: aws.String("ApplicationName"),
		MaxRecords:      aws.Int64(1),
		NextToken:       aws.String("Token"),
		VersionLabels: []*string{
			aws.String("VersionLabel"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeApplicationVersions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeApplications() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeApplicationsInput{
		ApplicationNames: []*string{
			aws.String("ApplicationName"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeApplications(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeConfigurationOptions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeConfigurationOptionsInput{
		ApplicationName: aws.String("ApplicationName"),
		EnvironmentName: aws.String("EnvironmentName"),
		Options: []*elasticbeanstalk.OptionSpecification{
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
			},
			// More values...
		},
		SolutionStackName: aws.String("SolutionStackName"),
		TemplateName:      aws.String("ConfigurationTemplateName"),
	}
	resp, err := svc.DescribeConfigurationOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeConfigurationSettings() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeConfigurationSettingsInput{
		ApplicationName: aws.String("ApplicationName"), // Required
		EnvironmentName: aws.String("EnvironmentName"),
		TemplateName:    aws.String("ConfigurationTemplateName"),
	}
	resp, err := svc.DescribeConfigurationSettings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeEnvironmentHealth() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeEnvironmentHealthInput{
		AttributeNames: []*string{
			aws.String("EnvironmentHealthAttribute"), // Required
			// More values...
		},
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
	}
	resp, err := svc.DescribeEnvironmentHealth(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeEnvironmentManagedActionHistory() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeEnvironmentManagedActionHistoryInput{
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
		MaxItems:        aws.Int64(1),
		NextToken:       aws.String("String"),
	}
	resp, err := svc.DescribeEnvironmentManagedActionHistory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeEnvironmentManagedActions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeEnvironmentManagedActionsInput{
		EnvironmentId:   aws.String("String"),
		EnvironmentName: aws.String("String"),
		Status:          aws.String("ActionStatus"),
	}
	resp, err := svc.DescribeEnvironmentManagedActions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeEnvironmentResources() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeEnvironmentResourcesInput{
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
	}
	resp, err := svc.DescribeEnvironmentResources(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeEnvironments() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeEnvironmentsInput{
		ApplicationName: aws.String("ApplicationName"),
		EnvironmentIds: []*string{
			aws.String("EnvironmentId"), // Required
			// More values...
		},
		EnvironmentNames: []*string{
			aws.String("EnvironmentName"), // Required
			// More values...
		},
		IncludeDeleted:        aws.Bool(true),
		IncludedDeletedBackTo: aws.Time(time.Now()),
		VersionLabel:          aws.String("VersionLabel"),
	}
	resp, err := svc.DescribeEnvironments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeEvents() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeEventsInput{
		ApplicationName: aws.String("ApplicationName"),
		EndTime:         aws.Time(time.Now()),
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
		MaxRecords:      aws.Int64(1),
		NextToken:       aws.String("Token"),
		RequestId:       aws.String("RequestId"),
		Severity:        aws.String("EventSeverity"),
		StartTime:       aws.Time(time.Now()),
		TemplateName:    aws.String("ConfigurationTemplateName"),
		VersionLabel:    aws.String("VersionLabel"),
	}
	resp, err := svc.DescribeEvents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_DescribeInstancesHealth() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.DescribeInstancesHealthInput{
		AttributeNames: []*string{
			aws.String("InstancesHealthAttribute"), // Required
			// More values...
		},
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
		NextToken:       aws.String("NextToken"),
	}
	resp, err := svc.DescribeInstancesHealth(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_ListAvailableSolutionStacks() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	var params *elasticbeanstalk.ListAvailableSolutionStacksInput
	resp, err := svc.ListAvailableSolutionStacks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_RebuildEnvironment() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.RebuildEnvironmentInput{
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
	}
	resp, err := svc.RebuildEnvironment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_RequestEnvironmentInfo() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.RequestEnvironmentInfoInput{
		InfoType:        aws.String("EnvironmentInfoType"), // Required
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
	}
	resp, err := svc.RequestEnvironmentInfo(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_RestartAppServer() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.RestartAppServerInput{
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
	}
	resp, err := svc.RestartAppServer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_RetrieveEnvironmentInfo() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.RetrieveEnvironmentInfoInput{
		InfoType:        aws.String("EnvironmentInfoType"), // Required
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
	}
	resp, err := svc.RetrieveEnvironmentInfo(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_SwapEnvironmentCNAMEs() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.SwapEnvironmentCNAMEsInput{
		DestinationEnvironmentId:   aws.String("EnvironmentId"),
		DestinationEnvironmentName: aws.String("EnvironmentName"),
		SourceEnvironmentId:        aws.String("EnvironmentId"),
		SourceEnvironmentName:      aws.String("EnvironmentName"),
	}
	resp, err := svc.SwapEnvironmentCNAMEs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_TerminateEnvironment() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.TerminateEnvironmentInput{
		EnvironmentId:      aws.String("EnvironmentId"),
		EnvironmentName:    aws.String("EnvironmentName"),
		ForceTerminate:     aws.Bool(true),
		TerminateResources: aws.Bool(true),
	}
	resp, err := svc.TerminateEnvironment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_UpdateApplication() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.UpdateApplicationInput{
		ApplicationName: aws.String("ApplicationName"), // Required
		Description:     aws.String("Description"),
	}
	resp, err := svc.UpdateApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_UpdateApplicationResourceLifecycle() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.UpdateApplicationResourceLifecycleInput{
		ApplicationName: aws.String("ApplicationName"), // Required
		ResourceLifecycleConfig: &elasticbeanstalk.ApplicationResourceLifecycleConfig{ // Required
			ServiceRole: aws.String("String"),
			VersionLifecycleConfig: &elasticbeanstalk.ApplicationVersionLifecycleConfig{
				MaxAgeRule: &elasticbeanstalk.MaxAgeRule{
					Enabled:            aws.Bool(true), // Required
					DeleteSourceFromS3: aws.Bool(true),
					MaxAgeInDays:       aws.Int64(1),
				},
				MaxCountRule: &elasticbeanstalk.MaxCountRule{
					Enabled:            aws.Bool(true), // Required
					DeleteSourceFromS3: aws.Bool(true),
					MaxCount:           aws.Int64(1),
				},
			},
		},
	}
	resp, err := svc.UpdateApplicationResourceLifecycle(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_UpdateApplicationVersion() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.UpdateApplicationVersionInput{
		ApplicationName: aws.String("ApplicationName"), // Required
		VersionLabel:    aws.String("VersionLabel"),    // Required
		Description:     aws.String("Description"),
	}
	resp, err := svc.UpdateApplicationVersion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_UpdateConfigurationTemplate() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.UpdateConfigurationTemplateInput{
		ApplicationName: aws.String("ApplicationName"),           // Required
		TemplateName:    aws.String("ConfigurationTemplateName"), // Required
		Description:     aws.String("Description"),
		OptionSettings: []*elasticbeanstalk.ConfigurationOptionSetting{
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
				Value:        aws.String("ConfigurationOptionValue"),
			},
			// More values...
		},
		OptionsToRemove: []*elasticbeanstalk.OptionSpecification{
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateConfigurationTemplate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_UpdateEnvironment() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.UpdateEnvironmentInput{
		ApplicationName: aws.String("ApplicationName"),
		Description:     aws.String("Description"),
		EnvironmentId:   aws.String("EnvironmentId"),
		EnvironmentName: aws.String("EnvironmentName"),
		GroupName:       aws.String("GroupName"),
		OptionSettings: []*elasticbeanstalk.ConfigurationOptionSetting{
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
				Value:        aws.String("ConfigurationOptionValue"),
			},
			// More values...
		},
		OptionsToRemove: []*elasticbeanstalk.OptionSpecification{
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
			},
			// More values...
		},
		SolutionStackName: aws.String("SolutionStackName"),
		TemplateName:      aws.String("ConfigurationTemplateName"),
		Tier: &elasticbeanstalk.EnvironmentTier{
			Name:    aws.String("String"),
			Type:    aws.String("String"),
			Version: aws.String("String"),
		},
		VersionLabel: aws.String("VersionLabel"),
	}
	resp, err := svc.UpdateEnvironment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticBeanstalk_ValidateConfigurationSettings() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elasticbeanstalk.New(sess)

	params := &elasticbeanstalk.ValidateConfigurationSettingsInput{
		ApplicationName: aws.String("ApplicationName"), // Required
		OptionSettings: []*elasticbeanstalk.ConfigurationOptionSetting{ // Required
			{ // Required
				Namespace:    aws.String("OptionNamespace"),
				OptionName:   aws.String("ConfigurationOptionName"),
				ResourceName: aws.String("ResourceName"),
				Value:        aws.String("ConfigurationOptionValue"),
			},
			// More values...
		},
		EnvironmentName: aws.String("EnvironmentName"),
		TemplateName:    aws.String("ConfigurationTemplateName"),
	}
	resp, err := svc.ValidateConfigurationSettings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
