// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ecr provides a client for Amazon EC2 Container Registry.
package ecr

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchCheckLayerAvailability = "BatchCheckLayerAvailability"

// BatchCheckLayerAvailabilityRequest generates a "aws/request.Request" representing the
// client's request for the BatchCheckLayerAvailability operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchCheckLayerAvailability for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchCheckLayerAvailability method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchCheckLayerAvailabilityRequest method.
//    req, resp := client.BatchCheckLayerAvailabilityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailability
func (c *ECR) BatchCheckLayerAvailabilityRequest(input *BatchCheckLayerAvailabilityInput) (req *request.Request, output *BatchCheckLayerAvailabilityOutput) {
	op := &request.Operation{
		Name:       opBatchCheckLayerAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCheckLayerAvailabilityInput{}
	}

	output = &BatchCheckLayerAvailabilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCheckLayerAvailability API operation for Amazon EC2 Container Registry.
//
// Check the availability of multiple image layers in a specified registry and
// repository.
//
// This operation is used by the Amazon ECR proxy, and it is not intended for
// general use by customers for pulling and pushing images. In most cases, you
// should use the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation BatchCheckLayerAvailability for usage and error information.
//
// Returned Error Codes:
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailability
func (c *ECR) BatchCheckLayerAvailability(input *BatchCheckLayerAvailabilityInput) (*BatchCheckLayerAvailabilityOutput, error) {
	req, out := c.BatchCheckLayerAvailabilityRequest(input)
	err := req.Send()
	return out, err
}

const opBatchDeleteImage = "BatchDeleteImage"

// BatchDeleteImageRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchDeleteImage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchDeleteImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchDeleteImageRequest method.
//    req, resp := client.BatchDeleteImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchDeleteImage
func (c *ECR) BatchDeleteImageRequest(input *BatchDeleteImageInput) (req *request.Request, output *BatchDeleteImageOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteImageInput{}
	}

	output = &BatchDeleteImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteImage API operation for Amazon EC2 Container Registry.
//
// Deletes a list of specified images within a specified repository. Images
// are specified with either imageTag or imageDigest.
//
// You can remove a tag from an image by specifying the image's tag in your
// request. When you remove the last tag from an image, the image is deleted
// from your repository.
//
// You can completely delete an image (and all of its tags) by specifying the
// image's digest in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation BatchDeleteImage for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchDeleteImage
func (c *ECR) BatchDeleteImage(input *BatchDeleteImageInput) (*BatchDeleteImageOutput, error) {
	req, out := c.BatchDeleteImageRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetImage = "BatchGetImage"

// BatchGetImageRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetImage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetImageRequest method.
//    req, resp := client.BatchGetImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetImage
func (c *ECR) BatchGetImageRequest(input *BatchGetImageInput) (req *request.Request, output *BatchGetImageOutput) {
	op := &request.Operation{
		Name:       opBatchGetImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetImageInput{}
	}

	output = &BatchGetImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetImage API operation for Amazon EC2 Container Registry.
//
// Gets detailed information for specified images within a specified repository.
// Images are specified with either imageTag or imageDigest.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation BatchGetImage for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetImage
func (c *ECR) BatchGetImage(input *BatchGetImageInput) (*BatchGetImageOutput, error) {
	req, out := c.BatchGetImageRequest(input)
	err := req.Send()
	return out, err
}

const opCompleteLayerUpload = "CompleteLayerUpload"

// CompleteLayerUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteLayerUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CompleteLayerUpload for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CompleteLayerUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CompleteLayerUploadRequest method.
//    req, resp := client.CompleteLayerUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUpload
func (c *ECR) CompleteLayerUploadRequest(input *CompleteLayerUploadInput) (req *request.Request, output *CompleteLayerUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteLayerUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteLayerUploadInput{}
	}

	output = &CompleteLayerUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CompleteLayerUpload API operation for Amazon EC2 Container Registry.
//
// Inform Amazon ECR that the image layer upload for a specified registry, repository
// name, and upload ID, has completed. You can optionally provide a sha256 digest
// of the image layer for data validation purposes.
//
// This operation is used by the Amazon ECR proxy, and it is not intended for
// general use by customers for pulling and pushing images. In most cases, you
// should use the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation CompleteLayerUpload for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
//   * UploadNotFoundException
//   The upload could not be found, or the specified upload id is not valid for
//   this repository.
//
//   * InvalidLayerException
//   The layer digest calculation performed by Amazon ECR upon receipt of the
//   image layer does not match the digest specified.
//
//   * LayerPartTooSmallException
//   Layer parts must be at least 5 MiB in size.
//
//   * LayerAlreadyExistsException
//   The image layer already exists in the associated repository.
//
//   * EmptyUploadException
//   The specified layer upload does not contain any layer parts.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUpload
func (c *ECR) CompleteLayerUpload(input *CompleteLayerUploadInput) (*CompleteLayerUploadOutput, error) {
	req, out := c.CompleteLayerUploadRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRepository operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateRepository for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRepository method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRepositoryRequest method.
//    req, resp := client.CreateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepository
func (c *ECR) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	output = &CreateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRepository API operation for Amazon EC2 Container Registry.
//
// Creates an image repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation CreateRepository for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryAlreadyExistsException
//   The specified repository already exists in the specified registry.
//
//   * LimitExceededException
//   The operation did not succeed because it would have exceeded a service limit
//   for your account. For more information, see Amazon ECR Default Service Limits
//   (http://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html)
//   in the Amazon EC2 Container Registry User Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepository
func (c *ECR) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRepository = "DeleteRepository"

// DeleteRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepository operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRepository for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRepository method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRepositoryRequest method.
//    req, resp := client.DeleteRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepository
func (c *ECR) DeleteRepositoryRequest(input *DeleteRepositoryInput) (req *request.Request, output *DeleteRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryInput{}
	}

	output = &DeleteRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepository API operation for Amazon EC2 Container Registry.
//
// Deletes an existing image repository. If a repository contains images, you
// must use the force option to delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation DeleteRepository for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
//   * RepositoryNotEmptyException
//   The specified repository contains images. To delete a repository that contains
//   images, you must force the deletion with the force parameter.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepository
func (c *ECR) DeleteRepository(input *DeleteRepositoryInput) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRepositoryPolicy = "DeleteRepositoryPolicy"

// DeleteRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepositoryPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRepositoryPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRepositoryPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRepositoryPolicyRequest method.
//    req, resp := client.DeleteRepositoryPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicy
func (c *ECR) DeleteRepositoryPolicyRequest(input *DeleteRepositoryPolicyInput) (req *request.Request, output *DeleteRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryPolicyInput{}
	}

	output = &DeleteRepositoryPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepositoryPolicy API operation for Amazon EC2 Container Registry.
//
// Deletes the repository policy from a specified repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation DeleteRepositoryPolicy for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
//   * RepositoryPolicyNotFoundException
//   The specified repository and registry combination does not have an associated
//   repository policy.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicy
func (c *ECR) DeleteRepositoryPolicy(input *DeleteRepositoryPolicyInput) (*DeleteRepositoryPolicyOutput, error) {
	req, out := c.DeleteRepositoryPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImages operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeImages for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeImages method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeImagesRequest method.
//    req, resp := client.DescribeImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages
func (c *ECR) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	output = &DescribeImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImages API operation for Amazon EC2 Container Registry.
//
// Returns metadata about the images in a repository, including image size,
// image tags, and creation date.
//
// Beginning with Docker version 1.9, the Docker client compresses image layers
// before pushing them to a V2 Docker registry. The output of the docker images
// command shows the uncompressed image size, so it may return a larger image
// size than the image sizes returned by DescribeImages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation DescribeImages for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
//   * ImageNotFoundException
//   The image requested does not exist in the specified repository.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages
func (c *ECR) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeImagesPages iterates over the pages of a DescribeImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeImages operation.
//    pageNum := 0
//    err := client.DescribeImagesPages(params,
//        func(page *DescribeImagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ECR) DescribeImagesPages(input *DescribeImagesInput, fn func(p *DescribeImagesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeImagesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeImagesOutput), lastPage)
	})
}

const opDescribeRepositories = "DescribeRepositories"

// DescribeRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRepositories operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRepositories for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRepositories method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRepositoriesRequest method.
//    req, resp := client.DescribeRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories
func (c *ECR) DescribeRepositoriesRequest(input *DescribeRepositoriesInput) (req *request.Request, output *DescribeRepositoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRepositoriesInput{}
	}

	output = &DescribeRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRepositories API operation for Amazon EC2 Container Registry.
//
// Describes image repositories in a registry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation DescribeRepositories for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories
func (c *ECR) DescribeRepositories(input *DescribeRepositoriesInput) (*DescribeRepositoriesOutput, error) {
	req, out := c.DescribeRepositoriesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeRepositoriesPages iterates over the pages of a DescribeRepositories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRepositories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeRepositories operation.
//    pageNum := 0
//    err := client.DescribeRepositoriesPages(params,
//        func(page *DescribeRepositoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ECR) DescribeRepositoriesPages(input *DescribeRepositoriesInput, fn func(p *DescribeRepositoriesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeRepositoriesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeRepositoriesOutput), lastPage)
	})
}

const opGetAuthorizationToken = "GetAuthorizationToken"

// GetAuthorizationTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthorizationToken operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAuthorizationToken for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAuthorizationToken method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAuthorizationTokenRequest method.
//    req, resp := client.GetAuthorizationTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationToken
func (c *ECR) GetAuthorizationTokenRequest(input *GetAuthorizationTokenInput) (req *request.Request, output *GetAuthorizationTokenOutput) {
	op := &request.Operation{
		Name:       opGetAuthorizationToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAuthorizationTokenInput{}
	}

	output = &GetAuthorizationTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAuthorizationToken API operation for Amazon EC2 Container Registry.
//
// Retrieves a token that is valid for a specified registry for 12 hours. This
// command allows you to use the docker CLI to push and pull images with Amazon
// ECR. If you do not specify a registry, the default registry is assumed.
//
// The authorizationToken returned for each registry specified is a base64 encoded
// string that can be decoded and used in a docker login command to authenticate
// to a registry. The AWS CLI offers an aws ecr get-login command that simplifies
// the login process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation GetAuthorizationToken for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationToken
func (c *ECR) GetAuthorizationToken(input *GetAuthorizationTokenInput) (*GetAuthorizationTokenOutput, error) {
	req, out := c.GetAuthorizationTokenRequest(input)
	err := req.Send()
	return out, err
}

const opGetDownloadUrlForLayer = "GetDownloadUrlForLayer"

// GetDownloadUrlForLayerRequest generates a "aws/request.Request" representing the
// client's request for the GetDownloadUrlForLayer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDownloadUrlForLayer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDownloadUrlForLayer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDownloadUrlForLayerRequest method.
//    req, resp := client.GetDownloadUrlForLayerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayer
func (c *ECR) GetDownloadUrlForLayerRequest(input *GetDownloadUrlForLayerInput) (req *request.Request, output *GetDownloadUrlForLayerOutput) {
	op := &request.Operation{
		Name:       opGetDownloadUrlForLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDownloadUrlForLayerInput{}
	}

	output = &GetDownloadUrlForLayerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDownloadUrlForLayer API operation for Amazon EC2 Container Registry.
//
// Retrieves the pre-signed Amazon S3 download URL corresponding to an image
// layer. You can only get URLs for image layers that are referenced in an image.
//
// This operation is used by the Amazon ECR proxy, and it is not intended for
// general use by customers for pulling and pushing images. In most cases, you
// should use the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation GetDownloadUrlForLayer for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * LayersNotFoundException
//   The specified layers could not be found, or the specified layer is not valid
//   for this repository.
//
//   * LayerInaccessibleException
//   The specified layer is not available because it is not associated with an
//   image. Unassociated image layers may be cleaned up at any time.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayer
func (c *ECR) GetDownloadUrlForLayer(input *GetDownloadUrlForLayerInput) (*GetDownloadUrlForLayerOutput, error) {
	req, out := c.GetDownloadUrlForLayerRequest(input)
	err := req.Send()
	return out, err
}

const opGetRepositoryPolicy = "GetRepositoryPolicy"

// GetRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRepositoryPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRepositoryPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRepositoryPolicyRequest method.
//    req, resp := client.GetRepositoryPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicy
func (c *ECR) GetRepositoryPolicyRequest(input *GetRepositoryPolicyInput) (req *request.Request, output *GetRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryPolicyInput{}
	}

	output = &GetRepositoryPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositoryPolicy API operation for Amazon EC2 Container Registry.
//
// Retrieves the repository policy for a specified repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation GetRepositoryPolicy for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
//   * RepositoryPolicyNotFoundException
//   The specified repository and registry combination does not have an associated
//   repository policy.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicy
func (c *ECR) GetRepositoryPolicy(input *GetRepositoryPolicyInput) (*GetRepositoryPolicyOutput, error) {
	req, out := c.GetRepositoryPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opInitiateLayerUpload = "InitiateLayerUpload"

// InitiateLayerUploadRequest generates a "aws/request.Request" representing the
// client's request for the InitiateLayerUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See InitiateLayerUpload for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the InitiateLayerUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the InitiateLayerUploadRequest method.
//    req, resp := client.InitiateLayerUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/InitiateLayerUpload
func (c *ECR) InitiateLayerUploadRequest(input *InitiateLayerUploadInput) (req *request.Request, output *InitiateLayerUploadOutput) {
	op := &request.Operation{
		Name:       opInitiateLayerUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InitiateLayerUploadInput{}
	}

	output = &InitiateLayerUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InitiateLayerUpload API operation for Amazon EC2 Container Registry.
//
// Notify Amazon ECR that you intend to upload an image layer.
//
// This operation is used by the Amazon ECR proxy, and it is not intended for
// general use by customers for pulling and pushing images. In most cases, you
// should use the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation InitiateLayerUpload for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/InitiateLayerUpload
func (c *ECR) InitiateLayerUpload(input *InitiateLayerUploadInput) (*InitiateLayerUploadOutput, error) {
	req, out := c.InitiateLayerUploadRequest(input)
	err := req.Send()
	return out, err
}

const opListImages = "ListImages"

// ListImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListImages operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListImages for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListImages method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListImagesRequest method.
//    req, resp := client.ListImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages
func (c *ECR) ListImagesRequest(input *ListImagesInput) (req *request.Request, output *ListImagesOutput) {
	op := &request.Operation{
		Name:       opListImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImagesInput{}
	}

	output = &ListImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImages API operation for Amazon EC2 Container Registry.
//
// Lists all the image IDs for a given repository.
//
// You can filter images based on whether or not they are tagged by setting
// the tagStatus parameter to TAGGED or UNTAGGED. For example, you can filter
// your results to return only UNTAGGED images and then pipe that result to
// a BatchDeleteImage operation to delete them. Or, you can filter your results
// to return only TAGGED images to list all of the tags in your repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation ListImages for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages
func (c *ECR) ListImages(input *ListImagesInput) (*ListImagesOutput, error) {
	req, out := c.ListImagesRequest(input)
	err := req.Send()
	return out, err
}

// ListImagesPages iterates over the pages of a ListImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListImages operation.
//    pageNum := 0
//    err := client.ListImagesPages(params,
//        func(page *ListImagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ECR) ListImagesPages(input *ListImagesInput, fn func(p *ListImagesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListImagesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListImagesOutput), lastPage)
	})
}

const opPutImage = "PutImage"

// PutImageRequest generates a "aws/request.Request" representing the
// client's request for the PutImage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutImage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutImage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutImageRequest method.
//    req, resp := client.PutImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImage
func (c *ECR) PutImageRequest(input *PutImageInput) (req *request.Request, output *PutImageOutput) {
	op := &request.Operation{
		Name:       opPutImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutImageInput{}
	}

	output = &PutImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutImage API operation for Amazon EC2 Container Registry.
//
// Creates or updates the image manifest and tags associated with an image.
//
// This operation is used by the Amazon ECR proxy, and it is not intended for
// general use by customers for pulling and pushing images. In most cases, you
// should use the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation PutImage for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
//   * ImageAlreadyExistsException
//   The specified image has already been pushed, and there are no changes to
//   the manifest or image tag since the last push.
//
//   * LayersNotFoundException
//   The specified layers could not be found, or the specified layer is not valid
//   for this repository.
//
//   * LimitExceededException
//   The operation did not succeed because it would have exceeded a service limit
//   for your account. For more information, see Amazon ECR Default Service Limits
//   (http://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html)
//   in the Amazon EC2 Container Registry User Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImage
func (c *ECR) PutImage(input *PutImageInput) (*PutImageOutput, error) {
	req, out := c.PutImageRequest(input)
	err := req.Send()
	return out, err
}

const opSetRepositoryPolicy = "SetRepositoryPolicy"

// SetRepositoryPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SetRepositoryPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetRepositoryPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetRepositoryPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetRepositoryPolicyRequest method.
//    req, resp := client.SetRepositoryPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicy
func (c *ECR) SetRepositoryPolicyRequest(input *SetRepositoryPolicyInput) (req *request.Request, output *SetRepositoryPolicyOutput) {
	op := &request.Operation{
		Name:       opSetRepositoryPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetRepositoryPolicyInput{}
	}

	output = &SetRepositoryPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetRepositoryPolicy API operation for Amazon EC2 Container Registry.
//
// Applies a repository policy on a specified repository to control access permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation SetRepositoryPolicy for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicy
func (c *ECR) SetRepositoryPolicy(input *SetRepositoryPolicyInput) (*SetRepositoryPolicyOutput, error) {
	req, out := c.SetRepositoryPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opUploadLayerPart = "UploadLayerPart"

// UploadLayerPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadLayerPart operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UploadLayerPart for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UploadLayerPart method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UploadLayerPartRequest method.
//    req, resp := client.UploadLayerPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UploadLayerPart
func (c *ECR) UploadLayerPartRequest(input *UploadLayerPartInput) (req *request.Request, output *UploadLayerPartOutput) {
	op := &request.Operation{
		Name:       opUploadLayerPart,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadLayerPartInput{}
	}

	output = &UploadLayerPartOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadLayerPart API operation for Amazon EC2 Container Registry.
//
// Uploads an image layer part to Amazon ECR.
//
// This operation is used by the Amazon ECR proxy, and it is not intended for
// general use by customers for pulling and pushing images. In most cases, you
// should use the docker CLI to pull, tag, and push images.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EC2 Container Registry's
// API operation UploadLayerPart for usage and error information.
//
// Returned Error Codes:
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * InvalidLayerPartException
//   The layer part size is not valid, or the first byte specified is not consecutive
//   to the last byte of a previous layer part upload.
//
//   * RepositoryNotFoundException
//   The specified repository could not be found. Check the spelling of the specified
//   repository and ensure that you are performing operations on the correct registry.
//
//   * UploadNotFoundException
//   The upload could not be found, or the specified upload id is not valid for
//   this repository.
//
//   * LimitExceededException
//   The operation did not succeed because it would have exceeded a service limit
//   for your account. For more information, see Amazon ECR Default Service Limits
//   (http://docs.aws.amazon.com/AmazonECR/latest/userguide/service_limits.html)
//   in the Amazon EC2 Container Registry User Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UploadLayerPart
func (c *ECR) UploadLayerPart(input *UploadLayerPartInput) (*UploadLayerPartOutput, error) {
	req, out := c.UploadLayerPartRequest(input)
	err := req.Send()
	return out, err
}

// An object representing authorization data for an Amazon ECR registry.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/AuthorizationData
type AuthorizationData struct {
	_ struct{} `type:"structure"`

	// A base64-encoded string that contains authorization data for the specified
	// Amazon ECR registry. When the string is decoded, it is presented in the format
	// user:password for private registry authentication using docker login.
	AuthorizationToken *string `locationName:"authorizationToken" type:"string"`

	// The Unix time in seconds and milliseconds when the authorization token expires.
	// Authorization tokens are valid for 12 hours.
	ExpiresAt *time.Time `locationName:"expiresAt" type:"timestamp" timestampFormat:"unix"`

	// The registry URL to use for this authorization token in a docker login command.
	// The Amazon ECR registry URL format is https://aws_account_id.dkr.ecr.region.amazonaws.com.
	// For example, https://012345678910.dkr.ecr.us-east-1.amazonaws.com..
	ProxyEndpoint *string `locationName:"proxyEndpoint" type:"string"`
}

// String returns the string representation
func (s AuthorizationData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizationData) GoString() string {
	return s.String()
}

// SetAuthorizationToken sets the AuthorizationToken field's value.
func (s *AuthorizationData) SetAuthorizationToken(v string) *AuthorizationData {
	s.AuthorizationToken = &v
	return s
}

// SetExpiresAt sets the ExpiresAt field's value.
func (s *AuthorizationData) SetExpiresAt(v time.Time) *AuthorizationData {
	s.ExpiresAt = &v
	return s
}

// SetProxyEndpoint sets the ProxyEndpoint field's value.
func (s *AuthorizationData) SetProxyEndpoint(v string) *AuthorizationData {
	s.ProxyEndpoint = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailabilityRequest
type BatchCheckLayerAvailabilityInput struct {
	_ struct{} `type:"structure"`

	// The digests of the image layers to check.
	//
	// LayerDigests is a required field
	LayerDigests []*string `locationName:"layerDigests" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry that contains the image layers
	// to check. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the image layers to check.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchCheckLayerAvailabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCheckLayerAvailabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCheckLayerAvailabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCheckLayerAvailabilityInput"}
	if s.LayerDigests == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerDigests"))
	}
	if s.LayerDigests != nil && len(s.LayerDigests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerDigests", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerDigests sets the LayerDigests field's value.
func (s *BatchCheckLayerAvailabilityInput) SetLayerDigests(v []*string) *BatchCheckLayerAvailabilityInput {
	s.LayerDigests = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *BatchCheckLayerAvailabilityInput) SetRegistryId(v string) *BatchCheckLayerAvailabilityInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *BatchCheckLayerAvailabilityInput) SetRepositoryName(v string) *BatchCheckLayerAvailabilityInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailabilityResponse
type BatchCheckLayerAvailabilityOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*LayerFailure `locationName:"failures" type:"list"`

	// A list of image layer objects corresponding to the image layer references
	// in the request.
	Layers []*Layer `locationName:"layers" type:"list"`
}

// String returns the string representation
func (s BatchCheckLayerAvailabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCheckLayerAvailabilityOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchCheckLayerAvailabilityOutput) SetFailures(v []*LayerFailure) *BatchCheckLayerAvailabilityOutput {
	s.Failures = v
	return s
}

// SetLayers sets the Layers field's value.
func (s *BatchCheckLayerAvailabilityOutput) SetLayers(v []*Layer) *BatchCheckLayerAvailabilityOutput {
	s.Layers = v
	return s
}

// Deletes specified images within a specified repository. Images are specified
// with either the imageTag or imageDigest.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchDeleteImageRequest
type BatchDeleteImageInput struct {
	_ struct{} `type:"structure"`

	// A list of image ID references that correspond to images to delete. The format
	// of the imageIds reference is imageTag=tag or imageDigest=digest.
	//
	// ImageIds is a required field
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry that contains the image to
	// delete. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository that contains the image to delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDeleteImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteImageInput"}
	if s.ImageIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageIds"))
	}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageIds sets the ImageIds field's value.
func (s *BatchDeleteImageInput) SetImageIds(v []*ImageIdentifier) *BatchDeleteImageInput {
	s.ImageIds = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *BatchDeleteImageInput) SetRegistryId(v string) *BatchDeleteImageInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *BatchDeleteImageInput) SetRepositoryName(v string) *BatchDeleteImageInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchDeleteImageResponse
type BatchDeleteImageOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*ImageFailure `locationName:"failures" type:"list"`

	// The image IDs of the deleted images.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchDeleteImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteImageOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchDeleteImageOutput) SetFailures(v []*ImageFailure) *BatchDeleteImageOutput {
	s.Failures = v
	return s
}

// SetImageIds sets the ImageIds field's value.
func (s *BatchDeleteImageOutput) SetImageIds(v []*ImageIdentifier) *BatchDeleteImageOutput {
	s.ImageIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetImageRequest
type BatchGetImageInput struct {
	_ struct{} `type:"structure"`

	// The accepted media types for the request.
	//
	// Valid values: application/vnd.docker.distribution.manifest.v1+json | application/vnd.docker.distribution.manifest.v2+json
	// | application/vnd.oci.image.manifest.v1+json
	AcceptedMediaTypes []*string `locationName:"acceptedMediaTypes" min:"1" type:"list"`

	// A list of image ID references that correspond to images to describe. The
	// format of the imageIds reference is imageTag=tag or imageDigest=digest.
	//
	// ImageIds is a required field
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry that contains the images
	// to describe. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository that contains the images to describe.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchGetImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetImageInput"}
	if s.AcceptedMediaTypes != nil && len(s.AcceptedMediaTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AcceptedMediaTypes", 1))
	}
	if s.ImageIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageIds"))
	}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptedMediaTypes sets the AcceptedMediaTypes field's value.
func (s *BatchGetImageInput) SetAcceptedMediaTypes(v []*string) *BatchGetImageInput {
	s.AcceptedMediaTypes = v
	return s
}

// SetImageIds sets the ImageIds field's value.
func (s *BatchGetImageInput) SetImageIds(v []*ImageIdentifier) *BatchGetImageInput {
	s.ImageIds = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *BatchGetImageInput) SetRegistryId(v string) *BatchGetImageInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *BatchGetImageInput) SetRepositoryName(v string) *BatchGetImageInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetImageResponse
type BatchGetImageOutput struct {
	_ struct{} `type:"structure"`

	// Any failures associated with the call.
	Failures []*ImageFailure `locationName:"failures" type:"list"`

	// A list of image objects corresponding to the image references in the request.
	Images []*Image `locationName:"images" type:"list"`
}

// String returns the string representation
func (s BatchGetImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetImageOutput) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *BatchGetImageOutput) SetFailures(v []*ImageFailure) *BatchGetImageOutput {
	s.Failures = v
	return s
}

// SetImages sets the Images field's value.
func (s *BatchGetImageOutput) SetImages(v []*Image) *BatchGetImageOutput {
	s.Images = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUploadRequest
type CompleteLayerUploadInput struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image layer.
	//
	// LayerDigests is a required field
	LayerDigests []*string `locationName:"layerDigests" min:"1" type:"list" required:"true"`

	// The AWS account ID associated with the registry to which to upload layers.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to associate with the image layer.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`

	// The upload ID from a previous InitiateLayerUpload operation to associate
	// with the image layer.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteLayerUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteLayerUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteLayerUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteLayerUploadInput"}
	if s.LayerDigests == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerDigests"))
	}
	if s.LayerDigests != nil && len(s.LayerDigests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerDigests", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerDigests sets the LayerDigests field's value.
func (s *CompleteLayerUploadInput) SetLayerDigests(v []*string) *CompleteLayerUploadInput {
	s.LayerDigests = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *CompleteLayerUploadInput) SetRegistryId(v string) *CompleteLayerUploadInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CompleteLayerUploadInput) SetRepositoryName(v string) *CompleteLayerUploadInput {
	s.RepositoryName = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteLayerUploadInput) SetUploadId(v string) *CompleteLayerUploadInput {
	s.UploadId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUploadResponse
type CompleteLayerUploadOutput struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image layer.
	LayerDigest *string `locationName:"layerDigest" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The upload ID associated with the layer.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation
func (s CompleteLayerUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteLayerUploadOutput) GoString() string {
	return s.String()
}

// SetLayerDigest sets the LayerDigest field's value.
func (s *CompleteLayerUploadOutput) SetLayerDigest(v string) *CompleteLayerUploadOutput {
	s.LayerDigest = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *CompleteLayerUploadOutput) SetRegistryId(v string) *CompleteLayerUploadOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CompleteLayerUploadOutput) SetRepositoryName(v string) *CompleteLayerUploadOutput {
	s.RepositoryName = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteLayerUploadOutput) SetUploadId(v string) *CompleteLayerUploadOutput {
	s.UploadId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepositoryRequest
type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name to use for the repository. The repository name may be specified
	// on its own (such as nginx-web-app) or it can be prepended with a namespace
	// to group the repository into a category (such as project-a/nginx-web-app).
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateRepositoryInput) SetRepositoryName(v string) *CreateRepositoryInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepositoryResponse
type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The repository that was created.
	Repository *Repository `locationName:"repository" type:"structure"`
}

// String returns the string representation
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *CreateRepositoryOutput) SetRepository(v *Repository) *CreateRepositoryOutput {
	s.Repository = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryRequest
type DeleteRepositoryInput struct {
	_ struct{} `type:"structure"`

	// Force the deletion of the repository if it contains images.
	Force *bool `locationName:"force" type:"boolean"`

	// The AWS account ID associated with the registry that contains the repository
	// to delete. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *DeleteRepositoryInput) SetForce(v bool) *DeleteRepositoryInput {
	s.Force = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DeleteRepositoryInput) SetRegistryId(v string) *DeleteRepositoryInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteRepositoryInput) SetRepositoryName(v string) *DeleteRepositoryInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryResponse
type DeleteRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The repository that was deleted.
	Repository *Repository `locationName:"repository" type:"structure"`
}

// String returns the string representation
func (s DeleteRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *DeleteRepositoryOutput) SetRepository(v *Repository) *DeleteRepositoryOutput {
	s.Repository = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicyRequest
type DeleteRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that contains the repository
	// policy to delete. If you do not specify a registry, the default registry
	// is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the repository policy
	// to delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryPolicyInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryId sets the RegistryId field's value.
func (s *DeleteRepositoryPolicyInput) SetRegistryId(v string) *DeleteRepositoryPolicyInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteRepositoryPolicyInput) SetRepositoryName(v string) *DeleteRepositoryPolicyInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicyResponse
type DeleteRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy that was deleted from the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s DeleteRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyText sets the PolicyText field's value.
func (s *DeleteRepositoryPolicyOutput) SetPolicyText(v string) *DeleteRepositoryPolicyOutput {
	s.PolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DeleteRepositoryPolicyOutput) SetRegistryId(v string) *DeleteRepositoryPolicyOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteRepositoryPolicyOutput) SetRepositoryName(v string) *DeleteRepositoryPolicyOutput {
	s.RepositoryName = &v
	return s
}

// An object representing a filter on a DescribeImages operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImagesFilter
type DescribeImagesFilter struct {
	_ struct{} `type:"structure"`

	// The tag status with which to filter your DescribeImages results. You can
	// filter results based on whether they are TAGGED or UNTAGGED.
	TagStatus *string `locationName:"tagStatus" type:"string" enum:"TagStatus"`
}

// String returns the string representation
func (s DescribeImagesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesFilter) GoString() string {
	return s.String()
}

// SetTagStatus sets the TagStatus field's value.
func (s *DescribeImagesFilter) SetTagStatus(v string) *DescribeImagesFilter {
	s.TagStatus = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImagesRequest
type DescribeImagesInput struct {
	_ struct{} `type:"structure"`

	// The filter key and value with which to filter your DescribeImages results.
	Filter *DescribeImagesFilter `locationName:"filter" type:"structure"`

	// The list of image IDs for the requested repository.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list"`

	// The maximum number of repository results returned by DescribeImages in paginated
	// output. When this parameter is used, DescribeImages only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another DescribeImages
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then DescribeImages returns up to 100
	// results and a nextToken value, if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeImages request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value. This value is null when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The AWS account ID associated with the registry that contains the repository
	// in which to describe images. If you do not specify a registry, the default
	// registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// A list of repositories to describe. If this parameter is omitted, then all
	// repositories in a registry are described.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImagesInput"}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *DescribeImagesInput) SetFilter(v *DescribeImagesFilter) *DescribeImagesInput {
	s.Filter = v
	return s
}

// SetImageIds sets the ImageIds field's value.
func (s *DescribeImagesInput) SetImageIds(v []*ImageIdentifier) *DescribeImagesInput {
	s.ImageIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImagesInput) SetMaxResults(v int64) *DescribeImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImagesInput) SetNextToken(v string) *DescribeImagesInput {
	s.NextToken = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DescribeImagesInput) SetRegistryId(v string) *DescribeImagesInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DescribeImagesInput) SetRepositoryName(v string) *DescribeImagesInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImagesResponse
type DescribeImagesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ImageDetail objects that contain data about the image.
	ImageDetails []*ImageDetail `locationName:"imageDetails" type:"list"`

	// The nextToken value to include in a future DescribeImages request. When the
	// results of a DescribeImages request exceed maxResults, this value can be
	// used to retrieve the next page of results. This value is null when there
	// are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesOutput) GoString() string {
	return s.String()
}

// SetImageDetails sets the ImageDetails field's value.
func (s *DescribeImagesOutput) SetImageDetails(v []*ImageDetail) *DescribeImagesOutput {
	s.ImageDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImagesOutput) SetNextToken(v string) *DescribeImagesOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositoriesRequest
type DescribeRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repository results returned by DescribeRepositories
	// in paginated output. When this parameter is used, DescribeRepositories only
	// returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another DescribeRepositories request with the returned nextToken value. This
	// value can be between 1 and 100. If this parameter is not used, then DescribeRepositories
	// returns up to 100 results and a nextToken value, if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeRepositories
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The AWS account ID associated with the registry that contains the repositories
	// to be described. If you do not specify a registry, the default registry is
	// assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// A list of repositories to describe. If this parameter is omitted, then all
	// repositories in a registry are described.
	RepositoryNames []*string `locationName:"repositoryNames" min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRepositoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRepositoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRepositoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RepositoryNames != nil && len(s.RepositoryNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeRepositoriesInput) SetMaxResults(v int64) *DescribeRepositoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRepositoriesInput) SetNextToken(v string) *DescribeRepositoriesInput {
	s.NextToken = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *DescribeRepositoriesInput) SetRegistryId(v string) *DescribeRepositoriesInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryNames sets the RepositoryNames field's value.
func (s *DescribeRepositoriesInput) SetRepositoryNames(v []*string) *DescribeRepositoriesInput {
	s.RepositoryNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositoriesResponse
type DescribeRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future DescribeRepositories request.
	// When the results of a DescribeRepositories request exceed maxResults, this
	// value can be used to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of repository objects corresponding to valid repositories.
	Repositories []*Repository `locationName:"repositories" type:"list"`
}

// String returns the string representation
func (s DescribeRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRepositoriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRepositoriesOutput) SetNextToken(v string) *DescribeRepositoriesOutput {
	s.NextToken = &v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *DescribeRepositoriesOutput) SetRepositories(v []*Repository) *DescribeRepositoriesOutput {
	s.Repositories = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationTokenRequest
type GetAuthorizationTokenInput struct {
	_ struct{} `type:"structure"`

	// A list of AWS account IDs that are associated with the registries for which
	// to get authorization tokens. If you do not specify a registry, the default
	// registry is assumed.
	RegistryIds []*string `locationName:"registryIds" min:"1" type:"list"`
}

// String returns the string representation
func (s GetAuthorizationTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAuthorizationTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizationTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAuthorizationTokenInput"}
	if s.RegistryIds != nil && len(s.RegistryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegistryIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryIds sets the RegistryIds field's value.
func (s *GetAuthorizationTokenInput) SetRegistryIds(v []*string) *GetAuthorizationTokenInput {
	s.RegistryIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationTokenResponse
type GetAuthorizationTokenOutput struct {
	_ struct{} `type:"structure"`

	// A list of authorization token data objects that correspond to the registryIds
	// values in the request.
	AuthorizationData []*AuthorizationData `locationName:"authorizationData" type:"list"`
}

// String returns the string representation
func (s GetAuthorizationTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAuthorizationTokenOutput) GoString() string {
	return s.String()
}

// SetAuthorizationData sets the AuthorizationData field's value.
func (s *GetAuthorizationTokenOutput) SetAuthorizationData(v []*AuthorizationData) *GetAuthorizationTokenOutput {
	s.AuthorizationData = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayerRequest
type GetDownloadUrlForLayerInput struct {
	_ struct{} `type:"structure"`

	// The digest of the image layer to download.
	//
	// LayerDigest is a required field
	LayerDigest *string `locationName:"layerDigest" type:"string" required:"true"`

	// The AWS account ID associated with the registry that contains the image layer
	// to download. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that is associated with the image layer to download.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDownloadUrlForLayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDownloadUrlForLayerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDownloadUrlForLayerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDownloadUrlForLayerInput"}
	if s.LayerDigest == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerDigest"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerDigest sets the LayerDigest field's value.
func (s *GetDownloadUrlForLayerInput) SetLayerDigest(v string) *GetDownloadUrlForLayerInput {
	s.LayerDigest = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *GetDownloadUrlForLayerInput) SetRegistryId(v string) *GetDownloadUrlForLayerInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetDownloadUrlForLayerInput) SetRepositoryName(v string) *GetDownloadUrlForLayerInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayerResponse
type GetDownloadUrlForLayerOutput struct {
	_ struct{} `type:"structure"`

	// The pre-signed Amazon S3 download URL for the requested layer.
	DownloadUrl *string `locationName:"downloadUrl" type:"string"`

	// The digest of the image layer to download.
	LayerDigest *string `locationName:"layerDigest" type:"string"`
}

// String returns the string representation
func (s GetDownloadUrlForLayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDownloadUrlForLayerOutput) GoString() string {
	return s.String()
}

// SetDownloadUrl sets the DownloadUrl field's value.
func (s *GetDownloadUrlForLayerOutput) SetDownloadUrl(v string) *GetDownloadUrlForLayerOutput {
	s.DownloadUrl = &v
	return s
}

// SetLayerDigest sets the LayerDigest field's value.
func (s *GetDownloadUrlForLayerOutput) SetLayerDigest(v string) *GetDownloadUrlForLayerOutput {
	s.LayerDigest = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicyRequest
type GetRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that contains the repository.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository whose policy you want to retrieve.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryPolicyInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryId sets the RegistryId field's value.
func (s *GetRepositoryPolicyInput) SetRegistryId(v string) *GetRepositoryPolicyInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryPolicyInput) SetRepositoryName(v string) *GetRepositoryPolicyInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicyResponse
type GetRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy text associated with the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s GetRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyText sets the PolicyText field's value.
func (s *GetRepositoryPolicyOutput) SetPolicyText(v string) *GetRepositoryPolicyOutput {
	s.PolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *GetRepositoryPolicyOutput) SetRegistryId(v string) *GetRepositoryPolicyOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryPolicyOutput) SetRepositoryName(v string) *GetRepositoryPolicyOutput {
	s.RepositoryName = &v
	return s
}

// An object representing an Amazon ECR image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/Image
type Image struct {
	_ struct{} `type:"structure"`

	// An object containing the image tag and image digest associated with an image.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`

	// The image manifest associated with the image.
	ImageManifest *string `locationName:"imageManifest" type:"string"`

	// The AWS account ID associated with the registry containing the image.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository associated with the image.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Image) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *Image) SetImageId(v *ImageIdentifier) *Image {
	s.ImageId = v
	return s
}

// SetImageManifest sets the ImageManifest field's value.
func (s *Image) SetImageManifest(v string) *Image {
	s.ImageManifest = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *Image) SetRegistryId(v string) *Image {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *Image) SetRepositoryName(v string) *Image {
	s.RepositoryName = &v
	return s
}

// An object that describes an image returned by a DescribeImages operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ImageDetail
type ImageDetail struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The date and time, expressed in standard JavaScript date format, at which
	// the current image was pushed to the repository.
	ImagePushedAt *time.Time `locationName:"imagePushedAt" type:"timestamp" timestampFormat:"unix"`

	// The size, in bytes, of the image in the repository.
	//
	// Beginning with Docker version 1.9, the Docker client compresses image layers
	// before pushing them to a V2 Docker registry. The output of the docker images
	// command shows the uncompressed image size, so it may return a larger image
	// size than the image sizes returned by DescribeImages.
	ImageSizeInBytes *int64 `locationName:"imageSizeInBytes" type:"long"`

	// The list of tags associated with this image.
	ImageTags []*string `locationName:"imageTags" type:"list"`

	// The AWS account ID associated with the registry to which this image belongs.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to which this image belongs.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s ImageDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageDetail) GoString() string {
	return s.String()
}

// SetImageDigest sets the ImageDigest field's value.
func (s *ImageDetail) SetImageDigest(v string) *ImageDetail {
	s.ImageDigest = &v
	return s
}

// SetImagePushedAt sets the ImagePushedAt field's value.
func (s *ImageDetail) SetImagePushedAt(v time.Time) *ImageDetail {
	s.ImagePushedAt = &v
	return s
}

// SetImageSizeInBytes sets the ImageSizeInBytes field's value.
func (s *ImageDetail) SetImageSizeInBytes(v int64) *ImageDetail {
	s.ImageSizeInBytes = &v
	return s
}

// SetImageTags sets the ImageTags field's value.
func (s *ImageDetail) SetImageTags(v []*string) *ImageDetail {
	s.ImageTags = v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *ImageDetail) SetRegistryId(v string) *ImageDetail {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *ImageDetail) SetRepositoryName(v string) *ImageDetail {
	s.RepositoryName = &v
	return s
}

// An object representing an Amazon ECR image failure.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ImageFailure
type ImageFailure struct {
	_ struct{} `type:"structure"`

	// The code associated with the failure.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"ImageFailureCode"`

	// The reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The image ID associated with the failure.
	ImageId *ImageIdentifier `locationName:"imageId" type:"structure"`
}

// String returns the string representation
func (s ImageFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *ImageFailure) SetFailureCode(v string) *ImageFailure {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *ImageFailure) SetFailureReason(v string) *ImageFailure {
	s.FailureReason = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *ImageFailure) SetImageId(v *ImageIdentifier) *ImageFailure {
	s.ImageId = v
	return s
}

// An object with identifying information for an Amazon ECR image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ImageIdentifier
type ImageIdentifier struct {
	_ struct{} `type:"structure"`

	// The sha256 digest of the image manifest.
	ImageDigest *string `locationName:"imageDigest" type:"string"`

	// The tag used for the image.
	ImageTag *string `locationName:"imageTag" type:"string"`
}

// String returns the string representation
func (s ImageIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageIdentifier) GoString() string {
	return s.String()
}

// SetImageDigest sets the ImageDigest field's value.
func (s *ImageIdentifier) SetImageDigest(v string) *ImageIdentifier {
	s.ImageDigest = &v
	return s
}

// SetImageTag sets the ImageTag field's value.
func (s *ImageIdentifier) SetImageTag(v string) *ImageIdentifier {
	s.ImageTag = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/InitiateLayerUploadRequest
type InitiateLayerUploadInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the registry that you intend to upload
	// layers to. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that you intend to upload layers to.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateLayerUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateLayerUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateLayerUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateLayerUploadInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegistryId sets the RegistryId field's value.
func (s *InitiateLayerUploadInput) SetRegistryId(v string) *InitiateLayerUploadInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *InitiateLayerUploadInput) SetRepositoryName(v string) *InitiateLayerUploadInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/InitiateLayerUploadResponse
type InitiateLayerUploadOutput struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, that Amazon ECR expects future layer part uploads to
	// be.
	PartSize *int64 `locationName:"partSize" type:"long"`

	// The upload ID for the layer upload. This parameter is passed to further UploadLayerPart
	// and CompleteLayerUpload operations.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation
func (s InitiateLayerUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateLayerUploadOutput) GoString() string {
	return s.String()
}

// SetPartSize sets the PartSize field's value.
func (s *InitiateLayerUploadOutput) SetPartSize(v int64) *InitiateLayerUploadOutput {
	s.PartSize = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *InitiateLayerUploadOutput) SetUploadId(v string) *InitiateLayerUploadOutput {
	s.UploadId = &v
	return s
}

// An object representing an Amazon ECR image layer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/Layer
type Layer struct {
	_ struct{} `type:"structure"`

	// The availability status of the image layer.
	LayerAvailability *string `locationName:"layerAvailability" type:"string" enum:"LayerAvailability"`

	// The sha256 digest of the image layer.
	LayerDigest *string `locationName:"layerDigest" type:"string"`

	// The size, in bytes, of the image layer.
	LayerSize *int64 `locationName:"layerSize" type:"long"`

	// The media type of the layer, such as application/vnd.docker.image.rootfs.diff.tar.gzip
	// or application/vnd.oci.image.layer.v1.tar+gzip.
	MediaType *string `locationName:"mediaType" type:"string"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Layer) GoString() string {
	return s.String()
}

// SetLayerAvailability sets the LayerAvailability field's value.
func (s *Layer) SetLayerAvailability(v string) *Layer {
	s.LayerAvailability = &v
	return s
}

// SetLayerDigest sets the LayerDigest field's value.
func (s *Layer) SetLayerDigest(v string) *Layer {
	s.LayerDigest = &v
	return s
}

// SetLayerSize sets the LayerSize field's value.
func (s *Layer) SetLayerSize(v int64) *Layer {
	s.LayerSize = &v
	return s
}

// SetMediaType sets the MediaType field's value.
func (s *Layer) SetMediaType(v string) *Layer {
	s.MediaType = &v
	return s
}

// An object representing an Amazon ECR image layer failure.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/LayerFailure
type LayerFailure struct {
	_ struct{} `type:"structure"`

	// The failure code associated with the failure.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"LayerFailureCode"`

	// The reason for the failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The layer digest associated with the failure.
	LayerDigest *string `locationName:"layerDigest" type:"string"`
}

// String returns the string representation
func (s LayerFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayerFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *LayerFailure) SetFailureCode(v string) *LayerFailure {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *LayerFailure) SetFailureReason(v string) *LayerFailure {
	s.FailureReason = &v
	return s
}

// SetLayerDigest sets the LayerDigest field's value.
func (s *LayerFailure) SetLayerDigest(v string) *LayerFailure {
	s.LayerDigest = &v
	return s
}

// An object representing a filter on a ListImages operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImagesFilter
type ListImagesFilter struct {
	_ struct{} `type:"structure"`

	// The tag status with which to filter your ListImages results. You can filter
	// results based on whether they are TAGGED or UNTAGGED.
	TagStatus *string `locationName:"tagStatus" type:"string" enum:"TagStatus"`
}

// String returns the string representation
func (s ListImagesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImagesFilter) GoString() string {
	return s.String()
}

// SetTagStatus sets the TagStatus field's value.
func (s *ListImagesFilter) SetTagStatus(v string) *ListImagesFilter {
	s.TagStatus = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImagesRequest
type ListImagesInput struct {
	_ struct{} `type:"structure"`

	// The filter key and value with which to filter your ListImages results.
	Filter *ListImagesFilter `locationName:"filter" type:"structure"`

	// The maximum number of image results returned by ListImages in paginated output.
	// When this parameter is used, ListImages only returns maxResults results in
	// a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListImages request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// this parameter is not used, then ListImages returns up to 100 results and
	// a nextToken value, if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListImages request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The AWS account ID associated with the registry that contains the repository
	// to list images in. If you do not specify a registry, the default registry
	// is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository whose image IDs are to be listed.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListImagesInput) SetFilter(v *ListImagesFilter) *ListImagesInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImagesInput) SetMaxResults(v int64) *ListImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagesInput) SetNextToken(v string) *ListImagesInput {
	s.NextToken = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *ListImagesInput) SetRegistryId(v string) *ListImagesInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *ListImagesInput) SetRepositoryName(v string) *ListImagesInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImagesResponse
type ListImagesOutput struct {
	_ struct{} `type:"structure"`

	// The list of image IDs for the requested repository.
	ImageIds []*ImageIdentifier `locationName:"imageIds" min:"1" type:"list"`

	// The nextToken value to include in a future ListImages request. When the results
	// of a ListImages request exceed maxResults, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImagesOutput) GoString() string {
	return s.String()
}

// SetImageIds sets the ImageIds field's value.
func (s *ListImagesOutput) SetImageIds(v []*ImageIdentifier) *ListImagesOutput {
	s.ImageIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImagesOutput) SetNextToken(v string) *ListImagesOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageRequest
type PutImageInput struct {
	_ struct{} `type:"structure"`

	// The image manifest corresponding to the image to be uploaded.
	//
	// ImageManifest is a required field
	ImageManifest *string `locationName:"imageManifest" type:"string" required:"true"`

	// The tag to associate with the image. This parameter is required for images
	// that use the Docker Image Manifest V2 Schema 2 or OCI formats.
	ImageTag *string `locationName:"imageTag" type:"string"`

	// The AWS account ID associated with the registry that contains the repository
	// in which to put the image. If you do not specify a registry, the default
	// registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository in which to put the image.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s PutImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutImageInput"}
	if s.ImageManifest == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageManifest"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageManifest sets the ImageManifest field's value.
func (s *PutImageInput) SetImageManifest(v string) *PutImageInput {
	s.ImageManifest = &v
	return s
}

// SetImageTag sets the ImageTag field's value.
func (s *PutImageInput) SetImageTag(v string) *PutImageInput {
	s.ImageTag = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *PutImageInput) SetRegistryId(v string) *PutImageInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PutImageInput) SetRepositoryName(v string) *PutImageInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageResponse
type PutImageOutput struct {
	_ struct{} `type:"structure"`

	// Details of the image uploaded.
	Image *Image `locationName:"image" type:"structure"`
}

// String returns the string representation
func (s PutImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutImageOutput) GoString() string {
	return s.String()
}

// SetImage sets the Image field's value.
func (s *PutImageOutput) SetImage(v *Image) *PutImageOutput {
	s.Image = v
	return s
}

// An object representing a repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/Repository
type Repository struct {
	_ struct{} `type:"structure"`

	// The date and time, in JavaScript date/time format, when the repository was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"unix"`

	// The AWS account ID associated with the registry that contains the repository.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the repository. The ARN contains
	// the arn:aws:ecr namespace, followed by the region of the repository, the
	// AWS account ID of the repository owner, the repository namespace, and then
	// the repository name. For example, arn:aws:ecr:region:012345678910:repository/test.
	RepositoryArn *string `locationName:"repositoryArn" type:"string"`

	// The name of the repository.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The URI for the repository. You can use this URI for Docker push and pull
	// operations.
	RepositoryUri *string `locationName:"repositoryUri" type:"string"`
}

// String returns the string representation
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Repository) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Repository) SetCreatedAt(v time.Time) *Repository {
	s.CreatedAt = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *Repository) SetRegistryId(v string) *Repository {
	s.RegistryId = &v
	return s
}

// SetRepositoryArn sets the RepositoryArn field's value.
func (s *Repository) SetRepositoryArn(v string) *Repository {
	s.RepositoryArn = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *Repository) SetRepositoryName(v string) *Repository {
	s.RepositoryName = &v
	return s
}

// SetRepositoryUri sets the RepositoryUri field's value.
func (s *Repository) SetRepositoryUri(v string) *Repository {
	s.RepositoryUri = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicyRequest
type SetRepositoryPolicyInput struct {
	_ struct{} `type:"structure"`

	// If the policy you are attempting to set on a repository policy would prevent
	// you from setting another policy in the future, you must force the SetRepositoryPolicy
	// operation. This is intended to prevent accidental repository lock outs.
	Force *bool `locationName:"force" type:"boolean"`

	// The JSON repository policy text to apply to the repository.
	//
	// PolicyText is a required field
	PolicyText *string `locationName:"policyText" type:"string" required:"true"`

	// The AWS account ID associated with the registry that contains the repository.
	// If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository to receive the policy.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s SetRepositoryPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetRepositoryPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetRepositoryPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetRepositoryPolicyInput"}
	if s.PolicyText == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyText"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *SetRepositoryPolicyInput) SetForce(v bool) *SetRepositoryPolicyInput {
	s.Force = &v
	return s
}

// SetPolicyText sets the PolicyText field's value.
func (s *SetRepositoryPolicyInput) SetPolicyText(v string) *SetRepositoryPolicyInput {
	s.PolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *SetRepositoryPolicyInput) SetRegistryId(v string) *SetRepositoryPolicyInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *SetRepositoryPolicyInput) SetRepositoryName(v string) *SetRepositoryPolicyInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicyResponse
type SetRepositoryPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The JSON repository policy text applied to the repository.
	PolicyText *string `locationName:"policyText" type:"string"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`
}

// String returns the string representation
func (s SetRepositoryPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetRepositoryPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyText sets the PolicyText field's value.
func (s *SetRepositoryPolicyOutput) SetPolicyText(v string) *SetRepositoryPolicyOutput {
	s.PolicyText = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *SetRepositoryPolicyOutput) SetRegistryId(v string) *SetRepositoryPolicyOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *SetRepositoryPolicyOutput) SetRepositoryName(v string) *SetRepositoryPolicyOutput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UploadLayerPartRequest
type UploadLayerPartInput struct {
	_ struct{} `type:"structure"`

	// The base64-encoded layer part payload.
	//
	// LayerPartBlob is automatically base64 encoded/decoded by the SDK.
	//
	// LayerPartBlob is a required field
	LayerPartBlob []byte `locationName:"layerPartBlob" type:"blob" required:"true"`

	// The integer value of the first byte of the layer part.
	//
	// PartFirstByte is a required field
	PartFirstByte *int64 `locationName:"partFirstByte" type:"long" required:"true"`

	// The integer value of the last byte of the layer part.
	//
	// PartLastByte is a required field
	PartLastByte *int64 `locationName:"partLastByte" type:"long" required:"true"`

	// The AWS account ID associated with the registry that you are uploading layer
	// parts to. If you do not specify a registry, the default registry is assumed.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The name of the repository that you are uploading layer parts to.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string" required:"true"`

	// The upload ID from a previous InitiateLayerUpload operation to associate
	// with the layer part upload.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadLayerPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadLayerPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadLayerPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadLayerPartInput"}
	if s.LayerPartBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerPartBlob"))
	}
	if s.PartFirstByte == nil {
		invalidParams.Add(request.NewErrParamRequired("PartFirstByte"))
	}
	if s.PartLastByte == nil {
		invalidParams.Add(request.NewErrParamRequired("PartLastByte"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 2))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerPartBlob sets the LayerPartBlob field's value.
func (s *UploadLayerPartInput) SetLayerPartBlob(v []byte) *UploadLayerPartInput {
	s.LayerPartBlob = v
	return s
}

// SetPartFirstByte sets the PartFirstByte field's value.
func (s *UploadLayerPartInput) SetPartFirstByte(v int64) *UploadLayerPartInput {
	s.PartFirstByte = &v
	return s
}

// SetPartLastByte sets the PartLastByte field's value.
func (s *UploadLayerPartInput) SetPartLastByte(v int64) *UploadLayerPartInput {
	s.PartLastByte = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *UploadLayerPartInput) SetRegistryId(v string) *UploadLayerPartInput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UploadLayerPartInput) SetRepositoryName(v string) *UploadLayerPartInput {
	s.RepositoryName = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadLayerPartInput) SetUploadId(v string) *UploadLayerPartInput {
	s.UploadId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UploadLayerPartResponse
type UploadLayerPartOutput struct {
	_ struct{} `type:"structure"`

	// The integer value of the last byte received in the request.
	LastByteReceived *int64 `locationName:"lastByteReceived" type:"long"`

	// The registry ID associated with the request.
	RegistryId *string `locationName:"registryId" type:"string"`

	// The repository name associated with the request.
	RepositoryName *string `locationName:"repositoryName" min:"2" type:"string"`

	// The upload ID associated with the request.
	UploadId *string `locationName:"uploadId" type:"string"`
}

// String returns the string representation
func (s UploadLayerPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadLayerPartOutput) GoString() string {
	return s.String()
}

// SetLastByteReceived sets the LastByteReceived field's value.
func (s *UploadLayerPartOutput) SetLastByteReceived(v int64) *UploadLayerPartOutput {
	s.LastByteReceived = &v
	return s
}

// SetRegistryId sets the RegistryId field's value.
func (s *UploadLayerPartOutput) SetRegistryId(v string) *UploadLayerPartOutput {
	s.RegistryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UploadLayerPartOutput) SetRepositoryName(v string) *UploadLayerPartOutput {
	s.RepositoryName = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadLayerPartOutput) SetUploadId(v string) *UploadLayerPartOutput {
	s.UploadId = &v
	return s
}

const (
	// ImageFailureCodeInvalidImageDigest is a ImageFailureCode enum value
	ImageFailureCodeInvalidImageDigest = "InvalidImageDigest"

	// ImageFailureCodeInvalidImageTag is a ImageFailureCode enum value
	ImageFailureCodeInvalidImageTag = "InvalidImageTag"

	// ImageFailureCodeImageTagDoesNotMatchDigest is a ImageFailureCode enum value
	ImageFailureCodeImageTagDoesNotMatchDigest = "ImageTagDoesNotMatchDigest"

	// ImageFailureCodeImageNotFound is a ImageFailureCode enum value
	ImageFailureCodeImageNotFound = "ImageNotFound"

	// ImageFailureCodeMissingDigestAndTag is a ImageFailureCode enum value
	ImageFailureCodeMissingDigestAndTag = "MissingDigestAndTag"
)

const (
	// LayerAvailabilityAvailable is a LayerAvailability enum value
	LayerAvailabilityAvailable = "AVAILABLE"

	// LayerAvailabilityUnavailable is a LayerAvailability enum value
	LayerAvailabilityUnavailable = "UNAVAILABLE"
)

const (
	// LayerFailureCodeInvalidLayerDigest is a LayerFailureCode enum value
	LayerFailureCodeInvalidLayerDigest = "InvalidLayerDigest"

	// LayerFailureCodeMissingLayerDigest is a LayerFailureCode enum value
	LayerFailureCodeMissingLayerDigest = "MissingLayerDigest"
)

const (
	// TagStatusTagged is a TagStatus enum value
	TagStatusTagged = "TAGGED"

	// TagStatusUntagged is a TagStatus enum value
	TagStatusUntagged = "UNTAGGED"
)
