// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudformation provides a client for AWS CloudFormation.
package cloudformation

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opCancelUpdateStack = "CancelUpdateStack"

// CancelUpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the CancelUpdateStack operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelUpdateStack for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelUpdateStack method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelUpdateStackRequest method.
//    req, resp := client.CancelUpdateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack
func (c *CloudFormation) CancelUpdateStackRequest(input *CancelUpdateStackInput) (req *request.Request, output *CancelUpdateStackOutput) {
	op := &request.Operation{
		Name:       opCancelUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelUpdateStackInput{}
	}

	output = &CancelUpdateStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelUpdateStack API operation for AWS CloudFormation.
//
// Cancels an update on the specified stack. If the call completes successfully,
// the stack rolls back the update and reverts to the previous stack configuration.
//
// You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CancelUpdateStack for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStack
func (c *CloudFormation) CancelUpdateStack(input *CancelUpdateStackInput) (*CancelUpdateStackOutput, error) {
	req, out := c.CancelUpdateStackRequest(input)
	err := req.Send()
	return out, err
}

const opContinueUpdateRollback = "ContinueUpdateRollback"

// ContinueUpdateRollbackRequest generates a "aws/request.Request" representing the
// client's request for the ContinueUpdateRollback operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ContinueUpdateRollback for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ContinueUpdateRollback method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ContinueUpdateRollbackRequest method.
//    req, resp := client.ContinueUpdateRollbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback
func (c *CloudFormation) ContinueUpdateRollbackRequest(input *ContinueUpdateRollbackInput) (req *request.Request, output *ContinueUpdateRollbackOutput) {
	op := &request.Operation{
		Name:       opContinueUpdateRollback,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ContinueUpdateRollbackInput{}
	}

	output = &ContinueUpdateRollbackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ContinueUpdateRollback API operation for AWS CloudFormation.
//
// For a specified stack that is in the UPDATE_ROLLBACK_FAILED state, continues
// rolling it back to the UPDATE_ROLLBACK_COMPLETE state. Depending on the cause
// of the failure, you can manually  fix the error (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
// and continue the rollback. By continuing the rollback, you can return your
// stack to a working state (the UPDATE_ROLLBACK_COMPLETE state), and then try
// to update the stack again.
//
// A stack goes into the UPDATE_ROLLBACK_FAILED state when AWS CloudFormation
// cannot roll back all changes after a failed stack update. For example, you
// might have a stack that is rolling back to an old database instance that
// was deleted outside of AWS CloudFormation. Because AWS CloudFormation doesn't
// know the database was deleted, it assumes that the database instance still
// exists and attempts to roll back to it, causing the update rollback to fail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ContinueUpdateRollback for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollback
func (c *CloudFormation) ContinueUpdateRollback(input *ContinueUpdateRollbackInput) (*ContinueUpdateRollbackOutput, error) {
	req, out := c.ContinueUpdateRollbackRequest(input)
	err := req.Send()
	return out, err
}

const opCreateChangeSet = "CreateChangeSet"

// CreateChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateChangeSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateChangeSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateChangeSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateChangeSetRequest method.
//    req, resp := client.CreateChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet
func (c *CloudFormation) CreateChangeSetRequest(input *CreateChangeSetInput) (req *request.Request, output *CreateChangeSetOutput) {
	op := &request.Operation{
		Name:       opCreateChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateChangeSetInput{}
	}

	output = &CreateChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChangeSet API operation for AWS CloudFormation.
//
// Creates a list of changes for a stack. AWS CloudFormation generates the change
// set by comparing the template's information with the information that you
// submit. A change set can help you understand which resources AWS CloudFormation
// will change, and how it will change them, before you update your stack. Change
// sets allow you to check before making a change to avoid deleting or replacing
// critical resources.
//
// AWS CloudFormation doesn't make any changes to the stack when you create
// a change set. To make the specified changes, you must execute the change
// set by using the ExecuteChangeSet action.
//
// After the call successfully completes, AWS CloudFormation starts creating
// the change set. To check the status of the change set, use the DescribeChangeSet
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateChangeSet for usage and error information.
//
// Returned Error Codes:
//   * AlreadyExistsException
//   Resource with the name requested already exists.
//
//   * InsufficientCapabilitiesException
//   The template contains resources with capabilities that were not specified
//   in the Capabilities parameter.
//
//   * LimitExceededException
//   Quota for the resource has already been reached.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet
func (c *CloudFormation) CreateChangeSet(input *CreateChangeSetInput) (*CreateChangeSetOutput, error) {
	req, out := c.CreateChangeSetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a "aws/request.Request" representing the
// client's request for the CreateStack operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateStack for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateStack method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateStackRequest method.
//    req, resp := client.CreateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack
func (c *CloudFormation) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	output = &CreateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStack API operation for AWS CloudFormation.
//
// Creates a stack as specified in the template. After the call completes successfully,
// the stack creation starts. You can check the status of the stack via the
// DescribeStacks API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation CreateStack for usage and error information.
//
// Returned Error Codes:
//   * LimitExceededException
//   Quota for the resource has already been reached.
//
//   * AlreadyExistsException
//   Resource with the name requested already exists.
//
//   * InsufficientCapabilitiesException
//   The template contains resources with capabilities that were not specified
//   in the Capabilities parameter.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStack
func (c *CloudFormation) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteChangeSet = "DeleteChangeSet"

// DeleteChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChangeSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteChangeSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteChangeSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteChangeSetRequest method.
//    req, resp := client.DeleteChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet
func (c *CloudFormation) DeleteChangeSetRequest(input *DeleteChangeSetInput) (req *request.Request, output *DeleteChangeSetOutput) {
	op := &request.Operation{
		Name:       opDeleteChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChangeSetInput{}
	}

	output = &DeleteChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteChangeSet API operation for AWS CloudFormation.
//
// Deletes the specified change set. Deleting change sets ensures that no one
// executes the wrong change set.
//
// If the call successfully completes, AWS CloudFormation successfully deleted
// the change set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteChangeSet for usage and error information.
//
// Returned Error Codes:
//   * InvalidChangeSetStatus
//   The specified change set cannot be used to update the stack. For example,
//   the change set status might be CREATE_IN_PROGRESS or the stack status might
//   be UPDATE_IN_PROGRESS.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSet
func (c *CloudFormation) DeleteChangeSet(input *DeleteChangeSetInput) (*DeleteChangeSetOutput, error) {
	req, out := c.DeleteChangeSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStack operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteStack for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteStack method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteStackRequest method.
//    req, resp := client.DeleteStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack
func (c *CloudFormation) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	output = &DeleteStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStack API operation for AWS CloudFormation.
//
// Deletes a specified stack. Once the call completes successfully, stack deletion
// starts. Deleted stacks do not show up in the DescribeStacks API if the deletion
// has been completed successfully.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DeleteStack for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStack
func (c *CloudFormation) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountLimits operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAccountLimits for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAccountLimits method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAccountLimitsRequest method.
//    req, resp := client.DescribeAccountLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits
func (c *CloudFormation) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *request.Request, output *DescribeAccountLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	output = &DescribeAccountLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountLimits API operation for AWS CloudFormation.
//
// Retrieves your account's AWS CloudFormation limits, such as the maximum number
// of stacks that you can create in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeAccountLimits for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimits
func (c *CloudFormation) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeChangeSet = "DescribeChangeSet"

// DescribeChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChangeSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeChangeSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeChangeSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeChangeSetRequest method.
//    req, resp := client.DescribeChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet
func (c *CloudFormation) DescribeChangeSetRequest(input *DescribeChangeSetInput) (req *request.Request, output *DescribeChangeSetOutput) {
	op := &request.Operation{
		Name:       opDescribeChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChangeSetInput{}
	}

	output = &DescribeChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChangeSet API operation for AWS CloudFormation.
//
// Returns the inputs for the change set and a list of changes that AWS CloudFormation
// will make if you execute the change set. For more information, see Updating
// Stacks Using Change Sets (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html)
// in the AWS CloudFormation User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeChangeSet for usage and error information.
//
// Returned Error Codes:
//   * ChangeSetNotFound
//   The specified change set name or ID doesn't exit. To view valid change sets
//   for a stack, use the ListChangeSets action.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSet
func (c *CloudFormation) DescribeChangeSet(input *DescribeChangeSetInput) (*DescribeChangeSetOutput, error) {
	req, out := c.DescribeChangeSetRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStackEvents = "DescribeStackEvents"

// DescribeStackEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackEvents operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStackEvents for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStackEvents method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStackEventsRequest method.
//    req, resp := client.DescribeStackEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents
func (c *CloudFormation) DescribeStackEventsRequest(input *DescribeStackEventsInput) (req *request.Request, output *DescribeStackEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeStackEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackEventsInput{}
	}

	output = &DescribeStackEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackEvents API operation for AWS CloudFormation.
//
// Returns all stack related events for a specified stack in reverse chronological
// order. For more information about a stack's event history, go to Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html)
// in the AWS CloudFormation User Guide.
//
// You can list events for stacks that have failed to create or have been deleted
// by specifying the unique stack identifier (stack ID).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackEvents for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEvents
func (c *CloudFormation) DescribeStackEvents(input *DescribeStackEventsInput) (*DescribeStackEventsOutput, error) {
	req, out := c.DescribeStackEventsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeStackEventsPages iterates over the pages of a DescribeStackEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStackEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStackEvents operation.
//    pageNum := 0
//    err := client.DescribeStackEventsPages(params,
//        func(page *DescribeStackEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) DescribeStackEventsPages(input *DescribeStackEventsInput, fn func(p *DescribeStackEventsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeStackEventsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeStackEventsOutput), lastPage)
	})
}

const opDescribeStackResource = "DescribeStackResource"

// DescribeStackResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStackResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStackResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStackResourceRequest method.
//    req, resp := client.DescribeStackResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource
func (c *CloudFormation) DescribeStackResourceRequest(input *DescribeStackResourceInput) (req *request.Request, output *DescribeStackResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourceInput{}
	}

	output = &DescribeStackResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackResource API operation for AWS CloudFormation.
//
// Returns a description of the specified resource in the specified stack.
//
// For deleted stacks, DescribeStackResource returns resource information for
// up to 90 days after the stack has been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackResource for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResource
func (c *CloudFormation) DescribeStackResource(input *DescribeStackResourceInput) (*DescribeStackResourceOutput, error) {
	req, out := c.DescribeStackResourceRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStackResources = "DescribeStackResources"

// DescribeStackResourcesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackResources operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStackResources for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStackResources method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStackResourcesRequest method.
//    req, resp := client.DescribeStackResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources
func (c *CloudFormation) DescribeStackResourcesRequest(input *DescribeStackResourcesInput) (req *request.Request, output *DescribeStackResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourcesInput{}
	}

	output = &DescribeStackResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackResources API operation for AWS CloudFormation.
//
// Returns AWS resource descriptions for running and deleted stacks. If StackName
// is specified, all the associated resources that are part of the stack are
// returned. If PhysicalResourceId is specified, the associated resources of
// the stack that the resource belongs to are returned.
//
// Only the first 100 resources will be returned. If your stack has more resources
// than this, you should use ListStackResources instead.
//
// For deleted stacks, DescribeStackResources returns resource information for
// up to 90 days after the stack has been deleted.
//
// You must specify either StackName or PhysicalResourceId, but not both. In
// addition, you can specify LogicalResourceId to filter the returned result.
// For more information about resources, the LogicalResourceId and PhysicalResourceId,
// go to the AWS CloudFormation User Guide (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
//
// A ValidationError is returned if you specify both StackName and PhysicalResourceId
// in the same request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStackResources for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResources
func (c *CloudFormation) DescribeStackResources(input *DescribeStackResourcesInput) (*DescribeStackResourcesOutput, error) {
	req, out := c.DescribeStackResourcesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStacks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStacks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStacks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStacksRequest method.
//    req, resp := client.DescribeStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks
func (c *CloudFormation) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	output = &DescribeStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStacks API operation for AWS CloudFormation.
//
// Returns the description for the specified stack; if no stack name was specified,
// then it returns the description for all the stacks created.
//
// If the stack does not exist, an AmazonCloudFormationException is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation DescribeStacks for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacks
func (c *CloudFormation) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	err := req.Send()
	return out, err
}

// DescribeStacksPages iterates over the pages of a DescribeStacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeStacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeStacks operation.
//    pageNum := 0
//    err := client.DescribeStacksPages(params,
//        func(page *DescribeStacksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) DescribeStacksPages(input *DescribeStacksInput, fn func(p *DescribeStacksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeStacksRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeStacksOutput), lastPage)
	})
}

const opEstimateTemplateCost = "EstimateTemplateCost"

// EstimateTemplateCostRequest generates a "aws/request.Request" representing the
// client's request for the EstimateTemplateCost operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EstimateTemplateCost for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EstimateTemplateCost method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EstimateTemplateCostRequest method.
//    req, resp := client.EstimateTemplateCostRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost
func (c *CloudFormation) EstimateTemplateCostRequest(input *EstimateTemplateCostInput) (req *request.Request, output *EstimateTemplateCostOutput) {
	op := &request.Operation{
		Name:       opEstimateTemplateCost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EstimateTemplateCostInput{}
	}

	output = &EstimateTemplateCostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EstimateTemplateCost API operation for AWS CloudFormation.
//
// Returns the estimated monthly cost of a template. The return value is an
// AWS Simple Monthly Calculator URL with a query string that describes the
// resources required to run the template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation EstimateTemplateCost for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCost
func (c *CloudFormation) EstimateTemplateCost(input *EstimateTemplateCostInput) (*EstimateTemplateCostOutput, error) {
	req, out := c.EstimateTemplateCostRequest(input)
	err := req.Send()
	return out, err
}

const opExecuteChangeSet = "ExecuteChangeSet"

// ExecuteChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the ExecuteChangeSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ExecuteChangeSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ExecuteChangeSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ExecuteChangeSetRequest method.
//    req, resp := client.ExecuteChangeSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet
func (c *CloudFormation) ExecuteChangeSetRequest(input *ExecuteChangeSetInput) (req *request.Request, output *ExecuteChangeSetOutput) {
	op := &request.Operation{
		Name:       opExecuteChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecuteChangeSetInput{}
	}

	output = &ExecuteChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExecuteChangeSet API operation for AWS CloudFormation.
//
// Updates a stack using the input information that was provided when the specified
// change set was created. After the call successfully completes, AWS CloudFormation
// starts updating the stack. Use the DescribeStacks action to view the status
// of the update.
//
// When you execute a change set, AWS CloudFormation deletes all other change
// sets associated with the stack because they aren't valid for the updated
// stack.
//
// If a stack policy is associated with the stack, AWS CloudFormation enforces
// the policy during the update. You can't specify a temporary stack policy
// that overrides the current policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ExecuteChangeSet for usage and error information.
//
// Returned Error Codes:
//   * InvalidChangeSetStatus
//   The specified change set cannot be used to update the stack. For example,
//   the change set status might be CREATE_IN_PROGRESS or the stack status might
//   be UPDATE_IN_PROGRESS.
//
//   * ChangeSetNotFound
//   The specified change set name or ID doesn't exit. To view valid change sets
//   for a stack, use the ListChangeSets action.
//
//   * InsufficientCapabilitiesException
//   The template contains resources with capabilities that were not specified
//   in the Capabilities parameter.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSet
func (c *CloudFormation) ExecuteChangeSet(input *ExecuteChangeSetInput) (*ExecuteChangeSetOutput, error) {
	req, out := c.ExecuteChangeSetRequest(input)
	err := req.Send()
	return out, err
}

const opGetStackPolicy = "GetStackPolicy"

// GetStackPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetStackPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetStackPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetStackPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetStackPolicyRequest method.
//    req, resp := client.GetStackPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy
func (c *CloudFormation) GetStackPolicyRequest(input *GetStackPolicyInput) (req *request.Request, output *GetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opGetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStackPolicyInput{}
	}

	output = &GetStackPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStackPolicy API operation for AWS CloudFormation.
//
// Returns the stack policy for a specified stack. If a stack doesn't have a
// policy, a null value is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetStackPolicy for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicy
func (c *CloudFormation) GetStackPolicy(input *GetStackPolicyInput) (*GetStackPolicyOutput, error) {
	req, out := c.GetStackPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetTemplate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetTemplate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetTemplateRequest method.
//    req, resp := client.GetTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate
func (c *CloudFormation) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	output = &GetTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplate API operation for AWS CloudFormation.
//
// Returns the template body for a specified stack. You can get the template
// for running or deleted stacks.
//
// For deleted stacks, GetTemplate returns the template for up to 90 days after
// the stack has been deleted.
//
// If the template does not exist, a ValidationError is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetTemplate for usage and error information.
//
// Returned Error Codes:
//   * ChangeSetNotFound
//   The specified change set name or ID doesn't exit. To view valid change sets
//   for a stack, use the ListChangeSets action.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplate
func (c *CloudFormation) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	err := req.Send()
	return out, err
}

const opGetTemplateSummary = "GetTemplateSummary"

// GetTemplateSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplateSummary operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetTemplateSummary for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetTemplateSummary method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetTemplateSummaryRequest method.
//    req, resp := client.GetTemplateSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary
func (c *CloudFormation) GetTemplateSummaryRequest(input *GetTemplateSummaryInput) (req *request.Request, output *GetTemplateSummaryOutput) {
	op := &request.Operation{
		Name:       opGetTemplateSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateSummaryInput{}
	}

	output = &GetTemplateSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplateSummary API operation for AWS CloudFormation.
//
// Returns information about a new or existing template. The GetTemplateSummary
// action is useful for viewing parameter information, such as default parameter
// values and parameter types, before you create or update a stack.
//
// You can use the GetTemplateSummary action when you submit a template, or
// you can get template information for a running or deleted stack.
//
// For deleted stacks, GetTemplateSummary returns the template information for
// up to 90 days after the stack has been deleted. If the template does not
// exist, a ValidationError is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation GetTemplateSummary for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummary
func (c *CloudFormation) GetTemplateSummary(input *GetTemplateSummaryInput) (*GetTemplateSummaryOutput, error) {
	req, out := c.GetTemplateSummaryRequest(input)
	err := req.Send()
	return out, err
}

const opListChangeSets = "ListChangeSets"

// ListChangeSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListChangeSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListChangeSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListChangeSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListChangeSetsRequest method.
//    req, resp := client.ListChangeSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets
func (c *CloudFormation) ListChangeSetsRequest(input *ListChangeSetsInput) (req *request.Request, output *ListChangeSetsOutput) {
	op := &request.Operation{
		Name:       opListChangeSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListChangeSetsInput{}
	}

	output = &ListChangeSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChangeSets API operation for AWS CloudFormation.
//
// Returns the ID and status of each active change set for a stack. For example,
// AWS CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or
// CREATE_PENDING state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListChangeSets for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSets
func (c *CloudFormation) ListChangeSets(input *ListChangeSetsInput) (*ListChangeSetsOutput, error) {
	req, out := c.ListChangeSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListExports = "ListExports"

// ListExportsRequest generates a "aws/request.Request" representing the
// client's request for the ListExports operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListExports for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListExports method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListExportsRequest method.
//    req, resp := client.ListExportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports
func (c *CloudFormation) ListExportsRequest(input *ListExportsInput) (req *request.Request, output *ListExportsOutput) {
	op := &request.Operation{
		Name:       opListExports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListExportsInput{}
	}

	output = &ListExportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExports API operation for AWS CloudFormation.
//
// Lists all exported output values in the account and region in which you call
// this action. Use this action to see the exported output values that you can
// import into other stacks. To import values, use the Fn::ImportValue (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
// function.
//
// For more information, see  AWS CloudFormation Export Stack Output Values
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListExports for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExports
func (c *CloudFormation) ListExports(input *ListExportsInput) (*ListExportsOutput, error) {
	req, out := c.ListExportsRequest(input)
	err := req.Send()
	return out, err
}

const opListImports = "ListImports"

// ListImportsRequest generates a "aws/request.Request" representing the
// client's request for the ListImports operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListImports for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListImports method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListImportsRequest method.
//    req, resp := client.ListImportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports
func (c *CloudFormation) ListImportsRequest(input *ListImportsInput) (req *request.Request, output *ListImportsOutput) {
	op := &request.Operation{
		Name:       opListImports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListImportsInput{}
	}

	output = &ListImportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImports API operation for AWS CloudFormation.
//
// Lists all stacks that are importing an exported output value. To modify or
// remove an exported output value, first use this action to see which stacks
// are using it. To see the exported output values in your account, see ListExports.
//
// For more information about importing an exported output value, see the Fn::ImportValue
// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
// function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListImports for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImports
func (c *CloudFormation) ListImports(input *ListImportsInput) (*ListImportsOutput, error) {
	req, out := c.ListImportsRequest(input)
	err := req.Send()
	return out, err
}

const opListStackResources = "ListStackResources"

// ListStackResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListStackResources operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListStackResources for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListStackResources method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListStackResourcesRequest method.
//    req, resp := client.ListStackResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources
func (c *CloudFormation) ListStackResourcesRequest(input *ListStackResourcesInput) (req *request.Request, output *ListStackResourcesOutput) {
	op := &request.Operation{
		Name:       opListStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackResourcesInput{}
	}

	output = &ListStackResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStackResources API operation for AWS CloudFormation.
//
// Returns descriptions of all resources of the specified stack.
//
// For deleted stacks, ListStackResources returns resource information for up
// to 90 days after the stack has been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStackResources for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResources
func (c *CloudFormation) ListStackResources(input *ListStackResourcesInput) (*ListStackResourcesOutput, error) {
	req, out := c.ListStackResourcesRequest(input)
	err := req.Send()
	return out, err
}

// ListStackResourcesPages iterates over the pages of a ListStackResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStackResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStackResources operation.
//    pageNum := 0
//    err := client.ListStackResourcesPages(params,
//        func(page *ListStackResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) ListStackResourcesPages(input *ListStackResourcesInput, fn func(p *ListStackResourcesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStackResourcesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStackResourcesOutput), lastPage)
	})
}

const opListStacks = "ListStacks"

// ListStacksRequest generates a "aws/request.Request" representing the
// client's request for the ListStacks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListStacks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListStacks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListStacksRequest method.
//    req, resp := client.ListStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks
func (c *CloudFormation) ListStacksRequest(input *ListStacksInput) (req *request.Request, output *ListStacksOutput) {
	op := &request.Operation{
		Name:       opListStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStacksInput{}
	}

	output = &ListStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStacks API operation for AWS CloudFormation.
//
// Returns the summary information for stacks whose status matches the specified
// StackStatusFilter. Summary information for stacks that have been deleted
// is kept for 90 days after the stack is deleted. If no StackStatusFilter is
// specified, summary information for all stacks is returned (including existing
// stacks and stacks that have been deleted).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ListStacks for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacks
func (c *CloudFormation) ListStacks(input *ListStacksInput) (*ListStacksOutput, error) {
	req, out := c.ListStacksRequest(input)
	err := req.Send()
	return out, err
}

// ListStacksPages iterates over the pages of a ListStacks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStacks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStacks operation.
//    pageNum := 0
//    err := client.ListStacksPages(params,
//        func(page *ListStacksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFormation) ListStacksPages(input *ListStacksInput, fn func(p *ListStacksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStacksRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStacksOutput), lastPage)
	})
}

const opSetStackPolicy = "SetStackPolicy"

// SetStackPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SetStackPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetStackPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetStackPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetStackPolicyRequest method.
//    req, resp := client.SetStackPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy
func (c *CloudFormation) SetStackPolicyRequest(input *SetStackPolicyInput) (req *request.Request, output *SetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opSetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetStackPolicyInput{}
	}

	output = &SetStackPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetStackPolicy API operation for AWS CloudFormation.
//
// Sets a stack policy for a specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation SetStackPolicy for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicy
func (c *CloudFormation) SetStackPolicy(input *SetStackPolicyInput) (*SetStackPolicyOutput, error) {
	req, out := c.SetStackPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opSignalResource = "SignalResource"

// SignalResourceRequest generates a "aws/request.Request" representing the
// client's request for the SignalResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SignalResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SignalResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SignalResourceRequest method.
//    req, resp := client.SignalResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource
func (c *CloudFormation) SignalResourceRequest(input *SignalResourceInput) (req *request.Request, output *SignalResourceOutput) {
	op := &request.Operation{
		Name:       opSignalResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalResourceInput{}
	}

	output = &SignalResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SignalResource API operation for AWS CloudFormation.
//
// Sends a signal to the specified resource with a success or failure status.
// You can use the SignalResource API in conjunction with a creation policy
// or update policy. AWS CloudFormation doesn't proceed with a stack creation
// or update until resources receive the required number of signals or the timeout
// period is exceeded. The SignalResource API is useful in cases where you want
// to send signals from anywhere other than an Amazon EC2 instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation SignalResource for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource
func (c *CloudFormation) SignalResource(input *SignalResourceInput) (*SignalResourceOutput, error) {
	req, out := c.SignalResourceRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStack operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateStack for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateStack method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateStackRequest method.
//    req, resp := client.UpdateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack
func (c *CloudFormation) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	output = &UpdateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStack API operation for AWS CloudFormation.
//
// Updates a stack as specified in the template. After the call completes successfully,
// the stack update starts. You can check the status of the stack via the DescribeStacks
// action.
//
// To get a copy of the template for an existing stack, you can use the GetTemplate
// action.
//
// For more information about creating an update template, updating a stack,
// and monitoring the progress of the update, see Updating a Stack (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation UpdateStack for usage and error information.
//
// Returned Error Codes:
//   * InsufficientCapabilitiesException
//   The template contains resources with capabilities that were not specified
//   in the Capabilities parameter.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStack
func (c *CloudFormation) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	err := req.Send()
	return out, err
}

const opValidateTemplate = "ValidateTemplate"

// ValidateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the ValidateTemplate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ValidateTemplate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ValidateTemplate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ValidateTemplateRequest method.
//    req, resp := client.ValidateTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate
func (c *CloudFormation) ValidateTemplateRequest(input *ValidateTemplateInput) (req *request.Request, output *ValidateTemplateOutput) {
	op := &request.Operation{
		Name:       opValidateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateTemplateInput{}
	}

	output = &ValidateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateTemplate API operation for AWS CloudFormation.
//
// Validates a specified template. AWS CloudFormation first checks if the template
// is valid JSON. If it isn't, AWS CloudFormation checks if the template is
// valid YAML. If both these checks fail, AWS CloudFormation returns a template
// validation error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudFormation's
// API operation ValidateTemplate for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplate
func (c *CloudFormation) ValidateTemplate(input *ValidateTemplateInput) (*ValidateTemplateOutput, error) {
	req, out := c.ValidateTemplateRequest(input)
	err := req.Send()
	return out, err
}

// The AccountLimit data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/AccountLimit
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The name of the account limit. Currently, the only account limit is StackLimit.
	Name *string `type:"string"`

	// The value that is associated with the account limit name.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AccountLimit) SetName(v string) *AccountLimit {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AccountLimit) SetValue(v int64) *AccountLimit {
	s.Value = &v
	return s
}

// The input for the CancelUpdateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStackInput
type CancelUpdateStackInput struct {
	_ struct{} `type:"structure"`

	// The name or the unique stack ID that is associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelUpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelUpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelUpdateStackInput"}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *CancelUpdateStackInput) SetStackName(v string) *CancelUpdateStackInput {
	s.StackName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CancelUpdateStackOutput
type CancelUpdateStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelUpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackOutput) GoString() string {
	return s.String()
}

// The Change structure describes the changes AWS CloudFormation will perform
// if you execute the change set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Change
type Change struct {
	_ struct{} `type:"structure"`

	// A ResourceChange structure that describes the resource and action that AWS
	// CloudFormation will perform.
	ResourceChange *ResourceChange `type:"structure"`

	// The type of entity that AWS CloudFormation changes. Currently, the only entity
	// type is Resource.
	Type *string `type:"string" enum:"ChangeType"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Change) GoString() string {
	return s.String()
}

// SetResourceChange sets the ResourceChange field's value.
func (s *Change) SetResourceChange(v *ResourceChange) *Change {
	s.ResourceChange = v
	return s
}

// SetType sets the Type field's value.
func (s *Change) SetType(v string) *Change {
	s.Type = &v
	return s
}

// The ChangeSetSummary structure describes a change set, its status, and the
// stack with which it's associated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ChangeSetSummary
type ChangeSetSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Descriptive information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can’t execute the change set, the status indicates why. For example,
	// a change set might be in an UNAVAILABLE state because AWS CloudFormation
	// is still creating it or in an OBSOLETE state because the stack was already
	// updated.
	ExecutionStatus *string `type:"string" enum:"ExecutionStatus"`

	// The ID of the stack with which the change set is associated.
	StackId *string `type:"string"`

	// The name of the stack with which the change set is associated.
	StackName *string `type:"string"`

	// The state of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status *string `type:"string" enum:"ChangeSetStatus"`

	// A description of the change set's status. For example, if your change set
	// is in the FAILED state, AWS CloudFormation shows the error message.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s ChangeSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeSetSummary) GoString() string {
	return s.String()
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *ChangeSetSummary) SetChangeSetId(v string) *ChangeSetSummary {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *ChangeSetSummary) SetChangeSetName(v string) *ChangeSetSummary {
	s.ChangeSetName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ChangeSetSummary) SetCreationTime(v time.Time) *ChangeSetSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ChangeSetSummary) SetDescription(v string) *ChangeSetSummary {
	s.Description = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *ChangeSetSummary) SetExecutionStatus(v string) *ChangeSetSummary {
	s.ExecutionStatus = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *ChangeSetSummary) SetStackId(v string) *ChangeSetSummary {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ChangeSetSummary) SetStackName(v string) *ChangeSetSummary {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ChangeSetSummary) SetStatus(v string) *ChangeSetSummary {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ChangeSetSummary) SetStatusReason(v string) *ChangeSetSummary {
	s.StatusReason = &v
	return s
}

// The input for the ContinueUpdateRollback action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollbackInput
type ContinueUpdateRollbackInput struct {
	_ struct{} `type:"structure"`

	// A list of the logical IDs of the resources that AWS CloudFormation skips
	// during the continue update rollback operation. You can specify only resources
	// that are in the UPDATE_FAILED state because a rollback failed. You can't
	// specify resources that are in the UPDATE_FAILED state for other reasons,
	// for example, because an update was canceled. To check why a resource update
	// failed, use the DescribeStackResources action, and view the resource status
	// reason.
	//
	// Specify this property to skip rolling back resources that AWS CloudFormation
	// can't successfully roll back. We recommend that you  troubleshoot (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
	// resources before skipping them. AWS CloudFormation sets the status of the
	// specified resources to UPDATE_COMPLETE and continues to roll back the stack.
	// After the rollback is complete, the state of the skipped resources will be
	// inconsistent with the state of the resources in the stack template. Before
	// performing another stack update, you must update the stack or resources to
	// be consistent with each other. If you don't, subsequent stack updates might
	// fail, and the stack will become unrecoverable.
	//
	// Specify the minimum number of resources required to successfully roll back
	// your stack. For example, a failed resource update might cause dependent resources
	// to fail. In this case, it might not be necessary to skip the dependent resources.
	//
	// To specify resources in a nested stack, use the following format: NestedStackName.ResourceLogicalID.
	// You can specify a nested stack resource (the logical ID of an AWS::CloudFormation::Stack
	// resource) only if it's in one of the following states: DELETE_IN_PROGRESS,
	// DELETE_COMPLETE, or DELETE_FAILED.
	ResourcesToSkip []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to roll back the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique ID of the stack that you want to continue rolling
	// back.
	//
	// Don't specify the name of a nested stack (a stack that was created by using
	// the AWS::CloudFormation::Stack resource). Instead, use this operation on
	// the parent stack (the stack that contains the AWS::CloudFormation::Stack
	// resource).
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ContinueUpdateRollbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueUpdateRollbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinueUpdateRollbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinueUpdateRollbackInput"}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourcesToSkip sets the ResourcesToSkip field's value.
func (s *ContinueUpdateRollbackInput) SetResourcesToSkip(v []*string) *ContinueUpdateRollbackInput {
	s.ResourcesToSkip = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ContinueUpdateRollbackInput) SetRoleARN(v string) *ContinueUpdateRollbackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ContinueUpdateRollbackInput) SetStackName(v string) *ContinueUpdateRollbackInput {
	s.StackName = &v
	return s
}

// The output for a ContinueUpdateRollback action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ContinueUpdateRollbackOutput
type ContinueUpdateRollbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ContinueUpdateRollbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueUpdateRollbackOutput) GoString() string {
	return s.String()
}

// The input for the CreateChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSetInput
type CreateChangeSetInput struct {
	_ struct{} `type:"structure"`

	// A list of values that you must specify before AWS CloudFormation can update
	// certain stacks. Some stack templates might include resources that can affect
	// permissions in your AWS account, for example, by creating new AWS Identity
	// and Access Management (IAM) users. For those stacks, you must explicitly
	// acknowledge their capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following
	// resources require you to specify this parameter:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// all permissions associated with them and edit their permissions if necessary.
	//
	// If you have IAM resources, you can specify either capability. If you have
	// IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If
	// you don't specify this parameter, this action returns an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []*string `type:"list"`

	// The name of the change set. The name must be unique among all change sets
	// that are associated with the specified stack.
	//
	// A change set name can contain only alphanumeric, case sensitive characters
	// and hyphens. It must start with an alphabetic character and cannot exceed
	// 128 characters.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// The type of change set operation. To create a change set for a new stack,
	// specify CREATE. To create a change set for an existing stack, specify UPDATE.
	//
	// If you create a change set for a new stack, AWS Cloudformation creates a
	// stack with a unique stack ID, but no template or resources. The stack will
	// be in the REVIEW_IN_PROGRESS (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995)
	// state until you execute the change set.
	//
	// By default, AWS CloudFormation specifies UPDATE. You can't use the UPDATE
	// type to create a change set for a new stack or the CREATE type to create
	// a change set for an existing stack.
	ChangeSetType *string `type:"string" enum:"ChangeSetType"`

	// A unique identifier for this CreateChangeSet request. Specify this token
	// if you plan to retry requests so that AWS CloudFormation knows that you're
	// not attempting to create another change set with the same name. You might
	// retry CreateChangeSet requests to ensure that AWS CloudFormation successfully
	// received them.
	ClientToken *string `min:"1" type:"string"`

	// A description to help you identify this change set.
	Description *string `min:"1" type:"string"`

	// The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon
	// SNS) topics that AWS CloudFormation associates with the stack. To remove
	// all associated notification topics, specify an empty list.
	NotificationARNs []*string `type:"list"`

	// A list of Parameter structures that specify input parameters for the change
	// set. For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with if you
	// execute this change set, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	//
	// If the list of resource types doesn't include a resource type that you're
	// updating, the stack update fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for condition keys in IAM policies for AWS CloudFormation. For
	// more information, see Controlling Access with AWS Identity and Access Management
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html)
	// in the AWS CloudFormation User Guide.
	ResourceTypes []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes when executing the change set. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// uses this role for all future operations on the stack. As long as users have
	// permission to operate on the stack, AWS CloudFormation uses this role even
	// if the users don't have permission to pass it. Ensure that the role grants
	// least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique ID of the stack for which you are creating a change
	// set. AWS CloudFormation generates the change set by comparing this stack's
	// information with the information that you submit, such as a modified template
	// or different parameter input values.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to resources in the stack. You can specify a maximum of 10 tags.
	Tags []*Tag `type:"list"`

	// A structure that contains the body of the revised template, with a minimum
	// length of 1 byte and a maximum length of 51,200 bytes. AWS CloudFormation
	// generates the change set by comparing this template with the template of
	// the stack that you specified.
	//
	// Conditional: You must specify only TemplateBody or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// The location of the file that contains the revised template. The URL must
	// point to a template (max size: 460,800 bytes) that is located in an S3 bucket.
	// AWS CloudFormation generates the change set by comparing this template with
	// the stack that you specified.
	//
	// Conditional: You must specify only TemplateBody or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`

	// Whether to reuse the template that is associated with the stack to create
	// the change set.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateChangeSetInput) SetCapabilities(v []*string) *CreateChangeSetInput {
	s.Capabilities = v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *CreateChangeSetInput) SetChangeSetName(v string) *CreateChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetChangeSetType sets the ChangeSetType field's value.
func (s *CreateChangeSetInput) SetChangeSetType(v string) *CreateChangeSetInput {
	s.ChangeSetType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateChangeSetInput) SetClientToken(v string) *CreateChangeSetInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateChangeSetInput) SetDescription(v string) *CreateChangeSetInput {
	s.Description = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *CreateChangeSetInput) SetNotificationARNs(v []*string) *CreateChangeSetInput {
	s.NotificationARNs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateChangeSetInput) SetParameters(v []*Parameter) *CreateChangeSetInput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateChangeSetInput) SetResourceTypes(v []*string) *CreateChangeSetInput {
	s.ResourceTypes = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateChangeSetInput) SetRoleARN(v string) *CreateChangeSetInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateChangeSetInput) SetStackName(v string) *CreateChangeSetInput {
	s.StackName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChangeSetInput) SetTags(v []*Tag) *CreateChangeSetInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateChangeSetInput) SetTemplateBody(v string) *CreateChangeSetInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *CreateChangeSetInput) SetTemplateURL(v string) *CreateChangeSetInput {
	s.TemplateURL = &v
	return s
}

// SetUsePreviousTemplate sets the UsePreviousTemplate field's value.
func (s *CreateChangeSetInput) SetUsePreviousTemplate(v bool) *CreateChangeSetInput {
	s.UsePreviousTemplate = &v
	return s
}

// The output for the CreateChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSetOutput
type CreateChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the change set.
	Id *string `min:"1" type:"string"`

	// The unique ID of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CreateChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChangeSetOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateChangeSetOutput) SetId(v string) *CreateChangeSetOutput {
	s.Id = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateChangeSetOutput) SetStackId(v string) *CreateChangeSetOutput {
	s.StackId = &v
	return s
}

// The input for CreateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackInput
type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// A list of values that you must specify before AWS CloudFormation can create
	// certain stacks. Some stack templates might include resources that can affect
	// permissions in your AWS account, for example, by creating new AWS Identity
	// and Access Management (IAM) users. For those stacks, you must explicitly
	// acknowledge their capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following
	// resources require you to specify this parameter:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// all permissions associated with them and edit their permissions if necessary.
	//
	// If you have IAM resources, you can specify either capability. If you have
	// IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If
	// you don't specify this parameter, this action returns an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []*string `type:"list"`

	// Set to true to disable rollback of the stack if stack creation failed. You
	// can specify either DisableRollback or OnFailure, but not both.
	//
	// Default: false
	DisableRollback *bool `type:"boolean"`

	// The Simple Notification Service (SNS) topic ARNs to publish stack related
	// events. You can find your SNS topic ARNs using the SNS console (https://console.aws.amazon.com/sns)
	// or your Command Line Interface (CLI).
	NotificationARNs []*string `type:"list"`

	// Determines what action will be taken if stack creation fails. This must be
	// one of: DO_NOTHING, ROLLBACK, or DELETE. You can specify either OnFailure
	// or DisableRollback, but not both.
	//
	// Default: ROLLBACK
	OnFailure *string `type:"string" enum:"OnFailure"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// create stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	// Use the following syntax to describe template resource types: AWS::* (for
	// all AWS resource), Custom::* (for all custom resources), Custom::logical_ID
	// (for a specific custom resource), AWS::service_name::* (for all resources
	// of a particular AWS service), and AWS::service_name::resource_logical_ID
	// (for a specific AWS resource).
	//
	// If the list of resource types doesn't include a resource that you're creating,
	// the stack creation fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for AWS CloudFormation-specific condition keys in IAM policies.
	// For more information, see Controlling Access with AWS Identity and Access
	// Management (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	ResourceTypes []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to create the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name that is associated with the stack. The name must be unique in the
	// region in which you are creating the stack.
	//
	// A stack name can contain only alphanumeric characters (case sensitive) and
	// hyphens. It must start with an alphabetic character and cannot be longer
	// than 128 characters.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (maximum size: 16 KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to the resources created in the stack. A maximum number of 10
	// tags can be specified.
	Tags []*Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information, go to the Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// The amount of time that can pass before the stack status becomes CREATE_FAILED;
	// if DisableRollback is not set or is set to false, the stack will be rolled
	// back.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInput"}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyURL", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}
	if s.TimeoutInMinutes != nil && *s.TimeoutInMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInMinutes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateStackInput) SetCapabilities(v []*string) *CreateStackInput {
	s.Capabilities = v
	return s
}

// SetDisableRollback sets the DisableRollback field's value.
func (s *CreateStackInput) SetDisableRollback(v bool) *CreateStackInput {
	s.DisableRollback = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *CreateStackInput) SetNotificationARNs(v []*string) *CreateStackInput {
	s.NotificationARNs = v
	return s
}

// SetOnFailure sets the OnFailure field's value.
func (s *CreateStackInput) SetOnFailure(v string) *CreateStackInput {
	s.OnFailure = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateStackInput) SetParameters(v []*Parameter) *CreateStackInput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateStackInput) SetResourceTypes(v []*string) *CreateStackInput {
	s.ResourceTypes = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateStackInput) SetRoleARN(v string) *CreateStackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateStackInput) SetStackName(v string) *CreateStackInput {
	s.StackName = &v
	return s
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *CreateStackInput) SetStackPolicyBody(v string) *CreateStackInput {
	s.StackPolicyBody = &v
	return s
}

// SetStackPolicyURL sets the StackPolicyURL field's value.
func (s *CreateStackInput) SetStackPolicyURL(v string) *CreateStackInput {
	s.StackPolicyURL = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStackInput) SetTags(v []*Tag) *CreateStackInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateStackInput) SetTemplateBody(v string) *CreateStackInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *CreateStackInput) SetTemplateURL(v string) *CreateStackInput {
	s.TemplateURL = &v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *CreateStackInput) SetTimeoutInMinutes(v int64) *CreateStackInput {
	s.TimeoutInMinutes = &v
	return s
}

// The output for a CreateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateStackOutput
type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *CreateStackOutput) SetStackId(v string) *CreateStackOutput {
	s.StackId = &v
	return s
}

// The input for the DeleteChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSetInput
type DeleteChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// delete.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// If you specified the name of a change set to delete, specify the stack name
	// or ID (ARN) that is associated with it.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DeleteChangeSetInput) SetChangeSetName(v string) *DeleteChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DeleteChangeSetInput) SetStackName(v string) *DeleteChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the DeleteChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteChangeSetOutput
type DeleteChangeSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChangeSetOutput) GoString() string {
	return s.String()
}

// The input for DeleteStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackInput
type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// For stacks in the DELETE_FAILED state, a list of resource logical IDs that
	// are associated with the resources you want to retain. During deletion, AWS
	// CloudFormation deletes the stack but does not delete the retained resources.
	//
	// Retaining resources is useful when you cannot delete a resource, such as
	// a non-empty S3 bucket, but you want to delete the stack.
	RetainResources []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to delete the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or the unique stack ID that is associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInput"}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetainResources sets the RetainResources field's value.
func (s *DeleteStackInput) SetRetainResources(v []*string) *DeleteStackInput {
	s.RetainResources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *DeleteStackInput) SetRoleARN(v string) *DeleteStackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DeleteStackInput) SetStackName(v string) *DeleteStackInput {
	s.StackName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DeleteStackOutput
type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

// The input for the DescribeAccountLimits action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimitsInput
type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of limits that you want to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountLimitsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountLimitsInput) SetNextToken(v string) *DescribeAccountLimitsInput {
	s.NextToken = &v
	return s
}

// The output for the DescribeAccountLimits action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeAccountLimitsOutput
type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	// An account limit structure that contain a list of AWS CloudFormation account
	// limits and their values.
	AccountLimits []*AccountLimit `type:"list"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of limits. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

// SetAccountLimits sets the AccountLimits field's value.
func (s *DescribeAccountLimitsOutput) SetAccountLimits(v []*AccountLimit) *DescribeAccountLimitsOutput {
	s.AccountLimits = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountLimitsOutput) SetNextToken(v string) *DescribeAccountLimitsOutput {
	s.NextToken = &v
	return s
}

// The input for the DescribeChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetInput
type DescribeChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the change set that you want to
	// describe.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// A string (provided by the DescribeChangeSet response output) that identifies
	// the next page of information that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// If you specified the name of a change set, specify the stack name or ID (ARN)
	// of the change set you want to describe.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetInput) SetChangeSetName(v string) *DescribeChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChangeSetInput) SetNextToken(v string) *DescribeChangeSetInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeChangeSetInput) SetStackName(v string) *DescribeChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the DescribeChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeChangeSetOutput
type DescribeChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// If you execute the change set, the list of capabilities that were explicitly
	// acknowledged when the change set was created.
	Capabilities []*string `type:"list"`

	// The ARN of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The name of the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// A list of Change structures that describes the resources AWS CloudFormation
	// changes if you execute the change set.
	Changes []*Change `type:"list"`

	// The start time when the change set was created, in UTC.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Information about the change set.
	Description *string `min:"1" type:"string"`

	// If the change set execution status is AVAILABLE, you can execute the change
	// set. If you can’t execute the change set, the status indicates why. For example,
	// a change set might be in an UNAVAILABLE state because AWS CloudFormation
	// is still creating it or in an OBSOLETE state because the stack was already
	// updated.
	ExecutionStatus *string `type:"string" enum:"ExecutionStatus"`

	// If the output exceeds 1 MB, a string that identifies the next page of changes.
	// If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The ARNs of the Amazon Simple Notification Service (Amazon SNS) topics that
	// will be associated with the stack if you execute the change set.
	NotificationARNs []*string `type:"list"`

	// A list of Parameter structures that describes the input parameters and their
	// values used to create the change set. For more information, see the Parameter
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The ARN of the stack that is associated with the change set.
	StackId *string `type:"string"`

	// The name of the stack that is associated with the change set.
	StackName *string `type:"string"`

	// The current status of the change set, such as CREATE_IN_PROGRESS, CREATE_COMPLETE,
	// or FAILED.
	Status *string `type:"string" enum:"ChangeSetStatus"`

	// A description of the change set's status. For example, if your attempt to
	// create a change set failed, AWS CloudFormation shows the error message.
	StatusReason *string `type:"string"`

	// If you execute the change set, the tags that will be associated with the
	// stack.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribeChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChangeSetOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *DescribeChangeSetOutput) SetCapabilities(v []*string) *DescribeChangeSetOutput {
	s.Capabilities = v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *DescribeChangeSetOutput) SetChangeSetId(v string) *DescribeChangeSetOutput {
	s.ChangeSetId = &v
	return s
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *DescribeChangeSetOutput) SetChangeSetName(v string) *DescribeChangeSetOutput {
	s.ChangeSetName = &v
	return s
}

// SetChanges sets the Changes field's value.
func (s *DescribeChangeSetOutput) SetChanges(v []*Change) *DescribeChangeSetOutput {
	s.Changes = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeChangeSetOutput) SetCreationTime(v time.Time) *DescribeChangeSetOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeChangeSetOutput) SetDescription(v string) *DescribeChangeSetOutput {
	s.Description = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *DescribeChangeSetOutput) SetExecutionStatus(v string) *DescribeChangeSetOutput {
	s.ExecutionStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeChangeSetOutput) SetNextToken(v string) *DescribeChangeSetOutput {
	s.NextToken = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *DescribeChangeSetOutput) SetNotificationARNs(v []*string) *DescribeChangeSetOutput {
	s.NotificationARNs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeChangeSetOutput) SetParameters(v []*Parameter) *DescribeChangeSetOutput {
	s.Parameters = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeChangeSetOutput) SetStackId(v string) *DescribeChangeSetOutput {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeChangeSetOutput) SetStackName(v string) *DescribeChangeSetOutput {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeChangeSetOutput) SetStatus(v string) *DescribeChangeSetOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeChangeSetOutput) SetStatusReason(v string) *DescribeChangeSetOutput {
	s.StatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeChangeSetOutput) SetTags(v []*Tag) *DescribeChangeSetOutput {
	s.Tags = v
	return s
}

// The input for DescribeStackEvents action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEventsInput
type DescribeStackEventsInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of events that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackEventsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackEventsInput) SetNextToken(v string) *DescribeStackEventsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackEventsInput) SetStackName(v string) *DescribeStackEventsInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackEvents action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackEventsOutput
type DescribeStackEventsOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of events. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackEvents structures.
	StackEvents []*StackEvent `type:"list"`
}

// String returns the string representation
func (s DescribeStackEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStackEventsOutput) SetNextToken(v string) *DescribeStackEventsOutput {
	s.NextToken = &v
	return s
}

// SetStackEvents sets the StackEvents field's value.
func (s *DescribeStackEventsOutput) SetStackEvents(v []*StackEvent) *DescribeStackEventsOutput {
	s.StackEvents = v
	return s
}

// The input for DescribeStackResource action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceInput
type DescribeStackResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackResourceInput"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DescribeStackResourceInput) SetLogicalResourceId(v string) *DescribeStackResourceInput {
	s.LogicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackResourceInput) SetStackName(v string) *DescribeStackResourceInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackResource action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceOutput
type DescribeStackResourceOutput struct {
	_ struct{} `type:"structure"`

	// A StackResourceDetail structure containing the description of the specified
	// resource in the specified stack.
	StackResourceDetail *StackResourceDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeStackResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceOutput) GoString() string {
	return s.String()
}

// SetStackResourceDetail sets the StackResourceDetail field's value.
func (s *DescribeStackResourceOutput) SetStackResourceDetail(v *StackResourceDetail) *DescribeStackResourceOutput {
	s.StackResourceDetail = v
	return s
}

// The input for DescribeStackResources action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourcesInput
type DescribeStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	//
	// For example, for an Amazon Elastic Compute Cloud (EC2) instance, PhysicalResourceId
	// corresponds to the InstanceId. You can pass the EC2 InstanceId to DescribeStackResources
	// to find which stack the instance belongs to and what other resources are
	// part of the stack.
	//
	// Required: Conditional. If you do not specify PhysicalResourceId, you must
	// specify StackName.
	//
	// Default: There is no default value.
	PhysicalResourceId *string `type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// Required: Conditional. If you do not specify StackName, you must specify
	// PhysicalResourceId.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesInput) GoString() string {
	return s.String()
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *DescribeStackResourcesInput) SetLogicalResourceId(v string) *DescribeStackResourcesInput {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *DescribeStackResourcesInput) SetPhysicalResourceId(v string) *DescribeStackResourcesInput {
	s.PhysicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStackResourcesInput) SetStackName(v string) *DescribeStackResourcesInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStackResources action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourcesOutput
type DescribeStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of StackResource structures.
	StackResources []*StackResource `type:"list"`
}

// String returns the string representation
func (s DescribeStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesOutput) GoString() string {
	return s.String()
}

// SetStackResources sets the StackResources field's value.
func (s *DescribeStackResourcesOutput) SetStackResources(v []*StackResource) *DescribeStackResourcesOutput {
	s.StackResources = v
	return s
}

// The input for DescribeStacks action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacksInput
type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksInput) SetNextToken(v string) *DescribeStacksInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeStacksInput) SetStackName(v string) *DescribeStacksInput {
	s.StackName = &v
	return s
}

// The output for a DescribeStacks action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStacksOutput
type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of stack structures.
	Stacks []*Stack `type:"list"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksOutput) SetNextToken(v string) *DescribeStacksOutput {
	s.NextToken = &v
	return s
}

// SetStacks sets the Stacks field's value.
func (s *DescribeStacksOutput) SetStacks(v []*Stack) *DescribeStacksOutput {
	s.Stacks = v
	return s
}

// The input for an EstimateTemplateCost action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCostInput
type EstimateTemplateCostInput struct {
	_ struct{} `type:"structure"`

	// A list of Parameter structures that specify input parameters.
	Parameters []*Parameter `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must pass TemplateBody or TemplateURL. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that is located in an Amazon S3 bucket. For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EstimateTemplateCostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EstimateTemplateCostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EstimateTemplateCostInput"}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *EstimateTemplateCostInput) SetParameters(v []*Parameter) *EstimateTemplateCostInput {
	s.Parameters = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *EstimateTemplateCostInput) SetTemplateBody(v string) *EstimateTemplateCostInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *EstimateTemplateCostInput) SetTemplateURL(v string) *EstimateTemplateCostInput {
	s.TemplateURL = &v
	return s
}

// The output for a EstimateTemplateCost action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/EstimateTemplateCostOutput
type EstimateTemplateCostOutput struct {
	_ struct{} `type:"structure"`

	// An AWS Simple Monthly Calculator URL with a query string that describes the
	// resources required to run the template.
	Url *string `type:"string"`
}

// String returns the string representation
func (s EstimateTemplateCostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostOutput) GoString() string {
	return s.String()
}

// SetUrl sets the Url field's value.
func (s *EstimateTemplateCostOutput) SetUrl(v string) *EstimateTemplateCostOutput {
	s.Url = &v
	return s
}

// The input for the ExecuteChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSetInput
type ExecuteChangeSetInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the change set that you want use to update the specified
	// stack.
	//
	// ChangeSetName is a required field
	ChangeSetName *string `min:"1" type:"string" required:"true"`

	// If you specified the name of a change set, specify the stack name or ID (ARN)
	// that is associated with the change set you want to execute.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ExecuteChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecuteChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecuteChangeSetInput"}
	if s.ChangeSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeSetName"))
	}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *ExecuteChangeSetInput) SetChangeSetName(v string) *ExecuteChangeSetInput {
	s.ChangeSetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ExecuteChangeSetInput) SetStackName(v string) *ExecuteChangeSetInput {
	s.StackName = &v
	return s
}

// The output for the ExecuteChangeSet action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ExecuteChangeSetOutput
type ExecuteChangeSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExecuteChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecuteChangeSetOutput) GoString() string {
	return s.String()
}

// The Export structure describes the exported output values for a stack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Export
type Export struct {
	_ struct{} `type:"structure"`

	// The stack that contains the exported output name and value.
	ExportingStackId *string `type:"string"`

	// The name of exported output value. Use this name and the Fn::ImportValue
	// function to import the associated value into other stacks. The name is defined
	// in the Export field in the associated stack's Outputs section.
	Name *string `type:"string"`

	// The value of the exported output, such as a resource physical ID. This value
	// is defined in the Export field in the associated stack's Outputs section.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Export) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Export) GoString() string {
	return s.String()
}

// SetExportingStackId sets the ExportingStackId field's value.
func (s *Export) SetExportingStackId(v string) *Export {
	s.ExportingStackId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Export) SetName(v string) *Export {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Export) SetValue(v string) *Export {
	s.Value = &v
	return s
}

// The input for the GetStackPolicy action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicyInput
type GetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that is associated with the stack whose policy
	// you want to get.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStackPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStackPolicyInput"}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *GetStackPolicyInput) SetStackName(v string) *GetStackPolicyInput {
	s.StackName = &v
	return s
}

// The output for the GetStackPolicy action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetStackPolicyOutput
type GetStackPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Structure containing the stack policy body. (For more information, go to
	//  Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide.)
	StackPolicyBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyOutput) GoString() string {
	return s.String()
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *GetStackPolicyOutput) SetStackPolicyBody(v string) *GetStackPolicyOutput {
	s.StackPolicyBody = &v
	return s
}

// The input for a GetTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateInput
type GetTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of a change set for which AWS CloudFormation
	// returns the associated template. If you specify a name, you must also specify
	// the StackName.
	ChangeSetName *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	StackName *string `type:"string"`

	// For templates that include transforms, the stage of the template that AWS
	// CloudFormation returns. To get the user-submitted template, specify Original.
	// To get the template after AWS CloudFormation has processed all transforms,
	// specify Processed.
	//
	// If the template doesn't include transforms, Original and Processed return
	// the same template. By default, AWS CloudFormation specifies Original.
	TemplateStage *string `type:"string" enum:"TemplateStage"`
}

// String returns the string representation
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateInput"}
	if s.ChangeSetName != nil && len(*s.ChangeSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeSetName sets the ChangeSetName field's value.
func (s *GetTemplateInput) SetChangeSetName(v string) *GetTemplateInput {
	s.ChangeSetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *GetTemplateInput) SetStackName(v string) *GetTemplateInput {
	s.StackName = &v
	return s
}

// SetTemplateStage sets the TemplateStage field's value.
func (s *GetTemplateInput) SetTemplateStage(v string) *GetTemplateInput {
	s.TemplateStage = &v
	return s
}

// The output for GetTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateOutput
type GetTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The stage of the template that you can retrieve. For stacks, the Original
	// and Processed templates are always available. For change sets, the Original
	// template is always available. After AWS CloudFormation finishes creating
	// the change set, the Processed template becomes available.
	StagesAvailable []*string `type:"list"`

	// Structure containing the template body. (For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// AWS CloudFormation returns the same template that was used when the stack
	// was created.
	TemplateBody *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// SetStagesAvailable sets the StagesAvailable field's value.
func (s *GetTemplateOutput) SetStagesAvailable(v []*string) *GetTemplateOutput {
	s.StagesAvailable = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *GetTemplateOutput) SetTemplateBody(v string) *GetTemplateOutput {
	s.TemplateBody = &v
	return s
}

// The input for the GetTemplateSummary action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummaryInput
type GetTemplateSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name or the stack ID that is associated with the stack, which are not
	// always interchangeable. For running stacks, you can specify either the stack's
	// name or its unique stack ID. For deleted stack, you must specify the unique
	// stack ID.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	StackName *string `min:"1" type:"string"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information about templates, see
	// Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information about templates, see Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTemplateSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateSummaryInput"}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *GetTemplateSummaryInput) SetStackName(v string) *GetTemplateSummaryInput {
	s.StackName = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *GetTemplateSummaryInput) SetTemplateBody(v string) *GetTemplateSummaryInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *GetTemplateSummaryInput) SetTemplateURL(v string) *GetTemplateSummaryInput {
	s.TemplateURL = &v
	return s
}

// The output for the GetTemplateSummary action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/GetTemplateSummaryOutput
type GetTemplateSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The capabilities found within the template. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value
	// for this parameter when you use the CreateStack or UpdateStack actions with
	// your template; otherwise, those actions return an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []*string `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// A list of the transforms that are declared in the template.
	DeclaredTransforms []*string `type:"list"`

	// The value that is defined in the Description property of the template.
	Description *string `min:"1" type:"string"`

	// The value that is defined for the Metadata property of the template.
	Metadata *string `type:"string"`

	// A list of parameter declarations that describe various properties for each
	// parameter.
	Parameters []*ParameterDeclaration `type:"list"`

	// A list of all the template resource types that are defined in the template,
	// such as AWS::EC2::Instance, AWS::Dynamo::Table, and Custom::MyCustomInstance.
	ResourceTypes []*string `type:"list"`

	// The AWS template format version, which identifies the capabilities of the
	// template.
	Version *string `type:"string"`
}

// String returns the string representation
func (s GetTemplateSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *GetTemplateSummaryOutput) SetCapabilities(v []*string) *GetTemplateSummaryOutput {
	s.Capabilities = v
	return s
}

// SetCapabilitiesReason sets the CapabilitiesReason field's value.
func (s *GetTemplateSummaryOutput) SetCapabilitiesReason(v string) *GetTemplateSummaryOutput {
	s.CapabilitiesReason = &v
	return s
}

// SetDeclaredTransforms sets the DeclaredTransforms field's value.
func (s *GetTemplateSummaryOutput) SetDeclaredTransforms(v []*string) *GetTemplateSummaryOutput {
	s.DeclaredTransforms = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTemplateSummaryOutput) SetDescription(v string) *GetTemplateSummaryOutput {
	s.Description = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetTemplateSummaryOutput) SetMetadata(v string) *GetTemplateSummaryOutput {
	s.Metadata = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetTemplateSummaryOutput) SetParameters(v []*ParameterDeclaration) *GetTemplateSummaryOutput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetTemplateSummaryOutput) SetResourceTypes(v []*string) *GetTemplateSummaryOutput {
	s.ResourceTypes = v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetTemplateSummaryOutput) SetVersion(v string) *GetTemplateSummaryOutput {
	s.Version = &v
	return s
}

// The input for the ListChangeSets action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSetsInput
type ListChangeSetsInput struct {
	_ struct{} `type:"structure"`

	// A string (provided by the ListChangeSets response output) that identifies
	// the next page of change sets that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the Amazon Resource Name (ARN) of the stack for which you want
	// to list change sets.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListChangeSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChangeSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChangeSetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsInput) SetNextToken(v string) *ListChangeSetsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListChangeSetsInput) SetStackName(v string) *ListChangeSetsInput {
	s.StackName = &v
	return s
}

// The output for the ListChangeSets action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSetsOutput
type ListChangeSetsOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB, a string that identifies the next page of change
	// sets. If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of ChangeSetSummary structures that provides the ID and status of
	// each change set for the specified stack.
	Summaries []*ChangeSetSummary `type:"list"`
}

// String returns the string representation
func (s ListChangeSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChangeSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListChangeSetsOutput) SetNextToken(v string) *ListChangeSetsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *ListChangeSetsOutput) SetSummaries(v []*ChangeSetSummary) *ListChangeSetsOutput {
	s.Summaries = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExportsInput
type ListExportsInput struct {
	_ struct{} `type:"structure"`

	// A string (provided by the ListExports response output) that identifies the
	// next page of exported output values that you asked to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListExportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListExportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListExportsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsInput) SetNextToken(v string) *ListExportsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListExportsOutput
type ListExportsOutput struct {
	_ struct{} `type:"structure"`

	// The output for the ListExports action.
	Exports []*Export `type:"list"`

	// If the output exceeds 100 exported output values, a string that identifies
	// the next page of exports. If there is no additional page, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListExportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListExportsOutput) GoString() string {
	return s.String()
}

// SetExports sets the Exports field's value.
func (s *ListExportsOutput) SetExports(v []*Export) *ListExportsOutput {
	s.Exports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListExportsOutput) SetNextToken(v string) *ListExportsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImportsInput
type ListImportsInput struct {
	_ struct{} `type:"structure"`

	// The name of the exported output value. AWS CloudFormation returns the stack
	// names that are importing this value.
	//
	// ExportName is a required field
	ExportName *string `type:"string" required:"true"`

	// A string (provided by the ListImports response output) that identifies the
	// next page of stacks that are importing the specified exported output value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListImportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImportsInput"}
	if s.ExportName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportName"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportName sets the ExportName field's value.
func (s *ListImportsInput) SetExportName(v string) *ListImportsInput {
	s.ExportName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportsInput) SetNextToken(v string) *ListImportsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListImportsOutput
type ListImportsOutput struct {
	_ struct{} `type:"structure"`

	// A list of stack names that are importing the specified exported output value.
	Imports []*string `type:"list"`

	// A string that identifies the next page of exports. If there is no additional
	// page, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListImportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImportsOutput) GoString() string {
	return s.String()
}

// SetImports sets the Imports field's value.
func (s *ListImportsOutput) SetImports(v []*string) *ListImportsOutput {
	s.Imports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportsOutput) SetNextToken(v string) *ListImportsOutput {
	s.NextToken = &v
	return s
}

// The input for the ListStackResource action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResourcesInput
type ListStackResourcesInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stack resources that you want to
	// retrieve.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//    * Running stacks: You can specify either the stack's name or its unique
	//    stack ID.
	//
	//    * Deleted stacks: You must specify the unique stack ID.
	//
	// Default: There is no default value.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStackResourcesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackResourcesInput) SetNextToken(v string) *ListStackResourcesInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListStackResourcesInput) SetStackName(v string) *ListStackResourcesInput {
	s.StackName = &v
	return s
}

// The output for a ListStackResources action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStackResourcesOutput
type ListStackResourcesOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB, a string that identifies the next page of stack
	// resources. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackResourceSummary structures.
	StackResourceSummaries []*StackResourceSummary `type:"list"`
}

// String returns the string representation
func (s ListStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStackResourcesOutput) SetNextToken(v string) *ListStackResourcesOutput {
	s.NextToken = &v
	return s
}

// SetStackResourceSummaries sets the StackResourceSummaries field's value.
func (s *ListStackResourcesOutput) SetStackResourceSummaries(v []*StackResourceSummary) *ListStackResourcesOutput {
	s.StackResourceSummaries = v
	return s
}

// The input for ListStacks action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacksInput
type ListStacksInput struct {
	_ struct{} `type:"structure"`

	// A string that identifies the next page of stacks that you want to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Stack status to use as a filter. Specify one or more stack status codes to
	// list only stacks with the specified status codes. For a complete list of
	// stack status codes, see the StackStatus parameter of the Stack data type.
	StackStatusFilter []*string `type:"list"`
}

// String returns the string representation
func (s ListStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListStacksInput) SetNextToken(v string) *ListStacksInput {
	s.NextToken = &v
	return s
}

// SetStackStatusFilter sets the StackStatusFilter field's value.
func (s *ListStacksInput) SetStackStatusFilter(v []*string) *ListStacksInput {
	s.StackStatusFilter = v
	return s
}

// The output for ListStacks action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListStacksOutput
type ListStacksOutput struct {
	_ struct{} `type:"structure"`

	// If the output exceeds 1 MB in size, a string that identifies the next page
	// of stacks. If no additional page exists, this value is null.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSummary structures containing information about the specified
	// stacks.
	StackSummaries []*StackSummary `type:"list"`
}

// String returns the string representation
func (s ListStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStacksOutput) SetNextToken(v string) *ListStacksOutput {
	s.NextToken = &v
	return s
}

// SetStackSummaries sets the StackSummaries field's value.
func (s *ListStacksOutput) SetStackSummaries(v []*StackSummary) *ListStacksOutput {
	s.StackSummaries = v
	return s
}

// The Output data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Output
type Output struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the output.
	Description *string `min:"1" type:"string"`

	// The key associated with the output.
	OutputKey *string `type:"string"`

	// The value associated with the output.
	OutputValue *string `type:"string"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Output) SetDescription(v string) *Output {
	s.Description = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *Output) SetOutputKey(v string) *Output {
	s.OutputKey = &v
	return s
}

// SetOutputValue sets the OutputValue field's value.
func (s *Output) SetOutputValue(v string) *Output {
	s.OutputValue = &v
	return s
}

// The Parameter data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Parameter
type Parameter struct {
	_ struct{} `type:"structure"`

	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, AWS CloudFormation uses the default value that
	// is specified in your template.
	ParameterKey *string `type:"string"`

	// The value associated with the parameter.
	ParameterValue *string `type:"string"`

	// During a stack update, use the existing parameter value that the stack is
	// using for a given parameter key. If you specify true, do not specify a parameter
	// value.
	UsePreviousValue *bool `type:"boolean"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetParameterKey sets the ParameterKey field's value.
func (s *Parameter) SetParameterKey(v string) *Parameter {
	s.ParameterKey = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetUsePreviousValue sets the UsePreviousValue field's value.
func (s *Parameter) SetUsePreviousValue(v bool) *Parameter {
	s.UsePreviousValue = &v
	return s
}

// A set of criteria that AWS CloudFormation uses to validate parameter values.
// Although other constraints might be defined in the stack template, AWS CloudFormation
// returns only the AllowedValues property.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ParameterConstraints
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// A list of values that are permitted for a parameter.
	AllowedValues []*string `type:"list"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *ParameterConstraints) SetAllowedValues(v []*string) *ParameterConstraints {
	s.AllowedValues = v
	return s
}

// The ParameterDeclaration data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ParameterDeclaration
type ParameterDeclaration struct {
	_ struct{} `type:"structure"`

	// The default value of the parameter.
	DefaultValue *string `type:"string"`

	// The description that is associate with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag that indicates whether the parameter value is shown as plain text in
	// logs and in the AWS Management Console.
	NoEcho *bool `type:"boolean"`

	// The criteria that AWS CloudFormation uses to validate parameter values.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The name that is associated with the parameter.
	ParameterKey *string `type:"string"`

	// The type of parameter.
	ParameterType *string `type:"string"`
}

// String returns the string representation
func (s ParameterDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterDeclaration) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ParameterDeclaration) SetDefaultValue(v string) *ParameterDeclaration {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ParameterDeclaration) SetDescription(v string) *ParameterDeclaration {
	s.Description = &v
	return s
}

// SetNoEcho sets the NoEcho field's value.
func (s *ParameterDeclaration) SetNoEcho(v bool) *ParameterDeclaration {
	s.NoEcho = &v
	return s
}

// SetParameterConstraints sets the ParameterConstraints field's value.
func (s *ParameterDeclaration) SetParameterConstraints(v *ParameterConstraints) *ParameterDeclaration {
	s.ParameterConstraints = v
	return s
}

// SetParameterKey sets the ParameterKey field's value.
func (s *ParameterDeclaration) SetParameterKey(v string) *ParameterDeclaration {
	s.ParameterKey = &v
	return s
}

// SetParameterType sets the ParameterType field's value.
func (s *ParameterDeclaration) SetParameterType(v string) *ParameterDeclaration {
	s.ParameterType = &v
	return s
}

// The ResourceChange structure describes the resource and the action that AWS
// CloudFormation will perform on it if you execute this change set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceChange
type ResourceChange struct {
	_ struct{} `type:"structure"`

	// The action that AWS CloudFormation takes on the resource, such as Add (adds
	// a new resource), Modify (changes a resource), or Remove (deletes a resource).
	Action *string `type:"string" enum:"ChangeAction"`

	// For the Modify action, a list of ResourceChangeDetail structures that describes
	// the changes that AWS CloudFormation will make to the resource.
	Details []*ResourceChangeDetail `type:"list"`

	// The resource's logical ID, which is defined in the stack's template.
	LogicalResourceId *string `type:"string"`

	// The resource's physical ID (resource name). Resources that you are adding
	// don't have physical IDs because they haven't been created.
	PhysicalResourceId *string `type:"string"`

	// For the Modify action, indicates whether AWS CloudFormation will replace
	// the resource by creating a new one and deleting the old one. This value depends
	// on the value of the RequiresRecreation property in the ResourceTargetDefinition
	// structure. For example, if the RequiresRecreation field is Always and the
	// Evaluation field is Static, Replacement is True. If the RequiresRecreation
	// field is Always and the Evaluation field is Dynamic, Replacement is Conditionally.
	//
	// If you have multiple changes with different RequiresRecreation values, the
	// Replacement value depends on the change with the most impact. A RequiresRecreation
	// value of Always has the most impact, followed by Conditionally, and then
	// Never.
	Replacement *string `type:"string" enum:"Replacement"`

	// The type of AWS CloudFormation resource, such as AWS::S3::Bucket.
	ResourceType *string `min:"1" type:"string"`

	// For the Modify action, indicates which resource attribute is triggering this
	// update, such as a change in the resource attribute's Metadata, Properties,
	// or Tags.
	Scope []*string `type:"list"`
}

// String returns the string representation
func (s ResourceChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceChange) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ResourceChange) SetAction(v string) *ResourceChange {
	s.Action = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ResourceChange) SetDetails(v []*ResourceChangeDetail) *ResourceChange {
	s.Details = v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *ResourceChange) SetLogicalResourceId(v string) *ResourceChange {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *ResourceChange) SetPhysicalResourceId(v string) *ResourceChange {
	s.PhysicalResourceId = &v
	return s
}

// SetReplacement sets the Replacement field's value.
func (s *ResourceChange) SetReplacement(v string) *ResourceChange {
	s.Replacement = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceChange) SetResourceType(v string) *ResourceChange {
	s.ResourceType = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ResourceChange) SetScope(v []*string) *ResourceChange {
	s.Scope = v
	return s
}

// For a resource with Modify as the action, the ResourceChange structure describes
// the changes AWS CloudFormation will make to that resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceChangeDetail
type ResourceChangeDetail struct {
	_ struct{} `type:"structure"`

	// The identity of the entity that triggered this change. This entity is a member
	// of the group that is specified by the ChangeSource field. For example, if
	// you modified the value of the KeyPairName parameter, the CausingEntity is
	// the name of the parameter (KeyPairName).
	//
	// If the ChangeSource value is DirectModification, no value is given for CausingEntity.
	CausingEntity *string `type:"string"`

	// The group to which the CausingEntity value belongs. There are five entity
	// groups:
	//
	//    * ResourceReference entities are Ref intrinsic functions that refer to
	//    resources in the template, such as { "Ref" : "MyEC2InstanceResource" }.
	//
	//    * ParameterReference entities are Ref intrinsic functions that get template
	//    parameter values, such as { "Ref" : "MyPasswordParameter" }.
	//
	//    * ResourceAttribute entities are Fn::GetAtt intrinsic functions that get
	//    resource attribute values, such as { "Fn::GetAtt" : [ "MyEC2InstanceResource",
	//    "PublicDnsName" ] }.
	//
	//    * DirectModification entities are changes that are made directly to the
	//    template.
	//
	//    * Automatic entities are AWS::CloudFormation::Stack resource types, which
	//    are also known as nested stacks. If you made no changes to the AWS::CloudFormation::Stack
	//    resource, AWS CloudFormation sets the ChangeSource to Automatic because
	//    the nested stack's template might have changed. Changes to a nested stack's
	//    template aren't visible to AWS CloudFormation until you run an update
	//    on the parent stack.
	ChangeSource *string `type:"string" enum:"ChangeSource"`

	// Indicates whether AWS CloudFormation can determine the target value, and
	// whether the target value will change before you execute a change set.
	//
	// For Static evaluations, AWS CloudFormation can determine that the target
	// value will change, and its value. For example, if you directly modify the
	// InstanceType property of an EC2 instance, AWS CloudFormation knows that this
	// property value will change, and its value, so this is a Static evaluation.
	//
	// For Dynamic evaluations, cannot determine the target value because it depends
	// on the result of an intrinsic function, such as a Ref or Fn::GetAtt intrinsic
	// function, when the stack is updated. For example, if your template includes
	// a reference to a resource that is conditionally recreated, the value of the
	// reference (the physical ID of the resource) might change, depending on if
	// the resource is recreated. If the resource is recreated, it will have a new
	// physical ID, so all references to that resource will also be updated.
	Evaluation *string `type:"string" enum:"EvaluationType"`

	// A ResourceTargetDefinition structure that describes the field that AWS CloudFormation
	// will change and whether the resource will be recreated.
	Target *ResourceTargetDefinition `type:"structure"`
}

// String returns the string representation
func (s ResourceChangeDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceChangeDetail) GoString() string {
	return s.String()
}

// SetCausingEntity sets the CausingEntity field's value.
func (s *ResourceChangeDetail) SetCausingEntity(v string) *ResourceChangeDetail {
	s.CausingEntity = &v
	return s
}

// SetChangeSource sets the ChangeSource field's value.
func (s *ResourceChangeDetail) SetChangeSource(v string) *ResourceChangeDetail {
	s.ChangeSource = &v
	return s
}

// SetEvaluation sets the Evaluation field's value.
func (s *ResourceChangeDetail) SetEvaluation(v string) *ResourceChangeDetail {
	s.Evaluation = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ResourceChangeDetail) SetTarget(v *ResourceTargetDefinition) *ResourceChangeDetail {
	s.Target = v
	return s
}

// The field that AWS CloudFormation will change, such as the name of a resource's
// property, and whether the resource will be recreated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ResourceTargetDefinition
type ResourceTargetDefinition struct {
	_ struct{} `type:"structure"`

	// Indicates which resource attribute is triggering this update, such as a change
	// in the resource attribute's Metadata, Properties, or Tags.
	Attribute *string `type:"string" enum:"ResourceAttribute"`

	// If the Attribute value is Properties, the name of the property. For all other
	// attributes, the value is null.
	Name *string `type:"string"`

	// If the Attribute value is Properties, indicates whether a change to this
	// property causes the resource to be recreated. The value can be Never, Always,
	// or Conditionally. To determine the conditions for a Conditionally recreation,
	// see the update behavior for that property (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	RequiresRecreation *string `type:"string" enum:"RequiresRecreation"`
}

// String returns the string representation
func (s ResourceTargetDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTargetDefinition) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *ResourceTargetDefinition) SetAttribute(v string) *ResourceTargetDefinition {
	s.Attribute = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceTargetDefinition) SetName(v string) *ResourceTargetDefinition {
	s.Name = &v
	return s
}

// SetRequiresRecreation sets the RequiresRecreation field's value.
func (s *ResourceTargetDefinition) SetRequiresRecreation(v string) *ResourceTargetDefinition {
	s.RequiresRecreation = &v
	return s
}

// The input for the SetStackPolicy action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicyInput
type SetStackPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or unique stack ID that you want to associate a policy with.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (maximum size: 16 KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetStackPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetStackPolicyInput"}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackName sets the StackName field's value.
func (s *SetStackPolicyInput) SetStackName(v string) *SetStackPolicyInput {
	s.StackName = &v
	return s
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *SetStackPolicyInput) SetStackPolicyBody(v string) *SetStackPolicyInput {
	s.StackPolicyBody = &v
	return s
}

// SetStackPolicyURL sets the StackPolicyURL field's value.
func (s *SetStackPolicyInput) SetStackPolicyURL(v string) *SetStackPolicyInput {
	s.StackPolicyURL = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SetStackPolicyOutput
type SetStackPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyOutput) GoString() string {
	return s.String()
}

// The input for the SignalResource action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResourceInput
type SignalResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical ID of the resource that you want to signal. The logical ID is
	// the name of the resource that given in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The stack name or unique stack ID that includes the resource that you want
	// to signal.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The status of the signal, which is either success or failure. A failure signal
	// causes AWS CloudFormation to immediately fail the stack creation or update.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ResourceSignalStatus"`

	// A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
	// groups, specify the instance ID that you are signaling as the unique ID.
	// If you send multiple signals to a single resource (such as signaling a wait
	// condition), each signal requires a different unique ID.
	//
	// UniqueId is a required field
	UniqueId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignalResourceInput"}
	if s.LogicalResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("LogicalResourceId"))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.UniqueId == nil {
		invalidParams.Add(request.NewErrParamRequired("UniqueId"))
	}
	if s.UniqueId != nil && len(*s.UniqueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UniqueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *SignalResourceInput) SetLogicalResourceId(v string) *SignalResourceInput {
	s.LogicalResourceId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *SignalResourceInput) SetStackName(v string) *SignalResourceInput {
	s.StackName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SignalResourceInput) SetStatus(v string) *SignalResourceInput {
	s.Status = &v
	return s
}

// SetUniqueId sets the UniqueId field's value.
func (s *SignalResourceInput) SetUniqueId(v string) *SignalResourceInput {
	s.UniqueId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResourceOutput
type SignalResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignalResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceOutput) GoString() string {
	return s.String()
}

// The Stack data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Stack
type Stack struct {
	_ struct{} `type:"structure"`

	// The capabilities allowed in the stack.
	Capabilities []*string `type:"list"`

	// The unique ID of the change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The time at which the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A user-defined description associated with the stack.
	Description *string `min:"1" type:"string"`

	// Boolean to enable or disable rollback on stack creation failures:
	//
	//    * true: disable rollback
	//
	//    * false: enable rollback
	DisableRollback *bool `type:"boolean"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// SNS topic ARNs to which stack related events are published.
	NotificationARNs []*string `type:"list"`

	// A list of output structures.
	Outputs []*Output `type:"list"`

	// A list of Parameter structures.
	Parameters []*Parameter `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that is associated with the stack. During a stack operation, AWS CloudFormation
	// uses this role's credentials to make calls on your behalf.
	RoleARN *string `min:"20" type:"string"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Current status of the stack.
	//
	// StackStatus is a required field
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// A list of Tags that specify information about the stack.
	Tags []*Tag `type:"list"`

	// The amount of time within which stack creation should complete.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *Stack) SetCapabilities(v []*string) *Stack {
	s.Capabilities = v
	return s
}

// SetChangeSetId sets the ChangeSetId field's value.
func (s *Stack) SetChangeSetId(v string) *Stack {
	s.ChangeSetId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Stack) SetCreationTime(v time.Time) *Stack {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Stack) SetDescription(v string) *Stack {
	s.Description = &v
	return s
}

// SetDisableRollback sets the DisableRollback field's value.
func (s *Stack) SetDisableRollback(v bool) *Stack {
	s.DisableRollback = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Stack) SetLastUpdatedTime(v time.Time) *Stack {
	s.LastUpdatedTime = &v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *Stack) SetNotificationARNs(v []*string) *Stack {
	s.NotificationARNs = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Stack) SetOutputs(v []*Output) *Stack {
	s.Outputs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Stack) SetParameters(v []*Parameter) *Stack {
	s.Parameters = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *Stack) SetRoleARN(v string) *Stack {
	s.RoleARN = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *Stack) SetStackId(v string) *Stack {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *Stack) SetStackName(v string) *Stack {
	s.StackName = &v
	return s
}

// SetStackStatus sets the StackStatus field's value.
func (s *Stack) SetStackStatus(v string) *Stack {
	s.StackStatus = &v
	return s
}

// SetStackStatusReason sets the StackStatusReason field's value.
func (s *Stack) SetStackStatusReason(v string) *Stack {
	s.StackStatusReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Stack) SetTags(v []*Tag) *Stack {
	s.Tags = v
	return s
}

// SetTimeoutInMinutes sets the TimeoutInMinutes field's value.
func (s *Stack) SetTimeoutInMinutes(v int64) *Stack {
	s.TimeoutInMinutes = &v
	return s
}

// The StackEvent data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackEvent
type StackEvent struct {
	_ struct{} `type:"structure"`

	// The unique ID of this event.
	//
	// EventId is a required field
	EventId *string `type:"string" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier associated with the physical instance of the
	// resource.
	PhysicalResourceId *string `type:"string"`

	// BLOB of the properties used to create the resource.
	ResourceProperties *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `min:"1" type:"string"`

	// The unique ID name of the instance of the stack.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The name associated with a stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackEvent) GoString() string {
	return s.String()
}

// SetEventId sets the EventId field's value.
func (s *StackEvent) SetEventId(v string) *StackEvent {
	s.EventId = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackEvent) SetLogicalResourceId(v string) *StackEvent {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackEvent) SetPhysicalResourceId(v string) *StackEvent {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceProperties sets the ResourceProperties field's value.
func (s *StackEvent) SetResourceProperties(v string) *StackEvent {
	s.ResourceProperties = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackEvent) SetResourceStatus(v string) *StackEvent {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackEvent) SetResourceStatusReason(v string) *StackEvent {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackEvent) SetResourceType(v string) *StackEvent {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackEvent) SetStackId(v string) *StackEvent {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackEvent) SetStackName(v string) *StackEvent {
	s.StackName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackEvent) SetTimestamp(v time.Time) *StackEvent {
	s.Timestamp = &v
	return s
}

// The StackResource data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResource
type StackResource struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	// Time the status was updated.
	//
	// Timestamp is a required field
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s StackResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResource) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StackResource) SetDescription(v string) *StackResource {
	s.Description = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResource) SetLogicalResourceId(v string) *StackResource {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResource) SetPhysicalResourceId(v string) *StackResource {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResource) SetResourceStatus(v string) *StackResource {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResource) SetResourceStatusReason(v string) *StackResource {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResource) SetResourceType(v string) *StackResource {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackResource) SetStackId(v string) *StackResource {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackResource) SetStackName(v string) *StackResource {
	s.StackName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *StackResource) SetTimestamp(v time.Time) *StackResource {
	s.Timestamp = &v
	return s
}

// Contains detailed information about the specified stack resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceDetail
type StackResourceDetail struct {
	_ struct{} `type:"structure"`

	// User defined description associated with the resource.
	Description *string `min:"1" type:"string"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The content of the Metadata attribute declared for the resource. For more
	// information, see Metadata Attribute (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html)
	// in the AWS CloudFormation User Guide.
	Metadata *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. ((For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`
}

// String returns the string representation
func (s StackResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceDetail) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *StackResourceDetail) SetDescription(v string) *StackResourceDetail {
	s.Description = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *StackResourceDetail) SetLastUpdatedTimestamp(v time.Time) *StackResourceDetail {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResourceDetail) SetLogicalResourceId(v string) *StackResourceDetail {
	s.LogicalResourceId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *StackResourceDetail) SetMetadata(v string) *StackResourceDetail {
	s.Metadata = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResourceDetail) SetPhysicalResourceId(v string) *StackResourceDetail {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResourceDetail) SetResourceStatus(v string) *StackResourceDetail {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResourceDetail) SetResourceStatusReason(v string) *StackResourceDetail {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResourceDetail) SetResourceType(v string) *StackResourceDetail {
	s.ResourceType = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackResourceDetail) SetStackId(v string) *StackResourceDetail {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackResourceDetail) SetStackName(v string) *StackResourceDetail {
	s.StackName = &v
	return s
}

// Contains high-level information about the specified stack resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackResourceSummary
type StackResourceSummary struct {
	_ struct{} `type:"structure"`

	// Time the status was updated.
	//
	// LastUpdatedTimestamp is a required field
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of the resource.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	//
	// ResourceStatus is a required field
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StackResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceSummary) GoString() string {
	return s.String()
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *StackResourceSummary) SetLastUpdatedTimestamp(v time.Time) *StackResourceSummary {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetLogicalResourceId sets the LogicalResourceId field's value.
func (s *StackResourceSummary) SetLogicalResourceId(v string) *StackResourceSummary {
	s.LogicalResourceId = &v
	return s
}

// SetPhysicalResourceId sets the PhysicalResourceId field's value.
func (s *StackResourceSummary) SetPhysicalResourceId(v string) *StackResourceSummary {
	s.PhysicalResourceId = &v
	return s
}

// SetResourceStatus sets the ResourceStatus field's value.
func (s *StackResourceSummary) SetResourceStatus(v string) *StackResourceSummary {
	s.ResourceStatus = &v
	return s
}

// SetResourceStatusReason sets the ResourceStatusReason field's value.
func (s *StackResourceSummary) SetResourceStatusReason(v string) *StackResourceSummary {
	s.ResourceStatusReason = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StackResourceSummary) SetResourceType(v string) *StackResourceSummary {
	s.ResourceType = &v
	return s
}

// The StackSummary Data Type
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/StackSummary
type StackSummary struct {
	_ struct{} `type:"structure"`

	// The time the stack was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Unique stack identifier.
	StackId *string `type:"string"`

	// The name associated with the stack.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// The current status of the stack.
	//
	// StackStatus is a required field
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/Failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// The template description of the template used to create the stack.
	TemplateDescription *string `type:"string"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StackSummary) SetCreationTime(v time.Time) *StackSummary {
	s.CreationTime = &v
	return s
}

// SetDeletionTime sets the DeletionTime field's value.
func (s *StackSummary) SetDeletionTime(v time.Time) *StackSummary {
	s.DeletionTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *StackSummary) SetLastUpdatedTime(v time.Time) *StackSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackSummary) SetStackId(v string) *StackSummary {
	s.StackId = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *StackSummary) SetStackName(v string) *StackSummary {
	s.StackName = &v
	return s
}

// SetStackStatus sets the StackStatus field's value.
func (s *StackSummary) SetStackStatus(v string) *StackSummary {
	s.StackStatus = &v
	return s
}

// SetStackStatusReason sets the StackStatusReason field's value.
func (s *StackSummary) SetStackStatusReason(v string) *StackSummary {
	s.StackStatusReason = &v
	return s
}

// SetTemplateDescription sets the TemplateDescription field's value.
func (s *StackSummary) SetTemplateDescription(v string) *StackSummary {
	s.TemplateDescription = &v
	return s
}

// The Tag type enables you to specify a key-value pair that can be used to
// store information about an AWS CloudFormation stack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// Required. A string used to identify this tag. You can specify a maximum of
	// 128 characters for a tag key. Tags owned by Amazon Web Services (AWS) have
	// the reserved prefix: aws:.
	Key *string `type:"string"`

	// Required. A string containing the value for this tag. You can specify a maximum
	// of 256 characters for a tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The TemplateParameter data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/TemplateParameter
type TemplateParameter struct {
	_ struct{} `type:"structure"`

	// The default value associated with the parameter.
	DefaultValue *string `type:"string"`

	// User defined description associated with the parameter.
	Description *string `min:"1" type:"string"`

	// Flag indicating whether the parameter should be displayed as plain text in
	// logs and UIs.
	NoEcho *bool `type:"boolean"`

	// The name associated with the parameter.
	ParameterKey *string `type:"string"`
}

// String returns the string representation
func (s TemplateParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateParameter) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *TemplateParameter) SetDefaultValue(v string) *TemplateParameter {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TemplateParameter) SetDescription(v string) *TemplateParameter {
	s.Description = &v
	return s
}

// SetNoEcho sets the NoEcho field's value.
func (s *TemplateParameter) SetNoEcho(v bool) *TemplateParameter {
	s.NoEcho = &v
	return s
}

// SetParameterKey sets the ParameterKey field's value.
func (s *TemplateParameter) SetParameterKey(v string) *TemplateParameter {
	s.ParameterKey = &v
	return s
}

// The input for an UpdateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackInput
type UpdateStackInput struct {
	_ struct{} `type:"structure"`

	// A list of values that you must specify before AWS CloudFormation can update
	// certain stacks. Some stack templates might include resources that can affect
	// permissions in your AWS account, for example, by creating new AWS Identity
	// and Access Management (IAM) users. For those stacks, you must explicitly
	// acknowledge their capabilities by specifying this parameter.
	//
	// The only valid values are CAPABILITY_IAM and CAPABILITY_NAMED_IAM. The following
	// resources require you to specify this parameter:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// all permissions associated with them and edit their permissions if necessary.
	//
	// If you have IAM resources, you can specify either capability. If you have
	// IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM. If
	// you don't specify this parameter, this action returns an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []*string `type:"list"`

	// Amazon Simple Notification Service topic Amazon Resource Names (ARNs) that
	// AWS CloudFormation associates with the stack. Specify an empty list to remove
	// all notification topics.
	NotificationARNs []*string `type:"list"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The template resource types that you have permissions to work with for this
	// update stack action, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance.
	//
	// If the list of resource types doesn't include a resource that you're updating,
	// the stack update fails. By default, AWS CloudFormation grants permissions
	// to all resource types. AWS Identity and Access Management (IAM) uses this
	// parameter for AWS CloudFormation-specific condition keys in IAM policies.
	// For more information, see Controlling Access with AWS Identity and Access
	// Management (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
	ResourceTypes []*string `type:"list"`

	// The Amazon Resource Name (ARN) of an AWS Identity and Access Management (IAM)
	// role that AWS CloudFormation assumes to update the stack. AWS CloudFormation
	// uses the role's credentials to make calls on your behalf. AWS CloudFormation
	// always uses this role for all future operations on the stack. As long as
	// users have permission to operate on the stack, AWS CloudFormation uses this
	// role even if the users don't have permission to pass it. Ensure that the
	// role grants least privilege.
	//
	// If you don't specify a value, AWS CloudFormation uses the role that was previously
	// associated with the stack. If no role is available, AWS CloudFormation uses
	// a temporary session that is generated from your user credentials.
	RoleARN *string `min:"20" type:"string"`

	// The name or unique stack ID of the stack to update.
	//
	// StackName is a required field
	StackName *string `type:"string" required:"true"`

	// Structure containing a new stack policy body. You can specify either the
	// StackPolicyBody or the StackPolicyURL parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyBody *string `min:"1" type:"string"`

	// Structure containing the temporary overriding stack policy body. You can
	// specify either the StackPolicyDuringUpdateBody or the StackPolicyDuringUpdateURL
	// parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateBody *string `min:"1" type:"string"`

	// Location of a file containing the temporary overriding stack policy. The
	// URL must point to a policy (max size: 16KB) located in an S3 bucket in the
	// same region as the stack. You can specify either the StackPolicyDuringUpdateBody
	// or the StackPolicyDuringUpdateURL parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateURL *string `min:"1" type:"string"`

	// Location of a file containing the updated stack policy. The URL must point
	// to a policy (max size: 16KB) located in an S3 bucket in the same region as
	// the stack. You can specify either the StackPolicyBody or the StackPolicyURL
	// parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyURL *string `min:"1" type:"string"`

	// Key-value pairs to associate with this stack. AWS CloudFormation also propagates
	// these tags to supported resources in the stack. You can specify a maximum
	// number of 10 tags.
	//
	// If you don't specify this parameter, AWS CloudFormation doesn't modify the
	// stack's tags. If you specify an empty value, AWS CloudFormation removes all
	// associated tags.
	Tags []*Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// that is located in an Amazon S3 bucket. For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// Reuse the existing template that is associated with the stack that you are
	// updating.
	UsePreviousTemplate *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStackInput"}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 20))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackPolicyBody != nil && len(*s.StackPolicyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyBody", 1))
	}
	if s.StackPolicyDuringUpdateBody != nil && len(*s.StackPolicyDuringUpdateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyDuringUpdateBody", 1))
	}
	if s.StackPolicyDuringUpdateURL != nil && len(*s.StackPolicyDuringUpdateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyDuringUpdateURL", 1))
	}
	if s.StackPolicyURL != nil && len(*s.StackPolicyURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackPolicyURL", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapabilities sets the Capabilities field's value.
func (s *UpdateStackInput) SetCapabilities(v []*string) *UpdateStackInput {
	s.Capabilities = v
	return s
}

// SetNotificationARNs sets the NotificationARNs field's value.
func (s *UpdateStackInput) SetNotificationARNs(v []*string) *UpdateStackInput {
	s.NotificationARNs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *UpdateStackInput) SetParameters(v []*Parameter) *UpdateStackInput {
	s.Parameters = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *UpdateStackInput) SetResourceTypes(v []*string) *UpdateStackInput {
	s.ResourceTypes = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *UpdateStackInput) SetRoleARN(v string) *UpdateStackInput {
	s.RoleARN = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *UpdateStackInput) SetStackName(v string) *UpdateStackInput {
	s.StackName = &v
	return s
}

// SetStackPolicyBody sets the StackPolicyBody field's value.
func (s *UpdateStackInput) SetStackPolicyBody(v string) *UpdateStackInput {
	s.StackPolicyBody = &v
	return s
}

// SetStackPolicyDuringUpdateBody sets the StackPolicyDuringUpdateBody field's value.
func (s *UpdateStackInput) SetStackPolicyDuringUpdateBody(v string) *UpdateStackInput {
	s.StackPolicyDuringUpdateBody = &v
	return s
}

// SetStackPolicyDuringUpdateURL sets the StackPolicyDuringUpdateURL field's value.
func (s *UpdateStackInput) SetStackPolicyDuringUpdateURL(v string) *UpdateStackInput {
	s.StackPolicyDuringUpdateURL = &v
	return s
}

// SetStackPolicyURL sets the StackPolicyURL field's value.
func (s *UpdateStackInput) SetStackPolicyURL(v string) *UpdateStackInput {
	s.StackPolicyURL = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateStackInput) SetTags(v []*Tag) *UpdateStackInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *UpdateStackInput) SetTemplateBody(v string) *UpdateStackInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *UpdateStackInput) SetTemplateURL(v string) *UpdateStackInput {
	s.TemplateURL = &v
	return s
}

// SetUsePreviousTemplate sets the UsePreviousTemplate field's value.
func (s *UpdateStackInput) SetUsePreviousTemplate(v bool) *UpdateStackInput {
	s.UsePreviousTemplate = &v
	return s
}

// The output for an UpdateStack action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/UpdateStackOutput
type UpdateStackOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *UpdateStackOutput) SetStackId(v string) *UpdateStackOutput {
	s.StackId = &v
	return s
}

// The input for ValidateTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplateInput
type ValidateTemplateInput struct {
	_ struct{} `type:"structure"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) that is located in an Amazon S3 bucket. For more
	// information, go to Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ValidateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ValidateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ValidateTemplateInput"}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateURL != nil && len(*s.TemplateURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *ValidateTemplateInput) SetTemplateBody(v string) *ValidateTemplateInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateURL sets the TemplateURL field's value.
func (s *ValidateTemplateInput) SetTemplateURL(v string) *ValidateTemplateInput {
	s.TemplateURL = &v
	return s
}

// The output for ValidateTemplate action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ValidateTemplateOutput
type ValidateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The capabilities found within the template. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM or CAPABILITY_NAMED_IAM value
	// for this parameter when you use the CreateStack or UpdateStack actions with
	// your template; otherwise, those actions return an InsufficientCapabilities
	// error.
	//
	// For more information, see Acknowledging IAM Resources in AWS CloudFormation
	// Templates (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
	Capabilities []*string `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// A list of the transforms that are declared in the template.
	DeclaredTransforms []*string `type:"list"`

	// The description found within the template.
	Description *string `min:"1" type:"string"`

	// A list of TemplateParameter structures.
	Parameters []*TemplateParameter `type:"list"`
}

// String returns the string representation
func (s ValidateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateOutput) GoString() string {
	return s.String()
}

// SetCapabilities sets the Capabilities field's value.
func (s *ValidateTemplateOutput) SetCapabilities(v []*string) *ValidateTemplateOutput {
	s.Capabilities = v
	return s
}

// SetCapabilitiesReason sets the CapabilitiesReason field's value.
func (s *ValidateTemplateOutput) SetCapabilitiesReason(v string) *ValidateTemplateOutput {
	s.CapabilitiesReason = &v
	return s
}

// SetDeclaredTransforms sets the DeclaredTransforms field's value.
func (s *ValidateTemplateOutput) SetDeclaredTransforms(v []*string) *ValidateTemplateOutput {
	s.DeclaredTransforms = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ValidateTemplateOutput) SetDescription(v string) *ValidateTemplateOutput {
	s.Description = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ValidateTemplateOutput) SetParameters(v []*TemplateParameter) *ValidateTemplateOutput {
	s.Parameters = v
	return s
}

const (
	// CapabilityCapabilityIam is a Capability enum value
	CapabilityCapabilityIam = "CAPABILITY_IAM"

	// CapabilityCapabilityNamedIam is a Capability enum value
	CapabilityCapabilityNamedIam = "CAPABILITY_NAMED_IAM"
)

const (
	// ChangeActionAdd is a ChangeAction enum value
	ChangeActionAdd = "Add"

	// ChangeActionModify is a ChangeAction enum value
	ChangeActionModify = "Modify"

	// ChangeActionRemove is a ChangeAction enum value
	ChangeActionRemove = "Remove"
)

const (
	// ChangeSetStatusCreatePending is a ChangeSetStatus enum value
	ChangeSetStatusCreatePending = "CREATE_PENDING"

	// ChangeSetStatusCreateInProgress is a ChangeSetStatus enum value
	ChangeSetStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ChangeSetStatusCreateComplete is a ChangeSetStatus enum value
	ChangeSetStatusCreateComplete = "CREATE_COMPLETE"

	// ChangeSetStatusDeleteComplete is a ChangeSetStatus enum value
	ChangeSetStatusDeleteComplete = "DELETE_COMPLETE"

	// ChangeSetStatusFailed is a ChangeSetStatus enum value
	ChangeSetStatusFailed = "FAILED"
)

const (
	// ChangeSetTypeCreate is a ChangeSetType enum value
	ChangeSetTypeCreate = "CREATE"

	// ChangeSetTypeUpdate is a ChangeSetType enum value
	ChangeSetTypeUpdate = "UPDATE"
)

const (
	// ChangeSourceResourceReference is a ChangeSource enum value
	ChangeSourceResourceReference = "ResourceReference"

	// ChangeSourceParameterReference is a ChangeSource enum value
	ChangeSourceParameterReference = "ParameterReference"

	// ChangeSourceResourceAttribute is a ChangeSource enum value
	ChangeSourceResourceAttribute = "ResourceAttribute"

	// ChangeSourceDirectModification is a ChangeSource enum value
	ChangeSourceDirectModification = "DirectModification"

	// ChangeSourceAutomatic is a ChangeSource enum value
	ChangeSourceAutomatic = "Automatic"
)

const (
	// ChangeTypeResource is a ChangeType enum value
	ChangeTypeResource = "Resource"
)

const (
	// EvaluationTypeStatic is a EvaluationType enum value
	EvaluationTypeStatic = "Static"

	// EvaluationTypeDynamic is a EvaluationType enum value
	EvaluationTypeDynamic = "Dynamic"
)

const (
	// ExecutionStatusUnavailable is a ExecutionStatus enum value
	ExecutionStatusUnavailable = "UNAVAILABLE"

	// ExecutionStatusAvailable is a ExecutionStatus enum value
	ExecutionStatusAvailable = "AVAILABLE"

	// ExecutionStatusExecuteInProgress is a ExecutionStatus enum value
	ExecutionStatusExecuteInProgress = "EXECUTE_IN_PROGRESS"

	// ExecutionStatusExecuteComplete is a ExecutionStatus enum value
	ExecutionStatusExecuteComplete = "EXECUTE_COMPLETE"

	// ExecutionStatusExecuteFailed is a ExecutionStatus enum value
	ExecutionStatusExecuteFailed = "EXECUTE_FAILED"

	// ExecutionStatusObsolete is a ExecutionStatus enum value
	ExecutionStatusObsolete = "OBSOLETE"
)

const (
	// OnFailureDoNothing is a OnFailure enum value
	OnFailureDoNothing = "DO_NOTHING"

	// OnFailureRollback is a OnFailure enum value
	OnFailureRollback = "ROLLBACK"

	// OnFailureDelete is a OnFailure enum value
	OnFailureDelete = "DELETE"
)

const (
	// ReplacementTrue is a Replacement enum value
	ReplacementTrue = "True"

	// ReplacementFalse is a Replacement enum value
	ReplacementFalse = "False"

	// ReplacementConditional is a Replacement enum value
	ReplacementConditional = "Conditional"
)

const (
	// RequiresRecreationNever is a RequiresRecreation enum value
	RequiresRecreationNever = "Never"

	// RequiresRecreationConditionally is a RequiresRecreation enum value
	RequiresRecreationConditionally = "Conditionally"

	// RequiresRecreationAlways is a RequiresRecreation enum value
	RequiresRecreationAlways = "Always"
)

const (
	// ResourceAttributeProperties is a ResourceAttribute enum value
	ResourceAttributeProperties = "Properties"

	// ResourceAttributeMetadata is a ResourceAttribute enum value
	ResourceAttributeMetadata = "Metadata"

	// ResourceAttributeCreationPolicy is a ResourceAttribute enum value
	ResourceAttributeCreationPolicy = "CreationPolicy"

	// ResourceAttributeUpdatePolicy is a ResourceAttribute enum value
	ResourceAttributeUpdatePolicy = "UpdatePolicy"

	// ResourceAttributeDeletionPolicy is a ResourceAttribute enum value
	ResourceAttributeDeletionPolicy = "DeletionPolicy"

	// ResourceAttributeTags is a ResourceAttribute enum value
	ResourceAttributeTags = "Tags"
)

const (
	// ResourceSignalStatusSuccess is a ResourceSignalStatus enum value
	ResourceSignalStatusSuccess = "SUCCESS"

	// ResourceSignalStatusFailure is a ResourceSignalStatus enum value
	ResourceSignalStatusFailure = "FAILURE"
)

const (
	// ResourceStatusCreateInProgress is a ResourceStatus enum value
	ResourceStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ResourceStatusCreateFailed is a ResourceStatus enum value
	ResourceStatusCreateFailed = "CREATE_FAILED"

	// ResourceStatusCreateComplete is a ResourceStatus enum value
	ResourceStatusCreateComplete = "CREATE_COMPLETE"

	// ResourceStatusDeleteInProgress is a ResourceStatus enum value
	ResourceStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// ResourceStatusDeleteFailed is a ResourceStatus enum value
	ResourceStatusDeleteFailed = "DELETE_FAILED"

	// ResourceStatusDeleteComplete is a ResourceStatus enum value
	ResourceStatusDeleteComplete = "DELETE_COMPLETE"

	// ResourceStatusDeleteSkipped is a ResourceStatus enum value
	ResourceStatusDeleteSkipped = "DELETE_SKIPPED"

	// ResourceStatusUpdateInProgress is a ResourceStatus enum value
	ResourceStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// ResourceStatusUpdateFailed is a ResourceStatus enum value
	ResourceStatusUpdateFailed = "UPDATE_FAILED"

	// ResourceStatusUpdateComplete is a ResourceStatus enum value
	ResourceStatusUpdateComplete = "UPDATE_COMPLETE"
)

const (
	// StackStatusCreateInProgress is a StackStatus enum value
	StackStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// StackStatusCreateFailed is a StackStatus enum value
	StackStatusCreateFailed = "CREATE_FAILED"

	// StackStatusCreateComplete is a StackStatus enum value
	StackStatusCreateComplete = "CREATE_COMPLETE"

	// StackStatusRollbackInProgress is a StackStatus enum value
	StackStatusRollbackInProgress = "ROLLBACK_IN_PROGRESS"

	// StackStatusRollbackFailed is a StackStatus enum value
	StackStatusRollbackFailed = "ROLLBACK_FAILED"

	// StackStatusRollbackComplete is a StackStatus enum value
	StackStatusRollbackComplete = "ROLLBACK_COMPLETE"

	// StackStatusDeleteInProgress is a StackStatus enum value
	StackStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// StackStatusDeleteFailed is a StackStatus enum value
	StackStatusDeleteFailed = "DELETE_FAILED"

	// StackStatusDeleteComplete is a StackStatus enum value
	StackStatusDeleteComplete = "DELETE_COMPLETE"

	// StackStatusUpdateInProgress is a StackStatus enum value
	StackStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// StackStatusUpdateCompleteCleanupInProgress is a StackStatus enum value
	StackStatusUpdateCompleteCleanupInProgress = "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"

	// StackStatusUpdateComplete is a StackStatus enum value
	StackStatusUpdateComplete = "UPDATE_COMPLETE"

	// StackStatusUpdateRollbackInProgress is a StackStatus enum value
	StackStatusUpdateRollbackInProgress = "UPDATE_ROLLBACK_IN_PROGRESS"

	// StackStatusUpdateRollbackFailed is a StackStatus enum value
	StackStatusUpdateRollbackFailed = "UPDATE_ROLLBACK_FAILED"

	// StackStatusUpdateRollbackCompleteCleanupInProgress is a StackStatus enum value
	StackStatusUpdateRollbackCompleteCleanupInProgress = "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"

	// StackStatusUpdateRollbackComplete is a StackStatus enum value
	StackStatusUpdateRollbackComplete = "UPDATE_ROLLBACK_COMPLETE"

	// StackStatusReviewInProgress is a StackStatus enum value
	StackStatusReviewInProgress = "REVIEW_IN_PROGRESS"
)

const (
	// TemplateStageOriginal is a TemplateStage enum value
	TemplateStageOriginal = "Original"

	// TemplateStageProcessed is a TemplateStage enum value
	TemplateStageProcessed = "Processed"
)
