// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package appstream provides a client for Amazon AppStream.
package appstream

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateFleet = "AssociateFleet"

// AssociateFleetRequest generates a "aws/request.Request" representing the
// client's request for the AssociateFleet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateFleet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateFleet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateFleetRequest method.
//    req, resp := client.AssociateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet
func (c *AppStream) AssociateFleetRequest(input *AssociateFleetInput) (req *request.Request, output *AssociateFleetOutput) {
	op := &request.Operation{
		Name:       opAssociateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateFleetInput{}
	}

	output = &AssociateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateFleet API operation for Amazon AppStream.
//
// Associate a fleet to a stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation AssociateFleet for usage and error information.
//
// Returned Error Codes:
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet
func (c *AppStream) AssociateFleet(input *AssociateFleetInput) (*AssociateFleetOutput, error) {
	req, out := c.AssociateFleetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateFleet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateFleet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateFleetRequest method.
//    req, resp := client.CreateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet
func (c *AppStream) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon AppStream.
//
// Creates a new fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateFleet for usage and error information.
//
// Returned Error Codes:
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet
func (c *AppStream) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a "aws/request.Request" representing the
// client's request for the CreateStack operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateStack for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateStack method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateStackRequest method.
//    req, resp := client.CreateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack
func (c *AppStream) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	output = &CreateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStack API operation for Amazon AppStream.
//
// Create a new stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateStack for usage and error information.
//
// Returned Error Codes:
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack
func (c *AppStream) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStreamingURL = "CreateStreamingURL"

// CreateStreamingURLRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingURL operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateStreamingURL for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateStreamingURL method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateStreamingURLRequest method.
//    req, resp := client.CreateStreamingURLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL
func (c *AppStream) CreateStreamingURLRequest(input *CreateStreamingURLInput) (req *request.Request, output *CreateStreamingURLOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingURL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStreamingURLInput{}
	}

	output = &CreateStreamingURLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingURL API operation for Amazon AppStream.
//
// Creates a URL to start an AppStream 2.0 streaming session for a user. By
// default, the URL is valid only for 1 minute from the time that it is generated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateStreamingURL for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ResourceNotAvailableException
//   The specified resource exists and is not in use, but isn't available.
//
//   * OperationNotPermittedException
//   The attempted operation is not permitted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL
func (c *AppStream) CreateStreamingURL(input *CreateStreamingURLInput) (*CreateStreamingURLOutput, error) {
	req, out := c.CreateStreamingURLRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteFleet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteFleet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteFleetRequest method.
//    req, resp := client.DeleteFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet
func (c *AppStream) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFleet API operation for Amazon AppStream.
//
// Deletes a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet
func (c *AppStream) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStack operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteStack for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteStack method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteStackRequest method.
//    req, resp := client.DeleteStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack
func (c *AppStream) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	output = &DeleteStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStack API operation for Amazon AppStream.
//
// Deletes the stack. After this operation completes, the environment can no
// longer be activated, and any reservations made for the stack are released.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteStack for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack
func (c *AppStream) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFleets = "DescribeFleets"

// DescribeFleetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeFleets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeFleets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeFleetsRequest method.
//    req, resp := client.DescribeFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets
func (c *AppStream) DescribeFleetsRequest(input *DescribeFleetsInput) (req *request.Request, output *DescribeFleetsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetsInput{}
	}

	output = &DescribeFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleets API operation for Amazon AppStream.
//
// If fleet names are provided, this operation describes the specified fleets;
// otherwise, all the fleets in the account are described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeFleets for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets
func (c *AppStream) DescribeFleets(input *DescribeFleetsInput) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImages operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeImages for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeImages method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeImagesRequest method.
//    req, resp := client.DescribeImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages
func (c *AppStream) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	output = &DescribeImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImages API operation for Amazon AppStream.
//
// Describes the images. If a list of names is not provided, all images in your
// account are returned. This operation does not return a paginated result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeImages for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages
func (c *AppStream) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSessions = "DescribeSessions"

// DescribeSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSessions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSessions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSessions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSessionsRequest method.
//    req, resp := client.DescribeSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions
func (c *AppStream) DescribeSessionsRequest(input *DescribeSessionsInput) (req *request.Request, output *DescribeSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSessionsInput{}
	}

	output = &DescribeSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSessions API operation for Amazon AppStream.
//
// Describes the streaming sessions for a stack and a fleet. If a user ID is
// provided, this operation returns streaming sessions for only that user. Pass
// this value for the nextToken parameter in a subsequent call to this operation
// to retrieve the next set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeSessions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions
func (c *AppStream) DescribeSessions(input *DescribeSessionsInput) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStacks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStacks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStacks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStacksRequest method.
//    req, resp := client.DescribeStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks
func (c *AppStream) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	output = &DescribeStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStacks API operation for Amazon AppStream.
//
// If stack names are not provided, this operation describes the specified stacks;
// otherwise, all stacks in the account are described. Pass the nextToken value
// in a subsequent call to this operation to retrieve the next set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeStacks for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks
func (c *AppStream) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateFleet = "DisassociateFleet"

// DisassociateFleetRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFleet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateFleet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateFleet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateFleetRequest method.
//    req, resp := client.DisassociateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet
func (c *AppStream) DisassociateFleetRequest(input *DisassociateFleetInput) (req *request.Request, output *DisassociateFleetOutput) {
	op := &request.Operation{
		Name:       opDisassociateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateFleetInput{}
	}

	output = &DisassociateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateFleet API operation for Amazon AppStream.
//
// Disassociates a fleet from a stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DisassociateFleet for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet
func (c *AppStream) DisassociateFleet(input *DisassociateFleetInput) (*DisassociateFleetOutput, error) {
	req, out := c.DisassociateFleetRequest(input)
	err := req.Send()
	return out, err
}

const opExpireSession = "ExpireSession"

// ExpireSessionRequest generates a "aws/request.Request" representing the
// client's request for the ExpireSession operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ExpireSession for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ExpireSession method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ExpireSessionRequest method.
//    req, resp := client.ExpireSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession
func (c *AppStream) ExpireSessionRequest(input *ExpireSessionInput) (req *request.Request, output *ExpireSessionOutput) {
	op := &request.Operation{
		Name:       opExpireSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExpireSessionInput{}
	}

	output = &ExpireSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExpireSession API operation for Amazon AppStream.
//
// This operation immediately stops a streaming session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ExpireSession for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession
func (c *AppStream) ExpireSession(input *ExpireSessionInput) (*ExpireSessionOutput, error) {
	req, out := c.ExpireSessionRequest(input)
	err := req.Send()
	return out, err
}

const opListAssociatedFleets = "ListAssociatedFleets"

// ListAssociatedFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedFleets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAssociatedFleets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAssociatedFleets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAssociatedFleetsRequest method.
//    req, resp := client.ListAssociatedFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets
func (c *AppStream) ListAssociatedFleetsRequest(input *ListAssociatedFleetsInput) (req *request.Request, output *ListAssociatedFleetsOutput) {
	op := &request.Operation{
		Name:       opListAssociatedFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociatedFleetsInput{}
	}

	output = &ListAssociatedFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedFleets API operation for Amazon AppStream.
//
// Lists all fleets associated with the stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ListAssociatedFleets for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets
func (c *AppStream) ListAssociatedFleets(input *ListAssociatedFleetsInput) (*ListAssociatedFleetsOutput, error) {
	req, out := c.ListAssociatedFleetsRequest(input)
	err := req.Send()
	return out, err
}

const opListAssociatedStacks = "ListAssociatedStacks"

// ListAssociatedStacksRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedStacks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAssociatedStacks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAssociatedStacks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAssociatedStacksRequest method.
//    req, resp := client.ListAssociatedStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks
func (c *AppStream) ListAssociatedStacksRequest(input *ListAssociatedStacksInput) (req *request.Request, output *ListAssociatedStacksOutput) {
	op := &request.Operation{
		Name:       opListAssociatedStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociatedStacksInput{}
	}

	output = &ListAssociatedStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedStacks API operation for Amazon AppStream.
//
// Lists all stacks to which the specified fleet is associated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ListAssociatedStacks for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks
func (c *AppStream) ListAssociatedStacks(input *ListAssociatedStacksInput) (*ListAssociatedStacksOutput, error) {
	req, out := c.ListAssociatedStacksRequest(input)
	err := req.Send()
	return out, err
}

const opStartFleet = "StartFleet"

// StartFleetRequest generates a "aws/request.Request" representing the
// client's request for the StartFleet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartFleet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartFleet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartFleetRequest method.
//    req, resp := client.StartFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet
func (c *AppStream) StartFleetRequest(input *StartFleetInput) (req *request.Request, output *StartFleetOutput) {
	op := &request.Operation{
		Name:       opStartFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFleetInput{}
	}

	output = &StartFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFleet API operation for Amazon AppStream.
//
// Starts a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StartFleet for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet
func (c *AppStream) StartFleet(input *StartFleetInput) (*StartFleetOutput, error) {
	req, out := c.StartFleetRequest(input)
	err := req.Send()
	return out, err
}

const opStopFleet = "StopFleet"

// StopFleetRequest generates a "aws/request.Request" representing the
// client's request for the StopFleet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopFleet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopFleet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopFleetRequest method.
//    req, resp := client.StopFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet
func (c *AppStream) StopFleetRequest(input *StopFleetInput) (req *request.Request, output *StopFleetOutput) {
	op := &request.Operation{
		Name:       opStopFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopFleetInput{}
	}

	output = &StopFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopFleet API operation for Amazon AppStream.
//
// Stops a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StopFleet for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet
func (c *AppStream) StopFleet(input *StopFleetInput) (*StopFleetOutput, error) {
	req, out := c.StopFleetRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFleet = "UpdateFleet"

// UpdateFleetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateFleet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateFleet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateFleetRequest method.
//    req, resp := client.UpdateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet
func (c *AppStream) UpdateFleetRequest(input *UpdateFleetInput) (req *request.Request, output *UpdateFleetOutput) {
	op := &request.Operation{
		Name:       opUpdateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetInput{}
	}

	output = &UpdateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleet API operation for Amazon AppStream.
//
// Updates an existing fleet. All the attributes except the fleet name can be
// updated in the STOPPED state. Only ComputeCapacity and ImageName can be updated
// in any other state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateFleet for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * LimitExceededException
//   The requested limit exceeds the permitted limit for an account.
//
//   * InvalidRoleException
//   The specified role is invalid.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet
func (c *AppStream) UpdateFleet(input *UpdateFleetInput) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStack operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateStack for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateStack method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateStackRequest method.
//    req, resp := client.UpdateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack
func (c *AppStream) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	output = &UpdateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStack API operation for Amazon AppStream.
//
// Updates the specified fields in the stack with the specified name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateStack for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack
func (c *AppStream) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	err := req.Send()
	return out, err
}

// An entry for a single application in the application catalog.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/Application
type Application struct {
	_ struct{} `type:"structure"`

	// The name of the application shown to the end users.
	DisplayName *string `min:"1" type:"string"`

	// An application can be disabled after image creation if there is a problem.
	Enabled *bool `type:"boolean"`

	// The URL for the application icon. This URL may be time-limited.
	IconURL *string `min:"1" type:"string"`

	// A list of arguments that are passed to the application at launch.
	LaunchParameters *string `min:"1" type:"string"`

	// The path to the application executable in the instance.
	LaunchPath *string `min:"1" type:"string"`

	// Additional attributes that describes the application.
	Metadata map[string]*string `type:"map"`

	// The unique identifier for the application.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Application) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Application) SetDisplayName(v string) *Application {
	s.DisplayName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Application) SetEnabled(v bool) *Application {
	s.Enabled = &v
	return s
}

// SetIconURL sets the IconURL field's value.
func (s *Application) SetIconURL(v string) *Application {
	s.IconURL = &v
	return s
}

// SetLaunchParameters sets the LaunchParameters field's value.
func (s *Application) SetLaunchParameters(v string) *Application {
	s.LaunchParameters = &v
	return s
}

// SetLaunchPath sets the LaunchPath field's value.
func (s *Application) SetLaunchPath(v string) *Application {
	s.LaunchPath = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Application) SetMetadata(v map[string]*string) *Application {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *Application) SetName(v string) *Application {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleetRequest
type AssociateFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet to associate.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The name of the stack to which the fleet is associated.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateFleetInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *AssociateFleetInput) SetFleetName(v string) *AssociateFleetInput {
	s.FleetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *AssociateFleetInput) SetStackName(v string) *AssociateFleetInput {
	s.StackName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleetResult
type AssociateFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateFleetOutput) GoString() string {
	return s.String()
}

// The capacity configuration for the fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ComputeCapacity
type ComputeCapacity struct {
	_ struct{} `type:"structure"`

	// The desired number of streaming instances.
	//
	// DesiredInstances is a required field
	DesiredInstances *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ComputeCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeCapacity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeCapacity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeCapacity"}
	if s.DesiredInstances == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredInstances"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredInstances sets the DesiredInstances field's value.
func (s *ComputeCapacity) SetDesiredInstances(v int64) *ComputeCapacity {
	s.DesiredInstances = &v
	return s
}

// The capacity information for the fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ComputeCapacityStatus
type ComputeCapacityStatus struct {
	_ struct{} `type:"structure"`

	// The number of currently available instances that can be used to stream sessions.
	Available *int64 `type:"integer"`

	// The desired number of streaming instances.
	//
	// Desired is a required field
	Desired *int64 `type:"integer" required:"true"`

	// The number of instances that are being used for streaming.
	InUse *int64 `type:"integer"`

	// The total number of simultaneous streaming instances that are running.
	Running *int64 `type:"integer"`
}

// String returns the string representation
func (s ComputeCapacityStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeCapacityStatus) GoString() string {
	return s.String()
}

// SetAvailable sets the Available field's value.
func (s *ComputeCapacityStatus) SetAvailable(v int64) *ComputeCapacityStatus {
	s.Available = &v
	return s
}

// SetDesired sets the Desired field's value.
func (s *ComputeCapacityStatus) SetDesired(v int64) *ComputeCapacityStatus {
	s.Desired = &v
	return s
}

// SetInUse sets the InUse field's value.
func (s *ComputeCapacityStatus) SetInUse(v int64) *ComputeCapacityStatus {
	s.InUse = &v
	return s
}

// SetRunning sets the Running field's value.
func (s *ComputeCapacityStatus) SetRunning(v int64) *ComputeCapacityStatus {
	s.Running = &v
	return s
}

// Contains the parameters for the new fleet to create.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleetRequest
type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// The parameters for the capacity allocated to the fleet.
	//
	// ComputeCapacity is a required field
	ComputeCapacity *ComputeCapacity `type:"structure" required:"true"`

	// The description of the fleet.
	Description *string `type:"string"`

	// The time after disconnection when a session is considered to have ended.
	// If a user who got disconnected reconnects within this timeout interval, the
	// user is connected back to his/her previous session.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The display name of the fleet.
	DisplayName *string `type:"string"`

	// Unique name of the image used by the fleet.
	//
	// ImageName is a required field
	ImageName *string `min:"1" type:"string" required:"true"`

	// The instance type of compute resources for the fleet. Fleet instances are
	// launched from this instance type.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The maximum time up to which a streaming session can run.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// A unique identifier for the fleet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.ComputeCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeCapacity"))
	}
	if s.ImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageName"))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ComputeCapacity != nil {
		if err := s.ComputeCapacity.Validate(); err != nil {
			invalidParams.AddNested("ComputeCapacity", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeCapacity sets the ComputeCapacity field's value.
func (s *CreateFleetInput) SetComputeCapacity(v *ComputeCapacity) *CreateFleetInput {
	s.ComputeCapacity = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetInput) SetDescription(v string) *CreateFleetInput {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *CreateFleetInput) SetDisconnectTimeoutInSeconds(v int64) *CreateFleetInput {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateFleetInput) SetDisplayName(v string) *CreateFleetInput {
	s.DisplayName = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *CreateFleetInput) SetImageName(v string) *CreateFleetInput {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateFleetInput) SetInstanceType(v string) *CreateFleetInput {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *CreateFleetInput) SetMaxUserDurationInSeconds(v int64) *CreateFleetInput {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFleetInput) SetName(v string) *CreateFleetInput {
	s.Name = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateFleetInput) SetVpcConfig(v *VpcConfig) *CreateFleetInput {
	s.VpcConfig = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleetResult
type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// The details for the created fleet.
	Fleet *Fleet `type:"structure"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetFleet sets the Fleet field's value.
func (s *CreateFleetOutput) SetFleet(v *Fleet) *CreateFleetOutput {
	s.Fleet = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStackRequest
type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// The description displayed to end users on the AppStream 2.0 portal.
	Description *string `type:"string"`

	// The name displayed to end users on the AppStream 2.0 portal.
	DisplayName *string `type:"string"`

	// The unique identifier for this stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateStackInput) SetDescription(v string) *CreateStackInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateStackInput) SetDisplayName(v string) *CreateStackInput {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStackInput) SetName(v string) *CreateStackInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStackResult
type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	// The details for the created stack.
	Stack *Stack `type:"structure"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// SetStack sets the Stack field's value.
func (s *CreateStackOutput) SetStack(v *Stack) *CreateStackOutput {
	s.Stack = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURLRequest
type CreateStreamingURLInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application that must be launched after the session starts.
	ApplicationId *string `min:"1" type:"string"`

	// The fleet for which the URL is generated.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The sessionContext of the streaming URL.
	SessionContext *string `min:"1" type:"string"`

	// The stack for which the URL is generated.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// A unique user ID for whom the URL is generated.
	//
	// UserId is a required field
	UserId *string `min:"2" type:"string" required:"true"`

	// The validity duration of the URL in seconds. After this duration, the URL
	// returned by this operation becomes invalid.
	Validity *int64 `type:"long"`
}

// String returns the string representation
func (s CreateStreamingURLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingURLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingURLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingURLInput"}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.SessionContext != nil && len(*s.SessionContext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionContext", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateStreamingURLInput) SetApplicationId(v string) *CreateStreamingURLInput {
	s.ApplicationId = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *CreateStreamingURLInput) SetFleetName(v string) *CreateStreamingURLInput {
	s.FleetName = &v
	return s
}

// SetSessionContext sets the SessionContext field's value.
func (s *CreateStreamingURLInput) SetSessionContext(v string) *CreateStreamingURLInput {
	s.SessionContext = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateStreamingURLInput) SetStackName(v string) *CreateStreamingURLInput {
	s.StackName = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateStreamingURLInput) SetUserId(v string) *CreateStreamingURLInput {
	s.UserId = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CreateStreamingURLInput) SetValidity(v int64) *CreateStreamingURLInput {
	s.Validity = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURLResult
type CreateStreamingURLOutput struct {
	_ struct{} `type:"structure"`

	// Elapsed seconds after the Unix epoch, at which time this URL expires.
	Expires *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The URL to start the AppStream 2.0 streaming session.
	StreamingURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStreamingURLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingURLOutput) GoString() string {
	return s.String()
}

// SetExpires sets the Expires field's value.
func (s *CreateStreamingURLOutput) SetExpires(v time.Time) *CreateStreamingURLOutput {
	s.Expires = &v
	return s
}

// SetStreamingURL sets the StreamingURL field's value.
func (s *CreateStreamingURLOutput) SetStreamingURL(v string) *CreateStreamingURLOutput {
	s.StreamingURL = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleetRequest
type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet to be deleted.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteFleetInput) SetName(v string) *DeleteFleetInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleetResult
type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStackRequest
type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// The name of the stack to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteStackInput) SetName(v string) *DeleteStackInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStackResult
type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleetsRequest
type DescribeFleetsInput struct {
	_ struct{} `type:"structure"`

	// The fleet names to describe. Use null to describe all the fleets for the
	// AWS account.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *DescribeFleetsInput) SetNames(v []*string) *DescribeFleetsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetsInput) SetNextToken(v string) *DescribeFleetsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleetsResult
type DescribeFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The list of fleet details.
	Fleets []*Fleet `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetsOutput) GoString() string {
	return s.String()
}

// SetFleets sets the Fleets field's value.
func (s *DescribeFleetsOutput) SetFleets(v []*Fleet) *DescribeFleetsOutput {
	s.Fleets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetsOutput) SetNextToken(v string) *DescribeFleetsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagesRequest
type DescribeImagesInput struct {
	_ struct{} `type:"structure"`

	// A specific list of images to describe.
	Names []*string `type:"list"`
}

// String returns the string representation
func (s DescribeImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesInput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *DescribeImagesInput) SetNames(v []*string) *DescribeImagesInput {
	s.Names = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagesResult
type DescribeImagesOutput struct {
	_ struct{} `type:"structure"`

	// The list of images.
	Images []*Image `type:"list"`
}

// String returns the string representation
func (s DescribeImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesOutput) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *DescribeImagesOutput) SetImages(v []*Image) *DescribeImagesOutput {
	s.Images = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessionsRequest
type DescribeSessionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet for which to list sessions.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The size of each page of results. The default value is 20 and the maximum
	// supported value is 50.
	Limit *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack for which to list sessions.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The user for whom to list sessions. Use null to describe all the sessions
	// for the stack and fleet.
	UserId *string `min:"2" type:"string"`
}

// String returns the string representation
func (s DescribeSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSessionsInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *DescribeSessionsInput) SetFleetName(v string) *DescribeSessionsInput {
	s.FleetName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeSessionsInput) SetLimit(v int64) *DescribeSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSessionsInput) SetNextToken(v string) *DescribeSessionsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeSessionsInput) SetStackName(v string) *DescribeSessionsInput {
	s.StackName = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeSessionsInput) SetUserId(v string) *DescribeSessionsInput {
	s.UserId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessionsResult
type DescribeSessionsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The list of streaming sessions.
	Sessions []*Session `type:"list"`
}

// String returns the string representation
func (s DescribeSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSessionsOutput) SetNextToken(v string) *DescribeSessionsOutput {
	s.NextToken = &v
	return s
}

// SetSessions sets the Sessions field's value.
func (s *DescribeSessionsOutput) SetSessions(v []*Session) *DescribeSessionsOutput {
	s.Sessions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacksRequest
type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// The stack names to describe. Use null to describe all the stacks for the
	// AWS account.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *DescribeStacksInput) SetNames(v []*string) *DescribeStacksInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksInput) SetNextToken(v string) *DescribeStacksInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacksResult
type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// The list of stack details.
	Stacks []*Stack `type:"list"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksOutput) SetNextToken(v string) *DescribeStacksOutput {
	s.NextToken = &v
	return s
}

// SetStacks sets the Stacks field's value.
func (s *DescribeStacksOutput) SetStacks(v []*Stack) *DescribeStacksOutput {
	s.Stacks = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleetRequest
type DisassociateFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet to disassociate.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The name of the stack with which the fleet is associated.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateFleetInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *DisassociateFleetInput) SetFleetName(v string) *DisassociateFleetInput {
	s.FleetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DisassociateFleetInput) SetStackName(v string) *DisassociateFleetInput {
	s.StackName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleetResult
type DisassociateFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFleetOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSessionRequest
type ExpireSessionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the streaming session to be stopped.
	//
	// SessionId is a required field
	SessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExpireSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpireSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpireSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExpireSessionInput"}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionId sets the SessionId field's value.
func (s *ExpireSessionInput) SetSessionId(v string) *ExpireSessionInput {
	s.SessionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSessionResult
type ExpireSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExpireSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpireSessionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for a fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/Fleet
type Fleet struct {
	_ struct{} `type:"structure"`

	// The ARN for the fleet.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The capacity information for the fleet.
	//
	// ComputeCapacityStatus is a required field
	ComputeCapacityStatus *ComputeCapacityStatus `type:"structure" required:"true"`

	// The time at which the fleet was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description displayed to end users on the AppStream 2.0 portal.
	Description *string `min:"1" type:"string"`

	// The time after disconnection when a session is considered to have ended.
	// When a user reconnects after a disconnection, the user is connected to the
	// same session and instance within this time interval.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The name displayed to end users on the AppStream 2.0 portal.
	DisplayName *string `min:"1" type:"string"`

	// The list of fleet errors is appended to this list.
	FleetErrors []*FleetError `type:"list"`

	// The image used by the fleet.
	//
	// ImageName is a required field
	ImageName *string `min:"1" type:"string" required:"true"`

	// The instance type of compute resources for the fleet. The fleet instances
	// are launched from this instance type.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The maximum time during which a streaming session can run.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current state for the fleet.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"FleetState"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s Fleet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Fleet) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Fleet) SetArn(v string) *Fleet {
	s.Arn = &v
	return s
}

// SetComputeCapacityStatus sets the ComputeCapacityStatus field's value.
func (s *Fleet) SetComputeCapacityStatus(v *ComputeCapacityStatus) *Fleet {
	s.ComputeCapacityStatus = v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Fleet) SetCreatedTime(v time.Time) *Fleet {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Fleet) SetDescription(v string) *Fleet {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *Fleet) SetDisconnectTimeoutInSeconds(v int64) *Fleet {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Fleet) SetDisplayName(v string) *Fleet {
	s.DisplayName = &v
	return s
}

// SetFleetErrors sets the FleetErrors field's value.
func (s *Fleet) SetFleetErrors(v []*FleetError) *Fleet {
	s.FleetErrors = v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *Fleet) SetImageName(v string) *Fleet {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Fleet) SetInstanceType(v string) *Fleet {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *Fleet) SetMaxUserDurationInSeconds(v int64) *Fleet {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *Fleet) SetName(v string) *Fleet {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Fleet) SetState(v string) *Fleet {
	s.State = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *Fleet) SetVpcConfig(v *VpcConfig) *Fleet {
	s.VpcConfig = v
	return s
}

// The details of the fleet error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/FleetError
type FleetError struct {
	_ struct{} `type:"structure"`

	// The error code for the fleet error.
	ErrorCode *string `type:"string" enum:"FleetErrorCode"`

	// The error message generated when the fleet has errors.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FleetError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FleetError) SetErrorCode(v string) *FleetError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FleetError) SetErrorMessage(v string) *FleetError {
	s.ErrorMessage = &v
	return s
}

// New streaming instances are booted from images. The image stores the application
// catalog and is connected to fleets.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/Image
type Image struct {
	_ struct{} `type:"structure"`

	// The applications associated with an image.
	Applications []*Application `type:"list"`

	// The ARN for the image.
	Arn *string `type:"string"`

	// The source image ARN from which this image was created.
	BaseImageArn *string `type:"string"`

	// The timestamp when the image was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A meaningful description for the image.
	Description *string `min:"1" type:"string"`

	// The display name for the image.
	DisplayName *string `min:"1" type:"string"`

	// The unique identifier for the image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The operating system platform of the image.
	Platform *string `type:"string" enum:"PlatformType"`

	// The image starts in the PENDING state, and then moves to AVAILABLE if image
	// creation succeeds and FAILED if image creation has failed.
	State *string `type:"string" enum:"ImageState"`

	// The reason why the last state change occurred.
	StateChangeReason *ImageStateChangeReason `type:"structure"`

	// The visibility of an image to the user; images can be public or private.
	Visibility *string `type:"string" enum:"VisibilityType"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Image) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *Image) SetApplications(v []*Application) *Image {
	s.Applications = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Image) SetArn(v string) *Image {
	s.Arn = &v
	return s
}

// SetBaseImageArn sets the BaseImageArn field's value.
func (s *Image) SetBaseImageArn(v string) *Image {
	s.BaseImageArn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Image) SetCreatedTime(v time.Time) *Image {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Image) SetDescription(v string) *Image {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Image) SetDisplayName(v string) *Image {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Image) SetName(v string) *Image {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Image) SetPlatform(v string) *Image {
	s.Platform = &v
	return s
}

// SetState sets the State field's value.
func (s *Image) SetState(v string) *Image {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *Image) SetStateChangeReason(v *ImageStateChangeReason) *Image {
	s.StateChangeReason = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *Image) SetVisibility(v string) *Image {
	s.Visibility = &v
	return s
}

// The reason why the last state change occurred.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ImageStateChangeReason
type ImageStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The state change reason code of the image.
	Code *string `type:"string" enum:"ImageStateChangeReasonCode"`

	// The state change reason message to the end user.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ImageStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ImageStateChangeReason) SetCode(v string) *ImageStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ImageStateChangeReason) SetMessage(v string) *ImageStateChangeReason {
	s.Message = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleetsRequest
type ListAssociatedFleetsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack whose associated fleets are listed.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAssociatedFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedFleetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedFleetsInput) SetNextToken(v string) *ListAssociatedFleetsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListAssociatedFleetsInput) SetStackName(v string) *ListAssociatedFleetsInput {
	s.StackName = &v
	return s
}

// The response from a successful operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleetsResult
type ListAssociatedFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The names of associated fleets.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedFleetsOutput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *ListAssociatedFleetsOutput) SetNames(v []*string) *ListAssociatedFleetsOutput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedFleetsOutput) SetNextToken(v string) *ListAssociatedFleetsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacksRequest
type ListAssociatedStacksInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet whose associated stacks are listed.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedStacksInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *ListAssociatedStacksInput) SetFleetName(v string) *ListAssociatedStacksInput {
	s.FleetName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedStacksInput) SetNextToken(v string) *ListAssociatedStacksInput {
	s.NextToken = &v
	return s
}

// The response from a successful operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacksResult
type ListAssociatedStacksOutput struct {
	_ struct{} `type:"structure"`

	// The names of associated stacks.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedStacksOutput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *ListAssociatedStacksOutput) SetNames(v []*string) *ListAssociatedStacksOutput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedStacksOutput) SetNextToken(v string) *ListAssociatedStacksOutput {
	s.NextToken = &v
	return s
}

// Contains the parameters for a streaming session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/Session
type Session struct {
	_ struct{} `type:"structure"`

	// The name of the fleet for which the streaming session was created.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The unique ID for a streaming session.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the stack for which the streaming session was created.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The current state of the streaming session.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"SessionState"`

	// The identifier of the user for whom the session was created.
	//
	// UserId is a required field
	UserId *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s Session) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Session) GoString() string {
	return s.String()
}

// SetFleetName sets the FleetName field's value.
func (s *Session) SetFleetName(v string) *Session {
	s.FleetName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Session) SetId(v string) *Session {
	s.Id = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *Session) SetStackName(v string) *Session {
	s.StackName = &v
	return s
}

// SetState sets the State field's value.
func (s *Session) SetState(v string) *Session {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *Session) SetUserId(v string) *Session {
	s.UserId = &v
	return s
}

// Details about a stack.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/Stack
type Stack struct {
	_ struct{} `type:"structure"`

	// The ARN of the stack.
	Arn *string `type:"string"`

	// The timestamp when the stack was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A meaningful description for the stack.
	Description *string `min:"1" type:"string"`

	// A display name for the stack.
	DisplayName *string `min:"1" type:"string"`

	// The unique identifier of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Stack) SetArn(v string) *Stack {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Stack) SetCreatedTime(v time.Time) *Stack {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Stack) SetDescription(v string) *Stack {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Stack) SetDisplayName(v string) *Stack {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Stack) SetName(v string) *Stack {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleetRequest
type StartFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet to start.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartFleetInput) SetName(v string) *StartFleetInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleetResult
type StartFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFleetOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleetRequest
type StopFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet to stop.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopFleetInput) SetName(v string) *StopFleetInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleetResult
type StopFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFleetOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleetRequest
type UpdateFleetInput struct {
	_ struct{} `type:"structure"`

	// The parameters for the capacity allocated to the fleet.
	ComputeCapacity *ComputeCapacity `type:"structure"`

	// Delete the VPC association for the specified fleet.
	DeleteVpcConfig *bool `type:"boolean"`

	// The description displayed to end users on the AppStream 2.0 portal.
	Description *string `type:"string"`

	// The time after disconnection when a session is considered to have ended.
	// When the user reconnects after a disconnection, the user is connected to
	// the same instance within this time interval.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The name displayed to end users on the AppStream 2.0 portal.
	DisplayName *string `type:"string"`

	// The image name from which a fleet is created.
	ImageName *string `min:"1" type:"string"`

	// The instance type of compute resources for the fleet. Fleet instances are
	// launched from this instance type.
	InstanceType *string `min:"1" type:"string"`

	// The maximum time during which a streaming session can run.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetInput"}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ComputeCapacity != nil {
		if err := s.ComputeCapacity.Validate(); err != nil {
			invalidParams.AddNested("ComputeCapacity", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeCapacity sets the ComputeCapacity field's value.
func (s *UpdateFleetInput) SetComputeCapacity(v *ComputeCapacity) *UpdateFleetInput {
	s.ComputeCapacity = v
	return s
}

// SetDeleteVpcConfig sets the DeleteVpcConfig field's value.
func (s *UpdateFleetInput) SetDeleteVpcConfig(v bool) *UpdateFleetInput {
	s.DeleteVpcConfig = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFleetInput) SetDescription(v string) *UpdateFleetInput {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *UpdateFleetInput) SetDisconnectTimeoutInSeconds(v int64) *UpdateFleetInput {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateFleetInput) SetDisplayName(v string) *UpdateFleetInput {
	s.DisplayName = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *UpdateFleetInput) SetImageName(v string) *UpdateFleetInput {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *UpdateFleetInput) SetInstanceType(v string) *UpdateFleetInput {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *UpdateFleetInput) SetMaxUserDurationInSeconds(v int64) *UpdateFleetInput {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFleetInput) SetName(v string) *UpdateFleetInput {
	s.Name = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateFleetInput) SetVpcConfig(v *VpcConfig) *UpdateFleetInput {
	s.VpcConfig = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleetResult
type UpdateFleetOutput struct {
	_ struct{} `type:"structure"`

	// A list of fleet details.
	Fleet *Fleet `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetOutput) GoString() string {
	return s.String()
}

// SetFleet sets the Fleet field's value.
func (s *UpdateFleetOutput) SetFleet(v *Fleet) *UpdateFleetOutput {
	s.Fleet = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStackRequest
type UpdateStackInput struct {
	_ struct{} `type:"structure"`

	// The description displayed to end users on the AppStream 2.0 portal.
	Description *string `type:"string"`

	// The name displayed to end users on the AppStream 2.0 portal.
	DisplayName *string `type:"string"`

	// The name of the stack to update.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStackInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateStackInput) SetDescription(v string) *UpdateStackInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateStackInput) SetDisplayName(v string) *UpdateStackInput {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStackInput) SetName(v string) *UpdateStackInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStackResult
type UpdateStackOutput struct {
	_ struct{} `type:"structure"`

	// A list of stack details.
	Stack *Stack `type:"structure"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

// SetStack sets the Stack field's value.
func (s *UpdateStackOutput) SetStack(v *Stack) *UpdateStackOutput {
	s.Stack = v
	return s
}

// The VPC in which the fleet is launched.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/VpcConfig
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// The list of subnets to which a network interface is established from the
	// fleet instance.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfig"}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

const (
	// FleetErrorCodeIamServiceRoleMissingEniDescribeAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniDescribeAction = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"

	// FleetErrorCodeIamServiceRoleMissingEniCreateAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniCreateAction = "IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"

	// FleetErrorCodeIamServiceRoleMissingEniDeleteAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniDeleteAction = "IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"

	// FleetErrorCodeNetworkInterfaceLimitExceeded is a FleetErrorCode enum value
	FleetErrorCodeNetworkInterfaceLimitExceeded = "NETWORK_INTERFACE_LIMIT_EXCEEDED"

	// FleetErrorCodeInternalServiceError is a FleetErrorCode enum value
	FleetErrorCodeInternalServiceError = "INTERNAL_SERVICE_ERROR"

	// FleetErrorCodeIamServiceRoleIsMissing is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleIsMissing = "IAM_SERVICE_ROLE_IS_MISSING"

	// FleetErrorCodeSubnetHasInsufficientIpAddresses is a FleetErrorCode enum value
	FleetErrorCodeSubnetHasInsufficientIpAddresses = "SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"

	// FleetErrorCodeIamServiceRoleMissingDescribeSubnetAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingDescribeSubnetAction = "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"

	// FleetErrorCodeSubnetNotFound is a FleetErrorCode enum value
	FleetErrorCodeSubnetNotFound = "SUBNET_NOT_FOUND"

	// FleetErrorCodeImageNotFound is a FleetErrorCode enum value
	FleetErrorCodeImageNotFound = "IMAGE_NOT_FOUND"

	// FleetErrorCodeInvalidSubnetConfiguration is a FleetErrorCode enum value
	FleetErrorCodeInvalidSubnetConfiguration = "INVALID_SUBNET_CONFIGURATION"
)

const (
	// FleetStateStarting is a FleetState enum value
	FleetStateStarting = "STARTING"

	// FleetStateRunning is a FleetState enum value
	FleetStateRunning = "RUNNING"

	// FleetStateStopping is a FleetState enum value
	FleetStateStopping = "STOPPING"

	// FleetStateStopped is a FleetState enum value
	FleetStateStopped = "STOPPED"
)

const (
	// ImageStatePending is a ImageState enum value
	ImageStatePending = "PENDING"

	// ImageStateAvailable is a ImageState enum value
	ImageStateAvailable = "AVAILABLE"

	// ImageStateFailed is a ImageState enum value
	ImageStateFailed = "FAILED"

	// ImageStateDeleting is a ImageState enum value
	ImageStateDeleting = "DELETING"
)

const (
	// ImageStateChangeReasonCodeInternalError is a ImageStateChangeReasonCode enum value
	ImageStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// ImageStateChangeReasonCodeImageBuilderNotAvailable is a ImageStateChangeReasonCode enum value
	ImageStateChangeReasonCodeImageBuilderNotAvailable = "IMAGE_BUILDER_NOT_AVAILABLE"
)

const (
	// PlatformTypeWindows is a PlatformType enum value
	PlatformTypeWindows = "WINDOWS"
)

// Possible values for the state of a streaming session.
const (
	// SessionStateActive is a SessionState enum value
	SessionStateActive = "ACTIVE"

	// SessionStatePending is a SessionState enum value
	SessionStatePending = "PENDING"

	// SessionStateExpired is a SessionState enum value
	SessionStateExpired = "EXPIRED"
)

const (
	// VisibilityTypePublic is a VisibilityType enum value
	VisibilityTypePublic = "PUBLIC"

	// VisibilityTypePrivate is a VisibilityType enum value
	VisibilityTypePrivate = "PRIVATE"
)
