// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ssm provides a client for Amazon Simple Systems Management Service.
package ssm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsToResourceOutput{}
	req.Data = output
	return
}

// AddTagsToResource API operation for Amazon Simple Systems Management Service.
//
// Adds or overwrites one or more tags for the specified resource. Tags are
// metadata that you assign to your managed instances. Tags enable you to categorize
// your managed instances in different ways, for example, by purpose, owner,
// or environment. Each tag consists of a key and an optional value, both of
// which you define. For example, you could define a set of tags for your account's
// managed instances that helps you track each instance's owner and stack level.
// For example: Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack
// and Value=Production, Pre-Production, or Test. Each resource can have a maximum
// of 10 tags.
//
// We recommend that you devise a set of tag keys that meets your needs for
// each resource type. Using a consistent set of tag keys makes it easier for
// you to manage your resources. You can search and filter the resources based
// on the tags you add. Tags don't have any semantic meaning to Amazon EC2 and
// are interpreted strictly as a string of characters.
//
// For more information about tags, see Tagging Your Amazon EC2 Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceType
//   The resource type is not valid. If you are attempting to tag an instance,
//   the instance must be a registered, managed instance.
//
//   * InvalidResourceId
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * InternalServerError
//   An error occurred on the server side.
//
func (c *SSM) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	err := req.Send()
	return out, err
}

const opCancelCommand = "CancelCommand"

// CancelCommandRequest generates a "aws/request.Request" representing the
// client's request for the CancelCommand operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelCommand for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelCommand method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelCommandRequest method.
//    req, resp := client.CancelCommandRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) CancelCommandRequest(input *CancelCommandInput) (req *request.Request, output *CancelCommandOutput) {
	op := &request.Operation{
		Name:       opCancelCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelCommandInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelCommandOutput{}
	req.Data = output
	return
}

// CancelCommand API operation for Amazon Simple Systems Management Service.
//
// Attempts to cancel the command specified by the Command ID. There is no guarantee
// that the command will be terminated and the underlying process stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CancelCommand for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidCommandId

//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * DuplicateInstanceId
//   You cannot specify an instance ID in more than one association.
//
func (c *SSM) CancelCommand(input *CancelCommandInput) (*CancelCommandOutput, error) {
	req, out := c.CancelCommandRequest(input)
	err := req.Send()
	return out, err
}

const opCreateActivation = "CreateActivation"

// CreateActivationRequest generates a "aws/request.Request" representing the
// client's request for the CreateActivation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateActivation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateActivation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateActivationRequest method.
//    req, resp := client.CreateActivationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) CreateActivationRequest(input *CreateActivationInput) (req *request.Request, output *CreateActivationOutput) {
	op := &request.Operation{
		Name:       opCreateActivation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateActivationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateActivationOutput{}
	req.Data = output
	return
}

// CreateActivation API operation for Amazon Simple Systems Management Service.
//
// Registers your on-premises server or virtual machine with Amazon EC2 so that
// you can manage these resources using Run Command. An on-premises server or
// virtual machine that has been registered with EC2 is called a managed instance.
// For more information about activations, see Setting Up Managed Instances
// (Linux) (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/managed-instances.html)
// or Setting Up Managed Instances (Windows) (http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/managed-instances.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateActivation for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
func (c *SSM) CreateActivation(input *CreateActivationInput) (*CreateActivationOutput, error) {
	req, out := c.CreateActivationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAssociation = "CreateAssociation"

// CreateAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssociation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAssociation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAssociation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAssociationRequest method.
//    req, resp := client.CreateAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) CreateAssociationRequest(input *CreateAssociationInput) (req *request.Request, output *CreateAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAssociationOutput{}
	req.Data = output
	return
}

// CreateAssociation API operation for Amazon Simple Systems Management Service.
//
// Associates the specified SSM document with the specified instance.
//
// When you associate an SSM document with an instance, the configuration agent
// on the instance (SSM agent for Linux and EC2Config service for Windows) processes
// the document and configures the instance as specified.
//
// If you associate a document with an instance that already has an associated
// document, the system throws the AssociationAlreadyExists exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateAssociation for usage and error information.
//
// Returned Error Codes:
//   * AssociationAlreadyExists
//   The specified association already exists.
//
//   * AssociationLimitExceeded
//   You can have at most 2,000 active associations.
//
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * UnsupportedPlatformType
//   The document does not support the platform type of the given instance ID(s).
//   For example, you sent an SSM document for a Windows instance to a Linux instance.
//
//   * InvalidParameters
//   You must specify values for all required parameters in the SSM document.
//   You can only supply values to parameters defined in the SSM document.
//
func (c *SSM) CreateAssociation(input *CreateAssociationInput) (*CreateAssociationOutput, error) {
	req, out := c.CreateAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAssociationBatch = "CreateAssociationBatch"

// CreateAssociationBatchRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssociationBatch operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAssociationBatch for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAssociationBatch method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAssociationBatchRequest method.
//    req, resp := client.CreateAssociationBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) CreateAssociationBatchRequest(input *CreateAssociationBatchInput) (req *request.Request, output *CreateAssociationBatchOutput) {
	op := &request.Operation{
		Name:       opCreateAssociationBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationBatchInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAssociationBatchOutput{}
	req.Data = output
	return
}

// CreateAssociationBatch API operation for Amazon Simple Systems Management Service.
//
// Associates the specified SSM document with the specified instances.
//
// When you associate an SSM document with an instance, the configuration agent
// on the instance (SSM agent for Linux and EC2Config service for Windows) processes
// the document and configures the instance as specified.
//
// If you associate a document with an instance that already has an associated
// document, the system throws the AssociationAlreadyExists exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateAssociationBatch for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * InvalidParameters
//   You must specify values for all required parameters in the SSM document.
//   You can only supply values to parameters defined in the SSM document.
//
//   * DuplicateInstanceId
//   You cannot specify an instance ID in more than one association.
//
//   * AssociationLimitExceeded
//   You can have at most 2,000 active associations.
//
//   * UnsupportedPlatformType
//   The document does not support the platform type of the given instance ID(s).
//   For example, you sent an SSM document for a Windows instance to a Linux instance.
//
func (c *SSM) CreateAssociationBatch(input *CreateAssociationBatchInput) (*CreateAssociationBatchOutput, error) {
	req, out := c.CreateAssociationBatchRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDocument = "CreateDocument"

// CreateDocumentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDocument operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDocument for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDocument method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDocumentRequest method.
//    req, resp := client.CreateDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) CreateDocumentRequest(input *CreateDocumentInput) (req *request.Request, output *CreateDocumentOutput) {
	op := &request.Operation{
		Name:       opCreateDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDocumentOutput{}
	req.Data = output
	return
}

// CreateDocument API operation for Amazon Simple Systems Management Service.
//
// Creates an SSM document.
//
// After you create an SSM document, you can use CreateAssociation to associate
// it with one or more running instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation CreateDocument for usage and error information.
//
// Returned Error Codes:
//   * DocumentAlreadyExists
//   The specified SSM document already exists.
//
//   * MaxDocumentSizeExceeded
//   The size limit of an SSM document is 64 KB.
//
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocumentContent
//   The content for the SSM document is not valid.
//
//   * DocumentLimitExceeded
//   You can have at most 200 active SSM documents.
//
func (c *SSM) CreateDocument(input *CreateDocumentInput) (*CreateDocumentOutput, error) {
	req, out := c.CreateDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteActivation = "DeleteActivation"

// DeleteActivationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActivation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteActivation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteActivation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteActivationRequest method.
//    req, resp := client.DeleteActivationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DeleteActivationRequest(input *DeleteActivationInput) (req *request.Request, output *DeleteActivationOutput) {
	op := &request.Operation{
		Name:       opDeleteActivation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteActivationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteActivationOutput{}
	req.Data = output
	return
}

// DeleteActivation API operation for Amazon Simple Systems Management Service.
//
// Deletes an activation. You are not required to delete an activation. If you
// delete an activation, you can no longer use it to register additional managed
// instances. Deleting an activation does not de-register managed instances.
// You must manually de-register managed instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteActivation for usage and error information.
//
// Returned Error Codes:
//   * InvalidActivationId
//   The activation ID is not valid. Verify the you entered the correct ActivationId
//   or ActivationCode and try again.
//
//   * InvalidActivation
//   The activation is not valid. The activation might have been deleted, or the
//   ActivationId and the ActivationCode do not match.
//
//   * InternalServerError
//   An error occurred on the server side.
//
func (c *SSM) DeleteActivation(input *DeleteActivationInput) (*DeleteActivationOutput, error) {
	req, out := c.DeleteActivationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAssociation = "DeleteAssociation"

// DeleteAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssociation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAssociation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAssociation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAssociationRequest method.
//    req, resp := client.DeleteAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DeleteAssociationRequest(input *DeleteAssociationInput) (req *request.Request, output *DeleteAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAssociationOutput{}
	req.Data = output
	return
}

// DeleteAssociation API operation for Amazon Simple Systems Management Service.
//
// Disassociates the specified SSM document from the specified instance.
//
// When you disassociate an SSM document from an instance, it does not change
// the configuration of the instance. To change the configuration state of an
// instance after you disassociate a document, you must create a new document
// with the desired configuration and associate it with the instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteAssociation for usage and error information.
//
// Returned Error Codes:
//   * AssociationDoesNotExist
//   The specified association does not exist.
//
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * TooManyUpdates
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
func (c *SSM) DeleteAssociation(input *DeleteAssociationInput) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDocument = "DeleteDocument"

// DeleteDocumentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDocument operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDocument for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDocument method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDocumentRequest method.
//    req, resp := client.DeleteDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DeleteDocumentRequest(input *DeleteDocumentInput) (req *request.Request, output *DeleteDocumentOutput) {
	op := &request.Operation{
		Name:       opDeleteDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDocumentOutput{}
	req.Data = output
	return
}

// DeleteDocument API operation for Amazon Simple Systems Management Service.
//
// Deletes the SSM document and all instance associations to the document.
//
// Before you delete the SSM document, we recommend that you use DeleteAssociation
// to disassociate all instances that are associated with the document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeleteDocument for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * InvalidDocumentOperation
//   You attempted to delete a document while it is still shared. You must stop
//   sharing the document before you can delete it.
//
//   * AssociatedInstances
//   You must disassociate an SSM document from all instances before you can delete
//   it.
//
func (c *SSM) DeleteDocument(input *DeleteDocumentInput) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterManagedInstance = "DeregisterManagedInstance"

// DeregisterManagedInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterManagedInstance operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeregisterManagedInstance for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeregisterManagedInstance method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeregisterManagedInstanceRequest method.
//    req, resp := client.DeregisterManagedInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DeregisterManagedInstanceRequest(input *DeregisterManagedInstanceInput) (req *request.Request, output *DeregisterManagedInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterManagedInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterManagedInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterManagedInstanceOutput{}
	req.Data = output
	return
}

// DeregisterManagedInstance API operation for Amazon Simple Systems Management Service.
//
// Removes the server or virtual machine from the list of registered servers.
// You can reregister the instance again at any time. If you don’t plan to use
// Run Command on the server, we suggest uninstalling the SSM agent first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DeregisterManagedInstance for usage and error information.
//
// Returned Error Codes:
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * InternalServerError
//   An error occurred on the server side.
//
func (c *SSM) DeregisterManagedInstance(input *DeregisterManagedInstanceInput) (*DeregisterManagedInstanceOutput, error) {
	req, out := c.DeregisterManagedInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeActivations = "DescribeActivations"

// DescribeActivationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActivations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeActivations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeActivations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeActivationsRequest method.
//    req, resp := client.DescribeActivationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DescribeActivationsRequest(input *DescribeActivationsInput) (req *request.Request, output *DescribeActivationsOutput) {
	op := &request.Operation{
		Name:       opDescribeActivations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeActivationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeActivationsOutput{}
	req.Data = output
	return
}

// DescribeActivations API operation for Amazon Simple Systems Management Service.
//
// Details about the activation, including: the date and time the activation
// was created, the expiration date, the IAM role assigned to the instances
// in the activation, and the number of instances activated by this registration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeActivations for usage and error information.
//
// Returned Error Codes:
//   * InvalidFilter
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * InvalidNextToken
//   The specified token is not valid.
//
//   * InternalServerError
//   An error occurred on the server side.
//
func (c *SSM) DescribeActivations(input *DescribeActivationsInput) (*DescribeActivationsOutput, error) {
	req, out := c.DescribeActivationsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeActivationsPages iterates over the pages of a DescribeActivations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeActivations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeActivations operation.
//    pageNum := 0
//    err := client.DescribeActivationsPages(params,
//        func(page *DescribeActivationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) DescribeActivationsPages(input *DescribeActivationsInput, fn func(p *DescribeActivationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeActivationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeActivationsOutput), lastPage)
	})
}

const opDescribeAssociation = "DescribeAssociation"

// DescribeAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssociation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAssociation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAssociation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAssociationRequest method.
//    req, resp := client.DescribeAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DescribeAssociationRequest(input *DescribeAssociationInput) (req *request.Request, output *DescribeAssociationOutput) {
	op := &request.Operation{
		Name:       opDescribeAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAssociationOutput{}
	req.Data = output
	return
}

// DescribeAssociation API operation for Amazon Simple Systems Management Service.
//
// Describes the associations for the specified SSM document or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeAssociation for usage and error information.
//
// Returned Error Codes:
//   * AssociationDoesNotExist
//   The specified association does not exist.
//
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
func (c *SSM) DescribeAssociation(input *DescribeAssociationInput) (*DescribeAssociationOutput, error) {
	req, out := c.DescribeAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDocument = "DescribeDocument"

// DescribeDocumentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocument operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeDocument for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeDocument method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeDocumentRequest method.
//    req, resp := client.DescribeDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DescribeDocumentRequest(input *DescribeDocumentInput) (req *request.Request, output *DescribeDocumentOutput) {
	op := &request.Operation{
		Name:       opDescribeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDocumentOutput{}
	req.Data = output
	return
}

// DescribeDocument API operation for Amazon Simple Systems Management Service.
//
// Describes the specified SSM document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocument for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
func (c *SSM) DescribeDocument(input *DescribeDocumentInput) (*DescribeDocumentOutput, error) {
	req, out := c.DescribeDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDocumentPermission = "DescribeDocumentPermission"

// DescribeDocumentPermissionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentPermission operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeDocumentPermission for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeDocumentPermission method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeDocumentPermissionRequest method.
//    req, resp := client.DescribeDocumentPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DescribeDocumentPermissionRequest(input *DescribeDocumentPermissionInput) (req *request.Request, output *DescribeDocumentPermissionOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentPermissionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDocumentPermissionOutput{}
	req.Data = output
	return
}

// DescribeDocumentPermission API operation for Amazon Simple Systems Management Service.
//
// Describes the permissions for an SSM document. If you created the document,
// you are the owner. If a document is shared, it can either be shared privately
// (by specifying a user’s AWS account ID) or publicly (All).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeDocumentPermission for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * InvalidPermissionType
//   The permission type is not supported. Share is the only supported permission
//   type.
//
func (c *SSM) DescribeDocumentPermission(input *DescribeDocumentPermissionInput) (*DescribeDocumentPermissionOutput, error) {
	req, out := c.DescribeDocumentPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInstanceInformation = "DescribeInstanceInformation"

// DescribeInstanceInformationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceInformation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeInstanceInformation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeInstanceInformation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeInstanceInformationRequest method.
//    req, resp := client.DescribeInstanceInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) DescribeInstanceInformationRequest(input *DescribeInstanceInformationInput) (req *request.Request, output *DescribeInstanceInformationOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceInformationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInstanceInformationOutput{}
	req.Data = output
	return
}

// DescribeInstanceInformation API operation for Amazon Simple Systems Management Service.
//
// Describes one or more of your instances. You can use this to get information
// about instances like the operating system platform, the SSM agent version
// (Linux), status etc. If you specify one or more instance IDs, it returns
// information for those instances. If you do not specify instance IDs, it returns
// information for all your instances. If you specify an instance ID that is
// not valid or an instance that you do not own, you receive an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation DescribeInstanceInformation for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * InvalidNextToken
//   The specified token is not valid.
//
//   * InvalidInstanceInformationFilterValue
//   The specified filter value is not valid.
//
//   * InvalidFilterKey
//   The specified key is not valid.
//
func (c *SSM) DescribeInstanceInformation(input *DescribeInstanceInformationInput) (*DescribeInstanceInformationOutput, error) {
	req, out := c.DescribeInstanceInformationRequest(input)
	err := req.Send()
	return out, err
}

// DescribeInstanceInformationPages iterates over the pages of a DescribeInstanceInformation operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceInformation method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstanceInformation operation.
//    pageNum := 0
//    err := client.DescribeInstanceInformationPages(params,
//        func(page *DescribeInstanceInformationOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) DescribeInstanceInformationPages(input *DescribeInstanceInformationInput, fn func(p *DescribeInstanceInformationOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeInstanceInformationRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeInstanceInformationOutput), lastPage)
	})
}

const opGetDocument = "GetDocument"

// GetDocumentRequest generates a "aws/request.Request" representing the
// client's request for the GetDocument operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDocument for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDocument method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDocumentRequest method.
//    req, resp := client.GetDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) GetDocumentRequest(input *GetDocumentInput) (req *request.Request, output *GetDocumentOutput) {
	op := &request.Operation{
		Name:       opGetDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDocumentOutput{}
	req.Data = output
	return
}

// GetDocument API operation for Amazon Simple Systems Management Service.
//
// Gets the contents of the specified SSM document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation GetDocument for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
func (c *SSM) GetDocument(input *GetDocumentInput) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opListAssociations = "ListAssociations"

// ListAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAssociations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAssociations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAssociationsRequest method.
//    req, resp := client.ListAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) ListAssociationsRequest(input *ListAssociationsInput) (req *request.Request, output *ListAssociationsOutput) {
	op := &request.Operation{
		Name:       opListAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAssociationsOutput{}
	req.Data = output
	return
}

// ListAssociations API operation for Amazon Simple Systems Management Service.
//
// Lists the associations for the specified SSM document or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListAssociations for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidNextToken
//   The specified token is not valid.
//
func (c *SSM) ListAssociations(input *ListAssociationsInput) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	err := req.Send()
	return out, err
}

// ListAssociationsPages iterates over the pages of a ListAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssociations operation.
//    pageNum := 0
//    err := client.ListAssociationsPages(params,
//        func(page *ListAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) ListAssociationsPages(input *ListAssociationsInput, fn func(p *ListAssociationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAssociationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAssociationsOutput), lastPage)
	})
}

const opListCommandInvocations = "ListCommandInvocations"

// ListCommandInvocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCommandInvocations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListCommandInvocations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListCommandInvocations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListCommandInvocationsRequest method.
//    req, resp := client.ListCommandInvocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) ListCommandInvocationsRequest(input *ListCommandInvocationsInput) (req *request.Request, output *ListCommandInvocationsOutput) {
	op := &request.Operation{
		Name:       opListCommandInvocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandInvocationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListCommandInvocationsOutput{}
	req.Data = output
	return
}

// ListCommandInvocations API operation for Amazon Simple Systems Management Service.
//
// An invocation is copy of a command sent to a specific instance. A command
// can apply to one or more instances. A command invocation applies to one instance.
// For example, if a user executes SendCommand against three instances, then
// a command invocation is created for each requested instance ID. ListCommandInvocations
// provide status about command execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListCommandInvocations for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidCommandId

//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * InvalidFilterKey
//   The specified key is not valid.
//
//   * InvalidNextToken
//   The specified token is not valid.
//
func (c *SSM) ListCommandInvocations(input *ListCommandInvocationsInput) (*ListCommandInvocationsOutput, error) {
	req, out := c.ListCommandInvocationsRequest(input)
	err := req.Send()
	return out, err
}

// ListCommandInvocationsPages iterates over the pages of a ListCommandInvocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCommandInvocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCommandInvocations operation.
//    pageNum := 0
//    err := client.ListCommandInvocationsPages(params,
//        func(page *ListCommandInvocationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) ListCommandInvocationsPages(input *ListCommandInvocationsInput, fn func(p *ListCommandInvocationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListCommandInvocationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListCommandInvocationsOutput), lastPage)
	})
}

const opListCommands = "ListCommands"

// ListCommandsRequest generates a "aws/request.Request" representing the
// client's request for the ListCommands operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListCommands for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListCommands method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListCommandsRequest method.
//    req, resp := client.ListCommandsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) ListCommandsRequest(input *ListCommandsInput) (req *request.Request, output *ListCommandsOutput) {
	op := &request.Operation{
		Name:       opListCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListCommandsOutput{}
	req.Data = output
	return
}

// ListCommands API operation for Amazon Simple Systems Management Service.
//
// Lists the commands requested by users of the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListCommands for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidCommandId

//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * InvalidFilterKey
//   The specified key is not valid.
//
//   * InvalidNextToken
//   The specified token is not valid.
//
func (c *SSM) ListCommands(input *ListCommandsInput) (*ListCommandsOutput, error) {
	req, out := c.ListCommandsRequest(input)
	err := req.Send()
	return out, err
}

// ListCommandsPages iterates over the pages of a ListCommands operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCommands method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCommands operation.
//    pageNum := 0
//    err := client.ListCommandsPages(params,
//        func(page *ListCommandsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) ListCommandsPages(input *ListCommandsInput, fn func(p *ListCommandsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListCommandsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListCommandsOutput), lastPage)
	})
}

const opListDocuments = "ListDocuments"

// ListDocumentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDocuments operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDocuments for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDocuments method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDocumentsRequest method.
//    req, resp := client.ListDocumentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) ListDocumentsRequest(input *ListDocumentsInput) (req *request.Request, output *ListDocumentsOutput) {
	op := &request.Operation{
		Name:       opListDocuments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDocumentsOutput{}
	req.Data = output
	return
}

// ListDocuments API operation for Amazon Simple Systems Management Service.
//
// Describes one or more of your SSM documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListDocuments for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidNextToken
//   The specified token is not valid.
//
//   * InvalidFilterKey
//   The specified key is not valid.
//
func (c *SSM) ListDocuments(input *ListDocumentsInput) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	err := req.Send()
	return out, err
}

// ListDocumentsPages iterates over the pages of a ListDocuments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocuments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDocuments operation.
//    pageNum := 0
//    err := client.ListDocumentsPages(params,
//        func(page *ListDocumentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) ListDocumentsPages(input *ListDocumentsInput, fn func(p *ListDocumentsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDocumentsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDocumentsOutput), lastPage)
	})
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

// ListTagsForResource API operation for Amazon Simple Systems Management Service.
//
// Returns a list of the tags assigned to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceType
//   The resource type is not valid. If you are attempting to tag an instance,
//   the instance must be a registered, managed instance.
//
//   * InvalidResourceId
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * InternalServerError
//   An error occurred on the server side.
//
func (c *SSM) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opModifyDocumentPermission = "ModifyDocumentPermission"

// ModifyDocumentPermissionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDocumentPermission operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyDocumentPermission for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyDocumentPermission method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyDocumentPermissionRequest method.
//    req, resp := client.ModifyDocumentPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) ModifyDocumentPermissionRequest(input *ModifyDocumentPermissionInput) (req *request.Request, output *ModifyDocumentPermissionOutput) {
	op := &request.Operation{
		Name:       opModifyDocumentPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDocumentPermissionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyDocumentPermissionOutput{}
	req.Data = output
	return
}

// ModifyDocumentPermission API operation for Amazon Simple Systems Management Service.
//
// Share a document publicly or privately. If you share a document privately,
// you must specify the AWS user account IDs for those people who can use the
// document. If you share a document publicly, you must specify All as the account
// ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation ModifyDocumentPermission for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * InvalidPermissionType
//   The permission type is not supported. Share is the only supported permission
//   type.
//
//   * DocumentPermissionLimit
//   The document cannot be shared with more AWS user accounts. You can share
//   a document with a maximum of 20 accounts. You can publicly share up to five
//   documents. If you need to increase this limit, contact AWS Support.
//
//   * DocumentLimitExceeded
//   You can have at most 200 active SSM documents.
//
func (c *SSM) ModifyDocumentPermission(input *ModifyDocumentPermissionInput) (*ModifyDocumentPermissionOutput, error) {
	req, out := c.ModifyDocumentPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsFromResourceOutput{}
	req.Data = output
	return
}

// RemoveTagsFromResource API operation for Amazon Simple Systems Management Service.
//
// Removes all tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceType
//   The resource type is not valid. If you are attempting to tag an instance,
//   the instance must be a registered, managed instance.
//
//   * InvalidResourceId
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * InternalServerError
//   An error occurred on the server side.
//
func (c *SSM) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	err := req.Send()
	return out, err
}

const opSendCommand = "SendCommand"

// SendCommandRequest generates a "aws/request.Request" representing the
// client's request for the SendCommand operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SendCommand for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SendCommand method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SendCommandRequest method.
//    req, resp := client.SendCommandRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) SendCommandRequest(input *SendCommandInput) (req *request.Request, output *SendCommandOutput) {
	op := &request.Operation{
		Name:       opSendCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendCommandInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendCommandOutput{}
	req.Data = output
	return
}

// SendCommand API operation for Amazon Simple Systems Management Service.
//
// Executes commands on one or more remote instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation SendCommand for usage and error information.
//
// Returned Error Codes:
//   * DuplicateInstanceId
//   You cannot specify an instance ID in more than one association.
//
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * InvalidOutputFolder
//   The S3 bucket does not exist.
//
//   * InvalidParameters
//   You must specify values for all required parameters in the SSM document.
//   You can only supply values to parameters defined in the SSM document.
//
//   * UnsupportedPlatformType
//   The document does not support the platform type of the given instance ID(s).
//   For example, you sent an SSM document for a Windows instance to a Linux instance.
//
//   * MaxDocumentSizeExceeded
//   The size limit of an SSM document is 64 KB.
//
//   * InvalidRole
//   The role name can't contain invalid characters. Also verify that you specified
//   an IAM role for notifications that includes the required trust policy. For
//   information about configuring the IAM role for SSM notifications, see Configuring
//   SNS Notifications SSM (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/rc-sns.html)
//   in the Amazon Elastic Compute Cloud User Guide .
//
//   * InvalidNotificationConfig
//   One or more configuration items is not valid. Verify that a valid Amazon
//   Resource Name (ARN) was provided for an Amazon SNS topic.
//
func (c *SSM) SendCommand(input *SendCommandInput) (*SendCommandOutput, error) {
	req, out := c.SendCommandRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAssociationStatus = "UpdateAssociationStatus"

// UpdateAssociationStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssociationStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateAssociationStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateAssociationStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateAssociationStatusRequest method.
//    req, resp := client.UpdateAssociationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) UpdateAssociationStatusRequest(input *UpdateAssociationStatusInput) (req *request.Request, output *UpdateAssociationStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssociationStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAssociationStatusOutput{}
	req.Data = output
	return
}

// UpdateAssociationStatus API operation for Amazon Simple Systems Management Service.
//
// Updates the status of the SSM document associated with the specified instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateAssociationStatus for usage and error information.
//
// Returned Error Codes:
//   * InternalServerError
//   An error occurred on the server side.
//
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * InvalidDocument
//   The specified document does not exist.
//
//   * AssociationDoesNotExist
//   The specified association does not exist.
//
//   * StatusUnchanged
//   The updated status is the same as the current status.
//
//   * TooManyUpdates
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
func (c *SSM) UpdateAssociationStatus(input *UpdateAssociationStatusInput) (*UpdateAssociationStatusOutput, error) {
	req, out := c.UpdateAssociationStatusRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateManagedInstanceRole = "UpdateManagedInstanceRole"

// UpdateManagedInstanceRoleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateManagedInstanceRole operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateManagedInstanceRole for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateManagedInstanceRole method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateManagedInstanceRoleRequest method.
//    req, resp := client.UpdateManagedInstanceRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *SSM) UpdateManagedInstanceRoleRequest(input *UpdateManagedInstanceRoleInput) (req *request.Request, output *UpdateManagedInstanceRoleOutput) {
	op := &request.Operation{
		Name:       opUpdateManagedInstanceRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateManagedInstanceRoleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateManagedInstanceRoleOutput{}
	req.Data = output
	return
}

// UpdateManagedInstanceRole API operation for Amazon Simple Systems Management Service.
//
// Assigns or changes an Amazon Identity and Access Management (IAM) role to
// the managed instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Management Service's
// API operation UpdateManagedInstanceRole for usage and error information.
//
// Returned Error Codes:
//   * InvalidInstanceId
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * InternalServerError
//   An error occurred on the server side.
//
func (c *SSM) UpdateManagedInstanceRole(input *UpdateManagedInstanceRoleInput) (*UpdateManagedInstanceRoleOutput, error) {
	req, out := c.UpdateManagedInstanceRoleRequest(input)
	err := req.Send()
	return out, err
}

// An activation registers one or more on-premises servers or virtual machines
// (VMs) with AWS so that you can configure those servers or VMs using Run Command.
// A server or VM that has been registered with AWS is called a managed instance.
type Activation struct {
	_ struct{} `type:"structure"`

	// The ID created by SSM when you submitted the activation.
	ActivationId *string `type:"string"`

	// The date the activation was created.
	CreatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A name for the managed instance when it is created.
	DefaultInstanceName *string `type:"string"`

	// A user defined description of the activation.
	Description *string `type:"string"`

	// The date when this activation can no longer be used to register managed instances.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Whether or not the activation is expired.
	Expired *bool `type:"boolean"`

	// The Amazon Identity and Access Management (IAM) role to assign to the managed
	// instance.
	IamRole *string `type:"string"`

	// The maximum number of managed instances that can be registered using this
	// activation.
	RegistrationLimit *int64 `min:"1" type:"integer"`

	// The number of managed instances already registered with this activation.
	RegistrationsCount *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s Activation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Activation) GoString() string {
	return s.String()
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ID you want to tag.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Specifies the type of resource you are tagging.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceTypeForTagging"`

	// One or more tags. The value parameter is required, but if you don't want
	// the tag to have a value, specify the parameter with no value, and we set
	// the value to an empty string.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// Describes an association of an SSM document and an instance.
type Association struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The name of the SSM document.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Association) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Association) GoString() string {
	return s.String()
}

// Describes the parameters for a document.
type AssociationDescription struct {
	_ struct{} `type:"structure"`

	// The date when the association was made.
	Date *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The name of the SSM document.
	Name *string `type:"string"`

	// A description of the parameters for a document.
	Parameters map[string][]*string `type:"map"`

	// The association status.
	Status *AssociationStatus `type:"structure"`
}

// String returns the string representation
func (s AssociationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationDescription) GoString() string {
	return s.String()
}

// Describes a filter.
type AssociationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"AssociationFilterKey"`

	// The filter value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an association status.
type AssociationStatus struct {
	_ struct{} `type:"structure"`

	// A user-defined string.
	AdditionalInfo *string `type:"string"`

	// The date when the status changed.
	//
	// Date is a required field
	Date *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The reason for the status.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The status.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"AssociationStatusName"`
}

// String returns the string representation
func (s AssociationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationStatus"}
	if s.Date == nil {
		invalidParams.Add(request.NewErrParamRequired("Date"))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelCommandInput struct {
	_ struct{} `type:"structure"`

	// The ID of the command you want to cancel.
	//
	// CommandId is a required field
	CommandId *string `min:"36" type:"string" required:"true"`

	// (Optional) A list of instance IDs on which you want to cancel the command.
	// If not provided, the command is canceled on every instance on which it was
	// requested.
	InstanceIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s CancelCommandInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCommandInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelCommandInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelCommandInput"}
	if s.CommandId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommandId"))
	}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CommandId", 36))
	}
	if s.InstanceIds != nil && len(s.InstanceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Whether or not the command was successfully canceled. There is no guarantee
// that a request can be canceled.
type CancelCommandOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelCommandOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCommandOutput) GoString() string {
	return s.String()
}

// Describes a command request.
type Command struct {
	_ struct{} `type:"structure"`

	// A unique identifier for this command.
	CommandId *string `min:"36" type:"string"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The name of the SSM document requested for execution.
	DocumentName *string `type:"string"`

	// If this time is reached and the command has not already started executing,
	// it will not execute. Calculated based on the ExpiresAfter user input provided
	// as part of the SendCommand API.
	ExpiresAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The instance IDs against which this command was requested.
	InstanceIds []*string `min:"1" type:"list"`

	// Configurations for sending notifications about command status changes.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The S3 bucket where the responses to the command executions should be stored.
	// This was requested when issuing the command.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 directory path inside the bucket where the responses to the command
	// executions should be stored. This was requested when issuing the command.
	OutputS3KeyPrefix *string `type:"string"`

	// The parameter values to be inserted in the SSM document when executing the
	// command.
	Parameters map[string][]*string `type:"map"`

	// The date and time the command was requested.
	RequestedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The IAM service role that SSM uses to act on your behalf when sending notifications
	// about command status changes.
	ServiceRole *string `type:"string"`

	// The status of the command.
	Status *string `type:"string" enum:"CommandStatus"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Command) GoString() string {
	return s.String()
}

// Describes a command filter.
type CommandFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. For example, requested date and time.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"CommandFilterKey"`

	// The filter value. For example: June 30, 2015.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CommandFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CommandFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CommandFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An invocation is copy of a command sent to a specific instance. A command
// can apply to one or more instances. A command invocation applies to one instance.
// For example, if a user executes SendCommand against three instances, then
// a command invocation is created for each requested instance ID. A command
// invocation returns status and detail information about a command you executed.
type CommandInvocation struct {
	_ struct{} `type:"structure"`

	// The command against which this invocation was requested.
	CommandId *string `min:"36" type:"string"`

	CommandPlugins []*CommandPlugin `type:"list"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The document name that was requested for execution.
	DocumentName *string `type:"string"`

	// The instance ID in which this invocation was requested.
	InstanceId *string `type:"string"`

	// Configurations for sending notifications about command status changes on
	// a per instance basis.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The time and date the request was sent to this instance.
	RequestedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The IAM service role that SSM uses to act on your behalf when sending notifications
	// about command status changes on a per instance basis.
	ServiceRole *string `type:"string"`

	// Whether or not the invocation succeeded, failed, or is pending.
	Status *string `type:"string" enum:"CommandInvocationStatus"`

	// Gets the trace output sent by the agent.
	TraceOutput *string `type:"string"`
}

// String returns the string representation
func (s CommandInvocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandInvocation) GoString() string {
	return s.String()
}

// Describes plugin details.
type CommandPlugin struct {
	_ struct{} `type:"structure"`

	// The name of the plugin. Must be one of the following: aws:updateAgent, aws:domainjoin,
	// aws:applications, aws:runPowerShellScript, aws:psmodule, aws:cloudWatch,
	// aws:runShellScript, or aws:updateSSMAgent.
	Name *string `min:"4" type:"string"`

	// Output of the plugin execution.
	Output *string `type:"string"`

	// The S3 bucket where the responses to the command executions should be stored.
	// This was requested when issuing the command.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 directory path inside the bucket where the responses to the command
	// executions should be stored. This was requested when issuing the command.
	OutputS3KeyPrefix *string `type:"string"`

	// A numeric response code generated after executing the plugin.
	ResponseCode *int64 `type:"integer"`

	// The time the plugin stopped executing. Could stop prematurely if, for example,
	// a cancel command was sent.
	ResponseFinishDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time the plugin started executing.
	ResponseStartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of this plugin. You can execute a document with multiple plugins.
	Status *string `type:"string" enum:"CommandPluginStatus"`
}

// String returns the string representation
func (s CommandPlugin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandPlugin) GoString() string {
	return s.String()
}

type CreateActivationInput struct {
	_ struct{} `type:"structure"`

	// The name of the registered, managed instance as it will appear in the Amazon
	// EC2 console or when you use the AWS command line tools to list EC2 resources.
	DefaultInstanceName *string `type:"string"`

	// A user-defined description of the resource that you want to register with
	// Amazon EC2.
	Description *string `type:"string"`

	// The date by which this activation request should expire. The default value
	// is 24 hours.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Identity and Access Management (IAM) role that you want to assign
	// to the managed instance.
	//
	// IamRole is a required field
	IamRole *string `type:"string" required:"true"`

	// Specify the maximum number of managed instances you want to register. The
	// default value is 1 instance.
	RegistrationLimit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s CreateActivationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActivationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateActivationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateActivationInput"}
	if s.IamRole == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRole"))
	}
	if s.RegistrationLimit != nil && *s.RegistrationLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RegistrationLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateActivationOutput struct {
	_ struct{} `type:"structure"`

	// The code the system generates when it processes the activation. The activation
	// code functions like a password to validate the activation ID.
	ActivationCode *string `min:"20" type:"string"`

	// The ID number generated by the system when it processed the activation. The
	// activation ID functions like a user name.
	ActivationId *string `type:"string"`
}

// String returns the string representation
func (s CreateActivationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActivationOutput) GoString() string {
	return s.String()
}

type CreateAssociationBatchInput struct {
	_ struct{} `type:"structure"`

	// One or more associations.
	//
	// Entries is a required field
	Entries []*CreateAssociationBatchRequestEntry `locationNameList:"entries" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateAssociationBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssociationBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssociationBatchInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAssociationBatchOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations that failed.
	Failed []*FailedCreateAssociation `locationNameList:"FailedCreateAssociationEntry" type:"list"`

	// Information about the associations that succeeded.
	Successful []*AssociationDescription `locationNameList:"AssociationDescription" type:"list"`
}

// String returns the string representation
func (s CreateAssociationBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchOutput) GoString() string {
	return s.String()
}

// Describes the association of an SSM document and an instance.
type CreateAssociationBatchRequestEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The name of the configuration document.
	Name *string `type:"string"`

	// A description of the parameters for a document.
	Parameters map[string][]*string `type:"map"`
}

// String returns the string representation
func (s CreateAssociationBatchRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchRequestEntry) GoString() string {
	return s.String()
}

type CreateAssociationInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The name of the SSM document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The parameters for the documents runtime configuration.
	Parameters map[string][]*string `type:"map"`
}

// String returns the string representation
func (s CreateAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssociationInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s CreateAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationOutput) GoString() string {
	return s.String()
}

type CreateDocumentInput struct {
	_ struct{} `type:"structure"`

	// A valid JSON string.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// A name for the SSM document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDocumentInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDocumentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SSM document.
	DocumentDescription *DocumentDescription `type:"structure"`
}

// String returns the string representation
func (s CreateDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentOutput) GoString() string {
	return s.String()
}

type DeleteActivationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the activation that you want to delete.
	//
	// ActivationId is a required field
	ActivationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteActivationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActivationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteActivationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteActivationInput"}
	if s.ActivationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteActivationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteActivationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActivationOutput) GoString() string {
	return s.String()
}

type DeleteAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The name of the SSM document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssociationInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssociationOutput) GoString() string {
	return s.String()
}

type DeleteDocumentInput struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDocumentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDocumentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentOutput) GoString() string {
	return s.String()
}

type DeregisterManagedInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the managed instance when you registered it using the
	// activation process.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterManagedInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterManagedInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterManagedInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterManagedInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterManagedInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterManagedInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterManagedInstanceOutput) GoString() string {
	return s.String()
}

// Filter for the DescribeActivation API.
type DescribeActivationsFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	FilterKey *string `type:"string" enum:"DescribeActivationsFilterKeys"`

	// The filter values.
	FilterValues []*string `type:"list"`
}

// String returns the string representation
func (s DescribeActivationsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivationsFilter) GoString() string {
	return s.String()
}

type DescribeActivationsInput struct {
	_ struct{} `type:"structure"`

	// A filter to view information about your activations.
	Filters []*DescribeActivationsFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActivationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActivationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeActivationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeActivationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of activations for your AWS account.
	ActivationList []*Activation `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActivationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivationsOutput) GoString() string {
	return s.String()
}

type DescribeAssociationInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The name of the SSM document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssociationInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationOutput) GoString() string {
	return s.String()
}

type DescribeDocumentInput struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDocumentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SSM document.
	Document *DocumentDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentOutput) GoString() string {
	return s.String()
}

type DescribeDocumentPermissionInput struct {
	_ struct{} `type:"structure"`

	// The name of the document for which you are the owner.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The permission type for the document. The permission type can be Share.
	//
	// PermissionType is a required field
	PermissionType *string `type:"string" required:"true" enum:"DocumentPermissionType"`
}

// String returns the string representation
func (s DescribeDocumentPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentPermissionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDocumentPermissionOutput struct {
	_ struct{} `type:"structure"`

	// The account IDs that have permission to use this document. The ID can be
	// either an AWS account or All.
	AccountIds []*string `locationNameList:"AccountId" type:"list"`
}

// String returns the string representation
func (s DescribeDocumentPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentPermissionOutput) GoString() string {
	return s.String()
}

type DescribeInstanceInformationInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of instances.
	InstanceInformationFilterList []*InstanceInformationFilter `locationNameList:"InstanceInformationFilter" min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceInformationInput"}
	if s.InstanceInformationFilterList != nil && len(s.InstanceInformationFilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceInformationFilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}
	if s.InstanceInformationFilterList != nil {
		for i, v := range s.InstanceInformationFilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceInformationFilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeInstanceInformationOutput struct {
	_ struct{} `type:"structure"`

	// The instance information list.
	InstanceInformationList []*InstanceInformation `locationNameList:"InstanceInformation" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceInformationOutput) GoString() string {
	return s.String()
}

// Describes an SSM document.
type DocumentDescription struct {
	_ struct{} `type:"structure"`

	// The date when the SSM document was created.
	CreatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A description of the document.
	Description *string `type:"string"`

	// The Sha256 or Sha1 hash created by the system when the document was created.
	//
	// Sha1 hashes have been deprecated.
	Hash *string `type:"string"`

	// Sha256 or Sha1.
	//
	// Sha1 hashes have been deprecated.
	HashType *string `type:"string" enum:"DocumentHashType"`

	// The name of the SSM document.
	Name *string `type:"string"`

	// The AWS user account of the person who created the document.
	Owner *string `type:"string"`

	// A description of the parameters for a document.
	Parameters []*DocumentParameter `locationNameList:"DocumentParameter" type:"list"`

	// The list of OS platforms compatible with this SSM document.
	PlatformTypes []*string `locationNameList:"PlatformType" type:"list"`

	// The SHA1 hash of the document, which you can use for verification purposes.
	Sha1 *string `type:"string"`

	// The status of the SSM document.
	Status *string `type:"string" enum:"DocumentStatus"`
}

// String returns the string representation
func (s DocumentDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentDescription) GoString() string {
	return s.String()
}

// Describes a filter.
type DocumentFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"DocumentFilterKey"`

	// The value of the filter.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DocumentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the name of an SSM document.
type DocumentIdentifier struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document.
	Name *string `type:"string"`

	// The AWS user account of the person who created the document.
	Owner *string `type:"string"`

	// The operating system platform.
	PlatformTypes []*string `locationNameList:"PlatformType" type:"list"`
}

// String returns the string representation
func (s DocumentIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentIdentifier) GoString() string {
	return s.String()
}

// Parameters specified in the SSM document that execute on the server when
// the command is run.
type DocumentParameter struct {
	_ struct{} `type:"structure"`

	// If specified, the default values for the parameters. Parameters without a
	// default value are required. Parameters with a default value are optional.
	DefaultValue *string `type:"string"`

	// A description of what the parameter does, how to use it, the default value,
	// and whether or not the parameter is optional.
	Description *string `type:"string"`

	// The name of the parameter.
	Name *string `type:"string"`

	// The type of parameter. The type can be either “String” or “StringList”.
	Type *string `type:"string" enum:"DocumentParameterType"`
}

// String returns the string representation
func (s DocumentParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentParameter) GoString() string {
	return s.String()
}

// Describes a failed association.
type FailedCreateAssociation struct {
	_ struct{} `type:"structure"`

	// The association.
	Entry *CreateAssociationBatchRequestEntry `type:"structure"`

	// The source of the failure.
	Fault *string `type:"string" enum:"Fault"`

	// A description of the failure.
	Message *string `type:"string"`
}

// String returns the string representation
func (s FailedCreateAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedCreateAssociation) GoString() string {
	return s.String()
}

type GetDocumentInput struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the SSM document.
	Content *string `min:"1" type:"string"`

	// The name of the SSM document.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GetDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentOutput) GoString() string {
	return s.String()
}

// Describes a filter for a specific list of instances.
type InstanceInformation struct {
	_ struct{} `type:"structure"`

	// The activation ID created by SSM when the server or VM was registered.
	ActivationId *string `type:"string"`

	// The version of the SSM agent running on your Linux instance.
	AgentVersion *string `type:"string"`

	// The fully qualified host name of the managed instance.
	ComputerName *string `min:"1" type:"string"`

	// The IP address of the managed instance.
	IPAddress *string `min:"1" type:"string"`

	// The Amazon Identity and Access Management (IAM) role assigned to EC2 instances
	// or managed instances.
	IamRole *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// Indicates whether latest version of the SSM agent is running on your instance.
	IsLatestVersion *bool `type:"boolean"`

	// The date and time when agent last pinged SSM service.
	LastPingDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the managed instance.
	Name *string `type:"string"`

	// Connection status of the SSM agent.
	PingStatus *string `type:"string" enum:"PingStatus"`

	// The name of the operating system platform running on your instance.
	PlatformName *string `type:"string"`

	// The operating system platform type.
	PlatformType *string `type:"string" enum:"PlatformType"`

	// The version of the OS platform running on your instance.
	PlatformVersion *string `type:"string"`

	// The date the server or VM was registered with AWS as a managed instance.
	RegistrationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The type of instance. Instances are either EC2 instances or managed instances.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s InstanceInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInformation) GoString() string {
	return s.String()
}

// Describes a filter for a specific list of instances.
type InstanceInformationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"InstanceInformationFilterKey"`

	// The filter values.
	//
	// ValueSet is a required field
	ValueSet []*string `locationName:"valueSet" locationNameList:"InstanceInformationFilterValue" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceInformationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInformationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceInformationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceInformationFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.ValueSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ValueSet"))
	}
	if s.ValueSet != nil && len(s.ValueSet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueSet", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAssociationsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	//
	// AssociationFilterList is a required field
	AssociationFilterList []*AssociationFilter `locationNameList:"AssociationFilter" min:"1" type:"list" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociationsInput"}
	if s.AssociationFilterList == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationFilterList"))
	}
	if s.AssociationFilterList != nil && len(s.AssociationFilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationFilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.AssociationFilterList != nil {
		for i, v := range s.AssociationFilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssociationFilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The associations.
	Associations []*Association `locationNameList:"Association" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsOutput) GoString() string {
	return s.String()
}

type ListCommandInvocationsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The invocations for a specific command ID.
	CommandId *string `min:"36" type:"string"`

	// (Optional) If set this returns the response of the command executions and
	// any command output. By default this is set to False.
	Details *bool `type:"boolean"`

	// (Optional) One or more filters. Use a filter to return a more specific list
	// of results.
	Filters []*CommandFilter `min:"1" type:"list"`

	// (Optional) The command execution details for a specific instance ID.
	InstanceId *string `type:"string"`

	// (Optional) The maximum number of items to return for this call. The call
	// also returns a token that you can specify in a subsequent call to get the
	// next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandInvocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandInvocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCommandInvocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCommandInvocationsInput"}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CommandId", 36))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListCommandInvocationsOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) A list of all invocations.
	CommandInvocations []*CommandInvocation `type:"list"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandInvocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandInvocationsOutput) GoString() string {
	return s.String()
}

type ListCommandsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) If provided, lists only the specified command.
	CommandId *string `min:"36" type:"string"`

	// (Optional) One or more filters. Use a filter to return a more specific list
	// of results.
	Filters []*CommandFilter `min:"1" type:"list"`

	// (Optional) Lists commands issued against this instance ID.
	InstanceId *string `type:"string"`

	// (Optional) The maximum number of items to return for this call. The call
	// also returns a token that you can specify in a subsequent call to get the
	// next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCommandsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCommandsInput"}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CommandId", 36))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListCommandsOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) The list of commands requested by the user.
	Commands []*Command `type:"list"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandsOutput) GoString() string {
	return s.String()
}

type ListDocumentsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	DocumentFilterList []*DocumentFilter `locationNameList:"DocumentFilter" min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentsInput"}
	if s.DocumentFilterList != nil && len(s.DocumentFilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentFilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.DocumentFilterList != nil {
		for i, v := range s.DocumentFilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentFilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDocumentsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the SSM documents.
	DocumentIdentifiers []*DocumentIdentifier `locationNameList:"DocumentIdentifier" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentsOutput) GoString() string {
	return s.String()
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ID for which you want to see a list of tags.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Returns a list of tags for a specific resource type.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceTypeForTagging"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

type ModifyDocumentPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS user accounts that should have access to the document. The account
	// IDs can either be a group of account IDs or All.
	AccountIdsToAdd []*string `locationNameList:"AccountId" type:"list"`

	// The AWS user accounts that should no longer have access to the document.
	// The AWS user account can either be a group of account IDs or All. This action
	// has a higher priority than AccountIdsToAdd. If you specify an account ID
	// to add and the same ID to remove, the system removes access to the document.
	AccountIdsToRemove []*string `locationNameList:"AccountId" type:"list"`

	// The name of the document that you want to share.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The permission type for the document. The permission type can be Share.
	//
	// PermissionType is a required field
	PermissionType *string `type:"string" required:"true" enum:"DocumentPermissionType"`
}

// String returns the string representation
func (s ModifyDocumentPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDocumentPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDocumentPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDocumentPermissionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyDocumentPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyDocumentPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDocumentPermissionOutput) GoString() string {
	return s.String()
}

// Configurations for sending notifications.
type NotificationConfig struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic.
	// SSM pushes notifications about command status changes to this topic.
	NotificationArn *string `type:"string"`

	// The different events for which you can receive notifications. These events
	// include the following: All (events), InProgress, Success, TimedOut, Cancelled,
	// Failed. To learn more about these events, see Monitoring Commands (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitor-commands.html)
	// in the Amazon Elastic Compute Cloud User Guide .
	NotificationEvents []*string `type:"list"`

	// Command: Receive notification when the status of a command changes. Invocation:
	// For commands sent to multiple instances, receive notification on a per-instance
	// basis when the status of a command changes.
	NotificationType *string `type:"string" enum:"NotificationType"`
}

// String returns the string representation
func (s NotificationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfig) GoString() string {
	return s.String()
}

type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ID for which you want to remove tags.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of resource of which you want to remove a tag.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceTypeForTagging"`

	// Tag keys that you want to remove from the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

type SendCommandInput struct {
	_ struct{} `type:"structure"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The Sha256 or Sha1 hash created by the system when the document was created.
	//
	// Sha1 hashes have been deprecated.
	DocumentHash *string `type:"string"`

	// Sha256 or Sha1.
	//
	// Sha1 hashes have been deprecated.
	DocumentHashType *string `type:"string" enum:"DocumentHashType"`

	// Required. The name of the SSM document to execute. This can be an SSM public
	// document or a custom document.
	//
	// DocumentName is a required field
	DocumentName *string `type:"string" required:"true"`

	// Required. The instance IDs where the command should execute. You can specify
	// a maximum of 50 IDs.
	//
	// InstanceIds is a required field
	InstanceIds []*string `min:"1" type:"list" required:"true"`

	// Configurations for sending notifications.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The name of the S3 bucket where command execution responses should be stored.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The directory structure within the S3 bucket where the responses should be
	// stored.
	OutputS3KeyPrefix *string `type:"string"`

	// The required and optional parameters specified in the SSM document being
	// executed.
	Parameters map[string][]*string `type:"map"`

	// The IAM role that SSM uses to send notifications.
	ServiceRoleArn *string `type:"string"`

	// If this time is reached and the command has not already started executing,
	// it will not execute.
	TimeoutSeconds *int64 `min:"30" type:"integer"`
}

// String returns the string representation
func (s SendCommandInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendCommandInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendCommandInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendCommandInput"}
	if s.DocumentName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentName"))
	}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}
	if s.InstanceIds != nil && len(s.InstanceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceIds", 1))
	}
	if s.OutputS3BucketName != nil && len(*s.OutputS3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("OutputS3BucketName", 3))
	}
	if s.TimeoutSeconds != nil && *s.TimeoutSeconds < 30 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutSeconds", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SendCommandOutput struct {
	_ struct{} `type:"structure"`

	// The request as it was received by SSM. Also provides the command ID which
	// can be used future references to this request.
	Command *Command `type:"structure"`
}

// String returns the string representation
func (s SendCommandOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendCommandOutput) GoString() string {
	return s.String()
}

// Metadata that you assign to your managed instances. Tags enable you to categorize
// your managed instances in different ways, for example, by purpose, owner,
// or environment.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateAssociationStatusInput struct {
	_ struct{} `type:"structure"`

	// The association status.
	//
	// AssociationStatus is a required field
	AssociationStatus *AssociationStatus `type:"structure" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The name of the SSM document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAssociationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssociationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssociationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssociationStatusInput"}
	if s.AssociationStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationStatus"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.AssociationStatus != nil {
		if err := s.AssociationStatus.Validate(); err != nil {
			invalidParams.AddNested("AssociationStatus", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateAssociationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateAssociationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssociationStatusOutput) GoString() string {
	return s.String()
}

type UpdateManagedInstanceRoleInput struct {
	_ struct{} `type:"structure"`

	// The IAM role you want to assign or change.
	//
	// IamRole is a required field
	IamRole *string `type:"string" required:"true"`

	// The ID of the managed instance where you want to update the role.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateManagedInstanceRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateManagedInstanceRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateManagedInstanceRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateManagedInstanceRoleInput"}
	if s.IamRole == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRole"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateManagedInstanceRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateManagedInstanceRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateManagedInstanceRoleOutput) GoString() string {
	return s.String()
}

const (
	// AssociationFilterKeyInstanceId is a AssociationFilterKey enum value
	AssociationFilterKeyInstanceId = "InstanceId"

	// AssociationFilterKeyName is a AssociationFilterKey enum value
	AssociationFilterKeyName = "Name"
)

const (
	// AssociationStatusNamePending is a AssociationStatusName enum value
	AssociationStatusNamePending = "Pending"

	// AssociationStatusNameSuccess is a AssociationStatusName enum value
	AssociationStatusNameSuccess = "Success"

	// AssociationStatusNameFailed is a AssociationStatusName enum value
	AssociationStatusNameFailed = "Failed"
)

const (
	// CommandFilterKeyInvokedAfter is a CommandFilterKey enum value
	CommandFilterKeyInvokedAfter = "InvokedAfter"

	// CommandFilterKeyInvokedBefore is a CommandFilterKey enum value
	CommandFilterKeyInvokedBefore = "InvokedBefore"

	// CommandFilterKeyStatus is a CommandFilterKey enum value
	CommandFilterKeyStatus = "Status"
)

const (
	// CommandInvocationStatusPending is a CommandInvocationStatus enum value
	CommandInvocationStatusPending = "Pending"

	// CommandInvocationStatusInProgress is a CommandInvocationStatus enum value
	CommandInvocationStatusInProgress = "InProgress"

	// CommandInvocationStatusCancelling is a CommandInvocationStatus enum value
	CommandInvocationStatusCancelling = "Cancelling"

	// CommandInvocationStatusSuccess is a CommandInvocationStatus enum value
	CommandInvocationStatusSuccess = "Success"

	// CommandInvocationStatusTimedOut is a CommandInvocationStatus enum value
	CommandInvocationStatusTimedOut = "TimedOut"

	// CommandInvocationStatusCancelled is a CommandInvocationStatus enum value
	CommandInvocationStatusCancelled = "Cancelled"

	// CommandInvocationStatusFailed is a CommandInvocationStatus enum value
	CommandInvocationStatusFailed = "Failed"
)

const (
	// CommandPluginStatusPending is a CommandPluginStatus enum value
	CommandPluginStatusPending = "Pending"

	// CommandPluginStatusInProgress is a CommandPluginStatus enum value
	CommandPluginStatusInProgress = "InProgress"

	// CommandPluginStatusSuccess is a CommandPluginStatus enum value
	CommandPluginStatusSuccess = "Success"

	// CommandPluginStatusTimedOut is a CommandPluginStatus enum value
	CommandPluginStatusTimedOut = "TimedOut"

	// CommandPluginStatusCancelled is a CommandPluginStatus enum value
	CommandPluginStatusCancelled = "Cancelled"

	// CommandPluginStatusFailed is a CommandPluginStatus enum value
	CommandPluginStatusFailed = "Failed"
)

const (
	// CommandStatusPending is a CommandStatus enum value
	CommandStatusPending = "Pending"

	// CommandStatusInProgress is a CommandStatus enum value
	CommandStatusInProgress = "InProgress"

	// CommandStatusCancelling is a CommandStatus enum value
	CommandStatusCancelling = "Cancelling"

	// CommandStatusSuccess is a CommandStatus enum value
	CommandStatusSuccess = "Success"

	// CommandStatusTimedOut is a CommandStatus enum value
	CommandStatusTimedOut = "TimedOut"

	// CommandStatusCancelled is a CommandStatus enum value
	CommandStatusCancelled = "Cancelled"

	// CommandStatusFailed is a CommandStatus enum value
	CommandStatusFailed = "Failed"
)

const (
	// DescribeActivationsFilterKeysActivationIds is a DescribeActivationsFilterKeys enum value
	DescribeActivationsFilterKeysActivationIds = "ActivationIds"

	// DescribeActivationsFilterKeysDefaultInstanceName is a DescribeActivationsFilterKeys enum value
	DescribeActivationsFilterKeysDefaultInstanceName = "DefaultInstanceName"

	// DescribeActivationsFilterKeysIamRole is a DescribeActivationsFilterKeys enum value
	DescribeActivationsFilterKeysIamRole = "IamRole"
)

const (
	// DocumentFilterKeyName is a DocumentFilterKey enum value
	DocumentFilterKeyName = "Name"

	// DocumentFilterKeyOwner is a DocumentFilterKey enum value
	DocumentFilterKeyOwner = "Owner"

	// DocumentFilterKeyPlatformTypes is a DocumentFilterKey enum value
	DocumentFilterKeyPlatformTypes = "PlatformTypes"
)

const (
	// DocumentHashTypeSha256 is a DocumentHashType enum value
	DocumentHashTypeSha256 = "Sha256"

	// DocumentHashTypeSha1 is a DocumentHashType enum value
	DocumentHashTypeSha1 = "Sha1"
)

const (
	// DocumentParameterTypeString is a DocumentParameterType enum value
	DocumentParameterTypeString = "String"

	// DocumentParameterTypeStringList is a DocumentParameterType enum value
	DocumentParameterTypeStringList = "StringList"
)

const (
	// DocumentPermissionTypeShare is a DocumentPermissionType enum value
	DocumentPermissionTypeShare = "Share"
)

const (
	// DocumentStatusCreating is a DocumentStatus enum value
	DocumentStatusCreating = "Creating"

	// DocumentStatusActive is a DocumentStatus enum value
	DocumentStatusActive = "Active"

	// DocumentStatusDeleting is a DocumentStatus enum value
	DocumentStatusDeleting = "Deleting"
)

const (
	// FaultClient is a Fault enum value
	FaultClient = "Client"

	// FaultServer is a Fault enum value
	FaultServer = "Server"

	// FaultUnknown is a Fault enum value
	FaultUnknown = "Unknown"
)

const (
	// InstanceInformationFilterKeyInstanceIds is a InstanceInformationFilterKey enum value
	InstanceInformationFilterKeyInstanceIds = "InstanceIds"

	// InstanceInformationFilterKeyAgentVersion is a InstanceInformationFilterKey enum value
	InstanceInformationFilterKeyAgentVersion = "AgentVersion"

	// InstanceInformationFilterKeyPingStatus is a InstanceInformationFilterKey enum value
	InstanceInformationFilterKeyPingStatus = "PingStatus"

	// InstanceInformationFilterKeyPlatformTypes is a InstanceInformationFilterKey enum value
	InstanceInformationFilterKeyPlatformTypes = "PlatformTypes"

	// InstanceInformationFilterKeyActivationIds is a InstanceInformationFilterKey enum value
	InstanceInformationFilterKeyActivationIds = "ActivationIds"

	// InstanceInformationFilterKeyIamRole is a InstanceInformationFilterKey enum value
	InstanceInformationFilterKeyIamRole = "IamRole"

	// InstanceInformationFilterKeyResourceType is a InstanceInformationFilterKey enum value
	InstanceInformationFilterKeyResourceType = "ResourceType"
)

const (
	// NotificationEventAll is a NotificationEvent enum value
	NotificationEventAll = "All"

	// NotificationEventInProgress is a NotificationEvent enum value
	NotificationEventInProgress = "InProgress"

	// NotificationEventSuccess is a NotificationEvent enum value
	NotificationEventSuccess = "Success"

	// NotificationEventTimedOut is a NotificationEvent enum value
	NotificationEventTimedOut = "TimedOut"

	// NotificationEventCancelled is a NotificationEvent enum value
	NotificationEventCancelled = "Cancelled"

	// NotificationEventFailed is a NotificationEvent enum value
	NotificationEventFailed = "Failed"
)

const (
	// NotificationTypeCommand is a NotificationType enum value
	NotificationTypeCommand = "Command"

	// NotificationTypeInvocation is a NotificationType enum value
	NotificationTypeInvocation = "Invocation"
)

const (
	// PingStatusOnline is a PingStatus enum value
	PingStatusOnline = "Online"

	// PingStatusConnectionLost is a PingStatus enum value
	PingStatusConnectionLost = "ConnectionLost"

	// PingStatusInactive is a PingStatus enum value
	PingStatusInactive = "Inactive"
)

const (
	// PlatformTypeWindows is a PlatformType enum value
	PlatformTypeWindows = "Windows"

	// PlatformTypeLinux is a PlatformType enum value
	PlatformTypeLinux = "Linux"
)

const (
	// ResourceTypeManagedInstance is a ResourceType enum value
	ResourceTypeManagedInstance = "ManagedInstance"

	// ResourceTypeDocument is a ResourceType enum value
	ResourceTypeDocument = "Document"

	// ResourceTypeEc2instance is a ResourceType enum value
	ResourceTypeEc2instance = "EC2Instance"
)

const (
	// ResourceTypeForTaggingManagedInstance is a ResourceTypeForTagging enum value
	ResourceTypeForTaggingManagedInstance = "ManagedInstance"
)
