// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cognitoidentityprovider provides a client for Amazon Cognito Identity Provider.
package cognitoidentityprovider

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddCustomAttributes = "AddCustomAttributes"

// AddCustomAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AddCustomAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddCustomAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddCustomAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddCustomAttributesRequest method.
//    req, resp := client.AddCustomAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AddCustomAttributesRequest(input *AddCustomAttributesInput) (req *request.Request, output *AddCustomAttributesOutput) {
	op := &request.Operation{
		Name:       opAddCustomAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCustomAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddCustomAttributesOutput{}
	req.Data = output
	return
}

// AddCustomAttributes API operation for Amazon Cognito Identity Provider.
//
// Adds additional user attributes to the user pool schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AddCustomAttributes for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserImportInProgressException
//   This exception is thrown when you are trying to modify a user pool while
//   a user import job is in progress for that pool.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AddCustomAttributes(input *AddCustomAttributesInput) (*AddCustomAttributesOutput, error) {
	req, out := c.AddCustomAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opAdminConfirmSignUp = "AdminConfirmSignUp"

// AdminConfirmSignUpRequest generates a "aws/request.Request" representing the
// client's request for the AdminConfirmSignUp operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminConfirmSignUp for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminConfirmSignUp method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminConfirmSignUpRequest method.
//    req, resp := client.AdminConfirmSignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminConfirmSignUpRequest(input *AdminConfirmSignUpInput) (req *request.Request, output *AdminConfirmSignUpOutput) {
	op := &request.Operation{
		Name:       opAdminConfirmSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminConfirmSignUpInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminConfirmSignUpOutput{}
	req.Data = output
	return
}

// AdminConfirmSignUp API operation for Amazon Cognito Identity Provider.
//
// Confirms user registration as an admin without using a confirmation code.
// Works on any user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminConfirmSignUp for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyFailedAttemptsException
//   This exception gets thrown when the user has made too many failed attempts
//   for a given action (e.g., sign in).
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminConfirmSignUp(input *AdminConfirmSignUpInput) (*AdminConfirmSignUpOutput, error) {
	req, out := c.AdminConfirmSignUpRequest(input)
	err := req.Send()
	return out, err
}

const opAdminCreateUser = "AdminCreateUser"

// AdminCreateUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminCreateUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminCreateUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminCreateUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminCreateUserRequest method.
//    req, resp := client.AdminCreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminCreateUserRequest(input *AdminCreateUserInput) (req *request.Request, output *AdminCreateUserOutput) {
	op := &request.Operation{
		Name:       opAdminCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminCreateUserInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminCreateUserOutput{}
	req.Data = output
	return
}

// AdminCreateUser API operation for Amazon Cognito Identity Provider.
//
// Creates a new user in the specified user pool and sends a welcome message
// via email or phone (SMS). This message is based on a template that you configured
// in your call to CreateUserPool or UpdateUserPool. This template includes
// your custom sign-up instructions and placeholders for user name and temporary
// password.
//
// Requires developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminCreateUser for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UsernameExistsException
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * InvalidPasswordException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * PreconditionNotMetException
//   This exception is thrown when a precondition is not met.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UnsupportedUserStateException
//   The request failed because the user is in an unsupported state.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminCreateUser(input *AdminCreateUserInput) (*AdminCreateUserOutput, error) {
	req, out := c.AdminCreateUserRequest(input)
	err := req.Send()
	return out, err
}

const opAdminDeleteUser = "AdminDeleteUser"

// AdminDeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminDeleteUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminDeleteUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminDeleteUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminDeleteUserRequest method.
//    req, resp := client.AdminDeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminDeleteUserRequest(input *AdminDeleteUserInput) (req *request.Request, output *AdminDeleteUserOutput) {
	op := &request.Operation{
		Name:       opAdminDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDeleteUserInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AdminDeleteUserOutput{}
	req.Data = output
	return
}

// AdminDeleteUser API operation for Amazon Cognito Identity Provider.
//
// Deletes a user as an administrator. Works on any user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminDeleteUser(input *AdminDeleteUserInput) (*AdminDeleteUserOutput, error) {
	req, out := c.AdminDeleteUserRequest(input)
	err := req.Send()
	return out, err
}

const opAdminDeleteUserAttributes = "AdminDeleteUserAttributes"

// AdminDeleteUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AdminDeleteUserAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminDeleteUserAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminDeleteUserAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminDeleteUserAttributesRequest method.
//    req, resp := client.AdminDeleteUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminDeleteUserAttributesRequest(input *AdminDeleteUserAttributesInput) (req *request.Request, output *AdminDeleteUserAttributesOutput) {
	op := &request.Operation{
		Name:       opAdminDeleteUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDeleteUserAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminDeleteUserAttributesOutput{}
	req.Data = output
	return
}

// AdminDeleteUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Deletes the user attributes in a user pool as an administrator. Works on
// any user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDeleteUserAttributes for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminDeleteUserAttributes(input *AdminDeleteUserAttributesInput) (*AdminDeleteUserAttributesOutput, error) {
	req, out := c.AdminDeleteUserAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opAdminDisableUser = "AdminDisableUser"

// AdminDisableUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminDisableUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminDisableUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminDisableUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminDisableUserRequest method.
//    req, resp := client.AdminDisableUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminDisableUserRequest(input *AdminDisableUserInput) (req *request.Request, output *AdminDisableUserOutput) {
	op := &request.Operation{
		Name:       opAdminDisableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminDisableUserInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminDisableUserOutput{}
	req.Data = output
	return
}

// AdminDisableUser API operation for Amazon Cognito Identity Provider.
//
// Disables the specified user as an administrator. Works on any user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminDisableUser for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminDisableUser(input *AdminDisableUserInput) (*AdminDisableUserOutput, error) {
	req, out := c.AdminDisableUserRequest(input)
	err := req.Send()
	return out, err
}

const opAdminEnableUser = "AdminEnableUser"

// AdminEnableUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminEnableUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminEnableUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminEnableUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminEnableUserRequest method.
//    req, resp := client.AdminEnableUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminEnableUserRequest(input *AdminEnableUserInput) (req *request.Request, output *AdminEnableUserOutput) {
	op := &request.Operation{
		Name:       opAdminEnableUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminEnableUserInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminEnableUserOutput{}
	req.Data = output
	return
}

// AdminEnableUser API operation for Amazon Cognito Identity Provider.
//
// Enables the specified user as an administrator. Works on any user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminEnableUser for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminEnableUser(input *AdminEnableUserInput) (*AdminEnableUserOutput, error) {
	req, out := c.AdminEnableUserRequest(input)
	err := req.Send()
	return out, err
}

const opAdminForgetDevice = "AdminForgetDevice"

// AdminForgetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the AdminForgetDevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminForgetDevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminForgetDevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminForgetDeviceRequest method.
//    req, resp := client.AdminForgetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminForgetDeviceRequest(input *AdminForgetDeviceInput) (req *request.Request, output *AdminForgetDeviceOutput) {
	op := &request.Operation{
		Name:       opAdminForgetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminForgetDeviceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AdminForgetDeviceOutput{}
	req.Data = output
	return
}

// AdminForgetDevice API operation for Amazon Cognito Identity Provider.
//
// Forgets the device, as an administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminForgetDevice for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminForgetDevice(input *AdminForgetDeviceInput) (*AdminForgetDeviceOutput, error) {
	req, out := c.AdminForgetDeviceRequest(input)
	err := req.Send()
	return out, err
}

const opAdminGetDevice = "AdminGetDevice"

// AdminGetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the AdminGetDevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminGetDevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminGetDevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminGetDeviceRequest method.
//    req, resp := client.AdminGetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminGetDeviceRequest(input *AdminGetDeviceInput) (req *request.Request, output *AdminGetDeviceOutput) {
	op := &request.Operation{
		Name:       opAdminGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminGetDeviceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminGetDeviceOutput{}
	req.Data = output
	return
}

// AdminGetDevice API operation for Amazon Cognito Identity Provider.
//
// Gets the device, as an administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminGetDevice for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
func (c *CognitoIdentityProvider) AdminGetDevice(input *AdminGetDeviceInput) (*AdminGetDeviceOutput, error) {
	req, out := c.AdminGetDeviceRequest(input)
	err := req.Send()
	return out, err
}

const opAdminGetUser = "AdminGetUser"

// AdminGetUserRequest generates a "aws/request.Request" representing the
// client's request for the AdminGetUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminGetUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminGetUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminGetUserRequest method.
//    req, resp := client.AdminGetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminGetUserRequest(input *AdminGetUserInput) (req *request.Request, output *AdminGetUserOutput) {
	op := &request.Operation{
		Name:       opAdminGetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminGetUserInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminGetUserOutput{}
	req.Data = output
	return
}

// AdminGetUser API operation for Amazon Cognito Identity Provider.
//
// Gets the specified user by user name in a user pool as an administrator.
// Works on any user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminGetUser for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminGetUser(input *AdminGetUserInput) (*AdminGetUserOutput, error) {
	req, out := c.AdminGetUserRequest(input)
	err := req.Send()
	return out, err
}

const opAdminInitiateAuth = "AdminInitiateAuth"

// AdminInitiateAuthRequest generates a "aws/request.Request" representing the
// client's request for the AdminInitiateAuth operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminInitiateAuth for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminInitiateAuth method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminInitiateAuthRequest method.
//    req, resp := client.AdminInitiateAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminInitiateAuthRequest(input *AdminInitiateAuthInput) (req *request.Request, output *AdminInitiateAuthOutput) {
	op := &request.Operation{
		Name:       opAdminInitiateAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminInitiateAuthInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminInitiateAuthOutput{}
	req.Data = output
	return
}

// AdminInitiateAuth API operation for Amazon Cognito Identity Provider.
//
// Initiates the authentication flow, as an administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminInitiateAuth for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * MFAMethodNotFoundException
//   This exception is thrown when Amazon Cognito cannot find a multi-factor authentication
//   (MFA) method.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
func (c *CognitoIdentityProvider) AdminInitiateAuth(input *AdminInitiateAuthInput) (*AdminInitiateAuthOutput, error) {
	req, out := c.AdminInitiateAuthRequest(input)
	err := req.Send()
	return out, err
}

const opAdminListDevices = "AdminListDevices"

// AdminListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the AdminListDevices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminListDevices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminListDevices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminListDevicesRequest method.
//    req, resp := client.AdminListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminListDevicesRequest(input *AdminListDevicesInput) (req *request.Request, output *AdminListDevicesOutput) {
	op := &request.Operation{
		Name:       opAdminListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminListDevicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminListDevicesOutput{}
	req.Data = output
	return
}

// AdminListDevices API operation for Amazon Cognito Identity Provider.
//
// Lists devices, as an administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminListDevices for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
func (c *CognitoIdentityProvider) AdminListDevices(input *AdminListDevicesInput) (*AdminListDevicesOutput, error) {
	req, out := c.AdminListDevicesRequest(input)
	err := req.Send()
	return out, err
}

const opAdminResetUserPassword = "AdminResetUserPassword"

// AdminResetUserPasswordRequest generates a "aws/request.Request" representing the
// client's request for the AdminResetUserPassword operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminResetUserPassword for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminResetUserPassword method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminResetUserPasswordRequest method.
//    req, resp := client.AdminResetUserPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminResetUserPasswordRequest(input *AdminResetUserPasswordInput) (req *request.Request, output *AdminResetUserPasswordOutput) {
	op := &request.Operation{
		Name:       opAdminResetUserPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminResetUserPasswordInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminResetUserPasswordOutput{}
	req.Data = output
	return
}

// AdminResetUserPassword API operation for Amazon Cognito Identity Provider.
//
// Resets the specified user's password in a user pool as an administrator.
// Works on any user.
//
// When a developer calls this API, the current password is invalidated, so
// it must be changed. If a user tries to sign in after the API is called, the
// app will get a PasswordResetRequiredException exception back and should direct
// the user down the flow to reset the password, which is the same as the forgot
// password flow. In addition, if the user pool has phone verification selected
// and a verified phone number exists for the user, or if email verification
// is selected and a verified email exists for the user, calling this API will
// also result in sending a message to the end user with the code to change
// their password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminResetUserPassword for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminResetUserPassword(input *AdminResetUserPasswordInput) (*AdminResetUserPasswordOutput, error) {
	req, out := c.AdminResetUserPasswordRequest(input)
	err := req.Send()
	return out, err
}

const opAdminRespondToAuthChallenge = "AdminRespondToAuthChallenge"

// AdminRespondToAuthChallengeRequest generates a "aws/request.Request" representing the
// client's request for the AdminRespondToAuthChallenge operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminRespondToAuthChallenge for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminRespondToAuthChallenge method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminRespondToAuthChallengeRequest method.
//    req, resp := client.AdminRespondToAuthChallengeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminRespondToAuthChallengeRequest(input *AdminRespondToAuthChallengeInput) (req *request.Request, output *AdminRespondToAuthChallengeOutput) {
	op := &request.Operation{
		Name:       opAdminRespondToAuthChallenge,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminRespondToAuthChallengeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminRespondToAuthChallengeOutput{}
	req.Data = output
	return
}

// AdminRespondToAuthChallenge API operation for Amazon Cognito Identity Provider.
//
// Responds to an authentication challenge, as an administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminRespondToAuthChallenge for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * InvalidPasswordException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * MFAMethodNotFoundException
//   This exception is thrown when Amazon Cognito cannot find a multi-factor authentication
//   (MFA) method.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
func (c *CognitoIdentityProvider) AdminRespondToAuthChallenge(input *AdminRespondToAuthChallengeInput) (*AdminRespondToAuthChallengeOutput, error) {
	req, out := c.AdminRespondToAuthChallengeRequest(input)
	err := req.Send()
	return out, err
}

const opAdminSetUserSettings = "AdminSetUserSettings"

// AdminSetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the AdminSetUserSettings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminSetUserSettings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminSetUserSettings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminSetUserSettingsRequest method.
//    req, resp := client.AdminSetUserSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminSetUserSettingsRequest(input *AdminSetUserSettingsInput) (req *request.Request, output *AdminSetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opAdminSetUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminSetUserSettingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminSetUserSettingsOutput{}
	req.Data = output
	return
}

// AdminSetUserSettings API operation for Amazon Cognito Identity Provider.
//
// Sets all the user settings for a specified user name. Works on any user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminSetUserSettings for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminSetUserSettings(input *AdminSetUserSettingsInput) (*AdminSetUserSettingsOutput, error) {
	req, out := c.AdminSetUserSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opAdminUpdateDeviceStatus = "AdminUpdateDeviceStatus"

// AdminUpdateDeviceStatusRequest generates a "aws/request.Request" representing the
// client's request for the AdminUpdateDeviceStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminUpdateDeviceStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminUpdateDeviceStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminUpdateDeviceStatusRequest method.
//    req, resp := client.AdminUpdateDeviceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminUpdateDeviceStatusRequest(input *AdminUpdateDeviceStatusInput) (req *request.Request, output *AdminUpdateDeviceStatusOutput) {
	op := &request.Operation{
		Name:       opAdminUpdateDeviceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateDeviceStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminUpdateDeviceStatusOutput{}
	req.Data = output
	return
}

// AdminUpdateDeviceStatus API operation for Amazon Cognito Identity Provider.
//
// Updates the device status as an administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUpdateDeviceStatus for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminUpdateDeviceStatus(input *AdminUpdateDeviceStatusInput) (*AdminUpdateDeviceStatusOutput, error) {
	req, out := c.AdminUpdateDeviceStatusRequest(input)
	err := req.Send()
	return out, err
}

const opAdminUpdateUserAttributes = "AdminUpdateUserAttributes"

// AdminUpdateUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the AdminUpdateUserAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminUpdateUserAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminUpdateUserAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminUpdateUserAttributesRequest method.
//    req, resp := client.AdminUpdateUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminUpdateUserAttributesRequest(input *AdminUpdateUserAttributesInput) (req *request.Request, output *AdminUpdateUserAttributesOutput) {
	op := &request.Operation{
		Name:       opAdminUpdateUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUpdateUserAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminUpdateUserAttributesOutput{}
	req.Data = output
	return
}

// AdminUpdateUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Updates the specified user's attributes, including developer attributes,
// as an administrator. Works on any user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUpdateUserAttributes for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminUpdateUserAttributes(input *AdminUpdateUserAttributesInput) (*AdminUpdateUserAttributesOutput, error) {
	req, out := c.AdminUpdateUserAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opAdminUserGlobalSignOut = "AdminUserGlobalSignOut"

// AdminUserGlobalSignOutRequest generates a "aws/request.Request" representing the
// client's request for the AdminUserGlobalSignOut operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AdminUserGlobalSignOut for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AdminUserGlobalSignOut method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AdminUserGlobalSignOutRequest method.
//    req, resp := client.AdminUserGlobalSignOutRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) AdminUserGlobalSignOutRequest(input *AdminUserGlobalSignOutInput) (req *request.Request, output *AdminUserGlobalSignOutOutput) {
	op := &request.Operation{
		Name:       opAdminUserGlobalSignOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminUserGlobalSignOutInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AdminUserGlobalSignOutOutput{}
	req.Data = output
	return
}

// AdminUserGlobalSignOut API operation for Amazon Cognito Identity Provider.
//
// Signs out users from all devices, as an administrator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation AdminUserGlobalSignOut for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) AdminUserGlobalSignOut(input *AdminUserGlobalSignOutInput) (*AdminUserGlobalSignOutOutput, error) {
	req, out := c.AdminUserGlobalSignOutRequest(input)
	err := req.Send()
	return out, err
}

const opChangePassword = "ChangePassword"

// ChangePasswordRequest generates a "aws/request.Request" representing the
// client's request for the ChangePassword operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ChangePassword for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ChangePassword method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ChangePasswordRequest method.
//    req, resp := client.ChangePasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ChangePasswordRequest(input *ChangePasswordInput) (req *request.Request, output *ChangePasswordOutput) {
	op := &request.Operation{
		Name:       opChangePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ChangePasswordInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &ChangePasswordOutput{}
	req.Data = output
	return
}

// ChangePassword API operation for Amazon Cognito Identity Provider.
//
// Changes the password for a specified user in a user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ChangePassword for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidPasswordException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ChangePassword(input *ChangePasswordInput) (*ChangePasswordOutput, error) {
	req, out := c.ChangePasswordRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmDevice = "ConfirmDevice"

// ConfirmDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmDevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConfirmDevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConfirmDevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConfirmDeviceRequest method.
//    req, resp := client.ConfirmDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ConfirmDeviceRequest(input *ConfirmDeviceInput) (req *request.Request, output *ConfirmDeviceOutput) {
	op := &request.Operation{
		Name:       opConfirmDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmDeviceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfirmDeviceOutput{}
	req.Data = output
	return
}

// ConfirmDevice API operation for Amazon Cognito Identity Provider.
//
// Confirms tracking of the device. This API call is the call that beings device
// tracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmDevice for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InvalidPasswordException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * UsernameExistsException
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ConfirmDevice(input *ConfirmDeviceInput) (*ConfirmDeviceOutput, error) {
	req, out := c.ConfirmDeviceRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmForgotPassword = "ConfirmForgotPassword"

// ConfirmForgotPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmForgotPassword operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConfirmForgotPassword for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConfirmForgotPassword method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConfirmForgotPasswordRequest method.
//    req, resp := client.ConfirmForgotPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ConfirmForgotPasswordRequest(input *ConfirmForgotPasswordInput) (req *request.Request, output *ConfirmForgotPasswordOutput) {
	op := &request.Operation{
		Name:       opConfirmForgotPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmForgotPasswordInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &ConfirmForgotPasswordOutput{}
	req.Data = output
	return
}

// ConfirmForgotPassword API operation for Amazon Cognito Identity Provider.
//
// Allows a user to enter a code provided when they reset their password to
// update their password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmForgotPassword for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidPasswordException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * TooManyFailedAttemptsException
//   This exception gets thrown when the user has made too many failed attempts
//   for a given action (e.g., sign in).
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ConfirmForgotPassword(input *ConfirmForgotPasswordInput) (*ConfirmForgotPasswordOutput, error) {
	req, out := c.ConfirmForgotPasswordRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmSignUp = "ConfirmSignUp"

// ConfirmSignUpRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmSignUp operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConfirmSignUp for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConfirmSignUp method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConfirmSignUpRequest method.
//    req, resp := client.ConfirmSignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ConfirmSignUpRequest(input *ConfirmSignUpInput) (req *request.Request, output *ConfirmSignUpOutput) {
	op := &request.Operation{
		Name:       opConfirmSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmSignUpInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &ConfirmSignUpOutput{}
	req.Data = output
	return
}

// ConfirmSignUp API operation for Amazon Cognito Identity Provider.
//
// Confirms registration of a user and handles the existing alias from a previous
// user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ConfirmSignUp for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyFailedAttemptsException
//   This exception gets thrown when the user has made too many failed attempts
//   for a given action (e.g., sign in).
//
//   * CodeMismatchException
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ConfirmSignUp(input *ConfirmSignUpInput) (*ConfirmSignUpOutput, error) {
	req, out := c.ConfirmSignUpRequest(input)
	err := req.Send()
	return out, err
}

const opCreateUserImportJob = "CreateUserImportJob"

// CreateUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserImportJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateUserImportJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateUserImportJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateUserImportJobRequest method.
//    req, resp := client.CreateUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) CreateUserImportJobRequest(input *CreateUserImportJobInput) (req *request.Request, output *CreateUserImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserImportJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateUserImportJobOutput{}
	req.Data = output
	return
}

// CreateUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Creates the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserImportJob for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PreconditionNotMetException
//   This exception is thrown when a precondition is not met.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) CreateUserImportJob(input *CreateUserImportJobInput) (*CreateUserImportJobOutput, error) {
	req, out := c.CreateUserImportJobRequest(input)
	err := req.Send()
	return out, err
}

const opCreateUserPool = "CreateUserPool"

// CreateUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserPool operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateUserPool for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateUserPool method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateUserPoolRequest method.
//    req, resp := client.CreateUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) CreateUserPoolRequest(input *CreateUserPoolInput) (req *request.Request, output *CreateUserPoolOutput) {
	op := &request.Operation{
		Name:       opCreateUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserPoolInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateUserPoolOutput{}
	req.Data = output
	return
}

// CreateUserPool API operation for Amazon Cognito Identity Provider.
//
// Creates a new Amazon Cognito user pool and sets the password policy for the
// pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserPool for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) CreateUserPool(input *CreateUserPoolInput) (*CreateUserPoolOutput, error) {
	req, out := c.CreateUserPoolRequest(input)
	err := req.Send()
	return out, err
}

const opCreateUserPoolClient = "CreateUserPoolClient"

// CreateUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserPoolClient operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateUserPoolClient for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateUserPoolClient method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateUserPoolClientRequest method.
//    req, resp := client.CreateUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) CreateUserPoolClientRequest(input *CreateUserPoolClientInput) (req *request.Request, output *CreateUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opCreateUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserPoolClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateUserPoolClientOutput{}
	req.Data = output
	return
}

// CreateUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Creates the user pool client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation CreateUserPoolClient for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) CreateUserPoolClient(input *CreateUserPoolClientInput) (*CreateUserPoolClientOutput, error) {
	req, out := c.CreateUserPoolClientRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &DeleteUserOutput{}
	req.Data = output
	return
}

// DeleteUser API operation for Amazon Cognito Identity Provider.
//
// Allows a user to delete one's self.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUserAttributes = "DeleteUserAttributes"

// DeleteUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteUserAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteUserAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteUserAttributesRequest method.
//    req, resp := client.DeleteUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) DeleteUserAttributesRequest(input *DeleteUserAttributesInput) (req *request.Request, output *DeleteUserAttributesOutput) {
	op := &request.Operation{
		Name:       opDeleteUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &DeleteUserAttributesOutput{}
	req.Data = output
	return
}

// DeleteUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Deletes the attributes for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserAttributes for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) DeleteUserAttributes(input *DeleteUserAttributesInput) (*DeleteUserAttributesOutput, error) {
	req, out := c.DeleteUserAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUserPool = "DeleteUserPool"

// DeleteUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPool operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteUserPool for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteUserPool method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteUserPoolRequest method.
//    req, resp := client.DeleteUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) DeleteUserPoolRequest(input *DeleteUserPoolInput) (req *request.Request, output *DeleteUserPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteUserPoolOutput{}
	req.Data = output
	return
}

// DeleteUserPool API operation for Amazon Cognito Identity Provider.
//
// Deletes the specified Amazon Cognito user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserPool for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserImportInProgressException
//   This exception is thrown when you are trying to modify a user pool while
//   a user import job is in progress for that pool.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) DeleteUserPool(input *DeleteUserPoolInput) (*DeleteUserPoolOutput, error) {
	req, out := c.DeleteUserPoolRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUserPoolClient = "DeleteUserPoolClient"

// DeleteUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPoolClient operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteUserPoolClient for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteUserPoolClient method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteUserPoolClientRequest method.
//    req, resp := client.DeleteUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) DeleteUserPoolClientRequest(input *DeleteUserPoolClientInput) (req *request.Request, output *DeleteUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPoolClientInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteUserPoolClientOutput{}
	req.Data = output
	return
}

// DeleteUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Allows the developer to delete the user pool client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DeleteUserPoolClient for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) DeleteUserPoolClient(input *DeleteUserPoolClientInput) (*DeleteUserPoolClientOutput, error) {
	req, out := c.DeleteUserPoolClientRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeUserImportJob = "DescribeUserImportJob"

// DescribeUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserImportJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeUserImportJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeUserImportJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeUserImportJobRequest method.
//    req, resp := client.DescribeUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) DescribeUserImportJobRequest(input *DescribeUserImportJobInput) (req *request.Request, output *DescribeUserImportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserImportJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeUserImportJobOutput{}
	req.Data = output
	return
}

// DescribeUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Describes the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserImportJob for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) DescribeUserImportJob(input *DescribeUserImportJobInput) (*DescribeUserImportJobOutput, error) {
	req, out := c.DescribeUserImportJobRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeUserPool = "DescribeUserPool"

// DescribeUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserPool operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeUserPool for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeUserPool method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeUserPoolRequest method.
//    req, resp := client.DescribeUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) DescribeUserPoolRequest(input *DescribeUserPoolInput) (req *request.Request, output *DescribeUserPoolOutput) {
	op := &request.Operation{
		Name:       opDescribeUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeUserPoolOutput{}
	req.Data = output
	return
}

// DescribeUserPool API operation for Amazon Cognito Identity Provider.
//
// Returns the configuration information and metadata of the specified user
// pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserPool for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) DescribeUserPool(input *DescribeUserPoolInput) (*DescribeUserPoolOutput, error) {
	req, out := c.DescribeUserPoolRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeUserPoolClient = "DescribeUserPoolClient"

// DescribeUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserPoolClient operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeUserPoolClient for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeUserPoolClient method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeUserPoolClientRequest method.
//    req, resp := client.DescribeUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) DescribeUserPoolClientRequest(input *DescribeUserPoolClientInput) (req *request.Request, output *DescribeUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opDescribeUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserPoolClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeUserPoolClientOutput{}
	req.Data = output
	return
}

// DescribeUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Client method for returning the configuration information and metadata of
// the specified user pool client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation DescribeUserPoolClient for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) DescribeUserPoolClient(input *DescribeUserPoolClientInput) (*DescribeUserPoolClientOutput, error) {
	req, out := c.DescribeUserPoolClientRequest(input)
	err := req.Send()
	return out, err
}

const opForgetDevice = "ForgetDevice"

// ForgetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ForgetDevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ForgetDevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ForgetDevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ForgetDeviceRequest method.
//    req, resp := client.ForgetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ForgetDeviceRequest(input *ForgetDeviceInput) (req *request.Request, output *ForgetDeviceOutput) {
	op := &request.Operation{
		Name:       opForgetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgetDeviceInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ForgetDeviceOutput{}
	req.Data = output
	return
}

// ForgetDevice API operation for Amazon Cognito Identity Provider.
//
// Forgets the specified device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ForgetDevice for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ForgetDevice(input *ForgetDeviceInput) (*ForgetDeviceOutput, error) {
	req, out := c.ForgetDeviceRequest(input)
	err := req.Send()
	return out, err
}

const opForgotPassword = "ForgotPassword"

// ForgotPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ForgotPassword operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ForgotPassword for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ForgotPassword method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ForgotPasswordRequest method.
//    req, resp := client.ForgotPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ForgotPasswordRequest(input *ForgotPasswordInput) (req *request.Request, output *ForgotPasswordOutput) {
	op := &request.Operation{
		Name:       opForgotPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgotPasswordInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &ForgotPasswordOutput{}
	req.Data = output
	return
}

// ForgotPassword API operation for Amazon Cognito Identity Provider.
//
// Retrieves the password for the specified client ID or username.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ForgotPassword for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ForgotPassword(input *ForgotPasswordInput) (*ForgotPasswordOutput, error) {
	req, out := c.ForgotPasswordRequest(input)
	err := req.Send()
	return out, err
}

const opGetCSVHeader = "GetCSVHeader"

// GetCSVHeaderRequest generates a "aws/request.Request" representing the
// client's request for the GetCSVHeader operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCSVHeader for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCSVHeader method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCSVHeaderRequest method.
//    req, resp := client.GetCSVHeaderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) GetCSVHeaderRequest(input *GetCSVHeaderInput) (req *request.Request, output *GetCSVHeaderOutput) {
	op := &request.Operation{
		Name:       opGetCSVHeader,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCSVHeaderInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCSVHeaderOutput{}
	req.Data = output
	return
}

// GetCSVHeader API operation for Amazon Cognito Identity Provider.
//
// Gets the header information for the .csv file to be used as input for the
// user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetCSVHeader for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) GetCSVHeader(input *GetCSVHeaderInput) (*GetCSVHeaderOutput, error) {
	req, out := c.GetCSVHeaderRequest(input)
	err := req.Send()
	return out, err
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDeviceRequest method.
//    req, resp := client.GetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeviceOutput{}
	req.Data = output
	return
}

// GetDevice API operation for Amazon Cognito Identity Provider.
//
// Gets the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetDevice for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	err := req.Send()
	return out, err
}

const opGetUser = "GetUser"

// GetUserRequest generates a "aws/request.Request" representing the
// client's request for the GetUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetUserRequest method.
//    req, resp := client.GetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &GetUserOutput{}
	req.Data = output
	return
}

// GetUser API operation for Amazon Cognito Identity Provider.
//
// Gets the user attributes and metadata for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUser for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	err := req.Send()
	return out, err
}

const opGetUserAttributeVerificationCode = "GetUserAttributeVerificationCode"

// GetUserAttributeVerificationCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetUserAttributeVerificationCode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetUserAttributeVerificationCode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetUserAttributeVerificationCode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetUserAttributeVerificationCodeRequest method.
//    req, resp := client.GetUserAttributeVerificationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) GetUserAttributeVerificationCodeRequest(input *GetUserAttributeVerificationCodeInput) (req *request.Request, output *GetUserAttributeVerificationCodeOutput) {
	op := &request.Operation{
		Name:       opGetUserAttributeVerificationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserAttributeVerificationCodeInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &GetUserAttributeVerificationCodeOutput{}
	req.Data = output
	return
}

// GetUserAttributeVerificationCode API operation for Amazon Cognito Identity Provider.
//
// Gets the user attribute verification code for the specified attribute name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GetUserAttributeVerificationCode for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) GetUserAttributeVerificationCode(input *GetUserAttributeVerificationCodeInput) (*GetUserAttributeVerificationCodeOutput, error) {
	req, out := c.GetUserAttributeVerificationCodeRequest(input)
	err := req.Send()
	return out, err
}

const opGlobalSignOut = "GlobalSignOut"

// GlobalSignOutRequest generates a "aws/request.Request" representing the
// client's request for the GlobalSignOut operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GlobalSignOut for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GlobalSignOut method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GlobalSignOutRequest method.
//    req, resp := client.GlobalSignOutRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) GlobalSignOutRequest(input *GlobalSignOutInput) (req *request.Request, output *GlobalSignOutOutput) {
	op := &request.Operation{
		Name:       opGlobalSignOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GlobalSignOutInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GlobalSignOutOutput{}
	req.Data = output
	return
}

// GlobalSignOut API operation for Amazon Cognito Identity Provider.
//
// Signs out users from all devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation GlobalSignOut for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) GlobalSignOut(input *GlobalSignOutInput) (*GlobalSignOutOutput, error) {
	req, out := c.GlobalSignOutRequest(input)
	err := req.Send()
	return out, err
}

const opInitiateAuth = "InitiateAuth"

// InitiateAuthRequest generates a "aws/request.Request" representing the
// client's request for the InitiateAuth operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See InitiateAuth for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the InitiateAuth method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the InitiateAuthRequest method.
//    req, resp := client.InitiateAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) InitiateAuthRequest(input *InitiateAuthInput) (req *request.Request, output *InitiateAuthOutput) {
	op := &request.Operation{
		Name:       opInitiateAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InitiateAuthInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InitiateAuthOutput{}
	req.Data = output
	return
}

// InitiateAuth API operation for Amazon Cognito Identity Provider.
//
// Initiates the authentication flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation InitiateAuth for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) InitiateAuth(input *InitiateAuthInput) (*InitiateAuthOutput, error) {
	req, out := c.InitiateAuthRequest(input)
	err := req.Send()
	return out, err
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDevices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDevices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDevicesRequest method.
//    req, resp := client.ListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDevicesOutput{}
	req.Data = output
	return
}

// ListDevices API operation for Amazon Cognito Identity Provider.
//
// Lists the devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListDevices for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	err := req.Send()
	return out, err
}

const opListUserImportJobs = "ListUserImportJobs"

// ListUserImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserImportJobs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUserImportJobs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUserImportJobs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUserImportJobsRequest method.
//    req, resp := client.ListUserImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ListUserImportJobsRequest(input *ListUserImportJobsInput) (req *request.Request, output *ListUserImportJobsOutput) {
	op := &request.Operation{
		Name:       opListUserImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserImportJobsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListUserImportJobsOutput{}
	req.Data = output
	return
}

// ListUserImportJobs API operation for Amazon Cognito Identity Provider.
//
// Lists the user import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserImportJobs for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ListUserImportJobs(input *ListUserImportJobsInput) (*ListUserImportJobsOutput, error) {
	req, out := c.ListUserImportJobsRequest(input)
	err := req.Send()
	return out, err
}

const opListUserPoolClients = "ListUserPoolClients"

// ListUserPoolClientsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserPoolClients operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUserPoolClients for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUserPoolClients method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUserPoolClientsRequest method.
//    req, resp := client.ListUserPoolClientsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ListUserPoolClientsRequest(input *ListUserPoolClientsInput) (req *request.Request, output *ListUserPoolClientsOutput) {
	op := &request.Operation{
		Name:       opListUserPoolClients,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserPoolClientsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListUserPoolClientsOutput{}
	req.Data = output
	return
}

// ListUserPoolClients API operation for Amazon Cognito Identity Provider.
//
// Lists the clients that have been created for the specified user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserPoolClients for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ListUserPoolClients(input *ListUserPoolClientsInput) (*ListUserPoolClientsOutput, error) {
	req, out := c.ListUserPoolClientsRequest(input)
	err := req.Send()
	return out, err
}

const opListUserPools = "ListUserPools"

// ListUserPoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserPools operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUserPools for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUserPools method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUserPoolsRequest method.
//    req, resp := client.ListUserPoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ListUserPoolsRequest(input *ListUserPoolsInput) (req *request.Request, output *ListUserPoolsOutput) {
	op := &request.Operation{
		Name:       opListUserPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserPoolsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListUserPoolsOutput{}
	req.Data = output
	return
}

// ListUserPools API operation for Amazon Cognito Identity Provider.
//
// Lists the user pools associated with an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUserPools for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ListUserPools(input *ListUserPoolsInput) (*ListUserPoolsOutput, error) {
	req, out := c.ListUserPoolsRequest(input)
	err := req.Send()
	return out, err
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUsers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUsers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListUsersOutput{}
	req.Data = output
	return
}

// ListUsers API operation for Amazon Cognito Identity Provider.
//
// Lists the users in the Amazon Cognito user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	err := req.Send()
	return out, err
}

const opResendConfirmationCode = "ResendConfirmationCode"

// ResendConfirmationCodeRequest generates a "aws/request.Request" representing the
// client's request for the ResendConfirmationCode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResendConfirmationCode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResendConfirmationCode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResendConfirmationCodeRequest method.
//    req, resp := client.ResendConfirmationCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) ResendConfirmationCodeRequest(input *ResendConfirmationCodeInput) (req *request.Request, output *ResendConfirmationCodeOutput) {
	op := &request.Operation{
		Name:       opResendConfirmationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResendConfirmationCodeInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &ResendConfirmationCodeOutput{}
	req.Data = output
	return
}

// ResendConfirmationCode API operation for Amazon Cognito Identity Provider.
//
// Resends the confirmation (for confirmation of registration) to a specific
// user in the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation ResendConfirmationCode for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) ResendConfirmationCode(input *ResendConfirmationCodeInput) (*ResendConfirmationCodeOutput, error) {
	req, out := c.ResendConfirmationCodeRequest(input)
	err := req.Send()
	return out, err
}

const opRespondToAuthChallenge = "RespondToAuthChallenge"

// RespondToAuthChallengeRequest generates a "aws/request.Request" representing the
// client's request for the RespondToAuthChallenge operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RespondToAuthChallenge for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RespondToAuthChallenge method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RespondToAuthChallengeRequest method.
//    req, resp := client.RespondToAuthChallengeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) RespondToAuthChallengeRequest(input *RespondToAuthChallengeInput) (req *request.Request, output *RespondToAuthChallengeOutput) {
	op := &request.Operation{
		Name:       opRespondToAuthChallenge,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondToAuthChallengeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RespondToAuthChallengeOutput{}
	req.Data = output
	return
}

// RespondToAuthChallenge API operation for Amazon Cognito Identity Provider.
//
// Responds to the authentication challenge.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation RespondToAuthChallenge for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidPasswordException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * MFAMethodNotFoundException
//   This exception is thrown when Amazon Cognito cannot find a multi-factor authentication
//   (MFA) method.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) RespondToAuthChallenge(input *RespondToAuthChallengeInput) (*RespondToAuthChallengeOutput, error) {
	req, out := c.RespondToAuthChallengeRequest(input)
	err := req.Send()
	return out, err
}

const opSetUserSettings = "SetUserSettings"

// SetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the SetUserSettings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetUserSettings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetUserSettings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetUserSettingsRequest method.
//    req, resp := client.SetUserSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) SetUserSettingsRequest(input *SetUserSettingsInput) (req *request.Request, output *SetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opSetUserSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetUserSettingsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &SetUserSettingsOutput{}
	req.Data = output
	return
}

// SetUserSettings API operation for Amazon Cognito Identity Provider.
//
// Sets the user settings like multi-factor authentication (MFA). If MFA is
// to be removed for a particular attribute pass the attribute with code delivery
// as null. If null list is passed, all MFA options are removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SetUserSettings for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) SetUserSettings(input *SetUserSettingsInput) (*SetUserSettingsOutput, error) {
	req, out := c.SetUserSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opSignUp = "SignUp"

// SignUpRequest generates a "aws/request.Request" representing the
// client's request for the SignUp operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SignUp for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SignUp method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SignUpRequest method.
//    req, resp := client.SignUpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) SignUpRequest(input *SignUpInput) (req *request.Request, output *SignUpOutput) {
	op := &request.Operation{
		Name:       opSignUp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignUpInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &SignUpOutput{}
	req.Data = output
	return
}

// SignUp API operation for Amazon Cognito Identity Provider.
//
// Registers the user in the specified user pool and creates a user name, password,
// and user attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation SignUp for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InvalidPasswordException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   password.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * UsernameExistsException
//   This exception is thrown when Amazon Cognito encounters a user name that
//   already exists in the user pool.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
func (c *CognitoIdentityProvider) SignUp(input *SignUpInput) (*SignUpOutput, error) {
	req, out := c.SignUpRequest(input)
	err := req.Send()
	return out, err
}

const opStartUserImportJob = "StartUserImportJob"

// StartUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartUserImportJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartUserImportJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartUserImportJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartUserImportJobRequest method.
//    req, resp := client.StartUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) StartUserImportJobRequest(input *StartUserImportJobInput) (req *request.Request, output *StartUserImportJobOutput) {
	op := &request.Operation{
		Name:       opStartUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartUserImportJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartUserImportJobOutput{}
	req.Data = output
	return
}

// StartUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Starts the user import.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation StartUserImportJob for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * PreconditionNotMetException
//   This exception is thrown when a precondition is not met.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
func (c *CognitoIdentityProvider) StartUserImportJob(input *StartUserImportJobInput) (*StartUserImportJobOutput, error) {
	req, out := c.StartUserImportJobRequest(input)
	err := req.Send()
	return out, err
}

const opStopUserImportJob = "StopUserImportJob"

// StopUserImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StopUserImportJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopUserImportJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopUserImportJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopUserImportJobRequest method.
//    req, resp := client.StopUserImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) StopUserImportJobRequest(input *StopUserImportJobInput) (req *request.Request, output *StopUserImportJobOutput) {
	op := &request.Operation{
		Name:       opStopUserImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopUserImportJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopUserImportJobOutput{}
	req.Data = output
	return
}

// StopUserImportJob API operation for Amazon Cognito Identity Provider.
//
// Stops the user import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation StopUserImportJob for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * PreconditionNotMetException
//   This exception is thrown when a precondition is not met.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
func (c *CognitoIdentityProvider) StopUserImportJob(input *StopUserImportJobInput) (*StopUserImportJobOutput, error) {
	req, out := c.StopUserImportJobRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDeviceStatus = "UpdateDeviceStatus"

// UpdateDeviceStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateDeviceStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateDeviceStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateDeviceStatusRequest method.
//    req, resp := client.UpdateDeviceStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) UpdateDeviceStatusRequest(input *UpdateDeviceStatusInput) (req *request.Request, output *UpdateDeviceStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDeviceStatusOutput{}
	req.Data = output
	return
}

// UpdateDeviceStatus API operation for Amazon Cognito Identity Provider.
//
// Updates the device status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateDeviceStatus for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InvalidUserPoolConfigurationException
//   This exception is thrown when the user pool configuration is invalid.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) UpdateDeviceStatus(input *UpdateDeviceStatusInput) (*UpdateDeviceStatusOutput, error) {
	req, out := c.UpdateDeviceStatusRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateUserAttributes = "UpdateUserAttributes"

// UpdateUserAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateUserAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateUserAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateUserAttributesRequest method.
//    req, resp := client.UpdateUserAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) UpdateUserAttributesRequest(input *UpdateUserAttributesInput) (req *request.Request, output *UpdateUserAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateUserAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &UpdateUserAttributesOutput{}
	req.Data = output
	return
}

// UpdateUserAttributes API operation for Amazon Cognito Identity Provider.
//
// Allows a user to update a specific attribute (one at a time).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserAttributes for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UnexpectedLambdaException
//   This exception gets thrown when the Amazon Cognito service encounters an
//   unexpected exception with the AWS Lambda service.
//
//   * UserLambdaValidationException
//   This exception gets thrown when the Amazon Cognito service encounters a user
//   validation exception with the AWS Lambda service.
//
//   * InvalidLambdaResponseException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   AWS Lambda response.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * AliasExistsException
//   This exception is thrown when a user tries to confirm the account with an
//   email or phone number that has already been supplied as an alias from a different
//   account. This exception tells user that an account with this email or phone
//   already exists.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
//   * CodeDeliveryFailureException
//   This exception is thrown when a verification code fails to deliver successfully.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) UpdateUserAttributes(input *UpdateUserAttributesInput) (*UpdateUserAttributesOutput, error) {
	req, out := c.UpdateUserAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateUserPool = "UpdateUserPool"

// UpdateUserPoolRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPool operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateUserPool for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateUserPool method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateUserPoolRequest method.
//    req, resp := client.UpdateUserPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) UpdateUserPoolRequest(input *UpdateUserPoolInput) (req *request.Request, output *UpdateUserPoolOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserPoolInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateUserPoolOutput{}
	req.Data = output
	return
}

// UpdateUserPool API operation for Amazon Cognito Identity Provider.
//
// Updates the specified user pool with the specified attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserPool for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * ConcurrentModificationException
//   This exception is thrown if two or more modifications are happening concurrently.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * UserImportInProgressException
//   This exception is thrown when you are trying to modify a user pool while
//   a user import job is in progress for that pool.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
//   * InvalidSmsRoleAccessPolicyException
//   This exception is returned when the role provided for SMS configuration does
//   not have permission to publish using Amazon SNS.
//
//   * InvalidSmsRoleTrustRelationshipException
//   This exception is thrown when the trust relationship is invalid for the role
//   provided for SMS configuration. This can happen if you do not trust cognito-idp.amazonaws.com
//   or the external ID provided in the role does not match what is provided in
//   the SMS configuration for the user pool.
//
//   * InvalidEmailRoleAccessPolicyException
//   This exception is thrown when Amazon Cognito is not allowed to use your email
//   identity. HTTP status code: 400.
//
func (c *CognitoIdentityProvider) UpdateUserPool(input *UpdateUserPoolInput) (*UpdateUserPoolOutput, error) {
	req, out := c.UpdateUserPoolRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateUserPoolClient = "UpdateUserPoolClient"

// UpdateUserPoolClientRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPoolClient operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateUserPoolClient for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateUserPoolClient method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateUserPoolClientRequest method.
//    req, resp := client.UpdateUserPoolClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) UpdateUserPoolClientRequest(input *UpdateUserPoolClientInput) (req *request.Request, output *UpdateUserPoolClientOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPoolClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserPoolClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateUserPoolClientOutput{}
	req.Data = output
	return
}

// UpdateUserPoolClient API operation for Amazon Cognito Identity Provider.
//
// Allows the developer to update the specified user pool client and password
// policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation UpdateUserPoolClient for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) UpdateUserPoolClient(input *UpdateUserPoolClientInput) (*UpdateUserPoolClientOutput, error) {
	req, out := c.UpdateUserPoolClientRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyUserAttribute = "VerifyUserAttribute"

// VerifyUserAttributeRequest generates a "aws/request.Request" representing the
// client's request for the VerifyUserAttribute operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See VerifyUserAttribute for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the VerifyUserAttribute method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the VerifyUserAttributeRequest method.
//    req, resp := client.VerifyUserAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoIdentityProvider) VerifyUserAttributeRequest(input *VerifyUserAttributeInput) (req *request.Request, output *VerifyUserAttributeOutput) {
	op := &request.Operation{
		Name:       opVerifyUserAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyUserAttributeInput{}
	}

	req = c.newRequest(op, input, output)
	req.Config.Credentials = credentials.AnonymousCredentials
	output = &VerifyUserAttributeOutput{}
	req.Data = output
	return
}

// VerifyUserAttribute API operation for Amazon Cognito Identity Provider.
//
// Verifies the specified user attributes in the user pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Identity Provider's
// API operation VerifyUserAttribute for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   This exception is thrown when the Amazon Cognito service cannot find the
//   requested resource.
//
//   * InvalidParameterException
//   This exception is thrown when the Amazon Cognito service encounters an invalid
//   parameter.
//
//   * CodeMismatchException
//   This exception is thrown if the provided code does not match what the server
//   was expecting.
//
//   * ExpiredCodeException
//   This exception is thrown if a code has expired.
//
//   * NotAuthorizedException
//   This exception gets thrown when a user is not authorized.
//
//   * TooManyRequestsException
//   This exception gets thrown when the user has made too many requests for a
//   given operation.
//
//   * LimitExceededException
//   This exception is thrown when a user exceeds the limit for a requested AWS
//   resource.
//
//   * PasswordResetRequiredException
//   This exception is thrown when a password reset is required.
//
//   * UserNotFoundException
//   This exception is thrown when a user is not found.
//
//   * UserNotConfirmedException
//   This exception is thrown when a user is not confirmed successfully.
//
//   * InternalErrorException
//   This exception is thrown when Amazon Cognito encounters an internal error.
//
func (c *CognitoIdentityProvider) VerifyUserAttribute(input *VerifyUserAttributeInput) (*VerifyUserAttributeOutput, error) {
	req, out := c.VerifyUserAttributeRequest(input)
	err := req.Send()
	return out, err
}

// Represents the request to add custom attributes.
type AddCustomAttributesInput struct {
	_ struct{} `type:"structure"`

	// An array of custom attributes, such as Mutable and Name.
	//
	// CustomAttributes is a required field
	CustomAttributes []*SchemaAttributeType `min:"1" type:"list" required:"true"`

	// The user pool ID for the user pool where you want to add custom attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddCustomAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCustomAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCustomAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCustomAttributesInput"}
	if s.CustomAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomAttributes"))
	}
	if s.CustomAttributes != nil && len(s.CustomAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomAttributes", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.CustomAttributes != nil {
		for i, v := range s.CustomAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the request to add custom attributes.
type AddCustomAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddCustomAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCustomAttributesOutput) GoString() string {
	return s.String()
}

// Represents the request to confirm user registration.
type AdminConfirmSignUpInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for which you want to confirm user registration.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name for which you want to confirm user registration.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminConfirmSignUpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminConfirmSignUpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminConfirmSignUpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminConfirmSignUpInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the request to confirm registration.
type AdminConfirmSignUpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminConfirmSignUpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminConfirmSignUpOutput) GoString() string {
	return s.String()
}

// The type of configuration for creating a new user profile.
type AdminCreateUserConfigType struct {
	_ struct{} `type:"structure"`

	// Set to True if only the administrator is allowed to create user profiles.
	// Set to False if users can sign themselves up via an app.
	AllowAdminCreateUserOnly *bool `type:"boolean"`

	// The message template to be used for the welcome message to new users.
	InviteMessageTemplate *MessageTemplateType `type:"structure"`

	// The user account expiration limit, in days, after which the account is no
	// longer usable. To reset the account after that time limit, you must call
	// AdminCreateUser again, specifying "RESEND" for the MessageAction parameter.
	UnusedAccountValidityDays *int64 `type:"integer"`
}

// String returns the string representation
func (s AdminCreateUserConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminCreateUserConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminCreateUserConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminCreateUserConfigType"}
	if s.InviteMessageTemplate != nil {
		if err := s.InviteMessageTemplate.Validate(); err != nil {
			invalidParams.AddNested("InviteMessageTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the request to create a user in the specified user pool.
type AdminCreateUserInput struct {
	_ struct{} `type:"structure"`

	// Specify "EMAIL" if email will be used to send the welcome message. Specify
	// "SMS" if the phone number will be used. The default value is "SMS". More
	// than one value can be specified.
	DesiredDeliveryMediums []*string `type:"list"`

	// This parameter is only used if the phone_number_verified or email_verified
	// attribute is set to True. Otherwise, it is ignored.
	//
	// If this parameter is set to True and the phone number or email address specified
	// in the UserAttributes parameter already exists as an alias with a different
	// user, the API call will migrate the alias from the previous user to the newly
	// created user. The previous user will no longer be able to log in using that
	// alias.
	//
	// If this parameter is set to False, the API throws an AliasExistsException
	// error if the alias already exists. The default value is False.
	ForceAliasCreation *bool `type:"boolean"`

	// Set to "RESEND" to resend the invitation message to a user that already exists
	// and reset the expiration limit on the user's account. Set to "SUPPRESS" to
	// suppress sending the message. Only one value can be specified.
	MessageAction *string `type:"string" enum:"MessageActionType"`

	// The user's temporary password. This password must conform to the password
	// policy that you specified when you created the user pool.
	//
	// The temporary password is valid only once. To complete the Admin Create User
	// flow, the user must enter the temporary password in the sign-in page along
	// with a new password to be used in all future sign-ins.
	//
	// This parameter is not required. If you do not specify a value, Amazon Cognito
	// generates one for you.
	//
	// The temporary password can only be used until the user account expiration
	// limit that you specified when you created the user pool. To reset the account
	// after that time limit, you must call AdminCreateUser again, specifying "RESEND"
	// for the MessageAction parameter.
	TemporaryPassword *string `min:"6" type:"string"`

	// An array of name-value pairs that contain user attributes and attribute values
	// to be set for the user to be created. You can create a user without specifying
	// any attributes other than Username. However, any attributes that you specify
	// as required (in CreateUserPool or in the Attributes tab of the console) must
	// be supplied either by you (in your call to AdminCreateUser) or by the user
	// (when he or she signs up in response to your welcome message).
	//
	// To send a message inviting the user to sign up, you must specify the user's
	// email address or phone number. This can be done in your call to AdminCreateUser
	// or in the Users tab of the Amazon Cognito console for managing your user
	// pools.
	//
	// In your call to AdminCreateUser, you can set the email_verified attribute
	// to True, and you can set the phone_number_verified attribute to True. (You
	// cannot do this by calling other operations such as AdminUpdateUserAttributes.)
	//
	//    * email: The email address of the user to whom the message that contains
	//    the code and username will be sent. Required if the email_verified attribute
	//    is set to True, or if "EMAIL" is specified in the DesiredDeliveryMediums
	//    parameter.
	//
	//    * phone_number: The phone number of the user to whom the message that
	//    contains the code and username will be sent. Required if the phone_number_verified
	//    attribute is set to True, or if "SMS" is specified in the DesiredDeliveryMediums
	//    parameter.
	UserAttributes []*AttributeType `type:"list"`

	// The user pool ID for the user pool where the user will be created.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The username for the user. Must be unique within the user pool. Must be a
	// UTF-8 string between 1 and 128 characters. After the user is created, the
	// username cannot be changed.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`

	// The user's validation data. This is an array of name-value pairs that contain
	// user attributes and attribute values that you can use for custom validation,
	// such as restricting the types of user accounts that can be registered. For
	// example, you might choose to allow or disallow user sign-up based on the
	// user's domain.
	//
	// To configure custom validation, you must create a Pre Sign-up Lambda trigger
	// for the user pool as described in the Amazon Cognito Developer Guide. The
	// Lambda trigger receives the validation data and uses it in the validation
	// process.
	//
	// The user's validation data is not persisted.
	ValidationData []*AttributeType `type:"list"`
}

// String returns the string representation
func (s AdminCreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminCreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminCreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminCreateUserInput"}
	if s.TemporaryPassword != nil && len(*s.TemporaryPassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("TemporaryPassword", 6))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ValidationData != nil {
		for i, v := range s.ValidationData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to create the user.
type AdminCreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The user returned in the request to create a new user.
	User *UserType `type:"structure"`
}

// String returns the string representation
func (s AdminCreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminCreateUserOutput) GoString() string {
	return s.String()
}

// Represents the request to delete user attributes as an administrator.
type AdminDeleteUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings representing the user attribute names you wish to delete.
	//
	// UserAttributeNames is a required field
	UserAttributeNames []*string `type:"list" required:"true"`

	// The user pool ID for the user pool where you want to delete user attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user from which you would like to delete attributes.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminDeleteUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDeleteUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDeleteUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDeleteUserAttributesInput"}
	if s.UserAttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributeNames"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response received from the server for a request to delete
// user attributes.
type AdminDeleteUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminDeleteUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDeleteUserAttributesOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user as an administrator.
type AdminDeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to delete the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to delete.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminDeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDeleteUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AdminDeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminDeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDeleteUserOutput) GoString() string {
	return s.String()
}

// Represents the request to disable any user as an administrator.
type AdminDisableUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to disable the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to disable.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminDisableUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDisableUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminDisableUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminDisableUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response received from the server to disable the user as an
// administrator.
type AdminDisableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminDisableUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminDisableUserOutput) GoString() string {
	return s.String()
}

// Represents the request that enables the user as an administrator.
type AdminEnableUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to enable the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to ebable.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminEnableUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminEnableUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminEnableUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminEnableUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the request to enable a user
// as an administrator.
type AdminEnableUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminEnableUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminEnableUserOutput) GoString() string {
	return s.String()
}

// Sends the forgot device request, as an administrator.
type AdminForgetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminForgetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminForgetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminForgetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminForgetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AdminForgetDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminForgetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminForgetDeviceOutput) GoString() string {
	return s.String()
}

// Represents the request to get the device, as an administrator.
type AdminGetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminGetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminGetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminGetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminGetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Gets the device response, as an administrator.
type AdminGetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device.
	//
	// Device is a required field
	Device *DeviceType `type:"structure" required:"true"`
}

// String returns the string representation
func (s AdminGetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminGetDeviceOutput) GoString() string {
	return s.String()
}

// Represents the request to get the specified user as an administrator.
type AdminGetUserInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to get information about
	// the user.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user you wish to retrieve.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminGetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminGetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminGetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminGetUserInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server from the request to get the specified
// user as an administrator.
type AdminGetUserOutput struct {
	_ struct{} `type:"structure"`

	// Indicates that the status is enabled.
	Enabled *bool `type:"boolean"`

	// Specifies the options for MFA (e.g., email or phone number).
	MFAOptions []*MFAOptionType `type:"list"`

	// An array of name-value pairs representing user attributes.
	UserAttributes []*AttributeType `type:"list"`

	// The date the user was created.
	UserCreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date the user was last modified.
	UserLastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The user status. Can be one of the following:
	//
	//    * UNCONFIRMED - User has been created but not confirmed.
	//
	//    * CONFIRMED - User has been confirmed.
	//
	//    * ARCHIVED - User is no longer active.
	//
	//    * COMPROMISED - User is disabled due to a potential security threat.
	//
	//    * UNKNOWN - User status is not known.
	UserStatus *string `type:"string" enum:"UserStatusType"`

	// The user name of the user about whom you are receiving information.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminGetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminGetUserOutput) GoString() string {
	return s.String()
}

// Initiates the authorization request, as an administrator.
type AdminInitiateAuthInput struct {
	_ struct{} `type:"structure"`

	// The authentication flow.
	//
	// AuthFlow is a required field
	AuthFlow *string `type:"string" required:"true" enum:"AuthFlowType"`

	// The authentication parameters.
	AuthParameters map[string]*string `type:"map"`

	// The client app ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The client app metadata.
	ClientMetadata map[string]*string `type:"map"`

	// The ID of the Amazon Cognito user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminInitiateAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminInitiateAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminInitiateAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminInitiateAuthInput"}
	if s.AuthFlow == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthFlow"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Initiates the authentication response, as an administrator.
type AdminInitiateAuthOutput struct {
	_ struct{} `type:"structure"`

	// The result type of the authentication result.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge.
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters.
	ChallengeParameters map[string]*string `type:"map"`

	// The session.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s AdminInitiateAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminInitiateAuthOutput) GoString() string {
	return s.String()
}

// Represents the request to list devices, as an administrator.
type AdminListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The limit of the devices request.
	Limit *int64 `type:"integer"`

	// The pagination token.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminListDevicesInput"}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Lists the device's response, as an administrator.
type AdminListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices in the list of devices response.
	Devices []*DeviceType `type:"list"`

	// The pagination token.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdminListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminListDevicesOutput) GoString() string {
	return s.String()
}

// Represents the request to reset a user's password as an administrator.
type AdminResetUserPasswordInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool where you want to reset the user's password.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user whose password you wish to reset.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminResetUserPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminResetUserPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminResetUserPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminResetUserPasswordInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to reset a user password as an administrator.
type AdminResetUserPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminResetUserPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminResetUserPasswordOutput) GoString() string {
	return s.String()
}

// The request to respond to the authentication challenge, as an administrator.
type AdminRespondToAuthChallengeInput struct {
	_ struct{} `type:"structure"`

	// The name of the challenge.
	//
	// ChallengeName is a required field
	ChallengeName *string `type:"string" required:"true" enum:"ChallengeNameType"`

	// The challenge response.
	ChallengeResponses map[string]*string `type:"map"`

	// The client ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The session.
	Session *string `min:"20" type:"string"`

	// The ID of the Amazon Cognito user pool.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminRespondToAuthChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminRespondToAuthChallengeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminRespondToAuthChallengeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminRespondToAuthChallengeInput"}
	if s.ChallengeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeName"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Responds to the authentication challenge, as an administrator.
type AdminRespondToAuthChallengeOutput struct {
	_ struct{} `type:"structure"`

	// The result type of the authentication result.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge.
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters.
	ChallengeParameters map[string]*string `type:"map"`

	// The session.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s AdminRespondToAuthChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminRespondToAuthChallengeOutput) GoString() string {
	return s.String()
}

// Represents the request to set user settings as an administrator.
type AdminSetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the options for MFA (e.g., email or phone number).
	//
	// MFAOptions is a required field
	MFAOptions []*MFAOptionType `type:"list" required:"true"`

	// The user pool ID for the user pool where you want to set the user's settings,
	// such as MFA options.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user for whom you wish to set user settings.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminSetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminSetUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminSetUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminSetUserSettingsInput"}
	if s.MFAOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("MFAOptions"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.MFAOptions != nil {
		for i, v := range s.MFAOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MFAOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to set user settings as an administrator.
type AdminSetUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminSetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminSetUserSettingsOutput) GoString() string {
	return s.String()
}

// The request to update the device status, as an administrator.
type AdminUpdateDeviceStatusInput struct {
	_ struct{} `type:"structure"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The status indicating whether a device has been remembered or not.
	DeviceRememberedStatus *string `type:"string" enum:"DeviceRememberedStatusType"`

	// The user pool ID>
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminUpdateDeviceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateDeviceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateDeviceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUpdateDeviceStatusInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status response from the request to update the device, as an administrator.
type AdminUpdateDeviceStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminUpdateDeviceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateDeviceStatusOutput) GoString() string {
	return s.String()
}

// Represents the request to update the user's attributes as an administrator.
type AdminUpdateUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// An array of name-value pairs representing user attributes.
	//
	// UserAttributes is a required field
	UserAttributes []*AttributeType `type:"list" required:"true"`

	// The user pool ID for the user pool where you want to update user attributes.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name of the user for whom you want to update user attributes.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminUpdateUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUpdateUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUpdateUserAttributesInput"}
	if s.UserAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributes"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the request to update user attributes
// as an administrator.
type AdminUpdateUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminUpdateUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUpdateUserAttributesOutput) GoString() string {
	return s.String()
}

// The request to sign out of all devices, as an administrator.
type AdminUserGlobalSignOutInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AdminUserGlobalSignOutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUserGlobalSignOutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminUserGlobalSignOutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdminUserGlobalSignOutInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The global sign-out response, as an administrator.
type AdminUserGlobalSignOutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AdminUserGlobalSignOutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdminUserGlobalSignOutOutput) GoString() string {
	return s.String()
}

// Specifies whether the attribute is standard or custom.
type AttributeType struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s AttributeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeType"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result type of the authentication result.
type AuthenticationResultType struct {
	_ struct{} `type:"structure"`

	// The access token of the authentication result.
	AccessToken *string `type:"string"`

	// The expiration period of the authentication result.
	ExpiresIn *int64 `type:"integer"`

	// The ID token of the authentication result.
	IdToken *string `type:"string"`

	// The new device metadata from an authentication result.
	NewDeviceMetadata *NewDeviceMetadataType `type:"structure"`

	// The refresh token of the authentication result.
	RefreshToken *string `type:"string"`

	// The token type of the authentication result.
	TokenType *string `type:"string"`
}

// String returns the string representation
func (s AuthenticationResultType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthenticationResultType) GoString() string {
	return s.String()
}

// Represents the request to change a user password.
type ChangePasswordInput struct {
	_ struct{} `type:"structure"`

	// The access token in the change password request.
	AccessToken *string `type:"string"`

	// The old password in the change password request.
	//
	// PreviousPassword is a required field
	PreviousPassword *string `min:"6" type:"string" required:"true"`

	// The new password in the change password request.
	//
	// ProposedPassword is a required field
	ProposedPassword *string `min:"6" type:"string" required:"true"`
}

// String returns the string representation
func (s ChangePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangePasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangePasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangePasswordInput"}
	if s.PreviousPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("PreviousPassword"))
	}
	if s.PreviousPassword != nil && len(*s.PreviousPassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("PreviousPassword", 6))
	}
	if s.ProposedPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("ProposedPassword"))
	}
	if s.ProposedPassword != nil && len(*s.ProposedPassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("ProposedPassword", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the server to the change password request.
type ChangePasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ChangePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangePasswordOutput) GoString() string {
	return s.String()
}

// The type of code delivery details being returned from the server.
type CodeDeliveryDetailsType struct {
	_ struct{} `type:"structure"`

	// The name of the attribute in the code delivery details type.
	AttributeName *string `min:"1" type:"string"`

	// The delivery medium (email message or phone number).
	DeliveryMedium *string `type:"string" enum:"DeliveryMediumType"`

	// The destination for the code delivery details.
	Destination *string `type:"string"`
}

// String returns the string representation
func (s CodeDeliveryDetailsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeDeliveryDetailsType) GoString() string {
	return s.String()
}

// Confirms the device request.
type ConfirmDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The device name.
	DeviceName *string `min:"1" type:"string"`

	// The configuration of the device secret verifier.
	DeviceSecretVerifierConfig *DeviceSecretVerifierConfigType `type:"structure"`
}

// String returns the string representation
func (s ConfirmDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmDeviceInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Confirms the device response.
type ConfirmDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the user confirmation is necessary to confirm the device
	// response.
	UserConfirmationNecessary *bool `type:"boolean"`
}

// String returns the string representation
func (s ConfirmDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmDeviceOutput) GoString() string {
	return s.String()
}

// The request representing the confirmation for a password reset.
type ConfirmForgotPasswordInput struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The confirmation code sent by a user's request to retrieve a forgotten password.
	//
	// ConfirmationCode is a required field
	ConfirmationCode *string `min:"1" type:"string" required:"true"`

	// The password sent by sent by a user's request to retrieve a forgotten password.
	//
	// Password is a required field
	Password *string `min:"6" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// The user name of the user for whom you want to enter a code to retrieve a
	// forgotten password.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmForgotPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmForgotPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmForgotPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmForgotPasswordInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ConfirmationCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfirmationCode"))
	}
	if s.ConfirmationCode != nil && len(*s.ConfirmationCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfirmationCode", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the server that results from a user's request to retrieve
// a forgotten password.
type ConfirmForgotPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ConfirmForgotPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmForgotPasswordOutput) GoString() string {
	return s.String()
}

// Represents the request to confirm registration of a user.
type ConfirmSignUpInput struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The confirmation code sent by a user's request to confirm registration.
	//
	// ConfirmationCode is a required field
	ConfirmationCode *string `min:"1" type:"string" required:"true"`

	// Boolean to be specified to force user confirmation irrespective of existing
	// alias. By default set to False. If this parameter is set to True and the
	// phone number/email used for sign up confirmation already exists as an alias
	// with a different user, the API call will migrate the alias from the previous
	// user to the newly created user being confirmed. If set to False, the API
	// will throw an AliasExistsException error.
	ForceAliasCreation *bool `type:"boolean"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// The user name of the user whose registration you wish to confirm.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmSignUpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmSignUpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmSignUpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmSignUpInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ConfirmationCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfirmationCode"))
	}
	if s.ConfirmationCode != nil && len(*s.ConfirmationCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfirmationCode", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the registration confirmation.
type ConfirmSignUpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ConfirmSignUpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmSignUpOutput) GoString() string {
	return s.String()
}

// Represents the request to create the user import job.
type CreateUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The role ARN for the Amazon CloudWatch Logging role for the user import job.
	//
	// CloudWatchLogsRoleArn is a required field
	CloudWatchLogsRoleArn *string `min:"20" type:"string" required:"true"`

	// The job name for the user import job.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserImportJobInput"}
	if s.CloudWatchLogsRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLogsRoleArn"))
	}
	if s.CloudWatchLogsRoleArn != nil && len(*s.CloudWatchLogsRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLogsRoleArn", 20))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to create the user
// import job.
type CreateUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s CreateUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserImportJobOutput) GoString() string {
	return s.String()
}

// Represents the request to create a user pool client.
type CreateUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The client name for the user pool client you would like to create.
	//
	// ClientName is a required field
	ClientName *string `min:"1" type:"string" required:"true"`

	// The explicit authentication flows.
	ExplicitAuthFlows []*string `type:"list"`

	// Boolean to specify whether you want to generate a secret for the user pool
	// client being created.
	GenerateSecret *bool `type:"boolean"`

	// The read attributes.
	ReadAttributes []*string `type:"list"`

	// Refreshes the token validity.
	RefreshTokenValidity *int64 `type:"integer"`

	// The user pool ID for the user pool where you want to create a user pool client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The write attributes.
	WriteAttributes []*string `type:"list"`
}

// String returns the string representation
func (s CreateUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserPoolClientInput"}
	if s.ClientName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientName"))
	}
	if s.ClientName != nil && len(*s.ClientName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to create a user pool client.
type CreateUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client that was just created.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation
func (s CreateUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolClientOutput) GoString() string {
	return s.String()
}

// Represents the request to create a user pool.
type CreateUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType `type:"structure"`

	// Attributes supported as an alias for this user pool. Possible values: phone_number,
	// email, or preferred_username.
	AliasAttributes []*string `type:"list"`

	// The attributes to be auto-verified. Possible values: email, phone_number.
	AutoVerifiedAttributes []*string `type:"list"`

	// The device configuration.
	DeviceConfiguration *DeviceConfigurationType `type:"structure"`

	// The email configuration.
	EmailConfiguration *EmailConfigurationType `type:"structure"`

	// A string representing the email verification message.
	EmailVerificationMessage *string `min:"6" type:"string"`

	// A string representing the email verification subject.
	EmailVerificationSubject *string `min:"1" type:"string"`

	// The Lambda trigger configuration information for the new user pool.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// Specifies MFA configuration details.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The policies associated with the new user pool.
	Policies *UserPoolPolicyType `type:"structure"`

	// A string used to name the user pool.
	//
	// PoolName is a required field
	PoolName *string `min:"1" type:"string" required:"true"`

	// A string representing the SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`

	// A string representing the SMS verification message.
	SmsVerificationMessage *string `min:"6" type:"string"`
}

// String returns the string representation
func (s CreateUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserPoolInput"}
	if s.EmailVerificationMessage != nil && len(*s.EmailVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationMessage", 6))
	}
	if s.EmailVerificationSubject != nil && len(*s.EmailVerificationSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationSubject", 1))
	}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.PoolName != nil && len(*s.PoolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolName", 1))
	}
	if s.SmsAuthenticationMessage != nil && len(*s.SmsAuthenticationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsAuthenticationMessage", 6))
	}
	if s.SmsVerificationMessage != nil && len(*s.SmsVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsVerificationMessage", 6))
	}
	if s.AdminCreateUserConfig != nil {
		if err := s.AdminCreateUserConfig.Validate(); err != nil {
			invalidParams.AddNested("AdminCreateUserConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EmailConfiguration != nil {
		if err := s.EmailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EmailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaConfig != nil {
		if err := s.LambdaConfig.Validate(); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Policies != nil {
		if err := s.Policies.Validate(); err != nil {
			invalidParams.AddNested("Policies", err.(request.ErrInvalidParams))
		}
	}
	if s.SmsConfiguration != nil {
		if err := s.SmsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SmsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the request to create a user
// pool.
type CreateUserPoolOutput struct {
	_ struct{} `type:"structure"`

	// A container for the user pool details.
	UserPool *UserPoolType `type:"structure"`
}

// String returns the string representation
func (s CreateUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserPoolOutput) GoString() string {
	return s.String()
}

// Represents the request to delete user attributes.
type DeleteUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// The access token used in the request to delete user attributes.
	AccessToken *string `type:"string"`

	// An array of strings representing the user attribute names you wish to delete.
	//
	// UserAttributeNames is a required field
	UserAttributeNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserAttributesInput"}
	if s.UserAttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributeNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to delete user attributes.
type DeleteUserAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserAttributesOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user.
type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The access token from a request to delete a user.
	AccessToken *string `type:"string"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user pool client.
type DeleteUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool where you want to delete the client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPoolClientInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteUserPoolClientOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolClientOutput) GoString() string {
	return s.String()
}

// Represents the request to delete a user pool.
type DeleteUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool you want to delete.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPoolInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteUserPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPoolOutput) GoString() string {
	return s.String()
}

// Represents the request to describe the user import job.
type DescribeUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID for the user import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to describe the user
// import job.
type DescribeUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserImportJobOutput) GoString() string {
	return s.String()
}

// Represents the request to describe a user pool client.
type DescribeUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool you want to describe.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserPoolClientInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server from a request to describe the user
// pool client.
type DescribeUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client from a server response to describe the user pool client.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolClientOutput) GoString() string {
	return s.String()
}

// Represents the request to describe the user pool.
type DescribeUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool you want to describe.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserPoolInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response to describe the user pool.
type DescribeUserPoolOutput struct {
	_ struct{} `type:"structure"`

	// The container of metadata returned by the server to describe the pool.
	UserPool *UserPoolType `type:"structure"`
}

// String returns the string representation
func (s DescribeUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserPoolOutput) GoString() string {
	return s.String()
}

// The type of configuration for the user pool's device tracking.
type DeviceConfigurationType struct {
	_ struct{} `type:"structure"`

	// Indicates whether a challenge is required on a new device. Only applicable
	// to a new device.
	ChallengeRequiredOnNewDevice *bool `type:"boolean"`

	// If true, a device is only remembered on user prompt.
	DeviceOnlyRememberedOnUserPrompt *bool `type:"boolean"`
}

// String returns the string representation
func (s DeviceConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceConfigurationType) GoString() string {
	return s.String()
}

// The device verifier against which it will be authenticated.
type DeviceSecretVerifierConfigType struct {
	_ struct{} `type:"structure"`

	// The password verifier.
	PasswordVerifier *string `type:"string"`

	// The salt.
	Salt *string `type:"string"`
}

// String returns the string representation
func (s DeviceSecretVerifierConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceSecretVerifierConfigType) GoString() string {
	return s.String()
}

// The device type.
type DeviceType struct {
	_ struct{} `type:"structure"`

	// The device attributes.
	DeviceAttributes []*AttributeType `type:"list"`

	// The creation date of the device.
	DeviceCreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The device key.
	DeviceKey *string `min:"1" type:"string"`

	// The date in which the device was last authenticated.
	DeviceLastAuthenticatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last modified date of the device.
	DeviceLastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DeviceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceType) GoString() string {
	return s.String()
}

// The email configuration type.
type EmailConfigurationType struct {
	_ struct{} `type:"structure"`

	// The REPLY-TO email address.
	ReplyToEmailAddress *string `type:"string"`

	// The Amazon Resource Name (ARN) of the email source.
	SourceArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s EmailConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmailConfigurationType"}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the request to forget the device.
type ForgetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token for the forgotten device request.
	AccessToken *string `type:"string"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ForgetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForgetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForgetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ForgetDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ForgetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForgetDeviceOutput) GoString() string {
	return s.String()
}

// Represents the request to reset a user's password.
type ForgotPasswordInput struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// The user name of the user for whom you want to enter a code to retrieve a
	// forgotten password.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ForgotPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForgotPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgotPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForgotPasswordInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Respresents the response from the server regarding the request to reset a
// password.
type ForgotPasswordOutput struct {
	_ struct{} `type:"structure"`

	// The type of code delivery details being returned from the server.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation
func (s ForgotPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForgotPasswordOutput) GoString() string {
	return s.String()
}

// Represents the request to get the header information for the .csv file for
// the user import job.
type GetCSVHeaderInput struct {
	_ struct{} `type:"structure"`

	// The user pool ID for the user pool that the users are to be imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCSVHeaderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCSVHeaderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCSVHeaderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCSVHeaderInput"}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to get the header
// information for the .csv file for the user import job.
type GetCSVHeaderOutput struct {
	_ struct{} `type:"structure"`

	// The header information for the .csv file for the user import job.
	CSVHeader []*string `type:"list"`

	// The user pool ID for the user pool that the users are to be imported into.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetCSVHeaderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCSVHeaderOutput) GoString() string {
	return s.String()
}

// Represents the request to get the device.
type GetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	AccessToken *string `type:"string"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceInput"}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Gets the device response.
type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The device.
	//
	// Device is a required field
	Device *DeviceType `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// Represents the request to get user attribute verification.
type GetUserAttributeVerificationCodeInput struct {
	_ struct{} `type:"structure"`

	// The access token returned by the server response to get the user attribute
	// verification code.
	AccessToken *string `type:"string"`

	// The attribute name returned by the server response to get the user attribute
	// verification code.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserAttributeVerificationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserAttributeVerificationCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserAttributeVerificationCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserAttributeVerificationCodeInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The verification code response returned by the server response to get the
// user attribute verification code.
type GetUserAttributeVerificationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server response to get the user
	// attribute verification code.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation
func (s GetUserAttributeVerificationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserAttributeVerificationCodeOutput) GoString() string {
	return s.String()
}

// Represents the request to get information about the user.
type GetUserInput struct {
	_ struct{} `type:"structure"`

	// The access token returned by the server response to get information about
	// the user.
	AccessToken *string `type:"string"`
}

// String returns the string representation
func (s GetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserInput) GoString() string {
	return s.String()
}

// Represents the response from the server from the request to get information
// about the user.
type GetUserOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the options for MFA (e.g., email or phone number).
	MFAOptions []*MFAOptionType `type:"list"`

	// An array of name-value pairs representing user attributes.
	//
	// UserAttributes is a required field
	UserAttributes []*AttributeType `type:"list" required:"true"`

	// The user name of the user you wish to retrieve from the get user request.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserOutput) GoString() string {
	return s.String()
}

// Represents the request to sign out all devices.
type GlobalSignOutInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	AccessToken *string `type:"string"`
}

// String returns the string representation
func (s GlobalSignOutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSignOutInput) GoString() string {
	return s.String()
}

// The response to the request to sign out all devices.
type GlobalSignOutOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GlobalSignOutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSignOutOutput) GoString() string {
	return s.String()
}

// Initiates the authentication request.
type InitiateAuthInput struct {
	_ struct{} `type:"structure"`

	// The authentication flow.
	//
	// AuthFlow is a required field
	AuthFlow *string `type:"string" required:"true" enum:"AuthFlowType"`

	// The authentication parameters.
	AuthParameters map[string]*string `type:"map"`

	// The client ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The client app's metadata.
	ClientMetadata map[string]*string `type:"map"`
}

// String returns the string representation
func (s InitiateAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InitiateAuthInput"}
	if s.AuthFlow == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthFlow"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Initiates the authentication response.
type InitiateAuthOutput struct {
	_ struct{} `type:"structure"`

	// The result type of the authentication result.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The name of the challenge.
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters.
	ChallengeParameters map[string]*string `type:"map"`

	// The session.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s InitiateAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateAuthOutput) GoString() string {
	return s.String()
}

// Specifies the type of configuration for AWS Lambda triggers.
type LambdaConfigType struct {
	_ struct{} `type:"structure"`

	// Creates an authentication challenge.
	CreateAuthChallenge *string `min:"20" type:"string"`

	// A custom Message AWS Lambda trigger.
	CustomMessage *string `min:"20" type:"string"`

	// Defines the authentication challenge.
	DefineAuthChallenge *string `min:"20" type:"string"`

	// A post-authentication AWS Lambda trigger.
	PostAuthentication *string `min:"20" type:"string"`

	// A post-confirmation AWS Lambda trigger.
	PostConfirmation *string `min:"20" type:"string"`

	// A pre-authentication AWS Lambda trigger.
	PreAuthentication *string `min:"20" type:"string"`

	// A pre-registration AWS Lambda trigger.
	PreSignUp *string `min:"20" type:"string"`

	// Verifies the authentication challenge response.
	VerifyAuthChallengeResponse *string `min:"20" type:"string"`
}

// String returns the string representation
func (s LambdaConfigType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaConfigType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaConfigType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaConfigType"}
	if s.CreateAuthChallenge != nil && len(*s.CreateAuthChallenge) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CreateAuthChallenge", 20))
	}
	if s.CustomMessage != nil && len(*s.CustomMessage) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomMessage", 20))
	}
	if s.DefineAuthChallenge != nil && len(*s.DefineAuthChallenge) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DefineAuthChallenge", 20))
	}
	if s.PostAuthentication != nil && len(*s.PostAuthentication) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PostAuthentication", 20))
	}
	if s.PostConfirmation != nil && len(*s.PostConfirmation) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PostConfirmation", 20))
	}
	if s.PreAuthentication != nil && len(*s.PreAuthentication) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PreAuthentication", 20))
	}
	if s.PreSignUp != nil && len(*s.PreSignUp) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PreSignUp", 20))
	}
	if s.VerifyAuthChallengeResponse != nil && len(*s.VerifyAuthChallengeResponse) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("VerifyAuthChallengeResponse", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the request to list the devices.
type ListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The access tokens for the request to list devices.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The limit of the device request.
	Limit *int64 `type:"integer"`

	// The pagination token for the list request.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response to list devices.
type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices returned in the list devices response.
	Devices []*DeviceType `type:"list"`

	// The pagination token for the list device response.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// Represents the request to list the user import jobs.
type ListUserImportJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of import jobs you want the request to return.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// An identifier that was returned from the previous call to ListUserImportJobs,
	// which can be used to return the next set of import jobs in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserImportJobsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to list the user import
// jobs.
type ListUserImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that can be used to return the next set of user import jobs
	// in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user import jobs.
	UserImportJobs []*UserImportJobType `min:"1" type:"list"`
}

// String returns the string representation
func (s ListUserImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserImportJobsOutput) GoString() string {
	return s.String()
}

// Represents the request to list the user pool clients.
type ListUserPoolClientsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return when listing
	// the user pool clients.
	MaxResults *int64 `min:"1" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool where you want to list user pool clients.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserPoolClientsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoolClientsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoolClientsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserPoolClientsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server that lists user pool clients.
type ListUserPoolClientsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pool clients in the response that lists user pool clients.
	UserPoolClients []*UserPoolClientDescription `type:"list"`
}

// String returns the string representation
func (s ListUserPoolClientsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoolClientsOutput) GoString() string {
	return s.String()
}

// Represents the request to list user pools.
type ListUserPoolsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results you want the request to return when listing
	// the user pools.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListUserPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserPoolsInput"}
	if s.MaxResults == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response to list user pools.
type ListUserPoolsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `min:"1" type:"string"`

	// The user pools from the response to list users.
	UserPools []*UserPoolDescriptionType `type:"list"`
}

// String returns the string representation
func (s ListUserPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoolsOutput) GoString() string {
	return s.String()
}

// Represents the request to list users.
type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The attributes to get from the request to list users.
	AttributesToGet []*string `type:"list"`

	// The filter for the list users request.
	Filter *string `type:"string"`

	// The limit of the request to list users.
	Limit *int64 `type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID for which you want to list users.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PaginationToken", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the request to list users.
type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The users returned in the request to list users.
	Users []*UserType `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// Specifies the different settings for multi-factor authentication (MFA).
type MFAOptionType struct {
	_ struct{} `type:"structure"`

	// The attribute name of the MFA option type.
	AttributeName *string `min:"1" type:"string"`

	// The delivery medium (email message or SMS message) to send the MFA code.
	DeliveryMedium *string `type:"string" enum:"DeliveryMediumType"`
}

// String returns the string representation
func (s MFAOptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MFAOptionType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MFAOptionType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MFAOptionType"}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The message template structure.
type MessageTemplateType struct {
	_ struct{} `type:"structure"`

	// The message template for email messages.
	EmailMessage *string `min:"6" type:"string"`

	// The subject line for email messages.
	EmailSubject *string `min:"1" type:"string"`

	// The message template for SMS messages.
	SMSMessage *string `min:"6" type:"string"`
}

// String returns the string representation
func (s MessageTemplateType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageTemplateType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTemplateType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageTemplateType"}
	if s.EmailMessage != nil && len(*s.EmailMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailMessage", 6))
	}
	if s.EmailSubject != nil && len(*s.EmailSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailSubject", 1))
	}
	if s.SMSMessage != nil && len(*s.SMSMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SMSMessage", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The new device metadata type.
type NewDeviceMetadataType struct {
	_ struct{} `type:"structure"`

	// The device group key.
	DeviceGroupKey *string `type:"string"`

	// The device key.
	DeviceKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NewDeviceMetadataType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewDeviceMetadataType) GoString() string {
	return s.String()
}

// The minimum and maximum value of an attribute that is of the number data
// type.
type NumberAttributeConstraintsType struct {
	_ struct{} `type:"structure"`

	// The maximum value of an attribute that is of the number data type.
	MaxValue *string `type:"string"`

	// The minimum value of an attribute that is of the number data type.
	MinValue *string `type:"string"`
}

// String returns the string representation
func (s NumberAttributeConstraintsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NumberAttributeConstraintsType) GoString() string {
	return s.String()
}

// The password policy type.
type PasswordPolicyType struct {
	_ struct{} `type:"structure"`

	// The minimum length of the password policy that you have set. Cannot be less
	// than 6.
	MinimumLength *int64 `min:"6" type:"integer"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one lowercase letter in their password.
	RequireLowercase *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one number in their password.
	RequireNumbers *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one symbol in their password.
	RequireSymbols *bool `type:"boolean"`

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one uppercase letter in their password.
	RequireUppercase *bool `type:"boolean"`
}

// String returns the string representation
func (s PasswordPolicyType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PasswordPolicyType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PasswordPolicyType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PasswordPolicyType"}
	if s.MinimumLength != nil && *s.MinimumLength < 6 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumLength", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the request to resend the confirmation code.
type ResendConfirmationCodeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// The user name of the user to whom you wish to resend a confirmation code.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResendConfirmationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendConfirmationCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResendConfirmationCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResendConfirmationCodeInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the server when the Amazon Cognito service makes the request
// to resend a confirmation code.
type ResendConfirmationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The type of code delivery details being returned from the server.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation
func (s ResendConfirmationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendConfirmationCodeOutput) GoString() string {
	return s.String()
}

// The request to respond to an authentication challenge.
type RespondToAuthChallengeInput struct {
	_ struct{} `type:"structure"`

	// The name of the challenge.
	//
	// ChallengeName is a required field
	ChallengeName *string `type:"string" required:"true" enum:"ChallengeNameType"`

	// The responses to the authentication challenge.
	ChallengeResponses map[string]*string `type:"map"`

	// The client ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The session.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s RespondToAuthChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondToAuthChallengeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondToAuthChallengeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RespondToAuthChallengeInput"}
	if s.ChallengeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChallengeName"))
	}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Session", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to respond to the authentication challenge.
type RespondToAuthChallengeOutput struct {
	_ struct{} `type:"structure"`

	// The result type of the authentication result.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The challenge name.
	ChallengeName *string `type:"string" enum:"ChallengeNameType"`

	// The challenge parameters.
	ChallengeParameters map[string]*string `type:"map"`

	// The session.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s RespondToAuthChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondToAuthChallengeOutput) GoString() string {
	return s.String()
}

// Contains information about the schema attribute.
type SchemaAttributeType struct {
	_ struct{} `type:"structure"`

	// The attribute data type.
	AttributeDataType *string `type:"string" enum:"AttributeDataType"`

	// Specifies whether the attribute type is developer only.
	DeveloperOnlyAttribute *bool `type:"boolean"`

	// Specifies whether the attribute can be changed once it has been created.
	Mutable *bool `type:"boolean"`

	// A schema attribute of the name type.
	Name *string `min:"1" type:"string"`

	// Specifies the constraints for an attribute of the number type.
	NumberAttributeConstraints *NumberAttributeConstraintsType `type:"structure"`

	// Specifies whether a user pool attribute is required. If the attribute is
	// required and the user does not provide a value, registration or sign-in will
	// fail.
	Required *bool `type:"boolean"`

	// Specifies the constraints for an attribute of the string type.
	StringAttributeConstraints *StringAttributeConstraintsType `type:"structure"`
}

// String returns the string representation
func (s SchemaAttributeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SchemaAttributeType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaAttributeType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaAttributeType"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the request to set user settings.
type SetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// The access token for the set user settings request.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// Specifies the options for MFA (e.g., email or phone number).
	//
	// MFAOptions is a required field
	MFAOptions []*MFAOptionType `type:"list" required:"true"`
}

// String returns the string representation
func (s SetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetUserSettingsInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.MFAOptions == nil {
		invalidParams.Add(request.NewErrParamRequired("MFAOptions"))
	}
	if s.MFAOptions != nil {
		for i, v := range s.MFAOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MFAOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the server for a set user settings request.
type SetUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetUserSettingsOutput) GoString() string {
	return s.String()
}

// Represents the request to register a user.
type SignUpInput struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The password of the user you wish to register.
	//
	// Password is a required field
	Password *string `min:"6" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// An array of name-value pairs representing user attributes.
	UserAttributes []*AttributeType `type:"list"`

	// The user name of the user you wish to register.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`

	// The validation data in the request to register a user.
	ValidationData []*AttributeType `type:"list"`
}

// String returns the string representation
func (s SignUpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignUpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignUpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignUpInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretHash", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ValidationData != nil {
		for i, v := range s.ValidationData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the server for a registration request.
type SignUpOutput struct {
	_ struct{} `type:"structure"`

	// The type of code delivery details being returned from the server.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`

	// A response from the server indicating that a user registration has been confirmed.
	UserConfirmed *bool `type:"boolean"`
}

// String returns the string representation
func (s SignUpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignUpOutput) GoString() string {
	return s.String()
}

// The SMS configuratoin type.
type SmsConfigurationType struct {
	_ struct{} `type:"structure"`

	// The external ID.
	ExternalId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) caller.
	SnsCallerArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s SmsConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SmsConfigurationType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SmsConfigurationType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SmsConfigurationType"}
	if s.SnsCallerArn != nil && len(*s.SnsCallerArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SnsCallerArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the request to start the user import job.
type StartUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID for the user import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartUserImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to start the user
// import job.
type StartUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s StartUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartUserImportJobOutput) GoString() string {
	return s.String()
}

// Represents the request to stop the user import job.
type StopUserImportJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID for the user import job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopUserImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopUserImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopUserImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopUserImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to stop the user import
// job.
type StopUserImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The job object that represents the user import job.
	UserImportJob *UserImportJobType `type:"structure"`
}

// String returns the string representation
func (s StopUserImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopUserImportJobOutput) GoString() string {
	return s.String()
}

// The type of constraints associated with an attribute of the string type.
type StringAttributeConstraintsType struct {
	_ struct{} `type:"structure"`

	// The maximum length of an attribute value of the string type.
	MaxLength *string `type:"string"`

	// The minimum length of an attribute value of the string type.
	MinLength *string `type:"string"`
}

// String returns the string representation
func (s StringAttributeConstraintsType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StringAttributeConstraintsType) GoString() string {
	return s.String()
}

// Represents the request to update the device status.
type UpdateDeviceStatusInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The status of whether a device is remembered.
	DeviceRememberedStatus *string `type:"string" enum:"DeviceRememberedStatusType"`
}

// String returns the string representation
func (s UpdateDeviceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeviceStatusInput"}
	if s.AccessToken == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessToken"))
	}
	if s.DeviceKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to the request to update the device status.
type UpdateDeviceStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeviceStatusOutput) GoString() string {
	return s.String()
}

// Represents the request to update user attributes.
type UpdateUserAttributesInput struct {
	_ struct{} `type:"structure"`

	// The access token for the request to update user attributes.
	AccessToken *string `type:"string"`

	// An array of name-value pairs representing user attributes.
	//
	// UserAttributes is a required field
	UserAttributes []*AttributeType `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateUserAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserAttributesInput"}
	if s.UserAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("UserAttributes"))
	}
	if s.UserAttributes != nil {
		for i, v := range s.UserAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server for the request to update user attributes.
type UpdateUserAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details list from the server for the request to update
	// user attributes.
	CodeDeliveryDetailsList []*CodeDeliveryDetailsType `type:"list"`
}

// String returns the string representation
func (s UpdateUserAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserAttributesOutput) GoString() string {
	return s.String()
}

// Represents the request to update the user pool client.
type UpdateUserPoolClientInput struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// The client name from the update user pool client request.
	ClientName *string `min:"1" type:"string"`

	// Explicit authentication flows.
	ExplicitAuthFlows []*string `type:"list"`

	// The read-only attributes of the user pool.
	ReadAttributes []*string `type:"list"`

	// The validity of the refresh token.
	RefreshTokenValidity *int64 `type:"integer"`

	// The user pool ID for the user pool where you want to update the user pool
	// client.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The writeable attributes of the user pool.
	WriteAttributes []*string `type:"list"`
}

// String returns the string representation
func (s UpdateUserPoolClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPoolClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserPoolClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserPoolClientInput"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientId", 1))
	}
	if s.ClientName != nil && len(*s.ClientName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientName", 1))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to update the user
// pool client.
type UpdateUserPoolClientOutput struct {
	_ struct{} `type:"structure"`

	// The user pool client value from the response from the server when an update
	// user pool client request is made.
	UserPoolClient *UserPoolClientType `type:"structure"`
}

// String returns the string representation
func (s UpdateUserPoolClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPoolClientOutput) GoString() string {
	return s.String()
}

// Represents the request to update the user pool.
type UpdateUserPoolInput struct {
	_ struct{} `type:"structure"`

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType `type:"structure"`

	// The attributes that are automatically verified when the Amazon Cognito service
	// makes a request to update user pools.
	AutoVerifiedAttributes []*string `type:"list"`

	// Device configuration.
	DeviceConfiguration *DeviceConfigurationType `type:"structure"`

	// Email configuration.
	EmailConfiguration *EmailConfigurationType `type:"structure"`

	// The contents of the email verification message.
	EmailVerificationMessage *string `min:"6" type:"string"`

	// The subject of the email verfication message.
	EmailVerificationSubject *string `min:"1" type:"string"`

	// The AWS Lambda configuration information from the request to update the user
	// pool.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// Can be one of the following values:
	//
	//    * OFF - MFA tokens are not required and cannot be specified during user
	//    registration.
	//
	//    * ON - MFA tokens are required for all user registrations. You can only
	//    specify required when you are initially creating a user pool.
	//
	//    * OPTIONAL - Users have the option when registering to create an MFA token.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// A container with the policies you wish to update in a user pool.
	Policies *UserPoolPolicyType `type:"structure"`

	// The contents of the SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`

	// A container with information about the SMS verification message.
	SmsVerificationMessage *string `min:"6" type:"string"`

	// The user pool ID for the user pool you want to update.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserPoolInput"}
	if s.EmailVerificationMessage != nil && len(*s.EmailVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationMessage", 6))
	}
	if s.EmailVerificationSubject != nil && len(*s.EmailVerificationSubject) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailVerificationSubject", 1))
	}
	if s.SmsAuthenticationMessage != nil && len(*s.SmsAuthenticationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsAuthenticationMessage", 6))
	}
	if s.SmsVerificationMessage != nil && len(*s.SmsVerificationMessage) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("SmsVerificationMessage", 6))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserPoolId", 1))
	}
	if s.AdminCreateUserConfig != nil {
		if err := s.AdminCreateUserConfig.Validate(); err != nil {
			invalidParams.AddNested("AdminCreateUserConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.EmailConfiguration != nil {
		if err := s.EmailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EmailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaConfig != nil {
		if err := s.LambdaConfig.Validate(); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Policies != nil {
		if err := s.Policies.Validate(); err != nil {
			invalidParams.AddNested("Policies", err.(request.ErrInvalidParams))
		}
	}
	if s.SmsConfiguration != nil {
		if err := s.SmsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SmsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server when you make a request to update
// the user pool.
type UpdateUserPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPoolOutput) GoString() string {
	return s.String()
}

// The user import job type.
type UserImportJobType struct {
	_ struct{} `type:"structure"`

	// The role ARN for the Amazon CloudWatch Logging role for the user import job.
	// For more information, see "Creating the CloudWatch Logs IAM Role" in the
	// Amazon Cognito Developer Guide.
	CloudWatchLogsRoleArn *string `min:"20" type:"string"`

	// The date when the user imoprt job was completed.
	CompletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The message returned when the user import job is completed.
	CompletionMessage *string `min:"1" type:"string"`

	// The date when the user import job was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The number of users that could not be imported.
	FailedUsers *int64 `type:"long"`

	// The number of users that were successfully imported.
	ImportedUsers *int64 `type:"long"`

	// The job ID for the user import job.
	JobId *string `min:"1" type:"string"`

	// The job name for the user import job.
	JobName *string `min:"1" type:"string"`

	// The pre-signed URL to be used to upload the .csv file.
	PreSignedUrl *string `type:"string"`

	// The number of users that were skipped.
	SkippedUsers *int64 `type:"long"`

	// The date when the user import job was started.
	StartDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of the user import job. One of the following:
	//
	//    * Created - The job was created but not started.
	//
	//    * Pending - A transition state. You have started the job, but it has not
	//    begun importing users yet.
	//
	//    * InProgress - The job has started, and users are being imported.
	//
	//    * Stopping - You have stopped the job, but the job has not stopped importing
	//    users yet.
	//
	//    * Stopped - You have stopped the job, and the job has stopped importing
	//    users.
	//
	//    * Succeeded - The job has completed successfully.
	//
	//    * Failed - The job has stopped due to an error.
	//
	//    * Expired - You created a job, but did not start the job within 24-48
	//    hours. All data associated with the job was deleted, and the job cannot
	//    be started.
	Status *string `type:"string" enum:"UserImportJobStatusType"`

	// The user pool ID for the user pool that the users are being imported into.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserImportJobType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserImportJobType) GoString() string {
	return s.String()
}

// The description of the user poool client.
type UserPoolClientDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	ClientId *string `min:"1" type:"string"`

	// The client name from the user pool client description.
	ClientName *string `min:"1" type:"string"`

	// The user pool ID for the user pool where you want to describe the user pool
	// client.
	UserPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserPoolClientDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolClientDescription) GoString() string {
	return s.String()
}

// A user pool of the client type.
type UserPoolClientType struct {
	_ struct{} `type:"structure"`

	// The ID of the client associated with the user pool.
	ClientId *string `min:"1" type:"string"`

	// The client name from the user pool request of the client type.
	ClientName *string `min:"1" type:"string"`

	// The client secret from the user pool request of the client type.
	ClientSecret *string `min:"1" type:"string"`

	// The creation date from the user pool request of the client type.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The explicit authentication flows.
	ExplicitAuthFlows []*string `type:"list"`

	// The last modified date from the user pool request of the client type.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Read-only attributes.
	ReadAttributes []*string `type:"list"`

	// The validity of the refresh token.
	RefreshTokenValidity *int64 `type:"integer"`

	// The user pool ID for the user pool client.
	UserPoolId *string `min:"1" type:"string"`

	// The writeable attributes.
	WriteAttributes []*string `type:"list"`
}

// String returns the string representation
func (s UserPoolClientType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolClientType) GoString() string {
	return s.String()
}

// A user pool description.
type UserPoolDescriptionType struct {
	_ struct{} `type:"structure"`

	// The creation date in a user pool description.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID in a user pool description.
	Id *string `min:"1" type:"string"`

	// The AWS Lambda configuration information in a user pool description.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// The last modified date in a user pool description.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name in a user pool description.
	Name *string `min:"1" type:"string"`

	// The user pool status in a user pool description.
	Status *string `type:"string" enum:"StatusType"`
}

// String returns the string representation
func (s UserPoolDescriptionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolDescriptionType) GoString() string {
	return s.String()
}

// The type of policy in a user pool.
type UserPoolPolicyType struct {
	_ struct{} `type:"structure"`

	// A container with information about the user pool password policy.
	PasswordPolicy *PasswordPolicyType `type:"structure"`
}

// String returns the string representation
func (s UserPoolPolicyType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolPolicyType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPoolPolicyType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserPoolPolicyType"}
	if s.PasswordPolicy != nil {
		if err := s.PasswordPolicy.Validate(); err != nil {
			invalidParams.AddNested("PasswordPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A container with information about the user pool type.
type UserPoolType struct {
	_ struct{} `type:"structure"`

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType `type:"structure"`

	// Specifies the attributes that are aliased in a user pool.
	AliasAttributes []*string `type:"list"`

	// Specifies the attributes that are auto-verified in a user pool.
	AutoVerifiedAttributes []*string `type:"list"`

	// The creation date of a user pool.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The device configuration.
	DeviceConfiguration *DeviceConfigurationType `type:"structure"`

	// The email configuration.
	EmailConfiguration *EmailConfigurationType `type:"structure"`

	// The reason why the email configuration cannot send the messages to your users.
	EmailConfigurationFailure *string `type:"string"`

	// The contents of the email verification message.
	EmailVerificationMessage *string `min:"6" type:"string"`

	// The subject of the email verification message.
	EmailVerificationSubject *string `min:"1" type:"string"`

	// A number estimating the size of the user pool.
	EstimatedNumberOfUsers *int64 `type:"integer"`

	// The ID of the user pool.
	Id *string `min:"1" type:"string"`

	// A container describing the AWS Lambda triggers associated with a user pool.
	LambdaConfig *LambdaConfigType `type:"structure"`

	// The last modified date of a user pool.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Can be one of the following values:
	//
	//    * OFF - MFA tokens are not required and cannot be specified during user
	//    registration.
	//
	//    * ON - MFA tokens are required for all user registrations. You can only
	//    specify required when you are initially creating a user pool.
	//
	//    * OPTIONAL - Users have the option when registering to create an MFA token.
	MfaConfiguration *string `type:"string" enum:"UserPoolMfaType"`

	// The name of the user pool.
	Name *string `min:"1" type:"string"`

	// A container describing the policies associated with a user pool.
	Policies *UserPoolPolicyType `type:"structure"`

	// A container with the schema attributes of a user pool.
	SchemaAttributes []*SchemaAttributeType `min:"1" type:"list"`

	// The contents of the SMS authentication message.
	SmsAuthenticationMessage *string `min:"6" type:"string"`

	// The SMS configuration.
	SmsConfiguration *SmsConfigurationType `type:"structure"`

	// The reason why the SMS configuration cannot send the message(s) to your users.
	SmsConfigurationFailure *string `type:"string"`

	// The contents of the SMS verification message.
	SmsVerificationMessage *string `min:"6" type:"string"`

	// The status of a user pool.
	Status *string `type:"string" enum:"StatusType"`
}

// String returns the string representation
func (s UserPoolType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPoolType) GoString() string {
	return s.String()
}

// The user type.
type UserType struct {
	_ struct{} `type:"structure"`

	// A container with information about the user type attributes.
	Attributes []*AttributeType `type:"list"`

	// Specifies whether the user is enabled.
	Enabled *bool `type:"boolean"`

	// The MFA options for the user.
	MFAOptions []*MFAOptionType `type:"list"`

	// The creation date of the user.
	UserCreateDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last modified date of the user.
	UserLastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The user status. Can be one of the following:
	//
	//    * UNCONFIRMED - User has been created but not confirmed.
	//
	//    * CONFIRMED - User has been confirmed.
	//
	//    * ARCHIVED - User is no longer active.
	//
	//    * COMPROMISED - User is disabled due to a potential security threat.
	//
	//    * UNKNOWN - User status is not known.
	UserStatus *string `type:"string" enum:"UserStatusType"`

	// The user name of the user you wish to describe.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserType) GoString() string {
	return s.String()
}

// Represents the request to verify user attributes.
type VerifyUserAttributeInput struct {
	_ struct{} `type:"structure"`

	// Represents the access token of the request to verify user attributes.
	AccessToken *string `type:"string"`

	// The attribute name in the request to verify user attributes.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The verification code in the request to verify user attributes.
	//
	// Code is a required field
	Code *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyUserAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyUserAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyUserAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyUserAttributeInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.Code != nil && len(*s.Code) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Code", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A container representing the response from the server from the request to
// verify user attributes.
type VerifyUserAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s VerifyUserAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyUserAttributeOutput) GoString() string {
	return s.String()
}

const (
	// AliasAttributeTypePhoneNumber is a AliasAttributeType enum value
	AliasAttributeTypePhoneNumber = "phone_number"

	// AliasAttributeTypeEmail is a AliasAttributeType enum value
	AliasAttributeTypeEmail = "email"

	// AliasAttributeTypePreferredUsername is a AliasAttributeType enum value
	AliasAttributeTypePreferredUsername = "preferred_username"
)

const (
	// AttributeDataTypeString is a AttributeDataType enum value
	AttributeDataTypeString = "String"

	// AttributeDataTypeNumber is a AttributeDataType enum value
	AttributeDataTypeNumber = "Number"

	// AttributeDataTypeDateTime is a AttributeDataType enum value
	AttributeDataTypeDateTime = "DateTime"

	// AttributeDataTypeBoolean is a AttributeDataType enum value
	AttributeDataTypeBoolean = "Boolean"
)

const (
	// AuthFlowTypeUserSrpAuth is a AuthFlowType enum value
	AuthFlowTypeUserSrpAuth = "USER_SRP_AUTH"

	// AuthFlowTypeRefreshTokenAuth is a AuthFlowType enum value
	AuthFlowTypeRefreshTokenAuth = "REFRESH_TOKEN_AUTH"

	// AuthFlowTypeRefreshToken is a AuthFlowType enum value
	AuthFlowTypeRefreshToken = "REFRESH_TOKEN"

	// AuthFlowTypeCustomAuth is a AuthFlowType enum value
	AuthFlowTypeCustomAuth = "CUSTOM_AUTH"

	// AuthFlowTypeAdminNoSrpAuth is a AuthFlowType enum value
	AuthFlowTypeAdminNoSrpAuth = "ADMIN_NO_SRP_AUTH"
)

const (
	// ChallengeNameTypeSmsMfa is a ChallengeNameType enum value
	ChallengeNameTypeSmsMfa = "SMS_MFA"

	// ChallengeNameTypePasswordVerifier is a ChallengeNameType enum value
	ChallengeNameTypePasswordVerifier = "PASSWORD_VERIFIER"

	// ChallengeNameTypeCustomChallenge is a ChallengeNameType enum value
	ChallengeNameTypeCustomChallenge = "CUSTOM_CHALLENGE"

	// ChallengeNameTypeDeviceSrpAuth is a ChallengeNameType enum value
	ChallengeNameTypeDeviceSrpAuth = "DEVICE_SRP_AUTH"

	// ChallengeNameTypeDevicePasswordVerifier is a ChallengeNameType enum value
	ChallengeNameTypeDevicePasswordVerifier = "DEVICE_PASSWORD_VERIFIER"

	// ChallengeNameTypeAdminNoSrpAuth is a ChallengeNameType enum value
	ChallengeNameTypeAdminNoSrpAuth = "ADMIN_NO_SRP_AUTH"

	// ChallengeNameTypeNewPasswordRequired is a ChallengeNameType enum value
	ChallengeNameTypeNewPasswordRequired = "NEW_PASSWORD_REQUIRED"
)

const (
	// DeliveryMediumTypeSms is a DeliveryMediumType enum value
	DeliveryMediumTypeSms = "SMS"

	// DeliveryMediumTypeEmail is a DeliveryMediumType enum value
	DeliveryMediumTypeEmail = "EMAIL"
)

const (
	// DeviceRememberedStatusTypeRemembered is a DeviceRememberedStatusType enum value
	DeviceRememberedStatusTypeRemembered = "remembered"

	// DeviceRememberedStatusTypeNotRemembered is a DeviceRememberedStatusType enum value
	DeviceRememberedStatusTypeNotRemembered = "not_remembered"
)

const (
	// ExplicitAuthFlowsTypeAdminNoSrpAuth is a ExplicitAuthFlowsType enum value
	ExplicitAuthFlowsTypeAdminNoSrpAuth = "ADMIN_NO_SRP_AUTH"

	// ExplicitAuthFlowsTypeCustomAuthFlowOnly is a ExplicitAuthFlowsType enum value
	ExplicitAuthFlowsTypeCustomAuthFlowOnly = "CUSTOM_AUTH_FLOW_ONLY"
)

const (
	// MessageActionTypeResend is a MessageActionType enum value
	MessageActionTypeResend = "RESEND"

	// MessageActionTypeSuppress is a MessageActionType enum value
	MessageActionTypeSuppress = "SUPPRESS"
)

const (
	// StatusTypeEnabled is a StatusType enum value
	StatusTypeEnabled = "Enabled"

	// StatusTypeDisabled is a StatusType enum value
	StatusTypeDisabled = "Disabled"
)

const (
	// UserImportJobStatusTypeCreated is a UserImportJobStatusType enum value
	UserImportJobStatusTypeCreated = "Created"

	// UserImportJobStatusTypePending is a UserImportJobStatusType enum value
	UserImportJobStatusTypePending = "Pending"

	// UserImportJobStatusTypeInProgress is a UserImportJobStatusType enum value
	UserImportJobStatusTypeInProgress = "InProgress"

	// UserImportJobStatusTypeStopping is a UserImportJobStatusType enum value
	UserImportJobStatusTypeStopping = "Stopping"

	// UserImportJobStatusTypeExpired is a UserImportJobStatusType enum value
	UserImportJobStatusTypeExpired = "Expired"

	// UserImportJobStatusTypeStopped is a UserImportJobStatusType enum value
	UserImportJobStatusTypeStopped = "Stopped"

	// UserImportJobStatusTypeFailed is a UserImportJobStatusType enum value
	UserImportJobStatusTypeFailed = "Failed"

	// UserImportJobStatusTypeSucceeded is a UserImportJobStatusType enum value
	UserImportJobStatusTypeSucceeded = "Succeeded"
)

const (
	// UserPoolMfaTypeOff is a UserPoolMfaType enum value
	UserPoolMfaTypeOff = "OFF"

	// UserPoolMfaTypeOn is a UserPoolMfaType enum value
	UserPoolMfaTypeOn = "ON"

	// UserPoolMfaTypeOptional is a UserPoolMfaType enum value
	UserPoolMfaTypeOptional = "OPTIONAL"
)

const (
	// UserStatusTypeUnconfirmed is a UserStatusType enum value
	UserStatusTypeUnconfirmed = "UNCONFIRMED"

	// UserStatusTypeConfirmed is a UserStatusType enum value
	UserStatusTypeConfirmed = "CONFIRMED"

	// UserStatusTypeArchived is a UserStatusType enum value
	UserStatusTypeArchived = "ARCHIVED"

	// UserStatusTypeCompromised is a UserStatusType enum value
	UserStatusTypeCompromised = "COMPROMISED"

	// UserStatusTypeUnknown is a UserStatusType enum value
	UserStatusTypeUnknown = "UNKNOWN"

	// UserStatusTypeResetRequired is a UserStatusType enum value
	UserStatusTypeResetRequired = "RESET_REQUIRED"

	// UserStatusTypeForceChangePassword is a UserStatusType enum value
	UserStatusTypeForceChangePassword = "FORCE_CHANGE_PASSWORD"
)

const (
	// VerifiedAttributeTypePhoneNumber is a VerifiedAttributeType enum value
	VerifiedAttributeTypePhoneNumber = "phone_number"

	// VerifiedAttributeTypeEmail is a VerifiedAttributeType enum value
	VerifiedAttributeTypeEmail = "email"
)
